# Să punem totul cap la cap[[să-punem-totul-cap-la-cap]]

{#if fw === 'pt'}

<CourseFloatingBanner chapter={2}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter2/section6_pt.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter2/section6_pt.ipynb"},
]} />

{:else}

<CourseFloatingBanner chapter={2}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter2/section6_tf.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter2/section6_tf.ipynb"},
]} />

{/if}

În ultimele secțiuni, ne-am străduit să facem cea mai mare parte a muncii manual. Am explorat modul în care funcționează tokenizatoarele și am analizat tokenizarea, conversia în ID-uri de intrare, padding, trunchiere și măști de atenție.

Cu toate acestea, după cum am văzut în secțiunea 2, API-ul 🤗 Transformers poate gestiona toate acestea pentru noi cu o funcție de nivel înalt în care ne vom adânci aici. Atunci când apelați `tokenizer` direct pe propoziție, primiți înapoi intrări care sunt gata să treacă prin modelul dvs:

```py
from transformers import AutoTokenizer

checkpoint = "distilbert-base-uncased-finetuned-sst-2-english"
tokenizer = AutoTokenizer.from_pretrained(checkpoint)

sequence = "I've been waiting for a HuggingFace course my whole life."

model_inputs = tokenizer(sequence)
```

Aici, variabila `model_inputs` conține tot ceea ce este necesar pentru ca un model să funcționeze bine. Pentru DistilBERT, aceasta include ID-urile de intrare, precum și masca de atenție. Alte modele care acceptă intrări suplimentare le vor avea, de asemenea, la ieșire prin obiectul `tokenizer`.

După cum vom vedea în câteva exemple de mai jos, această metodă este foarte puternică. În primul rând, poate tokeniza o singură secvență:

```py
sequence = "I've been waiting for a HuggingFace course my whole life."

model_inputs = tokenizer(sequence)
```

De asemenea, gestionează mai multe secvențe simultan, fără nicio modificare a API-ului:

```py
sequences = ["I've been waiting for a HuggingFace course my whole life.", "So have I!"]

model_inputs = tokenizer(sequences)
```

Poate aplica padding în funcție de mai multe obiective:

```py
# Va umple secvențele până la lungimea maximă a secvenței
model_inputs = tokenizer(sequences, padding="longest")

# Va umple secvențele până la lungimea maximă a modelului
# (512 pentru BERT sau DistilBERT)
model_inputs = tokenizer(sequences, padding="max_length")

# Va umple secvențele până la lungimea maximă specificată
model_inputs = tokenizer(sequences, padding="max_length", max_length=8)
```

De asemenea, poate trunchia secvențele:

```py
sequences = ["I've been waiting for a HuggingFace course my whole life.", "So have I!"]

# Va trunchia secvențele care sunt mai lungi decât lungimea maximă a modelului
# (512 pentru BERT sau DistilBERT)
model_inputs = tokenizer(sequences, truncation=True)

# Va trunchia secvențele care sunt mai lungi decât lungimea maximă specificată
model_inputs = tokenizer(sequences, max_length=8, truncation=True)
```

Obiectul `tokenizer` poate gestiona conversia în tensori specifici framework-ului, care pot fi apoi trimiși direct la model. De exemplu, în următorul exemplu de cod, solicităm tokenizatorului să returneze tensori din diferite framework-uri - `„pt”` returnează tensori PyTorch, `„tf”` returnează tensori TensorFlow, iar `„np”` returnează matrici NumPy:

```py
sequences = ["I've been waiting for a HuggingFace course my whole life.", "So have I!"]

# Returnează tensori PyTorch
model_inputs = tokenizer(sequences, padding=True, return_tensors="pt")

# Returnează tensori TensorFlow
model_inputs = tokenizer(sequences, padding=True, return_tensors="tf")

# Returnează array-uri NumPy
model_inputs = tokenizer(sequences, padding=True, return_tensors="np")
```

## Token-uri speciale[[token-uri-speciale]]

Dacă aruncăm o privire la ID-urile de intrare returnate de tokenizer, vom vedea că sunt puțin diferite de cele pe care le-am avut mai devreme:

```py
sequence = "I've been waiting for a HuggingFace course my whole life."

model_inputs = tokenizer(sequence)
print(model_inputs["input_ids"])

tokens = tokenizer.tokenize(sequence)
ids = tokenizer.convert_tokens_to_ids(tokens)
print(ids)
```

```python out
[101, 1045, 1005, 2310, 2042, 3403, 2005, 1037, 17662, 12172, 2607, 2026, 2878, 2166, 1012, 102]
[1045, 1005, 2310, 2042, 3403, 2005, 1037, 17662, 12172, 2607, 2026, 2878, 2166, 1012]
```

Un token ID a fost adăugat la început, iar unul la sfârșit. Să decodificăm cele două secvențe de ID-uri de mai sus pentru a vedea despre ce este vorba:

```py
print(tokenizer.decode(model_inputs["input_ids"]))
print(tokenizer.decode(ids))
```

```python out
"[CLS] i've been waiting for a huggingface course my whole life. [SEP]"
"i've been waiting for a huggingface course my whole life."
```

Tokenizatorul a adăugat cuvântul special `[CLS]` la început și cuvântul special `[SEP]` la sfârșit. Acest lucru se datorează faptului că modelul a fost preantrenat cu aceste cuvinte, deci pentru a obține aceleași rezultate pentru inferență trebuie să le adăugăm și pe acestea. Rețineți că unele modele nu adaugă cuvinte speciale sau adaugă cuvinte diferite; de asemenea, modelele pot adăuga aceste cuvinte speciale doar la început sau doar la sfârșit. În orice caz, tokenizatorul știe care sunt cele așteptate și se va ocupa de acest lucru pentru dumneavoastră.

## Încheiere: De la tokenizer la model[[încheiere-de-la-tokenizator-la-model]]

Acum că am văzut toți pașii individuali pe care îi utilizează obiectul `tokenizer` atunci când este aplicat pe texte, să vedem o ultimă dată cum poate gestiona secvențe multiple (padding!), secvențe foarte lungi (trunchiere!) și mai multe tipuri de tensori cu API-ul său principal:

{#if fw === 'pt'}
```py
import torch
from transformers import AutoTokenizer, AutoModelForSequenceClassification

checkpoint = "distilbert-base-uncased-finetuned-sst-2-english"
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = AutoModelForSequenceClassification.from_pretrained(checkpoint)
sequences = ["I've been waiting for a HuggingFace course my whole life.", "So have I!"]

tokens = tokenizer(sequences, padding=True, truncation=True, return_tensors="pt")
output = model(**tokens)
```
{:else}
```py
import tensorflow as tf
from transformers import AutoTokenizer, TFAutoModelForSequenceClassification

checkpoint = "distilbert-base-uncased-finetuned-sst-2-english"
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = TFAutoModelForSequenceClassification.from_pretrained(checkpoint)
sequences = ["I've been waiting for a HuggingFace course my whole life.", "So have I!"]

tokens = tokenizer(sequences, padding=True, truncation=True, return_tensors="tf")
output = model(**tokens)
```
{/if}


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter2/6.mdx" />