# Prelucrarea datelor[[prelucrarea-datelor]]

{#if fw === 'pt'}

<CourseFloatingBanner chapter={3}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter3/section2_pt.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter3/section2_pt.ipynb"},
]} />

{:else}

<CourseFloatingBanner chapter={3}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter3/section2_tf.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter3/section2_tf.ipynb"},
]} />

{/if}

{#if fw === 'pt'}
Continuând cu exemplul din [capitolul anterior](/course/chapter2), iată cum am antrena un clasificator de secvențe pe un batch în PyTorch:

```python
import torch
from transformers import AdamW, AutoTokenizer, AutoModelForSequenceClassification

# La fel ca înainte
checkpoint = "bert-base-uncased"
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = AutoModelForSequenceClassification.from_pretrained(checkpoint)
sequences = [
    "I've been waiting for a HuggingFace course my whole life.",
    "This course is amazing!",
]
batch = tokenizer(sequences, padding=True, truncation=True, return_tensors="pt")

# Ceva nou
batch["labels"] = torch.tensor([1, 1])

optimizer = AdamW(model.parameters())
loss = model(**batch).loss
loss.backward()
optimizer.step()
```
{:else}
Continuând cu exemplul din [capitolul anterior](/course/chapter2), iată cum am antrena un clasificator de secvențe pe un batch în TensorFlow:

```python
import tensorflow as tf
import numpy as np
from transformers import AutoTokenizer, TFAutoModelForSequenceClassification

# La fel ca înainte
checkpoint = "bert-base-uncased"
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = TFAutoModelForSequenceClassification.from_pretrained(checkpoint)
sequences = [
    "I've been waiting for a HuggingFace course my whole life.",
    "This course is amazing!",
]
batch = dict(tokenizer(sequences, padding=True, truncation=True, return_tensors="tf"))

# Ceva nou
model.compile(optimizer="adam", loss="sparse_categorical_crossentropy")
labels = tf.convert_to_tensor([1, 1])
model.train_on_batch(batch, labels)
```
{/if}

Desigur, doar antrenarea modelului pe două propoziții nu va da rezultate foarte bune. Pentru a obține rezultate mai bune, va trebui să pregătiți un set de date mai mare.

În această secțiune vom folosi ca exemplu setul de date MRPC (Microsoft Research Paraphrase Corpus), introdus într-o [lucrare](https://www.aclweb.org/anthology/I05-5002.pdf) de William B. Dolan și Chris Brockett. Setul de date este format din 5 801 perechi de propoziții, cu o etichetă care indică dacă acestea sunt parafrazări sau nu (adică, dacă ambele propoziții înseamnă același lucru). L-am selectat pentru acest capitol deoarece este un set de date mic, astfel încât este ușor de experimentat cu formarea pe acesta.

### Încărcarea unui set de date din Hub[[încărcarea-unui-set-de-date-din-Hub]]

{#if fw === 'pt'}
<Youtube id="_BZearw7f0w"/>
{:else}
<Youtube id="W_gMJF0xomE"/>
{/if}

Hub-ul nu conține doar modele, ci și multe seturi de date în limbi diferite. Puteți naviga printre seturile de date [aici](https://huggingface.co/datasets) și vă recomandăm să încercați să încărcați și să procesați un nou set de date după ce ați parcurs această secțiune (consultați documentația generală [aici](https://huggingface.co/docs/datasets/loading)). Dar, pentru moment, să ne concentrăm asupra setului de date MRPC! Acesta este unul dintre cele 10 seturi de date care compun [GLUE benchmark](https://gluebenchmark.com/), care este un benchmark academic utilizat pentru a măsura performanța modelelor ML în 10 sarcini diferite de clasificare a textului.

Biblioteca 🤗 Datasets oferă o comandă foarte simplă pentru a descărca și stoca în cache un set de date pe Hub. Putem descărca setul de date MRPC astfel:

<Tip>
⚠️ **Atenție** Asigurați-vă că `datasets` este instalat prin rularea `pip install datasets`. Apoi, încărcați setul de date MRPC și tipăriți-l pentru a vedea ce conține.
</Tip> 

```py
from datasets import load_dataset

raw_datasets = load_dataset("glue", "mrpc")
raw_datasets
```

```python out
DatasetDict({
    train: Dataset({
        features: ['sentence1', 'sentence2', 'label', 'idx'],
        num_rows: 3668
    })
    validation: Dataset({
        features: ['sentence1', 'sentence2', 'label', 'idx'],
        num_rows: 408
    })
    test: Dataset({
        features: ['sentence1', 'sentence2', 'label', 'idx'],
        num_rows: 1725
    })
})
```

După cum puteți vedea, obținem un obiect `DatasetDict` care conține setul de instruire, setul de validare și setul de testare. Fiecare dintre acestea conține mai multe coloane (`sentence1`, `sentence2`, `label` și `idx`) și un număr de rânduri variabil, care reprezintă numărul de elemente din fiecare set (astfel, există 3.668 de perechi de propoziții în setul de instruire, 408 în setul de validare și 1.725 în setul de testare).

Această comandă descarcă și pune în cache setul de date, implicit în *~/.cache/huggingface/datasets*. Reamintim din capitolul 2 că puteți personaliza folderul cache prin setarea variabilei de mediu `HF_HOME`.

Putem accesa fiecare pereche de propoziții din obiectul nostru `raw_datasets` prin indexare, ca într-un dicționar:

```py
raw_train_dataset = raw_datasets["train"]
raw_train_dataset[0]
```

```python out
{'idx': 0,
 'label': 1,
 'sentence1': 'Amrozi accused his brother , whom he called " the witness " , of deliberately distorting his evidence .',
 'sentence2': 'Referring to him as only " the witness " , Amrozi accused his brother of deliberately distorting his evidence .'}
```

Putem vedea că etichetele sunt deja numere întregi, deci nu va trebui să efectuăm nicio prelucrare prealabilă. Pentru a ști ce număr întreg corespunde fiecărei etichete, putem inspecta `features` din `raw_train_dataset`. Acest lucru ne va indica tipul fiecărei coloane:

```py
raw_train_dataset.features
```

```python out
{'sentence1': Value(dtype='string', id=None),
 'sentence2': Value(dtype='string', id=None),
 'label': ClassLabel(num_classes=2, names=['not_equivalent', 'equivalent'], names_file=None, id=None),
 'idx': Value(dtype='int32', id=None)}
```

În culise, `label` este de tipul `ClassLabel`, iar maparea numerelor întregi și numele etichetei este stocată în folderul *names*. `0` corespunde la `not_equivalent`, iar `1` corespunde la `equivalent`.

<Tip>

✏️ **Încercați!** Uitați-vă la elementul 15 din setul de antrenament și la elementul 87 din setul de validare. Care sunt etichetele lor?

</Tip>

### Preprocesarea unui set de date[[preprocesarea-unui-set-de-date]]

{#if fw === 'pt'}
<Youtube id="0u3ioSwev3s"/>
{:else}
<Youtube id="P-rZWqcB6CE"/>
{/if}

Pentru a preprocesa setul de date, trebuie să convertim textul în numere pe care modelul le înțelege. După cum ați văzut în [capitolul anterior](/course/chapter2), acest lucru se face cu ajutorul unui tokenizer. Putem furniza tokenizatorului o propoziție sau o listă de propoziții, astfel încât putem tokeniza direct primele propoziții și toate propozițiile secundare din fiecare pereche, astfel:

```py
from transformers import AutoTokenizer

checkpoint = "bert-base-uncased"
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
tokenized_sentences_1 = tokenizer(raw_datasets["train"]["sentence1"])
tokenized_sentences_2 = tokenizer(raw_datasets["train"]["sentence2"])
```

Cu toate acestea, nu putem pur și simplu să transmitem două secvențe modelului și să obținem o predicție care să indice dacă cele două propoziții sunt parafraze sau nu. Trebuie să tratăm cele două secvențe ca pe o pereche și să aplicăm preprocesarea corespunzătoare. Din fericire, tokenizatorul poate, de asemenea, să ia o pereche de secvențe și să le pregătească în modul în care se așteaptă modelul nostru BERT: 

```py
inputs = tokenizer("This is the first sentence.", "This is the second one.")
inputs
```

```python out
{ 
  'input_ids': [101, 2023, 2003, 1996, 2034, 6251, 1012, 102, 2023, 2003, 1996, 2117, 2028, 1012, 102],
  'token_type_ids': [0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1],
  'attention_mask': [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
}
```

Am discutat despre cheile `input_ids` și `attention_mask` în [Capitolul 2](/course/chapter2), dar am amânat discuția despre `token_type_ids`. În acest exemplu, aceasta este ceea ce îi spune modelului care parte a intrării este prima propoziție și care este a doua propoziție.

<Tip>

✏️ **Încercați!** Luați elementul 15 din setul de antrenament și tokenizați cele două propoziții separat apoi ca pe o pereche. Care este diferența dintre cele două rezultate?

</Tip>

Dacă decodificăm ID-urile din `input_ids` înapoi în cuvinte:

```py
tokenizer.convert_ids_to_tokens(inputs["input_ids"])
```

Vom obține:

```python out
['[CLS]', 'this', 'is', 'the', 'first', 'sentence', '.', '[SEP]', 'this', 'is', 'the', 'second', 'one', '.', '[SEP]']
```

Astfel, modelul se așteaptă ca intrările să fie de forma `[CLS] sentence1 [SEP] sentence2 [SEP]` atunci când există două propoziții. Alinierea acestui lucru cu `token_type_ids` ne dă:

```python out
['[CLS]', 'this', 'is', 'the', 'first', 'sentence', '.', '[SEP]', 'this', 'is', 'the', 'second', 'one', '.', '[SEP]']
[      0,      0,    0,     0,       0,          0,   0,       0,      1,    1,     1,        1,     1,   1,       1]
```

După cum puteți vedea, părțile de intrare corespunzătoare `[CLS] sentence1 [SEP]` au toate un ID de tip token de `0`, în timp ce celelalte părți, corespunzătoare `sentence2 [SEP]`, au toate un ID de tip token de `1`.

Rețineți că, dacă selectați un checkpoint diferit, nu veți avea neapărat `token_type_ids` în intrările dvs. tokenizate (de exemplu, acestea nu sunt returnate dacă utilizați un model DistilBERT). Acestea sunt returnate numai atunci când modelul va ști ce să facă cu ele, deoarece le-a văzut în timpul preinstruirii sale. 

Aici, BERT este preinstruit cu ID-uri de tip token și, pe lângă obiectivul de modelare a limbajului mascat despre care am vorbit în [[Chapter 1]](/course/chapter1), are un obiectiv suplimentar numit _next sentence prediction_. Obiectivul acestei sarcini este de a modela relația dintre perechile de propoziții.

În cazul predicției propoziției următoare, modelul primește perechi de propoziții (cu token-uri mascate aleatoriu) și i se cere să prezică dacă a doua propoziție o urmează pe prima. Pentru ca sarcina să nu fie complicată, jumătate din timp propozițiile se succed reciproc în documentul original din care au fost extrase, iar cealaltă jumătate din timp cele două propoziții provin din două documente diferite. 

În general, nu trebuie să vă faceți griji dacă există sau nu `token_type_ids` în intrările dvs. tokenizate: atâta timp cât utilizați același checkpoint pentru tokenizator și model, totul va fi bine, deoarece tokenizatorul știe ce să furnizeze modelului său.

Acum că am văzut cum tokenizatorul nostru poate trata o pereche de propoziții, îl putem folosi pentru a tokeniza întregul nostru set de date: la fel ca în [previous chapter](/course/chapter2), putem furniza tokenizatorului o listă de perechi de propoziții oferindu-i lista primelor propoziții, apoi lista celor de-a doua propoziții. Acest lucru este, de asemenea, compatibil cu opțiunile de padding și trunchiere pe care le-am văzut în [Chapter 2](/course/chapter2). Așadar, o modalitate de preprocesare a setului de date de instruire este:

```py
tokenized_dataset = tokenizer(
    raw_datasets["train"]["sentence1"],
    raw_datasets["train"]["sentence2"],
    padding=True,
    truncation=True,
)
```

Această metodă funcționează corespunzător, dar are dezavantajul de a returna un dicționar (cu cheile noastre, `input_ids`, `attention_mask` și `token_type_ids`, și valori care sunt liste ale listelor). De asemenea, va funcționa numai dacă aveți suficientă memorie RAM pentru a stoca întregul set de date în timpul tokenizării (în timp ce seturile de date din biblioteca 🤗 Datasets sunt fișiere [Apache Arrow](https://arrow.apache.org/) stocate pe disc, deci păstrați încărcate în memorie numai eșantioanele pe care le solicitați).

Pentru a păstra informațiile sub forma unui set de date, vom utiliza metoda [`Dataset.map()`](https://huggingface.co/docs/datasets/package_reference/main_classes#datasets.Dataset.map). Acest lucru ne permite, de asemenea, o flexibilitate sporită, în cazul în care avem nevoie de mai multe preprocesări decât simpla tokenizare. Metoda `map()` funcționează prin aplicarea unei funcții pe fiecare element al setului de date, deci să definim o funcție care să tokenizeze intrările noastre:

```py
def tokenize_function(example):
    return tokenizer(example["sentence1"], example["sentence2"], truncation=True)
```

Această funcție acceptă un dicționar (precum elementele din setul nostru de date) și returnează un nou dicționar cu cheile `input_ids`, `attention_mask` și `token_type_ids`. Rețineți că funcționează și în cazul în care dicționarul `example` conține mai multe eșantioane (fiecare cheie fiind o listă de propoziții), deoarece `tokenizer` funcționează pe liste de perechi de propoziții, așa cum am văzut anterior. Acest lucru ne va permite să folosim opțiunea `batched=True` în apelul nostru la `map`, ceea ce va accelera foarte mult tokenizarea. `tokenizer` este susținut de un tokenizer scris în Rust din biblioteca [🤗 Tokenizers](https://github.com/huggingface/tokenizers). Acest tokenizator poate fi foarte rapid, dar numai dacă îi oferim o mulțime de intrări deodată.

Rețineți că am omis deocamdată argumentul `padding` în funcția noastră de tokenizare. Acest lucru se datorează faptului că umplerea tuturor eșantioanelor la lungimea maximă nu este eficientă: este mai bine să umplem eșantioanele atunci când construim un batch, deoarece atunci trebuie să umplem doar la lungimea maximă din acel batch, și nu la lungimea maximă din întregul set de date. Acest lucru poate economisi mult timp și putere de procesare atunci când intrările au lungimi variate! 

Iată cum aplicăm funcția de tokenizare la toate seturile noastre de date simultan. Utilizăm `batched=True` în apelul către `map`, astfel încât funcția să fie aplicată la mai multe elemente ale setului nostru de date simultan, și nu la fiecare element în parte. Acest lucru permite o preprocesare mai rapidă.

```py
tokenized_datasets = raw_datasets.map(tokenize_function, batched=True)
tokenized_datasets
```

Modul în care biblioteca 🤗 Datasets aplică această procesare este prin adăugarea de noi câmpuri la seturile de date, câte unul pentru fiecare cheie din dicționarul returnat de funcția de preprocesare:

```python out
DatasetDict({
    train: Dataset({
        features: ['attention_mask', 'idx', 'input_ids', 'label', 'sentence1', 'sentence2', 'token_type_ids'],
        num_rows: 3668
    })
    validation: Dataset({
        features: ['attention_mask', 'idx', 'input_ids', 'label', 'sentence1', 'sentence2', 'token_type_ids'],
        num_rows: 408
    })
    test: Dataset({
        features: ['attention_mask', 'idx', 'input_ids', 'label', 'sentence1', 'sentence2', 'token_type_ids'],
        num_rows: 1725
    })
})
```

Puteți utiliza chiar și multiprocesarea atunci când aplicați funcția de preprocesare cu `map()` prin transmiterea unui argument `num_proc`. Nu am făcut acest lucru aici deoarece biblioteca 🤗 Tokenizers utilizează deja mai multe fire pentru a tokeniza mai rapid eșantioanele noastre, dar dacă nu utilizați un tokenizator rapid susținut de această bibliotecă, acest lucru v-ar putea accelera preprocesarea.

Funcția noastră `tokenize_function` returnează un dicționar cu cheile `input_ids`, `attention_mask` și `token_type_ids`, astfel încât aceste trei câmpuri sunt adăugate la toate diviziunile setului nostru de date. Rețineți că am fi putut, de asemenea, să modificăm câmpurile existente dacă funcția noastră de preprocesare a returnat o nouă valoare pentru o cheie existentă în setul de date căruia i-am aplicat funcția `map()`.

Ultimul lucru pe care va trebui să îl facem este să umplem toate exemplele la lungimea celui mai lung element atunci când grupăm elementele împreună - o tehnică la care ne referim ca *umplere dinamică*.

### Umplere dinamică[[umplere-dinamică]]

<Youtube id="7q5NyFT8REg"/>

{#if fw === 'pt'}
Funcția care este responsabilă de combinarea eșantioanelor în cadrul unui batch se numește *funcție de colaționare*. Este un argument pe care îl puteți trece atunci când construiți un `DataLoader`, implicit fiind o funcție care va converti eșantioanele în tensori PyTorch și le va concatena (recursiv dacă elementele dvs. sunt liste, tupluri sau dicționare). În cazul nostru, va fi de asemenea să aplicați umplutură pentru a avea toate intrările de aceeași lungime. Clasa `DataCollatorWithPadding` face exact acest lucru (și un pic mai mult, după cum am văzut anterior). Ia un tokenizer atunci când este instanțiat (pentru a știi ce token de completare să folosească și dacă modelul se așteaptă la padding în stânga sau în dreapta) și va face tot ce aveți nevoie. Umplerea dinamică poate fi aplicată în funcție de necesități la fiecare batch și pentru a evita să avem intrări prea lungi cu o mulțime de umpluturi. Acest lucru va accelera antrenamentul destul de mult, dar rețineți că, dacă vă antrenați pe o TPU, acest lucru poate cauza probleme - TPU-urile preferă forme fixe, chiar și atunci când ar putea necesita padding suplimentar.

{:else}

Funcția care este responsabilă de reunirea eșantioanelor în cadrul unui batch se numește *funcție de colaționare*. Funcția de colaționare implicită este o funcție care va converti eșantioanele în tf.Tensor și le va concatena (recursiv dacă elementele dvs. sunt liste, tuples sau dicționare). În cazul nostru, va fi de asemenea să aplicați umplutură pentru a avea toate intrările de aceeași lungime. Clasa `DataCollatorWithPadding` face exact acest lucru (și un pic mai mult, după cum am văzut anterior). Ia un tokenizer atunci când este instanțiat (pentru a știi ce token de completare să folosească și dacă modelul se așteaptă la padding în stânga sau în dreapta) și va face tot ce aveți nevoie. Umplerea dinamică poate fi aplicată în funcție de necesități la fiecare batch și pentru a evita să avem intrări prea lungi cu o mulțime de umpluturi. Acest lucru va accelera antrenamentul destul de mult, dar rețineți că, dacă vă antrenați pe o TPU, acest lucru poate cauza probleme - TPU-urile preferă forme fixe, chiar și atunci când ar putea necesita padding suplimentar.

{/if}

Pentru a face acest lucru în practică, trebuie să definim o funcție de colaționare care va aplica cantitatea corectă de umplutură elementelor din setul de date pe care dorim să le grupăm. Din fericire, biblioteca 🤗 Transformers ne oferă o astfel de funcție prin `DataCollatorWithPadding`. Aceasta preia un tokenizer atunci când o instanțiați (pentru a știi ce token de umplutură să utilizați și dacă modelul se așteaptă ca umplutura să fie la stânga sau la dreapta intrărilor) și va face tot ceea ce aveți nevoie:

{#if fw === 'pt'}
```py
from transformers import DataCollatorWithPadding

data_collator = DataCollatorWithPadding(tokenizer=tokenizer)
```
{:else}
```py
from transformers import DataCollatorWithPadding

data_collator = DataCollatorWithPadding(tokenizer=tokenizer, return_tensors="tf")
```
{/if}

Pentru a testa această nouă opțiune, să luăm câteva eșantioane din setul nostru de formare pe care dorim să le grupăm. Aici, eliminăm coloanele `idx`, `sentence1` și `sentence2` deoarece nu vor fi necesare și conțin șiruri de caractere (și nu putem crea tensori cu șiruri de caractere) și aruncăm o privire la lungimile fiecărei intrări din batch:

```py
samples = tokenized_datasets["train"][:8]
samples = {k: v for k, v in samples.items() if k not in ["idx", "sentence1", "sentence2"]}
[len(x) for x in samples["input_ids"]]
```

```python out
[50, 59, 47, 67, 59, 50, 62, 32]
```

Nici o surpriză, obținem eșantioane de diferite lungimi, de la 32 la 67. Umplerea dinamică înseamnă că toate eșantioanele din acest batch ar trebui să fie umplute la o lungime de 67, lungimea maximă din cadrul batch-ului. Fără umplutură dinamică, toate eșantioanele ar trebui să fie umplute la lungimea maximă din întregul set de date sau la lungimea maximă pe care modelul o poate accepta. Să verificăm de două ori dacă `data_collator` completează dinamic batch-ul în mod corespunzător:

```py
batch = data_collator(samples)
{k: v.shape for k, v in batch.items()}
```

{#if fw === 'tf'}

```python out
{'attention_mask': TensorShape([8, 67]),
 'input_ids': TensorShape([8, 67]),
 'token_type_ids': TensorShape([8, 67]),
 'labels': TensorShape([8])}
```

{:else}

```python out
{'attention_mask': torch.Size([8, 67]),
 'input_ids': torch.Size([8, 67]),
 'token_type_ids': torch.Size([8, 67]),
 'labels': torch.Size([8])}
```

Perfect! Acum că am trecut de la text brut la batch-uri cu care modelul nostru se poate descurca, suntem gata să îl ajustăm!

{/if}

<Tip>

✏️ **Încearcați!** Replicați preprocesarea pe setul de date GLUE SST-2. Acesta este puțin diferit, deoarece este compus din propoziții simple în loc de perechi, dar restul lucrurilor pe care le-am făcut ar trebui să fie la fel. Pentru o provocare mai dificilă, încercați să scrieți o funcție de preprocesare care să funcționeze pe oricare dintre sarcinile GLUE.

</Tip>

{#if fw === 'tf'}

Acum că avem setul nostru de date și un compilator de date, trebuie să le punem împreună. Am putea încărca manual batch-uri și să le asamblăm, dar este mult de lucru și probabil nici nu este foarte eficient. În schimb, există o metodă simplă care oferă o soluție performantă la această problemă: `to_tf_dataset()`. Aceasta va împacheta un `tf.data.Dataset` cu funcția de colaționare încorporată. Dacă utilizați `DataCollatorWithPadding`, acest lucru nu va fi o problemă deoarece ea funcționează cu dicționare, liste și tensori NumPy, precum și cu tensori TensorFlow!

```py
tf_train_dataset = tokenized_datasets["train"].to_tf_dataset(
    columns=["attention_mask", "input_ids", "token_type_ids"],
    label_cols=["labels"],
    shuffle=True,
    collate_fn=data_collator,
    batch_size=8,
)

tf_validation_dataset = tokenized_datasets["validation"].to_tf_dataset(
    columns=["attention_mask", "input_ids", "token_type_ids"],
    label_cols=["labels"],
    shuffle=False,
    collate_fn=data_collator,
    batch_size=8,
)
```

Și asta este tot! Putem folosi aceste seturi de date în cursul următor, unde instruirea va fi extrem de simplă după toată munca grea de preprocesare a datelor.

{/if}


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter3/2.mdx" />