# Utilizarea modelelor preantrenate[[using-pretrained-models]]

{#if fw === 'pt'}
 
<CourseFloatingBanner chapter={4}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter4/section2_pt.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter4/section2_pt.ipynb"},
]} />

{:else}

<CourseFloatingBanner chapter={4}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter4/section2_tf.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter4/section2_tf.ipynb"},
]} />

{/if}

Hubul Model oferă o modalitate simplă de a selecta modelul adecvat, astfel încât utilizarea sa în orice bibliotecă downstream poate fi efectuată în câteva linii de cod. Să vedem cum se utilizează efectiv unul dintre aceste modele și cum putem contribui înapoi la comunitate.


Să presupunem că noi căutăm un French-based model ce poate face mask filling.

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/camembert.gif" alt="Selecting the Camembert model." width="80%"/>
</div>

Alegem checkpointul „camembert-base” pentru al încerca. Identificatorul `camembert-base` este tot de ce avem nevoie pentru a începe. În capitolele precedente, am văzut cum putem inițializa modelul folosind funcția `pipeline()`:

```py
from transformers import pipeline

camembert_fill_mask = pipeline("fill-mask", model="camembert-base")
results = camembert_fill_mask("Le camembert est <mask> :)")
```

```python out
[
  {'sequence': 'Le camembert est délicieux :)', 'score': 0.49091005325317383, 'token': 7200, 'token_str': 'délicieux'}, 
  {'sequence': 'Le camembert est excellent :)', 'score': 0.1055697426199913, 'token': 2183, 'token_str': 'excellent'}, 
  {'sequence': 'Le camembert est succulent :)', 'score': 0.03453313186764717, 'token': 26202, 'token_str': 'succulent'}, 
  {'sequence': 'Le camembert est meilleur :)', 'score': 0.0330314114689827, 'token': 528, 'token_str': 'meilleur'}, 
  {'sequence': 'Le camembert est parfait :)', 'score': 0.03007650189101696, 'token': 1654, 'token_str': 'parfait'}
]
```

În mod evident, încărcarea unui model într-un pipeline este extrem de simplu. Singurul lucru la care trebuie să atrageți atenția este că checkpointul ales este adecvat pentru sarcina pe care urmează să o execute. De exemplu, în momentul în care încărăm checkpoint-ul „camembert-base” în pipelineul `fill-mask`, este perfect în regulă. Dar dacă îl încărcam în pipelineul `text-classification`, rezultatele nu vor avea nici o logică, pentru că headul „camembert-base” nu este adecvat pentru această sarcină! Recomandăm utilizarea task selectorului în interfața Hugging Face în scopul selectării checkpointurilor adecvate:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/tasks.png" alt="Selectorul de sarcini pe interfața web." width="80%"/>
</div>

Puteți inițializa checkpointul în mod direct folosind arhitectura modelului:

{#if fw === 'pt'}
```py
from transformers import CamembertTokenizer, CamembertForMaskedLM

tokenizer = CamembertTokenizer.from_pretrained("camembert-base")
model = CamembertForMaskedLM.from_pretrained("camembert-base")
```

Însă, recomandăm utilizarea [claselor `Auto*`](https://huggingface.co/transformers/model_doc/auto?highlight=auto#auto-classes), deoarece acestea sunt proiectate să fie architecture-agnostic. În timp ce codul precedent limita utilizatorii la checkpoints loadable în CamemBERT architecture, utilizarea claselor `Auto*` face schimbarea checkpointurilor simplă:

```py
from transformers import AutoTokenizer, AutoModelForMaskedLM

tokenizer = AutoTokenizer.from_pretrained("camembert-base")
model = AutoModelForMaskedLM.from_pretrained("camembert-base")
```
{:else}
```py
from transformers import CamembertTokenizer, TFCamembertForMaskedLM

tokenizer = CamembertTokenizer.from_pretrained("camembert-base")
model = TFCamembertForMaskedLM.from_pretrained("camembert-base")
```

Însă, recomandăm utilizarea [claselor `TFAuto*`](https://huggingface.co/transformers/model_doc/auto?highlight=auto#auto-classes), deoarece acestea sunt proiectate să fie architecture-agnostic. În timp ce codul precedent limita utilizatorii la checkpoints loadable în CamemBERT architecture, utilizarea claselor `TFAuto*` face schimbarea checkpointurilor simplă:

```py
from transformers import AutoTokenizer, TFAutoModelForMaskedLM

tokenizer = AutoTokenizer.from_pretrained("camembert-base")
model = TFAutoModelForMaskedLM.from_pretrained("camembert-base")
```
{/if}

<Tip>
În momentul în care folosiți un model preantrenat, asigurați-vă să verificați cum a fost antrenat și pe ce date se bazează. De asemenea, trebuie să cunoasceți limitele și prejudecățile sale. Toată această informație va fi indicată pe cartea modelului.
</Tip>



<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter4/2.mdx" />