# Înțelegerea LLM-urilor[[mastering-llms]]

<CourseFloatingBanner
    chapter={7}
    classNames="absolute z-10 right-0 top-0"
/>

Dacă ați ajuns până aici în curs, felicitări – acum aveți toate cunoștințele și instrumentele necesare pentru a aborda (aproape) orice sarcină de procesare a limbajului cu 🤗 Transformers și ecosistemul Hugging Face!

## De la NLP la LLM-uri

Deși am acoperit multe sarcini tradiționale de NLP în acest curs, domeniul a fost revoluționat de Modelele Mari de Limbaj (LLM-uri). Aceste modele au extins dramatic ceea ce este posibil în procesarea limbajului:

- Pot gestiona mai multe sarcini fără fine-tuning specific pentru fiecare sarcină
- Excelează la urmarea instrucțiunilor și adaptarea la contexte diferite
- Pot genera text coerent și adecvat contextului pentru diverse aplicații
- Pot realiza raționamente și rezolva probleme complexe prin tehnici precum chain-of-thought prompting

Abilitățile fundamentale de NLP pe care le-ați învățat sunt în continuare esențiale pentru a lucra eficient cu LLM-urile. Înțelegerea tokenizării, a arhitecturilor de modele, a metodelor de fine-tuning și a metricilor de evaluare vă oferă cunoștințele necesare pentru a valorifica la maximum potențialul LLM-urilor.

Am văzut o mulțime de data collators, așa că am făcut acest mic videoclip pentru a vă ajuta să găsiți cel pe care să îl utilizați pentru fiecare sarcină:

<Youtube id="-RPeakdlHYo"/>

După finalizarea acestui tur fulger prin sarcinile de bază ale procesării limbajului, ar trebui să:

* Știți care arhitecturi (encoder, decoder sau encoder-decoder) sunt cele mai potrivite pentru fiecare sarcină
* Înțelegeți diferența dintre preantrenarea și fine-tuning-ul unui model lingvistic
* Știți cum să antrenați modele Transformer folosind fie API-ul `Trainer` și funcționalitățile de antrenare distribuită ale 🤗 Accelerate, fie TensorFlow și Keras, în funcție de traseul pe care l-ați urmat
* Înțelegeți semnificația și limitele metricilor precum ROUGE și BLEU pentru sarcinile de generare de text
* Știți cum să interacționați cu modelele voastre ajustate, atât pe Hub, cât și folosind `pipeline` din 🤗 Transformers
* Să apreciați modul în care LLM-urile se bazează pe și extind tehnicile tradiționale de NLP

În ciuda tuturor acestor cunoștințe, va veni un moment în care fie veți întâlni un bug dificil în codul vostru, fie veți avea o întrebare despre cum să rezolvați o anumită problemă de procesare a limbajului. Din fericire, comunitatea Hugging Face este aici pentru a vă ajuta! În ultimul capitol al acestei părți a cursului, vom explora cum puteți depana modelele Transformer și cum puteți solicita ajutor în mod eficient.

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter7/8.mdx" />