# Quiz de sfârșit de capitol[[end-of-chapter-quiz]]

<CourseFloatingBanner
    chapter={7}
    classNames="absolute z-10 right-0 top-0"
/>

Să testăm ce ați învățat în acest capitol!

### 1. Care dintre următoarele sarcini pot fi încadrate ca o problemă de clasificare a tokenilor?

<Question
	choices={[
		{
			text: "Găsirea componentelor gramaticale ale unei propoziții.",
			explain: "Corect! Apoi putem eticheta fiecare cuvânt ca substantiv, verb etc.",
			correct: true
		},
		{
			text: "Verificarea dacă o propoziție este corectă gramatical sau nu.",
			explain: "Nu, aceasta este o problemă de clasificare a secvențelor."
		},
		{
			text: "Găsirea persoanelor menționate într-o propoziție.",
			explain: "Corect! Putem eticheta fiecare cuvânt ca persoană sau nu ca o persoană.",
            correct: true
		},
        {
			text: "Găsirea grupul de cuvinte dintr-o propoziție care răspunde la o întrebare.",
			explain: "Nu, aceasta ar fi o problemă de răspundere a unei întrebări."
		}
	]}
/>

### 2. Ce parte a preprocesării pentru clasificarea tokenilor diferă de celelalte pipelineuri de preprocesare?

<Question
	choices={[
		{
			text: "Nu este nevoie să faceți nimic; textele sunt deja tokenizate.",
			explain: "Textele sunt într-adevăr date ca cuvinte separate, dar tot trebuie să aplicăm modelul de tokenizare a sub-cuvintelor."
		},
		{
			text: "Textele sunt date sub formă de cuvinte, astfel încât trebuie să aplicăm doar tokenizarea sub-cuvintelor.",
			explain: "Corect! Acest lucru este diferit de preprocesarea obișnuită, în care trebuie să aplicăm întregul proces de tokenizare. Vă puteți gândi la o altă diferență?",
			correct: true
		},
		{
			text: "Folosim <code>-100</code> pentru a eticheta tokenii speciali.",
			explain: "Acest lucru nu este specific clasificării tokenilor - folosim întotdeauna <code>-100</code> ca label pentru tokenii pe care dorim să îi ignorăm în pierdere."
		},
		{
			text: "Trebuie să ne asigurăm că labelurile sunt trunchiate sau padded la aceeași dimensiune ca și inputurile, atunci când aplicăm trunchierea/paddingul.",
			explain: "Într-adevăr! Totuși, aceasta nu este singura diferență.",
			correct: true
		}
	]}
/>

### 3. Ce problemă apare atunci când tokenizăm cuvintele într-o problemă de clasificare a tokenilor și dorim să etichetăm tokenii?

<Question
	choices={[
		{
			text: "Tokenizerul adaugă tokeni speciali și nu avem labeluri pentru ele.",
			explain: "Le etichetăm pe acestea cu <code>-100</code>, astfel încât acestea să fie ignorate în pierdere."
		},
		{
			text: "Fiecare cuvânt poate produce mai mulți tokeni, astfel încât ajungem să avem mai multe tokeni decât labeluri.",
			explain: "Aceasta este problema principală, iar noi trebuie să aliniem labelurile originale cu tokenii.",
			correct: true
		},
		{
			text: "Tokenii adăugați nu au etichete, deci nu există nicio problemă.",
			explain: "Incorect; avem nevoie de atâtea etichete câți tokeni avem, altfel modelele noastre vor da erori."
		}
	]}
/>

### 4. Ce înseamnă "domain adaptation"??

<Question
	choices={[
		{
			text: "Este atunci când rulăm un model pe un dataset și obținem predicțiile pentru fiecare sample din acel dataset.",
			explain: "Nu, aceasta este doar o inferență."
		},
		{
			text: "Este atunci când antrenăm un model pe un dataset.",
			explain: "Nu, acesta este antrenarea unui model; nu există nicio adaptare aici."
		},
		{
			text: "Este atunci când facem fine-tune unui model preantrenat pe un nou dataset, iar acesta oferă predicții care sunt mai bine adaptate la datasetul respectiv",
			explain: "Corect! Modelul și-a adaptat cunoștințele la noul dataset.",
            correct: true
		},
        {
			text: "Este atunci când adăugăm sampleuri neclasificate la un dataset pentru a face modelul nostru mai robust.",
			explain: "Cu siguranță este ceva ce ar trebui să faceți dacă vă reantrenați modelul în mod regulat, dar nu este o adaptare la domeniu."
		}
	]}
/>

### 5. Ce sunt labelurile într-o problemă de modelare a limbajului mascat?

<Question
	choices={[
		{
			text: "Unii dintre tokenii din propoziția de intrare sunt mascate aleatoriu, iar labelurile sunt tokenii de input originali.",
			explain: "Corect!",
            correct: true
		},
		{
			text: "Unii dintre tokenii din propoziția de intrare sunt mascate aleatoriu, iar labelurile sunt tokenii de input originali, deplasate spre stânga.",
			explain: "Nu, deplasarea labelurilor spre stânga corespunde prezicerii următorului cuvânt, ceea ce este modelarea cauzală a limbajului."
		},
		{
			text: "Unele dintre tokenii din propoziția de intrare sunt mascate aleatoriu, iar labelul este dacă propoziția este pozitivă sau negativă.",
			explain: "Aceasta este o problemă de clasificare a secvențelor cu o anumită creștere a datelor, nu de modelare a limbajului mascat."
		},
        {
			text: "Unii dintre tokenii din cele două propoziții de intrare sunt mascate aleatoriu, iar labelul este dacă cele două propoziții sunt similare sau nu.",
			explain: "Aceasta este o problemă de clasificare a secvențelor cu o anumită creștere a datelor, nu de modelare a limbajului mascat."
		}
	]}
/>

### 6. Care dintre aceste sarcini poate fi văzută ca o problemă de sequence-to-sequence?

<Question
	choices={[
		{
			text: "Scrierea de recenzii scurte ale documentelor lungi",
			explain: "Da, aceasta este o problemă de sumarizare. Încercați un alt răspuns!",
            correct: true
		},
		{
			text: "Răspunderea întrebărilor despre un document",
			explain: "Acest lucru poate fi încadrat ca o problemă de sequence-to-sequence. Totuși, acesta nu este singurul răspuns corect.",
            correct: true
		},
		{
			text: "Traducerea unui text din chineză în engleză",
			explain: "Aceasta este cu siguranță o problemă de sequence-to-sequence. Mai puteți găsi alta?",
            correct: true
		},
        {
			text: "Corectarea mesajelor trimise de nepotul/prietenul meu pentru ca acestea să fie în limba engleză, scrise gramatical",
			explain: "Aceasta este un fel de problemă de traducere, deci cu siguranță o sarcină de la sequence-to-sequence. Totuși, acesta nu este singurul răspuns corect!",
			correct: true
		}
	]}
/>

### 7. Care este modalitatea corectă de preprocesare a datelor pentru o problemă de sequence-to-sequence?

<Question
	choices={[
		{
			text: "Inputurile și targeturile trebuie trimise împreună la tokenizer cu <code>inputs=...</code> și <code>targets=...</code>.",
			explain: "Acesta ar putea fi un API pe care îl vom adăuga în viitor, dar nu este disponibil acum."
		},
		{
			text: "Inputurile și targeturile trebuie preprocesate, în două apeluri separate către tokenizer.",
			explain: "Acest lucru este adevărat, dar incomplet. Trebuie să faceți ceva pentru a vă asigura că tokenizerul le procesează pe ambele în mod corespunzător."
		},
		{
			text: "Ca de obicei, trebuie doar să tokenizăm inputurile.",
			explain: "Nu într-o problemă de clasificare a secvențelor; targeturile sunt de asemenea texte pe care trebuie să le convertim în numere!"
		},
        {
			text: "Inputurile trebuie să fie trimise către tokenizer, la fel și targeturile, dar în cadrul unui manager de context special.",
			explain: "Corect, tokenizerul trebuie să fie pus în target mode de către acel context manager.",
			correct: true
		}
	]}
/>

{#if fw === 'pt'}

### 8. De ce există o subclasă specifică a `Trainer` pentru problemele sequence-to-sequence?

<Question
	choices={[
		{
			text: "Deoarece problemele de sequence-to-sequence utilizează o pierdere personalizată, pentru a ignora labelurile setate la <code>-100</code>",
			explain: "Aceasta nu este deloc o pierdere personalizată, ci modul în care pierderea este întotdeauna calculată."
		},
		{
			text: "Deoarece problemele de sequence-to-sequence la secvență necesită o buclă de evaluare specială",
			explain: "Acest lucru este corect. Predicțiile modelelor sequence-to-sequence sunt de obicei rulate cu metoda <code>generate()</code>.",
			correct: true
		},
		{
			text: "Deoarece targeturile sunt texte în probleme sequence-to-sequence",
			explain: "<code>Trainer</code>-ului nu prea îi pasă de asta, deoarece acestea au fost preprocesate înainte."
		},
        {
			text: "Deoarece folosim două modele în problemele sequence-to-sequence",
			explain: "Într-un fel, folosim două modele, un codificator și un decodificator, dar acestea sunt grupate într-un singur model."
		}
	]}
/>

{:else}

### 9. De ce este adesea inutil să se specifice o pierdere atunci când se apelează `compile()` pe un model Transformer?

<Question
	choices={[
		{
			text: "Deoarece modelele Transformer sunt antrenate cu unsupervised learning",
			explain: "Nu chiar - chiar și unsupervised learning are nevoie de o funcție de pierdere!"
		},
		{
			text: "Deoarece, în mod prestabilit, se utilizează valoarea pierderilor interne ale modelului",
			explain: "Corect!",
			correct: true
		},
		{
			text: "Deoarece calculăm metricele după antrenare",
			explain: "Facem adesea acest lucru, dar nu explică de unde obținem valoarea pierderii pe care o optimizăm în formare."
		},
        {
			text: "Deoarece pierderea este specificată în `model.fit()`",
			explain: "Nu, funcția de pierdere este întotdeauna fixată odată ce rulați `model.compile()`, și nu poate fi modificată în `model.fit()`."
		}
	]}
/>

{/if}

### 10. Când ar trebui să preantrenați un model nou?

<Question
	choices={[
		{
			text: "Atunci când nu există un model preantrenat disponibil pentru limba dorită.",
			explain: "Corect.",
			correct: true
		},
		{
			text: "Atunci când aveți o mulțime de date disponibile, chiar dacă există un model preantrenat care ar putea funcționa pe ele",
			explain: "În acest caz, ar trebui, probabil, să utilizați modelul preantrenat și să îi faceți fine-tune pe datele voastre, pentru a evita costurile uriașe de calcul."
		},
		{
			text: "Atunci când aveți îndoieli cu privire la biasul modelului preantrenat pe care îl utilizați",
			explain: "Este adevărat, dar trebuie să vă asigurați că datele pe care le veți utiliza pentru antrenare sunt cu adevărat mai bune.",
			correct: true
		},
        {
			text: "Atunci când modelele preantrenate disponibile nu sunt suficient de bune",
			explain: "Sunteți sigur că ați făcut debbuging în mod corespunzător antrenării?"
		}
	]}
/>

### 11. De ce este ușor să preantrenăm un model lingvistic pe o mulțime de texte?

<Question
	choices={[
		{
			text: "Deoarece există o mulțime de texte disponibile pe internet",
			explain: "Deși este adevărat, acest lucru nu răspunde cu adevărat la întrebare. Încercați din nou!"
		},
		{
			text: "Deoarece obiectivul de preantrenare nu necesită ca oamenii să eticheteze datele",
			explain: "Acest lucru este corect, modelarea limbajului este o problemă autosupravegheată.",
			correct: true
		},
		{
			text: "Deoarece biblioteca 🤗 Transformers necesită doar câteva linii de cod pentru a începe antrenarea",
			explain: "Deși adevărat, acest lucru nu răspunde cu adevărat la întrebarea pusă. Încercați un alt răspuns!"
		}
	]}
/>

### 12. Care sunt principalele provocări la preprocesarea datelor pentru o sarcină de răspundere a întrebărilor?

<Question
	choices={[
		{
			text: "Trebuie să tokenizați inputurile.",
			explain: "Este corect, dar este cu adevărat o provocare principală?"
		},
		{
			text: "Trebuie să aveți de-a face cu contexte foarte lungi, care oferă mai multe caracteristici de antrenare care pot sau nu să conțină răspunsul.",
			explain: "Aceasta este cu siguranță una dintre provocări.",
			correct: true
		},
		{
			text: "Trebuie să tokenizați răspunsurile la întrebări, precum și inputurile.",
			explain: "Nu, cu excepția cazului în care vă încadrați problema de răspundere a întrebărilor ca o sarcină de sequence-to-sequence."
		},
       {
			text: "Din intervalul răspunsului din text, trebuie să găsiți tokenul de început și de sfârșit în inputul tokenizat.",
			explain: "Aceasta este una dintre părțile dificile!",
			correct: true
		}
	]}
/>

### 13. Cum se face de obicei post-procesarea în răspunderea la întrebări?

<Question
	choices={[
		{
			text: "Modelul vă oferă pozițiile de început și de sfârșit ale răspunsului, iar voi trebuie doar să decodificați intervalul corespunzător de tokeni.",
			explain: "Acesta ar putea fi un mod de a face acest lucru, dar este un pic prea simplist."
		},
		{
			text: "Modelul vă oferă pozițiile de început și de sfârșit ale răspunsului pentru fiecare caracteristică creată de un exemplu, iar voi trebuie doar să decodificați intervalul corespunzător de tokeni în cel care are cel mai bun scor.",
			explain: "Acest lucru este apropiat de post-procesarea pe care am studiat-o, dar nu este complet corect."
		},
		{
			text: "Modelul vă oferă pozițiile de început și de sfârșit ale răspunsului pentru fiecare caracteristică creată de un exemplu, iar voi trebuie doar să le potriviți cu intervalul din context pentru cel care are cel mai bun scor.",
			explain: "Asta e corect!",
			correct: true
		},
        {
			text: "Modelul generează un răspuns, iar tu trebuie doar să îl decodifici.",
			explain: "Nu, cu excepția cazului în care vă încadrați problema de răspundere a întrebării ca o sarcină de sequence-to-sequence."
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter7/9.mdx" />