# Introducere în Gradio[[introduction-to-gradio]]

<CourseFloatingBanner
    chapter={9}
    classNames="absolute z-10 right-0 top-0"
/>

În acest capitol vom învăța cum să construim **demo-uri interactive** pentru modelele noastre de machine learning.

De ce să construim un demo sau o interfață grafică pentru modelul nostru de machine learning în primul rând? Demo-urile permit:

- **Dezvoltatorilor de machine learning** să își prezinte cu ușurință lucrarea unei audiențe largi, inclusiv echipelor non-tehnice sau clienților
- **Cercetătorilor** să reproducă mai ușor modelele și comportamentul machine learning
- **Testerilor de calitate** sau **utilizatorilor finali** să identifice și să depaneze mai ușor punctele de eșec ale modelelor
- **Utilizatorilor diverși** să descopere prejudecățile algoritmice din modele

Vom folosi biblioteca Gradio pentru a construi demo-uri pentru modelele noastre. Gradio vă permite să construiți, să personalizați și să partajați demo-uri web pentru orice model de machine learning, în întregime în Python.

Iată câteva exemple de demo-uri de machine learning construite cu Gradio:

* Un model de **recunoaștere a schițelor** care primește o schiță și afișează etichete cu ceea ce crede că este desenat:

<iframe src="https://course-demos-draw2.hf.space" frameBorder="0" height="450" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

* Un model extractiv de **răspunsuri la întrebări** care primește un paragraf de context și o întrebare și afișează un răspuns și un scor de probabilitate (am discutat despre acest tip de model [în Capitolul 7](/course/chapter7/7)):

<iframe src="https://course-demos-question-answering-simple.hf.space" frameBorder="0" height="640" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

* Un model de **eliminare a fundalului** care primește o imagine și afișează imaginea cu fundalul eliminat:

<iframe src="https://course-demos-remove-bg-original.hf.space" frameBorder="0" height="640" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

Acest capitol este împărțit în secțiuni care includ atât _concepte_ cât și _aplicații_. După ce învățați conceptul din fiecare secțiune, îl veți aplica pentru a construi un anumit tip de demo, de la clasificarea imaginilor la recunoașterea vocii. Până când terminați acest capitol, veți putea construi aceste demo-uri (și multe altele!) în doar câteva linii de cod Python.

<Tip>
👀 Consultați <a href="https://huggingface.co/spaces" target="_blank">Hugging Face Spaces</a> pentru a vedea multe exemple recente de demo-uri de machine learning construite de comunitatea machine learning!
</Tip> 

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter9/1.mdx" />