# Construirea primului tău demo[[building-your-first-demo]]

<CourseFloatingBanner chapter={9}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter9/section2.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter9/section2.ipynb"},
]} />

Să începem prin instalarea Gradio! Întrucât este un pachet Python, pur și simplu rulează:

`$ pip install gradio `

Puteți rula Gradio oriunde, fie din IDE-ul tău Python preferat, în notebook-urile Jupyter sau chiar în Google Colab 🤯!
Deci instalați Gradio oriunde rulați Python!

Să începem cu un exemplu simplu "Hello World" pentru a ne familiariza cu sintaxa Gradio:

```py
import gradio as gr


def greet(name):
    return "Hello " + name


demo = gr.Interface(fn=greet, inputs="text", outputs="text")

demo.launch()
```

Să parcurgem codul de mai sus:

- Mai întâi, definim o funcție numită `greet()`. În acest caz, este o funcție simplă care adaugă "Hello" înaintea numelui tău, dar poate fi *orice* funcție Python în general. De exemplu, în aplicațiile de machine learning, această funcție ar *apela un model pentru a face o predicție* pe o intrare și ar returna ieșirea.
- Apoi, creăm o `Interface` Gradio cu trei argumente, `fn`, `inputs`, și `outputs`. Aceste argumente definesc funcția de predicție, precum și _tipul_ componentelor de intrare și ieșire pe care le-am dori. În cazul nostru, ambele componente sunt cutii de text simple.
- Apoi apelăm metoda `launch()` pe `Interface`-ul pe care l-am creat.

Dacă rulați acest cod, interfața de mai jos va apărea automat într-un notebook Jupyter/Colab, sau va apărea într-un browser la **[http://localhost:7860](http://localhost:7860/)** dacă rulează dintr-un script.

<iframe src="https://course-demos-hello-world.hf.space" frameBorder="0" height="250" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

Încercați să folosiți această interfață grafică chiar acum cu numele vostru sau cu alte intrări!

Veți observa că în această interfață grafică, Gradio a dedus automat numele parametrului de intrare (`name`)
și l-a aplicat ca etichetă deasupra cutiei de text. Ce se întâmplă dacă doriți să schimbați asta?
Sau dacă doriți să personalizați cutia de text în alt fel? În acest caz, puteți
instanția un obiect de clasă care reprezintă componenta de intrare.

Priviți exemplul de mai jos:

```py
import gradio as gr


def greet(name):
    return "Hello " + name


# Instanțiem clasa Textbox
textbox = gr.Textbox(label="Tastați numele aici:", placeholder="John Doe", lines=2)

gr.Interface(fn=greet, inputs=textbox, outputs="text").launch()
```

<iframe src="https://course-demos-hello-world-custom.hf.space" frameBorder="0" height="300" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

Aici, am creat o cutie de text de intrare cu o etichetă, un placeholder și un număr setat de linii.
Ați putea face același lucru pentru cutia de text de ieșire, dar o vom lăsa pentru mai târziu.

Am văzut că cu doar câteva linii de cod, Gradio vă permite să creați o interfață simplă în jurul oricărei funcții
cu orice tip de intrări sau ieșiri. În această secțiune, am început cu o
cutie de text simplă, dar în următoarele secțiuni, vom acoperi alte tipuri de intrări și ieșiri. Să aruncăm acum o privire la includerea unor NLP într-o aplicație Gradio.


## 🤖 Includerea predicțiilor modelului[[including-model-predictions]]

Să construim acum o interfață simplă care vă permite să demonstrați un model de **generare de text** ca GPT-2.

Vom încărca modelul nostru folosind funcția `pipeline()` din 🤗 Transformers.
Dacă aveți nevoie de o reîmprospătare rapidă, puteți să vă întoarceți la [acea secțiune din Capitolul 1](/course/chapter1/3#text-generation).

Primul, definim o funcție de predicție care primește un prompt de text și returnează completarea textului:

```py
from transformers import pipeline

model = pipeline("text-generation")


def predict(prompt):
    completion = model(prompt)[0]["generated_text"]
    return completion
```

Această funcție completează prompt-urile pe care le furnizați, și puteți să o rulați cu propriile prompt-uri de intrare pentru a vedea cum funcționează. Iată un exemplu (este posibil să obțineți o completare diferită):

```
predict("My favorite programming language is")
```

```
>> My favorite programming language is Haskell. I really enjoyed the Haskell language, but it doesn't have all the features that can be applied to any other language. For example, all it does is compile to a byte array.
```

Acum că avem o funcție pentru generarea predicțiilor, putem crea și lansa o `Interface` în același mod în care am făcut mai devreme:

```py
import gradio as gr

gr.Interface(fn=predict, inputs="text", outputs="text").launch()
```


Asta e! Acum puteți folosi această interfață pentru a genera text folosind modelul GPT-2 așa cum se arată mai jos 🤯.

<iframe src="https://course-demos-gpt-2.hf.space" frameBorder="0" height="300" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

Continuați să citiți pentru a vedea cum să construiți alte tipuri de demo-uri cu Gradio! 

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter9/2.mdx" />