# Partajarea demo-urilor cu alții[[sharing-demos-with-others]]

<CourseFloatingBanner chapter={9}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter9/section4.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter9/section4.ipynb"},
]} />

Acum că ați construit un demo, probabil doriți să îl partajați cu alții. Demo-urile Gradio
pot fi partajate în două moduri: folosind un ***link de partajare temporar*** sau ***găzduire permanentă pe Spaces***.

Vom acoperi ambele abordări în curând. Dar înainte să vă partajați demo-ul, este posibil să doriți să îl înfrumusețați 💅.

### Înfrumusețarea demo-ului Gradio:[[polishing-your-gradio-demo]]

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter9/gradio-demo-overview.png" alt="Overview of a gradio interface">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter9/gradio-demo-overview-dark.png" alt="Overview of a gradio interface">
</div>

Pentru a adăuga conținut suplimentar la demo-ul dvs., clasa `Interface` suportă câțiva parametri opționali:
    - `title`: puteți da un titlu demo-ului dvs., care apare _deasupra_ componentelor de intrare și ieșire.
    - `description`: puteți da o descriere (în text, Markdown sau HTML) pentru interfață, care apare deasupra componentelor de intrare și ieșire și sub titlu.
    - `article`: puteți scrie și un articol extins (în text, Markdown sau HTML) explicând interfața. Dacă este furnizat, apare _sub_ componentele de intrare și ieșire.
    - `theme`: nu vă plac culorile implicite? Setați tema să folosească una dintre `default`, `huggingface`, `grass`, `peach`. Puteți adăuga și prefixul `dark-`, de ex. `dark-peach` pentru tema întunecată (sau doar `dark` pentru tema întunecată implicită).
    - `examples`: pentru a face demo-ul *mult mai ușor de folosit*, puteți furniza exemple de intrări pentru funcție. Acestea apar sub componentele UI și pot fi folosite pentru a popula interfața. Acestea ar trebui furnizate ca o listă imbricată, în care lista exterioară constă din exemple și fiecare listă interioară constă dintr-o intrare corespunzătoare fiecărei componente de intrare.
    - `live`: dacă doriți să faceți demo-ul "live", adică modelul să ruleze din nou de fiecare dată când intrarea se schimbă, puteți seta `live=True`. Acest lucru are sens să se folosească cu modele rapide (vom vedea un exemplu la sfârșitul acestei secțiuni)
Folosind opțiunile de mai sus, ajungem la o interfață mai completă. Rulați codul de mai jos pentru a putea conversa cu Rick și Morty:

```py
title = "Ask Rick a Question"
description = """
The bot was trained to answer questions based on Rick and Morty dialogues. Ask Rick anything!
<img src="https://huggingface.co/spaces/course-demos/Rick_and_Morty_QA/resolve/main/rick.png" width=200px>
"""

article = "Check out [the original Rick and Morty Bot](https://huggingface.co/spaces/kingabzpro/Rick_and_Morty_Bot) that this demo is based off of."

gr.Interface(
    fn=predict,
    inputs="textbox",
    outputs="text",
    title=title,
    description=description,
    article=article,
    examples=[["What are you doing?"], ["Where should we time travel to?"]],
).launch()
```

Folosind opțiunile de mai sus, ajungem la o interfață mai completă. Încercați interfața de mai jos:

<iframe src="https://course-demos-Rick-and-Morty-QA.hf.space" frameBorder="0" height="800" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

### Partajarea demo-ului cu link-uri temporare[[sharing-your-demo-with-temporary-links]]
Acum că avem un demo funcțional al modelului nostru de machine learning, să învățăm cum să partajăm cu ușurință un link către interfața noastră.
Interfețele pot fi partajate public cu ușurință prin setarea `share=True` în metoda `launch()`:

```python
gr.Interface(classify_image, "image", "label").launch(share=True)
```

Aceasta generează un link public, partajabil pe care îl puteți trimite oricui! Când trimiteți acest link, utilizatorul din cealaltă parte poate încerca modelul în browserul lor timp de până la 72 de ore. Deoarece procesarea se întâmplă pe dispozitivul dvs. (atâta timp cât dispozitivul dvs. rămâne pornit!), nu trebuie să vă faceți griji cu privire la împachetarea dependențelor. Dacă lucrați dintr-un notebook Google Colab, un link de partajare este întotdeauna creat automat. De obicei arată cam așa: **XXXXX.gradio.app**. Deși link-ul este servit printr-un link Gradio, suntem doar un proxy pentru serverul dvs. local și nu stocăm datele trimise prin interfețe.

Rețineți totuși că aceste link-uri sunt accesibile public, ceea ce înseamnă că oricine poate folosi modelul dvs. pentru predicție! Prin urmare, asigurați-vă să nu expuneți informații sensibile prin funcțiile pe care le scrieți sau să permiteți modificări critice pe dispozitivul dvs. Dacă setați `share=False` (implicit), doar un link local este creat.

### Găzduirea demo-ului pe Hugging Face Spaces[[hosting-your-demo-on-hugging-face-spaces]]

Un link de partajare pe care îl puteți transmite colegilor este cool, dar cum puteți găzdui permanent demo-ul și să îl faceți să existe în propriul său "spațiu" pe internet?

Hugging Face Spaces oferă infrastructura pentru a găzdui permanent modelul dvs. Gradio pe internet, **gratuit**! Spaces vă permite să creați și să împingeți într-un repo (public sau privat),
unde codul interfața dvs. Gradio
va exista într-un fișier `app.py`. [Citiți un tutorial pas cu pas](https://huggingface.co/blog/gradio-spaces) pentru a începe, sau urmăriți un videoclip exemplu mai jos.

<Youtube id="LS9Y2wDVI0k" />

## ✏️ Să aplicăm![[lets-apply-it]]

Folosind ceea ce tocmai am învățat în secțiunile de până acum, să creăm demo-ul de recunoaștere a schițelor pe care l-am văzut în [secțiunea unu din acest capitol](/course/chapter9/1). Să adăugăm câteva personalizări la interfața noastră și să setăm `share=True` pentru a crea un link public pe care îl putem transmite.

Putem încărca etichetele din [class_names.txt](https://huggingface.co/spaces/dawood/Sketch-Recognition/blob/main/class_names.txt) și să încărcăm modelul pytorch pre-antrenat din [pytorch_model.bin](https://huggingface.co/spaces/dawood/Sketch-Recognition/blob/main/pytorch_model.bin). Descărcați aceste fișiere urmărind link-ul și făcând clic pe download în colțul din stânga sus al previzualizării fișierului. Să aruncăm o privire la codul de mai jos pentru a vedea cum folosim aceste fișiere pentru a încărca modelul nostru și a crea o funcție `predict()`:
```py
from pathlib import Path
import torch
import gradio as gr
from torch import nn

LABELS = Path("class_names.txt").read_text().splitlines()

model = nn.Sequential(
    nn.Conv2d(1, 32, 3, padding="same"),
    nn.ReLU(),
    nn.MaxPool2d(2),
    nn.Conv2d(32, 64, 3, padding="same"),
    nn.ReLU(),
    nn.MaxPool2d(2),
    nn.Conv2d(64, 128, 3, padding="same"),
    nn.ReLU(),
    nn.MaxPool2d(2),
    nn.Flatten(),
    nn.Linear(1152, 256),
    nn.ReLU(),
    nn.Linear(256, len(LABELS)),
)
state_dict = torch.load("pytorch_model.bin", map_location="cpu")
model.load_state_dict(state_dict, strict=False)
model.eval()


def predict(im):
    x = torch.tensor(im, dtype=torch.float32).unsqueeze(0).unsqueeze(0) / 255.0
    with torch.no_grad():
        out = model(x)
    probabilities = torch.nn.functional.softmax(out[0], dim=0)
    values, indices = torch.topk(probabilities, 5)
    return {LABELS[i]: v.item() for i, v in zip(indices, values)}
```

Acum că avem o funcție `predict()`. Următorul pas este să definim și să lansăm interfața noastră gradio:

```py
interface = gr.Interface(
    predict,
    inputs="sketchpad",
    outputs="label",
    theme="huggingface",
    title="Sketch Recognition",
    description="Who wants to play Pictionary? Draw a common object like a shovel or a laptop, and the algorithm will guess in real time!",
    article="<p style='text-align: center'>Sketch Recognition | Demo Model</p>",
    live=True,
)
interface.launch(share=True)
```

<iframe src="https://course-demos-Sketch-Recognition.hf.space" frameBorder="0" height="650" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>


Observați parametrul `live=True` în `Interface`, care înseamnă că demo-ul cu schițe face
o predicție de fiecare dată când cineva desenează pe sketchpad (fără buton de submit!).

În plus, am setat și argumentul `share=True` în metoda `launch()`.
Aceasta va crea un link public pe care îl puteți
trimite oricui! Când trimiteți acest link, utilizatorul din cealaltă parte poate încerca
modelul de recunoaștere a schițelor. Pentru a reitera, ați putea găzdui și modelul pe Hugging Face Spaces,
care este modul în care reușim să încorporăm demo-ul de mai sus.

Următorul, vom acoperi alte moduri în care Gradio poate fi folosit cu ecosistemul Hugging Face! 

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter9/4.mdx" />