# Hugging Face Hub

<CourseFloatingBanner
    chapter={4}
    classNames="absolute z-10 right-0 top-0"
/>

[Hugging Face Hub](https://huggingface.co/) -- наш главный сайт -- центральная платформа, позволяющая всем изучить, применить и внести свой вклад в SOTA (state-of=the-art) модели и наборы данных. Здесь хранится множество разнообразных моделей, среди которых больше 10000 доступны для использования. В этой главе мы сконцентрируемся на моделях, а в главе 5 обратим внимание на датасеты. 

Модели из Hugging Face Hub - это не только трансформеры или модели из области NLP. Здесь присутствуют модели [Flair](https://github.com/flairNLP/flair) и [AllenNLP](https://github.com/allenai/allennlp) для NLP, речевые модели [Asteroid](https://github.com/asteroid-team/asteroid) и [pyannote](https://github.com/pyannote/pyannote-audio), [timm](https://github.com/rwightman/pytorch-image-models) для компьютерного зрения. 

Каждая из этих моделей размещается в виде git-репозитория, что позволяет управлять версиями и воспроизводить их. Совместное использование модели в Hub означает ее доступность для сообщества и предоставление доступа к ней всем, кто хочет легко ее использовать, что, в свою очередь, избавляет их от необходимости обучать модель самостоятельно.

Кроме того, совместное использование модели в Hub автоматически развертывает размещенный API применения для этой модели. Любой участник сообщества может протестировать его прямо на странице модели с пользовательскими входными данными и соответствующими виджетами.

Самое приятное то, что делиться и использовать любую общедоступную модель в Hub можно совершенно бесплатно! [Платные варианты] (https://huggingface.co/pricing) также существуют, если вы хотите поделиться моделями в частном порядке.

В видео ниже показано, как сориентироваться на Hub. 

<Youtube id="XvSGPZFEjDY"/>

Чтобы завершить изучение этой главы, необходимо иметь учетную запись Huggingface.co, так как мы будем создавать и управлять репозиториями в Hugging Face Hub: [создать учетную запись](https://huggingface.co/join)

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ru/chapter4/1.mdx" />