# Тест в конце главы[[end-of-chapter-quiz]]

<CourseFloatingBanner
    chapter={7}
    classNames="absolute z-10 right-0 top-0"
/>

Давайте проверим, чему вы научились в этой главе!

### 1. Какую из следующих задач можно сформулировать как проблему классификации токенов?

<Question
	choices={[
		{
			text: "Поиск грамматических компонентов в предложении.",
			explain: "Правильно! Затем мы можем пометить каждое слово как существительное, глагол и т.д.",
			correct: true
		},
		{
			text: "Определение того, является ли предложение грамматически правильным или нет.",
			explain: "Нет, это проблема классификации последовательностей."
		},
		{
			text: "Поиск персон, упомянутых в предложении.",
			explain: "Правильно! Мы можем пометить каждое слово как персона или не персона.",
            correct: true
		},
        {
			text: "Поиск части слов в предложении, которое отвечает на вопрос.",
			explain: "Нет, это была бы проблема ответа на вопрос."
		}
	]}
/>

### 2. Какая часть предварительной обработки для классификации токенов отличается от других конвейеров предварительной обработки?

<Question
	choices={[
		{
			text: "Ничего делать не нужно: тексты уже токенизированы.",
			explain: "Тексты действительно представлены в виде отдельных слов, но нам все равно нужно применить модель токенизации по подсловам."
		},
		{
			text: "Тексты представлены в виде слов, поэтому нам нужно применить только токенизацию по подсловам.",
			explain: "Правильно! Это отличие от обычной предобработки, где нам нужно применить полный конвейер токенизации. Можете ли вы придумать другое отличие?",
			correct: true
		},
		{
			text: "Мы используем <code>-100</code> для обозначения специальных токенов.",
			explain: "Это не относится к классификации токенов - мы всегда используем <code>-100</code> в качестве метки для токенов, которые мы хотим игнорировать в потерях."
		},
		{
			text: "При применении усечения/дополнения нам нужно убедиться, что метки имеют тот же размер, что и входные данные.",
			explain: "Действительно! Но это не единственное отличие.",
			correct: true
		}
	]}
/>

### 3. Какая проблема возникает при токенизации слов в проблеме классификации токенов и при необходимости их маркировки?

<Question
	choices={[
		{
			text: "Токенизатор добавляет специальные токены, для которых у нас нет меток.",
			explain: "Мы помечаем их -100, чтобы они игнорировались при потерях."
		},
		{
			text: "Каждое слово может создавать несколько токенов, поэтому в итоге мы получаем больше токенов, чем меток.",
			explain: "Это основная проблема, и нам нужно выровнять оригинальные метки с токенами.",
			correct: true
		},
		{
			text: "Добавленные токены не имеют меток, поэтому проблем не возникает.",
			explain: "Это неверно; нам нужно столько меток, сколько у нас токенов, иначе наши модели будут ошибаться."
		}
	]}
/>

### 4. Что означает "доменная адаптация"?

<Question
	choices={[
		{
			text: "Это когда мы запускаем модель на датасете и получаем предсказания для каждого примера в этом датасете.",
			explain: "Нет, это просто инференс."
		},
		{
			text: "Это когда мы обучаем модель на датасете.",
			explain: "Нет, это обучение модели; здесь нет адаптации."
		},
		{
			text: "Это когда мы проводим дообучение предварительно обученной модели на новом датасете, и он выдает прогнозы, более адаптированные к этому датасету.",
			explain: "Правильно! Модель адаптировала свои знания к новому датасету.",
            correct: true
		},
        {
			text: "Это когда мы добавляем в датасет неправильно классифицированные образцы, чтобы сделать нашу модель более надежной.",
			explain: "Это, конечно, нужно делать, если вы регулярно переобучаете свою модель, но это не доменная адаптация."
		}
	]}
/>

### 5. Что такое метки в проблеме маскированного языкового моделирования?

<Question
	choices={[
		{
			text: "Некоторые токены во входном предложении маскируются случайным образом, а метками служат оригинальные входные токены.",
			explain: "Это оно!",
            correct: true
		},
		{
			text: "Некоторые токены во входном предложении случайным образом маскируются, а метками служат исходные токены, сдвинутые влево.",
			explain: "Нет, сдвиг меток влево соответствует предсказанию следующего слова, что соответствует каузальному языковому моделированию."
		},
		{
			text: "Некоторые токены во входном предложении маскируются случайным образом, а метка означает, является ли предложение положительным или отрицательным.",
			explain: "Это проблема классификации последовательностей с некоторыми дополнениями к данным, а не маскированное языковое моделирование."
		},
        {
			text: "Некоторые токены в двух входных предложениях маскируются случайным образом, а метка означает, похожи эти два предложения или нет.",
			explain: "Это проблема классификации последовательностей с некоторыми дополнительными данными, а не маскированное моделирование языка."
		}
	]}
/>

### 6. Какую из этих задач можно рассматривать как проблему преобразования последовательности-в-последовательность (sequence-to-sequence problem)? 

<Question
	choices={[
		{
			text: "Написание коротких обзоров длинных документов",
			explain: "Да, это проблема суммаризации. Попробуйте другой ответ!",
            correct: true
		},
		{
			text: "Ответы на вопросы о документе",
			explain: "Это можно сформулировать как проблему преобразования последовательности-в-последовательность. Однако это не единственный правильный ответ.",
            correct: true
		},
		{
			text: "Перевод текста на китайском языке на английский",
			explain: "Это определенно проблема преобразования последовательности-в-последовательность. Вы можете найти другую?",
            correct: true
		},
        {
			text: "Исправление сообщений, отправленных моим племянником/другом, чтобы они были на правильном английском языке",
			explain: "Это своего рода проблема перевода, так что это определенно задача последовательности-в-последовательности. Однако это не единственный правильный ответ!",
			correct: true
		}
	]}
/>

### 7. Каков правильный способ предварительной обработки данных для проблемы преобразования последовательности-в-последовательность?

<Question
	choices={[
		{
			text: "Входные данные и цели должны быть переданы токенизатору вместе с <code>inputs=...</code> и <code>targets=...</code>.",
			explain: "Возможно, в будущем мы добавим такой API, но сейчас это невозможно."
		},
		{
			text: "Входные данные и цели должны быть предварительно обработаны в двух раздельных вызовах токенизатора.",
			explain: "Это правда, но неполная. Вам нужно кое-что сделать, чтобы убедиться, что токенизатор правильно обрабатывает оба варианта."
		},
		{
			text: "Как обычно, нам просто нужно выполнить токенизацию входных данных.",
			explain: "Не в проблеме классификации последовательностей; цели - это тексты, которые мы должны преобразовать в числа!"
		},
        {
			text: "Входные данные должны быть переданы токенизатору, и цели тоже, но под управлением специального контекстного менеджера.",
			explain: "Верно, токенизатор должен быть переведен в target режим этим менеджером контекста.",
			correct: true
		}
	]}
/>

{#if fw === 'pt'}

### 8. Почему существует специальный подкласс `Trainer` для проблем преобразования " последовательности-в-последовательность"?

<Question
	choices={[
		{
			text: "Поскольку проблемы преобразования последовательности-в-последовательность используют определенные пользователем потери, для игнорирования меток задайте <code>-100</code>.",
			explain: "Это вовсе не определенные пользователем потери, а то, как потери всегда вычисляются."
		},
		{
			text: "Поскольку проблемы преобразования последовательности-в-последовательность требуют специального цикла оценки",
			explain: "Это верно. Предсказания моделей преобразующих последовательность-в-последовательность часто выполняются с помощью метода <code>generate()</code>.",
			correct: true
		},
		{
			text: "Поскольку целью являются тексты в проблемах преобразования последовательности-в-последовательность",
			explain: "<code>Trainer</code> не особо заботится об этом, поскольку они уже были предварительно обработаны."
		},
        {
			text: "Поскольку в проблемах преобразования последовательности-в-последовательность мы используем две модели",
			explain: "В некотором смысле мы используем две модели, энкодер и декодер, но они сгруппированы в одну модель."
		}
	]}
/>

{:else}

### 9. Почему при вызове `compile()` для модели трансформера часто нет необходимости определять потери?

<Question
	choices={[
		{
			text: "Потому что модели трансформеров обучаются с помощью обучения без учителя.",
			explain: "Не совсем так - даже для обучения без учителя нужна функция потерь!"
		},
		{
			text: "Потому что по умолчанию используется внутренний вывод потерь модели.",
			explain: "Это верно!",
			correct: true
		},
		{
			text: "Потому что вместо этого мы вычисляем метрики после обучения.",
			explain: "Мы часто так и поступаем, но это не объясняет, откуда мы берем значение потерь, которое оптимизируем в процессе обучения."
		},
        {
			text: "Потому что вместо этого потери определяются в `model.fit()`.",
			explain: "Нет, функция потерь всегда фиксирована после запуска `model.compile()` и не может быть изменена в `model.fit()`."
		}
	]}
/>

{/if}

### 10. Когда следует проводить предварительное обучение новой модели?

<Question
	choices={[
		{
			text: "Если для вашего специфического языка не существует предварительно обученной модели.",
			explain: "Это верно!",
			correct: true
		},
		{
			text: "Когда у вас много данных, даже если есть предварительно обученная модель, которая может работать с ними.",
			explain: "В этом случае, вероятно, следует использовать предварительно обученную модель и провести ее дообучение на ваших данных, чтобы избежать больших вычислительных затрат."
		},
		{
			text: "Если у вас есть опасения по поводу смещения предварительно обученной модели, которую вы используете",
			explain: "Это правда, но вы должны быть уверены, что данные, которые вы будете использовать для обучения, действительно лучше.",
			correct: true
		},
        {
			text: "Когда имеющиеся предварительно обученные модели недостаточно хороши.",
			explain: "Вы уверены, что правильно отладили свой цикл обучения?"
		}
	]}
/>

### 11. Почему легко провести предварительное обучение языковой модели на большом количестве текстов?

<Question
	choices={[
		{
			text: "Потому что в Интернете можно найти множество текстов.",
			explain: "Хотя это и верно, но не отвечает на вопрос. Попробуйте еще раз!"
		},
		{
			text: "Потому что задача предварительного обучения не требует от людей маркировки данных.",
			explain: "Верно, языковое моделирование - это проблема обучения с самоконтролем (self-supervised problem).",
			correct: true
		},
		{
			text: "Потому что библиотека 🤗 Transformers требует всего несколько строк кода для начала обучения.",
			explain: "Хотя это и верно, но не совсем отвечает на поставленный вопрос. Попробуйте другой ответ!"
		}
	]}
/>

### 12. Какие основные проблемы возникают при предварительной обработке данных для задачи ответа на вопрос (question answering)?

<Question
	choices={[
		{
			text: "Вам нужно выполнить токенизацию входных данных.",
			explain: "Это верно, но действительно ли это главная проблема?"
		},
		{
			text: "Вам приходится иметь дело с очень длинными контекстами, в которых дается несколько обучающих признаков, которые могут содержать ответ, а могут и не содержать.",
			explain: "Это, безусловно, одна из проблем.",
			correct: true
		},
		{
			text: "Вам нужно провести токенизацию ответов на вопрос так же, как и входных данных.",
			explain: "Нет, если только вы не формулируете проблему ответа на вопрос как задачу преобразования последовательности-в-последовательность."
		},
       {
			text: "На основе фрагмента ответа в тексте нужно найти начальный и конечный токен в исходном токенизированном тексте.",
			explain: "Это одна из самых сложных частей, да!",
			correct: true
		}
	]}
/>

### 13. Как обычно выполняется постобработка в задаче ответов на вопросы?

<Question
	choices={[
		{
			text: "Модель дает вам начальную и конечную позиции ответа, и вам остается только декодировать соответствующий промежуток токенов.",
			explain: "Это может быть одним из способов, но слишком упрощенным."
		},
		{
			text: "Модель возыращает вам начальную и конечную позиции ответа для каждого признака, созданного одним примером, а вам остается только декодировать соответствующий промежуток токенов в том из них, который имеет наилучшую оценку.",
			explain: "Это близко к постобработке, которую мы изучали, но это не совсем правильно."
		},
		{
			text: "Модель возвращает вам начальную и конечную позиции ответа для каждого признака, созданного одним примером, а вам остается только сопоставить их с промежутком в контексте, чтобы выбрать тот, который набрал наибольшую оценку.",
			explain: "Вот и все в двух словах!",
			correct: true
		},
        {
			text: "Модель генерирует ответ, а вам остается только декодировать его.",
			explain: "Нет, если только вы не формулируете проблему ответа на вопрос как проблему преобразования последовательности-в-последовательность."
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ru/chapter7/9.mdx" />