# Тест в конце главы[[end-of-chapter-quiz]]

<CourseFloatingBanner
    chapter={8}
    classNames="absolute z-10 right-0 top-0"
/>

Let's test what you learned in this chapter!

### 1. В каком порядке следует читать обратную трассировку в Python?

<Question
	choices={[
		{
			text: "Сверху вниз",
			explain: "Попробуйте еще раз - хотя большинство других языков программирования выводят исключение сверху, Python в этом отношении особенный.	"
		},
		{
			text: "Снизу вверх",
			explain: "Правильно! Одно из преимуществ трассировки Python, показывающей исключение внизу, заключается в том, что ее легче отлаживать, когда вы работаете в терминале и это последняя строка, которую вы видите.",
			correct: true
		}
	]}
/>

### 2. Что такое минимальный воспроизводимый пример?

<Question
	choices={[
		{
			text: "Простая реализация архитектуры трансформера из научной статьи",
			explain: "Хотя создавать собственные модели трансформеров с нуля очень познавательно, мы сейчас говорим не об этом."
		},
		{
			text: "Компактный и самодостаточный блок кода, который может быть запущен без внешних зависимостей от частных файлов или данных",
			explain: "Правильно! Минимальные воспроизводимые примеры помогают сопровождающим библиотеки воспроизвести возникшую у вас проблему, чтобы они могли быстрее найти решение..",
			correct: true
		},
		{
			text: "Снимок экрана с трассировкой Python",
			explain: "Попробуйте еще раз - хотя очень соблазнительно приложить скриншот ошибки, с которой вы столкнулись при оформлении проблемы, это сильно затрудняет воспроизведение ошибки другими людьми.."
		},
		{
			text: "Jupyter-ноутбук, содержащий весь ваш код, включая части, не имеющие отношения к ошибке",
			explain: "Не совсем так - хотя может быть полезно поделиться блокнотом Google Colab, в котором показана ошибка, убедитесь, что он короткий и содержит только соответствующий код."
		}
	]}
/>

### 3. Предположим, вы пытаетесь выполнить следующий код, который выдает ошибку:

```py
from transformers import GPT3ForSequenceClassification

# ImportError: cannot import name 'GPT3ForSequenceClassification' from 'transformers' (/Users/lewtun/miniconda3/envs/huggingface/lib/python3.8/site-packages/transformers/__init__.py)
# ---------------------------------------------------------------------------
# ImportError                               Traceback (most recent call last)
# /var/folders/28/k4cy5q7s2hs92xq7_h89_vgm0000gn/T/ipykernel_30848/333858878.py in <module>
# ----> 1 from transformers import GPT3ForSequenceClassification

# ImportError: cannot import name 'GPT3ForSequenceClassification' from 'transformers' (/Users/lewtun/miniconda3/envs/huggingface/lib/python3.8/site-packages/transformers/__init__.py)
```

Что из нижеперечисленного может быть хорошим выбором для названия темы на форуме с просьбой о помощи?

<Question
	choices={[
		{
			text: "<code>ImportError: cannot import name 'GPT3ForSequenceClassification' from 'transformers' (/Users/lewtun/miniconda3/envs/huggingface/lib/python3.8/site-packages/transformers/__init__.py)</code>",
			explain: "Включение последней строки трассировки может быть описательным, но это лучше оставить для основной части темы. Попробуйте еще раз!"
		},
		{
			text: "Проблема с  <code>from transformers import GPT3ForSequenceClassification</code>",
			explain: "Попробуйте еще раз - хотя это и полезная информация, ее лучше оставить для основной части текста.",
		},
		{
			text: "Почему я не могу импортировать <code>GPT3ForSequenceClassification</code>?",
			explain: "Отличный выбор! Это название лаконично и дает читателю понять, что может быть не так (например, что GPT-3 не поддерживается в 🤗 Transformers).",
			correct: true
		},
		{
			text: "Поддерживается ли GPT-3 в 🤗 Transformers?",
			explain: "Отличный вариант! Использование вопросов в качестве заголовков тем - отличный способ донести проблему до сообщества.",
			correct: true
		}
	]}
/>

### 4. Предположим, вы пытаетесь запустить `trainer.train()` и сталкиваетесь с загадочной ошибкой, которая не говорит вам, откуда именно она взялась. Что из нижеперечисленного является первым местом, где вы должны искать ошибки в вашем конвейере обучения?

<Question
	choices={[
		{
			text: "Этап оптимизации, на котором мы вычисляем градиенты и выполняем обратное распространение ошибки",
			explain: "Хотя в вашем оптимизаторе могут быть ошибки, обычно это происходит на нескольких этапах обучения, поэтому сначала нужно проверить другие вещи. Попробуйте еще раз!"
		},
		{
			text: "Этап оценки, на котором мы вычисляем метрики",
			explain: "Оценка обычно выполняется после обучения в течение полной эпохи, поэтому сначала следует проверить где-то на более ранних этапах обучения.",
		},
		{
			text: "Набор данных",
			explain: "Правильно! Почти всегда первым делом нужно просмотреть данные, чтобы убедиться, что текст закодирован правильно, имеет ожидаемые характеристики и т. д.",
			correct: true
		},
		{
			text: "Загрузчики данных",
			explain: "Попробуйте еще раз - это очень близко к тому, что нужно проверить в первую очередь. Помните ли вы, какой объект мы передаем в dataloaders?"
		}
	]}
/>

### 5. Каков наилучший способ отладки ошибок CUDA?

<Question
	choices={[
		{
			text: "Опубликовать сообщение об ошибке на форумах или GitHub.",
			explain: "Это никому не поможет, поскольку сообщения об ошибках CUDA обычно очень неинформативны."
		},
		{
			text: "Выполнить такой же код на CPU.",
			explain: "Именно, это должно дать вам более точное сообщение об ошибке!",
			correct: true
		},
		{
			text: "Прочитайте трассировку, чтобы выяснить причину ошибки.",
			explain: "Это то, что вы сделали бы для любой другой ошибки, но ошибки CUDA обычно не проявляются там, где они произошли, потому что большинство операций CUDA асинхронны."
		},
		{
			text: "Уменьшите размер партии батча.",
			explain: "Уменьшение размера батча обычно является хорошей стратегией для устранения ошибок CUDA, связанных с памятью, но не для этой конкретной проблемы. Попробуйте еще раз!"
		},
		{
			text: "Перезапустите ядро Jupyter.",
			explain: "Попробуйте еще раз - перезапуск ядра не приведет к исчезновению ошибки!",
		}
	]}
/>

### 6. Как лучше всего сообщить о проблеме на GitHub?

<Question
	choices={[
		{
			text: "Опубликовать полный воспроизводимый пример ошибки.",
			explain: "Да, это лучший способ помочь сопровождающим найти вашу ошибку. Что еще вы должны сделать?",
			correct: true
		},
		{
			text: "Каждый день спрашивать о новостях.",
			explain: "Это вряд ли поможет вам; скорее всего, люди будут игнорировать вас еще больше.",
		},
		{
			text: "Изучите исходный код вокруг ошибки и попытайтесь найти причину ее возникновения. Опубликуйте результаты в этой теме.",
			explain: "Это определенно поможет сопровождающим! А если вы найдете источник ошибки и ее исправление, вы даже сможете открыть запрос на исправление (pull request). Что еще вы должны сделать?",
			correct: true
		}
	]}
/>

### 7. Почему переобучение модели с одним батчем обычно является хорошим методом отладки?

<Question
	choices={[
		{
			text: "Это не так; переобучение - это всегда плохо и его следует избегать.",
			explain: "При обучении на всем наборе данных переобучение действительно может быть признаком того, что ваша модель плохо обобщается на новые примеры. Однако для отладки мы обычно не обучаемся на всем наборе данных. Попробуйте еще раз!"
		},
		{
			text: "Это позволяет убедиться в том, что модель способна свести значения функциипотерь к нулю.",
			explain: "Правильно! С помощью батча даннх, состоящего всего из нескольких примеров, мы можем быстро проверить, способна ли модель к обучению.",
			correct: true
		},
		{
			text: "Это позволяет нам убедиться в правильности размеров тензоров наших входов и меток.",
			explain: "Попробуйте еще раз - если размерности ваших тензоров неподходящие, то вы точно не сможете обучиться даже на одном батче.",
		}
	]}
/>

### 8. Почему при создании нового вопроса в репозитории  🤗 Transformers стоит указать подробности о вашем  окружении разработки с помощью `transformers-cli env`??

<Question
	choices={[
		{
			text: "Это позволяет сопровождающим понять, какую версию библиотеки вы используете.",
			explain: "Правильно! Поскольку в каждой основной версии библиотеки могут быть изменения в API, знание конкретной версии может помочь сузить круг проблем. Каковы другие преимущества?",
			correct: true
		},
		{
			text: "Это позволяет сопровождающим узнать, работаете ли вы под Windows, macOS или Linux.",
			explain: "Правильно! Иногда ошибки могут быть вызваны конкретной операционной системой, которую вы используете, и знание этого помогает сопровождающим воспроизводить их на месте. Однако это не единственная причина.",
			correct: true
		},
		{
			text: "Это позволяет сопровождающим знать, на каком процессоре или GPU вы выполняете код.",
			explain: "Правильно! Как мы уже видели в этой главе, код, запущенный на GPU или CPU, может давать разные результаты или ошибки, и знание того, какое оборудование вы используете, может помочь сфокусировать внимание сопровождающих. Но это не единственное преимущество...",
			correct: true
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ru/chapter8/7.mdx" />