# ట్రాన్స్‌ఫార్మర్‌లు, అవి ఏమి చేయగలవు?[[transformers-what-can-they-do]]

<CourseFloatingBanner
  chapter={1}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {
      label: "Google Colab",
      value:
        "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter1/section3.ipynb",
    },
    {
      label: "Aws Studio",
      value:
        "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter1/section3.ipynb",
    },
  ]}
/>

ఈ విభాగంలో, Transformer మోడల్స్ ఏమి చేయగలవో చూద్దాం మరియు 🤗 Transformers లైబ్రరీ నుండి మా మొదటి సాధనం: `pipeline()` ఫంక్షన్‌ను ఉపయోగిద్దాం.

<Tip>
👀 కుడివైపు పైభాగంలో ఉన్న <em>Open in Colab</em> బటన్ చూడండి? దానిపై క్లిక్ చేసి, ఈ విభాగానికి సంబంధించిన అన్ని కోడ్ నమూనాలతో ఉన్న Google Colab నోట్‌బుక్‌ను తెరవండి. కోడ్ ఉదాహరణలు ఉన్న ఏ విభాగంలోనైనా ఈ బటన్ ఉంటుంది.

మీరు ఉదాహరణలను స్థానికంగా అమలు చేయాలనుకుంటే, మేము <a href="/course/chapter0">సెటప్</a> ను చూడమని సిఫార్సు చేస్తాము.

</Tip>

## ట్రాన్స్‌ఫార్మర్‌లు ప్రతిచోటా ఉన్నాయి![[transformers-are-everywhere]]

Transformer మోడల్స్ సహజ భాషా ప్రాసెసింగ్ (NLP), కంప్యూటర్ విజన్, ఆడియో ప్రాసెసింగ్ మరియు మరిన్ని వంటి వివిధ రంగాలలో అన్ని రకాల పనులను పరిష్కరించడానికి ఉపయోగిస్తారు. ఇక్కడ కొన్ని కంపెనీలు మరియు సంస్థలు ఉన్నాయి, ఇవి Hugging Face మరియు Transformer మోడల్స్ ను ఉపయోగిస్తున్నాయి, మరియు వారి మోడల్స్‌ను పంచుకోవడం ద్వారా సమాజానికి తిరిగి తోడ్పడతాయి:

<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/companies.PNG" alt="Companies using Hugging Face" width="100%">

[🤗 Transformers లైబ్రరీ](https://github.com/huggingface/transformers) ఆ పంచుకున్న మోడల్స్‌ను సృష్టించడానికి మరియు ఉపయోగించడానికి ఫంక్షనాలిటీని అందిస్తుంది. [మోడల్ హబ్](https://huggingface.co/models) లో మిలియన్ల కొద్దీ ముందుగా శిక్షణ పొందిన మోడల్స్ ఉన్నాయి, వాటిని ఎవరైనా డౌన్‌లోడ్ చేసి ఉపయోగించవచ్చు. మీరు మీ స్వంత మోడల్స్‌ను కూడా హబ్‌కు అప్‌లోడ్ చేయవచ్చు!

<Tip>

⚠️ Hugging Face హబ్ కేవలం Transformer మోడల్స్ కి మాత్రమే పరిమితం కాదు. ఎవరైనా ఏ రకమైన మోడల్స్ లేదా డేటాసెట్స్‌ను అయినా పంచుకోవచ్చు! అందుబాటులో ఉన్న అన్ని ఫీచర్ల నుండి ప్రయోజనం పొందడానికి <a href="https://huggingface.co/join">huggingface.co ఖాతాను సృష్టించుకోండి</a>!

</Tip>

Transformer మోడల్స్ తెర వెనుక ఎలా పనిచేస్తాయో లోతుగా పరిశీలించే ముందు, కొన్ని ఆసక్తికరమైన NLP సమస్యలను పరిష్కరించడానికి అవి ఎలా ఉపయోగించబడతాయో కొన్ని ఉదాహరణలు చూద్దాం.

## పైప్‌లైన్‌లతో పని చేయడం[[working-with-pipelines]]

<Youtube id="tiZFewofSLM" />

🤗 Transformers లైబ్రరీలోని అత్యంత ప్రాథమిక వస్తువు `pipeline()` ఫంక్షన్. ఇది ఒక మోడల్‌ను దాని అవసరమైన ప్రిప్రాసెసింగ్ మరియు పోస్ట్ ప్రాసెసింగ్ దశలతో కలుపుతుంది, తద్వారా మనం నేరుగా ఏదైనా టెక్స్ట్‌ను ఇన్పుట్ చేసి అర్థవంతమైన సమాధానాన్ని పొందవచ్చు:

```python
from transformers import pipeline

classifier = pipeline("sentiment-analysis")
classifier("I've been waiting for a HuggingFace course my whole life.")
```

```python out
[{'label': 'POSITIVE', 'score': 0.9598047137260437}]
```

మనం అనేక వాక్యాలను కూడా పంపవచ్చు!

```python
classifier(
    ["I've been waiting for a HuggingFace course my whole life.", "I hate this so much!"]
)
```

```python out
[{'label': 'POSITIVE', 'score': 0.9598047137260437},
 {'label': 'NEGATIVE', 'score': 0.9994558095932007}]
```

డిఫాల్ట్‌గా, ఈ పైప్‌లైన్ ఇంగ్లీష్‌లో సెంటిమెంట్ విశ్లేషణ కోసం ఫైన్-ట్యూన్ చేయబడిన ఒక నిర్దిష్ట ప్రీ-ట్రైన్డ్ మోడల్‌ను ఎంచుకుంటుంది. మీరు `classifier` ఆబ్జెక్ట్‌ను సృష్టించినప్పుడు మోడల్ డౌన్‌లోడ్ చేయబడి కాష్ చేయబడుతుంది. మీరు ఆదేశాన్ని మళ్లీ అమలు చేస్తే, కాష్ చేయబడిన మోడల్ ఉపయోగించబడుతుంది మరియు మోడల్‌ను మళ్లీ డౌన్‌లోడ్ చేయాల్సిన అవసరం లేదు.

మీరు కొన్ని టెక్స్ట్‌ను పైప్‌లైన్‌కు పంపినప్పుడు మూడు ప్రధాన దశలు ఉంటాయి:

1. మోడల్ అర్థం చేసుకోగల ఫార్మాట్‌లోకి టెక్స్ట్ ప్రిప్రాసెస్ చేయబడుతుంది.
2. ప్రిప్రాసెస్ చేయబడిన ఇన్‌పుట్‌లు మోడల్‌కు పంపబడతాయి.
3. మోడల్ యొక్క అంచనాలు పోస్ట్-ప్రాసెస్ చేయబడతాయి, తద్వారా మీరు వాటిని అర్థం చేసుకోవచ్చు.

## వివిధ మాధ్యమాల కోసం అందుబాటులో ఉన్న పైప్‌లైన్‌లు

`pipeline()` ఫంక్షన్ బహుళ మాధ్యమాలను సపోర్ట్ చేస్తుంది, టెక్స్ట్, చిత్రాలు, ఆడియో మరియు మల్టీమోడల్ పనులతో కూడా పని చేయడానికి మిమ్మల్ని అనుమతిస్తుంది. ఈ కోర్సులో మనం టెక్స్ట్ పనులపై దృష్టి పెడతాము, కానీ ట్రాన్స్‌ఫార్మర్ ఆర్కిటెక్చర్ యొక్క సామర్థ్యాన్ని అర్థం చేసుకోవడం ఉపయోగకరం, కాబట్టి మనం దానిని క్లుప్తంగా వివరిస్తాము.

ఇక్కడ అందుబాటులో ఉన్న వాటి యొక్క స్థూలదృష్టి ఉంది:

<Tip>

పైప్‌లైన్‌ల పూర్తి మరియు నవీకరించబడిన జాబితా కోసం, [🤗 Transformers డాక్యుమెంటేషన్](https://huggingface.co/docs/hub/en/models-tasks) ను చూడండి.

</Tip>

### టెక్స్ట్ పైప్‌లైన్‌లు

- `text-generation`: ఒక ప్రాంప్ట్ నుండి టెక్స్ట్‌ను రూపొందించడం
- `text-classification`: టెక్స్ట్‌ను ముందుగా నిర్వచించిన వర్గాలలోకి వర్గీకరించడం
- `summarization`: ముఖ్యమైన సమాచారాన్ని కాపాడుకుంటూ టెక్స్ట్ యొక్క చిన్న వెర్షన్‌ను సృష్టించడం
- `translation`: ఒక భాష నుండి మరొక భాషకు టెక్స్ట్‌ను అనువదించడం
- `zero-shot-classification`: నిర్దిష్ట లేబుల్స్‌పై ముందస్తు శిక్షణ లేకుండా టెక్స్ట్‌ను వర్గీకరించడం
- `feature-extraction`: టెక్స్ట్ యొక్క వెక్టర్ ప్రాతినిధ్యాలను సంగ్రహించడం

### చిత్ర పైప్‌లైన్‌లు

- `image-to-text`: చిత్రాల యొక్క టెక్స్ట్ వివరణలను రూపొందించడం
- `image-classification`: ఒక చిత్రంలోని వస్తువులను గుర్తించడం
- `object-detection`: చిత్రాలలో వస్తువులను గుర్తించి వాటి స్థానాన్ని కనుగొనడం

### ఆడియో పైప్‌లైన్‌లు

- `automatic-speech-recognition`: ప్రసంగాన్ని టెక్స్ట్‌గా మార్చడం
- `audio-classification`: ఆడియోను వర్గాలలోకి వర్గీకరించడం
- `text-to-speech`: టెక్స్ట్‌ను మాట్లాడే ఆడియోగా మార్చడం

### మల్టీమోడల్ పైప్‌లైన్‌లు

- `image-text-to-text`: ఒక టెక్స్ట్ ప్రాంప్ట్ ఆధారంగా చిత్రానికి ప్రతిస్పందించడం

ఈ పైప్‌లైన్‌లలో కొన్నింటిని మరింత వివరంగా అన్వేషిద్దాం!

## జీరో-షాట్ క్లాసిఫికేషన్[[zero-shot-classification]]

లేబుల్ చేయని టెక్స్ట్‌లను వర్గీకరించాల్సిన మరింత సవాలుతో కూడిన పనితో ప్రారంభిద్దాం. ఇది వాస్తవ ప్రపంచ ప్రాజెక్టులలో ఒక సాధారణ దృశ్యం ఎందుకంటే టెక్స్ట్‌ను వ్యాఖ్యానించడం సాధారణంగా సమయం తీసుకుంటుంది మరియు డొమైన్ నైపుణ్యం అవసరం. ఈ వినియోగ సందర్భం కోసం, `zero-shot-classification` పైప్‌లైన్ చాలా శక్తివంతమైనది: ఇది వర్గీకరణ కోసం ఏ లేబుల్స్ ఉపయోగించాలో నిర్దేశించడానికి మిమ్మల్ని అనుమతిస్తుంది, కాబట్టి మీరు ముందుగా శిక్షణ పొందిన మోడల్ యొక్క లేబుల్స్‌పై ఆధారపడాల్సిన అవసరం లేదు. మోడల్ ఆ రెండు లేబుల్స్ ఉపయోగించి ఒక వాక్యాన్ని పాజిటివ్ లేదా నెగటివ్‌గా ఎలా వర్గీకరించగలదో మీరు ఇప్పటికే చూశారు — కానీ ఇది మీకు నచ్చిన ఏ ఇతర లేబుల్స్ సెట్‌ను ఉపయోగించి కూడా టెక్స్ట్‌ను వర్గీకరించగలదు.

```python
from transformers import pipeline

classifier = pipeline("zero-shot-classification")
classifier(
    "This is a course about the Transformers library",
    candidate_labels=["education", "politics", "business"],
)
```

```python out
{'sequence': 'This is a course about the Transformers library',
 'labels': ['education', 'business', 'politics'],
 'scores': [0.8445963859558105, 0.111976258456707, 0.043427448719739914]}
```

ఈ పైప్‌లైన్‌ను _జీరో-షాట్_ అని అంటారు ఎందుకంటే దాన్ని ఉపయోగించడానికి మీరు మీ డేటాపై మోడల్‌ను ఫైన్-ట్యూన్ చేయాల్సిన అవసరం లేదు. ఇది మీకు కావలసిన లేబుల్స్ జాబితా కోసం నేరుగా సంభావ్యత స్కోర్‌లను తిరిగి ఇవ్వగలదు!

<Tip>

✏️ **ప్రయత్నించి చూడండి!** మీ స్వంత సీక్వెన్సులు మరియు లేబుల్స్‌తో ఆడుకోండి మరియు మోడల్ ఎలా ప్రవర్తిస్తుందో చూడండి.

</Tip>

## టెక్స్ట్ జనరేషన్[[text-generation]]

ఇప్పుడు కొన్ని టెక్స్ట్‌ను రూపొందించడానికి పైప్‌లైన్‌ను ఎలా ఉపయోగించాలో చూద్దాం. ఇక్కడ ప్రధాన ఆలోచన ఏమిటంటే మీరు ఒక ప్రాంప్ట్ అందిస్తారు మరియు మోడల్ మిగిలిన టెక్స్ట్‌ను రూపొందించడం ద్వారా దానిని స్వయంచాలకంగా పూర్తి చేస్తుంది. ఇది అనేక ఫోన్‌లలో కనిపించే ప్రిడిక్టివ్ టెక్స్ట్ ఫీచర్‌కు సమానంగా ఉంటుంది. టెక్స్ట్ జనరేషన్ యాదృచ్ఛికతను కలిగి ఉంటుంది, కాబట్టి క్రింద చూపిన ఫలితాలు మీకు లభించకపోవడం సాధారణం.

```python
from transformers import pipeline

generator = pipeline("text-generation")
generator("In this course, we will teach you how to")
```

```python out
[{'generated_text': 'In this course, we will teach you how to understand and use '
                    'data flow and data interchange when handling user data. We '
                    'will be working with one or more of the most commonly used '
                    'data flows — data flows of various types, as seen by the '
                    'HTTP'}]
```

మీరు `num_return_sequences` ఆర్గ్యుమెంట్‌తో ఎన్ని వేర్వేరు సీక్వెన్సులను రూపొందించాలో మరియు `max_length` ఆర్గ్యుమెంట్‌తో అవుట్‌పుట్ టెక్స్ట్ యొక్క మొత్తం పొడవును నియంత్రించవచ్చు.

<Tip>

✏️ **ప్రయత్నించి చూడండి!** `num_return_sequences` మరియు `max_length` ఆర్గ్యుమెంట్‌లను ఉపయోగించి 15 పదాల పొడవు గల రెండు వాక్యాలను రూపొందించండి.

</Tip>

## హబ్ నుండి ఏ మోడల్‌నైనా పైప్‌లైన్‌లో ఉపయోగించడం[[using-any-model-from-the-hub-in-a-pipeline]]

మునుపటి ఉదాహరణలు పని కోసం డిఫాల్ట్ మోడల్‌ను ఉపయోగించాయి, కానీ మీరు ఒక నిర్దిష్ట పని కోసం పైప్‌లైన్‌లో ఉపయోగించడానికి హబ్ నుండి ఒక నిర్దిష్ట మోడల్‌ను కూడా ఎంచుకోవచ్చు — ఉదాహరణకు, టెక్స్ట్ జనరేషన్. [మోడల్ హబ్](https://huggingface.co/models) కు వెళ్లి, ఆ పని కోసం మద్దతు ఉన్న మోడల్స్‌ను మాత్రమే ప్రదర్శించడానికి ఎడమవైపున ఉన్న సంబంధిత ట్యాగ్‌పై క్లిక్ చేయండి. మీరు [ఈ పేజీ](https://huggingface.co/models?pipeline_tag=text-generation)のようなページにたどり着くはずです.

[`HuggingFaceTB/SmolLM2-360M`](https://huggingface.co/HuggingFaceTB/SmolLM2-360M) మోడల్‌ను ప్రయత్నిద్దాం! మునుపటి పైప్‌లైన్‌లో దాన్ని ఎలా లోడ్ చేయాలో ఇక్కడ ఉంది:

```python
from transformers import pipeline

generator = pipeline("text-generation", model="HuggingFaceTB/SmolLM2-360M")
generator(
    "In this course, we will teach you how to",
    max_length=30,
    num_return_sequences=2,
)
```

```python out
[{'generated_text': 'In this course, we will teach you how to manipulate the world and '
                    'move your mental and physical capabilities to your advantage.'},
 {'generated_text': 'In this course, we will teach you how to become an expert and '
                    'practice realtime, and with a hands on experience on both real '
                    'time and real'}]
```

మీరు భాషా ట్యాగ్‌లపై క్లిక్ చేయడం ద్వారా మోడల్ కోసం మీ శోధనను మెరుగుపరచవచ్చు మరియు మరొక భాషలో టెక్స్ట్‌ను రూపొందించే మోడల్‌ను ఎంచుకోవచ్చు. మోడల్ హబ్ అనేక భాషలకు మద్దతు ఇచ్చే బహుభాషా మోడల్స్ కోసం చెక్‌పాయింట్లను కూడా కలిగి ఉంది.

మీరు దానిపై క్లిక్ చేయడం ద్వారా ఒక మోడల్‌ను ఎంచుకున్న తర్వాత, దాన్ని నేరుగా ఆన్‌లైన్‌లో ప్రయత్నించడానికి ఒక విడ్జెట్ ఉందని మీరు చూస్తారు. ఈ విధంగా మీరు మోడల్‌ను డౌన్‌లోడ్ చేయడానికి ముందు దాని సామర్థ్యాలను త్వరగా పరీక్షించవచ్చు.

<Tip>

✏️ **ప్రయత్నించి చూడండి!** మరొక భాష కోసం టెక్స్ట్ జనరేషన్ మోడల్‌ను కనుగొనడానికి ఫిల్టర్‌లను ఉపయోగించండి. విడ్జెట్‌తో ఆడుకోవడానికి సంకోచించకండి మరియు దానిని పైప్‌లైన్‌లో ఉపయోగించండి!

</Tip>

### ఇన్ఫరెన్స్ ప్రొవైడర్లు[[inference-providers]]

అన్ని మోడల్స్‌ను Hugging Face [వెబ్‌సైట్](https://huggingface.co/docs/inference-providers/en/index) లో అందుబాటులో ఉన్న ఇన్ఫరెన్స్ ప్రొవైడర్ల ద్వారా మీ బ్రౌజర్ ద్వారా నేరుగా పరీక్షించవచ్చు. మీరు కస్టమ్ టెక్స్ట్‌ను ఇన్‌పుట్ చేసి మరియు మోడల్ ఇన్‌పుట్ డేటాను ప్రాసెస్ చేయడాన్ని చూడటం ద్వారా ఈ పేజీలో నేరుగా మోడల్‌తో ఆడవచ్చు.

విడ్జెట్‌ను శక్తివంతం చేసే ఇన్ఫరెన్స్ ప్రొవైడర్లు చెల్లింపు ఉత్పత్తిగా కూడా అందుబాటులో ఉన్నాయి, ఇది మీ వర్క్‌ఫ్లోల కోసం అవసరమైతే ఉపయోగపడుతుంది. మరిన్ని వివరాల కోసం [ధరల పేజీ](https://huggingface.co/docs/inference-providers/en/pricing)ని చూడండి.

## మాస్క్ ఫిల్లింగ్[[mask-filling]]

మీరు ప్రయత్నించే తదుపరి పైప్‌లైన్ `fill-mask`. ఈ పని యొక్క ఆలోచన ఇచ్చిన టెక్స్ట్‌లోని ఖాళీలను పూరించడం:

```python
from transformers import pipeline

unmasker = pipeline("fill-mask")
unmasker("This course will teach you all about <mask> models.", top_k=2)
```

```python out
[{'sequence': 'This course will teach you all about mathematical models.',
  'score': 0.19619831442832947,
  'token': 30412,
  'token_str': ' mathematical'},
 {'sequence': 'This course will teach you all about computational models.',
  'score': 0.04052725434303284,
  'token': 38163,
  'token_str': ' computational'}]
```

`top_k` ఆర్గ్యుమెంట్ మీరు ఎన్ని అవకాశాలను ప్రదర్శించాలనుకుంటున్నారో నియంత్రిస్తుంది. ఇక్కడ మోడల్ ప్రత్యేక `<mask>` పదాన్ని నింపుతుందని గమనించండి, దీనిని తరచుగా _మాస్క్ టోకెన్_ అని అంటారు. ఇతర మాస్క్-ఫిల్లింగ్ మోడల్స్ వేర్వేరు మాస్క్ టోకెన్‌లను కలిగి ఉండవచ్చు, కాబట్టి ఇతర మోడల్స్‌ను అన్వేషించేటప్పుడు సరైన మాస్క్ పదాన్ని ధృవీకరించడం ఎల్లప్పుడూ మంచిది. దానిని తనిఖీ చేయడానికి ఒక మార్గం విడ్జెట్‌లో ఉపయోగించిన మాస్క్ పదాన్ని చూడటం.

<Tip>

✏️ **ప్రయత్నించి చూడండి!** హబ్‌లో `bert-base-cased` మోడల్ కోసం శోధించి మరియు ఇన్ఫరెన్స్ API విడ్జెట్‌లో దాని మాస్క్ పదాన్ని గుర్తించండి. మా `pipeline` ఉదాహరణలోని వాక్యానికి ఈ మోడల్ ఏమి అంచనా వేస్తుంది?

</Tip>

## నేమ్డ్ ఎంటిటీ రికగ్నిషన్[[named-entity-recognition]]

నేమ్డ్ ఎంటిటీ రికగ్నిషన్ (NER) అనేది ఒక పని, ఇక్కడ మోడల్ ఇన్‌పుట్ టెక్స్ట్‌లోని ఏ భాగాలు వ్యక్తులు, ప్రదేశాలు లేదా సంస్థల వంటి ఎంటిటీలకు సంబంధించినవో కనుగొనాలి. ఒక ఉదాహరణ చూద్దాం:

```python
from transformers import pipeline

ner = pipeline("ner", grouped_entities=True)
ner("My name is Sylvain and I work at Hugging Face in Brooklyn.")
```

```python out
[{'entity_group': 'PER', 'score': 0.99816, 'word': 'Sylvain', 'start': 11, 'end': 18},
 {'entity_group': 'ORG', 'score': 0.97960, 'word': 'Hugging Face', 'start': 33, 'end': 45},
 {'entity_group': 'LOC', 'score': 0.99321, 'word': 'Brooklyn', 'start': 49, 'end': 57}
]
```

ఇక్కడ మోడల్ సిల్వైన్ ఒక వ్యక్తి (PER), Hugging Face ఒక సంస్థ (ORG), మరియు బ్రూక్లిన్ ఒక ప్రదేశం (LOC) అని సరిగ్గా గుర్తించింది.

వాక్యంలోని ఒకే ఎంటిటీకి సంబంధించిన భాగాలను తిరిగి సమూహపరచమని పైప్‌లైన్‌కు చెప్పడానికి మేము పైప్‌లైన్ సృష్టి ఫంక్షన్‌లో `grouped_entities=True` ఎంపికను పాస్ చేస్తాము: ఇక్కడ మోడల్ "Hugging" మరియు "Face" ను ఒకే సంస్థగా సరిగ్గా సమూహపరిచింది, పేరు అనేక పదాలతో ఉన్నప్పటికీ. నిజానికి, మనం తదుపరి అధ్యాయంలో చూస్తాము, ప్రిప్రాసెసింగ్ కొన్ని పదాలను చిన్న భాగాలుగా కూడా విభజిస్తుంది. ఉదాహరణకు, `Sylvain` ను నాలుగు ముక్కలుగా విభజించారు: `S`, `##yl`, `##va`, మరియు `##in`. పోస్ట్-ప్రాసెసింగ్ దశలో, పైప్‌లైన్ ఆ ముక్కలను విజయవంతంగా తిరిగి సమూహపరిచింది.

<Tip>

✏️ **ప్రయత్నించి చూడండి!** ఇంగ్లీషులో పార్ట్-ఆఫ్-స్పీచ్ ట్యాగింగ్ (సాధారణంగా POS అని సంక్షిప్తం) చేయగల మోడల్ కోసం మోడల్ హబ్‌ను శోధించండి. పై ఉదాహరణలోని వాక్యానికి ఈ మోడల్ ఏమి అంచనా వేస్తుంది?

</Tip>

## ప్రశ్న సమాధానం[[question-answering]]

`question-answering` పైప్‌లైన్ ఇచ్చిన సందర్భం నుండి సమాచారాన్ని ఉపయోగించి ప్రశ్నలకు సమాధానమిస్తుంది:

```python
from transformers import pipeline

question_answerer = pipeline("question-answering")
question_answerer(
    question="Where do I work?",
    context="My name is Sylvain and I work at Hugging Face in Brooklyn",
)
```

```python out
{'score': 0.6385916471481323, 'start': 33, 'end': 45, 'answer': 'Hugging Face'}
```

ఈ పైప్‌లైన్ అందించిన సందర్భం నుండి సమాచారాన్ని సంగ్రహించడం ద్వారా పనిచేస్తుందని గమనించండి; ఇది సమాధానాన్ని రూపొందించదు.

## సారాంశీకరణ[[summarization]]

సారాంశీకరణ అనేది టెక్స్ట్‌లో ప్రస్తావించిన అన్ని (లేదా చాలా) ముఖ్యమైన అంశాలను ఉంచుతూ టెక్స్ట్‌ను చిన్న టెక్స్ట్‌గా తగ్గించడం. ఇక్కడ ఒక ఉదాహరణ ఉంది:

```python
from transformers import pipeline

summarizer = pipeline("summarization")
summarizer(
    """
    America has changed dramatically during recent years. Not only has the number of
    graduates in traditional engineering disciplines such as mechanical, civil,
    electrical, chemical, and aeronautical engineering declined, but in most of
    the premier American universities engineering curricula now concentrate on
    and encourage largely the study of engineering science. As a result, there
    are declining offerings in engineering subjects dealing with infrastructure,
    the environment, and related issues, and greater concentration on high
    technology subjects, largely supporting increasingly complex scientific
    developments. While the latter is important, it should not be at the expense
    of more traditional engineering.

    Rapidly developing economies such as China and India, as well as other
    industrial countries in Europe and Asia, continue to encourage and advance
    the teaching of engineering. Both China and India, respectively, graduate
    six and eight times as many traditional engineers as does the United States.
    Other industrial countries at minimum maintain their output, while America
    suffers an increasingly serious decline in the number of engineering graduates
    and a lack of well-educated engineers.
"""
)
```

```python out
[{'summary_text': ' America has changed dramatically during recent years . The '
                  'number of engineering graduates in the U.S. has declined in '
                  'traditional engineering disciplines such as mechanical, civil '
                  ', electrical, chemical, and aeronautical engineering . Rapidly '
                  'developing economies such as China and India, as well as other '
                  'industrial countries in Europe and Asia, continue to encourage '
                  'and advance engineering .'}]
```

టెక్స్ట్ జనరేషన్ లాగే, మీరు ఫలితం కోసం `max_length` లేదా `min_length` ను నిర్దేశించవచ్చు.

## అనువాదం[[translation]]

అనువాదం కోసం, మీరు టాస్క్ పేరులో ఒక భాషా జతను (ఉదాహరణకు `"translation_en_to_fr"`) అందిస్తే డిఫాల్ట్ మోడల్‌ను ఉపయోగించవచ్చు, కానీ సులభమైన మార్గం మీరు [మోడల్ హబ్](https://huggingface.co/models) లో ఉపయోగించాలనుకుంటున్న మోడల్‌ను ఎంచుకోవడం. ఇక్కడ మేము ఫ్రెంచ్ నుండి ఇంగ్లీష్‌లోకి అనువదించడానికి ప్రయత్నిస్తాము:

```python
from transformers import pipeline

translator = pipeline("translation", model="Helsinki-NLP/opus-mt-fr-en")
translator("Ce cours est produit par Hugging Face.")
```

```python out
[{'translation_text': 'This course is produced by Hugging Face.'}]
```

టెక్స్ట్ జనరేషన్ మరియు సారాంశీకరణ లాగే, మీరు ఫలితం కోసం `max_length` లేదా `min_length` ను నిర్దేశించవచ్చు.

<Tip>

✏️ **ప్రయత్నించి చూడండి!** ఇతర భాషలలో అనువాద మోడల్స్ కోసం శోధించి, మునుపటి వాక్యాన్ని కొన్ని వేర్వేరు భాషలలోకి అనువదించడానికి ప్రయత్నించండి.

</Tip>

## ఇమేజ్ మరియు ఆడియో పైప్‌లైన్‌లు

టెక్స్ట్‌తో పాటు, Transformer మోడల్స్ ఇమేజ్‌లు మరియు ఆడియోతో కూడా పనిచేయగలవు. ఇక్కడ కొన్ని ఉదాహరణలు ఉన్నాయి:

### ఇమేజ్ వర్గీకరణ

```python
from transformers import pipeline

image_classifier = pipeline(
    task="image-classification", model="google/vit-base-patch16-224"
)
result = image_classifier(
    "https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg"
)
print(result)
```

```python out
[{'label': 'lynx, catamount', 'score': 0.43350091576576233},
 {'label': 'cougar, puma, catamount, mountain lion, painter, panther, Felis concolor',
  'score': 0.034796204417943954},
 {'label': 'snow leopard, ounce, Panthera uncia',
  'score': 0.03240183740854263},
 {'label': 'Egyptian cat', 'score': 0.02394474856555462},
 {'label': 'tiger cat', 'score': 0.02288915030658245}]
```

### ఆటోమేటిక్ స్పీచ్ రికగ్నిషన్

```python
from transformers import pipeline

transcriber = pipeline(
    task="automatic-speech-recognition", model="openai/whisper-large-v3"
)
result = transcriber(
    "https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac"
)
print(result)
```

```python out
{'text': ' I have a dream that one day this nation will rise up and live out the true meaning of its creed.'}
```

## బహుళ మూలాల నుండి డేటాను కలపడం

Transformer మోడల్స్ యొక్క ఒక శక్తివంతమైన అప్లికేషన్ వాటికి బహుళ మూలాల నుండి డేటాను కలపడం మరియు ప్రాసెస్ చేసే సామర్థ్యం. ఇది మీకు అవసరమైనప్పుడు ప్రత్యేకంగా ఉపయోగపడుతుంది:

1. బహుళ డేటాబేస్‌లు లేదా రిపోజిటరీలలో శోధించడం
2. విభిన్న ఫార్మాట్ల నుండి సమాచారాన్ని ఏకీకృతం చేయడం (టెక్స్ట్, చిత్రాలు, ఆడియో)
3. సంబంధిత సమాచారం యొక్క ఏకీకృత వీక్షణను సృష్టించడం

ఉదాహరణకు, మీరు ఒక సిస్టమ్‌ను నిర్మించవచ్చు:

- టెక్స్ట్ మరియు ఇమేజ్ వంటి బహుళ మాధ్యమాలలో డేటాబేస్‌లలో సమాచారం కోసం శోధించడం.
- విభిన్న మూలాల నుండి ఫలితాలను ఒకే పొందికైన ప్రతిస్పందనగా కలపడం. ఉదాహరణకు, ఒక ఆడియో ఫైల్ మరియు టెక్స్ట్ వివరణ నుండి.
- పత్రాలు మరియు మెటాడేటా యొక్క డేటాబేస్ నుండి అత్యంత సంబంధిత సమాచారాన్ని ప్రదర్శించడం.

## ముగింపు

ఈ అధ్యాయంలో చూపిన పైప్‌లైన్‌లు చాలావరకు ప్రదర్శన ప్రయోజనాల కోసం. అవి నిర్దిష్ట పనుల కోసం ప్రోగ్రామ్ చేయబడ్డాయి మరియు వాటి వైవిధ్యాలను నిర్వహించలేవు. తదుపరి అధ్యాయంలో, మీరు `pipeline()` ఫంక్షన్ లోపల ఏమి ఉందో మరియు దాని ప్రవర్తనను ఎలా అనుకూలీకరించాలో నేర్చుకుంటారు.


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/te/chapter1/3.mdx" />