# ట్రాన్స్‌ఫార్మర్ ఆర్కిటెక్చర్లు[[transformer-architectures]]

మునుపటి విభాగాలలో, మేము సాధారణ Transformer ఆర్కిటెక్చర్‌ను పరిచయం చేసాము మరియు ఈ నమూనాలు వివిధ పనులను ఎలా పరిష్కరించగలవో అన్వేషించాము. ఇప్పుడు, Transformer నమూనాల యొక్క మూడు ప్రధాన నిర్మాణ వైవిధ్యాలను నిశితంగా పరిశీలిద్దాం మరియు ప్రతి ఒక్కటి ఎప్పుడు ఉపయోగించాలో అర్థం చేసుకుందాం. ఆపై, ఆ నిర్మాణాలు వేర్వేరు భాషా పనులకు ఎలా వర్తింపజేయబడతాయో చూశాము.

ఈ విభాగంలో, మేము Transformer నమూనాల యొక్క మూడు ప్రధాన నిర్మాణ వైవిధ్యాలను లోతుగా పరిశీలించబోతున్నాము మరియు ప్రతి ఒక్కటి ఎప్పుడు ఉపయోగించాలో అర్థం చేసుకుంటాము.

<Tip>

చాలా Transformer నమూనాలు మూడు నిర్మాణాలలో ఒకదాన్ని ఉపయోగిస్తాయని గుర్తుంచుకోండి: ఎన్‌కోడర్-మాత్రమే, డీకోడర్-మాత్రమే లేదా ఎన్‌కోడర్-డీకోడర్ (సీక్వెన్స్-టు-సీక్వెన్స్). ఈ తేడాలను అర్థం చేసుకోవడం మీ నిర్దిష్ట పనికి సరైన నమూనాను ఎంచుకోవడంలో మీకు సహాయపడుతుంది.

</Tip>

## ఎన్‌కోడర్ నమూనాలు[[encoder-models]]

<Youtube id="MUqNwgPjJvQ" />

ఎన్‌కోడర్ నమూనాలు Transformer నమూనా యొక్క ఎన్‌కోడర్‌ను మాత్రమే ఉపయోగిస్తాయి. ప్రతి దశలో, శ్రద్ధా పొరలు ప్రారంభ వాక్యంలోని అన్ని పదాలను యాక్సెస్ చేయగలవు. ఈ నమూనాలు తరచుగా "ద్విదిశాత్మక" శ్రద్ధను కలిగి ఉన్నాయని వర్గీకరించబడతాయి మరియు తరచుగా ఆటో-ఎన్‌కోడింగ్ నమూనాలు అని పిలువబడతాయి.

ఈ నమూనాల యొక్క ప్రీ-ట్రైనింగ్ సాధారణంగా ఇచ్చిన వాక్యాన్ని ఏదో ఒక విధంగా పాడు చేయడం (ఉదాహరణకు, యాదృచ్ఛిక పదాలను మాస్క్ చేయడం ద్వారా) మరియు ప్రారంభ వాక్యాన్ని కనుగొనడం లేదా పునర్నిర్మించడం నమూనా యొక్క పని.

వాక్య వర్గీకరణ, పేరున్న ఎంటిటీ గుర్తింపు (మరియు సాధారణంగా పద వర్గీకరణ), మరియు సంగ్రాహక ప్రశ్న-సమాధానం వంటి పూర్తి వాక్యం యొక్క అవగాహన అవసరమయ్యే పనులకు ఎన్‌కోడర్ నమూనాలు ఉత్తమంగా సరిపోతాయి.

<Tip>

[How 🤗 Transformers solve tasks](/chapter1/5), లో మనం చూసినట్లుగా, BERT వంటి ఎన్‌కోడర్ నమూనాలు టెక్స్ట్‌ను అర్థం చేసుకోవడంలో రాణిస్తాయి ఎందుకంటే అవి రెండు దిశలలోని మొత్తం సందర్భాన్ని చూడగలవు. ఇది మొత్తం ఇన్‌పుట్ యొక్క గ్రహణశక్తి ముఖ్యమైన పనులకు వాటిని పరిపూర్ణంగా చేస్తుంది.

</Tip>

ఈ నమూనాల కుటుంబం యొక్క ప్రతినిధులు:

- [BERT](https://huggingface.co/docs/transformers/model_doc/bert)
- [DistilBERT](https://huggingface.co/docs/transformers/model_doc/distilbert)
- [ModernBERT](https://huggingface.co/docs/transformers/en/model_doc/modernbert)

## డీకోడర్ నమూనాలు[[decoder-models]]

<Youtube id="d_ixlCubqQw" />

డీకోడర్ నమూనాలు Transformer నమూనా యొక్క డీకోడర్‌ను మాత్రమే ఉపయోగిస్తాయి. ప్రతి దశలో, ఇచ్చిన పదం కోసం శ్రద్ధా పొరలు వాక్యంలో దాని ముందు ఉన్న పదాలను మాత్రమే యాక్సెస్ చేయగలవు. ఈ నమూనాలను తరచుగా ఆటో-రిగ్రెసివ్ నమూనాలు అని పిలుస్తారు.

డీకోడర్ నమూనాల యొక్క ప్రీ-ట్రైనింగ్ సాధారణంగా వాక్యంలోని తదుపరి పదాన్ని అంచనా వేయడం చుట్టూ తిరుగుతుంది.

ఈ నమూనాలు టెక్స్ట్ జనరేషన్ వంటి పనులకు ఉత్తమంగా సరిపోతాయి.

<Tip>

GPT వంటి డీకోడర్ నమూనాలు ఒక సమయంలో ఒక టోకెన్‌ను అంచనా వేయడం ద్వారా టెక్స్ట్‌ను ఉత్పత్తి చేయడానికి రూపొందించబడ్డాయి. [How 🤗 Transformers solve tasks](/chapter1/5) లో మనం అన్వేషించినట్లుగా, అవి మునుపటి టోకెన్‌లను మాత్రమే చూడగలవు, ఇది సృజనాత్మక టెక్స్ట్ జనరేషన్‌కు వాటిని అద్భుతంగా చేస్తుంది కానీ ద్విదిశాత్మక అవగాహన అవసరమయ్యే పనులకు అంత ఆదర్శవంతంగా ఉండదు.

</Tip>

ఈ నమూనాల కుటుంబం యొక్క ప్రతినిధులు:

- [Hugging Face SmolLM Series](https://huggingface.co/HuggingFaceTB/SmolLM2-1.7B-Instruct)
- [Meta's Llama Series](https://huggingface.co/docs/transformers/en/model_doc/llama4)
- [Google's Gemma Series](https://huggingface.co/docs/transformers/main/en/model_doc/gemma3)
- [DeepSeek's V3](https://huggingface.co/deepseek-ai/DeepSeek-V3)

### ఆధునిక లార్జ్ లాంగ్వేజ్ మోడల్స్ (LLMలు)

చాలా ఆధునిక Large Language Models (LLMలు) డీకోడర్-మాత్రమే నిర్మాణాన్ని ఉపయోగిస్తాయి. ఈ నమూనాలు గత కొన్ని సంవత్సరాలుగా పరిమాణం మరియు సామర్థ్యాలలో నాటకీయంగా పెరిగాయి, అతిపెద్ద నమూనాలలో కొన్ని వందల బిలియన్ల పారామితులు ఉన్నాయి.

ఆధునిక LLMలు సాధారణంగా రెండు దశలలో శిక్షణ పొందుతాయి:

1. **ప్రీ-ట్రైనింగ్**: నమూనా విస్తారమైన టెక్స్ట్ డేటాపై తదుపరి టోకెన్‌ను అంచనా వేయడం నేర్చుకుంటుంది
2. **ఇన్‌స్ట్రక్షన్ ట్యూనింగ్**: నమూనా సూచనలను అనుసరించడానికి మరియు సహాయకరమైన ప్రతిస్పందనలను ఉత్పత్తి చేయడానికి ఫైన్-ట్యూన్ చేయబడుతుంది

ఈ విధానం అనేక రకాల అంశాలు మరియు పనులలో మానవ-లాంటి టెక్స్ట్‌ను అర్థం చేసుకుని, ఉత్పత్తి చేయగల నమూనాలకు దారితీసింది.

#### ఆధునిక LLMల యొక్క ముఖ్య సామర్థ్యాలు

ఆధునిక డీకోడర్-ఆధారిత LLMలు ఆకట్టుకునే సామర్థ్యాలను ప్రదర్శించాయి:

| సామర్థ్యం            | వివరణ                                               | ఉదాహరణ                                                   |
| -------------------- | --------------------------------------------------- | -------------------------------------------------------- |
| టెక్స్ట్ జనరేషన్     | పొందికైన మరియు సందర్భోచితమైన టెక్స్ట్‌ను సృష్టించడం | వ్యాసాలు, కథలు లేదా ఈమెయిల్‌లు రాయడం                     |
| సారాంశీకరణ           | పొడవైన పత్రాలను చిన్న వెర్షన్‌లుగా కుదించడం         | నివేదికల కార్యనిర్వాహక సారాంశాలను సృష్టించడం             |
| అనువాదం              | భాషల మధ్య టెక్స్ట్‌ను మార్చడం                       | ఇంగ్లీష్‌ను స్పానిష్‌లోకి అనువదించడం                     |
| ప్రశ్న-సమాధానం       | వాస్తవ ప్రశ్నలకు సమాధానాలు అందించడం                 | "ఫ్రాన్స్ రాజధాని ఏది?"                                  |
| కోడ్ జనరేషన్         | కోడ్ స్నిప్పెట్‌లను రాయడం లేదా పూర్తి చేయడం         | వివరణ ఆధారంగా ఒక ఫంక్షన్‌ను సృష్టించడం                   |
| తార్కికం (Reasoning) | సమస్యలను దశలవారీగా పరిష్కరించడం                     | గణిత సమస్యలు లేదా తార్కిక పజిల్స్‌ను పరిష్కరించడం        |
| ఫ్యూ-షాట్ లెర్నింగ్  | ప్రాంప్ట్‌లోని కొన్ని ఉదాహరణల నుండి నేర్చుకోవడం     | కేవలం 2-3 ఉదాహరణలు చూసిన తర్వాత టెక్స్ట్‌ను వర్గీకరించడం |

మీరు బ్రౌజర్‌లో నేరుగా హబ్‌లోని నమూనా రిపో పేజీల ద్వారా డీకోడర్-ఆధారిత LLMలతో ప్రయోగాలు చేయవచ్చు. ఇక్కడ క్లాసిక్ [GPT-2](https://huggingface.co/openai-community/gpt2) (OpenAI యొక్క అత్యుత్తమ ఓపెన్ సోర్స్ నమూనా!) తో ఒక ఉదాహరణ ఉంది:

<iframe
  src="https://huggingface.co/openai-community/gpt2"
  frameborder="0"
  width="100%"
  height="450"
></iframe>

## సీక్వెన్స్-టు-సీక్వెన్స్ నమూనాలు[[sequence-to-sequence-models]]

<Youtube id="0_4KEb08xrE" />

ఎన్‌కోడర్-డీకోడర్ నమూనాలు (సీక్వెన్స్-టు-సీక్వెన్స్ నమూనాలు అని కూడా పిలుస్తారు) Transformer నిర్మాణం యొక్క రెండు భాగాలను ఉపయోగిస్తాయి. ప్రతి దశలో, ఎన్‌కోడర్ యొక్క శ్రద్ధా పొరలు ప్రారంభ వాక్యంలోని అన్ని పదాలను యాక్సెస్ చేయగలవు, అయితే డీకోడర్ యొక్క శ్రద్ధా పొరలు ఇన్‌పుట్‌లో ఇచ్చిన పదం ముందు ఉన్న పదాలను మాత్రమే యాక్సెస్ చేయగలవు.

ఈ నమూనాల యొక్క ప్రీ-ట్రైనింగ్ వివిధ రూపాలను తీసుకోవచ్చు, కానీ ఇది తరచుగా ఇన్‌పుట్ ఏదో ఒక విధంగా పాడు చేయబడిన వాక్యాన్ని పునర్నిర్మించడం (ఉదాహరణకు యాదృచ్ఛిక పదాలను మాస్క్ చేయడం ద్వారా) ఉంటుంది. T5 నమూనా యొక్క ప్రీ-ట్రైనింగ్ యాదృచ్ఛిక టెక్స్ట్ స్పాన్‌లను (ఇవి అనేక పదాలను కలిగి ఉండవచ్చు) ఒకే మాస్క్ ప్రత్యేక టోకెన్‌తో భర్తీ చేయడం, మరియు అప్పుడు ఈ మాస్క్ టోకెన్ భర్తీ చేసే టెక్స్ట్‌ను అంచనా వేయడం పని.

సీక్వెన్స్-టు-సీక్వెన్స్ నమూనాలు సారాంశీకరణ, అనువాదం, లేదా సృజనాత్మక ప్రశ్న-సమాధానం వంటి ఇచ్చిన ఇన్‌పుట్‌పై ఆధారపడి కొత్త వాక్యాలను ఉత్పత్తి చేయడం చుట్టూ తిరిగే పనులకు ఉత్తమంగా సరిపోతాయి.

<Tip>

[How 🤗 Transformers solve tasks](/chapter1/5),లో మనం చూసినట్లుగా, BART మరియు T5 వంటి ఎన్‌కోడర్-డీకోడర్ నమూనాలు రెండు నిర్మాణాల యొక్క బలాలను మిళితం చేస్తాయి. ఎన్‌కోడర్ ఇన్‌పుట్ యొక్క లోతైన ద్విదిశాత్మక అవగాహనను అందిస్తుంది, అయితే డీకోడర్ తగిన అవుట్‌పుట్ టెక్స్ట్‌ను ఉత్పత్తి చేస్తుంది. ఇది ఒక సీక్వెన్స్‌ను మరొకదానికి మార్చే పనులకు, అనువాదం లేదా సారాంశీకరణ వంటి వాటికి వాటిని పరిపూర్ణంగా చేస్తుంది.

</Tip>

### ఆచరణాత్మక అనువర్తనాలు

సీక్వెన్స్-టు-సీక్వెన్స్ నమూనాలు అర్థాన్ని కాపాడుకుంటూ ఒక రూపంలోని టెక్స్ట్‌ను మరొక రూపంలోకి మార్చాల్సిన పనులలో రాణిస్తాయి. కొన్ని ఆచరణాత్మక అనువర్తనాలు:

| అనువర్తనం                | వివరణ                                           | ఉదాహరణ నమూనా |
| ------------------------ | ----------------------------------------------- | ------------ |
| యంత్ర అనువాదం            | భాషల మధ్య టెక్స్ట్‌ను మార్చడం                   | Marian, T5   |
| టెక్స్ట్ సారాంశీకరణ      | పొడవైన టెక్స్ట్‌ల క్లుప్త సారాంశాలను సృష్టించడం | BART, T5     |
| డేటా-టు-టెక్స్ట్ జనరేషన్ | నిర్మాణాత్మక డేటాను సహజ భాషలోకి మార్చడం         | T5           |
| వ్యాకరణ దిద్దుబాటు       | టెక్స్ట్‌లోని వ్యాకరణ దోషాలను సరిచేయడం          | T5           |

ఈ నమూనాల కుటుంబం యొక్క ప్రతినిధులు:

<iframe
  src="https://course-demos-speech-to-speech-translation.hf.space"
  frameborder="0"
  width="850"
  height="450"
></iframe>

Representatives of this family of models include:

- [BART](https://huggingface.co/docs/transformers/model_doc/bart)
- [mBART](https://huggingface.co/docs/transformers/model_doc/mbart)
- [Marian](https://huggingface.co/docs/transformers/model_doc/marian)
- [T5](https://huggingface.co/docs/transformers/model_doc/t5)

## సరైన నిర్మాణాన్ని ఎంచుకోవడం[[choosing-the-right-architecture]]

ఒక నిర్దిష్ట NLP పనిలో పనిచేస్తున్నప్పుడు, మీరు ఏ నిర్మాణాన్ని ఉపయోగించాలో ఎలా నిర్ణయిస్తారు? ఇక్కడ ఒక శీఘ్ర మార్గదర్శి ఉంది:

| పని                                  | సూచించిన నిర్మాణం          | ఉదాహరణలు      |
| ------------------------------------ | -------------------------- | ------------- |
| టెక్స్ట్ వర్గీకరణ (భావోద్వేగం, అంశం) | Encoder                    | BERT, RoBERTa |
| టెక్స్ట్ ఉత్పత్తి (సృజనాత్మక రచన)    | Decoder                    | GPT, LLaMA    |
| అనువాదం                              | Encoder-Decoder            | T5, BART      |
| సంక్షిప్తీకరణ                        | Encoder-Decoder            | BART, T5      |
| పేరుతో గుర్తింపు                     | Encoder                    | BERT, RoBERTa |
| ప్రశ్నలకు సమాధానం (ఎక్స్‌ట్రాక్టివ్) | Encoder                    | BERT, RoBERTa |
| ప్రశ్నలకు సమాధానం (జనరేటివ్)         | Encoder-Decoder or Decoder | T5, GPT       |
| సంభాషణ AI                            | Decoder                    | GPT, LLaMA    |

<Tip>

ఏ నమూనాను ఉపయోగించాలో సందేహంలో ఉన్నప్పుడు, పరిగణించండి:

1. మీ పనికి ఎలాంటి అవగాహన అవసరం? (ద్విదిశాత్మక లేదా ఏకదిశాత్మక)
2. మీరు కొత్త టెక్స్ట్‌ను ఉత్పత్తి చేస్తున్నారా లేదా ఉన్న టెక్స్ట్‌ను విశ్లేషిస్తున్నారా?
3. మీరు ఒక సీక్వెన్స్‌ను మరొకదానికి మార్చాల్సిన అవసరం ఉందా?

ఈ ప్రశ్నలకు సమాధానాలు మిమ్మల్ని సరైన నిర్మాణం వైపు నడిపిస్తాయి.

</Tip>

## LLMల పరిణామం

పెద్ద భాషా నమూనాలు ఇటీవలి సంవత్సరాలలో వేగంగా అభివృద్ధి చెందాయి, ప్రతి తరం సామర్థ్యాలలో గణనీయమైన మెరుగుదలలను తీసుకువచ్చింది.

## అటెన్షన్ మెకానిజమ్స్[[attention-mechanisms]]

చాలా ట్రాన్స్‌ఫార్మర్ నమూనాలు పూర్తి శ్రద్ధను ఉపయోగిస్తాయి, అంటే శ్రద్ధా మాత్రిక చతురస్రాకారంలో ఉంటుంది. మీకు పొడవైన టెక్స్ట్‌లు ఉన్నప్పుడు ఇది ఒక పెద్ద గణన అవరోధంగా ఉంటుంది. లాంగ్‌ఫార్మర్ మరియు రిఫార్మర్ అనే నమూనాలు మరింత సమర్థవంతంగా ఉండటానికి ప్రయత్నిస్తాయి మరియు శిక్షణను వేగవంతం చేయడానికి శ్రద్ధా మాత్రిక యొక్క స్పాన్ వెర్షన్‌ను ఉపయోగిస్తాయి.

<Tip>

ప్రామాణిక శ్రద్ధా యంత్రాంగాలు O(n²) యొక్క గణన సంక్లిష్టతను కలిగి ఉంటాయి, ఇక్కడ n సీక్వెన్స్ పొడవు. చాలా పొడవైన సీక్వెన్స్‌లకు ఇది సమస్యాత్మకంగా మారుతుంది. కింద పేర్కొన్న ప్రత్యేక శ్రద్ధా యంత్రాంగాలు ఈ పరిమితిని పరిష్కరించడంలో సహాయపడతాయి.

</Tip>

### LSH అటెన్షన్

[Reformer](https://huggingface.co/docs/transformers/model_doc/reformer) LSH అటెన్షన్ ఉపయోగిస్తుంది. సాఫ్ట్‌మాక్స్(QK^t)లో, మాత్రిక QK^t యొక్క అతిపెద్ద అంశాలు మాత్రమే (సాఫ్ట్‌మాక్స్ డైమెన్షన్‌లో) ఉపయోగకరమైన సహకారం అందిస్తాయి. కాబట్టి Q లోని ప్రతి క్వెరీ q కోసం, మనం K లో q కు దగ్గరగా ఉన్న కీలను మాత్రమే పరిగణించవచ్చు. q మరియు k దగ్గరగా ఉన్నాయో లేదో నిర్ధారించడానికి ఒక హాష్ ఫంక్షన్ ఉపయోగించబడుతుంది. ప్రస్తుత టోకెన్‌ను మాస్క్ చేయడానికి శ్రద్ధా మాస్క్ సవరించబడింది (మొదటి స్థానంలో తప్ప), ఎందుకంటే ఇది సమానమైన క్వెరీ మరియు కీని ఇస్తుంది (కాబట్టి ఒకదానికొకటి చాలా పోలి ఉంటుంది). హాష్ కొంచెం యాదృచ్ఛికంగా ఉండగలదు కాబట్టి, ఆచరణలో అనేక హాష్ ఫంక్షన్లు ఉపయోగించబడతాయి (n_rounds పారామితి ద్వారా నిర్ధారించబడతాయి) మరియు తరువాత అవి సగటు చేయబడతాయి.

### లోకల్ అటెన్షన్

[Longformer](https://huggingface.co/docs/transformers/model_doc/longformer) స్థానిక శ్రద్ధను ఉపయోగిస్తుంది: తరచుగా, స్థానిక సందర్భం (ఉదా., ఎడమ మరియు కుడి వైపున ఉన్న రెండు టోకెన్‌లు ఏమిటి?) ఒక నిర్దిష్ట టోకెన్ కోసం చర్య తీసుకోవడానికి సరిపోతుంది. అలాగే, చిన్న విండో ఉన్న శ్రద్ధా పొరలను పేర్చడం ద్వారా, చివరి పొర కేవలం విండోలోని టోకెన్‌ల కంటే ఎక్కువ గ్రహణ క్షేత్రాన్ని కలిగి ఉంటుంది, ఇది మొత్తం వాక్యం యొక్క ప్రాతినిధ్యాన్ని నిర్మించడానికి వీలు కల్పిస్తుంది.

కొన్ని ముందుగా ఎంచుకున్న ఇన్‌పుట్ టోకెన్‌లకు గ్లోబల్ అటెన్షన్ కూడా ఇవ్వబడుతుంది: ఆ కొన్ని టోకెన్‌ల కోసం, శ్రద్ధా మాత్రిక అన్ని టోకెన్‌లను యాక్సెస్ చేయగలదు మరియు ఈ ప్రక్రియ సుష్టంగా ఉంటుంది: అన్ని ఇతర టోకెన్‌లు ఆ నిర్దిష్ట టోకెన్‌లకు యాక్సెస్ కలిగి ఉంటాయి (వాటి స్థానిక విండోలోని వాటితో పాటు). ఇది పేపర్‌లోని ఫిగర్ 2డిలో చూపబడింది, ఒక నమూనా శ్రద్ధా మాస్క్ కోసం కింద చూడండి:

<div class="flex justify-center">
  <img
    scale="50 %"
    align="center"
    src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/local_attention_mask.png"
  />
</div>

తక్కువ పారామితులతో ఆ Attention matrix ఉపయోగించడం వలన నమూనా పెద్ద సీక్వెన్స్ పొడవు ఉన్న ఇన్‌పుట్‌లను కలిగి ఉండటానికి వీలు కల్పిస్తుంది.

### యాక్సియల్ పొజిషనల్ ఎన్‌కోడింగ్స్

[Reformer](https://huggingface.co/docs/transformers/model_doc/reformer) యాక్సియల్ పొజిషనల్ ఎన్‌కోడింగ్‌లను ఉపయోగిస్తుంది: సాంప్రదాయ ట్రాన్స్‌ఫార్మర్ నమూనాలలో, పొజిషనల్ ఎన్‌కోడింగ్ E అనేది \(l\) బై \(d\) పరిమాణంలో ఒక మాత్రిక, ఇక్కడ \(l\) సీక్వెన్స్ పొడవు మరియు \(d\) దాగి ఉన్న స్థితి యొక్క డైమెన్షన్. మీకు చాలా పొడవైన టెక్స్ట్‌లు ఉంటే, ఈ మాత్రిక చాలా పెద్దదిగా ఉండవచ్చు మరియు GPUలో చాలా ఎక్కువ స్థలాన్ని తీసుకుంటుంది. దానిని తగ్గించడానికి, యాక్సియల్ పొజిషనల్ ఎన్‌కోడింగ్‌లు ఆ పెద్ద మాత్రిక E ని రెండు చిన్న మాత్రికలు E1 మరియు E2 గా విభజించడం, వాటి డైమెన్షన్లు \(l*{1} \times d*{1}\) మరియు \(l*{2} \times d*{2}\), ఇక్కడ \(l*{1} \times l*{2} = l\) మరియు \(d*{1} + d*{2} = d\) (పొడవుల కోసం గుణకారంతో, ఇది చాలా చిన్నదిగా ముగుస్తుంది). E లో సమయ దశ \(j\) కోసం ఎంబెడ్డింగ్ E1 లో సమయ దశ \(j % l1\) మరియు E2 లో \(j // l1\) కోసం ఎంబెడ్డింగ్‌లను కలపడం ద్వారా పొందబడుతుంది.

## ముగింపు[[conclusion]]

ఈ విభాగంలో, మేము మూడు ప్రధాన Transformer నిర్మాణాలను మరియు కొన్ని ప్రత్యేక శ్రద్ధా యంత్రాంగాలను అన్వేషించాము. మీ నిర్దిష్ట NLP పని కోసం సరైన నమూనాను ఎంచుకోవడానికి ఈ నిర్మాణ తేడాలను అర్థం చేసుకోవడం చాలా ముఖ్యం.

కోర్సులో మనం ముందుకు సాగుతున్నప్పుడు, మీరు ఈ విభిన్న నిర్మాణాలతో ప్రత్యక్ష అనుభవాన్ని పొందుతారు మరియు మీ నిర్దిష్ట అవసరాలకు వాటిని ఎలా ఫైన్-ట్యూన్ చేయాలో నేర్చుకుంటారు. తదుపరి విభాగంలో, మనం ఈ నమూనాలలో ఉన్న కొన్ని పరిమితులు మరియు పక్షపాతాలను పరిశీలిస్తాము, వాటిని అమలు చేస్తున్నప్పుడు మీరు తెలుసుకోవాలి.


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/te/chapter1/6.mdx" />