# บทนำ

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

## ยินดีต้อนรับเข้าสู่คอร์ส 🤗!

<Youtube id="00GKzGyWFEs" />

คอร์สนี้จะสอนคุณเกี่ยวกับการประมวลผลภาษาธรรมชาติหรือ(หรือเรียกว่า NLP) โดยใช้กลุ่ม library ของ [Hugging Face](https://huggingface.co/) ได้แก่ [🤗 Transformers](https://github.com/huggingface/transformers), [🤗 Datasets](https://github.com/huggingface/datasets), [🤗 Tokenizers](https://github.com/huggingface/tokenizers), และ [🤗 Accelerate](https://github.com/huggingface/accelerate) รวมไปถึงการใช้งาน [Hugging Face Hub](https://huggingface.co/models) โดยคอร์สนี้เป็นคอร์สฟรีและไม่มีโฆษณา


## คุณจะได้อะไรจากการเรียนคอร์สนี้?

ภาพรวมของคอร์สเป็นดังนี้:

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/summary.svg" alt="Brief overview of the chapters of the course.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/summary-dark.svg" alt="Brief overview of the chapters of the course.">
</div>

- บทที่ 1 ถึง 4 จะพาคุณไปรู้จักกับคอนเซปต์หลัก ๆ ของ library 🤗 Transformers เมื่อเรียนเนื้อหาในส่วนนี้จบแล้วคุณจะเรียนรู้ว่าโมเดล Transformer ทำงานอย่างไร และเรียนรู้การใช้งานโมเดลจาก [Hugging Face Hub](https://huggingface.co/models), fine-tune โมเดลผ่าน dataset, และแชร์ผลลัพธ์ขึ้น Hub
- บทที่ 5 ถึง 8 จะสอนเกี่ยวกับ 🤗 Datasets และ 🤗 Tokenizers พื้นฐานก่อนที่จะไปลุยกันในส่วนของงานทางด้าน NLP แบบดั้งเดิม หลังจากเรียนเนื้อหาส่วนนี้จบ คุณจะสามารถแก้ปัญหา NLP ทั่วไปเองได้แล้ว
- บทที่ 9 ถึง 12 จะเจาะลึกเนื้อหามากกว่า NLP โดยจะเรียนรู้วิธีการที่โมเดล Transformer จัดการกับการประมวลผลคำพูด(หรือเรียกว่า speech processing) รวมถึงงานทางด้านการประมวลผลภาพ(หรือเรียกว่า computer vision)  ระหว่างนี้คุณจะได้เรียนรู้วิธีการสร้างและแชร์เดโมของโมเดล รวมถึงการ optimize เพื่อให้สามารถใช้งานในระดับ production ได้จริง หลังจากเรียนเนื้อหาส่วนนี้จบ คุณก็พร้อมที่จะใช้ 🤗 Transformers ในการแก้(เกือบ)ทุกปัญหาเกี่ยวกับ machine learning ได้แล้ว!


การเรียนคอร์สนี้:

* ผู้เรียนต้องมีความรู้ในการเขียนโปรแกรมภาษา Python อย่างดี
* ไม่ได้สอนพื้นฐาน deep learning ให้ ผู้เรียนควรเรียนคอร์สพื้นฐานอื่น ๆ มาก่อนแล้ว เช่น คอร์ส [Practical Deep Learning for Coders](https://course.fast.ai/) โดย [fast.ai's](https://www.fast.ai/) หรือคอร์สจาก [DeepLearning.AI](https://www.deeplearning.ai/)
* ผู้เรียนไม่จำเป็นต้องมีความรู้เกี่ยวกับ [PyTorch](https://pytorch.org/) หรือ [TensorFlow](https://www.tensorflow.org/) มาก่อน แต่ถ้าหากเคยใช้จะสามารถเรียนรู้ได้ง่ายยิ่งขึ้น


หลังจากเรียนจบคอร์สนี้ เราแนะนำให้คุณไปเรียนคอร์ส [Natural Language Processing Specialization](https://www.coursera.org/specializations/natural-language-processing?utm_source=deeplearning-ai&utm_medium=institutions&utm_campaign=20211011-nlp-2-hugging_face-page-nlp-refresh) ของ DeepLearning.AI ซึ่งสอนเนื้อหาเกี่ยวกับโมเดล NLP พื้นฐานที่ควรรู้ เช่น Naive Bayes และ LSTM 


## ผู้สอนมีใครบ้าง?

ทีมงานผู้สอนได้แก่:

**Matthew Carrigan** ทำงานตำแหน่ง Machine Learning Engineer ที่ Hugging Face อาศัยอยู่ที่เมือง Dublin ประเทศ Ireland เคยทำงานเป็น ML Engineer ที่ Parse.ly และเคยเป็นนักวิจัยหลังปริญญาเอกที่ Trinity College ใน Dublin เขาเองไม่เคยเชื่อว่าจะสามารถสร้างปัญญาประดิษฐ์ที่สามารถคิดเรื่องทั่วไปได้เหมือนมนุษย์จริง ๆ (หรือเรียกว่า Aritificial General Intelligence หรือตัวย่อว่า AGI) ได้ด้วยการขยายโครงสร้างโมเดลที่มีอยู่ปัจจุบัน แต่เขาก็ยังหวังเป็นอย่างมากเกี่ยวกับการเป็นอมตะของหุ่นยนต์

**Lysandre Debut** ทำงานตำแหน่ง Machine Learning Engineer ที่ Hugging Face ตั้งแต่เริ่มพัฒนา library 🤗 Transformers วาดฝันไว้ว่าจะทำให้ทุกคนใช้งาน NLP ได้ด้วยการพัฒนาเครื่องมือต่าง ๆ ผ่าน API ที่ใช้งานได้ง่าย

**Sylvain Gugger** ทำงานตำแหน่ง Research Engineer ที่ Hugging Face และเป็นหนึ่งในผู้ดูแลหลักของ library 🤗 Transformers ก่อนหน้านี้เป็น Research Scientist ที่ fast.ai และเป็นผู้ร่วมแต่งหนังสือ _[Deep Learning for Coders with fastai and PyTorch](https://learning.oreilly.com/library/view/deep-learning-for/9781492045519/)_ กับ Jeremy Howard เป้าหมายหลักของงานวิจัย คือ การทำให้คนทั่วไปใช้งานโมเดล deep learning ได้ง่ายโดยการออกแบบและปรับปรุงเทคนิคต่าง ๆ ที่ทำให้การ train โมเดลรวดเร็วยิ่งขึ้นบนทรัพยากรคอมพิวเตอร์ที่จำกัด

**Merve Noyan** ทำงานตำแหน่ง Developer Advocate ที่ Hugging Face ทำหน้าที่พัฒนาเครื่องมือในการทำงานต่าง ๆ รวมถึงผลิตสื่อที่มีเนื้อหาเกี่ยวกับเครื่องมือเหล่านี้เพื่อให้ทุกคนสามารถใช้งาน machine learning ได้ง่าย

**Lucile Saulnier** ทำงานตำแหน่ง Machine Learning Engineer ที่ Hugging Face ทำหน้าที่พัฒนาและสนับสนุนการใช้งานเครื่องมือ open-source เธอเองเป็นส่วนหนึ่งในโปรเจควิจัยหลายโปรเจคในเกี่ยวกับ NLP เช่น collaborative training และ BigScience

**Lewis Tunstall** ทำงานตำแหน่ง Machine Learning Engineer ที่ Hugging Face ทำหน้าที่พัฒนาเครื่องมือ open-source เพื่อให้มีการใช้งานอย่างแพร่หลายในชุมชน เป็นผู้ร่วมแต่งหนังสือ [O’Reilly book on Transformers](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/) ที่กำลังจะตีพิมพ์เร็ว ๆ นี้


**Leandro von Werra**  ทำงานตำแหน่ง Machine Learning Engineer ที่ Hugging Face ทีม open-source และเป็นผู้ร่วมแต่งหนังสือ [O’Reilly book on Transformers](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/) เช่นกัน มีประสบการณ์หลายปีในการนำโปรเจค NLP สู่การใช้งานจริงในอุตสาหกรรม


พร้อมกันรึยัง? ในบทนี้ คุณจะได้เรียน:
* วิธีการใช้ฟังก์ชัน `pipeline()` เพื่อแก้ปัญหา NLP เช่น การสร้างข้อความ(หรือเรียกว่า text generation) หรือการแบ่งประเภทข้อความ(หรือเรียกว่า text classification)
* โครงสร้างของ Transformer
* วิธีการแยกระหว่าง encoder, decoder, และ โครงสร้าง encoder-decoder รวมถึงการใช้งานต่าง ๆ



<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/th/chapter1/1.mdx" />