# บทนำ

<CourseFloatingBanner
    chapter={2}
    classNames="absolute z-10 right-0 top-0"
/>

อย่างที่คุณเห็นใน [Chapter 1](/course/chapter1), โดยปกติแล้วโมเดล Transformer นั้นจะมีขนาดใหญ่มาก การเทรนและการใช้งานโมเดลเหล่านี้ที่มีตัวแปร (parameters) เป็นล้านไปจนถึง *หมื่นล้าน* ตัวแปรนั้นเป็นเรื่องที่ค่อนข้างซับซ้อน นอกจากนั้นแล้วการที่มีโมเดลใหม่ๆปล่อยออกมาเกือบทุกวันและแต่ละโมเดลก็มีวิธีการสร้าง (implementation) เป็นของตัวเอง ดังนั้นการจะลองทุกโมเดลนั้นไม่ใช่เรื่องที่ง่ายเลย
🤗 Transformers library สร้างขึ้นมาเพื่อแก้ปัญหานี้ จุดประสงค์ก็คือ การทำให้ไม่ว่าจะโมเดล Transformer ใดก็ตามสามารถโหลด, เทรน, และบันทึก ได้ด้วยการใช้ API เพียงอันเดียว จุดเด่นหลักๆของ library ประกอบด้วย

- **ใช้งานง่าย**: การดาวน์โหลด, การโหลด, และการใช้งานโมเดล NLP ที่ประสิทธิภาพดีที่สุด (state-of-the-art) สำหรับการอนุมาน (inference) นั้นสามารถทำได้ด้วยโค้ดเพียง 2 บรรทัด
- **ความยืดหยุ่น**: โดยแก่นแท้แล้วทุกโมเดลนั้นก็เป็นเพียคลาส `nn.Module` ง่ายๆของ PyTorch หรือ `tf.keras.Model` ของ TensorFlow และสามารถถูกจัดการได้เหมือนโมเดลอื่นๆ ใน machine learning (ML) frameworks นั้นๆ
- **ความเรียบง่าย**: การประกาศ abstractions ใดๆข้ามไปมาใน libraries นั้นน้อยมากๆ แนวคิดหลัก (core concept) ก็คือ "ทุกอย่างอยู่ในไฟล์เดียว (All in one file)" เช่น ขั้นตอนการเรียนรู้ของโมเดลใน forward pass นั้นสามารถประกาศทั้งหมดได้ในไฟล์เดียว ดังนั้นตัวโค้ดนั้นสามารถเป็นที่เข้าใจและแก้ไขได้ในตัวมันเอง

จุดเด่นข้อสุดท้ายนี่เองที่ทำให้ 🤗 Transformers ต่างจาก ML libraries อื่นๆ โมเดลต่างๆไม่ได้ถูกสร้างขึ้นมาจากโมดูลต่างๆที่ต้องแชร์ข้ามไฟล์กันไปมา แต่กลับกัน แต่ละโมเดลจะมี layers ของตัวเอง 
นอกจากจะทำให้โมเดลเข้าถึงและเข้าใจได้ง่ายแล้ว ยังทำให้คุณสามารถทดลองโมเดลๆหนึ่งโดยที่ไม่กระทบโมเดลอื่นๆ

บทนี้จะเริ่มด้วยตัวอย่างแบบ end-to-end ซึ่งเราจะใช้โมเดลและ tokenizer ร่วมกันเพื่อทำซ้ำ(เลียนแบบ) ฟังก์ชัน `pipeline()` จากที่เรียนใน [Chapter 1](/course/chapter1) หลังจากนั้นเราจะมาเรียนเกี่ยวกับ API ของโมเดล โดยเราจะเจาะลึกในคลาสของโมเดลและการตั้งค่า (configuration) และจะแสดงวิธีการโหลดโมเดลและกระบวนการที่โมเดลทำการทำนายผลจากชุดข้อมูลเชิงตัวเลข ว่าทำอย่างไร

หลังจากนั้นเราจะไปดูกันที่ tokenizer API ซึ่งเป็นอีกหนึ่งส่วนประกอบหลักของฟังก์ชัน `pipeline()`, Tokenizers จะรับผิดชอบการประมวลผลขั้นแรกและขั้นสุดท้าย ซึ่งก็คือ การแปลงข้อมูลที่เป็นข้อความให้เป็นข้อมูลเชิงตัวเลข เพื่อใช้กับ neural network, และการแปลงข้อมูลกลับไปเป็นตัวอักษร ในกรณีที่จำเป็น และสุดท้ายเราจะแสดงวิธีการจัดการกับการส่งข้อความทีละหลายๆประโยคแบบที่เตรียมไว้เป็นชุดๆ (batch) ไปยังโมเดล และปิดท้ายด้วยฟังก์ชัน `tokenizer()`

<Tip>
⚠️ เพื่อให้ได้ประโยชน์สูงสุดจากคุณลักษณะเด่นทั้งหมดที่มีใน Model Hub และ 🤗 Transformers, เราแนะนำให้คุณ <a href="https://huggingface.co/join">สร้างบัญชี</a>.
</Tip>

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/th/chapter2/1.mdx" />