# Giới thiệu

Chào mừng các bạn đến với khoá học Hugging Face. Trong phần Giới thiệu này, chúng tôi sẽ hướng dẫn các bạn cách thiết lập môi trường làm việc. Nếu bạn mới bắt đầu khoá học, chúng tôi khuyến khích các bạn xem [Chương 1](/course/chapter1) trước rồi sau đó quay lại và cài đặt môi trường làm việc để bạn có thể tự thử nghiệm các đoạn mã nguồn.

Tất cả các thư viện mà chúng ta sẽ sử dụng ở khóa học này đều được đóng gói sẵn trong Python, vì vậy ở đây chúng tôi sẽ chỉ cho các bạn cách thiết lập môi trường Python và cài đặt các thư viện cụ thể mà bạn cần.

Chúng tôi sẽ đề cập đến hai cách thiết lập môi trường làm việc, sử dụng sổ ghi chép Colab hoặc môi trường ảo Python. Hãy thoải mái chọn phương pháp phù hợp và thuận tiện với bạn nhất. Đối với người mới học, chúng tôi khuyến khích các bạn nên bắt đầu bằng cách sử dụng sổ ghi chép Colab.

Lưu ý rằng chúng tôi sẽ không đề cập đến hệ thống Windows. Nếu bạn đang sử dụng Windows, chúng tôi khuyên bạn nên dùng sổ ghi chép Colab. Nếu bạn đang sử dụng Linux hoặc macOS, bạn có thể chọn một trong hai cách tiếp cận được mô tả trong phần này.

Hầu hết nội dung khóa học phụ thuộc vào việc bạn có một tài khoản Hugging Face. Chúng tôi khuyến khích bạn tạo một tài khoản ngay bây giờ: [tạo tài khoản](https://huggingface.co/join).

## Sử dụng sổ ghi chép Google Colab

Sử dụng sổ ghi chép Colab có thể coi là cách thiết lập đơn giản nhất; khởi động sổ ghi chép trong trình duyệt của bạn và bắt đầu viết mã thôi!

Nếu bạn không quen thuộc với Colab, chúng tôi khuyên bạn nên bắt đầu bằng cách làm theo phần [giới thiệu](https://colab.research.google.com/notebooks/intro.ipynb). Colab cho phép bạn sử dụng một số phần cứng tăng tốc, như GPU hoặc TPU, và nó miễn phí cho các khối lượng công việc nhỏ hơn.

Khi bạn cảm thấy thoải mái với các thao tác trong Colab, hãy tạo một sổ ghi chép mới và bắt đầu phần cài đặt:

<div class="flex justify-center">
  <img
    src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/new_colab.png"
    alt="An empty colab notebook"
    width="80%"
  />
</div>

Bước tiếp theo là cài đặt các thư viện mà chúng ta sẽ sử dụng trong khóa học này. Chúng ta sẽ sử dụng `pip`, một trình quản lý gói cho Python, để cài đặt. Trong sổ ghi chép, bạn có thể chạy các lệnh hệ thống bằng cách đặt trước chúng ký tự `!`, từ đó, bạn có thể cài đặt thư viện 🤗 Transformers như sau:

```
!pip install transformers
```

Bạn có thể đảm bảo rằng gói đã được cài đặt chính xác bằng cách nhập nó trong thời gian chạy Python của bạn:

```
import transformers
```

<div class="flex justify-center">
  <img
    src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/install.gif"
    alt="A gif showing the result of the two commands above: installation and import"
    width="80%"
  />
</div>

Câu lệnh trên cài đặt một phiên bản rất nhẹ của 🤗 Transformers. Đặc biệt, không có khung học máy cụ thể nào (như PyTorch hoặc TensorFlow) được cài đặt. Vì chúng ta sẽ sử dụng nhiều tính năng khác nhau của thư viện, chúng tôi khuyên bạn nên cài đặt phiên bản phát triển, đi kèm với tất cả các thư viện phụ thuộc bắt buộc cho nhiều trường hợp có thể nghĩ tới:

```
!pip install transformers[sentencepiece]
```

Câu lệnh này sẽ mất một chút thời gian để thực thi, nhưng sau đó, bạn sẽ sẵn sàng tiếp tục toàn bộ phần còn lại của khóa học!

## Sử dụng môi trường ảo Python

Nếu bạn thích sử dụng môi trường ảo Python, đầu tiên, bạn cần cài đặt Python trên hệ thống của bạn. Chúng tôi khuyên bạn nên làm theo [hướng dẫn này](https://realpython.com/installing-python/) để bắt đầu.

Khi bạn đã cài đặt Python xong, bạn sẽ có thể chạy các lệnh Python trên giao diện dòng lệch (terminal) của mình. Bạn có thể bắt đầu bằng cách chạy lệnh sau để đảm bảo rằng Python được cài đặt chính xác trước khi tiếp tục các bước tiếp theo: `python --version`. Câu lệnh này sẽ in ra phiên bản Python hiện có trên hệ thống của bạn.

Khi chạy một lệnh Python trên terminal của bạn, chẳng hạn như `python --version`, bạn có thể coi chương trình chạy lệnh là chương trình Python chính trên hệ thống của bạn. Chúng tôi khuyên bạn nên giữ bản cài đặt chính này khỏi bất kỳ gói thư viện nào và sử dụng nó để tạo môi trường riêng biệt cho từng ứng dụng bạn làm việc - với cách này, mỗi ứng dụng có thể có các gói và thư viện phụ thuộc riêng và bạn sẽ không cần phải lo lắng về các vấn đề tiềm ẩn về tương thích với các ứng dụng khác.

Trong Python, điều này được thực hiện với [_virtual environments_](https://docs.python.org/3/tutorial/venv.html), một cây thư mục độc lập chứa một bản cài đặt Python với một phiên bản Python cụ thể cùng với tất cả các gói ứng dụng cần thiết. Việc tạo một môi trường ảo như vậy có thể được thực hiện bằng một số công cụ khác nhau, nhưng chúng ta sẽ sử dụng gói Python chính thức cho mục đích đó, được gọi là [`venv`](https://docs.python.org/3/library/venv.html#module-venv).

Trước tiên, hãy tạo ra thư mục mà bạn muốn chứa ứng dụng của mình - ví dụ: bạn có thể tạo một thư mục mới có tên _transformers-course_ ở gốc của thư mục chính:

```
mkdir ~/transformers-course
cd ~/transformers-course
```

Từ bên trong thư mục này, chúng ta tạo một môi trường ảo bằng cách sử dụng mô-đun Python `venv`:

```
python -m venv .env
```

Bây giờ bạn sẽ có một thư mục được gọi là _.env_ trong thư mục trống của bạn:

```
ls -a
```

```out
.      ..    .env
```

Bạn có thể vào và thoát ra khỏi môi trường ảo của mình bằng câu lệnh `activate` và `deactivate`:

```
# Kích hoạt môi trường ảo
source .env/bin/activate

# Huỷ kích hoạt môi trường ảo
deactivate
```

Bạn có thể đảm bảo rằng môi trường đã được kích hoạt bằng cách chạy lệnh `which python`: nếu nó trỏ đến môi trường ảo thì bạn đã kích hoạt nó thành công!

```
which python
```

```out
/home/<user>/transformers-course/.env/bin/python
```

### Cài đặt các thư viện phụ thuộc

Tương tự với cách sử dụng các phiên bản Google Colab như trong phần trước, bạn sẽ cần cài đặt các gói thư viện cần thiết. Một lần nữa, các bạn có thể cài đặt phiên bản phát triển của 🤗 Transformers bằng trình quản lý gói `pip`:

```
pip install "transformers[sentencepiece]"
```

Bây giờ bạn đã thiết lập xong và sẵn sàng để bắt đầu khám phá nội dung khoá học này!


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/vi/chapter0/1.mdx" />