# Nếu như dữ liệu của ta không trên Hub thì sao?

<CourseFloatingBanner chapter={5}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/vi/chapter5/section2.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/vi/chapter5/section2.ipynb"},
]} />

Bạn biết cách sử dụng [Hugging Face Hub](https://huggingface.co/datasets) để tải xuống bộ dữ liệu, nhưng bạn sẽ thấy mình thường làm việc với dữ liệu được lưu trữ trên máy tính xách tay hoặc trên máy chủ từ xa. Trong phần này, chúng tôi sẽ chỉ cho bạn cách 🤗 Datasets có thể được sử dụng để tải các tập dữ liệu không có sẵn trên Hugging Face Hub.

<Youtube id="HyQgpJTkRdE"/>

## Làm việc với bộ dữ liệu cục bộ và từ xa

🤗 Datasets cung cấp các tập lệnh để xử lý việc tải các tập dữ liệu cục bộ và từ xa. Nó hỗ trợ một số định dạng dữ liệu phổ biến, chẳng hạn như:

|    Định dạng dữ liệu     | 
Tập lệnh |                         Ví dụ                         |
| :----------------: | :------------: | :-----------------------------------------------------: |
|     CSV & TSV      |     `csv`      |     `load_dataset("csv", data_files="my_file.csv")`     |
|     Text files     |     `text`     |    `load_dataset("text", data_files="my_file.txt")`     |
| JSON & JSON Lines  |     `json`     |   `load_dataset("json", data_files="my_file.jsonl")`    |
| Pickled DataFrames |    `pandas`    | `load_dataset("pandas", data_files="my_dataframe.pkl")` |

Như được hiển thị trong bảng, đối với mỗi định dạng dữ liệu, chúng ta chỉ cần chỉ định loại tập lệnh tải dữ liệu trong hàm `load_dataset()`, cùng với tham số `data_files` chỉ định đường dẫn đến một hoặc nhiều tệp. Hãy bắt đầu bằng cách tải một tập dữ liệu từ các tệp cục bộ; Sau đó, chúng ta sẽ xem cách thực hiện tương tự với các tệp từ xa.

## Tải tập dữ liệu cục bộ

Đối với ví dụ này, chúng ta sẽ sử dụng [bộ dữ liệu SQuAD-it](https://github.com/crux82/squad-it/), là một tập dữ liệu quy mô lớn cho tác vụ hỏi đáp bằng tiếng Ý.

Phần dữ liệu huấn luyện và kiểm thử được lưu trữ trên GitHub, vì vậy chúng tôi có thể tải chúng xuống bằng lệnh `wget` đơn giản:

```python
!wget https://github.com/crux82/squad-it/raw/master/SQuAD_it-train.json.gz
!wget https://github.com/crux82/squad-it/raw/master/SQuAD_it-test.json.gz
```

Thao tác này sẽ tải xuống hai tệp nén có tên *SQuAD_it-train.json.gz* và *SQuAD_it-test.json.gz*, chúng ta có thể giải nén bằng lệnh Linux `gzip`:

```python
!gzip -dkv SQuAD_it-*.json.gz
```

```bash
SQuAD_it-test.json.gz:	   87.4% -- replaced with SQuAD_it-test.json
SQuAD_it-train.json.gz:	   82.2% -- replaced with SQuAD_it-train.json
```

Chúng ta có thể thấy rằng các tệp nén đã được thay thế bằng _SQuAD_it-train.json_ và _SQuAD_it-text.json_, và dữ liệu được lưu trữ ở định dạng JSON.

<Tip>

✎ Nếu bạn đang thắc mắc tại sao lại có ký tự`!` trong các lệnh trên, đó là bởi vì chúng ta đang chạy chúng trong một sổ ghi chép Jupyter. Chỉ cần xóa tiền tố này nếu bạn muốn tải xuống và giải nén tập dữ liệu trên terminal.

</Tip>

Để tải tệp JSON bằng hàm `load_dataset()`, chúng ta chỉ cần biết liệu chúng ta đang xử lý JSON thông thường (tương tự như từ điển lồng nhau) hay JSON dòng (JSON được phân tách bằng dòng). Giống như nhiều bộ dữ liệu hỏi đáp, SQuAD-it sử dụng định dạng lồng nhau, với tất cả văn bản được lưu trữ trong trường `data`. Điều này có nghĩa là chúng ta có thể tải tập dữ liệu bằng cách chỉ định tham số `field` như sau:

```py
from datasets import load_dataset

squad_it_dataset = load_dataset("json", data_files="SQuAD_it-train.json", field="data")
```

Theo mặc định, việc tải các tệp cục bộ sẽ tạo ra một đối tượng `DatasetDict` với sự phân chia của `train`. Chúng ta có thể thấy điều này bằng cách kiểm tra đối tượng `squad_it_dataset`:

```py
squad_it_dataset
```

```python out
DatasetDict({
    train: Dataset({
        features: ['title', 'paragraphs'],
        num_rows: 442
    })
})
```

Điều này cho chúng ta thấy số hàng và cột được liên kết với tập huấn luyện. Chúng ta có thể xem một trong các ví dụ bằng cách lập chỉ mục vào phần tập `train` như sau:

```py
squad_it_dataset["train"][0]
```

```python out
{
    "title": "Terremoto del Sichuan del 2008",
    "paragraphs": [
        {
            "context": "Il terremoto del Sichuan del 2008 o il terremoto...",
            "qas": [
                {
                    "answers": [{"answer_start": 29, "text": "2008"}],
                    "id": "56cdca7862d2951400fa6826",
                    "question": "In quale anno si è verificato il terremoto nel Sichuan?",
                },
                ...
            ],
        },
        ...
    ],
}
```

Tuyệt, chúng ta đã tải tập dữ liệu cục bộ đầu tiên của mình! Nhưng trong khi điều này hoạt động cho tập huấn luyện, những gì chúng tôi thực sự muốn là bao gồm cả hai tập `train` và `test` trong một đối tượng `DatasetDict` duy nhất để ta có thể áp dụng `Dataset.map()` trên cả hai phần dữ liệu cùng một lúc. Để thực hiện việc này, chúng ta có thể cung cấp một từ điển cho tham số `data_files` ánh xạ từng tên phần dữ liệu với một tệp được liên kết với các phần đó:

```py
data_files = {"train": "SQuAD_it-train.json", "test": "SQuAD_it-test.json"}
squad_it_dataset = load_dataset("json", data_files=data_files, field="data")
squad_it_dataset
```

```python out
DatasetDict({
    train: Dataset({
        features: ['title', 'paragraphs'],
        num_rows: 442
    })
    test: Dataset({
        features: ['title', 'paragraphs'],
        num_rows: 48
    })
})
```
Đây chính xác là những gì chúng ta muốn. Giờ đây, ta có thể áp dụng nhiều kỹ thuật tiền xử lý khác nhau để làm sạch dữ liệu, mã hóa các bài đánh giá, v.v.

<Tip>

Tham số `data_files` của hàm `load_dataset()` khá linh hoạt và có thể là một đường dẫn tệp duy nhất, danh sách các đường dẫn tệp hoặc từ điển ánh xạ các tên tách thành đường dẫn tệp. Bạn cũng có thể tập hợp các tệp phù hợp với một mẫu được chỉ định theo các quy tắc được sử dụng bởi Unix shell (ví dụ: bạn có thể tổng hợp tất cả các tệp JSON trong một thư mục dưới dạng một lần tách duy nhất bằng cách đặt `data_files="*.json"`). Xem [tài liệu](https://huggingface.co/docs/datasets/loading#local-and-remote-files) 🤗 Datasets để biết thêm chi tiết.

</Tip>

Các tập lệnh tải trong 🤗 Datasets thực sự hỗ trợ giải nén tự động các tệp đầu vào, vì vậy chúng ta có thể bỏ qua việc sử dụng `gzip` bằng cách trỏ trực tiếp tham số `data_files` vào các tệp nén:

```py
data_files = {"train": "SQuAD_it-train.json.gz", "test": "SQuAD_it-test.json.gz"}
squad_it_dataset = load_dataset("json", data_files=data_files, field="data")
```

Điều này có thể hữu ích nếu bạn không muốn giải nén nhiều tệp GZIP theo cách thủ công. Tính năng giải nén tự động cũng áp dụng cho các định dạng phổ biến khác như ZIP và TAR, vì vậy bạn chỉ cần trỏ `data_files` đến các tệp nén và bạn đã sẵn sàng rồi!

Bây giờ bạn đã biết cách tải các tệp cục bộ trên máy tính xách tay hoặc máy tính để bàn của mình, hãy cùng xem cách tải các tệp từ xa.

## Tải tập dữ liệu từ xa

Nếu bạn đang làm việc với tư cách là nhà khoa học dữ liệu hoặc lập trình viên trong một công ty, thì rất có thể các bộ dữ liệu bạn muốn phân tích được lưu trữ trên một máy chủ từ xa nào đó. May mắn thay, việc tải các tệp từ xa cũng đơn giản như tải các tệp cục bộ! Thay vì cung cấp một đường dẫn đến các tệp cục bộ, chúng ta trỏ tham số `data_files` của `load_dataset()` đến một hoặc nhiều URL nơi các tệp từ xa được lưu trữ. Ví dụ: đối với tập dữ liệu SQuAD-it được lưu trữ trên GitHub, chúng ta chỉ cần trỏ `data_files` đến các URL _SQuAD_it-*.json.gz_ như sau:

```py
url = "https://github.com/crux82/squad-it/raw/master/"
data_files = {
    "train": url + "SQuAD_it-train.json.gz",
    "test": url + "SQuAD_it-test.json.gz",
}
squad_it_dataset = load_dataset("json", data_files=data_files, field="data")
```

Điều này trả về cùng một đối tượng `DatasetDict` như ở trên, nhưng giúp ta tiết kiệm bước tải xuống và giải nén thủ công các tệp  _SQuAD_it-*.json.gz_. Điều này tổng kết bước đột phá của chúng ta vào các cách khác nhau để tải các tập dữ liệu không được lưu trữ trên Hugging Face Hub. Giờ ta đã có một tập dữ liệu để nghịch, hãy bắt tay vào các kỹ thuật sắp xếp dữ liệu khác nhau thôi!

<Tip>

✏️ **Thử nghiệm thôi!** Chọn một tập dữ liệu khác được lưu trữ trên GitHub hoặc [Kho lưu trữ Học Máy UCI](https://archive.ics.uci.edu/ml/index.php) và thử tải nó cả cục bộ và từ xa bằng cách sử dụng các kỹ thuật đã giới thiệu ở trên. Để có điểm thưởng, hãy thử tải tập dữ liệu được lưu trữ ở định dạng CSV hoặc dạng văn bản (xem [tài liệu](https://huggingface.co/docs/datasets/loading#local-and-remote-files) để biết thêm thông tin trên các định dạng này).

</Tip>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/vi/chapter5/2.mdx" />