#  Làm thế nào để viết một vấn đề hay

<DocNotebookDropdown
  classNames="absolute z-10 right-0 top-0"
  options={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/vi/chapter8/section5.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/vi/chapter8/section5.ipynb"},
]} />

Khi bạn gặp điều gì đó có vẻ không ổn với một trong các thư viện Hugging Face, bạn chắc chắn nên cho chúng tôi biết để chúng tôi có thể sửa chữa nó (điều này cũng xảy ra với bất kỳ thư viện mã nguồn mở nào, đối với vấn đề đó). Nếu bạn không hoàn toàn chắc chắn liệu lỗi nằm trong mã của riêng bạn hay một trong các thư viện của chúng tôi, nơi đầu tiên cần kiểm tra là [diễn đàn](https://discuss.huggingface.co/). Cộng đồng sẽ giúp bạn tìm ra điều này và nhóm Hugging Face cũng theo dõi chặt chẽ các cuộc thảo luận tại đó.

<Youtube id="_PAli-V4wj0"/>

Khi bạn chắc chắn rằng bạn có một lỗi trong tay, bước đầu tiên là xây dựng một ví dụ có thể tái tạo tối thiểu.

## Tạo một ví dụ có thể tái tạo tối thiểu

Điều rất quan trọng là phải cô lập đoạn mã tạo ra lỗi, vì không có ai trong nhóm Hugging Face là ảo thuật gia và họ không thể sửa những gì họ không thể nhìn thấy. Một ví dụ có thể tái tạo tối thiểu, như tên đã chỉ ra, phải có thể tái tạo được. Điều này có nghĩa là nó không nên dựa vào bất kỳ tệp hoặc dữ liệu bên ngoài nào mà bạn có thể có. Cố gắng thay thế dữ liệu bạn đang sử dụng bằng một số giá trị giả trông giống như dữ liệu thật của bạn mà vẫn tạo ra lỗi tương tự.

<Tip>

🚨 Nhiều vấn đề trong kho lưu trữ 🤗 Transformers chưa được giải quyết vì không thể truy cập được dữ liệu được sử dụng để tái tạo chúng.

</Tip>

Một khi bạn có một cái gì đó độc lập, bạn có thể cố gắng giảm nó thành những dòng mã ít hơn, xây dựng cái mà chúng ta gọi là _ví dụ tối giản có thể tái tạo được_. Mặc dù điều này đòi hỏi bạn phải làm việc nhiều hơn một chút, nhưng bạn gần như sẽ được đảm bảo nhận được trợ giúp và bản sửa lỗi nếu bạn cung cấp một trình tạo lỗi ngắn gọn, đẹp mắt.

Nếu bạn cảm thấy đủ thoải mái, hãy kiểm tra mã nguồn nơi lỗi của bạn xảy ra. Bạn có thể tìm thấy giải pháp cho vấn đề của mình (trong trường hợp đó, bạn thậm chí có thể đề xuất một pull request để khắc phục nó), nhưng nhìn chung, điều này có thể giúp người bảo trì hiểu rõ hơn về nguồn khi họ đọc báo cáo của bạn.

## Điền vào mẫu vấn đề

Khi bạn gửi vấn đề của mình, bạn sẽ thấy có một mẫu để điền vào. Chúng tôi sẽ theo dõi thông tin về [🤗 Sự cố về Transformers](https://github.com/huggingface/transformers/issues/new/choose) tại đây, nhưng loại thông tin tương tự sẽ được yêu cầu nếu bạn báo cáo sự cố trong kho lưu trữ khác. Đừng để trống mẫu: dành thời gian điền vào mẫu sẽ tối đa hóa cơ hội nhận được câu trả lời và giải quyết vấn đề của bạn.

Nói chung, khi trình bày một vấn đề, hãy luôn giữ thái độ lịch sự. Đây là một dự án mã nguồn mở, vì vậy bạn đang sử dụng phần mềm miễn phí và không ai có nghĩa vụ phải giúp bạn. Bạn có thể bao gồm những gì bạn cảm thấy là những lời chỉ trích chính đáng trong vấn đề của bạn, nhưng sau đó những người bảo trì rất có thể coi thường nó và không vội vàng giúp bạn. Đảm bảo rằng bạn đã đọc [quy tắc ứng xử](https://github.com/huggingface/transformers/blob/master/CODE_OF_CONDUCT.md) của dự án.

###Bao gồm thông tin môi trường của bạn

🤗 Transformers cung cấp một tiện ích để lấy tất cả thông tin chúng tôi cần về môi trường của bạn. Chỉ cần nhập thông tin sau vào thiết bị đầu cuối như terminal của bạn:

```
transformers-cli env
```

và bạn sẽ nhận được một cái gì đó như thế này:

```out
Copy-and-paste the text below in your GitHub issue and FILL OUT the two last points.

- `transformers` version: 4.12.0.dev0
- Platform: Linux-5.10.61-1-MANJARO-x86_64-with-arch-Manjaro-Linux
- Python version: 3.7.9
- PyTorch version (GPU?): 1.8.1+cu111 (True)
- Tensorflow version (GPU?): 2.5.0 (True)
- Flax version (CPU?/GPU?/TPU?): 0.3.4 (cpu)
- Jax version: 0.2.13
- JaxLib version: 0.1.65
- Using GPU in script?: <fill in>
- Using distributed or parallel set-up in script?: <fill in>
```

Bạn cũng có thể thêm dấu `!` vào đầu lệnh `transformers-cli env` để thực thi nó từ một ô notebook, sau đó sao chép và dán kết quả vào đầu vấn đề của bạn.

### Gắn thẻ mọi người

Việc gắn thẻ mọi người bằng cách nhập `@` , theo sau là GitHub sẽ gửi cho họ thông báo để họ thấy vấn đề của bạn và có thể trả lời nhanh hơn. Sử dụng điều này một cách có kiểm duyệt, vì những người bạn gắn thẻ có thể không đánh giá cao việc được thông báo nếu đó là thứ mà họ không có liên kết trực tiếp. Nếu bạn đã xem các tệp nguồn liên quan đến lỗi của mình, bạn nên gắn thẻ người cuối cùng đã thực hiện thay đổi vào dòng mà bạn nghĩ là người chịu trách nhiệm cho vấn đề của bạn (bạn có thể tìm thông tin này bằng cách xem dòng đã nói trên GitHub, chọn nó, sau đó nhấp vào "View git blame" hay "Xem git đổ lỗi").

Nếu không, mẫu cung cấp đề xuất về những người cần gắn thẻ. Nói chung, đừng bao giờ gắn thẻ nhiều hơn ba người!

### Bao gồm một ví dụ có thể tái tạo

Nếu bạn đã cố gắng tạo một ví dụ độc lập tạo ra lỗi, bây giờ là lúc để đưa nó vào! Nhập một dòng có ba dấu gạch ngược theo sau là `python`, như thế này:

```python
```

sau đó dán vào ví dụ có thể tái tạo tối thiểu của bạn và nhập một dòng mới với ba dấu gạch ngược. Điều này sẽ đảm bảo mã của bạn được định dạng đúng.

Nếu bạn không quản lý để tạo một ví dụ có thể tái tạo, hãy giải thích theo các bước rõ ràng về cách bạn giải quyết vấn đề của mình. Bao gồm một liên kết đến một notebook Google Colab mà bạn gặp lỗi nếu có thể. Bạn càng chia sẻ nhiều thông tin, người bảo trì càng có thể trả lời bạn tốt hơn.

Trong mọi trường hợp, bạn nên sao chép và dán toàn bộ thông báo lỗi mà bạn đang nhận được. Nếu bạn đang làm việc trong Colab, hãy nhớ rằng một số khung có thể tự động được thu gọn trong dấu vết ngăn xếp, vì vậy hãy đảm bảo bạn mở rộng chúng trước khi sao chép. Giống như với mẫu mã, hãy đặt thông báo lỗi đó giữa hai dòng với ba dấu gạch ngược để nó được định dạng đúng.

### Mô tả hành vi kì vọng

Giải thích bằng một vài dòng những gì bạn mong đợi sẽ nhận được để những người bảo trì nắm bắt được đầy đủ vấn đề. Phần này nhìn chung khá rõ ràng, vì vậy nó nên nằm gọn trong một câu, nhưng trong một số trường hợp, bạn có thể có nhiều điều để nói.

## Và rồi chuyện gì xảy ra?

Sau khi vấn đề của bạn được gửi, hãy đảm bảo nhanh chóng kiểm tra mọi thứ có ổn không. Bạn có thể chỉnh sửa vấn đề nếu bạn mắc lỗi hoặc thậm chí thay đổi tiêu đề của vấn đề nếu bạn nhận ra vấn đề khác với những gì bạn nghĩ ban đầu.

Sẽ không có ích gì khi bạn không nhận được câu trả lời. Nếu không ai giúp bạn trong một vài ngày, có khả năng không ai có thể hiểu được vấn đề của bạn. Đừng ngần ngại quay lại ví dụ có thể tái tạo. Bạn có thể làm cho nó ngắn hơn và nhiều hơn vào điểm không? Nếu bạn không nhận được câu trả lời trong một tuần, bạn có thể nhẹ nhàng để lại tin nhắn yêu cầu trợ giúp, đặc biệt nếu bạn đã chỉnh sửa vấn đề của mình để bao gồm thêm thông tin về vấn đề.


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/vi/chapter8/5.mdx" />