# Các tính năng nâng cao của Interface

<DocNotebookDropdown
  classNames="absolute z-10 right-0 top-0"
  options={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/vi/chapter9/section6.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/vi/chapter9/section6.ipynb"},
]} />

Bây giờ chúng ta có thể xây dựng và chia sẻ giao diện cơ bản, hãy cùng khám phá một số tính năng nâng cao hơn như trạng thái và diễn giải.

### Sử dụng trạng thái để duy trì dữ liệu

Gradio hỗ trợ *trạng thái phiên*, nơi dữ liệu tồn tại qua nhiều lần gửi trong một tải trang. Trạng thái phiên hữu ích khi xây dựng các bản demo, chẳng hạn như chatbot ở nơi bạn muốn giữ nguyên dữ liệu khi người dùng tương tác với mô hình. Lưu ý rằng trạng thái phiên không chia sẻ dữ liệu giữa những người dùng khác nhau trong mô hình của bạn.

Để lưu trữ dữ liệu ở trạng thái phiên, bạn cần thực hiện ba việc:

1. Truyền một *tham số bổ sung* vào hàm của bạn, nó thể hiện trạng thái của giao diện.
1. Khi kết thúc hàm, trả về giá trị đã cập nhật của trạng thái dưới dạng *giá trị trả về bổ sung*.
1. Thêm thành phần đầu vào 'state' và đầu ra 'state' khi tạo `Interface` của bạn.

Xem ví dụ về chatbot bên dưới:

```py
import random

import gradio as gr


def chat(message, history):
    history = history or []
    if message.startswith("How many"):
        response = random.randint(1, 10)
    elif message.startswith("How"):
        response = random.choice(["Great", "Good", "Okay", "Bad"])
    elif message.startswith("Where"):
        response = random.choice(["Here", "There", "Somewhere"])
    else:
        response = "I don't know"
    history.append((message, response))
    return history, history


iface = gr.Interface(
    chat,
    ["text", "state"],
    ["chatbot", "state"],
    allow_screenshot=False,
    allow_flagging="never",
)
iface.launch()
```

<iframe src="https://course-demos-Chatbot-Demo.hf.space" frameBorder="0" height="350" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

Lưu ý trạng thái của thành phần đầu ra vẫn tồn tại qua các lần gửi.
Lưu ý: bạn có thể chuyển giá trị mặc định vào tham số trạng thái, được sử dụng làm giá trị ban đầu của trạng thái.

### Sử dụng diễn giải để hiểu các dự đoán

Hầu hết các mô hình học máy là hộp đen và logic bên trong của hàm bị ẩn khỏi người dùng cuối. Để khuyến khích tính minh bạch, chúng tôi đã giúp bạn dễ dàng thêm thông dịch vào mô hình của mình bằng cách chỉ cần đặt từ khóa thông dịch trong lớp Interface thành mặc định. Điều này cho phép người dùng của bạn hiểu những phần nào của đầu vào chịu trách nhiệm cho đầu ra. Hãy xem giao diện đơn giản bên dưới hiển thị bộ phân loại hình ảnh đồng thời bao gồm phần diễn giải:

```py
import requests
import tensorflow as tf

import gradio as gr

inception_net = tf.keras.applications.MobileNetV2()  # tải mô hình

# Tải nhãn con người đọc được cho ImageNet.
response = requests.get("https://git.io/JJkYN")
labels = response.text.split("\n")


def classify_image(inp):
    inp = inp.reshape((-1, 224, 224, 3))
    inp = tf.keras.applications.mobilenet_v2.preprocess_input(inp)
    prediction = inception_net.predict(inp).flatten()
    return {labels[i]: float(prediction[i]) for i in range(1000)}


image = gr.Image(shape=(224, 224))
label = gr.Label(num_top_classes=3)

title = "Gradio Image Classifiction + Interpretation Example"
gr.Interface(
    fn=classify_image, inputs=image, outputs=label, interpretation="default", title=title
).launch()
```

Kiểm tra hàm thông dịch bằng cách gửi đầu vào, sau đó nhấp vào Interpret tương ứng diễn giải bên dưới thành phần đầu ra.

<iframe src="https://course-demos-gradio-image-interpretation.hf.space" frameBorder="0" height="570" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

Bên cạnh phương pháp diễn giải mặc định mà Gradio cung cấp, bạn cũng có thể chỉ định `shap` cho tham số `interpretation` và đặt tham số `num_shap`. Điều này sử dụng diễn giải dựa trên Shapley, bạn có thể đọc thêm về [tại đây](https://christophm.github.io/interpretable-ml-book/shap.html).
Cuối cùng, bạn cũng có thể chuyển hàm thông dịch của riêng mình vào tham số `interpretation`. Xem ví dụ trong trang bắt đầu của Gradio [tại đây](https://gradio.app/getting_started/).

Điều này kết thúc việc đi sâu vào lớp `Interface` của Gradio. Như chúng ta đã thấy, lớp này giúp việc tạo trình diễn học máy trở nên đơn giản trong một vài dòng mã Python. Tuy nhiên, đôi khi bạn sẽ muốn tùy chỉnh bản demo của mình bằng cách thay đổi bố cục hoặc xâu chuỗi nhiều hàm dự đoán lại với nhau. Sẽ thật tuyệt nếu bằng cách nào đó chúng ta có thể chia `Interface` thành các "khối" có thể tùy chỉnh? May mắn thay, có! Đó là chủ đề của phần cuối cùng.


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/vi/chapter9/6.mdx" />