import{s as Ba,o as Qa,n as Wa}from"../chunks/scheduler.cc52f4b9.js";import{S as Ra,i as Na,e as a,s as n,c as M,h as Xa,a as i,d as t,b as p,f as _a,g as o,j as r,k as Mp,l as Aa,m as l,n as c,t as y,o as m,p as J}from"../chunks/index.9480bb2b.js";import{T as Ga}from"../chunks/Tip.f7b80743.js";import{C as La,H as Jt,E as qa}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.009dc98d.js";import{Y as Ha}from"../chunks/Youtube.7b12d9e8.js";import{C as T}from"../chunks/CodeBlock.184aadb6.js";import{C as Da}from"../chunks/CourseFloatingBanner.6488bde3.js";function Ea(Tt){let j,w="<strong>更进一步</strong>如果你在包含 unicode 字符的字符串上测试先前 normalizers 的两个版本，你肯定会注意到这两个 normalizers 并不完全等效。",f,u,d="为了避免 <code>normalizers.Sequence</code> 过于复杂，我们的实现没有包含当 <code>clean_text</code> 参数设置为 <code>True</code> 时 <code>BertNormalizer</code> 需要的正则表达式替换 —— 而这是 <code>BertNormalizer</code> 默认会实现的。但不要担心：通过在 normalizer 序列中添加两个 <code>normalizers.Replace</code> 可以在不使用方便的 <code>BertNormalizer</code> 的情况下获得完全相同的标准化。";return{c(){j=a("p"),j.innerHTML=w,f=n(),u=a("p"),u.innerHTML=d},l(k){j=i(k,"P",{"data-svelte-h":!0}),r(j)!=="svelte-5z0bx8"&&(j.innerHTML=w),f=p(k),u=i(k,"P",{"data-svelte-h":!0}),r(u)!=="svelte-1xqyqzu"&&(u.innerHTML=d)},m(k,U){l(k,j,U),l(k,f,U),l(k,u,U)},p:Wa,d(k){k&&(t(j),t(f),t(u))}}}function Sa(Tt){let j,w,f,u,d,k,U,jt,g,kt,x,op="正如我们在前几节中看到的，tokenization 包括几个步骤：",ut,h,cp="<li>标准化（任何认为必要的文本清理，例如删除空格或重音符号、Unicode 规范化等）</li> <li>预分词（将输入拆分为单词）</li> <li>通过模型处理输入（使用预先拆分的词来生成一系列  tokens ）</li> <li>后处理（添加 tokenizer 的特殊 tokens 生成注意力掩码和 token 类型 ID）</li>",Ut,C,yp="作为复习，这里再看一遍整个过程：",ft,$,mp='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter6/tokenization_pipeline.svg" alt="The tokenization pipeline."/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter6/tokenization_pipeline-dark.svg" alt="The tokenization pipeline."/>',dt,z,Jp='🤗 Tokenizers 库旨在为每个步骤提供多个选项，你可以任意搭配这些选项。在这一节中，我们将看到如何从零开始构建 tokenizer，而不是像我们在 <a href="/course/chapter6/2">第二节</a> 中那样从旧的 tokenizer 训练新的 tokenizer 然后，你将能够构建任何你能想到的类型的 tokenizer',$t,I,bt,Z,Tp="更精确地说，这个库围绕一个中心的 <code>Tokenizer</code> 类，实现了组成 <code>Tokenizer</code> 的各种子模块：",wt,V,jp='<li><code>normalizers</code> 包含所有可能使用的 <code>Normalizer（标准化）</code> 模块（完整列表 <a href="https://huggingface.co/docs/tokenizers/api/normalizers" rel="nofollow">在这里</a> ）。</li> <li><code>pre_tokenizesr</code> 包含所有可能使用的 <code>PreTokenizer（预处理）</code> 模块（完整列表 <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">在这里</a> ）。</li> <li><code>models</code> 包含了你可以使用的各种 <code>Model（子词分词算法模型）</code> 模块，如 <code>BPE</code> 、 <code>WordPiece</code> 和 <code>Unigram</code> （完整列表 <a href="https://huggingface.co/docs/tokenizers/api/models" rel="nofollow">在这里</a> ）。</li> <li><code>trainers</code> 包含所有不同类型的 <code>trainer</code> ，你可以使用它们在语料库上训练你的模型（每种模型一个；完整列表 <a href="https://huggingface.co/docs/tokenizers/api/trainers" rel="nofollow">在这里</a> ）。</li> <li><code>post_processors</code> 包含你可以使用的各种类型的 <code>PostProcessor（后处理）</code> 模块，（完整列表 <a href="https://huggingface.co/docs/tokenizers/api/post-processors" rel="nofollow">在这里</a> ）。</li> <li><code>decoders</code> 包含各种类型的 <code>Decoder</code> ，可以用来解码 tokenization 后的输出（完整列表 <a href="https://huggingface.co/docs/tokenizers/components#decoders" rel="nofollow">在这里</a> ）。</li>',gt,v,kp='你可以 <a href="https://huggingface.co/docs/tokenizers/components" rel="nofollow">在这里</a> 找到完整的模块列表。',xt,_,ht,B,up='为了训练新的 tokenizer 我们将使用一小部分文本作为语料库（这样运行得更快）。获取语​​料库的步骤与我们在 <a href="/course/chapter6/2">在这章的开头</a> 采取的步骤类似，但这次我们将使用 <a href="https://huggingface.co/datasets/wikitext" rel="nofollow">WikiText-2</a> 数据集：',Ct,Q,zt,W,Up="<code>get_training_corpus()</code> 函数是一个生成器，每次调用的时候将产生 1,000 个文本，我们将用它来训练 tokenizer 。",It,R,fp="🤗 Tokenizers 也可以直接在文本文件上进行训练。以下是我们生成一个包含 WikiText-2 所有文本的代码，这样我们就可以在本地离线使用：",Zt,N,Vt,X,dp="接下来，我们将展示如何模块化地构建你自己的 BERT、GPT-2 和 XLNet  tokenizer 这将包含主要的分词算法：WordPiece、BPE 和 Unigram 的例子。让我们从 BERT 开始吧！",vt,A,_t,G,$p="要用🤗 Tokenizers 库构建一个 tokenizer 我们首先实例化一个带有 <code>model</code> 的 <code>Tokenizer</code> 对象，然后将其 <code>normalizer</code> ， <code>pre_tokenizer</code> ， <code>post_processor</code> 和 <code>decoder</code> 属性设置为我们想要的值。",Bt,L,bp="以这个例子来说，我们将创建一个使用 WordPiece 模型的 <code>Tokenizer</code> ：",Qt,q,Wt,H,wp="我们必须指定 <code>unk_token</code> ，这样当模型遇到它从未见过的字符时，它就会返回 <code>unk_token</code>。我们在这里可以设置的其他参数包括已有的 <code>vocab（词汇表）</code> （我们要重新训练模型，所以我们不需要设置这个）和 <code>max_input_chars_per_word</code> ，它指定了每个词的最大长度（比 <code>max_input_chars_per_word</code> 长的词将被拆分）。",Rt,D,gp="tokenization 的第一步是标准化，所以我们从这里开始。由于 BERT 被广泛使用，所以我们可以使用 <code>BertNormalizer</code> ，我们可以为 BERT 设置经典参数： <code>lowercase（小写）</code> 和 <code>strip_accents（去除重音的字符）</code> ， <code>clean_text</code> 用于删除所有控制字符并将重复的空格替换为一个空格；以及 <code>handle_chinese_chars</code> ，它将在中文字符周围添加空格。要复现 <code>bert-base-uncased</code> tokenizer 我们可以这样设置 <code>normalizer</code> ：",Nt,E,Xt,S,xp="然而，通常来说，当你构建一个新的 tokenizer 时，也需要同步构建一个新的 <code>normalizer</code> —— 所以我们来看看如何手动创建 <code>BERT normalizer</code> 。🤗 Tokenizers 库提供了一个 <code>Lowercase normalizer</code> 和一个 <code>StripAccents normalizer</code> ，并且你可以使用 Sequence 来组合多个 normalizer。",At,P,Gt,F,hp="我们还使用了一个 <code>NFD Unicode normalizer</code> ，否则，否则 <code>StripAccents normalizer</code> 将因为无法正确识别带有重音的字符，从而没办法去除重音。",Lt,Y,Cp="正如我们之前看到的，我们可以使用 <code>normalizer</code> 的 <code>normalize_str()</code> 方法来对它进行测试：",qt,K,Ht,O,Dt,b,Et,ee,zp="下一步是预分词。同样，我们可以使用预构建的 <code>BertPreTokenizer</code> ：",St,se,Pt,te,Ip="或者我们可以从头开始构建它：",Ft,le,Yt,ne,Zp="注意， <code>Whitespace</code> 会使用空格和所有不是字母、数字或下划线的字符进行分割，因此在本次的例子中上会根据空格和标点符号进行分割：",Kt,pe,Ot,ae,el,ie,Vp="如果你只想使用空格进行分割，则应该使用 <code>WhitespaceSplit</code> ：",sl,re,tl,Me,ll,oe,vp="就像 normalizer 一样，你可以使用 <code>Sequence</code> 来组合几个预分词的步骤：",nl,ce,pl,ye,al,me,_p="tokenization 流程的下一步是将输入数据传递给模型。我们已经在初始化时指定了我们的模型，但是我们还需要对其进行训练，这就需要一个 <code>WordPieceTrainer</code> 。在实例化一个🤗 Tokenizers 中的 <code>Trainer</code> 时，一件很重要的事情是，你需要将你打算使用的所有特殊 tokens 都传递给它——否则，由于它们不在训练语料库中，<code>Trainer</code> 就不会将它们添加到词汇表中：",il,Je,rl,Te,Bp="除了指定 <code>vocab_size</code> 和 <code>special_tokens</code> ，我们还可以设置 <code>min_frequency</code> （一个 tokens 必须达到的最小的出现的次数才能被包含在词汇表中）或更改 <code>continuing_subword_prefix</code> （如果我们想使用其他的字符来替代 <code>##</code> ）。",Ml,je,Qp="我们只需要执行以下命令就可以使用我们之前定义的迭代器训练我们的模型：",ol,ke,cl,ue,Wp="我们还可以使用本地的文本文件来训练我们的 tokenizer 它看起来像这样（我们需要先使用 <code>WordPiece</code> 初始化一个空的模型）：",yl,Ue,ml,fe,Rp="在这两种情况下，我们都可以通过调用 <code>encode()</code> 方法来测试 tokenizer",Jl,de,Tl,$e,jl,be,Np="所得到的 <code>encoding</code> 是一个 <code>Encoding</code> 对象，它包含 tokenizer 的所有必要属性： <code>ids</code> 、 <code>type_ids</code> 、 <code>tokens</code> 、 <code>offsets</code> 、 <code>attention_mask</code> 、 <code>special_tokens_mask</code> 和 <code>overflowing</code> 。",kl,we,Xp="tokenizer 管道的最后一步是后处理。我们需要在开头添加 <code>[CLS]</code> token，然后在结束时（或在每句话后，如果我们有一对句子）添加 <code>[SEP]</code> token。我们将使用 <code>TemplateProcessor</code> 来完成这个任务，但首先我们需要知道词汇表中 <code>[CLS]</code> 和 <code>[SEP]</code> tokens 的 ID：",ul,ge,Ul,xe,fl,he,Ap="编写 <code>TemplateProcessor</code> 的模板时，我们必须指定如何处理单个句子和一对句子。对于这两者，我们写下我们想使用的特殊 tokens 第一句（或单句）用 <code>$A</code> 表示，而第二句（如果需要编码一对句子）用 <code>$B</code> 表示。对于这些（特殊 tokens 和句子），我们还需要在冒号后指定相应的 token 类型 ID。",dl,Ce,Gp="因此，经典的 BERT 模板定义如下：",$l,ze,bl,Ie,Lp="请注意，我们需要传递特殊 tokens 的 ID，这样 tokenizer 才能正确地将它们转换为它们的 ID。",wl,Ze,qp="添加之后，我们再次对之前的例子进行 tokenization：",gl,Ve,xl,ve,hl,_e,Hp="在一对句子中，我们也得到了正确的结果：",Cl,Be,zl,Qe,Il,We,Dp="我们几乎从头开始构建了这个 tokenizer ——但是还有最后一步：指定一个解码器：",Zl,Re,Vl,Ne,Ep="让我们在之前的 <code>encoding</code> 上测试一下它：",vl,Xe,_l,Ae,Bl,Ge,Sp="很好！我们可以将 tokenizer 保存在一个 JSON 文件中，如下所示：",Ql,Le,Wl,qe,Pp="然后，我们可以在一个 <code>Tokenizer</code> 对象中使用 <code>from_file()</code> 方法重新加载该文件：",Rl,He,Nl,De,Fp="要在🤗 Transformers 中使用这个 tokenizer 我们需要将它封装在一个 <code>PreTrainedTokenizerFast</code> 类中。我们可以使用通用类（PreTrainedTokenizerFast），或者，如果我们的 tokenizer 对应于一个现有的模型，则可以使用该类（例如这里的 <code>BertTokenizerFast</code> ）。如果你使用这个课程来构建一个全新的 tokenizer 并且没有一个现有的模型可以使用，就必须需要使用通用类。",Xl,Ee,Yp="要将构建的 tokenizer 封装在 <code>PreTrainedTokenizerFast</code> 类中，我们可以将我们构建的 tokenizer 作为 <code>tokenizer_object</code> 传入，或者将我们保存的 tokenizer 文件作为 <code>tokenizer_file</code> 传入。要记住的关键一点是，我们需要手动设置所有的特殊 tokens，因为这个类不能从 <code>tokenizer</code> 对象推断出哪个符号是掩码符号， <code>[CLS]</code> 符号等：",Al,Se,Gl,Pe,Kp="如果你使用的是其他的 tokenizer 类（如 <code>BertTokenizerFast</code> ），你只需要指定那些与默认值不同的特殊符号（这里没有）：",Ll,Fe,ql,Ye,Op="然后，你就可以像使用其他的🤗 Transformers  tokenizer 一样使用这个 tokenizer 了。你可以使用 <code>save_pretrained()</code> 方法来保存它，或者使用 <code>push_to_hub()</code> 方法将它上传到 Hub。",Hl,Ke,ea="既然我们已经看到了如何构建一个 WordPiece  tokenizer。那么让我们也尝试构建 BPE  tokenizer。这次我们会快一些，因为你已经知道所有的步骤，我们主要强调其中的区别。",Dl,Oe,El,es,sa="现在让我们构建一个 GPT-2  tokenizer，与 BERT  tokenizer 一样，我们首先通过 BPE model 初始化一个 <code>Tokenizer</code> ：",Sl,ss,Pl,ts,ta="同样，类似于 BERT，如果我们已经有一个词汇表，我们也可以使用这个词汇表来初始化 GPT 模型（在这种情况下，我们需要传入 <code>vocab</code> 和 <code>merges</code> 参数），但是因为我们将从头开始训练，所以我们不需要做这个。我们也不需要指定 <code>unk_token</code> ，因为 GPT-2 使用字节级 BPE，这不需要它。",Fl,ls,la="GPT-2 不使用 <code>normalizer</code> ，因此我们跳过该步骤并直接进入预分词：",Yl,ns,Kl,ps,na="我们在这里给 <code>ByteLevel</code> 添加的选项的含义是不在句子的开始添加空格（默认为 ture）。我们可以看一下之前的示例文本经过预分词后的结果：",Ol,as,en,is,sn,rs,pa="接下来是需要训练的模型。对于 GPT-2，唯一的特殊符号是文本结束符：",tn,Ms,ln,os,aa="就像 <code>WordPieceTrainer</code> 一样，除了 <code>vocab_size</code> 和 <code>special_tokens</code> ，我们也可以设置 <code>min_frequency</code> ，或者如果我们需要添加一个词尾后缀（如 <code>&lt;/w&gt;</code> ），我们可以用 <code>end_of_word_suffix</code> 设置它。",nn,cs,ia="这个 tokenizer 也可以在本地的文本文件上训练：",pn,ys,an,ms,ra="让我们看一下示例文本经过 tokenization 后的结果：",rn,Js,Mn,Ts,on,js,Ma="我们对 GPT-2  tokenizer 添加字节级后处理，如下所示：",cn,ks,yn,us,oa="<code>trim_offsets = False</code> 这个选项告诉 post-processor，我们应该让那些以‘Ġ’开始的 tokens 的偏移量保持不变：这样，偏移量起始的索引将指向单词前的空格，而不是单词的第一个字符（因为空格在技术上是 token 的一部分）。让我们看一下我们编码示例文本的结果，其中 <code>&#39;Ġtest&#39;</code> 是索引 4 的 token",mn,Us,Jn,fs,Tn,ds,ca="最后，我们添加一个字节级解码器：",jn,$s,kn,bs,ya="我们可以再次检查它是否工作正常：",un,ws,Un,gs,fn,xs,ma="太好了！现在我们完成了，我们可以像之前一样保存 tokenizer，并且如果我们想在🤗 Transformers 中使用它，可以将它封装在 <code>PreTrainedTokenizerFast</code> 类或者 <code>GPT2TokenizerFast</code> 类中：",dn,hs,$n,Cs,Ja="或者：",bn,zs,wn,Is,Ta="作为最后一个示例，我们将向你展示如何从零开始构建 Unigram  tokenizer",gn,Zs,xn,Vs,ja="现在让我们构建一个 XLNet tokenizer 与之前的 tokenizer 一样，我们首先使用 Unigram model 初始化一个 <code>Tokenizer</code> ：",hn,vs,Cn,_s,ka="同样，如果我们有词汇表，我们可以用词汇表初始化这个模型。",zn,Bs,ua="在标准化步骤，XLNet 进行了一些替换（来自 SentencePiece 算法）：",In,Qs,Zn,Ws,Ua="这会将<code>“</code>和<code>”</code>替换为<code>”</code>，将任何连续两个或更多的空格替换为一个空格，同时还将去掉待分词文本中的重音符号。",Vn,Rs,fa="任何 SentencePiece tokenizer 使用的预 tokenizer 是 <code>Metaspace</code> ：",vn,Ns,_n,Xs,da="我们可以像以前一样查看示例文本的预分词：",Bn,As,Qn,Gs,Wn,Ls,$a="接下来是需要训练的模型。XLNet 有不少特殊的 tokens",Rn,qs,Nn,Hs,ba="对于 <code>UnigramTrainer</code> 来说，一个非常重要的参数是 <code>unk_token</code> 。我们也可以传递一些 Unigram 算法独有的其他参数，例如我们可以设置每个删除 token 时的 <code>shrinking_factor</code> （默认为 0.75），或者指定 token 最大长度的 <code>max_piece_length</code> （默认为 16）。",Xn,Ds,wa="这个 tokenizer 也可以在本地的文本文件上训练：",An,Es,Gn,Ss,ga="让我们看一下示例文本的 tokenization 后的结果：",Ln,Ps,qn,Fs,Hn,Ys,xa="XLNet 的一个特点是它将 <code>&lt;cls&gt;</code> token 放在句子的末尾，token 类型 ID 为 2（以区别于其他 tokens）。因此，它在左边进行填充。我们可以像对待 BERT 一样，用模板处理所有特殊 tokens 和 tokens 类型 ID，但首先我们需要获取 <code>&lt;cls&gt;</code> 和 <code>&lt;sep&gt;</code> tokens 的 ID：",Dn,Ks,En,Os,Sn,et,ha="模板如下所示：",Pn,st,Fn,tt,Ca="我们可以通过编码一对句子来测试它是否有效：",Yn,lt,Kn,nt,On,pt,za="最后，我们添加一个 <code>Metaspace</code> 解码器：",ep,at,sp,it,Ia="我们完成了这个 tokenizer。我们可以像保存其他 tokenizer 一样保存它。如果我们想在 🤗 Transformers 中使用它，可以将它封装在 <code>PreTrainedTokenizerFast</code> 类或 <code>XLNetTokenizerFast</code> 类中。使用 <code>PreTrainedTokenizerFast</code> 类时需要注意的一点是，除了特殊 tokens 之外，我们还需要告诉🤗 Transformers 库在左边进行填充：",tp,rt,lp,Mt,Za="或者：",np,ot,pp,ct,Va="现在你已经了解了如何使用各种模块来构建现有的 tokenizer，你应该能够使用 🤗 tokenizer 库编写你想要的任何 tokenizer 并能够在 🤗 Transformers 中使用它。",ap,yt,ip,mt,rp;return d=new La({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),U=new Jt({props:{title:"模块化构建 tokenizer",local:"模块化构建 tokenizer",headingTag:"h1"}}),g=new Da({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/zh-CN/chapter6/section8.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/zh-CN/chapter6/section8.ipynb"}]}}),I=new Ha({props:{id:"MR8tZm5ViWU"}}),_=new Jt({props:{title:"获取语​​料库",local:"获取语​​料库",headingTag:"h2"}}),Q=new T({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ3aWtpdGV4dCUyMiUyQyUyMG5hbWUlM0QlMjJ3aWtpdGV4dC0yLXJhdy12MSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBJTBBZGVmJTIwZ2V0X3RyYWluaW5nX2NvcnB1cygpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMCUyQyUyMGxlbihkYXRhc2V0KSUyQyUyMDEwMDApJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweWllbGQlMjBkYXRhc2V0JTVCaSUyMCUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIydGV4dCUyMiU1RA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;wikitext&quot;</span>, name=<span class="hljs-string">&quot;wikitext-2-raw-v1&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_training_corpus</span>():
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(dataset), <span class="hljs-number">1000</span>):
        <span class="hljs-keyword">yield</span> dataset[i : i + <span class="hljs-number">1000</span>][<span class="hljs-string">&quot;text&quot;</span>]`,wrap:!1}}),N=new T({props:{code:"d2l0aCUyMG9wZW4oJTIyd2lraXRleHQtMi50eHQlMjIlMkMlMjAlMjJ3JTIyJTJDJTIwZW5jb2RpbmclM0QlMjJ1dGYtOCUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oZGF0YXNldCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZShkYXRhc2V0JTVCaSU1RCU1QiUyMnRleHQlMjIlNUQlMjAlMkIlMjAlMjIlNUNuJTIyKQ==",highlighted:`<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>, encoding=<span class="hljs-string">&quot;utf-8&quot;</span>) <span class="hljs-keyword">as</span> f:
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(dataset)):
        f.write(dataset[i][<span class="hljs-string">&quot;text&quot;</span>] + <span class="hljs-string">&quot;\\n&quot;</span>)`,wrap:!1}}),A=new Jt({props:{title:"从头开始构建 WordPiece  tokenizer",local:"从头开始构建 WordPiece  tokenizer",headingTag:"h2"}}),q=new T({props:{code:"ZnJvbSUyMHRva2VuaXplcnMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwZGVjb2RlcnMlMkMlMEElMjAlMjAlMjAlMjBtb2RlbHMlMkMlMEElMjAlMjAlMjAlMjBub3JtYWxpemVycyUyQyUwQSUyMCUyMCUyMCUyMHByZV90b2tlbml6ZXJzJTJDJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc29ycyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluZXJzJTJDJTBBJTIwJTIwJTIwJTIwVG9rZW5pemVyJTJDJTBBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMFRva2VuaXplcihtb2RlbHMuV29yZFBpZWNlKHVua190b2tlbiUzRCUyMiU1QlVOSyU1RCUyMikp",highlighted:`<span class="hljs-keyword">from</span> tokenizers <span class="hljs-keyword">import</span> (
    decoders,
    models,
    normalizers,
    pre_tokenizers,
    processors,
    trainers,
    Tokenizer,
)

tokenizer = Tokenizer(models.WordPiece(unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>))`,wrap:!1}}),E=new T({props:{code:"dG9rZW5pemVyLm5vcm1hbGl6ZXIlMjAlM0QlMjBub3JtYWxpemVycy5CZXJ0Tm9ybWFsaXplcihsb3dlcmNhc2UlM0RUcnVlKQ==",highlighted:'tokenizer.normalizer = normalizers.BertNormalizer(lowercase=<span class="hljs-literal">True</span>)',wrap:!1}}),P=new T({props:{code:"dG9rZW5pemVyLm5vcm1hbGl6ZXIlMjAlM0QlMjBub3JtYWxpemVycy5TZXF1ZW5jZSglMEElMjAlMjAlMjAlMjAlNUJub3JtYWxpemVycy5ORkQoKSUyQyUyMG5vcm1hbGl6ZXJzLkxvd2VyY2FzZSgpJTJDJTIwbm9ybWFsaXplcnMuU3RyaXBBY2NlbnRzKCklNUQlMEEp",highlighted:`tokenizer.normalizer = normalizers.<span class="hljs-type">Sequence</span>(
    [normalizers.NFD(), normalizers.Lowercase(), normalizers.StripAccents()]
)`,wrap:!1}}),K=new T({props:{code:"cHJpbnQodG9rZW5pemVyLm5vcm1hbGl6ZXIubm9ybWFsaXplX3N0ciglMjJIJUMzJUE5bGwlQzMlQjIlMjBoJUMzJUI0dyUyMGFyZSUyMCVDMyVCQyUzRiUyMikp",highlighted:'<span class="hljs-built_in">print</span>(tokenizer.normalizer.normalize_str(<span class="hljs-string">&quot;Héllò hôw are ü?&quot;</span>))',wrap:!1}}),O=new T({props:{code:"aGVsbG8lMjBob3clMjBhcmUlMjB1JTNG",highlighted:"hello how are u?",wrap:!1}}),b=new Ga({props:{$$slots:{default:[Ea]},$$scope:{ctx:Tt}}}),se=new T({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5CZXJ0UHJlVG9rZW5pemVyKCk=",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.BertPreTokenizer()",wrap:!1}}),le=new T({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5XaGl0ZXNwYWNlKCk=",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.Whitespace()",wrap:!1}}),pe=new T({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjBteSUyMHByZS10b2tlbml6ZXIuJTIyKQ==",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)',wrap:!1}}),ae=new T({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJyUyMiUyQyUyMCgzJTJDJTIwNCkpJTJDJTIwKCdzJyUyQyUyMCg0JTJDJTIwNSkpJTJDJTIwKCd0ZXN0JyUyQyUyMCg2JTJDJTIwMTApKSUyQyUyMCgnbXknJTJDJTIwKDExJTJDJTIwMTMpKSUyQyUyMCgncHJlJyUyQyUyMCgxNCUyQyUyMDE3KSklMkMlMEElMjAoJy0nJTJDJTIwKDE3JTJDJTIwMTgpKSUyQyUyMCgndG9rZW5pemVyJyUyQyUyMCgxOCUyQyUyMDI3KSklMkMlMjAoJy4nJTJDJTIwKDI3JTJDJTIwMjgpKSU1RA==",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">4</span>)), (<span class="hljs-string">&#x27;s&#x27;</span>, (<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">17</span>)),
 (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">17</span>, <span class="hljs-number">18</span>)), (<span class="hljs-string">&#x27;tokenizer&#x27;</span>, (<span class="hljs-number">18</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;.&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),re=new T({props:{code:"cHJlX3Rva2VuaXplciUyMCUzRCUyMHByZV90b2tlbml6ZXJzLldoaXRlc3BhY2VTcGxpdCgpJTBBcHJlX3Rva2VuaXplci5wcmVfdG9rZW5pemVfc3RyKCUyMkxldCdzJTIwdGVzdCUyMG15JTIwcHJlLXRva2VuaXplci4lMjIp",highlighted:`pre_tokenizer = pre_tokenizers.WhitespaceSplit()
pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)`,wrap:!1}}),Me=new T({props:{code:"JTVCKCUyMkxldCdzJTIyJTJDJTIwKDAlMkMlMjA1KSklMkMlMjAoJ3Rlc3QnJTJDJTIwKDYlMkMlMjAxMCkpJTJDJTIwKCdteSclMkMlMjAoMTElMkMlMjAxMykpJTJDJTIwKCdwcmUtdG9rZW5pemVyLiclMkMlMjAoMTQlMkMlMjAyOCkpJTVE",highlighted:'[(<span class="hljs-string">&quot;Let&#x27;s&quot;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre-tokenizer.&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">28</span>))]',wrap:!1}}),ce=new T({props:{code:"cHJlX3Rva2VuaXplciUyMCUzRCUyMHByZV90b2tlbml6ZXJzLlNlcXVlbmNlKCUwQSUyMCUyMCUyMCUyMCU1QnByZV90b2tlbml6ZXJzLldoaXRlc3BhY2VTcGxpdCgpJTJDJTIwcHJlX3Rva2VuaXplcnMuUHVuY3R1YXRpb24oKSU1RCUwQSklMEFwcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIoJTIyTGV0J3MlMjB0ZXN0JTIwbXklMjBwcmUtdG9rZW5pemVyLiUyMik=",highlighted:`pre_tokenizer = pre_tokenizers.<span class="hljs-type">Sequence</span>(
    [pre_tokenizers.WhitespaceSplit(), pre_tokenizers.Punctuation()]
)
pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)`,wrap:!1}}),ye=new T({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJyUyMiUyQyUyMCgzJTJDJTIwNCkpJTJDJTIwKCdzJyUyQyUyMCg0JTJDJTIwNSkpJTJDJTIwKCd0ZXN0JyUyQyUyMCg2JTJDJTIwMTApKSUyQyUyMCgnbXknJTJDJTIwKDExJTJDJTIwMTMpKSUyQyUyMCgncHJlJyUyQyUyMCgxNCUyQyUyMDE3KSklMkMlMEElMjAoJy0nJTJDJTIwKDE3JTJDJTIwMTgpKSUyQyUyMCgndG9rZW5pemVyJyUyQyUyMCgxOCUyQyUyMDI3KSklMkMlMjAoJy4nJTJDJTIwKDI3JTJDJTIwMjgpKSU1RA==",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">4</span>)), (<span class="hljs-string">&#x27;s&#x27;</span>, (<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">17</span>)),
 (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">17</span>, <span class="hljs-number">18</span>)), (<span class="hljs-string">&#x27;tokenizer&#x27;</span>, (<span class="hljs-number">18</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;.&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),Je=new T({props:{code:"c3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUIlMjIlNUJVTkslNUQlMjIlMkMlMjAlMjIlNUJQQUQlNUQlMjIlMkMlMjAlMjIlNUJDTFMlNUQlMjIlMkMlMjAlMjIlNUJTRVAlNUQlMjIlMkMlMjAlMjIlNUJNQVNLJTVEJTIyJTVEJTBBdHJhaW5lciUyMCUzRCUyMHRyYWluZXJzLldvcmRQaWVjZVRyYWluZXIodm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0RzcGVjaWFsX3Rva2Vucyk=",highlighted:`special_tokens = [<span class="hljs-string">&quot;[UNK]&quot;</span>, <span class="hljs-string">&quot;[PAD]&quot;</span>, <span class="hljs-string">&quot;[CLS]&quot;</span>, <span class="hljs-string">&quot;[SEP]&quot;</span>, <span class="hljs-string">&quot;[MASK]&quot;</span>]
trainer = trainers.WordPieceTrainer(vocab_size=<span class="hljs-number">25000</span>, special_tokens=special_tokens)`,wrap:!1}}),ke=new T({props:{code:"dG9rZW5pemVyLnRyYWluX2Zyb21faXRlcmF0b3IoZ2V0X3RyYWluaW5nX2NvcnB1cygpJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:"tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)",wrap:!1}}),Ue=new T({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLldvcmRQaWVjZSh1bmtfdG9rZW4lM0QlMjIlNUJVTkslNUQlMjIpJTBBdG9rZW5pemVyLnRyYWluKCU1QiUyMndpa2l0ZXh0LTIudHh0JTIyJTVEJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`tokenizer.model = models.WordPiece(unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>)
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),de=new T({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),$e=new T({props:{code:"JTVCJ2xldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJ3Rlc3QnJTJDJTIwJ3RoaXMnJTJDJTIwJ3RvayclMkMlMjAnJTIzJTIzZW5pJyUyQyUyMCclMjMlMjN6ZXInJTJDJTIwJy4nJTVE",highlighted:'[<span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),ge=new T({props:{code:"Y2xzX3Rva2VuX2lkJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuX3RvX2lkKCUyMiU1QkNMUyU1RCUyMiklMEFzZXBfdG9rZW5faWQlMjAlM0QlMjB0b2tlbml6ZXIudG9rZW5fdG9faWQoJTIyJTVCU0VQJTVEJTIyKSUwQXByaW50KGNsc190b2tlbl9pZCUyQyUyMHNlcF90b2tlbl9pZCk=",highlighted:`cls_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;[CLS]&quot;</span>)
sep_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;[SEP]&quot;</span>)
<span class="hljs-built_in">print</span>(cls_token_id, sep_token_id)`,wrap:!1}}),xe=new T({props:{code:"KDIlMkMlMjAzKQ==",highlighted:'(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>)',wrap:!1}}),ze=new T({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5UZW1wbGF0ZVByb2Nlc3NpbmcoJTBBJTIwJTIwJTIwJTIwc2luZ2xlJTNEZiUyMiU1QkNMUyU1RCUzQTAlMjAlMjRBJTNBMCUyMCU1QlNFUCU1RCUzQTAlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWlyJTNEZiUyMiU1QkNMUyU1RCUzQTAlMjAlMjRBJTNBMCUyMCU1QlNFUCU1RCUzQTAlMjAlMjRCJTNBMSUyMCU1QlNFUCU1RCUzQTElMjIlMkMlMEElMjAlMjAlMjAlMjBzcGVjaWFsX3Rva2VucyUzRCU1QiglMjIlNUJDTFMlNUQlMjIlMkMlMjBjbHNfdG9rZW5faWQpJTJDJTIwKCUyMiU1QlNFUCU1RCUyMiUyQyUyMHNlcF90b2tlbl9pZCklNUQlMkMlMEEp",highlighted:`tokenizer.post_processor = processors.TemplateProcessing(
    single=<span class="hljs-string">f&quot;[CLS]:0 $A:0 [SEP]:0&quot;</span>,
    pair=<span class="hljs-string">f&quot;[CLS]:0 $A:0 [SEP]:0 $B:1 [SEP]:1&quot;</span>,
    special_tokens=[(<span class="hljs-string">&quot;[CLS]&quot;</span>, cls_token_id), (<span class="hljs-string">&quot;[SEP]&quot;</span>, sep_token_id)],
)`,wrap:!1}}),Ve=new T({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),ve=new T({props:{code:"JTVCJyU1QkNMUyU1RCclMkMlMjAnbGV0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAndGVzdCclMkMlMjAndGhpcyclMkMlMjAndG9rJyUyQyUyMCclMjMlMjNlbmknJTJDJTIwJyUyMyUyM3plciclMkMlMjAnLiclMkMlMjAnJTVCU0VQJTVEJyU1RA==",highlighted:'[<span class="hljs-string">&#x27;[CLS]&#x27;</span>, <span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>]',wrap:!1}}),Be=new T({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuLi4lMjIlMkMlMjAlMjJvbiUyMGElMjBwYWlyJTIwb2YlMjBzZW50ZW5jZXMuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2VucyklMEFwcmludChlbmNvZGluZy50eXBlX2lkcyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer...&quot;</span>, <span class="hljs-string">&quot;on a pair of sentences.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)
<span class="hljs-built_in">print</span>(encoding.type_ids)`,wrap:!1}}),Qe=new T({props:{code:"JTVCJyU1QkNMUyU1RCclMkMlMjAnbGV0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAndGVzdCclMkMlMjAndGhpcyclMkMlMjAndG9rJyUyQyUyMCclMjMlMjNlbmknJTJDJTIwJyUyMyUyM3plciclMkMlMjAnLi4uJyUyQyUyMCclNUJTRVAlNUQnJTJDJTIwJ29uJyUyQyUyMCdhJyUyQyUyMCdwYWlyJyUyQyUyMCdvZiclMkMlMjAnc2VudGVuY2VzJyUyQyUyMCcuJyUyQyUyMCclNUJTRVAlNUQnJTVEJTBBJTVCMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTVE",highlighted:`[<span class="hljs-string">&#x27;[CLS]&#x27;</span>, <span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;...&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>, <span class="hljs-string">&#x27;on&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;pair&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;sentences&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]`,wrap:!1}}),Re=new T({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5Xb3JkUGllY2UocHJlZml4JTNEJTIyJTIzJTIzJTIyKQ==",highlighted:'tokenizer.decoder = decoders.WordPiece(prefix=<span class="hljs-string">&quot;##&quot;</span>)',wrap:!1}}),Xe=new T({props:{code:"dG9rZW5pemVyLmRlY29kZShlbmNvZGluZy5pZHMp",highlighted:"tokenizer.decode(encoding.ids)",wrap:!1}}),Ae=new T({props:{code:"JTIybGV0J3MlMjB0ZXN0JTIwdGhpcyUyMHRva2VuaXplci4uLiUyMG9uJTIwYSUyMHBhaXIlMjBvZiUyMHNlbnRlbmNlcy4lMjI=",highlighted:'<span class="hljs-string">&quot;let&#x27;s test this tokenizer... on a pair of sentences.&quot;</span>',wrap:!1}}),Le=new T({props:{code:"dG9rZW5pemVyLnNhdmUoJTIydG9rZW5pemVyLmpzb24lMjIp",highlighted:'tokenizer.save(<span class="hljs-string">&quot;tokenizer.json&quot;</span>)',wrap:!1}}),He=new T({props:{code:"bmV3X3Rva2VuaXplciUyMCUzRCUyMFRva2VuaXplci5mcm9tX2ZpbGUoJTIydG9rZW5pemVyLmpzb24lMjIp",highlighted:'new_tokenizer = Tokenizer.from_file(<span class="hljs-string">&quot;tokenizer.json&quot;</span>)',wrap:!1}}),Se=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwdG9rZW5pemVyX2ZpbGUlM0QlMjJ0b2tlbml6ZXIuanNvbiUyMiUyQyUyMCUyMyUyMCVFNCVCOSU5RiVFNSU4RiVBRiVFNCVCQiVBNSVFNCVCQiU4RXRva2VuaXplciVFNiU5NiU4NyVFNCVCQiVCNiVFNCVCOCVBRCVFNSU4QSVBMCVFOCVCRCVCRCUwQSUyMCUyMCUyMCUyMHVua190b2tlbiUzRCUyMiU1QlVOSyU1RCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZF90b2tlbiUzRCUyMiU1QlBBRCU1RCUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsc190b2tlbiUzRCUyMiU1QkNMUyU1RCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNlcF90b2tlbiUzRCUyMiU1QlNFUCU1RCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1hc2tfdG9rZW4lM0QlMjIlNUJNQVNLJTVEJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    <span class="hljs-comment"># tokenizer_file=&quot;tokenizer.json&quot;, # 也可以从tokenizer文件中加载</span>
    unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>,
    pad_token=<span class="hljs-string">&quot;[PAD]&quot;</span>,
    cls_token=<span class="hljs-string">&quot;[CLS]&quot;</span>,
    sep_token=<span class="hljs-string">&quot;[SEP]&quot;</span>,
    mask_token=<span class="hljs-string">&quot;[MASK]&quot;</span>,
)`,wrap:!1}}),Fe=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBCZXJ0VG9rZW5pemVyRmFzdCh0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertTokenizerFast

wrapped_tokenizer = BertTokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),Oe=new Jt({props:{title:"从头开始构建 BPE  tokenizer",local:"从头开始构建 BPE  tokenizer",headingTag:"h2"}}),ss=new T({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwVG9rZW5pemVyKG1vZGVscy5CUEUoKSk=",highlighted:"tokenizer = Tokenizer(models.BPE())",wrap:!1}}),ns=new T({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5CeXRlTGV2ZWwoYWRkX3ByZWZpeF9zcGFjZSUzREZhbHNlKQ==",highlighted:'tokenizer.pre_tokenizer = pre_tokenizers.ByteLevel(add_prefix_space=<span class="hljs-literal">False</span>)',wrap:!1}}),as=new T({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjBwcmUtdG9rZW5pemF0aW9uISUyMik=",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test pre-tokenization!&quot;</span>)',wrap:!1}}),is=new T({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJ3MlMjIlMkMlMjAoMyUyQyUyMDUpKSUyQyUyMCgnJUM0JUEwdGVzdCclMkMlMjAoNSUyQyUyMDEwKSklMkMlMjAoJyVDNCVBMHByZSclMkMlMjAoMTAlMkMlMjAxNCkpJTJDJTIwKCctJyUyQyUyMCgxNCUyQyUyMDE1KSklMkMlMEElMjAoJ3Rva2VuaXphdGlvbiclMkMlMjAoMTUlMkMlMjAyNykpJTJDJTIwKCchJyUyQyUyMCgyNyUyQyUyMDI4KSklNUQ=",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;s&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;Ġtest&#x27;</span>, (<span class="hljs-number">5</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;Ġpre&#x27;</span>, (<span class="hljs-number">10</span>, <span class="hljs-number">14</span>)), (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">15</span>)),
 (<span class="hljs-string">&#x27;tokenization&#x27;</span>, (<span class="hljs-number">15</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;!&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),Ms=new T({props:{code:"dHJhaW5lciUyMCUzRCUyMHRyYWluZXJzLkJwZVRyYWluZXIodm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0QlNUIlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlNUQpJTBBdG9rZW5pemVyLnRyYWluX2Zyb21faXRlcmF0b3IoZ2V0X3RyYWluaW5nX2NvcnB1cygpJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`trainer = trainers.BpeTrainer(vocab_size=<span class="hljs-number">25000</span>, special_tokens=[<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>])
tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)`,wrap:!1}}),ys=new T({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLkJQRSgpJTBBdG9rZW5pemVyLnRyYWluKCU1QiUyMndpa2l0ZXh0LTIudHh0JTIyJTVEJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`tokenizer.model = models.BPE()
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),Js=new T({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),Ts=new T({props:{code:"JTVCJ0wnJTJDJTIwJ2V0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAnJUM0JUEwdGVzdCclMkMlMjAnJUM0JUEwdGhpcyclMkMlMjAnJUM0JUEwdG8nJTJDJTIwJ2tlbiclMkMlMjAnaXplciclMkMlMjAnLiclNUQ=",highlighted:'[<span class="hljs-string">&#x27;L&#x27;</span>, <span class="hljs-string">&#x27;et&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;Ġtest&#x27;</span>, <span class="hljs-string">&#x27;Ġthis&#x27;</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),ks=new T({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5CeXRlTGV2ZWwodHJpbV9vZmZzZXRzJTNERmFsc2Up",highlighted:'tokenizer.post_processor = processors.ByteLevel(trim_offsets=<span class="hljs-literal">False</span>)',wrap:!1}}),Us=new T({props:{code:"c2VudGVuY2UlMjAlM0QlMjAlMjJMZXQncyUyMHRlc3QlMjB0aGlzJTIwdG9rZW5pemVyLiUyMiUwQWVuY29kaW5nJTIwJTNEJTIwdG9rZW5pemVyLmVuY29kZShzZW50ZW5jZSklMEFzdGFydCUyQyUyMGVuZCUyMCUzRCUyMGVuY29kaW5nLm9mZnNldHMlNUI0JTVEJTBBc2VudGVuY2UlNUJzdGFydCUzQWVuZCU1RA==",highlighted:`sentence = <span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>
encoding = tokenizer.encode(sentence)
start, end = encoding.offsets[<span class="hljs-number">4</span>]
sentence[start:end]`,wrap:!1}}),fs=new T({props:{code:"JyUyMHRlc3Qn",highlighted:'<span class="hljs-string">&#x27; test&#x27;</span>',wrap:!1}}),$s=new T({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5CeXRlTGV2ZWwoKQ==",highlighted:"tokenizer.decoder = decoders.ByteLevel()",wrap:!1}}),ws=new T({props:{code:"dG9rZW5pemVyLmRlY29kZShlbmNvZGluZy5pZHMp",highlighted:"tokenizer.decode(encoding.ids)",wrap:!1}}),gs=new T({props:{code:"JTIyTGV0J3MlMjB0ZXN0JTIwdGhpcyUyMHRva2VuaXplci4lMjI=",highlighted:'<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>',wrap:!1}}),hs=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYm9zX3Rva2VuJTNEJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTBBJTIwJTIwJTIwJTIwZW9zX3Rva2VuJTNEJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    bos_token=<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
    eos_token=<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
)`,wrap:!1}}),zs=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyRmFzdCh0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2TokenizerFast

wrapped_tokenizer = GPT2TokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),Zs=new Jt({props:{title:"从零开始构建 Unigram  tokenizer",local:"从零开始构建 Unigram  tokenizer",headingTag:"h2"}}),vs=new T({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwVG9rZW5pemVyKG1vZGVscy5VbmlncmFtKCkp",highlighted:"tokenizer = Tokenizer(models.Unigram())",wrap:!1}}),Qs=new T({props:{code:"ZnJvbSUyMHRva2VuaXplcnMlMjBpbXBvcnQlMjBSZWdleCUwQSUwQXRva2VuaXplci5ub3JtYWxpemVyJTIwJTNEJTIwbm9ybWFsaXplcnMuU2VxdWVuY2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuUmVwbGFjZSglMjIlNjAlNjAlMjIlMkMlMjAnJTIyJyklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemVycy5SZXBsYWNlKCUyMicnJTIyJTJDJTIwJyUyMicpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuTkZLRCgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuU3RyaXBBY2NlbnRzKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemVycy5SZXBsYWNlKFJlZ2V4KCUyMiUyMCU3QjIlMkMlN0QlMjIpJTJDJTIwJTIyJTIwJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> tokenizers <span class="hljs-keyword">import</span> Regex

tokenizer.normalizer = normalizers.<span class="hljs-type">Sequence</span>(
    [
        normalizers.Replace(<span class="hljs-string">&quot;\`\`&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>),
        normalizers.Replace(<span class="hljs-string">&quot;&#x27;&#x27;&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>),
        normalizers.NFKD(),
        normalizers.StripAccents(),
        normalizers.Replace(Regex(<span class="hljs-string">&quot; {2,}&quot;</span>), <span class="hljs-string">&quot; &quot;</span>),
    ]
)`,wrap:!1}}),Ns=new T({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5NZXRhc3BhY2UoKQ==",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.Metaspace()",wrap:!1}}),As=new T({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjB0aGUlMjBwcmUtdG9rZW5pemVyISUyMik=",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test the pre-tokenizer!&quot;</span>)',wrap:!1}}),Gs=new T({props:{code:"JTVCKCUyMiVFMiU5NiU4MUxldCdzJTIyJTJDJTIwKDAlMkMlMjA1KSklMkMlMjAoJyVFMiU5NiU4MXRlc3QnJTJDJTIwKDUlMkMlMjAxMCkpJTJDJTIwKCclRTIlOTYlODF0aGUnJTJDJTIwKDEwJTJDJTIwMTQpKSUyQyUyMCgnJUUyJTk2JTgxcHJlLXRva2VuaXplciEnJTJDJTIwKDE0JTJDJTIwMjkpKSU1RA==",highlighted:'[(<span class="hljs-string">&quot;▁Let&#x27;s&quot;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;▁test&#x27;</span>, (<span class="hljs-number">5</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;▁the&#x27;</span>, (<span class="hljs-number">10</span>, <span class="hljs-number">14</span>)), (<span class="hljs-string">&#x27;▁pre-tokenizer!&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">29</span>))]',wrap:!1}}),qs=new T({props:{code:"c3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUIlMjIlM0NjbHMlM0UlMjIlMkMlMjAlMjIlM0NzZXAlM0UlMjIlMkMlMjAlMjIlM0N1bmslM0UlMjIlMkMlMjAlMjIlM0NwYWQlM0UlMjIlMkMlMjAlMjIlM0NtYXNrJTNFJTIyJTJDJTIwJTIyJTNDcyUzRSUyMiUyQyUyMCUyMiUzQyUyRnMlM0UlMjIlNUQlMEF0cmFpbmVyJTIwJTNEJTIwdHJhaW5lcnMuVW5pZ3JhbVRyYWluZXIoJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0RzcGVjaWFsX3Rva2VucyUyQyUyMHVua190b2tlbiUzRCUyMiUzQ3VuayUzRSUyMiUwQSklMEF0b2tlbml6ZXIudHJhaW5fZnJvbV9pdGVyYXRvcihnZXRfdHJhaW5pbmdfY29ycHVzKCklMkMlMjB0cmFpbmVyJTNEdHJhaW5lcik=",highlighted:`special_tokens = [<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;pad&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;mask&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;s&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>]
trainer = trainers.UnigramTrainer(
    vocab_size=<span class="hljs-number">25000</span>, special_tokens=special_tokens, unk_token=<span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>
)
tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)`,wrap:!1}}),Es=new T({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLlVuaWdyYW0oKSUwQXRva2VuaXplci50cmFpbiglNUIlMjJ3aWtpdGV4dC0yLnR4dCUyMiU1RCUyQyUyMHRyYWluZXIlM0R0cmFpbmVyKQ==",highlighted:`tokenizer.model = models.Unigram()
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),Ps=new T({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),Fs=new T({props:{code:"JTVCJyVFMiU5NiU4MUxldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJyVFMiU5NiU4MXRlc3QnJTJDJTIwJyVFMiU5NiU4MXRoaXMnJTJDJTIwJyVFMiU5NiU4MXRvJyUyQyUyMCdrZW4nJTJDJTIwJ2l6ZXInJTJDJTIwJy4nJTVE",highlighted:'[<span class="hljs-string">&#x27;▁Let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;▁test&#x27;</span>, <span class="hljs-string">&#x27;▁this&#x27;</span>, <span class="hljs-string">&#x27;▁to&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),Ks=new T({props:{code:"Y2xzX3Rva2VuX2lkJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuX3RvX2lkKCUyMiUzQ2NscyUzRSUyMiklMEFzZXBfdG9rZW5faWQlMjAlM0QlMjB0b2tlbml6ZXIudG9rZW5fdG9faWQoJTIyJTNDc2VwJTNFJTIyKSUwQXByaW50KGNsc190b2tlbl9pZCUyQyUyMHNlcF90b2tlbl9pZCk=",highlighted:`cls_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>)
sep_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>)
<span class="hljs-built_in">print</span>(cls_token_id, sep_token_id)`,wrap:!1}}),Os=new T({props:{code:"MCUyMDE=",highlighted:'<span class="hljs-number">0</span> <span class="hljs-number">1</span>',wrap:!1}}),st=new T({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5UZW1wbGF0ZVByb2Nlc3NpbmcoJTBBJTIwJTIwJTIwJTIwc2luZ2xlJTNEJTIyJTI0QSUzQTAlMjAlM0NzZXAlM0UlM0EwJTIwJTNDY2xzJTNFJTNBMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhaXIlM0QlMjIlMjRBJTNBMCUyMCUzQ3NlcCUzRSUzQTAlMjAlMjRCJTNBMSUyMCUzQ3NlcCUzRSUzQTElMjAlM0NjbHMlM0UlM0EyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3BlY2lhbF90b2tlbnMlM0QlNUIoJTIyJTNDc2VwJTNFJTIyJTJDJTIwc2VwX3Rva2VuX2lkKSUyQyUyMCglMjIlM0NjbHMlM0UlMjIlMkMlMjBjbHNfdG9rZW5faWQpJTVEJTJDJTBBKQ==",highlighted:`tokenizer.post_processor = processors.TemplateProcessing(
    single=<span class="hljs-string">&quot;$A:0 &lt;sep&gt;:0 &lt;cls&gt;:2&quot;</span>,
    pair=<span class="hljs-string">&quot;$A:0 &lt;sep&gt;:0 $B:1 &lt;sep&gt;:1 &lt;cls&gt;:2&quot;</span>,
    special_tokens=[(<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>, sep_token_id), (<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>, cls_token_id)],
)`,wrap:!1}}),lt=new T({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuLi4lMjIlMkMlMjAlMjJvbiUyMGElMjBwYWlyJTIwb2YlMjBzZW50ZW5jZXMhJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2VucyklMEFwcmludChlbmNvZGluZy50eXBlX2lkcyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer...&quot;</span>, <span class="hljs-string">&quot;on a pair of sentences!&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)
<span class="hljs-built_in">print</span>(encoding.type_ids)`,wrap:!1}}),nt=new T({props:{code:"JTVCJyVFMiU5NiU4MUxldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJyVFMiU5NiU4MXRlc3QnJTJDJTIwJyVFMiU5NiU4MXRoaXMnJTJDJTIwJyVFMiU5NiU4MXRvJyUyQyUyMCdrZW4nJTJDJTIwJ2l6ZXInJTJDJTIwJy4nJTJDJTIwJy4nJTJDJTIwJy4nJTJDJTIwJyUzQ3NlcCUzRSclMkMlMjAnJUUyJTk2JTgxJyUyQyUyMCdvbiclMkMlMjAnJUUyJTk2JTgxJyUyQyUyMCdhJyUyQyUyMCclRTIlOTYlODFwYWlyJyUyQyUyMCUwQSUyMCUyMCclRTIlOTYlODFvZiclMkMlMjAnJUUyJTk2JTgxc2VudGVuY2UnJTJDJTIwJ3MnJTJDJTIwJyEnJTJDJTIwJyUzQ3NlcCUzRSclMkMlMjAnJTNDY2xzJTNFJyU1RCUwQSU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAyJTVE",highlighted:`[<span class="hljs-string">&#x27;▁Let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;▁test&#x27;</span>, <span class="hljs-string">&#x27;▁this&#x27;</span>, <span class="hljs-string">&#x27;▁to&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;&lt;sep&gt;&#x27;</span>, <span class="hljs-string">&#x27;▁&#x27;</span>, <span class="hljs-string">&#x27;on&#x27;</span>, <span class="hljs-string">&#x27;▁&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;▁pair&#x27;</span>, 
  <span class="hljs-string">&#x27;▁of&#x27;</span>, <span class="hljs-string">&#x27;▁sentence&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;!&#x27;</span>, <span class="hljs-string">&#x27;&lt;sep&gt;&#x27;</span>, <span class="hljs-string">&#x27;&lt;cls&gt;&#x27;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),at=new T({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5NZXRhc3BhY2UoKQ==",highlighted:"tokenizer.decoder = decoders.Metaspace()",wrap:!1}}),rt=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYm9zX3Rva2VuJTNEJTIyJTNDcyUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMGVvc190b2tlbiUzRCUyMiUzQyUyRnMlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjB1bmtfdG9rZW4lM0QlMjIlM0N1bmslM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWRfdG9rZW4lM0QlMjIlM0NwYWQlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBjbHNfdG9rZW4lM0QlMjIlM0NjbHMlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXBfdG9rZW4lM0QlMjIlM0NzZXAlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXNrX3Rva2VuJTNEJTIyJTNDbWFzayUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    bos_token=<span class="hljs-string">&quot;&lt;s&gt;&quot;</span>,
    eos_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>,
    unk_token=<span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>,
    pad_token=<span class="hljs-string">&quot;&lt;pad&gt;&quot;</span>,
    cls_token=<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>,
    sep_token=<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>,
    mask_token=<span class="hljs-string">&quot;&lt;mask&gt;&quot;</span>,
    padding_side=<span class="hljs-string">&quot;left&quot;</span>,
)`,wrap:!1}}),ot=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFhMTmV0VG9rZW5pemVyRmFzdCUwQSUwQXdyYXBwZWRfdG9rZW5pemVyJTIwJTNEJTIwWExOZXRUb2tlbml6ZXJGYXN0KHRva2VuaXplcl9vYmplY3QlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLNetTokenizerFast

wrapped_tokenizer = XLNetTokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),yt=new qa({props:{source:"https://github.com/huggingface/course/blob/main/chapters/zh-CN/chapter6/8.mdx"}}),{c(){j=a("meta"),w=n(),f=a("p"),u=n(),M(d.$$.fragment),k=n(),M(U.$$.fragment),jt=n(),M(g.$$.fragment),kt=n(),x=a("p"),x.textContent=op,ut=n(),h=a("ul"),h.innerHTML=cp,Ut=n(),C=a("p"),C.textContent=yp,ft=n(),$=a("div"),$.innerHTML=mp,dt=n(),z=a("p"),z.innerHTML=Jp,$t=n(),M(I.$$.fragment),bt=n(),Z=a("p"),Z.innerHTML=Tp,wt=n(),V=a("ul"),V.innerHTML=jp,gt=n(),v=a("p"),v.innerHTML=kp,xt=n(),M(_.$$.fragment),ht=n(),B=a("p"),B.innerHTML=up,Ct=n(),M(Q.$$.fragment),zt=n(),W=a("p"),W.innerHTML=Up,It=n(),R=a("p"),R.textContent=fp,Zt=n(),M(N.$$.fragment),Vt=n(),X=a("p"),X.textContent=dp,vt=n(),M(A.$$.fragment),_t=n(),G=a("p"),G.innerHTML=$p,Bt=n(),L=a("p"),L.innerHTML=bp,Qt=n(),M(q.$$.fragment),Wt=n(),H=a("p"),H.innerHTML=wp,Rt=n(),D=a("p"),D.innerHTML=gp,Nt=n(),M(E.$$.fragment),Xt=n(),S=a("p"),S.innerHTML=xp,At=n(),M(P.$$.fragment),Gt=n(),F=a("p"),F.innerHTML=hp,Lt=n(),Y=a("p"),Y.innerHTML=Cp,qt=n(),M(K.$$.fragment),Ht=n(),M(O.$$.fragment),Dt=n(),M(b.$$.fragment),Et=n(),ee=a("p"),ee.innerHTML=zp,St=n(),M(se.$$.fragment),Pt=n(),te=a("p"),te.textContent=Ip,Ft=n(),M(le.$$.fragment),Yt=n(),ne=a("p"),ne.innerHTML=Zp,Kt=n(),M(pe.$$.fragment),Ot=n(),M(ae.$$.fragment),el=n(),ie=a("p"),ie.innerHTML=Vp,sl=n(),M(re.$$.fragment),tl=n(),M(Me.$$.fragment),ll=n(),oe=a("p"),oe.innerHTML=vp,nl=n(),M(ce.$$.fragment),pl=n(),M(ye.$$.fragment),al=n(),me=a("p"),me.innerHTML=_p,il=n(),M(Je.$$.fragment),rl=n(),Te=a("p"),Te.innerHTML=Bp,Ml=n(),je=a("p"),je.textContent=Qp,ol=n(),M(ke.$$.fragment),cl=n(),ue=a("p"),ue.innerHTML=Wp,yl=n(),M(Ue.$$.fragment),ml=n(),fe=a("p"),fe.innerHTML=Rp,Jl=n(),M(de.$$.fragment),Tl=n(),M($e.$$.fragment),jl=n(),be=a("p"),be.innerHTML=Np,kl=n(),we=a("p"),we.innerHTML=Xp,ul=n(),M(ge.$$.fragment),Ul=n(),M(xe.$$.fragment),fl=n(),he=a("p"),he.innerHTML=Ap,dl=n(),Ce=a("p"),Ce.textContent=Gp,$l=n(),M(ze.$$.fragment),bl=n(),Ie=a("p"),Ie.textContent=Lp,wl=n(),Ze=a("p"),Ze.textContent=qp,gl=n(),M(Ve.$$.fragment),xl=n(),M(ve.$$.fragment),hl=n(),_e=a("p"),_e.textContent=Hp,Cl=n(),M(Be.$$.fragment),zl=n(),M(Qe.$$.fragment),Il=n(),We=a("p"),We.textContent=Dp,Zl=n(),M(Re.$$.fragment),Vl=n(),Ne=a("p"),Ne.innerHTML=Ep,vl=n(),M(Xe.$$.fragment),_l=n(),M(Ae.$$.fragment),Bl=n(),Ge=a("p"),Ge.textContent=Sp,Ql=n(),M(Le.$$.fragment),Wl=n(),qe=a("p"),qe.innerHTML=Pp,Rl=n(),M(He.$$.fragment),Nl=n(),De=a("p"),De.innerHTML=Fp,Xl=n(),Ee=a("p"),Ee.innerHTML=Yp,Al=n(),M(Se.$$.fragment),Gl=n(),Pe=a("p"),Pe.innerHTML=Kp,Ll=n(),M(Fe.$$.fragment),ql=n(),Ye=a("p"),Ye.innerHTML=Op,Hl=n(),Ke=a("p"),Ke.textContent=ea,Dl=n(),M(Oe.$$.fragment),El=n(),es=a("p"),es.innerHTML=sa,Sl=n(),M(ss.$$.fragment),Pl=n(),ts=a("p"),ts.innerHTML=ta,Fl=n(),ls=a("p"),ls.innerHTML=la,Yl=n(),M(ns.$$.fragment),Kl=n(),ps=a("p"),ps.innerHTML=na,Ol=n(),M(as.$$.fragment),en=n(),M(is.$$.fragment),sn=n(),rs=a("p"),rs.textContent=pa,tn=n(),M(Ms.$$.fragment),ln=n(),os=a("p"),os.innerHTML=aa,nn=n(),cs=a("p"),cs.textContent=ia,pn=n(),M(ys.$$.fragment),an=n(),ms=a("p"),ms.textContent=ra,rn=n(),M(Js.$$.fragment),Mn=n(),M(Ts.$$.fragment),on=n(),js=a("p"),js.textContent=Ma,cn=n(),M(ks.$$.fragment),yn=n(),us=a("p"),us.innerHTML=oa,mn=n(),M(Us.$$.fragment),Jn=n(),M(fs.$$.fragment),Tn=n(),ds=a("p"),ds.textContent=ca,jn=n(),M($s.$$.fragment),kn=n(),bs=a("p"),bs.textContent=ya,un=n(),M(ws.$$.fragment),Un=n(),M(gs.$$.fragment),fn=n(),xs=a("p"),xs.innerHTML=ma,dn=n(),M(hs.$$.fragment),$n=n(),Cs=a("p"),Cs.textContent=Ja,bn=n(),M(zs.$$.fragment),wn=n(),Is=a("p"),Is.textContent=Ta,gn=n(),M(Zs.$$.fragment),xn=n(),Vs=a("p"),Vs.innerHTML=ja,hn=n(),M(vs.$$.fragment),Cn=n(),_s=a("p"),_s.textContent=ka,zn=n(),Bs=a("p"),Bs.textContent=ua,In=n(),M(Qs.$$.fragment),Zn=n(),Ws=a("p"),Ws.innerHTML=Ua,Vn=n(),Rs=a("p"),Rs.innerHTML=fa,vn=n(),M(Ns.$$.fragment),_n=n(),Xs=a("p"),Xs.textContent=da,Bn=n(),M(As.$$.fragment),Qn=n(),M(Gs.$$.fragment),Wn=n(),Ls=a("p"),Ls.textContent=$a,Rn=n(),M(qs.$$.fragment),Nn=n(),Hs=a("p"),Hs.innerHTML=ba,Xn=n(),Ds=a("p"),Ds.textContent=wa,An=n(),M(Es.$$.fragment),Gn=n(),Ss=a("p"),Ss.textContent=ga,Ln=n(),M(Ps.$$.fragment),qn=n(),M(Fs.$$.fragment),Hn=n(),Ys=a("p"),Ys.innerHTML=xa,Dn=n(),M(Ks.$$.fragment),En=n(),M(Os.$$.fragment),Sn=n(),et=a("p"),et.textContent=ha,Pn=n(),M(st.$$.fragment),Fn=n(),tt=a("p"),tt.textContent=Ca,Yn=n(),M(lt.$$.fragment),Kn=n(),M(nt.$$.fragment),On=n(),pt=a("p"),pt.innerHTML=za,ep=n(),M(at.$$.fragment),sp=n(),it=a("p"),it.innerHTML=Ia,tp=n(),M(rt.$$.fragment),lp=n(),Mt=a("p"),Mt.textContent=Za,np=n(),M(ot.$$.fragment),pp=n(),ct=a("p"),ct.textContent=Va,ap=n(),M(yt.$$.fragment),ip=n(),mt=a("p"),this.h()},l(e){const s=Xa("svelte-u9bgzb",document.head);j=i(s,"META",{name:!0,content:!0}),s.forEach(t),w=p(e),f=i(e,"P",{}),_a(f).forEach(t),u=p(e),o(d.$$.fragment,e),k=p(e),o(U.$$.fragment,e),jt=p(e),o(g.$$.fragment,e),kt=p(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1l229f0"&&(x.textContent=op),ut=p(e),h=i(e,"UL",{"data-svelte-h":!0}),r(h)!=="svelte-1afkc51"&&(h.innerHTML=cp),Ut=p(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1lp6zkp"&&(C.textContent=yp),ft=p(e),$=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r($)!=="svelte-oxfng3"&&($.innerHTML=mp),dt=p(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-3wijst"&&(z.innerHTML=Jp),$t=p(e),o(I.$$.fragment,e),bt=p(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-14xicb7"&&(Z.innerHTML=Tp),wt=p(e),V=i(e,"UL",{"data-svelte-h":!0}),r(V)!=="svelte-aq54ei"&&(V.innerHTML=jp),gt=p(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-lm4vlq"&&(v.innerHTML=kp),xt=p(e),o(_.$$.fragment,e),ht=p(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-h304cz"&&(B.innerHTML=up),Ct=p(e),o(Q.$$.fragment,e),zt=p(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-k47fs5"&&(W.innerHTML=Up),It=p(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-r885a"&&(R.textContent=fp),Zt=p(e),o(N.$$.fragment,e),Vt=p(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1h3dg4b"&&(X.textContent=dp),vt=p(e),o(A.$$.fragment,e),_t=p(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-shwjxs"&&(G.innerHTML=$p),Bt=p(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-3wlynn"&&(L.innerHTML=bp),Qt=p(e),o(q.$$.fragment,e),Wt=p(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1fwm2oe"&&(H.innerHTML=wp),Rt=p(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1t6ckvm"&&(D.innerHTML=gp),Nt=p(e),o(E.$$.fragment,e),Xt=p(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1qckmck"&&(S.innerHTML=xp),At=p(e),o(P.$$.fragment,e),Gt=p(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1kameru"&&(F.innerHTML=hp),Lt=p(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-bar1jo"&&(Y.innerHTML=Cp),qt=p(e),o(K.$$.fragment,e),Ht=p(e),o(O.$$.fragment,e),Dt=p(e),o(b.$$.fragment,e),Et=p(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1v7hck5"&&(ee.innerHTML=zp),St=p(e),o(se.$$.fragment,e),Pt=p(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-vuawww"&&(te.textContent=Ip),Ft=p(e),o(le.$$.fragment,e),Yt=p(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1tk5vrx"&&(ne.innerHTML=Zp),Kt=p(e),o(pe.$$.fragment,e),Ot=p(e),o(ae.$$.fragment,e),el=p(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-vusm0g"&&(ie.innerHTML=Vp),sl=p(e),o(re.$$.fragment,e),tl=p(e),o(Me.$$.fragment,e),ll=p(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1gr3a1c"&&(oe.innerHTML=vp),nl=p(e),o(ce.$$.fragment,e),pl=p(e),o(ye.$$.fragment,e),al=p(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1j2tkt5"&&(me.innerHTML=_p),il=p(e),o(Je.$$.fragment,e),rl=p(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-sr9wyd"&&(Te.innerHTML=Bp),Ml=p(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-11kfccl"&&(je.textContent=Qp),ol=p(e),o(ke.$$.fragment,e),cl=p(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1idb5q1"&&(ue.innerHTML=Wp),yl=p(e),o(Ue.$$.fragment,e),ml=p(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-gs4pzl"&&(fe.innerHTML=Rp),Jl=p(e),o(de.$$.fragment,e),Tl=p(e),o($e.$$.fragment,e),jl=p(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1dxwx8l"&&(be.innerHTML=Np),kl=p(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-d04344"&&(we.innerHTML=Xp),ul=p(e),o(ge.$$.fragment,e),Ul=p(e),o(xe.$$.fragment,e),fl=p(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-w8pwca"&&(he.innerHTML=Ap),dl=p(e),Ce=i(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-b5qu8g"&&(Ce.textContent=Gp),$l=p(e),o(ze.$$.fragment,e),bl=p(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-92l6jr"&&(Ie.textContent=Lp),wl=p(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-lguo0j"&&(Ze.textContent=qp),gl=p(e),o(Ve.$$.fragment,e),xl=p(e),o(ve.$$.fragment,e),hl=p(e),_e=i(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-6cqgdg"&&(_e.textContent=Hp),Cl=p(e),o(Be.$$.fragment,e),zl=p(e),o(Qe.$$.fragment,e),Il=p(e),We=i(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-5s8q42"&&(We.textContent=Dp),Zl=p(e),o(Re.$$.fragment,e),Vl=p(e),Ne=i(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-15gpweu"&&(Ne.innerHTML=Ep),vl=p(e),o(Xe.$$.fragment,e),_l=p(e),o(Ae.$$.fragment,e),Bl=p(e),Ge=i(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-18ulh5y"&&(Ge.textContent=Sp),Ql=p(e),o(Le.$$.fragment,e),Wl=p(e),qe=i(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-3ftdzw"&&(qe.innerHTML=Pp),Rl=p(e),o(He.$$.fragment,e),Nl=p(e),De=i(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-1xiknfs"&&(De.innerHTML=Fp),Xl=p(e),Ee=i(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-1wz2yfc"&&(Ee.innerHTML=Yp),Al=p(e),o(Se.$$.fragment,e),Gl=p(e),Pe=i(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1vrtr3f"&&(Pe.innerHTML=Kp),Ll=p(e),o(Fe.$$.fragment,e),ql=p(e),Ye=i(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-iygluh"&&(Ye.innerHTML=Op),Hl=p(e),Ke=i(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-1nve07z"&&(Ke.textContent=ea),Dl=p(e),o(Oe.$$.fragment,e),El=p(e),es=i(e,"P",{"data-svelte-h":!0}),r(es)!=="svelte-18jz4b6"&&(es.innerHTML=sa),Sl=p(e),o(ss.$$.fragment,e),Pl=p(e),ts=i(e,"P",{"data-svelte-h":!0}),r(ts)!=="svelte-1qs6c1r"&&(ts.innerHTML=ta),Fl=p(e),ls=i(e,"P",{"data-svelte-h":!0}),r(ls)!=="svelte-1t5a1tr"&&(ls.innerHTML=la),Yl=p(e),o(ns.$$.fragment,e),Kl=p(e),ps=i(e,"P",{"data-svelte-h":!0}),r(ps)!=="svelte-9b356c"&&(ps.innerHTML=na),Ol=p(e),o(as.$$.fragment,e),en=p(e),o(is.$$.fragment,e),sn=p(e),rs=i(e,"P",{"data-svelte-h":!0}),r(rs)!=="svelte-1ibccev"&&(rs.textContent=pa),tn=p(e),o(Ms.$$.fragment,e),ln=p(e),os=i(e,"P",{"data-svelte-h":!0}),r(os)!=="svelte-1htjvs9"&&(os.innerHTML=aa),nn=p(e),cs=i(e,"P",{"data-svelte-h":!0}),r(cs)!=="svelte-9zdx5b"&&(cs.textContent=ia),pn=p(e),o(ys.$$.fragment,e),an=p(e),ms=i(e,"P",{"data-svelte-h":!0}),r(ms)!=="svelte-f9ey0e"&&(ms.textContent=ra),rn=p(e),o(Js.$$.fragment,e),Mn=p(e),o(Ts.$$.fragment,e),on=p(e),js=i(e,"P",{"data-svelte-h":!0}),r(js)!=="svelte-1dk3fb5"&&(js.textContent=Ma),cn=p(e),o(ks.$$.fragment,e),yn=p(e),us=i(e,"P",{"data-svelte-h":!0}),r(us)!=="svelte-lmmp0z"&&(us.innerHTML=oa),mn=p(e),o(Us.$$.fragment,e),Jn=p(e),o(fs.$$.fragment,e),Tn=p(e),ds=i(e,"P",{"data-svelte-h":!0}),r(ds)!=="svelte-1bu1bm"&&(ds.textContent=ca),jn=p(e),o($s.$$.fragment,e),kn=p(e),bs=i(e,"P",{"data-svelte-h":!0}),r(bs)!=="svelte-u3j12w"&&(bs.textContent=ya),un=p(e),o(ws.$$.fragment,e),Un=p(e),o(gs.$$.fragment,e),fn=p(e),xs=i(e,"P",{"data-svelte-h":!0}),r(xs)!=="svelte-1vzdefe"&&(xs.innerHTML=ma),dn=p(e),o(hs.$$.fragment,e),$n=p(e),Cs=i(e,"P",{"data-svelte-h":!0}),r(Cs)!=="svelte-fzp8ed"&&(Cs.textContent=Ja),bn=p(e),o(zs.$$.fragment,e),wn=p(e),Is=i(e,"P",{"data-svelte-h":!0}),r(Is)!=="svelte-1ydc4ba"&&(Is.textContent=Ta),gn=p(e),o(Zs.$$.fragment,e),xn=p(e),Vs=i(e,"P",{"data-svelte-h":!0}),r(Vs)!=="svelte-6rfid6"&&(Vs.innerHTML=ja),hn=p(e),o(vs.$$.fragment,e),Cn=p(e),_s=i(e,"P",{"data-svelte-h":!0}),r(_s)!=="svelte-1jkt6ld"&&(_s.textContent=ka),zn=p(e),Bs=i(e,"P",{"data-svelte-h":!0}),r(Bs)!=="svelte-187158j"&&(Bs.textContent=ua),In=p(e),o(Qs.$$.fragment,e),Zn=p(e),Ws=i(e,"P",{"data-svelte-h":!0}),r(Ws)!=="svelte-15dsv2a"&&(Ws.innerHTML=Ua),Vn=p(e),Rs=i(e,"P",{"data-svelte-h":!0}),r(Rs)!=="svelte-1jqpw05"&&(Rs.innerHTML=fa),vn=p(e),o(Ns.$$.fragment,e),_n=p(e),Xs=i(e,"P",{"data-svelte-h":!0}),r(Xs)!=="svelte-4jou9m"&&(Xs.textContent=da),Bn=p(e),o(As.$$.fragment,e),Qn=p(e),o(Gs.$$.fragment,e),Wn=p(e),Ls=i(e,"P",{"data-svelte-h":!0}),r(Ls)!=="svelte-w73zlc"&&(Ls.textContent=$a),Rn=p(e),o(qs.$$.fragment,e),Nn=p(e),Hs=i(e,"P",{"data-svelte-h":!0}),r(Hs)!=="svelte-17zoz2j"&&(Hs.innerHTML=ba),Xn=p(e),Ds=i(e,"P",{"data-svelte-h":!0}),r(Ds)!=="svelte-9zdx5b"&&(Ds.textContent=wa),An=p(e),o(Es.$$.fragment,e),Gn=p(e),Ss=i(e,"P",{"data-svelte-h":!0}),r(Ss)!=="svelte-18crjnk"&&(Ss.textContent=ga),Ln=p(e),o(Ps.$$.fragment,e),qn=p(e),o(Fs.$$.fragment,e),Hn=p(e),Ys=i(e,"P",{"data-svelte-h":!0}),r(Ys)!=="svelte-xt4fe9"&&(Ys.innerHTML=xa),Dn=p(e),o(Ks.$$.fragment,e),En=p(e),o(Os.$$.fragment,e),Sn=p(e),et=i(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-ose5sl"&&(et.textContent=ha),Pn=p(e),o(st.$$.fragment,e),Fn=p(e),tt=i(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-4pbeet"&&(tt.textContent=Ca),Yn=p(e),o(lt.$$.fragment,e),Kn=p(e),o(nt.$$.fragment,e),On=p(e),pt=i(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-y80rw8"&&(pt.innerHTML=za),ep=p(e),o(at.$$.fragment,e),sp=p(e),it=i(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-1arw03s"&&(it.innerHTML=Ia),tp=p(e),o(rt.$$.fragment,e),lp=p(e),Mt=i(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-fzp8ed"&&(Mt.textContent=Za),np=p(e),o(ot.$$.fragment,e),pp=p(e),ct=i(e,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-chgqxl"&&(ct.textContent=Va),ap=p(e),o(yt.$$.fragment,e),ip=p(e),mt=i(e,"P",{}),_a(mt).forEach(t),this.h()},h(){Mp(j,"name","hf:doc:metadata"),Mp(j,"content",Pa),Mp($,"class","flex justify-center")},m(e,s){Aa(document.head,j),l(e,w,s),l(e,f,s),l(e,u,s),c(d,e,s),l(e,k,s),c(U,e,s),l(e,jt,s),c(g,e,s),l(e,kt,s),l(e,x,s),l(e,ut,s),l(e,h,s),l(e,Ut,s),l(e,C,s),l(e,ft,s),l(e,$,s),l(e,dt,s),l(e,z,s),l(e,$t,s),c(I,e,s),l(e,bt,s),l(e,Z,s),l(e,wt,s),l(e,V,s),l(e,gt,s),l(e,v,s),l(e,xt,s),c(_,e,s),l(e,ht,s),l(e,B,s),l(e,Ct,s),c(Q,e,s),l(e,zt,s),l(e,W,s),l(e,It,s),l(e,R,s),l(e,Zt,s),c(N,e,s),l(e,Vt,s),l(e,X,s),l(e,vt,s),c(A,e,s),l(e,_t,s),l(e,G,s),l(e,Bt,s),l(e,L,s),l(e,Qt,s),c(q,e,s),l(e,Wt,s),l(e,H,s),l(e,Rt,s),l(e,D,s),l(e,Nt,s),c(E,e,s),l(e,Xt,s),l(e,S,s),l(e,At,s),c(P,e,s),l(e,Gt,s),l(e,F,s),l(e,Lt,s),l(e,Y,s),l(e,qt,s),c(K,e,s),l(e,Ht,s),c(O,e,s),l(e,Dt,s),c(b,e,s),l(e,Et,s),l(e,ee,s),l(e,St,s),c(se,e,s),l(e,Pt,s),l(e,te,s),l(e,Ft,s),c(le,e,s),l(e,Yt,s),l(e,ne,s),l(e,Kt,s),c(pe,e,s),l(e,Ot,s),c(ae,e,s),l(e,el,s),l(e,ie,s),l(e,sl,s),c(re,e,s),l(e,tl,s),c(Me,e,s),l(e,ll,s),l(e,oe,s),l(e,nl,s),c(ce,e,s),l(e,pl,s),c(ye,e,s),l(e,al,s),l(e,me,s),l(e,il,s),c(Je,e,s),l(e,rl,s),l(e,Te,s),l(e,Ml,s),l(e,je,s),l(e,ol,s),c(ke,e,s),l(e,cl,s),l(e,ue,s),l(e,yl,s),c(Ue,e,s),l(e,ml,s),l(e,fe,s),l(e,Jl,s),c(de,e,s),l(e,Tl,s),c($e,e,s),l(e,jl,s),l(e,be,s),l(e,kl,s),l(e,we,s),l(e,ul,s),c(ge,e,s),l(e,Ul,s),c(xe,e,s),l(e,fl,s),l(e,he,s),l(e,dl,s),l(e,Ce,s),l(e,$l,s),c(ze,e,s),l(e,bl,s),l(e,Ie,s),l(e,wl,s),l(e,Ze,s),l(e,gl,s),c(Ve,e,s),l(e,xl,s),c(ve,e,s),l(e,hl,s),l(e,_e,s),l(e,Cl,s),c(Be,e,s),l(e,zl,s),c(Qe,e,s),l(e,Il,s),l(e,We,s),l(e,Zl,s),c(Re,e,s),l(e,Vl,s),l(e,Ne,s),l(e,vl,s),c(Xe,e,s),l(e,_l,s),c(Ae,e,s),l(e,Bl,s),l(e,Ge,s),l(e,Ql,s),c(Le,e,s),l(e,Wl,s),l(e,qe,s),l(e,Rl,s),c(He,e,s),l(e,Nl,s),l(e,De,s),l(e,Xl,s),l(e,Ee,s),l(e,Al,s),c(Se,e,s),l(e,Gl,s),l(e,Pe,s),l(e,Ll,s),c(Fe,e,s),l(e,ql,s),l(e,Ye,s),l(e,Hl,s),l(e,Ke,s),l(e,Dl,s),c(Oe,e,s),l(e,El,s),l(e,es,s),l(e,Sl,s),c(ss,e,s),l(e,Pl,s),l(e,ts,s),l(e,Fl,s),l(e,ls,s),l(e,Yl,s),c(ns,e,s),l(e,Kl,s),l(e,ps,s),l(e,Ol,s),c(as,e,s),l(e,en,s),c(is,e,s),l(e,sn,s),l(e,rs,s),l(e,tn,s),c(Ms,e,s),l(e,ln,s),l(e,os,s),l(e,nn,s),l(e,cs,s),l(e,pn,s),c(ys,e,s),l(e,an,s),l(e,ms,s),l(e,rn,s),c(Js,e,s),l(e,Mn,s),c(Ts,e,s),l(e,on,s),l(e,js,s),l(e,cn,s),c(ks,e,s),l(e,yn,s),l(e,us,s),l(e,mn,s),c(Us,e,s),l(e,Jn,s),c(fs,e,s),l(e,Tn,s),l(e,ds,s),l(e,jn,s),c($s,e,s),l(e,kn,s),l(e,bs,s),l(e,un,s),c(ws,e,s),l(e,Un,s),c(gs,e,s),l(e,fn,s),l(e,xs,s),l(e,dn,s),c(hs,e,s),l(e,$n,s),l(e,Cs,s),l(e,bn,s),c(zs,e,s),l(e,wn,s),l(e,Is,s),l(e,gn,s),c(Zs,e,s),l(e,xn,s),l(e,Vs,s),l(e,hn,s),c(vs,e,s),l(e,Cn,s),l(e,_s,s),l(e,zn,s),l(e,Bs,s),l(e,In,s),c(Qs,e,s),l(e,Zn,s),l(e,Ws,s),l(e,Vn,s),l(e,Rs,s),l(e,vn,s),c(Ns,e,s),l(e,_n,s),l(e,Xs,s),l(e,Bn,s),c(As,e,s),l(e,Qn,s),c(Gs,e,s),l(e,Wn,s),l(e,Ls,s),l(e,Rn,s),c(qs,e,s),l(e,Nn,s),l(e,Hs,s),l(e,Xn,s),l(e,Ds,s),l(e,An,s),c(Es,e,s),l(e,Gn,s),l(e,Ss,s),l(e,Ln,s),c(Ps,e,s),l(e,qn,s),c(Fs,e,s),l(e,Hn,s),l(e,Ys,s),l(e,Dn,s),c(Ks,e,s),l(e,En,s),c(Os,e,s),l(e,Sn,s),l(e,et,s),l(e,Pn,s),c(st,e,s),l(e,Fn,s),l(e,tt,s),l(e,Yn,s),c(lt,e,s),l(e,Kn,s),c(nt,e,s),l(e,On,s),l(e,pt,s),l(e,ep,s),c(at,e,s),l(e,sp,s),l(e,it,s),l(e,tp,s),c(rt,e,s),l(e,lp,s),l(e,Mt,s),l(e,np,s),c(ot,e,s),l(e,pp,s),l(e,ct,s),l(e,ap,s),c(yt,e,s),l(e,ip,s),l(e,mt,s),rp=!0},p(e,[s]){const va={};s&2&&(va.$$scope={dirty:s,ctx:e}),b.$set(va)},i(e){rp||(y(d.$$.fragment,e),y(U.$$.fragment,e),y(g.$$.fragment,e),y(I.$$.fragment,e),y(_.$$.fragment,e),y(Q.$$.fragment,e),y(N.$$.fragment,e),y(A.$$.fragment,e),y(q.$$.fragment,e),y(E.$$.fragment,e),y(P.$$.fragment,e),y(K.$$.fragment,e),y(O.$$.fragment,e),y(b.$$.fragment,e),y(se.$$.fragment,e),y(le.$$.fragment,e),y(pe.$$.fragment,e),y(ae.$$.fragment,e),y(re.$$.fragment,e),y(Me.$$.fragment,e),y(ce.$$.fragment,e),y(ye.$$.fragment,e),y(Je.$$.fragment,e),y(ke.$$.fragment,e),y(Ue.$$.fragment,e),y(de.$$.fragment,e),y($e.$$.fragment,e),y(ge.$$.fragment,e),y(xe.$$.fragment,e),y(ze.$$.fragment,e),y(Ve.$$.fragment,e),y(ve.$$.fragment,e),y(Be.$$.fragment,e),y(Qe.$$.fragment,e),y(Re.$$.fragment,e),y(Xe.$$.fragment,e),y(Ae.$$.fragment,e),y(Le.$$.fragment,e),y(He.$$.fragment,e),y(Se.$$.fragment,e),y(Fe.$$.fragment,e),y(Oe.$$.fragment,e),y(ss.$$.fragment,e),y(ns.$$.fragment,e),y(as.$$.fragment,e),y(is.$$.fragment,e),y(Ms.$$.fragment,e),y(ys.$$.fragment,e),y(Js.$$.fragment,e),y(Ts.$$.fragment,e),y(ks.$$.fragment,e),y(Us.$$.fragment,e),y(fs.$$.fragment,e),y($s.$$.fragment,e),y(ws.$$.fragment,e),y(gs.$$.fragment,e),y(hs.$$.fragment,e),y(zs.$$.fragment,e),y(Zs.$$.fragment,e),y(vs.$$.fragment,e),y(Qs.$$.fragment,e),y(Ns.$$.fragment,e),y(As.$$.fragment,e),y(Gs.$$.fragment,e),y(qs.$$.fragment,e),y(Es.$$.fragment,e),y(Ps.$$.fragment,e),y(Fs.$$.fragment,e),y(Ks.$$.fragment,e),y(Os.$$.fragment,e),y(st.$$.fragment,e),y(lt.$$.fragment,e),y(nt.$$.fragment,e),y(at.$$.fragment,e),y(rt.$$.fragment,e),y(ot.$$.fragment,e),y(yt.$$.fragment,e),rp=!0)},o(e){m(d.$$.fragment,e),m(U.$$.fragment,e),m(g.$$.fragment,e),m(I.$$.fragment,e),m(_.$$.fragment,e),m(Q.$$.fragment,e),m(N.$$.fragment,e),m(A.$$.fragment,e),m(q.$$.fragment,e),m(E.$$.fragment,e),m(P.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),m(b.$$.fragment,e),m(se.$$.fragment,e),m(le.$$.fragment,e),m(pe.$$.fragment,e),m(ae.$$.fragment,e),m(re.$$.fragment,e),m(Me.$$.fragment,e),m(ce.$$.fragment,e),m(ye.$$.fragment,e),m(Je.$$.fragment,e),m(ke.$$.fragment,e),m(Ue.$$.fragment,e),m(de.$$.fragment,e),m($e.$$.fragment,e),m(ge.$$.fragment,e),m(xe.$$.fragment,e),m(ze.$$.fragment,e),m(Ve.$$.fragment,e),m(ve.$$.fragment,e),m(Be.$$.fragment,e),m(Qe.$$.fragment,e),m(Re.$$.fragment,e),m(Xe.$$.fragment,e),m(Ae.$$.fragment,e),m(Le.$$.fragment,e),m(He.$$.fragment,e),m(Se.$$.fragment,e),m(Fe.$$.fragment,e),m(Oe.$$.fragment,e),m(ss.$$.fragment,e),m(ns.$$.fragment,e),m(as.$$.fragment,e),m(is.$$.fragment,e),m(Ms.$$.fragment,e),m(ys.$$.fragment,e),m(Js.$$.fragment,e),m(Ts.$$.fragment,e),m(ks.$$.fragment,e),m(Us.$$.fragment,e),m(fs.$$.fragment,e),m($s.$$.fragment,e),m(ws.$$.fragment,e),m(gs.$$.fragment,e),m(hs.$$.fragment,e),m(zs.$$.fragment,e),m(Zs.$$.fragment,e),m(vs.$$.fragment,e),m(Qs.$$.fragment,e),m(Ns.$$.fragment,e),m(As.$$.fragment,e),m(Gs.$$.fragment,e),m(qs.$$.fragment,e),m(Es.$$.fragment,e),m(Ps.$$.fragment,e),m(Fs.$$.fragment,e),m(Ks.$$.fragment,e),m(Os.$$.fragment,e),m(st.$$.fragment,e),m(lt.$$.fragment,e),m(nt.$$.fragment,e),m(at.$$.fragment,e),m(rt.$$.fragment,e),m(ot.$$.fragment,e),m(yt.$$.fragment,e),rp=!1},d(e){e&&(t(w),t(f),t(u),t(k),t(jt),t(kt),t(x),t(ut),t(h),t(Ut),t(C),t(ft),t($),t(dt),t(z),t($t),t(bt),t(Z),t(wt),t(V),t(gt),t(v),t(xt),t(ht),t(B),t(Ct),t(zt),t(W),t(It),t(R),t(Zt),t(Vt),t(X),t(vt),t(_t),t(G),t(Bt),t(L),t(Qt),t(Wt),t(H),t(Rt),t(D),t(Nt),t(Xt),t(S),t(At),t(Gt),t(F),t(Lt),t(Y),t(qt),t(Ht),t(Dt),t(Et),t(ee),t(St),t(Pt),t(te),t(Ft),t(Yt),t(ne),t(Kt),t(Ot),t(el),t(ie),t(sl),t(tl),t(ll),t(oe),t(nl),t(pl),t(al),t(me),t(il),t(rl),t(Te),t(Ml),t(je),t(ol),t(cl),t(ue),t(yl),t(ml),t(fe),t(Jl),t(Tl),t(jl),t(be),t(kl),t(we),t(ul),t(Ul),t(fl),t(he),t(dl),t(Ce),t($l),t(bl),t(Ie),t(wl),t(Ze),t(gl),t(xl),t(hl),t(_e),t(Cl),t(zl),t(Il),t(We),t(Zl),t(Vl),t(Ne),t(vl),t(_l),t(Bl),t(Ge),t(Ql),t(Wl),t(qe),t(Rl),t(Nl),t(De),t(Xl),t(Ee),t(Al),t(Gl),t(Pe),t(Ll),t(ql),t(Ye),t(Hl),t(Ke),t(Dl),t(El),t(es),t(Sl),t(Pl),t(ts),t(Fl),t(ls),t(Yl),t(Kl),t(ps),t(Ol),t(en),t(sn),t(rs),t(tn),t(ln),t(os),t(nn),t(cs),t(pn),t(an),t(ms),t(rn),t(Mn),t(on),t(js),t(cn),t(yn),t(us),t(mn),t(Jn),t(Tn),t(ds),t(jn),t(kn),t(bs),t(un),t(Un),t(fn),t(xs),t(dn),t($n),t(Cs),t(bn),t(wn),t(Is),t(gn),t(xn),t(Vs),t(hn),t(Cn),t(_s),t(zn),t(Bs),t(In),t(Zn),t(Ws),t(Vn),t(Rs),t(vn),t(_n),t(Xs),t(Bn),t(Qn),t(Wn),t(Ls),t(Rn),t(Nn),t(Hs),t(Xn),t(Ds),t(An),t(Gn),t(Ss),t(Ln),t(qn),t(Hn),t(Ys),t(Dn),t(En),t(Sn),t(et),t(Pn),t(Fn),t(tt),t(Yn),t(Kn),t(On),t(pt),t(ep),t(sp),t(it),t(tp),t(lp),t(Mt),t(np),t(pp),t(ct),t(ap),t(ip),t(mt)),t(j),J(d,e),J(U,e),J(g,e),J(I,e),J(_,e),J(Q,e),J(N,e),J(A,e),J(q,e),J(E,e),J(P,e),J(K,e),J(O,e),J(b,e),J(se,e),J(le,e),J(pe,e),J(ae,e),J(re,e),J(Me,e),J(ce,e),J(ye,e),J(Je,e),J(ke,e),J(Ue,e),J(de,e),J($e,e),J(ge,e),J(xe,e),J(ze,e),J(Ve,e),J(ve,e),J(Be,e),J(Qe,e),J(Re,e),J(Xe,e),J(Ae,e),J(Le,e),J(He,e),J(Se,e),J(Fe,e),J(Oe,e),J(ss,e),J(ns,e),J(as,e),J(is,e),J(Ms,e),J(ys,e),J(Js,e),J(Ts,e),J(ks,e),J(Us,e),J(fs,e),J($s,e),J(ws,e),J(gs,e),J(hs,e),J(zs,e),J(Zs,e),J(vs,e),J(Qs,e),J(Ns,e),J(As,e),J(Gs,e),J(qs,e),J(Es,e),J(Ps,e),J(Fs,e),J(Ks,e),J(Os,e),J(st,e),J(lt,e),J(nt,e),J(at,e),J(rt,e),J(ot,e),J(yt,e)}}}const Pa='{"title":"模块化构建 tokenizer","local":"模块化构建 tokenizer","sections":[{"title":"获取语​​料库","local":"获取语​​料库","sections":[],"depth":2},{"title":"从头开始构建 WordPiece  tokenizer","local":"从头开始构建 WordPiece  tokenizer","sections":[],"depth":2},{"title":"从头开始构建 BPE  tokenizer","local":"从头开始构建 BPE  tokenizer","sections":[],"depth":2},{"title":"从零开始构建 Unigram  tokenizer","local":"从零开始构建 Unigram  tokenizer","sections":[],"depth":2}],"depth":1}';function Fa(Tt){return Qa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ni extends Ra{constructor(j){super(),Na(this,j,Fa,Sa,Ba,{})}}export{ni as component};
