# 章末小测试 [[章末小测试]]

`<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>`

这一章涵盖了很多内容！ 如果有一些不太明白的地方，请不要担心； 下一章将帮助你了解这些模块在底层是如何工作的。

让我们来测试一下你在这一章学到了什么！

### 1. 探索 Hub 并寻找 `roberta-large-mnli` checkpoint。 它可以完成什么类型的任务？

<Question
	choices={[
		{
			text: "文本摘要提取",
			explain: "点击前往<a href=\"https://huggingface.co/roberta-large-mnli\">`roberta-large-mnli` 页面 </a>再仔细看一下。"
		},
		{
			text: "文本分类",
			explain: "更准确地说，它能通过三个标签（矛盾，无关，蕴含）分类，判断两句话是否在逻辑上有关联——这项任务也称为自然语言推理（natural language inference）。",
			correct: true
		},
		{
			text: "文本生成",
			explain: "点击前往<a href=\"https://huggingface.co/roberta-large-mnli\">`roberta-large-mnli` 页面 `</a>`再仔细看一下。"
		}
	]}
/>

### 2. 下面的代码将会输出什么结果？

```py
from transformers import pipeline

ner = pipeline("ner", grouped_entities=True)
ner("My name is Sylvain and I work at Hugging Face in Brooklyn.")
```

<Question
	choices={[
		{
			text: "它将输出带有 \"positive\" 或者 \"negative\"标签分类的分数。",
			explain: "不对 —— <code>sentiment-analysis（情感分析）</code> pipeline才会输出这些。"
		},
		{
			text: "它将生成这句话的下一句话。",
			explain: "不对 —— <code>text-generation（文本生成）</code> pipeline才会输出这些。",
		},
		{
			text: "它找出代表人员、组织或位置的单词。",
			explain: "正解! 此外，使用 <code>grouped_entities=True</code>，可以将属于同一实体的单词组合在一起，例如“Hugging Face”。",
			correct: true
		}
	]}
/>

### 3. 在此代码示例中...的地方应该填写什么？

```py
from transformers import pipeline

filler = pipeline("fill-mask", model="bert-base-cased")
result = filler("...")
```

<Question
	choices={[
		{
			text: "This &#60;mask> has been waiting for you.",
			explain: "不对。 请查看 <code>bert-base-cased</code> 模型卡片,然后再尝试找找错在哪里。"
		},
		{
			text: "This [MASK] has been waiting for you.",
			explain: "正解! 这个模型的mask token是[MASK]。",
			correct: true
		},
		{
			text: "This man has been waiting for you.",
			explain: "不对。 这个pipeline的作用是填充经过mask的文字，因此它需要在输入中有一个mask token。"
		}
	]}
/>

### 4. 为什么这段代码会无法运行？

```py
from transformers import pipeline

classifier = pipeline("zero-shot-classification")
result = classifier("This is a course about the Transformers library")
```

<Question
	choices={[
		{
			text: "这个pipeline需要提供用来分类此文本的标签。",
			explain: "正解 —— 正确的代码需要包含：<code>candidate_labels=[...]</code>。",
			correct: true
		},
		{
			text: "这个pipeline需要多个句子，而不仅仅是一个。",
			explain: "不对。尽管正确使用时，此pipeline可以同时处理多个句子（所有其他pipeline也是一样）。"
		},
		{
			text: "🤗 Transformers库又出故障了。",
			explain: "对此，我们不予置评！"
		},
		{
			text: "该pipeline需要更长的输入； 这个句子太短了。",
			explain: "不对。 不过请注意，在这个pipeline处理太长的文本时会将其截断。"
		}
	]}
/>

### 5. “迁移学习”是什么意思？

<Question
	choices={[
		{
			text: "通过在同一数据集上再次训练模型，将预训练模型的知识迁移到新模型。",
			explain: "不，那将是同一模型的两个版本。"
		},
		{
			text: "通过使用第一个模型的权重初始化第二个模型，将预训练模型的知识迁移到新模型。",
			explain: "正确：当第二个模型接受新任务训练时，它迁移（transfers）第一个模型的知识。",
			correct: true
		},
		{
			text: "构建与第一个模型具有相同架构的第二个模型，将预训练模型的知识迁移到新模型。",
			explain: "架构只是模型的构建方式； 在这种情况下，没有知识共享或迁移。"
		}
	]}
/>

### 6. 语言模型在预训练时通常不需要标签，这样的说法是否正确。

<Question
	choices={[
		{
			text: "正确",
			explain: "预训练通常是`自监督（self-supervised）`，这意味着标签是根据输入自动创建的（例如：预测下一个单词或填充一些[MARSK]单词）。",
			correct: true
		},
		{
			text: "错误",
			explain: "这不是一个正确的答案。"
		}
	]}
/>

### 7. 选择最能描述“模型(model)”、“架构(architecture)”和“权重(weights)”的句子。

<Question
	choices={[
		{
			text: "如果模型是一座建筑物，那么它的架构就是蓝图，而权重就是住在里面的人。",
			explain: "按照这个比喻，更准确地来说权重应该是用于建造建筑物的砖块和其他材料。"
		},
		{
			text: "架构是建立模型的地图，权重是地图上表示的城市。",
			explain: "这个比喻的问题在于，一张地图通常代表只有一个确定的事实（法国只有一个城市叫巴黎）。 对于给定的体系结构，可能有多个权重。"
		},
		{
			text: "架构是用于构建模型的一系列数学函数，其权重是这些函数参数。",
			explain: "同一组数学函数（架构）可以通过使用不同的参数（权重）来构建不同的模型。",
			correct: true
		}
	]}
/>

### 8. 你将使用以下哪种类型的模型来根据输入的提示生成文本？

<Question
	choices={[
		{
			text: "“编码器”模型",
			explain: "“编码器”模型生成整个句子的表示，这种表示更适合于分类之类的任务。"
		},
		{
			text: "“解码器”模型",
			explain: "“解码器”模型非常适合根据提示生成文本。",
			correct: true
		},
		{
			text: "“序列到序列”模型",
			explain: "“序列到序列”模型更适合于根据输入句子生成句子的任务而不是给定提示。"
		}
	]}
/>

### 9. 你会使用哪些类型的模型来生成文本的摘要？

<Question
	choices={[
		{
			text: "“编码器”模型",
			explain: "“编码器”模型生成整个句子的表示，这种表示更适合于分类之类的任务。"
		},
		{
			text: "“解码器”模型",
			explain: "“解码器”模型对于生成输出文本(如摘要)很好，但它们不具备利用上下文(整个文本)进行总结的能力。"
		},
		{
			text: "“序列到序列”模型",
			explain: "“序列到序列”模型非常适合摘要任务。",
			correct: true
		}
	]}
/>

### 10. 你会使用哪一种类型的模型来根据特定的标签对文本输入进行分类？

<Question
	choices={[
		{
			text: "“编码器”模型",
			explain: "“编码器”模型可以生成整个句子的表示，非常适合分类这样的任务。",
			correct: true
		},
		{
			text: "“解码器”模型",
			explain: "“解码器”模型适合于生成输出文本，而不是从句子中提取标签。"
		},
		{
			text: "“序列到序列”模型",
			explain: "“序列到序列”模型更适合于输入句子而不是标签生成文本的任务。",
		}
	]}
/>

### 11. 模型中观察到的偏见有哪些可能的来源？

<Question
	choices={[
		{
			text: "这个模型是一个预训练模型的微调版本，它从中继承了预训练模型的偏见。",
			explain: "当进行迁移学习时，在预训练模型中产生的偏见在微调模型中不能完全去除。",
			correct: true
		},
		{
			text: "用于训练模型的数据是有偏见的。",
			explain: "这是最明显的偏见来源，但不是唯一的来源。",
			correct: true
		},
		{
			text: "模型优化的指标是有偏见的。",
			explain: "一个不太明显的偏见来源是模型的训练方式。 你的模型将盲目地只针对你选择的指标进行优化，而不会思考这样是否会带有偏见。",
			correct: true
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-CN/chapter1/10.mdx" />