# 偏见和局限性 [[偏见和局限性]]

<CourseFloatingBanner chapter={1}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/zh-CN/chapter1/section8.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/zh-CN/chapter1/section8.ipynb"},
]} />

如果你打算在正式的项目中使用经过预训练或经过微调的模型。请注意：虽然这些模型是很强大，但它们也有局限性。其中最大的一个问题是，为了对大量数据进行预训练，研究人员通常会搜集所有他们能找到的所有文字内容，中间可能夹带一些意识形态或者价值观的刻板印象。

为了快速解释清楚这个问题，让我们回到一个使用 BERT 模型的 pipeline 的例子：

```python
from transformers import pipeline

unmasker = pipeline("fill-mask", model="bert-base-uncased")
result = unmasker("This man works as a [MASK].")
print([r["token_str"] for r in result])

result = unmasker("This woman works as a [MASK].")
print([r["token_str"] for r in result])
```

```python out
['lawyer', 'carpenter', 'doctor', 'waiter', 'mechanic']
['nurse', 'waitress', 'teacher', 'maid', 'prostitute']
```
当要求模型填写这两句话中缺少的单词时，模型给出的答案中，只有一个与性别无关（服务员/女服务员）。其他职业通常与某一特定性别相关，妓女最终进入了模型中与“女人”和“工作”相关的前五位。尽管 BERT 是少数使用经过筛选和清洗后，并且看似中立的数据集上建立的的 Transformer 模型，而不是通过从互联网上搜集数据（它使用的是 [Wikipedia 英文](https://huggingface.co/datasets/wikipedia) 和 [BookCorpus](https://huggingface.co/datasets/bookcorpus) 数据集），但是这种情况还是发生了。

因此，当你使用这些工具时，你需要记住，使用的原始模型的时候，很容易生成性别歧视、种族主义或恐同内容。这种固有偏见不会随着微调模型而消失。


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-CN/chapter1/8.mdx" />