# 章末小测验 [[章末小测验]]

<CourseFloatingBanner
    chapter={6}
    classNames="absolute z-10 right-0 top-0"
/>

让我们测试一下你在本章中学到了什么！

### 1．在什么时候你应该考虑训练一个新的 tokenizer ？
<Question
	choices={[
		{
			text: "当你的数据集与现有预训练模型使用的数据集相似，且你想预训练一个新模型时",
			explain: "在这种情况下，为了节省时间和计算资源，一个更好的选择是使用与预训练模型相同的 tokenizer ，并对该 tokenizer 进行微调。"
		},
		{
			text: "当你的数据集与现有预训练模型使用的数据集相似，且你想对此预训练模型进行微调时",
			explain: "从预训练模型进行微调，你应该使用与预训练模型相同的 tokenizer 。"
		},
		{
			text: "当你的数据集与现有预训练模型使用的数据集不同，且你想预训练一个新模型时",
			explain: "正确！在这种情况下，使用现有预训练模型 tokenizer 将没有任何优势。",
            correct: true
		},
        {
			text: "当你的数据集与现有预训练模型所使用的数据集不同时，但是你对此预训练模型对新模型进行微调",
			explain: "从预训练模型进行微调，你应该使用与预训练模型相同的 tokenizer 。"
		}
	]}
/>

### 2．当使用 `train_new_from_iterator()` 时，使用文本列表生成器与文本列表相比有什么优点？
<Question
	choices={[
		{
			text: "文本列表生成器是`train_new_from_iterator()`方法唯一接受的输入类型。",
			explain: "文本列表是一种特殊的文本列表生成器，因此该方法也会接受这种方法。再试一次！"
		},
		{
			text: "你可以避免一次性将整个数据集加载到内存中。",
			explain: "正确！每个 batch 的文本在迭代时都将从内存中释放，如果你使用🤗 Datasets 存储你的文本，你会看到特别明显的收益。",
			correct: true
		},
		{
			text: "这将允许🤗 Tokenizers 库使用多进程。",
			explain: "不，即使随时文本列表它也会使用多进程。"
		},
        {
			text: "你训练的 Tokenizer 将生成效果更好的输出。",
			explain: "Tokenizer 不生成文本——你是否将其与语言模型混淆了？"
		}
	]}
/>

### 3．使用“快速” tokenizer 有什么优势？

<Question
	choices={[
		{
			text: "当你批处理大量的输入时，它可以比慢速的 tokenizer 更快地处理输入。",
			explain: "正确！由于 Rust 中实现的并行性，它将在批量处理输入上更快。你还能想到其他什么好处吗？",
			correct: true
		},
		{
			text: "快速的 tokenizer 总是比慢速的 tokenizer 快。",
			explain: "当你只给它一个或很少的文本时，快速 tokenizer 实际上可能更慢，因为它不能利用并行的优势。"
		},
		{
			text: "它可以填充和截断文本。",
			explain: "是的，但是慢速的 tokenizer 也可以做到这一点。"
		},
        {
			text: "它有一些额外的功能，允许你将 tokens 映射到生成它们的文本范围。",
			explain: "确实——这些被称为偏移映射。但这不是唯一的优势。",
			correct: true
		}
	]}
/>

### 4. `token-classification` 管道如何处理跨越多个 tokens 的实体？
<Question
	choices={[
		{
			text: "具有相同标签的实体被合并为一个实体。",
			explain: "这样处理有点过于简单了，再试一次！"
		},
		{
			text: "使用一个标签代表实体的开始，另一个标签代表实体的继续。",
			explain: "正确！",
			correct: true
		},
		{
			text: "在给定的单词中，只要第一个 tokens 具有实体的标签，整个单词都被认为带有该实体的标签。",
			explain: "这是处理实体的其中一种策略。这里还有什么其他的答案？",
			correct: true
		},
        {
			text: "当一个 tokens 具有特定实体的标签时，任何其他后续的带有相同标签的 tokens 都被视为同一实体的一部分，除非它被预测为新实体的开始。",
			explain: "这是最常见的将实体组合在一起的方法——但这并不是唯一的正确答案。",
			correct: true
		}
	]}
/>

### 5. `question-answering` 管道如何处理长上下文？
<Question
	choices={[
		{
			text: "它其实并未处理，因为它会将超过模型接受的最大长度的长上下文截断。",
			explain: "有一个技巧你可以用来处理很长的上下文，你还记得是什么吗？"
		},
		{
			text: "它将上下文分成若干部分，并对所得结果进行平均。",
			explain: "不，对所有的部分进行平均是没有意义的，因为上下文的某些部分不包括答案。"
		},
		{
			text: "它将上下文拆分为若干部分(有重叠部分) 并在每个部分中查找一个答案的最大分数。",
			explain: "这就是正确答案！",
			correct: true
		},
        {
			text: "它将上下文分成若干部分(不重叠，以提高效率) 并在每个部分中找到一个答案的最大得分。",
			explain: "不，不同的部分之间应该有一些重叠，以避免出现答案将分成两部分的情况。"
		}
	]}
/>

### 6．什么是标准化？
<Question
	choices={[
		{
			text: "这是 tokenizer 在初始阶段对文本进行的清洗。",
			explain: "这是正确的——例如，它可能涉及删除重音符号或空格，或输入转化为小写。",
			correct: true
		},
		{
			text: "这是一种数据增强技术，包括通过删除稀有单词使文本更加标准。",
			explain: "不对！再试一次。"
		},
		{
			text: "在最后的后处理步骤中，tokenizer 添加特殊 tokens 。",
			explain: "这个阶段简单地称为后期处理。"
		},
        {
			text: "这是通过减去平均值并除以标准差，使嵌入具有 0 的均值和 1 的标准差的过程。",
			explain: "在计算机视觉中，对像素值进行这种处理通常被称为标准化，但在自然语言处理中，标准化的含义并非如此。"
		}
	]}
/>

### 7．什么是 tokenizer 的预分词？
<Question
	choices={[
		{
			text: "这是 tokenization 之前的步骤，对数据进行增强(如随机掩码)。",
			explain: "不，这一步是预处理的一部分，但是不是预分词。"
		},
		{
			text: "这是 tokenization 之前的步骤，在这个步骤中，对文本进行清洗。",
			explain: "不，这是标准化步骤。"
		},
		{
			text: "这是进行 tokenize 之前的步骤，将输入拆分为单词。",
			explain: "这就是正确答案！",
			correct: true
		},
        {
			text: "这是进行 tokenize 之前的步骤，将输入切分为 tokens 。",
			explain: "不，切分为 tokens 是 tokenizer 子词分词算法模型的工作。"
		}
	]}
/>

### 8．选择描述 BPE 算法最准确的句子。
<Question
	choices={[
		{
			text: "BPE 是一个 tokenization 算法，从小词汇表开始，学习合并规则。",
			explain: "的确如此！",
			correct: true
		},
		{
			text: "BPE 是一种 tokenization 算法，从大词汇表开始，逐步从中删除 tokens 。",
			explain: "不，另一种 tokenization 算法所采用的方法。"
		},
		{
			text: "BPE tokenizer 通过合并最常见的一对 token 来学习合并规则。",
			explain: "没错！",
			correct: true
		},
		{
			text: "BPE（字节对编码） tokenizer 通过合并一对 tokens 来学习合并规则，该规则会优先选择经常一起出现以及不经常独立出现的 tokens 对。",
			explain: "不，这是另一个 tokenization 算法使用的策略。"
		},
		{
			text: "BPE 通过将单词分割成字符，然后使用合并规则将单词分解成子单词。",
			explain: "没错！",
			correct: true
		},
		{
			text: "BPE 通过从词汇表的开头找到最长的子词，然后在文本的其余部分重复这个过程，将单词转化为子词。",
			explain: "不，这是另一种 tokenization 算法的做法。"
		},
	]}
/>

### 9．选择描述 WordPiece 算法最准确的句子。
<Question
	choices={[
		{
			text: "WordPiece 是一个 tokenization 算法，它从一个小词汇表开始，学习合并规则。",
			explain: "的确如此！",
			correct: true
		},
		{
			text: "WordPiece 是一种 tokenization 算法，从大词汇表开始，逐步从中删除 tokens。",
			explain: "不，这是另一个 tokenization 算法所采用的方法。"
		},
		{
			text: "WordPiece tokenizer 通过合并最常见的两个 tokens 来学习合并规则。",
			explain: "不，这是另一个 tokenization 算法使用的策略。"
		},
		{
			text: "WordPiece tokenizer 通过合并一对 tokens 来学习合并规则，该规则会优先选择经常一起出现以及不经常独立出现的 tokens 对。",
			explain: "没错！",
			correct: true
		},
		{
			text: "WordPiece 通过模型找到最可能的分割方式，将单词分词为子词。",
			explain: "不，这是另一个 tokenization 算法的工作原理。"
		},
		{
			text: "WordPiece 通过从词汇表的开头找到最长的子词，然后在文本的其余部分重复这个过程，将单词转化为子词。",
			explain: "是的，这就是 WordPiece 进行编码的过程。",
			correct: true
		},
	]}
/>

### 10．选择描述 Unigram 算法最准确的句子。
<Question
	choices={[
		{
			text: "Unigram 是一个 tokenization 算法，它从一个很小的词汇表开始学习合并规则。",
			explain: "不，这是另一种 tokenization 算法的方法。"
		},
		{
			text: "Unigram 是一种 tokenization 算法，它从大词汇表开始，逐步从中删除 tokens。",
			explain: "没错！",
			correct: true
		},
		{
			text: "Unigram 通过最小化在整个语料库中的损失来调整词汇量。",
			explain: "没错！",
			correct: true
		},
		{
			text: "Unigram 通过保留出现最频繁的子词来调整它的词汇量。",
			explain: "不，这个不正确。"
		},
		{
			text: "Unigram 通过模型找到最可能的分割位置来将词转化为子词。",
			explain: "没错！",
			correct: true
		},
		{
			text: "Unigram 通过将单词分割成字符，然后使用合并规则将单词分解成子词。",
			explain: "不，这是另一个 tokenization 算法的工作原理。"
		},
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-CN/chapter6/10.mdx" />