import{s as oa,o as Ta,n as Ks}from"../chunks/scheduler.cc52f4b9.js";import{S as ha,i as wa,e as U,s as t,c as M,h as Ca,a as r,d as n,b as p,f as ra,g as y,j as o,k as ua,l as xa,m as a,n as j,t as i,o as J,p as c}from"../chunks/index.9480bb2b.js";import{T as Ys}from"../chunks/Tip.f7b80743.js";import{C as ma,H as $n,E as ga}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.52103c90.js";import{Y as Ia}from"../chunks/Youtube.7b12d9e8.js";import{C as T}from"../chunks/CodeBlock.c5404643.js";import{C as fa}from"../chunks/CourseFloatingBanner.78fb31df.js";function $a(C){let e,h="💡 本節深入介紹了BPE，甚至展示了一個完整的實現。如果你只想大致瞭解標記化算法，可以跳到最後。";return{c(){e=U("p"),e.textContent=h},l(u){e=r(u,"P",{"data-svelte-h":!0}),o(e)!=="svelte-1ujy58m"&&(e.textContent=h)},m(u,w){a(u,e,w)},p:Ks,d(u){u&&n(e)}}}function da(C){let e,h="TGPT-2 和 RoBERTa 標記器(非常相似)有一個聰明的方法來處理這個問題: 他們不把單詞看成是用 Unicode 字符寫的，而是用字節寫的。這樣，基本詞彙表的大小很小(256),但你能想到的每個字符仍將被包含在內,而不會最終轉換為未知標記。這個技巧被稱為 <em>字節級 BPE</em>。";return{c(){e=U("p"),e.innerHTML=h},l(u){e=r(u,"P",{"data-svelte-h":!0}),o(e)!=="svelte-1164592"&&(e.innerHTML=h)},m(u,w){a(u,e,w)},p:Ks,d(u){u&&n(e)}}}function qa(C){let e,h="✏️ <strong>現在輪到你了!</strong>你認為下一個合併規則是什麼？";return{c(){e=U("p"),e.innerHTML=h},l(u){e=r(u,"P",{"data-svelte-h":!0}),o(e)!=="svelte-15gt3yg"&&(e.innerHTML=h)},m(u,w){a(u,e,w)},p:Ks,d(u){u&&n(e)}}}function ba(C){let e,h="✏️ <strong>現在輪到你了!</strong> 你認為這個詞 <code>&quot;unhug&quot;</code> 將如何被標記？";return{c(){e=U("p"),e.innerHTML=h},l(u){e=r(u,"P",{"data-svelte-h":!0}),o(e)!=="svelte-1jbc3w4"&&(e.innerHTML=h)},m(u,w){a(u,e,w)},p:Ks,d(u){u&&n(e)}}}function Qa(C){let e,h="💡 在同一語料庫上使用 <code>train_new_from_iterator()</code> 不會產生完全相同的詞彙表。這是因為當有最頻繁對的選擇時,我們選擇遇到的第一個, 而 🤗 Tokenizers 庫根據內部ID選擇第一個。";return{c(){e=U("p"),e.innerHTML=h},l(u){e=r(u,"P",{"data-svelte-h":!0}),o(e)!=="svelte-ao5ez3"&&(e.innerHTML=h)},m(u,w){a(u,e,w)},p:Ks,d(u){u&&n(e)}}}function ka(C){let e,h="⚠️ 如果存在未知字符,我們的實現將拋出錯誤,因為我們沒有做任何處理它們。GPT-2 實際上沒有未知標記(使用字節級 BPE 時不可能得到未知字符),但這可能發生在這裡,因為我們沒有在初始詞彙表中包含所有可能的字節。 BPE 的這方面超出了本節的範圍,因此我們忽略了細節。";return{c(){e=U("p"),e.textContent=h},l(u){e=r(u,"P",{"data-svelte-h":!0}),o(e)!=="svelte-1csxy0s"&&(e.textContent=h)},m(u,w){a(u,e,w)},p:Ks,d(u){u&&n(e)}}}function Aa(C){let e,h,u,w,d,Fs,q,Ls,b,Os,Q,dn="字節對編碼(BPE)最初被開發為一種壓縮文本的算法,然後在預訓練 GPT 模型時被 OpenAI 用於標記化。許多 Transformer 模型都使用它,包括 GPT、GPT-2、RoBERTa、BART 和 DeBERTa。",sl,k,ll,x,nl,A,al,B,qn="BPE 訓練首先計算語料庫中使用的唯一單詞集(在完成標準化和預標記化步驟之後)，然後通過獲取用於編寫這些單詞的所有符號來構建詞彙表。舉一個簡單的例子，假設我們的語料庫使用了這五個詞:",tl,V,pl,E,bn="基礎詞彙將是 <code>[&quot;b&quot;, &quot;g&quot;, &quot;h&quot;, &quot;n&quot;, &quot;p&quot;, &quot;s&quot;, &quot;u&quot;]</code>。對於實際情況，基本詞彙表將包含所有 ASCII 字符，至少，可能還包含一些 Unicode 字符。如果您正在標記的示例使用不在訓練語料庫中的字符，則該字符將轉換為未知標記。這就是為什麼許多 NLP 模型在分析帶有表情符號的內容方面非常糟糕的原因之一。",el,m,Ml,Z,Qn="獲得這個基本詞彙後，我們添加新的標記，直到通過學習<em>合併</em>達到所需的詞彙量，這是將現有詞彙表的兩個元素合併為一個新元素的規則。因此在開始時，這些合併將創建具有兩個字符的標記，然後隨著訓練的進行，會創建更長的子詞。",yl,z,kn="在分詞器訓練期間的任何一步，BPE 算法都會搜索最常見的現有標記對 (“對”,這裡我們指的是單詞中的兩個連續標記)。最頻繁的一對將被合併，我們沖洗並重複下一步。",jl,G,An="回到我們之前的例子，讓我們假設單詞具有以下頻率：",il,S,Jl,_,Bn="意味著 <code>&quot;hug&quot;</code> 在語料庫中出現了10次, <code>&quot;pug&quot;</code> 5次, <code>&quot;pun&quot;</code> 12次, <code>&quot;bun&quot;</code> 4次, 以及 <code>&quot;hugs&quot;</code> 5次。我們通過將每個單詞拆分為字符(形成我們初始詞彙表的字符)來開始訓練,這樣我們就可以將每個單詞視為一個標記列表:",cl,N,Ul,v,Vn="然後我們看成對。這對 <code>(&quot;h&quot;, &quot;u&quot;)</code> 出現在單詞 <code>&quot;hug&quot;</code> 和 <code>&quot;hugs&quot;</code>中,所以語料庫中總共有15次。不過,這並不是最頻繁的一對:這個榮譽屬於 <code>(&quot;u&quot;, &quot;g&quot;)</code>,它出現在 <code>&quot;hug&quot;</code>, <code>&quot;pug&quot;</code>, 以及 <code>&quot;hugs&quot;</code>中,在詞彙表中總共 20 次。",rl,H,En="因此,標記器學習的第一個合併規則是 <code>(&quot;u&quot;, &quot;g&quot;) -&gt; &quot;ug&quot;</code>,意思就是 <code>&quot;ug&quot;</code> 將被添加到詞彙表中,並且這對應該合併到語料庫的所有單詞中。在這個階段結束時,詞彙表和語料庫看起來像這樣:",ul,X,ol,D,Zn="現在我們有一些導致標記長於兩個字符的對: 例如 <code>(&quot;h&quot;, &quot;ug&quot;)</code>, 在語料庫中出現15次。然而,這個階段最頻繁的對是 <code>(&quot;u&quot;, &quot;n&quot;)</code>,在語料庫中出現16次,所以學到的第二個合併規則是 <code>(&quot;u&quot;, &quot;n&quot;) -&gt; &quot;un&quot;</code>。將其添加到詞彙表併合並所有現有的這個對,將出現:",Tl,W,hl,R,zn="現在最頻繁的一對是 <code>(&quot;h&quot;, &quot;ug&quot;)</code>,所以我們學習了合併規則 <code>(&quot;h&quot;, &quot;ug&quot;) -&gt; &quot;hug&quot;</code>,這給了我們第一個三個字母的標記。合併後,語料庫如下所示:",wl,Y,Cl,K,Gn="我們繼續這樣合併,直到達到我們所需的詞彙量。",xl,g,ml,P,gl,F,Sn="標記化緊跟訓練過程,從某種意義上說,通過應用以下步驟對新輸入進行標記:",Il,L,_n="<li>規範化</li> <li>預標記化</li> <li>將單詞拆分為單個字符</li> <li>將學習的合併規則按順序應用於這些拆分</li>",fl,O,Nn="讓我們以我們在訓練期間使用的示例為例,學習三個合併規則:",$l,ss,dl,ls,vn="這個單詞 <code>&quot;bug&quot;</code> 將被標記為 <code>[&quot;b&quot;, &quot;ug&quot;]</code>。然而 <code>&quot;mug&quot;</code>,將被標記為 <code>[&quot;[UNK]&quot;, &quot;ug&quot;]</code>,因為字母 <code>&quot;m&quot;</code> 不再基本詞彙表中。同樣,單詞<code>&quot;thug&quot;</code> 會被標記為 <code>[&quot;[UNK]&quot;, &quot;hug&quot;]</code>: 字母 <code>&quot;t&quot;</code> 不在基本詞彙表中,應用合併規則首先導致 <code>&quot;u&quot;</code> 和 <code>&quot;g&quot;</code> 被合併,然後是 <code>&quot;hu&quot;</code> 和 <code>&quot;g&quot;</code> 被合併。",ql,I,bl,ns,Ql,as,Hn="現在讓我們看一下 BPE 算法的實現。這不會是你可以在大型語料庫上實際使用的優化版本;我們只是想向你展示代碼,以便你可以更好地理解算法",kl,ts,Xn="首先我們需要一個語料庫,所以讓我們用幾句話創建一個簡單的語料庫:",Al,ps,Bl,es,Dn="接下來,我們需要將該語料庫預先標記為單詞。由於我們正在複製 BPE 標記器(如 GPT-2),我們將使用 <code>gpt2</code> 標記器作為預標記化的標記器:",Vl,Ms,El,ys,Wn="然後我們在進行預標記化時計算語料庫中每個單詞的頻率:",Zl,js,zl,is,Gl,Js,Rn="下一步是計算基本詞彙,由語料庫中使用的所有字符組成:",Sl,cs,_l,Us,Nl,rs,Yn="我們還在該詞彙表的開頭添加了模型使用的特殊標記。對於GPT-2,唯一的特殊標記是 <code>&quot;&lt;|endoftext|&gt;&quot;</code>:",vl,us,Hl,os,Kn="我們現在需要將每個單詞拆分為單獨的字符,以便能夠開始訓練:",Xl,Ts,Dl,hs,Pn="現在我們已準備好進行訓練,讓我們編寫一個函數來計算每對的頻率。我們需要在訓練的每個步驟中使用它:",Wl,ws,Rl,Cs,Fn="讓我們來看看這個字典在初始拆分後的一部分:",Yl,xs,Kl,ms,Pl,gs,Ln="現在, 找到最頻繁的對只需要一個快速的循環:",Fl,Is,Ll,fs,Ol,$s,On="所以第一個要學習的合併是 <code>(&#39;Ġ&#39;, &#39;t&#39;) -&gt; &#39;Ġt&#39;</code>, 我們添加 <code>&#39;Ġt&#39;</code> 到詞彙表:",sn,ds,ln,qs,sa="要繼續接下來的步驟,我們需要在我們的<code>分詞</code>字典中應用該合併。讓我們為此編寫另一個函數:",nn,bs,an,Qs,la="我們可以看看第一次合併的結果:",tn,ks,pn,As,en,Bs,na="現在我們有了循環所需的一切,直到我們學會了我們想要的所有合併。我們的目標是詞彙量達到50:",Mn,Vs,yn,Es,aa="結果,我們學習了 19 條合併規則(初始詞彙表的大小 31 — 30 字母字符,加上特殊標記):",jn,Zs,Jn,zs,cn,Gs,ta="詞彙表由特殊標記、初始字母和所有合併結果組成:",Un,Ss,rn,_s,un,f,on,Ns,pa="為了對新文本進行分詞,我們對其進行預分詞、拆分，然後應用學到的所有合併規則:",Tn,vs,hn,Hs,ea="我們可以在任何由字母表中的字符組成的文本上嘗試這個:",wn,Xs,Cn,Ds,xn,$,mn,Ws,Ma="這就是 BPE 算法！接下來,我們將看看 WordPiece。",gn,Rs,In,Ps,fn;return d=new ma({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),q=new $n({props:{title:"字節對編碼標記化",local:"字節對編碼標記化",headingTag:"h1"}}),b=new fa({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/zh-CN/chapter6/section5.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/zh-CN/chapter6/section5.ipynb"}]}}),k=new Ia({props:{id:"HEikzVL-lZU"}}),x=new Ys({props:{$$slots:{default:[$a]},$$scope:{ctx:C}}}),A=new $n({props:{title:"訓練算法",local:"訓練算法",headingTag:"h2"}}),V=new T({props:{code:"JTIyaHVnJTIyJTJDJTIwJTIycHVnJTIyJTJDJTIwJTIycHVuJTIyJTJDJTIwJTIyYnVuJTIyJTJDJTIwJTIyaHVncyUyMg==",highlighted:'<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-string">&quot;pug&quot;</span>, <span class="hljs-string">&quot;pun&quot;</span>, <span class="hljs-string">&quot;bun&quot;</span>, <span class="hljs-string">&quot;hugs&quot;</span>',wrap:!1}}),m=new Ys({props:{$$slots:{default:[da]},$$scope:{ctx:C}}}),S=new T({props:{code:"KCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwdWclMjIlMkMlMjA1KSUyQyUyMCglMjJwdW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVncyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;bun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;hugs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),N=new T({props:{code:"KCUyMmglMjIlMjAlMjJ1JTIyJTIwJTIyZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMmclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMm4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnUlMjIlMjAlMjJnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span> <span class="hljs-string">&quot;s&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),X=new T({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiU1RCUwQUNvcnB1cyUzQSUyMCglMjJoJTIyJTIwJTIydWclMjIlMkMlMjAxMCklMkMlMjAoJTIycCUyMiUyMCUyMnVnJTIyJTJDJTIwNSklMkMlMjAoJTIycCUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwMTIpJTJDJTIwKCUyMmIlMjIlMjAlMjJ1JTIyJTIwJTIybiUyMiUyQyUyMDQpJTJDJTIwKCUyMmglMjIlMjAlMjJ1ZyUyMiUyMCUyMnMlMjIlMkMlMjA1KQ==",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),W=new T({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiUyQyUyMCUyMnVuJTIyJTVEJTBBQ29ycHVzJTNBJTIwKCUyMmglMjIlMjAlMjJ1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydWclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnVnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),Y=new T({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiUyQyUyMCUyMnVuJTIyJTJDJTIwJTIyaHVnJTIyJTVEJTBBQ29ycHVzJTNBJTIwKCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydWclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-string">&quot;hug&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;hug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),g=new Ys({props:{$$slots:{default:[qa]},$$scope:{ctx:C}}}),P=new $n({props:{title:"標記化算法",local:"標記化算法",headingTag:"h2"}}),ss=new T({props:{code:"KCUyMnUlMjIlMkMlMjAlMjJnJTIyKSUyMC0lM0UlMjAlMjJ1ZyUyMiUwQSglMjJ1JTIyJTJDJTIwJTIybiUyMiklMjAtJTNFJTIwJTIydW4lMjIlMEEoJTIyaCUyMiUyQyUyMCUyMnVnJTIyKSUyMC0lM0UlMjAlMjJodWclMjI=",highlighted:`<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;ug&quot;</span>
<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;un&quot;</span>
<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;hug&quot;</span>`,wrap:!1}}),I=new Ys({props:{$$slots:{default:[ba]},$$scope:{ctx:C}}}),ns=new $n({props:{title:"實現 BPE",local:"實現-bpe",headingTag:"h2"}}),ps=new T({props:{code:"Y29ycHVzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGlzJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBjb3Vyc2UuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGNoYXB0ZXIlMjBpcyUyMGFib3V0JTIwdG9rZW5pemF0aW9uLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlRoaXMlMjBzZWN0aW9uJTIwc2hvd3MlMjBzZXZlcmFsJTIwdG9rZW5pemVyJTIwYWxnb3JpdGhtcy4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJIb3BlZnVsbHklMkMlMjB5b3UlMjB3aWxsJTIwYmUlMjBhYmxlJTIwdG8lMjB1bmRlcnN0YW5kJTIwaG93JTIwdGhleSUyMGFyZSUyMHRyYWluZWQlMjBhbmQlMjBnZW5lcmF0ZSUyMHRva2Vucy4lMjIlMkMlMEElNUQ=",highlighted:`corpus = [
    <span class="hljs-string">&quot;This is the Hugging Face course.&quot;</span>,
    <span class="hljs-string">&quot;This chapter is about tokenization.&quot;</span>,
    <span class="hljs-string">&quot;This section shows several tokenizer algorithms.&quot;</span>,
    <span class="hljs-string">&quot;Hopefully, you will be able to understand how they are trained and generate tokens.&quot;</span>,
]`,wrap:!1}}),Ms=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)`,wrap:!1}}),js=new T({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEF3b3JkX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQSUwQWZvciUyMHRleHQlMjBpbiUyMGNvcnB1cyUzQSUwQSUyMCUyMCUyMCUyMHdvcmRzX3dpdGhfb2Zmc2V0cyUyMCUzRCUyMHRva2VuaXplci5iYWNrZW5kX3Rva2VuaXplci5wcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIodGV4dCklMEElMjAlMjAlMjAlMjBuZXdfd29yZHMlMjAlM0QlMjAlNUJ3b3JkJTIwZm9yJTIwd29yZCUyQyUyMG9mZnNldCUyMGluJTIwd29yZHNfd2l0aF9vZmZzZXRzJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwd29yZCUyMGluJTIwbmV3X3dvcmRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd29yZF9mcmVxcyU1QndvcmQlNUQlMjAlMkIlM0QlMjAxJTBBJTBBcHJpbnQod29yZF9mcmVxcyk=",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

word_freqs = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-keyword">for</span> text <span class="hljs-keyword">in</span> corpus:
    words_with_offsets = tokenizer.backend_tokenizer.pre_tokenizer.pre_tokenize_str(text)
    new_words = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> words_with_offsets]
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> new_words:
        word_freqs[word] += <span class="hljs-number">1</span>

<span class="hljs-built_in">print</span>(word_freqs)`,wrap:!1}}),is=new T({props:{code:"ZGVmYXVsdGRpY3QoaW50JTJDJTIwJTdCJ1RoaXMnJTNBJTIwMyUyQyUyMCclQzQlQTBpcyclM0ElMjAyJTJDJTIwJyVDNCVBMHRoZSclM0ElMjAxJTJDJTIwJyVDNCVBMEh1Z2dpbmcnJTNBJTIwMSUyQyUyMCclQzQlQTBGYWNlJyUzQSUyMDElMkMlMjAnJUM0JUEwQ291cnNlJyUzQSUyMDElMkMlMjAnLiclM0ElMjA0JTJDJTIwJyVDNCVBMGNoYXB0ZXInJTNBJTIwMSUyQyUwQSUyMCUyMCUyMCUyMCclQzQlQTBhYm91dCclM0ElMjAxJTJDJTIwJyVDNCVBMHRva2VuaXphdGlvbiclM0ElMjAxJTJDJTIwJyVDNCVBMHNlY3Rpb24nJTNBJTIwMSUyQyUyMCclQzQlQTBzaG93cyclM0ElMjAxJTJDJTIwJyVDNCVBMHNldmVyYWwnJTNBJTIwMSUyQyUyMCclQzQlQTB0b2tlbml6ZXInJTNBJTIwMSUyQyUyMCclQzQlQTBhbGdvcml0aG1zJyUzQSUyMDElMkMlMEElMjAlMjAlMjAlMjAnSG9wZWZ1bGx5JyUzQSUyMDElMkMlMjAnJTJDJyUzQSUyMDElMkMlMjAnJUM0JUEweW91JyUzQSUyMDElMkMlMjAnJUM0JUEwd2lsbCclM0ElMjAxJTJDJTIwJyVDNCVBMGJlJyUzQSUyMDElMkMlMjAnJUM0JUEwYWJsZSclM0ElMjAxJTJDJTIwJyVDNCVBMHRvJyUzQSUyMDElMkMlMjAnJUM0JUEwdW5kZXJzdGFuZCclM0ElMjAxJTJDJTIwJyVDNCVBMGhvdyclM0ElMjAxJTJDJTBBJTIwJTIwJTIwJTIwJyVDNCVBMHRoZXknJTNBJTIwMSUyQyUyMCclQzQlQTBhcmUnJTNBJTIwMSUyQyUyMCclQzQlQTB0cmFpbmVkJyUzQSUyMDElMkMlMjAnJUM0JUEwYW5kJyUzQSUyMDElMkMlMjAnJUM0JUEwZ2VuZXJhdGUnJTNBJTIwMSUyQyUyMCclQzQlQTB0b2tlbnMnJTNBJTIwMSU3RCk=",highlighted:`defaultdict(<span class="hljs-built_in">int</span>, {<span class="hljs-string">&#x27;This&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠHugging&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠFace&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠCourse&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;.&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;Ġchapter&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Ġabout&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokenization&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġsection&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġshows&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġseveral&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokenizer&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġalgorithms&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Hopefully&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;,&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġyou&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġwill&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġbe&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġable&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġunderstand&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġhow&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Ġthey&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġare&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtrained&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġand&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġgenerate&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokens&#x27;</span>: <span class="hljs-number">1</span>})`,wrap:!1}}),cs=new T({props:{code:"YWxwaGFiZXQlMjAlM0QlMjAlNUIlNUQlMEElMEFmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzLmtleXMoKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGxldHRlciUyMGluJTIwd29yZCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGV0dGVyJTIwbm90JTIwaW4lMjBhbHBoYWJldCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFscGhhYmV0LmFwcGVuZChsZXR0ZXIpJTBBYWxwaGFiZXQuc29ydCgpJTBBJTBBcHJpbnQoYWxwaGFiZXQp",highlighted:`alphabet = []

<span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys():
    <span class="hljs-keyword">for</span> letter <span class="hljs-keyword">in</span> word:
        <span class="hljs-keyword">if</span> letter <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> alphabet:
            alphabet.append(letter)
alphabet.sort()

<span class="hljs-built_in">print</span>(alphabet)`,wrap:!1}}),Us=new T({props:{code:"JTVCJTIwJyUyQyclMkMlMjAnLiclMkMlMjAnQyclMkMlMjAnRiclMkMlMjAnSCclMkMlMjAnVCclMkMlMjAnYSclMkMlMjAnYiclMkMlMjAnYyclMkMlMjAnZCclMkMlMjAnZSclMkMlMjAnZiclMkMlMjAnZyclMkMlMjAnaCclMkMlMjAnaSclMkMlMjAnayclMkMlMjAnbCclMkMlMjAnbSclMkMlMjAnbiclMkMlMjAnbyclMkMlMjAncCclMkMlMjAnciclMkMlMjAncyclMkMlMEElMjAlMjAndCclMkMlMjAndSclMkMlMjAndiclMkMlMjAndyclMkMlMjAneSclMkMlMjAneiclMkMlMjAnJUM0JUEwJyU1RA==",highlighted:`[ <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;f&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>, <span class="hljs-string">&#x27;l&#x27;</span>, <span class="hljs-string">&#x27;m&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;p&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>,
  <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;v&#x27;</span>, <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>, <span class="hljs-string">&#x27;z&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>]`,wrap:!1}}),us=new T({props:{code:"dm9jYWIlMjAlM0QlMjAlNUIlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlNUQlMjAlMkIlMjBhbHBoYWJldC5jb3B5KCk=",highlighted:'vocab = [<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>] + alphabet.copy()',wrap:!1}}),Ts=new T({props:{code:"c3BsaXRzJTIwJTNEJTIwJTdCd29yZCUzQSUyMCU1QmMlMjBmb3IlMjBjJTIwaW4lMjB3b3JkJTVEJTIwZm9yJTIwd29yZCUyMGluJTIwd29yZF9mcmVxcy5rZXlzKCklN0Q=",highlighted:'splits = {word: [c <span class="hljs-keyword">for</span> c <span class="hljs-keyword">in</span> word] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys()}',wrap:!1}}),ws=new T({props:{code:"ZGVmJTIwY29tcHV0ZV9wYWlyX2ZyZXFzKHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjBwYWlyX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQSUyMCUyMCUyMCUyMGZvciUyMHdvcmQlMkMlMjBmcmVxJTIwaW4lMjB3b3JkX2ZyZXFzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGxpdCUyMCUzRCUyMHNwbGl0cyU1QndvcmQlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGxlbihzcGxpdCklMjAlM0QlM0QlMjAxJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29udGludWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oc3BsaXQpJTIwLSUyMDEpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFpciUyMCUzRCUyMChzcGxpdCU1QmklNUQlMkMlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhaXJfZnJlcXMlNUJwYWlyJTVEJTIwJTJCJTNEJTIwZnJlcSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHBhaXJfZnJlcXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_pair_freqs</span>(<span class="hljs-params">splits</span>):
    pair_freqs = defaultdict(<span class="hljs-built_in">int</span>)
    <span class="hljs-keyword">for</span> word, freq <span class="hljs-keyword">in</span> word_freqs.items():
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>):
            pair = (split[i], split[i + <span class="hljs-number">1</span>])
            pair_freqs[pair] += freq
    <span class="hljs-keyword">return</span> pair_freqs`,wrap:!1}}),xs=new T({props:{code:"cGFpcl9mcmVxcyUyMCUzRCUyMGNvbXB1dGVfcGFpcl9mcmVxcyhzcGxpdHMpJTBBJTBBZm9yJTIwaSUyQyUyMGtleSUyMGluJTIwZW51bWVyYXRlKHBhaXJfZnJlcXMua2V5cygpKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlN0JrZXklN0QlM0ElMjAlN0JwYWlyX2ZyZXFzJTVCa2V5JTVEJTdEJTIyKSUwQSUyMCUyMCUyMCUyMGlmJTIwaSUyMCUzRSUzRCUyMDUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBicmVhaw==",highlighted:`pair_freqs = compute_pair_freqs(splits)

<span class="hljs-keyword">for</span> i, key <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(pair_freqs.keys()):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{key}</span>: <span class="hljs-subst">{pair_freqs[key]}</span>&quot;</span>)
    <span class="hljs-keyword">if</span> i &gt;= <span class="hljs-number">5</span>:
        <span class="hljs-keyword">break</span>`,wrap:!1}}),ms=new T({props:{code:"KCdUJyUyQyUyMCdoJyklM0ElMjAzJTBBKCdoJyUyQyUyMCdpJyklM0ElMjAzJTBBKCdpJyUyQyUyMCdzJyklM0ElMjA1JTBBKCclQzQlQTAnJTJDJTIwJ2knKSUzQSUyMDIlMEEoJyVDNCVBMCclMkMlMjAndCcpJTNBJTIwNyUwQSgndCclMkMlMjAnaCcpJTNBJTIwMw==",highlighted:`(<span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-number">3</span>
(<span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-number">3</span>
(<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>): <span class="hljs-number">5</span>
(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-number">2</span>
(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>): <span class="hljs-number">7</span>
(<span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-number">3</span>`,wrap:!1}}),Is=new T({props:{code:"YmVzdF9wYWlyJTIwJTNEJTIwJTIyJTIyJTBBbWF4X2ZyZXElMjAlM0QlMjBOb25lJTBBJTBBZm9yJTIwcGFpciUyQyUyMGZyZXElMjBpbiUyMHBhaXJfZnJlcXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWF4X2ZyZXElMjBpcyUyME5vbmUlMjBvciUyMG1heF9mcmVxJTIwJTNDJTIwZnJlcSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJlc3RfcGFpciUyMCUzRCUyMHBhaXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfZnJlcSUyMCUzRCUyMGZyZXElMEElMEFwcmludChiZXN0X3BhaXIlMkMlMjBtYXhfZnJlcSk=",highlighted:`best_pair = <span class="hljs-string">&quot;&quot;</span>
max_freq = <span class="hljs-literal">None</span>

<span class="hljs-keyword">for</span> pair, freq <span class="hljs-keyword">in</span> pair_freqs.items():
    <span class="hljs-keyword">if</span> max_freq <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_freq &lt; freq:
        best_pair = pair
        max_freq = freq

<span class="hljs-built_in">print</span>(best_pair, max_freq)`,wrap:!1}}),fs=new T({props:{code:"KCclQzQlQTAnJTJDJTIwJ3QnKSUyMDc=",highlighted:'(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>) <span class="hljs-number">7</span>',wrap:!1}}),ds=new T({props:{code:"bWVyZ2VzJTIwJTNEJTIwJTdCKCUyMiVDNCVBMCUyMiUyQyUyMCUyMnQlMjIpJTNBJTIwJTIyJUM0JUEwdCUyMiU3RCUwQXZvY2FiLmFwcGVuZCglMjIlQzQlQTB0JTIyKQ==",highlighted:`merges = {(<span class="hljs-string">&quot;Ġ&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>): <span class="hljs-string">&quot;Ġt&quot;</span>}
vocab.append(<span class="hljs-string">&quot;Ġt&quot;</span>)`,wrap:!1}}),bs=new T({props:{code:"ZGVmJTIwbWVyZ2VfcGFpcihhJTJDJTIwYiUyQyUyMHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXQlMjAlM0QlMjBzcGxpdHMlNUJ3b3JkJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsZW4oc3BsaXQpJTIwJTNEJTNEJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbnRpbnVlJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaSUyMCUzRCUyMDAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aGlsZSUyMGklMjAlM0MlMjBsZW4oc3BsaXQpJTIwLSUyMDElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHNwbGl0JTVCaSU1RCUyMCUzRCUzRCUyMGElMjBhbmQlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEJTIwJTNEJTNEJTIwYiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0JTIwJTNEJTIwc3BsaXQlNUIlM0FpJTVEJTIwJTJCJTIwJTVCYSUyMCUyQiUyMGIlNUQlMjAlMkIlMjBzcGxpdCU1QmklMjAlMkIlMjAyJTIwJTNBJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGklMjAlMkIlM0QlMjAxJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXRzJTVCd29yZCU1RCUyMCUzRCUyMHNwbGl0JTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3BsaXRz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">merge_pair</span>(<span class="hljs-params">a, b, splits</span>):
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs:
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>

        i = <span class="hljs-number">0</span>
        <span class="hljs-keyword">while</span> i &lt; <span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>:
            <span class="hljs-keyword">if</span> split[i] == a <span class="hljs-keyword">and</span> split[i + <span class="hljs-number">1</span>] == b:
                split = split[:i] + [a + b] + split[i + <span class="hljs-number">2</span> :]
            <span class="hljs-keyword">else</span>:
                i += <span class="hljs-number">1</span>
        splits[word] = split
    <span class="hljs-keyword">return</span> splits`,wrap:!1}}),ks=new T({props:{code:"c3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpciglMjIlQzQlQTAlMjIlMkMlMjAlMjJ0JTIyJTJDJTIwc3BsaXRzKSUwQXByaW50KHNwbGl0cyU1QiUyMiVDNCVBMHRyYWluZWQlMjIlNUQp",highlighted:`splits = merge_pair(<span class="hljs-string">&quot;Ġ&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>, splits)
<span class="hljs-built_in">print</span>(splits[<span class="hljs-string">&quot;Ġtrained&quot;</span>])`,wrap:!1}}),As=new T({props:{code:"JTVCJyVDNCVBMHQnJTJDJTIwJ3InJTJDJTIwJ2EnJTJDJTIwJ2knJTJDJTIwJ24nJTJDJTIwJ2UnJTJDJTIwJ2QnJTVE",highlighted:'[<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>]',wrap:!1}}),Vs=new T({props:{code:"dm9jYWJfc2l6ZSUyMCUzRCUyMDUwJTBBJTBBd2hpbGUlMjBsZW4odm9jYWIpJTIwJTNDJTIwdm9jYWJfc2l6ZSUzQSUwQSUyMCUyMCUyMCUyMHBhaXJfZnJlcXMlMjAlM0QlMjBjb21wdXRlX3BhaXJfZnJlcXMoc3BsaXRzKSUwQSUyMCUyMCUyMCUyMGJlc3RfcGFpciUyMCUzRCUyMCUyMiUyMiUwQSUyMCUyMCUyMCUyMG1heF9mcmVxJTIwJTNEJTIwTm9uZSUwQSUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMkMlMjBmcmVxJTIwaW4lMjBwYWlyX2ZyZXFzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMG1heF9mcmVxJTIwaXMlMjBOb25lJTIwb3IlMjBtYXhfZnJlcSUyMCUzQyUyMGZyZXElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiZXN0X3BhaXIlMjAlM0QlMjBwYWlyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X2ZyZXElMjAlM0QlMjBmcmVxJTBBJTIwJTIwJTIwJTIwc3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpcigqYmVzdF9wYWlyJTJDJTIwc3BsaXRzKSUwQSUyMCUyMCUyMCUyMG1lcmdlcyU1QmJlc3RfcGFpciU1RCUyMCUzRCUyMGJlc3RfcGFpciU1QjAlNUQlMjAlMkIlMjBiZXN0X3BhaXIlNUIxJTVEJTBBJTIwJTIwJTIwJTIwdm9jYWIuYXBwZW5kKGJlc3RfcGFpciU1QjAlNUQlMjAlMkIlMjBiZXN0X3BhaXIlNUIxJTVEKQ==",highlighted:`vocab_size = <span class="hljs-number">50</span>

<span class="hljs-keyword">while</span> <span class="hljs-built_in">len</span>(vocab) &lt; vocab_size:
    pair_freqs = compute_pair_freqs(splits)
    best_pair = <span class="hljs-string">&quot;&quot;</span>
    max_freq = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">for</span> pair, freq <span class="hljs-keyword">in</span> pair_freqs.items():
        <span class="hljs-keyword">if</span> max_freq <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_freq &lt; freq:
            best_pair = pair
            max_freq = freq
    splits = merge_pair(*best_pair, splits)
    merges[best_pair] = best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>]
    vocab.append(best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>])`,wrap:!1}}),Zs=new T({props:{code:"cHJpbnQobWVyZ2VzKQ==",highlighted:'<span class="hljs-built_in">print</span>(merges)',wrap:!1}}),zs=new T({props:{code:"JTdCKCclQzQlQTAnJTJDJTIwJ3QnKSUzQSUyMCclQzQlQTB0JyUyQyUyMCgnaSclMkMlMjAncycpJTNBJTIwJ2lzJyUyQyUyMCgnZSclMkMlMjAncicpJTNBJTIwJ2VyJyUyQyUyMCgnJUM0JUEwJyUyQyUyMCdhJyklM0ElMjAnJUM0JUEwYSclMkMlMjAoJyVDNCVBMHQnJTJDJTIwJ28nKSUzQSUyMCclQzQlQTB0byclMkMlMjAoJ2UnJTJDJTIwJ24nKSUzQSUyMCdlbiclMkMlMEElMjAoJ1QnJTJDJTIwJ2gnKSUzQSUyMCdUaCclMkMlMjAoJ1RoJyUyQyUyMCdpcycpJTNBJTIwJ1RoaXMnJTJDJTIwKCdvJyUyQyUyMCd1JyklM0ElMjAnb3UnJTJDJTIwKCdzJyUyQyUyMCdlJyklM0ElMjAnc2UnJTJDJTIwKCclQzQlQTB0byclMkMlMjAnaycpJTNBJTIwJyVDNCVBMHRvayclMkMlMEElMjAoJyVDNCVBMHRvayclMkMlMjAnZW4nKSUzQSUyMCclQzQlQTB0b2tlbiclMkMlMjAoJ24nJTJDJTIwJ2QnKSUzQSUyMCduZCclMkMlMjAoJyVDNCVBMCclMkMlMjAnaXMnKSUzQSUyMCclQzQlQTBpcyclMkMlMjAoJyVDNCVBMHQnJTJDJTIwJ2gnKSUzQSUyMCclQzQlQTB0aCclMkMlMjAoJyVDNCVBMHRoJyUyQyUyMCdlJyklM0ElMjAnJUM0JUEwdGhlJyUyQyUwQSUyMCgnaSclMkMlMjAnbicpJTNBJTIwJ2luJyUyQyUyMCgnJUM0JUEwYSclMkMlMjAnYicpJTNBJTIwJyVDNCVBMGFiJyUyQyUyMCgnJUM0JUEwdG9rZW4nJTJDJTIwJ2knKSUzQSUyMCclQzQlQTB0b2tlbmknJTdE",highlighted:`{(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>): <span class="hljs-string">&#x27;Ġt&#x27;</span>, (<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>): <span class="hljs-string">&#x27;is&#x27;</span>, (<span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>): <span class="hljs-string">&#x27;er&#x27;</span>, (<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>): <span class="hljs-string">&#x27;Ġa&#x27;</span>, (<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>): <span class="hljs-string">&#x27;Ġto&#x27;</span>, (<span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>): <span class="hljs-string">&#x27;en&#x27;</span>,
 (<span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-string">&#x27;Th&#x27;</span>, (<span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>): <span class="hljs-string">&#x27;This&#x27;</span>, (<span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>): <span class="hljs-string">&#x27;ou&#x27;</span>, (<span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>): <span class="hljs-string">&#x27;se&#x27;</span>, (<span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>): <span class="hljs-string">&#x27;Ġtok&#x27;</span>,
 (<span class="hljs-string">&#x27;Ġtok&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>): <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, (<span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>): <span class="hljs-string">&#x27;nd&#x27;</span>, (<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>): <span class="hljs-string">&#x27;Ġis&#x27;</span>, (<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-string">&#x27;Ġth&#x27;</span>, (<span class="hljs-string">&#x27;Ġth&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>): <span class="hljs-string">&#x27;Ġthe&#x27;</span>,
 (<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>): <span class="hljs-string">&#x27;in&#x27;</span>, (<span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>): <span class="hljs-string">&#x27;Ġab&#x27;</span>, (<span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-string">&#x27;Ġtokeni&#x27;</span>}`,wrap:!1}}),Ss=new T({props:{code:"cHJpbnQodm9jYWIp",highlighted:'<span class="hljs-built_in">print</span>(vocab)',wrap:!1}}),_s=new T({props:{code:"JTVCJyUzQyU3Q2VuZG9mdGV4dCU3QyUzRSclMkMlMjAnJTJDJyUyQyUyMCcuJyUyQyUyMCdDJyUyQyUyMCdGJyUyQyUyMCdIJyUyQyUyMCdUJyUyQyUyMCdhJyUyQyUyMCdiJyUyQyUyMCdjJyUyQyUyMCdkJyUyQyUyMCdlJyUyQyUyMCdmJyUyQyUyMCdnJyUyQyUyMCdoJyUyQyUyMCdpJyUyQyUyMCdrJyUyQyUyMCdsJyUyQyUyMCdtJyUyQyUyMCduJyUyQyUyMCdvJyUyQyUwQSUyMCdwJyUyQyUyMCdyJyUyQyUyMCdzJyUyQyUyMCd0JyUyQyUyMCd1JyUyQyUyMCd2JyUyQyUyMCd3JyUyQyUyMCd5JyUyQyUyMCd6JyUyQyUyMCclQzQlQTAnJTJDJTIwJyVDNCVBMHQnJTJDJTIwJ2lzJyUyQyUyMCdlciclMkMlMjAnJUM0JUEwYSclMkMlMjAnJUM0JUEwdG8nJTJDJTIwJ2VuJyUyQyUyMCdUaCclMkMlMjAnVGhpcyclMkMlMjAnb3UnJTJDJTIwJ3NlJyUyQyUwQSUyMCclQzQlQTB0b2snJTJDJTIwJyVDNCVBMHRva2VuJyUyQyUyMCduZCclMkMlMjAnJUM0JUEwaXMnJTJDJTIwJyVDNCVBMHRoJyUyQyUyMCclQzQlQTB0aGUnJTJDJTIwJ2luJyUyQyUyMCclQzQlQTBhYiclMkMlMjAnJUM0JUEwdG9rZW5pJyU1RA==",highlighted:`[<span class="hljs-string">&#x27;&lt;|endoftext|&gt;&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;f&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>, <span class="hljs-string">&#x27;l&#x27;</span>, <span class="hljs-string">&#x27;m&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>,
 <span class="hljs-string">&#x27;p&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;v&#x27;</span>, <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>, <span class="hljs-string">&#x27;z&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;er&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;This&#x27;</span>, <span class="hljs-string">&#x27;ou&#x27;</span>, <span class="hljs-string">&#x27;se&#x27;</span>,
 <span class="hljs-string">&#x27;Ġtok&#x27;</span>, <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;nd&#x27;</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>, <span class="hljs-string">&#x27;Ġth&#x27;</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>, <span class="hljs-string">&#x27;in&#x27;</span>, <span class="hljs-string">&#x27;Ġab&#x27;</span>, <span class="hljs-string">&#x27;Ġtokeni&#x27;</span>]`,wrap:!1}}),f=new Ys({props:{$$slots:{default:[Qa]},$$scope:{ctx:C}}}),vs=new T({props:{code:"ZGVmJTIwdG9rZW5pemUodGV4dCklM0ElMEElMjAlMjAlMjAlMjBwcmVfdG9rZW5pemVfcmVzdWx0JTIwJTNEJTIwdG9rZW5pemVyLl90b2tlbml6ZXIucHJlX3Rva2VuaXplci5wcmVfdG9rZW5pemVfc3RyKHRleHQpJTBBJTIwJTIwJTIwJTIwcHJlX3Rva2VuaXplZF90ZXh0JTIwJTNEJTIwJTVCd29yZCUyMGZvciUyMHdvcmQlMkMlMjBvZmZzZXQlMjBpbiUyMHByZV90b2tlbml6ZV9yZXN1bHQlNUQlMEElMjAlMjAlMjAlMjBzcGxpdHMlMjAlM0QlMjAlNUIlNUJsJTIwZm9yJTIwbCUyMGluJTIwd29yZCU1RCUyMGZvciUyMHdvcmQlMjBpbiUyMHByZV90b2tlbml6ZWRfdGV4dCU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMkMlMjBtZXJnZSUyMGluJTIwbWVyZ2VzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpZHglMkMlMjBzcGxpdCUyMGluJTIwZW51bWVyYXRlKHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpJTIwJTNEJTIwMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdoaWxlJTIwaSUyMCUzQyUyMGxlbihzcGxpdCklMjAtJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwc3BsaXQlNUJpJTVEJTIwJTNEJTNEJTIwcGFpciU1QjAlNUQlMjBhbmQlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEJTIwJTNEJTNEJTIwcGFpciU1QjElNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGxpdCUyMCUzRCUyMHNwbGl0JTVCJTNBaSU1RCUyMCUyQiUyMCU1Qm1lcmdlJTVEJTIwJTJCJTIwc3BsaXQlNUJpJTIwJTJCJTIwMiUyMCUzQSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpJTIwJTJCJTNEJTIwMSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0cyU1QmlkeCU1RCUyMCUzRCUyMHNwbGl0JTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3VtKHNwbGl0cyUyQyUyMCU1QiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">text</span>):
    pre_tokenize_result = tokenizer._tokenizer.pre_tokenizer.pre_tokenize_str(text)
    pre_tokenized_text = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> pre_tokenize_result]
    splits = [[l <span class="hljs-keyword">for</span> l <span class="hljs-keyword">in</span> word] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> pre_tokenized_text]
    <span class="hljs-keyword">for</span> pair, merge <span class="hljs-keyword">in</span> merges.items():
        <span class="hljs-keyword">for</span> idx, split <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(splits):
            i = <span class="hljs-number">0</span>
            <span class="hljs-keyword">while</span> i &lt; <span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>:
                <span class="hljs-keyword">if</span> split[i] == pair[<span class="hljs-number">0</span>] <span class="hljs-keyword">and</span> split[i + <span class="hljs-number">1</span>] == pair[<span class="hljs-number">1</span>]:
                    split = split[:i] + [merge] + split[i + <span class="hljs-number">2</span> :]
                <span class="hljs-keyword">else</span>:
                    i += <span class="hljs-number">1</span>
            splits[idx] = split

    <span class="hljs-keyword">return</span> <span class="hljs-built_in">sum</span>(splits, [])`,wrap:!1}}),Xs=new T({props:{code:"dG9rZW5pemUoJTIyVGhpcyUyMGlzJTIwbm90JTIwYSUyMHRva2VuLiUyMik=",highlighted:'tokenize(<span class="hljs-string">&quot;This is not a token.&quot;</span>)',wrap:!1}}),Ds=new T({props:{code:"JTVCJ1RoaXMnJTJDJTIwJyVDNCVBMGlzJyUyQyUyMCclQzQlQTAnJTJDJTIwJ24nJTJDJTIwJ28nJTJDJTIwJ3QnJTJDJTIwJyVDNCVBMGEnJTJDJTIwJyVDNCVBMHRva2VuJyUyQyUyMCcuJyU1RA==",highlighted:'[<span class="hljs-string">&#x27;This&#x27;</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),$=new Ys({props:{warning:!0,$$slots:{default:[ka]},$$scope:{ctx:C}}}),Rs=new ga({props:{source:"https://github.com/huggingface/course/blob/main/chapters/zh-TW/chapter6/5.mdx"}}),{c(){e=U("meta"),h=t(),u=U("p"),w=t(),M(d.$$.fragment),Fs=t(),M(q.$$.fragment),Ls=t(),M(b.$$.fragment),Os=t(),Q=U("p"),Q.textContent=dn,sl=t(),M(k.$$.fragment),ll=t(),M(x.$$.fragment),nl=t(),M(A.$$.fragment),al=t(),B=U("p"),B.textContent=qn,tl=t(),M(V.$$.fragment),pl=t(),E=U("p"),E.innerHTML=bn,el=t(),M(m.$$.fragment),Ml=t(),Z=U("p"),Z.innerHTML=Qn,yl=t(),z=U("p"),z.textContent=kn,jl=t(),G=U("p"),G.textContent=An,il=t(),M(S.$$.fragment),Jl=t(),_=U("p"),_.innerHTML=Bn,cl=t(),M(N.$$.fragment),Ul=t(),v=U("p"),v.innerHTML=Vn,rl=t(),H=U("p"),H.innerHTML=En,ul=t(),M(X.$$.fragment),ol=t(),D=U("p"),D.innerHTML=Zn,Tl=t(),M(W.$$.fragment),hl=t(),R=U("p"),R.innerHTML=zn,wl=t(),M(Y.$$.fragment),Cl=t(),K=U("p"),K.textContent=Gn,xl=t(),M(g.$$.fragment),ml=t(),M(P.$$.fragment),gl=t(),F=U("p"),F.textContent=Sn,Il=t(),L=U("ol"),L.innerHTML=_n,fl=t(),O=U("p"),O.textContent=Nn,$l=t(),M(ss.$$.fragment),dl=t(),ls=U("p"),ls.innerHTML=vn,ql=t(),M(I.$$.fragment),bl=t(),M(ns.$$.fragment),Ql=t(),as=U("p"),as.textContent=Hn,kl=t(),ts=U("p"),ts.textContent=Xn,Al=t(),M(ps.$$.fragment),Bl=t(),es=U("p"),es.innerHTML=Dn,Vl=t(),M(Ms.$$.fragment),El=t(),ys=U("p"),ys.textContent=Wn,Zl=t(),M(js.$$.fragment),zl=t(),M(is.$$.fragment),Gl=t(),Js=U("p"),Js.textContent=Rn,Sl=t(),M(cs.$$.fragment),_l=t(),M(Us.$$.fragment),Nl=t(),rs=U("p"),rs.innerHTML=Yn,vl=t(),M(us.$$.fragment),Hl=t(),os=U("p"),os.textContent=Kn,Xl=t(),M(Ts.$$.fragment),Dl=t(),hs=U("p"),hs.textContent=Pn,Wl=t(),M(ws.$$.fragment),Rl=t(),Cs=U("p"),Cs.textContent=Fn,Yl=t(),M(xs.$$.fragment),Kl=t(),M(ms.$$.fragment),Pl=t(),gs=U("p"),gs.textContent=Ln,Fl=t(),M(Is.$$.fragment),Ll=t(),M(fs.$$.fragment),Ol=t(),$s=U("p"),$s.innerHTML=On,sn=t(),M(ds.$$.fragment),ln=t(),qs=U("p"),qs.innerHTML=sa,nn=t(),M(bs.$$.fragment),an=t(),Qs=U("p"),Qs.textContent=la,tn=t(),M(ks.$$.fragment),pn=t(),M(As.$$.fragment),en=t(),Bs=U("p"),Bs.textContent=na,Mn=t(),M(Vs.$$.fragment),yn=t(),Es=U("p"),Es.textContent=aa,jn=t(),M(Zs.$$.fragment),Jn=t(),M(zs.$$.fragment),cn=t(),Gs=U("p"),Gs.textContent=ta,Un=t(),M(Ss.$$.fragment),rn=t(),M(_s.$$.fragment),un=t(),M(f.$$.fragment),on=t(),Ns=U("p"),Ns.textContent=pa,Tn=t(),M(vs.$$.fragment),hn=t(),Hs=U("p"),Hs.textContent=ea,wn=t(),M(Xs.$$.fragment),Cn=t(),M(Ds.$$.fragment),xn=t(),M($.$$.fragment),mn=t(),Ws=U("p"),Ws.textContent=Ma,gn=t(),M(Rs.$$.fragment),In=t(),Ps=U("p"),this.h()},l(s){const l=Ca("svelte-u9bgzb",document.head);e=r(l,"META",{name:!0,content:!0}),l.forEach(n),h=p(s),u=r(s,"P",{}),ra(u).forEach(n),w=p(s),y(d.$$.fragment,s),Fs=p(s),y(q.$$.fragment,s),Ls=p(s),y(b.$$.fragment,s),Os=p(s),Q=r(s,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-17pox8i"&&(Q.textContent=dn),sl=p(s),y(k.$$.fragment,s),ll=p(s),y(x.$$.fragment,s),nl=p(s),y(A.$$.fragment,s),al=p(s),B=r(s,"P",{"data-svelte-h":!0}),o(B)!=="svelte-2inrj6"&&(B.textContent=qn),tl=p(s),y(V.$$.fragment,s),pl=p(s),E=r(s,"P",{"data-svelte-h":!0}),o(E)!=="svelte-ucxlp2"&&(E.innerHTML=bn),el=p(s),y(m.$$.fragment,s),Ml=p(s),Z=r(s,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-khgm0p"&&(Z.innerHTML=Qn),yl=p(s),z=r(s,"P",{"data-svelte-h":!0}),o(z)!=="svelte-16rhscq"&&(z.textContent=kn),jl=p(s),G=r(s,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1pymdi4"&&(G.textContent=An),il=p(s),y(S.$$.fragment,s),Jl=p(s),_=r(s,"P",{"data-svelte-h":!0}),o(_)!=="svelte-r48sl9"&&(_.innerHTML=Bn),cl=p(s),y(N.$$.fragment,s),Ul=p(s),v=r(s,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1swwp9p"&&(v.innerHTML=Vn),rl=p(s),H=r(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-zpne97"&&(H.innerHTML=En),ul=p(s),y(X.$$.fragment,s),ol=p(s),D=r(s,"P",{"data-svelte-h":!0}),o(D)!=="svelte-5kte7b"&&(D.innerHTML=Zn),Tl=p(s),y(W.$$.fragment,s),hl=p(s),R=r(s,"P",{"data-svelte-h":!0}),o(R)!=="svelte-giox8m"&&(R.innerHTML=zn),wl=p(s),y(Y.$$.fragment,s),Cl=p(s),K=r(s,"P",{"data-svelte-h":!0}),o(K)!=="svelte-125t69x"&&(K.textContent=Gn),xl=p(s),y(g.$$.fragment,s),ml=p(s),y(P.$$.fragment,s),gl=p(s),F=r(s,"P",{"data-svelte-h":!0}),o(F)!=="svelte-s2d4c4"&&(F.textContent=Sn),Il=p(s),L=r(s,"OL",{"data-svelte-h":!0}),o(L)!=="svelte-yp7zsq"&&(L.innerHTML=_n),fl=p(s),O=r(s,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1mqz9bf"&&(O.textContent=Nn),$l=p(s),y(ss.$$.fragment,s),dl=p(s),ls=r(s,"P",{"data-svelte-h":!0}),o(ls)!=="svelte-1c63kc0"&&(ls.innerHTML=vn),ql=p(s),y(I.$$.fragment,s),bl=p(s),y(ns.$$.fragment,s),Ql=p(s),as=r(s,"P",{"data-svelte-h":!0}),o(as)!=="svelte-wk57ec"&&(as.textContent=Hn),kl=p(s),ts=r(s,"P",{"data-svelte-h":!0}),o(ts)!=="svelte-1amsvnb"&&(ts.textContent=Xn),Al=p(s),y(ps.$$.fragment,s),Bl=p(s),es=r(s,"P",{"data-svelte-h":!0}),o(es)!=="svelte-s31cgz"&&(es.innerHTML=Dn),Vl=p(s),y(Ms.$$.fragment,s),El=p(s),ys=r(s,"P",{"data-svelte-h":!0}),o(ys)!=="svelte-16ge37"&&(ys.textContent=Wn),Zl=p(s),y(js.$$.fragment,s),zl=p(s),y(is.$$.fragment,s),Gl=p(s),Js=r(s,"P",{"data-svelte-h":!0}),o(Js)!=="svelte-1goryqc"&&(Js.textContent=Rn),Sl=p(s),y(cs.$$.fragment,s),_l=p(s),y(Us.$$.fragment,s),Nl=p(s),rs=r(s,"P",{"data-svelte-h":!0}),o(rs)!=="svelte-10w4a2b"&&(rs.innerHTML=Yn),vl=p(s),y(us.$$.fragment,s),Hl=p(s),os=r(s,"P",{"data-svelte-h":!0}),o(os)!=="svelte-c21ci5"&&(os.textContent=Kn),Xl=p(s),y(Ts.$$.fragment,s),Dl=p(s),hs=r(s,"P",{"data-svelte-h":!0}),o(hs)!=="svelte-1bhf379"&&(hs.textContent=Pn),Wl=p(s),y(ws.$$.fragment,s),Rl=p(s),Cs=r(s,"P",{"data-svelte-h":!0}),o(Cs)!=="svelte-1gv0rei"&&(Cs.textContent=Fn),Yl=p(s),y(xs.$$.fragment,s),Kl=p(s),y(ms.$$.fragment,s),Pl=p(s),gs=r(s,"P",{"data-svelte-h":!0}),o(gs)!=="svelte-12sv1a5"&&(gs.textContent=Ln),Fl=p(s),y(Is.$$.fragment,s),Ll=p(s),y(fs.$$.fragment,s),Ol=p(s),$s=r(s,"P",{"data-svelte-h":!0}),o($s)!=="svelte-1lvsckd"&&($s.innerHTML=On),sn=p(s),y(ds.$$.fragment,s),ln=p(s),qs=r(s,"P",{"data-svelte-h":!0}),o(qs)!=="svelte-1phnwkv"&&(qs.innerHTML=sa),nn=p(s),y(bs.$$.fragment,s),an=p(s),Qs=r(s,"P",{"data-svelte-h":!0}),o(Qs)!=="svelte-jw1a3u"&&(Qs.textContent=la),tn=p(s),y(ks.$$.fragment,s),pn=p(s),y(As.$$.fragment,s),en=p(s),Bs=r(s,"P",{"data-svelte-h":!0}),o(Bs)!=="svelte-e3mcqu"&&(Bs.textContent=na),Mn=p(s),y(Vs.$$.fragment,s),yn=p(s),Es=r(s,"P",{"data-svelte-h":!0}),o(Es)!=="svelte-1h8gz36"&&(Es.textContent=aa),jn=p(s),y(Zs.$$.fragment,s),Jn=p(s),y(zs.$$.fragment,s),cn=p(s),Gs=r(s,"P",{"data-svelte-h":!0}),o(Gs)!=="svelte-10ltvxx"&&(Gs.textContent=ta),Un=p(s),y(Ss.$$.fragment,s),rn=p(s),y(_s.$$.fragment,s),un=p(s),y(f.$$.fragment,s),on=p(s),Ns=r(s,"P",{"data-svelte-h":!0}),o(Ns)!=="svelte-23pg7h"&&(Ns.textContent=pa),Tn=p(s),y(vs.$$.fragment,s),hn=p(s),Hs=r(s,"P",{"data-svelte-h":!0}),o(Hs)!=="svelte-1r6mvob"&&(Hs.textContent=ea),wn=p(s),y(Xs.$$.fragment,s),Cn=p(s),y(Ds.$$.fragment,s),xn=p(s),y($.$$.fragment,s),mn=p(s),Ws=r(s,"P",{"data-svelte-h":!0}),o(Ws)!=="svelte-1avkgv4"&&(Ws.textContent=Ma),gn=p(s),y(Rs.$$.fragment,s),In=p(s),Ps=r(s,"P",{}),ra(Ps).forEach(n),this.h()},h(){ua(e,"name","hf:doc:metadata"),ua(e,"content",Ba)},m(s,l){xa(document.head,e),a(s,h,l),a(s,u,l),a(s,w,l),j(d,s,l),a(s,Fs,l),j(q,s,l),a(s,Ls,l),j(b,s,l),a(s,Os,l),a(s,Q,l),a(s,sl,l),j(k,s,l),a(s,ll,l),j(x,s,l),a(s,nl,l),j(A,s,l),a(s,al,l),a(s,B,l),a(s,tl,l),j(V,s,l),a(s,pl,l),a(s,E,l),a(s,el,l),j(m,s,l),a(s,Ml,l),a(s,Z,l),a(s,yl,l),a(s,z,l),a(s,jl,l),a(s,G,l),a(s,il,l),j(S,s,l),a(s,Jl,l),a(s,_,l),a(s,cl,l),j(N,s,l),a(s,Ul,l),a(s,v,l),a(s,rl,l),a(s,H,l),a(s,ul,l),j(X,s,l),a(s,ol,l),a(s,D,l),a(s,Tl,l),j(W,s,l),a(s,hl,l),a(s,R,l),a(s,wl,l),j(Y,s,l),a(s,Cl,l),a(s,K,l),a(s,xl,l),j(g,s,l),a(s,ml,l),j(P,s,l),a(s,gl,l),a(s,F,l),a(s,Il,l),a(s,L,l),a(s,fl,l),a(s,O,l),a(s,$l,l),j(ss,s,l),a(s,dl,l),a(s,ls,l),a(s,ql,l),j(I,s,l),a(s,bl,l),j(ns,s,l),a(s,Ql,l),a(s,as,l),a(s,kl,l),a(s,ts,l),a(s,Al,l),j(ps,s,l),a(s,Bl,l),a(s,es,l),a(s,Vl,l),j(Ms,s,l),a(s,El,l),a(s,ys,l),a(s,Zl,l),j(js,s,l),a(s,zl,l),j(is,s,l),a(s,Gl,l),a(s,Js,l),a(s,Sl,l),j(cs,s,l),a(s,_l,l),j(Us,s,l),a(s,Nl,l),a(s,rs,l),a(s,vl,l),j(us,s,l),a(s,Hl,l),a(s,os,l),a(s,Xl,l),j(Ts,s,l),a(s,Dl,l),a(s,hs,l),a(s,Wl,l),j(ws,s,l),a(s,Rl,l),a(s,Cs,l),a(s,Yl,l),j(xs,s,l),a(s,Kl,l),j(ms,s,l),a(s,Pl,l),a(s,gs,l),a(s,Fl,l),j(Is,s,l),a(s,Ll,l),j(fs,s,l),a(s,Ol,l),a(s,$s,l),a(s,sn,l),j(ds,s,l),a(s,ln,l),a(s,qs,l),a(s,nn,l),j(bs,s,l),a(s,an,l),a(s,Qs,l),a(s,tn,l),j(ks,s,l),a(s,pn,l),j(As,s,l),a(s,en,l),a(s,Bs,l),a(s,Mn,l),j(Vs,s,l),a(s,yn,l),a(s,Es,l),a(s,jn,l),j(Zs,s,l),a(s,Jn,l),j(zs,s,l),a(s,cn,l),a(s,Gs,l),a(s,Un,l),j(Ss,s,l),a(s,rn,l),j(_s,s,l),a(s,un,l),j(f,s,l),a(s,on,l),a(s,Ns,l),a(s,Tn,l),j(vs,s,l),a(s,hn,l),a(s,Hs,l),a(s,wn,l),j(Xs,s,l),a(s,Cn,l),j(Ds,s,l),a(s,xn,l),j($,s,l),a(s,mn,l),a(s,Ws,l),a(s,gn,l),j(Rs,s,l),a(s,In,l),a(s,Ps,l),fn=!0},p(s,[l]){const ya={};l&2&&(ya.$$scope={dirty:l,ctx:s}),x.$set(ya);const ja={};l&2&&(ja.$$scope={dirty:l,ctx:s}),m.$set(ja);const ia={};l&2&&(ia.$$scope={dirty:l,ctx:s}),g.$set(ia);const Ja={};l&2&&(Ja.$$scope={dirty:l,ctx:s}),I.$set(Ja);const ca={};l&2&&(ca.$$scope={dirty:l,ctx:s}),f.$set(ca);const Ua={};l&2&&(Ua.$$scope={dirty:l,ctx:s}),$.$set(Ua)},i(s){fn||(i(d.$$.fragment,s),i(q.$$.fragment,s),i(b.$$.fragment,s),i(k.$$.fragment,s),i(x.$$.fragment,s),i(A.$$.fragment,s),i(V.$$.fragment,s),i(m.$$.fragment,s),i(S.$$.fragment,s),i(N.$$.fragment,s),i(X.$$.fragment,s),i(W.$$.fragment,s),i(Y.$$.fragment,s),i(g.$$.fragment,s),i(P.$$.fragment,s),i(ss.$$.fragment,s),i(I.$$.fragment,s),i(ns.$$.fragment,s),i(ps.$$.fragment,s),i(Ms.$$.fragment,s),i(js.$$.fragment,s),i(is.$$.fragment,s),i(cs.$$.fragment,s),i(Us.$$.fragment,s),i(us.$$.fragment,s),i(Ts.$$.fragment,s),i(ws.$$.fragment,s),i(xs.$$.fragment,s),i(ms.$$.fragment,s),i(Is.$$.fragment,s),i(fs.$$.fragment,s),i(ds.$$.fragment,s),i(bs.$$.fragment,s),i(ks.$$.fragment,s),i(As.$$.fragment,s),i(Vs.$$.fragment,s),i(Zs.$$.fragment,s),i(zs.$$.fragment,s),i(Ss.$$.fragment,s),i(_s.$$.fragment,s),i(f.$$.fragment,s),i(vs.$$.fragment,s),i(Xs.$$.fragment,s),i(Ds.$$.fragment,s),i($.$$.fragment,s),i(Rs.$$.fragment,s),fn=!0)},o(s){J(d.$$.fragment,s),J(q.$$.fragment,s),J(b.$$.fragment,s),J(k.$$.fragment,s),J(x.$$.fragment,s),J(A.$$.fragment,s),J(V.$$.fragment,s),J(m.$$.fragment,s),J(S.$$.fragment,s),J(N.$$.fragment,s),J(X.$$.fragment,s),J(W.$$.fragment,s),J(Y.$$.fragment,s),J(g.$$.fragment,s),J(P.$$.fragment,s),J(ss.$$.fragment,s),J(I.$$.fragment,s),J(ns.$$.fragment,s),J(ps.$$.fragment,s),J(Ms.$$.fragment,s),J(js.$$.fragment,s),J(is.$$.fragment,s),J(cs.$$.fragment,s),J(Us.$$.fragment,s),J(us.$$.fragment,s),J(Ts.$$.fragment,s),J(ws.$$.fragment,s),J(xs.$$.fragment,s),J(ms.$$.fragment,s),J(Is.$$.fragment,s),J(fs.$$.fragment,s),J(ds.$$.fragment,s),J(bs.$$.fragment,s),J(ks.$$.fragment,s),J(As.$$.fragment,s),J(Vs.$$.fragment,s),J(Zs.$$.fragment,s),J(zs.$$.fragment,s),J(Ss.$$.fragment,s),J(_s.$$.fragment,s),J(f.$$.fragment,s),J(vs.$$.fragment,s),J(Xs.$$.fragment,s),J(Ds.$$.fragment,s),J($.$$.fragment,s),J(Rs.$$.fragment,s),fn=!1},d(s){s&&(n(h),n(u),n(w),n(Fs),n(Ls),n(Os),n(Q),n(sl),n(ll),n(nl),n(al),n(B),n(tl),n(pl),n(E),n(el),n(Ml),n(Z),n(yl),n(z),n(jl),n(G),n(il),n(Jl),n(_),n(cl),n(Ul),n(v),n(rl),n(H),n(ul),n(ol),n(D),n(Tl),n(hl),n(R),n(wl),n(Cl),n(K),n(xl),n(ml),n(gl),n(F),n(Il),n(L),n(fl),n(O),n($l),n(dl),n(ls),n(ql),n(bl),n(Ql),n(as),n(kl),n(ts),n(Al),n(Bl),n(es),n(Vl),n(El),n(ys),n(Zl),n(zl),n(Gl),n(Js),n(Sl),n(_l),n(Nl),n(rs),n(vl),n(Hl),n(os),n(Xl),n(Dl),n(hs),n(Wl),n(Rl),n(Cs),n(Yl),n(Kl),n(Pl),n(gs),n(Fl),n(Ll),n(Ol),n($s),n(sn),n(ln),n(qs),n(nn),n(an),n(Qs),n(tn),n(pn),n(en),n(Bs),n(Mn),n(yn),n(Es),n(jn),n(Jn),n(cn),n(Gs),n(Un),n(rn),n(un),n(on),n(Ns),n(Tn),n(hn),n(Hs),n(wn),n(Cn),n(xn),n(mn),n(Ws),n(gn),n(In),n(Ps)),n(e),c(d,s),c(q,s),c(b,s),c(k,s),c(x,s),c(A,s),c(V,s),c(m,s),c(S,s),c(N,s),c(X,s),c(W,s),c(Y,s),c(g,s),c(P,s),c(ss,s),c(I,s),c(ns,s),c(ps,s),c(Ms,s),c(js,s),c(is,s),c(cs,s),c(Us,s),c(us,s),c(Ts,s),c(ws,s),c(xs,s),c(ms,s),c(Is,s),c(fs,s),c(ds,s),c(bs,s),c(ks,s),c(As,s),c(Vs,s),c(Zs,s),c(zs,s),c(Ss,s),c(_s,s),c(f,s),c(vs,s),c(Xs,s),c(Ds,s),c($,s),c(Rs,s)}}}const Ba='{"title":"字節對編碼標記化","local":"字節對編碼標記化","sections":[{"title":"訓練算法","local":"訓練算法","sections":[],"depth":2},{"title":"標記化算法","local":"標記化算法","sections":[],"depth":2},{"title":"實現 BPE","local":"實現-bpe","sections":[],"depth":2}],"depth":1}';function Va(C){return Ta(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class va extends ha{constructor(e){super(),wa(this,e,Va,Aa,oa,{})}}export{va as component};
