# 課程簡介

歡迎來到 Hugging Face 的教學！本篇介紹將會帶著你設置運行環境。如果你正開始學的話，不妨先看看[第一章](/course/chapter1)再回來，這樣就能直接開始試著執行裡面的程式碼了。

我們會用到的所有函式庫都將會以 Python 資源包的方式被取得，所以這邊我們會教你如何設置 Python 環境並安裝你所需要的函式庫。

本篇將會涵蓋兩種設置環境的方法 - 使用 Colab notebook 或是 Python 虛擬環境。選你自己覺得合適的方式就好，但是對於初學者我們強烈推薦先從使用 Colab notebook 開始。

我們不會提到 Windows 系統，如果你是 Windows 的使用者，我們建議使用 Colab notebook。如果你用的是 Linux 或是 macOS，你可以任意選擇上述的兩種方法。

大部分的教學都會需要一個Hugging Face的帳號。我們建議現在就[創一個](https://huggingface.co/join)。

## 使用Google Colab notebook

用 Colab notebook 是最簡單容易的方法；在瀏覽器開一頁 Colab notebook 就能直接開始寫程式了！

如果你對 Colab notebook 不熟悉的話，我們建議你從[這篇介紹](https://colab.research.google.com/notebooks/intro.ipynb)開始。在 Colab 上你可以使用一些加速硬體，像是 GPU 或 TPU，而且工作量不大的話也不收費。

當你開始熟悉 Colab 後，建立新的筆記本然後開始進行設置：

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/new_colab.png" alt="An empty colab notebook" width="80%"/>
</div>

接下來就是安裝我們將會用到的函式庫。我們會使用 `pip` 這個Python的資源管理工具來安裝。在Colab notebook裡，你可以用 `!` 來執行系統指令，所以你可以用以下的指令來安裝 🤗 Transformers 函式庫：

```
!pip install transformers
```

把函式庫導入到 Python runtime 可以確認你的資源包有被正確地安裝：

```
import transformers
```

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/install.gif" alt="A gif showing the result of the two commands above: installation and import" width="80%"/>
</div>

這會安裝一個非常輕量的 🤗 Transformers。裡面沒有安裝任何像是 PyTorch 或 TensorFlow 等的機器學習框架。因為我們會用到很多函式庫裡的不同功能，所以我們建議安裝包含了大部分使用情境所需資源的開發用版本：


```
!pip install transformers[sentencepiece]
```

這會花一點時間，不過裝完你就已經完全準備好面對剩下的教學了！


## 使用Python虛擬環境

如果你比較想用 Python 虛擬環境的話，第一步就是安裝 Python。我們建議跟著[這篇教學](https://realpython.com/installing-python/)做為起手式。


當你安裝好 Python 後，你應該就能從終端機執行 Python 指令了。在進行下一步之前你可以先執行以下指令來確認 Python 有沒有安裝好：`python --version` 這條指令會讓終端機顯示你所安裝的 Python 版本。


在終端機執行像是`python --version`的 Python 指令時，你應該把你的指令想成是用你系統上主要的 Python 版本來執行。我們建議不要在這個版本上安裝任何資源包，讓每個專案在各自獨立的環境裡運行就可以了。這樣每個專案都可以有各自的相依性跟資源包，你也不用擔心不同專案之間使用同一個環境時潛在的相容性問題。


在 Python 我們可以用[*虛擬環境*](https://docs.python.org/3/tutorial/venv.html)來做這件事。虛擬環境是一個獨立包裝的樹狀目錄，每一個目錄下都有安裝特定版本的Python跟它需要的所有資源包。創建這樣的虛擬環境可以用很多不同的工具，不過我們會用一個叫做[`venv`](https://docs.python.org/3/library/venv.html#module-venv)的Python官方資源包。

首先，創建你希望你的程式執行時所在的目錄 - 舉例來說，你可能想要在你的家目錄下新增一個叫*transformers-course*的目錄：

```
mkdir ~/transformers-course
cd ~/transformers-course
```
從這個目錄裡面，你可以用Python的`venv`模組建立一個虛擬環境：

```
python -m venv .env
```
你現在應該在你的空資料夾裡找到一個叫做*.env*的目錄，這個目錄就是你的虛擬環境。
You should now have a directory called *.env* in your otherwise empty folder:

```
ls -a
```

```out
.      ..    .env
```
你可用 `activate` 和 `deactivate` 這兩個腳本來啟用或關閉你的虛擬環境：

```
# Activate the virtual environment
source .env/bin/activate

# Deactivate the virtual environment
deactivate
```
你可以執行 `which python` 指令來確認你的虛擬環境是否有被啟用：如果它指向虛擬環境的目錄，那表示你的虛擬環境已經啟用了！

```
which python
```

```out
/home/<user>/transformers-course/.env/bin/python
```

### 安裝相依性資源包

在之前的段落中提到的使用 Google Colab 的情況裡，你會需要安裝相依性資源包才能繼續。你可以用 `pip` 這個資源管理工具來安裝開發版的🤗 Transformers：

```
pip install "transformers[sentencepiece]"
```
你現在已經準備就緒，可以開始了！


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-TW/chapter0/1.mdx" />