# 本章簡介

<CourseFloatingBanner
    chapter={2}
    classNames="absolute z-10 right-0 top-0"
/>

正如你在 [Chapter 1](/course/chapter1),中看到的那樣，Transformers 模型通常非常大。對於數以百萬計到數千萬計數十億的參數，訓練和部署這些模型是一項複雜的任務。此外，由於幾乎每天都在發佈新模型，而且每種模型都有自己的實現，因此嘗試它們絕非易事。

創建 🤗Transformers 庫就是為了解決這個問題。它的目標是提供一個API，通過它可以加載、訓練和保存任何Transformer模型。這個庫的主要特點是：
-  **易於使用**：下載、加載和使用最先進的NLP模型進行推理只需兩行代碼即可完成。
- **靈活**：所有模型的核心都是簡單的 PyTorch **nn.Module** 或者 TensorFlow **tf.kears.Model**，可以像它們各自的機器學習（ML）框架中的任何其他模型一樣進行處理。
- **簡單**：當前位置整個庫幾乎沒有任何摘要。“都在一個文件中”是一個核心概念：模型的正向傳遞完全定義在一個文件中，因此代碼本身是可以理解的，並且是可以破解的。

最後一個特性使🤗 Transformers與其他ML庫截然不同。這些模型不是基於通過文件共享的模塊構建的；相反，每一個模型都有自己的網絡結構（layers）。除了使模型更加容易接受和更容易理解，這還允許你輕鬆地在一個模型上實驗，而且不影響其他模型。

本章將從一個端到端的示例開始，在該示例中，我們一起使用模型和tokenizer分詞器來複制[Chapter 1](/course/chapter1)中引入的函數 pipeline(). 接下來，我們將討論模型API：我們將深入研究模型和配置類，並向您展示如何加載模型以及如何將數值輸入處理為輸出預測。

然後我們來看看標記器API，它是 pipeline() 函數的另一個主要組件。它是作用分詞器負責第一個和最後一個處理步驟，處理從文本到神經網絡數字輸入的轉換，以及在需要時轉換回文本。最後，我們將向您展示如何處理在一個準備好的批處理中通過一個模型發送多個句子的問題，然後詳細介紹 pipeline() 函數。

<Tip>
⚠️ 為了從模型中心和 🤗Transformers 的所有可用功能中獲益，我們建議<a href="https://huggingface.co/join">creating an account</a>.
</Tip>

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-TW/chapter2/1.mdx" />