# 構建模型卡片

<CourseFloatingBanner
    chapter={4}
    classNames="absolute z-10 right-0 top-0"
/>

模型卡片是一個配置文件，可以說與模型存儲庫中的模型和 tokenizer 文件一樣重要。它包含了模型的核心定義，確保了社區成員可以復現模型的結果，並提供一個其他成員可以在這個模型基礎上構建他們的組件的平臺。

記錄訓練和評估過程並提供有關使用的數據以及已完成的預處理和後續處理的足夠信息，有助於其他人瞭解對模型的能力——確保模型存在和目前的限制、偏差可以識別和理解。

因此，創建清晰定義模型的模型卡片是非常重要的一步。在這裡，我們提供了一些可以幫助您解決此問題的方法。創建模型卡片是通過您之前看到的 Markdown 文件：README.md 。

「模型卡片」的概念源於谷歌的一個研究方向， Margaret Mitchell 等人在論文[“Model Cards for Model Reporting”](https://arxiv.org/abs/1810.03993)中首次提出，此處包含的許多信息均基於該論文，我們建議您查看這篇論文以瞭解為什麼模型卡片在重視可重複性、可重用性和公平性的時候中如此重要。

模型卡通常以非常簡短的概述開始，說明模型的用途，然後是模型卡片需要的其他信息：

- 模型描述
- 預期用途和限制
- 如何使用
- 侷限性和偏見
- 訓練數據
- 訓練程序
- 評價結果

讓我們來看看每個部分應該包含什麼。

### 模型描述：

提供了有關模型的基本詳細信息。這包括架構、版本、如果它是在論文中介紹的，是否有原始的實現可用？作者以及有關模型的一般信息、任何版權都應歸於此處。這一部分還可以提及有關訓練程序、參數和重要免責聲明的一般信息。

### 預期用途和限制：

在此描述模型可以適用的例子，包括可以應用它的語言、領域。模型卡的這一部分還可以記錄已知超出模型範圍的區域，或者可能表現不佳的區域。

### 使用方法：

此部分應包括一些有關如何使用模型的示例。這可以展示使用 **pipeline()** 函數、模型和標記器類的使用以及其他任何您認為可能有幫助的代碼。

### 訓練數據：

這部分應該指出模型是在哪個數據集上訓練的。也歡迎對數據集進行簡要描述。

### 訓練過程：

此部分中，您應該描述從再現性角度來看有用的訓練的所有相關方面。這包括對數據進行的任何預處理和後處理，以及模型訓練的批量數、批量大小、學習率等細節。

### 變量和指標：

在這裡，您應該描述您用於評估的指標，以及您測量的不同因素。提及使用了哪些指標、在哪個數據集上以及哪個數據集部分，可以輕鬆地將您的模型的性能與其他模型的性能進行比較。

### 評價結果：

這些應該提前在前面的部分告知，例如預期的使用效果和示例。最後，提供模型在評估數據集上的表現的指示。如果模型使用決策閾值，要麼提供評估中使用的決策閾值，要麼提供在不同閾值下針對預期用途進行評估的詳細信息。

## 例子

查看以下幾個精心製作的模型卡的例子：

* [bert-base-cased](https://huggingface.co/bert-base-cased)
* [gpt2](https://huggingface.co/gpt2)
* [distilbert](https://huggingface.co/distilbert-base-uncased)

更多來自於不同組織和公司的示例可以在[這裡](https://github.com/huggingface/model_card/blob/master/examples.md)查閱.

## 提示

發佈模型時不需要模型卡，製作一個模型時不需要包含上述所有部分。但是，模型的文檔會使未來的用戶受益，因此我們建議您儘自己的知識和能力填寫儘可能多的部分。

## 模型卡片元數據

如果您對 Hugging Face Hub 進行了一些探索，您應該已經看到某些模型屬於某些類別：您可以按任務、語言、庫等對其進行過濾。模型所屬的類別來自於您在模型卡片標題中添加的元數據。

例如，如果你看一下[`camembert-base` 模型卡片](https://huggingface.co/camembert-base/blob/main/README.md)，您應該在模型卡標題中看到以下幾行：

```
---
language: fr
license: mit
datasets:
- oscar
---
```

該元數據由 Hugging Face Hub 解析，然後將這個模型識別為法語模型，擁有 MIT 許可證，在 Oscar 數據集上訓練。

允許的指定語言、許可證、標籤、數據集、指標以及模型在訓練時獲得的評估結果在[全部模型卡片的規格](https://raw.githubusercontent.com/huggingface/huggingface_hub/main/modelcard.md)可以查閱。

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-TW/chapter4/4.mdx" />