# 章末小測驗

<CourseFloatingBanner
    chapter={6}
    classNames="absolute z-10 right-0 top-0"
/>

讓我們測試一下您在本章中學到了什麼！

### 1.你應該什麼時候訓練一個新的標記器？
<Question
	choices={[
		{
			text: "當您的數據集與現有的預訓練模型所使用的數據集相似時，並且您希望預訓練一個新模型",
			explain: "在這種情況下，為了節省時間和計算資源，一個更好的選擇是使用與預訓練模型相同的標記器，並對該模型進行微調。"
		},
		{
			text: "當您的數據集與現有的預訓練模型所使用的數據集相似時，並且您希望使用此預訓練模型對新模型進行微調",
			explain: "要根據預先訓練的模型對模型進行微調，您應該始終使用相同的標記器。"
		},
		{
			text: "當您的數據集與現有預訓練模型所使用的數據集不同時，您希望預訓練一個新模型",
			explain: "正確！ 在這種情況下，使用現有預訓練模型標記器將沒有任何優勢。",
            correct: true
		},
        {
			text: "當您的數據集與現有預訓練模型所使用的數據集不同時，但是您希望使用此預訓練模型對新模型進行微調",
			explain: "要根據預先訓練的模型對模型進行微調，您應該始終使用相同的標記器。"
		}
	]}
/>

### 2.當使用“ train_new_from_iterator()”時，使用文本列表生成器與文本列表相比有什麼優點？
<Question
	choices={[
		{
			text: "這是方法 < code > train_new_from_iterator() </code > 接受的唯一類型。",
			explain: "文本列表是一種特殊的文本列表生成器，因此該方法也會接受這種方法。再試一次！"
		},
		{
			text: "您將避免立即將整個數據集載入內存中。",
			explain: "沒錯！每一批文本都會在你迭代的時候從內存中釋放出來，如果你使用數據集存儲文本的話，增益將尤其明顯。",
			correct: true
		},
		{
			text: "這將允許 Tokenizers 庫使用並行處理。",
			explain: "不，無論如何它都將使用並行處理。"
		},
        {
			text: "你訓練的標記器將產生更好的文本。",
			explain: "Tokenizer 不生成文本——您是否將其與語言模型混淆了？"
		}
	]}
/>

### 3.使用“快速”標記器的優點是什麼？
<Question
	choices={[
		{
			text: "當你批處理大量的輸入時，它可以比一個滿速的標記器更快地處理輸入。",
			explain: "正確！由於在 Rust 中實現了並行性，它將在批量處理輸入上更快。你還能想到其他什麼好處嗎？",
			correct: true
		},
		{
			text: "快速的標記法總是比慢速的標記法快。",
			explain: "一個快速的標記器當你只給它一個或很少的文本實際上可能會更慢，因為它不能使用並行。"
		},
		{
			text: "它可以填充和截斷文本。",
			explain: "是的，但是慢速的標記符也會這樣做。"
		},
        {
			text: "它有一些額外的功能，允許你將標記映射到創建它們的文本範圍。",
			explain: "事實上，這些被稱為偏移映射，但這並不是唯一的優點。",
			correct: true
		}
	]}
/>

### 4.“token-classification”管道如何處理跨多個標記的實體？
<Question
	choices={[
		{
			text: "具有相同標籤的實體合併為一個實體。",
			explain: "這有點過於簡單化了，再試一次！"
		},
		{
			text: "實體的開始有一個標籤，實體的持續有一個標籤。",
			explain: "正確！",
			correct: true
		},
		{
			text: "在給定的單詞中，只要第一個標記具有實體的標籤，則認為整個單詞都帶有該實體的標籤。",
			explain: "這是一個處理實體的策略，這裡還有什麼其他的答案嗎？",
			correct: true
		},
        {
			text: "當一個標記具有給定實體的標記時，除非標記為新實體的開始，否則具有相同標記的任何其他後續標記都被視為同一實體的一部分。",
			explain: "這是最常見的將實體組合在一起的方法---- 儘管這不是唯一正確的答案。",
			correct: true
		}
	]}
/>

### 5.“question-answering”流水線如何處理長上下文？
<Question
	choices={[
		{
			text: "實際上並不是這樣，因為它在模型接受的最大長度上截斷了長上下文。",
			explain: "有一個技巧你可以用來處理很長的上下文，你還記得是什麼嗎？"
		},
		{
			text: "它將上下文分成若干部分，並對所得結果進行平均。",
			explain: "不，對結果進行平均是沒有意義的，因為上下文的某些部分不包括答案。"
		},
		{
			text: "它將上下文拆分為若干部分(有重疊部分) ，並在每個部分中查找一個答案的最大得分。",
			explain: "這就是正確答案！",
			correct: true
		},
        {
			text: "它將上下文分成若干部分(不重疊，以提高效率) ，並在每個部分中找到一個答案的最大得分。",
			explain: "不，它包括部分之間的一些重疊，以避免出現答案將分成兩部分的情況。"
		}
	]}
/>

### 6.什麼是標準化？
<Question
	choices={[
		{
			text: "這是 tokenizer 在初始階段對文本執行的任何清理。",
			explain: "這是正確的——例如，它可能涉及刪除重音符號或空格，或縮小輸入的大小寫。",
			correct: true
		},
		{
			text: "這是一種數據增強技術，包括通過刪除稀有單詞使文本更加標準。",
			explain: "不對! 再試一次。"
		},
		{
			text: "在最後的後處理步驟中，tokenizer 添加特殊標記。",
			explain: "這個階段簡單地稱為後期處理。"
		},
        {
			text: "這是當嵌入的平均值為0和標準差為1時，通過減去平均值和除以標準差。",
			explain: "在計算機視覺中，這個過程通常被稱為標準化，但在 NLP 中，這並不是標準化的意思。"
		}
	]}
/>

### 7.什麼是子詞標記化的前標記化？
<Question
	choices={[
		{
			text: "這是標記化之前的步驟，應用數據增強(如隨機遮罩)。",
			explain: "不，這一步是預處理的一部分。"
		},
		{
			text: "這是標記化之前的步驟，在這個步驟中，所需的清理操作應用於文本。",
			explain: "不，這是標準化步驟。"
		},
		{
			text: "這是應用 tokenizer 模型之前的步驟，將輸入拆分為單詞。",
			explain: "這就是正確答案！",
			correct: true
		},
        {
			text: "這是應用 tokenizer 模型之前的步驟，將輸入拆分為標記。",
			explain: "不，分解為標記是 tokenizer 模型的工作。"
		}
	]}
/>

### 8.選擇描述標記化 BPE 模式最準確的句子。
<Question
	choices={[
		{
			text: "BPE 是一個子詞標記算法，從小詞彙表開始，學習合併規則。",
			explain: "的確如此！",
			correct: true
		},
		{
			text: "BPE 是一種子詞標記算法，從大詞彙表開始，逐步從中刪除標記。",
			explain: "不，另一種標記算法所採用的方法。"
		},
		{
			text: "BPE 標記器通過合併最常見的一對標記來學習合併規則。",
			explain: "沒錯！",
			correct: true
		},
		{
			text: "BPE 記號賦予器通過合併一對記號來學習合併規則，該記號最大化了特權頻繁對和較少個別部分的分數。",
			explain: "不，這是另一個標記算法應用的策略。"
		},
		{
			text: "BPE 通過將單詞分割成字符，然後應用合併規則將單詞分解成子單詞。",
			explain: "沒錯！",
			correct: true
		},
		{
			text: "BPE 通過從詞彙表的開頭找到最長的子詞，然後在文本的其餘部分重複這個過程，將單詞轉化為子詞。",
			explain: "不，這是另一種標記化算法的做事方式。"
		},
	]}
/>

### 9.選擇適用於 WordPiece 標記模型的句子。
<Question
	choices={[
		{
			text: "WordPiece 是一個子詞標記算法，它從一個小詞彙表開始，學習合併規則。",
			explain: "的確如此！",
			correct: true
		},
		{
			text: "WordPiece 是一種子詞標記算法，從大詞彙表開始，逐步從中刪除標記。",
			explain: "不，這是一種不同的標記算法所採用的方法。"
		},
		{
			text: "WordPiece 標記器通過合併最常見的兩個標記來學習合併規則。",
			explain: "不，這是另一個標記算法應用的策略。"
		},
		{
			text: "WordPiece 標記器通過合併兩個標記來學習合併規則，這兩個標記最大限度地提高了頻繁出現的標記的分數，而這兩個標記的獨立部分出現頻率較低。",
			explain: "沒錯！",
			correct: true
		},
		{
			text: "根據模型，WordPiece 通過找到最有可能的切分符號，將單詞標記為子單詞。",
			explain: "不，這是另一個標記化算法的工作原理。"
		},
		{
			text: "WordPiece 通過從詞彙表的開頭找到最長的子詞，然後在文本的其餘部分重複這個過程，將單詞轉化為子詞。",
			explain: "是的，這就是 WordPiece 進行編碼的過程。",
			correct: true
		},
	]}
/>

### 10.選擇適用於 Unigram 標記模式的句子。
<Question
	choices={[
		{
			text: "Unigram 是一個子詞標記算法，它從一個很小的詞彙表開始學習合併規則。",
			explain: "不，這是一種不同的標記算法所採用的方法。"
		},
		{
			text: "Unigram 是一種子詞標記算法，它從大詞彙表開始，逐步從中刪除標記。",
			explain: "沒錯！",
			correct: true
		},
		{
			text: "Unigram 通過最小化在整個語料庫中的損失來調整詞彙量。",
			explain: "沒錯！",
			correct: true
		},
		{
			text: "Unigram 通過保留最頻繁的子詞來調整它的詞彙量。",
			explain: "不，這個不正確。"
		},
		{
			text: "根據模型，Unigram 通過找到最可能的分割符號來將詞轉化為子詞。",
			explain: "沒錯！",
			correct: true
		},
		{
			text: "Unigram 通過將單詞分割成字符，然後應用合併規則將其分解成子單詞。",
			explain: "不，這是另一個標記化算法的工作原理。"
		},
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-TW/chapter6/10.mdx" />