# 構建你的第一個演示

<DocNotebookDropdown
  classNames="absolute z-10 right-0 top-0"
  options={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/chapter9/section2.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/chapter9/section2.ipynb"},
]} />

讓我們從安裝 Gradio 開始吧！ 由於它是一個 Python 包，只需運行：

`$ pip install gradio `

您可以在任何地方運行 Gradio，無論是從您最喜歡的 Python IDE、Jupyter notebook 還是 Google Colab 🤯！
所以無論你在哪裡運行 Python，都可以安裝 Gradio！

讓我們從一個簡單的“Hello World”示例開始，熟悉 Gradio 語法：

```py
import gradio as gr


def greet(name):
    return "Hello " + name


demo = gr.Interface(fn=greet, inputs="text", outputs="text")

demo.launch()
```

讓我們看一下上面的代碼：

-首先，我們定義一個名為 `greet()` 的函數。 在這種情況下，它是一個在您的名字前添加“Hello”的簡單函數，但它通常可以是 *any* Python 函數。 例如，在機器學習應用程序中，此函數將*調用模型以對輸入進行預測*並返回輸出。
- 然後，我們創建一個帶有三個參數的 Gradio `Interface`，`fn`、`inputs` 和 `outputs`。 這些參數定義了預測函數，以及我們想要的輸入和輸出組件的_type_。 在我們的例子中，兩個組件都是簡單的文本框。
- 然後我們在我們創建的 `Interface` 上調用 `launch()` 方法。

如果你運行這段代碼，下面的界面會自動出現在 Jupyter/Colab notebook 中，或者在瀏覽器中彈出 **[http://localhost:7860](http://localhost:7860/)** 如果運行 從一個腳本。

<iframe src="https://course-demos-hello-world.hf.space" frameBorder="0" height="250" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

立即嘗試使用您自己的姓名或其他輸入來使用此 GUI！

您會注意到，在這個 GUI 中，Gradio 自動推斷輸入參數的名稱 (`name`)並將其應用為文本框頂部的標籤。 如果你想改變它怎麼辦？或者，如果您想以其他方式自定義文本框？ 在這種情況下，您可以實例化一個表示輸入組件的類對象。

看看下面的例子：

```py
import gradio as gr


def greet(name):
    return "Hello " + name


# We instantiate the Textbox class
textbox = gr.Textbox(label="Type your name here:", placeholder="John Doe", lines=2)

gr.Interface(fn=greet, inputs=textbox, outputs="text").launch()
```

<iframe src="https://course-demos-hello-world-custom.hf.space" frameBorder="0" height="300" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

在這裡，我們創建了一個帶有標籤、佔位符和一組行數的輸入文本框。您可以對輸出文本框執行相同的操作，但我們現在將其保留。

我們已經看到，只需幾行代碼，Gradio 就可以讓您圍繞任何具有任何類型輸入或輸出的函數創建一個簡單的界面。 在本節中，我們從一個簡單的文本框開始，但在接下來的部分中，我們將介紹其他類型的輸入和輸出。 現在讓我們看看在 Gradio 應用程序中包含一些 NLP。


## 🤖 包括模型預測

現在讓我們構建一個簡單的界面，讓您可以演示像 GPT-2 這樣的**文本生成**模型。

我們將使用 🤗 Transformers 中的 `pipeline()` 函數加載我們的模型。
如果您需要快速複習，您可以返回到 [第 1 章中的那個部分](/course/chapter1/3#text-generation)。

首先，我們定義一個接受文本提示並返回文本完成的預測函數：

```py
from transformers import pipeline

model = pipeline("text-generation")


def predict(prompt):
    completion = model(prompt)[0]["generated_text"]
    return completion
```

此函數完成您提供的提示，您可以使用自己的輸入提示運行它以查看它是如何工作的。 這是一個示例（您可能會得到不同的完成）：

```
predict("My favorite programming language is")
```

```
>> My favorite programming language is Haskell. I really enjoyed the Haskell language, but it doesn't have all the features that can be applied to any other language. For example, all it does is compile to a byte array.
```

現在我們有了一個生成預測的函數，我們可以像之前一樣創建和啟動一個“接口”：

```py
import gradio as gr

gr.Interface(fn=predict, inputs="text", outputs="text").launch()
```


就是這樣！ 您現在可以使用此接口使用 GPT-2 模型生成文本，如下所示 🤯.

<iframe src="https://course-demos-gpt-2.hf.space" frameBorder="0" height="300" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

繼續閱讀以瞭解如何使用 Gradio 構建其他類型的演示！

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-TW/chapter9/2.mdx" />