# 章末測驗

<CourseFloatingBanner
    chapter={7}
    classNames="absolute z-10 right-0 top-0"
/>

讓我們測試一下您在本章中學到了什麼！

### 1.你能利用Grado做什麼？
<Question
	choices={[
        {
			text: "為您的機器學習模型創建一個演示",
			explain: "通過幾行 Python 代碼，您可以使用我們的預構建組件庫為 ML 模型生成一個演示。",
			correct: true
		},
		{
			text: "與他人分享你的機器學習模型",
			explain: "在啟動方法中使用 <code> share = True </code> 參數，可以生成一個共享鏈接發送給任何人。",
            correct: true
		},
		{
			text: "調試模型",
			explain: "Grado演示的一個優點是能夠用真實數據測試模型，您可以實時更改並觀察模型的預測變化，從而幫助您調試模型。",
			correct: true
		},
		{
			text: "訓練你的模型",
			explain: "在你的模型被訓練之後，Grado 被設計用來進行模型推理。",
		}
	]}
/>

### 2.Grado只在 PyTorch 模型上工作
<Question
	choices={[
        {
			text: "沒錯",
			explain: "Grdio 可以處理 PyTorch 模型，但除此之外也可以處理任何類型的機器學習模型！"
        },
        {
			text: "不正確",
			explain: "Grdio 是不依賴模型的，這意味著您可以為任何類型的機器學習模型創建演示。",
			correct: true
        }
	]}
/>

### 3.你可以在哪裡發佈一個 GRadio 演示？
<Question
	choices={[
        {
			text: "標準的 python IDEs",
			explain: "對於您最喜歡的 IDE，Grdio 工作得非常好。",
            correct: true
        },
        {
			text: "Google Colab 筆記本",
			explain: "你可以在你的 Google colab 筆記本上創建並啟動一個演示。",
			correct: true
        },
        {
			text: "Jupyter筆記本",
			explain: "很好的選擇 —— 您可以在您的Jupyter notebook創建並啟動一個演示。",
			correct: true
        }
	]}
/>

### 4.Gdio 主要是為 NLP 模型設計的
<Question
	choices={[
        {
			text: "沒錯",
			explain: "GRadio 可以處理幾乎所有的數據類型，而不僅僅是 NLP。"
        },
        {
			text: "假的",
			explain: "Grado 為開發人員提供了一個庫，其中包含幾乎所有數據類型的預構建組件。",
            correct: true
        }
	]}
/>

### 5.下列哪些特性是由 Grado 支持的？
<Question
	choices={[
        {
			text: "多輸入多輸出",
			explain: "多輸入多輸出是可能的。您所需要做的就是將輸入和輸出的列表傳遞給它們相應的參數",
            correct: true
        },
        {
			text: "數據持久性狀態",
			explain: "可以在界面中添加狀態。",
			correct: true
        },
        {
			text: "用戶名和密碼身份驗證",
			explain: "將用戶名/密碼元組的列表傳遞給啟動方法，以添加身份驗證。",
			correct: true
        },
        {
			text: "自動分析誰在使用您的Grado演示",
			explain: "再試一次 —— Grado 不提供給開發人員關於誰使用他們的演示的分析。"
        },
        {
			text: "從“HuggingFace”的模型中心或“HuggingFace” Space加載模型",
			explain: "絕對可以 —— 使用 <code> gr. Interface.load () </code> 方法加載任何 Hugging Face 模型",
			correct: true
        }
	]}
/>

### 6.下列哪一種是從 Hub 或 Spaces 加載 Huggging Face 模型的有效方法？
<Question
	choices={[
        {
			text: "gr.Interface.load('huggingface/{user}/{model_name}')",
			explain: "這是從 Hub 加載 Hugging Face 模型的有效方法",
            correct: true
        },
        {
			text: "gr.Interface.load('model/{user}/{model_name}')",
			explain: "這是從 Hub 加載 Hugging Face 模型的有效方法",
			correct: true
        },
        {
			text: "gr.Interface.load('demos/{user}/{model_name}')",
			explain: "再試一次——你不能使用'demos'前綴來加載模型。"
        },
        {
			text: "gr.Interface.load('spaces/{user}/{model_name}')",
			explain: "這是從 Space 加載 Hugging Face 模型的有效方法",
			correct: true
        }
	]}
/>

### 7.創建您的 Gradio 接口時，您必須添加以下步驟：
<Question
	choices={[
        {
			text: "向預測函數中傳入一個額外的參數，該參數表示接口的狀態。",
			explain: "需要一個額外的參數來存儲接口的歷史記錄或狀態。",
            correct: true
        },
        {
			text: "在預測函數的末尾，將狀態的更新值作為額外的返回值返回。",
			explain: "此歷史記錄或狀態值需要由函數返回。",
            correct: true
        },
        {
			text: "在創建接口時添加狀態輸入和狀態輸出組件",
			explain: "Grado 提供了一個狀態輸入和輸出組件來持久存儲數據。",
            correct: true
        }
	]}
/>

### 8.Gradio 庫包括以下哪些組件？
<Question
	choices={[
        {
			text: "文本框。",
			explain: "是的，可以使用 Textbox 組件創建文本框。",
            correct: true
        },
        {
			text: "圖表。",
			explain: "目前沒有圖形組件。",
        },
        {
			text: "圖像。",
			explain: "是的，您可以使用 Image 組件創建一個圖像上傳小部件。",
            correct: true
        },
        {
			text: "音頻。",
			explain: "是的，您可以使用 Audio 組件創建一個音頻上傳小部件。",
            correct: true
        },
	]}
/>

### 9.Gradio允許你做什麼？
<Question
	choices={[
        {
			text: "將多個演示合併到一個 Web 應用程序中",
			explain: "您可以使用`with gradio.Tabs ():`來為多個演示添加選項卡",
			correct: true
        },
        {
			text: "將單擊/更改/等事件觸發器分配給`Blocks`組件",
			explain: "在分配事件時，傳入三個參數: fn: 應該調用的函數、輸入: 組件的輸入(list)和輸出: 應該調用組件的輸出(list)。",
			correct: true
        },
        {
			text: "自動確定哪些`Blocks`組件應該是交互的還是靜態的",
			explain: "根據您定義的事件觸發器，`Blocks`自動計算出組件是否應該接受用戶輸入。",
			correct: true
        },
		 {
			text: "創建多步演示; 這意味著允許您重用一個組件的輸出作為下一個組件的輸入",
			explain: "您可以使用組件作為一個事件觸發器的輸入，但作為另一個事件觸發器的輸出。",
            correct: true
        },
	]}
/>

### 10.你可以共享一個`Blocks`演示的公共鏈接，並創建一個`Blocks`的演示在HuggingFace空間。
<Question
	choices={[
        {
			text: "沒錯",
			explain: "就像`Interface`一樣，所有的共享和託管功能對於`Blocks`演示都是一樣的！",
			correct: true
        },
        {
			text: "不正確",
			explain: "就像`Interface`一樣，所有的共享和託管功能對於`Blocks`演示都是一樣的！",
			correct: false
        }
	]}
/>

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-TW/chapter9/9.mdx" />