import{s as xe,o as Qe,n as Ne}from"../chunks/scheduler.c57aa7ef.js";import{S as He,i as Ye,g as i,s,r as m,A as Se,h as o,f as l,c as n,j as Xe,u as r,x as p,k as Ae,y as ze,a,v as c,d as M,t as f,w as h}from"../chunks/index.394f8801.js";import{T as Le}from"../chunks/Tip.23dfb1a9.js";import{C as S}from"../chunks/CodeBlock.b5488637.js";import{H as L,E as Pe}from"../chunks/getInferenceSnippets.54bf47f2.js";function De(P){let d,w="If the original PEFT adapters was using <code>target_parameters</code> instead of <code>target_modules</code>, injecting from a <code>state_dict</code> will not work correctly. In this case, it is mandatory to use the correct PEFT config for injection.";return{c(){d=i("p"),d.innerHTML=w},l(u){d=o(u,"P",{"data-svelte-h":!0}),p(d)!=="svelte-1xmahue"&&(d.innerHTML=w)},m(u,Y){a(u,d,Y)},p:Ne,d(u){u&&l(d)}}}function Ke(P){let d,w,u,Y,y,D,_,Ue="With PEFT, you can inject trainable adapters into any <code>torch</code> module which allows you to use adapter methods without relying on the modeling classes in PEFT. This works for all adapters except for those based on prompt learning (e.g. prefix tuning or p-tuning).",K,J,ge="Check the table below to see when you should inject adapters.",q,b,Ce="<thead><tr><th>Pros</th> <th>Cons</th></tr></thead> <tbody><tr><td>the model is modified inplace, keeping all the original attributes and methods</td> <td>manually write the <code>from_pretrained</code> and <code>save_pretrained</code> utility functions from Hugging Face to save and load adapters</td></tr> <tr><td>works for any <code>torch</code> module and modality</td> <td>doesn’t work with any of the utility methods provided by <code>PeftModel</code> such as disabling and merging adapters</td></tr></tbody>",O,j,ee,U,Ze='To perform the adapter injection, use the <a href="/docs/peft/v0.17.0/en/package_reference/peft_model#peft.inject_adapter_in_model">inject_adapter_in_model()</a> method. This method takes 3 arguments, the PEFT config, the model, and an optional adapter name. You can also attach multiple adapters to the model if you call <a href="/docs/peft/v0.17.0/en/package_reference/peft_model#peft.inject_adapter_in_model">inject_adapter_in_model()</a> multiple times with different adapter names.',te,g,Ie="For example, to inject LoRA adapters into the <code>linear</code> submodule of the <code>DummyModel</code> module:",le,C,ae,Z,$e="Print the model to see that the adapters have been correctly injected.",se,I,ne,$,ie,k,ke='Sometimes, it is possible that there is a PEFT adapter checkpoint but the corresponding PEFT config is not known for whatever reason. To inject the PEFT layers for this checkpoint, you would usually have to reverse-engineer the corresponding PEFT config, most notably the <code>target_modules</code> argument, based on the <code>state_dict</code> from the checkpoint. This can be cumbersome and error prone. To avoid this, it is also possible to call <a href="/docs/peft/v0.17.0/en/package_reference/peft_model#peft.inject_adapter_in_model">inject_adapter_in_model()</a> and pass the loaded <code>state_dict</code> as an argument:',oe,W,de,E,We="In this case, PEFT will use the <code>state_dict</code> as reference for which layers to target instead of using the PEFT config. As a user, you don’t have to set the exact <code>target_modules</code> of the PEFT config for this to work. However, you should still pass a PEFT config of the right type, in this example <code>LoraConfig</code>, you can leave the <code>target_modules</code> as <code>None</code>.",pe,B,Ee="Be aware that this still only creates the uninitialized PEFT layers, the values from the <code>state_dict</code> are not used to populate the model weights. To populate the weights, proceed with calling <code>set_peft_model_state_dict()</code> as described below.",me,G,Be="⚠️ Note that if there is a mismatch between what is configured in the PEFT config and what is found in the <code>state_dict</code>, PEFT will warn you about this. You can ignore the warning if you know that the PEFT config is not correctly specified.",re,T,ce,v,Me,V,Ge='To only save the adapter, use the <a href="/docs/peft/v0.17.0/en/package_reference/peft_model#peft.get_peft_model_state_dict">get_peft_model_state_dict()</a> function:',fe,F,he,R,ve="Otherwise, <code>model.state_dict()</code> returns the full state dict of the model.",ue,X,Te,A,Ve="After loading the saved <code>state_dict</code>, it can be applied using the <code>set_peft_model_state_dict()</code> function:",we,x,ye,Q,Fe='If injecting the adapter is slow or you need to load a large number of adapters, you may use an optimization that allows to create an “empty” adapter on meta device and only fills the weights with real weights when the <code>set_peft_model_state_dict()</code> is called. To do this, pass <code>low_cpu_mem_usage=True</code> to both <a href="/docs/peft/v0.17.0/en/package_reference/peft_model#peft.inject_adapter_in_model">inject_adapter_in_model()</a> and <code>set_peft_model_state_dict()</code>.',_e,N,Je,H,be,z,je;return y=new L({props:{title:"Adapter injection",local:"adapter-injection",headingTag:"h1"}}),j=new L({props:{title:"Creating a new PEFT model",local:"creating-a-new-peft-model",headingTag:"h2"}}),C=new S({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMGluamVjdF9hZGFwdGVyX2luX21vZGVsJTJDJTIwTG9yYUNvbmZpZyUwQSUwQWNsYXNzJTIwRHVtbXlNb2RlbCh0b3JjaC5ubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmVtYmVkZGluZyUyMCUzRCUyMHRvcmNoLm5uLkVtYmVkZGluZygxMCUyQyUyMDEwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubGluZWFyJTIwJTNEJTIwdG9yY2gubm4uTGluZWFyKDEwJTJDJTIwMTApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5sbV9oZWFkJTIwJTNEJTIwdG9yY2gubm4uTGluZWFyKDEwJTJDJTIwMTApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwaW5wdXRfaWRzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMjAlM0QlMjBzZWxmLmVtYmVkZGluZyhpbnB1dF9pZHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNlbGYubGluZWFyKHgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNlbGYubG1faGVhZCh4KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHglMEElMEElMEFsb3JhX2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9yYV9hbHBoYSUzRDE2JTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwciUzRDY0JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMmxpbmVhciUyMiU1RCUyQyUwQSklMEElMEFtb2RlbCUyMCUzRCUyMER1bW15TW9kZWwoKSUwQW1vZGVsJTIwJTNEJTIwaW5qZWN0X2FkYXB0ZXJfaW5fbW9kZWwobG9yYV9jb25maWclMkMlMjBtb2RlbCklMEElMEFkdW1teV9pbnB1dHMlMjAlM0QlMjB0b3JjaC5Mb25nVGVuc29yKCU1QiU1QjAlMkMlMjAxJTJDJTIwMiUyQyUyMDMlMkMlMjA0JTJDJTIwNSUyQyUyMDYlMkMlMjA3JTVEJTVEKSUwQWR1bW15X291dHB1dHMlMjAlM0QlMjBtb2RlbChkdW1teV9pbnB1dHMp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> inject_adapter_in_model, LoraConfig

<span class="hljs-keyword">class</span> <span class="hljs-title class_">DummyModel</span>(torch.nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.embedding = torch.nn.Embedding(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.linear = torch.nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.lm_head = torch.nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, input_ids</span>):
        x = self.embedding(input_ids)
        x = self.linear(x)
        x = self.lm_head(x)
        <span class="hljs-keyword">return</span> x


lora_config = LoraConfig(
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.1</span>,
    r=<span class="hljs-number">64</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    target_modules=[<span class="hljs-string">&quot;linear&quot;</span>],
)

model = DummyModel()
model = inject_adapter_in_model(lora_config, model)

dummy_inputs = torch.LongTensor([[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>]])
dummy_outputs = model(dummy_inputs)`,wrap:!1}}),I=new S({props:{code:"RHVtbXlNb2RlbCglMEElMjAlMjAoZW1iZWRkaW5nKSUzQSUyMEVtYmVkZGluZygxMCUyQyUyMDEwKSUwQSUyMCUyMChsaW5lYXIpJTNBJTIwTGluZWFyKCUwQSUyMCUyMCUyMCUyMGluX2ZlYXR1cmVzJTNEMTAlMkMlMjBvdXRfZmVhdHVyZXMlM0QxMCUyQyUyMGJpYXMlM0RUcnVlJTBBJTIwJTIwJTIwJTIwKGxvcmFfZHJvcG91dCklM0ElMjBNb2R1bGVEaWN0KCUwQSUyMCUyMCUyMCUyMCUyMCUyMChkZWZhdWx0KSUzQSUyMERyb3BvdXQocCUzRDAuMSUyQyUyMGlucGxhY2UlM0RGYWxzZSklMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwKGxvcmFfQSklM0ElMjBNb2R1bGVEaWN0KCUwQSUyMCUyMCUyMCUyMCUyMCUyMChkZWZhdWx0KSUzQSUyMExpbmVhcihpbl9mZWF0dXJlcyUzRDEwJTJDJTIwb3V0X2ZlYXR1cmVzJTNENjQlMkMlMjBiaWFzJTNERmFsc2UpJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMChsb3JhX0IpJTNBJTIwTW9kdWxlRGljdCglMEElMjAlMjAlMjAlMjAlMjAlMjAoZGVmYXVsdCklM0ElMjBMaW5lYXIoaW5fZmVhdHVyZXMlM0Q2NCUyQyUyMG91dF9mZWF0dXJlcyUzRDEwJTJDJTIwYmlhcyUzREZhbHNlKSUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAobG9yYV9lbWJlZGRpbmdfQSklM0ElMjBQYXJhbWV0ZXJEaWN0KCklMEElMjAlMjAlMjAlMjAobG9yYV9lbWJlZGRpbmdfQiklM0ElMjBQYXJhbWV0ZXJEaWN0KCklMEElMjAlMjApJTBBJTIwJTIwKGxtX2hlYWQpJTNBJTIwTGluZWFyKGluX2ZlYXR1cmVzJTNEMTAlMkMlMjBvdXRfZmVhdHVyZXMlM0QxMCUyQyUyMGJpYXMlM0RUcnVlKSUwQSk=",highlighted:`DummyModel(
  (embedding): Embedding(10, 10)
  (linear): Linear(
    in_features=10, out_features=10, bias=True
    (lora_dropout): ModuleDict(
      (default): Dropout(p=0.1, inplace=False)
    )
    (lora_A): ModuleDict(
      (default): Linear(in_features=10, out_features=64, bias=False)
    )
    (lora_B): ModuleDict(
      (default): Linear(in_features=64, out_features=10, bias=False)
    )
    (lora_embedding_A): ParameterDict()
    (lora_embedding_B): ParameterDict()
  )
  (lm_head): Linear(in_features=10, out_features=10, bias=True)
)`,wrap:!1}}),$=new L({props:{title:"Injection based on a state_dict",local:"injection-based-on-a-statedict",headingTag:"h3"}}),W=new S({props:{code:"ZnJvbSUyMHNhZmV0ZW5zb3JzLnRvcmNoJTIwaW1wb3J0JTIwbG9hZF9maWxlJTBBJTBBbW9kZWwlMjAlM0QlMjAuLi4lMEFzdGF0ZV9kaWN0JTIwJTNEJTIwbG9hZF9maWxlKCUzQ3BhdGgtdG8tc2FmZXRlbnNvcnMtZmlsZSUzRSklMEFsb3JhX2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoLi4uKSUwQW1vZGVsJTIwJTNEJTIwaW5qZWN0X2FkYXB0ZXJfaW5fbW9kZWwobG9yYV9jb25maWclMkMlMjBtb2RlbCUyQyUyMHN0YXRlX2RpY3QlM0RzdGF0ZV9kaWN0KQ==",highlighted:`<span class="hljs-keyword">from</span> safetensors.torch <span class="hljs-keyword">import</span> load_file

model = ...
state_dict = load_file(&lt;path-to-safetensors-file&gt;)
lora_config = LoraConfig(...)
model = inject_adapter_in_model(lora_config, model, state_dict=state_dict)`,wrap:!1}}),T=new Le({props:{warning:!0,$$slots:{default:[De]},$$scope:{ctx:P}}}),v=new L({props:{title:"Saving the model",local:"saving-the-model",headingTag:"h2"}}),F=new S({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbF9zdGF0ZV9kaWN0JTBBJTBBcGVmdF9zdGF0ZV9kaWN0JTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWxfc3RhdGVfZGljdChtb2RlbCklMEFwcmludChwZWZ0X3N0YXRlX2RpY3Qp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model_state_dict

peft_state_dict = get_peft_model_state_dict(model)
<span class="hljs-built_in">print</span>(peft_state_dict)`,wrap:!1}}),X=new L({props:{title:"Loading the model",local:"loading-the-model",headingTag:"h2"}}),x=new S({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBzZXRfcGVmdF9tb2RlbF9zdGF0ZV9kaWN0JTBBJTBBbW9kZWwlMjAlM0QlMjBEdW1teU1vZGVsKCklMEFtb2RlbCUyMCUzRCUyMGluamVjdF9hZGFwdGVyX2luX21vZGVsKGxvcmFfY29uZmlnJTJDJTIwbW9kZWwpJTBBb3V0Y29tZSUyMCUzRCUyMHNldF9wZWZ0X21vZGVsX3N0YXRlX2RpY3QobW9kZWwlMkMlMjBwZWZ0X3N0YXRlX2RpY3QpJTBBJTIzJTIwY2hlY2slMjB0aGF0JTIwdGhlcmUlMjB3ZXJlJTIwbm8lMjB3cm9uZyUyMGtleXMlMEFwcmludChvdXRjb21lLnVuZXhwZWN0ZWRfa2V5cyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> set_peft_model_state_dict

model = DummyModel()
model = inject_adapter_in_model(lora_config, model)
outcome = set_peft_model_state_dict(model, peft_state_dict)
<span class="hljs-comment"># check that there were no wrong keys</span>
<span class="hljs-built_in">print</span>(outcome.unexpected_keys)`,wrap:!1}}),N=new S({props:{code:"bW9kZWwlMjAlM0QlMjBEdW1teU1vZGVsKCklMEFtb2RlbCUyMCUzRCUyMGluamVjdF9hZGFwdGVyX2luX21vZGVsKGxvcmFfY29uZmlnJTJDJTIwbW9kZWwlMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUpJTBBJTBBcHJpbnQobW9kZWwubGluZWFyLmxvcmFfQSU1QiUyMmRlZmF1bHQlMjIlNUQud2VpZ2h0LmRldmljZS50eXBlJTIwJTNEJTNEJTIwJTIybWV0YSUyMiklMjAlMjAlMjMlMjBzaG91bGQlMjBiZSUyMFRydWUlMEFzZXRfcGVmdF9tb2RlbF9zdGF0ZV9kaWN0KG1vZGVsJTJDJTIwcGVmdF9zdGF0ZV9kaWN0JTJDJTIwbG93X2NwdV9tZW1fdXNhZ2UlM0RUcnVlKSUwQXByaW50KG1vZGVsLmxpbmVhci5sb3JhX0ElNUIlMjJkZWZhdWx0JTIyJTVELndlaWdodC5kZXZpY2UudHlwZSUyMCUzRCUzRCUyMCUyMmNwdSUyMiklMjAlMjAlMjMlMjBzaG91bGQlMjBiZSUyMFRydWU=",highlighted:`model = DummyModel()
model = inject_adapter_in_model(lora_config, model, low_cpu_mem_usage=<span class="hljs-literal">True</span>)

<span class="hljs-built_in">print</span>(model.linear.lora_A[<span class="hljs-string">&quot;default&quot;</span>].weight.device.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;meta&quot;</span>)  <span class="hljs-comment"># should be True</span>
set_peft_model_state_dict(model, peft_state_dict, low_cpu_mem_usage=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(model.linear.lora_A[<span class="hljs-string">&quot;default&quot;</span>].weight.device.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;cpu&quot;</span>)  <span class="hljs-comment"># should be True</span>`,wrap:!1}}),H=new Pe({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/low_level_api.md"}}),{c(){d=i("meta"),w=s(),u=i("p"),Y=s(),m(y.$$.fragment),D=s(),_=i("p"),_.innerHTML=Ue,K=s(),J=i("p"),J.textContent=ge,q=s(),b=i("table"),b.innerHTML=Ce,O=s(),m(j.$$.fragment),ee=s(),U=i("p"),U.innerHTML=Ze,te=s(),g=i("p"),g.innerHTML=Ie,le=s(),m(C.$$.fragment),ae=s(),Z=i("p"),Z.textContent=$e,se=s(),m(I.$$.fragment),ne=s(),m($.$$.fragment),ie=s(),k=i("p"),k.innerHTML=ke,oe=s(),m(W.$$.fragment),de=s(),E=i("p"),E.innerHTML=We,pe=s(),B=i("p"),B.innerHTML=Ee,me=s(),G=i("p"),G.innerHTML=Be,re=s(),m(T.$$.fragment),ce=s(),m(v.$$.fragment),Me=s(),V=i("p"),V.innerHTML=Ge,fe=s(),m(F.$$.fragment),he=s(),R=i("p"),R.innerHTML=ve,ue=s(),m(X.$$.fragment),Te=s(),A=i("p"),A.innerHTML=Ve,we=s(),m(x.$$.fragment),ye=s(),Q=i("p"),Q.innerHTML=Fe,_e=s(),m(N.$$.fragment),Je=s(),m(H.$$.fragment),be=s(),z=i("p"),this.h()},l(e){const t=Se("svelte-u9bgzb",document.head);d=o(t,"META",{name:!0,content:!0}),t.forEach(l),w=n(e),u=o(e,"P",{}),Xe(u).forEach(l),Y=n(e),r(y.$$.fragment,e),D=n(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-9e5cx8"&&(_.innerHTML=Ue),K=n(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-mj4045"&&(J.textContent=ge),q=n(e),b=o(e,"TABLE",{"data-svelte-h":!0}),p(b)!=="svelte-j2tc6m"&&(b.innerHTML=Ce),O=n(e),r(j.$$.fragment,e),ee=n(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1v44uli"&&(U.innerHTML=Ze),te=n(e),g=o(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-tifeyo"&&(g.innerHTML=Ie),le=n(e),r(C.$$.fragment,e),ae=n(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-3xa704"&&(Z.textContent=$e),se=n(e),r(I.$$.fragment,e),ne=n(e),r($.$$.fragment,e),ie=n(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1791uw7"&&(k.innerHTML=ke),oe=n(e),r(W.$$.fragment,e),de=n(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-aqktpe"&&(E.innerHTML=We),pe=n(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1xvzmm9"&&(B.innerHTML=Ee),me=n(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-sc7gea"&&(G.innerHTML=Be),re=n(e),r(T.$$.fragment,e),ce=n(e),r(v.$$.fragment,e),Me=n(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-9x8256"&&(V.innerHTML=Ge),fe=n(e),r(F.$$.fragment,e),he=n(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1hk759o"&&(R.innerHTML=ve),ue=n(e),r(X.$$.fragment,e),Te=n(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-197rq1s"&&(A.innerHTML=Ve),we=n(e),r(x.$$.fragment,e),ye=n(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-nvt89o"&&(Q.innerHTML=Fe),_e=n(e),r(N.$$.fragment,e),Je=n(e),r(H.$$.fragment,e),be=n(e),z=o(e,"P",{}),Xe(z).forEach(l),this.h()},h(){Ae(d,"name","hf:doc:metadata"),Ae(d,"content",qe)},m(e,t){ze(document.head,d),a(e,w,t),a(e,u,t),a(e,Y,t),c(y,e,t),a(e,D,t),a(e,_,t),a(e,K,t),a(e,J,t),a(e,q,t),a(e,b,t),a(e,O,t),c(j,e,t),a(e,ee,t),a(e,U,t),a(e,te,t),a(e,g,t),a(e,le,t),c(C,e,t),a(e,ae,t),a(e,Z,t),a(e,se,t),c(I,e,t),a(e,ne,t),c($,e,t),a(e,ie,t),a(e,k,t),a(e,oe,t),c(W,e,t),a(e,de,t),a(e,E,t),a(e,pe,t),a(e,B,t),a(e,me,t),a(e,G,t),a(e,re,t),c(T,e,t),a(e,ce,t),c(v,e,t),a(e,Me,t),a(e,V,t),a(e,fe,t),c(F,e,t),a(e,he,t),a(e,R,t),a(e,ue,t),c(X,e,t),a(e,Te,t),a(e,A,t),a(e,we,t),c(x,e,t),a(e,ye,t),a(e,Q,t),a(e,_e,t),c(N,e,t),a(e,Je,t),c(H,e,t),a(e,be,t),a(e,z,t),je=!0},p(e,[t]){const Re={};t&2&&(Re.$$scope={dirty:t,ctx:e}),T.$set(Re)},i(e){je||(M(y.$$.fragment,e),M(j.$$.fragment,e),M(C.$$.fragment,e),M(I.$$.fragment,e),M($.$$.fragment,e),M(W.$$.fragment,e),M(T.$$.fragment,e),M(v.$$.fragment,e),M(F.$$.fragment,e),M(X.$$.fragment,e),M(x.$$.fragment,e),M(N.$$.fragment,e),M(H.$$.fragment,e),je=!0)},o(e){f(y.$$.fragment,e),f(j.$$.fragment,e),f(C.$$.fragment,e),f(I.$$.fragment,e),f($.$$.fragment,e),f(W.$$.fragment,e),f(T.$$.fragment,e),f(v.$$.fragment,e),f(F.$$.fragment,e),f(X.$$.fragment,e),f(x.$$.fragment,e),f(N.$$.fragment,e),f(H.$$.fragment,e),je=!1},d(e){e&&(l(w),l(u),l(Y),l(D),l(_),l(K),l(J),l(q),l(b),l(O),l(ee),l(U),l(te),l(g),l(le),l(ae),l(Z),l(se),l(ne),l(ie),l(k),l(oe),l(de),l(E),l(pe),l(B),l(me),l(G),l(re),l(ce),l(Me),l(V),l(fe),l(he),l(R),l(ue),l(Te),l(A),l(we),l(ye),l(Q),l(_e),l(Je),l(be),l(z)),l(d),h(y,e),h(j,e),h(C,e),h(I,e),h($,e),h(W,e),h(T,e),h(v,e),h(F,e),h(X,e),h(x,e),h(N,e),h(H,e)}}}const qe='{"title":"Adapter injection","local":"adapter-injection","sections":[{"title":"Creating a new PEFT model","local":"creating-a-new-peft-model","sections":[{"title":"Injection based on a state_dict","local":"injection-based-on-a-statedict","sections":[],"depth":3}],"depth":2},{"title":"Saving the model","local":"saving-the-model","sections":[],"depth":2},{"title":"Loading the model","local":"loading-the-model","sections":[],"depth":2}],"depth":1}';function Oe(P){return Qe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nt extends He{constructor(d){super(),Ye(this,d,Oe,Ke,xe,{})}}export{nt as component};
