import{s as Zs,o as Cs,n as ya}from"../chunks/scheduler.c57aa7ef.js";import{S as Us,i as Ls,g as i,s,r as p,A as Ws,h as o,f as l,c as n,j as ks,u as d,x as r,k as Js,y as Bs,a,v as m,d as f,t as h,w as u}from"../chunks/index.394f8801.js";import{T as ga}from"../chunks/Tip.23dfb1a9.js";import{C as w}from"../chunks/CodeBlock.b5488637.js";import{H as y,E as Fs}from"../chunks/getInferenceSnippets.54bf47f2.js";function Gs(T){let c,b='Starting from PEFT version v0.12.0, PEFT automatically promotes the dtype of adapter weights from <code>torch.float16</code> and <code>torch.bfloat16</code> to <code>torch.float32</code> where appropriate. To <em>prevent</em> this behavior, you can pass <code>autocast_adapter_dtype=False</code> to <a href="/docs/peft/v0.17.0/en/package_reference/peft_model#peft.get_peft_model">~get_peft_model()</a>, to <a href="/docs/peft/v0.17.0/en/package_reference/peft_model#peft.PeftModel.from_pretrained">from_pretrained()</a>, and to <a href="/docs/peft/v0.17.0/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>.';return{c(){c=i("p"),c.innerHTML=b},l(g){c=o(g,"P",{"data-svelte-h":!0}),r(c)!=="svelte-f20nt3"&&(c.innerHTML=b)},m(g,M){a(g,c,M)},p:ya,d(g){g&&l(c)}}}function Is(T){let c,b="As an example, when loading a model that is using the DeBERTa architecture for sequence classification, you’ll see a warning that the following weights are newly initialized: <code>[&#39;classifier.bias&#39;, &#39;classifier.weight&#39;, &#39;pooler.dense.bias&#39;, &#39;pooler.dense.weight&#39;]</code>. From this, it follows that the <code>classifier</code> and <code>pooler</code> layers should be added to: <code>modules_to_save=[&quot;classifier&quot;, &quot;pooler&quot;]</code>.";return{c(){c=i("p"),c.innerHTML=b},l(g){c=o(g,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1r4u1vb"&&(c.innerHTML=b)},m(g,M){a(g,c,M)},p:ya,d(g){g&&l(c)}}}function Rs(T){let c,b="If this option works well across different use cases, it may become the default for adapter loading in the future.";return{c(){c=i("p"),c.textContent=b},l(g){c=o(g,"P",{"data-svelte-h":!0}),r(c)!=="svelte-18nkf7o"&&(c.textContent=b)},m(g,M){a(g,c,M)},p:ya,d(g){g&&l(c)}}}function Hs(T){let c,b,g,M,x,bt,j,wa="If you encounter any issue when using PEFT, please check the following list of common issues and their solutions.",Mt,k,Tt,J,ba="Examples often rely on the most recent package versions, so please ensure they’re up-to-date. In particular, check the following package versions:",_t,Z,Ma="<li><code>peft</code></li> <li><code>transformers</code></li> <li><code>accelerate</code></li> <li><code>torch</code></li>",$t,C,Ta="In general, you can update the package version by running this command inside your Python environment:",vt,U,xt,L,_a="Installing PEFT from source is useful for keeping up with the latest developments:",jt,W,kt,B,Jt,F,Zt,G,$a="This error probably occurred because the model was loaded with <code>torch_dtype=torch.float16</code> and then used in an automatic mixed precision (AMP) context, e.g. by setting <code>fp16=True</code> in the <code>Trainer</code> class from 🤗 Transformers. The reason is that when using AMP, trainable weights should never use fp16. To make this work without loading the whole model in fp32, add the following to your code:",Ct,I,Ut,R,va='Alternatively, you can use the <a href="/docs/peft/v0.17.0/en/package_reference/peft_model#peft.cast_mixed_precision_params">cast_mixed_precision_params()</a> function to correctly cast the weights:',Lt,H,Wt,_,Bt,X,Ft,V,xa="Most PEFT methods, like LoRA, work by adding trainable adapter weights. By default, those weights are stored in float32 dtype (fp32), i.e. at a relatively high precision. Therefore, even if the base model is loaded in float16 (fp16) or bfloat16 (bf16), the adapter weights are float32. When the adapter results are calculated during the forward pass, the input will typically be in the dtype of the base model, thus it will be upcast to float32 if necessary, then cast back to the original dtype.",Gt,E,ja='If you prefer to have the adapter weights in the lower precision of the base model, i.e. in float16 or bfloat16, you can pass <code>autocast_adapter_dtype=False</code> when creating the model (<a href="/docs/peft/v0.17.0/en/package_reference/peft_model#peft.get_peft_model">~get_peft_model()</a>) or loading the model (<a href="/docs/peft/v0.17.0/en/package_reference/peft_model#peft.PeftModel.from_pretrained">from_pretrained()</a>). There are some advantages and disadvantages to this:',It,P,ka="Advantages of half precision adapter:",Rt,z,Ja="<li>computation slightly faster</li> <li>slightly less memory</li> <li>smaller file size of checkpoint (half the size)</li>",Ht,Y,Za="Disadvantages of half precision adapter:",Xt,N,Ca="<li>slightly worse loss</li> <li>higher risk of overflow or underflow</li>",Vt,q,Ua="Note that for most use cases, overall runtime and memory cost will be determined by the size of the base model and by the dataset, while the dtype of the PEFT adapter will only have a small impact.",Et,Q,Pt,S,La='There can be several reasons for getting a poor result from a loaded PEFT model which are listed below. If you’re still unable to troubleshoot the problem, see if anyone else had a similar <a href="https://github.com/huggingface/peft/issues" rel="nofollow">issue</a> on GitHub, and if you can’t find any, open a new issue.',zt,A,Wa="When opening an issue, it helps a lot if you provide a minimal code example that reproduces the issue. Also, please report if the loaded model performs at the same level as the model did before fine-tuning, if it performs at a random level, or if it is only slightly worse than expected. This information helps us identify the problem more quickly.",Yt,D,Nt,K,Ba="If your model outputs are not exactly the same as previous runs, there could be an issue with random elements. For example:",qt,O,Fa="<li>please ensure it is in <code>.eval()</code> mode, which is important, for instance, if the model uses dropout</li> <li>if you use <code>generate</code> on a language model, there could be random sampling, so obtaining the same result requires setting a random seed</li> <li>if you used quantization and merged the weights, small deviations are expected due to rounding errors</li>",Qt,ee,St,te,Ga='Please ensure that you load the model correctly. A common error is trying to load a <em>trained</em> model with <a href="/docs/peft/v0.17.0/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> which is incorrect. Instead, the loading code should look like this:',At,le,Dt,ae,Kt,se,Ia="For some tasks, it is important to correctly configure <code>modules_to_save</code> in the config to account for randomly initialized layers.",Ot,ne,Ra="As an example, this is necessary if you use LoRA to fine-tune a language model for sequence classification because 🤗 Transformers adds a randomly initialized classification head on top of the model. If you do not add this layer to <code>modules_to_save</code>, the classification head won’t be saved. The next time you load the model, you’ll get a <em>different</em> randomly initialized classification head, resulting in completely different results.",el,ie,Ha="PEFT tries to correctly guess the <code>modules_to_save</code> if you provide the <code>task_type</code> argument in the config. This should work for transformers models that follow the standard naming scheme. It is always a good idea to double check though because we can’t guarantee all models follow the naming scheme.",tl,oe,Xa="When you load a transformers model that has randomly initialized layers, you should see a warning along the lines of:",ll,re,al,pe,Va="The mentioned layers should be added to <code>modules_to_save</code> in the config to avoid the described problem.",sl,$,nl,de,il,me,Ea="For many language fine-tuning tasks, extending the model’s vocabulary is necessary since new tokens are being introduced. This requires extending the embedding layer to account for the new tokens and, depending on the fine-tuning method, also storing the embedding layer in addition to the adapter weights when saving the adapter. There are a few ways of achieving this ordered by parameter effectiveness:",ol,fe,Pa='<li><a href="../package_reference/trainable_tokens">trainable tokens</a>, train only the specified tokens, optionally store only the updated values</li> <li>training an adapter on the embedding matrix, optionally store only the updated values</li> <li>full-finetuning of the embedding layer</li>',rl,he,pl,ue,za='Let’s start with trainable tokens, in this case its <a href="../developer_guides/lora#efficiently-train-tokens-alongside-lora">LoRA integration</a>.  If you’re interested in only training the new embeddings and nothing else, refer to the <a href="../package_reference/trainable_tokens">standalone documentation</a>.',dl,ce,Ya="To enable selective token training of the embedding layer, you’ll need to supply the token ids of your newly added tokens via the <code>trainable_token_indices</code> parameter.  Optionally you can specify which layer to target if there is more than one embedding layer. For a Mistral model this could look like this:",ml,ge,fl,ye,Na="If your model uses tied weights (such as the <code>lm_head</code>), trainable tokens will try to resolve those and keep them updated as well, so in that case there should be no need for adding <code>modules_to_save=[&quot;lm_head&quot;]</code>. This only works if the model uses the Transformers convention for tying weights.",hl,we,qa=`Saving the model with <code>model.save_pretrained</code> may save the full embedding matrix instead of
only the difference as a precaution because the embedding matrix was resized. To save space you can disable this behavior by setting <code>save_embedding_layers=False</code> when calling <code>save_pretrained</code>. This is safe to do as long as you don’t modify the embedding matrix through other means as well, as such changes will be not tracked by trainable tokens.`,ul,be,cl,Me,Qa="Prepare the embedding layer by adding it to the <code>target_modules</code> of your adapter config. For example, the Mistral config could look like this:",gl,Te,yl,_e,Sa="Once added to <code>target_modules</code>, PEFT automatically stores the embedding layer when saving the adapter if the model has the <code>get_input_embeddings</code> and <code>get_output_embeddings</code>. This is generally the case for Transformers models.",wl,$e,Aa="If the model’s embedding layer doesn’t follow the Transformer’s naming scheme but nevertheless implements <code>get_input_embeddings</code>, you can still save it by manually passing <code>save_embedding_layers=True</code> when saving the adapter:",bl,ve,Ml,xe,Da="For inference, load the base model first and resize it the same way you did before you trained the model. After you’ve resized the base model, you can load the PEFT checkpoint.",Tl,je,Ka='For a complete example, please check out <a href="https://github.com/huggingface/peft/blob/main/examples/causal_language_modeling/peft_lora_clm_with_additional_tokens.ipynb" rel="nofollow">this notebook</a>.',_l,ke,$l,Je,Oa="Full fine-tuning is more costly in terms of VRAM or storage space but if all else fails, you can fall back to this and see if it works for you. Achieve it by adding the name of the embedding layer to <code>modules_to_save</code>. Note that you need to add tied layers as well, e.g. <code>lm_head</code>. Example for a Mistral model with LoRA:",vl,Ze,xl,Ce,jl,Ue,es="When you load your PEFT model which has been trained on a task (for example, classification), you may get a warning like:",kl,Le,ts="<p>Some weights of LlamaForSequenceClassification were not initialized from the model checkpoint at meta-llama/Llama-3.2-1B and are newly initialized: [‘score.weight’]. You should probably TRAIN this model on a down-stream task to be able to use it for predictions and inference.</p>",Jl,We,ls="Although this looks scary, it is most likely nothing to worry about. This warning comes from Transformers, and it isn’t a PEFT specific warning. It lets you know that a randomly initialized classification head (<code>score</code>) is attached to the base model, and the head must be trained to produce sensible predictions.",Zl,Be,as="When you get this warning <em>before</em> training the model, PEFT automatically takes care of making the classification head trainable if you correctly passed the <code>task_type</code> argument to the PEFT config.",Cl,Fe,Ul,Ge,ss="If your classification head does not follow the usual naming conventions from Transformers (which is rare), you have to explicitly tell PEFT the name of the head in <code>modules_to_save</code>.",Ll,Ie,Wl,Re,ns="To check the name of the classification head, print the model and it should be the last module.",Bl,He,is="If you get this warning from your inference code, i.e. <em>after</em> training the model, when you load the PEFT model, you always have to load the Transformers model first. Since Transformers does not know that you will load PEFT weights afterwards, it still gives the warning.",Fl,Xe,os="As always, it is best practice to ensure the model works correctly for inference by running some validation on it.",Gl,Ve,Il,Ee,rs='Sometimes a PEFT model can end up in a bad state, especially when handling multiple adapters. There can be some confusion around what adapters exist, which one is active, which one is merged, etc. To help investigate this issue, call the <a href="/docs/peft/v0.17.0/en/package_reference/peft_model#peft.PeftModel.get_layer_status">get_layer_status()</a> and the <a href="/docs/peft/v0.17.0/en/package_reference/peft_model#peft.PeftModel.get_model_status">get_model_status()</a> methods.',Rl,Pe,ps='The <a href="/docs/peft/v0.17.0/en/package_reference/peft_model#peft.PeftModel.get_layer_status">get_layer_status()</a> method gives you a detailed overview of each targeted layer’s active, merged, and available adapters.',Hl,ze,Xl,Ye,ds="In the model state output, you should look out for entries that say <code>&quot;irregular&quot;</code>. This means PEFT detected an inconsistent state in the model. For instance, if <code>merged_adapters=&quot;irregular&quot;</code>, it means that for at least one adapter, it was merged on some target modules but not on others. The inference results will most likely be incorrect as a result.",Vl,Ne,ms="The best way to resolve this issue is to reload the whole model and adapter checkpoint(s). Ensure that you don’t perform any incorrect operations on the model, e.g. manually merging adapters on some modules but not others.",El,qe,fs="Convert the layer status into a pandas <code>DataFrame</code> for an easier visual inspection.",Pl,Qe,zl,Se,hs='It is possible to get this information for non-PEFT models if they are using PEFT layers under the hood, but some information like the <code>base_model_type</code> or the <code>peft_types</code> cannot be determined in that case. As an example, you can call this on a <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">diffusers</a> model like so:',Yl,Ae,Nl,De,ql,Ke,Ql,Oe,us='Loading adapters like LoRA weights should generally be fast compared to loading the base model. However, there can be use cases where the adapter weights are quite large or where users need to load a large number of adapters — the loading time can add up in this case. The reason for this is that the adapter weights are first initialized and then overridden by the loaded weights, which is wasteful. To speed up the loading time, you can pass the <code>low_cpu_mem_usage=True</code> argument to <a href="/docs/peft/v0.17.0/en/package_reference/peft_model#peft.PeftModel.from_pretrained">from_pretrained()</a> and <a href="/docs/peft/v0.17.0/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>.',Sl,v,Al,et,Dl,tt,Kl,lt,cs="When loading a trained PEFT model where the base model uses batch norm (e.g. <code>torch.nn.BatchNorm1d</code> or <code>torch.nn.BatchNorm2d</code>), you may find that you cannot reproduce the exact same outputs. This is because the batch norm layers keep track of running stats during training, but these stats are not part of the PEFT checkpoint. Therefore, when you load the PEFT model, the running stats of the base model will be used (i.e. from before training with PEFT).",Ol,at,gs="Depending on your use case, this may not be a big deal. If, however, you need your outputs to be 100% reproducible, you can achieve this by adding the batch norm layers to <code>modules_to_save</code>. Below is an example of this using resnet and LoRA. Notice that we set <code>modules_to_save=[&quot;classifier&quot;, &quot;normalization&quot;]</code>. We need the <code>&quot;classifier&quot;</code> argument because our task is image classification, and we add the <code>&quot;normalization&quot;</code> argument to ensure that the batch norm layers are saved in the PEFT checkpoint.",ea,st,ta,nt,ys="Depending on the type of model you use, the batch norm layers could have different names than <code>&quot;normalization&quot;</code>, so please ensure that the name matches your model architecture.",la,it,aa,ot,sa,rt,ws="When you encounter an error like the one shown below, it means the adapter you’re trying to load was trained with a more recent version of PEFT than the version you have installed on your system.",na,pt,ia,dt,bs="The best way to resolve this issue is to install the latest PEFT version:",oa,mt,ra,ft,Ms="If the adapter was trained from a source install of PEFT (an unreleased version of PEFT), then you also need to install PEFT from source.",pa,ht,da,ut,Ts="If it is not possible for you to upgrade PEFT, there is a workaround you can try.",ma,ct,_s="Assume the error message says that the unknown keyword argument is named <code>foobar</code>. Search inside the <code>adapter_config.json</code> of this PEFT adapter for the <code>foobar</code> entry and delete it from the file. Then save the file and try loading the model again.",fa,gt,$s="This solution works most of the time. As long as it is the default value for <code>foobar</code>, it can be ignored. However, when it is set to some other value, you will get incorrect results. Upgrading PEFT is the recommended solution.",ha,yt,ua,wt,ca;return x=new y({props:{title:"Troubleshooting",local:"troubleshooting",headingTag:"h1"}}),k=new y({props:{title:"Examples don’t work",local:"examples-dont-work",headingTag:"h2"}}),U=new w({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwLVUlMjAlM0NwYWNrYWdlX25hbWUlM0U=",highlighted:"python -m pip install -U &lt;package_name&gt;",wrap:!1}}),W=new w({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwZ2l0JTJCaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZwZWZ0",highlighted:"python -m pip install git+https://github.com/huggingface/peft",wrap:!1}}),B=new y({props:{title:"Dtype-related issues",local:"dtype-related-issues",headingTag:"h2"}}),F=new y({props:{title:"ValueError: Attempting to unscale FP16 gradients",local:"valueerror-attempting-to-unscale-fp16-gradients",headingTag:"h3"}}),I=new w({props:{code:"cGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKC4uLiklMEElMEElMjMlMjBhZGQlMjB0aGlzJTNBJTBBZm9yJTIwcGFyYW0lMjBpbiUyMG1vZGVsLnBhcmFtZXRlcnMoKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwcGFyYW0ucmVxdWlyZXNfZ3JhZCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhcmFtLmRhdGElMjAlM0QlMjBwYXJhbS5kYXRhLmZsb2F0KCklMEElMEElMjMlMjBwcm9jZWVkJTIwYXMlMjB1c3VhbCUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKG1vZGVsJTNEcGVmdF9tb2RlbCUyQyUyMGZwMTYlM0RUcnVlJTJDJTIwLi4uKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`peft_model = get_peft_model(...)

<span class="hljs-comment"># add this:</span>
<span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.parameters():
    <span class="hljs-keyword">if</span> param.requires_grad:
        param.data = param.data.<span class="hljs-built_in">float</span>()

<span class="hljs-comment"># proceed as usual</span>
trainer = Trainer(model=peft_model, fp16=<span class="hljs-literal">True</span>, ...)
trainer.train()`,wrap:!1}}),H=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBjYXN0X21peGVkX3ByZWNpc2lvbl9wYXJhbXMlMEElMEFwZWZ0X21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwoLi4uKSUwQWNhc3RfbWl4ZWRfcHJlY2lzaW9uX3BhcmFtcyhwZWZ0X21vZGVsJTJDJTIwZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQSUyMyUyMHByb2NlZWQlMjBhcyUyMHVzdWFsJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIobW9kZWwlM0RwZWZ0X21vZGVsJTJDJTIwZnAxNiUzRFRydWUlMkMlMjAuLi4pJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> cast_mixed_precision_params

peft_model = get_peft_model(...)
cast_mixed_precision_params(peft_model, dtype=torch.float16)

<span class="hljs-comment"># proceed as usual</span>
trainer = Trainer(model=peft_model, fp16=<span class="hljs-literal">True</span>, ...)
trainer.train()`,wrap:!1}}),_=new ga({props:{$$slots:{default:[Gs]},$$scope:{ctx:T}}}),X=new y({props:{title:"Selecting the dtype of the adapter",local:"selecting-the-dtype-of-the-adapter",headingTag:"h3"}}),Q=new y({props:{title:"Bad results from a loaded PEFT model",local:"bad-results-from-a-loaded-peft-model",headingTag:"h2"}}),D=new y({props:{title:"Random deviations",local:"random-deviations",headingTag:"h3"}}),ee=new y({props:{title:"Incorrectly loaded model",local:"incorrectly-loaded-model",headingTag:"h3"}}),le=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMkMlMjBQZWZ0Q29uZmlnJTBBJTBBYmFzZV9tb2RlbCUyMCUzRCUyMC4uLiUyMCUyMCUyMyUyMHRvJTIwbG9hZCUyMHRoZSUyMGJhc2UlMjBtb2RlbCUyQyUyMHVzZSUyMHRoZSUyMHNhbWUlMjBjb2RlJTIwYXMlMjB3aGVuJTIweW91JTIwdHJhaW5lZCUyMGl0JTBBY29uZmlnJTIwJTNEJTIwUGVmdENvbmZpZy5mcm9tX3ByZXRyYWluZWQocGVmdF9tb2RlbF9pZCklMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel, PeftConfig

base_model = ...  <span class="hljs-comment"># to load the base model, use the same code as when you trained it</span>
config = PeftConfig.from_pretrained(peft_model_id)
peft_model = PeftModel.from_pretrained(base_model, peft_model_id)`,wrap:!1}}),ae=new y({props:{title:"Randomly initialized layers",local:"randomly-initialized-layers",headingTag:"h3"}}),re=new w({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMCUzQ01PREVMJTNFJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwJTNDSUQlM0UlMjBhbmQlMjBhcmUlMjBuZXdseSUyMGluaXRpYWxpemVkJTNBJTIwJTVCJTNDTEFZRVJfTkFNRVMlM0UlNUQuJTBBWW91JTIwc2hvdWxkJTIwcHJvYmFibHklMjBUUkFJTiUyMHRoaXMlMjBtb2RlbCUyMG9uJTIwYSUyMGRvd24tc3RyZWFtJTIwdGFzayUyMHRvJTIwYmUlMjBhYmxlJTIwdG8lMjB1c2UlMjBpdCUyMGZvciUyMHByZWRpY3Rpb25zJTIwYW5kJTIwaW5mZXJlbmNlLg==",highlighted:`<span class="hljs-keyword">Some</span> weights <span class="hljs-keyword">of</span> &lt;MODEL&gt; were <span class="hljs-keyword">not</span> initialized <span class="hljs-keyword">from</span> the model <span class="hljs-keyword">checkpoint</span> at &lt;ID&gt; <span class="hljs-keyword">and</span> are newly initialized: [&lt;LAYER_NAMES&gt;].
You should probably TRAIN this model <span class="hljs-keyword">on</span> a down-stream task <span class="hljs-keyword">to</span> be able <span class="hljs-keyword">to</span> use it <span class="hljs-keyword">for</span> predictions <span class="hljs-keyword">and</span> inference.`,wrap:!1}}),$=new ga({props:{$$slots:{default:[Is]},$$scope:{ctx:T}}}),de=new y({props:{title:"Extending the vocabulary",local:"extending-the-vocabulary",headingTag:"h3"}}),he=new y({props:{title:"Using trainable tokens",local:"using-trainable-tokens",headingTag:"h4"}}),ge=new w({props:{code:"bmV3X3Rva2VucyUyMCUzRCUyMCU1QiclM0N0aGluayUzRSclMkMlMjAnJTNDJTJGdGhpbmslM0UnJTVEJTBBdG9rZW5pemVyLmFkZF90b2tlbnMobmV3X3Rva2VucyklMEFiYXNlX21vZGVsLnJlc2l6ZV90b2tlbl9lbWJlZGRpbmdzKGxlbih0b2tlbml6ZXIpKSUwQSUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjB0cmFpbmFibGVfdG9rZW5faW5kaWNlcyUzRCU3QidlbWJlZF90b2tlbnMnJTNBJTIwdG9rZW5pemVyLmNvbnZlcnRfdG9rZW5zX3RvX2lkcyhuZXdfdG9rZW5zKSU3RCUyQyUwQSk=",highlighted:`new_tokens = [<span class="hljs-string">&#x27;&lt;think&gt;&#x27;</span>, <span class="hljs-string">&#x27;&lt;/think&gt;&#x27;</span>]
tokenizer.add_tokens(new_tokens)
base_model.resize_token_embeddings(<span class="hljs-built_in">len</span>(tokenizer))

lora_config = LoraConfig(
    ...,
    trainable_token_indices={<span class="hljs-string">&#x27;embed_tokens&#x27;</span>: tokenizer.convert_tokens_to_ids(new_tokens)},
)`,wrap:!1}}),be=new y({props:{title:"Using an adapter, e.g. LoRA",local:"using-an-adapter-eg-lora",headingTag:"h4"}}),Te=new w({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyguLi4lMkMlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMmVtYmVkX3Rva2VucyUyMiUyQyUyMCUyMmxtX2hlYWQlMjIlMkMlMjAlMjJxX3Byb2olMjIlMkMlMjAlMjJ2X3Byb2olMjIlNUQp",highlighted:'config = LoraConfig(..., target_modules=[<span class="hljs-string">&quot;embed_tokens&quot;</span>, <span class="hljs-string">&quot;lm_head&quot;</span>, <span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>])',wrap:!1}}),ve=new w({props:{code:"bW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbCguLi4pJTBBJTIzJTIwdHJhaW4lMjB0aGUlMjBtb2RlbCUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJteV9hZGFwdGVyJTIyJTJDJTIwc2F2ZV9lbWJlZGRpbmdfbGF5ZXJzJTNEVHJ1ZSk=",highlighted:`model = get_peft_model(...)
<span class="hljs-comment"># train the model</span>
model.save_pretrained(<span class="hljs-string">&quot;my_adapter&quot;</span>, save_embedding_layers=<span class="hljs-literal">True</span>)`,wrap:!1}}),ke=new y({props:{title:"Full fine-tuning",local:"full-fine-tuning",headingTag:"h4"}}),Ze=new w({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyguLi4lMkMlMjBtb2R1bGVzX3RvX3NhdmUlM0QlNUIlMjJlbWJlZF90b2tlbnMlMjIlMkMlMjAlMjJsbV9oZWFkJTIyJTVEJTJDJTIwdGFyZ2V0X21vZHVsZXMlM0QlNUIlMjJxX3Byb2olMjIlMkMlMjAlMjJ2X3Byb2olMjIlNUQp",highlighted:'config = LoraConfig(..., modules_to_save=[<span class="hljs-string">&quot;embed_tokens&quot;</span>, <span class="hljs-string">&quot;lm_head&quot;</span>], target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>])',wrap:!1}}),Ce=new y({props:{title:"Getting a warning about “weights not being initialized from the model checkpoint”",local:"getting-a-warning-about-weights-not-being-initialized-from-the-model-checkpoint",headingTag:"h3"}}),Fe=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwVGFza1R5cGUlMEElMEFsb3JhX2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoLi4uJTJDJTIwdGFza190eXBlJTNEVGFza1R5cGUuU0VRX0NMUyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, TaskType

lora_config = LoraConfig(..., task_type=TaskType.SEQ_CLS)`,wrap:!1}}),Ie=new w({props:{code:"bG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiUyQyUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMm5hbWUtb2YtY2xhc3NpZmljYXRpb24taGVhZCUyMiU1RCk=",highlighted:'lora_config = LoraConfig(..., modules_to_save=[<span class="hljs-string">&quot;name-of-classification-head&quot;</span>])',wrap:!1}}),Ve=new y({props:{title:"Check layer and model status",local:"check-layer-and-model-status",headingTag:"h3"}}),ze=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwZ2V0X3BlZnRfbW9kZWwlMkMlMjBMb3JhQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJnb29nbGUlMkZmbGFuLXQ1LXNtYWxsJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBMb3JhQ29uZmlnKCkpJTBBJTBBbW9kZWwuZ2V0X2xheWVyX3N0YXR1cygpJTBBJTBBbW9kZWwuZ2V0X21vZGVsX3N0YXR1cygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model, LoraConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;google/flan-t5-small&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = get_peft_model(model, LoraConfig())

<span class="hljs-meta">&gt;&gt;&gt; </span>model.get_layer_status()
[TunerLayerStatus(name=<span class="hljs-string">&#x27;model.encoder.block.0.layer.0.SelfAttention.q&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-literal">True</span>},
                  available_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>]),
 TunerLayerStatus(name=<span class="hljs-string">&#x27;model.encoder.block.0.layer.0.SelfAttention.v&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-literal">True</span>},
                  available_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>]),
...]

<span class="hljs-meta">&gt;&gt;&gt; </span>model.get_model_status()
TunerModelStatus(
    base_model_type=<span class="hljs-string">&#x27;T5Model&#x27;</span>,
    adapter_model_type=<span class="hljs-string">&#x27;LoraModel&#x27;</span>,
    peft_types={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-string">&#x27;LORA&#x27;</span>},
    trainable_params=<span class="hljs-number">344064</span>,
    total_params=<span class="hljs-number">60855680</span>,
    num_adapter_layers=<span class="hljs-number">48</span>,
    enabled=<span class="hljs-literal">True</span>,
    active_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
    merged_adapters=[],
    requires_grad={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-literal">True</span>},
    available_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
)`,wrap:!1}}),Qe=new w({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwYXNkaWN0JTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQWRmJTIwJTNEJTIwcGQuRGF0YUZyYW1lKGFzZGljdChsYXllciklMjBmb3IlMjBsYXllciUyMGluJTIwbW9kZWwuZ2V0X2xheWVyX3N0YXR1cygpKQ==",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> asdict
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

df = pd.DataFrame(asdict(layer) <span class="hljs-keyword">for</span> layer <span class="hljs-keyword">in</span> model.get_layer_status())`,wrap:!1}}),Ae=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMGdldF9tb2RlbF9zdGF0dXMlMkMlMjBnZXRfbGF5ZXJfc3RhdHVzJTBBJTBBcGF0aCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBbG9yYV9pZCUyMCUzRCUyMCUyMnRha3VtYTEwNCUyRmxvcmEtdGVzdC10ZXh0LWVuY29kZXItbG9yYS10YXJnZXQlMjIlMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHBhdGglMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZS5sb2FkX2xvcmFfd2VpZ2h0cyhsb3JhX2lkJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlci0xJTIyKSUwQXBpcGUubG9hZF9sb3JhX3dlaWdodHMobG9yYV9pZCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmFkYXB0ZXItMiUyMiklMEFwaXBlLnNldF9sb3JhX2RldmljZSglNUIlMjJhZGFwdGVyLTIlMjIlNUQlMkMlMjAlMjJjdWRhJTIyKSUwQWdldF9sYXllcl9zdGF0dXMocGlwZS50ZXh0X2VuY29kZXIpJTBBJTBBZ2V0X21vZGVsX3N0YXR1cyhwaXBlLnVuZXQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_model_status, get_layer_status

<span class="hljs-meta">&gt;&gt;&gt; </span>path = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>lora_id = <span class="hljs-string">&quot;takuma104/lora-test-text-encoder-lora-target&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(path, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.load_lora_weights(lora_id, adapter_name=<span class="hljs-string">&quot;adapter-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.load_lora_weights(lora_id, adapter_name=<span class="hljs-string">&quot;adapter-2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.set_lora_device([<span class="hljs-string">&quot;adapter-2&quot;</span>], <span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>get_layer_status(pipe.text_encoder)
[TunerLayerStatus(name=<span class="hljs-string">&#x27;text_model.encoder.layers.0.self_attn.k_proj&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;adapter-2&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>: <span class="hljs-literal">True</span>},
                  available_adapters=[<span class="hljs-string">&#x27;adapter-1&#x27;</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>],
                  devices={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: [<span class="hljs-string">&#x27;cpu&#x27;</span>], <span class="hljs-string">&#x27;adapter-2&#x27;</span>: [<span class="hljs-string">&#x27;cuda&#x27;</span>]}),
 TunerLayerStatus(name=<span class="hljs-string">&#x27;text_model.encoder.layers.0.self_attn.v_proj&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;adapter-2&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>: <span class="hljs-literal">True</span>},
                  devices={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: [<span class="hljs-string">&#x27;cpu&#x27;</span>], <span class="hljs-string">&#x27;adapter-2&#x27;</span>: [<span class="hljs-string">&#x27;cuda&#x27;</span>]}),
...]

<span class="hljs-meta">&gt;&gt;&gt; </span>get_model_status(pipe.unet)
TunerModelStatus(
    base_model_type=<span class="hljs-string">&#x27;other&#x27;</span>,
    adapter_model_type=<span class="hljs-string">&#x27;None&#x27;</span>,
    peft_types={},
    trainable_params=<span class="hljs-number">797184</span>,
    total_params=<span class="hljs-number">861115332</span>,
    num_adapter_layers=<span class="hljs-number">128</span>,
    enabled=<span class="hljs-literal">True</span>,
    active_adapters=[<span class="hljs-string">&#x27;adapter-2&#x27;</span>],
    merged_adapters=[],
    requires_grad={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>: <span class="hljs-literal">True</span>},
    available_adapters=[<span class="hljs-string">&#x27;adapter-1&#x27;</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>],
    devices={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: [<span class="hljs-string">&#x27;cpu&#x27;</span>], <span class="hljs-string">&#x27;adapter-2&#x27;</span>: [<span class="hljs-string">&#x27;cuda&#x27;</span>]},
)`,wrap:!1}}),De=new y({props:{title:"Speed",local:"speed",headingTag:"h2"}}),Ke=new y({props:{title:"Loading adapter weights is slow",local:"loading-adapter-weights-is-slow",headingTag:"h3"}}),v=new ga({props:{$$slots:{default:[Rs]},$$scope:{ctx:T}}}),et=new y({props:{title:"Reproducibility",local:"reproducibility",headingTag:"h2"}}),tt=new y({props:{title:"Models using batch norm",local:"models-using-batch-norm",headingTag:"h3"}}),st=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMExvcmFDb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybWljcm9zb2Z0JTJGcmVzbmV0LTE4JTIyJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKHNlbGYubW9kZWxfaWQpJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMmNvbnZvbHV0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kdWxlc190b19zYXZlJTNEJTVCJTIyY2xhc3NpZmllciUyMiUyQyUyMCUyMm5vcm1hbGl6YXRpb24lMjIlNUQlMkMlMEEpJTJD",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

model_id = <span class="hljs-string">&quot;microsoft/resnet-18&quot;</span>
base_model = AutoModelForImageClassification.from_pretrained(self.model_id)
config = LoraConfig(
    target_modules=[<span class="hljs-string">&quot;convolution&quot;</span>],
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>, <span class="hljs-string">&quot;normalization&quot;</span>],
),`,wrap:!1}}),it=new y({props:{title:"Version mismatch",local:"version-mismatch",headingTag:"h2"}}),ot=new y({props:{title:"Error while loading the config because of an unexpected keyword argument",local:"error-while-loading-the-config-because-of-an-unexpected-keyword-argument",headingTag:"h3"}}),pt=new w({props:{code:"VHlwZUVycm9yJTNBJTIwTG9yYUNvbmZpZy5fX2luaXRfXygpJTIwZ290JTIwYW4lMjB1bmV4cGVjdGVkJTIwa2V5d29yZCUyMGFyZ3VtZW50JTIwJTNDYXJndW1lbnQtbmFtZSUzRQ==",highlighted:'TypeError: LoraConfig.__init__() got an unexpected keyword <span class="hljs-variable language_">argument</span> &lt;<span class="hljs-variable language_">argument</span>-name&gt;',wrap:!1}}),mt=new w({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwLVUlMjBQRUZU",highlighted:"python -m pip install -U PEFT",wrap:!1}}),ht=new w({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwLVUlMjBnaXQlMkJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRnBlZnQuZ2l0",highlighted:"python -m pip install -U git+https://github.com/huggingface/peft.git",wrap:!1}}),yt=new Fs({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/troubleshooting.md"}}),{c(){c=i("meta"),b=s(),g=i("p"),M=s(),p(x.$$.fragment),bt=s(),j=i("p"),j.textContent=wa,Mt=s(),p(k.$$.fragment),Tt=s(),J=i("p"),J.textContent=ba,_t=s(),Z=i("ul"),Z.innerHTML=Ma,$t=s(),C=i("p"),C.textContent=Ta,vt=s(),p(U.$$.fragment),xt=s(),L=i("p"),L.textContent=_a,jt=s(),p(W.$$.fragment),kt=s(),p(B.$$.fragment),Jt=s(),p(F.$$.fragment),Zt=s(),G=i("p"),G.innerHTML=$a,Ct=s(),p(I.$$.fragment),Ut=s(),R=i("p"),R.innerHTML=va,Lt=s(),p(H.$$.fragment),Wt=s(),p(_.$$.fragment),Bt=s(),p(X.$$.fragment),Ft=s(),V=i("p"),V.textContent=xa,Gt=s(),E=i("p"),E.innerHTML=ja,It=s(),P=i("p"),P.textContent=ka,Rt=s(),z=i("ul"),z.innerHTML=Ja,Ht=s(),Y=i("p"),Y.textContent=Za,Xt=s(),N=i("ul"),N.innerHTML=Ca,Vt=s(),q=i("p"),q.textContent=Ua,Et=s(),p(Q.$$.fragment),Pt=s(),S=i("p"),S.innerHTML=La,zt=s(),A=i("p"),A.textContent=Wa,Yt=s(),p(D.$$.fragment),Nt=s(),K=i("p"),K.textContent=Ba,qt=s(),O=i("ol"),O.innerHTML=Fa,Qt=s(),p(ee.$$.fragment),St=s(),te=i("p"),te.innerHTML=Ga,At=s(),p(le.$$.fragment),Dt=s(),p(ae.$$.fragment),Kt=s(),se=i("p"),se.innerHTML=Ia,Ot=s(),ne=i("p"),ne.innerHTML=Ra,el=s(),ie=i("p"),ie.innerHTML=Ha,tl=s(),oe=i("p"),oe.textContent=Xa,ll=s(),p(re.$$.fragment),al=s(),pe=i("p"),pe.innerHTML=Va,sl=s(),p($.$$.fragment),nl=s(),p(de.$$.fragment),il=s(),me=i("p"),me.textContent=Ea,ol=s(),fe=i("ul"),fe.innerHTML=Pa,rl=s(),p(he.$$.fragment),pl=s(),ue=i("p"),ue.innerHTML=za,dl=s(),ce=i("p"),ce.innerHTML=Ya,ml=s(),p(ge.$$.fragment),fl=s(),ye=i("p"),ye.innerHTML=Na,hl=s(),we=i("p"),we.innerHTML=qa,ul=s(),p(be.$$.fragment),cl=s(),Me=i("p"),Me.innerHTML=Qa,gl=s(),p(Te.$$.fragment),yl=s(),_e=i("p"),_e.innerHTML=Sa,wl=s(),$e=i("p"),$e.innerHTML=Aa,bl=s(),p(ve.$$.fragment),Ml=s(),xe=i("p"),xe.textContent=Da,Tl=s(),je=i("p"),je.innerHTML=Ka,_l=s(),p(ke.$$.fragment),$l=s(),Je=i("p"),Je.innerHTML=Oa,vl=s(),p(Ze.$$.fragment),xl=s(),p(Ce.$$.fragment),jl=s(),Ue=i("p"),Ue.textContent=es,kl=s(),Le=i("blockquote"),Le.innerHTML=ts,Jl=s(),We=i("p"),We.innerHTML=ls,Zl=s(),Be=i("p"),Be.innerHTML=as,Cl=s(),p(Fe.$$.fragment),Ul=s(),Ge=i("p"),Ge.innerHTML=ss,Ll=s(),p(Ie.$$.fragment),Wl=s(),Re=i("p"),Re.textContent=ns,Bl=s(),He=i("p"),He.innerHTML=is,Fl=s(),Xe=i("p"),Xe.textContent=os,Gl=s(),p(Ve.$$.fragment),Il=s(),Ee=i("p"),Ee.innerHTML=rs,Rl=s(),Pe=i("p"),Pe.innerHTML=ps,Hl=s(),p(ze.$$.fragment),Xl=s(),Ye=i("p"),Ye.innerHTML=ds,Vl=s(),Ne=i("p"),Ne.textContent=ms,El=s(),qe=i("p"),qe.innerHTML=fs,Pl=s(),p(Qe.$$.fragment),zl=s(),Se=i("p"),Se.innerHTML=hs,Yl=s(),p(Ae.$$.fragment),Nl=s(),p(De.$$.fragment),ql=s(),p(Ke.$$.fragment),Ql=s(),Oe=i("p"),Oe.innerHTML=us,Sl=s(),p(v.$$.fragment),Al=s(),p(et.$$.fragment),Dl=s(),p(tt.$$.fragment),Kl=s(),lt=i("p"),lt.innerHTML=cs,Ol=s(),at=i("p"),at.innerHTML=gs,ea=s(),p(st.$$.fragment),ta=s(),nt=i("p"),nt.innerHTML=ys,la=s(),p(it.$$.fragment),aa=s(),p(ot.$$.fragment),sa=s(),rt=i("p"),rt.textContent=ws,na=s(),p(pt.$$.fragment),ia=s(),dt=i("p"),dt.textContent=bs,oa=s(),p(mt.$$.fragment),ra=s(),ft=i("p"),ft.textContent=Ms,pa=s(),p(ht.$$.fragment),da=s(),ut=i("p"),ut.textContent=Ts,ma=s(),ct=i("p"),ct.innerHTML=_s,fa=s(),gt=i("p"),gt.innerHTML=$s,ha=s(),p(yt.$$.fragment),ua=s(),wt=i("p"),this.h()},l(e){const t=Ws("svelte-u9bgzb",document.head);c=o(t,"META",{name:!0,content:!0}),t.forEach(l),b=n(e),g=o(e,"P",{}),ks(g).forEach(l),M=n(e),d(x.$$.fragment,e),bt=n(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-wwms7a"&&(j.textContent=wa),Mt=n(e),d(k.$$.fragment,e),Tt=n(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-18nlz3r"&&(J.textContent=ba),_t=n(e),Z=o(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-ccv654"&&(Z.innerHTML=Ma),$t=n(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1cuqjyb"&&(C.textContent=Ta),vt=n(e),d(U.$$.fragment,e),xt=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-h5ykrw"&&(L.textContent=_a),jt=n(e),d(W.$$.fragment,e),kt=n(e),d(B.$$.fragment,e),Jt=n(e),d(F.$$.fragment,e),Zt=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-18fagzb"&&(G.innerHTML=$a),Ct=n(e),d(I.$$.fragment,e),Ut=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-8d8em4"&&(R.innerHTML=va),Lt=n(e),d(H.$$.fragment,e),Wt=n(e),d(_.$$.fragment,e),Bt=n(e),d(X.$$.fragment,e),Ft=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1w3ww7i"&&(V.textContent=xa),Gt=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-14zgsh3"&&(E.innerHTML=ja),It=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-3n96y7"&&(P.textContent=ka),Rt=n(e),z=o(e,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-1ghjkcl"&&(z.innerHTML=Ja),Ht=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1yqgo19"&&(Y.textContent=Za),Xt=n(e),N=o(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-pdypmd"&&(N.innerHTML=Ca),Vt=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1gmj2pd"&&(q.textContent=Ua),Et=n(e),d(Q.$$.fragment,e),Pt=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-ns8zue"&&(S.innerHTML=La),zt=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-lfc2ft"&&(A.textContent=Wa),Yt=n(e),d(D.$$.fragment,e),Nt=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-16feh"&&(K.textContent=Ba),qt=n(e),O=o(e,"OL",{"data-svelte-h":!0}),r(O)!=="svelte-7wn4ol"&&(O.innerHTML=Fa),Qt=n(e),d(ee.$$.fragment,e),St=n(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-3rlx6"&&(te.innerHTML=Ga),At=n(e),d(le.$$.fragment,e),Dt=n(e),d(ae.$$.fragment,e),Kt=n(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-5heszj"&&(se.innerHTML=Ia),Ot=n(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-c4824l"&&(ne.innerHTML=Ra),el=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1ou3c35"&&(ie.innerHTML=Ha),tl=n(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1g4txs2"&&(oe.textContent=Xa),ll=n(e),d(re.$$.fragment,e),al=n(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1fbeum6"&&(pe.innerHTML=Va),sl=n(e),d($.$$.fragment,e),nl=n(e),d(de.$$.fragment,e),il=n(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1ftgm9w"&&(me.textContent=Ea),ol=n(e),fe=o(e,"UL",{"data-svelte-h":!0}),r(fe)!=="svelte-1cu50cp"&&(fe.innerHTML=Pa),rl=n(e),d(he.$$.fragment,e),pl=n(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-p4bcqv"&&(ue.innerHTML=za),dl=n(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-ffklcx"&&(ce.innerHTML=Ya),ml=n(e),d(ge.$$.fragment,e),fl=n(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-12n0r5k"&&(ye.innerHTML=Na),hl=n(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1r5fwm9"&&(we.innerHTML=qa),ul=n(e),d(be.$$.fragment,e),cl=n(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1bq6qvj"&&(Me.innerHTML=Qa),gl=n(e),d(Te.$$.fragment,e),yl=n(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1lr155g"&&(_e.innerHTML=Sa),wl=n(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1kaw5hl"&&($e.innerHTML=Aa),bl=n(e),d(ve.$$.fragment,e),Ml=n(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-nkv7o7"&&(xe.textContent=Da),Tl=n(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-a0ibfa"&&(je.innerHTML=Ka),_l=n(e),d(ke.$$.fragment,e),$l=n(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-u2918x"&&(Je.innerHTML=Oa),vl=n(e),d(Ze.$$.fragment,e),xl=n(e),d(Ce.$$.fragment,e),jl=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-q2uzbp"&&(Ue.textContent=es),kl=n(e),Le=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(Le)!=="svelte-ray7nl"&&(Le.innerHTML=ts),Jl=n(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1cejahg"&&(We.innerHTML=ls),Zl=n(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-m24cow"&&(Be.innerHTML=as),Cl=n(e),d(Fe.$$.fragment,e),Ul=n(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1c6v178"&&(Ge.innerHTML=ss),Ll=n(e),d(Ie.$$.fragment,e),Wl=n(e),Re=o(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-f59lgd"&&(Re.textContent=ns),Bl=n(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-k7fvy1"&&(He.innerHTML=is),Fl=n(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-16spx00"&&(Xe.textContent=os),Gl=n(e),d(Ve.$$.fragment,e),Il=n(e),Ee=o(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-80wjft"&&(Ee.innerHTML=rs),Rl=n(e),Pe=o(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-10ckl44"&&(Pe.innerHTML=ps),Hl=n(e),d(ze.$$.fragment,e),Xl=n(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1gb1r7d"&&(Ye.innerHTML=ds),Vl=n(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-19sfzdf"&&(Ne.textContent=ms),El=n(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-18r4lni"&&(qe.innerHTML=fs),Pl=n(e),d(Qe.$$.fragment,e),zl=n(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-17rnlhh"&&(Se.innerHTML=hs),Yl=n(e),d(Ae.$$.fragment,e),Nl=n(e),d(De.$$.fragment,e),ql=n(e),d(Ke.$$.fragment,e),Ql=n(e),Oe=o(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-n6gm7m"&&(Oe.innerHTML=us),Sl=n(e),d(v.$$.fragment,e),Al=n(e),d(et.$$.fragment,e),Dl=n(e),d(tt.$$.fragment,e),Kl=n(e),lt=o(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-yt67c7"&&(lt.innerHTML=cs),Ol=n(e),at=o(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-wblxho"&&(at.innerHTML=gs),ea=n(e),d(st.$$.fragment,e),ta=n(e),nt=o(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1e3stb1"&&(nt.innerHTML=ys),la=n(e),d(it.$$.fragment,e),aa=n(e),d(ot.$$.fragment,e),sa=n(e),rt=o(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-5zz36e"&&(rt.textContent=ws),na=n(e),d(pt.$$.fragment,e),ia=n(e),dt=o(e,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-1dqw1qx"&&(dt.textContent=bs),oa=n(e),d(mt.$$.fragment,e),ra=n(e),ft=o(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-1k207nl"&&(ft.textContent=Ms),pa=n(e),d(ht.$$.fragment,e),da=n(e),ut=o(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-1jt6x31"&&(ut.textContent=Ts),ma=n(e),ct=o(e,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-1a81pzz"&&(ct.innerHTML=_s),fa=n(e),gt=o(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-1wt4m5g"&&(gt.innerHTML=$s),ha=n(e),d(yt.$$.fragment,e),ua=n(e),wt=o(e,"P",{}),ks(wt).forEach(l),this.h()},h(){Js(c,"name","hf:doc:metadata"),Js(c,"content",Xs)},m(e,t){Bs(document.head,c),a(e,b,t),a(e,g,t),a(e,M,t),m(x,e,t),a(e,bt,t),a(e,j,t),a(e,Mt,t),m(k,e,t),a(e,Tt,t),a(e,J,t),a(e,_t,t),a(e,Z,t),a(e,$t,t),a(e,C,t),a(e,vt,t),m(U,e,t),a(e,xt,t),a(e,L,t),a(e,jt,t),m(W,e,t),a(e,kt,t),m(B,e,t),a(e,Jt,t),m(F,e,t),a(e,Zt,t),a(e,G,t),a(e,Ct,t),m(I,e,t),a(e,Ut,t),a(e,R,t),a(e,Lt,t),m(H,e,t),a(e,Wt,t),m(_,e,t),a(e,Bt,t),m(X,e,t),a(e,Ft,t),a(e,V,t),a(e,Gt,t),a(e,E,t),a(e,It,t),a(e,P,t),a(e,Rt,t),a(e,z,t),a(e,Ht,t),a(e,Y,t),a(e,Xt,t),a(e,N,t),a(e,Vt,t),a(e,q,t),a(e,Et,t),m(Q,e,t),a(e,Pt,t),a(e,S,t),a(e,zt,t),a(e,A,t),a(e,Yt,t),m(D,e,t),a(e,Nt,t),a(e,K,t),a(e,qt,t),a(e,O,t),a(e,Qt,t),m(ee,e,t),a(e,St,t),a(e,te,t),a(e,At,t),m(le,e,t),a(e,Dt,t),m(ae,e,t),a(e,Kt,t),a(e,se,t),a(e,Ot,t),a(e,ne,t),a(e,el,t),a(e,ie,t),a(e,tl,t),a(e,oe,t),a(e,ll,t),m(re,e,t),a(e,al,t),a(e,pe,t),a(e,sl,t),m($,e,t),a(e,nl,t),m(de,e,t),a(e,il,t),a(e,me,t),a(e,ol,t),a(e,fe,t),a(e,rl,t),m(he,e,t),a(e,pl,t),a(e,ue,t),a(e,dl,t),a(e,ce,t),a(e,ml,t),m(ge,e,t),a(e,fl,t),a(e,ye,t),a(e,hl,t),a(e,we,t),a(e,ul,t),m(be,e,t),a(e,cl,t),a(e,Me,t),a(e,gl,t),m(Te,e,t),a(e,yl,t),a(e,_e,t),a(e,wl,t),a(e,$e,t),a(e,bl,t),m(ve,e,t),a(e,Ml,t),a(e,xe,t),a(e,Tl,t),a(e,je,t),a(e,_l,t),m(ke,e,t),a(e,$l,t),a(e,Je,t),a(e,vl,t),m(Ze,e,t),a(e,xl,t),m(Ce,e,t),a(e,jl,t),a(e,Ue,t),a(e,kl,t),a(e,Le,t),a(e,Jl,t),a(e,We,t),a(e,Zl,t),a(e,Be,t),a(e,Cl,t),m(Fe,e,t),a(e,Ul,t),a(e,Ge,t),a(e,Ll,t),m(Ie,e,t),a(e,Wl,t),a(e,Re,t),a(e,Bl,t),a(e,He,t),a(e,Fl,t),a(e,Xe,t),a(e,Gl,t),m(Ve,e,t),a(e,Il,t),a(e,Ee,t),a(e,Rl,t),a(e,Pe,t),a(e,Hl,t),m(ze,e,t),a(e,Xl,t),a(e,Ye,t),a(e,Vl,t),a(e,Ne,t),a(e,El,t),a(e,qe,t),a(e,Pl,t),m(Qe,e,t),a(e,zl,t),a(e,Se,t),a(e,Yl,t),m(Ae,e,t),a(e,Nl,t),m(De,e,t),a(e,ql,t),m(Ke,e,t),a(e,Ql,t),a(e,Oe,t),a(e,Sl,t),m(v,e,t),a(e,Al,t),m(et,e,t),a(e,Dl,t),m(tt,e,t),a(e,Kl,t),a(e,lt,t),a(e,Ol,t),a(e,at,t),a(e,ea,t),m(st,e,t),a(e,ta,t),a(e,nt,t),a(e,la,t),m(it,e,t),a(e,aa,t),m(ot,e,t),a(e,sa,t),a(e,rt,t),a(e,na,t),m(pt,e,t),a(e,ia,t),a(e,dt,t),a(e,oa,t),m(mt,e,t),a(e,ra,t),a(e,ft,t),a(e,pa,t),m(ht,e,t),a(e,da,t),a(e,ut,t),a(e,ma,t),a(e,ct,t),a(e,fa,t),a(e,gt,t),a(e,ha,t),m(yt,e,t),a(e,ua,t),a(e,wt,t),ca=!0},p(e,[t]){const vs={};t&2&&(vs.$$scope={dirty:t,ctx:e}),_.$set(vs);const xs={};t&2&&(xs.$$scope={dirty:t,ctx:e}),$.$set(xs);const js={};t&2&&(js.$$scope={dirty:t,ctx:e}),v.$set(js)},i(e){ca||(f(x.$$.fragment,e),f(k.$$.fragment,e),f(U.$$.fragment,e),f(W.$$.fragment,e),f(B.$$.fragment,e),f(F.$$.fragment,e),f(I.$$.fragment,e),f(H.$$.fragment,e),f(_.$$.fragment,e),f(X.$$.fragment,e),f(Q.$$.fragment,e),f(D.$$.fragment,e),f(ee.$$.fragment,e),f(le.$$.fragment,e),f(ae.$$.fragment,e),f(re.$$.fragment,e),f($.$$.fragment,e),f(de.$$.fragment,e),f(he.$$.fragment,e),f(ge.$$.fragment,e),f(be.$$.fragment,e),f(Te.$$.fragment,e),f(ve.$$.fragment,e),f(ke.$$.fragment,e),f(Ze.$$.fragment,e),f(Ce.$$.fragment,e),f(Fe.$$.fragment,e),f(Ie.$$.fragment,e),f(Ve.$$.fragment,e),f(ze.$$.fragment,e),f(Qe.$$.fragment,e),f(Ae.$$.fragment,e),f(De.$$.fragment,e),f(Ke.$$.fragment,e),f(v.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(st.$$.fragment,e),f(it.$$.fragment,e),f(ot.$$.fragment,e),f(pt.$$.fragment,e),f(mt.$$.fragment,e),f(ht.$$.fragment,e),f(yt.$$.fragment,e),ca=!0)},o(e){h(x.$$.fragment,e),h(k.$$.fragment,e),h(U.$$.fragment,e),h(W.$$.fragment,e),h(B.$$.fragment,e),h(F.$$.fragment,e),h(I.$$.fragment,e),h(H.$$.fragment,e),h(_.$$.fragment,e),h(X.$$.fragment,e),h(Q.$$.fragment,e),h(D.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),h(ae.$$.fragment,e),h(re.$$.fragment,e),h($.$$.fragment,e),h(de.$$.fragment,e),h(he.$$.fragment,e),h(ge.$$.fragment,e),h(be.$$.fragment,e),h(Te.$$.fragment,e),h(ve.$$.fragment,e),h(ke.$$.fragment,e),h(Ze.$$.fragment,e),h(Ce.$$.fragment,e),h(Fe.$$.fragment,e),h(Ie.$$.fragment,e),h(Ve.$$.fragment,e),h(ze.$$.fragment,e),h(Qe.$$.fragment,e),h(Ae.$$.fragment,e),h(De.$$.fragment,e),h(Ke.$$.fragment,e),h(v.$$.fragment,e),h(et.$$.fragment,e),h(tt.$$.fragment,e),h(st.$$.fragment,e),h(it.$$.fragment,e),h(ot.$$.fragment,e),h(pt.$$.fragment,e),h(mt.$$.fragment,e),h(ht.$$.fragment,e),h(yt.$$.fragment,e),ca=!1},d(e){e&&(l(b),l(g),l(M),l(bt),l(j),l(Mt),l(Tt),l(J),l(_t),l(Z),l($t),l(C),l(vt),l(xt),l(L),l(jt),l(kt),l(Jt),l(Zt),l(G),l(Ct),l(Ut),l(R),l(Lt),l(Wt),l(Bt),l(Ft),l(V),l(Gt),l(E),l(It),l(P),l(Rt),l(z),l(Ht),l(Y),l(Xt),l(N),l(Vt),l(q),l(Et),l(Pt),l(S),l(zt),l(A),l(Yt),l(Nt),l(K),l(qt),l(O),l(Qt),l(St),l(te),l(At),l(Dt),l(Kt),l(se),l(Ot),l(ne),l(el),l(ie),l(tl),l(oe),l(ll),l(al),l(pe),l(sl),l(nl),l(il),l(me),l(ol),l(fe),l(rl),l(pl),l(ue),l(dl),l(ce),l(ml),l(fl),l(ye),l(hl),l(we),l(ul),l(cl),l(Me),l(gl),l(yl),l(_e),l(wl),l($e),l(bl),l(Ml),l(xe),l(Tl),l(je),l(_l),l($l),l(Je),l(vl),l(xl),l(jl),l(Ue),l(kl),l(Le),l(Jl),l(We),l(Zl),l(Be),l(Cl),l(Ul),l(Ge),l(Ll),l(Wl),l(Re),l(Bl),l(He),l(Fl),l(Xe),l(Gl),l(Il),l(Ee),l(Rl),l(Pe),l(Hl),l(Xl),l(Ye),l(Vl),l(Ne),l(El),l(qe),l(Pl),l(zl),l(Se),l(Yl),l(Nl),l(ql),l(Ql),l(Oe),l(Sl),l(Al),l(Dl),l(Kl),l(lt),l(Ol),l(at),l(ea),l(ta),l(nt),l(la),l(aa),l(sa),l(rt),l(na),l(ia),l(dt),l(oa),l(ra),l(ft),l(pa),l(da),l(ut),l(ma),l(ct),l(fa),l(gt),l(ha),l(ua),l(wt)),l(c),u(x,e),u(k,e),u(U,e),u(W,e),u(B,e),u(F,e),u(I,e),u(H,e),u(_,e),u(X,e),u(Q,e),u(D,e),u(ee,e),u(le,e),u(ae,e),u(re,e),u($,e),u(de,e),u(he,e),u(ge,e),u(be,e),u(Te,e),u(ve,e),u(ke,e),u(Ze,e),u(Ce,e),u(Fe,e),u(Ie,e),u(Ve,e),u(ze,e),u(Qe,e),u(Ae,e),u(De,e),u(Ke,e),u(v,e),u(et,e),u(tt,e),u(st,e),u(it,e),u(ot,e),u(pt,e),u(mt,e),u(ht,e),u(yt,e)}}}const Xs='{"title":"Troubleshooting","local":"troubleshooting","sections":[{"title":"Examples don’t work","local":"examples-dont-work","sections":[],"depth":2},{"title":"Dtype-related issues","local":"dtype-related-issues","sections":[{"title":"ValueError: Attempting to unscale FP16 gradients","local":"valueerror-attempting-to-unscale-fp16-gradients","sections":[],"depth":3},{"title":"Selecting the dtype of the adapter","local":"selecting-the-dtype-of-the-adapter","sections":[],"depth":3}],"depth":2},{"title":"Bad results from a loaded PEFT model","local":"bad-results-from-a-loaded-peft-model","sections":[{"title":"Random deviations","local":"random-deviations","sections":[],"depth":3},{"title":"Incorrectly loaded model","local":"incorrectly-loaded-model","sections":[],"depth":3},{"title":"Randomly initialized layers","local":"randomly-initialized-layers","sections":[],"depth":3},{"title":"Extending the vocabulary","local":"extending-the-vocabulary","sections":[{"title":"Using trainable tokens","local":"using-trainable-tokens","sections":[],"depth":4},{"title":"Using an adapter, e.g. LoRA","local":"using-an-adapter-eg-lora","sections":[],"depth":4},{"title":"Full fine-tuning","local":"full-fine-tuning","sections":[],"depth":4}],"depth":3},{"title":"Getting a warning about “weights not being initialized from the model checkpoint”","local":"getting-a-warning-about-weights-not-being-initialized-from-the-model-checkpoint","sections":[],"depth":3},{"title":"Check layer and model status","local":"check-layer-and-model-status","sections":[],"depth":3}],"depth":2},{"title":"Speed","local":"speed","sections":[{"title":"Loading adapter weights is slow","local":"loading-adapter-weights-is-slow","sections":[],"depth":3}],"depth":2},{"title":"Reproducibility","local":"reproducibility","sections":[{"title":"Models using batch norm","local":"models-using-batch-norm","sections":[],"depth":3}],"depth":2},{"title":"Version mismatch","local":"version-mismatch","sections":[{"title":"Error while loading the config because of an unexpected keyword argument","local":"error-while-loading-the-config-because-of-an-unexpected-keyword-argument","sections":[],"depth":3}],"depth":2}],"depth":1}';function Vs(T){return Cs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qs extends Us{constructor(c){super(),Ls(this,c,Vs,Hs,Zs,{})}}export{qs as component};
