import{s as Nt,o as Ht,n as be}from"../chunks/scheduler.c57aa7ef.js";import{S as Lt,i as St,g as U,s as o,r as c,A as qt,h as w,f as l,c as r,j as Et,u as d,x as T,k as Ut,y as Dt,a,v as y,d as f,t as h,w as u}from"../chunks/index.394f8801.js";import{T as wt}from"../chunks/Tip.23dfb1a9.js";import{C as j}from"../chunks/CodeBlock.b5488637.js";import{H as we,E as Pt}from"../chunks/getInferenceSnippets.54bf47f2.js";import{H as Kt,a as Jt}from"../chunks/HfOption.41e9cb41.js";function Ot($){let s,b='Some familiarity with the general process of training an image classification model would be really helpful and allow you to focus on the low-rank decomposition methods. If you’re new, we recommend taking a look at the <a href="https://huggingface.co/docs/transformers/tasks/image_classification" rel="nofollow">Image classification</a> guide first from the Transformers documentation. When you’re ready, come back and see how easy it is to drop PEFT in to your training!';return{c(){s=U("p"),s.innerHTML=b},l(i){s=w(i,"P",{"data-svelte-h":!0}),T(s)!=="svelte-122rdqq"&&(s.innerHTML=b)},m(i,p){a(i,s,p)},p:be,d(i){i&&l(s)}}}function el($){let s,b='Call the <a href="/docs/peft/v0.17.0/en/package_reference/peft_model#peft.PeftModel.print_trainable_parameters">print_trainable_parameters()</a> method to compare the number of parameters of <a href="/docs/peft/v0.17.0/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> versus the number of parameters in the base model!';return{c(){s=U("p"),s.innerHTML=b},l(i){s=w(i,"P",{"data-svelte-h":!0}),T(s)!=="svelte-124940v"&&(s.innerHTML=b)},m(i,p){a(i,s,p)},p:be,d(i){i&&l(s)}}}function tl($){let s,b='<a href="../conceptual_guides/adapter#low-rank-adaptation-lora">LoRA</a> decomposes the weight update matrix into <em>two</em> smaller matrices. The size of these low-rank matrices is determined by its <em>rank</em> or <code>r</code>. A higher rank means the model has more parameters to train, but it also means the model has more learning capacity. You’ll also want to specify the <code>target_modules</code> which determine where the smaller matrices are inserted. For this guide, you’ll target the <em>query</em> and <em>value</em> matrices of the attention blocks. Other important parameters to set are <code>lora_alpha</code> (scaling factor), <code>bias</code> (whether <code>none</code>, <code>all</code> or only the LoRA bias parameters should be trained), and <code>modules_to_save</code> (the modules apart from the LoRA layers to be trained and saved). All of these parameters - and more - are found in the <a href="/docs/peft/v0.17.0/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>.',i,p,M;return p=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QxNiUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycXVlcnklMjIlMkMlMjAlMjJ2YWx1ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kdWxlc190b19zYXZlJTNEJTVCJTIyY2xhc3NpZmllciUyMiU1RCUyQyUwQSklMEFtb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKG1vZGVsJTJDJTIwY29uZmlnKSUwQW1vZGVsLnByaW50X3RyYWluYWJsZV9wYXJhbWV0ZXJzKCklMEElMjJ0cmFpbmFibGUlMjBwYXJhbXMlM0ElMjA2NjclMkM0OTMlMjAlN0MlN0MlMjBhbGwlMjBwYXJhbXMlM0ElMjA4NiUyQzU0MyUyQzgxOCUyMCU3QyU3QyUyMHRyYWluYWJsZSUyNSUzQSUyMDAuNzcxMjc3NTA0NzY2NDI5NCUyMg==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">16</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    lora_dropout=<span class="hljs-number">0.1</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)
model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 667,493 || all params: 86,543,818 || trainable%: 0.7712775047664294&quot;</span>`,wrap:!1}}),{c(){s=U("p"),s.innerHTML=b,i=o(),c(p.$$.fragment)},l(n){s=w(n,"P",{"data-svelte-h":!0}),T(s)!=="svelte-knc248"&&(s.innerHTML=b),i=r(n),d(p.$$.fragment,n)},m(n,J){a(n,s,J),a(n,i,J),y(p,n,J),M=!0},p:be,i(n){M||(f(p.$$.fragment,n),M=!0)},o(n){h(p.$$.fragment,n),M=!1},d(n){n&&(l(s),l(i)),u(p,n)}}}function ll($){let s,b='<a href="../conceptual_guides/adapter#low-rank-hadamard-product-loha">LoHa</a> decomposes the weight update matrix into <em>four</em> smaller matrices and each pair of smaller matrices is combined with the Hadamard product. This allows the weight update matrix to keep the same number of trainable parameters when compared to LoRA, but with a higher rank (<code>r^2</code> for LoHA when compared to <code>2*r</code> for LoRA). The size of the smaller matrices is determined by its <em>rank</em> or <code>r</code>. You’ll also want to specify the <code>target_modules</code> which determines where the smaller matrices are inserted. For this guide, you’ll target the <em>query</em> and <em>value</em> matrices of the attention blocks. Other important parameters to set are <code>alpha</code> (scaling factor), and <code>modules_to_save</code> (the modules apart from the LoHa layers to be trained and saved). All of these parameters - and more - are found in the <a href="/docs/peft/v0.17.0/en/package_reference/loha#peft.LoHaConfig">LoHaConfig</a>.',i,p,M;return p=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb0hhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb0hhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGFscGhhJTNEMTYlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnF1ZXJ5JTIyJTJDJTIwJTIydmFsdWUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2R1bGVfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMmNsYXNzaWZpZXIlMjIlNUQlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwMSUyQzI1NyUyQzMxNyUyMCU3QyU3QyUyMGFsbCUyMHBhcmFtcyUzQSUyMDg3JTJDMTMzJTJDNjQyJTIwJTdDJTdDJTIwdHJhaW5hYmxlJTI1JTNBJTIwMS40NDI5NzUzNzc5ODMxNjc2JTIy",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoHaConfig, get_peft_model

config = LoHaConfig(
    r=<span class="hljs-number">16</span>,
    alpha=<span class="hljs-number">16</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    module_dropout=<span class="hljs-number">0.1</span>,
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)
model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 1,257,317 || all params: 87,133,642 || trainable%: 1.4429753779831676&quot;</span>`,wrap:!1}}),{c(){s=U("p"),s.innerHTML=b,i=o(),c(p.$$.fragment)},l(n){s=w(n,"P",{"data-svelte-h":!0}),T(s)!=="svelte-1ifxs19"&&(s.innerHTML=b),i=r(n),d(p.$$.fragment,n)},m(n,J){a(n,s,J),a(n,i,J),y(p,n,J),M=!0},p:be,i(n){M||(f(p.$$.fragment,n),M=!0)},o(n){h(p.$$.fragment,n),M=!1},d(n){n&&(l(s),l(i)),u(p,n)}}}function al($){let s,b='<a href="../conceptual_guides/adapter#low-rank-kronecker-product-lokr">LoKr</a> expresses the weight update matrix as a decomposition of a Kronecker product, creating a block matrix that is able to preserve the rank of the original weight matrix. The size of the smaller matrices are determined by its <em>rank</em> or <code>r</code>. You’ll also want to specify the <code>target_modules</code> which determines where the smaller matrices are inserted. For this guide, you’ll target the <em>query</em> and <em>value</em> matrices of the attention blocks. Other important parameters to set are <code>alpha</code> (scaling factor), and <code>modules_to_save</code> (the modules apart from the LoKr layers to be trained and saved). All of these parameters - and more - are found in the <a href="/docs/peft/v0.17.0/en/package_reference/lokr#peft.LoKrConfig">LoKrConfig</a>.',i,p,M;return p=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb0tyQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb0tyQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGFscGhhJTNEMTYlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnF1ZXJ5JTIyJTJDJTIwJTIydmFsdWUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2R1bGVfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMmNsYXNzaWZpZXIlMjIlNUQlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwMTE2JTJDMDY5JTIwJTdDJTdDJTIwYWxsJTIwcGFyYW1zJTNBJTIwODclMkMxNzIlMkMwNDIlMjAlN0MlN0MlMjB0cmFpbmFibGUlMjUlM0ElMjAwLjEzMzE0OTM0MTYyMDMzMjgyJTIy",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoKrConfig, get_peft_model

config = LoKrConfig(
    r=<span class="hljs-number">16</span>,
    alpha=<span class="hljs-number">16</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    module_dropout=<span class="hljs-number">0.1</span>,
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)
model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 116,069 || all params: 87,172,042 || trainable%: 0.13314934162033282&quot;</span>`,wrap:!1}}),{c(){s=U("p"),s.innerHTML=b,i=o(),c(p.$$.fragment)},l(n){s=w(n,"P",{"data-svelte-h":!0}),T(s)!=="svelte-1mvlwja"&&(s.innerHTML=b),i=r(n),d(p.$$.fragment,n)},m(n,J){a(n,s,J),a(n,i,J),y(p,n,J),M=!0},p:be,i(n){M||(f(p.$$.fragment,n),M=!0)},o(n){h(p.$$.fragment,n),M=!1},d(n){n&&(l(s),l(i)),u(p,n)}}}function sl($){let s,b='<a href="../conceptual_guides/adapter#adaptive-low-rank-adaptation-adalora">AdaLoRA</a> efficiently manages the LoRA parameter budget by assigning important weight matrices more parameters and pruning less important ones. In contrast, LoRA evenly distributes parameters across all modules. You can control the average desired <em>rank</em> or <code>r</code> of the matrices, and which modules to apply AdaLoRA to with <code>target_modules</code>. Other important parameters to set are <code>lora_alpha</code> (scaling factor), and <code>modules_to_save</code> (the modules apart from the AdaLoRA layers to be trained and saved). All of these parameters - and more - are found in the <a href="/docs/peft/v0.17.0/en/package_reference/adalora#peft.AdaLoraConfig">AdaLoraConfig</a>.',i,p,M;return p=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBBZGFMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBBZGFMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwaW5pdF9yJTNEMTIlMkMlMEElMjAlMjAlMjAlMjB0aW5pdCUzRDIwMCUyQyUwQSUyMCUyMCUyMCUyMHRmaW5hbCUzRDEwMDAlMkMlMEElMjAlMjAlMjAlMjBkZWx0YVQlM0QxMCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycXVlcnklMjIlMkMlMjAlMjJ2YWx1ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMmNsYXNzaWZpZXIlMjIlNUQlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwNTIwJTJDMzI1JTIwJTdDJTdDJTIwYWxsJTIwcGFyYW1zJTNBJTIwODclMkM2MTQlMkM3MjIlMjAlN0MlN0MlMjB0cmFpbmFibGUlMjUlM0ElMjAwLjU5Mzg3ODUwMzY2MDYwNjIlMjI=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> AdaLoraConfig, get_peft_model

config = AdaLoraConfig(
    r=<span class="hljs-number">8</span>,
    init_r=<span class="hljs-number">12</span>,
    tinit=<span class="hljs-number">200</span>,
    tfinal=<span class="hljs-number">1000</span>,
    deltaT=<span class="hljs-number">10</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)
model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 520,325 || all params: 87,614,722 || trainable%: 0.5938785036606062&quot;</span>`,wrap:!1}}),{c(){s=U("p"),s.innerHTML=b,i=o(),c(p.$$.fragment)},l(n){s=w(n,"P",{"data-svelte-h":!0}),T(s)!=="svelte-bsnabk"&&(s.innerHTML=b),i=r(n),d(p.$$.fragment,n)},m(n,J){a(n,s,J),a(n,i,J),y(p,n,J),M=!0},p:be,i(n){M||(f(p.$$.fragment,n),M=!0)},o(n){h(p.$$.fragment,n),M=!1},d(n){n&&(l(s),l(i)),u(p,n)}}}function nl($){let s,b,i,p,M,n,J,B;return s=new Jt({props:{id:"loras",option:"LoRA",$$slots:{default:[tl]},$$scope:{ctx:$}}}),i=new Jt({props:{id:"loras",option:"LoHa",$$slots:{default:[ll]},$$scope:{ctx:$}}}),M=new Jt({props:{id:"loras",option:"LoKr",$$slots:{default:[al]},$$scope:{ctx:$}}}),J=new Jt({props:{id:"loras",option:"AdaLoRA",$$slots:{default:[sl]},$$scope:{ctx:$}}}),{c(){c(s.$$.fragment),b=o(),c(i.$$.fragment),p=o(),c(M.$$.fragment),n=o(),c(J.$$.fragment)},l(m){d(s.$$.fragment,m),b=r(m),d(i.$$.fragment,m),p=r(m),d(M.$$.fragment,m),n=r(m),d(J.$$.fragment,m)},m(m,g){y(s,m,g),a(m,b,g),y(i,m,g),a(m,p,g),y(M,m,g),a(m,n,g),y(J,m,g),B=!0},p(m,g){const Te={};g&2&&(Te.$$scope={dirty:g,ctx:m}),s.$set(Te);const v={};g&2&&(v.$$scope={dirty:g,ctx:m}),i.$set(v);const C={};g&2&&(C.$$scope={dirty:g,ctx:m}),M.$set(C);const ge={};g&2&&(ge.$$scope={dirty:g,ctx:m}),J.$set(ge)},i(m){B||(f(s.$$.fragment,m),f(i.$$.fragment,m),f(M.$$.fragment,m),f(J.$$.fragment,m),B=!0)},o(m){h(s.$$.fragment,m),h(i.$$.fragment,m),h(M.$$.fragment,m),h(J.$$.fragment,m),B=!1},d(m){m&&(l(b),l(p),l(n)),u(s,m),u(i,m),u(M,m),u(J,m)}}}function ol($){let s,b='AdaLoRA has an <a href="/docs/peft/v0.17.0/en/package_reference/adalora#peft.AdaLoraModel.update_and_allocate">update_and_allocate()</a> method that should be called at each training step to update the parameter budget and mask, otherwise the adaptation step is not performed. This requires writing a custom training loop or subclassing the <code>Trainer</code> to incorporate this method. As an example, take a look at this <a href="https://github.com/huggingface/peft/blob/912ad41e96e03652cabf47522cd876076f7a0c4f/examples/conditional_generation/peft_adalora_seq2seq.py#L120" rel="nofollow">custom training loop</a>.';return{c(){s=U("p"),s.innerHTML=b},l(i){s=w(i,"P",{"data-svelte-h":!0}),T(s)!=="svelte-112yd2x"&&(s.innerHTML=b)},m(i,p){a(i,s,p)},p:be,d(i){i&&l(s)}}}function rl($){let s,b,i,p,M,n,J,B="A popular way to efficiently train large models is to insert (typically in the attention blocks) smaller trainable matrices that are a low-rank decomposition of the delta weight matrix to be learnt during finetuning. The pretrained model’s original weight matrix is frozen and only the smaller matrices are updated during training. This reduces the number of trainable parameters, reducing memory usage and training time which can be very expensive for large models.",m,g,Te='There are several different ways to express the weight matrix as a low-rank decomposition, but <a href="../conceptual_guides/adapter#low-rank-adaptation-lora">Low-Rank Adaptation (LoRA)</a> is the most common method. The PEFT library supports several other LoRA variants, such as <a href="../conceptual_guides/adapter#low-rank-hadamard-product-loha">Low-Rank Hadamard Product (LoHa)</a>, <a href="../conceptual_guides/adapter#low-rank-kronecker-product-lokr">Low-Rank Kronecker Product (LoKr)</a>, and <a href="../conceptual_guides/adapter#adaptive-low-rank-adaptation-adalora">Adaptive Low-Rank Adaptation (AdaLoRA)</a>. You can learn more about how these methods work conceptually in the <a href="../conceptual_guides/adapter">Adapters</a> guide. If you’re interested in applying these methods to other tasks and use cases like semantic segmentation, token classification, take a look at our <a href="https://huggingface.co/collections/PEFT/notebooks-6573b28b33e5a4bf5b157fc1" rel="nofollow">notebook collection</a>!',v,C,ge='Additionally, PEFT supports the <a href="../conceptual_guides/adapter#mixture-of-lora-experts-x-lora">X-LoRA</a> Mixture of LoRA Experts method.',$e,Q,bt="This guide will show you how to quickly train an image classification model - with a low-rank decomposition method - to identify the class of food shown in an image.",Ce,Z,Ze,R,Tt="Before you begin, make sure you have all the necessary libraries installed.",_e,G,Ie,X,ke,F,gt='In this guide, you’ll use the <a href="https://huggingface.co/datasets/food101" rel="nofollow">Food-101</a> dataset which contains images of 101 food classes (take a look at the <a href="https://huggingface.co/datasets/food101/viewer/default/train" rel="nofollow">dataset viewer</a> to get a better idea of what the dataset looks like).',We,Y,jt='Load the dataset with the <a href="https://huggingface.co/docs/datasets/v4.0.0/en/package_reference/loading_methods#datasets.load_dataset" rel="nofollow">load_dataset</a> function.',Be,A,ve,z,$t="Each food class is labeled with an integer, so to make it easier to understand what these integers represent, you’ll create a <code>label2id</code> and <code>id2label</code> dictionary to map the integer to its class label.",Qe,V,Re,x,Ct="Load an image processor to properly resize and normalize the pixel values of the training and evaluation images.",Ge,E,Xe,N,Zt="You can also use the image processor to prepare some transformation functions for data augmentation and pixel scaling.",Fe,H,Ye,L,_t='Define the training and validation datasets, and use the <a href="https://huggingface.co/docs/datasets/v4.0.0/en/package_reference/main_classes#datasets.Dataset.set_transform" rel="nofollow">set_transform</a> function to apply the transformations on-the-fly.',Ae,S,ze,q,It="Finally, you’ll need a data collator to create a batch of training and evaluation data and convert the labels to <code>torch.tensor</code> objects.",Ve,D,xe,P,Ee,K,kt='Now let’s load a pretrained model to use as the base model. This guide uses the <a href="https://huggingface.co/google/vit-base-patch16-224-in21k" rel="nofollow">google/vit-base-patch16-224-in21k</a> model, but you can use any image classification model you want. Pass the <code>label2id</code> and <code>id2label</code> dictionaries to the model so it knows how to map the integer labels to their class labels, and you can optionally pass the <code>ignore_mismatched_sizes=True</code> parameter if you’re finetuning a checkpoint that has already been finetuned.',Ne,O,He,ee,Le,te,Wt='Every PEFT method requires a configuration that holds all the parameters specifying how the PEFT method should be applied. Once the configuration is setup, pass it to the <a href="/docs/peft/v0.17.0/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function along with the base model to create a trainable <a href="/docs/peft/v0.17.0/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',Se,_,qe,I,De,le,Pe,ae,Bt="For training, let’s use the <code>Trainer</code> class from Transformers. The <code>Trainer</code> contains a PyTorch training loop, and when you’re ready, call <code>train</code> to start training. To customize the training run, configure the training hyperparameters in the <code>TrainingArguments</code> class. With LoRA-like methods, you can afford to use a higher batch size and learning rate.",Ke,k,Oe,se,et,ne,vt="Begin training with <code>train</code>.",tt,oe,lt,re,at,ie,Qt="Once training is complete, you can upload your model to the Hub with the <code>push_to_hub</code> method. You’ll need to login to your Hugging Face account first and enter your token when prompted.",st,pe,nt,me,Rt="Call <code>push_to_hub</code> to save your model to your repositoy.",ot,Me,rt,ce,it,de,Gt="Let’s load the model from the Hub and test it out on a food image.",pt,ye,mt,W,Xt='<img src="https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/beignets.jpeg"/>',Mt,fe,Ft="Convert the image to RGB and return the underlying PyTorch tensors.",ct,he,dt,ue,Yt="Now run the model and return the predicted class!",yt,Je,ft,Ue,ht,je,ut;return M=new we({props:{title:"LoRA methods",local:"lora-methods",headingTag:"h1"}}),Z=new wt({props:{$$slots:{default:[Ot]},$$scope:{ctx:$}}}),G=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwcGVmdCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRz",highlighted:"pip install -q peft transformers datasets",wrap:!1}}),X=new we({props:{title:"Dataset",local:"dataset",headingTag:"h2"}}),A=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZm9vZDEwMSUyMik=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

ds = load_dataset(<span class="hljs-string">&quot;food101&quot;</span>)`,wrap:!1}}),V=new j({props:{code:"bGFiZWxzJTIwJTNEJTIwZHMlNUIlMjJ0cmFpbiUyMiU1RC5mZWF0dXJlcyU1QiUyMmxhYmVsJTIyJTVELm5hbWVzJTBBbGFiZWwyaWQlMkMlMjBpZDJsYWJlbCUyMCUzRCUyMGRpY3QoKSUyQyUyMGRpY3QoKSUwQWZvciUyMGklMkMlMjBsYWJlbCUyMGluJTIwZW51bWVyYXRlKGxhYmVscyklM0ElMEElMjAlMjAlMjAlMjBsYWJlbDJpZCU1QmxhYmVsJTVEJTIwJTNEJTIwaSUwQSUyMCUyMCUyMCUyMGlkMmxhYmVsJTVCaSU1RCUyMCUzRCUyMGxhYmVsJTBBJTBBaWQybGFiZWwlNUIyJTVEJTBBJTIyYmFrbGF2YSUyMg==",highlighted:`labels = ds[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;label&quot;</span>].names
label2id, id2label = <span class="hljs-built_in">dict</span>(), <span class="hljs-built_in">dict</span>()
<span class="hljs-keyword">for</span> i, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(labels):
    label2id[label] = i
    id2label[i] = label

id2label[<span class="hljs-number">2</span>]
<span class="hljs-string">&quot;baklava&quot;</span>`,wrap:!1}}),E=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQtaW4yMWslMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224-in21k&quot;</span>)`,wrap:!1}}),H=new j({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQ2VudGVyQ3JvcCUyQyUwQSUyMCUyMCUyMCUyMENvbXBvc2UlMkMlMEElMjAlMjAlMjAlMjBOb3JtYWxpemUlMkMlMEElMjAlMjAlMjAlMjBSYW5kb21Ib3Jpem9udGFsRmxpcCUyQyUwQSUyMCUyMCUyMCUyMFJhbmRvbVJlc2l6ZWRDcm9wJTJDJTBBJTIwJTIwJTIwJTIwUmVzaXplJTJDJTBBJTIwJTIwJTIwJTIwVG9UZW5zb3IlMkMlMEEpJTBBJTBBbm9ybWFsaXplJTIwJTNEJTIwTm9ybWFsaXplKG1lYW4lM0RpbWFnZV9wcm9jZXNzb3IuaW1hZ2VfbWVhbiUyQyUyMHN0ZCUzRGltYWdlX3Byb2Nlc3Nvci5pbWFnZV9zdGQpJTBBdHJhaW5fdHJhbnNmb3JtcyUyMCUzRCUyMENvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwUmFuZG9tUmVzaXplZENyb3AoaW1hZ2VfcHJvY2Vzc29yLnNpemUlNUIlMjJoZWlnaHQlMjIlNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwUmFuZG9tSG9yaXpvbnRhbEZsaXAoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFRvVGVuc29yKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemUlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEpJTBBJTBBdmFsX3RyYW5zZm9ybXMlMjAlM0QlMjBDb21wb3NlKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFJlc2l6ZShpbWFnZV9wcm9jZXNzb3Iuc2l6ZSU1QiUyMmhlaWdodCUyMiU1RCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBDZW50ZXJDcm9wKGltYWdlX3Byb2Nlc3Nvci5zaXplJTVCJTIyaGVpZ2h0JTIyJTVEKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFRvVGVuc29yKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemUlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEpJTBBJTBBZGVmJTIwcHJlcHJvY2Vzc190cmFpbihleGFtcGxlX2JhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMGV4YW1wbGVfYmF0Y2glNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMjAlM0QlMjAlNUJ0cmFpbl90cmFuc2Zvcm1zKGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSklMjBmb3IlMjBpbWFnZSUyMGluJTIwZXhhbXBsZV9iYXRjaCU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZV9iYXRjaCUwQSUwQWRlZiUyMHByZXByb2Nlc3NfdmFsKGV4YW1wbGVfYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwZXhhbXBsZV9iYXRjaCU1QiUyMnBpeGVsX3ZhbHVlcyUyMiU1RCUyMCUzRCUyMCU1QnZhbF90cmFuc2Zvcm1zKGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSklMjBmb3IlMjBpbWFnZSUyMGluJTIwZXhhbXBsZV9iYXRjaCU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZV9iYXRjaA==",highlighted:`<span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> (
    CenterCrop,
    Compose,
    Normalize,
    RandomHorizontalFlip,
    RandomResizedCrop,
    Resize,
    ToTensor,
)

normalize = Normalize(mean=image_processor.image_mean, std=image_processor.image_std)
train_transforms = Compose(
    [
        RandomResizedCrop(image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]),
        RandomHorizontalFlip(),
        ToTensor(),
        normalize,
    ]
)

val_transforms = Compose(
    [
        Resize(image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]),
        CenterCrop(image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]),
        ToTensor(),
        normalize,
    ]
)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_train</span>(<span class="hljs-params">example_batch</span>):
    example_batch[<span class="hljs-string">&quot;pixel_values&quot;</span>] = [train_transforms(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
    <span class="hljs-keyword">return</span> example_batch

<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_val</span>(<span class="hljs-params">example_batch</span>):
    example_batch[<span class="hljs-string">&quot;pixel_values&quot;</span>] = [val_transforms(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
    <span class="hljs-keyword">return</span> example_batch`,wrap:!1}}),S=new j({props:{code:"dHJhaW5fZHMlMjAlM0QlMjBkcyU1QiUyMnRyYWluJTIyJTVEJTBBdmFsX2RzJTIwJTNEJTIwZHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTBBJTBBdHJhaW5fZHMuc2V0X3RyYW5zZm9ybShwcmVwcm9jZXNzX3RyYWluKSUwQXZhbF9kcy5zZXRfdHJhbnNmb3JtKHByZXByb2Nlc3NfdmFsKQ==",highlighted:`train_ds = ds[<span class="hljs-string">&quot;train&quot;</span>]
val_ds = ds[<span class="hljs-string">&quot;validation&quot;</span>]

train_ds.set_transform(preprocess_train)
val_ds.set_transform(preprocess_val)`,wrap:!1}}),D=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZWYlMjBjb2xsYXRlX2ZuKGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMHBpeGVsX3ZhbHVlcyUyMCUzRCUyMHRvcmNoLnN0YWNrKCU1QmV4YW1wbGUlNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMjBmb3IlMjBleGFtcGxlJTIwaW4lMjBleGFtcGxlcyU1RCklMEElMjAlMjAlMjAlMjBsYWJlbHMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCZXhhbXBsZSU1QiUyMmxhYmVsJTIyJTVEJTIwZm9yJTIwZXhhbXBsZSUyMGluJTIwZXhhbXBsZXMlNUQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIycGl4ZWxfdmFsdWVzJTIyJTNBJTIwcGl4ZWxfdmFsdWVzJTJDJTIwJTIybGFiZWxzJTIyJTNBJTIwbGFiZWxzJTdE",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">examples</span>):
    pixel_values = torch.stack([example[<span class="hljs-string">&quot;pixel_values&quot;</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples])
    labels = torch.tensor([example[<span class="hljs-string">&quot;label&quot;</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples])
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;pixel_values&quot;</span>: pixel_values, <span class="hljs-string">&quot;labels&quot;</span>: labels}`,wrap:!1}}),P=new we({props:{title:"Model",local:"model",headingTag:"h2"}}),O=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMkMlMjBUcmFpbmluZ0FyZ3VtZW50cyUyQyUyMFRyYWluZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0LWluMjFrJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCUyQyUwQSUyMCUyMCUyMCUyMGlkMmxhYmVsJTNEaWQybGFiZWwlMkMlMEElMjAlMjAlMjAlMjBpZ25vcmVfbWlzbWF0Y2hlZF9zaXplcyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification, TrainingArguments, Trainer

model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;google/vit-base-patch16-224-in21k&quot;</span>,
    label2id=label2id,
    id2label=id2label,
    ignore_mismatched_sizes=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),ee=new we({props:{title:"PEFT configuration and model",local:"peft-configuration-and-model",headingTag:"h3"}}),_=new wt({props:{$$slots:{default:[el]},$$scope:{ctx:$}}}),I=new Kt({props:{id:"loras",options:["LoRA","LoHa","LoKr","AdaLoRA"],$$slots:{default:[nl]},$$scope:{ctx:$}}}),le=new we({props:{title:"Training",local:"training",headingTag:"h3"}}),k=new wt({props:{warning:!0,$$slots:{default:[ol]},$$scope:{ctx:$}}}),se=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQSUwQWFjY291bnQlMjAlM0QlMjAlMjJzdGV2aGxpdSUyMiUwQXBlZnRfbW9kZWxfaWQlMjAlM0QlMjBmJTIyJTdCYWNjb3VudCU3RCUyRmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0LWluMjFrLWxvcmElMjIlMEFiYXRjaF9zaXplJTIwJTNEJTIwMTI4JTBBJTBBYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMHBlZnRfbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjByZW1vdmVfdW51c2VkX2NvbHVtbnMlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0Q1ZS0zJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDQlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX2V2YWxfYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0Q1JTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDEwJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9iZXN0X21vZGVsX2F0X2VuZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBsYWJlbF9uYW1lcyUzRCU1QiUyMmxhYmVscyUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer

account = <span class="hljs-string">&quot;stevhliu&quot;</span>
peft_model_id = <span class="hljs-string">f&quot;<span class="hljs-subst">{account}</span>/google/vit-base-patch16-224-in21k-lora&quot;</span>
batch_size = <span class="hljs-number">128</span>

args = TrainingArguments(
    peft_model_id,
    remove_unused_columns=<span class="hljs-literal">False</span>,
    eval_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">5e-3</span>,
    per_device_train_batch_size=batch_size,
    gradient_accumulation_steps=<span class="hljs-number">4</span>,
    per_device_eval_batch_size=batch_size,
    fp16=<span class="hljs-literal">True</span>,
    num_train_epochs=<span class="hljs-number">5</span>,
    logging_steps=<span class="hljs-number">10</span>,
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
)`,wrap:!1}}),oe=new j({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RzJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEdmFsX2RzJTJDJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc2luZ19jbGFzcyUzRGltYWdlX3Byb2Nlc3NvciUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRlX2ZuJTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`trainer = Trainer(
    model,
    args,
    train_dataset=train_ds,
    eval_dataset=val_ds,
    processing_class=image_processor,
    data_collator=collate_fn,
)
trainer.train()`,wrap:!1}}),re=new we({props:{title:"Share your model",local:"share-your-model",headingTag:"h2"}}),pe=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),Me=new j({props:{code:"bW9kZWwucHVzaF90b19odWIocGVmdF9tb2RlbF9pZCk=",highlighted:"model.push_to_hub(peft_model_id)",wrap:!1}}),ce=new we({props:{title:"Inference",local:"inference",headingTag:"h2"}}),ye=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0Q29uZmlnJTJDJTIwUGVmdE1vZGVsJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBY29uZmlnJTIwJTNEJTIwUGVmdENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyc3RldmhsaXUlMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNC1pbjIxay1sb3JhJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwY29uZmlnLmJhc2VfbW9kZWxfbmFtZV9vcl9wYXRoJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCUyQyUwQSUyMCUyMCUyMCUyMGlkMmxhYmVsJTNEaWQybGFiZWwlMkMlMEElMjAlMjAlMjAlMjBpZ25vcmVfbWlzbWF0Y2hlZF9zaXplcyUzRFRydWUlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsJTJDJTIwJTIyc3RldmhsaXUlMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNC1pbjIxay1sb3JhJTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRnNheWFrcGF1bCUyRnNhbXBsZS1kYXRhc2V0cyUyRnJlc29sdmUlMkZtYWluJTJGYmVpZ25ldHMuanBlZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWltYWdl",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftConfig, PeftModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

config = PeftConfig.from_pretrained(<span class="hljs-string">&quot;stevhliu/vit-base-patch16-224-in21k-lora&quot;</span>)
model = AutoModelForImageClassification.from_pretrained(
    config.base_model_name_or_path,
    label2id=label2id,
    id2label=id2label,
    ignore_mismatched_sizes=<span class="hljs-literal">True</span>,
)
model = PeftModel.from_pretrained(model, <span class="hljs-string">&quot;stevhliu/vit-base-patch16-224-in21k-lora&quot;</span>)

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/beignets.jpeg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
image`,wrap:!1}}),he=new j({props:{code:"ZW5jb2RpbmclMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UuY29udmVydCglMjJSR0IlMjIpJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'encoding = image_processor(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),Je=new j({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmVuY29kaW5nKSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkeCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KCUyMlByZWRpY3RlZCUyMGNsYXNzJTNBJTIyJTJDJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkeCU1RCklMEElMjJQcmVkaWN0ZWQlMjBjbGFzcyUzQSUyMGJlaWduZXRzJTIy",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model(**encoding)
    logits = outputs.logits

predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
<span class="hljs-string">&quot;Predicted class: beignets&quot;</span>`,wrap:!1}}),Ue=new Pt({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/task_guides/lora_based_methods.md"}}),{c(){s=U("meta"),b=o(),i=U("p"),p=o(),c(M.$$.fragment),n=o(),J=U("p"),J.textContent=B,m=o(),g=U("p"),g.innerHTML=Te,v=o(),C=U("p"),C.innerHTML=ge,$e=o(),Q=U("p"),Q.textContent=bt,Ce=o(),c(Z.$$.fragment),Ze=o(),R=U("p"),R.textContent=Tt,_e=o(),c(G.$$.fragment),Ie=o(),c(X.$$.fragment),ke=o(),F=U("p"),F.innerHTML=gt,We=o(),Y=U("p"),Y.innerHTML=jt,Be=o(),c(A.$$.fragment),ve=o(),z=U("p"),z.innerHTML=$t,Qe=o(),c(V.$$.fragment),Re=o(),x=U("p"),x.textContent=Ct,Ge=o(),c(E.$$.fragment),Xe=o(),N=U("p"),N.textContent=Zt,Fe=o(),c(H.$$.fragment),Ye=o(),L=U("p"),L.innerHTML=_t,Ae=o(),c(S.$$.fragment),ze=o(),q=U("p"),q.innerHTML=It,Ve=o(),c(D.$$.fragment),xe=o(),c(P.$$.fragment),Ee=o(),K=U("p"),K.innerHTML=kt,Ne=o(),c(O.$$.fragment),He=o(),c(ee.$$.fragment),Le=o(),te=U("p"),te.innerHTML=Wt,Se=o(),c(_.$$.fragment),qe=o(),c(I.$$.fragment),De=o(),c(le.$$.fragment),Pe=o(),ae=U("p"),ae.innerHTML=Bt,Ke=o(),c(k.$$.fragment),Oe=o(),c(se.$$.fragment),et=o(),ne=U("p"),ne.innerHTML=vt,tt=o(),c(oe.$$.fragment),lt=o(),c(re.$$.fragment),at=o(),ie=U("p"),ie.innerHTML=Qt,st=o(),c(pe.$$.fragment),nt=o(),me=U("p"),me.innerHTML=Rt,ot=o(),c(Me.$$.fragment),rt=o(),c(ce.$$.fragment),it=o(),de=U("p"),de.textContent=Gt,pt=o(),c(ye.$$.fragment),mt=o(),W=U("div"),W.innerHTML=Xt,Mt=o(),fe=U("p"),fe.textContent=Ft,ct=o(),c(he.$$.fragment),dt=o(),ue=U("p"),ue.textContent=Yt,yt=o(),c(Je.$$.fragment),ft=o(),c(Ue.$$.fragment),ht=o(),je=U("p"),this.h()},l(e){const t=qt("svelte-u9bgzb",document.head);s=w(t,"META",{name:!0,content:!0}),t.forEach(l),b=r(e),i=w(e,"P",{}),Et(i).forEach(l),p=r(e),d(M.$$.fragment,e),n=r(e),J=w(e,"P",{"data-svelte-h":!0}),T(J)!=="svelte-3c4mx2"&&(J.textContent=B),m=r(e),g=w(e,"P",{"data-svelte-h":!0}),T(g)!=="svelte-1mec8a1"&&(g.innerHTML=Te),v=r(e),C=w(e,"P",{"data-svelte-h":!0}),T(C)!=="svelte-wawyyc"&&(C.innerHTML=ge),$e=r(e),Q=w(e,"P",{"data-svelte-h":!0}),T(Q)!=="svelte-3yvnz9"&&(Q.textContent=bt),Ce=r(e),d(Z.$$.fragment,e),Ze=r(e),R=w(e,"P",{"data-svelte-h":!0}),T(R)!=="svelte-1rdzhb1"&&(R.textContent=Tt),_e=r(e),d(G.$$.fragment,e),Ie=r(e),d(X.$$.fragment,e),ke=r(e),F=w(e,"P",{"data-svelte-h":!0}),T(F)!=="svelte-l33v6t"&&(F.innerHTML=gt),We=r(e),Y=w(e,"P",{"data-svelte-h":!0}),T(Y)!=="svelte-fj7csq"&&(Y.innerHTML=jt),Be=r(e),d(A.$$.fragment,e),ve=r(e),z=w(e,"P",{"data-svelte-h":!0}),T(z)!=="svelte-1a5q7dy"&&(z.innerHTML=$t),Qe=r(e),d(V.$$.fragment,e),Re=r(e),x=w(e,"P",{"data-svelte-h":!0}),T(x)!=="svelte-13cytaa"&&(x.textContent=Ct),Ge=r(e),d(E.$$.fragment,e),Xe=r(e),N=w(e,"P",{"data-svelte-h":!0}),T(N)!=="svelte-1p1x6w4"&&(N.textContent=Zt),Fe=r(e),d(H.$$.fragment,e),Ye=r(e),L=w(e,"P",{"data-svelte-h":!0}),T(L)!=="svelte-1unssa4"&&(L.innerHTML=_t),Ae=r(e),d(S.$$.fragment,e),ze=r(e),q=w(e,"P",{"data-svelte-h":!0}),T(q)!=="svelte-mznco7"&&(q.innerHTML=It),Ve=r(e),d(D.$$.fragment,e),xe=r(e),d(P.$$.fragment,e),Ee=r(e),K=w(e,"P",{"data-svelte-h":!0}),T(K)!=="svelte-akpunr"&&(K.innerHTML=kt),Ne=r(e),d(O.$$.fragment,e),He=r(e),d(ee.$$.fragment,e),Le=r(e),te=w(e,"P",{"data-svelte-h":!0}),T(te)!=="svelte-ivsf8c"&&(te.innerHTML=Wt),Se=r(e),d(_.$$.fragment,e),qe=r(e),d(I.$$.fragment,e),De=r(e),d(le.$$.fragment,e),Pe=r(e),ae=w(e,"P",{"data-svelte-h":!0}),T(ae)!=="svelte-1irb22c"&&(ae.innerHTML=Bt),Ke=r(e),d(k.$$.fragment,e),Oe=r(e),d(se.$$.fragment,e),et=r(e),ne=w(e,"P",{"data-svelte-h":!0}),T(ne)!=="svelte-682im"&&(ne.innerHTML=vt),tt=r(e),d(oe.$$.fragment,e),lt=r(e),d(re.$$.fragment,e),at=r(e),ie=w(e,"P",{"data-svelte-h":!0}),T(ie)!=="svelte-1xwmp9h"&&(ie.innerHTML=Qt),st=r(e),d(pe.$$.fragment,e),nt=r(e),me=w(e,"P",{"data-svelte-h":!0}),T(me)!=="svelte-eu5v9l"&&(me.innerHTML=Rt),ot=r(e),d(Me.$$.fragment,e),rt=r(e),d(ce.$$.fragment,e),it=r(e),de=w(e,"P",{"data-svelte-h":!0}),T(de)!=="svelte-1whrqzq"&&(de.textContent=Gt),pt=r(e),d(ye.$$.fragment,e),mt=r(e),W=w(e,"DIV",{class:!0,"data-svelte-h":!0}),T(W)!=="svelte-sucph9"&&(W.innerHTML=Xt),Mt=r(e),fe=w(e,"P",{"data-svelte-h":!0}),T(fe)!=="svelte-1nlb27h"&&(fe.textContent=Ft),ct=r(e),d(he.$$.fragment,e),dt=r(e),ue=w(e,"P",{"data-svelte-h":!0}),T(ue)!=="svelte-1mvhoi"&&(ue.textContent=Yt),yt=r(e),d(Je.$$.fragment,e),ft=r(e),d(Ue.$$.fragment,e),ht=r(e),je=w(e,"P",{}),Et(je).forEach(l),this.h()},h(){Ut(s,"name","hf:doc:metadata"),Ut(s,"content",il),Ut(W,"class","flex justify-center")},m(e,t){Dt(document.head,s),a(e,b,t),a(e,i,t),a(e,p,t),y(M,e,t),a(e,n,t),a(e,J,t),a(e,m,t),a(e,g,t),a(e,v,t),a(e,C,t),a(e,$e,t),a(e,Q,t),a(e,Ce,t),y(Z,e,t),a(e,Ze,t),a(e,R,t),a(e,_e,t),y(G,e,t),a(e,Ie,t),y(X,e,t),a(e,ke,t),a(e,F,t),a(e,We,t),a(e,Y,t),a(e,Be,t),y(A,e,t),a(e,ve,t),a(e,z,t),a(e,Qe,t),y(V,e,t),a(e,Re,t),a(e,x,t),a(e,Ge,t),y(E,e,t),a(e,Xe,t),a(e,N,t),a(e,Fe,t),y(H,e,t),a(e,Ye,t),a(e,L,t),a(e,Ae,t),y(S,e,t),a(e,ze,t),a(e,q,t),a(e,Ve,t),y(D,e,t),a(e,xe,t),y(P,e,t),a(e,Ee,t),a(e,K,t),a(e,Ne,t),y(O,e,t),a(e,He,t),y(ee,e,t),a(e,Le,t),a(e,te,t),a(e,Se,t),y(_,e,t),a(e,qe,t),y(I,e,t),a(e,De,t),y(le,e,t),a(e,Pe,t),a(e,ae,t),a(e,Ke,t),y(k,e,t),a(e,Oe,t),y(se,e,t),a(e,et,t),a(e,ne,t),a(e,tt,t),y(oe,e,t),a(e,lt,t),y(re,e,t),a(e,at,t),a(e,ie,t),a(e,st,t),y(pe,e,t),a(e,nt,t),a(e,me,t),a(e,ot,t),y(Me,e,t),a(e,rt,t),y(ce,e,t),a(e,it,t),a(e,de,t),a(e,pt,t),y(ye,e,t),a(e,mt,t),a(e,W,t),a(e,Mt,t),a(e,fe,t),a(e,ct,t),y(he,e,t),a(e,dt,t),a(e,ue,t),a(e,yt,t),y(Je,e,t),a(e,ft,t),y(Ue,e,t),a(e,ht,t),a(e,je,t),ut=!0},p(e,[t]){const At={};t&2&&(At.$$scope={dirty:t,ctx:e}),Z.$set(At);const zt={};t&2&&(zt.$$scope={dirty:t,ctx:e}),_.$set(zt);const Vt={};t&2&&(Vt.$$scope={dirty:t,ctx:e}),I.$set(Vt);const xt={};t&2&&(xt.$$scope={dirty:t,ctx:e}),k.$set(xt)},i(e){ut||(f(M.$$.fragment,e),f(Z.$$.fragment,e),f(G.$$.fragment,e),f(X.$$.fragment,e),f(A.$$.fragment,e),f(V.$$.fragment,e),f(E.$$.fragment,e),f(H.$$.fragment,e),f(S.$$.fragment,e),f(D.$$.fragment,e),f(P.$$.fragment,e),f(O.$$.fragment,e),f(ee.$$.fragment,e),f(_.$$.fragment,e),f(I.$$.fragment,e),f(le.$$.fragment,e),f(k.$$.fragment,e),f(se.$$.fragment,e),f(oe.$$.fragment,e),f(re.$$.fragment,e),f(pe.$$.fragment,e),f(Me.$$.fragment,e),f(ce.$$.fragment,e),f(ye.$$.fragment,e),f(he.$$.fragment,e),f(Je.$$.fragment,e),f(Ue.$$.fragment,e),ut=!0)},o(e){h(M.$$.fragment,e),h(Z.$$.fragment,e),h(G.$$.fragment,e),h(X.$$.fragment,e),h(A.$$.fragment,e),h(V.$$.fragment,e),h(E.$$.fragment,e),h(H.$$.fragment,e),h(S.$$.fragment,e),h(D.$$.fragment,e),h(P.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(_.$$.fragment,e),h(I.$$.fragment,e),h(le.$$.fragment,e),h(k.$$.fragment,e),h(se.$$.fragment,e),h(oe.$$.fragment,e),h(re.$$.fragment,e),h(pe.$$.fragment,e),h(Me.$$.fragment,e),h(ce.$$.fragment,e),h(ye.$$.fragment,e),h(he.$$.fragment,e),h(Je.$$.fragment,e),h(Ue.$$.fragment,e),ut=!1},d(e){e&&(l(b),l(i),l(p),l(n),l(J),l(m),l(g),l(v),l(C),l($e),l(Q),l(Ce),l(Ze),l(R),l(_e),l(Ie),l(ke),l(F),l(We),l(Y),l(Be),l(ve),l(z),l(Qe),l(Re),l(x),l(Ge),l(Xe),l(N),l(Fe),l(Ye),l(L),l(Ae),l(ze),l(q),l(Ve),l(xe),l(Ee),l(K),l(Ne),l(He),l(Le),l(te),l(Se),l(qe),l(De),l(Pe),l(ae),l(Ke),l(Oe),l(et),l(ne),l(tt),l(lt),l(at),l(ie),l(st),l(nt),l(me),l(ot),l(rt),l(it),l(de),l(pt),l(mt),l(W),l(Mt),l(fe),l(ct),l(dt),l(ue),l(yt),l(ft),l(ht),l(je)),l(s),u(M,e),u(Z,e),u(G,e),u(X,e),u(A,e),u(V,e),u(E,e),u(H,e),u(S,e),u(D,e),u(P,e),u(O,e),u(ee,e),u(_,e),u(I,e),u(le,e),u(k,e),u(se,e),u(oe,e),u(re,e),u(pe,e),u(Me,e),u(ce,e),u(ye,e),u(he,e),u(Je,e),u(Ue,e)}}}const il='{"title":"LoRA methods","local":"lora-methods","sections":[{"title":"Dataset","local":"dataset","sections":[],"depth":2},{"title":"Model","local":"model","sections":[{"title":"PEFT configuration and model","local":"peft-configuration-and-model","sections":[],"depth":3},{"title":"Training","local":"training","sections":[],"depth":3}],"depth":2},{"title":"Share your model","local":"share-your-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function pl($){return Ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hl extends Lt{constructor(s){super(),St(this,s,pl,rl,Nt,{})}}export{hl as component};
