import{s as lt,n as it,o as nt}from"../chunks/scheduler.c57aa7ef.js";import{S as st,i as at,g as s,s as i,r as c,A as rt,h as a,f as o,c as n,j as tt,u as m,x as r,k as $e,y as ct,a as l,v as f,d,t as p,w as u}from"../chunks/index.394f8801.js";import{C as ot}from"../chunks/CodeBlock.b5488637.js";import{H as T,E as mt}from"../chunks/getInferenceSnippets.54bf47f2.js";function ft(Oe){let b,P,L,D,g,K,M,ze='This conceptual guide gives a brief overview of <a href="https://huggingface.co/papers/2306.07280" rel="nofollow">OFT</a>, <a href="https://www.arxiv.org/abs/2506.19847" rel="nofollow">OFTv2</a> and <a href="https://huggingface.co/papers/2311.06243" rel="nofollow">BOFT</a>, a parameter-efficient fine-tuning technique that utilizes orthogonal matrix to multiplicatively transform the pretrained weight matrices.',ee,w,Ie="To achieve efficient fine-tuning, OFT represents the weight updates with an orthogonal transformation. The orthogonal transformation is parameterized by an orthogonal matrix multiplied to the pretrained weight matrix. These new matrices can be trained to adapt to the new data while keeping the overall number of changes low. The original weight matrix remains frozen and doesn’t receive any further adjustments. To produce the final results, both the original and the adapted weights are multiplied togethor.",te,_,Ze="Orthogonal Butterfly (BOFT) generalizes OFT with Butterfly factorization and further improves its parameter efficiency and finetuning flexibility. In short, OFT can be viewed as a special case of BOFT. Different from LoRA that uses additive low-rank weight updates, BOFT uses multiplicative orthogonal weight updates. The comparison is shown below.",oe,h,Re='<img src="https://raw.githubusercontent.com/wy1iu/butterfly-oft/main/assets/BOFT_comparison.png"/>',le,J,We="BOFT has some advantages compared to LoRA:",ie,F,Ee='<li>BOFT proposes a simple yet generic way to finetune pretrained models to downstream tasks, yielding a better preservation of pretraining knowledge and a better parameter efficiency.</li> <li>Through the orthogonality, BOFT introduces a structural constraint, i.e., keeping the <a href="https://huggingface.co/papers/1805.09298" rel="nofollow">hyperspherical energy</a> unchanged during finetuning. This can effectively reduce the forgetting of pretraining knowledge.</li> <li>BOFT uses the butterfly factorization to efficiently parameterize the orthogonal matrix, which yields a compact yet expressive learning space (i.e., hypothesis class).</li> <li>The sparse matrix decomposition in BOFT brings in additional inductive biases that are beneficial to generalization.</li>',ne,U,qe="In principle, BOFT can be applied to any subset of weight matrices in a neural network to reduce the number of trainable parameters. Given the target layers for injecting BOFT parameters, the number of trainable parameters can be determined based on the size of the weight matrices.",se,C,ae,B,Ae="Similar to LoRA, the weights learned by OFT/BOFT can be integrated into the pretrained weight matrices using the merge_and_unload() function. This function merges the adapter weights with the base model which allows you to effectively use the newly merged model as a standalone model.",re,y,Xe='<img src="https://raw.githubusercontent.com/wy1iu/butterfly-oft/main/assets/boft_merge.png"/>',ce,j,Ge="This works because during training, the orthogonal weight matrix (R in the diagram above) and the pretrained weight matrices are separate. But once training is complete, these weights can actually be merged (multiplied) into a new weight matrix that is equivalent.",me,v,fe,k,de,x,Qe="As with other methods supported by PEFT, to fine-tune a model using OFT or BOFT, you need to:",pe,$,He="<li>Instantiate a base model.</li> <li>Create a configuration (<code>OFTConfig</code> or <code>BOFTConfig</code>) where you define OFT/BOFT-specific parameters.</li> <li>Wrap the base model with <code>get_peft_model()</code> to get a trainable <code>PeftModel</code>.</li> <li>Train the <code>PeftModel</code> as you normally would train the base model.</li>",ue,O,be,z,Ne="<code>OFTConfig</code> allows you to control how OFT is applied to the base model through the following parameters:",he,I,Se="<li><code>r</code>: OFT rank, number of OFT blocks per injected layer. <strong>Bigger</strong> <code>r</code> results in more sparse update matrices with <strong>fewer</strong> trainable paramters. <strong>Note</strong>: You can only specify either <code>r</code> or <code>oft_block_size</code>, but not both simultaneously, because <code>r</code> × <code>oft_block_size</code> = layer dimension. For simplicity, we let the user speficy either <code>r</code> or <code>oft_block_size</code> and infer the other one. Default set to <code>r = 0</code>, the user is advised to set the <code>oft_block_size</code> instead for better clarity.</li> <li><code>oft_block_size</code>: OFT block size across different layers. <strong>Bigger</strong> <code>oft_block_size</code> results in more dense update matrices with <strong>more</strong> trainable parameters. <strong>Note</strong>: Please choose <code>oft_block_size</code> to be divisible by layer’s input dimension (<code>in_features</code>), e.g., 4, 8, 16. You can only specify either <code>r</code> or <code>oft_block_size</code>, but not both simultaneously, because <code>r</code> × <code>oft_block_size</code> = layer dimension. For simplicity, we let the user speficy either <code>r</code> or <code>oft_block_size</code> and infer the other one. Default set to <code>oft_block_size = 32</code>.</li> <li><code>use_cayley_neumann</code>: Specifies whether to use the Cayley-Neumann parameterization (efficient but approximate) or the vanilla Cayley parameterization (exact but computationally expensive because of matrix inverse). We recommend to set it to <code>True</code> for better efficiency, but performance may be slightly worse because of the approximation error. Please test both settings (<code>True</code> and <code>False</code>) depending on your needs. Default is <code>False</code>.</li> <li><code>module_dropout</code>: The multiplicative dropout probability, by setting OFT blocks to identity during training, similar to the dropout layer in LoRA.</li> <li><code>bias</code>: specify if the <code>bias</code> parameters should be trained. Can be <code>&quot;none&quot;</code>, <code>&quot;all&quot;</code> or <code>&quot;oft_only&quot;</code>.</li> <li><code>target_modules</code>: The modules (for example, attention blocks) to inject the OFT matrices.</li> <li><code>modules_to_save</code>: List of modules apart from OFT matrices to be set as trainable and saved in the final checkpoint. These typically include model’s custom head that is randomly initialized for the fine-tuning task.</li>",ye,Z,Te,R,Ve="<code>BOFTConfig</code> allows you to control how BOFT is applied to the base model through the following parameters:",ge,W,Le=`<li><code>boft_block_size</code>: the BOFT matrix block size across different layers, expressed in <code>int</code>. <strong>Bigger</strong> <code>boft_block_size</code> results in more dense update matrices with <strong>more</strong> trainable parameters. <strong>Note</strong>, please choose <code>boft_block_size</code> to be divisible by most layer’s input dimension (<code>in_features</code>), e.g., 4, 8, 16. Also, please only
specify either <code>boft_block_size</code> or <code>boft_block_num</code>, but not both simultaneously or leaving both to 0, because <code>boft_block_size</code> x <code>boft_block_num</code> must equal the layer’s input dimension.</li> <li><code>boft_block_num</code>: the number of BOFT matrix blocks across different layers, expressed in <code>int</code>. <strong>Bigger</strong> <code>boft_block_num</code> result in sparser update matrices with <strong>fewer</strong> trainable parameters. <strong>Note</strong>, please choose <code>boft_block_num</code> to be divisible by most layer’s input dimension (<code>in_features</code>), e.g., 4, 8, 16. Also, please only
specify either <code>boft_block_size</code> or <code>boft_block_num</code>, but not both simultaneously or leaving both to 0, because <code>boft_block_size</code> x <code>boft_block_num</code> must equal the layer’s input dimension.</li> <li><code>boft_n_butterfly_factor</code>: the number of butterfly factors. <strong>Note</strong>, for <code>boft_n_butterfly_factor=1</code>, BOFT is the same as vanilla OFT, for <code>boft_n_butterfly_factor=2</code>, the effective block size of OFT becomes twice as big and the number of blocks become half.</li> <li><code>bias</code>: specify if the <code>bias</code> parameters should be trained. Can be <code>&quot;none&quot;</code>, <code>&quot;all&quot;</code> or <code>&quot;boft_only&quot;</code>.</li> <li><code>boft_dropout</code>: specify the probability of multiplicative dropout.</li> <li><code>target_modules</code>: The modules (for example, attention blocks) to inject the OFT/BOFT matrices.</li> <li><code>modules_to_save</code>: List of modules apart from OFT/BOFT matrices to be set as trainable and saved in the final checkpoint. These typically include model’s custom head that is randomly initialized for the fine-tuning task.</li>`,Me,E,we,q,Ye='For using OFT for quantized finetuning with <a href="https://github.com/huggingface/trl" rel="nofollow">TRL</a> for <code>SFT</code>, <code>PPO</code>, or <code>DPO</code> fine-tuning, follow the following outline:',_e,A,Je,X,Fe,G,Pe="For an example of the BOFT method application to various downstream tasks, please refer to the following guides:",Ue,Q,De="Take a look at the following step-by-step guides on how to finetune a model with BOFT:",Ce,H,Ke='<li><a href="https://github.com/huggingface/peft/blob/main/examples/boft_dreambooth/boft_dreambooth.md" rel="nofollow">Dreambooth finetuning with BOFT</a></li> <li><a href="https://github.com/huggingface/peft/blob/main/examples/boft_controlnet/boft_controlnet.md" rel="nofollow">Controllable generation finetuning with BOFT (ControlNet)</a></li>',Be,N,et="For the task of image classification, one can initialize the BOFT config for a DinoV2 model as follows:",je,S,ve,V,ke,Y,xe;return g=new T({props:{title:"Orthogonal Finetuning (OFT and BOFT)",local:"orthogonal-finetuning-oft-and-boft",headingTag:"h1"}}),C=new T({props:{title:"Merge OFT/BOFT weights into the base model",local:"merge-oftboft-weights-into-the-base-model",headingTag:"h2"}}),v=new T({props:{title:"Utils for OFT / BOFT",local:"utils-for-oft--boft",headingTag:"h2"}}),k=new T({props:{title:"Common OFT / BOFT parameters in PEFT",local:"common-oft--boft-parameters-in-peft",headingTag:"h3"}}),O=new T({props:{title:"OFT-specific parameters",local:"oft-specific-parameters",headingTag:"h3"}}),Z=new T({props:{title:"BOFT-specific parameters",local:"boft-specific-parameters",headingTag:"h3"}}),E=new T({props:{title:"OFT Example Usage",local:"oft-example-usage",headingTag:"h2"}}),A=new ot({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRUcmFpbmVyJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBPRlRDb25maWclMEElMEFpZiUyMHVzZV9xdWFudGl6YXRpb24lM0ElMEElMjAlMjAlMjAlMjBibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF9zdG9yYWdlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjApJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybW9kZWxfbmFtZSUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RibmJfY29uZmlnJTBBKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1vZGVsX25hbWUlMjIpJTBBJTBBJTIzJTIwQ29uZmlndXJlJTIwT0ZUJTBBcGVmdF9jb25maWclMjAlM0QlMjBPRlRDb25maWcoJTBBJTIwJTIwJTIwJTIwb2Z0X2Jsb2NrX3NpemUlM0QzMiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9jYXlsZXlfbmV1bWFubiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjBiaWFzJTNEJTIybm9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRCUyMkNBVVNBTF9MTSUyMiUwQSklMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRzJTVCJ3RyYWluJyU1RCUyQyUwQSUyMCUyMCUyMCUyMHBlZnRfY29uZmlnJTNEcGVmdF9jb25maWclMkMlMEElMjAlMjAlMjAlMjBwcm9jZXNzaW5nX2NsYXNzJTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3VtZW50cyUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRvciUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> OFTConfig

<span class="hljs-keyword">if</span> use_quantization:
    bnb_config = BitsAndBytesConfig(
        load_in_4bit=<span class="hljs-literal">True</span>,
        bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
        bnb_4bit_compute_dtype=torch.bfloat16,
        bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
        bnb_4bit_quant_storage=torch.bfloat16,
    )

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;model_name&quot;</span>, 
    quantization_config=bnb_config
)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;model_name&quot;</span>)

<span class="hljs-comment"># Configure OFT</span>
peft_config = OFTConfig(
    oft_block_size=<span class="hljs-number">32</span>,
    use_cayley_neumann=<span class="hljs-literal">True</span>,
    target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)

trainer = SFTTrainer(
    model=model,
    train_dataset=ds[<span class="hljs-string">&#x27;train&#x27;</span>],
    peft_config=peft_config,
    processing_class=tokenizer,
    args=training_arguments,
    data_collator=collator,
)

trainer.train()`,wrap:!1}}),X=new T({props:{title:"BOFT Example Usage",local:"boft-example-usage",headingTag:"h2"}}),S=new ot({props:{code:"aW1wb3J0JTIwdHJhbnNmb3JtZXJzJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTSUyQyUyMEJPRlRDb25maWclMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMEJPRlRDb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQWNvbmZpZyUyMCUzRCUyMEJPRlRDb25maWcoJTBBJTIwJTIwJTIwJTIwYm9mdF9ibG9ja19zaXplJTNENCUyQyUwQSUyMCUyMCUyMCUyMGJvZnRfbl9idXR0ZXJmbHlfZmFjdG9yJTNEMiUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycXVlcnklMjIlMkMlMjAlMjJ2YWx1ZSUyMiUyQyUyMCUyMmtleSUyMiUyQyUyMCUyMm91dHB1dC5kZW5zZSUyMiUyQyUyMCUyMm1scC5mYzElMjIlMkMlMjAlMjJtbHAuZmMyJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwYm9mdF9kcm9wb3V0JTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMmJvZnRfb25seSUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMmNsYXNzaWZpZXIlMjIlNUQlMkMlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjB0cmFuc2Zvcm1lcnMuRGlub3YyRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZmFjZWJvb2slMkZkaW5vdjItbGFyZ2UlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fbGFiZWxzJTNEMTAwJTJDJTBBKSUwQSUwQWJvZnRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">import</span> transformers
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSeq2SeqLM, BOFTConfig
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> BOFTConfig, get_peft_model

config = BOFTConfig(
    boft_block_size=<span class="hljs-number">4</span>,
    boft_n_butterfly_factor=<span class="hljs-number">2</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>, <span class="hljs-string">&quot;key&quot;</span>, <span class="hljs-string">&quot;output.dense&quot;</span>, <span class="hljs-string">&quot;mlp.fc1&quot;</span>, <span class="hljs-string">&quot;mlp.fc2&quot;</span>],
    boft_dropout=<span class="hljs-number">0.1</span>,
    bias=<span class="hljs-string">&quot;boft_only&quot;</span>,
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)

model = transformers.Dinov2ForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;facebook/dinov2-large&quot;</span>,
    num_labels=<span class="hljs-number">100</span>,
)

boft_model = get_peft_model(model, config)`,wrap:!1}}),V=new mt({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/conceptual_guides/oft.md"}}),{c(){b=s("meta"),P=i(),L=s("p"),D=i(),c(g.$$.fragment),K=i(),M=s("p"),M.innerHTML=ze,ee=i(),w=s("p"),w.textContent=Ie,te=i(),_=s("p"),_.textContent=Ze,oe=i(),h=s("div"),h.innerHTML=Re,le=i(),J=s("p"),J.textContent=We,ie=i(),F=s("ul"),F.innerHTML=Ee,ne=i(),U=s("p"),U.textContent=qe,se=i(),c(C.$$.fragment),ae=i(),B=s("p"),B.textContent=Ae,re=i(),y=s("div"),y.innerHTML=Xe,ce=i(),j=s("p"),j.textContent=Ge,me=i(),c(v.$$.fragment),fe=i(),c(k.$$.fragment),de=i(),x=s("p"),x.textContent=Qe,pe=i(),$=s("ol"),$.innerHTML=He,ue=i(),c(O.$$.fragment),be=i(),z=s("p"),z.innerHTML=Ne,he=i(),I=s("ul"),I.innerHTML=Se,ye=i(),c(Z.$$.fragment),Te=i(),R=s("p"),R.innerHTML=Ve,ge=i(),W=s("ul"),W.innerHTML=Le,Me=i(),c(E.$$.fragment),we=i(),q=s("p"),q.innerHTML=Ye,_e=i(),c(A.$$.fragment),Je=i(),c(X.$$.fragment),Fe=i(),G=s("p"),G.textContent=Pe,Ue=i(),Q=s("p"),Q.textContent=De,Ce=i(),H=s("ul"),H.innerHTML=Ke,Be=i(),N=s("p"),N.textContent=et,je=i(),c(S.$$.fragment),ve=i(),c(V.$$.fragment),ke=i(),Y=s("p"),this.h()},l(e){const t=rt("svelte-u9bgzb",document.head);b=a(t,"META",{name:!0,content:!0}),t.forEach(o),P=n(e),L=a(e,"P",{}),tt(L).forEach(o),D=n(e),m(g.$$.fragment,e),K=n(e),M=a(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-1ip40zx"&&(M.innerHTML=ze),ee=n(e),w=a(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-91fr84"&&(w.textContent=Ie),te=n(e),_=a(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-lal94n"&&(_.textContent=Ze),oe=n(e),h=a(e,"DIV",{class:!0,"data-svelte-h":!0}),r(h)!=="svelte-1veppqu"&&(h.innerHTML=Re),le=n(e),J=a(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1dyux9"&&(J.textContent=We),ie=n(e),F=a(e,"UL",{"data-svelte-h":!0}),r(F)!=="svelte-1tn8i92"&&(F.innerHTML=Ee),ne=n(e),U=a(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-18dbsba"&&(U.textContent=qe),se=n(e),m(C.$$.fragment,e),ae=n(e),B=a(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-10xuh5x"&&(B.textContent=Ae),re=n(e),y=a(e,"DIV",{class:!0,"data-svelte-h":!0}),r(y)!=="svelte-1a4qpj5"&&(y.innerHTML=Xe),ce=n(e),j=a(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-6kbdta"&&(j.textContent=Ge),me=n(e),m(v.$$.fragment,e),fe=n(e),m(k.$$.fragment,e),de=n(e),x=a(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-qq3gtj"&&(x.textContent=Qe),pe=n(e),$=a(e,"OL",{"data-svelte-h":!0}),r($)!=="svelte-psegni"&&($.innerHTML=He),ue=n(e),m(O.$$.fragment,e),be=n(e),z=a(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-19hbjqq"&&(z.innerHTML=Ne),he=n(e),I=a(e,"UL",{"data-svelte-h":!0}),r(I)!=="svelte-zsxfpf"&&(I.innerHTML=Se),ye=n(e),m(Z.$$.fragment,e),Te=n(e),R=a(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1wxeuea"&&(R.innerHTML=Ve),ge=n(e),W=a(e,"UL",{"data-svelte-h":!0}),r(W)!=="svelte-1u1opeo"&&(W.innerHTML=Le),Me=n(e),m(E.$$.fragment,e),we=n(e),q=a(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1or7048"&&(q.innerHTML=Ye),_e=n(e),m(A.$$.fragment,e),Je=n(e),m(X.$$.fragment,e),Fe=n(e),G=a(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1py8k9k"&&(G.textContent=Pe),Ue=n(e),Q=a(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-5zw2dt"&&(Q.textContent=De),Ce=n(e),H=a(e,"UL",{"data-svelte-h":!0}),r(H)!=="svelte-yv73mp"&&(H.innerHTML=Ke),Be=n(e),N=a(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-9y5ksw"&&(N.textContent=et),je=n(e),m(S.$$.fragment,e),ve=n(e),m(V.$$.fragment,e),ke=n(e),Y=a(e,"P",{}),tt(Y).forEach(o),this.h()},h(){$e(b,"name","hf:doc:metadata"),$e(b,"content",dt),$e(h,"class","flex justify-center"),$e(y,"class","flex justify-center")},m(e,t){ct(document.head,b),l(e,P,t),l(e,L,t),l(e,D,t),f(g,e,t),l(e,K,t),l(e,M,t),l(e,ee,t),l(e,w,t),l(e,te,t),l(e,_,t),l(e,oe,t),l(e,h,t),l(e,le,t),l(e,J,t),l(e,ie,t),l(e,F,t),l(e,ne,t),l(e,U,t),l(e,se,t),f(C,e,t),l(e,ae,t),l(e,B,t),l(e,re,t),l(e,y,t),l(e,ce,t),l(e,j,t),l(e,me,t),f(v,e,t),l(e,fe,t),f(k,e,t),l(e,de,t),l(e,x,t),l(e,pe,t),l(e,$,t),l(e,ue,t),f(O,e,t),l(e,be,t),l(e,z,t),l(e,he,t),l(e,I,t),l(e,ye,t),f(Z,e,t),l(e,Te,t),l(e,R,t),l(e,ge,t),l(e,W,t),l(e,Me,t),f(E,e,t),l(e,we,t),l(e,q,t),l(e,_e,t),f(A,e,t),l(e,Je,t),f(X,e,t),l(e,Fe,t),l(e,G,t),l(e,Ue,t),l(e,Q,t),l(e,Ce,t),l(e,H,t),l(e,Be,t),l(e,N,t),l(e,je,t),f(S,e,t),l(e,ve,t),f(V,e,t),l(e,ke,t),l(e,Y,t),xe=!0},p:it,i(e){xe||(d(g.$$.fragment,e),d(C.$$.fragment,e),d(v.$$.fragment,e),d(k.$$.fragment,e),d(O.$$.fragment,e),d(Z.$$.fragment,e),d(E.$$.fragment,e),d(A.$$.fragment,e),d(X.$$.fragment,e),d(S.$$.fragment,e),d(V.$$.fragment,e),xe=!0)},o(e){p(g.$$.fragment,e),p(C.$$.fragment,e),p(v.$$.fragment,e),p(k.$$.fragment,e),p(O.$$.fragment,e),p(Z.$$.fragment,e),p(E.$$.fragment,e),p(A.$$.fragment,e),p(X.$$.fragment,e),p(S.$$.fragment,e),p(V.$$.fragment,e),xe=!1},d(e){e&&(o(P),o(L),o(D),o(K),o(M),o(ee),o(w),o(te),o(_),o(oe),o(h),o(le),o(J),o(ie),o(F),o(ne),o(U),o(se),o(ae),o(B),o(re),o(y),o(ce),o(j),o(me),o(fe),o(de),o(x),o(pe),o($),o(ue),o(be),o(z),o(he),o(I),o(ye),o(Te),o(R),o(ge),o(W),o(Me),o(we),o(q),o(_e),o(Je),o(Fe),o(G),o(Ue),o(Q),o(Ce),o(H),o(Be),o(N),o(je),o(ve),o(ke),o(Y)),o(b),u(g,e),u(C,e),u(v,e),u(k,e),u(O,e),u(Z,e),u(E,e),u(A,e),u(X,e),u(S,e),u(V,e)}}}const dt='{"title":"Orthogonal Finetuning (OFT and BOFT)","local":"orthogonal-finetuning-oft-and-boft","sections":[{"title":"Merge OFT/BOFT weights into the base model","local":"merge-oftboft-weights-into-the-base-model","sections":[],"depth":2},{"title":"Utils for OFT / BOFT","local":"utils-for-oft--boft","sections":[{"title":"Common OFT / BOFT parameters in PEFT","local":"common-oft--boft-parameters-in-peft","sections":[],"depth":3},{"title":"OFT-specific parameters","local":"oft-specific-parameters","sections":[],"depth":3},{"title":"BOFT-specific parameters","local":"boft-specific-parameters","sections":[],"depth":3}],"depth":2},{"title":"OFT Example Usage","local":"oft-example-usage","sections":[],"depth":2},{"title":"BOFT Example Usage","local":"boft-example-usage","sections":[],"depth":2}],"depth":1}';function pt(Oe){return nt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tt extends st{constructor(b){super(),at(this,b,pt,ft,lt,{})}}export{Tt as component};
