import{s as rd,f as g,n as hd,o as pd}from"../chunks/scheduler.37c15a92.js";import{S as ud,i as md,g as a,s as i,u as m,m as jh,A as cd,h as s,f as t,c as o,j as u,v as c,y as r,n as Uh,k as h,o as p,a as n,w as d,d as M,t as f,x as v}from"../chunks/index.b01106c0.js";import{I as y}from"../chunks/IconCopyLink.77b762b4.js";import{C as w}from"../chunks/CodeBlock.00a4ae02.js";import{C as dd}from"../chunks/CourseFloatingBanner.9c5d96ce.js";function Md(Kh){let b,ss,Ia,is,T,D,ka,xe,Jh,ta,ep="Train your first Deep Reinforcement Learning Agent 🤖",os,Ie,rs,ke,tp=`Now that you’ve studied the bases of Reinforcement Learning, you’re ready to train your first agent and share it with the community through the Hub 🔥:
A Lunar Lander agent that will learn to land correctly on the Moon 🌕`,hs,$e,lp,ps,Ze,np="And finally, you’ll <strong>upload this trained agent to the Hugging Face Hub 🤗, a free, open platform where people can share ML models, datasets, and demos.</strong>",us,Be,ap='Thanks to our <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard">leaderboard</a>, you’ll be able to compare your results with other classmates and exchange the best practices to improve your agent’s scores. Who will win the challenge for Unit 1 🏆?',ms,He,sp='To validate this hands-on for the <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">certification process</a>, you need to push your trained model to the Hub and <strong>get a result of &gt;= 200</strong>.',cs,We,ip='To find your result, go to the <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">leaderboard</a> and find your model, <strong>the result = mean_reward - std of reward</strong>',ds,Le,op="<strong>If you don’t find your model, go to the bottom of the page and click on the refresh button.</strong>",Ms,Ge,rp='For more information about the certification process, check this section 👉 <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process</a>',fs,Ee,hp='And you can check your progress here 👉 <a href="https://huggingface.co/spaces/ThomasSimonini/Check-my-progress-Deep-RL-Course" rel="nofollow">https://huggingface.co/spaces/ThomasSimonini/Check-my-progress-Deep-RL-Course</a>',vs,Re,pp="So let’s get started! 🚀",ys,Se,up="<strong>To start the hands-on click on Open In Colab button</strong> 👇 :",ws,Ye,mp='<a href="https://colab.research.google.com/github/huggingface/deep-rl-class/blob/master/notebooks/unit1/unit1.ipynb" rel="nofollow"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a>',gs,Xe,cp="We strongly <strong>recommend students use Google Colab for the hands-on exercises</strong> instead of running them on their personal computers.",bs,Ve,dp="By using Google Colab, <strong>you can focus on learning and experimenting without worrying about the technical aspects</strong> of setting up your environments.",Ts,j,q,$a,Ae,Ch,la,Mp="Unit 1: Train your first Deep Reinforcement Learning Agent 🤖",js,O,fp,Us,Pe,vp='In this notebook, you’ll train your <strong>first Deep Reinforcement Learning agent</strong> a Lunar Lander agent that will learn to <strong>land correctly on the Moon 🌕</strong>. Using <a href="https://stable-baselines3.readthedocs.io/en/master/" rel="nofollow">Stable-Baselines3</a> a Deep Reinforcement Learning library, share them with the community, and experiment with different configurations',Js,U,K,Za,Fe,_h,na,yp="The environment 🎮",Cs,Qe,wp='<li><a href="https://gymnasium.farama.org/environments/box2d/lunar_lander/" rel="nofollow">LunarLander-v2</a></li>',_s,J,ee,Ba,Ne,xh,aa,gp="The library used 📚",xs,ze,bp='<li><a href="https://stable-baselines3.readthedocs.io/en/master/" rel="nofollow">Stable-Baselines3</a></li>',Is,De,Tp='We’re constantly trying to improve our tutorials, so <strong>if you find some issues in this notebook</strong>, please <a href="https://github.com/huggingface/deep-rl-class/issues" rel="nofollow">open an issue on the Github Repo</a>.',ks,C,te,Ha,qe,Ih,sa,jp="Objectives of this notebook 🏆",$s,Oe,Up="At the end of the notebook, you will:",Zs,Ke,Jp="<li>Be able to use <strong>Gymnasium</strong>, the environment library.</li> <li>Be able to use <strong>Stable-Baselines3</strong>, the deep reinforcement learning library.</li> <li>Be able to <strong>push your trained agent to the Hub</strong> with a nice video replay and an evaluation score 🔥.</li>",Bs,_,le,Wa,et,kh,ia,Cp="This notebook is from Deep Reinforcement Learning Course",Hs,tt,_p,Ws,lt,xp="In this free course, you will:",Ls,nt,Ip="<li>📖 Study Deep Reinforcement Learning in <strong>theory and practice</strong>.</li> <li>🧑‍💻 Learn to <strong>use famous Deep RL libraries</strong> such as Stable Baselines3, RL Baselines3 Zoo, CleanRL and Sample Factory 2.0.</li> <li>🤖 Train <strong>agents in unique environments</strong></li> <li>🎓 <strong>Earn a certificate of completion</strong> by completing 80% of the assignments.</li>",Gs,at,kp="And more!",Es,st,$p='Check 📚 the syllabus 👉 <a href="https://simoninithomas.github.io/deep-rl-course" rel="nofollow">https://simoninithomas.github.io/deep-rl-course</a>',Rs,it,Zp='Don’t forget to <strong><a href="http://eepurl.com/ic5ZUD">sign up to the course</a></strong> (we are collecting your email to be able to <strong>send you the links when each Unit is published and give you information about the challenges and updates).</strong>',Ss,ot,Bp='The best way to keep in touch and ask questions is <strong>to join our discord server</strong> to exchange with the community and with us 👉🏻 <a href="https://discord.gg/ydHrjt3WP5" rel="nofollow">https://discord.gg/ydHrjt3WP5</a>',Ys,x,ne,La,rt,$h,oa,Hp="Prerequisites 🏗️",Xs,ht,Wp="Before diving into the notebook, you need to:",Vs,pt,Lp='🔲 📝 <strong><a href="https://huggingface.co/deep-rl-course/unit0/introduction" rel="nofollow">Read Unit 0</a></strong> that gives you all the <strong>information about the course and helps you to onboard</strong> 🤗',As,ut,Gp='🔲 📚 <strong>Develop an understanding of the foundations of Reinforcement learning</strong> (MC, TD, Rewards hypothesis…) by <a href="https://huggingface.co/deep-rl-course/unit1/introduction" rel="nofollow">reading Unit 1</a>.',Ps,I,ae,Ga,mt,Zh,ra,Ep="A small recap of Deep Reinforcement Learning 📚",Fs,se,Rp,Qs,ct,Sp="Let’s do a small recap on what we learned in the first Unit:",Ns,dt,Yp="<li><p>Reinforcement Learning is a <strong>computational approach to learning from actions</strong>. We build an agent that learns from the environment by <strong>interacting with it through trial and error</strong> and receiving rewards (negative or positive) as feedback.</p></li> <li><p>The goal of any RL agent is to <strong>maximize its expected cumulative reward</strong> (also called expected return) because RL is based on the <em>reward hypothesis</em>, which is that all goals can be described as the maximization of an expected cumulative reward.</p></li> <li><p>The RL process is a <strong>loop that outputs a sequence of state, action, reward, and next state</strong>.</p></li> <li><p>To calculate the expected cumulative reward (expected return), <strong>we discount the rewards</strong>: the rewards that come sooner (at the beginning of the game) are more probable to happen since they are more predictable than the long-term future reward.</p></li> <li><p>To solve an RL problem, you want to <strong>find an optimal policy</strong>; the policy is the “brain” of your AI that will tell us what action to take given a state. The optimal one is the one that gives you the actions that max the expected return.</p></li>",zs,Mt,Xp="There are <strong>two</strong> ways to find your optimal policy:",Ds,ft,Vp="<li><p>By <strong>training your policy directly</strong>: policy-based methods.</p></li> <li><p>By <strong>training a value function</strong> that tells us the expected return the agent will get at each state and use this function to define our policy: value-based methods.</p></li> <li><p>Finally, we spoke about Deep RL because <strong>we introduce deep neural networks to estimate the action to take (policy-based) or to estimate the value of a state (value-based) hence the name “deep.”</strong></p></li>",qs,k,ie,Ea,vt,Bh,ha,Ap="Let's train our first Deep Reinforcement Learning agent and upload it to the Hub 🚀",Os,$,oe,Ra,yt,Hh,pa,Pp="Get a certificate 🎓",Ks,wt,Fp='To validate this hands-on for the <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">certification process</a>, you need to push your trained model to the Hub and <strong>get a result of &gt;= 200</strong>.',ei,gt,Qp='To find your result, go to the <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">leaderboard</a> and find your model, <strong>the result = mean_reward - std of reward</strong>',ti,bt,Np='For more information about the certification process, check this section 👉 <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process</a>',li,Z,re,Sa,Tt,Wh,ua,zp="Set the GPU 💪",ni,jt,Dp="<li>To <strong>accelerate the agent’s training, we’ll use a GPU</strong>. To do that, go to <code>Runtime &gt; Change Runtime type</code></li>",ai,Ut,qp,si,Jt,Op="<li><code>Hardware Accelerator &gt; GPU</code></li>",ii,Ct,Kp,oi,B,he,Ya,_t,Lh,ma,eu="Install dependencies and create a virtual screen 🔽",ri,xt,tu="The first step is to install the dependencies, we’ll install multiple ones.",hi,It,lu="<li><code>gymnasium[box2d]</code>: Contains the LunarLander-v2 environment 🌛</li> <li><code>stable-baselines3[extra]</code>: The deep reinforcement learning library.</li> <li><code>huggingface_sb3</code>: Additional code for Stable-baselines3 to load and upload models from the Hugging Face 🤗 Hub.</li>",pi,kt,nu="To make things easier, we created a script to install all these dependencies.",ui,$t,mi,Zt,ci,Bt,au="During the notebook, we’ll need to generate a replay video. To do so, with colab, <strong>we need to have a virtual screen to be able to render the environment</strong> (and thus record the frames).",di,Ht,su="Hence the following cell will install virtual screen libraries and create and run a virtual screen 🖥",Mi,Wt,fi,Lt,iu="To make sure the new installed libraries are used, <strong>sometimes it’s required to restart the notebook runtime</strong>. The next cell will force the <strong>runtime to crash, so you’ll need to connect again and run the code starting from here</strong>. Thanks to this trick, <strong>we will be able to run our virtual screen.</strong>",vi,Gt,yi,Et,wi,H,pe,Xa,Rt,Gh,ca,ou="Import the packages 📦",gi,St,ru="One additional library we import is huggingface_hub <strong>to be able to upload and download trained models from the hub</strong>.",bi,Yt,hu="The Hugging Face Hub 🤗 works as a central place where anyone can share and explore models and datasets. It has versioning, metrics, visualizations and other features that will allow you to easily collaborate with others.",Ti,Xt,pu='You can see here all the Deep reinforcement Learning models available here👉 <a href="https://huggingface.co/models?pipeline_tag=reinforcement-learning&amp;sort=downloads" rel="nofollow">https://huggingface.co/models?pipeline_tag=reinforcement-learning&amp;sort=downloads</a>',ji,Vt,Ui,W,ue,Va,At,Eh,da,uu="Understand Gymnasium and how it works 🤖",Ji,Pt,mu=`🏋 The library containing our environment is called Gymnasium.
<strong>You’ll use Gymnasium a lot in Deep Reinforcement Learning.</strong>`,Ci,Ft,cu='Gymnasium is the <strong>new version of Gym library</strong> <a href="https://farama.org/" rel="nofollow">maintained by the Farama Foundation</a>.',_i,Qt,du="The Gymnasium library provides two things:",xi,Nt,Mu="<li>An interface that allows you to <strong>create RL environments</strong>.</li> <li>A <strong>collection of environments</strong> (gym-control, atari, box2D…).</li>",Ii,zt,fu="Let’s look at an example, but first let’s recall the RL loop.",ki,me,vu,$i,Dt,yu="At each step:",Zi,qt,wu="<li>Our Agent receives a <strong>state (S0)</strong> from the <strong>Environment</strong> — we receive the first frame of our game (Environment).</li> <li>Based on that <strong>state (S0),</strong> the Agent takes an <strong>action (A0)</strong> — our Agent will move to the right.</li> <li>The environment transitions to a <strong>new</strong> <strong>state (S1)</strong> — new frame.</li> <li>The environment gives some <strong>reward (R1)</strong> to the Agent — we’re not dead <em>(Positive Reward +1)</em>.</li>",Bi,Ot,gu="With Gymnasium:",Hi,Kt,bu="1️⃣ We create our environment using <code>gymnasium.make()</code>",Wi,el,Tu="2️⃣ We reset the environment to its initial state with <code>observation = env.reset()</code>",Li,tl,ju="At each step:",Gi,ll,Uu="3️⃣ Get an action using our model (in our example we take a random action)",Ei,nl,Ju="4️⃣ Using <code>env.step(action)</code>, we perform this action in the environment and get",Ri,al,Cu="<li><code>observation</code>: The new state (st+1)</li> <li><code>reward</code>: The reward we get after executing the action</li> <li><code>terminated</code>: Indicates if the episode terminated (agent reach the terminal state)</li> <li><code>truncated</code>: Introduced with this new version, it indicates a timelimit or if an agent go out of bounds of the environment for instance.</li> <li><code>info</code>: A dictionary that provides additional information (depends on the environment).</li>",Si,sl,_u='For more explanations check this 👉 <a href="https://gymnasium.farama.org/api/env/#gymnasium.Env.step" rel="nofollow">https://gymnasium.farama.org/api/env/#gymnasium.Env.step</a>',Yi,il,xu="If the episode is terminated:",Xi,ol,Iu="<li>We reset the environment to its initial state with <code>observation = env.reset()</code></li>",Vi,rl,ku="<strong>Let’s look at an example!</strong> Make sure to read the code",Ai,hl,Pi,L,ce,Aa,pl,Rh,Ma,$u="Create the LunarLander environment 🌛 and understand how it works",Fi,G,de,Pa,ul,Sh,fa,Zu="The environment 🎮",Qi,ml,Bu='In this first tutorial, we’re going to train our agent, a <a href="https://gymnasium.farama.org/environments/box2d/lunar_lander/" rel="nofollow">Lunar Lander</a>, <strong>to land correctly on the moon</strong>. To do that, the agent needs to learn <strong>to adapt its speed and position (horizontal, vertical, and angular) to land correctly.</strong>',Ni,zi,Di,cl,Hu="💡 A good habit when you start to use an environment is to check its documentation",qi,dl,Wu='👉 <a href="https://gymnasium.farama.org/environments/box2d/lunar_lander/" rel="nofollow">https://gymnasium.farama.org/environments/box2d/lunar_lander/</a>',Oi,Ki,eo,Ml,Lu="Let’s see what the Environment looks like:",to,fl,lo,vl,Gu="We see with <code>Observation Space Shape (8,)</code> that the observation is a vector of size 8, where each value contains different information about the lander:",no,yl,Eu="<li>Horizontal pad coordinate (x)</li> <li>Vertical pad coordinate (y)</li> <li>Horizontal speed (x)</li> <li>Vertical speed (y)</li> <li>Angle</li> <li>Angular speed</li> <li>If the left leg contact point has touched the land (boolean)</li> <li>If the right leg contact point has touched the land (boolean)</li>",ao,wl,so,gl,Ru="The action space (the set of possible actions the agent can take) is discrete with 4 actions available 🎮:",io,bl,Su="<li>Action 0: Do nothing,</li> <li>Action 1: Fire left orientation engine,</li> <li>Action 2: Fire the main engine,</li> <li>Action 3: Fire right orientation engine.</li>",oo,Tl,Yu="Reward function (the function that will gives a reward at each timestep) 💰:",ro,jl,Xu="After every step a reward is granted. The total reward of an episode is the <strong>sum of the rewards for all the steps within that episode</strong>.",ho,Ul,Vu="For each step, the reward:",po,Jl,Au="<li>Is increased/decreased the closer/further the lander is to the landing pad.</li> <li>Is increased/decreased the slower/faster the lander is moving.</li> <li>Is decreased the more the lander is tilted (angle not horizontal).</li> <li>Is increased by 10 points for each leg that is in contact with the ground.</li> <li>Is decreased by 0.03 points each frame a side engine is firing.</li> <li>Is decreased by 0.3 points each frame the main engine is firing.</li>",uo,Cl,Pu="The episode receive an <strong>additional reward of -100 or +100 points for crashing or landing safely respectively.</strong>",mo,_l,Fu="An episode is <strong>considered a solution if it scores at least 200 points.</strong>",co,E,Me,Fa,xl,Yh,va,Qu="Vectorized Environment",Mo,Il,Nu="<li>We create a vectorized environment (a method for stacking multiple independent environments into a single environment) of 16 environments, this way, <strong>we’ll have more diverse experiences during the training.</strong></li>",fo,kl,vo,R,fe,Qa,$l,Xh,ya,zu="Create the Model 🤖",yo,Zl,Du='<li><p>We have studied our environment and we understood the problem: <strong>being able to land the Lunar Lander to the Landing Pad correctly by controlling left, right and main orientation engine</strong>. Now let’s build the algorithm we’re going to use to solve this Problem 🚀.</p></li> <li><p>To do so, we’re going to use our first Deep RL library, <a href="https://stable-baselines3.readthedocs.io/en/master/" rel="nofollow">Stable Baselines3 (SB3)</a>.</p></li> <li><p>SB3 is a set of <strong>reliable implementations of reinforcement learning algorithms in PyTorch</strong>.</p></li>',wo,go,bo,Bl,qu='💡 A good habit when using a new library is to dive first on the documentation: <a href="https://stable-baselines3.readthedocs.io/en/master/" rel="nofollow">https://stable-baselines3.readthedocs.io/en/master/</a> and then try some tutorials.',To,jo,Uo,Hl,Ou,Jo,Wl,Ku='To solve this problem, we’re going to use SB3 <strong>PPO</strong>. <a href="https://stable-baselines3.readthedocs.io/en/master/modules/ppo.html#example%5D" rel="nofollow">PPO (aka Proximal Policy Optimization) is one of the SOTA (state of the art) Deep Reinforcement Learning algorithms that you’ll study during this course</a>.',Co,Ll,em="PPO is a combination of:",_o,Gl,tm="<li><em>Value-based reinforcement learning method</em>: learning an action-value function that will tell us the <strong>most valuable action to take given a state and action</strong>.</li> <li><em>Policy-based reinforcement learning method</em>: learning a policy that will <strong>give us a probability distribution over actions</strong>.</li>",xo,El,lm="Stable-Baselines3 is easy to set up:",Io,Rl,nm="1️⃣ You <strong>create your environment</strong> (in our case it was done above)",ko,Sl,am="2️⃣ You define the <strong>model you want to use and instantiate this model</strong> <code>model = PPO(&quot;MlpPolicy&quot;)</code>",$o,Yl,sm="3️⃣ You <strong>train the agent</strong> with <code>model.learn</code> and define the number of training timesteps",Zo,Xl,Bo,Vl,Ho,S,ve,Na,Al,Vh,wa,im="Solution",Wo,Pl,Lo,Y,ye,za,Fl,Ah,ga,om="Train the PPO agent 🏃",Go,Ql,Eo,X,we,Da,Nl,Ph,ba,rm="Solution",Ro,zl,So,V,ge,qa,Dl,Fh,Ta,hm="Evaluate the agent 📈",Yo,ql,pm='<li>Remember to wrap the environment in a <a href="https://stable-baselines3.readthedocs.io/en/master/common/monitor.html" rel="nofollow">Monitor</a>.</li> <li>Now that our Lunar Lander agent is trained 🚀, we need to <strong>check its performance</strong>.</li> <li>Stable-Baselines3 provides a method to do that: <code>evaluate_policy</code>.</li> <li>To fill that part you need to <a href="https://stable-baselines3.readthedocs.io/en/master/guide/examples.html#basic-usage-training-saving-loading" rel="nofollow">check the documentation</a></li> <li>In the next step,  we’ll see <strong>how to automatically evaluate and share your agent to compete in a leaderboard, but for now let’s do it ourselves</strong></li>',Xo,Ol,um="💡 When you evaluate your agent, you should not use your training environment but create an evaluation environment.",Vo,Kl,Ao,A,be,Oa,en,Qh,ja,mm="Solution",Po,tn,Fo,ln,cm="<li>In my case, I got a mean reward is <code>200.20 +/- 20.80</code> after training for 1 million steps, which means that our lunar lander agent is ready to land on the moon 🌛🥳.</li>",Qo,P,Te,Ka,nn,Nh,Ua,dm="Publish our trained model on the Hub 🔥",No,an,Mm='📚 The libraries documentation 👉 <a href="https://github.com/huggingface/huggingface_sb3/tree/main#hugging-face--x-stable-baselines3-v20" rel="nofollow">https://github.com/huggingface/huggingface_sb3/tree/main#hugging-face—x-stable-baselines3-v20</a>',zo,sn,fm="Here’s an example of a Model Card (with Space Invaders):",Do,on,vm="By using <code>package_to_hub</code> <strong>you evaluate, record a replay, generate a model card of your agent and push it to the hub</strong>.",qo,rn,ym="This way:",Oo,hn,wm='<li>You can <strong>showcase our work</strong> 🔥</li> <li>You can <strong>visualize your agent playing</strong> 👀</li> <li>You can <strong>share with the community an agent that others can use</strong> 💾</li> <li>You can <strong>access a leaderboard 🏆 to see how well your agent is performing compared to your classmates</strong> 👉 <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard</a></li>',Ko,pn,gm="To be able to share your model with the community there are three more steps to follow:",er,un,bm='1️⃣ (If it’s not already done) create an account on Hugging Face ➡ <a href="https://huggingface.co/join" rel="nofollow">https://huggingface.co/join</a>',tr,mn,Tm="2️⃣ Sign in and then, you need to store your authentication token from the Hugging Face website.",lr,cn,jm='<li>Create a new token (<a href="https://huggingface.co/settings/tokens" rel="nofollow">https://huggingface.co/settings/tokens</a>) <strong>with write role</strong></li>',nr,dn,Um,ar,Mn,Jm="<li>Copy the token</li> <li>Run the cell below and paste the token</li>",sr,fn,ir,vn,Cm="If you don’t want to use a Google Colab or a Jupyter Notebook, you need to use this command instead: <code>huggingface-cli login</code>",or,yn,_m="3️⃣ We’re now ready to push our trained agent to the 🤗 Hub 🔥 using <code>package_to_hub()</code> function",rr,wn,xm="Let’s fill the <code>package_to_hub</code> function:",hr,gn,Im="<li><code>model</code>: our trained model.</li> <li><code>model_name</code>: the name of the trained model that we defined in <code>model_save</code></li> <li><code>model_architecture</code>: the model architecture we used, in our case PPO</li> <li><code>env_id</code>: the name of the environment, in our case <code>LunarLander-v2</code></li> <li><code>eval_env</code>: the evaluation environment defined in eval_env</li> <li><code>repo_id</code>: the name of the Hugging Face Hub Repository that will be created/updated <code>(repo_id = {username}/{repo_name})</code></li>",pr,bn,km="💡 <strong>A good name is <code>{username}/{model_architecture}-{env_id}</code></strong>",ur,Tn,$m="<li><code>commit_message</code>: message of the commit</li>",mr,jn,cr,F,je,es,Un,zh,Ja,Zm="Solution",dr,Jn,Mr,Cn,Bm='Congrats 🥳 you’ve just trained and uploaded your first Deep Reinforcement Learning agent. The script above should have displayed a link to a model repository such as <a href="https://huggingface.co/osanseviero/test_sb3" rel="nofollow">https://huggingface.co/osanseviero/test_sb3</a>. When you go to this link, you can:',fr,_n,Hm="<li>See a video preview of your agent at the right.</li> <li>Click “Files and versions” to see all the files in the repository.</li> <li>Click “Use in stable-baselines3” to get a code snippet that shows how to load the model.</li> <li>A model card (<code>README.md</code> file) which gives a description of the model</li>",vr,xn,Wm="Under the hood, the Hub uses git-based repositories (don’t worry if you don’t know what git is), which means you can update the model with new versions as you experiment and improve your agent.",yr,In,Lm='Compare the results of your LunarLander-v2 with your classmates using the leaderboard 🏆 👉 <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard</a>',wr,Q,Ue,ts,kn,Dh,Ca,Gm="Load a saved LunarLander model from the Hub 🤗",gr,$n,Em="Loading a saved model from the Hub is really easy.",br,Zn,Rm='You go to <a href="https://huggingface.co/models?library=stable-baselines3" rel="nofollow">https://huggingface.co/models?library=stable-baselines3</a> to see the list of all the Stable-baselines3 saved models.',Tr,Bn,Sm="<li>You select one and copy its repo_id</li>",jr,Hn,Ym,Ur,Je,Xm="<li>Then we just need to use load_from_hub with:</li>",Jr,Wn,Vm="<li>The repo_id</li> <li>The filename: the saved model inside the repo and its extension (*.zip)</li>",Cr,Ln,Am="Because the model I download from the Hub was trained with Gym (the former version of Gymnasium) we need to install shimmy a API conversion tool that will help us to run the environment correctly.",_r,Gn,Pm='Shimmy Documentation: <a href="https://github.com/Farama-Foundation/Shimmy" rel="nofollow">https://github.com/Farama-Foundation/Shimmy</a>',xr,En,Ir,Rn,kr,Sn,Fm="Let’s evaluate this agent:",$r,Yn,Zr,N,Ce,ls,Xn,qh,_a,Qm="Some additional challenges 🏆",Br,Vn,Nm='In the <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">Leaderboard</a> you will find your agents. Can you get to the top?',Hr,An,zm="Here are some ideas to achieve so:",Wr,Pn,Dm='<li>Train more steps</li> <li>Try different hyperparameters for <code>PPO</code>. You can see them at <a href="https://stable-baselines3.readthedocs.io/en/master/modules/ppo.html#parameters" rel="nofollow">https://stable-baselines3.readthedocs.io/en/master/modules/ppo.html#parameters</a>.</li> <li>Check the <a href="https://stable-baselines3.readthedocs.io/en/master/modules/dqn.html" rel="nofollow">Stable-Baselines3 documentation</a> and try another model such as DQN.</li> <li><strong>Push your new trained model</strong> on the Hub 🔥</li>',Lr,Fn,qm='<strong>Compare the results of your LunarLander-v2 with your classmates</strong> using the <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">leaderboard</a> 🏆',Gr,Qn,Om='Is moon landing too boring for you? Try to <strong>change the environment</strong>, why not use MountainCar-v0, CartPole-v1 or CarRacing-v0? Check how they work <a href="https://www.gymlibrary.dev/" rel="nofollow">using the gym documentation</a> and have fun 🎉.',Er,Rr,Sr,Nn,Km="Congrats on finishing this chapter! That was the biggest one, <strong>and there was a lot of information.</strong>",Yr,zn,ec="If you’re still feel confused with all these elements…it’s totally normal! <strong>This was the same for me and for all people who studied RL.</strong>",Xr,Dn,tc="Take time to really <strong>grasp the material before continuing and try the additional challenges</strong>. It’s important to master these elements and have a solid foundations.",Vr,qn,lc="Naturally, during the course, we’re going to dive deeper into these concepts but <strong>it’s better to have a good understanding of them now before diving into the next chapters.</strong>",Ar,On,nc="Next time, in the bonus unit 1, you’ll train Huggy the Dog to fetch the stick.",Pr,Kn,ac,Fr,z,_e,ns,ea,Oh,xa,sc="Keep learning, stay awesome 🤗",Qr,as,Nr;return xe=new y({}),Ie=new dd({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/deep-rl-class/blob/master/notebooks/unit1/unit1.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),Ae=new y({}),Fe=new y({}),Ne=new y({}),qe=new y({}),et=new y({}),rt=new y({}),mt=new y({}),vt=new y({}),yt=new y({}),Tt=new y({}),_t=new y({}),$t=new w({props:{code:"YXB0JTIwaW5zdGFsbCUyMHN3aWclMjBjbWFrZQ==",highlighted:"apt install swig cmake",wrap:!1}}),Zt=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1yJTIwaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGaHVnZ2luZ2ZhY2UlMkZkZWVwLXJsLWNsYXNzJTJGbWFpbiUyRm5vdGVib29rcyUyRnVuaXQxJTJGcmVxdWlyZW1lbnRzLXVuaXQxLnR4dA==",highlighted:"pip install -r https://raw.githubusercontent.com/huggingface/deep-rl-class/main/notebooks/unit1/requirements-unit1.txt",wrap:!1}}),Wt=new w({props:{code:"c3VkbyUyMGFwdC1nZXQlMjB1cGRhdGUlMEFhcHQlMjBpbnN0YWxsJTIwcHl0aG9uLW9wZW5nbCUwQWFwdCUyMGluc3RhbGwlMjBmZm1wZWclMEFhcHQlMjBpbnN0YWxsJTIweHZmYiUwQXBpcDMlMjBpbnN0YWxsJTIwcHl2aXJ0dWFsZGlzcGxheQ==",highlighted:`sudo apt-get update
apt install python-opengl
apt install ffmpeg
apt install xvfb
pip3 install pyvirtualdisplay`,wrap:!1}}),Gt=new w({props:{code:"aW1wb3J0JTIwb3MlMEElMEFvcy5raWxsKG9zLmdldHBpZCgpJTJDJTIwOSk=",highlighted:`<span class="hljs-keyword">import</span> os

os.kill(os.getpid(), <span class="hljs-number">9</span>)`,wrap:!1}}),Et=new w({props:{code:"JTIzJTIwVmlydHVhbCUyMGRpc3BsYXklMEFmcm9tJTIwcHl2aXJ0dWFsZGlzcGxheSUyMGltcG9ydCUyMERpc3BsYXklMEElMEF2aXJ0dWFsX2Rpc3BsYXklMjAlM0QlMjBEaXNwbGF5KHZpc2libGUlM0QwJTJDJTIwc2l6ZSUzRCgxNDAwJTJDJTIwOTAwKSklMEF2aXJ0dWFsX2Rpc3BsYXkuc3RhcnQoKQ==",highlighted:`<span class="hljs-comment"># Virtual display</span>
<span class="hljs-keyword">from</span> pyvirtualdisplay <span class="hljs-keyword">import</span> Display

virtual_display = Display(visible=<span class="hljs-number">0</span>, size=(<span class="hljs-number">1400</span>, <span class="hljs-number">900</span>))
virtual_display.start()`,wrap:!1}}),Rt=new y({}),Vt=new w({props:{code:"aW1wb3J0JTIwZ3ltbmFzaXVtJTBBJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX3NiMyUyMGltcG9ydCUyMGxvYWRfZnJvbV9odWIlMkMlMjBwYWNrYWdlX3RvX2h1YiUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwbm90ZWJvb2tfbG9naW4lMkMlMEEpJTIwJTIwJTIzJTIwVG8lMjBsb2clMjB0byUyMG91ciUyMEh1Z2dpbmclMjBGYWNlJTIwYWNjb3VudCUyMHRvJTIwYmUlMjBhYmxlJTIwdG8lMjB1cGxvYWQlMjBtb2RlbHMlMjB0byUyMHRoZSUyMEh1Yi4lMEElMEFmcm9tJTIwc3RhYmxlX2Jhc2VsaW5lczMlMjBpbXBvcnQlMjBQUE8lMEFmcm9tJTIwc3RhYmxlX2Jhc2VsaW5lczMuY29tbW9uLmVudl91dGlsJTIwaW1wb3J0JTIwbWFrZV92ZWNfZW52JTBBZnJvbSUyMHN0YWJsZV9iYXNlbGluZXMzLmNvbW1vbi5ldmFsdWF0aW9uJTIwaW1wb3J0JTIwZXZhbHVhdGVfcG9saWN5JTBBZnJvbSUyMHN0YWJsZV9iYXNlbGluZXMzLmNvbW1vbi5tb25pdG9yJTIwaW1wb3J0JTIwTW9uaXRvcg==",highlighted:`<span class="hljs-keyword">import</span> gymnasium

<span class="hljs-keyword">from</span> huggingface_sb3 <span class="hljs-keyword">import</span> load_from_hub, package_to_hub
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> (
    notebook_login,
)  <span class="hljs-comment"># To log to our Hugging Face account to be able to upload models to the Hub.</span>

<span class="hljs-keyword">from</span> stable_baselines3 <span class="hljs-keyword">import</span> PPO
<span class="hljs-keyword">from</span> stable_baselines3.common.env_util <span class="hljs-keyword">import</span> make_vec_env
<span class="hljs-keyword">from</span> stable_baselines3.common.evaluation <span class="hljs-keyword">import</span> evaluate_policy
<span class="hljs-keyword">from</span> stable_baselines3.common.monitor <span class="hljs-keyword">import</span> Monitor`,wrap:!1}}),At=new y({}),hl=new w({props:{code:"aW1wb3J0JTIwZ3ltbmFzaXVtJTIwYXMlMjBneW0lMEElMEElMjMlMjBGaXJzdCUyQyUyMHdlJTIwY3JlYXRlJTIwb3VyJTIwZW52aXJvbm1lbnQlMjBjYWxsZWQlMjBMdW5hckxhbmRlci12MiUwQWVudiUyMCUzRCUyMGd5bS5tYWtlKCUyMkx1bmFyTGFuZGVyLXYyJTIyKSUwQSUwQSUyMyUyMFRoZW4lMjB3ZSUyMHJlc2V0JTIwdGhpcyUyMGVudmlyb25tZW50JTBBb2JzZXJ2YXRpb24lMkMlMjBpbmZvJTIwJTNEJTIwZW52LnJlc2V0KCklMEElMEFmb3IlMjBfJTIwaW4lMjByYW5nZSgyMCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBUYWtlJTIwYSUyMHJhbmRvbSUyMGFjdGlvbiUwQSUyMCUyMCUyMCUyMGFjdGlvbiUyMCUzRCUyMGVudi5hY3Rpb25fc3BhY2Uuc2FtcGxlKCklMEElMjAlMjAlMjAlMjBwcmludCglMjJBY3Rpb24lMjB0YWtlbiUzQSUyMiUyQyUyMGFjdGlvbiklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBEbyUyMHRoaXMlMjBhY3Rpb24lMjBpbiUyMHRoZSUyMGVudmlyb25tZW50JTIwYW5kJTIwZ2V0JTBBJTIwJTIwJTIwJTIwJTIzJTIwbmV4dF9zdGF0ZSUyQyUyMHJld2FyZCUyQyUyMHRlcm1pbmF0ZWQlMkMlMjB0cnVuY2F0ZWQlMjBhbmQlMjBpbmZvJTBBJTIwJTIwJTIwJTIwb2JzZXJ2YXRpb24lMkMlMjByZXdhcmQlMkMlMjB0ZXJtaW5hdGVkJTJDJTIwdHJ1bmNhdGVkJTJDJTIwaW5mbyUyMCUzRCUyMGVudi5zdGVwKGFjdGlvbiklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBJZiUyMHRoZSUyMGdhbWUlMjBpcyUyMHRlcm1pbmF0ZWQlMjAoaW4lMjBvdXIlMjBjYXNlJTIwd2UlMjBsYW5kJTJDJTIwY3Jhc2hlZCklMjBvciUyMHRydW5jYXRlZCUyMCh0aW1lb3V0KSUwQSUyMCUyMCUyMCUyMGlmJTIwdGVybWluYXRlZCUyMG9yJTIwdHJ1bmNhdGVkJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwUmVzZXQlMjB0aGUlMjBlbnZpcm9ubWVudCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCUyMkVudmlyb25tZW50JTIwaXMlMjByZXNldCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvYnNlcnZhdGlvbiUyQyUyMGluZm8lMjAlM0QlMjBlbnYucmVzZXQoKSUwQSUwQWVudi5jbG9zZSgp",highlighted:`<span class="hljs-keyword">import</span> gymnasium <span class="hljs-keyword">as</span> gym

<span class="hljs-comment"># First, we create our environment called LunarLander-v2</span>
env = gym.make(<span class="hljs-string">&quot;LunarLander-v2&quot;</span>)

<span class="hljs-comment"># Then we reset this environment</span>
observation, info = env.reset()

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">20</span>):
    <span class="hljs-comment"># Take a random action</span>
    action = env.action_space.sample()
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Action taken:&quot;</span>, action)

    <span class="hljs-comment"># Do this action in the environment and get</span>
    <span class="hljs-comment"># next_state, reward, terminated, truncated and info</span>
    observation, reward, terminated, truncated, info = env.step(action)

    <span class="hljs-comment"># If the game is terminated (in our case we land, crashed) or truncated (timeout)</span>
    <span class="hljs-keyword">if</span> terminated <span class="hljs-keyword">or</span> truncated:
        <span class="hljs-comment"># Reset the environment</span>
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Environment is reset&quot;</span>)
        observation, info = env.reset()

env.close()`,wrap:!1}}),pl=new y({}),ul=new y({}),fl=new w({props:{code:"JTIzJTIwV2UlMjBjcmVhdGUlMjBvdXIlMjBlbnZpcm9ubWVudCUyMHdpdGglMjBneW0ubWFrZSglMjIlM0NuYW1lX29mX3RoZV9lbnZpcm9ubWVudCUzRSUyMiklMEFlbnYlMjAlM0QlMjBneW0ubWFrZSglMjJMdW5hckxhbmRlci12MiUyMiklMEFlbnYucmVzZXQoKSUwQXByaW50KCUyMl9fX19fT0JTRVJWQVRJT04lMjBTUEFDRV9fX19fJTIwJTVDbiUyMiklMEFwcmludCglMjJPYnNlcnZhdGlvbiUyMFNwYWNlJTIwU2hhcGUlMjIlMkMlMjBlbnYub2JzZXJ2YXRpb25fc3BhY2Uuc2hhcGUpJTBBcHJpbnQoJTIyU2FtcGxlJTIwb2JzZXJ2YXRpb24lMjIlMkMlMjBlbnYub2JzZXJ2YXRpb25fc3BhY2Uuc2FtcGxlKCkpJTIwJTIwJTIzJTIwR2V0JTIwYSUyMHJhbmRvbSUyMG9ic2VydmF0aW9u",highlighted:`<span class="hljs-comment"># We create our environment with gym.make(&quot;&lt;name_of_the_environment&gt;&quot;)</span>
env = gym.make(<span class="hljs-string">&quot;LunarLander-v2&quot;</span>)
env.reset()
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;_____OBSERVATION SPACE_____ \\n&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Observation Space Shape&quot;</span>, env.observation_space.shape)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Sample observation&quot;</span>, env.observation_space.sample())  <span class="hljs-comment"># Get a random observation</span>`,wrap:!1}}),wl=new w({props:{code:"cHJpbnQoJTIyJTVDbiUyMF9fX19fQUNUSU9OJTIwU1BBQ0VfX19fXyUyMCU1Q24lMjIpJTBBcHJpbnQoJTIyQWN0aW9uJTIwU3BhY2UlMjBTaGFwZSUyMiUyQyUyMGVudi5hY3Rpb25fc3BhY2UubiklMEFwcmludCglMjJBY3Rpb24lMjBTcGFjZSUyMFNhbXBsZSUyMiUyQyUyMGVudi5hY3Rpb25fc3BhY2Uuc2FtcGxlKCkpJTIwJTIwJTIzJTIwVGFrZSUyMGElMjByYW5kb20lMjBhY3Rpb24=",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n _____ACTION SPACE_____ \\n&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Action Space Shape&quot;</span>, env.action_space.n)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Action Space Sample&quot;</span>, env.action_space.sample())  <span class="hljs-comment"># Take a random action</span>`,wrap:!1}}),xl=new y({}),kl=new w({props:{code:"JTIzJTIwQ3JlYXRlJTIwdGhlJTIwZW52aXJvbm1lbnQlMEFlbnYlMjAlM0QlMjBtYWtlX3ZlY19lbnYoJTIyTHVuYXJMYW5kZXItdjIlMjIlMkMlMjBuX2VudnMlM0QxNik=",highlighted:`<span class="hljs-comment"># Create the environment</span>
env = make_vec_env(<span class="hljs-string">&quot;LunarLander-v2&quot;</span>, n_envs=<span class="hljs-number">16</span>)`,wrap:!1}}),$l=new y({}),Xl=new w({props:{code:"JTIzJTIwQ3JlYXRlJTIwZW52aXJvbm1lbnQlMEFlbnYlMjAlM0QlMjBneW0ubWFrZSgnTHVuYXJMYW5kZXItdjInKSUwQSUwQSUyMyUyMEluc3RhbnRpYXRlJTIwdGhlJTIwYWdlbnQlMEFtb2RlbCUyMCUzRCUyMFBQTygnTWxwUG9saWN5JyUyQyUyMGVudiUyQyUyMHZlcmJvc2UlM0QxKSUwQSUyMyUyMFRyYWluJTIwdGhlJTIwYWdlbnQlMEFtb2RlbC5sZWFybih0b3RhbF90aW1lc3RlcHMlM0RpbnQoMmU1KSk=",highlighted:`<span class="hljs-comment"># Create environment</span>
env = gym.make(<span class="hljs-string">&#x27;LunarLander-v2&#x27;</span>)

<span class="hljs-comment"># Instantiate the agent</span>
model = PPO(<span class="hljs-string">&#x27;MlpPolicy&#x27;</span>, env, <span class="hljs-attribute">verbose</span>=1)
<span class="hljs-comment"># Train the agent</span>
model.learn(<span class="hljs-attribute">total_timesteps</span>=int(2e5))`,wrap:!1}}),Vl=new w({props:{code:"JTIzJTIwVE9ETyUzQSUyMERlZmluZSUyMGElMjBQUE8lMjBNbHBQb2xpY3klMjBhcmNoaXRlY3R1cmUlMEElMjMlMjBXZSUyMHVzZSUyME11bHRpTGF5ZXJQZXJjZXB0cm9uJTIwKE1MUFBvbGljeSklMjBiZWNhdXNlJTIwdGhlJTIwaW5wdXQlMjBpcyUyMGElMjB2ZWN0b3IlMkMlMEElMjMlMjBpZiUyMHdlJTIwaGFkJTIwZnJhbWVzJTIwYXMlMjBpbnB1dCUyMHdlJTIwd291bGQlMjB1c2UlMjBDbm5Qb2xpY3klMEFtb2RlbCUyMCUzRA==",highlighted:`<span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Define a PPO MlpPolicy architecture</span>
<span class="hljs-comment"># We use MultiLayerPerceptron (MLPPolicy) because the input is a vector,</span>
<span class="hljs-comment"># if we had frames as input we would use CnnPolicy</span>
model =`,wrap:!1}}),Al=new y({}),Pl=new w({props:{code:"JTIzJTIwU09MVVRJT04lMEElMjMlMjBXZSUyMGFkZGVkJTIwc29tZSUyMHBhcmFtZXRlcnMlMjB0byUyMGFjY2VsZXJhdGUlMjB0aGUlMjB0cmFpbmluZyUwQW1vZGVsJTIwJTNEJTIwUFBPKCUwQSUyMCUyMCUyMCUyMHBvbGljeSUzRCUyMk1scFBvbGljeSUyMiUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRGVudiUyQyUwQSUyMCUyMCUyMCUyMG5fc3RlcHMlM0QxMDI0JTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzRDY0JTJDJTBBJTIwJTIwJTIwJTIwbl9lcG9jaHMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwZ2FtbWElM0QwLjk5OSUyQyUwQSUyMCUyMCUyMCUyMGdhZV9sYW1iZGElM0QwLjk4JTJDJTBBJTIwJTIwJTIwJTIwZW50X2NvZWYlM0QwLjAxJTJDJTBBJTIwJTIwJTIwJTIwdmVyYm9zZSUzRDElMkMlMEEp",highlighted:`<span class="hljs-comment"># SOLUTION</span>
<span class="hljs-comment"># We added some parameters to accelerate the training</span>
model = PPO(
    policy=<span class="hljs-string">&quot;MlpPolicy&quot;</span>,
    env=env,
    n_steps=<span class="hljs-number">1024</span>,
    batch_size=<span class="hljs-number">64</span>,
    n_epochs=<span class="hljs-number">4</span>,
    gamma=<span class="hljs-number">0.999</span>,
    gae_lambda=<span class="hljs-number">0.98</span>,
    ent_coef=<span class="hljs-number">0.01</span>,
    verbose=<span class="hljs-number">1</span>,
)`,wrap:!1}}),Fl=new y({}),Ql=new w({props:{code:"JTIzJTIwVE9ETyUzQSUyMFRyYWluJTIwaXQlMjBmb3IlMjAxJTJDMDAwJTJDMDAwJTIwdGltZXN0ZXBzJTBBJTBBJTIzJTIwVE9ETyUzQSUyMFNwZWNpZnklMjBmaWxlJTIwbmFtZSUyMGZvciUyMG1vZGVsJTIwYW5kJTIwc2F2ZSUyMHRoZSUyMG1vZGVsJTIwdG8lMjBmaWxlJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMiUyMg==",highlighted:`<span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Train it for 1,000,000 timesteps</span>

<span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Specify file name for model and save the model to file</span>
model_name = <span class="hljs-string">&quot;&quot;</span>`,wrap:!1}}),Nl=new y({}),zl=new w({props:{code:"JTIzJTIwU09MVVRJT04lMEElMjMlMjBUcmFpbiUyMGl0JTIwZm9yJTIwMSUyQzAwMCUyQzAwMCUyMHRpbWVzdGVwcyUwQW1vZGVsLmxlYXJuKHRvdGFsX3RpbWVzdGVwcyUzRDEwMDAwMDApJTBBJTIzJTIwU2F2ZSUyMHRoZSUyMG1vZGVsJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMnBwby1MdW5hckxhbmRlci12MiUyMiUwQW1vZGVsLnNhdmUobW9kZWxfbmFtZSk=",highlighted:`<span class="hljs-comment"># SOLUTION</span>
<span class="hljs-comment"># Train it for 1,000,000 timesteps</span>
model.learn(total_timesteps=<span class="hljs-number">1000000</span>)
<span class="hljs-comment"># Save the model</span>
model_name = <span class="hljs-string">&quot;ppo-LunarLander-v2&quot;</span>
model.save(model_name)`,wrap:!1}}),Dl=new y({}),Kl=new w({props:{code:"JTIzJTIwVE9ETyUzQSUyMEV2YWx1YXRlJTIwdGhlJTIwYWdlbnQlMEElMjMlMjBDcmVhdGUlMjBhJTIwbmV3JTIwZW52aXJvbm1lbnQlMjBmb3IlMjBldmFsdWF0aW9uJTBBZXZhbF9lbnYlMjAlM0QlMEElMEElMjMlMjBFdmFsdWF0ZSUyMHRoZSUyMG1vZGVsJTIwd2l0aCUyMDEwJTIwZXZhbHVhdGlvbiUyMGVwaXNvZGVzJTIwYW5kJTIwZGV0ZXJtaW5pc3RpYyUzRFRydWUlMEFtZWFuX3Jld2FyZCUyQyUyMHN0ZF9yZXdhcmQlMjAlM0QlMjAlMEElMEElMjMlMjBQcmludCUyMHRoZSUyMHJlc3VsdHM=",highlighted:`<span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Evaluate the agent</span>
<span class="hljs-comment"># Create a new environment for evaluation</span>
eval_env =

<span class="hljs-comment"># Evaluate the model with 10 evaluation episodes and deterministic=True</span>
mean_reward, std_reward = 

<span class="hljs-comment"># Print the results</span>`,wrap:!1}}),en=new y({}),tn=new w({props:{code:"JTIzJTIwJTQwdGl0bGUlMEFldmFsX2VudiUyMCUzRCUyME1vbml0b3IoZ3ltLm1ha2UoJTIyTHVuYXJMYW5kZXItdjIlMjIpKSUwQW1lYW5fcmV3YXJkJTJDJTIwc3RkX3Jld2FyZCUyMCUzRCUyMGV2YWx1YXRlX3BvbGljeShtb2RlbCUyQyUyMGV2YWxfZW52JTJDJTIwbl9ldmFsX2VwaXNvZGVzJTNEMTAlMkMlMjBkZXRlcm1pbmlzdGljJTNEVHJ1ZSklMEFwcmludChmJTIybWVhbl9yZXdhcmQlM0QlN0JtZWFuX3Jld2FyZCUzQS4yZiU3RCUyMCUyQiUyRi0lMjAlN0JzdGRfcmV3YXJkJTdEJTIyKQ==",highlighted:`<span class="hljs-comment"># @title</span>
eval_env = Monitor(gym.make(<span class="hljs-string">&quot;LunarLander-v2&quot;</span>))
mean_reward, std_reward = evaluate_policy(model, eval_env, n_eval_episodes=<span class="hljs-number">10</span>, deterministic=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;mean_reward=<span class="hljs-subst">{mean_reward:<span class="hljs-number">.2</span>f}</span> +/- <span class="hljs-subst">{std_reward}</span>&quot;</span>)`,wrap:!1}}),nn=new y({}),fn=new w({props:{code:"bm90ZWJvb2tfbG9naW4oKSUwQSFnaXQlMjBjb25maWclMjAtLWdsb2JhbCUyMGNyZWRlbnRpYWwuaGVscGVyJTIwc3RvcmU=",highlighted:`notebook_login()
!git config --<span class="hljs-keyword">global</span> credential.helper store`,wrap:!1}}),jn=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> gymnasium <span class="hljs-keyword">as</span> gym
<span class="hljs-keyword">from</span> stable_baselines3.common.vec_env <span class="hljs-keyword">import</span> DummyVecEnv
<span class="hljs-keyword">from</span> stable_baselines3.common.env_util <span class="hljs-keyword">import</span> make_vec_env

<span class="hljs-keyword">from</span> huggingface_sb3 <span class="hljs-keyword">import</span> package_to_hub

<span class="hljs-comment">## <span class="hljs-doctag">TODO:</span> Define a repo_id</span>
<span class="hljs-comment">## repo_id is the id of the model repository from the Hugging Face Hub (repo_id = {organization}/{repo_name} for instance ThomasSimonini/ppo-LunarLander-v2</span>
repo_id = 

<span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Define the name of the environment</span>
env_id = 

<span class="hljs-comment"># Create the evaluation env and set the render_mode=&quot;rgb_array&quot;</span>
eval_env = DummyVecEnv([<span class="hljs-keyword">lambda</span>: gym.make(env_id, render_mode=<span class="hljs-string">&quot;rgb_array&quot;</span>)])


<span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Define the model architecture we used</span>
model_architecture = <span class="hljs-string">&quot;&quot;</span>

<span class="hljs-comment">## <span class="hljs-doctag">TODO:</span> Define the commit message</span>
commit_message = <span class="hljs-string">&quot;&quot;</span>

<span class="hljs-comment"># method save, evaluate, generate a model card and record a replay video of your agent before pushing the repo to the hub</span>
package_to_hub(model=model, <span class="hljs-comment"># Our trained model</span>
               model_name=model_name, <span class="hljs-comment"># The name of our trained model </span>
               model_architecture=model_architecture, <span class="hljs-comment"># The model architecture we used: in our case PPO</span>
               env_id=env_id, <span class="hljs-comment"># Name of the environment</span>
               eval_env=eval_env, <span class="hljs-comment"># Evaluation Environment</span>
               repo_id=repo_id, <span class="hljs-comment"># id of the model repository from the Hugging Face Hub (repo_id = {organization}/{repo_name} for instance ThomasSimonini/ppo-LunarLander-v2</span>
               commit_message=commit_message)`,wrap:!1}}),Un=new y({}),Jn=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> gymnasium <span class="hljs-keyword">as</span> gym

<span class="hljs-keyword">from</span> stable_baselines3 <span class="hljs-keyword">import</span> PPO
<span class="hljs-keyword">from</span> stable_baselines3.common.vec_env <span class="hljs-keyword">import</span> DummyVecEnv
<span class="hljs-keyword">from</span> stable_baselines3.common.env_util <span class="hljs-keyword">import</span> make_vec_env

<span class="hljs-keyword">from</span> huggingface_sb3 <span class="hljs-keyword">import</span> package_to_hub

<span class="hljs-comment"># PLACE the variables you&#x27;ve just defined two cells above</span>
<span class="hljs-comment"># Define the name of the environment</span>
env_id = <span class="hljs-string">&quot;LunarLander-v2&quot;</span>

<span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Define the model architecture we used</span>
model_architecture = <span class="hljs-string">&quot;PPO&quot;</span>

<span class="hljs-comment">## Define a repo_id</span>
<span class="hljs-comment">## repo_id is the id of the model repository from the Hugging Face Hub (repo_id = {organization}/{repo_name} for instance ThomasSimonini/ppo-LunarLander-v2</span>
<span class="hljs-comment">## CHANGE WITH YOUR REPO ID</span>
repo_id = <span class="hljs-string">&quot;ThomasSimonini/ppo-LunarLander-v2&quot;</span>  <span class="hljs-comment"># Change with your repo id, you can&#x27;t push with mine 😄</span>

<span class="hljs-comment">## Define the commit message</span>
commit_message = <span class="hljs-string">&quot;Upload PPO LunarLander-v2 trained agent&quot;</span>

<span class="hljs-comment"># Create the evaluation env and set the render_mode=&quot;rgb_array&quot;</span>
eval_env = DummyVecEnv([<span class="hljs-keyword">lambda</span>: Monitor(gym.make(env_id, render_mode=<span class="hljs-string">&quot;rgb_array&quot;</span>))])

<span class="hljs-comment"># PLACE the package_to_hub function you&#x27;ve just filled here</span>
package_to_hub(
    model=model,  <span class="hljs-comment"># Our trained model</span>
    model_name=model_name,  <span class="hljs-comment"># The name of our trained model</span>
    model_architecture=model_architecture,  <span class="hljs-comment"># The model architecture we used: in our case PPO</span>
    env_id=env_id,  <span class="hljs-comment"># Name of the environment</span>
    eval_env=eval_env,  <span class="hljs-comment"># Evaluation Environment</span>
    repo_id=repo_id,  <span class="hljs-comment"># id of the model repository from the Hugging Face Hub (repo_id = {organization}/{repo_name} for instance ThomasSimonini/ppo-LunarLander-v2</span>
    commit_message=commit_message,
)`,wrap:!1}}),kn=new y({}),En=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzaGltbXk=",highlighted:"!pip install shimmy",wrap:!1}}),Rn=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX3NiMyUyMGltcG9ydCUyMGxvYWRfZnJvbV9odWIlMEElMEFyZXBvX2lkJTIwJTNEJTIwJTIyQ2xhc3Nyb29tLXdvcmtzaG9wJTJGYXNzaWdubWVudDItb21hciUyMiUyMCUyMCUyMyUyMFRoZSUyMHJlcG9faWQlMEFmaWxlbmFtZSUyMCUzRCUyMCUyMnBwby1MdW5hckxhbmRlci12Mi56aXAlMjIlMjAlMjAlMjMlMjBUaGUlMjBtb2RlbCUyMGZpbGVuYW1lLnppcCUwQSUwQSUyMyUyMFdoZW4lMjB0aGUlMjBtb2RlbCUyMHdhcyUyMHRyYWluZWQlMjBvbiUyMFB5dGhvbiUyMDMuOCUyMHRoZSUyMHBpY2tsZSUyMHByb3RvY29sJTIwaXMlMjA1JTBBJTIzJTIwQnV0JTIwUHl0aG9uJTIwMy42JTJDJTIwMy43JTIwdXNlJTIwcHJvdG9jb2wlMjA0JTBBJTIzJTIwSW4lMjBvcmRlciUyMHRvJTIwZ2V0JTIwY29tcGF0aWJpbGl0eSUyMHdlJTIwbmVlZCUyMHRvJTNBJTBBJTIzJTIwMS4lMjBJbnN0YWxsJTIwcGlja2xlNSUyMCh3ZSUyMGRvbmUlMjBpdCUyMGF0JTIwdGhlJTIwYmVnaW5uaW5nJTIwb2YlMjB0aGUlMjBjb2xhYiklMEElMjMlMjAyLiUyMENyZWF0ZSUyMGElMjBjdXN0b20lMjBlbXB0eSUyMG9iamVjdCUyMHdlJTIwcGFzcyUyMGFzJTIwcGFyYW1ldGVyJTIwdG8lMjBQUE8ubG9hZCgpJTBBY3VzdG9tX29iamVjdHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJsZWFybmluZ19yYXRlJTIyJTNBJTIwMC4wJTJDJTBBJTIwJTIwJTIwJTIwJTIybHJfc2NoZWR1bGUlMjIlM0ElMjBsYW1iZGElMjBfJTNBJTIwMC4wJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2xpcF9yYW5nZSUyMiUzQSUyMGxhbWJkYSUyMF8lM0ElMjAwLjAlMkMlMEElN0QlMEElMEFjaGVja3BvaW50JTIwJTNEJTIwbG9hZF9mcm9tX2h1YihyZXBvX2lkJTJDJTIwZmlsZW5hbWUpJTBBbW9kZWwlMjAlM0QlMjBQUE8ubG9hZChjaGVja3BvaW50JTJDJTIwY3VzdG9tX29iamVjdHMlM0RjdXN0b21fb2JqZWN0cyUyQyUyMHByaW50X3N5c3RlbV9pbmZvJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_sb3 <span class="hljs-keyword">import</span> load_from_hub

repo_id = <span class="hljs-string">&quot;Classroom-workshop/assignment2-omar&quot;</span>  <span class="hljs-comment"># The repo_id</span>
filename = <span class="hljs-string">&quot;ppo-LunarLander-v2.zip&quot;</span>  <span class="hljs-comment"># The model filename.zip</span>

<span class="hljs-comment"># When the model was trained on Python 3.8 the pickle protocol is 5</span>
<span class="hljs-comment"># But Python 3.6, 3.7 use protocol 4</span>
<span class="hljs-comment"># In order to get compatibility we need to:</span>
<span class="hljs-comment"># 1. Install pickle5 (we done it at the beginning of the colab)</span>
<span class="hljs-comment"># 2. Create a custom empty object we pass as parameter to PPO.load()</span>
custom_objects = {
    <span class="hljs-string">&quot;learning_rate&quot;</span>: <span class="hljs-number">0.0</span>,
    <span class="hljs-string">&quot;lr_schedule&quot;</span>: <span class="hljs-keyword">lambda</span> _: <span class="hljs-number">0.0</span>,
    <span class="hljs-string">&quot;clip_range&quot;</span>: <span class="hljs-keyword">lambda</span> _: <span class="hljs-number">0.0</span>,
}

checkpoint = load_from_hub(repo_id, filename)
model = PPO.load(checkpoint, custom_objects=custom_objects, print_system_info=<span class="hljs-literal">True</span>)`,wrap:!1}}),Yn=new w({props:{code:"JTIzJTIwJTQwdGl0bGUlMEFldmFsX2VudiUyMCUzRCUyME1vbml0b3IoZ3ltLm1ha2UoJTIyTHVuYXJMYW5kZXItdjIlMjIpKSUwQW1lYW5fcmV3YXJkJTJDJTIwc3RkX3Jld2FyZCUyMCUzRCUyMGV2YWx1YXRlX3BvbGljeShtb2RlbCUyQyUyMGV2YWxfZW52JTJDJTIwbl9ldmFsX2VwaXNvZGVzJTNEMTAlMkMlMjBkZXRlcm1pbmlzdGljJTNEVHJ1ZSklMEFwcmludChmJTIybWVhbl9yZXdhcmQlM0QlN0JtZWFuX3Jld2FyZCUzQS4yZiU3RCUyMCUyQiUyRi0lMjAlN0JzdGRfcmV3YXJkJTdEJTIyKQ==",highlighted:`<span class="hljs-comment"># @title</span>
eval_env = Monitor(gym.make(<span class="hljs-string">&quot;LunarLander-v2&quot;</span>))
mean_reward, std_reward = evaluate_policy(model, eval_env, n_eval_episodes=<span class="hljs-number">10</span>, deterministic=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;mean_reward=<span class="hljs-subst">{mean_reward:<span class="hljs-number">.2</span>f}</span> +/- <span class="hljs-subst">{std_reward}</span>&quot;</span>)`,wrap:!1}}),Xn=new y({}),ea=new y({}),{c(){b=a("meta"),ss=i(),Ia=a("p"),is=i(),T=a("h1"),D=a("a"),ka=a("span"),m(xe.$$.fragment),Jh=i(),ta=a("span"),ta.textContent=ep,os=i(),m(Ie.$$.fragment),rs=i(),ke=a("p"),ke.textContent=tp,hs=i(),$e=a("img"),ps=i(),Ze=a("p"),Ze.innerHTML=np,us=i(),Be=a("p"),Be.innerHTML=ap,ms=i(),He=a("p"),He.innerHTML=sp,cs=i(),We=a("p"),We.innerHTML=ip,ds=i(),Le=a("p"),Le.innerHTML=op,Ms=i(),Ge=a("p"),Ge.innerHTML=rp,fs=i(),Ee=a("p"),Ee.innerHTML=hp,vs=i(),Re=a("p"),Re.textContent=pp,ys=i(),Se=a("p"),Se.innerHTML=up,ws=i(),Ye=a("p"),Ye.innerHTML=mp,gs=i(),Xe=a("p"),Xe.innerHTML=cp,bs=i(),Ve=a("p"),Ve.innerHTML=dp,Ts=i(),j=a("h1"),q=a("a"),$a=a("span"),m(Ae.$$.fragment),Ch=i(),la=a("span"),la.textContent=Mp,js=i(),O=a("img"),Us=i(),Pe=a("p"),Pe.innerHTML=vp,Js=i(),U=a("h3"),K=a("a"),Za=a("span"),m(Fe.$$.fragment),_h=i(),na=a("span"),na.textContent=yp,Cs=i(),Qe=a("ul"),Qe.innerHTML=wp,_s=i(),J=a("h3"),ee=a("a"),Ba=a("span"),m(Ne.$$.fragment),xh=i(),aa=a("span"),aa.textContent=gp,xs=i(),ze=a("ul"),ze.innerHTML=bp,Is=i(),De=a("p"),De.innerHTML=Tp,ks=i(),C=a("h2"),te=a("a"),Ha=a("span"),m(qe.$$.fragment),Ih=i(),sa=a("span"),sa.textContent=jp,$s=i(),Oe=a("p"),Oe.textContent=Up,Zs=i(),Ke=a("ul"),Ke.innerHTML=Jp,Bs=i(),_=a("h2"),le=a("a"),Wa=a("span"),m(et.$$.fragment),kh=i(),ia=a("span"),ia.textContent=Cp,Hs=i(),tt=a("img"),Ws=i(),lt=a("p"),lt.textContent=xp,Ls=i(),nt=a("ul"),nt.innerHTML=Ip,Gs=i(),at=a("p"),at.textContent=kp,Es=i(),st=a("p"),st.innerHTML=$p,Rs=i(),it=a("p"),it.innerHTML=Zp,Ss=i(),ot=a("p"),ot.innerHTML=Bp,Ys=i(),x=a("h2"),ne=a("a"),La=a("span"),m(rt.$$.fragment),$h=i(),oa=a("span"),oa.textContent=Hp,Xs=i(),ht=a("p"),ht.textContent=Wp,Vs=i(),pt=a("p"),pt.innerHTML=Lp,As=i(),ut=a("p"),ut.innerHTML=Gp,Ps=i(),I=a("h2"),ae=a("a"),Ga=a("span"),m(mt.$$.fragment),Zh=i(),ra=a("span"),ra.textContent=Ep,Fs=i(),se=a("img"),Qs=i(),ct=a("p"),ct.textContent=Sp,Ns=i(),dt=a("ul"),dt.innerHTML=Yp,zs=i(),Mt=a("p"),Mt.innerHTML=Xp,Ds=i(),ft=a("ul"),ft.innerHTML=Vp,qs=i(),k=a("h1"),ie=a("a"),Ea=a("span"),m(vt.$$.fragment),Bh=i(),ha=a("span"),ha.textContent=Ap,Os=i(),$=a("h2"),oe=a("a"),Ra=a("span"),m(yt.$$.fragment),Hh=i(),pa=a("span"),pa.textContent=Pp,Ks=i(),wt=a("p"),wt.innerHTML=Fp,ei=i(),gt=a("p"),gt.innerHTML=Qp,ti=i(),bt=a("p"),bt.innerHTML=Np,li=i(),Z=a("h2"),re=a("a"),Sa=a("span"),m(Tt.$$.fragment),Wh=i(),ua=a("span"),ua.textContent=zp,ni=i(),jt=a("ul"),jt.innerHTML=Dp,ai=i(),Ut=a("img"),si=i(),Jt=a("ul"),Jt.innerHTML=Op,ii=i(),Ct=a("img"),oi=i(),B=a("h2"),he=a("a"),Ya=a("span"),m(_t.$$.fragment),Lh=i(),ma=a("span"),ma.textContent=eu,ri=i(),xt=a("p"),xt.textContent=tu,hi=i(),It=a("ul"),It.innerHTML=lu,pi=i(),kt=a("p"),kt.textContent=nu,ui=i(),m($t.$$.fragment),mi=i(),m(Zt.$$.fragment),ci=i(),Bt=a("p"),Bt.innerHTML=au,di=i(),Ht=a("p"),Ht.textContent=su,Mi=i(),m(Wt.$$.fragment),fi=i(),Lt=a("p"),Lt.innerHTML=iu,vi=i(),m(Gt.$$.fragment),yi=i(),m(Et.$$.fragment),wi=i(),H=a("h2"),pe=a("a"),Xa=a("span"),m(Rt.$$.fragment),Gh=i(),ca=a("span"),ca.textContent=ou,gi=i(),St=a("p"),St.innerHTML=ru,bi=i(),Yt=a("p"),Yt.textContent=hu,Ti=i(),Xt=a("p"),Xt.innerHTML=pu,ji=i(),m(Vt.$$.fragment),Ui=i(),W=a("h2"),ue=a("a"),Va=a("span"),m(At.$$.fragment),Eh=i(),da=a("span"),da.textContent=uu,Ji=i(),Pt=a("p"),Pt.innerHTML=mu,Ci=i(),Ft=a("p"),Ft.innerHTML=cu,_i=i(),Qt=a("p"),Qt.textContent=du,xi=i(),Nt=a("ul"),Nt.innerHTML=Mu,Ii=i(),zt=a("p"),zt.textContent=fu,ki=i(),me=a("img"),$i=i(),Dt=a("p"),Dt.textContent=yu,Zi=i(),qt=a("ul"),qt.innerHTML=wu,Bi=i(),Ot=a("p"),Ot.textContent=gu,Hi=i(),Kt=a("p"),Kt.innerHTML=bu,Wi=i(),el=a("p"),el.innerHTML=Tu,Li=i(),tl=a("p"),tl.textContent=ju,Gi=i(),ll=a("p"),ll.textContent=Uu,Ei=i(),nl=a("p"),nl.innerHTML=Ju,Ri=i(),al=a("ul"),al.innerHTML=Cu,Si=i(),sl=a("p"),sl.innerHTML=_u,Yi=i(),il=a("p"),il.textContent=xu,Xi=i(),ol=a("ul"),ol.innerHTML=Iu,Vi=i(),rl=a("p"),rl.innerHTML=ku,Ai=i(),m(hl.$$.fragment),Pi=i(),L=a("h2"),ce=a("a"),Aa=a("span"),m(pl.$$.fragment),Rh=i(),Ma=a("span"),Ma.textContent=$u,Fi=i(),G=a("h3"),de=a("a"),Pa=a("span"),m(ul.$$.fragment),Sh=i(),fa=a("span"),fa.textContent=Zu,Qi=i(),ml=a("p"),ml.innerHTML=Bu,Ni=i(),zi=a("hr"),Di=i(),cl=a("p"),cl.textContent=Hu,qi=i(),dl=a("p"),dl.innerHTML=Wu,Oi=i(),Ki=a("hr"),eo=i(),Ml=a("p"),Ml.textContent=Lu,to=i(),m(fl.$$.fragment),lo=i(),vl=a("p"),vl.innerHTML=Gu,no=i(),yl=a("ul"),yl.innerHTML=Eu,ao=i(),m(wl.$$.fragment),so=i(),gl=a("p"),gl.textContent=Ru,io=i(),bl=a("ul"),bl.innerHTML=Su,oo=i(),Tl=a("p"),Tl.textContent=Yu,ro=i(),jl=a("p"),jl.innerHTML=Xu,ho=i(),Ul=a("p"),Ul.textContent=Vu,po=i(),Jl=a("ul"),Jl.innerHTML=Au,uo=i(),Cl=a("p"),Cl.innerHTML=Pu,mo=i(),_l=a("p"),_l.innerHTML=Fu,co=i(),E=a("h4"),Me=a("a"),Fa=a("span"),m(xl.$$.fragment),Yh=i(),va=a("span"),va.textContent=Qu,Mo=i(),Il=a("ul"),Il.innerHTML=Nu,fo=i(),m(kl.$$.fragment),vo=i(),R=a("h2"),fe=a("a"),Qa=a("span"),m($l.$$.fragment),Xh=i(),ya=a("span"),ya.textContent=zu,yo=i(),Zl=a("ul"),Zl.innerHTML=Du,wo=i(),go=a("hr"),bo=i(),Bl=a("p"),Bl.innerHTML=qu,To=i(),jo=a("hr"),Uo=i(),Hl=a("img"),Jo=i(),Wl=a("p"),Wl.innerHTML=Ku,Co=i(),Ll=a("p"),Ll.textContent=em,_o=i(),Gl=a("ul"),Gl.innerHTML=tm,xo=i(),El=a("p"),El.textContent=lm,Io=i(),Rl=a("p"),Rl.innerHTML=nm,ko=i(),Sl=a("p"),Sl.innerHTML=am,$o=i(),Yl=a("p"),Yl.innerHTML=sm,Zo=i(),m(Xl.$$.fragment),Bo=i(),m(Vl.$$.fragment),Ho=i(),S=a("h4"),ve=a("a"),Na=a("span"),m(Al.$$.fragment),Vh=i(),wa=a("span"),wa.textContent=im,Wo=i(),m(Pl.$$.fragment),Lo=i(),Y=a("h2"),ye=a("a"),za=a("span"),m(Fl.$$.fragment),Ah=i(),ga=a("span"),ga.textContent=om,Go=jh(`


- Let's train our agent for 1,000,000 timesteps, don't forget to use GPU on Colab. It will take approximately ~20min, but you can use fewer timesteps if you just want to try it out.
- During the training, take a ☕ break you deserved it 🤗

	`),m(Ql.$$.fragment),Eo=i(),X=a("h4"),we=a("a"),Da=a("span"),m(Nl.$$.fragment),Ph=i(),ba=a("span"),ba.textContent=rm,Ro=i(),m(zl.$$.fragment),So=i(),V=a("h2"),ge=a("a"),qa=a("span"),m(Dl.$$.fragment),Fh=i(),Ta=a("span"),Ta.textContent=hm,Yo=i(),ql=a("ul"),ql.innerHTML=pm,Xo=i(),Ol=a("p"),Ol.textContent=um,Vo=i(),m(Kl.$$.fragment),Ao=i(),A=a("h4"),be=a("a"),Oa=a("span"),m(en.$$.fragment),Qh=i(),ja=a("span"),ja.textContent=mm,Po=i(),m(tn.$$.fragment),Fo=i(),ln=a("ul"),ln.innerHTML=cm,Qo=i(),P=a("h2"),Te=a("a"),Ka=a("span"),m(nn.$$.fragment),Nh=i(),Ua=a("span"),Ua.textContent=dm,No=jh(`


Now that we saw we got good results after the training, we can publish our trained model on the hub 🤗 with one line of code.
`),an=a("p"),an.innerHTML=Mm,zo=i(),sn=a("p"),sn.textContent=fm,Do=i(),on=a("p"),on.innerHTML=vm,qo=i(),rn=a("p"),rn.textContent=ym,Oo=i(),hn=a("ul"),hn.innerHTML=wm,Ko=i(),pn=a("p"),pn.textContent=gm,er=i(),un=a("p"),un.innerHTML=bm,tr=i(),mn=a("p"),mn.textContent=Tm,lr=i(),cn=a("ul"),cn.innerHTML=jm,nr=i(),dn=a("img"),ar=i(),Mn=a("ul"),Mn.innerHTML=Jm,sr=i(),m(fn.$$.fragment),ir=i(),vn=a("p"),vn.innerHTML=Cm,or=i(),yn=a("p"),yn.innerHTML=_m,rr=i(),wn=a("p"),wn.innerHTML=xm,hr=i(),gn=a("ul"),gn.innerHTML=Im,pr=i(),bn=a("p"),bn.innerHTML=km,ur=i(),Tn=a("ul"),Tn.innerHTML=$m,mr=i(),m(jn.$$.fragment),cr=i(),F=a("h4"),je=a("a"),es=a("span"),m(Un.$$.fragment),zh=i(),Ja=a("span"),Ja.textContent=Zm,dr=i(),m(Jn.$$.fragment),Mr=i(),Cn=a("p"),Cn.innerHTML=Bm,fr=i(),_n=a("ul"),_n.innerHTML=Hm,vr=i(),xn=a("p"),xn.textContent=Wm,yr=i(),In=a("p"),In.innerHTML=Lm,wr=i(),Q=a("h2"),Ue=a("a"),ts=a("span"),m(kn.$$.fragment),Dh=i(),Ca=a("span"),Ca.textContent=Gm,gr=jh(`


Thanks to [ironbar](https://github.com/ironbar) for the contribution.
`),$n=a("p"),$n.textContent=Em,br=i(),Zn=a("p"),Zn.innerHTML=Rm,Tr=i(),Bn=a("ol"),Bn.innerHTML=Sm,jr=i(),Hn=a("img"),Ur=i(),Je=a("ol"),Je.innerHTML=Xm,Jr=i(),Wn=a("ul"),Wn.innerHTML=Vm,Cr=i(),Ln=a("p"),Ln.textContent=Am,_r=i(),Gn=a("p"),Gn.innerHTML=Pm,xr=i(),m(En.$$.fragment),Ir=i(),m(Rn.$$.fragment),kr=i(),Sn=a("p"),Sn.textContent=Fm,$r=i(),m(Yn.$$.fragment),Zr=i(),N=a("h2"),Ce=a("a"),ls=a("span"),m(Xn.$$.fragment),qh=i(),_a=a("span"),_a.textContent=Qm,Br=jh(`


The best way to learn **is to try things by your own**! As you saw, the current agent is not doing great. As a first suggestion, you can train for more steps. With 1,000,000 steps, we saw some great results!
`),Vn=a("p"),Vn.innerHTML=Nm,Hr=i(),An=a("p"),An.textContent=zm,Wr=i(),Pn=a("ul"),Pn.innerHTML=Dm,Lr=i(),Fn=a("p"),Fn.innerHTML=qm,Gr=i(),Qn=a("p"),Qn.innerHTML=Om,Er=i(),Rr=a("hr"),Sr=i(),Nn=a("p"),Nn.innerHTML=Km,Yr=i(),zn=a("p"),zn.innerHTML=ec,Xr=i(),Dn=a("p"),Dn.innerHTML=tc,Vr=i(),qn=a("p"),qn.innerHTML=lc,Ar=i(),On=a("p"),On.textContent=nc,Pr=i(),Kn=a("img"),Fr=i(),z=a("h2"),_e=a("a"),ns=a("span"),m(ea.$$.fragment),Oh=i(),xa=a("span"),xa.textContent=sc,Qr=i(),as=a("p"),this.h()},l(e){const l=cd("svelte-1phssyn",document.head);b=s(l,"META",{name:!0,content:!0}),l.forEach(t),ss=o(e),Ia=s(e,"P",{}),u(Ia).forEach(t),is=o(e),T=s(e,"H1",{class:!0});var zr=u(T);D=s(zr,"A",{id:!0,class:!0,href:!0});var ic=u(D);ka=s(ic,"SPAN",{});var oc=u(ka);c(xe.$$.fragment,oc),oc.forEach(t),ic.forEach(t),Jh=o(zr),ta=s(zr,"SPAN",{"data-svelte-h":!0}),r(ta)!=="svelte-3j0ua6"&&(ta.textContent=ep),zr.forEach(t),os=o(e),c(Ie.$$.fragment,e),rs=o(e),ke=s(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1fyqzqg"&&(ke.textContent=tp),hs=o(e),$e=s(e,"IMG",{src:!0,alt:!0}),ps=o(e),Ze=s(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-qeetmg"&&(Ze.innerHTML=np),us=o(e),Be=s(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-6a5et3"&&(Be.innerHTML=ap),ms=o(e),He=s(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-1yw7b9f"&&(He.innerHTML=sp),cs=o(e),We=s(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-lt0dbq"&&(We.innerHTML=ip),ds=o(e),Le=s(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1c0nyzi"&&(Le.innerHTML=op),Ms=o(e),Ge=s(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1qkxyrx"&&(Ge.innerHTML=rp),fs=o(e),Ee=s(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-znarat"&&(Ee.innerHTML=hp),vs=o(e),Re=s(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-vkoquy"&&(Re.textContent=pp),ys=o(e),Se=s(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-10pdw2g"&&(Se.innerHTML=up),ws=o(e),Ye=s(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-ur7x3v"&&(Ye.innerHTML=mp),gs=o(e),Xe=s(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-uilrpw"&&(Xe.innerHTML=cp),bs=o(e),Ve=s(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-p9mrd0"&&(Ve.innerHTML=dp),Ts=o(e),j=s(e,"H1",{class:!0});var Dr=u(j);q=s(Dr,"A",{id:!0,class:!0,href:!0});var rc=u(q);$a=s(rc,"SPAN",{});var hc=u($a);c(Ae.$$.fragment,hc),hc.forEach(t),rc.forEach(t),Ch=o(Dr),la=s(Dr,"SPAN",{"data-svelte-h":!0}),r(la)!=="svelte-in0ex"&&(la.textContent=Mp),Dr.forEach(t),js=o(e),O=s(e,"IMG",{src:!0,alt:!0,width:!0}),Us=o(e),Pe=s(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-gtyyy1"&&(Pe.innerHTML=vp),Js=o(e),U=s(e,"H3",{class:!0});var qr=u(U);K=s(qr,"A",{id:!0,class:!0,href:!0});var pc=u(K);Za=s(pc,"SPAN",{});var uc=u(Za);c(Fe.$$.fragment,uc),uc.forEach(t),pc.forEach(t),_h=o(qr),na=s(qr,"SPAN",{"data-svelte-h":!0}),r(na)!=="svelte-annmn1"&&(na.textContent=yp),qr.forEach(t),Cs=o(e),Qe=s(e,"UL",{"data-svelte-h":!0}),r(Qe)!=="svelte-1i75yc"&&(Qe.innerHTML=wp),_s=o(e),J=s(e,"H3",{class:!0});var Or=u(J);ee=s(Or,"A",{id:!0,class:!0,href:!0});var mc=u(ee);Ba=s(mc,"SPAN",{});var cc=u(Ba);c(Ne.$$.fragment,cc),cc.forEach(t),mc.forEach(t),xh=o(Or),aa=s(Or,"SPAN",{"data-svelte-h":!0}),r(aa)!=="svelte-vp4qir"&&(aa.textContent=gp),Or.forEach(t),xs=o(e),ze=s(e,"UL",{"data-svelte-h":!0}),r(ze)!=="svelte-1lt8xht"&&(ze.innerHTML=bp),Is=o(e),De=s(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-1nezll8"&&(De.innerHTML=Tp),ks=o(e),C=s(e,"H2",{class:!0});var Kr=u(C);te=s(Kr,"A",{id:!0,class:!0,href:!0});var dc=u(te);Ha=s(dc,"SPAN",{});var Mc=u(Ha);c(qe.$$.fragment,Mc),Mc.forEach(t),dc.forEach(t),Ih=o(Kr),sa=s(Kr,"SPAN",{"data-svelte-h":!0}),r(sa)!=="svelte-ygr1lr"&&(sa.textContent=jp),Kr.forEach(t),$s=o(e),Oe=s(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-nsjs09"&&(Oe.textContent=Up),Zs=o(e),Ke=s(e,"UL",{"data-svelte-h":!0}),r(Ke)!=="svelte-rzgp9v"&&(Ke.innerHTML=Jp),Bs=o(e),_=s(e,"H2",{class:!0});var eh=u(_);le=s(eh,"A",{id:!0,class:!0,href:!0});var fc=u(le);Wa=s(fc,"SPAN",{});var vc=u(Wa);c(et.$$.fragment,vc),vc.forEach(t),fc.forEach(t),kh=o(eh),ia=s(eh,"SPAN",{"data-svelte-h":!0}),r(ia)!=="svelte-187kpbk"&&(ia.textContent=Cp),eh.forEach(t),Hs=o(e),tt=s(e,"IMG",{src:!0,alt:!0}),Ws=o(e),lt=s(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-6wur6d"&&(lt.textContent=xp),Ls=o(e),nt=s(e,"UL",{"data-svelte-h":!0}),r(nt)!=="svelte-1uvcz43"&&(nt.innerHTML=Ip),Gs=o(e),at=s(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-l0ox3l"&&(at.textContent=kp),Es=o(e),st=s(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-df6xsg"&&(st.innerHTML=$p),Rs=o(e),it=s(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-i91mrq"&&(it.innerHTML=Zp),Ss=o(e),ot=s(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-1sstckl"&&(ot.innerHTML=Bp),Ys=o(e),x=s(e,"H2",{class:!0});var th=u(x);ne=s(th,"A",{id:!0,class:!0,href:!0});var yc=u(ne);La=s(yc,"SPAN",{});var wc=u(La);c(rt.$$.fragment,wc),wc.forEach(t),yc.forEach(t),$h=o(th),oa=s(th,"SPAN",{"data-svelte-h":!0}),r(oa)!=="svelte-14bgx92"&&(oa.textContent=Hp),th.forEach(t),Xs=o(e),ht=s(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-1v25wk6"&&(ht.textContent=Wp),Vs=o(e),pt=s(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-1ex8j5d"&&(pt.innerHTML=Lp),As=o(e),ut=s(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-fgg92r"&&(ut.innerHTML=Gp),Ps=o(e),I=s(e,"H2",{class:!0});var lh=u(I);ae=s(lh,"A",{id:!0,class:!0,href:!0});var gc=u(ae);Ga=s(gc,"SPAN",{});var bc=u(Ga);c(mt.$$.fragment,bc),bc.forEach(t),gc.forEach(t),Zh=o(lh),ra=s(lh,"SPAN",{"data-svelte-h":!0}),r(ra)!=="svelte-bruyah"&&(ra.textContent=Ep),lh.forEach(t),Fs=o(e),se=s(e,"IMG",{src:!0,alt:!0,width:!0}),Qs=o(e),ct=s(e,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-7aaye9"&&(ct.textContent=Sp),Ns=o(e),dt=s(e,"UL",{"data-svelte-h":!0}),r(dt)!=="svelte-1q6p5tv"&&(dt.innerHTML=Yp),zs=o(e),Mt=s(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-vmzi2g"&&(Mt.innerHTML=Xp),Ds=o(e),ft=s(e,"UL",{"data-svelte-h":!0}),r(ft)!=="svelte-15oilwj"&&(ft.innerHTML=Vp),qs=o(e),k=s(e,"H1",{class:!0});var nh=u(k);ie=s(nh,"A",{id:!0,class:!0,href:!0});var Tc=u(ie);Ea=s(Tc,"SPAN",{});var jc=u(Ea);c(vt.$$.fragment,jc),jc.forEach(t),Tc.forEach(t),Bh=o(nh),ha=s(nh,"SPAN",{"data-svelte-h":!0}),r(ha)!=="svelte-fe6rfd"&&(ha.textContent=Ap),nh.forEach(t),Os=o(e),$=s(e,"H2",{class:!0});var ah=u($);oe=s(ah,"A",{id:!0,class:!0,href:!0});var Uc=u(oe);Ra=s(Uc,"SPAN",{});var Jc=u(Ra);c(yt.$$.fragment,Jc),Jc.forEach(t),Uc.forEach(t),Hh=o(ah),pa=s(ah,"SPAN",{"data-svelte-h":!0}),r(pa)!=="svelte-1k3vx16"&&(pa.textContent=Pp),ah.forEach(t),Ks=o(e),wt=s(e,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-1yw7b9f"&&(wt.innerHTML=Fp),ei=o(e),gt=s(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-lt0dbq"&&(gt.innerHTML=Qp),ti=o(e),bt=s(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-1qkxyrx"&&(bt.innerHTML=Np),li=o(e),Z=s(e,"H2",{class:!0});var sh=u(Z);re=s(sh,"A",{id:!0,class:!0,href:!0});var Cc=u(re);Sa=s(Cc,"SPAN",{});var _c=u(Sa);c(Tt.$$.fragment,_c),_c.forEach(t),Cc.forEach(t),Wh=o(sh),ua=s(sh,"SPAN",{"data-svelte-h":!0}),r(ua)!=="svelte-wdjh5x"&&(ua.textContent=zp),sh.forEach(t),ni=o(e),jt=s(e,"UL",{"data-svelte-h":!0}),r(jt)!=="svelte-1funvfi"&&(jt.innerHTML=Dp),ai=o(e),Ut=s(e,"IMG",{src:!0,alt:!0}),si=o(e),Jt=s(e,"UL",{"data-svelte-h":!0}),r(Jt)!=="svelte-1cge6gn"&&(Jt.innerHTML=Op),ii=o(e),Ct=s(e,"IMG",{src:!0,alt:!0}),oi=o(e),B=s(e,"H2",{class:!0});var ih=u(B);he=s(ih,"A",{id:!0,class:!0,href:!0});var xc=u(he);Ya=s(xc,"SPAN",{});var Ic=u(Ya);c(_t.$$.fragment,Ic),Ic.forEach(t),xc.forEach(t),Lh=o(ih),ma=s(ih,"SPAN",{"data-svelte-h":!0}),r(ma)!=="svelte-1mat65y"&&(ma.textContent=eu),ih.forEach(t),ri=o(e),xt=s(e,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-240n94"&&(xt.textContent=tu),hi=o(e),It=s(e,"UL",{"data-svelte-h":!0}),r(It)!=="svelte-176sd9d"&&(It.innerHTML=lu),pi=o(e),kt=s(e,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-yvi6vy"&&(kt.textContent=nu),ui=o(e),c($t.$$.fragment,e),mi=o(e),c(Zt.$$.fragment,e),ci=o(e),Bt=s(e,"P",{"data-svelte-h":!0}),r(Bt)!=="svelte-1t10iqv"&&(Bt.innerHTML=au),di=o(e),Ht=s(e,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-xvjq2n"&&(Ht.textContent=su),Mi=o(e),c(Wt.$$.fragment,e),fi=o(e),Lt=s(e,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-bx852m"&&(Lt.innerHTML=iu),vi=o(e),c(Gt.$$.fragment,e),yi=o(e),c(Et.$$.fragment,e),wi=o(e),H=s(e,"H2",{class:!0});var oh=u(H);pe=s(oh,"A",{id:!0,class:!0,href:!0});var kc=u(pe);Xa=s(kc,"SPAN",{});var $c=u(Xa);c(Rt.$$.fragment,$c),$c.forEach(t),kc.forEach(t),Gh=o(oh),ca=s(oh,"SPAN",{"data-svelte-h":!0}),r(ca)!=="svelte-1oue0e3"&&(ca.textContent=ou),oh.forEach(t),gi=o(e),St=s(e,"P",{"data-svelte-h":!0}),r(St)!=="svelte-1a8ukem"&&(St.innerHTML=ru),bi=o(e),Yt=s(e,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-1ub567"&&(Yt.textContent=hu),Ti=o(e),Xt=s(e,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-179moh"&&(Xt.innerHTML=pu),ji=o(e),c(Vt.$$.fragment,e),Ui=o(e),W=s(e,"H2",{class:!0});var rh=u(W);ue=s(rh,"A",{id:!0,class:!0,href:!0});var Zc=u(ue);Va=s(Zc,"SPAN",{});var Bc=u(Va);c(At.$$.fragment,Bc),Bc.forEach(t),Zc.forEach(t),Eh=o(rh),da=s(rh,"SPAN",{"data-svelte-h":!0}),r(da)!=="svelte-1hcqvhl"&&(da.textContent=uu),rh.forEach(t),Ji=o(e),Pt=s(e,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-18clawh"&&(Pt.innerHTML=mu),Ci=o(e),Ft=s(e,"P",{"data-svelte-h":!0}),r(Ft)!=="svelte-4pwxen"&&(Ft.innerHTML=cu),_i=o(e),Qt=s(e,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-1omhoff"&&(Qt.textContent=du),xi=o(e),Nt=s(e,"UL",{"data-svelte-h":!0}),r(Nt)!=="svelte-1gr0wpr"&&(Nt.innerHTML=Mu),Ii=o(e),zt=s(e,"P",{"data-svelte-h":!0}),r(zt)!=="svelte-1d4ybay"&&(zt.textContent=fu),ki=o(e),me=s(e,"IMG",{src:!0,alt:!0,width:!0}),$i=o(e),Dt=s(e,"P",{"data-svelte-h":!0}),r(Dt)!=="svelte-1buylsu"&&(Dt.textContent=yu),Zi=o(e),qt=s(e,"UL",{"data-svelte-h":!0}),r(qt)!=="svelte-18q8eyd"&&(qt.innerHTML=wu),Bi=o(e),Ot=s(e,"P",{"data-svelte-h":!0}),r(Ot)!=="svelte-1vqqw6i"&&(Ot.textContent=gu),Hi=o(e),Kt=s(e,"P",{"data-svelte-h":!0}),r(Kt)!=="svelte-13b9y4a"&&(Kt.innerHTML=bu),Wi=o(e),el=s(e,"P",{"data-svelte-h":!0}),r(el)!=="svelte-1bdnzh6"&&(el.innerHTML=Tu),Li=o(e),tl=s(e,"P",{"data-svelte-h":!0}),r(tl)!=="svelte-1buylsu"&&(tl.textContent=ju),Gi=o(e),ll=s(e,"P",{"data-svelte-h":!0}),r(ll)!=="svelte-5kldyy"&&(ll.textContent=Uu),Ei=o(e),nl=s(e,"P",{"data-svelte-h":!0}),r(nl)!=="svelte-55e9cg"&&(nl.innerHTML=Ju),Ri=o(e),al=s(e,"UL",{"data-svelte-h":!0}),r(al)!=="svelte-xz0jlk"&&(al.innerHTML=Cu),Si=o(e),sl=s(e,"P",{"data-svelte-h":!0}),r(sl)!=="svelte-1w6llkl"&&(sl.innerHTML=_u),Yi=o(e),il=s(e,"P",{"data-svelte-h":!0}),r(il)!=="svelte-4sv61e"&&(il.textContent=xu),Xi=o(e),ol=s(e,"UL",{"data-svelte-h":!0}),r(ol)!=="svelte-14fsfpn"&&(ol.innerHTML=Iu),Vi=o(e),rl=s(e,"P",{"data-svelte-h":!0}),r(rl)!=="svelte-1gwp7j4"&&(rl.innerHTML=ku),Ai=o(e),c(hl.$$.fragment,e),Pi=o(e),L=s(e,"H2",{class:!0});var hh=u(L);ce=s(hh,"A",{id:!0,class:!0,href:!0});var Hc=u(ce);Aa=s(Hc,"SPAN",{});var Wc=u(Aa);c(pl.$$.fragment,Wc),Wc.forEach(t),Hc.forEach(t),Rh=o(hh),Ma=s(hh,"SPAN",{"data-svelte-h":!0}),r(Ma)!=="svelte-l55slk"&&(Ma.textContent=$u),hh.forEach(t),Fi=o(e),G=s(e,"H3",{class:!0});var ph=u(G);de=s(ph,"A",{id:!0,class:!0,href:!0});var Lc=u(de);Pa=s(Lc,"SPAN",{});var Gc=u(Pa);c(ul.$$.fragment,Gc),Gc.forEach(t),Lc.forEach(t),Sh=o(ph),fa=s(ph,"SPAN",{"data-svelte-h":!0}),r(fa)!=="svelte-annmn1"&&(fa.textContent=Zu),ph.forEach(t),Qi=o(e),ml=s(e,"P",{"data-svelte-h":!0}),r(ml)!=="svelte-2un6m0"&&(ml.innerHTML=Bu),Ni=o(e),zi=s(e,"HR",{}),Di=o(e),cl=s(e,"P",{"data-svelte-h":!0}),r(cl)!=="svelte-15dw51a"&&(cl.textContent=Hu),qi=o(e),dl=s(e,"P",{"data-svelte-h":!0}),r(dl)!=="svelte-jnu6xx"&&(dl.innerHTML=Wu),Oi=o(e),Ki=s(e,"HR",{}),eo=o(e),Ml=s(e,"P",{"data-svelte-h":!0}),r(Ml)!=="svelte-mlxrgb"&&(Ml.textContent=Lu),to=o(e),c(fl.$$.fragment,e),lo=o(e),vl=s(e,"P",{"data-svelte-h":!0}),r(vl)!=="svelte-1dc7m7j"&&(vl.innerHTML=Gu),no=o(e),yl=s(e,"UL",{"data-svelte-h":!0}),r(yl)!=="svelte-gm5axf"&&(yl.innerHTML=Eu),ao=o(e),c(wl.$$.fragment,e),so=o(e),gl=s(e,"P",{"data-svelte-h":!0}),r(gl)!=="svelte-l9gcgq"&&(gl.textContent=Ru),io=o(e),bl=s(e,"UL",{"data-svelte-h":!0}),r(bl)!=="svelte-1gafu9z"&&(bl.innerHTML=Su),oo=o(e),Tl=s(e,"P",{"data-svelte-h":!0}),r(Tl)!=="svelte-pqdpyc"&&(Tl.textContent=Yu),ro=o(e),jl=s(e,"P",{"data-svelte-h":!0}),r(jl)!=="svelte-163y6uv"&&(jl.innerHTML=Xu),ho=o(e),Ul=s(e,"P",{"data-svelte-h":!0}),r(Ul)!=="svelte-1er0mm6"&&(Ul.textContent=Vu),po=o(e),Jl=s(e,"UL",{"data-svelte-h":!0}),r(Jl)!=="svelte-1yozgp2"&&(Jl.innerHTML=Au),uo=o(e),Cl=s(e,"P",{"data-svelte-h":!0}),r(Cl)!=="svelte-b6qau5"&&(Cl.innerHTML=Pu),mo=o(e),_l=s(e,"P",{"data-svelte-h":!0}),r(_l)!=="svelte-ta04ov"&&(_l.innerHTML=Fu),co=o(e),E=s(e,"H4",{class:!0});var uh=u(E);Me=s(uh,"A",{id:!0,class:!0,href:!0});var Ec=u(Me);Fa=s(Ec,"SPAN",{});var Rc=u(Fa);c(xl.$$.fragment,Rc),Rc.forEach(t),Ec.forEach(t),Yh=o(uh),va=s(uh,"SPAN",{"data-svelte-h":!0}),r(va)!=="svelte-1ln69ih"&&(va.textContent=Qu),uh.forEach(t),Mo=o(e),Il=s(e,"UL",{"data-svelte-h":!0}),r(Il)!=="svelte-8jx2x9"&&(Il.innerHTML=Nu),fo=o(e),c(kl.$$.fragment,e),vo=o(e),R=s(e,"H2",{class:!0});var mh=u(R);fe=s(mh,"A",{id:!0,class:!0,href:!0});var Sc=u(fe);Qa=s(Sc,"SPAN",{});var Yc=u(Qa);c($l.$$.fragment,Yc),Yc.forEach(t),Sc.forEach(t),Xh=o(mh),ya=s(mh,"SPAN",{"data-svelte-h":!0}),r(ya)!=="svelte-r2py2x"&&(ya.textContent=zu),mh.forEach(t),yo=o(e),Zl=s(e,"UL",{"data-svelte-h":!0}),r(Zl)!=="svelte-1zi2xo"&&(Zl.innerHTML=Du),wo=o(e),go=s(e,"HR",{}),bo=o(e),Bl=s(e,"P",{"data-svelte-h":!0}),r(Bl)!=="svelte-157uj5u"&&(Bl.innerHTML=qu),To=o(e),jo=s(e,"HR",{}),Uo=o(e),Hl=s(e,"IMG",{src:!0,alt:!0}),Jo=o(e),Wl=s(e,"P",{"data-svelte-h":!0}),r(Wl)!=="svelte-1blqo6u"&&(Wl.innerHTML=Ku),Co=o(e),Ll=s(e,"P",{"data-svelte-h":!0}),r(Ll)!=="svelte-1j8t0lq"&&(Ll.textContent=em),_o=o(e),Gl=s(e,"UL",{"data-svelte-h":!0}),r(Gl)!=="svelte-hdfg8e"&&(Gl.innerHTML=tm),xo=o(e),El=s(e,"P",{"data-svelte-h":!0}),r(El)!=="svelte-80yx2p"&&(El.textContent=lm),Io=o(e),Rl=s(e,"P",{"data-svelte-h":!0}),r(Rl)!=="svelte-1b4vrh6"&&(Rl.innerHTML=nm),ko=o(e),Sl=s(e,"P",{"data-svelte-h":!0}),r(Sl)!=="svelte-122u5fk"&&(Sl.innerHTML=am),$o=o(e),Yl=s(e,"P",{"data-svelte-h":!0}),r(Yl)!=="svelte-12b0l2y"&&(Yl.innerHTML=sm),Zo=o(e),c(Xl.$$.fragment,e),Bo=o(e),c(Vl.$$.fragment,e),Ho=o(e),S=s(e,"H4",{class:!0});var ch=u(S);ve=s(ch,"A",{id:!0,class:!0,href:!0});var Xc=u(ve);Na=s(Xc,"SPAN",{});var Vc=u(Na);c(Al.$$.fragment,Vc),Vc.forEach(t),Xc.forEach(t),Vh=o(ch),wa=s(ch,"SPAN",{"data-svelte-h":!0}),r(wa)!=="svelte-13h1zkw"&&(wa.textContent=im),ch.forEach(t),Wo=o(e),c(Pl.$$.fragment,e),Lo=o(e),Y=s(e,"H2",{class:!0});var dh=u(Y);ye=s(dh,"A",{id:!0,class:!0,href:!0});var Ac=u(ye);za=s(Ac,"SPAN",{});var Pc=u(za);c(Fl.$$.fragment,Pc),Pc.forEach(t),Ac.forEach(t),Ah=o(dh),ga=s(dh,"SPAN",{"data-svelte-h":!0}),r(ga)!=="svelte-1idwsrf"&&(ga.textContent=om),dh.forEach(t),Go=Uh(e,`


- Let's train our agent for 1,000,000 timesteps, don't forget to use GPU on Colab. It will take approximately ~20min, but you can use fewer timesteps if you just want to try it out.
- During the training, take a ☕ break you deserved it 🤗

	`),c(Ql.$$.fragment,e),Eo=o(e),X=s(e,"H4",{class:!0});var Mh=u(X);we=s(Mh,"A",{id:!0,class:!0,href:!0});var Fc=u(we);Da=s(Fc,"SPAN",{});var Qc=u(Da);c(Nl.$$.fragment,Qc),Qc.forEach(t),Fc.forEach(t),Ph=o(Mh),ba=s(Mh,"SPAN",{"data-svelte-h":!0}),r(ba)!=="svelte-13h1zkw"&&(ba.textContent=rm),Mh.forEach(t),Ro=o(e),c(zl.$$.fragment,e),So=o(e),V=s(e,"H2",{class:!0});var fh=u(V);ge=s(fh,"A",{id:!0,class:!0,href:!0});var Nc=u(ge);qa=s(Nc,"SPAN",{});var zc=u(qa);c(Dl.$$.fragment,zc),zc.forEach(t),Nc.forEach(t),Fh=o(fh),Ta=s(fh,"SPAN",{"data-svelte-h":!0}),r(Ta)!=="svelte-119enb5"&&(Ta.textContent=hm),fh.forEach(t),Yo=o(e),ql=s(e,"UL",{"data-svelte-h":!0}),r(ql)!=="svelte-dmghau"&&(ql.innerHTML=pm),Xo=o(e),Ol=s(e,"P",{"data-svelte-h":!0}),r(Ol)!=="svelte-11gty83"&&(Ol.textContent=um),Vo=o(e),c(Kl.$$.fragment,e),Ao=o(e),A=s(e,"H4",{class:!0});var vh=u(A);be=s(vh,"A",{id:!0,class:!0,href:!0});var Dc=u(be);Oa=s(Dc,"SPAN",{});var qc=u(Oa);c(en.$$.fragment,qc),qc.forEach(t),Dc.forEach(t),Qh=o(vh),ja=s(vh,"SPAN",{"data-svelte-h":!0}),r(ja)!=="svelte-13h1zkw"&&(ja.textContent=mm),vh.forEach(t),Po=o(e),c(tn.$$.fragment,e),Fo=o(e),ln=s(e,"UL",{"data-svelte-h":!0}),r(ln)!=="svelte-oku03u"&&(ln.innerHTML=cm),Qo=o(e),P=s(e,"H2",{class:!0});var yh=u(P);Te=s(yh,"A",{id:!0,class:!0,href:!0});var Oc=u(Te);Ka=s(Oc,"SPAN",{});var Kc=u(Ka);c(nn.$$.fragment,Kc),Kc.forEach(t),Oc.forEach(t),Nh=o(yh),Ua=s(yh,"SPAN",{"data-svelte-h":!0}),r(Ua)!=="svelte-a4wiux"&&(Ua.textContent=dm),yh.forEach(t),No=Uh(e,`


Now that we saw we got good results after the training, we can publish our trained model on the hub 🤗 with one line of code.
`),an=s(e,"P",{"data-svelte-h":!0}),r(an)!=="svelte-1vcevn6"&&(an.innerHTML=Mm),zo=o(e),sn=s(e,"P",{"data-svelte-h":!0}),r(sn)!=="svelte-w1lcgd"&&(sn.textContent=fm),Do=o(e),on=s(e,"P",{"data-svelte-h":!0}),r(on)!=="svelte-1r6eiir"&&(on.innerHTML=vm),qo=o(e),rn=s(e,"P",{"data-svelte-h":!0}),r(rn)!=="svelte-vgzxi7"&&(rn.textContent=ym),Oo=o(e),hn=s(e,"UL",{"data-svelte-h":!0}),r(hn)!=="svelte-19ddql5"&&(hn.innerHTML=wm),Ko=o(e),pn=s(e,"P",{"data-svelte-h":!0}),r(pn)!=="svelte-6k9qpu"&&(pn.textContent=gm),er=o(e),un=s(e,"P",{"data-svelte-h":!0}),r(un)!=="svelte-7v2fwq"&&(un.innerHTML=bm),tr=o(e),mn=s(e,"P",{"data-svelte-h":!0}),r(mn)!=="svelte-1cn3tld"&&(mn.textContent=Tm),lr=o(e),cn=s(e,"UL",{"data-svelte-h":!0}),r(cn)!=="svelte-19b5tev"&&(cn.innerHTML=jm),nr=o(e),dn=s(e,"IMG",{src:!0,alt:!0}),ar=o(e),Mn=s(e,"UL",{"data-svelte-h":!0}),r(Mn)!=="svelte-ricdz6"&&(Mn.innerHTML=Jm),sr=o(e),c(fn.$$.fragment,e),ir=o(e),vn=s(e,"P",{"data-svelte-h":!0}),r(vn)!=="svelte-1g9v6di"&&(vn.innerHTML=Cm),or=o(e),yn=s(e,"P",{"data-svelte-h":!0}),r(yn)!=="svelte-1enm9m5"&&(yn.innerHTML=_m),rr=o(e),wn=s(e,"P",{"data-svelte-h":!0}),r(wn)!=="svelte-1bz1l0q"&&(wn.innerHTML=xm),hr=o(e),gn=s(e,"UL",{"data-svelte-h":!0}),r(gn)!=="svelte-1lm8teg"&&(gn.innerHTML=Im),pr=o(e),bn=s(e,"P",{"data-svelte-h":!0}),r(bn)!=="svelte-11ha3rd"&&(bn.innerHTML=km),ur=o(e),Tn=s(e,"UL",{"data-svelte-h":!0}),r(Tn)!=="svelte-10dry3f"&&(Tn.innerHTML=$m),mr=o(e),c(jn.$$.fragment,e),cr=o(e),F=s(e,"H4",{class:!0});var wh=u(F);je=s(wh,"A",{id:!0,class:!0,href:!0});var ed=u(je);es=s(ed,"SPAN",{});var td=u(es);c(Un.$$.fragment,td),td.forEach(t),ed.forEach(t),zh=o(wh),Ja=s(wh,"SPAN",{"data-svelte-h":!0}),r(Ja)!=="svelte-13h1zkw"&&(Ja.textContent=Zm),wh.forEach(t),dr=o(e),c(Jn.$$.fragment,e),Mr=o(e),Cn=s(e,"P",{"data-svelte-h":!0}),r(Cn)!=="svelte-hp3w20"&&(Cn.innerHTML=Bm),fr=o(e),_n=s(e,"UL",{"data-svelte-h":!0}),r(_n)!=="svelte-123gpq9"&&(_n.innerHTML=Hm),vr=o(e),xn=s(e,"P",{"data-svelte-h":!0}),r(xn)!=="svelte-1pr3qlz"&&(xn.textContent=Wm),yr=o(e),In=s(e,"P",{"data-svelte-h":!0}),r(In)!=="svelte-1ekdy5l"&&(In.innerHTML=Lm),wr=o(e),Q=s(e,"H2",{class:!0});var gh=u(Q);Ue=s(gh,"A",{id:!0,class:!0,href:!0});var ld=u(Ue);ts=s(ld,"SPAN",{});var nd=u(ts);c(kn.$$.fragment,nd),nd.forEach(t),ld.forEach(t),Dh=o(gh),Ca=s(gh,"SPAN",{"data-svelte-h":!0}),r(Ca)!=="svelte-11ogv05"&&(Ca.textContent=Gm),gh.forEach(t),gr=Uh(e,`


Thanks to [ironbar](https://github.com/ironbar) for the contribution.
`),$n=s(e,"P",{"data-svelte-h":!0}),r($n)!=="svelte-j6e6xs"&&($n.textContent=Em),br=o(e),Zn=s(e,"P",{"data-svelte-h":!0}),r(Zn)!=="svelte-1u6nkgv"&&(Zn.innerHTML=Rm),Tr=o(e),Bn=s(e,"OL",{"data-svelte-h":!0}),r(Bn)!=="svelte-prvn3y"&&(Bn.innerHTML=Sm),jr=o(e),Hn=s(e,"IMG",{src:!0,alt:!0}),Ur=o(e),Je=s(e,"OL",{start:!0,"data-svelte-h":!0}),r(Je)!=="svelte-w87ej2"&&(Je.innerHTML=Xm),Jr=o(e),Wn=s(e,"UL",{"data-svelte-h":!0}),r(Wn)!=="svelte-uec4xf"&&(Wn.innerHTML=Vm),Cr=o(e),Ln=s(e,"P",{"data-svelte-h":!0}),r(Ln)!=="svelte-13gqrjl"&&(Ln.textContent=Am),_r=o(e),Gn=s(e,"P",{"data-svelte-h":!0}),r(Gn)!=="svelte-ytxq9m"&&(Gn.innerHTML=Pm),xr=o(e),c(En.$$.fragment,e),Ir=o(e),c(Rn.$$.fragment,e),kr=o(e),Sn=s(e,"P",{"data-svelte-h":!0}),r(Sn)!=="svelte-1nd8fiz"&&(Sn.textContent=Fm),$r=o(e),c(Yn.$$.fragment,e),Zr=o(e),N=s(e,"H2",{class:!0});var bh=u(N);Ce=s(bh,"A",{id:!0,class:!0,href:!0});var ad=u(Ce);ls=s(ad,"SPAN",{});var sd=u(ls);c(Xn.$$.fragment,sd),sd.forEach(t),ad.forEach(t),qh=o(bh),_a=s(bh,"SPAN",{"data-svelte-h":!0}),r(_a)!=="svelte-a17ig2"&&(_a.textContent=Qm),bh.forEach(t),Br=Uh(e,`


The best way to learn **is to try things by your own**! As you saw, the current agent is not doing great. As a first suggestion, you can train for more steps. With 1,000,000 steps, we saw some great results!
`),Vn=s(e,"P",{"data-svelte-h":!0}),r(Vn)!=="svelte-131ixzr"&&(Vn.innerHTML=Nm),Hr=o(e),An=s(e,"P",{"data-svelte-h":!0}),r(An)!=="svelte-qrxvcm"&&(An.textContent=zm),Wr=o(e),Pn=s(e,"UL",{"data-svelte-h":!0}),r(Pn)!=="svelte-11s3zll"&&(Pn.innerHTML=Dm),Lr=o(e),Fn=s(e,"P",{"data-svelte-h":!0}),r(Fn)!=="svelte-1dyozfn"&&(Fn.innerHTML=qm),Gr=o(e),Qn=s(e,"P",{"data-svelte-h":!0}),r(Qn)!=="svelte-otwf19"&&(Qn.innerHTML=Om),Er=o(e),Rr=s(e,"HR",{}),Sr=o(e),Nn=s(e,"P",{"data-svelte-h":!0}),r(Nn)!=="svelte-4ab4sp"&&(Nn.innerHTML=Km),Yr=o(e),zn=s(e,"P",{"data-svelte-h":!0}),r(zn)!=="svelte-zyppti"&&(zn.innerHTML=ec),Xr=o(e),Dn=s(e,"P",{"data-svelte-h":!0}),r(Dn)!=="svelte-6h5jhw"&&(Dn.innerHTML=tc),Vr=o(e),qn=s(e,"P",{"data-svelte-h":!0}),r(qn)!=="svelte-7f0plk"&&(qn.innerHTML=lc),Ar=o(e),On=s(e,"P",{"data-svelte-h":!0}),r(On)!=="svelte-6b51l9"&&(On.textContent=nc),Pr=o(e),Kn=s(e,"IMG",{src:!0,alt:!0}),Fr=o(e),z=s(e,"H2",{class:!0});var Th=u(z);_e=s(Th,"A",{id:!0,class:!0,href:!0});var id=u(_e);ns=s(id,"SPAN",{});var od=u(ns);c(ea.$$.fragment,od),od.forEach(t),id.forEach(t),Oh=o(Th),xa=s(Th,"SPAN",{"data-svelte-h":!0}),r(xa)!=="svelte-i9a3z3"&&(xa.textContent=sc),Th.forEach(t),Qr=o(e),as=s(e,"P",{}),u(as).forEach(t),this.h()},h(){h(b,"name","hf:doc:metadata"),h(b,"content",JSON.stringify(fd)),h(D,"id","hands-on"),h(D,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(D,"href","#hands-on"),h(T,"class","relative group"),g($e.src,lp="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit1/lunarLander.gif")||h($e,"src",lp),h($e,"alt","LunarLander"),h(q,"id","unit-1-train-your-first-deep-reinforcement-learning-agent"),h(q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(q,"href","#unit-1-train-your-first-deep-reinforcement-learning-agent"),h(j,"class","relative group"),g(O.src,fp="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit1/thumbnail.jpg")||h(O,"src",fp),h(O,"alt","Unit 1 thumbnail"),h(O,"width","100%"),h(K,"id","the-environment"),h(K,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(K,"href","#the-environment"),h(U,"class","relative group"),h(ee,"id","the-library-used"),h(ee,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(ee,"href","#the-library-used"),h(J,"class","relative group"),h(te,"id","objectives-of-this-notebook"),h(te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(te,"href","#objectives-of-this-notebook"),h(C,"class","relative group"),h(le,"id","this-notebook-is-from-deep-reinforcement-learning-course"),h(le,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(le,"href","#this-notebook-is-from-deep-reinforcement-learning-course"),h(_,"class","relative group"),g(tt.src,_p="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/deep-rl-course-illustration.jpg")||h(tt,"src",_p),h(tt,"alt","Deep RL Course illustration"),h(ne,"id","prerequisites"),h(ne,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(ne,"href","#prerequisites"),h(x,"class","relative group"),h(ae,"id","a-small-recap-of-deep-reinforcement-learning"),h(ae,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(ae,"href","#a-small-recap-of-deep-reinforcement-learning"),h(I,"class","relative group"),g(se.src,Rp="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit1/RL_process_game.jpg")||h(se,"src",Rp),h(se,"alt","The RL process"),h(se,"width","100%"),h(ie,"id","lets-train-our-first-deep-reinforcement-learning-agent-and-upload-it-to-the-hub"),h(ie,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(ie,"href","#lets-train-our-first-deep-reinforcement-learning-agent-and-upload-it-to-the-hub"),h(k,"class","relative group"),h(oe,"id","get-a-certificate"),h(oe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(oe,"href","#get-a-certificate"),h($,"class","relative group"),h(re,"id","set-the-gpu"),h(re,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(re,"href","#set-the-gpu"),h(Z,"class","relative group"),g(Ut.src,qp="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/gpu-step1.jpg")||h(Ut,"src",qp),h(Ut,"alt","GPU Step 1"),g(Ct.src,Kp="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/gpu-step2.jpg")||h(Ct,"src",Kp),h(Ct,"alt","GPU Step 2"),h(he,"id","install-dependencies-and-create-a-virtual-screen"),h(he,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(he,"href","#install-dependencies-and-create-a-virtual-screen"),h(B,"class","relative group"),h(pe,"id","import-the-packages"),h(pe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(pe,"href","#import-the-packages"),h(H,"class","relative group"),h(ue,"id","understand-gymnasium-and-how-it-works"),h(ue,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(ue,"href","#understand-gymnasium-and-how-it-works"),h(W,"class","relative group"),g(me.src,vu="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit1/RL_process_game.jpg")||h(me,"src",vu),h(me,"alt","The RL process"),h(me,"width","100%"),h(ce,"id","create-the-lunarlander-environment-and-understand-how-it-works"),h(ce,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(ce,"href","#create-the-lunarlander-environment-and-understand-how-it-works"),h(L,"class","relative group"),h(de,"id","the-environment"),h(de,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(de,"href","#the-environment"),h(G,"class","relative group"),h(Me,"id","vectorized-environment"),h(Me,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(Me,"href","#vectorized-environment"),h(E,"class","relative group"),h(fe,"id","create-the-model"),h(fe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(fe,"href","#create-the-model"),h(R,"class","relative group"),g(Hl.src,Ou="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit1/sb3.png")||h(Hl,"src",Ou),h(Hl,"alt","Stable Baselines3"),h(ve,"id","solution"),h(ve,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(ve,"href","#solution"),h(S,"class","relative group"),h(ye,"id","train-the-ppo-agent"),h(ye,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(ye,"href","#train-the-ppo-agent"),h(Y,"class","relative group"),h(we,"id","solution"),h(we,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(we,"href","#solution"),h(X,"class","relative group"),h(ge,"id","evaluate-the-agent"),h(ge,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(ge,"href","#evaluate-the-agent"),h(V,"class","relative group"),h(be,"id","solution"),h(be,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(be,"href","#solution"),h(A,"class","relative group"),h(Te,"id","publish-our-trained-model-on-the-hub"),h(Te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(Te,"href","#publish-our-trained-model-on-the-hub"),h(P,"class","relative group"),g(dn.src,Um="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/create-token.jpg")||h(dn,"src",Um),h(dn,"alt","Create HF Token"),h(je,"id","solution"),h(je,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(je,"href","#solution"),h(F,"class","relative group"),h(Ue,"id","load-a-saved-lunarlander-model-from-the-hub"),h(Ue,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(Ue,"href","#load-a-saved-lunarlander-model-from-the-hub"),h(Q,"class","relative group"),g(Hn.src,Ym="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/unit1/copy-id.png")||h(Hn,"src",Ym),h(Hn,"alt","Copy-id"),h(Je,"start","2"),h(Ce,"id","some-additional-challenges"),h(Ce,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(Ce,"href","#some-additional-challenges"),h(N,"class","relative group"),g(Kn.src,ac="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/unit1/huggy.jpg")||h(Kn,"src",ac),h(Kn,"alt","Huggy"),h(_e,"id","keep-learning-stay-awesome"),h(_e,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(_e,"href","#keep-learning-stay-awesome"),h(z,"class","relative group")},m(e,l){p(document.head,b),n(e,ss,l),n(e,Ia,l),n(e,is,l),n(e,T,l),p(T,D),p(D,ka),d(xe,ka,null),p(T,Jh),p(T,ta),n(e,os,l),d(Ie,e,l),n(e,rs,l),n(e,ke,l),n(e,hs,l),n(e,$e,l),n(e,ps,l),n(e,Ze,l),n(e,us,l),n(e,Be,l),n(e,ms,l),n(e,He,l),n(e,cs,l),n(e,We,l),n(e,ds,l),n(e,Le,l),n(e,Ms,l),n(e,Ge,l),n(e,fs,l),n(e,Ee,l),n(e,vs,l),n(e,Re,l),n(e,ys,l),n(e,Se,l),n(e,ws,l),n(e,Ye,l),n(e,gs,l),n(e,Xe,l),n(e,bs,l),n(e,Ve,l),n(e,Ts,l),n(e,j,l),p(j,q),p(q,$a),d(Ae,$a,null),p(j,Ch),p(j,la),n(e,js,l),n(e,O,l),n(e,Us,l),n(e,Pe,l),n(e,Js,l),n(e,U,l),p(U,K),p(K,Za),d(Fe,Za,null),p(U,_h),p(U,na),n(e,Cs,l),n(e,Qe,l),n(e,_s,l),n(e,J,l),p(J,ee),p(ee,Ba),d(Ne,Ba,null),p(J,xh),p(J,aa),n(e,xs,l),n(e,ze,l),n(e,Is,l),n(e,De,l),n(e,ks,l),n(e,C,l),p(C,te),p(te,Ha),d(qe,Ha,null),p(C,Ih),p(C,sa),n(e,$s,l),n(e,Oe,l),n(e,Zs,l),n(e,Ke,l),n(e,Bs,l),n(e,_,l),p(_,le),p(le,Wa),d(et,Wa,null),p(_,kh),p(_,ia),n(e,Hs,l),n(e,tt,l),n(e,Ws,l),n(e,lt,l),n(e,Ls,l),n(e,nt,l),n(e,Gs,l),n(e,at,l),n(e,Es,l),n(e,st,l),n(e,Rs,l),n(e,it,l),n(e,Ss,l),n(e,ot,l),n(e,Ys,l),n(e,x,l),p(x,ne),p(ne,La),d(rt,La,null),p(x,$h),p(x,oa),n(e,Xs,l),n(e,ht,l),n(e,Vs,l),n(e,pt,l),n(e,As,l),n(e,ut,l),n(e,Ps,l),n(e,I,l),p(I,ae),p(ae,Ga),d(mt,Ga,null),p(I,Zh),p(I,ra),n(e,Fs,l),n(e,se,l),n(e,Qs,l),n(e,ct,l),n(e,Ns,l),n(e,dt,l),n(e,zs,l),n(e,Mt,l),n(e,Ds,l),n(e,ft,l),n(e,qs,l),n(e,k,l),p(k,ie),p(ie,Ea),d(vt,Ea,null),p(k,Bh),p(k,ha),n(e,Os,l),n(e,$,l),p($,oe),p(oe,Ra),d(yt,Ra,null),p($,Hh),p($,pa),n(e,Ks,l),n(e,wt,l),n(e,ei,l),n(e,gt,l),n(e,ti,l),n(e,bt,l),n(e,li,l),n(e,Z,l),p(Z,re),p(re,Sa),d(Tt,Sa,null),p(Z,Wh),p(Z,ua),n(e,ni,l),n(e,jt,l),n(e,ai,l),n(e,Ut,l),n(e,si,l),n(e,Jt,l),n(e,ii,l),n(e,Ct,l),n(e,oi,l),n(e,B,l),p(B,he),p(he,Ya),d(_t,Ya,null),p(B,Lh),p(B,ma),n(e,ri,l),n(e,xt,l),n(e,hi,l),n(e,It,l),n(e,pi,l),n(e,kt,l),n(e,ui,l),d($t,e,l),n(e,mi,l),d(Zt,e,l),n(e,ci,l),n(e,Bt,l),n(e,di,l),n(e,Ht,l),n(e,Mi,l),d(Wt,e,l),n(e,fi,l),n(e,Lt,l),n(e,vi,l),d(Gt,e,l),n(e,yi,l),d(Et,e,l),n(e,wi,l),n(e,H,l),p(H,pe),p(pe,Xa),d(Rt,Xa,null),p(H,Gh),p(H,ca),n(e,gi,l),n(e,St,l),n(e,bi,l),n(e,Yt,l),n(e,Ti,l),n(e,Xt,l),n(e,ji,l),d(Vt,e,l),n(e,Ui,l),n(e,W,l),p(W,ue),p(ue,Va),d(At,Va,null),p(W,Eh),p(W,da),n(e,Ji,l),n(e,Pt,l),n(e,Ci,l),n(e,Ft,l),n(e,_i,l),n(e,Qt,l),n(e,xi,l),n(e,Nt,l),n(e,Ii,l),n(e,zt,l),n(e,ki,l),n(e,me,l),n(e,$i,l),n(e,Dt,l),n(e,Zi,l),n(e,qt,l),n(e,Bi,l),n(e,Ot,l),n(e,Hi,l),n(e,Kt,l),n(e,Wi,l),n(e,el,l),n(e,Li,l),n(e,tl,l),n(e,Gi,l),n(e,ll,l),n(e,Ei,l),n(e,nl,l),n(e,Ri,l),n(e,al,l),n(e,Si,l),n(e,sl,l),n(e,Yi,l),n(e,il,l),n(e,Xi,l),n(e,ol,l),n(e,Vi,l),n(e,rl,l),n(e,Ai,l),d(hl,e,l),n(e,Pi,l),n(e,L,l),p(L,ce),p(ce,Aa),d(pl,Aa,null),p(L,Rh),p(L,Ma),n(e,Fi,l),n(e,G,l),p(G,de),p(de,Pa),d(ul,Pa,null),p(G,Sh),p(G,fa),n(e,Qi,l),n(e,ml,l),n(e,Ni,l),n(e,zi,l),n(e,Di,l),n(e,cl,l),n(e,qi,l),n(e,dl,l),n(e,Oi,l),n(e,Ki,l),n(e,eo,l),n(e,Ml,l),n(e,to,l),d(fl,e,l),n(e,lo,l),n(e,vl,l),n(e,no,l),n(e,yl,l),n(e,ao,l),d(wl,e,l),n(e,so,l),n(e,gl,l),n(e,io,l),n(e,bl,l),n(e,oo,l),n(e,Tl,l),n(e,ro,l),n(e,jl,l),n(e,ho,l),n(e,Ul,l),n(e,po,l),n(e,Jl,l),n(e,uo,l),n(e,Cl,l),n(e,mo,l),n(e,_l,l),n(e,co,l),n(e,E,l),p(E,Me),p(Me,Fa),d(xl,Fa,null),p(E,Yh),p(E,va),n(e,Mo,l),n(e,Il,l),n(e,fo,l),d(kl,e,l),n(e,vo,l),n(e,R,l),p(R,fe),p(fe,Qa),d($l,Qa,null),p(R,Xh),p(R,ya),n(e,yo,l),n(e,Zl,l),n(e,wo,l),n(e,go,l),n(e,bo,l),n(e,Bl,l),n(e,To,l),n(e,jo,l),n(e,Uo,l),n(e,Hl,l),n(e,Jo,l),n(e,Wl,l),n(e,Co,l),n(e,Ll,l),n(e,_o,l),n(e,Gl,l),n(e,xo,l),n(e,El,l),n(e,Io,l),n(e,Rl,l),n(e,ko,l),n(e,Sl,l),n(e,$o,l),n(e,Yl,l),n(e,Zo,l),d(Xl,e,l),n(e,Bo,l),d(Vl,e,l),n(e,Ho,l),n(e,S,l),p(S,ve),p(ve,Na),d(Al,Na,null),p(S,Vh),p(S,wa),n(e,Wo,l),d(Pl,e,l),n(e,Lo,l),n(e,Y,l),p(Y,ye),p(ye,za),d(Fl,za,null),p(Y,Ah),p(Y,ga),n(e,Go,l),d(Ql,e,l),n(e,Eo,l),n(e,X,l),p(X,we),p(we,Da),d(Nl,Da,null),p(X,Ph),p(X,ba),n(e,Ro,l),d(zl,e,l),n(e,So,l),n(e,V,l),p(V,ge),p(ge,qa),d(Dl,qa,null),p(V,Fh),p(V,Ta),n(e,Yo,l),n(e,ql,l),n(e,Xo,l),n(e,Ol,l),n(e,Vo,l),d(Kl,e,l),n(e,Ao,l),n(e,A,l),p(A,be),p(be,Oa),d(en,Oa,null),p(A,Qh),p(A,ja),n(e,Po,l),d(tn,e,l),n(e,Fo,l),n(e,ln,l),n(e,Qo,l),n(e,P,l),p(P,Te),p(Te,Ka),d(nn,Ka,null),p(P,Nh),p(P,Ua),n(e,No,l),n(e,an,l),n(e,zo,l),n(e,sn,l),n(e,Do,l),n(e,on,l),n(e,qo,l),n(e,rn,l),n(e,Oo,l),n(e,hn,l),n(e,Ko,l),n(e,pn,l),n(e,er,l),n(e,un,l),n(e,tr,l),n(e,mn,l),n(e,lr,l),n(e,cn,l),n(e,nr,l),n(e,dn,l),n(e,ar,l),n(e,Mn,l),n(e,sr,l),d(fn,e,l),n(e,ir,l),n(e,vn,l),n(e,or,l),n(e,yn,l),n(e,rr,l),n(e,wn,l),n(e,hr,l),n(e,gn,l),n(e,pr,l),n(e,bn,l),n(e,ur,l),n(e,Tn,l),n(e,mr,l),d(jn,e,l),n(e,cr,l),n(e,F,l),p(F,je),p(je,es),d(Un,es,null),p(F,zh),p(F,Ja),n(e,dr,l),d(Jn,e,l),n(e,Mr,l),n(e,Cn,l),n(e,fr,l),n(e,_n,l),n(e,vr,l),n(e,xn,l),n(e,yr,l),n(e,In,l),n(e,wr,l),n(e,Q,l),p(Q,Ue),p(Ue,ts),d(kn,ts,null),p(Q,Dh),p(Q,Ca),n(e,gr,l),n(e,$n,l),n(e,br,l),n(e,Zn,l),n(e,Tr,l),n(e,Bn,l),n(e,jr,l),n(e,Hn,l),n(e,Ur,l),n(e,Je,l),n(e,Jr,l),n(e,Wn,l),n(e,Cr,l),n(e,Ln,l),n(e,_r,l),n(e,Gn,l),n(e,xr,l),d(En,e,l),n(e,Ir,l),d(Rn,e,l),n(e,kr,l),n(e,Sn,l),n(e,$r,l),d(Yn,e,l),n(e,Zr,l),n(e,N,l),p(N,Ce),p(Ce,ls),d(Xn,ls,null),p(N,qh),p(N,_a),n(e,Br,l),n(e,Vn,l),n(e,Hr,l),n(e,An,l),n(e,Wr,l),n(e,Pn,l),n(e,Lr,l),n(e,Fn,l),n(e,Gr,l),n(e,Qn,l),n(e,Er,l),n(e,Rr,l),n(e,Sr,l),n(e,Nn,l),n(e,Yr,l),n(e,zn,l),n(e,Xr,l),n(e,Dn,l),n(e,Vr,l),n(e,qn,l),n(e,Ar,l),n(e,On,l),n(e,Pr,l),n(e,Kn,l),n(e,Fr,l),n(e,z,l),p(z,_e),p(_e,ns),d(ea,ns,null),p(z,Oh),p(z,xa),n(e,Qr,l),n(e,as,l),Nr=!0},p:hd,i(e){Nr||(M(xe.$$.fragment,e),M(Ie.$$.fragment,e),M(Ae.$$.fragment,e),M(Fe.$$.fragment,e),M(Ne.$$.fragment,e),M(qe.$$.fragment,e),M(et.$$.fragment,e),M(rt.$$.fragment,e),M(mt.$$.fragment,e),M(vt.$$.fragment,e),M(yt.$$.fragment,e),M(Tt.$$.fragment,e),M(_t.$$.fragment,e),M($t.$$.fragment,e),M(Zt.$$.fragment,e),M(Wt.$$.fragment,e),M(Gt.$$.fragment,e),M(Et.$$.fragment,e),M(Rt.$$.fragment,e),M(Vt.$$.fragment,e),M(At.$$.fragment,e),M(hl.$$.fragment,e),M(pl.$$.fragment,e),M(ul.$$.fragment,e),M(fl.$$.fragment,e),M(wl.$$.fragment,e),M(xl.$$.fragment,e),M(kl.$$.fragment,e),M($l.$$.fragment,e),M(Xl.$$.fragment,e),M(Vl.$$.fragment,e),M(Al.$$.fragment,e),M(Pl.$$.fragment,e),M(Fl.$$.fragment,e),M(Ql.$$.fragment,e),M(Nl.$$.fragment,e),M(zl.$$.fragment,e),M(Dl.$$.fragment,e),M(Kl.$$.fragment,e),M(en.$$.fragment,e),M(tn.$$.fragment,e),M(nn.$$.fragment,e),M(fn.$$.fragment,e),M(jn.$$.fragment,e),M(Un.$$.fragment,e),M(Jn.$$.fragment,e),M(kn.$$.fragment,e),M(En.$$.fragment,e),M(Rn.$$.fragment,e),M(Yn.$$.fragment,e),M(Xn.$$.fragment,e),M(ea.$$.fragment,e),Nr=!0)},o(e){f(xe.$$.fragment,e),f(Ie.$$.fragment,e),f(Ae.$$.fragment,e),f(Fe.$$.fragment,e),f(Ne.$$.fragment,e),f(qe.$$.fragment,e),f(et.$$.fragment,e),f(rt.$$.fragment,e),f(mt.$$.fragment,e),f(vt.$$.fragment,e),f(yt.$$.fragment,e),f(Tt.$$.fragment,e),f(_t.$$.fragment,e),f($t.$$.fragment,e),f(Zt.$$.fragment,e),f(Wt.$$.fragment,e),f(Gt.$$.fragment,e),f(Et.$$.fragment,e),f(Rt.$$.fragment,e),f(Vt.$$.fragment,e),f(At.$$.fragment,e),f(hl.$$.fragment,e),f(pl.$$.fragment,e),f(ul.$$.fragment,e),f(fl.$$.fragment,e),f(wl.$$.fragment,e),f(xl.$$.fragment,e),f(kl.$$.fragment,e),f($l.$$.fragment,e),f(Xl.$$.fragment,e),f(Vl.$$.fragment,e),f(Al.$$.fragment,e),f(Pl.$$.fragment,e),f(Fl.$$.fragment,e),f(Ql.$$.fragment,e),f(Nl.$$.fragment,e),f(zl.$$.fragment,e),f(Dl.$$.fragment,e),f(Kl.$$.fragment,e),f(en.$$.fragment,e),f(tn.$$.fragment,e),f(nn.$$.fragment,e),f(fn.$$.fragment,e),f(jn.$$.fragment,e),f(Un.$$.fragment,e),f(Jn.$$.fragment,e),f(kn.$$.fragment,e),f(En.$$.fragment,e),f(Rn.$$.fragment,e),f(Yn.$$.fragment,e),f(Xn.$$.fragment,e),f(ea.$$.fragment,e),Nr=!1},d(e){e&&(t(ss),t(Ia),t(is),t(T),t(os),t(rs),t(ke),t(hs),t($e),t(ps),t(Ze),t(us),t(Be),t(ms),t(He),t(cs),t(We),t(ds),t(Le),t(Ms),t(Ge),t(fs),t(Ee),t(vs),t(Re),t(ys),t(Se),t(ws),t(Ye),t(gs),t(Xe),t(bs),t(Ve),t(Ts),t(j),t(js),t(O),t(Us),t(Pe),t(Js),t(U),t(Cs),t(Qe),t(_s),t(J),t(xs),t(ze),t(Is),t(De),t(ks),t(C),t($s),t(Oe),t(Zs),t(Ke),t(Bs),t(_),t(Hs),t(tt),t(Ws),t(lt),t(Ls),t(nt),t(Gs),t(at),t(Es),t(st),t(Rs),t(it),t(Ss),t(ot),t(Ys),t(x),t(Xs),t(ht),t(Vs),t(pt),t(As),t(ut),t(Ps),t(I),t(Fs),t(se),t(Qs),t(ct),t(Ns),t(dt),t(zs),t(Mt),t(Ds),t(ft),t(qs),t(k),t(Os),t($),t(Ks),t(wt),t(ei),t(gt),t(ti),t(bt),t(li),t(Z),t(ni),t(jt),t(ai),t(Ut),t(si),t(Jt),t(ii),t(Ct),t(oi),t(B),t(ri),t(xt),t(hi),t(It),t(pi),t(kt),t(ui),t(mi),t(ci),t(Bt),t(di),t(Ht),t(Mi),t(fi),t(Lt),t(vi),t(yi),t(wi),t(H),t(gi),t(St),t(bi),t(Yt),t(Ti),t(Xt),t(ji),t(Ui),t(W),t(Ji),t(Pt),t(Ci),t(Ft),t(_i),t(Qt),t(xi),t(Nt),t(Ii),t(zt),t(ki),t(me),t($i),t(Dt),t(Zi),t(qt),t(Bi),t(Ot),t(Hi),t(Kt),t(Wi),t(el),t(Li),t(tl),t(Gi),t(ll),t(Ei),t(nl),t(Ri),t(al),t(Si),t(sl),t(Yi),t(il),t(Xi),t(ol),t(Vi),t(rl),t(Ai),t(Pi),t(L),t(Fi),t(G),t(Qi),t(ml),t(Ni),t(zi),t(Di),t(cl),t(qi),t(dl),t(Oi),t(Ki),t(eo),t(Ml),t(to),t(lo),t(vl),t(no),t(yl),t(ao),t(so),t(gl),t(io),t(bl),t(oo),t(Tl),t(ro),t(jl),t(ho),t(Ul),t(po),t(Jl),t(uo),t(Cl),t(mo),t(_l),t(co),t(E),t(Mo),t(Il),t(fo),t(vo),t(R),t(yo),t(Zl),t(wo),t(go),t(bo),t(Bl),t(To),t(jo),t(Uo),t(Hl),t(Jo),t(Wl),t(Co),t(Ll),t(_o),t(Gl),t(xo),t(El),t(Io),t(Rl),t(ko),t(Sl),t($o),t(Yl),t(Zo),t(Bo),t(Ho),t(S),t(Wo),t(Lo),t(Y),t(Go),t(Eo),t(X),t(Ro),t(So),t(V),t(Yo),t(ql),t(Xo),t(Ol),t(Vo),t(Ao),t(A),t(Po),t(Fo),t(ln),t(Qo),t(P),t(No),t(an),t(zo),t(sn),t(Do),t(on),t(qo),t(rn),t(Oo),t(hn),t(Ko),t(pn),t(er),t(un),t(tr),t(mn),t(lr),t(cn),t(nr),t(dn),t(ar),t(Mn),t(sr),t(ir),t(vn),t(or),t(yn),t(rr),t(wn),t(hr),t(gn),t(pr),t(bn),t(ur),t(Tn),t(mr),t(cr),t(F),t(dr),t(Mr),t(Cn),t(fr),t(_n),t(vr),t(xn),t(yr),t(In),t(wr),t(Q),t(gr),t($n),t(br),t(Zn),t(Tr),t(Bn),t(jr),t(Hn),t(Ur),t(Je),t(Jr),t(Wn),t(Cr),t(Ln),t(_r),t(Gn),t(xr),t(Ir),t(kr),t(Sn),t($r),t(Zr),t(N),t(Br),t(Vn),t(Hr),t(An),t(Wr),t(Pn),t(Lr),t(Fn),t(Gr),t(Qn),t(Er),t(Rr),t(Sr),t(Nn),t(Yr),t(zn),t(Xr),t(Dn),t(Vr),t(qn),t(Ar),t(On),t(Pr),t(Kn),t(Fr),t(z),t(Qr),t(as)),t(b),v(xe),v(Ie,e),v(Ae),v(Fe),v(Ne),v(qe),v(et),v(rt),v(mt),v(vt),v(yt),v(Tt),v(_t),v($t,e),v(Zt,e),v(Wt,e),v(Gt,e),v(Et,e),v(Rt),v(Vt,e),v(At),v(hl,e),v(pl),v(ul),v(fl,e),v(wl,e),v(xl),v(kl,e),v($l),v(Xl,e),v(Vl,e),v(Al),v(Pl,e),v(Fl),v(Ql,e),v(Nl),v(zl,e),v(Dl),v(Kl,e),v(en),v(tn,e),v(nn),v(fn,e),v(jn,e),v(Un),v(Jn,e),v(kn),v(En,e),v(Rn,e),v(Yn,e),v(Xn),v(ea)}}}const fd={local:"lets-train-our-first-deep-reinforcement-learning-agent-and-upload-it-to-the-hub",sections:[{local:"get-a-certificate",title:"Get a certificate 🎓"},{local:"set-the-gpu",title:"Set the GPU 💪"},{local:"install-dependencies-and-create-a-virtual-screen",title:"Install dependencies and create a virtual screen 🔽"},{local:"import-the-packages",title:"Import the packages 📦"},{local:"understand-gymnasium-and-how-it-works",title:"Understand Gymnasium and how it works 🤖"},{local:"create-the-lunarlander-environment-and-understand-how-it-works",sections:[{local:"the-environment",sections:[{local:"vectorized-environment",title:"Vectorized Environment"}],title:"The environment 🎮"}],title:"Create the LunarLander environment 🌛 and understand how it works"},{local:"create-the-model",sections:[{local:"solution",title:"Solution"}],title:"Create the Model 🤖"},{local:"train-the-ppo-agent",sections:[{local:"solution",title:"Solution"}],title:"Train the PPO agent 🏃"},{local:"evaluate-the-agent",sections:[{local:"solution",title:"Solution"}],title:"Evaluate the agent 📈"},{local:"publish-our-trained-model-on-the-hub",sections:[{local:"solution",title:"Solution"}],title:"Publish our trained model on the Hub 🔥"},{local:"load-a-saved-lunarlander-model-from-the-hub",title:"Load a saved LunarLander model from the Hub 🤗"},{local:"some-additional-challenges",title:"Some additional challenges 🏆"},{local:"keep-learning-stay-awesome",title:"Keep learning, stay awesome 🤗"}],title:"Let's train our first Deep Reinforcement Learning agent and upload it to the Hub 🚀"};function vd(Kh){return pd(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jd extends ud{constructor(b){super(),md(this,b,vd,Md,rd,{})}}export{jd as component};
