import{s as Xn,f as g,n as Yn,o as Zn}from"../chunks/scheduler.37c15a92.js";import{S as ti,i as ei,g as n,s as l,u as G,m as c,H as pe,A as si,h as i,f as e,c as r,j as h,v as q,y as m,n as u,B as oe,k as p,o,a,w as N,d as U,t as W,x as O}from"../chunks/index.b01106c0.js";import{I as F}from"../chunks/IconCopyLink.77b762b4.js";function ai(_a){let f,_e,me,be,v,C,he,D,na,Kt,ba="Introducing Q-Learning",Le,d,Q,ce,B,ia,Xt,La="What is Q-Learning?",Me,J,Ma="Q-Learning is an <strong>off-policy value-based method that uses a TD approach to train its action-value function:</strong>",Te,V,Ta="<li><em>Off-policy</em>: we’ll talk about that at the end of this unit.</li> <li><em>Value-based method</em>: finds the optimal policy indirectly by training a value or action-value function that will tell us <strong>the value of each state or each state-action pair.</strong></li> <li><em>TD approach:</em> <strong>updates its action-value function at each step instead of at the end of the episode.</strong></li>",Ce,K,Ca="<strong>Q-Learning is the algorithm we use to train our Q-function</strong>, an <strong>action-value function</strong> that determines the value of being at a particular state and taking a specific action at that state.",Qe,X,Qa='<img src="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/Q-function.jpg" alt="Q-function"/> <figcaption>Given a state and action, our Q Function outputs a state-action value (also called Q-value)</figcaption>',He,Y,Ha="The <strong>Q comes from “the Quality” (the value) of that action at that state.</strong>",ke,Z,ka="Let’s recap the difference between value and reward:",$e,tt,$a="<li>The <em>value of a state</em>, or a <em>state-action pair</em> is the expected cumulative reward our agent gets if it starts at this state (or state-action pair) and then acts accordingly to its policy.</li> <li>The <em>reward</em> is the <strong>feedback I get from the environment</strong> after performing an action at a state.</li>",ze,et,za="Internally, our Q-function is encoded by <strong>a Q-table, a table where each cell corresponds to a state-action pair value.</strong> Think of this Q-table as <strong>the memory or cheat sheet of our Q-function.</strong>",Pe,st,Pa="Let’s go through an example of a maze.",Se,at,Sa,Ae,nt,Aa="The Q-table is initialized. That’s why all values are = 0. This table <strong>contains, for each state and action, the corresponding state-action values.</strong>",Ee,it,Ea,Ie,lt,Ia="Here we see that the <strong>state-action value of the initial state and going up is 0:</strong>",je,rt,ja,Re,pt,Ra="So: the Q-function uses a Q-table <strong>that has the value of each state-action pair.</strong> Given a state and action, <strong>our Q-function will search inside its Q-table to output the value.</strong>",Ge,ot,Ga='<img src="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/Q-function-2.jpg" alt="Q-function"/>',qe,mt,qa="If we recap, <em>Q-Learning</em> <strong>is the RL algorithm that:</strong>",Ne,ht,Na="<li>Trains a <em>Q-function</em> (an <strong>action-value function</strong>), which internally is a <strong>Q-table that contains all the state-action pair values.</strong></li> <li>Given a state and action, our Q-function <strong>will search its Q-table for the corresponding value.</strong></li> <li>When the training is done, <strong>we have an optimal Q-function, which means we have optimal Q-table.</strong></li> <li>And if we <strong>have an optimal Q-function</strong>, we <strong>have an optimal policy</strong> since we <strong>know the best action to take at each state.</strong></li>",Ue,ct,Ua,We,ut,Wa="In the beginning, <strong>our Q-table is useless since it gives arbitrary values for each state-action pair</strong> (most of the time, we initialize the Q-table to 0). As the agent <strong>explores the environment and we update the Q-table, it will give us a better and better approximation</strong> to the optimal policy.",Oe,H,Oa='<img src="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/Q-learning-1.jpg" alt="Q-learning"/> <figcaption>We see here that with the training, our Q-table is better since, thanks to it, we can know the value of each state-action pair.</figcaption>',Fe,gt,Fa="Now that we understand what Q-Learning, Q-functions, and Q-tables are, <strong>let’s dive deeper into the Q-Learning algorithm</strong>.",De,w,k,ue,ft,la,Yt,Da="The Q-Learning algorithm",Be,vt,Ba="This is the Q-Learning pseudocode; let’s study each part and <strong>see how it works with a simple example before implementing it.</strong> Don’t be intimidated by it, it’s simpler than it looks! We’ll go over each step.",Je,dt,Ja,Ve,y,$,ge,wt,ra,Zt,Va="Step 1: We initialize the Q-table",Ke,yt,Ka,Xe,xt,Xa="We need to initialize the Q-table for each state-action pair. <strong>Most of the time, we initialize with values of 0.</strong>",Ye,x,z,fe,_t,pa,te,Ya="Step 2: Choose an action using the epsilon-greedy strategy",Ze,bt,Za,ts,Lt,tn="The epsilon-greedy strategy is a policy that handles the exploration/exploitation trade-off.",es,Mt,en="The idea is that, with an initial value of ɛ = 1.0:",ss,Tt,sn="<li><em>With probability 1 — ɛ</em> : we do <strong>exploitation</strong> (aka our agent selects the action with the highest state-action pair value).</li> <li>With probability ɛ: <strong>we do exploration</strong> (trying random action).</li>",as,Ct,an="At the beginning of the training, <strong>the probability of doing exploration will be huge since ɛ is very high, so most of the time, we’ll explore.</strong> But as the training goes on, and consequently our <strong>Q-table gets better and better in its estimations, we progressively reduce the epsilon value</strong> since we will need less and less exploration and more exploitation.",ns,Qt,nn,is,_,P,ve,Ht,oa,ee,ln="Step 3: Perform action At, get reward Rt+1 and next state St+1",ls,kt,rn,rs,b,S,de,$t,ma,se,pn="Step 4: Update Q(St, At)",ps,zt,on="Remember that in TD Learning, we update our policy or value function (depending on the RL method we choose) <strong>after one step of the interaction.</strong>",os,A,ha,Pt,ca,ms,Fn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>R</mi><mrow><mi>t</mi><mo>+</mo><mn>1</mn></mrow></msub></mrow><annotation encoding="application/x-tex">R_{t+1}</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8917em;vertical-align:-0.2083em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.00773em;">R</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.0077em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">t</span><span class="mbin mtight">+</span><span class="mord mtight">1</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2083em;"><span></span></span></span></span></span></span></span></span></span>',hs,ua,cs,St,mn,us,L,ga,gs,Dn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>Q</mi><mo stretchy="false">(</mo><msub><mi>S</mi><mi>t</mi></msub><mo separator="true">,</mo><msub><mi>A</mi><mi>t</mi></msub><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">Q(S_t, A_t)</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal">Q</span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.05764em;">S</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:-0.0576em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">t</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">A</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">t</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',fs,ae,hn="update formula goes like this:",vs,At,cn,ds,E,fa,ws,Bn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>Q</mi><mo stretchy="false">(</mo><msub><mi>S</mi><mi>t</mi></msub><mo separator="true">,</mo><msub><mi>A</mi><mi>t</mi></msub><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">Q(S_t, A_t)</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal">Q</span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.05764em;">S</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:-0.0576em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">t</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">A</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">t</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',ys,xs,I,Et,va,_s,Jn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>S</mi><mi>t</mi></msub><mo separator="true">,</mo><msub><mi>A</mi><mi>t</mi></msub><mo separator="true">,</mo><msub><mi>R</mi><mrow><mi>t</mi><mo>+</mo><mn>1</mn></mrow></msub><mo separator="true">,</mo><msub><mi>S</mi><mrow><mi>t</mi><mo>+</mo><mn>1</mn></mrow></msub></mrow><annotation encoding="application/x-tex">S_t, A_t, R_{t+1}, S_{t+1}</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8917em;vertical-align:-0.2083em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.05764em;">S</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:-0.0576em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">t</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">A</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">t</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.00773em;">R</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.0077em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">t</span><span class="mbin mtight">+</span><span class="mord mtight">1</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2083em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.05764em;">S</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.0576em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">t</span><span class="mbin mtight">+</span><span class="mord mtight">1</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2083em;"><span></span></span></span></span></span></span></span></span></span>',bs,da,ne,un="To update our Q-value at a given state-action pair, we use the TD target.",Ls,It,gn="How do we form the TD target?",Ms,j,M,wa,Ts,Vn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>R</mi><mrow><mi>t</mi><mo>+</mo><mn>1</mn></mrow></msub></mrow><annotation encoding="application/x-tex">R_{t+1}</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8917em;vertical-align:-0.2083em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.00773em;">R</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.0077em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">t</span><span class="mbin mtight">+</span><span class="mord mtight">1</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2083em;"><span></span></span></span></span></span></span></span></span></span>',Cs,Qs,Kn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>A</mi><mi>t</mi></msub></mrow><annotation encoding="application/x-tex">A_t</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal">A</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">t</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Hs,ya,ie,fn="To get the <strong>best state-action pair value</strong> for the next state, we use a greedy policy to select the next best action. Note that this is not an epsilon-greedy policy, this will always take the action with the highest state-action value.",ks,jt,vn="Then when the update of this Q-value is done, we start in a new state and select our action <strong>using a epsilon-greedy policy again.</strong>",$s,Rt,dn="<strong>This is why we say that Q Learning is an off-policy algorithm.</strong>",zs,T,R,we,Gt,xa,le,wn="Off-policy vs On-policy",Ps,qt,yn="The difference is subtle:",Ss,Nt,xn="<li><em>Off-policy</em>: using <strong>a different policy for acting (inference) and updating (training).</strong></li>",As,Ut,_n="For instance, with Q-Learning, the epsilon-greedy policy (acting policy), is different from the greedy policy that is <strong>used to select the best next-state action value to update our Q-value (updating policy).</strong>",Es,Wt,bn='<img src="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/off-on-1.jpg" alt="Off-on policy"/> <figcaption>Acting Policy</figcaption>',Is,Ot,Ln="Is different from the policy we use during the training part:",js,Ft,Mn='<img src="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/off-on-2.jpg" alt="Off-on policy"/> <figcaption>Updating policy</figcaption>',Rs,Dt,Tn="<li><em>On-policy:</em> using the <strong>same policy for acting and updating.</strong></li>",Gs,Bt,Cn="For instance, with Sarsa, another value-based algorithm, <strong>the epsilon-greedy policy selects the next state-action pair, not a greedy policy.</strong>",qs,Jt,Qn='<img src="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/off-on-3.jpg" alt="Off-on policy"/> <figcaption>Sarsa</figcaption>',Ns,Vt,Hn='<img src="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/off-on-4.jpg" alt="Off-on policy"/>',Us,ye,Ws;return D=new F({}),B=new F({}),ft=new F({}),wt=new F({}),_t=new F({}),Ht=new F({}),$t=new F({}),Gt=new F({}),{c(){f=n("meta"),_e=l(),me=n("p"),be=l(),v=n("h1"),C=n("a"),he=n("span"),G(D.$$.fragment),na=l(),Kt=n("span"),Kt.textContent=ba,Le=l(),d=n("h2"),Q=n("a"),ce=n("span"),G(B.$$.fragment),ia=l(),Xt=n("span"),Xt.textContent=La,Me=l(),J=n("p"),J.innerHTML=Ma,Te=l(),V=n("ul"),V.innerHTML=Ta,Ce=l(),K=n("p"),K.innerHTML=Ca,Qe=l(),X=n("figure"),X.innerHTML=Qa,He=l(),Y=n("p"),Y.innerHTML=Ha,ke=l(),Z=n("p"),Z.textContent=ka,$e=l(),tt=n("ul"),tt.innerHTML=$a,ze=l(),et=n("p"),et.innerHTML=za,Pe=l(),st=n("p"),st.textContent=Pa,Se=l(),at=n("img"),Ae=l(),nt=n("p"),nt.innerHTML=Aa,Ee=l(),it=n("img"),Ie=l(),lt=n("p"),lt.innerHTML=Ia,je=l(),rt=n("img"),Re=l(),pt=n("p"),pt.innerHTML=Ra,Ge=l(),ot=n("figure"),ot.innerHTML=Ga,qe=l(),mt=n("p"),mt.innerHTML=qa,Ne=l(),ht=n("ul"),ht.innerHTML=Na,Ue=l(),ct=n("img"),We=l(),ut=n("p"),ut.innerHTML=Wa,Oe=l(),H=n("figure"),H.innerHTML=Oa,Fe=l(),gt=n("p"),gt.innerHTML=Fa,De=l(),w=n("h2"),k=n("a"),ue=n("span"),G(ft.$$.fragment),la=l(),Yt=n("span"),Yt.textContent=Da,Be=l(),vt=n("p"),vt.innerHTML=Ba,Je=l(),dt=n("img"),Ve=l(),y=n("h3"),$=n("a"),ge=n("span"),G(wt.$$.fragment),ra=l(),Zt=n("span"),Zt.textContent=Va,Ke=l(),yt=n("img"),Xe=l(),xt=n("p"),xt.innerHTML=Xa,Ye=l(),x=n("h3"),z=n("a"),fe=n("span"),G(_t.$$.fragment),pa=l(),te=n("span"),te.textContent=Ya,Ze=l(),bt=n("img"),ts=l(),Lt=n("p"),Lt.textContent=tn,es=l(),Mt=n("p"),Mt.textContent=en,ss=l(),Tt=n("ul"),Tt.innerHTML=sn,as=l(),Ct=n("p"),Ct.innerHTML=an,ns=l(),Qt=n("img"),is=l(),_=n("h3"),P=n("a"),ve=n("span"),G(Ht.$$.fragment),oa=l(),ee=n("span"),ee.textContent=ln,ls=l(),kt=n("img"),rs=l(),b=n("h3"),S=n("a"),de=n("span"),G($t.$$.fragment),ma=l(),se=n("span"),se.textContent=pn,ps=l(),zt=n("p"),zt.innerHTML=on,os=l(),A=n("p"),ha=c("To produce our TD target, "),Pt=n("strong"),ca=c("we used the immediate reward "),ms=new pe(!1),hs=c(" plus the discounted value of the next state"),ua=c(", computed by finding the action that maximizes the current Q-function at the next state. (We call that bootstrap)."),cs=l(),St=n("img"),us=l(),L=n("p"),ga=c("Therefore, our "),gs=new pe(!1),fs=c(" "),ae=n("strong"),ae.textContent=hn,vs=l(),At=n("img"),ds=l(),E=n("p"),fa=c("This means that to update our "),ws=new pe(!1),ys=c(":"),xs=l(),I=n("ul"),Et=n("li"),va=c("We need "),_s=new pe(!1),bs=c("."),da=l(),ne=n("li"),ne.textContent=un,Ls=l(),It=n("p"),It.textContent=gn,Ms=l(),j=n("ol"),M=n("li"),wa=c("We obtain the reward "),Ts=new pe(!1),Cs=c(" after taking the action "),Qs=new pe(!1),Hs=c("."),ya=l(),ie=n("li"),ie.innerHTML=fn,ks=l(),jt=n("p"),jt.innerHTML=vn,$s=l(),Rt=n("p"),Rt.innerHTML=dn,zs=l(),T=n("h2"),R=n("a"),we=n("span"),G(Gt.$$.fragment),xa=l(),le=n("span"),le.textContent=wn,Ps=l(),qt=n("p"),qt.textContent=yn,Ss=l(),Nt=n("ul"),Nt.innerHTML=xn,As=l(),Ut=n("p"),Ut.innerHTML=_n,Es=l(),Wt=n("figure"),Wt.innerHTML=bn,Is=l(),Ot=n("p"),Ot.textContent=Ln,js=l(),Ft=n("figure"),Ft.innerHTML=Mn,Rs=l(),Dt=n("ul"),Dt.innerHTML=Tn,Gs=l(),Bt=n("p"),Bt.innerHTML=Cn,qs=l(),Jt=n("figure"),Jt.innerHTML=Qn,Ns=l(),Vt=n("figure"),Vt.innerHTML=Hn,Us=l(),ye=n("p"),this.h()},l(t){const s=si("svelte-1phssyn",document.head);f=i(s,"META",{name:!0,content:!0}),s.forEach(e),_e=r(t),me=i(t,"P",{}),h(me).forEach(e),be=r(t),v=i(t,"H1",{class:!0});var Os=h(v);C=i(Os,"A",{id:!0,class:!0,href:!0});var kn=h(C);he=i(kn,"SPAN",{});var $n=h(he);q(D.$$.fragment,$n),$n.forEach(e),kn.forEach(e),na=r(Os),Kt=i(Os,"SPAN",{"data-svelte-h":!0}),m(Kt)!=="svelte-1c6dzu9"&&(Kt.textContent=ba),Os.forEach(e),Le=r(t),d=i(t,"H2",{class:!0});var Fs=h(d);Q=i(Fs,"A",{id:!0,class:!0,href:!0});var zn=h(Q);ce=i(zn,"SPAN",{});var Pn=h(ce);q(B.$$.fragment,Pn),Pn.forEach(e),zn.forEach(e),ia=r(Fs),Xt=i(Fs,"SPAN",{"data-svelte-h":!0}),m(Xt)!=="svelte-1x3a6f2"&&(Xt.textContent=La),Fs.forEach(e),Me=r(t),J=i(t,"P",{"data-svelte-h":!0}),m(J)!=="svelte-vs38b5"&&(J.innerHTML=Ma),Te=r(t),V=i(t,"UL",{"data-svelte-h":!0}),m(V)!=="svelte-10wsnaz"&&(V.innerHTML=Ta),Ce=r(t),K=i(t,"P",{"data-svelte-h":!0}),m(K)!=="svelte-1bdys1r"&&(K.innerHTML=Ca),Qe=r(t),X=i(t,"FIGURE",{"data-svelte-h":!0}),m(X)!=="svelte-5lmfx0"&&(X.innerHTML=Qa),He=r(t),Y=i(t,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-crnsdp"&&(Y.innerHTML=Ha),ke=r(t),Z=i(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1ubk9oh"&&(Z.textContent=ka),$e=r(t),tt=i(t,"UL",{"data-svelte-h":!0}),m(tt)!=="svelte-1nda8m2"&&(tt.innerHTML=$a),ze=r(t),et=i(t,"P",{"data-svelte-h":!0}),m(et)!=="svelte-gdw4y7"&&(et.innerHTML=za),Pe=r(t),st=i(t,"P",{"data-svelte-h":!0}),m(st)!=="svelte-1cli1ai"&&(st.textContent=Pa),Se=r(t),at=i(t,"IMG",{src:!0,alt:!0}),Ae=r(t),nt=i(t,"P",{"data-svelte-h":!0}),m(nt)!=="svelte-7yqtiu"&&(nt.innerHTML=Aa),Ee=r(t),it=i(t,"IMG",{src:!0,alt:!0}),Ie=r(t),lt=i(t,"P",{"data-svelte-h":!0}),m(lt)!=="svelte-1v5c7t0"&&(lt.innerHTML=Ia),je=r(t),rt=i(t,"IMG",{src:!0,alt:!0}),Re=r(t),pt=i(t,"P",{"data-svelte-h":!0}),m(pt)!=="svelte-1ptm42n"&&(pt.innerHTML=Ra),Ge=r(t),ot=i(t,"FIGURE",{"data-svelte-h":!0}),m(ot)!=="svelte-1wlsy73"&&(ot.innerHTML=Ga),qe=r(t),mt=i(t,"P",{"data-svelte-h":!0}),m(mt)!=="svelte-18kluj9"&&(mt.innerHTML=qa),Ne=r(t),ht=i(t,"UL",{"data-svelte-h":!0}),m(ht)!=="svelte-rhztxe"&&(ht.innerHTML=Na),Ue=r(t),ct=i(t,"IMG",{src:!0,alt:!0}),We=r(t),ut=i(t,"P",{"data-svelte-h":!0}),m(ut)!=="svelte-upi7hl"&&(ut.innerHTML=Wa),Oe=r(t),H=i(t,"FIGURE",{class:!0,"data-svelte-h":!0}),m(H)!=="svelte-qceb0"&&(H.innerHTML=Oa),Fe=r(t),gt=i(t,"P",{"data-svelte-h":!0}),m(gt)!=="svelte-1jxrnuj"&&(gt.innerHTML=Fa),De=r(t),w=i(t,"H2",{class:!0});var Ds=h(w);k=i(Ds,"A",{id:!0,class:!0,href:!0});var Sn=h(k);ue=i(Sn,"SPAN",{});var An=h(ue);q(ft.$$.fragment,An),An.forEach(e),Sn.forEach(e),la=r(Ds),Yt=i(Ds,"SPAN",{"data-svelte-h":!0}),m(Yt)!=="svelte-1eih48z"&&(Yt.textContent=Da),Ds.forEach(e),Be=r(t),vt=i(t,"P",{"data-svelte-h":!0}),m(vt)!=="svelte-1fdmnfq"&&(vt.innerHTML=Ba),Je=r(t),dt=i(t,"IMG",{src:!0,alt:!0}),Ve=r(t),y=i(t,"H3",{class:!0});var Bs=h(y);$=i(Bs,"A",{id:!0,class:!0,href:!0});var En=h($);ge=i(En,"SPAN",{});var In=h(ge);q(wt.$$.fragment,In),In.forEach(e),En.forEach(e),ra=r(Bs),Zt=i(Bs,"SPAN",{"data-svelte-h":!0}),m(Zt)!=="svelte-1q8itzj"&&(Zt.textContent=Va),Bs.forEach(e),Ke=r(t),yt=i(t,"IMG",{src:!0,alt:!0}),Xe=r(t),xt=i(t,"P",{"data-svelte-h":!0}),m(xt)!=="svelte-hvlw74"&&(xt.innerHTML=Xa),Ye=r(t),x=i(t,"H3",{class:!0});var Js=h(x);z=i(Js,"A",{id:!0,class:!0,href:!0});var jn=h(z);fe=i(jn,"SPAN",{});var Rn=h(fe);q(_t.$$.fragment,Rn),Rn.forEach(e),jn.forEach(e),pa=r(Js),te=i(Js,"SPAN",{"data-svelte-h":!0}),m(te)!=="svelte-tjf264"&&(te.textContent=Ya),Js.forEach(e),Ze=r(t),bt=i(t,"IMG",{src:!0,alt:!0}),ts=r(t),Lt=i(t,"P",{"data-svelte-h":!0}),m(Lt)!=="svelte-1rsicc3"&&(Lt.textContent=tn),es=r(t),Mt=i(t,"P",{"data-svelte-h":!0}),m(Mt)!=="svelte-1p8nnff"&&(Mt.textContent=en),ss=r(t),Tt=i(t,"UL",{"data-svelte-h":!0}),m(Tt)!=="svelte-1qbe9yz"&&(Tt.innerHTML=sn),as=r(t),Ct=i(t,"P",{"data-svelte-h":!0}),m(Ct)!=="svelte-vlbioi"&&(Ct.innerHTML=an),ns=r(t),Qt=i(t,"IMG",{src:!0,alt:!0}),is=r(t),_=i(t,"H3",{class:!0});var Vs=h(_);P=i(Vs,"A",{id:!0,class:!0,href:!0});var Gn=h(P);ve=i(Gn,"SPAN",{});var qn=h(ve);q(Ht.$$.fragment,qn),qn.forEach(e),Gn.forEach(e),oa=r(Vs),ee=i(Vs,"SPAN",{"data-svelte-h":!0}),m(ee)!=="svelte-1u5t2e5"&&(ee.textContent=ln),Vs.forEach(e),ls=r(t),kt=i(t,"IMG",{src:!0,alt:!0}),rs=r(t),b=i(t,"H3",{class:!0});var Ks=h(b);S=i(Ks,"A",{id:!0,class:!0,href:!0});var Nn=h(S);de=i(Nn,"SPAN",{});var Un=h(de);q($t.$$.fragment,Un),Un.forEach(e),Nn.forEach(e),ma=r(Ks),se=i(Ks,"SPAN",{"data-svelte-h":!0}),m(se)!=="svelte-dskxu"&&(se.textContent=pn),Ks.forEach(e),ps=r(t),zt=i(t,"P",{"data-svelte-h":!0}),m(zt)!=="svelte-19iw7lu"&&(zt.innerHTML=on),os=r(t),A=i(t,"P",{});var Xs=h(A);ha=u(Xs,"To produce our TD target, "),Pt=i(Xs,"STRONG",{});var Ys=h(Pt);ca=u(Ys,"we used the immediate reward "),ms=oe(Ys,!1),hs=u(Ys," plus the discounted value of the next state"),Ys.forEach(e),ua=u(Xs,", computed by finding the action that maximizes the current Q-function at the next state. (We call that bootstrap)."),Xs.forEach(e),cs=r(t),St=i(t,"IMG",{src:!0,alt:!0}),us=r(t),L=i(t,"P",{});var xe=h(L);ga=u(xe,"Therefore, our "),gs=oe(xe,!1),fs=u(xe," "),ae=i(xe,"STRONG",{"data-svelte-h":!0}),m(ae)!=="svelte-12kejy4"&&(ae.textContent=hn),xe.forEach(e),vs=r(t),At=i(t,"IMG",{src:!0,alt:!0}),ds=r(t),E=i(t,"P",{});var Zs=h(E);fa=u(Zs,"This means that to update our "),ws=oe(Zs,!1),ys=u(Zs,":"),Zs.forEach(e),xs=r(t),I=i(t,"UL",{});var ta=h(I);Et=i(ta,"LI",{});var ea=h(Et);va=u(ea,"We need "),_s=oe(ea,!1),bs=u(ea,"."),ea.forEach(e),da=r(ta),ne=i(ta,"LI",{"data-svelte-h":!0}),m(ne)!=="svelte-1ihnbvx"&&(ne.textContent=un),ta.forEach(e),Ls=r(t),It=i(t,"P",{"data-svelte-h":!0}),m(It)!=="svelte-1dxw0aw"&&(It.textContent=gn),Ms=r(t),j=i(t,"OL",{});var sa=h(j);M=i(sa,"LI",{});var re=h(M);wa=u(re,"We obtain the reward "),Ts=oe(re,!1),Cs=u(re," after taking the action "),Qs=oe(re,!1),Hs=u(re,"."),re.forEach(e),ya=r(sa),ie=i(sa,"LI",{"data-svelte-h":!0}),m(ie)!=="svelte-ncl2c6"&&(ie.innerHTML=fn),sa.forEach(e),ks=r(t),jt=i(t,"P",{"data-svelte-h":!0}),m(jt)!=="svelte-yt04ce"&&(jt.innerHTML=vn),$s=r(t),Rt=i(t,"P",{"data-svelte-h":!0}),m(Rt)!=="svelte-rw0dnq"&&(Rt.innerHTML=dn),zs=r(t),T=i(t,"H2",{class:!0});var aa=h(T);R=i(aa,"A",{id:!0,class:!0,href:!0});var Wn=h(R);we=i(Wn,"SPAN",{});var On=h(we);q(Gt.$$.fragment,On),On.forEach(e),Wn.forEach(e),xa=r(aa),le=i(aa,"SPAN",{"data-svelte-h":!0}),m(le)!=="svelte-118tnyq"&&(le.textContent=wn),aa.forEach(e),Ps=r(t),qt=i(t,"P",{"data-svelte-h":!0}),m(qt)!=="svelte-1660nrr"&&(qt.textContent=yn),Ss=r(t),Nt=i(t,"UL",{"data-svelte-h":!0}),m(Nt)!=="svelte-jbg8q"&&(Nt.innerHTML=xn),As=r(t),Ut=i(t,"P",{"data-svelte-h":!0}),m(Ut)!=="svelte-5r7jq0"&&(Ut.innerHTML=_n),Es=r(t),Wt=i(t,"FIGURE",{"data-svelte-h":!0}),m(Wt)!=="svelte-2uzk1v"&&(Wt.innerHTML=bn),Is=r(t),Ot=i(t,"P",{"data-svelte-h":!0}),m(Ot)!=="svelte-1xs5vi8"&&(Ot.textContent=Ln),js=r(t),Ft=i(t,"FIGURE",{"data-svelte-h":!0}),m(Ft)!=="svelte-2rk9mg"&&(Ft.innerHTML=Mn),Rs=r(t),Dt=i(t,"UL",{"data-svelte-h":!0}),m(Dt)!=="svelte-19dbnnc"&&(Dt.innerHTML=Tn),Gs=r(t),Bt=i(t,"P",{"data-svelte-h":!0}),m(Bt)!=="svelte-3lwzbr"&&(Bt.innerHTML=Cn),qs=r(t),Jt=i(t,"FIGURE",{"data-svelte-h":!0}),m(Jt)!=="svelte-1qn38id"&&(Jt.innerHTML=Qn),Ns=r(t),Vt=i(t,"FIGURE",{"data-svelte-h":!0}),m(Vt)!=="svelte-1e5hwrp"&&(Vt.innerHTML=Hn),Us=r(t),ye=i(t,"P",{}),h(ye).forEach(e),this.h()},h(){p(f,"name","hf:doc:metadata"),p(f,"content",JSON.stringify(ni)),p(C,"id","q-learning"),p(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(C,"href","#q-learning"),p(v,"class","relative group"),p(Q,"id","what-is-q-learning"),p(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Q,"href","#what-is-q-learning"),p(d,"class","relative group"),g(at.src,Sa="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/Maze-1.jpg")||p(at,"src",Sa),p(at,"alt","Maze example"),g(it.src,Ea="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/Maze-2.jpg")||p(it,"src",Ea),p(it,"alt","Maze example"),g(rt.src,ja="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/Maze-3.jpg")||p(rt,"src",ja),p(rt,"alt","Maze example"),g(ct.src,Ua="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/link-value-policy.jpg")||p(ct,"src",Ua),p(ct,"alt","Link value policy"),p(H,"class","image table text-center m-0 w-full"),p(k,"id","q-learning-algo"),p(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(k,"href","#q-learning-algo"),p(w,"class","relative group"),g(dt.src,Ja="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/Q-learning-2.jpg")||p(dt,"src",Ja),p(dt,"alt","Q-learning"),p($,"id","step1"),p($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p($,"href","#step1"),p(y,"class","relative group"),g(yt.src,Ka="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/Q-learning-3.jpg")||p(yt,"src",Ka),p(yt,"alt","Q-learning"),p(z,"id","step2"),p(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(z,"href","#step2"),p(x,"class","relative group"),g(bt.src,Za="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/Q-learning-4.jpg")||p(bt,"src",Za),p(bt,"alt","Q-learning"),g(Qt.src,nn="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/Q-learning-5.jpg")||p(Qt,"src",nn),p(Qt,"alt","Q-learning"),p(P,"id","step3"),p(P,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(P,"href","#step3"),p(_,"class","relative group"),g(kt.src,rn="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/Q-learning-6.jpg")||p(kt,"src",rn),p(kt,"alt","Q-learning"),p(S,"id","step4"),p(S,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(S,"href","#step4"),p(b,"class","relative group"),ms.a=hs,g(St.src,mn="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/Q-learning-7.jpg")||p(St,"src",mn),p(St,"alt","Q-learning"),gs.a=fs,g(At.src,cn="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/Q-learning-8.jpg")||p(At,"src",cn),p(At,"alt","Q-learning"),ws.a=ys,_s.a=bs,Ts.a=Cs,Qs.a=Hs,p(R,"id","off-vs-on"),p(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(R,"href","#off-vs-on"),p(T,"class","relative group")},m(t,s){o(document.head,f),a(t,_e,s),a(t,me,s),a(t,be,s),a(t,v,s),o(v,C),o(C,he),N(D,he,null),o(v,na),o(v,Kt),a(t,Le,s),a(t,d,s),o(d,Q),o(Q,ce),N(B,ce,null),o(d,ia),o(d,Xt),a(t,Me,s),a(t,J,s),a(t,Te,s),a(t,V,s),a(t,Ce,s),a(t,K,s),a(t,Qe,s),a(t,X,s),a(t,He,s),a(t,Y,s),a(t,ke,s),a(t,Z,s),a(t,$e,s),a(t,tt,s),a(t,ze,s),a(t,et,s),a(t,Pe,s),a(t,st,s),a(t,Se,s),a(t,at,s),a(t,Ae,s),a(t,nt,s),a(t,Ee,s),a(t,it,s),a(t,Ie,s),a(t,lt,s),a(t,je,s),a(t,rt,s),a(t,Re,s),a(t,pt,s),a(t,Ge,s),a(t,ot,s),a(t,qe,s),a(t,mt,s),a(t,Ne,s),a(t,ht,s),a(t,Ue,s),a(t,ct,s),a(t,We,s),a(t,ut,s),a(t,Oe,s),a(t,H,s),a(t,Fe,s),a(t,gt,s),a(t,De,s),a(t,w,s),o(w,k),o(k,ue),N(ft,ue,null),o(w,la),o(w,Yt),a(t,Be,s),a(t,vt,s),a(t,Je,s),a(t,dt,s),a(t,Ve,s),a(t,y,s),o(y,$),o($,ge),N(wt,ge,null),o(y,ra),o(y,Zt),a(t,Ke,s),a(t,yt,s),a(t,Xe,s),a(t,xt,s),a(t,Ye,s),a(t,x,s),o(x,z),o(z,fe),N(_t,fe,null),o(x,pa),o(x,te),a(t,Ze,s),a(t,bt,s),a(t,ts,s),a(t,Lt,s),a(t,es,s),a(t,Mt,s),a(t,ss,s),a(t,Tt,s),a(t,as,s),a(t,Ct,s),a(t,ns,s),a(t,Qt,s),a(t,is,s),a(t,_,s),o(_,P),o(P,ve),N(Ht,ve,null),o(_,oa),o(_,ee),a(t,ls,s),a(t,kt,s),a(t,rs,s),a(t,b,s),o(b,S),o(S,de),N($t,de,null),o(b,ma),o(b,se),a(t,ps,s),a(t,zt,s),a(t,os,s),a(t,A,s),o(A,ha),o(A,Pt),o(Pt,ca),ms.m(Fn,Pt),o(Pt,hs),o(A,ua),a(t,cs,s),a(t,St,s),a(t,us,s),a(t,L,s),o(L,ga),gs.m(Dn,L),o(L,fs),o(L,ae),a(t,vs,s),a(t,At,s),a(t,ds,s),a(t,E,s),o(E,fa),ws.m(Bn,E),o(E,ys),a(t,xs,s),a(t,I,s),o(I,Et),o(Et,va),_s.m(Jn,Et),o(Et,bs),o(I,da),o(I,ne),a(t,Ls,s),a(t,It,s),a(t,Ms,s),a(t,j,s),o(j,M),o(M,wa),Ts.m(Vn,M),o(M,Cs),Qs.m(Kn,M),o(M,Hs),o(j,ya),o(j,ie),a(t,ks,s),a(t,jt,s),a(t,$s,s),a(t,Rt,s),a(t,zs,s),a(t,T,s),o(T,R),o(R,we),N(Gt,we,null),o(T,xa),o(T,le),a(t,Ps,s),a(t,qt,s),a(t,Ss,s),a(t,Nt,s),a(t,As,s),a(t,Ut,s),a(t,Es,s),a(t,Wt,s),a(t,Is,s),a(t,Ot,s),a(t,js,s),a(t,Ft,s),a(t,Rs,s),a(t,Dt,s),a(t,Gs,s),a(t,Bt,s),a(t,qs,s),a(t,Jt,s),a(t,Ns,s),a(t,Vt,s),a(t,Us,s),a(t,ye,s),Ws=!0},p:Yn,i(t){Ws||(U(D.$$.fragment,t),U(B.$$.fragment,t),U(ft.$$.fragment,t),U(wt.$$.fragment,t),U(_t.$$.fragment,t),U(Ht.$$.fragment,t),U($t.$$.fragment,t),U(Gt.$$.fragment,t),Ws=!0)},o(t){W(D.$$.fragment,t),W(B.$$.fragment,t),W(ft.$$.fragment,t),W(wt.$$.fragment,t),W(_t.$$.fragment,t),W(Ht.$$.fragment,t),W($t.$$.fragment,t),W(Gt.$$.fragment,t),Ws=!1},d(t){t&&(e(_e),e(me),e(be),e(v),e(Le),e(d),e(Me),e(J),e(Te),e(V),e(Ce),e(K),e(Qe),e(X),e(He),e(Y),e(ke),e(Z),e($e),e(tt),e(ze),e(et),e(Pe),e(st),e(Se),e(at),e(Ae),e(nt),e(Ee),e(it),e(Ie),e(lt),e(je),e(rt),e(Re),e(pt),e(Ge),e(ot),e(qe),e(mt),e(Ne),e(ht),e(Ue),e(ct),e(We),e(ut),e(Oe),e(H),e(Fe),e(gt),e(De),e(w),e(Be),e(vt),e(Je),e(dt),e(Ve),e(y),e(Ke),e(yt),e(Xe),e(xt),e(Ye),e(x),e(Ze),e(bt),e(ts),e(Lt),e(es),e(Mt),e(ss),e(Tt),e(as),e(Ct),e(ns),e(Qt),e(is),e(_),e(ls),e(kt),e(rs),e(b),e(ps),e(zt),e(os),e(A),e(cs),e(St),e(us),e(L),e(vs),e(At),e(ds),e(E),e(xs),e(I),e(Ls),e(It),e(Ms),e(j),e(ks),e(jt),e($s),e(Rt),e(zs),e(T),e(Ps),e(qt),e(Ss),e(Nt),e(As),e(Ut),e(Es),e(Wt),e(Is),e(Ot),e(js),e(Ft),e(Rs),e(Dt),e(Gs),e(Bt),e(qs),e(Jt),e(Ns),e(Vt),e(Us),e(ye)),e(f),O(D),O(B),O(ft),O(wt),O(_t),O(Ht),O($t),O(Gt)}}}const ni={local:"q-learning",sections:[{local:"what-is-q-learning",title:"What is Q-Learning? "},{local:"q-learning-algo",sections:[{local:"step1",title:"Step 1: We initialize the Q-table "},{local:"step2",title:"Step 2: Choose an action using the epsilon-greedy strategy "},{local:"step3",title:"Step 3: Perform action At, get reward Rt+1 and next state St+1 "},{local:"step4",title:"Step 4: Update Q(St, At) "}],title:"The Q-Learning algorithm "},{local:"off-vs-on",title:"Off-policy vs On-policy "}],title:"Introducing Q-Learning "};function ii(_a){return Zn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class oi extends ti{constructor(f){super(),ei(this,f,ii,ai,Xn,{})}}export{oi as component};
