import{s as Jn,f as qn,o as Ln,n as xt}from"../chunks/scheduler.9bc65507.js";import{S as Wn,i as Sn,g as n,s,u as g,A as On,h as r,f as t,c as i,j as p,v as _,y as f,k as m,o,a as l,w as b,d as v,t as y,x as D}from"../chunks/index.78c82d43.js";import{T as Zn}from"../chunks/Tip.87d55b76.js";import{D as I}from"../chunks/Docstring.4e7352e2.js";import{C as So}from"../chunks/CodeBlock.73e038be.js";import{I as ce}from"../chunks/IconCopyLink.bedaa44d.js";import{E as Wo}from"../chunks/ExampleCodeBlock.872b014d.js";import{P as An}from"../chunks/PipelineTag.75b0f707.js";function Hn(k){let c,T="Examples:",h,u,w;return u=new So({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlZm9ybWFibGVEZXRyQ29uZmlnJTJDJTIwRGVmb3JtYWJsZURldHJNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBEZWZvcm1hYmxlJTIwREVUUiUyMFNlbnNlVGltZSUyRmRlZm9ybWFibGUtZGV0ciUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBEZWZvcm1hYmxlRGV0ckNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBTZW5zZVRpbWUlMkZkZWZvcm1hYmxlLWRldHIlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMERlZm9ybWFibGVEZXRyTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DeformableDetrConfig, DeformableDetrModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Deformable DETR SenseTime/deformable-detr style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = DeformableDetrConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the SenseTime/deformable-detr style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DeformableDetrModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){c=n("p"),c.textContent=T,h=s(),g(u.$$.fragment)},l(d){c=r(d,"P",{"data-svelte-h":!0}),f(c)!=="svelte-kvfsh7"&&(c.textContent=T),h=i(d),_(u.$$.fragment,d)},m(d,x){l(d,c,x),l(d,h,x),b(u,d,x),w=!0},p:xt,i(d){w||(v(u.$$.fragment,d),w=!0)},o(d){y(u.$$.fragment,d),w=!1},d(d){d&&(t(c),t(h)),D(u,d)}}}function Vn(k){let c,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=n("p"),c.innerHTML=T},l(h){c=r(h,"P",{"data-svelte-h":!0}),f(c)!=="svelte-fincs2"&&(c.innerHTML=T)},m(h,u){l(h,c,u)},p:xt,d(h){h&&t(c)}}}function Gn(k){let c,T="Examples:",h,u,w;return u=new So({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMERlZm9ybWFibGVEZXRyTW9kZWwlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMlNlbnNlVGltZSUyRmRlZm9ybWFibGUtZGV0ciUyMiklMEFtb2RlbCUyMCUzRCUyMERlZm9ybWFibGVEZXRyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMlNlbnNlVGltZSUyRmRlZm9ybWFibGUtZGV0ciUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdChsYXN0X2hpZGRlbl9zdGF0ZXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, DeformableDetrModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;SenseTime/deformable-detr&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DeformableDetrModel.from_pretrained(<span class="hljs-string">&quot;SenseTime/deformable-detr&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">300</span>, <span class="hljs-number">256</span>]`,wrap:!1}}),{c(){c=n("p"),c.textContent=T,h=s(),g(u.$$.fragment)},l(d){c=r(d,"P",{"data-svelte-h":!0}),f(c)!=="svelte-kvfsh7"&&(c.textContent=T),h=i(d),_(u.$$.fragment,d)},m(d,x){l(d,c,x),l(d,h,x),b(u,d,x),w=!0},p:xt,i(d){w||(v(u.$$.fragment,d),w=!0)},o(d){y(u.$$.fragment,d),w=!1},d(d){d&&(t(c),t(h)),D(u,d)}}}function Bn(k){let c,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=n("p"),c.innerHTML=T},l(h){c=r(h,"P",{"data-svelte-h":!0}),f(c)!=="svelte-fincs2"&&(c.innerHTML=T)},m(h,u){l(h,c,u)},p:xt,d(h){h&&t(c)}}}function Xn(k){let c,T="Examples:",h,u,w;return u=new So({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMERlZm9ybWFibGVEZXRyRm9yT2JqZWN0RGV0ZWN0aW9uJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJTZW5zZVRpbWUlMkZkZWZvcm1hYmxlLWRldHIlMjIpJTBBbW9kZWwlMjAlM0QlMjBEZWZvcm1hYmxlRGV0ckZvck9iamVjdERldGVjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyU2Vuc2VUaW1lJTJGZGVmb3JtYWJsZS1kZXRyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQSUyMyUyMGNvbnZlcnQlMjBvdXRwdXRzJTIwKGJvdW5kaW5nJTIwYm94ZXMlMjBhbmQlMjBjbGFzcyUyMGxvZ2l0cyklMjB0byUyMENPQ08lMjBBUEklMEF0YXJnZXRfc2l6ZXMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCaW1hZ2Uuc2l6ZSU1QiUzQSUzQS0xJTVEJTVEKSUwQXJlc3VsdHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX29iamVjdF9kZXRlY3Rpb24ob3V0cHV0cyUyQyUyMHRocmVzaG9sZCUzRDAuNSUyQyUyMHRhcmdldF9zaXplcyUzRHRhcmdldF9zaXplcyklNUIlMEElMjAlMjAlMjAlMjAwJTBBJTVEJTBBZm9yJTIwc2NvcmUlMkMlMjBsYWJlbCUyQyUyMGJveCUyMGluJTIwemlwKHJlc3VsdHMlNUIlMjJzY29yZXMlMjIlNUQlMkMlMjByZXN1bHRzJTVCJTIybGFiZWxzJTIyJTVEJTJDJTIwcmVzdWx0cyU1QiUyMmJveGVzJTIyJTVEKSUzQSUwQSUyMCUyMCUyMCUyMGJveCUyMCUzRCUyMCU1QnJvdW5kKGklMkMlMjAyKSUyMGZvciUyMGklMjBpbiUyMGJveC50b2xpc3QoKSU1RCUwQSUyMCUyMCUyMCUyMHByaW50KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjJEZXRlY3RlZCUyMCU3Qm1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QmxhYmVsLml0ZW0oKSU1RCU3RCUyMHdpdGglMjBjb25maWRlbmNlJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMiU3QnJvdW5kKHNjb3JlLml0ZW0oKSUyQyUyMDMpJTdEJTIwYXQlMjBsb2NhdGlvbiUyMCU3QmJveCU3RCUyMiUwQSUyMCUyMCUyMCUyMCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, DeformableDetrForObjectDetection
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;SenseTime/deformable-detr&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DeformableDetrForObjectDetection.from_pretrained(<span class="hljs-string">&quot;SenseTime/deformable-detr&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># convert outputs (bounding boxes and class logits) to COCO API</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.tensor([image.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">&gt;&gt;&gt; </span>results = image_processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.5</span>, target_sizes=target_sizes)[
<span class="hljs-meta">... </span>    <span class="hljs-number">0</span>
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> score, label, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;labels&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{model.config.id2label[label.item()]}</span> with confidence &quot;</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>
<span class="hljs-meta">... </span>    )
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.8</span> at location [<span class="hljs-number">16.5</span>, <span class="hljs-number">52.84</span>, <span class="hljs-number">318.25</span>, <span class="hljs-number">470.78</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.789</span> at location [<span class="hljs-number">342.19</span>, <span class="hljs-number">24.3</span>, <span class="hljs-number">640.02</span>, <span class="hljs-number">372.25</span>]
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.633</span> at location [<span class="hljs-number">40.79</span>, <span class="hljs-number">72.78</span>, <span class="hljs-number">176.76</span>, <span class="hljs-number">117.25</span>]`,wrap:!1}}),{c(){c=n("p"),c.textContent=T,h=s(),g(u.$$.fragment)},l(d){c=r(d,"P",{"data-svelte-h":!0}),f(c)!=="svelte-kvfsh7"&&(c.textContent=T),h=i(d),_(u.$$.fragment,d)},m(d,x){l(d,c,x),l(d,h,x),b(u,d,x),w=!0},p:xt,i(d){w||(v(u.$$.fragment,d),w=!0)},o(d){y(u.$$.fragment,d),w=!1},d(d){d&&(t(c),t(h)),D(u,d)}}}function Qn(k){let c,T,h,u,w,d,x,me,io,Se,Oo="Deformable DETR",Mt,R,S,pt,fe,lo,Oe,Ao="Overview",Ct,pe,Ho=`The Deformable DETR model was proposed in <a href="https://arxiv.org/abs/2010.04159" rel="nofollow">Deformable DETR: Deformable Transformers for End-to-End Object Detection</a> by Xizhou Zhu, Weijie Su, Lewei Lu, Bin Li, Xiaogang Wang, Jifeng Dai.
Deformable DETR mitigates the slow convergence issues and limited feature spatial resolution of the original <a href="detr">DETR</a> by leveraging a new deformable attention module which only attends to a small set of key sampling points around a reference.`,jt,he,Vo="The abstract from the paper is the following:",$t,ue,Go="<em>DETR has been recently proposed to eliminate the need for many hand-designed components in object detection while demonstrating good performance. However, it suffers from slow convergence and limited feature spatial resolution, due to the limitation of Transformer attention modules in processing image feature maps. To mitigate these issues, we proposed Deformable DETR, whose attention modules only attend to a small set of key sampling points around a reference. Deformable DETR can achieve better performance than DETR (especially on small objects) with 10 times less training epochs. Extensive experiments on the COCO benchmark demonstrate the effectiveness of our approach.</em>",kt,ge,Bo="Tips:",zt,_e,Xo='<li>One can use <a href="/docs/transformers/v4.34.0/en/model_doc/deformable_detr#transformers.DeformableDetrImageProcessor">DeformableDetrImageProcessor</a> to prepare images (and optional targets) for the model.</li> <li>Training Deformable DETR is equivalent to training the original <a href="detr">DETR</a> model. See the <a href="#resources">resources</a> section below for demo notebooks.</li>',Ut,O,Qo,Ft,be,Yo='Deformable DETR architecture. Taken from the <a href="https://arxiv.org/abs/2010.04159">original paper</a>.',It,ve,Ko='This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The original code can be found <a href="https://github.com/fundamentalvision/Deformable-DETR" rel="nofollow">here</a>.',Et,N,A,ht,ye,co,Ae,en="Resources",Pt,De,tn="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with Deformable DETR.",Rt,we,Nt,Te,on='<li>Demo notebooks regarding inference + fine-tuning on a custom dataset for <a href="/docs/transformers/v4.34.0/en/model_doc/deformable_detr#transformers.DeformableDetrForObjectDetection">DeformableDetrForObjectDetection</a> can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/Deformable-DETR" rel="nofollow">here</a>.</li> <li>See also: <a href="../tasks/object_detection">Object detection task guide</a>.</li>',Zt,xe,nn="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",Jt,Z,H,ut,Me,mo,He,rn="DeformableDetrImageProcessor",qt,j,Ce,fo,Ve,an="Constructs a Deformable DETR image processor.",po,V,je,ho,Ge,sn="Preprocess an image or a batch of images so that it can be used by the model.",uo,G,$e,go,Be,ln=`Converts the raw output of <a href="/docs/transformers/v4.34.0/en/model_doc/deformable_detr#transformers.DeformableDetrForObjectDetection">DeformableDetrForObjectDetection</a> into final bounding boxes in (top_left_x,
top_left_y, bottom_right_x, bottom_right_y) format. Only supports PyTorch.`,Lt,J,B,gt,ke,_o,Xe,dn="DeformableDetrFeatureExtractor",Wt,F,ze,bo,X,Ue,vo,Qe,cn="Preprocess an image or a batch of images.",yo,Q,Fe,Do,Ye,mn=`Converts the raw output of <a href="/docs/transformers/v4.34.0/en/model_doc/deformable_detr#transformers.DeformableDetrForObjectDetection">DeformableDetrForObjectDetection</a> into final bounding boxes in (top_left_x,
top_left_y, bottom_right_x, bottom_right_y) format. Only supports PyTorch.`,St,q,Y,_t,Ie,wo,Ke,fn="DeformableDetrConfig",Ot,$,Ee,To,et,pn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.34.0/en/model_doc/deformable_detr#transformers.DeformableDetrModel">DeformableDetrModel</a>. It is used to instantiate
a Deformable DETR model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Deformable DETR
<a href="https://huggingface.co/SenseTime/deformable-detr" rel="nofollow">SenseTime/deformable-detr</a> architecture.`,xo,tt,hn=`Configuration objects inherit from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Mo,K,At,L,ee,bt,Pe,Co,ot,un="DeformableDetrModel",Ht,M,Re,jo,nt,gn=`The bare Deformable DETR Model (consisting of a backbone and encoder-decoder Transformer) outputting raw
hidden-states without any specific head on top.`,$o,rt,_n=`This model inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ko,at,bn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,zo,z,Ne,Uo,st,vn='The <a href="/docs/transformers/v4.34.0/en/model_doc/deformable_detr#transformers.DeformableDetrModel">DeformableDetrModel</a> forward method, overrides the <code>__call__</code> special method.',Fo,te,Io,oe,Vt,W,ne,vt,Ze,Eo,it,yn="DeformableDetrForObjectDetection",Gt,C,Je,Po,lt,Dn=`Deformable DETR Model (consisting of a backbone and encoder-decoder Transformer) with object detection heads on
top, for tasks such as COCO detection.`,Ro,dt,wn=`This model inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,No,ct,Tn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Zo,U,qe,Jo,mt,xn='The <a href="/docs/transformers/v4.34.0/en/model_doc/deformable_detr#transformers.DeformableDetrForObjectDetection">DeformableDetrForObjectDetection</a> forward method, overrides the <code>__call__</code> special method.',qo,re,Lo,ae,Bt,yt,Xt;return me=new ce({}),fe=new ce({}),ye=new ce({}),we=new An({props:{pipeline:"object-detection"}}),Me=new ce({}),Ce=new I({props:{name:"class transformers.DeformableDetrImageProcessor",anchor:"transformers.DeformableDetrImageProcessor",parameters:[{name:"format",val:": typing.Union[str, transformers.models.deformable_detr.image_processing_deformable_detr.AnnotionFormat] = <AnnotionFormat.COCO_DETECTION: 'coco_detection'>"},{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float]] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float]] = None"},{name:"do_pad",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DeformableDetrImageProcessor.format",description:`<strong>format</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;coco_detection&quot;</code>) &#x2014;
Data format of the annotations. One of &#x201C;coco_detection&#x201D; or &#x201C;coco_panoptic&#x201D;.`,name:"format"},{anchor:"transformers.DeformableDetrImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be
overridden by the <code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.DeformableDetrImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 800, &quot;longest_edge&quot;: 1333}</code>):
Size of the image&#x2019;s (height, width) dimensions after resizing. Can be overridden by the <code>size</code> parameter in
the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.DeformableDetrImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image.`,name:"resample"},{anchor:"transformers.DeformableDetrImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the
<code>do_rescale</code> parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.DeformableDetrImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.
do_normalize &#x2014;
Controls whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the
<code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.DeformableDetrImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_MEAN</code>) &#x2014;
Mean values to use when normalizing the image. Can be a single value or a list of values, one for each
channel. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.DeformableDetrImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_STD</code>) &#x2014;
Standard deviation values to use when normalizing the image. Can be a single value or a list of values, one
for each channel. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.DeformableDetrImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to pad the image to the largest image in a batch and create a pixel mask. Can be
overridden by the <code>do_pad</code> parameter in the <code>preprocess</code> method.`,name:"do_pad"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deformable_detr/image_processing_deformable_detr.py#L761"}}),je=new I({props:{name:"preprocess",anchor:"transformers.DeformableDetrImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"annotations",val:": typing.Union[typing.Dict[str, typing.Union[int, str, typing.List[typing.Dict]]], typing.List[typing.Dict[str, typing.Union[int, str, typing.List[typing.Dict]]]], NoneType] = None"},{name:"return_segmentation_masks",val:": bool = None"},{name:"masks_path",val:": typing.Union[str, pathlib.Path, NoneType] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Union[typing.Dict[str, int], NoneType] = None"},{name:"resample",val:" = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Union[int, float, NoneType] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": typing.Optional[bool] = None"},{name:"format",val:": typing.Union[str, transformers.models.deformable_detr.image_processing_deformable_detr.AnnotionFormat, NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DeformableDetrImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image or batch of images to preprocess. Expects a single or batch of images with pixel values ranging
from 0 to 255. If passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.annotations",description:`<strong>annotations</strong> (<code>AnnotationType</code> or <code>List[AnnotationType]</code>, <em>optional</em>) &#x2014;
List of annotations associated with the image or batch of images. If annotation is for object
detection, the annotations should be a dictionary with the following keys:<ul>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;annotations&#x201D; (<code>List[Dict]</code>): List of annotations for an image. Each annotation should be a
dictionary. An image can have no annotations, in which case the list should be empty.
If annotation is for segmentation, the annotations should be a dictionary with the following keys:</li>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;segments_info&#x201D; (<code>List[Dict]</code>): List of segments for an image. Each segment should be a dictionary.
An image can have no segments, in which case the list should be empty.</li>
<li>&#x201C;file_name&#x201D; (<code>str</code>): The file name of the image.</li>
</ul>`,name:"annotations"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.return_segmentation_masks",description:`<strong>return_segmentation_masks</strong> (<code>bool</code>, <em>optional</em>, defaults to self.return_segmentation_masks) &#x2014;
Whether to return segmentation masks.`,name:"return_segmentation_masks"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.masks_path",description:`<strong>masks_path</strong> (<code>str</code> or <code>pathlib.Path</code>, <em>optional</em>) &#x2014;
Path to the directory containing the segmentation masks.`,name:"masks_path"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_resize) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to self.size) &#x2014;
Size of the image after resizing.`,name:"size"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to self.resample) &#x2014;
Resampling filter to use when resizing the image.`,name:"resample"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_rescale) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to self.rescale_factor) &#x2014;
Rescale factor to use when rescaling the image.`,name:"rescale_factor"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_normalize) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_mean) &#x2014;
Mean to use when normalizing the image.`,name:"image_mean"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_std) &#x2014;
Standard deviation to use when normalizing the image.`,name:"image_std"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_pad) &#x2014;
Whether to pad the image.`,name:"do_pad"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.format",description:`<strong>format</strong> (<code>str</code> or <code>AnnotionFormat</code>, <em>optional</em>, defaults to self.format) &#x2014;
Format of the annotations.`,name:"format"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to self.return_tensors) &#x2014;
Type of tensors to return. If <code>None</code>, will return the list of images.`,name:"return_tensors"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deformable_detr/image_processing_deformable_detr.py#L1102"}}),$e=new I({props:{name:"post_process_object_detection",anchor:"transformers.DeformableDetrImageProcessor.post_process_object_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple]] = None"},{name:"top_k",val:": int = 100"}],parametersDescription:[{anchor:"transformers.DeformableDetrImageProcessor.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>DetrObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.DeformableDetrImageProcessor.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.DeformableDetrImageProcessor.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
(height, width) of each image in the batch. If left to None, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.DeformableDetrImageProcessor.post_process_object_detection.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
Keep only top k bounding boxes before filtering by thresholding.`,name:"top_k"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deformable_detr/image_processing_deformable_detr.py#L1393",returnDescription:`
<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`
<p><code>List[Dict]</code></p>
`}}),ke=new ce({}),ze=new I({props:{name:"class transformers.DeformableDetrFeatureExtractor",anchor:"transformers.DeformableDetrFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deformable_detr/feature_extraction_deformable_detr.py#L26"}}),Ue=new I({props:{name:"__call__",anchor:"transformers.DeformableDetrFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/image_processing_utils.py#L544"}}),Fe=new I({props:{name:"post_process_object_detection",anchor:"transformers.DeformableDetrFeatureExtractor.post_process_object_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple]] = None"},{name:"top_k",val:": int = 100"}],parametersDescription:[{anchor:"transformers.DeformableDetrFeatureExtractor.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>DetrObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.DeformableDetrFeatureExtractor.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.DeformableDetrFeatureExtractor.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
(height, width) of each image in the batch. If left to None, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.DeformableDetrFeatureExtractor.post_process_object_detection.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
Keep only top k bounding boxes before filtering by thresholding.`,name:"top_k"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deformable_detr/image_processing_deformable_detr.py#L1393",returnDescription:`
<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`
<p><code>List[Dict]</code></p>
`}}),Ie=new ce({}),Ee=new I({props:{name:"class transformers.DeformableDetrConfig",anchor:"transformers.DeformableDetrConfig",parameters:[{name:"use_timm_backbone",val:" = True"},{name:"backbone_config",val:" = None"},{name:"num_channels",val:" = 3"},{name:"num_queries",val:" = 300"},{name:"max_position_embeddings",val:" = 1024"},{name:"encoder_layers",val:" = 6"},{name:"encoder_ffn_dim",val:" = 1024"},{name:"encoder_attention_heads",val:" = 8"},{name:"decoder_layers",val:" = 6"},{name:"decoder_ffn_dim",val:" = 1024"},{name:"decoder_attention_heads",val:" = 8"},{name:"encoder_layerdrop",val:" = 0.0"},{name:"is_encoder_decoder",val:" = True"},{name:"activation_function",val:" = 'relu'"},{name:"d_model",val:" = 256"},{name:"dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"init_std",val:" = 0.02"},{name:"init_xavier_std",val:" = 1.0"},{name:"return_intermediate",val:" = True"},{name:"auxiliary_loss",val:" = False"},{name:"position_embedding_type",val:" = 'sine'"},{name:"backbone",val:" = 'resnet50'"},{name:"use_pretrained_backbone",val:" = True"},{name:"dilation",val:" = False"},{name:"num_feature_levels",val:" = 4"},{name:"encoder_n_points",val:" = 4"},{name:"decoder_n_points",val:" = 4"},{name:"two_stage",val:" = False"},{name:"two_stage_num_proposals",val:" = 300"},{name:"with_box_refine",val:" = False"},{name:"class_cost",val:" = 1"},{name:"bbox_cost",val:" = 5"},{name:"giou_cost",val:" = 2"},{name:"mask_loss_coefficient",val:" = 1"},{name:"dice_loss_coefficient",val:" = 1"},{name:"bbox_loss_coefficient",val:" = 5"},{name:"giou_loss_coefficient",val:" = 2"},{name:"eos_coefficient",val:" = 0.1"},{name:"focal_alpha",val:" = 0.25"},{name:"disable_custom_kernels",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DeformableDetrConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to use the <code>timm</code> library for the backbone. If set to <code>False</code>, will use the <code>AutoBackbone</code>
API.`,name:"use_timm_backbone"},{anchor:"transformers.DeformableDetrConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code> or <code>dict</code>, <em>optional</em>) &#x2014;
The configuration of the backbone model. Only used in case <code>use_timm_backbone</code> is set to <code>False</code> in which
case it will default to <code>ResNetConfig()</code>.`,name:"backbone_config"},{anchor:"transformers.DeformableDetrConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.DeformableDetrConfig.num_queries",description:`<strong>num_queries</strong> (<code>int</code>, <em>optional</em>, defaults to 300) &#x2014;
Number of object queries, i.e. detection slots. This is the maximal number of objects
<a href="/docs/transformers/v4.34.0/en/model_doc/deformable_detr#transformers.DeformableDetrModel">DeformableDetrModel</a> can detect in a single image. In case <code>two_stage</code> is set to <code>True</code>, we use
<code>two_stage_num_proposals</code> instead.`,name:"num_queries"},{anchor:"transformers.DeformableDetrConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimension of the layers.`,name:"d_model"},{anchor:"transformers.DeformableDetrConfig.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of encoder layers.`,name:"encoder_layers"},{anchor:"transformers.DeformableDetrConfig.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of decoder layers.`,name:"decoder_layers"},{anchor:"transformers.DeformableDetrConfig.encoder_attention_heads",description:`<strong>encoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"encoder_attention_heads"},{anchor:"transformers.DeformableDetrConfig.decoder_attention_heads",description:`<strong>decoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"decoder_attention_heads"},{anchor:"transformers.DeformableDetrConfig.decoder_ffn_dim",description:`<strong>decoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"decoder_ffn_dim"},{anchor:"transformers.DeformableDetrConfig.encoder_ffn_dim",description:`<strong>encoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"encoder_ffn_dim"},{anchor:"transformers.DeformableDetrConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.DeformableDetrConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"dropout"},{anchor:"transformers.DeformableDetrConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.DeformableDetrConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.DeformableDetrConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"init_std"},{anchor:"transformers.DeformableDetrConfig.init_xavier_std",description:`<strong>init_xavier_std</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
The scaling factor used for the Xavier initialization gain in the HM Attention map module.`,name:"init_xavier_std"},{anchor:"transformers.DeformableDetrConfig.encoder_layerdrop",description:`<strong>encoder_layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the encoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"encoder_layerdrop"},{anchor:"transformers.DeformableDetrConfig.auxiliary_loss",description:`<strong>auxiliary_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether auxiliary decoding losses (loss at each decoder layer) are to be used.`,name:"auxiliary_loss"},{anchor:"transformers.DeformableDetrConfig.position_embedding_type",description:`<strong>position_embedding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sine&quot;</code>) &#x2014;
Type of position embeddings to be used on top of the image features. One of <code>&quot;sine&quot;</code> or <code>&quot;learned&quot;</code>.`,name:"position_embedding_type"},{anchor:"transformers.DeformableDetrConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;resnet50&quot;</code>) &#x2014;
Name of convolutional backbone to use in case <code>use_timm_backbone</code> = <code>True</code>. Supports any convolutional
backbone from the timm package. For a list of all available models, see <a href="https://rwightman.github.io/pytorch-image-models/#load-a-pretrained-model" rel="nofollow">this
page</a>.`,name:"backbone"},{anchor:"transformers.DeformableDetrConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use pretrained weights for the backbone. Only supported when <code>use_timm_backbone</code> = <code>True</code>.`,name:"use_pretrained_backbone"},{anchor:"transformers.DeformableDetrConfig.dilation",description:`<strong>dilation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to replace stride with dilation in the last convolutional block (DC5). Only supported when
<code>use_timm_backbone</code> = <code>True</code>.`,name:"dilation"},{anchor:"transformers.DeformableDetrConfig.class_cost",description:`<strong>class_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Relative weight of the classification error in the Hungarian matching cost.`,name:"class_cost"},{anchor:"transformers.DeformableDetrConfig.bbox_cost",description:`<strong>bbox_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 error of the bounding box coordinates in the Hungarian matching cost.`,name:"bbox_cost"},{anchor:"transformers.DeformableDetrConfig.giou_cost",description:`<strong>giou_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss of the bounding box in the Hungarian matching cost.`,name:"giou_cost"},{anchor:"transformers.DeformableDetrConfig.mask_loss_coefficient",description:`<strong>mask_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Relative weight of the Focal loss in the panoptic segmentation loss.`,name:"mask_loss_coefficient"},{anchor:"transformers.DeformableDetrConfig.dice_loss_coefficient",description:`<strong>dice_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Relative weight of the DICE/F-1 loss in the panoptic segmentation loss.`,name:"dice_loss_coefficient"},{anchor:"transformers.DeformableDetrConfig.bbox_loss_coefficient",description:`<strong>bbox_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 bounding box loss in the object detection loss.`,name:"bbox_loss_coefficient"},{anchor:"transformers.DeformableDetrConfig.giou_loss_coefficient",description:`<strong>giou_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss in the object detection loss.`,name:"giou_loss_coefficient"},{anchor:"transformers.DeformableDetrConfig.eos_coefficient",description:`<strong>eos_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Relative classification weight of the &#x2018;no-object&#x2019; class in the object detection loss.`,name:"eos_coefficient"},{anchor:"transformers.DeformableDetrConfig.num_feature_levels",description:`<strong>num_feature_levels</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of input feature levels.`,name:"num_feature_levels"},{anchor:"transformers.DeformableDetrConfig.encoder_n_points",description:`<strong>encoder_n_points</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of sampled keys in each feature level for each attention head in the encoder.`,name:"encoder_n_points"},{anchor:"transformers.DeformableDetrConfig.decoder_n_points",description:`<strong>decoder_n_points</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of sampled keys in each feature level for each attention head in the decoder.`,name:"decoder_n_points"},{anchor:"transformers.DeformableDetrConfig.two_stage",description:`<strong>two_stage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to apply a two-stage deformable DETR, where the region proposals are also generated by a variant of
Deformable DETR, which are further fed into the decoder for iterative bounding box refinement.`,name:"two_stage"},{anchor:"transformers.DeformableDetrConfig.two_stage_num_proposals",description:`<strong>two_stage_num_proposals</strong> (<code>int</code>, <em>optional</em>, defaults to 300) &#x2014;
The number of region proposals to be generated, in case <code>two_stage</code> is set to <code>True</code>.`,name:"two_stage_num_proposals"},{anchor:"transformers.DeformableDetrConfig.with_box_refine",description:`<strong>with_box_refine</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to apply iterative bounding box refinement, where each decoder layer refines the bounding boxes
based on the predictions from the previous layer.`,name:"with_box_refine"},{anchor:"transformers.DeformableDetrConfig.focal_alpha",description:`<strong>focal_alpha</strong> (<code>float</code>, <em>optional</em>, defaults to 0.25) &#x2014;
Alpha parameter in the focal loss.`,name:"focal_alpha"},{anchor:"transformers.DeformableDetrConfig.disable_custom_kernels",description:`<strong>disable_custom_kernels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Disable the use of custom CUDA and CPU kernels. This option is necessary for the ONNX export, as custom
kernels are not supported by PyTorch ONNX export.`,name:"disable_custom_kernels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deformable_detr/configuration_deformable_detr.py#L30"}}),K=new Wo({props:{anchor:"transformers.DeformableDetrConfig.example",$$slots:{default:[Hn]},$$scope:{ctx:k}}}),Pe=new ce({}),Re=new I({props:{name:"class transformers.DeformableDetrModel",anchor:"transformers.DeformableDetrModel",parameters:[{name:"config",val:": DeformableDetrConfig"}],parametersDescription:[{anchor:"transformers.DeformableDetrModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/deformable_detr#transformers.DeformableDetrConfig">DeformableDetrConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deformable_detr/modeling_deformable_detr.py#L1475"}}),Ne=new I({props:{name:"forward",anchor:"transformers.DeformableDetrModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"pixel_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DeformableDetrModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__">DeformableDetrImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.DeformableDetrModel.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.DeformableDetrModel.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries)</code>, <em>optional</em>) &#x2014;
Not used by default. Can be used to mask object queries.`,name:"decoder_attention_mask"},{anchor:"transformers.DeformableDetrModel.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.DeformableDetrModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing the flattened feature map (output of the backbone + projection layer), you
can choose to directly pass a flattened representation of an image.`,name:"inputs_embeds"},{anchor:"transformers.DeformableDetrModel.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of initializing the queries with a tensor of zeros, you can choose to directly pass an
embedded representation.`,name:"decoder_inputs_embeds"},{anchor:"transformers.DeformableDetrModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DeformableDetrModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DeformableDetrModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deformable_detr/modeling_deformable_detr.py#L1624",returnDescription:`
<p>A <code>transformers.models.deformable_detr.modeling_deformable_detr.DeformableDetrModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/deformable_detr#transformers.DeformableDetrConfig"
>DeformableDetrConfig</a>) and inputs.</p>
<ul>
<li><strong>init_reference_points</strong> (<code>torch.FloatTensor</code> of shape  <code>(batch_size, num_queries, 4)</code>) — Initial reference points sent through the Transformer decoder.</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>intermediate_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.decoder_layers, num_queries, hidden_size)</code>) — Stacked intermediate hidden states (output of each layer of the decoder).</li>
<li><strong>intermediate_reference_points</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.decoder_layers, num_queries, 4)</code>) — Stacked intermediate reference points (reference points of each layer of the decoder).</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, num_queries, hidden_size)</code>. Hidden-states of the decoder at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, num_queries, num_queries)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the weighted
average in the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_queries, num_heads, 4, 4)</code>.
Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_queries, num_heads, 4, 4)</code>.
Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</li>
<li><strong>enc_outputs_class</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>, <em>optional</em>, returned when <code>config.with_box_refine=True</code> and <code>config.two_stage=True</code>) — Predicted bounding boxes scores where the top <code>config.two_stage_num_proposals</code> scoring bounding boxes are
picked as region proposals in the first stage. Output of bounding box binary classification (i.e.
foreground and background).</li>
<li><strong>enc_outputs_coord_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, 4)</code>, <em>optional</em>, returned when <code>config.with_box_refine=True</code> and <code>config.two_stage=True</code>) — Logits of predicted bounding boxes coordinates in the first stage.</li>
</ul>
`,returnType:`
<p><code>transformers.models.deformable_detr.modeling_deformable_detr.DeformableDetrModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),te=new Zn({props:{$$slots:{default:[Vn]},$$scope:{ctx:k}}}),oe=new Wo({props:{anchor:"transformers.DeformableDetrModel.forward.example",$$slots:{default:[Gn]},$$scope:{ctx:k}}}),Ze=new ce({}),Je=new I({props:{name:"class transformers.DeformableDetrForObjectDetection",anchor:"transformers.DeformableDetrForObjectDetection",parameters:[{name:"config",val:": DeformableDetrConfig"}],parametersDescription:[{anchor:"transformers.DeformableDetrForObjectDetection.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/deformable_detr#transformers.DeformableDetrConfig">DeformableDetrConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deformable_detr/modeling_deformable_detr.py#L1832"}}),qe=new I({props:{name:"forward",anchor:"transformers.DeformableDetrForObjectDetection.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"pixel_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[typing.List[dict]] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DeformableDetrForObjectDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__">DeformableDetrImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.DeformableDetrForObjectDetection.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.DeformableDetrForObjectDetection.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries)</code>, <em>optional</em>) &#x2014;
Not used by default. Can be used to mask object queries.`,name:"decoder_attention_mask"},{anchor:"transformers.DeformableDetrForObjectDetection.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.DeformableDetrForObjectDetection.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing the flattened feature map (output of the backbone + projection layer), you
can choose to directly pass a flattened representation of an image.`,name:"inputs_embeds"},{anchor:"transformers.DeformableDetrForObjectDetection.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of initializing the queries with a tensor of zeros, you can choose to directly pass an
embedded representation.`,name:"decoder_inputs_embeds"},{anchor:"transformers.DeformableDetrForObjectDetection.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DeformableDetrForObjectDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DeformableDetrForObjectDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.DeformableDetrForObjectDetection.forward.labels",description:`<strong>labels</strong> (<code>List[Dict]</code> of len <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the bipartite matching loss. List of dicts, each dictionary containing at least the
following 2 keys: &#x2018;class_labels&#x2019; and &#x2018;boxes&#x2019; (the class labels and bounding boxes of an image in the batch
respectively). The class labels themselves should be a <code>torch.LongTensor</code> of len <code>(number of bounding boxes in the image,)</code> and the boxes a <code>torch.FloatTensor</code> of shape <code>(number of bounding boxes in the image, 4)</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deformable_detr/modeling_deformable_detr.py#L1884",returnDescription:`
<p>A <code>transformers.models.deformable_detr.modeling_deformable_detr.DeformableDetrObjectDetectionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/deformable_detr#transformers.DeformableDetrConfig"
>DeformableDetrConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) — Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.</li>
<li><strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) — A dictionary containing the individual losses. Useful for logging.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes + 1)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <code>~DeformableDetrProcessor.post_process_object_detection</code> to retrieve the
unnormalized bounding boxes.</li>
<li><strong>auxiliary_outputs</strong> (<code>list[Dict]</code>, <em>optional</em>) — Optional, only returned when auxilary losses are activated (i.e. <code>config.auxiliary_loss</code> is set to <code>True</code>)
and labels are provided. It is a list of dictionaries containing the two above keys (<code>logits</code> and
<code>pred_boxes</code>) for each decoder layer.</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, num_queries, hidden_size)</code>. Hidden-states of the decoder at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, num_queries, num_queries)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the weighted
average in the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_queries, num_heads, 4, 4)</code>.
Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, sequence_length, num_heads, 4, 4)</code>. Attentions weights of the encoder, after the attention softmax, used to compute the weighted average
in the self-attention heads.</li>
<li><strong>intermediate_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.decoder_layers, num_queries, hidden_size)</code>) — Stacked intermediate hidden states (output of each layer of the decoder).</li>
<li><strong>intermediate_reference_points</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.decoder_layers, num_queries, 4)</code>) — Stacked intermediate reference points (reference points of each layer of the decoder).</li>
<li><strong>init_reference_points</strong> (<code>torch.FloatTensor</code> of shape  <code>(batch_size, num_queries, 4)</code>) — Initial reference points sent through the Transformer decoder.</li>
<li><strong>enc_outputs_class</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>, <em>optional</em>, returned when <code>config.with_box_refine=True</code> and <code>config.two_stage=True</code>) — Predicted bounding boxes scores where the top <code>config.two_stage_num_proposals</code> scoring bounding boxes are
picked as region proposals in the first stage. Output of bounding box binary classification (i.e.
foreground and background).</li>
<li><strong>enc_outputs_coord_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, 4)</code>, <em>optional</em>, returned when <code>config.with_box_refine=True</code> and <code>config.two_stage=True</code>) — Logits of predicted bounding boxes coordinates in the first stage.</li>
</ul>
`,returnType:`
<p><code>transformers.models.deformable_detr.modeling_deformable_detr.DeformableDetrObjectDetectionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),re=new Zn({props:{$$slots:{default:[Bn]},$$scope:{ctx:k}}}),ae=new Wo({props:{anchor:"transformers.DeformableDetrForObjectDetection.forward.example",$$slots:{default:[Xn]},$$scope:{ctx:k}}}),{c(){c=n("meta"),T=s(),h=n("p"),u=s(),w=n("h1"),d=n("a"),x=n("span"),g(me.$$.fragment),io=s(),Se=n("span"),Se.textContent=Oo,Mt=s(),R=n("h2"),S=n("a"),pt=n("span"),g(fe.$$.fragment),lo=s(),Oe=n("span"),Oe.textContent=Ao,Ct=s(),pe=n("p"),pe.innerHTML=Ho,jt=s(),he=n("p"),he.textContent=Vo,$t=s(),ue=n("p"),ue.innerHTML=Go,kt=s(),ge=n("p"),ge.textContent=Bo,zt=s(),_e=n("ul"),_e.innerHTML=Xo,Ut=s(),O=n("img"),Ft=s(),be=n("small"),be.innerHTML=Yo,It=s(),ve=n("p"),ve.innerHTML=Ko,Et=s(),N=n("h2"),A=n("a"),ht=n("span"),g(ye.$$.fragment),co=s(),Ae=n("span"),Ae.textContent=en,Pt=s(),De=n("p"),De.textContent=tn,Rt=s(),g(we.$$.fragment),Nt=s(),Te=n("ul"),Te.innerHTML=on,Zt=s(),xe=n("p"),xe.textContent=nn,Jt=s(),Z=n("h2"),H=n("a"),ut=n("span"),g(Me.$$.fragment),mo=s(),He=n("span"),He.textContent=rn,qt=s(),j=n("div"),g(Ce.$$.fragment),fo=s(),Ve=n("p"),Ve.textContent=an,po=s(),V=n("div"),g(je.$$.fragment),ho=s(),Ge=n("p"),Ge.textContent=sn,uo=s(),G=n("div"),g($e.$$.fragment),go=s(),Be=n("p"),Be.innerHTML=ln,Lt=s(),J=n("h2"),B=n("a"),gt=n("span"),g(ke.$$.fragment),_o=s(),Xe=n("span"),Xe.textContent=dn,Wt=s(),F=n("div"),g(ze.$$.fragment),bo=s(),X=n("div"),g(Ue.$$.fragment),vo=s(),Qe=n("p"),Qe.textContent=cn,yo=s(),Q=n("div"),g(Fe.$$.fragment),Do=s(),Ye=n("p"),Ye.innerHTML=mn,St=s(),q=n("h2"),Y=n("a"),_t=n("span"),g(Ie.$$.fragment),wo=s(),Ke=n("span"),Ke.textContent=fn,Ot=s(),$=n("div"),g(Ee.$$.fragment),To=s(),et=n("p"),et.innerHTML=pn,xo=s(),tt=n("p"),tt.innerHTML=hn,Mo=s(),g(K.$$.fragment),At=s(),L=n("h2"),ee=n("a"),bt=n("span"),g(Pe.$$.fragment),Co=s(),ot=n("span"),ot.textContent=un,Ht=s(),M=n("div"),g(Re.$$.fragment),jo=s(),nt=n("p"),nt.textContent=gn,$o=s(),rt=n("p"),rt.innerHTML=_n,ko=s(),at=n("p"),at.innerHTML=bn,zo=s(),z=n("div"),g(Ne.$$.fragment),Uo=s(),st=n("p"),st.innerHTML=vn,Fo=s(),g(te.$$.fragment),Io=s(),g(oe.$$.fragment),Vt=s(),W=n("h2"),ne=n("a"),vt=n("span"),g(Ze.$$.fragment),Eo=s(),it=n("span"),it.textContent=yn,Gt=s(),C=n("div"),g(Je.$$.fragment),Po=s(),lt=n("p"),lt.textContent=Dn,Ro=s(),dt=n("p"),dt.innerHTML=wn,No=s(),ct=n("p"),ct.innerHTML=Tn,Zo=s(),U=n("div"),g(qe.$$.fragment),Jo=s(),mt=n("p"),mt.innerHTML=xn,qo=s(),g(re.$$.fragment),Lo=s(),g(ae.$$.fragment),Bt=s(),yt=n("p"),this.h()},l(e){const a=On("svelte-1phssyn",document.head);c=r(a,"META",{name:!0,content:!0}),a.forEach(t),T=i(e),h=r(e,"P",{}),p(h).forEach(t),u=i(e),w=r(e,"H1",{class:!0});var Le=p(w);d=r(Le,"A",{id:!0,class:!0,href:!0});var Dt=p(d);x=r(Dt,"SPAN",{});var wt=p(x);_(me.$$.fragment,wt),wt.forEach(t),Dt.forEach(t),io=i(Le),Se=r(Le,"SPAN",{"data-svelte-h":!0}),f(Se)!=="svelte-esjdzd"&&(Se.textContent=Oo),Le.forEach(t),Mt=i(e),R=r(e,"H2",{class:!0});var We=p(R);S=r(We,"A",{id:!0,class:!0,href:!0});var Tt=p(S);pt=r(Tt,"SPAN",{});var Mn=p(pt);_(fe.$$.fragment,Mn),Mn.forEach(t),Tt.forEach(t),lo=i(We),Oe=r(We,"SPAN",{"data-svelte-h":!0}),f(Oe)!=="svelte-1jsw1pg"&&(Oe.textContent=Ao),We.forEach(t),Ct=i(e),pe=r(e,"P",{"data-svelte-h":!0}),f(pe)!=="svelte-1mg55mk"&&(pe.innerHTML=Ho),jt=i(e),he=r(e,"P",{"data-svelte-h":!0}),f(he)!=="svelte-vfdo9a"&&(he.textContent=Vo),$t=i(e),ue=r(e,"P",{"data-svelte-h":!0}),f(ue)!=="svelte-z1y2k"&&(ue.innerHTML=Go),kt=i(e),ge=r(e,"P",{"data-svelte-h":!0}),f(ge)!=="svelte-axv494"&&(ge.textContent=Bo),zt=i(e),_e=r(e,"UL",{"data-svelte-h":!0}),f(_e)!=="svelte-xqtebr"&&(_e.innerHTML=Xo),Ut=i(e),O=r(e,"IMG",{src:!0,alt:!0,width:!0}),Ft=i(e),be=r(e,"SMALL",{"data-svelte-h":!0}),f(be)!=="svelte-1bl4e9a"&&(be.innerHTML=Yo),It=i(e),ve=r(e,"P",{"data-svelte-h":!0}),f(ve)!=="svelte-16ajxx"&&(ve.innerHTML=Ko),Et=i(e),N=r(e,"H2",{class:!0});var Qt=p(N);A=r(Qt,"A",{id:!0,class:!0,href:!0});var Cn=p(A);ht=r(Cn,"SPAN",{});var jn=p(ht);_(ye.$$.fragment,jn),jn.forEach(t),Cn.forEach(t),co=i(Qt),Ae=r(Qt,"SPAN",{"data-svelte-h":!0}),f(Ae)!=="svelte-w4zzv6"&&(Ae.textContent=en),Qt.forEach(t),Pt=i(e),De=r(e,"P",{"data-svelte-h":!0}),f(De)!=="svelte-1rgxvdl"&&(De.textContent=tn),Rt=i(e),_(we.$$.fragment,e),Nt=i(e),Te=r(e,"UL",{"data-svelte-h":!0}),f(Te)!=="svelte-pjn2j5"&&(Te.innerHTML=on),Zt=i(e),xe=r(e,"P",{"data-svelte-h":!0}),f(xe)!=="svelte-1xesile"&&(xe.textContent=nn),Jt=i(e),Z=r(e,"H2",{class:!0});var Yt=p(Z);H=r(Yt,"A",{id:!0,class:!0,href:!0});var $n=p(H);ut=r($n,"SPAN",{});var kn=p(ut);_(Me.$$.fragment,kn),kn.forEach(t),$n.forEach(t),mo=i(Yt),He=r(Yt,"SPAN",{"data-svelte-h":!0}),f(He)!=="svelte-1fudmkk"&&(He.textContent=rn),Yt.forEach(t),qt=i(e),j=r(e,"DIV",{class:!0});var se=p(j);_(Ce.$$.fragment,se),fo=i(se),Ve=r(se,"P",{"data-svelte-h":!0}),f(Ve)!=="svelte-54uec8"&&(Ve.textContent=an),po=i(se),V=r(se,"DIV",{class:!0});var Kt=p(V);_(je.$$.fragment,Kt),ho=i(Kt),Ge=r(Kt,"P",{"data-svelte-h":!0}),f(Ge)!=="svelte-jgz2ra"&&(Ge.textContent=sn),Kt.forEach(t),uo=i(se),G=r(se,"DIV",{class:!0});var eo=p(G);_($e.$$.fragment,eo),go=i(eo),Be=r(eo,"P",{"data-svelte-h":!0}),f(Be)!=="svelte-y56vea"&&(Be.innerHTML=ln),eo.forEach(t),se.forEach(t),Lt=i(e),J=r(e,"H2",{class:!0});var to=p(J);B=r(to,"A",{id:!0,class:!0,href:!0});var zn=p(B);gt=r(zn,"SPAN",{});var Un=p(gt);_(ke.$$.fragment,Un),Un.forEach(t),zn.forEach(t),_o=i(to),Xe=r(to,"SPAN",{"data-svelte-h":!0}),f(Xe)!=="svelte-1z6cvb"&&(Xe.textContent=dn),to.forEach(t),Wt=i(e),F=r(e,"DIV",{class:!0});var ft=p(F);_(ze.$$.fragment,ft),bo=i(ft),X=r(ft,"DIV",{class:!0});var oo=p(X);_(Ue.$$.fragment,oo),vo=i(oo),Qe=r(oo,"P",{"data-svelte-h":!0}),f(Qe)!=="svelte-khengj"&&(Qe.textContent=cn),oo.forEach(t),yo=i(ft),Q=r(ft,"DIV",{class:!0});var no=p(Q);_(Fe.$$.fragment,no),Do=i(no),Ye=r(no,"P",{"data-svelte-h":!0}),f(Ye)!=="svelte-y56vea"&&(Ye.innerHTML=mn),no.forEach(t),ft.forEach(t),St=i(e),q=r(e,"H2",{class:!0});var ro=p(q);Y=r(ro,"A",{id:!0,class:!0,href:!0});var Fn=p(Y);_t=r(Fn,"SPAN",{});var In=p(_t);_(Ie.$$.fragment,In),In.forEach(t),Fn.forEach(t),wo=i(ro),Ke=r(ro,"SPAN",{"data-svelte-h":!0}),f(Ke)!=="svelte-ir7dkb"&&(Ke.textContent=fn),ro.forEach(t),Ot=i(e),$=r(e,"DIV",{class:!0});var ie=p($);_(Ee.$$.fragment,ie),To=i(ie),et=r(ie,"P",{"data-svelte-h":!0}),f(et)!=="svelte-h3kncw"&&(et.innerHTML=pn),xo=i(ie),tt=r(ie,"P",{"data-svelte-h":!0}),f(tt)!=="svelte-10kqkkl"&&(tt.innerHTML=hn),Mo=i(ie),_(K.$$.fragment,ie),ie.forEach(t),At=i(e),L=r(e,"H2",{class:!0});var ao=p(L);ee=r(ao,"A",{id:!0,class:!0,href:!0});var En=p(ee);bt=r(En,"SPAN",{});var Pn=p(bt);_(Pe.$$.fragment,Pn),Pn.forEach(t),En.forEach(t),Co=i(ao),ot=r(ao,"SPAN",{"data-svelte-h":!0}),f(ot)!=="svelte-1fd01im"&&(ot.textContent=un),ao.forEach(t),Ht=i(e),M=r(e,"DIV",{class:!0});var E=p(M);_(Re.$$.fragment,E),jo=i(E),nt=r(E,"P",{"data-svelte-h":!0}),f(nt)!=="svelte-12u6mh6"&&(nt.textContent=gn),$o=i(E),rt=r(E,"P",{"data-svelte-h":!0}),f(rt)!=="svelte-hmtw9k"&&(rt.innerHTML=_n),ko=i(E),at=r(E,"P",{"data-svelte-h":!0}),f(at)!=="svelte-hswkmf"&&(at.innerHTML=bn),zo=i(E),z=r(E,"DIV",{class:!0});var le=p(z);_(Ne.$$.fragment,le),Uo=i(le),st=r(le,"P",{"data-svelte-h":!0}),f(st)!=="svelte-hrmds4"&&(st.innerHTML=vn),Fo=i(le),_(te.$$.fragment,le),Io=i(le),_(oe.$$.fragment,le),le.forEach(t),E.forEach(t),Vt=i(e),W=r(e,"H2",{class:!0});var so=p(W);ne=r(so,"A",{id:!0,class:!0,href:!0});var Rn=p(ne);vt=r(Rn,"SPAN",{});var Nn=p(vt);_(Ze.$$.fragment,Nn),Nn.forEach(t),Rn.forEach(t),Eo=i(so),it=r(so,"SPAN",{"data-svelte-h":!0}),f(it)!=="svelte-ztnzg4"&&(it.textContent=yn),so.forEach(t),Gt=i(e),C=r(e,"DIV",{class:!0});var P=p(C);_(Je.$$.fragment,P),Po=i(P),lt=r(P,"P",{"data-svelte-h":!0}),f(lt)!=="svelte-1bchwb"&&(lt.textContent=Dn),Ro=i(P),dt=r(P,"P",{"data-svelte-h":!0}),f(dt)!=="svelte-hmtw9k"&&(dt.innerHTML=wn),No=i(P),ct=r(P,"P",{"data-svelte-h":!0}),f(ct)!=="svelte-hswkmf"&&(ct.innerHTML=Tn),Zo=i(P),U=r(P,"DIV",{class:!0});var de=p(U);_(qe.$$.fragment,de),Jo=i(de),mt=r(de,"P",{"data-svelte-h":!0}),f(mt)!=="svelte-1wobmhe"&&(mt.innerHTML=xn),qo=i(de),_(re.$$.fragment,de),Lo=i(de),_(ae.$$.fragment,de),de.forEach(t),P.forEach(t),Bt=i(e),yt=r(e,"P",{}),p(yt).forEach(t),this.h()},h(){m(c,"name","hf:doc:metadata"),m(c,"content",JSON.stringify(Yn)),m(d,"id","deformable-detr"),m(d,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(d,"href","#deformable-detr"),m(w,"class","relative group"),m(S,"id","overview"),m(S,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(S,"href","#overview"),m(R,"class","relative group"),qn(O.src,Qo="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/deformable_detr_architecture.png")||m(O,"src",Qo),m(O,"alt","drawing"),m(O,"width","600"),m(A,"id","resources"),m(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(A,"href","#resources"),m(N,"class","relative group"),m(H,"id","transformers.DeformableDetrImageProcessor"),m(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(H,"href","#transformers.DeformableDetrImageProcessor"),m(Z,"class","relative group"),m(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(B,"id","transformers.DeformableDetrFeatureExtractor"),m(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(B,"href","#transformers.DeformableDetrFeatureExtractor"),m(J,"class","relative group"),m(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(Y,"id","transformers.DeformableDetrConfig"),m(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(Y,"href","#transformers.DeformableDetrConfig"),m(q,"class","relative group"),m($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(ee,"id","transformers.DeformableDetrModel"),m(ee,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(ee,"href","#transformers.DeformableDetrModel"),m(L,"class","relative group"),m(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(ne,"id","transformers.DeformableDetrForObjectDetection"),m(ne,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(ne,"href","#transformers.DeformableDetrForObjectDetection"),m(W,"class","relative group"),m(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){o(document.head,c),l(e,T,a),l(e,h,a),l(e,u,a),l(e,w,a),o(w,d),o(d,x),b(me,x,null),o(w,io),o(w,Se),l(e,Mt,a),l(e,R,a),o(R,S),o(S,pt),b(fe,pt,null),o(R,lo),o(R,Oe),l(e,Ct,a),l(e,pe,a),l(e,jt,a),l(e,he,a),l(e,$t,a),l(e,ue,a),l(e,kt,a),l(e,ge,a),l(e,zt,a),l(e,_e,a),l(e,Ut,a),l(e,O,a),l(e,Ft,a),l(e,be,a),l(e,It,a),l(e,ve,a),l(e,Et,a),l(e,N,a),o(N,A),o(A,ht),b(ye,ht,null),o(N,co),o(N,Ae),l(e,Pt,a),l(e,De,a),l(e,Rt,a),b(we,e,a),l(e,Nt,a),l(e,Te,a),l(e,Zt,a),l(e,xe,a),l(e,Jt,a),l(e,Z,a),o(Z,H),o(H,ut),b(Me,ut,null),o(Z,mo),o(Z,He),l(e,qt,a),l(e,j,a),b(Ce,j,null),o(j,fo),o(j,Ve),o(j,po),o(j,V),b(je,V,null),o(V,ho),o(V,Ge),o(j,uo),o(j,G),b($e,G,null),o(G,go),o(G,Be),l(e,Lt,a),l(e,J,a),o(J,B),o(B,gt),b(ke,gt,null),o(J,_o),o(J,Xe),l(e,Wt,a),l(e,F,a),b(ze,F,null),o(F,bo),o(F,X),b(Ue,X,null),o(X,vo),o(X,Qe),o(F,yo),o(F,Q),b(Fe,Q,null),o(Q,Do),o(Q,Ye),l(e,St,a),l(e,q,a),o(q,Y),o(Y,_t),b(Ie,_t,null),o(q,wo),o(q,Ke),l(e,Ot,a),l(e,$,a),b(Ee,$,null),o($,To),o($,et),o($,xo),o($,tt),o($,Mo),b(K,$,null),l(e,At,a),l(e,L,a),o(L,ee),o(ee,bt),b(Pe,bt,null),o(L,Co),o(L,ot),l(e,Ht,a),l(e,M,a),b(Re,M,null),o(M,jo),o(M,nt),o(M,$o),o(M,rt),o(M,ko),o(M,at),o(M,zo),o(M,z),b(Ne,z,null),o(z,Uo),o(z,st),o(z,Fo),b(te,z,null),o(z,Io),b(oe,z,null),l(e,Vt,a),l(e,W,a),o(W,ne),o(ne,vt),b(Ze,vt,null),o(W,Eo),o(W,it),l(e,Gt,a),l(e,C,a),b(Je,C,null),o(C,Po),o(C,lt),o(C,Ro),o(C,dt),o(C,No),o(C,ct),o(C,Zo),o(C,U),b(qe,U,null),o(U,Jo),o(U,mt),o(U,qo),b(re,U,null),o(U,Lo),b(ae,U,null),l(e,Bt,a),l(e,yt,a),Xt=!0},p(e,[a]){const Le={};a&2&&(Le.$$scope={dirty:a,ctx:e}),K.$set(Le);const Dt={};a&2&&(Dt.$$scope={dirty:a,ctx:e}),te.$set(Dt);const wt={};a&2&&(wt.$$scope={dirty:a,ctx:e}),oe.$set(wt);const We={};a&2&&(We.$$scope={dirty:a,ctx:e}),re.$set(We);const Tt={};a&2&&(Tt.$$scope={dirty:a,ctx:e}),ae.$set(Tt)},i(e){Xt||(v(me.$$.fragment,e),v(fe.$$.fragment,e),v(ye.$$.fragment,e),v(we.$$.fragment,e),v(Me.$$.fragment,e),v(Ce.$$.fragment,e),v(je.$$.fragment,e),v($e.$$.fragment,e),v(ke.$$.fragment,e),v(ze.$$.fragment,e),v(Ue.$$.fragment,e),v(Fe.$$.fragment,e),v(Ie.$$.fragment,e),v(Ee.$$.fragment,e),v(K.$$.fragment,e),v(Pe.$$.fragment,e),v(Re.$$.fragment,e),v(Ne.$$.fragment,e),v(te.$$.fragment,e),v(oe.$$.fragment,e),v(Ze.$$.fragment,e),v(Je.$$.fragment,e),v(qe.$$.fragment,e),v(re.$$.fragment,e),v(ae.$$.fragment,e),Xt=!0)},o(e){y(me.$$.fragment,e),y(fe.$$.fragment,e),y(ye.$$.fragment,e),y(we.$$.fragment,e),y(Me.$$.fragment,e),y(Ce.$$.fragment,e),y(je.$$.fragment,e),y($e.$$.fragment,e),y(ke.$$.fragment,e),y(ze.$$.fragment,e),y(Ue.$$.fragment,e),y(Fe.$$.fragment,e),y(Ie.$$.fragment,e),y(Ee.$$.fragment,e),y(K.$$.fragment,e),y(Pe.$$.fragment,e),y(Re.$$.fragment,e),y(Ne.$$.fragment,e),y(te.$$.fragment,e),y(oe.$$.fragment,e),y(Ze.$$.fragment,e),y(Je.$$.fragment,e),y(qe.$$.fragment,e),y(re.$$.fragment,e),y(ae.$$.fragment,e),Xt=!1},d(e){e&&(t(T),t(h),t(u),t(w),t(Mt),t(R),t(Ct),t(pe),t(jt),t(he),t($t),t(ue),t(kt),t(ge),t(zt),t(_e),t(Ut),t(O),t(Ft),t(be),t(It),t(ve),t(Et),t(N),t(Pt),t(De),t(Rt),t(Nt),t(Te),t(Zt),t(xe),t(Jt),t(Z),t(qt),t(j),t(Lt),t(J),t(Wt),t(F),t(St),t(q),t(Ot),t($),t(At),t(L),t(Ht),t(M),t(Vt),t(W),t(Gt),t(C),t(Bt),t(yt)),t(c),D(me),D(fe),D(ye),D(we,e),D(Me),D(Ce),D(je),D($e),D(ke),D(ze),D(Ue),D(Fe),D(Ie),D(Ee),D(K),D(Pe),D(Re),D(Ne),D(te),D(oe),D(Ze),D(Je),D(qe),D(re),D(ae)}}}const Yn={local:"deformable-detr",sections:[{local:"overview",title:"Overview"},{local:"resources",title:"Resources"},{local:"transformers.DeformableDetrImageProcessor",title:"DeformableDetrImageProcessor"},{local:"transformers.DeformableDetrFeatureExtractor",title:"DeformableDetrFeatureExtractor"},{local:"transformers.DeformableDetrConfig",title:"DeformableDetrConfig"},{local:"transformers.DeformableDetrModel",title:"DeformableDetrModel"},{local:"transformers.DeformableDetrForObjectDetection",title:"DeformableDetrForObjectDetection"}],title:"Deformable DETR"};function Kn(k){return Ln(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class lr extends Wn{constructor(c){super(),Sn(this,c,Kn,Qn,Jn,{})}}export{lr as component};
