import{s as Kr,o as es,n as x}from"../chunks/scheduler.9bc65507.js";import{S as ts,i as os,g as s,s as i,u,A as ns,h as a,f as t,c as l,j as g,v as _,y as h,k as p,o as n,a as m,w as y,d as b,t as v,x as w}from"../chunks/index.78c82d43.js";import{T as _t}from"../chunks/Tip.87d55b76.js";import{D as I}from"../chunks/Docstring.4e7352e2.js";import{C as bt}from"../chunks/CodeBlock.73e038be.js";import{I as L}from"../chunks/IconCopyLink.bedaa44d.js";import{E as yt}from"../chunks/ExampleCodeBlock.872b014d.js";function rs($){let o,T="Example:",d,f,F;return f=new bt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEVmZmljaWVudEZvcm1lckNvbmZpZyUyQyUyMEVmZmljaWVudEZvcm1lck1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMEVmZmljaWVudEZvcm1lciUyMGVmZmljaWVudGZvcm1lci1sMSUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBFZmZpY2llbnRGb3JtZXJDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBFZmZpY2llbnRGb3JtZXJNb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwZWZmaWNpZW50Zm9ybWVyLWwzJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBFZmZpY2llbnRGb3JtZXJNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> EfficientFormerConfig, EfficientFormerModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a EfficientFormer efficientformer-l1 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = EfficientFormerConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a EfficientFormerModel (with random weights) from the efficientformer-l3 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = EfficientFormerModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){o=s("p"),o.textContent=T,d=i(),u(f.$$.fragment)},l(r){o=a(r,"P",{"data-svelte-h":!0}),h(o)!=="svelte-11lpom8"&&(o.textContent=T),d=l(r),_(f.$$.fragment,r)},m(r,M){m(r,o,M),m(r,d,M),y(f,r,M),F=!0},p:x,i(r){F||(b(f.$$.fragment,r),F=!0)},o(r){v(f.$$.fragment,r),F=!1},d(r){r&&(t(o),t(d)),w(f,r)}}}function ss($){let o,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=s("p"),o.innerHTML=T},l(d){o=a(d,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fincs2"&&(o.innerHTML=T)},m(d,f){m(d,o,f)},p:x,d(d){d&&t(o)}}}function as($){let o,T="Example:",d,f,F;return f=new bt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEVmZmljaWVudEZvcm1lck1vZGVsJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmh1Z2dpbmdmYWNlJTJGY2F0cy1pbWFnZSUyMiklMEFpbWFnZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCJTIyaW1hZ2UlMjIlNUQlNUIwJTVEJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJzbmFwLXJlc2VhcmNoJTJGZWZmaWNpZW50Zm9ybWVyLWwxLTMwMCUyMiklMEFtb2RlbCUyMCUzRCUyMEVmZmljaWVudEZvcm1lck1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJzbmFwLXJlc2VhcmNoJTJGZWZmaWNpZW50Zm9ybWVyLWwxLTMwMCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQWxpc3QobGFzdF9oaWRkZW5fc3RhdGVzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, EfficientFormerModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;snap-research/efficientformer-l1-300&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = EfficientFormerModel.from_pretrained(<span class="hljs-string">&quot;snap-research/efficientformer-l1-300&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">49</span>, <span class="hljs-number">448</span>]`,wrap:!1}}),{c(){o=s("p"),o.textContent=T,d=i(),u(f.$$.fragment)},l(r){o=a(r,"P",{"data-svelte-h":!0}),h(o)!=="svelte-11lpom8"&&(o.textContent=T),d=l(r),_(f.$$.fragment,r)},m(r,M){m(r,o,M),m(r,d,M),y(f,r,M),F=!0},p:x,i(r){F||(b(f.$$.fragment,r),F=!0)},o(r){v(f.$$.fragment,r),F=!1},d(r){r&&(t(o),t(d)),w(f,r)}}}function is($){let o,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=s("p"),o.innerHTML=T},l(d){o=a(d,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fincs2"&&(o.innerHTML=T)},m(d,f){m(d,o,f)},p:x,d(d){d&&t(o)}}}function ls($){let o,T="Example:",d,f,F;return f=new bt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEVmZmljaWVudEZvcm1lckZvckltYWdlQ2xhc3NpZmljYXRpb24lMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaHVnZ2luZ2ZhY2UlMkZjYXRzLWltYWdlJTIyKSUwQWltYWdlJTIwJTNEJTIwZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlNUIlMjJpbWFnZSUyMiU1RCU1QjAlNUQlMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMnNuYXAtcmVzZWFyY2glMkZlZmZpY2llbnRmb3JtZXItbDEtMzAwJTIyKSUwQW1vZGVsJTIwJTNEJTIwRWZmaWNpZW50Rm9ybWVyRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyc25hcC1yZXNlYXJjaCUyRmVmZmljaWVudGZvcm1lci1sMS0zMDAlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQSUyMyUyMG1vZGVsJTIwcHJlZGljdHMlMjBvbmUlMjBvZiUyMHRoZSUyMDEwMDAlMjBJbWFnZU5ldCUyMGNsYXNzZXMlMEFwcmVkaWN0ZWRfbGFiZWwlMjAlM0QlMjBsb2dpdHMuYXJnbWF4KC0xKS5pdGVtKCklMEFwcmludChtb2RlbC5jb25maWcuaWQybGFiZWwlNUJwcmVkaWN0ZWRfbGFiZWwlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, EfficientFormerForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;snap-research/efficientformer-l1-300&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = EfficientFormerForImageClassification.from_pretrained(<span class="hljs-string">&quot;snap-research/efficientformer-l1-300&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
Egyptian cat`,wrap:!1}}),{c(){o=s("p"),o.textContent=T,d=i(),u(f.$$.fragment)},l(r){o=a(r,"P",{"data-svelte-h":!0}),h(o)!=="svelte-11lpom8"&&(o.textContent=T),d=l(r),_(f.$$.fragment,r)},m(r,M){m(r,o,M),m(r,d,M),y(f,r,M),F=!0},p:x,i(r){F||(b(f.$$.fragment,r),F=!0)},o(r){v(f.$$.fragment,r),F=!1},d(r){r&&(t(o),t(d)),w(f,r)}}}function cs($){let o,T=`This model supports inference-only. Fine-tuning with distillation (i.e. with a teacher) is not yet
supported.`;return{c(){o=s("p"),o.textContent=T},l(d){o=a(d,"P",{"data-svelte-h":!0}),h(o)!=="svelte-1gp6z48"&&(o.textContent=T)},m(d,f){m(d,o,f)},p:x,d(d){d&&t(o)}}}function ds($){let o,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=s("p"),o.innerHTML=T},l(d){o=a(d,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fincs2"&&(o.innerHTML=T)},m(d,f){m(d,o,f)},p:x,d(d){d&&t(o)}}}function fs($){let o,T="Example:",d,f,F;return f=new bt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEVmZmljaWVudEZvcm1lckZvckltYWdlQ2xhc3NpZmljYXRpb25XaXRoVGVhY2hlciUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyc25hcC1yZXNlYXJjaCUyRmVmZmljaWVudGZvcm1lci1sMS0zMDAlMjIpJTBBbW9kZWwlMjAlM0QlMjBFZmZpY2llbnRGb3JtZXJGb3JJbWFnZUNsYXNzaWZpY2F0aW9uV2l0aFRlYWNoZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnNuYXAtcmVzZWFyY2glMkZlZmZpY2llbnRmb3JtZXItbDEtMzAwJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEElMjMlMjBtb2RlbCUyMHByZWRpY3RzJTIwb25lJTIwb2YlMjB0aGUlMjAxMDAwJTIwSW1hZ2VOZXQlMjBjbGFzc2VzJTBBcHJlZGljdGVkX2xhYmVsJTIwJTNEJTIwbG9naXRzLmFyZ21heCgtMSkuaXRlbSgpJTBBcHJpbnQobW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2xhYmVsJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, EfficientFormerForImageClassificationWithTeacher
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;snap-research/efficientformer-l1-300&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = EfficientFormerForImageClassificationWithTeacher.from_pretrained(<span class="hljs-string">&quot;snap-research/efficientformer-l1-300&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
Egyptian cat`,wrap:!1}}),{c(){o=s("p"),o.textContent=T,d=i(),u(f.$$.fragment)},l(r){o=a(r,"P",{"data-svelte-h":!0}),h(o)!=="svelte-11lpom8"&&(o.textContent=T),d=l(r),_(f.$$.fragment,r)},m(r,M){m(r,o,M),m(r,d,M),y(f,r,M),F=!0},p:x,i(r){F||(b(f.$$.fragment,r),F=!0)},o(r){v(f.$$.fragment,r),F=!1},d(r){r&&(t(o),t(d)),w(f,r)}}}function ms($){let o,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=s("p"),o.innerHTML=T},l(d){o=a(d,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fincs2"&&(o.innerHTML=T)},m(d,f){m(d,o,f)},p:x,d(d){d&&t(o)}}}function ps($){let o,T="Example:",d,f,F;return f=new bt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFRGRWZmaWNpZW50Rm9ybWVyTW9kZWwlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmh1Z2dpbmdmYWNlJTJGY2F0cy1pbWFnZSUyMiklMEFpbWFnZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCJTIyaW1hZ2UlMjIlNUQlNUIwJTVEJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJzbmFwLXJlc2VhcmNoJTJGZWZmaWNpZW50Zm9ybWVyLWwxLTMwMCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGRWZmaWNpZW50Rm9ybWVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnNuYXAtcmVzZWFyY2glMkZlZmZpY2llbnRmb3JtZXItbDEtMzAwJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFsaXN0KGxhc3RfaGlkZGVuX3N0YXRlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TFEfficientFormerModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;snap-research/efficientformer-l1-300&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFEfficientFormerModel.from_pretrained(<span class="hljs-string">&quot;snap-research/efficientformer-l1-300&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">49</span>, <span class="hljs-number">448</span>]`,wrap:!1}}),{c(){o=s("p"),o.textContent=T,d=i(),u(f.$$.fragment)},l(r){o=a(r,"P",{"data-svelte-h":!0}),h(o)!=="svelte-11lpom8"&&(o.textContent=T),d=l(r),_(f.$$.fragment,r)},m(r,M){m(r,o,M),m(r,d,M),y(f,r,M),F=!0},p:x,i(r){F||(b(f.$$.fragment,r),F=!0)},o(r){v(f.$$.fragment,r),F=!1},d(r){r&&(t(o),t(d)),w(f,r)}}}function hs($){let o,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=s("p"),o.innerHTML=T},l(d){o=a(d,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fincs2"&&(o.innerHTML=T)},m(d,f){m(d,o,f)},p:x,d(d){d&&t(o)}}}function gs($){let o,T="Example:",d,f,F;return f=new bt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFRGRWZmaWNpZW50Rm9ybWVyRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRlbnNvcmZsb3clMjBhcyUyMHRmJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyc25hcC1yZXNlYXJjaCUyRmVmZmljaWVudGZvcm1lci1sMS0zMDAlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkVmZmljaWVudEZvcm1lckZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNuYXAtcmVzZWFyY2glMkZlZmZpY2llbnRmb3JtZXItbDEtMzAwJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQSUyMyUyMG1vZGVsJTIwcHJlZGljdHMlMjBvbmUlMjBvZiUyMHRoZSUyMDEwMDAlMjBJbWFnZU5ldCUyMGNsYXNzZXMlMEFwcmVkaWN0ZWRfbGFiZWwlMjAlM0QlMjBpbnQodGYubWF0aC5hcmdtYXgobG9naXRzJTJDJTIwYXhpcyUzRC0xKSklMEFwcmludChtb2RlbC5jb25maWcuaWQybGFiZWwlNUJwcmVkaWN0ZWRfbGFiZWwlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TFEfficientFormerForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;snap-research/efficientformer-l1-300&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFEfficientFormerForImageClassification.from_pretrained(<span class="hljs-string">&quot;snap-research/efficientformer-l1-300&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = <span class="hljs-built_in">int</span>(tf.math.argmax(logits, axis=-<span class="hljs-number">1</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
LABEL_281`,wrap:!1}}),{c(){o=s("p"),o.textContent=T,d=i(),u(f.$$.fragment)},l(r){o=a(r,"P",{"data-svelte-h":!0}),h(o)!=="svelte-11lpom8"&&(o.textContent=T),d=l(r),_(f.$$.fragment,r)},m(r,M){m(r,o,M),m(r,d,M),y(f,r,M),F=!0},p:x,i(r){F||(b(f.$$.fragment,r),F=!0)},o(r){v(f.$$.fragment,r),F=!1},d(r){r&&(t(o),t(d)),w(f,r)}}}function us($){let o,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=s("p"),o.innerHTML=T},l(d){o=a(d,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fincs2"&&(o.innerHTML=T)},m(d,f){m(d,o,f)},p:x,d(d){d&&t(o)}}}function _s($){let o,T="Example:",d,f,F;return f=new bt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFRGRWZmaWNpZW50Rm9ybWVyRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbldpdGhUZWFjaGVyJTBBaW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmh1Z2dpbmdmYWNlJTJGY2F0cy1pbWFnZSUyMiklMEFpbWFnZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCJTIyaW1hZ2UlMjIlNUQlNUIwJTVEJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJzbmFwLXJlc2VhcmNoJTJGZWZmaWNpZW50Zm9ybWVyLWwxLTMwMCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGRWZmaWNpZW50Rm9ybWVyRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbldpdGhUZWFjaGVyLmZyb21fcHJldHJhaW5lZCglMjJzbmFwLXJlc2VhcmNoJTJGZWZmaWNpZW50Zm9ybWVyLWwxLTMwMCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQWxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEElMjMlMjBtb2RlbCUyMHByZWRpY3RzJTIwb25lJTIwb2YlMjB0aGUlMjAxMDAwJTIwSW1hZ2VOZXQlMjBjbGFzc2VzJTBBcHJlZGljdGVkX2xhYmVsJTIwJTNEJTIwaW50KHRmLm1hdGguYXJnbWF4KGxvZ2l0cyUyQyUyMGF4aXMlM0QtMSkpJTBBcHJpbnQobW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2xhYmVsJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TFEfficientFormerForImageClassificationWithTeacher
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;snap-research/efficientformer-l1-300&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFEfficientFormerForImageClassificationWithTeacher.from_pretrained(<span class="hljs-string">&quot;snap-research/efficientformer-l1-300&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = <span class="hljs-built_in">int</span>(tf.math.argmax(logits, axis=-<span class="hljs-number">1</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
LABEL_281`,wrap:!1}}),{c(){o=s("p"),o.textContent=T,d=i(),u(f.$$.fragment)},l(r){o=a(r,"P",{"data-svelte-h":!0}),h(o)!=="svelte-11lpom8"&&(o.textContent=T),d=l(r),_(f.$$.fragment,r)},m(r,M){m(r,o,M),m(r,d,M),y(f,r,M),F=!0},p:x,i(r){F||(b(f.$$.fragment,r),F=!0)},o(r){v(f.$$.fragment,r),F=!1},d(r){r&&(t(o),t(d)),w(f,r)}}}function ys($){let o,T,d,f,F,r,M,ze,en,vt,tr="EfficientFormer",To,X,ne,oo,ke,tn,wt,or="Overview",Fo,Ne,nr=`The EfficientFormer model was proposed in <a href="https://arxiv.org/abs/2206.01191" rel="nofollow">EfficientFormer: Vision Transformers at MobileNet Speed</a>
by Yanyu Li, Geng Yuan, Yang Wen, Eric Hu, Georgios Evangelidis, Sergey Tulyakov, Yanzhi Wang, Jian Ren.  EfficientFormer proposes a
dimension-consistent pure transformer that can be run on mobile devices for dense prediction tasks like image classification, object
detection and semantic segmentation.`,Mo,Ve,rr="The abstract from the paper is the following:",$o,Re,sr=`<em>Vision Transformers (ViT) have shown rapid progress in computer vision tasks, achieving promising results on various benchmarks.
However, due to the massive number of parameters and model design, e.g., attention mechanism, ViT-based models are generally
times slower than lightweight convolutional networks. Therefore, the deployment of ViT for real-time applications is particularly
challenging, especially on resource-constrained hardware such as mobile devices. Recent efforts try to reduce the computation
complexity of ViT through network architecture search or hybrid design with MobileNet block, yet the inference speed is still
unsatisfactory. This leads to an important question: can transformers run as fast as MobileNet while obtaining high performance?
To answer this, we first revisit the network architecture and operators used in ViT-based models and identify inefficient designs.
Then we introduce a dimension-consistent pure transformer (without MobileNet blocks) as a design paradigm.
Finally, we perform latency-driven slimming to get a series of final models dubbed EfficientFormer.
Extensive experiments show the superiority of EfficientFormer in performance and speed on mobile devices.
Our fastest model, EfficientFormer-L1, achieves 79.2% top-1 accuracy on ImageNet-1K with only 1.6 ms inference latency on
iPhone 12 (compiled with CoreML), which { runs as fast as MobileNetV2×1.4 (1.6 ms, 74.7% top-1),} and our largest model,
EfficientFormer-L7, obtains 83.3% accuracy with only 7.0 ms latency. Our work proves that properly designed transformers can
reach extremely low latency on mobile devices while maintaining high performance.</em>`,Co,Pe,ar=`This model was contributed by <a href="https://huggingface.co/novice03" rel="nofollow">novice03</a> and <a href="https://huggingface.co/Bearnardd" rel="nofollow">Bearnardd</a>.
The original code can be found <a href="https://github.com/snap-research/EfficientFormer" rel="nofollow">here</a>. The TensorFlow version of this model was added by <a href="https://huggingface.co/D-Roberts" rel="nofollow">D-Roberts</a>.`,Eo,Y,re,no,Ge,on,Tt,ir="Documentation resources",Io,Be,lr='<li><a href="../tasks/image_classification">Image classification task guide</a></li>',Wo,A,se,ro,Le,nn,Ft,cr="EfficientFormerConfig",xo,j,Se,rn,Mt,dr=`This is the configuration class to store the configuration of an <a href="/docs/transformers/v4.34.0/en/model_doc/efficientformer#transformers.EfficientFormerModel">EfficientFormerModel</a>. It is used to
instantiate an EfficientFormer model according to the specified arguments, defining the model architecture.
Instantiating a configuration with the defaults will yield a similar configuration to that of the EfficientFormer
<a href="https://huggingface.co/snap-research/efficientformer-l1" rel="nofollow">snap-research/efficientformer-l1</a> architecture.`,sn,$t,fr=`Configuration objects inherit from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,an,ae,jo,Q,ie,so,qe,ln,Ct,mr="EfficientFormerImageProcessor",Zo,R,He,cn,Et,pr="Constructs a EfficientFormer image processor.",dn,le,Xe,fn,It,hr="Preprocess an image or batch of images.",Jo,D,ce,ao,Ye,mn,Wt,gr="EfficientFormerModel",Uo,P,Ae,pn,xt,ur=`The bare EfficientFormer Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#nn.Module" rel="nofollow">nn.Module</a> subclass. Use it as a
regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and behavior.`,hn,U,Qe,gn,jt,_r='The <a href="/docs/transformers/v4.34.0/en/model_doc/efficientformer#transformers.EfficientFormerModel">EfficientFormerModel</a> forward method, overrides the <code>__call__</code> special method.',un,de,_n,fe,zo,O,me,io,De,yn,Zt,yr="EfficientFormerForImageClassification",ko,Z,Oe,bn,Jt,br=`EfficientFormer Model transformer with an image classification head on top (a linear layer on top of the final
hidden state of the [CLS] token) e.g. for ImageNet.`,vn,Ut,vr=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#nn.Module" rel="nofollow">nn.Module</a> subclass. Use it as a
regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and behavior.`,wn,z,Ke,Tn,zt,wr='The <a href="/docs/transformers/v4.34.0/en/model_doc/efficientformer#transformers.EfficientFormerForImageClassification">EfficientFormerForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',Fn,pe,Mn,he,No,K,ge,lo,et,$n,kt,Tr="EfficientFormerForImageClassificationWithTeacher",Vo,C,tt,Cn,Nt,Fr=`EfficientFormer Model transformer with image classification heads on top (a linear layer on top of the final hidden
state of the [CLS] token and a linear layer on top of the final hidden state of the distillation token) e.g. for
ImageNet.`,En,ue,In,Vt,Mr=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#nn.Module" rel="nofollow">nn.Module</a> subclass. Use it as a
regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and behavior.`,Wn,k,ot,xn,Rt,$r='The <a href="/docs/transformers/v4.34.0/en/model_doc/efficientformer#transformers.EfficientFormerForImageClassificationWithTeacher">EfficientFormerForImageClassificationWithTeacher</a> forward method, overrides the <code>__call__</code> special method.',jn,_e,Zn,ye,Ro,ee,be,co,nt,Jn,Pt,Cr="TFEfficientFormerModel",Po,G,rt,Un,Gt,Er=`The bare EfficientFormer Model transformer outputting raw hidden-states without any specific head on top.
This model is a TensorFlow
<a href="https://www.tensorflow.org/api_docs/python/tf/keras/layers/Layer" rel="nofollow">tf.keras.layers.Layer</a>. Use it as a regular
TensorFlow Module and refer to the TensorFlow documentation for all matter related to general usage and behavior.`,zn,N,st,kn,Bt,Ir='The <a href="/docs/transformers/v4.34.0/en/model_doc/efficientformer#transformers.TFEfficientFormerModel">TFEfficientFormerModel</a> forward method, overrides the <code>__call__</code> special method.',Nn,ve,Vn,we,Go,te,Te,fo,at,Rn,Lt,Wr="TFEfficientFormerForImageClassification",Bo,J,it,Pn,St,xr=`EfficientFormer Model transformer with an image classification head on top of pooled last hidden state, e.g. for
ImageNet.`,Gn,qt,jr=`This model is a TensorFlow
<a href="https://www.tensorflow.org/api_docs/python/tf/keras/layers/Layer" rel="nofollow">tf.keras.layers.Layer</a>. Use it as a regular
TensorFlow Module and refer to the TensorFlow documentation for all matter related to general usage and behavior.`,Bn,V,lt,Ln,Ht,Zr='The <a href="/docs/transformers/v4.34.0/en/model_doc/efficientformer#transformers.TFEfficientFormerForImageClassification">TFEfficientFormerForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',Sn,Fe,qn,Me,Lo,oe,$e,mo,ct,Hn,Xt,Jr="TFEfficientFormerForImageClassificationWithTeacher",So,E,dt,Xn,Yt,Ur=`EfficientFormer Model transformer with image classification heads on top (a linear layer on top of the final hidden
state and a linear layer on top of the final hidden state of the distillation token) e.g. for ImageNet.`,Yn,At,zr=`.. warning::
This model supports inference-only. Fine-tuning with distillation (i.e. with a teacher) is not yet
supported.`,An,Qt,kr=`This model is a TensorFlow
<a href="https://www.tensorflow.org/api_docs/python/tf/keras/layers/Layer" rel="nofollow">tf.keras.layers.Layer</a>. Use it as a regular
TensorFlow Module and refer to the TensorFlow documentation for all matter related to general usage and behavior.`,Qn,W,ft,Dn,Dt,Nr='The <a href="/docs/transformers/v4.34.0/en/model_doc/efficientformer#transformers.TFEfficientFormerForImageClassificationWithTeacher">TFEfficientFormerForImageClassificationWithTeacher</a> forward method, overrides the <code>__call__</code> special method.',On,Ce,Kn,Ot,Vr=`<li><strong>Output</strong> type of <a href="/docs/transformers/v4.34.0/en/model_doc/efficientformer#transformers.EfficientFormerForImageClassificationWithTeacher">EfficientFormerForImageClassificationWithTeacher</a>.
logits (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Prediction scores as the average of the cls_logits and distillation logits.
cls_logits (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Prediction scores of the classification head (i.e. the linear layer on top of the final hidden state of the
class token).
distillation_logits (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Prediction scores of the distillation head (i.e. the linear layer on top of the final hidden state of the
distillation token).
hidden_states (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when
<code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer plus
the initial embedding outputs.
attentions (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when
<code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>`,er,Ee,qo,po,Ho;return ze=new L({}),ke=new L({}),Ge=new L({}),Le=new L({}),Se=new I({props:{name:"class transformers.EfficientFormerConfig",anchor:"transformers.EfficientFormerConfig",parameters:[{name:"depths",val:": typing.List[int] = [3, 2, 6, 4]"},{name:"hidden_sizes",val:": typing.List[int] = [48, 96, 224, 448]"},{name:"downsamples",val:": typing.List[bool] = [True, True, True, True]"},{name:"dim",val:": int = 448"},{name:"key_dim",val:": int = 32"},{name:"attention_ratio",val:": int = 4"},{name:"resolution",val:": int = 7"},{name:"num_hidden_layers",val:": int = 5"},{name:"num_attention_heads",val:": int = 8"},{name:"mlp_expansion_ratio",val:": int = 4"},{name:"hidden_dropout_prob",val:": float = 0.0"},{name:"patch_size",val:": int = 16"},{name:"num_channels",val:": int = 3"},{name:"pool_size",val:": int = 3"},{name:"downsample_patch_size",val:": int = 3"},{name:"downsample_stride",val:": int = 2"},{name:"downsample_pad",val:": int = 1"},{name:"drop_path_rate",val:": float = 0.0"},{name:"num_meta3d_blocks",val:": int = 1"},{name:"distillation",val:": bool = True"},{name:"use_layer_scale",val:": bool = True"},{name:"layer_scale_init_value",val:": float = 1e-05"},{name:"hidden_act",val:": str = 'gelu'"},{name:"initializer_range",val:": float = 0.02"},{name:"layer_norm_eps",val:": float = 1e-12"},{name:"image_size",val:": int = 224"},{name:"batch_norm_eps",val:": float = 1e-05"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.EfficientFormerConfig.depths",description:`<strong>depths</strong> (<code>List(int)</code>, <em>optional</em>, defaults to <code>[3, 2, 6, 4]</code>) &#x2014;
Depth of each stage.`,name:"depths"},{anchor:"transformers.EfficientFormerConfig.hidden_sizes",description:`<strong>hidden_sizes</strong> (<code>List(int)</code>, <em>optional</em>, defaults to <code>[48, 96, 224, 448]</code>) &#x2014;
Dimensionality of each stage.`,name:"hidden_sizes"},{anchor:"transformers.EfficientFormerConfig.downsamples",description:`<strong>downsamples</strong> (<code>List(bool)</code>, <em>optional</em>, defaults to <code>[True, True, True, True]</code>) &#x2014;
Whether or not to downsample inputs between two stages.`,name:"downsamples"},{anchor:"transformers.EfficientFormerConfig.dim",description:`<strong>dim</strong> (<code>int</code>, <em>optional</em>, defaults to 448) &#x2014;
Number of channels in Meta3D layers`,name:"dim"},{anchor:"transformers.EfficientFormerConfig.key_dim",description:`<strong>key_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The size of the key in meta3D block.`,name:"key_dim"},{anchor:"transformers.EfficientFormerConfig.attention_ratio",description:`<strong>attention_ratio</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Ratio of the dimension of the query and value to the dimension of the key in MSHA block`,name:"attention_ratio"},{anchor:"transformers.EfficientFormerConfig.resolution",description:`<strong>resolution</strong> (<code>int</code>, <em>optional</em>, defaults to 7) &#x2014;
Size of each patch`,name:"resolution"},{anchor:"transformers.EfficientFormerConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 5) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.EfficientFormerConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the 3D MetaBlock.`,name:"num_attention_heads"},{anchor:"transformers.EfficientFormerConfig.mlp_expansion_ratio",description:`<strong>mlp_expansion_ratio</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Ratio of size of the hidden dimensionality of an MLP to the dimensionality of its input.`,name:"mlp_expansion_ratio"},{anchor:"transformers.EfficientFormerConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings and encoder.`,name:"hidden_dropout_prob"},{anchor:"transformers.EfficientFormerConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.EfficientFormerConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.EfficientFormerConfig.pool_size",description:`<strong>pool_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Kernel size of pooling layers.`,name:"pool_size"},{anchor:"transformers.EfficientFormerConfig.downsample_patch_size",description:`<strong>downsample_patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The size of patches in downsampling layers.`,name:"downsample_patch_size"},{anchor:"transformers.EfficientFormerConfig.downsample_stride",description:`<strong>downsample_stride</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The stride of convolution kernels in downsampling layers.`,name:"downsample_stride"},{anchor:"transformers.EfficientFormerConfig.downsample_pad",description:`<strong>downsample_pad</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Padding in downsampling layers.`,name:"downsample_pad"},{anchor:"transformers.EfficientFormerConfig.drop_path_rate",description:`<strong>drop_path_rate</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Rate at which to increase dropout probability in DropPath.`,name:"drop_path_rate"},{anchor:"transformers.EfficientFormerConfig.num_meta3d_blocks",description:`<strong>num_meta3d_blocks</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of 3D MetaBlocks in the last stage.`,name:"num_meta3d_blocks"},{anchor:"transformers.EfficientFormerConfig.distillation",description:`<strong>distillation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a distillation head.`,name:"distillation"},{anchor:"transformers.EfficientFormerConfig.use_layer_scale",description:`<strong>use_layer_scale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to scale outputs from token mixers.`,name:"use_layer_scale"},{anchor:"transformers.EfficientFormerConfig.layer_scale_init_value",description:`<strong>layer_scale_init_value</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-5) &#x2014;
Factor by which outputs from token mixers are scaled.`,name:"layer_scale_init_value"},{anchor:"transformers.EfficientFormerConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.EfficientFormerConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.EfficientFormerConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.EfficientFormerConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>224</code>) &#x2014;
The size (resolution) of each image.`,name:"image_size"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/efficientformer/configuration_efficientformer.py#L32"}}),ae=new yt({props:{anchor:"transformers.EfficientFormerConfig.example",$$slots:{default:[rs]},$$scope:{ctx:$}}}),qe=new L({}),He=new I({props:{name:"class transformers.EfficientFormerImageProcessor",anchor:"transformers.EfficientFormerImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Union[typing.Dict[str, int], NoneType] = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_center_crop",val:": bool = True"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.EfficientFormerImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>(size[&quot;height&quot;], size[&quot;width&quot;])</code>. Can be overridden by the <code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.EfficientFormerImageProcessor.size",description:`<strong>size</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 224, &quot;width&quot;: 224}</code>):
Size of the output image after resizing. Can be overridden by the <code>size</code> parameter in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.EfficientFormerImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by the <code>resample</code> parameter in the
<code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.EfficientFormerImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by <code>do_center_crop</code> in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.EfficientFormerImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to 224) &#x2014;
Size of the output image after applying <code>center_crop</code>. Can be overridden by <code>crop_size</code> in the <code>preprocess</code>
method.`,name:"crop_size"},{anchor:"transformers.EfficientFormerImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.EfficientFormerImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.
do_normalize &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.EfficientFormerImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.EfficientFormerImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/efficientformer/image_processing_efficientformer.py#L45"}}),Xe=new I({props:{name:"preprocess",anchor:"transformers.EfficientFormerImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": bool = None"},{name:"crop_size",val:": int = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.EfficientFormerImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.EfficientFormerImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.EfficientFormerImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Dictionary in the format <code>{&quot;height&quot;: h, &quot;width&quot;: w}</code> specifying the size of the output image after
resizing.`,name:"size"},{anchor:"transformers.EfficientFormerImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code> filter, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
<code>PILImageResampling</code> filter to use if resizing the image e.g. <code>PILImageResampling.BILINEAR</code>. Only has
an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.EfficientFormerImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.EfficientFormerImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.EfficientFormerImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.EfficientFormerImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the center crop. Only has an effect if <code>do_center_crop</code> is set to <code>True</code>.`,name:"crop_size"},{anchor:"transformers.EfficientFormerImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.EfficientFormerImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.EfficientFormerImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_std"},{anchor:"transformers.EfficientFormerImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.EfficientFormerImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.EfficientFormerImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/efficientformer/image_processing_efficientformer.py#L160"}}),Ye=new L({}),Ae=new I({props:{name:"class transformers.EfficientFormerModel",anchor:"transformers.EfficientFormerModel",parameters:[{name:"config",val:": EfficientFormerConfig"}],parametersDescription:[{anchor:"transformers.EfficientFormerModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/efficientformer#transformers.EfficientFormerConfig">EfficientFormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/efficientformer/modeling_efficientformer.py#L557"}}),Qe=new I({props:{name:"forward",anchor:"transformers.EfficientFormerModel.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.EfficientFormerModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a>. See
<a href="/docs/transformers/v4.34.0/en/model_doc/vit#transformers.ViTImageProcessor.preprocess">ViTImageProcessor.preprocess()</a> for details.`,name:"pixel_values"},{anchor:"transformers.EfficientFormerModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.EfficientFormerModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.EfficientFormerModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/efficientformer/modeling_efficientformer.py#L569",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/efficientformer#transformers.EfficientFormerConfig"
>EfficientFormerConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),de=new _t({props:{$$slots:{default:[ss]},$$scope:{ctx:$}}}),fe=new yt({props:{anchor:"transformers.EfficientFormerModel.forward.example",$$slots:{default:[as]},$$scope:{ctx:$}}}),De=new L({}),Oe=new I({props:{name:"class transformers.EfficientFormerForImageClassification",anchor:"transformers.EfficientFormerForImageClassification",parameters:[{name:"config",val:": EfficientFormerConfig"}],parametersDescription:[{anchor:"transformers.EfficientFormerForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/efficientformer#transformers.EfficientFormerConfig">EfficientFormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/efficientformer/modeling_efficientformer.py#L619"}}),Ke=new I({props:{name:"forward",anchor:"transformers.EfficientFormerForImageClassification.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.EfficientFormerForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a>. See
<a href="/docs/transformers/v4.34.0/en/model_doc/vit#transformers.ViTImageProcessor.preprocess">ViTImageProcessor.preprocess()</a> for details.`,name:"pixel_values"},{anchor:"transformers.EfficientFormerForImageClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.EfficientFormerForImageClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.EfficientFormerForImageClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.EfficientFormerForImageClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/efficientformer/modeling_efficientformer.py#L634",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/efficientformer#transformers.EfficientFormerConfig"
>EfficientFormerConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states
(also called feature maps) of the model at the output of each stage.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),pe=new _t({props:{$$slots:{default:[is]},$$scope:{ctx:$}}}),he=new yt({props:{anchor:"transformers.EfficientFormerForImageClassification.forward.example",$$slots:{default:[ls]},$$scope:{ctx:$}}}),et=new L({}),tt=new I({props:{name:"class transformers.EfficientFormerForImageClassificationWithTeacher",anchor:"transformers.EfficientFormerForImageClassificationWithTeacher",parameters:[{name:"config",val:": EfficientFormerConfig"}],parametersDescription:[{anchor:"transformers.EfficientFormerForImageClassificationWithTeacher.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/efficientformer#transformers.EfficientFormerConfig">EfficientFormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/efficientformer/modeling_efficientformer.py#L749"}}),ue=new _t({props:{warning:!0,$$slots:{default:[cs]},$$scope:{ctx:$}}}),ot=new I({props:{name:"forward",anchor:"transformers.EfficientFormerForImageClassificationWithTeacher.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.EfficientFormerForImageClassificationWithTeacher.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a>. See
<a href="/docs/transformers/v4.34.0/en/model_doc/vit#transformers.ViTImageProcessor.preprocess">ViTImageProcessor.preprocess()</a> for details.`,name:"pixel_values"},{anchor:"transformers.EfficientFormerForImageClassificationWithTeacher.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.EfficientFormerForImageClassificationWithTeacher.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.EfficientFormerForImageClassificationWithTeacher.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/efficientformer/modeling_efficientformer.py#L766",returnDescription:`
<p>A <code>transformers.models.efficientformer.modeling_efficientformer.EfficientFormerForImageClassificationWithTeacherOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/efficientformer#transformers.EfficientFormerConfig"
>EfficientFormerConfig</a>) and inputs.</p>
<ul>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Prediction scores as the average of the cls_logits and distillation logits.</li>
<li><strong>cls_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Prediction scores of the classification head (i.e. the linear layer on top of the final hidden state of the
class token).</li>
<li><strong>distillation_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Prediction scores of the distillation head (i.e. the linear layer on top of the final hidden state of the
distillation token).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
</ul>
`,returnType:`
<p><code>transformers.models.efficientformer.modeling_efficientformer.EfficientFormerForImageClassificationWithTeacherOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),_e=new _t({props:{$$slots:{default:[ds]},$$scope:{ctx:$}}}),ye=new yt({props:{anchor:"transformers.EfficientFormerForImageClassificationWithTeacher.forward.example",$$slots:{default:[fs]},$$scope:{ctx:$}}}),nt=new L({}),rt=new I({props:{name:"class transformers.TFEfficientFormerModel",anchor:"transformers.TFEfficientFormerModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFEfficientFormerModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/efficientformer#transformers.EfficientFormerConfig">EfficientFormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/efficientformer/modeling_tf_efficientformer.py#L775"}}),st=new I({props:{name:"call",anchor:"transformers.TFEfficientFormerModel.call",parameters:[{name:"pixel_values",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFEfficientFormerModel.call.pixel_values",description:`<strong>pixel_values</strong> ((<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__">EfficientFormerImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.TFEfficientFormerModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TFEfficientFormerModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFEfficientFormerModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/efficientformer/modeling_tf_efficientformer.py#L781",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling"
>transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/efficientformer#transformers.EfficientFormerConfig"
>EfficientFormerConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) further processed by a
Linear layer and a Tanh activation function. The Linear layer weights are trained from the next sentence
prediction (classification) objective during pretraining.</p>
<p>This output is usually <em>not</em> a good summary of the semantic content of the input, you’re often better with
averaging or pooling the sequence of hidden-states for the whole input sequence.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling"
>transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling</a> or <code>tuple(tf.Tensor)</code></p>
`}}),ve=new _t({props:{$$slots:{default:[ms]},$$scope:{ctx:$}}}),we=new yt({props:{anchor:"transformers.TFEfficientFormerModel.call.example",$$slots:{default:[ps]},$$scope:{ctx:$}}}),at=new L({}),it=new I({props:{name:"class transformers.TFEfficientFormerForImageClassification",anchor:"transformers.TFEfficientFormerForImageClassification",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFEfficientFormerForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/efficientformer#transformers.EfficientFormerConfig">EfficientFormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/efficientformer/modeling_tf_efficientformer.py#L815"}}),lt=new I({props:{name:"call",anchor:"transformers.TFEfficientFormerForImageClassification.call",parameters:[{name:"pixel_values",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"labels",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFEfficientFormerForImageClassification.call.pixel_values",description:`<strong>pixel_values</strong> ((<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__">EfficientFormerImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.TFEfficientFormerForImageClassification.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TFEfficientFormerForImageClassification.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFEfficientFormerForImageClassification.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TFEfficientFormerForImageClassification.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/efficientformer/modeling_tf_efficientformer.py#L829",returnDescription:`
<p>A <code>transformers.modeling_tf_outputs.TFImageClassifierOutput</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/efficientformer#transformers.EfficientFormerConfig"
>EfficientFormerConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings, if the model has an embedding layer, + one for
the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called
feature maps) of the model at the output of each stage.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><code>transformers.modeling_tf_outputs.TFImageClassifierOutput</code> or <code>tuple(tf.Tensor)</code></p>
`}}),Fe=new _t({props:{$$slots:{default:[hs]},$$scope:{ctx:$}}}),Me=new yt({props:{anchor:"transformers.TFEfficientFormerForImageClassification.call.example",$$slots:{default:[gs]},$$scope:{ctx:$}}}),ct=new L({}),dt=new I({props:{name:"class transformers.TFEfficientFormerForImageClassificationWithTeacher",anchor:"transformers.TFEfficientFormerForImageClassificationWithTeacher",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFEfficientFormerForImageClassificationWithTeacher.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/efficientformer#transformers.EfficientFormerConfig">EfficientFormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/efficientformer/modeling_tf_efficientformer.py#L920"}}),ft=new I({props:{name:"call",anchor:"transformers.TFEfficientFormerForImageClassificationWithTeacher.call",parameters:[{name:"pixel_values",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFEfficientFormerForImageClassificationWithTeacher.call.pixel_values",description:`<strong>pixel_values</strong> ((<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__">EfficientFormerImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.TFEfficientFormerForImageClassificationWithTeacher.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TFEfficientFormerForImageClassificationWithTeacher.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFEfficientFormerForImageClassificationWithTeacher.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/efficientformer/modeling_tf_efficientformer.py#L939",returnDescription:`
<p>A <code>transformers.models.efficientformer.modeling_tf_efficientformer.TFEfficientFormerForImageClassificationWithTeacherOutput</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/efficientformer#transformers.EfficientFormerConfig"
>EfficientFormerConfig</a>) and inputs.</p>
`,returnType:`
<p><code>transformers.models.efficientformer.modeling_tf_efficientformer.TFEfficientFormerForImageClassificationWithTeacherOutput</code> or <code>tuple(tf.Tensor)</code></p>
`}}),Ce=new _t({props:{$$slots:{default:[us]},$$scope:{ctx:$}}}),Ee=new yt({props:{anchor:"transformers.TFEfficientFormerForImageClassificationWithTeacher.call.example",$$slots:{default:[_s]},$$scope:{ctx:$}}}),{c(){o=s("meta"),T=i(),d=s("p"),f=i(),F=s("h1"),r=s("a"),M=s("span"),u(ze.$$.fragment),en=i(),vt=s("span"),vt.textContent=tr,To=i(),X=s("h2"),ne=s("a"),oo=s("span"),u(ke.$$.fragment),tn=i(),wt=s("span"),wt.textContent=or,Fo=i(),Ne=s("p"),Ne.innerHTML=nr,Mo=i(),Ve=s("p"),Ve.textContent=rr,$o=i(),Re=s("p"),Re.innerHTML=sr,Co=i(),Pe=s("p"),Pe.innerHTML=ar,Eo=i(),Y=s("h2"),re=s("a"),no=s("span"),u(Ge.$$.fragment),on=i(),Tt=s("span"),Tt.textContent=ir,Io=i(),Be=s("ul"),Be.innerHTML=lr,Wo=i(),A=s("h2"),se=s("a"),ro=s("span"),u(Le.$$.fragment),nn=i(),Ft=s("span"),Ft.textContent=cr,xo=i(),j=s("div"),u(Se.$$.fragment),rn=i(),Mt=s("p"),Mt.innerHTML=dr,sn=i(),$t=s("p"),$t.innerHTML=fr,an=i(),u(ae.$$.fragment),jo=i(),Q=s("h2"),ie=s("a"),so=s("span"),u(qe.$$.fragment),ln=i(),Ct=s("span"),Ct.textContent=mr,Zo=i(),R=s("div"),u(He.$$.fragment),cn=i(),Et=s("p"),Et.textContent=pr,dn=i(),le=s("div"),u(Xe.$$.fragment),fn=i(),It=s("p"),It.textContent=hr,Jo=i(),D=s("h2"),ce=s("a"),ao=s("span"),u(Ye.$$.fragment),mn=i(),Wt=s("span"),Wt.textContent=gr,Uo=i(),P=s("div"),u(Ae.$$.fragment),pn=i(),xt=s("p"),xt.innerHTML=ur,hn=i(),U=s("div"),u(Qe.$$.fragment),gn=i(),jt=s("p"),jt.innerHTML=_r,un=i(),u(de.$$.fragment),_n=i(),u(fe.$$.fragment),zo=i(),O=s("h2"),me=s("a"),io=s("span"),u(De.$$.fragment),yn=i(),Zt=s("span"),Zt.textContent=yr,ko=i(),Z=s("div"),u(Oe.$$.fragment),bn=i(),Jt=s("p"),Jt.textContent=br,vn=i(),Ut=s("p"),Ut.innerHTML=vr,wn=i(),z=s("div"),u(Ke.$$.fragment),Tn=i(),zt=s("p"),zt.innerHTML=wr,Fn=i(),u(pe.$$.fragment),Mn=i(),u(he.$$.fragment),No=i(),K=s("h2"),ge=s("a"),lo=s("span"),u(et.$$.fragment),$n=i(),kt=s("span"),kt.textContent=Tr,Vo=i(),C=s("div"),u(tt.$$.fragment),Cn=i(),Nt=s("p"),Nt.textContent=Fr,En=i(),u(ue.$$.fragment),In=i(),Vt=s("p"),Vt.innerHTML=Mr,Wn=i(),k=s("div"),u(ot.$$.fragment),xn=i(),Rt=s("p"),Rt.innerHTML=$r,jn=i(),u(_e.$$.fragment),Zn=i(),u(ye.$$.fragment),Ro=i(),ee=s("h2"),be=s("a"),co=s("span"),u(nt.$$.fragment),Jn=i(),Pt=s("span"),Pt.textContent=Cr,Po=i(),G=s("div"),u(rt.$$.fragment),Un=i(),Gt=s("p"),Gt.innerHTML=Er,zn=i(),N=s("div"),u(st.$$.fragment),kn=i(),Bt=s("p"),Bt.innerHTML=Ir,Nn=i(),u(ve.$$.fragment),Vn=i(),u(we.$$.fragment),Go=i(),te=s("h2"),Te=s("a"),fo=s("span"),u(at.$$.fragment),Rn=i(),Lt=s("span"),Lt.textContent=Wr,Bo=i(),J=s("div"),u(it.$$.fragment),Pn=i(),St=s("p"),St.textContent=xr,Gn=i(),qt=s("p"),qt.innerHTML=jr,Bn=i(),V=s("div"),u(lt.$$.fragment),Ln=i(),Ht=s("p"),Ht.innerHTML=Zr,Sn=i(),u(Fe.$$.fragment),qn=i(),u(Me.$$.fragment),Lo=i(),oe=s("h2"),$e=s("a"),mo=s("span"),u(ct.$$.fragment),Hn=i(),Xt=s("span"),Xt.textContent=Jr,So=i(),E=s("div"),u(dt.$$.fragment),Xn=i(),Yt=s("p"),Yt.textContent=Ur,Yn=i(),At=s("p"),At.textContent=zr,An=i(),Qt=s("p"),Qt.innerHTML=kr,Qn=i(),W=s("div"),u(ft.$$.fragment),Dn=i(),Dt=s("p"),Dt.innerHTML=Nr,On=i(),u(Ce.$$.fragment),Kn=i(),Ot=s("ul"),Ot.innerHTML=Vr,er=i(),u(Ee.$$.fragment),qo=i(),po=s("p"),this.h()},l(e){const c=ns("svelte-1phssyn",document.head);o=a(c,"META",{name:!0,content:!0}),c.forEach(t),T=l(e),d=a(e,"P",{}),g(d).forEach(t),f=l(e),F=a(e,"H1",{class:!0});var mt=g(F);r=a(mt,"A",{id:!0,class:!0,href:!0});var ho=g(r);M=a(ho,"SPAN",{});var go=g(M);_(ze.$$.fragment,go),go.forEach(t),ho.forEach(t),en=l(mt),vt=a(mt,"SPAN",{"data-svelte-h":!0}),h(vt)!=="svelte-z5teh5"&&(vt.textContent=tr),mt.forEach(t),To=l(e),X=a(e,"H2",{class:!0});var pt=g(X);ne=a(pt,"A",{id:!0,class:!0,href:!0});var uo=g(ne);oo=a(uo,"SPAN",{});var _o=g(oo);_(ke.$$.fragment,_o),_o.forEach(t),uo.forEach(t),tn=l(pt),wt=a(pt,"SPAN",{"data-svelte-h":!0}),h(wt)!=="svelte-1jsw1pg"&&(wt.textContent=or),pt.forEach(t),Fo=l(e),Ne=a(e,"P",{"data-svelte-h":!0}),h(Ne)!=="svelte-48qc0w"&&(Ne.innerHTML=nr),Mo=l(e),Ve=a(e,"P",{"data-svelte-h":!0}),h(Ve)!=="svelte-vfdo9a"&&(Ve.textContent=rr),$o=l(e),Re=a(e,"P",{"data-svelte-h":!0}),h(Re)!=="svelte-1w1hunj"&&(Re.innerHTML=sr),Co=l(e),Pe=a(e,"P",{"data-svelte-h":!0}),h(Pe)!=="svelte-e302oa"&&(Pe.innerHTML=ar),Eo=l(e),Y=a(e,"H2",{class:!0});var ht=g(Y);re=a(ht,"A",{id:!0,class:!0,href:!0});var yo=g(re);no=a(yo,"SPAN",{});var bo=g(no);_(Ge.$$.fragment,bo),bo.forEach(t),yo.forEach(t),on=l(ht),Tt=a(ht,"SPAN",{"data-svelte-h":!0}),h(Tt)!=="svelte-n3f0j0"&&(Tt.textContent=ir),ht.forEach(t),Io=l(e),Be=a(e,"UL",{"data-svelte-h":!0}),h(Be)!=="svelte-1f2rorg"&&(Be.innerHTML=lr),Wo=l(e),A=a(e,"H2",{class:!0});var gt=g(A);se=a(gt,"A",{id:!0,class:!0,href:!0});var vo=g(se);ro=a(vo,"SPAN",{});var wo=g(ro);_(Le.$$.fragment,wo),wo.forEach(t),vo.forEach(t),nn=l(gt),Ft=a(gt,"SPAN",{"data-svelte-h":!0}),h(Ft)!=="svelte-ec2y23"&&(Ft.textContent=cr),gt.forEach(t),xo=l(e),j=a(e,"DIV",{class:!0});var B=g(j);_(Se.$$.fragment,B),rn=l(B),Mt=a(B,"P",{"data-svelte-h":!0}),h(Mt)!=="svelte-14ybbv9"&&(Mt.innerHTML=dr),sn=l(B),$t=a(B,"P",{"data-svelte-h":!0}),h($t)!=="svelte-10kqkkl"&&($t.innerHTML=fr),an=l(B),_(ae.$$.fragment,B),B.forEach(t),jo=l(e),Q=a(e,"H2",{class:!0});var ut=g(Q);ie=a(ut,"A",{id:!0,class:!0,href:!0});var Rr=g(ie);so=a(Rr,"SPAN",{});var Pr=g(so);_(qe.$$.fragment,Pr),Pr.forEach(t),Rr.forEach(t),ln=l(ut),Ct=a(ut,"SPAN",{"data-svelte-h":!0}),h(Ct)!=="svelte-1vss6ji"&&(Ct.textContent=mr),ut.forEach(t),Zo=l(e),R=a(e,"DIV",{class:!0});var Kt=g(R);_(He.$$.fragment,Kt),cn=l(Kt),Et=a(Kt,"P",{"data-svelte-h":!0}),h(Et)!=="svelte-48xdfc"&&(Et.textContent=pr),dn=l(Kt),le=a(Kt,"DIV",{class:!0});var Xo=g(le);_(Xe.$$.fragment,Xo),fn=l(Xo),It=a(Xo,"P",{"data-svelte-h":!0}),h(It)!=="svelte-1x3yxsa"&&(It.textContent=hr),Xo.forEach(t),Kt.forEach(t),Jo=l(e),D=a(e,"H2",{class:!0});var Yo=g(D);ce=a(Yo,"A",{id:!0,class:!0,href:!0});var Gr=g(ce);ao=a(Gr,"SPAN",{});var Br=g(ao);_(Ye.$$.fragment,Br),Br.forEach(t),Gr.forEach(t),mn=l(Yo),Wt=a(Yo,"SPAN",{"data-svelte-h":!0}),h(Wt)!=="svelte-zmc67c"&&(Wt.textContent=gr),Yo.forEach(t),Uo=l(e),P=a(e,"DIV",{class:!0});var eo=g(P);_(Ae.$$.fragment,eo),pn=l(eo),xt=a(eo,"P",{"data-svelte-h":!0}),h(xt)!=="svelte-adm7u9"&&(xt.innerHTML=ur),hn=l(eo),U=a(eo,"DIV",{class:!0});var Ie=g(U);_(Qe.$$.fragment,Ie),gn=l(Ie),jt=a(Ie,"P",{"data-svelte-h":!0}),h(jt)!=="svelte-19xyme1"&&(jt.innerHTML=_r),un=l(Ie),_(de.$$.fragment,Ie),_n=l(Ie),_(fe.$$.fragment,Ie),Ie.forEach(t),eo.forEach(t),zo=l(e),O=a(e,"H2",{class:!0});var Ao=g(O);me=a(Ao,"A",{id:!0,class:!0,href:!0});var Lr=g(me);io=a(Lr,"SPAN",{});var Sr=g(io);_(De.$$.fragment,Sr),Sr.forEach(t),Lr.forEach(t),yn=l(Ao),Zt=a(Ao,"SPAN",{"data-svelte-h":!0}),h(Zt)!=="svelte-175u6qx"&&(Zt.textContent=yr),Ao.forEach(t),ko=l(e),Z=a(e,"DIV",{class:!0});var We=g(Z);_(Oe.$$.fragment,We),bn=l(We),Jt=a(We,"P",{"data-svelte-h":!0}),h(Jt)!=="svelte-qa8pu3"&&(Jt.textContent=br),vn=l(We),Ut=a(We,"P",{"data-svelte-h":!0}),h(Ut)!=="svelte-11dly9a"&&(Ut.innerHTML=vr),wn=l(We),z=a(We,"DIV",{class:!0});var xe=g(z);_(Ke.$$.fragment,xe),Tn=l(xe),zt=a(xe,"P",{"data-svelte-h":!0}),h(zt)!=="svelte-uccv9f"&&(zt.innerHTML=wr),Fn=l(xe),_(pe.$$.fragment,xe),Mn=l(xe),_(he.$$.fragment,xe),xe.forEach(t),We.forEach(t),No=l(e),K=a(e,"H2",{class:!0});var Qo=g(K);ge=a(Qo,"A",{id:!0,class:!0,href:!0});var qr=g(ge);lo=a(qr,"SPAN",{});var Hr=g(lo);_(et.$$.fragment,Hr),Hr.forEach(t),qr.forEach(t),$n=l(Qo),kt=a(Qo,"SPAN",{"data-svelte-h":!0}),h(kt)!=="svelte-ty86e1"&&(kt.textContent=Tr),Qo.forEach(t),Vo=l(e),C=a(e,"DIV",{class:!0});var S=g(C);_(tt.$$.fragment,S),Cn=l(S),Nt=a(S,"P",{"data-svelte-h":!0}),h(Nt)!=="svelte-105ubol"&&(Nt.textContent=Fr),En=l(S),_(ue.$$.fragment,S),In=l(S),Vt=a(S,"P",{"data-svelte-h":!0}),h(Vt)!=="svelte-11dly9a"&&(Vt.innerHTML=Mr),Wn=l(S),k=a(S,"DIV",{class:!0});var je=g(k);_(ot.$$.fragment,je),xn=l(je),Rt=a(je,"P",{"data-svelte-h":!0}),h(Rt)!=="svelte-a8wtdf"&&(Rt.innerHTML=$r),jn=l(je),_(_e.$$.fragment,je),Zn=l(je),_(ye.$$.fragment,je),je.forEach(t),S.forEach(t),Ro=l(e),ee=a(e,"H2",{class:!0});var Do=g(ee);be=a(Do,"A",{id:!0,class:!0,href:!0});var Xr=g(be);co=a(Xr,"SPAN",{});var Yr=g(co);_(nt.$$.fragment,Yr),Yr.forEach(t),Xr.forEach(t),Jn=l(Do),Pt=a(Do,"SPAN",{"data-svelte-h":!0}),h(Pt)!=="svelte-apsavi"&&(Pt.textContent=Cr),Do.forEach(t),Po=l(e),G=a(e,"DIV",{class:!0});var to=g(G);_(rt.$$.fragment,to),Un=l(to),Gt=a(to,"P",{"data-svelte-h":!0}),h(Gt)!=="svelte-1nm4rof"&&(Gt.innerHTML=Er),zn=l(to),N=a(to,"DIV",{class:!0});var Ze=g(N);_(st.$$.fragment,Ze),kn=l(Ze),Bt=a(Ze,"P",{"data-svelte-h":!0}),h(Bt)!=="svelte-npc4cp"&&(Bt.innerHTML=Ir),Nn=l(Ze),_(ve.$$.fragment,Ze),Vn=l(Ze),_(we.$$.fragment,Ze),Ze.forEach(t),to.forEach(t),Go=l(e),te=a(e,"H2",{class:!0});var Oo=g(te);Te=a(Oo,"A",{id:!0,class:!0,href:!0});var Ar=g(Te);fo=a(Ar,"SPAN",{});var Qr=g(fo);_(at.$$.fragment,Qr),Qr.forEach(t),Ar.forEach(t),Rn=l(Oo),Lt=a(Oo,"SPAN",{"data-svelte-h":!0}),h(Lt)!=="svelte-1fg3erj"&&(Lt.textContent=Wr),Oo.forEach(t),Bo=l(e),J=a(e,"DIV",{class:!0});var Je=g(J);_(it.$$.fragment,Je),Pn=l(Je),St=a(Je,"P",{"data-svelte-h":!0}),h(St)!=="svelte-iwgv3e"&&(St.textContent=xr),Gn=l(Je),qt=a(Je,"P",{"data-svelte-h":!0}),h(qt)!=="svelte-1y4qz5o"&&(qt.innerHTML=jr),Bn=l(Je),V=a(Je,"DIV",{class:!0});var Ue=g(V);_(lt.$$.fragment,Ue),Ln=l(Ue),Ht=a(Ue,"P",{"data-svelte-h":!0}),h(Ht)!=="svelte-1x29qkz"&&(Ht.innerHTML=Zr),Sn=l(Ue),_(Fe.$$.fragment,Ue),qn=l(Ue),_(Me.$$.fragment,Ue),Ue.forEach(t),Je.forEach(t),Lo=l(e),oe=a(e,"H2",{class:!0});var Ko=g(oe);$e=a(Ko,"A",{id:!0,class:!0,href:!0});var Dr=g($e);mo=a(Dr,"SPAN",{});var Or=g(mo);_(ct.$$.fragment,Or),Or.forEach(t),Dr.forEach(t),Hn=l(Ko),Xt=a(Ko,"SPAN",{"data-svelte-h":!0}),h(Xt)!=="svelte-eouv7z"&&(Xt.textContent=Jr),Ko.forEach(t),So=l(e),E=a(e,"DIV",{class:!0});var q=g(E);_(dt.$$.fragment,q),Xn=l(q),Yt=a(q,"P",{"data-svelte-h":!0}),h(Yt)!=="svelte-yw5jbc"&&(Yt.textContent=Ur),Yn=l(q),At=a(q,"P",{"data-svelte-h":!0}),h(At)!=="svelte-tyl86q"&&(At.textContent=zr),An=l(q),Qt=a(q,"P",{"data-svelte-h":!0}),h(Qt)!=="svelte-1y4qz5o"&&(Qt.innerHTML=kr),Qn=l(q),W=a(q,"DIV",{class:!0});var H=g(W);_(ft.$$.fragment,H),Dn=l(H),Dt=a(H,"P",{"data-svelte-h":!0}),h(Dt)!=="svelte-7fik8b"&&(Dt.innerHTML=Nr),On=l(H),_(Ce.$$.fragment,H),Kn=l(H),Ot=a(H,"UL",{"data-svelte-h":!0}),h(Ot)!=="svelte-tnz5q8"&&(Ot.innerHTML=Vr),er=l(H),_(Ee.$$.fragment,H),H.forEach(t),q.forEach(t),qo=l(e),po=a(e,"P",{}),g(po).forEach(t),this.h()},h(){p(o,"name","hf:doc:metadata"),p(o,"content",JSON.stringify(bs)),p(r,"id","efficientformer"),p(r,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(r,"href","#efficientformer"),p(F,"class","relative group"),p(ne,"id","overview"),p(ne,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ne,"href","#overview"),p(X,"class","relative group"),p(re,"id","documentation-resources"),p(re,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(re,"href","#documentation-resources"),p(Y,"class","relative group"),p(se,"id","transformers.EfficientFormerConfig"),p(se,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(se,"href","#transformers.EfficientFormerConfig"),p(A,"class","relative group"),p(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(ie,"id","transformers.EfficientFormerImageProcessor"),p(ie,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ie,"href","#transformers.EfficientFormerImageProcessor"),p(Q,"class","relative group"),p(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(ce,"id","transformers.EfficientFormerModel"),p(ce,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ce,"href","#transformers.EfficientFormerModel"),p(D,"class","relative group"),p(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(me,"id","transformers.EfficientFormerForImageClassification"),p(me,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(me,"href","#transformers.EfficientFormerForImageClassification"),p(O,"class","relative group"),p(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(ge,"id","transformers.EfficientFormerForImageClassificationWithTeacher"),p(ge,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ge,"href","#transformers.EfficientFormerForImageClassificationWithTeacher"),p(K,"class","relative group"),p(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(be,"id","transformers.TFEfficientFormerModel"),p(be,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(be,"href","#transformers.TFEfficientFormerModel"),p(ee,"class","relative group"),p(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(Te,"id","transformers.TFEfficientFormerForImageClassification"),p(Te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Te,"href","#transformers.TFEfficientFormerForImageClassification"),p(te,"class","relative group"),p(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p($e,"id","transformers.TFEfficientFormerForImageClassificationWithTeacher"),p($e,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p($e,"href","#transformers.TFEfficientFormerForImageClassificationWithTeacher"),p(oe,"class","relative group"),p(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){n(document.head,o),m(e,T,c),m(e,d,c),m(e,f,c),m(e,F,c),n(F,r),n(r,M),y(ze,M,null),n(F,en),n(F,vt),m(e,To,c),m(e,X,c),n(X,ne),n(ne,oo),y(ke,oo,null),n(X,tn),n(X,wt),m(e,Fo,c),m(e,Ne,c),m(e,Mo,c),m(e,Ve,c),m(e,$o,c),m(e,Re,c),m(e,Co,c),m(e,Pe,c),m(e,Eo,c),m(e,Y,c),n(Y,re),n(re,no),y(Ge,no,null),n(Y,on),n(Y,Tt),m(e,Io,c),m(e,Be,c),m(e,Wo,c),m(e,A,c),n(A,se),n(se,ro),y(Le,ro,null),n(A,nn),n(A,Ft),m(e,xo,c),m(e,j,c),y(Se,j,null),n(j,rn),n(j,Mt),n(j,sn),n(j,$t),n(j,an),y(ae,j,null),m(e,jo,c),m(e,Q,c),n(Q,ie),n(ie,so),y(qe,so,null),n(Q,ln),n(Q,Ct),m(e,Zo,c),m(e,R,c),y(He,R,null),n(R,cn),n(R,Et),n(R,dn),n(R,le),y(Xe,le,null),n(le,fn),n(le,It),m(e,Jo,c),m(e,D,c),n(D,ce),n(ce,ao),y(Ye,ao,null),n(D,mn),n(D,Wt),m(e,Uo,c),m(e,P,c),y(Ae,P,null),n(P,pn),n(P,xt),n(P,hn),n(P,U),y(Qe,U,null),n(U,gn),n(U,jt),n(U,un),y(de,U,null),n(U,_n),y(fe,U,null),m(e,zo,c),m(e,O,c),n(O,me),n(me,io),y(De,io,null),n(O,yn),n(O,Zt),m(e,ko,c),m(e,Z,c),y(Oe,Z,null),n(Z,bn),n(Z,Jt),n(Z,vn),n(Z,Ut),n(Z,wn),n(Z,z),y(Ke,z,null),n(z,Tn),n(z,zt),n(z,Fn),y(pe,z,null),n(z,Mn),y(he,z,null),m(e,No,c),m(e,K,c),n(K,ge),n(ge,lo),y(et,lo,null),n(K,$n),n(K,kt),m(e,Vo,c),m(e,C,c),y(tt,C,null),n(C,Cn),n(C,Nt),n(C,En),y(ue,C,null),n(C,In),n(C,Vt),n(C,Wn),n(C,k),y(ot,k,null),n(k,xn),n(k,Rt),n(k,jn),y(_e,k,null),n(k,Zn),y(ye,k,null),m(e,Ro,c),m(e,ee,c),n(ee,be),n(be,co),y(nt,co,null),n(ee,Jn),n(ee,Pt),m(e,Po,c),m(e,G,c),y(rt,G,null),n(G,Un),n(G,Gt),n(G,zn),n(G,N),y(st,N,null),n(N,kn),n(N,Bt),n(N,Nn),y(ve,N,null),n(N,Vn),y(we,N,null),m(e,Go,c),m(e,te,c),n(te,Te),n(Te,fo),y(at,fo,null),n(te,Rn),n(te,Lt),m(e,Bo,c),m(e,J,c),y(it,J,null),n(J,Pn),n(J,St),n(J,Gn),n(J,qt),n(J,Bn),n(J,V),y(lt,V,null),n(V,Ln),n(V,Ht),n(V,Sn),y(Fe,V,null),n(V,qn),y(Me,V,null),m(e,Lo,c),m(e,oe,c),n(oe,$e),n($e,mo),y(ct,mo,null),n(oe,Hn),n(oe,Xt),m(e,So,c),m(e,E,c),y(dt,E,null),n(E,Xn),n(E,Yt),n(E,Yn),n(E,At),n(E,An),n(E,Qt),n(E,Qn),n(E,W),y(ft,W,null),n(W,Dn),n(W,Dt),n(W,On),y(Ce,W,null),n(W,Kn),n(W,Ot),n(W,er),y(Ee,W,null),m(e,qo,c),m(e,po,c),Ho=!0},p(e,[c]){const mt={};c&2&&(mt.$$scope={dirty:c,ctx:e}),ae.$set(mt);const ho={};c&2&&(ho.$$scope={dirty:c,ctx:e}),de.$set(ho);const go={};c&2&&(go.$$scope={dirty:c,ctx:e}),fe.$set(go);const pt={};c&2&&(pt.$$scope={dirty:c,ctx:e}),pe.$set(pt);const uo={};c&2&&(uo.$$scope={dirty:c,ctx:e}),he.$set(uo);const _o={};c&2&&(_o.$$scope={dirty:c,ctx:e}),ue.$set(_o);const ht={};c&2&&(ht.$$scope={dirty:c,ctx:e}),_e.$set(ht);const yo={};c&2&&(yo.$$scope={dirty:c,ctx:e}),ye.$set(yo);const bo={};c&2&&(bo.$$scope={dirty:c,ctx:e}),ve.$set(bo);const gt={};c&2&&(gt.$$scope={dirty:c,ctx:e}),we.$set(gt);const vo={};c&2&&(vo.$$scope={dirty:c,ctx:e}),Fe.$set(vo);const wo={};c&2&&(wo.$$scope={dirty:c,ctx:e}),Me.$set(wo);const B={};c&2&&(B.$$scope={dirty:c,ctx:e}),Ce.$set(B);const ut={};c&2&&(ut.$$scope={dirty:c,ctx:e}),Ee.$set(ut)},i(e){Ho||(b(ze.$$.fragment,e),b(ke.$$.fragment,e),b(Ge.$$.fragment,e),b(Le.$$.fragment,e),b(Se.$$.fragment,e),b(ae.$$.fragment,e),b(qe.$$.fragment,e),b(He.$$.fragment,e),b(Xe.$$.fragment,e),b(Ye.$$.fragment,e),b(Ae.$$.fragment,e),b(Qe.$$.fragment,e),b(de.$$.fragment,e),b(fe.$$.fragment,e),b(De.$$.fragment,e),b(Oe.$$.fragment,e),b(Ke.$$.fragment,e),b(pe.$$.fragment,e),b(he.$$.fragment,e),b(et.$$.fragment,e),b(tt.$$.fragment,e),b(ue.$$.fragment,e),b(ot.$$.fragment,e),b(_e.$$.fragment,e),b(ye.$$.fragment,e),b(nt.$$.fragment,e),b(rt.$$.fragment,e),b(st.$$.fragment,e),b(ve.$$.fragment,e),b(we.$$.fragment,e),b(at.$$.fragment,e),b(it.$$.fragment,e),b(lt.$$.fragment,e),b(Fe.$$.fragment,e),b(Me.$$.fragment,e),b(ct.$$.fragment,e),b(dt.$$.fragment,e),b(ft.$$.fragment,e),b(Ce.$$.fragment,e),b(Ee.$$.fragment,e),Ho=!0)},o(e){v(ze.$$.fragment,e),v(ke.$$.fragment,e),v(Ge.$$.fragment,e),v(Le.$$.fragment,e),v(Se.$$.fragment,e),v(ae.$$.fragment,e),v(qe.$$.fragment,e),v(He.$$.fragment,e),v(Xe.$$.fragment,e),v(Ye.$$.fragment,e),v(Ae.$$.fragment,e),v(Qe.$$.fragment,e),v(de.$$.fragment,e),v(fe.$$.fragment,e),v(De.$$.fragment,e),v(Oe.$$.fragment,e),v(Ke.$$.fragment,e),v(pe.$$.fragment,e),v(he.$$.fragment,e),v(et.$$.fragment,e),v(tt.$$.fragment,e),v(ue.$$.fragment,e),v(ot.$$.fragment,e),v(_e.$$.fragment,e),v(ye.$$.fragment,e),v(nt.$$.fragment,e),v(rt.$$.fragment,e),v(st.$$.fragment,e),v(ve.$$.fragment,e),v(we.$$.fragment,e),v(at.$$.fragment,e),v(it.$$.fragment,e),v(lt.$$.fragment,e),v(Fe.$$.fragment,e),v(Me.$$.fragment,e),v(ct.$$.fragment,e),v(dt.$$.fragment,e),v(ft.$$.fragment,e),v(Ce.$$.fragment,e),v(Ee.$$.fragment,e),Ho=!1},d(e){e&&(t(T),t(d),t(f),t(F),t(To),t(X),t(Fo),t(Ne),t(Mo),t(Ve),t($o),t(Re),t(Co),t(Pe),t(Eo),t(Y),t(Io),t(Be),t(Wo),t(A),t(xo),t(j),t(jo),t(Q),t(Zo),t(R),t(Jo),t(D),t(Uo),t(P),t(zo),t(O),t(ko),t(Z),t(No),t(K),t(Vo),t(C),t(Ro),t(ee),t(Po),t(G),t(Go),t(te),t(Bo),t(J),t(Lo),t(oe),t(So),t(E),t(qo),t(po)),t(o),w(ze),w(ke),w(Ge),w(Le),w(Se),w(ae),w(qe),w(He),w(Xe),w(Ye),w(Ae),w(Qe),w(de),w(fe),w(De),w(Oe),w(Ke),w(pe),w(he),w(et),w(tt),w(ue),w(ot),w(_e),w(ye),w(nt),w(rt),w(st),w(ve),w(we),w(at),w(it),w(lt),w(Fe),w(Me),w(ct),w(dt),w(ft),w(Ce),w(Ee)}}}const bs={local:"efficientformer",sections:[{local:"overview",title:"Overview"},{local:"documentation-resources",title:"Documentation resources"},{local:"transformers.EfficientFormerConfig",title:"EfficientFormerConfig"},{local:"transformers.EfficientFormerImageProcessor",title:"EfficientFormerImageProcessor"},{local:"transformers.EfficientFormerModel",title:"EfficientFormerModel"},{local:"transformers.EfficientFormerForImageClassification",title:"EfficientFormerForImageClassification"},{local:"transformers.EfficientFormerForImageClassificationWithTeacher",title:"EfficientFormerForImageClassificationWithTeacher"},{local:"transformers.TFEfficientFormerModel",title:"TFEfficientFormerModel"},{local:"transformers.TFEfficientFormerForImageClassification",title:"TFEfficientFormerForImageClassification"},{local:"transformers.TFEfficientFormerForImageClassificationWithTeacher",title:"TFEfficientFormerForImageClassificationWithTeacher"}],title:"EfficientFormer"};function vs($){return es(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Is extends ts{constructor(o){super(),os(this,o,vs,ys,Kr,{})}}export{Is as component};
