import{s as ha,o as fa,n as O}from"../chunks/scheduler.9bc65507.js";import{S as ga,i as _a,g as s,s as l,u as _,A as Ta,h as a,f as t,c as i,j as f,v as T,y as h,k as m,o as n,a as c,w as y,d as M,t as J,x as b}from"../chunks/index.78c82d43.js";import{T as ua}from"../chunks/Tip.87d55b76.js";import{D as ue}from"../chunks/Docstring.4e7352e2.js";import{C as he}from"../chunks/CodeBlock.73e038be.js";import{I as P}from"../chunks/IconCopyLink.bedaa44d.js";import{E as Xe}from"../chunks/ExampleCodeBlock.872b014d.js";function ya(C){let o,g="Example:",d,u,U;return u=new he({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVFNhbkphcGFuZXNlVG9rZW5pemVyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwR1BUU2FuSmFwYW5lc2VUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlRhbnJlaSUyRkdQVFNBTi1qYXBhbmVzZSUyMiklMEElMjMlMjBZb3UlMjBjYW4lMjBjb25maXJtJTIwYm90aCUyMCVFNiU4NSVCNiVFNSVCRiU5QyUyMGFuZCUyMCVFNiU4NSVCNiVFNiU4NyU4OSUyMGFyZSUyMGVuY29kZWQlMjB0byUyMDE3NzUwJTBBdG9rZW5pemVyKCUyMiVFNSU5MCVCRSVFOCVCQyVBOSVFMyU4MSVBRiVFNyU4QyVBQiVFMyU4MSVBNyVFMyU4MSU4MiVFMyU4MiU4QiVGMCU5RiU5MCVBRiVFMyU4MCU4MiVFNSVBRSU5RiVFMyU4MSVBRiVFNiU4NSVCNiVFNSVCRiU5QyglRTYlODUlQjYlRTYlODclODkpJUU1JUE0JUE3JUU1JUFEJUE2JUU1JTg3JUJBJUU4JUJBJUFCJTIyKSU1QiUyMmlucHV0X2lkcyUyMiU1RCUwQSUwQSUyMyUyMEJvdGglMjAlRTYlODUlQjYlRTUlQkYlOUMlMjBhbmQlMjAlRTYlODUlQjYlRTYlODclODklMjBhcmUlMjBkZWNvZGVkJTIwdG8lMjAlRTYlODUlQjYlRTUlQkYlOUMlMEF0b2tlbml6ZXIuZGVjb2RlKHRva2VuaXplciglMjIlRTUlOTAlQkUlRTglQkMlQTklRTMlODElQUYlRTclOEMlQUIlRTMlODElQTclRTMlODElODIlRTMlODIlOEIlRjAlOUYlOTAlQUYlRTMlODAlODIlRTUlQUUlOUYlRTMlODElQUYlRTYlODUlQjYlRTUlQkYlOUMoJUU2JTg1JUI2JUU2JTg3JTg5KSVFNSVBNCVBNyVFNSVBRCVBNiVFNSU4NyVCQSVFOCVCQSVBQiUyMiklNUIlMjJpbnB1dF9pZHMlMjIlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPTSanJapaneseTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPTSanJapaneseTokenizer.from_pretrained(<span class="hljs-string">&quot;Tanrei/GPTSAN-japanese&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># You can confirm both 慶応 and 慶應 are encoded to 17750</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer(<span class="hljs-string">&quot;吾輩は猫である🐯。実は慶応(慶應)大学出身&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]
[<span class="hljs-number">35993</span>, <span class="hljs-number">35998</span>, <span class="hljs-number">34347</span>, <span class="hljs-number">31459</span>, <span class="hljs-number">30647</span>, <span class="hljs-number">31448</span>, <span class="hljs-number">25</span>, <span class="hljs-number">30659</span>, <span class="hljs-number">35729</span>, <span class="hljs-number">35676</span>, <span class="hljs-number">32417</span>, <span class="hljs-number">30647</span>, <span class="hljs-number">17750</span>, <span class="hljs-number">35589</span>, <span class="hljs-number">17750</span>, <span class="hljs-number">35590</span>, <span class="hljs-number">321</span>, <span class="hljs-number">1281</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Both 慶応 and 慶應 are decoded to 慶応</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(tokenizer(<span class="hljs-string">&quot;吾輩は猫である🐯。実は慶応(慶應)大学出身&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-string">&#x27;吾輩は猫である🐯。実は慶応(慶応)大学出身&#x27;</span>`,wrap:!1}}),{c(){o=s("p"),o.textContent=g,d=l(),_(u.$$.fragment)},l(p){o=a(p,"P",{"data-svelte-h":!0}),h(o)!=="svelte-11lpom8"&&(o.textContent=g),d=i(p),T(u.$$.fragment,p)},m(p,j){c(p,o,j),c(p,d,j),y(u,p,j),U=!0},p:O,i(p){U||(M(u.$$.fragment,p),U=!0)},o(p){J(u.$$.fragment,p),U=!1},d(p){p&&(t(o),t(d)),b(u,p)}}}function Ma(C){let o,g="Example for Prefix-LM:",d,u,U;return u=new he({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVFNhbkphcGFuZXNlVG9rZW5pemVyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwR1BUU2FuSmFwYW5lc2VUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlRhbnJlaSUyRkdQVFNBTi1qYXBhbmVzZSUyMiklMEF0b2tlbml6ZXIoJTIyJUU1JUFFJTlGJUUzJTgxJUFGJUU2JTg1JUI2JUU1JUJGJTlDKCVFNiU4NSVCNiVFNiU4NyU4OSklRTUlQTQlQTclRTUlQUQlQTYlRTUlODclQkElRTglQkElQUIlMjIlMkMlMjBwcmVmaXhfdGV4dCUzRCUyMiVFNSU5MCVCRSVFOCVCQyVBOSVFMyU4MSVBRiVFNyU4QyVBQiVFMyU4MSVBNyVFMyU4MSU4MiVFMyU4MiU4QiVGMCU5RiU5MCVBRiVFMyU4MCU4MiUyMiklNUIlMjJpbnB1dF9pZHMlMjIlNUQlMEElMEElMjMlMjBNYXNrJTIwZm9yJTIwUHJlZml4LUxNJTIwaW5wdXRzJTBBdG9rZW5pemVyKCUyMiVFNSVBRSU5RiVFMyU4MSVBRiVFNiU4NSVCNiVFNSVCRiU5QyglRTYlODUlQjYlRTYlODclODkpJUU1JUE0JUE3JUU1JUFEJUE2JUU1JTg3JUJBJUU4JUJBJUFCJTIyJTJDJTIwcHJlZml4X3RleHQlM0QlMjIlRTUlOTAlQkUlRTglQkMlQTklRTMlODElQUYlRTclOEMlQUIlRTMlODElQTclRTMlODElODIlRTMlODIlOEIlRjAlOUYlOTAlQUYlRTMlODAlODIlMjIpJTVCJTIydG9rZW5fdHlwZV9pZHMlMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPTSanJapaneseTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPTSanJapaneseTokenizer.from_pretrained(<span class="hljs-string">&quot;Tanrei/GPTSAN-japanese&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer(<span class="hljs-string">&quot;実は慶応(慶應)大学出身&quot;</span>, prefix_text=<span class="hljs-string">&quot;吾輩は猫である🐯。&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]
[<span class="hljs-number">35993</span>, <span class="hljs-number">34347</span>, <span class="hljs-number">31459</span>, <span class="hljs-number">30647</span>, <span class="hljs-number">31448</span>, <span class="hljs-number">25</span>, <span class="hljs-number">30659</span>, <span class="hljs-number">35729</span>, <span class="hljs-number">35676</span>, <span class="hljs-number">35998</span>, <span class="hljs-number">32417</span>, <span class="hljs-number">30647</span>, <span class="hljs-number">17750</span>, <span class="hljs-number">35589</span>, <span class="hljs-number">17750</span>, <span class="hljs-number">35590</span>, <span class="hljs-number">321</span>, <span class="hljs-number">1281</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Mask for Prefix-LM inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer(<span class="hljs-string">&quot;実は慶応(慶應)大学出身&quot;</span>, prefix_text=<span class="hljs-string">&quot;吾輩は猫である🐯。&quot;</span>)[<span class="hljs-string">&quot;token_type_ids&quot;</span>]
[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=s("p"),o.textContent=g,d=l(),_(u.$$.fragment)},l(p){o=a(p,"P",{"data-svelte-h":!0}),h(o)!=="svelte-sklucv"&&(o.textContent=g),d=i(p),T(u.$$.fragment,p)},m(p,j){c(p,o,j),c(p,d,j),y(u,p,j),U=!0},p:O,i(p){U||(M(u.$$.fragment,p),U=!0)},o(p){J(u.$$.fragment,p),U=!1},d(p){p&&(t(o),t(d)),b(u,p)}}}function Ja(C){let o,g="Example for batch encode:",d,u,U;return u=new he({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVFNhbkphcGFuZXNlVG9rZW5pemVyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwR1BUU2FuSmFwYW5lc2VUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlRhbnJlaSUyRkdQVFNBTi1qYXBhbmVzZSUyMiklMEF0b2tlbml6ZXIoJTVCJTVCJTIyJUU2JUFEJUE2JUU3JTk0JUIwJUU0JUJGJUExJUU3JThFJTg0JTIyJTJDJTIwJTIyJUUzJTgxJUFGJUUzJTgwJTgxJTIyJTVEJTJDJTIwJTVCJTIyJUU3JUI5JTk0JUU3JTk0JUIwJUU0JUJGJUExJUU5JTk1JUI3JTIyJTJDJTIwJTIyJUUzJTgxJUFFJUU5JTg1JThEJUU0JUI4JThCJUUzJTgxJUFFJUUzJTgwJTgxJTIyJTVEJTVEJTJDJTIwcGFkZGluZyUzRFRydWUpJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTBBJTBBJTIzJTIwTWFzayUyMGZvciUyMFByZWZpeC1MTSUyMGlucHV0cyUwQXRva2VuaXplciglNUIlNUIlMjIlRTYlQUQlQTYlRTclOTQlQjAlRTQlQkYlQTElRTclOEUlODQlMjIlMkMlMjAlMjIlRTMlODElQUYlRTMlODAlODElMjIlNUQlMkMlMjAlNUIlMjIlRTclQjklOTQlRTclOTQlQjAlRTQlQkYlQTElRTklOTUlQjclMjIlMkMlMjAlMjIlRTMlODElQUUlRTklODUlOEQlRTQlQjglOEIlRTMlODElQUUlRTMlODAlODElMjIlNUQlNUQlMkMlMjBwYWRkaW5nJTNEVHJ1ZSklNUIlMjJ0b2tlbl90eXBlX2lkcyUyMiU1RCUwQSUwQSUyMyUyME1hc2slMjBmb3IlMjBwYWRkaW5nJTBBdG9rZW5pemVyKCU1QiU1QiUyMiVFNiVBRCVBNiVFNyU5NCVCMCVFNCVCRiVBMSVFNyU4RSU4NCUyMiUyQyUyMCUyMiVFMyU4MSVBRiVFMyU4MCU4MSUyMiU1RCUyQyUyMCU1QiUyMiVFNyVCOSU5NCVFNyU5NCVCMCVFNCVCRiVBMSVFOSU5NSVCNyUyMiUyQyUyMCUyMiVFMyU4MSVBRSVFOSU4NSU4RCVFNCVCOCU4QiVFMyU4MSVBRSVFMyU4MCU4MSUyMiU1RCU1RCUyQyUyMHBhZGRpbmclM0RUcnVlKSU1QiUyMmF0dGVudGlvbl9tYXNrJTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPTSanJapaneseTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPTSanJapaneseTokenizer.from_pretrained(<span class="hljs-string">&quot;Tanrei/GPTSAN-japanese&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer([[<span class="hljs-string">&quot;武田信玄&quot;</span>, <span class="hljs-string">&quot;は、&quot;</span>], [<span class="hljs-string">&quot;織田信長&quot;</span>, <span class="hljs-string">&quot;の配下の、&quot;</span>]], padding=<span class="hljs-literal">True</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]
[[<span class="hljs-number">35993</span>, <span class="hljs-number">8640</span>, <span class="hljs-number">25948</span>, <span class="hljs-number">35998</span>, <span class="hljs-number">30647</span>, <span class="hljs-number">35675</span>, <span class="hljs-number">35999</span>, <span class="hljs-number">35999</span>], [<span class="hljs-number">35993</span>, <span class="hljs-number">10382</span>, <span class="hljs-number">9868</span>, <span class="hljs-number">35998</span>, <span class="hljs-number">30646</span>, <span class="hljs-number">9459</span>, <span class="hljs-number">30646</span>, <span class="hljs-number">35675</span>]]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Mask for Prefix-LM inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer([[<span class="hljs-string">&quot;武田信玄&quot;</span>, <span class="hljs-string">&quot;は、&quot;</span>], [<span class="hljs-string">&quot;織田信長&quot;</span>, <span class="hljs-string">&quot;の配下の、&quot;</span>]], padding=<span class="hljs-literal">True</span>)[<span class="hljs-string">&quot;token_type_ids&quot;</span>]
[[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>], [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>]]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Mask for padding</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer([[<span class="hljs-string">&quot;武田信玄&quot;</span>, <span class="hljs-string">&quot;は、&quot;</span>], [<span class="hljs-string">&quot;織田信長&quot;</span>, <span class="hljs-string">&quot;の配下の、&quot;</span>]], padding=<span class="hljs-literal">True</span>)[<span class="hljs-string">&quot;attention_mask&quot;</span>]
[[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>], [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]]`,wrap:!1}}),{c(){o=s("p"),o.textContent=g,d=l(),_(u.$$.fragment)},l(p){o=a(p,"P",{"data-svelte-h":!0}),h(o)!=="svelte-1t2nozh"&&(o.textContent=g),d=i(p),T(u.$$.fragment,p)},m(p,j){c(p,o,j),c(p,d,j),y(u,p,j),U=!0},p:O,i(p){U||(M(u.$$.fragment,p),U=!0)},o(p){J(u.$$.fragment,p),U=!1},d(p){p&&(t(o),t(d)),b(u,p)}}}function ba(C){let o,g="Example:",d,u,U;return u=new he({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVFNhbkphcGFuZXNlVG9rZW5pemVyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwR1BUU2FuSmFwYW5lc2VUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlRhbnJlaSUyRkdQVFNBTi1qYXBhbmVzZSUyMiklMEF4X3Rva2VuJTIwJTNEJTIwdG9rZW5pemVyKCUyMiVFRiVCRCVCMSVFRiVCRCVCMiVFRiVCRCVCMyVFRiVCRCVCNCUyMiklMEElMjMlMjBpbnB1dF9pZHMlM0ElMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjBTT1QlMjAlN0MlMjBTRUclMjAlN0MlMjAlRUYlQkQlQjElMjAlN0MlMjAlRUYlQkQlQjIlMjAlN0MlMjAlRUYlQkQlQjMlMjAlN0MlMjAlRUYlQkQlQjQlMjAlN0MlMEElMjMlMjB0b2tlbl90eXBlX2lkcyUzQSUyMCU3QyUyMDElMjAlMjAlMjAlN0MlMjAwJTIwJTIwJTIwJTdDJTIwMCUyMCU3QyUyMDAlMjAlN0MlMjAwJTIwJTdDJTIwMCUyMCU3QyUwQSUwQXhfdG9rZW4lMjAlM0QlMjB0b2tlbml6ZXIoJTIyJTIyJTJDJTIwcHJlZml4X3RleHQlM0QlMjIlRUYlQkQlQjElRUYlQkQlQjIlRUYlQkQlQjMlRUYlQkQlQjQlMjIpJTBBJTIzJTIwaW5wdXRfaWRzJTNBJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwU09UJTIwJTdDJTIwJUVGJUJEJUIxJTIwJTdDJTIwJUVGJUJEJUIyJTIwJTdDJTIwJUVGJUJEJUIzJTIwJTdDJTIwJUVGJUJEJUI0JTIwJTdDJTIwU0VHJTIwJTdDJTBBJTIzJTIwdG9rZW5fdHlwZV9pZHMlM0ElMjAlN0MlMjAxJTIwJTIwJTIwJTdDJTIwMSUyMCU3QyUyMDElMjAlN0MlMjAxJTIwJTdDJTIwMSUyMCU3QyUyMDAlMjAlMjAlN0MlMEElMEF4X3Rva2VuJTIwJTNEJTIwdG9rZW5pemVyKCUyMiVFRiVCRCVCMyVFRiVCRCVCNCUyMiUyQyUyMHByZWZpeF90ZXh0JTNEJTIyJUVGJUJEJUIxJUVGJUJEJUIyJTIyKSUwQSUyMyUyMGlucHV0X2lkcyUzQSUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMFNPVCUyMCU3QyUyMCVFRiVCRCVCMSUyMCU3QyUyMCVFRiVCRCVCMiUyMCU3QyUyMFNFRyUyMCU3QyUyMCVFRiVCRCVCMyUyMCU3QyUyMCVFRiVCRCVCNCUyMCU3QyUwQSUyMyUyMHRva2VuX3R5cGVfaWRzJTNBJTIwJTdDJTIwMSUyMCUyMCUyMCU3QyUyMDElMjAlN0MlMjAxJTIwJTdDJTIwMCUyMCUyMCUyMCU3QyUyMDAlMjAlN0MlMjAwJTIwJTdD",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPTSanJapaneseTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPTSanJapaneseTokenizer.from_pretrained(<span class="hljs-string">&quot;Tanrei/GPTSAN-japanese&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>x_token = tokenizer(<span class="hljs-string">&quot;ｱｲｳｴ&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># input_ids:      | SOT | SEG | ｱ | ｲ | ｳ | ｴ |</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># token_type_ids: | 1   | 0   | 0 | 0 | 0 | 0 |</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>x_token = tokenizer(<span class="hljs-string">&quot;&quot;</span>, prefix_text=<span class="hljs-string">&quot;ｱｲｳｴ&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># input_ids:      | SOT | ｱ | ｲ | ｳ | ｴ | SEG |</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># token_type_ids: | 1   | 1 | 1 | 1 | 1 | 0  |</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>x_token = tokenizer(<span class="hljs-string">&quot;ｳｴ&quot;</span>, prefix_text=<span class="hljs-string">&quot;ｱｲ&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># input_ids:      | SOT | ｱ | ｲ | SEG | ｳ | ｴ |</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># token_type_ids: | 1   | 1 | 1 | 0   | 0 | 0 |</span>`,wrap:!1}}),{c(){o=s("p"),o.textContent=g,d=l(),_(u.$$.fragment)},l(p){o=a(p,"P",{"data-svelte-h":!0}),h(o)!=="svelte-11lpom8"&&(o.textContent=g),d=i(p),T(u.$$.fragment,p)},m(p,j){c(p,o,j),c(p,d,j),y(u,p,j),U=!0},p:O,i(p){U||(M(u.$$.fragment,p),U=!0)},o(p){J(u.$$.fragment,p),U=!1},d(p){p&&(t(o),t(d)),b(u,p)}}}function Ua(C){let o,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=s("p"),o.innerHTML=g},l(d){o=a(d,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fincs2"&&(o.innerHTML=g)},m(d,u){c(d,o,u)},p:O,d(d){d&&t(o)}}}function ka(C){let o,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=s("p"),o.innerHTML=g},l(d){o=a(d,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fincs2"&&(o.innerHTML=g)},m(d,u){c(d,o,u)},p:O,d(d){d&&t(o)}}}function ja(C){let o,g;return o=new he({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUyQyUyMEF1dG9Ub2tlbml6ZXIlMkMlMjB0cmFpbmVyX3V0aWxzJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJUYW5yZWklMkZHUFRTQU4tamFwYW5lc2UlMjIpLnRvKGRldmljZSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJUYW5yZWklMkZHUFRTQU4tamFwYW5lc2UlMjIpJTBBeF90b2tlbiUyMCUzRCUyMHRva2VuaXplciglMjIlRTclQjklOTQlRTclOTQlQjAlRTQlQkYlQTElRTklOTUlQjclRTMlODElQUYlRTMlODAlODElMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXRyYWluZXJfdXRpbHMuc2V0X3NlZWQoMzApJTBBaW5wdXRfaWRzJTIwJTNEJTIweF90b2tlbi5pbnB1dF9pZHMudG8oZGV2aWNlKSUwQWdlbl90b2tlbiUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0X2lkcyUyQyUyMG1heF9uZXdfdG9rZW5zJTNENTApJTBBdG9rZW5pemVyLmRlY29kZShnZW5fdG9rZW4lNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel, AutoTokenizer, trainer_utils

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;Tanrei/GPTSAN-japanese&quot;</span>).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Tanrei/GPTSAN-japanese&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>x_token = tokenizer(<span class="hljs-string">&quot;織田信長は、&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>trainer_utils.set_seed(<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = x_token.input_ids.to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_token = model.generate(input_ids, max_new_tokens=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(gen_token[<span class="hljs-number">0</span>])
<span class="hljs-string">&quot;織田信長は、政治・軍事の中枢まで掌握した政治家であり、日本史上類を見ない驚異的な軍事侵攻を続け...&quot;</span>`,wrap:!1}}),{c(){_(o.$$.fragment)},l(d){T(o.$$.fragment,d)},m(d,u){y(o,d,u),g=!0},p:O,i(d){g||(M(o.$$.fragment,d),g=!0)},o(d){J(o.$$.fragment,d),g=!1},d(d){b(o,d)}}}function va(C){let o,g;return o=new he({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUyQyUyMEF1dG9Ub2tlbml6ZXIlMkMlMjB0cmFpbmVyX3V0aWxzJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJUYW5yZWklMkZHUFRTQU4tamFwYW5lc2UlMjIpLnRvKGRldmljZSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJUYW5yZWklMkZHUFRTQU4tamFwYW5lc2UlMjIpJTBBeF90b2tlbiUyMCUzRCUyMHRva2VuaXplciglMjIlMjIlMkMlMjBwcmVmaXhfdGV4dCUzRCUyMiVFNyVCOSU5NCVFNyU5NCVCMCVFNCVCRiVBMSVFOSU5NSVCNyVFMyU4MSVBRiVFMyU4MCU4MSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBdHJhaW5lcl91dGlscy5zZXRfc2VlZCgzMCklMEFpbnB1dF9pZHMlMjAlM0QlMjB4X3Rva2VuLmlucHV0X2lkcy50byhkZXZpY2UpJTBBdG9rZW5fdHlwZV9pZHMlMjAlM0QlMjB4X3Rva2VuLnRva2VuX3R5cGVfaWRzLnRvKGRldmljZSklMEFnZW5fdG9rZW4lMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dF9pZHMlMkMlMjB0b2tlbl90eXBlX2lkcyUzRHRva2VuX3R5cGVfaWRzJTJDJTIwbWF4X25ld190b2tlbnMlM0Q1MCklMEF0b2tlbml6ZXIuZGVjb2RlKGdlbl90b2tlbiU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel, AutoTokenizer, trainer_utils

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;Tanrei/GPTSAN-japanese&quot;</span>).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Tanrei/GPTSAN-japanese&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>x_token = tokenizer(<span class="hljs-string">&quot;&quot;</span>, prefix_text=<span class="hljs-string">&quot;織田信長は、&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>trainer_utils.set_seed(<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = x_token.input_ids.to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>token_type_ids = x_token.token_type_ids.to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_token = model.generate(input_ids, token_type_ids=token_type_ids, max_new_tokens=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(gen_token[<span class="hljs-number">0</span>])
<span class="hljs-string">&quot;織田信長は、政治・外交で数々の戦果を上げるが、1568年からは、いわゆる本能寺の変で細川晴元に暗殺される...&quot;</span>`,wrap:!1}}),{c(){_(o.$$.fragment)},l(d){T(o.$$.fragment,d)},m(d,u){y(o,d,u),g=!0},p:O,i(d){g||(M(o.$$.fragment,d),g=!0)},o(d){J(o.$$.fragment,d),g=!1},d(d){b(o,d)}}}function Ca(C){let o,g;return o=new he({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUyQyUyMEF1dG9Ub2tlbml6ZXIlMkMlMjB0cmFpbmVyX3V0aWxzJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJUYW5yZWklMkZHUFRTQU4tamFwYW5lc2UlMjIpLnRvKGRldmljZSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJUYW5yZWklMkZHUFRTQU4tamFwYW5lc2UlMjIpJTBBbWFza2VkX3NlbnRlbmNlJTIwJTNEJTIwJTIyJUU2JUFEJUE2JUU3JTk0JUIwJUU0JUJGJUExJUU3JThFJTg0JUUzJTgxJUFGJUUzJTgwJTgxJTNDJTdDaW5wdXRtYXNrJTdDJTNFJUU2JTk5JTgyJUU0JUJCJUEzJUUzJTgzJTk1JUUzJTgyJUExJUUzJTgzJUIzJUUzJTgxJUFBJUUzJTgyJTg5JUUzJTgxJTlDJUUzJTgxJUIyJUU2JThBJUJDJUUzJTgxJTk1JUUzJTgxJTg4JTNDJTdDaW5wdXRtYXNrJTdDJTNFJUUzJTgxJThEJUUzJTgxJTlGJUUzJTgxJTg0JUU1JTkwJThEJUU1JUIwJTg2JUUzJTgxJUFFJUU0JUI4JTgwJUU0JUJBJUJBJUUzJTgwJTgyJTIyJTBBeF90b2tlbiUyMCUzRCUyMHRva2VuaXplciglMjIlMjIlMkMlMjBwcmVmaXhfdGV4dCUzRG1hc2tlZF9zZW50ZW5jZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBdHJhaW5lcl91dGlscy5zZXRfc2VlZCgzMCklMEFpbnB1dF9pZHMlMjAlM0QlMjB4X3Rva2VuLmlucHV0X2lkcy50byhkZXZpY2UpJTBBdG9rZW5fdHlwZV9pZHMlMjAlM0QlMjB4X3Rva2VuLnRva2VuX3R5cGVfaWRzLnRvKGRldmljZSklMEFvdXRfbG1fdG9rZW4lMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dF9pZHMlMkMlMjB0b2tlbl90eXBlX2lkcyUzRHRva2VuX3R5cGVfaWRzJTJDJTIwbWF4X25ld190b2tlbnMlM0Q1MCklMEFvdXRfbWxtX3Rva2VuJTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzJTJDJTIwdG9rZW5fdHlwZV9pZHMlM0R0b2tlbl90eXBlX2lkcykubG9naXRzLmFyZ21heChheGlzJTNELTEpJTBBdG9rZW5pemVyLmRlY29kZShvdXRfbWxtX3Rva2VuJTVCMCU1RCklMEElMEF0b2tlbml6ZXIuZGVjb2RlKG91dF9sbV90b2tlbiU1QjAlNUQlNUJpbnB1dF9pZHMuc2hhcGUlNUIxJTVEJTIwJTNBJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel, AutoTokenizer, trainer_utils

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;Tanrei/GPTSAN-japanese&quot;</span>).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Tanrei/GPTSAN-japanese&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>masked_sentence = <span class="hljs-string">&quot;武田信玄は、&lt;|inputmask|&gt;時代ファンならぜひ押さえ&lt;|inputmask|&gt;きたい名将の一人。&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>x_token = tokenizer(<span class="hljs-string">&quot;&quot;</span>, prefix_text=masked_sentence, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>trainer_utils.set_seed(<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = x_token.input_ids.to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>token_type_ids = x_token.token_type_ids.to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>out_lm_token = model.generate(input_ids, token_type_ids=token_type_ids, max_new_tokens=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out_mlm_token = model(input_ids, token_type_ids=token_type_ids).logits.argmax(axis=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(out_mlm_token[<span class="hljs-number">0</span>])
<span class="hljs-string">&quot;武田信玄は、戦国時代ファンならぜひ押さえておきたい名将の一人。&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(out_lm_token[<span class="hljs-number">0</span>][input_ids.shape[<span class="hljs-number">1</span>] :])
<span class="hljs-string">&quot;武田氏の三代に渡った武田家のひとり\\n甲斐市に住む、日本史上最大の戦国大名。...&quot;</span>`,wrap:!1}}),{c(){_(o.$$.fragment)},l(d){T(o.$$.fragment,d)},m(d,u){y(o,d,u),g=!0},p:O,i(d){g||(M(o.$$.fragment,d),g=!0)},o(d){J(o.$$.fragment,d),g=!1},d(d){b(o,d)}}}function xa(C){let o,g,d,u,U,p,j,fe,vn,Le,us="GPTSAN-japanese",qt,I,H,Ct,ge,Cn,De,hs="Overview",Bt,_e,fs="The GPTSAN-japanese model was released in the repository by Toshiyuki Sakamoto (tanreinama).",At,Te,gs=`GPTSAN is a Japanese language model using Switch Transformer. It has the same structure as the model introduced as Prefix LM
in the T5 paper, and support both Text Generation and Masked Language Modeling tasks. These basic tasks similarly can
fine-tune for translation or summarization.`,Wt,E,X,xt,ye,xn,Ye,_s="Generation",Ot,Me,Ts="The <code>generate()</code> method can be used to generate text using GPTSAN-Japanese model.",Ht,Je,Xt,z,L,wt,be,wn,Ke,ys="GPTSAN Features",Lt,Ue,Ms=`GPTSAN has some unique features. It has a model structure of Prefix-LM. It works as a shifted Masked Language Model for Prefix Input tokens. Un-prefixed inputs behave like normal generative models.
The Spout vector is a GPTSAN specific input. Spout is pre-trained with random inputs, but you can specify a class of text or an arbitrary vector during fine-tuning. This allows you to indicate the tendency of the generated text.
GPTSAN has a sparse Feed Forward based on Switch-Transformer. You can also add other layers and train them partially. See the original GPTSAN repository for details.`,Dt,Q,D,St,ke,Sn,et,Js="Prefix-LM Model",Yt,je,bs=`GPTSAN has the structure of the model named Prefix-LM in the <code>T5</code> paper. (The original GPTSAN repository calls it <code>hybrid</code>)
In GPTSAN, the <code>Prefix</code> part of Prefix-LM, that is, the input position that can be referenced by both tokens, can be specified with any length.
Arbitrary lengths can also be specified differently for each batch.
This length applies to the text entered in <code>prefix_text</code> for the tokenizer.
The tokenizer returns the mask of the <code>Prefix</code> part of Prefix-LM as <code>token_type_ids</code>.
The model treats the part where <code>token_type_ids</code> is 1 as a <code>Prefix</code> part, that is, the input can refer to both tokens before and after.`,Kt,ve,Us="Tips:",en,Ce,ks=`Specifying the Prefix part is done with a mask passed to self-attention.
When token_type_ids=None or all zero, it is equivalent to regular causal mask`,tn,xe,js="for example:",nn,we,vs=`<blockquote><blockquote><p>x_token = tokenizer(“ｱｲｳｴ”)
input_ids:      | SOT | SEG | ｱ | ｲ | ｳ | ｴ |
token_type_ids: | 1   | 0   | 0 | 0 | 0 | 0 |
prefix_lm_mask:
SOT | 1 0 0 0 0 0 |
SEG | 1 1 0 0 0 0 |
ｱ   | 1 1 1 0 0 0 |
ｲ   | 1 1 1 1 0 0 |
ｳ   | 1 1 1 1 1 0 |
ｴ   | 1 1 1 1 1 1 |</p></blockquote></blockquote>`,sn,Se,Cs=`<blockquote><blockquote><p>x_token = tokenizer(&quot;&quot;, prefix_text=“ｱｲｳｴ”)
input_ids:      | SOT | ｱ | ｲ | ｳ | ｴ | SEG |
token_type_ids: | 1   | 1 | 1 | 1 | 1 | 0  |
prefix_lm_mask:
SOT | 1 1 1 1 1 0 |
ｱ   | 1 1 1 1 1 0 |
ｲ   | 1 1 1 1 1 0 |
ｳ   | 1 1 1 1 1 0 |
ｴ   | 1 1 1 1 1 0 |
SEG | 1 1 1 1 1 1 |</p></blockquote></blockquote>`,an,Ge,xs=`<blockquote><blockquote><p>x_token = tokenizer(“ｳｴ”, prefix_text=“ｱｲ”)
input_ids:      | SOT | ｱ | ｲ | SEG | ｳ | ｴ |
token_type_ids: | 1   | 1 | 1 | 0   | 0 | 0 |
prefix_lm_mask:
SOT | 1 1 1 0 0 0 |
ｱ   | 1 1 1 0 0 0 |
ｲ   | 1 1 1 0 0 0 |
SEG | 1 1 1 1 0 0 |
ｳ   | 1 1 1 1 1 0 |
ｴ   | 1 1 1 1 1 1 |</p></blockquote></blockquote>`,on,Z,Y,Gt,Ve,Gn,tt,ws="Spout Vector",rn,$e,Ss=`A Spout Vector is a special vector for controlling text generation.
This vector is treated as the first embedding in self-attention to bring extraneous attention to the generated tokens.
In the pre-trained model published from <code>Tanrei/GPTSAN-japanese</code>, the Spout Vector is a 128-dimensional vector that passes through 8 fully connected layers in the model and is projected into the space acting as external attention.
The Spout Vector projected by the fully connected layer is split to be passed to all self-attentions.`,ln,q,K,Vt,Fe,Vn,nt,Gs="GPTSanJapaneseConfig",pn,V,Re,$n,st,Vs=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.34.0/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseModel">GPTSanJapaneseModel</a>. It is used to instantiate
a GPTSANJapanese model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the GPTSANJapanese
<a href="https://huggingface.co/Tanrei/GPTSAN-japanese" rel="nofollow">Tanrei/GPTSAN-japanese</a> architecture.`,Fn,at,$s=`Configuration objects inherit from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,dn,B,ee,$t,Ne,Rn,ot,Fs="GPTSanJapaneseTokenizer",cn,v,Pe,Nn,rt,Rs="This tokenizer is based on GPTNeoXJapaneseTokenizer and has the following modifications",Pn,lt,Ns=`<li>Decoding byte0~byte255 tokens correctly</li> <li>Added bagofword token handling</li> <li>Return token_type_ids for Prefix-LM model
The bagofword token represents a repetition of the previous token and is converted to 3 consecutive tokens when
decoding In addition, the original Japanese special Sub-Word-Encoding has been released in this repository
(<a href="https://github.com/tanreinama/Japanese-BPEEncoder_V2" rel="nofollow">https://github.com/tanreinama/Japanese-BPEEncoder_V2</a>). The token_type_ids is a mask indicating the prefix input
position of the Prefix-LM model. To specify a prefix position, specify a prefix input for prefix_text, or specify a
sentence of the prefix part and the part after it as a text pair of batch input.</li>`,In,te,En,ne,zn,se,Qn,ae,Ie,Zn,it,Ps="Converts a sequence of tokens (string) in a single string.",qn,$,Ee,Bn,pt,Is=`The tokenizer returns token_type_ids as separators between the Prefix part and the rest.
token_type_ids is 1 for the Prefix part and 0 for the rest of the token.`,An,oe,mn,A,re,Ft,ze,Wn,dt,Es="GPTSanJapaneseModel",un,S,Qe,On,ct,zs="The bare GPTSAN-japanese Model transformer outputting raw hidden-states without any specific head on top.",Hn,mt,Qs=`The <a href="https://github.com/tanreinama/GPTSAN" rel="nofollow">GPTSAN-japanese</a> model was proposed in General-purpose Swich transformer
based Japanese language model`,Xn,ut,Zs=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ln,F,Ze,Dn,ht,qs='The <a href="/docs/transformers/v4.34.0/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseModel">GPTSanJapaneseModel</a> forward method, overrides the <code>__call__</code> special method.',Yn,le,hn,W,ie,Rt,qe,Kn,ft,Bs="GPTSanJapaneseForConditionalGeneration",fn,G,Be,es,gt,As="The bare GPTSAN-japanese Model with a language modeling head.",ts,_t,Ws=`The <a href="https://github.com/tanreinama/GPTSAN" rel="nofollow">GPTSAN-japanese</a> model was proposed in General-purpose Swich transformer
based Japanese language model`,ns,Tt,Os=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ss,k,Ae,as,yt,Hs='The <a href="/docs/transformers/v4.34.0/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseForConditionalGeneration">GPTSanJapaneseForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',os,pe,rs,Mt,Xs="Example:",ls,Jt,Ls="Text Generation with regular LM Model",is,de,ps,bt,Ds="Text Generation with Prefix-LM Model",ds,ce,cs,Ut,Ys="Simultaneously Text Generation And Masked Language Model",ms,me,gn,Nt,_n;return fe=new P({}),ge=new P({}),ye=new P({}),Je=new he({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUyQyUyMEF1dG9Ub2tlbml6ZXIlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlRhbnJlaSUyRkdQVFNBTi1qYXBhbmVzZSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyVGFucmVpJTJGR1BUU0FOLWphcGFuZXNlJTIyKS5jdWRhKCklMEF4X3RvayUyMCUzRCUyMHRva2VuaXplciglMjIlRTMlODElQUYlRTMlODAlODElMjIlMkMlMjBwcmVmaXhfdGV4dCUzRCUyMiVFNyVCOSU5NCVFNyU5NCVCMCVFNCVCRiVBMSVFOSU5NSVCNyUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBdG9yY2gubWFudWFsX3NlZWQoMCklMEFnZW5fdG9rJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoeF90b2suaW5wdXRfaWRzLmN1ZGEoKSUyQyUyMHRva2VuX3R5cGVfaWRzJTNEeF90b2sudG9rZW5fdHlwZV9pZHMuY3VkYSgpJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCklMEF0b2tlbml6ZXIuZGVjb2RlKGdlbl90b2slNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel, AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Tanrei/GPTSAN-japanese&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;Tanrei/GPTSAN-japanese&quot;</span>).cuda()
<span class="hljs-meta">&gt;&gt;&gt; </span>x_tok = tokenizer(<span class="hljs-string">&quot;は、&quot;</span>, prefix_text=<span class="hljs-string">&quot;織田信長&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tok = model.generate(x_tok.input_ids.cuda(), token_type_ids=x_tok.token_type_ids.cuda(), max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(gen_tok[<span class="hljs-number">0</span>])
<span class="hljs-string">&#x27;織田信長は、2004年に『戦国BASARA』のために、豊臣秀吉&#x27;</span>`,wrap:!1}}),be=new P({}),ke=new P({}),Ve=new P({}),Fe=new P({}),Re=new ue({props:{name:"class transformers.GPTSanJapaneseConfig",anchor:"transformers.GPTSanJapaneseConfig",parameters:[{name:"vocab_size",val:" = 36000"},{name:"max_position_embeddings",val:" = 1280"},{name:"d_model",val:" = 1024"},{name:"d_ff",val:" = 8192"},{name:"d_ext",val:" = 4096"},{name:"d_spout",val:" = 128"},{name:"num_switch_layers",val:" = 10"},{name:"num_ext_layers",val:" = 0"},{name:"num_heads",val:" = 16"},{name:"num_experts",val:" = 16"},{name:"expert_capacity",val:" = 128"},{name:"dropout_rate",val:" = 0.0"},{name:"layer_norm_epsilon",val:" = 1e-05"},{name:"router_bias",val:" = False"},{name:"router_jitter_noise",val:" = 0.0"},{name:"router_dtype",val:" = 'float32'"},{name:"router_ignore_padding_tokens",val:" = False"},{name:"output_hidden_states",val:" = False"},{name:"output_attentions",val:" = False"},{name:"initializer_factor",val:" = 0.002"},{name:"output_router_logits",val:" = False"},{name:"use_cache",val:" = True"},{name:"separator_token_id",val:" = 35998"},{name:"pad_token_id",val:" = 35995"},{name:"eos_token_id",val:" = 35999"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GPTSanJapaneseConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 36000) &#x2014;
Vocabulary size of the GPTSANJapanese model. Defines the number of different tokens that can be represented
by the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/v4.34.0/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseModel">GPTSanJapaneseModel</a>.`,name:"vocab_size"},{anchor:"transformers.GPTSanJapaneseConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 1280) &#x2014;
The maximum sequence length that this model might ever be used with. Defaults set this to 1280.`,name:"max_position_embeddings"},{anchor:"transformers.GPTSanJapaneseConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Size of the encoder layers and the pooler layer.`,name:"d_model"},{anchor:"transformers.GPTSanJapaneseConfig.d_ff",description:`<strong>d_ff</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
Size of the intermediate feed forward layer in each <code>SwitchTransformersBlock</code>.`,name:"d_ff"},{anchor:"transformers.GPTSanJapaneseConfig.d_ext",description:`<strong>d_ext</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Size of the intermediate feed forward layer in each Extra-layers.`,name:"d_ext"},{anchor:"transformers.GPTSanJapaneseConfig.d_spout",description:`<strong>d_spout</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Size of the <code>spout</code> vector.`,name:"d_spout"},{anchor:"transformers.GPTSanJapaneseConfig.num_switch_layers",description:`<strong>num_switch_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
Number of layers in the Switch Transformer layer.`,name:"num_switch_layers"},{anchor:"transformers.GPTSanJapaneseConfig.num_ext_layers",description:`<strong>num_ext_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Number of layers in the Extra-layers.`,name:"num_ext_layers"},{anchor:"transformers.GPTSanJapaneseConfig.num_heads",description:`<strong>num_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_heads"},{anchor:"transformers.GPTSanJapaneseConfig.num_experts",description:`<strong>num_experts</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of experts for each SwitchTransformer layer.`,name:"num_experts"},{anchor:"transformers.GPTSanJapaneseConfig.expert_capacity",description:`<strong>expert_capacity</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Number of tokens that can be stored in each expert. If set to 1, the model will behave like a regular
Transformer.`,name:"expert_capacity"},{anchor:"transformers.GPTSanJapaneseConfig.dropout_rate",description:`<strong>dropout_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The ratio for all dropout layers.`,name:"dropout_rate"},{anchor:"transformers.GPTSanJapaneseConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-5) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.GPTSanJapaneseConfig.router_bias",description:`<strong>router_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add a bias to the router.`,name:"router_bias"},{anchor:"transformers.GPTSanJapaneseConfig.router_jitter_noise",description:`<strong>router_jitter_noise</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Amount of noise to add to the router. Set it to 0.0 during prediction or set small value (usually 1e-2)
during training.`,name:"router_jitter_noise"},{anchor:"transformers.GPTSanJapaneseConfig.router_dtype",description:`<strong>router_dtype</strong> (<code>str</code>, <em>optional</em>, default to <code>&quot;float32&quot;</code>) &#x2014;
The <code>dtype</code> used for the routers. It is preferable to keep the <code>dtype</code> to <code>&quot;float32&quot;</code> as specified in the
<em>selective precision</em> discussion in <a href="https://arxiv.org/abs/2101.03961" rel="nofollow">the paper</a>.`,name:"router_dtype"},{anchor:"transformers.GPTSanJapaneseConfig.router_ignore_padding_tokens",description:`<strong>router_ignore_padding_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to ignore padding tokens when routing.`,name:"router_ignore_padding_tokens"},{anchor:"transformers.GPTSanJapaneseConfig.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, default to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.GPTSanJapaneseConfig.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers.`,name:"output_attentions"},{anchor:"transformers.GPTSanJapaneseConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.002) &#x2014;
A factor for initializing all weight matrices.`,name:"initializer_factor"},{anchor:"transformers.GPTSanJapaneseConfig.output_router_logits",description:`<strong>output_router_logits</strong> (<code>bool</code>, <em>optional</em>, default to <code>False</code>) &#x2014;
Whether or not to return the router logits of all experts.`,name:"output_router_logits"},{anchor:"transformers.GPTSanJapaneseConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models)`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/gptsan_japanese/configuration_gptsan_japanese.py#L29"}}),Ne=new P({}),Pe=new ue({props:{name:"class transformers.GPTSanJapaneseTokenizer",anchor:"transformers.GPTSanJapaneseTokenizer",parameters:[{name:"vocab_file",val:""},{name:"emoji_file",val:""},{name:"unk_token",val:" = '<|nottoken|>'"},{name:"pad_token",val:" = '<|separator|>'"},{name:"bos_token",val:" = '<|startoftext|>'"},{name:"eos_token",val:" = '<|endoftext|>'"},{name:"sep_token",val:" = '<|segmenter|>'"},{name:"do_clean_text",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GPTSanJapaneseTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
File containing the vocabulary.`,name:"vocab_file"},{anchor:"transformers.GPTSanJapaneseTokenizer.emoji_file",description:`<strong>emoji_file</strong> (<code>str</code>) &#x2014;
File containing the emoji.`,name:"emoji_file"},{anchor:"transformers.GPTSanJapaneseTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;|nottoken|&gt;&quot;</code>) &#x2014;
The token used for unknown charactor`,name:"unk_token"},{anchor:"transformers.GPTSanJapaneseTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;|separator|&gt;&quot;</code>) &#x2014;
The token used for padding`,name:"pad_token"},{anchor:"transformers.GPTSanJapaneseTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;|startoftext|&gt;&quot;&quot;</code>) &#x2014;
The beginning of sequence token.`,name:"bos_token"},{anchor:"transformers.GPTSanJapaneseTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;|endoftext|&gt;&quot;</code>) &#x2014;
The end of sequence token.`,name:"eos_token"},{anchor:"transformers.GPTSanJapaneseTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;|segmenter|&gt;&quot;</code>) &#x2014;
A special token to separate token to prefix part and general input part.`,name:"sep_token"},{anchor:"transformers.GPTSanJapaneseTokenizer.do_clean_text",description:`<strong>do_clean_text</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to clean text for URL, EMAIL, TEL, Japanese DATE and Japanese PRICE.`,name:"do_clean_text"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/gptsan_japanese/tokenization_gptsan_japanese.py#L74"}}),te=new Xe({props:{anchor:"transformers.GPTSanJapaneseTokenizer.example",$$slots:{default:[ya]},$$scope:{ctx:C}}}),ne=new Xe({props:{anchor:"transformers.GPTSanJapaneseTokenizer.example-2",$$slots:{default:[Ma]},$$scope:{ctx:C}}}),se=new Xe({props:{anchor:"transformers.GPTSanJapaneseTokenizer.example-3",$$slots:{default:[Ja]},$$scope:{ctx:C}}}),Ie=new ue({props:{name:"convert_tokens_to_string",anchor:"transformers.GPTSanJapaneseTokenizer.convert_tokens_to_string",parameters:[{name:"tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/gptsan_japanese/tokenization_gptsan_japanese.py#L219"}}),Ee=new ue({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.GPTSanJapaneseTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/gptsan_japanese/tokenization_gptsan_japanese.py#L302"}}),oe=new Xe({props:{anchor:"transformers.GPTSanJapaneseTokenizer.create_token_type_ids_from_sequences.example",$$slots:{default:[ba]},$$scope:{ctx:C}}}),ze=new P({}),Qe=new ue({props:{name:"class transformers.GPTSanJapaneseModel",anchor:"transformers.GPTSanJapaneseModel",parameters:[{name:"config",val:": GPTSanJapaneseConfig"}],parametersDescription:[{anchor:"transformers.GPTSanJapaneseModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseConfig">GPTSanJapaneseConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/gptsan_japanese/modeling_gptsan_japanese.py#L868"}}),Ze=new ue({props:{name:"forward",anchor:"transformers.GPTSanJapaneseModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.FloatTensor] = None"},{name:"spout",val:": typing.Optional[torch.FloatTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = False"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"output_router_logits",val:": typing.Optional[bool] = None"},{name:"num_precontext",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.GPTSanJapaneseModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. GPTSAN-japanese is a model that generates sentence
continuations or predicts tokens at mask positions. Special tokens required for inputs to the model are
automatically appended.`,name:"input_ids"},{anchor:"transformers.GPTSanJapaneseModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.GPTSanJapaneseModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
An input that masks the Prefix part in the Prefix-LM input. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>prefix</strong> input,</li>
<li>0 for tokens that are <strong>not-prefix</strong> input.</li>
</ul>`,name:"token_type_ids"},{anchor:"transformers.GPTSanJapaneseModel.forward.spout",description:`<strong>spout</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, config.d_spout)</code>) &#x2014;
This vector is transformed through an 8-layer FFN and can be used instead of <code>past_key_values</code>.`,name:"spout"},{anchor:"transformers.GPTSanJapaneseModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.GPTSanJapaneseModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:`,name:"head_mask"},{anchor:"transformers.GPTSanJapaneseModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.GPTSanJapaneseModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.GPTSanJapaneseModel.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.`,name:"decoder_inputs_embeds"},{anchor:"transformers.GPTSanJapaneseModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.GPTSanJapaneseModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.GPTSanJapaneseModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.GPTSanJapaneseModel.forward.router_logits",description:`<strong>router_logits</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_router_logits=True</code> is passed or when <code>config.add_router_probs=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, sequence_length, num_experts)</code>.
Router logits of the decoder model, useful to compute the auxiliary loss for Mixture of Experts models.`,name:"router_logits"},{anchor:"transformers.GPTSanJapaneseModel.forward.num_precontext",description:`<strong>num_precontext</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,1)</code>) &#x2014;
length of <code>hybrid</code> input tokens in the input. Tokens up to this length refer to both front and back like
BERT, tokens after that refer only to front like GPT. see also:
<a href="https://github.com/tanreinama/GPTSAN/blob/main/report/model.md" rel="nofollow">https://github.com/tanreinama/GPTSAN/blob/main/report/model.md</a>`,name:"num_precontext"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/gptsan_japanese/modeling_gptsan_japanese.py#L902",returnDescription:`
<p><code>MoEModelOutputWithPastAndCrossAttentions</code> or <code>tuple</code> if <code>return_dict</code> returns
MoEModelOutputWithPastAndCrossAttentions insted of tuple</p>
`}}),le=new ua({props:{$$slots:{default:[Ua]},$$scope:{ctx:C}}}),qe=new P({}),Be=new ue({props:{name:"class transformers.GPTSanJapaneseForConditionalGeneration",anchor:"transformers.GPTSanJapaneseForConditionalGeneration",parameters:[{name:"config",val:": GPTSanJapaneseConfig"}],parametersDescription:[{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseConfig">GPTSanJapaneseConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/gptsan_japanese/modeling_gptsan_japanese.py#L1113"}}),Ae=new ue({props:{name:"forward",anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.FloatTensor] = None"},{name:"spout",val:": typing.Optional[torch.FloatTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = False"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"output_router_logits",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. GPTSAN-japanese is a model that generates sentence
continuations or predicts tokens at mask positions. Special tokens required for inputs to the model are
automatically appended.`,name:"input_ids"},{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
An input that masks the Prefix part in the Prefix-LM input. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>prefix</strong> input,</li>
<li>0 for tokens that are <strong>not-prefix</strong> input.</li>
</ul>`,name:"token_type_ids"},{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.spout",description:`<strong>spout</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, config.d_spout)</code>) &#x2014;
This vector is transformed through an 8-layer FFN and can be used instead of <code>past_key_values</code>.`,name:"spout"},{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:`,name:"head_mask"},{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.`,name:"decoder_inputs_embeds"},{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.router_logits",description:`<strong>router_logits</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_router_logits=True</code> is passed or when <code>config.add_router_probs=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, sequence_length, num_experts)</code>.
Router logits of the decoder model, useful to compute the auxiliary loss for Mixture of Experts models.`,name:"router_logits"},{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification loss. Indices should be in <code>[-100, 0, ..., config.vocab_size - 1]</code>. All labels set to <code>-100</code> are ignored (masked), the loss is only computed for
labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/gptsan_japanese/modeling_gptsan_japanese.py#L1124",returnDescription:`
<p><code>MoECausalLMOutputWithPast</code> or <code>tuple</code> if <code>return_dict</code> returns MoECausalLMOutputWithPast insted of tuple</p>
`}}),pe=new ua({props:{$$slots:{default:[ka]},$$scope:{ctx:C}}}),de=new Xe({props:{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.example",$$slots:{default:[ja]},$$scope:{ctx:C}}}),ce=new Xe({props:{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.example-2",$$slots:{default:[va]},$$scope:{ctx:C}}}),me=new Xe({props:{anchor:"transformers.GPTSanJapaneseForConditionalGeneration.forward.example-3",$$slots:{default:[Ca]},$$scope:{ctx:C}}}),{c(){o=s("meta"),g=l(),d=s("p"),u=l(),U=s("h1"),p=s("a"),j=s("span"),_(fe.$$.fragment),vn=l(),Le=s("span"),Le.textContent=us,qt=l(),I=s("h2"),H=s("a"),Ct=s("span"),_(ge.$$.fragment),Cn=l(),De=s("span"),De.textContent=hs,Bt=l(),_e=s("p"),_e.textContent=fs,At=l(),Te=s("p"),Te.textContent=gs,Wt=l(),E=s("h3"),X=s("a"),xt=s("span"),_(ye.$$.fragment),xn=l(),Ye=s("span"),Ye.textContent=_s,Ot=l(),Me=s("p"),Me.innerHTML=Ts,Ht=l(),_(Je.$$.fragment),Xt=l(),z=s("h2"),L=s("a"),wt=s("span"),_(be.$$.fragment),wn=l(),Ke=s("span"),Ke.textContent=ys,Lt=l(),Ue=s("p"),Ue.textContent=Ms,Dt=l(),Q=s("h3"),D=s("a"),St=s("span"),_(ke.$$.fragment),Sn=l(),et=s("span"),et.textContent=Js,Yt=l(),je=s("p"),je.innerHTML=bs,Kt=l(),ve=s("p"),ve.textContent=Us,en=l(),Ce=s("p"),Ce.textContent=ks,tn=l(),xe=s("p"),xe.textContent=js,nn=l(),we=s("blockquote"),we.innerHTML=vs,sn=l(),Se=s("blockquote"),Se.innerHTML=Cs,an=l(),Ge=s("blockquote"),Ge.innerHTML=xs,on=l(),Z=s("h3"),Y=s("a"),Gt=s("span"),_(Ve.$$.fragment),Gn=l(),tt=s("span"),tt.textContent=ws,rn=l(),$e=s("p"),$e.innerHTML=Ss,ln=l(),q=s("h2"),K=s("a"),Vt=s("span"),_(Fe.$$.fragment),Vn=l(),nt=s("span"),nt.textContent=Gs,pn=l(),V=s("div"),_(Re.$$.fragment),$n=l(),st=s("p"),st.innerHTML=Vs,Fn=l(),at=s("p"),at.innerHTML=$s,dn=l(),B=s("h2"),ee=s("a"),$t=s("span"),_(Ne.$$.fragment),Rn=l(),ot=s("span"),ot.textContent=Fs,cn=l(),v=s("div"),_(Pe.$$.fragment),Nn=l(),rt=s("p"),rt.textContent=Rs,Pn=l(),lt=s("ul"),lt.innerHTML=Ns,In=l(),_(te.$$.fragment),En=l(),_(ne.$$.fragment),zn=l(),_(se.$$.fragment),Qn=l(),ae=s("div"),_(Ie.$$.fragment),Zn=l(),it=s("p"),it.textContent=Ps,qn=l(),$=s("div"),_(Ee.$$.fragment),Bn=l(),pt=s("p"),pt.textContent=Is,An=l(),_(oe.$$.fragment),mn=l(),A=s("h2"),re=s("a"),Ft=s("span"),_(ze.$$.fragment),Wn=l(),dt=s("span"),dt.textContent=Es,un=l(),S=s("div"),_(Qe.$$.fragment),On=l(),ct=s("p"),ct.textContent=zs,Hn=l(),mt=s("p"),mt.innerHTML=Qs,Xn=l(),ut=s("p"),ut.innerHTML=Zs,Ln=l(),F=s("div"),_(Ze.$$.fragment),Dn=l(),ht=s("p"),ht.innerHTML=qs,Yn=l(),_(le.$$.fragment),hn=l(),W=s("h2"),ie=s("a"),Rt=s("span"),_(qe.$$.fragment),Kn=l(),ft=s("span"),ft.textContent=Bs,fn=l(),G=s("div"),_(Be.$$.fragment),es=l(),gt=s("p"),gt.textContent=As,ts=l(),_t=s("p"),_t.innerHTML=Ws,ns=l(),Tt=s("p"),Tt.innerHTML=Os,ss=l(),k=s("div"),_(Ae.$$.fragment),as=l(),yt=s("p"),yt.innerHTML=Hs,os=l(),_(pe.$$.fragment),rs=l(),Mt=s("p"),Mt.textContent=Xs,ls=l(),Jt=s("p"),Jt.textContent=Ls,is=l(),_(de.$$.fragment),ps=l(),bt=s("p"),bt.textContent=Ds,ds=l(),_(ce.$$.fragment),cs=l(),Ut=s("p"),Ut.textContent=Ys,ms=l(),_(me.$$.fragment),gn=l(),Nt=s("p"),this.h()},l(e){const r=Ta("svelte-1phssyn",document.head);o=a(r,"META",{name:!0,content:!0}),r.forEach(t),g=i(e),d=a(e,"P",{}),f(d).forEach(t),u=i(e),U=a(e,"H1",{class:!0});var We=f(U);p=a(We,"A",{id:!0,class:!0,href:!0});var Pt=f(p);j=a(Pt,"SPAN",{});var It=f(j);T(fe.$$.fragment,It),It.forEach(t),Pt.forEach(t),vn=i(We),Le=a(We,"SPAN",{"data-svelte-h":!0}),h(Le)!=="svelte-huax6w"&&(Le.textContent=us),We.forEach(t),qt=i(e),I=a(e,"H2",{class:!0});var Oe=f(I);H=a(Oe,"A",{id:!0,class:!0,href:!0});var Et=f(H);Ct=a(Et,"SPAN",{});var zt=f(Ct);T(ge.$$.fragment,zt),zt.forEach(t),Et.forEach(t),Cn=i(Oe),De=a(Oe,"SPAN",{"data-svelte-h":!0}),h(De)!=="svelte-1jsw1pg"&&(De.textContent=hs),Oe.forEach(t),Bt=i(e),_e=a(e,"P",{"data-svelte-h":!0}),h(_e)!=="svelte-tknax7"&&(_e.textContent=fs),At=i(e),Te=a(e,"P",{"data-svelte-h":!0}),h(Te)!=="svelte-ydpvl8"&&(Te.textContent=gs),Wt=i(e),E=a(e,"H3",{class:!0});var He=f(E);X=a(He,"A",{id:!0,class:!0,href:!0});var Qt=f(X);xt=a(Qt,"SPAN",{});var Zt=f(xt);T(ye.$$.fragment,Zt),Zt.forEach(t),Qt.forEach(t),xn=i(He),Ye=a(He,"SPAN",{"data-svelte-h":!0}),h(Ye)!=="svelte-j76oon"&&(Ye.textContent=_s),He.forEach(t),Ot=i(e),Me=a(e,"P",{"data-svelte-h":!0}),h(Me)!=="svelte-1hxg3na"&&(Me.innerHTML=Ts),Ht=i(e),T(Je.$$.fragment,e),Xt=i(e),z=a(e,"H2",{class:!0});var Tn=f(z);L=a(Tn,"A",{id:!0,class:!0,href:!0});var Ks=f(L);wt=a(Ks,"SPAN",{});var ea=f(wt);T(be.$$.fragment,ea),ea.forEach(t),Ks.forEach(t),wn=i(Tn),Ke=a(Tn,"SPAN",{"data-svelte-h":!0}),h(Ke)!=="svelte-sk10gz"&&(Ke.textContent=ys),Tn.forEach(t),Lt=i(e),Ue=a(e,"P",{"data-svelte-h":!0}),h(Ue)!=="svelte-ertpqo"&&(Ue.textContent=Ms),Dt=i(e),Q=a(e,"H3",{class:!0});var yn=f(Q);D=a(yn,"A",{id:!0,class:!0,href:!0});var ta=f(D);St=a(ta,"SPAN",{});var na=f(St);T(ke.$$.fragment,na),na.forEach(t),ta.forEach(t),Sn=i(yn),et=a(yn,"SPAN",{"data-svelte-h":!0}),h(et)!=="svelte-1u5twdy"&&(et.textContent=Js),yn.forEach(t),Yt=i(e),je=a(e,"P",{"data-svelte-h":!0}),h(je)!=="svelte-1rqeshc"&&(je.innerHTML=bs),Kt=i(e),ve=a(e,"P",{"data-svelte-h":!0}),h(ve)!=="svelte-axv494"&&(ve.textContent=Us),en=i(e),Ce=a(e,"P",{"data-svelte-h":!0}),h(Ce)!=="svelte-1xag9tb"&&(Ce.textContent=ks),tn=i(e),xe=a(e,"P",{"data-svelte-h":!0}),h(xe)!=="svelte-1gl9mvz"&&(xe.textContent=js),nn=i(e),we=a(e,"BLOCKQUOTE",{"data-svelte-h":!0}),h(we)!=="svelte-4r9qjo"&&(we.innerHTML=vs),sn=i(e),Se=a(e,"BLOCKQUOTE",{"data-svelte-h":!0}),h(Se)!=="svelte-1qp1s1n"&&(Se.innerHTML=Cs),an=i(e),Ge=a(e,"BLOCKQUOTE",{"data-svelte-h":!0}),h(Ge)!=="svelte-1use4j"&&(Ge.innerHTML=xs),on=i(e),Z=a(e,"H3",{class:!0});var Mn=f(Z);Y=a(Mn,"A",{id:!0,class:!0,href:!0});var sa=f(Y);Gt=a(sa,"SPAN",{});var aa=f(Gt);T(Ve.$$.fragment,aa),aa.forEach(t),sa.forEach(t),Gn=i(Mn),tt=a(Mn,"SPAN",{"data-svelte-h":!0}),h(tt)!=="svelte-132f1rd"&&(tt.textContent=ws),Mn.forEach(t),rn=i(e),$e=a(e,"P",{"data-svelte-h":!0}),h($e)!=="svelte-4kiza2"&&($e.innerHTML=Ss),ln=i(e),q=a(e,"H2",{class:!0});var Jn=f(q);K=a(Jn,"A",{id:!0,class:!0,href:!0});var oa=f(K);Vt=a(oa,"SPAN",{});var ra=f(Vt);T(Fe.$$.fragment,ra),ra.forEach(t),oa.forEach(t),Vn=i(Jn),nt=a(Jn,"SPAN",{"data-svelte-h":!0}),h(nt)!=="svelte-rduk3x"&&(nt.textContent=Gs),Jn.forEach(t),pn=i(e),V=a(e,"DIV",{class:!0});var kt=f(V);T(Re.$$.fragment,kt),$n=i(kt),st=a(kt,"P",{"data-svelte-h":!0}),h(st)!=="svelte-ybvycy"&&(st.innerHTML=Vs),Fn=i(kt),at=a(kt,"P",{"data-svelte-h":!0}),h(at)!=="svelte-10kqkkl"&&(at.innerHTML=$s),kt.forEach(t),dn=i(e),B=a(e,"H2",{class:!0});var bn=f(B);ee=a(bn,"A",{id:!0,class:!0,href:!0});var la=f(ee);$t=a(la,"SPAN",{});var ia=f($t);T(Ne.$$.fragment,ia),ia.forEach(t),la.forEach(t),Rn=i(bn),ot=a(bn,"SPAN",{"data-svelte-h":!0}),h(ot)!=="svelte-85mi68"&&(ot.textContent=Fs),bn.forEach(t),cn=i(e),v=a(e,"DIV",{class:!0});var w=f(v);T(Pe.$$.fragment,w),Nn=i(w),rt=a(w,"P",{"data-svelte-h":!0}),h(rt)!=="svelte-1pkozbi"&&(rt.textContent=Rs),Pn=i(w),lt=a(w,"UL",{"data-svelte-h":!0}),h(lt)!=="svelte-12rov6i"&&(lt.innerHTML=Ns),In=i(w),T(te.$$.fragment,w),En=i(w),T(ne.$$.fragment,w),zn=i(w),T(se.$$.fragment,w),Qn=i(w),ae=a(w,"DIV",{class:!0});var Un=f(ae);T(Ie.$$.fragment,Un),Zn=i(Un),it=a(Un,"P",{"data-svelte-h":!0}),h(it)!=="svelte-b3k2yi"&&(it.textContent=Ps),Un.forEach(t),qn=i(w),$=a(w,"DIV",{class:!0});var jt=f($);T(Ee.$$.fragment,jt),Bn=i(jt),pt=a(jt,"P",{"data-svelte-h":!0}),h(pt)!=="svelte-btxjfp"&&(pt.textContent=Is),An=i(jt),T(oe.$$.fragment,jt),jt.forEach(t),w.forEach(t),mn=i(e),A=a(e,"H2",{class:!0});var kn=f(A);re=a(kn,"A",{id:!0,class:!0,href:!0});var pa=f(re);Ft=a(pa,"SPAN",{});var da=f(Ft);T(ze.$$.fragment,da),da.forEach(t),pa.forEach(t),Wn=i(kn),dt=a(kn,"SPAN",{"data-svelte-h":!0}),h(dt)!=="svelte-4r3wdc"&&(dt.textContent=Es),kn.forEach(t),un=i(e),S=a(e,"DIV",{class:!0});var R=f(S);T(Qe.$$.fragment,R),On=i(R),ct=a(R,"P",{"data-svelte-h":!0}),h(ct)!=="svelte-1jq56ze"&&(ct.textContent=zs),Hn=i(R),mt=a(R,"P",{"data-svelte-h":!0}),h(mt)!=="svelte-1sm4xoj"&&(mt.innerHTML=Qs),Xn=i(R),ut=a(R,"P",{"data-svelte-h":!0}),h(ut)!=="svelte-hswkmf"&&(ut.innerHTML=Zs),Ln=i(R),F=a(R,"DIV",{class:!0});var vt=f(F);T(Ze.$$.fragment,vt),Dn=i(vt),ht=a(vt,"P",{"data-svelte-h":!0}),h(ht)!=="svelte-afcj3k"&&(ht.innerHTML=qs),Yn=i(vt),T(le.$$.fragment,vt),vt.forEach(t),R.forEach(t),hn=i(e),W=a(e,"H2",{class:!0});var jn=f(W);ie=a(jn,"A",{id:!0,class:!0,href:!0});var ca=f(ie);Rt=a(ca,"SPAN",{});var ma=f(Rt);T(qe.$$.fragment,ma),ma.forEach(t),ca.forEach(t),Kn=i(jn),ft=a(jn,"SPAN",{"data-svelte-h":!0}),h(ft)!=="svelte-3np5qq"&&(ft.textContent=Bs),jn.forEach(t),fn=i(e),G=a(e,"DIV",{class:!0});var N=f(G);T(Be.$$.fragment,N),es=i(N),gt=a(N,"P",{"data-svelte-h":!0}),h(gt)!=="svelte-mgq95n"&&(gt.textContent=As),ts=i(N),_t=a(N,"P",{"data-svelte-h":!0}),h(_t)!=="svelte-1sm4xoj"&&(_t.innerHTML=Ws),ns=i(N),Tt=a(N,"P",{"data-svelte-h":!0}),h(Tt)!=="svelte-hswkmf"&&(Tt.innerHTML=Os),ss=i(N),k=a(N,"DIV",{class:!0});var x=f(k);T(Ae.$$.fragment,x),as=i(x),yt=a(x,"P",{"data-svelte-h":!0}),h(yt)!=="svelte-1exe5x6"&&(yt.innerHTML=Hs),os=i(x),T(pe.$$.fragment,x),rs=i(x),Mt=a(x,"P",{"data-svelte-h":!0}),h(Mt)!=="svelte-11lpom8"&&(Mt.textContent=Xs),ls=i(x),Jt=a(x,"P",{"data-svelte-h":!0}),h(Jt)!=="svelte-14d7hu9"&&(Jt.textContent=Ls),is=i(x),T(de.$$.fragment,x),ps=i(x),bt=a(x,"P",{"data-svelte-h":!0}),h(bt)!=="svelte-11j4hh0"&&(bt.textContent=Ds),ds=i(x),T(ce.$$.fragment,x),cs=i(x),Ut=a(x,"P",{"data-svelte-h":!0}),h(Ut)!=="svelte-t76udw"&&(Ut.textContent=Ys),ms=i(x),T(me.$$.fragment,x),x.forEach(t),N.forEach(t),gn=i(e),Nt=a(e,"P",{}),f(Nt).forEach(t),this.h()},h(){m(o,"name","hf:doc:metadata"),m(o,"content",JSON.stringify(wa)),m(p,"id","gptsanjapanese"),m(p,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(p,"href","#gptsanjapanese"),m(U,"class","relative group"),m(H,"id","overview"),m(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(H,"href","#overview"),m(I,"class","relative group"),m(X,"id","generation"),m(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(X,"href","#generation"),m(E,"class","relative group"),m(L,"id","gptsan-features"),m(L,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(L,"href","#gptsan-features"),m(z,"class","relative group"),m(D,"id","prefixlm-model"),m(D,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(D,"href","#prefixlm-model"),m(Q,"class","relative group"),m(Y,"id","spout-vector"),m(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(Y,"href","#spout-vector"),m(Z,"class","relative group"),m(K,"id","transformers.GPTSanJapaneseConfig"),m(K,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(K,"href","#transformers.GPTSanJapaneseConfig"),m(q,"class","relative group"),m(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(ee,"id","transformers.GPTSanJapaneseTokenizer"),m(ee,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(ee,"href","#transformers.GPTSanJapaneseTokenizer"),m(B,"class","relative group"),m(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(re,"id","transformers.GPTSanJapaneseModel"),m(re,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(re,"href","#transformers.GPTSanJapaneseModel"),m(A,"class","relative group"),m(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(ie,"id","transformers.GPTSanJapaneseForConditionalGeneration"),m(ie,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(ie,"href","#transformers.GPTSanJapaneseForConditionalGeneration"),m(W,"class","relative group"),m(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){n(document.head,o),c(e,g,r),c(e,d,r),c(e,u,r),c(e,U,r),n(U,p),n(p,j),y(fe,j,null),n(U,vn),n(U,Le),c(e,qt,r),c(e,I,r),n(I,H),n(H,Ct),y(ge,Ct,null),n(I,Cn),n(I,De),c(e,Bt,r),c(e,_e,r),c(e,At,r),c(e,Te,r),c(e,Wt,r),c(e,E,r),n(E,X),n(X,xt),y(ye,xt,null),n(E,xn),n(E,Ye),c(e,Ot,r),c(e,Me,r),c(e,Ht,r),y(Je,e,r),c(e,Xt,r),c(e,z,r),n(z,L),n(L,wt),y(be,wt,null),n(z,wn),n(z,Ke),c(e,Lt,r),c(e,Ue,r),c(e,Dt,r),c(e,Q,r),n(Q,D),n(D,St),y(ke,St,null),n(Q,Sn),n(Q,et),c(e,Yt,r),c(e,je,r),c(e,Kt,r),c(e,ve,r),c(e,en,r),c(e,Ce,r),c(e,tn,r),c(e,xe,r),c(e,nn,r),c(e,we,r),c(e,sn,r),c(e,Se,r),c(e,an,r),c(e,Ge,r),c(e,on,r),c(e,Z,r),n(Z,Y),n(Y,Gt),y(Ve,Gt,null),n(Z,Gn),n(Z,tt),c(e,rn,r),c(e,$e,r),c(e,ln,r),c(e,q,r),n(q,K),n(K,Vt),y(Fe,Vt,null),n(q,Vn),n(q,nt),c(e,pn,r),c(e,V,r),y(Re,V,null),n(V,$n),n(V,st),n(V,Fn),n(V,at),c(e,dn,r),c(e,B,r),n(B,ee),n(ee,$t),y(Ne,$t,null),n(B,Rn),n(B,ot),c(e,cn,r),c(e,v,r),y(Pe,v,null),n(v,Nn),n(v,rt),n(v,Pn),n(v,lt),n(v,In),y(te,v,null),n(v,En),y(ne,v,null),n(v,zn),y(se,v,null),n(v,Qn),n(v,ae),y(Ie,ae,null),n(ae,Zn),n(ae,it),n(v,qn),n(v,$),y(Ee,$,null),n($,Bn),n($,pt),n($,An),y(oe,$,null),c(e,mn,r),c(e,A,r),n(A,re),n(re,Ft),y(ze,Ft,null),n(A,Wn),n(A,dt),c(e,un,r),c(e,S,r),y(Qe,S,null),n(S,On),n(S,ct),n(S,Hn),n(S,mt),n(S,Xn),n(S,ut),n(S,Ln),n(S,F),y(Ze,F,null),n(F,Dn),n(F,ht),n(F,Yn),y(le,F,null),c(e,hn,r),c(e,W,r),n(W,ie),n(ie,Rt),y(qe,Rt,null),n(W,Kn),n(W,ft),c(e,fn,r),c(e,G,r),y(Be,G,null),n(G,es),n(G,gt),n(G,ts),n(G,_t),n(G,ns),n(G,Tt),n(G,ss),n(G,k),y(Ae,k,null),n(k,as),n(k,yt),n(k,os),y(pe,k,null),n(k,rs),n(k,Mt),n(k,ls),n(k,Jt),n(k,is),y(de,k,null),n(k,ps),n(k,bt),n(k,ds),y(ce,k,null),n(k,cs),n(k,Ut),n(k,ms),y(me,k,null),c(e,gn,r),c(e,Nt,r),_n=!0},p(e,[r]){const We={};r&2&&(We.$$scope={dirty:r,ctx:e}),te.$set(We);const Pt={};r&2&&(Pt.$$scope={dirty:r,ctx:e}),ne.$set(Pt);const It={};r&2&&(It.$$scope={dirty:r,ctx:e}),se.$set(It);const Oe={};r&2&&(Oe.$$scope={dirty:r,ctx:e}),oe.$set(Oe);const Et={};r&2&&(Et.$$scope={dirty:r,ctx:e}),le.$set(Et);const zt={};r&2&&(zt.$$scope={dirty:r,ctx:e}),pe.$set(zt);const He={};r&2&&(He.$$scope={dirty:r,ctx:e}),de.$set(He);const Qt={};r&2&&(Qt.$$scope={dirty:r,ctx:e}),ce.$set(Qt);const Zt={};r&2&&(Zt.$$scope={dirty:r,ctx:e}),me.$set(Zt)},i(e){_n||(M(fe.$$.fragment,e),M(ge.$$.fragment,e),M(ye.$$.fragment,e),M(Je.$$.fragment,e),M(be.$$.fragment,e),M(ke.$$.fragment,e),M(Ve.$$.fragment,e),M(Fe.$$.fragment,e),M(Re.$$.fragment,e),M(Ne.$$.fragment,e),M(Pe.$$.fragment,e),M(te.$$.fragment,e),M(ne.$$.fragment,e),M(se.$$.fragment,e),M(Ie.$$.fragment,e),M(Ee.$$.fragment,e),M(oe.$$.fragment,e),M(ze.$$.fragment,e),M(Qe.$$.fragment,e),M(Ze.$$.fragment,e),M(le.$$.fragment,e),M(qe.$$.fragment,e),M(Be.$$.fragment,e),M(Ae.$$.fragment,e),M(pe.$$.fragment,e),M(de.$$.fragment,e),M(ce.$$.fragment,e),M(me.$$.fragment,e),_n=!0)},o(e){J(fe.$$.fragment,e),J(ge.$$.fragment,e),J(ye.$$.fragment,e),J(Je.$$.fragment,e),J(be.$$.fragment,e),J(ke.$$.fragment,e),J(Ve.$$.fragment,e),J(Fe.$$.fragment,e),J(Re.$$.fragment,e),J(Ne.$$.fragment,e),J(Pe.$$.fragment,e),J(te.$$.fragment,e),J(ne.$$.fragment,e),J(se.$$.fragment,e),J(Ie.$$.fragment,e),J(Ee.$$.fragment,e),J(oe.$$.fragment,e),J(ze.$$.fragment,e),J(Qe.$$.fragment,e),J(Ze.$$.fragment,e),J(le.$$.fragment,e),J(qe.$$.fragment,e),J(Be.$$.fragment,e),J(Ae.$$.fragment,e),J(pe.$$.fragment,e),J(de.$$.fragment,e),J(ce.$$.fragment,e),J(me.$$.fragment,e),_n=!1},d(e){e&&(t(g),t(d),t(u),t(U),t(qt),t(I),t(Bt),t(_e),t(At),t(Te),t(Wt),t(E),t(Ot),t(Me),t(Ht),t(Xt),t(z),t(Lt),t(Ue),t(Dt),t(Q),t(Yt),t(je),t(Kt),t(ve),t(en),t(Ce),t(tn),t(xe),t(nn),t(we),t(sn),t(Se),t(an),t(Ge),t(on),t(Z),t(rn),t($e),t(ln),t(q),t(pn),t(V),t(dn),t(B),t(cn),t(v),t(mn),t(A),t(un),t(S),t(hn),t(W),t(fn),t(G),t(gn),t(Nt)),t(o),b(fe),b(ge),b(ye),b(Je,e),b(be),b(ke),b(Ve),b(Fe),b(Re),b(Ne),b(Pe),b(te),b(ne),b(se),b(Ie),b(Ee),b(oe),b(ze),b(Qe),b(Ze),b(le),b(qe),b(Be),b(Ae),b(pe),b(de),b(ce),b(me)}}}const wa={local:"gptsanjapanese",sections:[{local:"overview",sections:[{local:"generation",title:"Generation"}],title:"Overview"},{local:"gptsan-features",sections:[{local:"prefixlm-model",title:"Prefix-LM Model"},{local:"spout-vector",title:"Spout Vector"}],title:"GPTSAN Features"},{local:"transformers.GPTSanJapaneseConfig",title:"GPTSanJapaneseConfig"},{local:"transformers.GPTSanJapaneseTokenizer",title:"GPTSanJapaneseTokenizer"},{local:"transformers.GPTSanJapaneseModel",title:"GPTSanJapaneseModel"},{local:"transformers.GPTSanJapaneseForConditionalGeneration",title:"GPTSanJapaneseForConditionalGeneration"}],title:"GPTSAN-japanese"};function Sa(C){return fa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ia extends ga{constructor(o){super(),_a(this,o,Sa,xa,ha,{})}}export{Ia as component};
