import{s as xs,o as Rs,n as Wl}from"../chunks/scheduler.9bc65507.js";import{S as Xs,i as Ys,g as o,s as n,u as M,A as Es,h as i,f as l,c as a,j as J,v as d,y as r,k as p,o as f,a as s,w as m,d as y,t as h,x as u}from"../chunks/index.78c82d43.js";import{T as Nl}from"../chunks/Tip.87d55b76.js";import{I as et}from"../chunks/IconCopyLink.bedaa44d.js";import{C as T}from"../chunks/CodeBlock.73e038be.js";function Gs(Z){let c,j="If your model is very similar to a model inside the library, you can re-use the same configuration as this model.";return{c(){c=o("p"),c.textContent=j},l(w){c=i(w,"P",{"data-svelte-h":!0}),r(c)!=="svelte-alg4p1"&&(c.textContent=j)},m(w,b){s(w,c,b)},p:Wl,d(w){w&&l(c)}}}function Vs(Z){let c,j="This API is experimental and may have some slight breaking changes in the next releases.";return{c(){c=o("p"),c.textContent=j},l(w){c=i(w,"P",{"data-svelte-h":!0}),r(c)!=="svelte-15rpg4"&&(c.textContent=j)},m(w,b){s(w,c,b)},p:Wl,d(w){w&&l(c)}}}function Qs(Z){let c,j=`If copying a modeling files from the library, you will need to replace all the relative imports at the top of the file
to import from the <code>transformers</code> package.`;return{c(){c=o("p"),c.innerHTML=j},l(w){c=i(w,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1816fmc"&&(c.innerHTML=j)},m(w,b){s(w,c,b)},p:Wl,d(w){w&&l(c)}}}function Hs(Z){let c,j,w,b,U,A,tt,Y,_l,Pe,Bl="Sharing custom models",Mt,E,xl=`The 🤗 Transformers library is designed to be easily extensible. Every model is fully coded in a given subfolder
of the repository with no abstraction, so you can easily copy a modeling file and tweak it to your needs.`,dt,G,Rl=`If you are writing a brand new model, it might be easier to start from scratch. In this tutorial, we will show you
how to write a custom model and its configuration so it can be used inside Transformers, and how you can share it
with the community (with the code it relies on) so that anyone can use it, even if it’s not present in the 🤗
Transformers library.`,pt,V,Xl=`We will illustrate all of this on a ResNet model, by wrapping the ResNet class of the
<a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">timm library</a> into a <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>.`,mt,C,k,lt,Q,vl,Le,Yl="Writing a custom configuration",yt,H,El=`Before we dive into the model, let’s first write its configuration. The configuration of a model is an object that
will contain all the necessary information to build the model. As we will see in the next section, the model can only
take a <code>config</code> to be initialized, so we really need that object to be as complete as possible.`,ht,z,Gl=`In our example, we will take a couple of arguments of the ResNet class that we might want to tweak. Different
configurations will then give us the different types of ResNets that are possible. We then just store those arguments,
after checking the validity of a few of them.`,ut,F,ft,S,Vl="The three important things to remember when writing you own configuration are the following:",wt,P,Ql="<li>you have to inherit from <code>PretrainedConfig</code>,</li> <li>the <code>__init__</code> of your <code>PretrainedConfig</code> must accept any kwargs,</li> <li>those <code>kwargs</code> need to be passed to the superclass <code>__init__</code>.</li>",Jt,L,Hl=`The inheritance is to make sure you get all the functionality from the 🤗 Transformers library, while the two other
constraints come from the fact a <code>PretrainedConfig</code> has more fields than the ones you are setting. When reloading a
config with the <code>from_pretrained</code> method, those fields need to be accepted by your config and then sent to the
superclass.`,Tt,q,zl=`Defining a <code>model_type</code> for your configuration (here <code>model_type=&quot;resnet&quot;</code>) is not mandatory, unless you want to
register your model with the auto classes (see last section).`,jt,D,Fl=`With this done, you can easily create and save your configuration like you would do with any other model config of the
library. Here is how we can create a resnet50d config and save it:`,bt,K,Ut,O,Sl=`This will save a file named <code>config.json</code> inside the folder <code>custom-resnet</code>. You can then reload your config with the
<code>from_pretrained</code> method:`,Ct,ee,gt,te,Pl=`You can also use any other method of the <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> class, like <a href="/docs/transformers/v4.34.0/en/main_classes/processors#transformers.ProcessorMixin.push_to_hub">push_to_hub()</a> to
directly upload your config to the Hub.`,It,g,$,st,le,Zl,qe,Ll="Writing a custom model",_t,se,ql=`Now that we have our ResNet configuration, we can go on writing the model. We will actually write two: one that
extracts the hidden features from a batch of images (like <a href="/docs/transformers/v4.34.0/en/model_doc/bert#transformers.BertModel">BertModel</a>) and one that is suitable for image
classification (like <a href="/docs/transformers/v4.34.0/en/model_doc/bert#transformers.BertForSequenceClassification">BertForSequenceClassification</a>).`,vt,ne,Dl=`As we mentioned before, we’ll only write a loose wrapper of the model to keep it simple for this example. The only
thing we need to do before writing this class is a map between the block types and actual block classes. Then the
model is defined from the configuration by passing everything to the <code>ResNet</code> class:`,Zt,ae,At,oe,Kl="For the model that will classify images, we just change the forward method:",kt,ie,$t,re,Ol=`In both cases, notice how we inherit from <code>PreTrainedModel</code> and call the superclass initialization with the <code>config</code>
(a bit like when you write a regular <code>torch.nn.Module</code>). The line that sets the <code>config_class</code> is not mandatory, unless
you want to register your model with the auto classes (see last section).`,Nt,N,Wt,ce,es=`You can have your model return anything you want, but returning a dictionary like we did for
<code>ResnetModelForImageClassification</code>, with the loss included when labels are passed, will make your model directly
usable inside the <a href="/docs/transformers/v4.34.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> class. Using another output format is fine as long as you are planning on using your own
training loop or another library for training.`,Bt,Me,ts="Now that we have our model class, let’s create one:",xt,de,Rt,pe,ls=`Again, you can use any of the methods of <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>, like <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> or
<a href="/docs/transformers/v4.34.0/en/main_classes/processors#transformers.ProcessorMixin.push_to_hub">push_to_hub()</a>. We will use the second in the next section, and see how to push the model weights
with the code of our model. But first, let’s load some pretrained weights inside our model.`,Xt,me,ss=`In your own use case, you will probably be training your custom model on your own data. To go fast for this tutorial,
we will use the pretrained version of the resnet50d. Since our model is just a wrapper around it, it’s going to be
easy to transfer those weights:`,Yt,ye,Et,he,ns=`Now let’s see how to make sure that when we do <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> or <a href="/docs/transformers/v4.34.0/en/main_classes/processors#transformers.ProcessorMixin.push_to_hub">push_to_hub()</a>, the
code of the model is saved.`,Gt,I,W,nt,ue,Al,De,as="Sending the code to the Hub",Vt,B,Qt,fe,os=`First, make sure your model is fully defined in a <code>.py</code> file. It can rely on relative imports to some other files as
long as all the files are in the same directory (we don’t support submodules for this feature yet). For our example,
we’ll define a <code>modeling_resnet.py</code> file and a <code>configuration_resnet.py</code> file in a folder of the current working
directory named <code>resnet_model</code>. The configuration file contains the code for <code>ResnetConfig</code> and the modeling file
contains the code of <code>ResnetModel</code> and <code>ResnetModelForImageClassification</code>.`,Ht,we,zt,Je,is="The <code>__init__.py</code> can be empty, it’s just there so that Python detects <code>resnet_model</code> can be use as a module.",Ft,x,St,Te,rs="Note that you can re-use (or subclass) an existing configuration/model.",Pt,je,cs=`To share your model with the community, follow those steps: first import the ResNet model and config from the newly
created files:`,Lt,be,qt,Ue,Ms=`Then you have to tell the library you want to copy the code files of those objects when using the <code>save_pretrained</code>
method and properly register them with a given Auto class (especially for models), just run:`,Dt,Ce,Kt,ge,ds=`Note that there is no need to specify an auto class for the configuration (there is only one auto class for them,
<a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoConfig">AutoConfig</a>) but it’s different for models. Your custom model could be suitable for many different tasks, so you
have to specify which one of the auto classes is the correct one for your model.`,Ot,Ie,ps="Next, let’s create the config and models as we did before:",el,_e,tl,ve,ms="Now to send the model to the Hub, make sure you are logged in. Either run in your terminal:",ll,Ze,sl,Ae,ys="or from a notebook:",nl,ke,al,$e,hs="You can then push to your own namespace (or an organization you are a member of) like this:",ol,Ne,il,We,us=`On top of the modeling weights and the configuration in json format, this also copied the modeling and
configuration <code>.py</code> files in the folder <code>custom-resnet50d</code> and uploaded the result to the Hub. You can check the result
in this <a href="https://huggingface.co/sgugger/custom-resnet50d" rel="nofollow">model repo</a>.`,rl,Be,fs='See the <a href="model_sharing">sharing tutorial</a> for more information on the push to Hub method.',cl,_,R,at,xe,kl,Ke,ws="Using a model with custom code",Ml,Re,Js=`You can use any configuration, model or tokenizer with custom code files in its repository with the auto-classes and
the <code>from_pretrained</code> method. All files and code uploaded to the Hub are scanned for malware (refer to the <a href="https://huggingface.co/docs/hub/security#malware-scanning" rel="nofollow">Hub security</a> documentation for more information), but you should still
review the model code and author to avoid executing malicious code on your machine. Set <code>trust_remote_code=True</code> to use
a model with custom code:`,dl,Xe,pl,Ye,Ts=`It is also strongly encouraged to pass a commit hash as a <code>revision</code> to make sure the author of the models did not
update the code with some malicious new lines (unless you fully trust the authors of the models).`,ml,Ee,yl,Ge,js=`Note that when browsing the commit history of the model repo on the Hub, there is a button to easily copy the commit
hash of any commit.`,hl,v,X,ot,Ve,$l,Oe,bs="Registering a model with custom code to the auto classes",ul,Qe,Us=`If you are writing a library that extends 🤗 Transformers, you may want to extend the auto classes to include your own
model. This is different from pushing the code to the Hub in the sense that users will need to import your library to
get the custom models (contrarily to automatically downloading the model code from the Hub).`,fl,He,Cs=`As long as your config has a <code>model_type</code> attribute that is different from existing model types, and that your model
classes have the right <code>config_class</code> attributes, you can just add them to the auto classes like this:`,wl,ze,Jl,Fe,gs=`Note that the first argument used when registering your custom config to <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoConfig">AutoConfig</a> needs to match the <code>model_type</code>
of your custom config, and the first argument used when registering your custom models to any auto model class needs
to match the <code>config_class</code> of those models.`,Tl,it,jl;return Y=new et({}),Q=new et({}),F=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PretrainedConfig
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetConfig</span>(<span class="hljs-title class_ inherited__">PretrainedConfig</span>):
    model_type = <span class="hljs-string">&quot;resnet&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>,
        layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>] = [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">6</span>, <span class="hljs-number">3</span>],
        num_classes: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>,
        input_channels: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>,
        cardinality: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span>,
        base_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_type: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>,
        avg_down: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
        **kwargs,
    </span>):
        <span class="hljs-keyword">if</span> block_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;basic&quot;</span>, <span class="hljs-string">&quot;bottleneck&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`block_type\` must be &#x27;basic&#x27; or bottleneck&#x27;, got <span class="hljs-subst">{block_type}</span>.&quot;</span>)
        <span class="hljs-keyword">if</span> stem_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;deep&quot;</span>, <span class="hljs-string">&quot;deep-tiered&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`stem_type\` must be &#x27;&#x27;, &#x27;deep&#x27; or &#x27;deep-tiered&#x27;, got <span class="hljs-subst">{stem_type}</span>.&quot;</span>)

        self.block_type = block_type
        self.layers = layers
        self.num_classes = num_classes
        self.input_channels = input_channels
        self.cardinality = cardinality
        self.base_width = base_width
        self.stem_width = stem_width
        self.stem_type = stem_type
        self.avg_down = avg_down
        <span class="hljs-built_in">super</span>().__init__(**kwargs)`,wrap:!1}}),K=new T({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d_config.save_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)`,wrap:!1}}),ee=new T({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:'resnet50d_config = ResnetConfig.from_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)',wrap:!1}}),le=new et({}),ae=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjB0aW1tLm1vZGVscy5yZXNuZXQlMjBpbXBvcnQlMjBCYXNpY0Jsb2NrJTJDJTIwQm90dGxlbmVjayUyQyUyMFJlc05ldCUwQWZyb20lMjAuY29uZmlndXJhdGlvbl9yZXNuZXQlMjBpbXBvcnQlMjBSZXNuZXRDb25maWclMEElMEElMEFCTE9DS19NQVBQSU5HJTIwJTNEJTIwJTdCJTIyYmFzaWMlMjIlM0ElMjBCYXNpY0Jsb2NrJTJDJTIwJTIyYm90dGxlbmVjayUyMiUzQSUyMEJvdHRsZW5lY2slN0QlMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBSZXNuZXRDb25maWclMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX2xheWVyJTIwJTNEJTIwQkxPQ0tfTUFQUElORyU1QmNvbmZpZy5ibG9ja190eXBlJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbCUyMCUzRCUyMFJlc05ldCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZy5sYXllcnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fY2xhc3NlcyUzRGNvbmZpZy5udW1fY2xhc3NlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5zJTNEY29uZmlnLmlucHV0X2NoYW5uZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FyZGluYWxpdHklM0Rjb25maWcuY2FyZGluYWxpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXNlX3dpZHRoJTNEY29uZmlnLmJhc2Vfd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3dpZHRoJTNEY29uZmlnLnN0ZW1fd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3R5cGUlM0Rjb25maWcuc3RlbV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXZnX2Rvd24lM0Rjb25maWcuYXZnX2Rvd24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubW9kZWwuZm9yd2FyZF9mZWF0dXJlcyh0ZW5zb3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> timm.models.resnet <span class="hljs-keyword">import</span> BasicBlock, Bottleneck, ResNet
<span class="hljs-keyword">from</span> .configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig


BLOCK_MAPPING = {<span class="hljs-string">&quot;basic&quot;</span>: BasicBlock, <span class="hljs-string">&quot;bottleneck&quot;</span>: Bottleneck}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor</span>):
        <span class="hljs-keyword">return</span> self.model.forward_features(tensor)`,wrap:!1}}),ie=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihQcmVUcmFpbmVkTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnX2NsYXNzJTIwJTNEJTIwUmVzbmV0Q29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyMCUzRCUyMEJMT0NLX01BUFBJTkclNUJjb25maWcuYmxvY2tfdHlwZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBSZXNOZXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfbGF5ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcubGF5ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2NsYXNzZXMlM0Rjb25maWcubnVtX2NsYXNzZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbl9jaGFucyUzRGNvbmZpZy5pbnB1dF9jaGFubmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRpbmFsaXR5JTNEY29uZmlnLmNhcmRpbmFsaXR5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmFzZV93aWR0aCUzRGNvbmZpZy5iYXNlX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV93aWR0aCUzRGNvbmZpZy5zdGVtX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV90eXBlJTNEY29uZmlnLnN0ZW1fdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2Z19kb3duJTNEY29uZmlnLmF2Z19kb3duJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHRlbnNvciUyQyUyMGxhYmVscyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwc2VsZi5tb2RlbCh0ZW5zb3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsYWJlbHMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwdG9yY2gubm4uY3Jvc3NfZW50cm9weShsb2dpdHMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybG9zcyUyMiUzQSUyMGxvc3MlMkMlMjAlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0Q=",highlighted:`<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModelForImageClassification</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor, labels=<span class="hljs-literal">None</span></span>):
        logits = self.model(tensor)
        <span class="hljs-keyword">if</span> labels <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            loss = torch.nn.cross_entropy(logits, labels)
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;loss&quot;</span>: loss, <span class="hljs-string">&quot;logits&quot;</span>: logits}
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),N=new Nl({props:{$$slots:{default:[Gs]},$$scope:{ctx:Z}}}),de=new T({props:{code:"cmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcp",highlighted:"resnet50d = ResnetModelForImageClassification(resnet50d_config)",wrap:!1}}),ye=new T({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQXByZXRyYWluZWRfbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFyZXNuZXQ1MGQubW9kZWwubG9hZF9zdGF0ZV9kaWN0KHByZXRyYWluZWRfbW9kZWwuc3RhdGVfZGljdCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),ue=new et({}),B=new Nl({props:{warning:!0,$$slots:{default:[Vs]},$$scope:{ctx:Z}}}),we=new T({props:{code:"LiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHJlc25ldF9tb2RlbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlndXJhdGlvbl9yZXNuZXQucHklMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbGluZ19yZXNuZXQucHk=",highlighted:`.
└── resnet_model
    ├── __init__.<span class="hljs-keyword">py</span>
    ├── configuration_resnet.<span class="hljs-keyword">py</span>
    └── modeling_resnet.<span class="hljs-keyword">py</span>`,wrap:!1}}),x=new Nl({props:{warning:!0,$$slots:{default:[Qs]},$$scope:{ctx:Z}}}),be=new T({props:{code:"ZnJvbSUyMHJlc25ldF9tb2RlbC5jb25maWd1cmF0aW9uX3Jlc25ldCUyMGltcG9ydCUyMFJlc25ldENvbmZpZyUwQWZyb20lMjByZXNuZXRfbW9kZWwubW9kZWxpbmdfcmVzbmV0JTIwaW1wb3J0JTIwUmVzbmV0TW9kZWwlMkMlMjBSZXNuZXRNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24=",highlighted:`<span class="hljs-keyword">from</span> resnet_model.configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig
<span class="hljs-keyword">from</span> resnet_model.modeling_resnet <span class="hljs-keyword">import</span> ResnetModel, ResnetModelForImageClassification`,wrap:!1}}),Ce=new T({props:{code:"UmVzbmV0Q29uZmlnLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCklMEFSZXNuZXRNb2RlbC5yZWdpc3Rlcl9mb3JfYXV0b19jbGFzcyglMjJBdXRvTW9kZWwlMjIpJTBBUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCUyMkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMjIp",highlighted:`ResnetConfig.register_for_auto_class()
ResnetModel.register_for_auto_class(<span class="hljs-string">&quot;AutoModel&quot;</span>)
ResnetModelForImageClassification.register_for_auto_class(<span class="hljs-string">&quot;AutoModelForImageClassification&quot;</span>)`,wrap:!1}}),_e=new T({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcpJTBBJTBBcHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXJlc25ldDUwZC5tb2RlbC5sb2FkX3N0YXRlX2RpY3QocHJldHJhaW5lZF9tb2RlbC5zdGF0ZV9kaWN0KCkp",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d = ResnetModelForImageClassification(resnet50d_config)

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),Ze=new T({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),ke=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),Ne=new T({props:{code:"cmVzbmV0NTBkLnB1c2hfdG9faHViKCUyMmN1c3RvbS1yZXNuZXQ1MGQlMjIp",highlighted:'resnet50d.push_to_hub(<span class="hljs-string">&quot;custom-resnet50d&quot;</span>)',wrap:!1}}),xe=new et({}),Xe=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNndWdnZXIlMkZjdXN0b20tcmVzbmV0NTBkJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),Ee=new T({props:{code:"Y29tbWl0X2hhc2glMjAlM0QlMjAlMjJlZDk0YTdjNjI0N2Q4YWVkY2U0NjQ3ZjAwZjIwZGU2ODc1YjViMjkyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzZ3VnZ2VyJTJGY3VzdG9tLXJlc25ldDUwZCUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUyMHJldmlzaW9uJTNEY29tbWl0X2hhc2glMEEp",highlighted:`commit_hash = <span class="hljs-string">&quot;ed94a7c6247d8aedce4647f00f20de6875b5b292&quot;</span>
model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, revision=commit_hash
)`,wrap:!1}}),Ve=new et({}),ze=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBQXV0b0NvbmZpZy5yZWdpc3RlciglMjJyZXNuZXQlMjIlMkMlMjBSZXNuZXRDb25maWcpJTBBQXV0b01vZGVsLnJlZ2lzdGVyKFJlc25ldENvbmZpZyUyQyUyMFJlc25ldE1vZGVsKSUwQUF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24ucmVnaXN0ZXIoUmVzbmV0Q29uZmlnJTJDJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel, AutoModelForImageClassification

AutoConfig.register(<span class="hljs-string">&quot;resnet&quot;</span>, ResnetConfig)
AutoModel.register(ResnetConfig, ResnetModel)
AutoModelForImageClassification.register(ResnetConfig, ResnetModelForImageClassification)`,wrap:!1}}),{c(){c=o("meta"),j=n(),w=o("p"),b=n(),U=o("h1"),A=o("a"),tt=o("span"),M(Y.$$.fragment),_l=n(),Pe=o("span"),Pe.textContent=Bl,Mt=n(),E=o("p"),E.textContent=xl,dt=n(),G=o("p"),G.textContent=Rl,pt=n(),V=o("p"),V.innerHTML=Xl,mt=n(),C=o("h2"),k=o("a"),lt=o("span"),M(Q.$$.fragment),vl=n(),Le=o("span"),Le.textContent=Yl,yt=n(),H=o("p"),H.innerHTML=El,ht=n(),z=o("p"),z.textContent=Gl,ut=n(),M(F.$$.fragment),ft=n(),S=o("p"),S.textContent=Vl,wt=n(),P=o("ul"),P.innerHTML=Ql,Jt=n(),L=o("p"),L.innerHTML=Hl,Tt=n(),q=o("p"),q.innerHTML=zl,jt=n(),D=o("p"),D.textContent=Fl,bt=n(),M(K.$$.fragment),Ut=n(),O=o("p"),O.innerHTML=Sl,Ct=n(),M(ee.$$.fragment),gt=n(),te=o("p"),te.innerHTML=Pl,It=n(),g=o("h2"),$=o("a"),st=o("span"),M(le.$$.fragment),Zl=n(),qe=o("span"),qe.textContent=Ll,_t=n(),se=o("p"),se.innerHTML=ql,vt=n(),ne=o("p"),ne.innerHTML=Dl,Zt=n(),M(ae.$$.fragment),At=n(),oe=o("p"),oe.textContent=Kl,kt=n(),M(ie.$$.fragment),$t=n(),re=o("p"),re.innerHTML=Ol,Nt=n(),M(N.$$.fragment),Wt=n(),ce=o("p"),ce.innerHTML=es,Bt=n(),Me=o("p"),Me.textContent=ts,xt=n(),M(de.$$.fragment),Rt=n(),pe=o("p"),pe.innerHTML=ls,Xt=n(),me=o("p"),me.textContent=ss,Yt=n(),M(ye.$$.fragment),Et=n(),he=o("p"),he.innerHTML=ns,Gt=n(),I=o("h2"),W=o("a"),nt=o("span"),M(ue.$$.fragment),Al=n(),De=o("span"),De.textContent=as,Vt=n(),M(B.$$.fragment),Qt=n(),fe=o("p"),fe.innerHTML=os,Ht=n(),M(we.$$.fragment),zt=n(),Je=o("p"),Je.innerHTML=is,Ft=n(),M(x.$$.fragment),St=n(),Te=o("p"),Te.textContent=rs,Pt=n(),je=o("p"),je.textContent=cs,Lt=n(),M(be.$$.fragment),qt=n(),Ue=o("p"),Ue.innerHTML=Ms,Dt=n(),M(Ce.$$.fragment),Kt=n(),ge=o("p"),ge.innerHTML=ds,Ot=n(),Ie=o("p"),Ie.textContent=ps,el=n(),M(_e.$$.fragment),tl=n(),ve=o("p"),ve.textContent=ms,ll=n(),M(Ze.$$.fragment),sl=n(),Ae=o("p"),Ae.textContent=ys,nl=n(),M(ke.$$.fragment),al=n(),$e=o("p"),$e.textContent=hs,ol=n(),M(Ne.$$.fragment),il=n(),We=o("p"),We.innerHTML=us,rl=n(),Be=o("p"),Be.innerHTML=fs,cl=n(),_=o("h2"),R=o("a"),at=o("span"),M(xe.$$.fragment),kl=n(),Ke=o("span"),Ke.textContent=ws,Ml=n(),Re=o("p"),Re.innerHTML=Js,dl=n(),M(Xe.$$.fragment),pl=n(),Ye=o("p"),Ye.innerHTML=Ts,ml=n(),M(Ee.$$.fragment),yl=n(),Ge=o("p"),Ge.textContent=js,hl=n(),v=o("h2"),X=o("a"),ot=o("span"),M(Ve.$$.fragment),$l=n(),Oe=o("span"),Oe.textContent=bs,ul=n(),Qe=o("p"),Qe.textContent=Us,fl=n(),He=o("p"),He.innerHTML=Cs,wl=n(),M(ze.$$.fragment),Jl=n(),Fe=o("p"),Fe.innerHTML=gs,Tl=n(),it=o("p"),this.h()},l(e){const t=Es("svelte-1phssyn",document.head);c=i(t,"META",{name:!0,content:!0}),t.forEach(l),j=a(e),w=i(e,"P",{}),J(w).forEach(l),b=a(e),U=i(e,"H1",{class:!0});var Se=J(U);A=i(Se,"A",{id:!0,class:!0,href:!0});var rt=J(A);tt=i(rt,"SPAN",{});var ct=J(tt);d(Y.$$.fragment,ct),ct.forEach(l),rt.forEach(l),_l=a(Se),Pe=i(Se,"SPAN",{"data-svelte-h":!0}),r(Pe)!=="svelte-1wllo48"&&(Pe.textContent=Bl),Se.forEach(l),Mt=a(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1bvx2nz"&&(E.textContent=xl),dt=a(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-t7mxg8"&&(G.textContent=Rl),pt=a(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-akqot2"&&(V.innerHTML=Xl),mt=a(e),C=i(e,"H2",{class:!0});var bl=J(C);k=i(bl,"A",{id:!0,class:!0,href:!0});var Is=J(k);lt=i(Is,"SPAN",{});var _s=J(lt);d(Q.$$.fragment,_s),_s.forEach(l),Is.forEach(l),vl=a(bl),Le=i(bl,"SPAN",{"data-svelte-h":!0}),r(Le)!=="svelte-1sg72yp"&&(Le.textContent=Yl),bl.forEach(l),yt=a(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-15o85x"&&(H.innerHTML=El),ht=a(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1u8fbq1"&&(z.textContent=Gl),ut=a(e),d(F.$$.fragment,e),ft=a(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-9tm0xv"&&(S.textContent=Vl),wt=a(e),P=i(e,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-1l985bz"&&(P.innerHTML=Ql),Jt=a(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-ttxucl"&&(L.innerHTML=Hl),Tt=a(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-9uxjnq"&&(q.innerHTML=zl),jt=a(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1229zpx"&&(D.textContent=Fl),bt=a(e),d(K.$$.fragment,e),Ut=a(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1hshoid"&&(O.innerHTML=Sl),Ct=a(e),d(ee.$$.fragment,e),gt=a(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1tfebe2"&&(te.innerHTML=Pl),It=a(e),g=i(e,"H2",{class:!0});var Ul=J(g);$=i(Ul,"A",{id:!0,class:!0,href:!0});var vs=J($);st=i(vs,"SPAN",{});var Zs=J(st);d(le.$$.fragment,Zs),Zs.forEach(l),vs.forEach(l),Zl=a(Ul),qe=i(Ul,"SPAN",{"data-svelte-h":!0}),r(qe)!=="svelte-1gc1mjg"&&(qe.textContent=Ll),Ul.forEach(l),_t=a(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-9tpdyn"&&(se.innerHTML=ql),vt=a(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-13oyc7x"&&(ne.innerHTML=Dl),Zt=a(e),d(ae.$$.fragment,e),At=a(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-85b6xb"&&(oe.textContent=Kl),kt=a(e),d(ie.$$.fragment,e),$t=a(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1vktyut"&&(re.innerHTML=Ol),Nt=a(e),d(N.$$.fragment,e),Wt=a(e),ce=i(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1lt8xi7"&&(ce.innerHTML=es),Bt=a(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-zsjn9b"&&(Me.textContent=ts),xt=a(e),d(de.$$.fragment,e),Rt=a(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-boikgb"&&(pe.innerHTML=ls),Xt=a(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-kn8bw1"&&(me.textContent=ss),Yt=a(e),d(ye.$$.fragment,e),Et=a(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-e7i5w5"&&(he.innerHTML=ns),Gt=a(e),I=i(e,"H2",{class:!0});var Cl=J(I);W=i(Cl,"A",{id:!0,class:!0,href:!0});var As=J(W);nt=i(As,"SPAN",{});var ks=J(nt);d(ue.$$.fragment,ks),ks.forEach(l),As.forEach(l),Al=a(Cl),De=i(Cl,"SPAN",{"data-svelte-h":!0}),r(De)!=="svelte-1vucxq0"&&(De.textContent=as),Cl.forEach(l),Vt=a(e),d(B.$$.fragment,e),Qt=a(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-w79o0g"&&(fe.innerHTML=os),Ht=a(e),d(we.$$.fragment,e),zt=a(e),Je=i(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1orsl60"&&(Je.innerHTML=is),Ft=a(e),d(x.$$.fragment,e),St=a(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-miae0j"&&(Te.textContent=rs),Pt=a(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1kyhtnz"&&(je.textContent=cs),Lt=a(e),d(be.$$.fragment,e),qt=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1ce24vd"&&(Ue.innerHTML=Ms),Dt=a(e),d(Ce.$$.fragment,e),Kt=a(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1neg8ot"&&(ge.innerHTML=ds),Ot=a(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-19txhag"&&(Ie.textContent=ps),el=a(e),d(_e.$$.fragment,e),tl=a(e),ve=i(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1w2dqml"&&(ve.textContent=ms),ll=a(e),d(Ze.$$.fragment,e),sl=a(e),Ae=i(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-11lw65d"&&(Ae.textContent=ys),nl=a(e),d(ke.$$.fragment,e),al=a(e),$e=i(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1c2397x"&&($e.textContent=hs),ol=a(e),d(Ne.$$.fragment,e),il=a(e),We=i(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-djed3h"&&(We.innerHTML=us),rl=a(e),Be=i(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1sdq6eg"&&(Be.innerHTML=fs),cl=a(e),_=i(e,"H2",{class:!0});var gl=J(_);R=i(gl,"A",{id:!0,class:!0,href:!0});var $s=J(R);at=i($s,"SPAN",{});var Ns=J(at);d(xe.$$.fragment,Ns),Ns.forEach(l),$s.forEach(l),kl=a(gl),Ke=i(gl,"SPAN",{"data-svelte-h":!0}),r(Ke)!=="svelte-273es3"&&(Ke.textContent=ws),gl.forEach(l),Ml=a(e),Re=i(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-nao5c0"&&(Re.innerHTML=Js),dl=a(e),d(Xe.$$.fragment,e),pl=a(e),Ye=i(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1i8vto1"&&(Ye.innerHTML=Ts),ml=a(e),d(Ee.$$.fragment,e),yl=a(e),Ge=i(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1y2zx54"&&(Ge.textContent=js),hl=a(e),v=i(e,"H2",{class:!0});var Il=J(v);X=i(Il,"A",{id:!0,class:!0,href:!0});var Ws=J(X);ot=i(Ws,"SPAN",{});var Bs=J(ot);d(Ve.$$.fragment,Bs),Bs.forEach(l),Ws.forEach(l),$l=a(Il),Oe=i(Il,"SPAN",{"data-svelte-h":!0}),r(Oe)!=="svelte-1vgczqf"&&(Oe.textContent=bs),Il.forEach(l),ul=a(e),Qe=i(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-bccbz6"&&(Qe.textContent=Us),fl=a(e),He=i(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-uijzdg"&&(He.innerHTML=Cs),wl=a(e),d(ze.$$.fragment,e),Jl=a(e),Fe=i(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-p4fyik"&&(Fe.innerHTML=gs),Tl=a(e),it=i(e,"P",{}),J(it).forEach(l),this.h()},h(){p(c,"name","hf:doc:metadata"),p(c,"content",JSON.stringify(zs)),p(A,"id","sharing-custom-models"),p(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(A,"href","#sharing-custom-models"),p(U,"class","relative group"),p(k,"id","writing-a-custom-configuration"),p(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(k,"href","#writing-a-custom-configuration"),p(C,"class","relative group"),p($,"id","writing-a-custom-model"),p($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p($,"href","#writing-a-custom-model"),p(g,"class","relative group"),p(W,"id","sending-the-code-to-the-hub"),p(W,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(W,"href","#sending-the-code-to-the-hub"),p(I,"class","relative group"),p(R,"id","using-a-model-with-custom-code"),p(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(R,"href","#using-a-model-with-custom-code"),p(_,"class","relative group"),p(X,"id","registering-a-model-with-custom-code-to-the-auto-classes"),p(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(X,"href","#registering-a-model-with-custom-code-to-the-auto-classes"),p(v,"class","relative group")},m(e,t){f(document.head,c),s(e,j,t),s(e,w,t),s(e,b,t),s(e,U,t),f(U,A),f(A,tt),m(Y,tt,null),f(U,_l),f(U,Pe),s(e,Mt,t),s(e,E,t),s(e,dt,t),s(e,G,t),s(e,pt,t),s(e,V,t),s(e,mt,t),s(e,C,t),f(C,k),f(k,lt),m(Q,lt,null),f(C,vl),f(C,Le),s(e,yt,t),s(e,H,t),s(e,ht,t),s(e,z,t),s(e,ut,t),m(F,e,t),s(e,ft,t),s(e,S,t),s(e,wt,t),s(e,P,t),s(e,Jt,t),s(e,L,t),s(e,Tt,t),s(e,q,t),s(e,jt,t),s(e,D,t),s(e,bt,t),m(K,e,t),s(e,Ut,t),s(e,O,t),s(e,Ct,t),m(ee,e,t),s(e,gt,t),s(e,te,t),s(e,It,t),s(e,g,t),f(g,$),f($,st),m(le,st,null),f(g,Zl),f(g,qe),s(e,_t,t),s(e,se,t),s(e,vt,t),s(e,ne,t),s(e,Zt,t),m(ae,e,t),s(e,At,t),s(e,oe,t),s(e,kt,t),m(ie,e,t),s(e,$t,t),s(e,re,t),s(e,Nt,t),m(N,e,t),s(e,Wt,t),s(e,ce,t),s(e,Bt,t),s(e,Me,t),s(e,xt,t),m(de,e,t),s(e,Rt,t),s(e,pe,t),s(e,Xt,t),s(e,me,t),s(e,Yt,t),m(ye,e,t),s(e,Et,t),s(e,he,t),s(e,Gt,t),s(e,I,t),f(I,W),f(W,nt),m(ue,nt,null),f(I,Al),f(I,De),s(e,Vt,t),m(B,e,t),s(e,Qt,t),s(e,fe,t),s(e,Ht,t),m(we,e,t),s(e,zt,t),s(e,Je,t),s(e,Ft,t),m(x,e,t),s(e,St,t),s(e,Te,t),s(e,Pt,t),s(e,je,t),s(e,Lt,t),m(be,e,t),s(e,qt,t),s(e,Ue,t),s(e,Dt,t),m(Ce,e,t),s(e,Kt,t),s(e,ge,t),s(e,Ot,t),s(e,Ie,t),s(e,el,t),m(_e,e,t),s(e,tl,t),s(e,ve,t),s(e,ll,t),m(Ze,e,t),s(e,sl,t),s(e,Ae,t),s(e,nl,t),m(ke,e,t),s(e,al,t),s(e,$e,t),s(e,ol,t),m(Ne,e,t),s(e,il,t),s(e,We,t),s(e,rl,t),s(e,Be,t),s(e,cl,t),s(e,_,t),f(_,R),f(R,at),m(xe,at,null),f(_,kl),f(_,Ke),s(e,Ml,t),s(e,Re,t),s(e,dl,t),m(Xe,e,t),s(e,pl,t),s(e,Ye,t),s(e,ml,t),m(Ee,e,t),s(e,yl,t),s(e,Ge,t),s(e,hl,t),s(e,v,t),f(v,X),f(X,ot),m(Ve,ot,null),f(v,$l),f(v,Oe),s(e,ul,t),s(e,Qe,t),s(e,fl,t),s(e,He,t),s(e,wl,t),m(ze,e,t),s(e,Jl,t),s(e,Fe,t),s(e,Tl,t),s(e,it,t),jl=!0},p(e,[t]){const Se={};t&2&&(Se.$$scope={dirty:t,ctx:e}),N.$set(Se);const rt={};t&2&&(rt.$$scope={dirty:t,ctx:e}),B.$set(rt);const ct={};t&2&&(ct.$$scope={dirty:t,ctx:e}),x.$set(ct)},i(e){jl||(y(Y.$$.fragment,e),y(Q.$$.fragment,e),y(F.$$.fragment,e),y(K.$$.fragment,e),y(ee.$$.fragment,e),y(le.$$.fragment,e),y(ae.$$.fragment,e),y(ie.$$.fragment,e),y(N.$$.fragment,e),y(de.$$.fragment,e),y(ye.$$.fragment,e),y(ue.$$.fragment,e),y(B.$$.fragment,e),y(we.$$.fragment,e),y(x.$$.fragment,e),y(be.$$.fragment,e),y(Ce.$$.fragment,e),y(_e.$$.fragment,e),y(Ze.$$.fragment,e),y(ke.$$.fragment,e),y(Ne.$$.fragment,e),y(xe.$$.fragment,e),y(Xe.$$.fragment,e),y(Ee.$$.fragment,e),y(Ve.$$.fragment,e),y(ze.$$.fragment,e),jl=!0)},o(e){h(Y.$$.fragment,e),h(Q.$$.fragment,e),h(F.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),h(ae.$$.fragment,e),h(ie.$$.fragment,e),h(N.$$.fragment,e),h(de.$$.fragment,e),h(ye.$$.fragment,e),h(ue.$$.fragment,e),h(B.$$.fragment,e),h(we.$$.fragment,e),h(x.$$.fragment,e),h(be.$$.fragment,e),h(Ce.$$.fragment,e),h(_e.$$.fragment,e),h(Ze.$$.fragment,e),h(ke.$$.fragment,e),h(Ne.$$.fragment,e),h(xe.$$.fragment,e),h(Xe.$$.fragment,e),h(Ee.$$.fragment,e),h(Ve.$$.fragment,e),h(ze.$$.fragment,e),jl=!1},d(e){e&&(l(j),l(w),l(b),l(U),l(Mt),l(E),l(dt),l(G),l(pt),l(V),l(mt),l(C),l(yt),l(H),l(ht),l(z),l(ut),l(ft),l(S),l(wt),l(P),l(Jt),l(L),l(Tt),l(q),l(jt),l(D),l(bt),l(Ut),l(O),l(Ct),l(gt),l(te),l(It),l(g),l(_t),l(se),l(vt),l(ne),l(Zt),l(At),l(oe),l(kt),l($t),l(re),l(Nt),l(Wt),l(ce),l(Bt),l(Me),l(xt),l(Rt),l(pe),l(Xt),l(me),l(Yt),l(Et),l(he),l(Gt),l(I),l(Vt),l(Qt),l(fe),l(Ht),l(zt),l(Je),l(Ft),l(St),l(Te),l(Pt),l(je),l(Lt),l(qt),l(Ue),l(Dt),l(Kt),l(ge),l(Ot),l(Ie),l(el),l(tl),l(ve),l(ll),l(sl),l(Ae),l(nl),l(al),l($e),l(ol),l(il),l(We),l(rl),l(Be),l(cl),l(_),l(Ml),l(Re),l(dl),l(pl),l(Ye),l(ml),l(yl),l(Ge),l(hl),l(v),l(ul),l(Qe),l(fl),l(He),l(wl),l(Jl),l(Fe),l(Tl),l(it)),l(c),u(Y),u(Q),u(F,e),u(K,e),u(ee,e),u(le),u(ae,e),u(ie,e),u(N,e),u(de,e),u(ye,e),u(ue),u(B,e),u(we,e),u(x,e),u(be,e),u(Ce,e),u(_e,e),u(Ze,e),u(ke,e),u(Ne,e),u(xe),u(Xe,e),u(Ee,e),u(Ve),u(ze,e)}}}const zs={local:"sharing-custom-models",sections:[{local:"writing-a-custom-configuration",title:"Writing a custom configuration"},{local:"writing-a-custom-model",title:"Writing a custom model"},{local:"sending-the-code-to-the-hub",title:"Sending the code to the Hub"},{local:"using-a-model-with-custom-code",title:"Using a model with custom code"},{local:"registering-a-model-with-custom-code-to-the-auto-classes",title:"Registering a model with custom code to the auto classes"}],title:"Sharing custom models"};function Fs(Z){return Rs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ks extends Xs{constructor(c){super(),Ys(this,c,Fs,Hs,xs,{})}}export{Ks as component};
