import{s as ea,o as la,n as ul}from"../chunks/scheduler.9bc65507.js";import{S as aa,i as na,g as p,s as n,u as o,A as ta,h as r,f as l,c as t,j as J,v as h,y as u,k as d,o as b,a,w,d as M,t as j,x as m}from"../chunks/index.78c82d43.js";import{T as rl}from"../chunks/Tip.87d55b76.js";import{I as ll}from"../chunks/IconCopyLink.bedaa44d.js";import{C as T}from"../chunks/CodeBlock.73e038be.js";function pa(A){let c,y="This feature is currently available for PyTorch-only.";return{c(){c=p("p"),c.textContent=y},l(i){c=r(i,"P",{"data-svelte-h":!0}),u(c)!=="svelte-1659hm6"&&(c.textContent=y)},m(i,f){a(i,c,f)},p:ul,d(i){i&&l(c)}}}function ra(A){let c,y="For multi-GPU training it requires DDP (<code>torch.distributed.launch</code>).";return{c(){c=p("p"),c.innerHTML=y},l(i){c=r(i,"P",{"data-svelte-h":!0}),u(c)!=="svelte-b2srlm"&&(c.innerHTML=y)},m(i,f){a(i,c,f)},p:ul,d(i){i&&l(c)}}}function ua(A){let c,y="This feature can be used with any <code>nn.Module</code>-based model.";return{c(){c=p("p"),c.innerHTML=y},l(i){c=r(i,"P",{"data-svelte-h":!0}),u(c)!=="svelte-tkb0f4"&&(c.innerHTML=y)},m(i,f){a(i,c,f)},p:ul,d(i){i&&l(c)}}}function ca(A){let c,y,i,f,I,v,Es,R,al,$s,cl="Debugging",zs,U,G,Xs,x,nl,Ns,il="Multi-GPU Network Issues Debug",Fs,$,ol="When training or inferencing with <code>DistributedDataParallel</code> and multiple GPU, if you run into issue of inter-communication between processes and/or nodes, you can use the following script to diagnose network issues.",Ps,N,Ks,L,hl="For example to test how 2 GPUs interact do:",Os,W,qs,E,wl="If both processes can talk to each and allocate GPU memory each will print an OK status.",se,X,Ml="For more GPUs or nodes adjust the arguments in the script.",ee,Q,jl="You will find a lot more details inside the diagnostics script and even a recipe to how you could run it in a SLURM environment.",le,D,ml="An additional level of debug is to add <code>NCCL_DEBUG=INFO</code> environment variable as follows:",ae,H,ne,S,dl="This will dump a lot of NCCL-related debug information, which you can then search online if you find that some problems are reported. Or if you’re not sure how to interpret the output you can share the log file in an Issue.",te,C,V,Qs,Y,tl,Ls,bl="Underflow and Overflow Detection",pe,k,re,g,ue,B,ce,z,Tl=`If you start getting <code>loss=NaN</code> or the model inhibits some other abnormal behavior due to <code>inf</code> or <code>nan</code> in
activations or weights one needs to discover where the first underflow or overflow happens and what led to it. Luckily
you can accomplish that easily by activating a special module that will do the detection automatically.`,ie,F,Jl='If you’re using <a href="/docs/transformers/v4.34.0/en/main_classes/trainer#transformers.Trainer">Trainer</a>, you just need to add:',oe,P,he,K,yl=`to the normal command line arguments, or pass <code>debug=&quot;underflow_overflow&quot;</code> when creating the
<a href="/docs/transformers/v4.34.0/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> object.`,we,O,fl="If you’re using your own training loop or another Trainer you can accomplish the same with:",Me,q,je,ss,Il=`<a href="/docs/transformers/v4.34.0/en/internal/trainer_utils#transformers.debug_utils.DebugUnderflowOverflow">DebugUnderflowOverflow</a> inserts hooks into the model that immediately after each
forward call will test input and output variables and also the corresponding module’s weights. As soon as <code>inf</code> or
<code>nan</code> is detected in at least one element of the activations or weights, the program will assert and print a report
like this (this was caught with <code>google/mt5-small</code> under fp16 mixed precision):`,me,es,de,ls,Ul="The example output has been trimmed in the middle for brevity.",be,as,Cl=`The second column shows the value of the absolute largest element, so if you have a closer look at the last few frames,
the inputs and outputs were in the range of <code>1e4</code>. So when this training was done under fp16 mixed precision the very
last step overflowed (since under <code>fp16</code> the largest number before <code>inf</code> is <code>64e3</code>). To avoid overflows under
<code>fp16</code> the activations must remain way below <code>1e4</code>, because <code>1e4 * 1e4 = 1e8</code> so any matrix multiplication with
large activations is going to lead to a numerical overflow condition.`,Te,ns,Zl="At the very start of the trace you can discover at which batch number the problem occurred (here <code>Detected inf/nan during batch_number=0</code> means the problem occurred on the first batch).",Je,ts,Al=`Each reported frame starts by declaring the fully qualified entry for the corresponding module this frame is reporting
for. If we look just at this frame:`,ye,ps,fe,rs,vl=`Here, <code>encoder.block.2.layer.1.layer_norm</code> indicates that it was a layer norm for the first layer, of the second
block of the encoder. And the specific calls of the <code>forward</code> is <code>T5LayerNorm</code>.`,Ie,us,Gl="Let’s look at the last few frames of that report:",Ue,cs,Ce,is,Vl=`The last frame reports for <code>Dropout.forward</code> function with the first entry for the only input and the second for the
only output. You can see that it was called from an attribute <code>dropout</code> inside <code>DenseReluDense</code> class. We can see
that it happened during the first layer, of the 2nd block, during the very first batch. Finally, the absolute largest
input elements was <code>6.27e+04</code> and same for the output was <code>inf</code>.`,Ze,os,kl=`You can see here, that <code>T5DenseGatedGeluDense.forward</code> resulted in output activations, whose absolute max value was
around 62.7K, which is very close to fp16’s top limit of 64K. In the next frame we have <code>Dropout</code> which renormalizes
the weights, after it zeroed some of the elements, which pushes the absolute max value to more than 64K, and we get an
overflow (<code>inf</code>).`,Ae,hs,gl=`As you can see it’s the previous frames that we need to look into when the numbers start going into very large for fp16
numbers.`,ve,ws,Bl="Let’s match the report to the code from <code>models/t5/modeling_t5.py</code>:",Ge,Ms,Ve,js,_l="Now it’s easy to see the <code>dropout</code> call, and all the previous calls as well.",ke,ms,Rl=`Since the detection is happening in a forward hook, these reports are printed immediately after each <code>forward</code>
returns.`,ge,ds,xl=`Going back to the full report, to act on it and to fix the problem, we need to go a few frames up where the numbers
started to go up and most likely switch to the <code>fp32</code> mode here, so that the numbers don’t overflow when multiplied
or summed up. Of course, there might be other solutions. For example, we could turn off <code>amp</code> temporarily if it’s
enabled, after moving the original <code>forward</code> into a helper wrapper, like so:`,Be,bs,_e,Ts,$l=`Since the automatic detector only reports on inputs and outputs of full frames, once you know where to look, you may
want to analyse the intermediary stages of any specific <code>forward</code> function as well. In such a case you can use the
<code>detect_overflow</code> helper function to inject the detector where you want it, for example:`,Re,Js,xe,ys,Nl=`You can see that we added 2 of these and now we track if <code>inf</code> or <code>nan</code> for <code>forwarded_states</code> was detected
somewhere in between.`,$e,fs,Ll=`Actually, the detector already reports these because each of the calls in the example above is a <code>nn.Module</code>, but
let’s say if you had some local direct calculations this is how you’d do that.`,Ne,Is,Wl=`Additionally, if you’re instantiating the debugger in your own code, you can adjust the number of frames printed from
its default, e.g.:`,Le,Us,We,Z,_,Ds,Cs,pl,Ws,El="Specific batch absolute min and max value tracing",Ee,Zs,Xl="The same debugging class can be used for per-batch tracing with the underflow/overflow detection feature turned off.",Xe,As,Ql=`Let’s say you want to watch the absolute min and max values for all the ingredients of each <code>forward</code> call of a given
batch, and only do that for batches 1 and 3. Then you instantiate this class as:`,Qe,vs,De,Gs,Dl="And now full batches 1 and 3 will be traced using the same format as the underflow/overflow detector does.",He,Vs,Hl="Batches are 0-indexed.",Se,ks,Sl=`This is helpful if you know that the program starts misbehaving after a certain batch number, so you can fast-forward
right to that area. Here is a sample truncated output for such configuration:`,Ye,gs,ze,Bs,Yl=`Here you will get a huge number of frames dumped - as many as there were forward calls in your model, so it may or may
not what you want, but sometimes it can be easier to use for debugging purposes than a normal debugger. For example, if
a problem starts happening at batch number 150. So you can dump traces for batches 149 and 150 and compare where
numbers started to diverge.`,Fe,_s,zl="You can also specify the batch number after which to stop the training, with:",Pe,Rs,Ke,Hs,Oe;return R=new ll({}),x=new ll({}),N=new T({props:{code:"d2dldCUyMGh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRmh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzJTJGbWFpbiUyRnNjcmlwdHMlMkZkaXN0cmlidXRlZCUyRnRvcmNoLWRpc3RyaWJ1dGVkLWdwdS10ZXN0LnB5",highlighted:"wget https://raw.githubusercontent.com/huggingface/transformers/main/scripts/distributed/torch-distributed-gpu-test.py",wrap:!1}}),W=new T({props:{code:"cHl0aG9uJTIwLW0lMjB0b3JjaC5kaXN0cmlidXRlZC5ydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTIwMiUyMC0tbm5vZGVzJTIwMSUyMHRvcmNoLWRpc3RyaWJ1dGVkLWdwdS10ZXN0LnB5",highlighted:"python -m torch.distributed.run --nproc_per_node 2 --nnodes 1 torch-distributed-gpu-test.py",wrap:!1}}),H=new T({props:{code:"TkNDTF9ERUJVRyUzRElORk8lMjBweXRob24lMjAtbSUyMHRvcmNoLmRpc3RyaWJ1dGVkLnJ1biUyMC0tbnByb2NfcGVyX25vZGUlMjAyJTIwLS1ubm9kZXMlMjAxJTIwdG9yY2gtZGlzdHJpYnV0ZWQtZ3B1LXRlc3QucHk=",highlighted:"NCCL_DEBUG=INFO python -m torch.distributed.run --nproc_per_node 2 --nnodes 1 torch-distributed-gpu-test.py",wrap:!1}}),Y=new ll({}),k=new rl({props:{$$slots:{default:[pa]},$$scope:{ctx:A}}}),g=new rl({props:{$$slots:{default:[ra]},$$scope:{ctx:A}}}),B=new rl({props:{$$slots:{default:[ua]},$$scope:{ctx:A}}}),P=new T({props:{code:"LS1kZWJ1ZyUyMHVuZGVyZmxvd19vdmVyZmxvdw==",highlighted:"--debug underflow_overflow",wrap:!1}}),q=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5kZWJ1Z191dGlscyUyMGltcG9ydCUyMERlYnVnVW5kZXJmbG93T3ZlcmZsb3clMEElMEFkZWJ1Z19vdmVyZmxvdyUyMCUzRCUyMERlYnVnVW5kZXJmbG93T3ZlcmZsb3cobW9kZWwp",highlighted:`<span class="hljs-keyword">from</span> transformers.debug_utils <span class="hljs-keyword">import</span> DebugUnderflowOverflow

debug_overflow = DebugUnderflowOverflow(model)`,wrap:!1}}),es=new T({props:{code:"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",highlighted:`<span class="hljs-attribute">Detected</span> inf/nan during batch_number=<span class="hljs-number">0</span>
<span class="hljs-attribute">Last</span> <span class="hljs-number">21</span> forward frames:
<span class="hljs-attribute">abs</span> min  abs max  metadata
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">1</span>.layer.<span class="hljs-number">1</span>.DenseReluDense.dropout Dropout
<span class="hljs-attribute">0</span>.<span class="hljs-number">00</span>e+<span class="hljs-number">00</span> <span class="hljs-number">2</span>.<span class="hljs-number">57</span>e+<span class="hljs-number">02</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">0</span>.<span class="hljs-number">00</span>e+<span class="hljs-number">00</span> <span class="hljs-number">2</span>.<span class="hljs-number">85</span>e+<span class="hljs-number">02</span> output<span class="hljs-meta">
[...]</span>
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">0</span> T5LayerSelfAttention
<span class="hljs-attribute">6</span>.<span class="hljs-number">78</span>e-<span class="hljs-number">04</span> <span class="hljs-number">3</span>.<span class="hljs-number">15</span>e+<span class="hljs-number">03</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">2</span>.<span class="hljs-number">65</span>e-<span class="hljs-number">04</span> <span class="hljs-number">3</span>.<span class="hljs-number">42</span>e+<span class="hljs-number">03</span> output[<span class="hljs-number">0</span>]
             <span class="hljs-attribute">None</span> output[<span class="hljs-number">1</span>]
<span class="hljs-attribute">2</span>.<span class="hljs-number">25</span>e-<span class="hljs-number">01</span> <span class="hljs-number">1</span>.<span class="hljs-number">00</span>e+<span class="hljs-number">04</span> output[<span class="hljs-number">2</span>]
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.layer_norm T5LayerNorm
<span class="hljs-attribute">8</span>.<span class="hljs-number">69</span>e-<span class="hljs-number">02</span> <span class="hljs-number">4</span>.<span class="hljs-number">18</span>e-<span class="hljs-number">01</span> weight
<span class="hljs-attribute">2</span>.<span class="hljs-number">65</span>e-<span class="hljs-number">04</span> <span class="hljs-number">3</span>.<span class="hljs-number">42</span>e+<span class="hljs-number">03</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">1</span>.<span class="hljs-number">79</span>e-<span class="hljs-number">06</span> <span class="hljs-number">4</span>.<span class="hljs-number">65</span>e+<span class="hljs-number">00</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.DenseReluDense.wi_0 Linear
<span class="hljs-attribute">2</span>.<span class="hljs-number">17</span>e-<span class="hljs-number">07</span> <span class="hljs-number">4</span>.<span class="hljs-number">50</span>e+<span class="hljs-number">00</span> weight
<span class="hljs-attribute">1</span>.<span class="hljs-number">79</span>e-<span class="hljs-number">06</span> <span class="hljs-number">4</span>.<span class="hljs-number">65</span>e+<span class="hljs-number">00</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">2</span>.<span class="hljs-number">68</span>e-<span class="hljs-number">06</span> <span class="hljs-number">3</span>.<span class="hljs-number">70</span>e+<span class="hljs-number">01</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.DenseReluDense.wi_1 Linear
<span class="hljs-attribute">8</span>.<span class="hljs-number">08</span>e-<span class="hljs-number">07</span> <span class="hljs-number">2</span>.<span class="hljs-number">66</span>e+<span class="hljs-number">01</span> weight
<span class="hljs-attribute">1</span>.<span class="hljs-number">79</span>e-<span class="hljs-number">06</span> <span class="hljs-number">4</span>.<span class="hljs-number">65</span>e+<span class="hljs-number">00</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">1</span>.<span class="hljs-number">27</span>e-<span class="hljs-number">04</span> <span class="hljs-number">2</span>.<span class="hljs-number">37</span>e+<span class="hljs-number">02</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.DenseReluDense.dropout Dropout
<span class="hljs-attribute">0</span>.<span class="hljs-number">00</span>e+<span class="hljs-number">00</span> <span class="hljs-number">8</span>.<span class="hljs-number">76</span>e+<span class="hljs-number">03</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">0</span>.<span class="hljs-number">00</span>e+<span class="hljs-number">00</span> <span class="hljs-number">9</span>.<span class="hljs-number">74</span>e+<span class="hljs-number">03</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.DenseReluDense.wo Linear
<span class="hljs-attribute">1</span>.<span class="hljs-number">01</span>e-<span class="hljs-number">06</span> <span class="hljs-number">6</span>.<span class="hljs-number">44</span>e+<span class="hljs-number">00</span> weight
<span class="hljs-attribute">0</span>.<span class="hljs-number">00</span>e+<span class="hljs-number">00</span> <span class="hljs-number">9</span>.<span class="hljs-number">74</span>e+<span class="hljs-number">03</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">3</span>.<span class="hljs-number">18</span>e-<span class="hljs-number">04</span> <span class="hljs-number">6</span>.<span class="hljs-number">27</span>e+<span class="hljs-number">04</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.DenseReluDense T5DenseGatedGeluDense
<span class="hljs-attribute">1</span>.<span class="hljs-number">79</span>e-<span class="hljs-number">06</span> <span class="hljs-number">4</span>.<span class="hljs-number">65</span>e+<span class="hljs-number">00</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">3</span>.<span class="hljs-number">18</span>e-<span class="hljs-number">04</span> <span class="hljs-number">6</span>.<span class="hljs-number">27</span>e+<span class="hljs-number">04</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.dropout Dropout
<span class="hljs-attribute">3</span>.<span class="hljs-number">18</span>e-<span class="hljs-number">04</span> <span class="hljs-number">6</span>.<span class="hljs-number">27</span>e+<span class="hljs-number">04</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">0</span>.<span class="hljs-number">00</span>e+<span class="hljs-number">00</span>      inf output`,wrap:!1}}),ps=new T({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZW5jb2Rlci5ibG9jay4yLmxheWVyLjEubGF5ZXJfbm9ybSUyMFQ1TGF5ZXJOb3JtJTBBOC42OWUtMDIlMjA0LjE4ZS0wMSUyMHdlaWdodCUwQTIuNjVlLTA0JTIwMy40MmUlMkIwMyUyMGlucHV0JTVCMCU1RCUwQTEuNzllLTA2JTIwNC42NWUlMkIwMCUyMG91dHB1dA==",highlighted:`                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.layer_norm T5LayerNorm
<span class="hljs-attribute">8</span>.<span class="hljs-number">69</span>e-<span class="hljs-number">02</span> <span class="hljs-number">4</span>.<span class="hljs-number">18</span>e-<span class="hljs-number">01</span> weight
<span class="hljs-attribute">2</span>.<span class="hljs-number">65</span>e-<span class="hljs-number">04</span> <span class="hljs-number">3</span>.<span class="hljs-number">42</span>e+<span class="hljs-number">03</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">1</span>.<span class="hljs-number">79</span>e-<span class="hljs-number">06</span> <span class="hljs-number">4</span>.<span class="hljs-number">65</span>e+<span class="hljs-number">00</span> output`,wrap:!1}}),cs=new T({props:{code:"RGV0ZWN0ZWQlMjBpbmYlMkZuYW4lMjBkdXJpbmclMjBiYXRjaF9udW1iZXIlM0QwJTBBTGFzdCUyMDIxJTIwZm9yd2FyZCUyMGZyYW1lcyUzQSUwQWFicyUyMG1pbiUyMCUyMGFicyUyMG1heCUyMCUyMG1ldGFkYXRhJTBBJTVCLi4uJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZW5jb2Rlci5ibG9jay4yLmxheWVyLjEuRGVuc2VSZWx1RGVuc2Uud2lfMCUyMExpbmVhciUwQTIuMTdlLTA3JTIwNC41MGUlMkIwMCUyMHdlaWdodCUwQTEuNzllLTA2JTIwNC42NWUlMkIwMCUyMGlucHV0JTVCMCU1RCUwQTIuNjhlLTA2JTIwMy43MGUlMkIwMSUyMG91dHB1dCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVuY29kZXIuYmxvY2suMi5sYXllci4xLkRlbnNlUmVsdURlbnNlLndpXzElMjBMaW5lYXIlMEE4LjA4ZS0wNyUyMDIuNjZlJTJCMDElMjB3ZWlnaHQlMEExLjc5ZS0wNiUyMDQuNjVlJTJCMDAlMjBpbnB1dCU1QjAlNUQlMEExLjI3ZS0wNCUyMDIuMzdlJTJCMDIlMjBvdXRwdXQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbmNvZGVyLmJsb2NrLjIubGF5ZXIuMS5EZW5zZVJlbHVEZW5zZS53byUyMExpbmVhciUwQTEuMDFlLTA2JTIwNi40NGUlMkIwMCUyMHdlaWdodCUwQTAuMDBlJTJCMDAlMjA5Ljc0ZSUyQjAzJTIwaW5wdXQlNUIwJTVEJTBBMy4xOGUtMDQlMjA2LjI3ZSUyQjA0JTIwb3V0cHV0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZW5jb2Rlci5ibG9jay4yLmxheWVyLjEuRGVuc2VSZWx1RGVuc2UlMjBUNURlbnNlR2F0ZWRHZWx1RGVuc2UlMEExLjc5ZS0wNiUyMDQuNjVlJTJCMDAlMjBpbnB1dCU1QjAlNUQlMEEzLjE4ZS0wNCUyMDYuMjdlJTJCMDQlMjBvdXRwdXQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbmNvZGVyLmJsb2NrLjIubGF5ZXIuMS5kcm9wb3V0JTIwRHJvcG91dCUwQTMuMThlLTA0JTIwNi4yN2UlMkIwNCUyMGlucHV0JTVCMCU1RCUwQTAuMDBlJTJCMDAlMjAlMjAlMjAlMjAlMjAlMjBpbmYlMjBvdXRwdXQ=",highlighted:`<span class="hljs-attribute">Detected</span> inf/nan during batch_number=<span class="hljs-number">0</span>
<span class="hljs-attribute">Last</span> <span class="hljs-number">21</span> forward frames:
<span class="hljs-attribute">abs</span> min  abs max  metadata<span class="hljs-meta">
[...]</span>
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.DenseReluDense.wi_0 Linear
<span class="hljs-attribute">2</span>.<span class="hljs-number">17</span>e-<span class="hljs-number">07</span> <span class="hljs-number">4</span>.<span class="hljs-number">50</span>e+<span class="hljs-number">00</span> weight
<span class="hljs-attribute">1</span>.<span class="hljs-number">79</span>e-<span class="hljs-number">06</span> <span class="hljs-number">4</span>.<span class="hljs-number">65</span>e+<span class="hljs-number">00</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">2</span>.<span class="hljs-number">68</span>e-<span class="hljs-number">06</span> <span class="hljs-number">3</span>.<span class="hljs-number">70</span>e+<span class="hljs-number">01</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.DenseReluDense.wi_1 Linear
<span class="hljs-attribute">8</span>.<span class="hljs-number">08</span>e-<span class="hljs-number">07</span> <span class="hljs-number">2</span>.<span class="hljs-number">66</span>e+<span class="hljs-number">01</span> weight
<span class="hljs-attribute">1</span>.<span class="hljs-number">79</span>e-<span class="hljs-number">06</span> <span class="hljs-number">4</span>.<span class="hljs-number">65</span>e+<span class="hljs-number">00</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">1</span>.<span class="hljs-number">27</span>e-<span class="hljs-number">04</span> <span class="hljs-number">2</span>.<span class="hljs-number">37</span>e+<span class="hljs-number">02</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.DenseReluDense.wo Linear
<span class="hljs-attribute">1</span>.<span class="hljs-number">01</span>e-<span class="hljs-number">06</span> <span class="hljs-number">6</span>.<span class="hljs-number">44</span>e+<span class="hljs-number">00</span> weight
<span class="hljs-attribute">0</span>.<span class="hljs-number">00</span>e+<span class="hljs-number">00</span> <span class="hljs-number">9</span>.<span class="hljs-number">74</span>e+<span class="hljs-number">03</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">3</span>.<span class="hljs-number">18</span>e-<span class="hljs-number">04</span> <span class="hljs-number">6</span>.<span class="hljs-number">27</span>e+<span class="hljs-number">04</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.DenseReluDense T5DenseGatedGeluDense
<span class="hljs-attribute">1</span>.<span class="hljs-number">79</span>e-<span class="hljs-number">06</span> <span class="hljs-number">4</span>.<span class="hljs-number">65</span>e+<span class="hljs-number">00</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">3</span>.<span class="hljs-number">18</span>e-<span class="hljs-number">04</span> <span class="hljs-number">6</span>.<span class="hljs-number">27</span>e+<span class="hljs-number">04</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.dropout Dropout
<span class="hljs-attribute">3</span>.<span class="hljs-number">18</span>e-<span class="hljs-number">04</span> <span class="hljs-number">6</span>.<span class="hljs-number">27</span>e+<span class="hljs-number">04</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">0</span>.<span class="hljs-number">00</span>e+<span class="hljs-number">00</span>      inf output`,wrap:!1}}),Ms=new T({props:{code:"Y2xhc3MlMjBUNURlbnNlR2F0ZWRHZWx1RGVuc2Uobm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBjb25maWcpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi53aV8wJTIwJTNEJTIwbm4uTGluZWFyKGNvbmZpZy5kX21vZGVsJTJDJTIwY29uZmlnLmRfZmYlMkMlMjBiaWFzJTNERmFsc2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi53aV8xJTIwJTNEJTIwbm4uTGluZWFyKGNvbmZpZy5kX21vZGVsJTJDJTIwY29uZmlnLmRfZmYlMkMlMjBiaWFzJTNERmFsc2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi53byUyMCUzRCUyMG5uLkxpbmVhcihjb25maWcuZF9mZiUyQyUyMGNvbmZpZy5kX21vZGVsJTJDJTIwYmlhcyUzREZhbHNlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuZHJvcG91dCUyMCUzRCUyMG5uLkRyb3BvdXQoY29uZmlnLmRyb3BvdXRfcmF0ZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmdlbHVfYWN0JTIwJTNEJTIwQUNUMkZOJTVCJTIyZ2VsdV9uZXclMjIlNUQlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjBoaWRkZW5fc3RhdGVzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGhpZGRlbl9nZWx1JTIwJTNEJTIwc2VsZi5nZWx1X2FjdChzZWxmLndpXzAoaGlkZGVuX3N0YXRlcykpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGlkZGVuX2xpbmVhciUyMCUzRCUyMHNlbGYud2lfMShoaWRkZW5fc3RhdGVzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGhpZGRlbl9zdGF0ZXMlMjAlM0QlMjBoaWRkZW5fZ2VsdSUyMColMjBoaWRkZW5fbGluZWFyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGlkZGVuX3N0YXRlcyUyMCUzRCUyMHNlbGYuZHJvcG91dChoaWRkZW5fc3RhdGVzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGhpZGRlbl9zdGF0ZXMlMjAlM0QlMjBzZWxmLndvKGhpZGRlbl9zdGF0ZXMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwaGlkZGVuX3N0YXRlcw==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">T5DenseGatedGeluDense</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.wi_0 = nn.Linear(config.d_model, config.d_ff, bias=<span class="hljs-literal">False</span>)
        self.wi_1 = nn.Linear(config.d_model, config.d_ff, bias=<span class="hljs-literal">False</span>)
        self.wo = nn.Linear(config.d_ff, config.d_model, bias=<span class="hljs-literal">False</span>)
        self.dropout = nn.Dropout(config.dropout_rate)
        self.gelu_act = ACT2FN[<span class="hljs-string">&quot;gelu_new&quot;</span>]

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, hidden_states</span>):
        hidden_gelu = self.gelu_act(self.wi_0(hidden_states))
        hidden_linear = self.wi_1(hidden_states)
        hidden_states = hidden_gelu * hidden_linear
        hidden_states = self.dropout(hidden_states)
        hidden_states = self.wo(hidden_states)
        <span class="hljs-keyword">return</span> hidden_states`,wrap:!1}}),bs=new T({props:{code:"ZGVmJTIwX2ZvcndhcmQoc2VsZiUyQyUyMGhpZGRlbl9zdGF0ZXMpJTNBJTBBJTIwJTIwJTIwJTIwaGlkZGVuX2dlbHUlMjAlM0QlMjBzZWxmLmdlbHVfYWN0KHNlbGYud2lfMChoaWRkZW5fc3RhdGVzKSklMEElMjAlMjAlMjAlMjBoaWRkZW5fbGluZWFyJTIwJTNEJTIwc2VsZi53aV8xKGhpZGRlbl9zdGF0ZXMpJTBBJTIwJTIwJTIwJTIwaGlkZGVuX3N0YXRlcyUyMCUzRCUyMGhpZGRlbl9nZWx1JTIwKiUyMGhpZGRlbl9saW5lYXIlMEElMjAlMjAlMjAlMjBoaWRkZW5fc3RhdGVzJTIwJTNEJTIwc2VsZi5kcm9wb3V0KGhpZGRlbl9zdGF0ZXMpJTBBJTIwJTIwJTIwJTIwaGlkZGVuX3N0YXRlcyUyMCUzRCUyMHNlbGYud28oaGlkZGVuX3N0YXRlcyklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBoaWRkZW5fc3RhdGVzJTBBJTBBJTBBaW1wb3J0JTIwdG9yY2glMEElMEElMEFkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjBoaWRkZW5fc3RhdGVzKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwdG9yY2guaXNfYXV0b2Nhc3RfZW5hYmxlZCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLmN1ZGEuYW1wLmF1dG9jYXN0KGVuYWJsZWQlM0RGYWxzZSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLl9mb3J3YXJkKGhpZGRlbl9zdGF0ZXMpJTBBJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYuX2ZvcndhcmQoaGlkZGVuX3N0YXRlcyk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, hidden_states</span>):
    hidden_gelu = self.gelu_act(self.wi_0(hidden_states))
    hidden_linear = self.wi_1(hidden_states)
    hidden_states = hidden_gelu * hidden_linear
    hidden_states = self.dropout(hidden_states)
    hidden_states = self.wo(hidden_states)
    <span class="hljs-keyword">return</span> hidden_states


<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, hidden_states</span>):
    <span class="hljs-keyword">if</span> torch.is_autocast_enabled():
        <span class="hljs-keyword">with</span> torch.cuda.amp.autocast(enabled=<span class="hljs-literal">False</span>):
            <span class="hljs-keyword">return</span> self._forward(hidden_states)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> self._forward(hidden_states)`,wrap:!1}}),Js=new T({props:{code:"ZnJvbSUyMGRlYnVnX3V0aWxzJTIwaW1wb3J0JTIwZGV0ZWN0X292ZXJmbG93JTBBJTBBJTBBY2xhc3MlMjBUNUxheWVyRkYobm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMCU1Qi4uLiU1RCUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMGhpZGRlbl9zdGF0ZXMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yd2FyZGVkX3N0YXRlcyUyMCUzRCUyMHNlbGYubGF5ZXJfbm9ybShoaWRkZW5fc3RhdGVzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRldGVjdF9vdmVyZmxvdyhmb3J3YXJkZWRfc3RhdGVzJTJDJTIwJTIyYWZ0ZXIlMjBsYXllcl9ub3JtJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvcndhcmRlZF9zdGF0ZXMlMjAlM0QlMjBzZWxmLkRlbnNlUmVsdURlbnNlKGZvcndhcmRlZF9zdGF0ZXMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGV0ZWN0X292ZXJmbG93KGZvcndhcmRlZF9zdGF0ZXMlMkMlMjAlMjJhZnRlciUyMERlbnNlUmVsdURlbnNlJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGhpZGRlbl9zdGF0ZXMlMjAlMkIlMjBzZWxmLmRyb3BvdXQoZm9yd2FyZGVkX3N0YXRlcyk=",highlighted:`<span class="hljs-keyword">from</span> debug_utils <span class="hljs-keyword">import</span> detect_overflow


<span class="hljs-keyword">class</span> <span class="hljs-title class_">T5LayerFF</span>(nn.Module):
    [...]

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, hidden_states</span>):
        forwarded_states = self.layer_norm(hidden_states)
        detect_overflow(forwarded_states, <span class="hljs-string">&quot;after layer_norm&quot;</span>)
        forwarded_states = self.DenseReluDense(forwarded_states)
        detect_overflow(forwarded_states, <span class="hljs-string">&quot;after DenseReluDense&quot;</span>)
        <span class="hljs-keyword">return</span> hidden_states + self.dropout(forwarded_states)`,wrap:!1}}),Us=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5kZWJ1Z191dGlscyUyMGltcG9ydCUyMERlYnVnVW5kZXJmbG93T3ZlcmZsb3clMEElMEFkZWJ1Z19vdmVyZmxvdyUyMCUzRCUyMERlYnVnVW5kZXJmbG93T3ZlcmZsb3cobW9kZWwlMkMlMjBtYXhfZnJhbWVzX3RvX3NhdmUlM0QxMDAp",highlighted:`<span class="hljs-keyword">from</span> transformers.debug_utils <span class="hljs-keyword">import</span> DebugUnderflowOverflow

debug_overflow = DebugUnderflowOverflow(model, max_frames_to_save=<span class="hljs-number">100</span>)`,wrap:!1}}),Cs=new ll({}),vs=new T({props:{code:"ZGVidWdfb3ZlcmZsb3clMjAlM0QlMjBEZWJ1Z1VuZGVyZmxvd092ZXJmbG93KG1vZGVsJTJDJTIwdHJhY2VfYmF0Y2hfbnVtcyUzRCU1QjElMkMlMjAzJTVEKQ==",highlighted:'debug_overflow = DebugUnderflowOverflow(model, trace_batch_nums=[<span class="hljs-number">1</span>, <span class="hljs-number">3</span>])',wrap:!1}}),gs=new T({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKioqJTIwU3RhcnRpbmclMjBiYXRjaCUyMG51bWJlciUzRDElMjAqKiolMEFhYnMlMjBtaW4lMjAlMjBhYnMlMjBtYXglMjAlMjBtZXRhZGF0YSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNoYXJlZCUyMEVtYmVkZGluZyUwQTEuMDFlLTA2JTIwNy45MmUlMkIwMiUyMHdlaWdodCUwQTAuMDBlJTJCMDAlMjAyLjQ3ZSUyQjA0JTIwaW5wdXQlNUIwJTVEJTBBNS4zNmUtMDUlMjA3LjkyZSUyQjAyJTIwb3V0cHV0JTBBJTVCLi4uJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGVjb2Rlci5kcm9wb3V0JTIwRHJvcG91dCUwQTEuNjBlLTA3JTIwMi4yN2UlMkIwMSUyMGlucHV0JTVCMCU1RCUwQTAuMDBlJTJCMDAlMjAyLjUyZSUyQjAxJTIwb3V0cHV0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGVjb2RlciUyMFQ1U3RhY2slMEElMjAlMjAlMjAlMjAlMjBub3QlMjBhJTIwdGVuc29yJTIwb3V0cHV0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG1faGVhZCUyMExpbmVhciUwQTEuMDFlLTA2JTIwNy45MmUlMkIwMiUyMHdlaWdodCUwQTAuMDBlJTJCMDAlMjAxLjExZSUyQjAwJTIwaW5wdXQlNUIwJTVEJTBBNi4wNmUtMDIlMjA4LjM5ZSUyQjAxJTIwb3V0cHV0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMjAlMjAlMjAlMjAlMjBub3QlMjBhJTIwdGVuc29yJTIwb3V0cHV0JTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKioqJTIwU3RhcnRpbmclMjBiYXRjaCUyMG51bWJlciUzRDMlMjAqKiolMEFhYnMlMjBtaW4lMjAlMjBhYnMlMjBtYXglMjAlMjBtZXRhZGF0YSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNoYXJlZCUyMEVtYmVkZGluZyUwQTEuMDFlLTA2JTIwNy45MmUlMkIwMiUyMHdlaWdodCUwQTAuMDBlJTJCMDAlMjAyLjc4ZSUyQjA0JTIwaW5wdXQlNUIwJTVEJTBBNS4zNmUtMDUlMjA3LjkyZSUyQjAyJTIwb3V0cHV0JTBBJTVCLi4uJTVE",highlighted:`                  *** Starting batch number=1 ***
abs min  abs max  metadata
                  shared Embedding
1.01e<span class="hljs-string">-06</span> 7.92e<span class="hljs-string">+02</span> weight
0.00e<span class="hljs-string">+00</span> 2.47e<span class="hljs-string">+04</span> input[0]
5.36e<span class="hljs-string">-05</span> 7.92e<span class="hljs-string">+02</span> output
[...]
                  decoder.dropout Dropout
1.60e<span class="hljs-string">-07</span> 2.27e<span class="hljs-string">+01</span> input[0]
0.00e<span class="hljs-string">+00</span> 2.52e<span class="hljs-string">+01</span> output
                  decoder T5Stack
     not a tensor output
                  lm_head Linear
1.01e<span class="hljs-string">-06</span> 7.92e<span class="hljs-string">+02</span> weight
0.00e<span class="hljs-string">+00</span> 1.11e<span class="hljs-string">+00</span> input[0]
6.06e<span class="hljs-string">-02</span> 8.39e<span class="hljs-string">+01</span> output
                   T5ForConditionalGeneration
     not a tensor output

                  *** Starting batch number=3 ***
abs min  abs max  metadata
                  shared Embedding
1.01e<span class="hljs-string">-06</span> 7.92e<span class="hljs-string">+02</span> weight
0.00e<span class="hljs-string">+00</span> 2.78e<span class="hljs-string">+04</span> input[0]
5.36e<span class="hljs-string">-05</span> 7.92e<span class="hljs-string">+02</span> output
[...]`,wrap:!1}}),Rs=new T({props:{code:"ZGVidWdfb3ZlcmZsb3clMjAlM0QlMjBEZWJ1Z1VuZGVyZmxvd092ZXJmbG93KG1vZGVsJTJDJTIwdHJhY2VfYmF0Y2hfbnVtcyUzRCU1QjElMkMlMjAzJTVEJTJDJTIwYWJvcnRfYWZ0ZXJfYmF0Y2hfbnVtJTNEMyk=",highlighted:'debug_overflow = DebugUnderflowOverflow(model, trace_batch_nums=[<span class="hljs-number">1</span>, <span class="hljs-number">3</span>], abort_after_batch_num=<span class="hljs-number">3</span>)',wrap:!1}}),{c(){c=p("meta"),y=n(),i=p("p"),f=n(),I=p("h1"),v=p("a"),Es=p("span"),o(R.$$.fragment),al=n(),$s=p("span"),$s.textContent=cl,zs=n(),U=p("h2"),G=p("a"),Xs=p("span"),o(x.$$.fragment),nl=n(),Ns=p("span"),Ns.textContent=il,Fs=n(),$=p("p"),$.innerHTML=ol,Ps=n(),o(N.$$.fragment),Ks=n(),L=p("p"),L.textContent=hl,Os=n(),o(W.$$.fragment),qs=n(),E=p("p"),E.textContent=wl,se=n(),X=p("p"),X.textContent=Ml,ee=n(),Q=p("p"),Q.textContent=jl,le=n(),D=p("p"),D.innerHTML=ml,ae=n(),o(H.$$.fragment),ne=n(),S=p("p"),S.textContent=dl,te=n(),C=p("h2"),V=p("a"),Qs=p("span"),o(Y.$$.fragment),tl=n(),Ls=p("span"),Ls.textContent=bl,pe=n(),o(k.$$.fragment),re=n(),o(g.$$.fragment),ue=n(),o(B.$$.fragment),ce=n(),z=p("p"),z.innerHTML=Tl,ie=n(),F=p("p"),F.innerHTML=Jl,oe=n(),o(P.$$.fragment),he=n(),K=p("p"),K.innerHTML=yl,we=n(),O=p("p"),O.textContent=fl,Me=n(),o(q.$$.fragment),je=n(),ss=p("p"),ss.innerHTML=Il,me=n(),o(es.$$.fragment),de=n(),ls=p("p"),ls.textContent=Ul,be=n(),as=p("p"),as.innerHTML=Cl,Te=n(),ns=p("p"),ns.innerHTML=Zl,Je=n(),ts=p("p"),ts.textContent=Al,ye=n(),o(ps.$$.fragment),fe=n(),rs=p("p"),rs.innerHTML=vl,Ie=n(),us=p("p"),us.textContent=Gl,Ue=n(),o(cs.$$.fragment),Ce=n(),is=p("p"),is.innerHTML=Vl,Ze=n(),os=p("p"),os.innerHTML=kl,Ae=n(),hs=p("p"),hs.textContent=gl,ve=n(),ws=p("p"),ws.innerHTML=Bl,Ge=n(),o(Ms.$$.fragment),Ve=n(),js=p("p"),js.innerHTML=_l,ke=n(),ms=p("p"),ms.innerHTML=Rl,ge=n(),ds=p("p"),ds.innerHTML=xl,Be=n(),o(bs.$$.fragment),_e=n(),Ts=p("p"),Ts.innerHTML=$l,Re=n(),o(Js.$$.fragment),xe=n(),ys=p("p"),ys.innerHTML=Nl,$e=n(),fs=p("p"),fs.innerHTML=Ll,Ne=n(),Is=p("p"),Is.textContent=Wl,Le=n(),o(Us.$$.fragment),We=n(),Z=p("h3"),_=p("a"),Ds=p("span"),o(Cs.$$.fragment),pl=n(),Ws=p("span"),Ws.textContent=El,Ee=n(),Zs=p("p"),Zs.textContent=Xl,Xe=n(),As=p("p"),As.innerHTML=Ql,Qe=n(),o(vs.$$.fragment),De=n(),Gs=p("p"),Gs.textContent=Dl,He=n(),Vs=p("p"),Vs.textContent=Hl,Se=n(),ks=p("p"),ks.textContent=Sl,Ye=n(),o(gs.$$.fragment),ze=n(),Bs=p("p"),Bs.textContent=Yl,Fe=n(),_s=p("p"),_s.textContent=zl,Pe=n(),o(Rs.$$.fragment),Ke=n(),Hs=p("p"),this.h()},l(s){const e=ta("svelte-1phssyn",document.head);c=r(e,"META",{name:!0,content:!0}),e.forEach(l),y=t(s),i=r(s,"P",{}),J(i).forEach(l),f=t(s),I=r(s,"H1",{class:!0});var xs=J(I);v=r(xs,"A",{id:!0,class:!0,href:!0});var Ss=J(v);Es=r(Ss,"SPAN",{});var Ys=J(Es);h(R.$$.fragment,Ys),Ys.forEach(l),Ss.forEach(l),al=t(xs),$s=r(xs,"SPAN",{"data-svelte-h":!0}),u($s)!=="svelte-1gm1qgf"&&($s.textContent=cl),xs.forEach(l),zs=t(s),U=r(s,"H2",{class:!0});var qe=J(U);G=r(qe,"A",{id:!0,class:!0,href:!0});var Fl=J(G);Xs=r(Fl,"SPAN",{});var Pl=J(Xs);h(x.$$.fragment,Pl),Pl.forEach(l),Fl.forEach(l),nl=t(qe),Ns=r(qe,"SPAN",{"data-svelte-h":!0}),u(Ns)!=="svelte-9z9emw"&&(Ns.textContent=il),qe.forEach(l),Fs=t(s),$=r(s,"P",{"data-svelte-h":!0}),u($)!=="svelte-9omdti"&&($.innerHTML=ol),Ps=t(s),h(N.$$.fragment,s),Ks=t(s),L=r(s,"P",{"data-svelte-h":!0}),u(L)!=="svelte-1l3iq1o"&&(L.textContent=hl),Os=t(s),h(W.$$.fragment,s),qs=t(s),E=r(s,"P",{"data-svelte-h":!0}),u(E)!=="svelte-1mfzxxn"&&(E.textContent=wl),se=t(s),X=r(s,"P",{"data-svelte-h":!0}),u(X)!=="svelte-p47u8u"&&(X.textContent=Ml),ee=t(s),Q=r(s,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-r57lzq"&&(Q.textContent=jl),le=t(s),D=r(s,"P",{"data-svelte-h":!0}),u(D)!=="svelte-1px963d"&&(D.innerHTML=ml),ae=t(s),h(H.$$.fragment,s),ne=t(s),S=r(s,"P",{"data-svelte-h":!0}),u(S)!=="svelte-179ydg6"&&(S.textContent=dl),te=t(s),C=r(s,"H2",{class:!0});var sl=J(C);V=r(sl,"A",{id:!0,class:!0,href:!0});var Kl=J(V);Qs=r(Kl,"SPAN",{});var Ol=J(Qs);h(Y.$$.fragment,Ol),Ol.forEach(l),Kl.forEach(l),tl=t(sl),Ls=r(sl,"SPAN",{"data-svelte-h":!0}),u(Ls)!=="svelte-1bu8m7h"&&(Ls.textContent=bl),sl.forEach(l),pe=t(s),h(k.$$.fragment,s),re=t(s),h(g.$$.fragment,s),ue=t(s),h(B.$$.fragment,s),ce=t(s),z=r(s,"P",{"data-svelte-h":!0}),u(z)!=="svelte-rc8gwf"&&(z.innerHTML=Tl),ie=t(s),F=r(s,"P",{"data-svelte-h":!0}),u(F)!=="svelte-8t9k0h"&&(F.innerHTML=Jl),oe=t(s),h(P.$$.fragment,s),he=t(s),K=r(s,"P",{"data-svelte-h":!0}),u(K)!=="svelte-gjo02z"&&(K.innerHTML=yl),we=t(s),O=r(s,"P",{"data-svelte-h":!0}),u(O)!=="svelte-1l3b7y5"&&(O.textContent=fl),Me=t(s),h(q.$$.fragment,s),je=t(s),ss=r(s,"P",{"data-svelte-h":!0}),u(ss)!=="svelte-2r85wj"&&(ss.innerHTML=Il),me=t(s),h(es.$$.fragment,s),de=t(s),ls=r(s,"P",{"data-svelte-h":!0}),u(ls)!=="svelte-2ii9wn"&&(ls.textContent=Ul),be=t(s),as=r(s,"P",{"data-svelte-h":!0}),u(as)!=="svelte-1si0hkb"&&(as.innerHTML=Cl),Te=t(s),ns=r(s,"P",{"data-svelte-h":!0}),u(ns)!=="svelte-yj4cwf"&&(ns.innerHTML=Zl),Je=t(s),ts=r(s,"P",{"data-svelte-h":!0}),u(ts)!=="svelte-1w41g2g"&&(ts.textContent=Al),ye=t(s),h(ps.$$.fragment,s),fe=t(s),rs=r(s,"P",{"data-svelte-h":!0}),u(rs)!=="svelte-1tqbqml"&&(rs.innerHTML=vl),Ie=t(s),us=r(s,"P",{"data-svelte-h":!0}),u(us)!=="svelte-wdyrpk"&&(us.textContent=Gl),Ue=t(s),h(cs.$$.fragment,s),Ce=t(s),is=r(s,"P",{"data-svelte-h":!0}),u(is)!=="svelte-unqbdv"&&(is.innerHTML=Vl),Ze=t(s),os=r(s,"P",{"data-svelte-h":!0}),u(os)!=="svelte-yxhf7s"&&(os.innerHTML=kl),Ae=t(s),hs=r(s,"P",{"data-svelte-h":!0}),u(hs)!=="svelte-qa5qyo"&&(hs.textContent=gl),ve=t(s),ws=r(s,"P",{"data-svelte-h":!0}),u(ws)!=="svelte-lw0sg0"&&(ws.innerHTML=Bl),Ge=t(s),h(Ms.$$.fragment,s),Ve=t(s),js=r(s,"P",{"data-svelte-h":!0}),u(js)!=="svelte-19gpk8b"&&(js.innerHTML=_l),ke=t(s),ms=r(s,"P",{"data-svelte-h":!0}),u(ms)!=="svelte-ipsm9a"&&(ms.innerHTML=Rl),ge=t(s),ds=r(s,"P",{"data-svelte-h":!0}),u(ds)!=="svelte-1rpvta4"&&(ds.innerHTML=xl),Be=t(s),h(bs.$$.fragment,s),_e=t(s),Ts=r(s,"P",{"data-svelte-h":!0}),u(Ts)!=="svelte-up3p3a"&&(Ts.innerHTML=$l),Re=t(s),h(Js.$$.fragment,s),xe=t(s),ys=r(s,"P",{"data-svelte-h":!0}),u(ys)!=="svelte-152lw1d"&&(ys.innerHTML=Nl),$e=t(s),fs=r(s,"P",{"data-svelte-h":!0}),u(fs)!=="svelte-iv1rb"&&(fs.innerHTML=Ll),Ne=t(s),Is=r(s,"P",{"data-svelte-h":!0}),u(Is)!=="svelte-1kb9fq"&&(Is.textContent=Wl),Le=t(s),h(Us.$$.fragment,s),We=t(s),Z=r(s,"H3",{class:!0});var el=J(Z);_=r(el,"A",{id:!0,class:!0,href:!0});var ql=J(_);Ds=r(ql,"SPAN",{});var sa=J(Ds);h(Cs.$$.fragment,sa),sa.forEach(l),ql.forEach(l),pl=t(el),Ws=r(el,"SPAN",{"data-svelte-h":!0}),u(Ws)!=="svelte-jmcsgu"&&(Ws.textContent=El),el.forEach(l),Ee=t(s),Zs=r(s,"P",{"data-svelte-h":!0}),u(Zs)!=="svelte-mwprcu"&&(Zs.textContent=Xl),Xe=t(s),As=r(s,"P",{"data-svelte-h":!0}),u(As)!=="svelte-medkr5"&&(As.innerHTML=Ql),Qe=t(s),h(vs.$$.fragment,s),De=t(s),Gs=r(s,"P",{"data-svelte-h":!0}),u(Gs)!=="svelte-zj2sw0"&&(Gs.textContent=Dl),He=t(s),Vs=r(s,"P",{"data-svelte-h":!0}),u(Vs)!=="svelte-ux7vsk"&&(Vs.textContent=Hl),Se=t(s),ks=r(s,"P",{"data-svelte-h":!0}),u(ks)!=="svelte-v84jpj"&&(ks.textContent=Sl),Ye=t(s),h(gs.$$.fragment,s),ze=t(s),Bs=r(s,"P",{"data-svelte-h":!0}),u(Bs)!=="svelte-124ox4j"&&(Bs.textContent=Yl),Fe=t(s),_s=r(s,"P",{"data-svelte-h":!0}),u(_s)!=="svelte-vocb5m"&&(_s.textContent=zl),Pe=t(s),h(Rs.$$.fragment,s),Ke=t(s),Hs=r(s,"P",{}),J(Hs).forEach(l),this.h()},h(){d(c,"name","hf:doc:metadata"),d(c,"content",JSON.stringify(ia)),d(v,"id","debugging"),d(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(v,"href","#debugging"),d(I,"class","relative group"),d(G,"id","multigpu-network-issues-debug"),d(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(G,"href","#multigpu-network-issues-debug"),d(U,"class","relative group"),d(V,"id","underflow-and-overflow-detection"),d(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(V,"href","#underflow-and-overflow-detection"),d(C,"class","relative group"),d(_,"id","specific-batch-absolute-min-and-max-value-tracing"),d(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(_,"href","#specific-batch-absolute-min-and-max-value-tracing"),d(Z,"class","relative group")},m(s,e){b(document.head,c),a(s,y,e),a(s,i,e),a(s,f,e),a(s,I,e),b(I,v),b(v,Es),w(R,Es,null),b(I,al),b(I,$s),a(s,zs,e),a(s,U,e),b(U,G),b(G,Xs),w(x,Xs,null),b(U,nl),b(U,Ns),a(s,Fs,e),a(s,$,e),a(s,Ps,e),w(N,s,e),a(s,Ks,e),a(s,L,e),a(s,Os,e),w(W,s,e),a(s,qs,e),a(s,E,e),a(s,se,e),a(s,X,e),a(s,ee,e),a(s,Q,e),a(s,le,e),a(s,D,e),a(s,ae,e),w(H,s,e),a(s,ne,e),a(s,S,e),a(s,te,e),a(s,C,e),b(C,V),b(V,Qs),w(Y,Qs,null),b(C,tl),b(C,Ls),a(s,pe,e),w(k,s,e),a(s,re,e),w(g,s,e),a(s,ue,e),w(B,s,e),a(s,ce,e),a(s,z,e),a(s,ie,e),a(s,F,e),a(s,oe,e),w(P,s,e),a(s,he,e),a(s,K,e),a(s,we,e),a(s,O,e),a(s,Me,e),w(q,s,e),a(s,je,e),a(s,ss,e),a(s,me,e),w(es,s,e),a(s,de,e),a(s,ls,e),a(s,be,e),a(s,as,e),a(s,Te,e),a(s,ns,e),a(s,Je,e),a(s,ts,e),a(s,ye,e),w(ps,s,e),a(s,fe,e),a(s,rs,e),a(s,Ie,e),a(s,us,e),a(s,Ue,e),w(cs,s,e),a(s,Ce,e),a(s,is,e),a(s,Ze,e),a(s,os,e),a(s,Ae,e),a(s,hs,e),a(s,ve,e),a(s,ws,e),a(s,Ge,e),w(Ms,s,e),a(s,Ve,e),a(s,js,e),a(s,ke,e),a(s,ms,e),a(s,ge,e),a(s,ds,e),a(s,Be,e),w(bs,s,e),a(s,_e,e),a(s,Ts,e),a(s,Re,e),w(Js,s,e),a(s,xe,e),a(s,ys,e),a(s,$e,e),a(s,fs,e),a(s,Ne,e),a(s,Is,e),a(s,Le,e),w(Us,s,e),a(s,We,e),a(s,Z,e),b(Z,_),b(_,Ds),w(Cs,Ds,null),b(Z,pl),b(Z,Ws),a(s,Ee,e),a(s,Zs,e),a(s,Xe,e),a(s,As,e),a(s,Qe,e),w(vs,s,e),a(s,De,e),a(s,Gs,e),a(s,He,e),a(s,Vs,e),a(s,Se,e),a(s,ks,e),a(s,Ye,e),w(gs,s,e),a(s,ze,e),a(s,Bs,e),a(s,Fe,e),a(s,_s,e),a(s,Pe,e),w(Rs,s,e),a(s,Ke,e),a(s,Hs,e),Oe=!0},p(s,[e]){const xs={};e&2&&(xs.$$scope={dirty:e,ctx:s}),k.$set(xs);const Ss={};e&2&&(Ss.$$scope={dirty:e,ctx:s}),g.$set(Ss);const Ys={};e&2&&(Ys.$$scope={dirty:e,ctx:s}),B.$set(Ys)},i(s){Oe||(M(R.$$.fragment,s),M(x.$$.fragment,s),M(N.$$.fragment,s),M(W.$$.fragment,s),M(H.$$.fragment,s),M(Y.$$.fragment,s),M(k.$$.fragment,s),M(g.$$.fragment,s),M(B.$$.fragment,s),M(P.$$.fragment,s),M(q.$$.fragment,s),M(es.$$.fragment,s),M(ps.$$.fragment,s),M(cs.$$.fragment,s),M(Ms.$$.fragment,s),M(bs.$$.fragment,s),M(Js.$$.fragment,s),M(Us.$$.fragment,s),M(Cs.$$.fragment,s),M(vs.$$.fragment,s),M(gs.$$.fragment,s),M(Rs.$$.fragment,s),Oe=!0)},o(s){j(R.$$.fragment,s),j(x.$$.fragment,s),j(N.$$.fragment,s),j(W.$$.fragment,s),j(H.$$.fragment,s),j(Y.$$.fragment,s),j(k.$$.fragment,s),j(g.$$.fragment,s),j(B.$$.fragment,s),j(P.$$.fragment,s),j(q.$$.fragment,s),j(es.$$.fragment,s),j(ps.$$.fragment,s),j(cs.$$.fragment,s),j(Ms.$$.fragment,s),j(bs.$$.fragment,s),j(Js.$$.fragment,s),j(Us.$$.fragment,s),j(Cs.$$.fragment,s),j(vs.$$.fragment,s),j(gs.$$.fragment,s),j(Rs.$$.fragment,s),Oe=!1},d(s){s&&(l(y),l(i),l(f),l(I),l(zs),l(U),l(Fs),l($),l(Ps),l(Ks),l(L),l(Os),l(qs),l(E),l(se),l(X),l(ee),l(Q),l(le),l(D),l(ae),l(ne),l(S),l(te),l(C),l(pe),l(re),l(ue),l(ce),l(z),l(ie),l(F),l(oe),l(he),l(K),l(we),l(O),l(Me),l(je),l(ss),l(me),l(de),l(ls),l(be),l(as),l(Te),l(ns),l(Je),l(ts),l(ye),l(fe),l(rs),l(Ie),l(us),l(Ue),l(Ce),l(is),l(Ze),l(os),l(Ae),l(hs),l(ve),l(ws),l(Ge),l(Ve),l(js),l(ke),l(ms),l(ge),l(ds),l(Be),l(_e),l(Ts),l(Re),l(xe),l(ys),l($e),l(fs),l(Ne),l(Is),l(Le),l(We),l(Z),l(Ee),l(Zs),l(Xe),l(As),l(Qe),l(De),l(Gs),l(He),l(Vs),l(Se),l(ks),l(Ye),l(ze),l(Bs),l(Fe),l(_s),l(Pe),l(Ke),l(Hs)),l(c),m(R),m(x),m(N,s),m(W,s),m(H,s),m(Y),m(k,s),m(g,s),m(B,s),m(P,s),m(q,s),m(es,s),m(ps,s),m(cs,s),m(Ms,s),m(bs,s),m(Js,s),m(Us,s),m(Cs),m(vs,s),m(gs,s),m(Rs,s)}}}const ia={local:"debugging",sections:[{local:"multigpu-network-issues-debug",title:"Multi-GPU Network Issues Debug"},{local:"underflow-and-overflow-detection",sections:[{local:"specific-batch-absolute-min-and-max-value-tracing",title:"Specific batch absolute min and max value tracing"}],title:"Underflow and Overflow Detection"}],title:"Debugging"};function oa(A){return la(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class da extends aa{constructor(c){super(),na(this,c,oa,ca,ea,{})}}export{da as component};
