import{s as Er,f as Gr,o as Xr,n as Ko}from"../chunks/scheduler.9bc65507.js";import{S as Ar,i as Dr,g as n,s,u as g,A as Yr,h as r,f as o,c as a,j as p,v as f,y as h,k as c,o as t,a as l,w as u,d as _,t as v,x as b}from"../chunks/index.78c82d43.js";import{T as Vr}from"../chunks/Tip.87d55b76.js";import{D as M}from"../chunks/Docstring.4e7352e2.js";import{C as Sn}from"../chunks/CodeBlock.73e038be.js";import{I as X}from"../chunks/IconCopyLink.bedaa44d.js";import{E as Wn}from"../chunks/ExampleCodeBlock.872b014d.js";function Qr($){let m,x="Examples:",y,w,T;return w=new Sn({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME9uZUZvcm1lckNvbmZpZyUyQyUyME9uZUZvcm1lck1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyME9uZUZvcm1lciUyMHNoaS1sYWJzJTJGb25lZm9ybWVyX2FkZTIwa19zd2luX3RpbnklMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyME9uZUZvcm1lckNvbmZpZygpJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBzaGktbGFicyUyRm9uZWZvcm1lcl9hZGUyMGtfc3dpbl90aW55JTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBPbmVGb3JtZXJNb2RlbChjb25maWd1cmF0aW9uKSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OneFormerConfig, OneFormerModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a OneFormer shi-labs/oneformer_ade20k_swin_tiny configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = OneFormerConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the shi-labs/oneformer_ade20k_swin_tiny style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OneFormerModel(configuration)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){m=n("p"),m.textContent=x,y=s(),g(w.$$.fragment)},l(d){m=r(d,"P",{"data-svelte-h":!0}),h(m)!=="svelte-kvfsh7"&&(m.textContent=x),y=a(d),f(w.$$.fragment,d)},m(d,k){l(d,m,k),l(d,y,k),u(w,d,k),T=!0},p:Ko,i(d){T||(_(w.$$.fragment,d),T=!0)},o(d){v(w.$$.fragment,d),T=!1},d(d){d&&(o(m),o(y)),b(w,d)}}}function Kr($){let m,x=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){m=n("p"),m.innerHTML=x},l(y){m=r(y,"P",{"data-svelte-h":!0}),h(m)!=="svelte-fincs2"&&(m.innerHTML=x)},m(y,w){l(y,m,w)},p:Ko,d(y){y&&o(m)}}}function es($){let m,x="Example:",y,w,T;return w=new Sn({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBPbmVGb3JtZXJQcm9jZXNzb3IlMkMlMjBPbmVGb3JtZXJNb2RlbCUwQSUwQSUyMyUyMGRvd25sb2FkJTIwdGV4dGluZyUyMGltYWdlJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQSUyMyUyMGxvYWQlMjBwcm9jZXNzb3IlMjBmb3IlMjBwcmVwcm9jZXNzaW5nJTIwdGhlJTIwaW5wdXRzJTBBcHJvY2Vzc29yJTIwJTNEJTIwT25lRm9ybWVyUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJzaGktbGFicyUyRm9uZWZvcm1lcl9hZGUyMGtfc3dpbl90aW55JTIyKSUwQW1vZGVsJTIwJTNEJTIwT25lRm9ybWVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnNoaS1sYWJzJTJGb25lZm9ybWVyX2FkZTIwa19zd2luX3RpbnklMjIpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwJTVCJTIyc2VtYW50aWMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbWFza19wcmVkaWN0aW9ucyUyMCUzRCUyMG91dHB1dHMudHJhbnNmb3JtZXJfZGVjb2Rlcl9tYXNrX3ByZWRpY3Rpb25zJTBBY2xhc3NfcHJlZGljdGlvbnMlMjAlM0QlMjBvdXRwdXRzLnRyYW5zZm9ybWVyX2RlY29kZXJfY2xhc3NfcHJlZGljdGlvbnMlMEElMEFmJTIyJUYwJTlGJTkxJTg5JTIwTWFzayUyMFByZWRpY3Rpb25zJTIwU2hhcGUlM0ElMjAlN0JsaXN0KG1hc2tfcHJlZGljdGlvbnMuc2hhcGUpJTdEJTJDJTIwQ2xhc3MlMjBQcmVkaWN0aW9ucyUyMFNoYXBlJTNBJTIwJTdCbGlzdChjbGFzc19wcmVkaWN0aW9ucy5zaGFwZSklN0QlMjI=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OneFormerProcessor, OneFormerModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># download texting image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load processor for preprocessing the inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = OneFormerProcessor.from_pretrained(<span class="hljs-string">&quot;shi-labs/oneformer_ade20k_swin_tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OneFormerModel.from_pretrained(<span class="hljs-string">&quot;shi-labs/oneformer_ade20k_swin_tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, [<span class="hljs-string">&quot;semantic&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>mask_predictions = outputs.transformer_decoder_mask_predictions
<span class="hljs-meta">&gt;&gt;&gt; </span>class_predictions = outputs.transformer_decoder_class_predictions

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">f&quot;👉 Mask Predictions Shape: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(mask_predictions.shape)}</span>, Class Predictions Shape: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(class_predictions.shape)}</span>&quot;</span>
<span class="hljs-string">&#x27;👉 Mask Predictions Shape: [1, 150, 128, 171], Class Predictions Shape: [1, 150, 151]&#x27;</span>`,wrap:!1}}),{c(){m=n("p"),m.textContent=x,y=s(),g(w.$$.fragment)},l(d){m=r(d,"P",{"data-svelte-h":!0}),h(m)!=="svelte-11lpom8"&&(m.textContent=x),y=a(d),f(w.$$.fragment,d)},m(d,k){l(d,m,k),l(d,y,k),u(w,d,k),T=!0},p:Ko,i(d){T||(_(w.$$.fragment,d),T=!0)},o(d){v(w.$$.fragment,d),T=!1},d(d){d&&(o(m),o(y)),b(w,d)}}}function os($){let m,x=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){m=n("p"),m.innerHTML=x},l(y){m=r(y,"P",{"data-svelte-h":!0}),h(m)!=="svelte-fincs2"&&(m.innerHTML=x)},m(y,w){l(y,m,w)},p:Ko,d(y){y&&o(m)}}}function ts($){let m,x="Universal segmentation example:",y,w,T;return w=new Sn({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OneFormerProcessor, OneFormerForUniversalSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load OneFormer fine-tuned on ADE20k for universal segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = OneFormerProcessor.from_pretrained(<span class="hljs-string">&quot;shi-labs/oneformer_ade20k_swin_tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OneFormerForUniversalSegmentation.from_pretrained(<span class="hljs-string">&quot;shi-labs/oneformer_ade20k_swin_tiny&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_ade20k/resolve/main/ADE_val_00000001.jpg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Semantic Segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, [<span class="hljs-string">&quot;semantic&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can pass them to processor for semantic postprocessing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_semantic_map = processor.post_process_semantic_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">f&quot;👉 Semantic Predictions Shape: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(predicted_semantic_map.shape)}</span>&quot;</span>
<span class="hljs-string">&#x27;👉 Semantic Predictions Shape: [512, 683]&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Instance Segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, [<span class="hljs-string">&quot;instance&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can pass them to processor for instance postprocessing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_instance_map = processor.post_process_instance_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;segmentation&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">f&quot;👉 Instance Predictions Shape: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(predicted_instance_map.shape)}</span>&quot;</span>
<span class="hljs-string">&#x27;👉 Instance Predictions Shape: [512, 683]&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Panoptic Segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, [<span class="hljs-string">&quot;panoptic&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can pass them to processor for panoptic postprocessing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_panoptic_map = processor.post_process_panoptic_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;segmentation&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">f&quot;👉 Panoptic Predictions Shape: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(predicted_panoptic_map.shape)}</span>&quot;</span>
<span class="hljs-string">&#x27;👉 Panoptic Predictions Shape: [512, 683]&#x27;</span>`,wrap:!1}}),{c(){m=n("p"),m.textContent=x,y=s(),g(w.$$.fragment)},l(d){m=r(d,"P",{"data-svelte-h":!0}),h(m)!=="svelte-9x0o9r"&&(m.textContent=x),y=a(d),f(w.$$.fragment,d)},m(d,k){l(d,m,k),l(d,y,k),u(w,d,k),T=!0},p:Ko,i(d){T||(_(w.$$.fragment,d),T=!0)},o(d){v(w.$$.fragment,d),T=!1},d(d){d&&(o(m),o(y)),b(w,d)}}}function ns($){let m,x,y,w,T,d,k,_e,Rt,ro,Zn="OneFormer",et,S,A,Lo,ve,Gt,so,Ln="Overview",ot,be,Bn='The OneFormer model was proposed in <a href="https://arxiv.org/abs/2211.06220" rel="nofollow">OneFormer: One Transformer to Rule Universal Image Segmentation</a> by Jitesh Jain, Jiachen Li, MangTik Chiu, Ali Hassani, Nikita Orlov, Humphrey Shi. OneFormer is a universal image segmentation framework that can be trained on a single panoptic dataset to perform semantic, instance, and panoptic segmentation tasks. OneFormer uses a task token to condition the model on the task in focus, making the architecture task-guided for training, and task-dynamic for inference.',tt,ye,Hn,nt,we,Rn="The abstract from the paper is the following:",rt,Te,Gn="<em>Universal Image Segmentation is not a new concept. Past attempts to unify image segmentation in the last decades include scene parsing, panoptic segmentation, and, more recently, new panoptic architectures. However, such panoptic architectures do not truly unify image segmentation because they need to be trained individually on the semantic, instance, or panoptic segmentation to achieve the best performance. Ideally, a truly universal framework should be trained only once and achieve SOTA performance across all three image segmentation tasks. To that end, we propose OneFormer, a universal image segmentation framework that unifies segmentation with a multi-task train-once design. We first propose a task-conditioned joint training strategy that enables training on ground truths of each domain (semantic, instance, and panoptic segmentation) within a single multi-task training process. Secondly, we introduce a task token to condition our model on the task at hand, making our model task-dynamic to support multi-task training and inference. Thirdly, we propose using a query-text contrastive loss during training to establish better inter-task and inter-class distinctions. Notably, our single OneFormer model outperforms specialized Mask2Former models across all three segmentation tasks on ADE20k, CityScapes, and COCO, despite the latter being trained on each of the three tasks individually with three times the resources. With new ConvNeXt and DiNAT backbones, we observe even more performance improvement. We believe OneFormer is a significant step towards making image segmentation more universal and accessible.</em>",st,Fe,Vn="Tips:",at,xe,En=`<li>OneFormer requires two inputs during inference: <em>image</em> and <em>task token</em>.</li> <li>During training, OneFormer only uses panoptic annotations.</li> <li>If you want to train the model in a distributed environment across multiple nodes, then one should update the
<code>get_num_masks</code> function inside in the <code>OneFormerLoss</code> class of <code>modeling_oneformer.py</code>. When training on multiple nodes, this should be
set to the average number of target masks across all nodes, as can be seen in the original implementation <a href="https://github.com/SHI-Labs/OneFormer/blob/33ebb56ed34f970a30ae103e786c0cb64c653d9a/oneformer/modeling/criterion.py#L287" rel="nofollow">here</a>.</li> <li>One can use <a href="/docs/transformers/v4.34.0/en/model_doc/oneformer#transformers.OneFormerProcessor">OneFormerProcessor</a> to prepare input images and task inputs for the model and optional targets for the model. <code>OneformerProcessor</code> wraps <a href="/docs/transformers/v4.34.0/en/model_doc/oneformer#transformers.OneFormerImageProcessor">OneFormerImageProcessor</a> and <a href="/docs/transformers/v4.34.0/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> into a single instance to both prepare the images and encode the task inputs.</li> <li>To get the final segmentation, depending on the task, you can call <a href="/docs/transformers/v4.34.0/en/model_doc/oneformer#transformers.OneFormerProcessor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or <a href="/docs/transformers/v4.34.0/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_instance_segmentation">post_process_instance_segmentation()</a> or <a href="/docs/transformers/v4.34.0/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a>. All three tasks can be solved using <a href="/docs/transformers/v4.34.0/en/model_doc/oneformer#transformers.OneFormerForUniversalSegmentation">OneFormerForUniversalSegmentation</a> output, panoptic segmentation accepts an optional <code>label_ids_to_fuse</code> argument to fuse instances of the target object/s (e.g. sky) together.</li>`,it,Me,Xn='The figure below illustrates the architecture of OneFormer. Taken from the <a href="https://arxiv.org/abs/2211.06220" rel="nofollow">original paper</a>.',lt,ke,An,ct,Oe,Dn='This model was contributed by <a href="https://huggingface.co/praeclarumjj3" rel="nofollow">Jitesh Jain</a>. The original code can be found <a href="https://github.com/SHI-Labs/OneFormer" rel="nofollow">here</a>.',dt,Z,D,Bo,je,Vt,ao,Yn="Resources",mt,Ie,Qn="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with OneFormer.",pt,Ue,Kn='<li>Demo notebooks regarding inference + fine-tuning on custom data can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/OneFormer" rel="nofollow">here</a>.</li>',ht,$e,er=`If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we will review it.
The resource should ideally demonstrate something new instead of duplicating an existing resource.`,gt,L,Y,Ho,Je,Et,io,or="OneFormer specific outputs",ft,B,ze,Xt,lo,tr='Class for outputs of <a href="/docs/transformers/v4.34.0/en/model_doc/oneformer#transformers.OneFormerModel">OneFormerModel</a>. This class returns all the needed hidden states to compute the logits.',ut,C,Ce,At,co,nr="Class for outputs of <code>OneFormerForUniversalSegmentationOutput</code>.",Dt,mo,rr=`This output can be directly passed to <a href="/docs/transformers/v4.34.0/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or
<a href="/docs/transformers/v4.34.0/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_instance_segmentation">post_process_instance_segmentation()</a> or
<a href="/docs/transformers/v4.34.0/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a> depending on the task. Please, see
[\`~OneFormerImageProcessor] for details regarding usage.`,_t,H,Q,Ro,Ne,Yt,po,sr="OneFormerConfig",vt,U,Pe,Qt,ho,ar=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.34.0/en/model_doc/oneformer#transformers.OneFormerModel">OneFormerModel</a>. It is used to instantiate a
OneFormer model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the OneFormer
<a href="https://huggingface.co/shi-labs/oneformer_ade20k_swin_tiny" rel="nofollow">shi-labs/oneformer_ade20k_swin_tiny</a> architecture
trained on <a href="https://huggingface.co/datasets/scene_parse_150" rel="nofollow">ADE20k-150</a>.`,Kt,go,ir=`Configuration objects inherit from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,en,K,bt,R,ee,Go,qe,on,fo,lr="OneFormerImageProcessor",yt,F,We,tn,uo,cr=`Constructs a OneFormer image processor. The image processor can be used to prepare image(s), task input(s) and
optional text inputs and targets for the model.`,nn,_o,dr=`This image processor inherits from <code>BaseImageProcessor</code> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,rn,vo,Se,sn,q,Ze,an,bo,mr="Pad images up to the largest image in a batch and create a corresponding <code>pixel_mask</code>.",ln,yo,pr=`OneFormer addresses semantic segmentation with a mask classification paradigm, thus input segmentation maps
will be converted to lists of binary masks and their respective labels. Let’s see an example, assuming
<code>segmentation_maps = [[2,6,7,9]]</code>, the output will contain <code>mask_labels = [[1,0,0,0],[0,1,0,0],[0,0,1,0],[0,0,0,1]]</code> (four binary masks) and <code>class_labels = [2,6,7,9]</code>, the labels for
each mask.`,cn,oe,Le,dn,wo,hr=`Converts the output of <a href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a> into semantic segmentation maps. Only supports
PyTorch.`,mn,te,Be,pn,To,gr=`Converts the output of <code>OneFormerForUniversalSegmentationOutput</code> into image instance segmentation
predictions. Only supports PyTorch.`,hn,ne,He,gn,Fo,fr=`Converts the output of <code>MaskFormerForInstanceSegmentationOutput</code> into image panoptic segmentation
predictions. Only supports PyTorch.`,wt,G,re,Vo,Re,fn,xo,ur="OneFormerProcessor",Tt,O,Ge,un,Mo,_r=`Constructs an OneFormer processor which wraps <a href="/docs/transformers/v4.34.0/en/model_doc/oneformer#transformers.OneFormerImageProcessor">OneFormerImageProcessor</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a>/<a href="/docs/transformers/v4.34.0/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> into a single processor that inherits both the image processor and
tokenizer functionalities.`,_n,se,Ve,vn,ko,vr=`This method forwards all its arguments to <a href="/docs/transformers/v4.34.0/en/model_doc/oneformer#transformers.OneFormerImageProcessor.encode_inputs">OneFormerImageProcessor.encode_inputs()</a> and then tokenizes the
task_inputs. Please refer to the docstring of this method for more information.`,bn,ae,Ee,yn,Oo,br=`This method forwards all its arguments to <a href="/docs/transformers/v4.34.0/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_instance_segmentation">OneFormerImageProcessor.post_process_instance_segmentation()</a>.
Please refer to the docstring of this method for more information.`,wn,ie,Xe,Tn,jo,yr=`This method forwards all its arguments to <a href="/docs/transformers/v4.34.0/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_panoptic_segmentation">OneFormerImageProcessor.post_process_panoptic_segmentation()</a>.
Please refer to the docstring of this method for more information.`,Fn,le,Ae,xn,Io,wr=`This method forwards all its arguments to <a href="/docs/transformers/v4.34.0/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_semantic_segmentation">OneFormerImageProcessor.post_process_semantic_segmentation()</a>.
Please refer to the docstring of this method for more information.`,Ft,V,ce,Eo,De,Mn,Uo,Tr="OneFormerModel",xt,N,Ye,kn,$o,Fr=`The bare OneFormer Model outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">nn.Module</a> sub-class. Use it as a
regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and behavior.`,On,J,Qe,jn,Jo,xr='The <a href="/docs/transformers/v4.34.0/en/model_doc/oneformer#transformers.OneFormerModel">OneFormerModel</a> forward method, overrides the <code>__call__</code> special method.',In,de,Un,me,Mt,E,pe,Xo,Ke,$n,zo,Mr="OneFormerForUniversalSegmentation",kt,P,eo,Jn,Co,kr=`OneFormer Model for instance, semantic and panoptic image segmentation.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">nn.Module</a> sub-class. Use it as a
regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and behavior.`,zn,I,oo,Cn,No,Or='The <a href="/docs/transformers/v4.34.0/en/model_doc/oneformer#transformers.OneFormerForUniversalSegmentation">OneFormerForUniversalSegmentation</a> forward method, overrides the <code>__call__</code> special method.',Nn,he,Pn,Po,jr="Example:",qn,ge,Ot,Ao,jt;return _e=new X({}),ve=new X({}),je=new X({}),Je=new X({}),ze=new M({props:{name:"class transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput",anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput",parameters:[{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"pixel_decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"transformer_decoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"transformer_decoder_object_queries",val:": FloatTensor = None"},{name:"transformer_decoder_contrastive_queries",val:": typing.Optional[torch.FloatTensor] = None"},{name:"transformer_decoder_mask_predictions",val:": FloatTensor = None"},{name:"transformer_decoder_class_predictions",val:": FloatTensor = None"},{name:"transformer_decoder_auxiliary_predictions",val:": typing.Union[typing.Tuple[typing.Dict[str, torch.FloatTensor]], NoneType] = None"},{name:"text_queries",val:": typing.Optional[torch.FloatTensor] = None"},{name:"task_token",val:": FloatTensor = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.`,name:"encoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.pixel_decoder_hidden_states",description:`<strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.`,name:"pixel_decoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_hidden_states",description:`<strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.`,name:"transformer_decoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_object_queries",description:`<strong>transformer_decoder_object_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Output object queries from the last layer in the transformer decoder.`,name:"transformer_decoder_object_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_contrastive_queries",description:`<strong>transformer_decoder_contrastive_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Contrastive queries from the transformer decoder.`,name:"transformer_decoder_contrastive_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_mask_predictions",description:`<strong>transformer_decoder_mask_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, height, width)</code>) &#x2014;
Mask Predictions from the last layer in the transformer decoder.`,name:"transformer_decoder_mask_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_class_predictions",description:`<strong>transformer_decoder_class_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes+1)</code>) &#x2014;
Class Predictions from the last layer in the transformer decoder.`,name:"transformer_decoder_class_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_auxiliary_predictions",description:`<strong>transformer_decoder_auxiliary_predictions</strong> (Tuple of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Tuple of class and mask predictions from each layer of the transformer decoder.`,name:"transformer_decoder_auxiliary_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.text_queries",description:`<strong>text_queries</strong> (<code>torch.FloatTensor</code>, <em>optional</em> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Text queries derived from the input text list used for calculating contrastive loss during training.`,name:"text_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.task_token",description:`<strong>task_token</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_dim)</code>) &#x2014;
1D task token to condition the queries.`,name:"task_token"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/oneformer/modeling_oneformer.py#L804"}}),Ce=new M({props:{name:"class transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput",anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"class_queries_logits",val:": FloatTensor = None"},{name:"masks_queries_logits",val:": FloatTensor = None"},{name:"auxiliary_predictions",val:": typing.List[typing.Dict[str, torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"pixel_decoder_hidden_states",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"transformer_decoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"transformer_decoder_object_queries",val:": FloatTensor = None"},{name:"transformer_decoder_contrastive_queries",val:": typing.Optional[torch.FloatTensor] = None"},{name:"transformer_decoder_mask_predictions",val:": FloatTensor = None"},{name:"transformer_decoder_class_predictions",val:": FloatTensor = None"},{name:"transformer_decoder_auxiliary_predictions",val:": typing.Union[typing.List[typing.Dict[str, torch.FloatTensor]], NoneType] = None"},{name:"text_queries",val:": typing.Optional[torch.FloatTensor] = None"},{name:"task_token",val:": FloatTensor = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.loss",description:`<strong>loss</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
The computed loss, returned when labels are present.`,name:"loss"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.class_queries_logits",description:`<strong>class_queries_logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
A tensor of shape <code>(batch_size, num_queries, num_labels + 1)</code> representing the proposed classes for each
query. Note the <code>+ 1</code> is needed because we incorporate the null class.`,name:"class_queries_logits"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.masks_queries_logits",description:`<strong>masks_queries_logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
A tensor of shape <code>(batch_size, num_queries, height, width)</code> representing the proposed masks for each
query.`,name:"masks_queries_logits"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.auxiliary_predictions",description:`<strong>auxiliary_predictions</strong> (List of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) &#x2014;
List of class and mask predictions from each layer of the transformer decoder.`,name:"auxiliary_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.`,name:"encoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.pixel_decoder_hidden_states",description:`<strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.`,name:"pixel_decoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_hidden_states",description:`<strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.`,name:"transformer_decoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_object_queries",description:`<strong>transformer_decoder_object_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Output object queries from the last layer in the transformer decoder.`,name:"transformer_decoder_object_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_contrastive_queries",description:`<strong>transformer_decoder_contrastive_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Contrastive queries from the transformer decoder.`,name:"transformer_decoder_contrastive_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_mask_predictions",description:`<strong>transformer_decoder_mask_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, height, width)</code>) &#x2014;
Mask Predictions from the last layer in the transformer decoder.`,name:"transformer_decoder_mask_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_class_predictions",description:`<strong>transformer_decoder_class_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes+1)</code>) &#x2014;
Class Predictions from the last layer in the transformer decoder.`,name:"transformer_decoder_class_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_auxiliary_predictions",description:`<strong>transformer_decoder_auxiliary_predictions</strong> (List of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) &#x2014;
List of class and mask predictions from each layer of the transformer decoder.`,name:"transformer_decoder_auxiliary_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.text_queries",description:`<strong>text_queries</strong> (<code>torch.FloatTensor</code>, <em>optional</em> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Text queries derived from the input text list used for calculating contrastive loss during training.`,name:"text_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.task_token",description:`<strong>task_token</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_dim)</code>) &#x2014;
1D task token to condition the queries.`,name:"task_token"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/oneformer/modeling_oneformer.py#L854"}}),Ne=new X({}),Pe=new M({props:{name:"class transformers.OneFormerConfig",anchor:"transformers.OneFormerConfig",parameters:[{name:"backbone_config",val:": typing.Optional[typing.Dict] = None"},{name:"ignore_value",val:": int = 255"},{name:"num_queries",val:": int = 150"},{name:"no_object_weight",val:": int = 0.1"},{name:"class_weight",val:": float = 2.0"},{name:"mask_weight",val:": float = 5.0"},{name:"dice_weight",val:": float = 5.0"},{name:"contrastive_weight",val:": float = 0.5"},{name:"contrastive_temperature",val:": float = 0.07"},{name:"train_num_points",val:": int = 12544"},{name:"oversample_ratio",val:": float = 3.0"},{name:"importance_sample_ratio",val:": float = 0.75"},{name:"init_std",val:": float = 0.02"},{name:"init_xavier_std",val:": float = 1.0"},{name:"layer_norm_eps",val:": float = 1e-05"},{name:"is_training",val:": bool = False"},{name:"use_auxiliary_loss",val:": bool = True"},{name:"output_auxiliary_logits",val:": bool = True"},{name:"strides",val:": typing.Optional[list] = [4, 8, 16, 32]"},{name:"task_seq_len",val:": int = 77"},{name:"text_encoder_width",val:": int = 256"},{name:"text_encoder_context_length",val:": int = 77"},{name:"text_encoder_num_layers",val:": int = 6"},{name:"text_encoder_vocab_size",val:": int = 49408"},{name:"text_encoder_proj_layers",val:": int = 2"},{name:"text_encoder_n_ctx",val:": int = 16"},{name:"conv_dim",val:": int = 256"},{name:"mask_dim",val:": int = 256"},{name:"hidden_dim",val:": int = 256"},{name:"encoder_feedforward_dim",val:": int = 1024"},{name:"norm",val:": str = 'GN'"},{name:"encoder_layers",val:": int = 6"},{name:"decoder_layers",val:": int = 10"},{name:"use_task_norm",val:": bool = True"},{name:"num_attention_heads",val:": int = 8"},{name:"dropout",val:": float = 0.1"},{name:"dim_feedforward",val:": int = 2048"},{name:"pre_norm",val:": bool = False"},{name:"enforce_input_proj",val:": bool = False"},{name:"query_dec_layers",val:": int = 2"},{name:"common_stride",val:": int = 4"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.OneFormerConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code>, <em>optional</em>, defaults to <code>SwinConfig</code>) &#x2014;
The configuration of the backbone model.`,name:"backbone_config"},{anchor:"transformers.OneFormerConfig.ignore_value",description:`<strong>ignore_value</strong> (<code>int</code>, <em>optional</em>, defaults to 255) &#x2014;
Values to be ignored in GT label while calculating loss.`,name:"ignore_value"},{anchor:"transformers.OneFormerConfig.num_queries",description:`<strong>num_queries</strong> (<code>int</code>, <em>optional</em>, defaults to 150) &#x2014;
Number of object queries.`,name:"num_queries"},{anchor:"transformers.OneFormerConfig.no_object_weight",description:`<strong>no_object_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Weight for no-object class predictions.`,name:"no_object_weight"},{anchor:"transformers.OneFormerConfig.class_weight",description:`<strong>class_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 2.0) &#x2014;
Weight for Classification CE loss.`,name:"class_weight"},{anchor:"transformers.OneFormerConfig.mask_weight",description:`<strong>mask_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Weight for binary CE loss.`,name:"mask_weight"},{anchor:"transformers.OneFormerConfig.dice_weight",description:`<strong>dice_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Weight for dice loss.`,name:"dice_weight"},{anchor:"transformers.OneFormerConfig.contrastive_weight",description:`<strong>contrastive_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Weight for contrastive loss.`,name:"contrastive_weight"},{anchor:"transformers.OneFormerConfig.contrastive_temperature",description:`<strong>contrastive_temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 0.07) &#x2014;
Initial value for scaling the contrastive logits.`,name:"contrastive_temperature"},{anchor:"transformers.OneFormerConfig.train_num_points",description:`<strong>train_num_points</strong> (<code>int</code>, <em>optional</em>, defaults to 12544) &#x2014;
Number of points to sample while calculating losses on mask predictions.`,name:"train_num_points"},{anchor:"transformers.OneFormerConfig.oversample_ratio",description:`<strong>oversample_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 3.0) &#x2014;
Ratio to decide how many points to oversample.`,name:"oversample_ratio"},{anchor:"transformers.OneFormerConfig.importance_sample_ratio",description:`<strong>importance_sample_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 0.75) &#x2014;
Ratio of points that are sampled via importance sampling.`,name:"importance_sample_ratio"},{anchor:"transformers.OneFormerConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
Standard deviation for normal intialization.`,name:"init_std"},{anchor:"transformers.OneFormerConfig.init_xavier_std",description:`<strong>init_xavier_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
Standard deviation for xavier uniform initialization.`,name:"init_xavier_std"},{anchor:"transformers.OneFormerConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
Epsilon for layer normalization.`,name:"layer_norm_eps"},{anchor:"transformers.OneFormerConfig.is_training",description:`<strong>is_training</strong> (<code>bool</code>, <em>optional</em>, defaults to False) &#x2014;
Whether to run in training or inference mode.`,name:"is_training"},{anchor:"transformers.OneFormerConfig.use_auxiliary_loss",description:`<strong>use_auxiliary_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to True) &#x2014;
Whether to calculate loss using intermediate predictions from transformer decoder.`,name:"use_auxiliary_loss"},{anchor:"transformers.OneFormerConfig.output_auxiliary_logits",description:`<strong>output_auxiliary_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to True) &#x2014;
Whether to return intermediate predictions from transformer decoder.`,name:"output_auxiliary_logits"},{anchor:"transformers.OneFormerConfig.strides",description:`<strong>strides</strong> (<code>list</code>, <em>optional</em>, defaults to [4, 8, 16, 32]) &#x2014;
List containing the strides for feature maps in the encoder.`,name:"strides"},{anchor:"transformers.OneFormerConfig.task_seq_len",description:`<strong>task_seq_len</strong> (<code>int</code>, <em>optional</em>, defaults to 77) &#x2014;
Sequence length for tokenizing text list input.`,name:"task_seq_len"},{anchor:"transformers.OneFormerConfig.text_encoder_width",description:`<strong>text_encoder_width</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Hidden size for text encoder.`,name:"text_encoder_width"},{anchor:"transformers.OneFormerConfig.text_encoder_context_length",description:`<strong>text_encoder_context_length</strong> (<code>int</code>, <em>optional</em>, defaults to 77) &#x2014;
Input sequence length for text encoder.`,name:"text_encoder_context_length"},{anchor:"transformers.OneFormerConfig.text_encoder_num_layers",description:`<strong>text_encoder_num_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of layers for transformer in text encoder.`,name:"text_encoder_num_layers"},{anchor:"transformers.OneFormerConfig.text_encoder_vocab_size",description:`<strong>text_encoder_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 49408) &#x2014;
Vocabulary size for tokenizer.`,name:"text_encoder_vocab_size"},{anchor:"transformers.OneFormerConfig.text_encoder_proj_layers",description:`<strong>text_encoder_proj_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Number of layers in MLP for project text queries.`,name:"text_encoder_proj_layers"},{anchor:"transformers.OneFormerConfig.text_encoder_n_ctx",description:`<strong>text_encoder_n_ctx</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of learnable text context queries.`,name:"text_encoder_n_ctx"},{anchor:"transformers.OneFormerConfig.conv_dim",description:`<strong>conv_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Feature map dimension to map outputs from the backbone.`,name:"conv_dim"},{anchor:"transformers.OneFormerConfig.mask_dim",description:`<strong>mask_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimension for feature maps in pixel decoder.`,name:"mask_dim"},{anchor:"transformers.OneFormerConfig.hidden_dim",description:`<strong>hidden_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimension for hidden states in transformer decoder.`,name:"hidden_dim"},{anchor:"transformers.OneFormerConfig.encoder_feedforward_dim",description:`<strong>encoder_feedforward_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimension for FFN layer in pixel decoder.`,name:"encoder_feedforward_dim"},{anchor:"transformers.OneFormerConfig.norm",description:`<strong>norm</strong> (<code>str</code>, <em>optional</em>, defaults to <code>GN</code>) &#x2014;
Type of normalization.`,name:"norm"},{anchor:"transformers.OneFormerConfig.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of layers in pixel decoder.`,name:"encoder_layers"},{anchor:"transformers.OneFormerConfig.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
Number of layers in transformer decoder.`,name:"decoder_layers"},{anchor:"transformers.OneFormerConfig.use_task_norm",description:`<strong>use_task_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the task token.`,name:"use_task_norm"},{anchor:"transformers.OneFormerConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads in transformer layers in the pixel and transformer decoders.`,name:"num_attention_heads"},{anchor:"transformers.OneFormerConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Dropout probability for pixel and transformer decoders.`,name:"dropout"},{anchor:"transformers.OneFormerConfig.dim_feedforward",description:`<strong>dim_feedforward</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension for FFN layer in transformer decoder.`,name:"dim_feedforward"},{anchor:"transformers.OneFormerConfig.pre_norm",description:`<strong>pre_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize hidden states before attention layers in transformer decoder.`,name:"pre_norm"},{anchor:"transformers.OneFormerConfig.enforce_input_proj",description:`<strong>enforce_input_proj</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to project hidden states in transformer decoder.`,name:"enforce_input_proj"},{anchor:"transformers.OneFormerConfig.query_dec_layers",description:`<strong>query_dec_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Number of layers in query transformer.`,name:"query_dec_layers"},{anchor:"transformers.OneFormerConfig.common_stride",description:`<strong>common_stride</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Common stride used for features in pixel decoder.`,name:"common_stride"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/oneformer/configuration_oneformer.py#L33"}}),K=new Wn({props:{anchor:"transformers.OneFormerConfig.example",$$slots:{default:[Qr]},$$scope:{ctx:$}}}),qe=new X({}),We=new M({props:{name:"class transformers.OneFormerImageProcessor",anchor:"transformers.OneFormerImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": float = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float]] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float]] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"do_reduce_labels",val:": bool = False"},{name:"repo_path",val:": str = 'shi-labs/oneformer_demo'"},{name:"class_info_file",val:": str = None"},{name:"num_text",val:": typing.Optional[int] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.OneFormerImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the input to a certain <code>size</code>.`,name:"do_resize"},{anchor:"transformers.OneFormerImageProcessor.size",description:`<strong>size</strong> (<code>int</code>, <em>optional</em>, defaults to 800) &#x2014;
Resize the input to the given size. Only has an effect if <code>do_resize</code> is set to <code>True</code>. If size is a
sequence like <code>(width, height)</code>, output size will be matched to this. If size is an int, smaller edge of
the image will be matched to this number. i.e, if <code>height &gt; width</code>, then image will be rescaled to <code>(size * height / width, size)</code>.`,name:"size"},{anchor:"transformers.OneFormerImageProcessor.max_size",description:`<strong>max_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1333) &#x2014;
The largest size an image dimension can have (otherwise it&#x2019;s capped). Only has an effect if <code>do_resize</code> is
set to <code>True</code>.`,name:"max_size"},{anchor:"transformers.OneFormerImageProcessor.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>PIL.Image.Resampling.BILINEAR</code>) &#x2014;
An optional resampling filter. This can be one of <code>PIL.Image.Resampling.NEAREST</code>,
<code>PIL.Image.Resampling.BOX</code>, <code>PIL.Image.Resampling.BILINEAR</code>, <code>PIL.Image.Resampling.HAMMING</code>,
<code>PIL.Image.Resampling.BICUBIC</code> or <code>PIL.Image.Resampling.LANCZOS</code>. Only has an effect if <code>do_resize</code> is set
to <code>True</code>.`,name:"resample"},{anchor:"transformers.OneFormerImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the input to a certain <code>scale</code>.`,name:"do_rescale"},{anchor:"transformers.OneFormerImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1/ 255) &#x2014;
Rescale the input by the given factor. Only has an effect if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.OneFormerImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to normalize the input with mean and standard deviation.`,name:"do_normalize"},{anchor:"transformers.OneFormerImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>int</code>, <em>optional</em>, defaults to <code>[0.485, 0.456, 0.406]</code>) &#x2014;
The sequence of means for each channel, to be used when normalizing images. Defaults to the ImageNet mean.`,name:"image_mean"},{anchor:"transformers.OneFormerImageProcessor.image_std",description:`<strong>image_std</strong> (<code>int</code>, <em>optional</em>, defaults to <code>[0.229, 0.224, 0.225]</code>) &#x2014;
The sequence of standard deviations for each channel, to be used when normalizing images. Defaults to the
ImageNet std.`,name:"image_std"},{anchor:"transformers.OneFormerImageProcessor.ignore_index",description:`<strong>ignore_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Label to be assigned to background pixels in segmentation maps. If provided, segmentation map pixels
denoted with 0 (background) will be replaced with <code>ignore_index</code>.`,name:"ignore_index"},{anchor:"transformers.OneFormerImageProcessor.do_reduce_labels",description:`<strong>do_reduce_labels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to decrement all label values of segmentation maps by 1. Usually used for datasets where 0
is used for background, and background itself is not included in all classes of a dataset (e.g. ADE20k).
The background label will be replaced by <code>ignore_index</code>.`,name:"do_reduce_labels"},{anchor:"transformers.OneFormerImageProcessor.repo_path",description:`<strong>repo_path</strong> (<code>str</code>, defaults to <code>shi-labs/oneformer_demo</code>) &#x2014;
Dataset repository on huggingface hub containing the JSON file with class information for the dataset.`,name:"repo_path"},{anchor:"transformers.OneFormerImageProcessor.class_info_file",description:`<strong>class_info_file</strong> (<code>str</code>) &#x2014;
JSON file containing class information for the dataset. It is stored inside on the <code>repo_path</code> dataset
repository.`,name:"class_info_file"},{anchor:"transformers.OneFormerImageProcessor.num_text",description:`<strong>num_text</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of text entries in the text input list.`,name:"num_text"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/oneformer/image_processing_oneformer.py#L348"}}),Se=new M({props:{name:"preprocess",anchor:"transformers.OneFormerImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"task_inputs",val:": typing.Optional[typing.List[str]] = None"},{name:"segmentation_maps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')], NoneType] = None"},{name:"instance_id_to_semantic_id",val:": typing.Union[typing.Dict[int, int], NoneType] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Union[typing.Dict[str, int], NoneType] = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"do_reduce_labels",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/oneformer/image_processing_oneformer.py#L636"}}),Ze=new M({props:{name:"encode_inputs",anchor:"transformers.OneFormerImageProcessor.encode_inputs",parameters:[{name:"pixel_values_list",val:": typing.List[typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]]"},{name:"task_inputs",val:": typing.List[str]"},{name:"segmentation_maps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]] = None"},{name:"instance_id_to_semantic_id",val:": typing.Union[typing.List[typing.Dict[int, int]], typing.Dict[int, int], NoneType] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"reduce_labels",val:": bool = False"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.OneFormerImageProcessor.encode_inputs.pixel_values_list",description:`<strong>pixel_values_list</strong> (<code>List[ImageInput]</code>) &#x2014;
List of images (pixel values) to be padded. Each image should be a tensor of shape <code>(channels, height, width)</code>.`,name:"pixel_values_list"},{anchor:"transformers.OneFormerImageProcessor.encode_inputs.task_inputs",description:`<strong>task_inputs</strong> (<code>List[str]</code>) &#x2014;
List of task values.`,name:"task_inputs"},{anchor:"transformers.OneFormerImageProcessor.encode_inputs.segmentation_maps",description:`<strong>segmentation_maps</strong> (<code>ImageInput</code>, <em>optional</em>) &#x2014;
The corresponding semantic segmentation maps with the pixel-wise annotations.</p>
<p>(<code>bool</code>, <em>optional</em>, defaults to <code>True</code>):
Whether or not to pad images up to the largest image in a batch and create a pixel mask.</p>
<p>If left to the default, will return a pixel mask that is:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>`,name:"segmentation_maps"},{anchor:"transformers.OneFormerImageProcessor.encode_inputs.instance_id_to_semantic_id",description:`<strong>instance_id_to_semantic_id</strong> (<code>List[Dict[int, int]]</code> or <code>Dict[int, int]</code>, <em>optional</em>) &#x2014;
A mapping between object instance ids and class ids. If passed, <code>segmentation_maps</code> is treated as an
instance segmentation map where each pixel represents an instance id. Can be provided as a single
dictionary with a global/dataset-level mapping or as a list of dictionaries (one per image), to map
instance ids in each image separately.`,name:"instance_id_to_semantic_id"},{anchor:"transformers.OneFormerImageProcessor.encode_inputs.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/v4.34.0/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of NumPy arrays. If set to <code>&apos;pt&apos;</code>, return PyTorch <code>torch.Tensor</code>
objects.`,name:"return_tensors"},{anchor:"transformers.OneFormerImageProcessor.encode_inputs.input_data_format",description:`<strong>input_data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred from the input
image.`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/oneformer/image_processing_oneformer.py#L934",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>pixel_values</strong> — Pixel values to be fed to a model.</li>
<li><strong>pixel_mask</strong> — Pixel mask to be fed to a model (when <code>=True</code> or if <code>pixel_mask</code> is in
<code>self.model_input_names</code>).</li>
<li><strong>mask_labels</strong> — Optional list of mask labels of shape <code>(labels, height, width)</code> to be fed to a model
(when <code>annotations</code> are provided).</li>
<li><strong>class_labels</strong> — Optional list of class labels of shape <code>(labels)</code> to be fed to a model (when
<code>annotations</code> are provided). They identify the labels of <code>mask_labels</code>, e.g. the label of
<code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.</li>
<li><strong>text_inputs</strong> — Optional list of text string entries to be fed to a model (when <code>annotations</code> are
provided). They identify the binary masks present in the image.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),Le=new M({props:{name:"post_process_semantic_segmentation",anchor:"transformers.OneFormerImageProcessor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"}],parametersDescription:[{anchor:"transformers.OneFormerImageProcessor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.OneFormerImageProcessor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/oneformer/image_processing_oneformer.py#L1069",returnDescription:`
<p>A list of length <code>batch_size</code>, where each item is a semantic segmentation map of shape (height, width)
corresponding to the target_sizes entry (if <code>target_sizes</code> is specified). Each entry of each
<code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`
<p><code>List[torch.Tensor]</code></p>
`}}),Be=new M({props:{name:"post_process_instance_segmentation",anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation",parameters:[{name:"outputs",val:""},{name:"task_type",val:": str = 'instance'"},{name:"is_demo",val:": bool = True"},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"},{name:"return_coco_annotation",val:": typing.Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.outputs",description:`<strong>outputs</strong> (<code>OneFormerForUniversalSegmentationOutput</code>) &#x2014;
The outputs from <code>OneFormerForUniversalSegmentationOutput</code>.`,name:"outputs"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.task_type",description:`<strong>task_type</strong> (<code>str</code>, <em>optional)</em>, defaults to &#x201C;instance&#x201D;) &#x2014;
The post processing depends on the task token input. If the <code>task_type</code> is &#x201C;panoptic&#x201D;, we need to
ignore the stuff predictions.`,name:"task_type"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.is_demo",description:`<strong>is_demo</strong> (<code>bool</code>, <em>optional)</em>, defaults to <code>True</code>) &#x2014;
Whether the model is in demo mode. If true, use threshold to predict final masks.`,name:"is_demo"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction in batch. If left to None, predictions will not be
resized.`,name:"target_sizes"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.return_coco_annotation",description:`<strong>return_coco_annotation</strong> (<code>bool</code>, <em>optional)</em>, defaults to <code>False</code>) &#x2014;
Whether to return predictions in COCO format.`,name:"return_coco_annotation"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/oneformer/image_processing_oneformer.py#L1119",returnDescription:`
<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — a tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code>, set
to <code>None</code> if no mask if found above <code>threshold</code>. If <code>target_sizes</code> is specified, segmentation is resized
to the corresponding <code>target_sizes</code> entry.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — an integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>was_fused</strong> — a boolean, <code>True</code> if <code>label_id</code> was in <code>label_ids_to_fuse</code>, <code>False</code> otherwise.
Multiple instances of the same class / label were fused and assigned a single <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`
<p><code>List[Dict]</code></p>
`}}),He=new M({props:{name:"post_process_panoptic_segmentation",anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"label_ids_to_fuse",val:": typing.Optional[typing.Set[int]] = None"},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"}],parametersDescription:[{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.outputs",description:`<strong>outputs</strong> (<code>MaskFormerForInstanceSegmentationOutput</code>) &#x2014;
The outputs from <a href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>.`,name:"outputs"},{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.label_ids_to_fuse",description:`<strong>label_ids_to_fuse</strong> (<code>Set[int]</code>, <em>optional</em>) &#x2014;
The labels in this state will have all their instances be fused together. For instance we could say
there can only be one sky in an image, but several persons, so the label ID for sky would be in that
set, but not the one for person.`,name:"label_ids_to_fuse"},{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction in batch. If left to None, predictions will not be
resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/oneformer/image_processing_oneformer.py#L1238",returnDescription:`
<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — a tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code>, set
to <code>None</code> if no mask if found above <code>threshold</code>. If <code>target_sizes</code> is specified, segmentation is resized
to the corresponding <code>target_sizes</code> entry.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — an integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>was_fused</strong> — a boolean, <code>True</code> if <code>label_id</code> was in <code>label_ids_to_fuse</code>, <code>False</code> otherwise.
Multiple instances of the same class / label were fused and assigned a single <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`
<p><code>List[Dict]</code></p>
`}}),Re=new X({}),Ge=new M({props:{name:"class transformers.OneFormerProcessor",anchor:"transformers.OneFormerProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"max_seq_length",val:": int = 77"},{name:"task_seq_length",val:": int = 77"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.OneFormerProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/oneformer#transformers.OneFormerImageProcessor">OneFormerImageProcessor</a>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.OneFormerProcessor.tokenizer",description:`<strong>tokenizer</strong> ([<code>CLIPTokenizer</code>, <code>CLIPTokenizerFast</code>]) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.OneFormerProcessor.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>, defaults to 77)) &#x2014;
Sequence length for input text list.`,name:"max_seq_len"},{anchor:"transformers.OneFormerProcessor.task_seq_len",description:`<strong>task_seq_len</strong> (<code>int</code>, <em>optional</em>, defaults to 77) &#x2014;
Sequence length for input task token.`,name:"task_seq_len"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/oneformer/processing_oneformer.py#L29"}}),Ve=new M({props:{name:"encode_inputs",anchor:"transformers.OneFormerProcessor.encode_inputs",parameters:[{name:"images",val:" = None"},{name:"task_inputs",val:" = None"},{name:"segmentation_maps",val:" = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/oneformer/processing_oneformer.py#L145"}}),Ee=new M({props:{name:"post_process_instance_segmentation",anchor:"transformers.OneFormerProcessor.post_process_instance_segmentation",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/oneformer/processing_oneformer.py#L192"}}),Xe=new M({props:{name:"post_process_panoptic_segmentation",anchor:"transformers.OneFormerProcessor.post_process_panoptic_segmentation",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/oneformer/processing_oneformer.py#L199"}}),Ae=new M({props:{name:"post_process_semantic_segmentation",anchor:"transformers.OneFormerProcessor.post_process_semantic_segmentation",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/oneformer/processing_oneformer.py#L185"}}),De=new X({}),Ye=new M({props:{name:"class transformers.OneFormerModel",anchor:"transformers.OneFormerModel",parameters:[{name:"config",val:": OneFormerConfig"}],parametersDescription:[{anchor:"transformers.OneFormerModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/oneformer#transformers.OneFormerConfig">OneFormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/oneformer/modeling_oneformer.py#L2902"}}),Qe=new M({props:{name:"forward",anchor:"transformers.OneFormerModel.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"task_inputs",val:": Tensor"},{name:"text_inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"pixel_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.OneFormerModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/oneformer#transformers.OneFormerProcessor">OneFormerProcessor</a>. See
<code>OneFormerProcessor.__call__()</code> for details.`,name:"pixel_values"},{anchor:"transformers.OneFormerModel.forward.task_inputs",description:`<strong>task_inputs</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Task inputs. Task inputs can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <code>OneFormerProcessor.__call__()</code>
for details.`,name:"task_inputs"},{anchor:"transformers.OneFormerModel.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.OneFormerModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.OneFormerModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of Detr&#x2019;s decoder attention layers.`,name:"output_attentions"},{anchor:"transformers.OneFormerModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>~OneFormerModelOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/oneformer/modeling_oneformer.py#L2919",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/model_doc/oneformer#transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput"
>transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/oneformer#transformers.OneFormerConfig"
>OneFormerConfig</a>) and inputs.</p>
<ul>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.</li>
<li><strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.</li>
<li><strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.</li>
<li><strong>transformer_decoder_object_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Output object queries from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_contrastive_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Contrastive queries from the transformer decoder.</li>
<li><strong>transformer_decoder_mask_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, height, width)</code>)
Mask Predictions from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_class_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes+1)</code>) — Class Predictions from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_auxiliary_predictions</strong> (Tuple of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) — Tuple of class and mask predictions from each layer of the transformer decoder.</li>
<li><strong>text_queries</strong> (<code>torch.FloatTensor</code>, <em>optional</em> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Text queries derived from the input text list used for calculating contrastive loss during training.</li>
<li><strong>task_token</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_dim)</code>)
1D task token to condition the queries.</li>
<li><strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.</li>
</ul>
<p><code>OneFormerModelOutput</code></p>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/model_doc/oneformer#transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput"
>transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),de=new Vr({props:{$$slots:{default:[Kr]},$$scope:{ctx:$}}}),me=new Wn({props:{anchor:"transformers.OneFormerModel.forward.example",$$slots:{default:[es]},$$scope:{ctx:$}}}),Ke=new X({}),eo=new M({props:{name:"class transformers.OneFormerForUniversalSegmentation",anchor:"transformers.OneFormerForUniversalSegmentation",parameters:[{name:"config",val:": OneFormerConfig"}],parametersDescription:[{anchor:"transformers.OneFormerForUniversalSegmentation.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/oneformer#transformers.OneFormerConfig">OneFormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/oneformer/modeling_oneformer.py#L3031"}}),oo=new M({props:{name:"forward",anchor:"transformers.OneFormerForUniversalSegmentation.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"task_inputs",val:": Tensor"},{name:"text_inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"mask_labels",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"class_labels",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"pixel_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_auxiliary_logits",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.OneFormerForUniversalSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/oneformer#transformers.OneFormerProcessor">OneFormerProcessor</a>. See
<code>OneFormerProcessor.__call__()</code> for details.`,name:"pixel_values"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.task_inputs",description:`<strong>task_inputs</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Task inputs. Task inputs can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <code>OneFormerProcessor.__call__()</code>
for details.`,name:"task_inputs"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of Detr&#x2019;s decoder attention layers.`,name:"output_attentions"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>~OneFormerModelOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.text_inputs",description:`<strong>text_inputs</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Tensor fof shape <code>(num_queries, sequence_length)</code> to be fed to a model`,name:"text_inputs"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.mask_labels",description:`<strong>mask_labels</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
List of mask labels of shape <code>(num_labels, height, width)</code> to be fed to a model`,name:"mask_labels"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.class_labels",description:`<strong>class_labels</strong> (<code>List[torch.LongTensor]</code>, <em>optional</em>) &#x2014;
list of target class labels of shape <code>(num_labels, height, width)</code> to be fed to a model. They identify the
labels of <code>mask_labels</code>, e.g. the label of <code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.`,name:"class_labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/oneformer/modeling_oneformer.py#L3098",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/model_doc/oneformer#transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput"
>transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/oneformer#transformers.OneFormerConfig"
>OneFormerConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.Tensor</code>, <em>optional</em>) — The computed loss, returned when labels are present.</li>
<li><strong>class_queries_logits</strong> (<code>torch.FloatTensor</code>) — A tensor of shape <code>(batch_size, num_queries, num_labels + 1)</code> representing the proposed classes for each
query. Note the <code>+ 1</code> is needed because we incorporate the null class.</li>
<li><strong>masks_queries_logits</strong> (<code>torch.FloatTensor</code>) — A tensor of shape <code>(batch_size, num_queries, height, width)</code> representing the proposed masks for each
query.</li>
<li><strong>auxiliary_predictions</strong> (List of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) — List of class and mask predictions from each layer of the transformer decoder.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.</li>
<li><strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.</li>
<li><strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.</li>
<li><strong>transformer_decoder_object_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Output object queries from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_contrastive_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Contrastive queries from the transformer decoder.</li>
<li><strong>transformer_decoder_mask_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, height, width)</code>)
Mask Predictions from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_class_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes+1)</code>) — Class Predictions from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_auxiliary_predictions</strong> (List of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) — List of class and mask predictions from each layer of the transformer decoder.</li>
<li><strong>text_queries</strong> (<code>torch.FloatTensor</code>, <em>optional</em> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Text queries derived from the input text list used for calculating contrastive loss during training.</li>
<li><strong>task_token</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_dim)</code>)
1D task token to condition the queries.</li>
<li><strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.</li>
</ul>
<p><code>OneFormerUniversalSegmentationOutput</code></p>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/model_doc/oneformer#transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput"
>transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),he=new Vr({props:{$$slots:{default:[os]},$$scope:{ctx:$}}}),ge=new Wn({props:{anchor:"transformers.OneFormerForUniversalSegmentation.forward.example",$$slots:{default:[ts]},$$scope:{ctx:$}}}),{c(){m=n("meta"),x=s(),y=n("p"),w=s(),T=n("h1"),d=n("a"),k=n("span"),g(_e.$$.fragment),Rt=s(),ro=n("span"),ro.textContent=Zn,et=s(),S=n("h2"),A=n("a"),Lo=n("span"),g(ve.$$.fragment),Gt=s(),so=n("span"),so.textContent=Ln,ot=s(),be=n("p"),be.innerHTML=Bn,tt=s(),ye=n("img"),nt=s(),we=n("p"),we.textContent=Rn,rt=s(),Te=n("p"),Te.innerHTML=Gn,st=s(),Fe=n("p"),Fe.textContent=Vn,at=s(),xe=n("ul"),xe.innerHTML=En,it=s(),Me=n("p"),Me.innerHTML=Xn,lt=s(),ke=n("img"),ct=s(),Oe=n("p"),Oe.innerHTML=Dn,dt=s(),Z=n("h2"),D=n("a"),Bo=n("span"),g(je.$$.fragment),Vt=s(),ao=n("span"),ao.textContent=Yn,mt=s(),Ie=n("p"),Ie.textContent=Qn,pt=s(),Ue=n("ul"),Ue.innerHTML=Kn,ht=s(),$e=n("p"),$e.textContent=er,gt=s(),L=n("h2"),Y=n("a"),Ho=n("span"),g(Je.$$.fragment),Et=s(),io=n("span"),io.textContent=or,ft=s(),B=n("div"),g(ze.$$.fragment),Xt=s(),lo=n("p"),lo.innerHTML=tr,ut=s(),C=n("div"),g(Ce.$$.fragment),At=s(),co=n("p"),co.innerHTML=nr,Dt=s(),mo=n("p"),mo.innerHTML=rr,_t=s(),H=n("h2"),Q=n("a"),Ro=n("span"),g(Ne.$$.fragment),Yt=s(),po=n("span"),po.textContent=sr,vt=s(),U=n("div"),g(Pe.$$.fragment),Qt=s(),ho=n("p"),ho.innerHTML=ar,Kt=s(),go=n("p"),go.innerHTML=ir,en=s(),g(K.$$.fragment),bt=s(),R=n("h2"),ee=n("a"),Go=n("span"),g(qe.$$.fragment),on=s(),fo=n("span"),fo.textContent=lr,yt=s(),F=n("div"),g(We.$$.fragment),tn=s(),uo=n("p"),uo.textContent=cr,nn=s(),_o=n("p"),_o.innerHTML=dr,rn=s(),vo=n("div"),g(Se.$$.fragment),sn=s(),q=n("div"),g(Ze.$$.fragment),an=s(),bo=n("p"),bo.innerHTML=mr,ln=s(),yo=n("p"),yo.innerHTML=pr,cn=s(),oe=n("div"),g(Le.$$.fragment),dn=s(),wo=n("p"),wo.innerHTML=hr,mn=s(),te=n("div"),g(Be.$$.fragment),pn=s(),To=n("p"),To.innerHTML=gr,hn=s(),ne=n("div"),g(He.$$.fragment),gn=s(),Fo=n("p"),Fo.innerHTML=fr,wt=s(),G=n("h2"),re=n("a"),Vo=n("span"),g(Re.$$.fragment),fn=s(),xo=n("span"),xo.textContent=ur,Tt=s(),O=n("div"),g(Ge.$$.fragment),un=s(),Mo=n("p"),Mo.innerHTML=_r,_n=s(),se=n("div"),g(Ve.$$.fragment),vn=s(),ko=n("p"),ko.innerHTML=vr,bn=s(),ae=n("div"),g(Ee.$$.fragment),yn=s(),Oo=n("p"),Oo.innerHTML=br,wn=s(),ie=n("div"),g(Xe.$$.fragment),Tn=s(),jo=n("p"),jo.innerHTML=yr,Fn=s(),le=n("div"),g(Ae.$$.fragment),xn=s(),Io=n("p"),Io.innerHTML=wr,Ft=s(),V=n("h2"),ce=n("a"),Eo=n("span"),g(De.$$.fragment),Mn=s(),Uo=n("span"),Uo.textContent=Tr,xt=s(),N=n("div"),g(Ye.$$.fragment),kn=s(),$o=n("p"),$o.innerHTML=Fr,On=s(),J=n("div"),g(Qe.$$.fragment),jn=s(),Jo=n("p"),Jo.innerHTML=xr,In=s(),g(de.$$.fragment),Un=s(),g(me.$$.fragment),Mt=s(),E=n("h2"),pe=n("a"),Xo=n("span"),g(Ke.$$.fragment),$n=s(),zo=n("span"),zo.textContent=Mr,kt=s(),P=n("div"),g(eo.$$.fragment),Jn=s(),Co=n("p"),Co.innerHTML=kr,zn=s(),I=n("div"),g(oo.$$.fragment),Cn=s(),No=n("p"),No.innerHTML=Or,Nn=s(),g(he.$$.fragment),Pn=s(),Po=n("p"),Po.textContent=jr,qn=s(),g(ge.$$.fragment),Ot=s(),Ao=n("p"),this.h()},l(e){const i=Yr("svelte-1phssyn",document.head);m=r(i,"META",{name:!0,content:!0}),i.forEach(o),x=a(e),y=r(e,"P",{}),p(y).forEach(o),w=a(e),T=r(e,"H1",{class:!0});var to=p(T);d=r(to,"A",{id:!0,class:!0,href:!0});var Do=p(d);k=r(Do,"SPAN",{});var Yo=p(k);f(_e.$$.fragment,Yo),Yo.forEach(o),Do.forEach(o),Rt=a(to),ro=r(to,"SPAN",{"data-svelte-h":!0}),h(ro)!=="svelte-1tg6sfm"&&(ro.textContent=Zn),to.forEach(o),et=a(e),S=r(e,"H2",{class:!0});var no=p(S);A=r(no,"A",{id:!0,class:!0,href:!0});var Qo=p(A);Lo=r(Qo,"SPAN",{});var Ir=p(Lo);f(ve.$$.fragment,Ir),Ir.forEach(o),Qo.forEach(o),Gt=a(no),so=r(no,"SPAN",{"data-svelte-h":!0}),h(so)!=="svelte-1jsw1pg"&&(so.textContent=Ln),no.forEach(o),ot=a(e),be=r(e,"P",{"data-svelte-h":!0}),h(be)!=="svelte-4uriep"&&(be.innerHTML=Bn),tt=a(e),ye=r(e,"IMG",{width:!0,src:!0}),nt=a(e),we=r(e,"P",{"data-svelte-h":!0}),h(we)!=="svelte-vfdo9a"&&(we.textContent=Rn),rt=a(e),Te=r(e,"P",{"data-svelte-h":!0}),h(Te)!=="svelte-lnf9ge"&&(Te.innerHTML=Gn),st=a(e),Fe=r(e,"P",{"data-svelte-h":!0}),h(Fe)!=="svelte-axv494"&&(Fe.textContent=Vn),at=a(e),xe=r(e,"UL",{"data-svelte-h":!0}),h(xe)!=="svelte-13z02k2"&&(xe.innerHTML=En),it=a(e),Me=r(e,"P",{"data-svelte-h":!0}),h(Me)!=="svelte-194z8jz"&&(Me.innerHTML=Xn),lt=a(e),ke=r(e,"IMG",{width:!0,src:!0}),ct=a(e),Oe=r(e,"P",{"data-svelte-h":!0}),h(Oe)!=="svelte-tphfzt"&&(Oe.innerHTML=Dn),dt=a(e),Z=r(e,"H2",{class:!0});var It=p(Z);D=r(It,"A",{id:!0,class:!0,href:!0});var Ur=p(D);Bo=r(Ur,"SPAN",{});var $r=p(Bo);f(je.$$.fragment,$r),$r.forEach(o),Ur.forEach(o),Vt=a(It),ao=r(It,"SPAN",{"data-svelte-h":!0}),h(ao)!=="svelte-w4zzv6"&&(ao.textContent=Yn),It.forEach(o),mt=a(e),Ie=r(e,"P",{"data-svelte-h":!0}),h(Ie)!=="svelte-e2wyhg"&&(Ie.textContent=Qn),pt=a(e),Ue=r(e,"UL",{"data-svelte-h":!0}),h(Ue)!=="svelte-1f4vugx"&&(Ue.innerHTML=Kn),ht=a(e),$e=r(e,"P",{"data-svelte-h":!0}),h($e)!=="svelte-1rggs50"&&($e.textContent=er),gt=a(e),L=r(e,"H2",{class:!0});var Ut=p(L);Y=r(Ut,"A",{id:!0,class:!0,href:!0});var Jr=p(Y);Ho=r(Jr,"SPAN",{});var zr=p(Ho);f(Je.$$.fragment,zr),zr.forEach(o),Jr.forEach(o),Et=a(Ut),io=r(Ut,"SPAN",{"data-svelte-h":!0}),h(io)!=="svelte-1xsrk8m"&&(io.textContent=or),Ut.forEach(o),ft=a(e),B=r(e,"DIV",{class:!0});var $t=p(B);f(ze.$$.fragment,$t),Xt=a($t),lo=r($t,"P",{"data-svelte-h":!0}),h(lo)!=="svelte-p3fgxb"&&(lo.innerHTML=tr),$t.forEach(o),ut=a(e),C=r(e,"DIV",{class:!0});var qo=p(C);f(Ce.$$.fragment,qo),At=a(qo),co=r(qo,"P",{"data-svelte-h":!0}),h(co)!=="svelte-tmsgtt"&&(co.innerHTML=nr),Dt=a(qo),mo=r(qo,"P",{"data-svelte-h":!0}),h(mo)!=="svelte-ce1uuv"&&(mo.innerHTML=rr),qo.forEach(o),_t=a(e),H=r(e,"H2",{class:!0});var Jt=p(H);Q=r(Jt,"A",{id:!0,class:!0,href:!0});var Cr=p(Q);Ro=r(Cr,"SPAN",{});var Nr=p(Ro);f(Ne.$$.fragment,Nr),Nr.forEach(o),Cr.forEach(o),Yt=a(Jt),po=r(Jt,"SPAN",{"data-svelte-h":!0}),h(po)!=="svelte-7q8hwk"&&(po.textContent=sr),Jt.forEach(o),vt=a(e),U=r(e,"DIV",{class:!0});var fe=p(U);f(Pe.$$.fragment,fe),Qt=a(fe),ho=r(fe,"P",{"data-svelte-h":!0}),h(ho)!=="svelte-ojmx7c"&&(ho.innerHTML=ar),Kt=a(fe),go=r(fe,"P",{"data-svelte-h":!0}),h(go)!=="svelte-10kqkkl"&&(go.innerHTML=ir),en=a(fe),f(K.$$.fragment,fe),fe.forEach(o),bt=a(e),R=r(e,"H2",{class:!0});var zt=p(R);ee=r(zt,"A",{id:!0,class:!0,href:!0});var Pr=p(ee);Go=r(Pr,"SPAN",{});var qr=p(Go);f(qe.$$.fragment,qr),qr.forEach(o),Pr.forEach(o),on=a(zt),fo=r(zt,"SPAN",{"data-svelte-h":!0}),h(fo)!=="svelte-m4ytjl"&&(fo.textContent=lr),zt.forEach(o),yt=a(e),F=r(e,"DIV",{class:!0});var j=p(F);f(We.$$.fragment,j),tn=a(j),uo=r(j,"P",{"data-svelte-h":!0}),h(uo)!=="svelte-5uz02u"&&(uo.textContent=cr),nn=a(j),_o=r(j,"P",{"data-svelte-h":!0}),h(_o)!=="svelte-1wh3jgn"&&(_o.innerHTML=dr),rn=a(j),vo=r(j,"DIV",{class:!0});var Wr=p(vo);f(Se.$$.fragment,Wr),Wr.forEach(o),sn=a(j),q=r(j,"DIV",{class:!0});var Wo=p(q);f(Ze.$$.fragment,Wo),an=a(Wo),bo=r(Wo,"P",{"data-svelte-h":!0}),h(bo)!=="svelte-1tetyua"&&(bo.innerHTML=mr),ln=a(Wo),yo=r(Wo,"P",{"data-svelte-h":!0}),h(yo)!=="svelte-g5nqd2"&&(yo.innerHTML=pr),Wo.forEach(o),cn=a(j),oe=r(j,"DIV",{class:!0});var Ct=p(oe);f(Le.$$.fragment,Ct),dn=a(Ct),wo=r(Ct,"P",{"data-svelte-h":!0}),h(wo)!=="svelte-1bnicaz"&&(wo.innerHTML=hr),Ct.forEach(o),mn=a(j),te=r(j,"DIV",{class:!0});var Nt=p(te);f(Be.$$.fragment,Nt),pn=a(Nt),To=r(Nt,"P",{"data-svelte-h":!0}),h(To)!=="svelte-ivz9k7"&&(To.innerHTML=gr),Nt.forEach(o),hn=a(j),ne=r(j,"DIV",{class:!0});var Pt=p(ne);f(He.$$.fragment,Pt),gn=a(Pt),Fo=r(Pt,"P",{"data-svelte-h":!0}),h(Fo)!=="svelte-pw2uru"&&(Fo.innerHTML=fr),Pt.forEach(o),j.forEach(o),wt=a(e),G=r(e,"H2",{class:!0});var qt=p(G);re=r(qt,"A",{id:!0,class:!0,href:!0});var Sr=p(re);Vo=r(Sr,"SPAN",{});var Zr=p(Vo);f(Re.$$.fragment,Zr),Zr.forEach(o),Sr.forEach(o),fn=a(qt),xo=r(qt,"SPAN",{"data-svelte-h":!0}),h(xo)!=="svelte-1n36uoo"&&(xo.textContent=ur),qt.forEach(o),Tt=a(e),O=r(e,"DIV",{class:!0});var z=p(O);f(Ge.$$.fragment,z),un=a(z),Mo=r(z,"P",{"data-svelte-h":!0}),h(Mo)!=="svelte-fe4xt8"&&(Mo.innerHTML=_r),_n=a(z),se=r(z,"DIV",{class:!0});var Wt=p(se);f(Ve.$$.fragment,Wt),vn=a(Wt),ko=r(Wt,"P",{"data-svelte-h":!0}),h(ko)!=="svelte-122w3rn"&&(ko.innerHTML=vr),Wt.forEach(o),bn=a(z),ae=r(z,"DIV",{class:!0});var St=p(ae);f(Ee.$$.fragment,St),yn=a(St),Oo=r(St,"P",{"data-svelte-h":!0}),h(Oo)!=="svelte-1h1v9bl"&&(Oo.innerHTML=br),St.forEach(o),wn=a(z),ie=r(z,"DIV",{class:!0});var Zt=p(ie);f(Xe.$$.fragment,Zt),Tn=a(Zt),jo=r(Zt,"P",{"data-svelte-h":!0}),h(jo)!=="svelte-pn7mtz"&&(jo.innerHTML=yr),Zt.forEach(o),Fn=a(z),le=r(z,"DIV",{class:!0});var Lt=p(le);f(Ae.$$.fragment,Lt),xn=a(Lt),Io=r(Lt,"P",{"data-svelte-h":!0}),h(Io)!=="svelte-18q6fuf"&&(Io.innerHTML=wr),Lt.forEach(o),z.forEach(o),Ft=a(e),V=r(e,"H2",{class:!0});var Bt=p(V);ce=r(Bt,"A",{id:!0,class:!0,href:!0});var Lr=p(ce);Eo=r(Lr,"SPAN",{});var Br=p(Eo);f(De.$$.fragment,Br),Br.forEach(o),Lr.forEach(o),Mn=a(Bt),Uo=r(Bt,"SPAN",{"data-svelte-h":!0}),h(Uo)!=="svelte-dcymiz"&&(Uo.textContent=Tr),Bt.forEach(o),xt=a(e),N=r(e,"DIV",{class:!0});var So=p(N);f(Ye.$$.fragment,So),kn=a(So),$o=r(So,"P",{"data-svelte-h":!0}),h($o)!=="svelte-1o75izy"&&($o.innerHTML=Fr),On=a(So),J=r(So,"DIV",{class:!0});var ue=p(J);f(Qe.$$.fragment,ue),jn=a(ue),Jo=r(ue,"P",{"data-svelte-h":!0}),h(Jo)!=="svelte-1a12pyq"&&(Jo.innerHTML=xr),In=a(ue),f(de.$$.fragment,ue),Un=a(ue),f(me.$$.fragment,ue),ue.forEach(o),So.forEach(o),Mt=a(e),E=r(e,"H2",{class:!0});var Ht=p(E);pe=r(Ht,"A",{id:!0,class:!0,href:!0});var Hr=p(pe);Xo=r(Hr,"SPAN",{});var Rr=p(Xo);f(Ke.$$.fragment,Rr),Rr.forEach(o),Hr.forEach(o),$n=a(Ht),zo=r(Ht,"SPAN",{"data-svelte-h":!0}),h(zo)!=="svelte-yradpk"&&(zo.textContent=Mr),Ht.forEach(o),kt=a(e),P=r(e,"DIV",{class:!0});var Zo=p(P);f(eo.$$.fragment,Zo),Jn=a(Zo),Co=r(Zo,"P",{"data-svelte-h":!0}),h(Co)!=="svelte-1c5p7r"&&(Co.innerHTML=kr),zn=a(Zo),I=r(Zo,"DIV",{class:!0});var W=p(I);f(oo.$$.fragment,W),Cn=a(W),No=r(W,"P",{"data-svelte-h":!0}),h(No)!=="svelte-1ck46wu"&&(No.innerHTML=Or),Nn=a(W),f(he.$$.fragment,W),Pn=a(W),Po=r(W,"P",{"data-svelte-h":!0}),h(Po)!=="svelte-11lpom8"&&(Po.textContent=jr),qn=a(W),f(ge.$$.fragment,W),W.forEach(o),Zo.forEach(o),Ot=a(e),Ao=r(e,"P",{}),p(Ao).forEach(o),this.h()},h(){c(m,"name","hf:doc:metadata"),c(m,"content",JSON.stringify(rs)),c(d,"id","oneformer"),c(d,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(d,"href","#oneformer"),c(T,"class","relative group"),c(A,"id","overview"),c(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(A,"href","#overview"),c(S,"class","relative group"),c(ye,"width","600"),Gr(ye.src,Hn="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/oneformer_teaser.png")||c(ye,"src",Hn),c(ke,"width","600"),Gr(ke.src,An="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/oneformer_architecture.png")||c(ke,"src",An),c(D,"id","resources"),c(D,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(D,"href","#resources"),c(Z,"class","relative group"),c(Y,"id","transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput"),c(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Y,"href","#transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput"),c(L,"class","relative group"),c(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Q,"id","transformers.OneFormerConfig"),c(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Q,"href","#transformers.OneFormerConfig"),c(H,"class","relative group"),c(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(ee,"id","transformers.OneFormerImageProcessor"),c(ee,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(ee,"href","#transformers.OneFormerImageProcessor"),c(R,"class","relative group"),c(vo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(re,"id","transformers.OneFormerProcessor"),c(re,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(re,"href","#transformers.OneFormerProcessor"),c(G,"class","relative group"),c(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(ce,"id","transformers.OneFormerModel"),c(ce,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(ce,"href","#transformers.OneFormerModel"),c(V,"class","relative group"),c(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(pe,"id","transformers.OneFormerForUniversalSegmentation"),c(pe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(pe,"href","#transformers.OneFormerForUniversalSegmentation"),c(E,"class","relative group"),c(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){t(document.head,m),l(e,x,i),l(e,y,i),l(e,w,i),l(e,T,i),t(T,d),t(d,k),u(_e,k,null),t(T,Rt),t(T,ro),l(e,et,i),l(e,S,i),t(S,A),t(A,Lo),u(ve,Lo,null),t(S,Gt),t(S,so),l(e,ot,i),l(e,be,i),l(e,tt,i),l(e,ye,i),l(e,nt,i),l(e,we,i),l(e,rt,i),l(e,Te,i),l(e,st,i),l(e,Fe,i),l(e,at,i),l(e,xe,i),l(e,it,i),l(e,Me,i),l(e,lt,i),l(e,ke,i),l(e,ct,i),l(e,Oe,i),l(e,dt,i),l(e,Z,i),t(Z,D),t(D,Bo),u(je,Bo,null),t(Z,Vt),t(Z,ao),l(e,mt,i),l(e,Ie,i),l(e,pt,i),l(e,Ue,i),l(e,ht,i),l(e,$e,i),l(e,gt,i),l(e,L,i),t(L,Y),t(Y,Ho),u(Je,Ho,null),t(L,Et),t(L,io),l(e,ft,i),l(e,B,i),u(ze,B,null),t(B,Xt),t(B,lo),l(e,ut,i),l(e,C,i),u(Ce,C,null),t(C,At),t(C,co),t(C,Dt),t(C,mo),l(e,_t,i),l(e,H,i),t(H,Q),t(Q,Ro),u(Ne,Ro,null),t(H,Yt),t(H,po),l(e,vt,i),l(e,U,i),u(Pe,U,null),t(U,Qt),t(U,ho),t(U,Kt),t(U,go),t(U,en),u(K,U,null),l(e,bt,i),l(e,R,i),t(R,ee),t(ee,Go),u(qe,Go,null),t(R,on),t(R,fo),l(e,yt,i),l(e,F,i),u(We,F,null),t(F,tn),t(F,uo),t(F,nn),t(F,_o),t(F,rn),t(F,vo),u(Se,vo,null),t(F,sn),t(F,q),u(Ze,q,null),t(q,an),t(q,bo),t(q,ln),t(q,yo),t(F,cn),t(F,oe),u(Le,oe,null),t(oe,dn),t(oe,wo),t(F,mn),t(F,te),u(Be,te,null),t(te,pn),t(te,To),t(F,hn),t(F,ne),u(He,ne,null),t(ne,gn),t(ne,Fo),l(e,wt,i),l(e,G,i),t(G,re),t(re,Vo),u(Re,Vo,null),t(G,fn),t(G,xo),l(e,Tt,i),l(e,O,i),u(Ge,O,null),t(O,un),t(O,Mo),t(O,_n),t(O,se),u(Ve,se,null),t(se,vn),t(se,ko),t(O,bn),t(O,ae),u(Ee,ae,null),t(ae,yn),t(ae,Oo),t(O,wn),t(O,ie),u(Xe,ie,null),t(ie,Tn),t(ie,jo),t(O,Fn),t(O,le),u(Ae,le,null),t(le,xn),t(le,Io),l(e,Ft,i),l(e,V,i),t(V,ce),t(ce,Eo),u(De,Eo,null),t(V,Mn),t(V,Uo),l(e,xt,i),l(e,N,i),u(Ye,N,null),t(N,kn),t(N,$o),t(N,On),t(N,J),u(Qe,J,null),t(J,jn),t(J,Jo),t(J,In),u(de,J,null),t(J,Un),u(me,J,null),l(e,Mt,i),l(e,E,i),t(E,pe),t(pe,Xo),u(Ke,Xo,null),t(E,$n),t(E,zo),l(e,kt,i),l(e,P,i),u(eo,P,null),t(P,Jn),t(P,Co),t(P,zn),t(P,I),u(oo,I,null),t(I,Cn),t(I,No),t(I,Nn),u(he,I,null),t(I,Pn),t(I,Po),t(I,qn),u(ge,I,null),l(e,Ot,i),l(e,Ao,i),jt=!0},p(e,[i]){const to={};i&2&&(to.$$scope={dirty:i,ctx:e}),K.$set(to);const Do={};i&2&&(Do.$$scope={dirty:i,ctx:e}),de.$set(Do);const Yo={};i&2&&(Yo.$$scope={dirty:i,ctx:e}),me.$set(Yo);const no={};i&2&&(no.$$scope={dirty:i,ctx:e}),he.$set(no);const Qo={};i&2&&(Qo.$$scope={dirty:i,ctx:e}),ge.$set(Qo)},i(e){jt||(_(_e.$$.fragment,e),_(ve.$$.fragment,e),_(je.$$.fragment,e),_(Je.$$.fragment,e),_(ze.$$.fragment,e),_(Ce.$$.fragment,e),_(Ne.$$.fragment,e),_(Pe.$$.fragment,e),_(K.$$.fragment,e),_(qe.$$.fragment,e),_(We.$$.fragment,e),_(Se.$$.fragment,e),_(Ze.$$.fragment,e),_(Le.$$.fragment,e),_(Be.$$.fragment,e),_(He.$$.fragment,e),_(Re.$$.fragment,e),_(Ge.$$.fragment,e),_(Ve.$$.fragment,e),_(Ee.$$.fragment,e),_(Xe.$$.fragment,e),_(Ae.$$.fragment,e),_(De.$$.fragment,e),_(Ye.$$.fragment,e),_(Qe.$$.fragment,e),_(de.$$.fragment,e),_(me.$$.fragment,e),_(Ke.$$.fragment,e),_(eo.$$.fragment,e),_(oo.$$.fragment,e),_(he.$$.fragment,e),_(ge.$$.fragment,e),jt=!0)},o(e){v(_e.$$.fragment,e),v(ve.$$.fragment,e),v(je.$$.fragment,e),v(Je.$$.fragment,e),v(ze.$$.fragment,e),v(Ce.$$.fragment,e),v(Ne.$$.fragment,e),v(Pe.$$.fragment,e),v(K.$$.fragment,e),v(qe.$$.fragment,e),v(We.$$.fragment,e),v(Se.$$.fragment,e),v(Ze.$$.fragment,e),v(Le.$$.fragment,e),v(Be.$$.fragment,e),v(He.$$.fragment,e),v(Re.$$.fragment,e),v(Ge.$$.fragment,e),v(Ve.$$.fragment,e),v(Ee.$$.fragment,e),v(Xe.$$.fragment,e),v(Ae.$$.fragment,e),v(De.$$.fragment,e),v(Ye.$$.fragment,e),v(Qe.$$.fragment,e),v(de.$$.fragment,e),v(me.$$.fragment,e),v(Ke.$$.fragment,e),v(eo.$$.fragment,e),v(oo.$$.fragment,e),v(he.$$.fragment,e),v(ge.$$.fragment,e),jt=!1},d(e){e&&(o(x),o(y),o(w),o(T),o(et),o(S),o(ot),o(be),o(tt),o(ye),o(nt),o(we),o(rt),o(Te),o(st),o(Fe),o(at),o(xe),o(it),o(Me),o(lt),o(ke),o(ct),o(Oe),o(dt),o(Z),o(mt),o(Ie),o(pt),o(Ue),o(ht),o($e),o(gt),o(L),o(ft),o(B),o(ut),o(C),o(_t),o(H),o(vt),o(U),o(bt),o(R),o(yt),o(F),o(wt),o(G),o(Tt),o(O),o(Ft),o(V),o(xt),o(N),o(Mt),o(E),o(kt),o(P),o(Ot),o(Ao)),o(m),b(_e),b(ve),b(je),b(Je),b(ze),b(Ce),b(Ne),b(Pe),b(K),b(qe),b(We),b(Se),b(Ze),b(Le),b(Be),b(He),b(Re),b(Ge),b(Ve),b(Ee),b(Xe),b(Ae),b(De),b(Ye),b(Qe),b(de),b(me),b(Ke),b(eo),b(oo),b(he),b(ge)}}}const rs={local:"oneformer",sections:[{local:"overview",title:"Overview"},{local:"resources",title:"Resources"},{local:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput",title:"OneFormer specific outputs"},{local:"transformers.OneFormerConfig",title:"OneFormerConfig"},{local:"transformers.OneFormerImageProcessor",title:"OneFormerImageProcessor"},{local:"transformers.OneFormerProcessor",title:"OneFormerProcessor"},{local:"transformers.OneFormerModel",title:"OneFormerModel"},{local:"transformers.OneFormerForUniversalSegmentation",title:"OneFormerForUniversalSegmentation"}],title:"OneFormer"};function ss($){return Xr(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hs extends Ar{constructor(m){super(),Dr(this,m,ss,ns,Er,{})}}export{hs as component};
