import{s as Ua,n as da,o as fa}from"../chunks/scheduler.9bc65507.js";import{S as Ia,i as Ca,g as l,s as r,u as y,m as ba,A as ga,h as n,f as a,c as p,j as h,v as m,y as o,n as _a,k as i,o as c,a as t,w as M,d as u,t as J,x as T}from"../chunks/index.78c82d43.js";import{I as Ss}from"../chunks/IconCopyLink.bedaa44d.js";import{C as I}from"../chunks/CodeBlock.73e038be.js";function va(zs){let w,cs,ls,hs,j,C,ns,v,Gs,ss,Ds="Hyperparameter Search using Trainer API",ys,$,Ps='🤗 Transformers provides a <a href="/docs/transformers/v4.34.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> class optimized for training 🤗 Transformers models, making it easier to start training without manually writing your own training loop. The <a href="/docs/transformers/v4.34.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> provides API for hyperparameter search. This doc shows how to enable it in example.',ms,U,b,rs,q,Rs,as,Ls="Hyperparameter Search backend",Ms,k,Ks=`<a href="/docs/transformers/v4.34.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> supports four hyperparameter search backends currently:
<a href="https://optuna.org/" rel="nofollow">optuna</a>, <a href="https://sigopt.com/" rel="nofollow">sigopt</a>, <a href="https://docs.ray.io/en/latest/tune/index.html" rel="nofollow">raytune</a> and <a href="https://wandb.ai/site/sweeps" rel="nofollow">wandb</a>.`,us,X,Os="you should install them before using them as the hyperparameter search backend",Js,W,Ts,d,g,ps,Y,Es,es,sa="How to enable Hyperparameter search in example",ws,B,aa="Define the hyperparameter search space, different backends need different format.",js,Z,ea='For sigopt, see sigopt <a href="https://docs.sigopt.com/ai-module-api-references/api_reference/objects/object_parameter" rel="nofollow">object_parameter</a>, it’s like following:',Us,x,ds,A,ta='For optuna, see optuna <a href="https://optuna.readthedocs.io/en/stable/tutorial/10_key_features/002_configurations.html#sphx-glr-tutorial-10-key-features-002-configurations-py" rel="nofollow">object_parameter</a>, it’s like following:',fs,V,Is,H,la='Optuna provides multi-objective HPO. You can pass <code>direction</code> in <code>hyperparameter_search</code> and define your own compute_objective to return multiple objective values. The Pareto Front (<code>List[BestRun]</code>) will be returned in hyperparameter_search, you should refer to the test case <code>TrainerHyperParameterMultiObjectOptunaIntegrationTest</code> in <a href="https://github.com/huggingface/transformers/blob/main/tests/trainer/test_trainer.py" rel="nofollow">test_trainer</a>. It’s like following',Cs,N,bs,Q,na='For raytune, see raytune <a href="https://docs.ray.io/en/latest/tune/api/search_space.html" rel="nofollow">object_parameter</a>, it’s like following:',gs,S,_s,G,ra='For wandb, see wandb <a href="https://docs.wandb.ai/guides/sweeps/configuration" rel="nofollow">object_parameter</a>, it’s like following:',vs,R,$s,E,pa='Define a <code>model_init</code> function and pass it to the <a href="/docs/transformers/v4.34.0/en/main_classes/trainer#transformers.Trainer">Trainer</a>, as an example:',qs,F,ks,z,ia='Create a <a href="/docs/transformers/v4.34.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> with your <code>model_init</code> function, training arguments, training and test datasets, and evaluation function:',Xs,D,Ws,P,oa="Call hyperparameter search, get the best trial parameters, backend could be <code>&quot;optuna&quot;</code>/<code>&quot;sigopt&quot;</code>/<code>&quot;wandb&quot;</code>/<code>&quot;ray&quot;</code>. direction can be<code>&quot;minimize&quot;</code> or <code>&quot;maximize&quot;</code>, which indicates whether to optimize greater or lower objective.",Ys,L,ca="You could define your own compute_objective function, if not defined, the default compute_objective will be called, and the sum of eval metric like f1 is returned as objective value.",Bs,K,Zs,f,_,is,O,Fs,ts,ha="Hyperparameter search For DDP finetune",xs,os,As;return v=new Ss({}),q=new Ss({}),W=new I({props:{code:"cGlwJTIwaW5zdGFsbCUyMG9wdHVuYSUyRnNpZ29wdCUyRndhbmRiJTJGcmF5JTVCdHVuZSU1RCUyMA==",highlighted:"pip install optuna/sigopt/wandb/ray[tune] ",wrap:!1}}),Y=new Ss({}),x=new I({props:{code:"ZGVmJTIwc2lnb3B0X2hwX3NwYWNlKHRyaWFsKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMmJvdW5kcyUyMiUzQSUyMCU3QiUyMm1pbiUyMiUzQSUyMDFlLTYlMkMlMjAlMjJtYXglMjIlM0ElMjAxZS00JTdEJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmxlYXJuaW5nX3JhdGUlMjIlMkMlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyZG91YmxlJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY2F0ZWdvcmljYWxfdmFsdWVzJTIyJTNBJTIwJTVCJTIyMTYlMjIlMkMlMjAlMjIzMiUyMiUyQyUyMCUyMjY0JTIyJTJDJTIwJTIyMTI4JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybmFtZSUyMiUzQSUyMCUyMnBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJjYXRlZ29yaWNhbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">sigopt_hp_space</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> [
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;bounds&quot;</span>: {<span class="hljs-string">&quot;min&quot;</span>: <span class="hljs-number">1e-6</span>, <span class="hljs-string">&quot;max&quot;</span>: <span class="hljs-number">1e-4</span>}, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;learning_rate&quot;</span>, <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;double&quot;</span>},
<span class="hljs-meta">... </span>        {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;categorical_values&quot;</span>: [<span class="hljs-string">&quot;16&quot;</span>, <span class="hljs-string">&quot;32&quot;</span>, <span class="hljs-string">&quot;64&quot;</span>, <span class="hljs-string">&quot;128&quot;</span>],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;categorical&quot;</span>,
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    ]`,wrap:!1}}),V=new I({props:{code:"ZGVmJTIwb3B0dW5hX2hwX3NwYWNlKHRyaWFsKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxlYXJuaW5nX3JhdGUlMjIlM0ElMjB0cmlhbC5zdWdnZXN0X2Zsb2F0KCUyMmxlYXJuaW5nX3JhdGUlMjIlMkMlMjAxZS02JTJDJTIwMWUtNCUyQyUyMGxvZyUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIyJTNBJTIwdHJpYWwuc3VnZ2VzdF9jYXRlZ29yaWNhbCglMjJwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjIlMkMlMjAlNUIxNiUyQyUyMDMyJTJDJTIwNjQlMkMlMjAxMjglNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTdE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">optuna_hp_space</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;learning_rate&quot;</span>: trial.suggest_float(<span class="hljs-string">&quot;learning_rate&quot;</span>, <span class="hljs-number">1e-6</span>, <span class="hljs-number">1e-4</span>, log=<span class="hljs-literal">True</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>: trial.suggest_categorical(<span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>, [<span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">128</span>]),
<span class="hljs-meta">... </span>    }`,wrap:!1}}),N=new I({props:{code:"YmVzdF90cmlhbHMlMjAlM0QlMjB0cmFpbmVyLmh5cGVycGFyYW1ldGVyX3NlYXJjaCglMEElMjAlMjAlMjAlMjBkaXJlY3Rpb24lM0QlNUIlMjJtaW5pbWl6ZSUyMiUyQyUyMCUyMm1heGltaXplJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwYmFja2VuZCUzRCUyMm9wdHVuYSUyMiUyQyUwQSUyMCUyMCUyMCUyMGhwX3NwYWNlJTNEb3B0dW5hX2hwX3NwYWNlJTJDJTBBJTIwJTIwJTIwJTIwbl90cmlhbHMlM0QyMCUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfb2JqZWN0aXZlJTNEY29tcHV0ZV9vYmplY3RpdmUlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>best_trials = trainer.hyperparameter_search(
<span class="hljs-meta">... </span>    direction=[<span class="hljs-string">&quot;minimize&quot;</span>, <span class="hljs-string">&quot;maximize&quot;</span>],
<span class="hljs-meta">... </span>    backend=<span class="hljs-string">&quot;optuna&quot;</span>,
<span class="hljs-meta">... </span>    hp_space=optuna_hp_space,
<span class="hljs-meta">... </span>    n_trials=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    compute_objective=compute_objective,
<span class="hljs-meta">... </span>)`,wrap:!1}}),S=new I({props:{code:"ZGVmJTIwcmF5X2hwX3NwYWNlKHRyaWFsKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxlYXJuaW5nX3JhdGUlMjIlM0ElMjB0dW5lLmxvZ3VuaWZvcm0oMWUtNiUyQyUyMDFlLTQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIyJTNBJTIwdHVuZS5jaG9pY2UoJTVCMTYlMkMlMjAzMiUyQyUyMDY0JTJDJTIwMTI4JTVEKSUyQyUwQSUyMCUyMCUyMCUyMCU3RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">ray_hp_space</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;learning_rate&quot;</span>: tune.loguniform(<span class="hljs-number">1e-6</span>, <span class="hljs-number">1e-4</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>: tune.choice([<span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">128</span>]),
<span class="hljs-meta">... </span>    }`,wrap:!1}}),R=new I({props:{code:"ZGVmJTIwd2FuZGJfaHBfc3BhY2UodHJpYWwpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWV0aG9kJTIyJTNBJTIwJTIycmFuZG9tJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWV0cmljJTIyJTNBJTIwJTdCJTIybmFtZSUyMiUzQSUyMCUyMm9iamVjdGl2ZSUyMiUyQyUyMCUyMmdvYWwlMjIlM0ElMjAlMjJtaW5pbWl6ZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWFybmluZ19yYXRlJTIyJTNBJTIwJTdCJTIyZGlzdHJpYnV0aW9uJTIyJTNBJTIwJTIydW5pZm9ybSUyMiUyQyUyMCUyMm1pbiUyMiUzQSUyMDFlLTYlMkMlMjAlMjJtYXglMjIlM0ElMjAxZS00JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIyJTNBJTIwJTdCJTIydmFsdWVzJTIyJTNBJTIwJTVCMTYlMkMlMjAzMiUyQyUyMDY0JTJDJTIwMTI4JTVEJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">wandb_hp_space</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;method&quot;</span>: <span class="hljs-string">&quot;random&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;metric&quot;</span>: {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;objective&quot;</span>, <span class="hljs-string">&quot;goal&quot;</span>: <span class="hljs-string">&quot;minimize&quot;</span>},
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;learning_rate&quot;</span>: {<span class="hljs-string">&quot;distribution&quot;</span>: <span class="hljs-string">&quot;uniform&quot;</span>, <span class="hljs-string">&quot;min&quot;</span>: <span class="hljs-number">1e-6</span>, <span class="hljs-string">&quot;max&quot;</span>: <span class="hljs-number">1e-4</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>: {<span class="hljs-string">&quot;values&quot;</span>: [<span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">128</span>]},
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    }`,wrap:!1}}),F=new I({props:{code:"ZGVmJTIwbW9kZWxfaW5pdCh0cmlhbCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9hcmdzLm1vZGVsX25hbWVfb3JfcGF0aCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZyb21fdGYlM0Rib29sKCUyMi5ja3B0JTIyJTIwaW4lMjBtb2RlbF9hcmdzLm1vZGVsX25hbWVfb3JfcGF0aCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWclM0Rjb25maWclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYWNoZV9kaXIlM0Rtb2RlbF9hcmdzLmNhY2hlX2RpciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldmlzaW9uJTNEbW9kZWxfYXJncy5tb2RlbF9yZXZpc2lvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHVzZV9hdXRoX3Rva2VuJTNEVHJ1ZSUyMGlmJTIwbW9kZWxfYXJncy51c2VfYXV0aF90b2tlbiUyMGVsc2UlMjBOb25lJTJDJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">model_init</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> AutoModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>        model_args.model_name_or_path,
<span class="hljs-meta">... </span>        from_tf=<span class="hljs-built_in">bool</span>(<span class="hljs-string">&quot;.ckpt&quot;</span> <span class="hljs-keyword">in</span> model_args.model_name_or_path),
<span class="hljs-meta">... </span>        config=config,
<span class="hljs-meta">... </span>        cache_dir=model_args.cache_dir,
<span class="hljs-meta">... </span>        revision=model_args.model_revision,
<span class="hljs-meta">... </span>        use_auth_token=<span class="hljs-literal">True</span> <span class="hljs-keyword">if</span> model_args.use_auth_token <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>    )`,wrap:!1}}),D=new I({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEc21hbGxfdHJhaW5fZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRHNtYWxsX2V2YWxfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2luaXQlM0Rtb2RlbF9pbml0JTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=<span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    train_dataset=small_train_dataset,
<span class="hljs-meta">... </span>    eval_dataset=small_eval_dataset,
<span class="hljs-meta">... </span>    compute_metrics=compute_metrics,
<span class="hljs-meta">... </span>    tokenizer=tokenizer,
<span class="hljs-meta">... </span>    model_init=model_init,
<span class="hljs-meta">... </span>    data_collator=data_collator,
<span class="hljs-meta">... </span>)`,wrap:!1}}),K=new I({props:{code:"YmVzdF90cmlhbCUyMCUzRCUyMHRyYWluZXIuaHlwZXJwYXJhbWV0ZXJfc2VhcmNoKCUwQSUyMCUyMCUyMCUyMGRpcmVjdGlvbiUzRCUyMm1heGltaXplJTIyJTJDJTBBJTIwJTIwJTIwJTIwYmFja2VuZCUzRCUyMm9wdHVuYSUyMiUyQyUwQSUyMCUyMCUyMCUyMGhwX3NwYWNlJTNEb3B0dW5hX2hwX3NwYWNlJTJDJTBBJTIwJTIwJTIwJTIwbl90cmlhbHMlM0QyMCUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfb2JqZWN0aXZlJTNEY29tcHV0ZV9vYmplY3RpdmUlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>best_trial = trainer.hyperparameter_search(
<span class="hljs-meta">... </span>    direction=<span class="hljs-string">&quot;maximize&quot;</span>,
<span class="hljs-meta">... </span>    backend=<span class="hljs-string">&quot;optuna&quot;</span>,
<span class="hljs-meta">... </span>    hp_space=optuna_hp_space,
<span class="hljs-meta">... </span>    n_trials=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    compute_objective=compute_objective,
<span class="hljs-meta">... </span>)`,wrap:!1}}),O=new Ss({}),{c(){w=l("meta"),cs=r(),ls=l("p"),hs=r(),j=l("h1"),C=l("a"),ns=l("span"),y(v.$$.fragment),Gs=r(),ss=l("span"),ss.textContent=Ds,ys=r(),$=l("p"),$.innerHTML=Ps,ms=r(),U=l("h2"),b=l("a"),rs=l("span"),y(q.$$.fragment),Rs=r(),as=l("span"),as.textContent=Ls,Ms=r(),k=l("p"),k.innerHTML=Ks,us=r(),X=l("p"),X.textContent=Os,Js=r(),y(W.$$.fragment),Ts=r(),d=l("h2"),g=l("a"),ps=l("span"),y(Y.$$.fragment),Es=r(),es=l("span"),es.textContent=sa,ws=r(),B=l("p"),B.textContent=aa,js=r(),Z=l("p"),Z.innerHTML=ea,Us=r(),y(x.$$.fragment),ds=r(),A=l("p"),A.innerHTML=ta,fs=r(),y(V.$$.fragment),Is=r(),H=l("p"),H.innerHTML=la,Cs=r(),y(N.$$.fragment),bs=r(),Q=l("p"),Q.innerHTML=na,gs=r(),y(S.$$.fragment),_s=r(),G=l("p"),G.innerHTML=ra,vs=r(),y(R.$$.fragment),$s=r(),E=l("p"),E.innerHTML=pa,qs=r(),y(F.$$.fragment),ks=r(),z=l("p"),z.innerHTML=ia,Xs=r(),y(D.$$.fragment),Ws=r(),P=l("p"),P.innerHTML=oa,Ys=r(),L=l("p"),L.textContent=ca,Bs=r(),y(K.$$.fragment),Zs=r(),f=l("h2"),_=l("a"),is=l("span"),y(O.$$.fragment),Fs=r(),ts=l("span"),ts.textContent=ha,xs=ba(`


Currently, Hyperparameter search for DDP is enabled for optuna and sigopt. Only the rank-zero process will generate the search trial and pass the argument to other ranks.

`),os=l("p"),this.h()},l(s){const e=ga("svelte-1phssyn",document.head);w=n(e,"META",{name:!0,content:!0}),e.forEach(a),cs=p(s),ls=n(s,"P",{}),h(ls).forEach(a),hs=p(s),j=n(s,"H1",{class:!0});var Vs=h(j);C=n(Vs,"A",{id:!0,class:!0,href:!0});var ya=h(C);ns=n(ya,"SPAN",{});var ma=h(ns);m(v.$$.fragment,ma),ma.forEach(a),ya.forEach(a),Gs=p(Vs),ss=n(Vs,"SPAN",{"data-svelte-h":!0}),o(ss)!=="svelte-lwg3h1"&&(ss.textContent=Ds),Vs.forEach(a),ys=p(s),$=n(s,"P",{"data-svelte-h":!0}),o($)!=="svelte-ofq0og"&&($.innerHTML=Ps),ms=p(s),U=n(s,"H2",{class:!0});var Hs=h(U);b=n(Hs,"A",{id:!0,class:!0,href:!0});var Ma=h(b);rs=n(Ma,"SPAN",{});var ua=h(rs);m(q.$$.fragment,ua),ua.forEach(a),Ma.forEach(a),Rs=p(Hs),as=n(Hs,"SPAN",{"data-svelte-h":!0}),o(as)!=="svelte-4ugnks"&&(as.textContent=Ls),Hs.forEach(a),Ms=p(s),k=n(s,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1p7gw0a"&&(k.innerHTML=Ks),us=p(s),X=n(s,"P",{"data-svelte-h":!0}),o(X)!=="svelte-ttiwiu"&&(X.textContent=Os),Js=p(s),m(W.$$.fragment,s),Ts=p(s),d=n(s,"H2",{class:!0});var Ns=h(d);g=n(Ns,"A",{id:!0,class:!0,href:!0});var Ja=h(g);ps=n(Ja,"SPAN",{});var Ta=h(ps);m(Y.$$.fragment,Ta),Ta.forEach(a),Ja.forEach(a),Es=p(Ns),es=n(Ns,"SPAN",{"data-svelte-h":!0}),o(es)!=="svelte-1ftd6u7"&&(es.textContent=sa),Ns.forEach(a),ws=p(s),B=n(s,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1jwax0f"&&(B.textContent=aa),js=p(s),Z=n(s,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-dng8fq"&&(Z.innerHTML=ea),Us=p(s),m(x.$$.fragment,s),ds=p(s),A=n(s,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1o2m9k6"&&(A.innerHTML=ta),fs=p(s),m(V.$$.fragment,s),Is=p(s),H=n(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-e3s4e6"&&(H.innerHTML=la),Cs=p(s),m(N.$$.fragment,s),bs=p(s),Q=n(s,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1fs958e"&&(Q.innerHTML=na),gs=p(s),m(S.$$.fragment,s),_s=p(s),G=n(s,"P",{"data-svelte-h":!0}),o(G)!=="svelte-uzyw2c"&&(G.innerHTML=ra),vs=p(s),m(R.$$.fragment,s),$s=p(s),E=n(s,"P",{"data-svelte-h":!0}),o(E)!=="svelte-cpjifh"&&(E.innerHTML=pa),qs=p(s),m(F.$$.fragment,s),ks=p(s),z=n(s,"P",{"data-svelte-h":!0}),o(z)!=="svelte-jfvh14"&&(z.innerHTML=ia),Xs=p(s),m(D.$$.fragment,s),Ws=p(s),P=n(s,"P",{"data-svelte-h":!0}),o(P)!=="svelte-rd47zq"&&(P.innerHTML=oa),Ys=p(s),L=n(s,"P",{"data-svelte-h":!0}),o(L)!=="svelte-v9khww"&&(L.textContent=ca),Bs=p(s),m(K.$$.fragment,s),Zs=p(s),f=n(s,"H2",{class:!0});var Qs=h(f);_=n(Qs,"A",{id:!0,class:!0,href:!0});var wa=h(_);is=n(wa,"SPAN",{});var ja=h(is);m(O.$$.fragment,ja),ja.forEach(a),wa.forEach(a),Fs=p(Qs),ts=n(Qs,"SPAN",{"data-svelte-h":!0}),o(ts)!=="svelte-isw2d7"&&(ts.textContent=ha),Qs.forEach(a),xs=_a(s,`


Currently, Hyperparameter search for DDP is enabled for optuna and sigopt. Only the rank-zero process will generate the search trial and pass the argument to other ranks.

`),os=n(s,"P",{}),h(os).forEach(a),this.h()},h(){i(w,"name","hf:doc:metadata"),i(w,"content",JSON.stringify($a)),i(C,"id","hyperparameter-search-using-trainer-api"),i(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(C,"href","#hyperparameter-search-using-trainer-api"),i(j,"class","relative group"),i(b,"id","hyperparameter-search-backend"),i(b,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(b,"href","#hyperparameter-search-backend"),i(U,"class","relative group"),i(g,"id","how-to-enable-hyperparameter-search-in-example"),i(g,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(g,"href","#how-to-enable-hyperparameter-search-in-example"),i(d,"class","relative group"),i(_,"id","hyperparameter-search-for-ddp-finetune"),i(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(_,"href","#hyperparameter-search-for-ddp-finetune"),i(f,"class","relative group")},m(s,e){c(document.head,w),t(s,cs,e),t(s,ls,e),t(s,hs,e),t(s,j,e),c(j,C),c(C,ns),M(v,ns,null),c(j,Gs),c(j,ss),t(s,ys,e),t(s,$,e),t(s,ms,e),t(s,U,e),c(U,b),c(b,rs),M(q,rs,null),c(U,Rs),c(U,as),t(s,Ms,e),t(s,k,e),t(s,us,e),t(s,X,e),t(s,Js,e),M(W,s,e),t(s,Ts,e),t(s,d,e),c(d,g),c(g,ps),M(Y,ps,null),c(d,Es),c(d,es),t(s,ws,e),t(s,B,e),t(s,js,e),t(s,Z,e),t(s,Us,e),M(x,s,e),t(s,ds,e),t(s,A,e),t(s,fs,e),M(V,s,e),t(s,Is,e),t(s,H,e),t(s,Cs,e),M(N,s,e),t(s,bs,e),t(s,Q,e),t(s,gs,e),M(S,s,e),t(s,_s,e),t(s,G,e),t(s,vs,e),M(R,s,e),t(s,$s,e),t(s,E,e),t(s,qs,e),M(F,s,e),t(s,ks,e),t(s,z,e),t(s,Xs,e),M(D,s,e),t(s,Ws,e),t(s,P,e),t(s,Ys,e),t(s,L,e),t(s,Bs,e),M(K,s,e),t(s,Zs,e),t(s,f,e),c(f,_),c(_,is),M(O,is,null),c(f,Fs),c(f,ts),t(s,xs,e),t(s,os,e),As=!0},p:da,i(s){As||(u(v.$$.fragment,s),u(q.$$.fragment,s),u(W.$$.fragment,s),u(Y.$$.fragment,s),u(x.$$.fragment,s),u(V.$$.fragment,s),u(N.$$.fragment,s),u(S.$$.fragment,s),u(R.$$.fragment,s),u(F.$$.fragment,s),u(D.$$.fragment,s),u(K.$$.fragment,s),u(O.$$.fragment,s),As=!0)},o(s){J(v.$$.fragment,s),J(q.$$.fragment,s),J(W.$$.fragment,s),J(Y.$$.fragment,s),J(x.$$.fragment,s),J(V.$$.fragment,s),J(N.$$.fragment,s),J(S.$$.fragment,s),J(R.$$.fragment,s),J(F.$$.fragment,s),J(D.$$.fragment,s),J(K.$$.fragment,s),J(O.$$.fragment,s),As=!1},d(s){s&&(a(cs),a(ls),a(hs),a(j),a(ys),a($),a(ms),a(U),a(Ms),a(k),a(us),a(X),a(Js),a(Ts),a(d),a(ws),a(B),a(js),a(Z),a(Us),a(ds),a(A),a(fs),a(Is),a(H),a(Cs),a(bs),a(Q),a(gs),a(_s),a(G),a(vs),a($s),a(E),a(qs),a(ks),a(z),a(Xs),a(Ws),a(P),a(Ys),a(L),a(Bs),a(Zs),a(f),a(xs),a(os)),a(w),T(v),T(q),T(W,s),T(Y),T(x,s),T(V,s),T(N,s),T(S,s),T(R,s),T(F,s),T(D,s),T(K,s),T(O)}}}const $a={local:"hyperparameter-search-using-trainer-api",sections:[{local:"hyperparameter-search-backend",title:"Hyperparameter Search backend"},{local:"how-to-enable-hyperparameter-search-in-example",title:"How to enable Hyperparameter search in example"},{local:"hyperparameter-search-for-ddp-finetune",title:"Hyperparameter search For DDP finetune"}],title:"Hyperparameter Search using Trainer API"};function qa(zs){return fa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ba extends Ia{constructor(w){super(),Ca(this,w,qa,va,Ua,{})}}export{Ba as component};
