import{s as Wo,f as zo,o as Po,n as et}from"../chunks/scheduler.9bc65507.js";import{S as Bo,i as Zo,g as o,s as c,u as w,A as Eo,h as n,f as t,c as d,j as u,v as _,y as f,k as p,o as s,a as i,w as v,d as S,t as b,x as y}from"../chunks/index.78c82d43.js";import{T as No}from"../chunks/Tip.87d55b76.js";import{D as Te}from"../chunks/Docstring.4e7352e2.js";import{C as Ot}from"../chunks/CodeBlock.73e038be.js";import{I as Re}from"../chunks/IconCopyLink.bedaa44d.js";import{E as Dt}from"../chunks/ExampleCodeBlock.872b014d.js";function Ho(C){let l,M="Example:",m,h,g;return h=new Ot({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFN3aW4yU1JDb25maWclMkMlMjBTd2luMlNSTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwU3dpbjJTUiUyMGNhaWRhcyUyRnN3aW4yc3ItY2xhc3NpY2Fsc3IteDItNjQlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwU3dpbjJTUkNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBjYWlkYXMlMkZzd2luMnNyLWNsYXNzaWNhbHNyLXgyLTY0JTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBTd2luMlNSTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Swin2SRConfig, Swin2SRModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Swin2SR caidas/swin2sr-classicalsr-x2-64 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Swin2SRConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the caidas/swin2sr-classicalsr-x2-64 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Swin2SRModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){l=o("p"),l.textContent=M,m=c(),w(h.$$.fragment)},l(r){l=n(r,"P",{"data-svelte-h":!0}),f(l)!=="svelte-11lpom8"&&(l.textContent=M),m=d(r),_(h.$$.fragment,r)},m(r,T){i(r,l,T),i(r,m,T),v(h,r,T),g=!0},p:et,i(r){g||(S(h.$$.fragment,r),g=!0)},o(r){b(h.$$.fragment,r),g=!1},d(r){r&&(t(l),t(m)),y(h,r)}}}function qo(C){let l,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=o("p"),l.innerHTML=M},l(m){l=n(m,"P",{"data-svelte-h":!0}),f(l)!=="svelte-fincs2"&&(l.innerHTML=M)},m(m,h){i(m,l,h)},p:et,d(m){m&&t(l)}}}function Lo(C){let l,M="Example:",m,h,g;return h=new Ot({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFN3aW4yU1JNb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyY2FpZGFzJTJGc3dpbjJTUi1jbGFzc2ljYWwtc3IteDItNjQlMjIpJTBBbW9kZWwlMjAlM0QlMjBTd2luMlNSTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmNhaWRhcyUyRnN3aW4yU1ItY2xhc3NpY2FsLXNyLXgyLTY0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdChsYXN0X2hpZGRlbl9zdGF0ZXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, Swin2SRModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;caidas/swin2SR-classical-sr-x2-64&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Swin2SRModel.from_pretrained(<span class="hljs-string">&quot;caidas/swin2SR-classical-sr-x2-64&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">180</span>, <span class="hljs-number">488</span>, <span class="hljs-number">648</span>]`,wrap:!1}}),{c(){l=o("p"),l.textContent=M,m=c(),w(h.$$.fragment)},l(r){l=n(r,"P",{"data-svelte-h":!0}),f(l)!=="svelte-11lpom8"&&(l.textContent=M),m=d(r),_(h.$$.fragment,r)},m(r,T){i(r,l,T),i(r,m,T),v(h,r,T),g=!0},p:et,i(r){g||(S(h.$$.fragment,r),g=!0)},o(r){b(h.$$.fragment,r),g=!1},d(r){r&&(t(l),t(m)),y(h,r)}}}function Xo(C){let l,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=o("p"),l.innerHTML=M},l(m){l=n(m,"P",{"data-svelte-h":!0}),f(l)!=="svelte-fincs2"&&(l.innerHTML=M)},m(m,h){i(m,l,h)},p:et,d(m){m&&t(l)}}}function Go(C){let l,M="Example:",m,h,g;return h=new Ot({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvSW1hZ2VQcm9jZXNzb3IlMkMlMjBTd2luMlNSRm9ySW1hZ2VTdXBlclJlc29sdXRpb24lMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmNhaWRhcyUyRnN3aW4yU1ItY2xhc3NpY2FsLXNyLXgyLTY0JTIyKSUwQW1vZGVsJTIwJTNEJTIwU3dpbjJTUkZvckltYWdlU3VwZXJSZXNvbHV0aW9uLmZyb21fcHJldHJhaW5lZCglMjJjYWlkYXMlMkZzd2luMlNSLWNsYXNzaWNhbC1zci14Mi02NCUyMiklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3BhY2VzJTJGampvdXJuZXkxMTI1JTJGc3dpbjJzciUyRnJlc29sdmUlMkZtYWluJTJGc2FtcGxlcyUyRmJ1dHRlcmZseS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMjMlMjBwcmVwYXJlJTIwaW1hZ2UlMjBmb3IlMjB0aGUlMjBtb2RlbCUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwZm9yd2FyZCUyMHBhc3MlMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQW91dHB1dCUyMCUzRCUyMG91dHB1dHMucmVjb25zdHJ1Y3Rpb24uZGF0YS5zcXVlZXplKCkuZmxvYXQoKS5jcHUoKS5jbGFtcF8oMCUyQyUyMDEpLm51bXB5KCklMEFvdXRwdXQlMjAlM0QlMjBucC5tb3ZlYXhpcyhvdXRwdXQlMkMlMjBzb3VyY2UlM0QwJTJDJTIwZGVzdGluYXRpb24lM0QtMSklMEFvdXRwdXQlMjAlM0QlMjAob3V0cHV0JTIwKiUyMDI1NS4wKS5yb3VuZCgpLmFzdHlwZShucC51aW50OCklMjAlMjAlMjMlMjBmbG9hdDMyJTIwdG8lMjB1aW50OCUwQSUyMyUyMHlvdSUyMGNhbiUyMHZpc3VhbGl6ZSUyMCU2MG91dHB1dCU2MCUyMHdpdGglMjAlNjBJbWFnZS5mcm9tYXJyYXklNjA=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, Swin2SRForImageSuperResolution

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;caidas/swin2SR-classical-sr-x2-64&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Swin2SRForImageSuperResolution.from_pretrained(<span class="hljs-string">&quot;caidas/swin2SR-classical-sr-x2-64&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/spaces/jjourney1125/swin2sr/resolve/main/samples/butterfly.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = outputs.reconstruction.data.squeeze().<span class="hljs-built_in">float</span>().cpu().clamp_(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>).numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>output = np.moveaxis(output, source=<span class="hljs-number">0</span>, destination=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = (output * <span class="hljs-number">255.0</span>).<span class="hljs-built_in">round</span>().astype(np.uint8)  <span class="hljs-comment"># float32 to uint8</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can visualize \`output\` with \`Image.fromarray\`</span>`,wrap:!1}}),{c(){l=o("p"),l.textContent=M,m=c(),w(h.$$.fragment)},l(r){l=n(r,"P",{"data-svelte-h":!0}),f(l)!=="svelte-11lpom8"&&(l.textContent=M),m=d(r),_(h.$$.fragment,r)},m(r,T){i(r,l,T),i(r,m,T),v(h,r,T),g=!0},p:et,i(r){g||(S(h.$$.fragment,r),g=!0)},o(r){b(h.$$.fragment,r),g=!1},d(r){r&&(t(l),t(m)),y(h,r)}}}function Ao(C){let l,M,m,h,g,r,T,te,Ct,$e,Kt="Swin2SR",tt,k,P,Le,oe,xt,Ce,eo="Overview",ot,ne,to=`The Swin2SR model was proposed in <a href="https://arxiv.org/abs/2209.11345" rel="nofollow">Swin2SR: SwinV2 Transformer for Compressed Image Super-Resolution and Restoration</a> by Marcos V. Conde, Ui-Jin Choi, Maxime Burchi, Radu Timofte.
Swin2R improves the <a href="https://github.com/JingyunLiang/SwinIR/" rel="nofollow">SwinIR</a> model by incorporating <a href="swinv2">Swin Transformer v2</a> layers which mitigates issues such as training instability, resolution gaps between pre-training
and fine-tuning, and hunger on data.`,nt,se,oo="The abstract from the paper is the following:",st,ae,no=`<em>Compression plays an important role on the efficient transmission and storage of images and videos through band-limited systems such as streaming services, virtual reality or videogames. However, compression unavoidably leads to artifacts and the loss of the original information, which may severely degrade the visual quality. For these reasons, quality enhancement of compressed images has become a popular research topic. While most state-of-the-art image restoration methods are based on convolutional neural networks, other transformers-based methods such as SwinIR, show impressive performance on these tasks.
In this paper, we explore the novel Swin Transformer V2, to improve SwinIR for image super-resolution, and in particular, the compressed input scenario. Using this method we can tackle the major issues in training transformer vision models, such as training instability, resolution gaps between pre-training and fine-tuning, and hunger on data. We conduct experiments on three representative tasks: JPEG compression artifacts removal, image super-resolution (classical and lightweight), and compressed image super-resolution. Experimental results demonstrate that our method, Swin2SR, can improve the training convergence and performance of SwinIR, and is a top-5 solution at the “AIM 2022 Challenge on Super-Resolution of Compressed Image and Video”.</em>`,at,B,so,rt,re,ao='Swin2SR architecture. Taken from the <a href="https://arxiv.org/abs/2209.11345">original paper.</a>',it,ie,ro=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/mv-lab/swin2sr" rel="nofollow">here</a>.`,lt,J,Z,Xe,le,jt,xe,io="Resources",ct,ce,lo='Demo notebooks for Swin2SR can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/Swin2SR" rel="nofollow">here</a>.',dt,de,co='A demo Space for image super-resolution with SwinSR can be found <a href="https://huggingface.co/spaces/jjourney1125/swin2sr" rel="nofollow">here</a>.',pt,F,E,Ge,pe,It,je,po="Swin2SRImageProcessor",mt,I,me,Ut,Ie,mo="Constructs a Swin2SR image processor.",kt,H,he,Jt,Ue,ho="Preprocess an image or batch of images.",ht,N,q,Ae,ue,Ft,ke,uo="Swin2SRConfig",ut,R,fe,Nt,Je,fo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.34.0/en/model_doc/swin2sr#transformers.Swin2SRModel">Swin2SRModel</a>. It is used to instantiate a Swin
Transformer v2 model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Swin Transformer v2
<a href="https://huggingface.co/caidas/swin2sr-classicalsr-x2-64" rel="nofollow">caidas/swin2sr-classicalsr-x2-64</a> architecture.`,Wt,Fe,go=`Configuration objects inherit from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,zt,L,ft,W,X,Ve,ge,Pt,Ne,wo="Swin2SRModel",gt,U,we,Bt,We,_o=`The bare Swin2SR Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Zt,x,_e,Et,ze,vo='The <a href="/docs/transformers/v4.34.0/en/model_doc/swin2sr#transformers.Swin2SRModel">Swin2SRModel</a> forward method, overrides the <code>__call__</code> special method.',Ht,G,qt,A,wt,z,V,Ye,ve,Lt,Pe,So="Swin2SRForImageSuperResolution",_t,$,Se,Xt,Be,bo="Swin2SR Model transformer with an upsampler head on top for image super resolution and restoration.",Gt,Ze,yo=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,At,j,be,Vt,Ee,Mo='The <a href="/docs/transformers/v4.34.0/en/model_doc/swin2sr#transformers.Swin2SRForImageSuperResolution">Swin2SRForImageSuperResolution</a> forward method, overrides the <code>__call__</code> special method.',Yt,Y,Qt,Q,vt,Qe,St;return te=new Re({}),oe=new Re({}),le=new Re({}),pe=new Re({}),me=new Te({props:{name:"class transformers.Swin2SRImageProcessor",anchor:"transformers.Swin2SRImageProcessor",parameters:[{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_pad",val:": bool = True"},{name:"pad_size",val:": int = 8"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Swin2SRImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.Swin2SRImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.`,name:"rescale_factor"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/swin2sr/image_processing_swin2sr.py#L38"}}),he=new Te({props:{name:"preprocess",anchor:"transformers.Swin2SRImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_pad",val:": typing.Optional[bool] = None"},{name:"pad_size",val:": typing.Optional[int] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[transformers.image_utils.ChannelDimension, str, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Swin2SRImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.Swin2SRImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.Swin2SRImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.Swin2SRImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image to make the height and width divisible by <code>window_size</code>.`,name:"do_pad"},{anchor:"transformers.Swin2SRImageProcessor.preprocess.pad_size",description:`<strong>pad_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The size of the sliding window for the local attention.`,name:"pad_size"},{anchor:"transformers.Swin2SRImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of typ, input_data_format=input_data_formate
<code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.Swin2SRImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.Swin2SRImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/swin2sr/image_processing_swin2sr.py#L109"}}),ue=new Re({}),fe=new Te({props:{name:"class transformers.Swin2SRConfig",anchor:"transformers.Swin2SRConfig",parameters:[{name:"image_size",val:" = 64"},{name:"patch_size",val:" = 1"},{name:"num_channels",val:" = 3"},{name:"embed_dim",val:" = 180"},{name:"depths",val:" = [6, 6, 6, 6, 6, 6]"},{name:"num_heads",val:" = [6, 6, 6, 6, 6, 6]"},{name:"window_size",val:" = 8"},{name:"mlp_ratio",val:" = 2.0"},{name:"qkv_bias",val:" = True"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"drop_path_rate",val:" = 0.1"},{name:"hidden_act",val:" = 'gelu'"},{name:"use_absolute_embeddings",val:" = False"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"upscale",val:" = 2"},{name:"img_range",val:" = 1.0"},{name:"resi_connection",val:" = '1conv'"},{name:"upsampler",val:" = 'pixelshuffle'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Swin2SRConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.Swin2SRConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.Swin2SRConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.Swin2SRConfig.embed_dim",description:`<strong>embed_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 180) &#x2014;
Dimensionality of patch embedding.`,name:"embed_dim"},{anchor:"transformers.Swin2SRConfig.depths",description:`<strong>depths</strong> (<code>list(int)</code>, <em>optional</em>, defaults to <code>[6, 6, 6, 6, 6, 6]</code>) &#x2014;
Depth of each layer in the Transformer encoder.`,name:"depths"},{anchor:"transformers.Swin2SRConfig.num_heads",description:`<strong>num_heads</strong> (<code>list(int)</code>, <em>optional</em>, defaults to <code>[6, 6, 6, 6, 6, 6]</code>) &#x2014;
Number of attention heads in each layer of the Transformer encoder.`,name:"num_heads"},{anchor:"transformers.Swin2SRConfig.window_size",description:`<strong>window_size</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Size of windows.`,name:"window_size"},{anchor:"transformers.Swin2SRConfig.mlp_ratio",description:`<strong>mlp_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 2.0) &#x2014;
Ratio of MLP hidden dimensionality to embedding dimensionality.`,name:"mlp_ratio"},{anchor:"transformers.Swin2SRConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not a learnable bias should be added to the queries, keys and values.`,name:"qkv_bias"},{anchor:"transformers.Swin2SRConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings and encoder.`,name:"hidden_dropout_prob"},{anchor:"transformers.Swin2SRConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.Swin2SRConfig.drop_path_rate",description:`<strong>drop_path_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Stochastic depth rate.`,name:"drop_path_rate"},{anchor:"transformers.Swin2SRConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder. If string, <code>&quot;gelu&quot;</code>, <code>&quot;relu&quot;</code>,
<code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.Swin2SRConfig.use_absolute_embeddings",description:`<strong>use_absolute_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to add absolute position embeddings to the patch embeddings.`,name:"use_absolute_embeddings"},{anchor:"transformers.Swin2SRConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Swin2SRConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.Swin2SRConfig.upscale",description:`<strong>upscale</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The upscale factor for the image. 2/3/4/8 for image super resolution, 1 for denoising and compress artifact
reduction`,name:"upscale"},{anchor:"transformers.Swin2SRConfig.img_range",description:`<strong>img_range</strong> (<code>float</code>, <em>optional</em>, defaults to 1.) &#x2014;
The range of the values of the input image.`,name:"img_range"},{anchor:"transformers.Swin2SRConfig.resi_connection",description:`<strong>resi_connection</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;1conv&quot;</code>) &#x2014;
The convolutional block to use before the residual connection in each stage.`,name:"resi_connection"},{anchor:"transformers.Swin2SRConfig.upsampler",description:`<strong>upsampler</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pixelshuffle&quot;</code>) &#x2014;
The reconstruction reconstruction module. Can be &#x2018;pixelshuffle&#x2019;/&#x2018;pixelshuffledirect&#x2019;/&#x2018;nearest+conv&#x2019;/None.`,name:"upsampler"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/swin2sr/configuration_swin2sr.py#L30"}}),L=new Dt({props:{anchor:"transformers.Swin2SRConfig.example",$$slots:{default:[Ho]},$$scope:{ctx:C}}}),ge=new Re({}),we=new Te({props:{name:"class transformers.Swin2SRModel",anchor:"transformers.Swin2SRModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Swin2SRModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/swin2sr#transformers.Swin2SRConfig">Swin2SRConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/swin2sr/modeling_swin2sr.py#L847"}}),_e=new Te({props:{name:"forward",anchor:"transformers.Swin2SRModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Swin2SRModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__">Swin2SRImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.Swin2SRModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.Swin2SRModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Swin2SRModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Swin2SRModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/swin2sr/modeling_swin2sr.py#L896",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/swin2sr#transformers.Swin2SRConfig"
>Swin2SRConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),G=new No({props:{$$slots:{default:[qo]},$$scope:{ctx:C}}}),A=new Dt({props:{anchor:"transformers.Swin2SRModel.forward.example",$$slots:{default:[Lo]},$$scope:{ctx:C}}}),ve=new Re({}),Se=new Te({props:{name:"class transformers.Swin2SRForImageSuperResolution",anchor:"transformers.Swin2SRForImageSuperResolution",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Swin2SRForImageSuperResolution.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/swin2sr#transformers.Swin2SRConfig">Swin2SRConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/swin2sr/modeling_swin2sr.py#L1101"}}),be=new Te({props:{name:"forward",anchor:"transformers.Swin2SRForImageSuperResolution.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Swin2SRForImageSuperResolution.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__">Swin2SRImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.Swin2SRForImageSuperResolution.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.Swin2SRForImageSuperResolution.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Swin2SRForImageSuperResolution.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Swin2SRForImageSuperResolution.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/swin2sr/modeling_swin2sr.py#L1128",returnDescription:`
<p>A <code>transformers.modeling_outputs.ImageSuperResolutionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/swin2sr#transformers.Swin2SRConfig"
>Swin2SRConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Reconstruction loss.</p>
</li>
<li>
<p><strong>reconstruction</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Reconstructed images, possibly upscaled.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states
(also called feature maps) of the model at the output of each stage.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><code>transformers.modeling_outputs.ImageSuperResolutionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Y=new No({props:{$$slots:{default:[Xo]},$$scope:{ctx:C}}}),Q=new Dt({props:{anchor:"transformers.Swin2SRForImageSuperResolution.forward.example",$$slots:{default:[Go]},$$scope:{ctx:C}}}),{c(){l=o("meta"),M=c(),m=o("p"),h=c(),g=o("h1"),r=o("a"),T=o("span"),w(te.$$.fragment),Ct=c(),$e=o("span"),$e.textContent=Kt,tt=c(),k=o("h2"),P=o("a"),Le=o("span"),w(oe.$$.fragment),xt=c(),Ce=o("span"),Ce.textContent=eo,ot=c(),ne=o("p"),ne.innerHTML=to,nt=c(),se=o("p"),se.textContent=oo,st=c(),ae=o("p"),ae.innerHTML=no,at=c(),B=o("img"),rt=c(),re=o("small"),re.innerHTML=ao,it=c(),ie=o("p"),ie.innerHTML=ro,lt=c(),J=o("h2"),Z=o("a"),Xe=o("span"),w(le.$$.fragment),jt=c(),xe=o("span"),xe.textContent=io,ct=c(),ce=o("p"),ce.innerHTML=lo,dt=c(),de=o("p"),de.innerHTML=co,pt=c(),F=o("h2"),E=o("a"),Ge=o("span"),w(pe.$$.fragment),It=c(),je=o("span"),je.textContent=po,mt=c(),I=o("div"),w(me.$$.fragment),Ut=c(),Ie=o("p"),Ie.textContent=mo,kt=c(),H=o("div"),w(he.$$.fragment),Jt=c(),Ue=o("p"),Ue.textContent=ho,ht=c(),N=o("h2"),q=o("a"),Ae=o("span"),w(ue.$$.fragment),Ft=c(),ke=o("span"),ke.textContent=uo,ut=c(),R=o("div"),w(fe.$$.fragment),Nt=c(),Je=o("p"),Je.innerHTML=fo,Wt=c(),Fe=o("p"),Fe.innerHTML=go,zt=c(),w(L.$$.fragment),ft=c(),W=o("h2"),X=o("a"),Ve=o("span"),w(ge.$$.fragment),Pt=c(),Ne=o("span"),Ne.textContent=wo,gt=c(),U=o("div"),w(we.$$.fragment),Bt=c(),We=o("p"),We.innerHTML=_o,Zt=c(),x=o("div"),w(_e.$$.fragment),Et=c(),ze=o("p"),ze.innerHTML=vo,Ht=c(),w(G.$$.fragment),qt=c(),w(A.$$.fragment),wt=c(),z=o("h2"),V=o("a"),Ye=o("span"),w(ve.$$.fragment),Lt=c(),Pe=o("span"),Pe.textContent=So,_t=c(),$=o("div"),w(Se.$$.fragment),Xt=c(),Be=o("p"),Be.textContent=bo,Gt=c(),Ze=o("p"),Ze.innerHTML=yo,At=c(),j=o("div"),w(be.$$.fragment),Vt=c(),Ee=o("p"),Ee.innerHTML=Mo,Yt=c(),w(Y.$$.fragment),Qt=c(),w(Q.$$.fragment),vt=c(),Qe=o("p"),this.h()},l(e){const a=Eo("svelte-1phssyn",document.head);l=n(a,"META",{name:!0,content:!0}),a.forEach(t),M=d(e),m=n(e,"P",{}),u(m).forEach(t),h=d(e),g=n(e,"H1",{class:!0});var ye=u(g);r=n(ye,"A",{id:!0,class:!0,href:!0});var De=u(r);T=n(De,"SPAN",{});var Oe=u(T);_(te.$$.fragment,Oe),Oe.forEach(t),De.forEach(t),Ct=d(ye),$e=n(ye,"SPAN",{"data-svelte-h":!0}),f($e)!=="svelte-1w9imfz"&&($e.textContent=Kt),ye.forEach(t),tt=d(e),k=n(e,"H2",{class:!0});var Me=u(k);P=n(Me,"A",{id:!0,class:!0,href:!0});var Ke=u(P);Le=n(Ke,"SPAN",{});var To=u(Le);_(oe.$$.fragment,To),To.forEach(t),Ke.forEach(t),xt=d(Me),Ce=n(Me,"SPAN",{"data-svelte-h":!0}),f(Ce)!=="svelte-1jsw1pg"&&(Ce.textContent=eo),Me.forEach(t),ot=d(e),ne=n(e,"P",{"data-svelte-h":!0}),f(ne)!=="svelte-ey7lmd"&&(ne.innerHTML=to),nt=d(e),se=n(e,"P",{"data-svelte-h":!0}),f(se)!=="svelte-vfdo9a"&&(se.textContent=oo),st=d(e),ae=n(e,"P",{"data-svelte-h":!0}),f(ae)!=="svelte-180sy5i"&&(ae.innerHTML=no),at=d(e),B=n(e,"IMG",{src:!0,alt:!0,width:!0}),rt=d(e),re=n(e,"SMALL",{"data-svelte-h":!0}),f(re)!=="svelte-1f14c9b"&&(re.innerHTML=ao),it=d(e),ie=n(e,"P",{"data-svelte-h":!0}),f(ie)!=="svelte-1qdp0v2"&&(ie.innerHTML=ro),lt=d(e),J=n(e,"H2",{class:!0});var bt=u(J);Z=n(bt,"A",{id:!0,class:!0,href:!0});var Ro=u(Z);Xe=n(Ro,"SPAN",{});var $o=u(Xe);_(le.$$.fragment,$o),$o.forEach(t),Ro.forEach(t),jt=d(bt),xe=n(bt,"SPAN",{"data-svelte-h":!0}),f(xe)!=="svelte-w4zzv6"&&(xe.textContent=io),bt.forEach(t),ct=d(e),ce=n(e,"P",{"data-svelte-h":!0}),f(ce)!=="svelte-1w7u0gr"&&(ce.innerHTML=lo),dt=d(e),de=n(e,"P",{"data-svelte-h":!0}),f(de)!=="svelte-1o6g186"&&(de.innerHTML=co),pt=d(e),F=n(e,"H2",{class:!0});var yt=u(F);E=n(yt,"A",{id:!0,class:!0,href:!0});var Co=u(E);Ge=n(Co,"SPAN",{});var xo=u(Ge);_(pe.$$.fragment,xo),xo.forEach(t),Co.forEach(t),It=d(yt),je=n(yt,"SPAN",{"data-svelte-h":!0}),f(je)!=="svelte-18ba0z0"&&(je.textContent=po),yt.forEach(t),mt=d(e),I=n(e,"DIV",{class:!0});var He=u(I);_(me.$$.fragment,He),Ut=d(He),Ie=n(He,"P",{"data-svelte-h":!0}),f(Ie)!=="svelte-1jih302"&&(Ie.textContent=mo),kt=d(He),H=n(He,"DIV",{class:!0});var Mt=u(H);_(he.$$.fragment,Mt),Jt=d(Mt),Ue=n(Mt,"P",{"data-svelte-h":!0}),f(Ue)!=="svelte-1x3yxsa"&&(Ue.textContent=ho),Mt.forEach(t),He.forEach(t),ht=d(e),N=n(e,"H2",{class:!0});var Tt=u(N);q=n(Tt,"A",{id:!0,class:!0,href:!0});var jo=u(q);Ae=n(jo,"SPAN",{});var Io=u(Ae);_(ue.$$.fragment,Io),Io.forEach(t),jo.forEach(t),Ft=d(Tt),ke=n(Tt,"SPAN",{"data-svelte-h":!0}),f(ke)!=="svelte-nu5o15"&&(ke.textContent=uo),Tt.forEach(t),ut=d(e),R=n(e,"DIV",{class:!0});var D=u(R);_(fe.$$.fragment,D),Nt=d(D),Je=n(D,"P",{"data-svelte-h":!0}),f(Je)!=="svelte-aa7sl5"&&(Je.innerHTML=fo),Wt=d(D),Fe=n(D,"P",{"data-svelte-h":!0}),f(Fe)!=="svelte-10kqkkl"&&(Fe.innerHTML=go),zt=d(D),_(L.$$.fragment,D),D.forEach(t),ft=d(e),W=n(e,"H2",{class:!0});var Rt=u(W);X=n(Rt,"A",{id:!0,class:!0,href:!0});var Uo=u(X);Ve=n(Uo,"SPAN",{});var ko=u(Ve);_(ge.$$.fragment,ko),ko.forEach(t),Uo.forEach(t),Pt=d(Rt),Ne=n(Rt,"SPAN",{"data-svelte-h":!0}),f(Ne)!=="svelte-z7926e"&&(Ne.textContent=wo),Rt.forEach(t),gt=d(e),U=n(e,"DIV",{class:!0});var qe=u(U);_(we.$$.fragment,qe),Bt=d(qe),We=n(qe,"P",{"data-svelte-h":!0}),f(We)!=="svelte-8sq17a"&&(We.innerHTML=_o),Zt=d(qe),x=n(qe,"DIV",{class:!0});var O=u(x);_(_e.$$.fragment,O),Et=d(O),ze=n(O,"P",{"data-svelte-h":!0}),f(ze)!=="svelte-l4oe3z"&&(ze.innerHTML=vo),Ht=d(O),_(G.$$.fragment,O),qt=d(O),_(A.$$.fragment,O),O.forEach(t),qe.forEach(t),wt=d(e),z=n(e,"H2",{class:!0});var $t=u(z);V=n($t,"A",{id:!0,class:!0,href:!0});var Jo=u(V);Ye=n(Jo,"SPAN",{});var Fo=u(Ye);_(ve.$$.fragment,Fo),Fo.forEach(t),Jo.forEach(t),Lt=d($t),Pe=n($t,"SPAN",{"data-svelte-h":!0}),f(Pe)!=="svelte-xgnvm6"&&(Pe.textContent=So),$t.forEach(t),_t=d(e),$=n(e,"DIV",{class:!0});var K=u($);_(Se.$$.fragment,K),Xt=d(K),Be=n(K,"P",{"data-svelte-h":!0}),f(Be)!=="svelte-31vje8"&&(Be.textContent=bo),Gt=d(K),Ze=n(K,"P",{"data-svelte-h":!0}),f(Ze)!=="svelte-68lg8f"&&(Ze.innerHTML=yo),At=d(K),j=n(K,"DIV",{class:!0});var ee=u(j);_(be.$$.fragment,ee),Vt=d(ee),Ee=n(ee,"P",{"data-svelte-h":!0}),f(Ee)!=="svelte-1mbsrl7"&&(Ee.innerHTML=Mo),Yt=d(ee),_(Y.$$.fragment,ee),Qt=d(ee),_(Q.$$.fragment,ee),ee.forEach(t),K.forEach(t),vt=d(e),Qe=n(e,"P",{}),u(Qe).forEach(t),this.h()},h(){p(l,"name","hf:doc:metadata"),p(l,"content",JSON.stringify(Vo)),p(r,"id","swin2sr"),p(r,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(r,"href","#swin2sr"),p(g,"class","relative group"),p(P,"id","overview"),p(P,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(P,"href","#overview"),p(k,"class","relative group"),zo(B.src,so="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/swin2sr_architecture.png")||p(B,"src",so),p(B,"alt","drawing"),p(B,"width","600"),p(Z,"id","resources"),p(Z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Z,"href","#resources"),p(J,"class","relative group"),p(E,"id","transformers.Swin2SRImageProcessor"),p(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(E,"href","#transformers.Swin2SRImageProcessor"),p(F,"class","relative group"),p(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(q,"id","transformers.Swin2SRConfig"),p(q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(q,"href","#transformers.Swin2SRConfig"),p(N,"class","relative group"),p(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(X,"id","transformers.Swin2SRModel"),p(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(X,"href","#transformers.Swin2SRModel"),p(W,"class","relative group"),p(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(V,"id","transformers.Swin2SRForImageSuperResolution"),p(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(V,"href","#transformers.Swin2SRForImageSuperResolution"),p(z,"class","relative group"),p(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){s(document.head,l),i(e,M,a),i(e,m,a),i(e,h,a),i(e,g,a),s(g,r),s(r,T),v(te,T,null),s(g,Ct),s(g,$e),i(e,tt,a),i(e,k,a),s(k,P),s(P,Le),v(oe,Le,null),s(k,xt),s(k,Ce),i(e,ot,a),i(e,ne,a),i(e,nt,a),i(e,se,a),i(e,st,a),i(e,ae,a),i(e,at,a),i(e,B,a),i(e,rt,a),i(e,re,a),i(e,it,a),i(e,ie,a),i(e,lt,a),i(e,J,a),s(J,Z),s(Z,Xe),v(le,Xe,null),s(J,jt),s(J,xe),i(e,ct,a),i(e,ce,a),i(e,dt,a),i(e,de,a),i(e,pt,a),i(e,F,a),s(F,E),s(E,Ge),v(pe,Ge,null),s(F,It),s(F,je),i(e,mt,a),i(e,I,a),v(me,I,null),s(I,Ut),s(I,Ie),s(I,kt),s(I,H),v(he,H,null),s(H,Jt),s(H,Ue),i(e,ht,a),i(e,N,a),s(N,q),s(q,Ae),v(ue,Ae,null),s(N,Ft),s(N,ke),i(e,ut,a),i(e,R,a),v(fe,R,null),s(R,Nt),s(R,Je),s(R,Wt),s(R,Fe),s(R,zt),v(L,R,null),i(e,ft,a),i(e,W,a),s(W,X),s(X,Ve),v(ge,Ve,null),s(W,Pt),s(W,Ne),i(e,gt,a),i(e,U,a),v(we,U,null),s(U,Bt),s(U,We),s(U,Zt),s(U,x),v(_e,x,null),s(x,Et),s(x,ze),s(x,Ht),v(G,x,null),s(x,qt),v(A,x,null),i(e,wt,a),i(e,z,a),s(z,V),s(V,Ye),v(ve,Ye,null),s(z,Lt),s(z,Pe),i(e,_t,a),i(e,$,a),v(Se,$,null),s($,Xt),s($,Be),s($,Gt),s($,Ze),s($,At),s($,j),v(be,j,null),s(j,Vt),s(j,Ee),s(j,Yt),v(Y,j,null),s(j,Qt),v(Q,j,null),i(e,vt,a),i(e,Qe,a),St=!0},p(e,[a]){const ye={};a&2&&(ye.$$scope={dirty:a,ctx:e}),L.$set(ye);const De={};a&2&&(De.$$scope={dirty:a,ctx:e}),G.$set(De);const Oe={};a&2&&(Oe.$$scope={dirty:a,ctx:e}),A.$set(Oe);const Me={};a&2&&(Me.$$scope={dirty:a,ctx:e}),Y.$set(Me);const Ke={};a&2&&(Ke.$$scope={dirty:a,ctx:e}),Q.$set(Ke)},i(e){St||(S(te.$$.fragment,e),S(oe.$$.fragment,e),S(le.$$.fragment,e),S(pe.$$.fragment,e),S(me.$$.fragment,e),S(he.$$.fragment,e),S(ue.$$.fragment,e),S(fe.$$.fragment,e),S(L.$$.fragment,e),S(ge.$$.fragment,e),S(we.$$.fragment,e),S(_e.$$.fragment,e),S(G.$$.fragment,e),S(A.$$.fragment,e),S(ve.$$.fragment,e),S(Se.$$.fragment,e),S(be.$$.fragment,e),S(Y.$$.fragment,e),S(Q.$$.fragment,e),St=!0)},o(e){b(te.$$.fragment,e),b(oe.$$.fragment,e),b(le.$$.fragment,e),b(pe.$$.fragment,e),b(me.$$.fragment,e),b(he.$$.fragment,e),b(ue.$$.fragment,e),b(fe.$$.fragment,e),b(L.$$.fragment,e),b(ge.$$.fragment,e),b(we.$$.fragment,e),b(_e.$$.fragment,e),b(G.$$.fragment,e),b(A.$$.fragment,e),b(ve.$$.fragment,e),b(Se.$$.fragment,e),b(be.$$.fragment,e),b(Y.$$.fragment,e),b(Q.$$.fragment,e),St=!1},d(e){e&&(t(M),t(m),t(h),t(g),t(tt),t(k),t(ot),t(ne),t(nt),t(se),t(st),t(ae),t(at),t(B),t(rt),t(re),t(it),t(ie),t(lt),t(J),t(ct),t(ce),t(dt),t(de),t(pt),t(F),t(mt),t(I),t(ht),t(N),t(ut),t(R),t(ft),t(W),t(gt),t(U),t(wt),t(z),t(_t),t($),t(vt),t(Qe)),t(l),y(te),y(oe),y(le),y(pe),y(me),y(he),y(ue),y(fe),y(L),y(ge),y(we),y(_e),y(G),y(A),y(ve),y(Se),y(be),y(Y),y(Q)}}}const Vo={local:"swin2sr",sections:[{local:"overview",title:"Overview"},{local:"resources",title:"Resources"},{local:"transformers.Swin2SRImageProcessor",title:"Swin2SRImageProcessor"},{local:"transformers.Swin2SRConfig",title:"Swin2SRConfig"},{local:"transformers.Swin2SRModel",title:"Swin2SRModel"},{local:"transformers.Swin2SRForImageSuperResolution",title:"Swin2SRForImageSuperResolution"}],title:"Swin2SR"};function Yo(C){return Po(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nn extends Bo{constructor(l){super(),Zo(this,l,Yo,Ao,Wo,{})}}export{nn as component};
