import{s as gh,o as _h,n as J}from"../chunks/scheduler.9bc65507.js";import{S as Th,i as bh,g as o,s as r,u as f,A as yh,h as s,f as t,c as i,j as v,v as g,y as p,k as m,o as n,a as d,w as _,d as T,t as b,x as y}from"../chunks/index.78c82d43.js";import{T as O}from"../chunks/Tip.87d55b76.js";import{D as z}from"../chunks/Docstring.4e7352e2.js";import{C as H}from"../chunks/CodeBlock.73e038be.js";import{I as U}from"../chunks/IconCopyLink.bedaa44d.js";import{E as he}from"../chunks/ExampleCodeBlock.872b014d.js";import{P as is}from"../chunks/PipelineTag.75b0f707.js";function vh($){let l,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=o("p"),l.innerHTML=k},l(u){l=s(u,"P",{"data-svelte-h":!0}),p(l)!=="svelte-fincs2"&&(l.innerHTML=k)},m(u,h){d(u,l,h)},p:J,d(u){u&&t(l)}}}function kh($){let l,k="Example:",u,h,M;return h=new H({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUNU1vZGVsJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIydDUtc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBUNU1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJ0NS1zbWFsbCUyMiklMEElMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwJTIyU3R1ZGllcyUyMGhhdmUlMjBiZWVuJTIwc2hvd24lMjB0aGF0JTIwb3duaW5nJTIwYSUyMGRvZyUyMGlzJTIwZ29vZCUyMGZvciUyMHlvdSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpLmlucHV0X2lkcyUyMCUyMCUyMyUyMEJhdGNoJTIwc2l6ZSUyMDElMEFkZWNvZGVyX2lucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplciglMjJTdHVkaWVzJTIwc2hvdyUyMHRoYXQlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5pbnB1dF9pZHMlMjAlMjAlMjMlMjBCYXRjaCUyMHNpemUlMjAxJTBBJTBBJTIzJTIwcHJlcHJvY2VzcyUzQSUyMFByZXBlbmQlMjBkZWNvZGVyX2lucHV0X2lkcyUyMHdpdGglMjBzdGFydCUyMHRva2VuJTIwd2hpY2glMjBpcyUyMHBhZCUyMHRva2VuJTIwZm9yJTIwVDVNb2RlbC4lMEElMjMlMjBUaGlzJTIwaXMlMjBub3QlMjBuZWVkZWQlMjBmb3IlMjB0b3JjaCdzJTIwVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMjBhcyUyMGl0JTIwZG9lcyUyMHRoaXMlMjBpbnRlcm5hbGx5JTIwdXNpbmclMjBsYWJlbHMlMjBhcmcuJTBBZGVjb2Rlcl9pbnB1dF9pZHMlMjAlM0QlMjBtb2RlbC5fc2hpZnRfcmlnaHQoZGVjb2Rlcl9pbnB1dF9pZHMpJTBBJTBBJTIzJTIwZm9yd2FyZCUyMHBhc3MlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzJTNEaW5wdXRfaWRzJTJDJTIwZGVjb2Rlcl9pbnB1dF9pZHMlM0RkZWNvZGVyX2lucHV0X2lkcyklMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, T5Model

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = T5Model.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Studies have been shown that owning a dog is good for you&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).input_ids  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = tokenizer(<span class="hljs-string">&quot;Studies show that&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids  <span class="hljs-comment"># Batch size 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># preprocess: Prepend decoder_input_ids with start token which is pad token for T5Model.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This is not needed for torch&#x27;s T5ForConditionalGeneration as it does this internally using labels arg.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = model._shift_right(decoder_input_ids)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids=input_ids, decoder_input_ids=decoder_input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){l=o("p"),l.textContent=k,u=r(),f(h.$$.fragment)},l(c){l=s(c,"P",{"data-svelte-h":!0}),p(l)!=="svelte-11lpom8"&&(l.textContent=k),u=i(c),g(h.$$.fragment,c)},m(c,w){d(c,l,w),d(c,u,w),_(h,c,w),M=!0},p:J,i(c){M||(T(h.$$.fragment,c),M=!0)},o(c){b(h.$$.fragment,c),M=!1},d(c){c&&(t(l),t(u)),y(h,c)}}}function Mh($){let l,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=o("p"),l.innerHTML=k},l(u){l=s(u,"P",{"data-svelte-h":!0}),p(l)!=="svelte-fincs2"&&(l.innerHTML=k)},m(u,h){d(u,l,h)},p:J,d(u){u&&t(l)}}}function wh($){let l,k="Examples:",u,h,M;return h=new H({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUNUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnQ1LXNtYWxsJTIyKSUwQW1vZGVsJTIwJTNEJTIwVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnQ1LXNtYWxsJTIyKSUwQSUwQSUyMyUyMHRyYWluaW5nJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMCUzQ2V4dHJhX2lkXzAlM0UlMjB3YWxrcyUyMGluJTIwJTNDZXh0cmFfaWRfMSUzRSUyMHBhcmslMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5pbnB1dF9pZHMlMEFsYWJlbHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyJTNDZXh0cmFfaWRfMCUzRSUyMGN1dGUlMjBkb2clMjAlM0NleHRyYV9pZF8xJTNFJTIwdGhlJTIwJTNDZXh0cmFfaWRfMiUzRSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLmlucHV0X2lkcyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dF9pZHMlM0RpbnB1dF9pZHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpJTBBbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBJTBBJTIzJTIwaW5mZXJlbmNlJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCUyMnN1bW1hcml6ZSUzQSUyMHN0dWRpZXMlMjBoYXZlJTIwc2hvd24lMjB0aGF0JTIwb3duaW5nJTIwYSUyMGRvZyUyMGlzJTIwZ29vZCUyMGZvciUyMHlvdSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpLmlucHV0X2lkcyUyMCUyMCUyMyUyMEJhdGNoJTIwc2l6ZSUyMDElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRfaWRzKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0cyU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkpJTBBJTIzJTIwc3R1ZGllcyUyMGhhdmUlMjBzaG93biUyMHRoYXQlMjBvd25pbmclMjBhJTIwZG9nJTIwaXMlMjBnb29kJTIwZm9yJTIweW91Lg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, T5ForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = T5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># training</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(<span class="hljs-string">&quot;The &lt;extra_id_0&gt; walks in &lt;extra_id_1&gt; park&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(<span class="hljs-string">&quot;&lt;extra_id_0&gt; cute dog &lt;extra_id_1&gt; the &lt;extra_id_2&gt;&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids=input_ids, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;summarize: studies have shown that owning a dog is good for you&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).input_ids  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># studies have shown that owning a dog is good for you.</span>`,wrap:!1}}),{c(){l=o("p"),l.textContent=k,u=r(),f(h.$$.fragment)},l(c){l=s(c,"P",{"data-svelte-h":!0}),p(l)!=="svelte-kvfsh7"&&(l.textContent=k),u=i(c),g(h.$$.fragment,c)},m(c,w){d(c,l,w),d(c,u,w),_(h,c,w),M=!0},p:J,i(c){M||(T(h.$$.fragment,c),M=!0)},o(c){b(h.$$.fragment,c),M=!1},d(c){c&&(t(l),t(u)),y(h,c)}}}function xh($){let l,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=o("p"),l.innerHTML=k},l(u){l=s(u,"P",{"data-svelte-h":!0}),p(l)!=="svelte-fincs2"&&(l.innerHTML=k)},m(u,h){d(u,l,h)},p:J,d(u){u&&t(l)}}}function $h($){let l,k="Example:",u,h,M;return h=new H({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUNUVuY29kZXJNb2RlbCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnQ1LXNtYWxsJTIyKSUwQW1vZGVsJTIwJTNEJTIwVDVFbmNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnQ1LXNtYWxsJTIyKSUwQWlucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlMjJTdHVkaWVzJTIwaGF2ZSUyMGJlZW4lMjBzaG93biUyMHRoYXQlMjBvd25pbmclMjBhJTIwZG9nJTIwaXMlMjBnb29kJTIwZm9yJTIweW91JTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUwQSkuaW5wdXRfaWRzJTIwJTIwJTIzJTIwQmF0Y2glMjBzaXplJTIwMSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dF9pZHMlM0RpbnB1dF9pZHMpJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, T5EncoderModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = T5EncoderModel.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Studies have been shown that owning a dog is good for you&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).input_ids  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids=input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){l=o("p"),l.textContent=k,u=r(),f(h.$$.fragment)},l(c){l=s(c,"P",{"data-svelte-h":!0}),p(l)!=="svelte-11lpom8"&&(l.textContent=k),u=i(c),g(h.$$.fragment,c)},m(c,w){d(c,l,w),d(c,u,w),_(h,c,w),M=!0},p:J,i(c){M||(T(h.$$.fragment,c),M=!0)},o(c){b(h.$$.fragment,c),M=!1},d(c){c&&(t(l),t(u)),y(h,c)}}}function jh($){let l,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=o("p"),l.innerHTML=k},l(u){l=s(u,"P",{"data-svelte-h":!0}),p(l)!=="svelte-fincs2"&&(l.innerHTML=k)},m(u,h){d(u,l,h)},p:J,d(u){u&&t(l)}}}function zh($){let l,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=o("p"),l.innerHTML=k},l(u){l=s(u,"P",{"data-svelte-h":!0}),p(l)!=="svelte-fincs2"&&(l.innerHTML=k)},m(u,h){d(u,l,h)},p:J,d(u){u&&t(l)}}}function Fh($){let l,k="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",u,h,M="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",c,w,S=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,B,C,me=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,q,F,fe=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){l=o("p"),l.innerHTML=k,u=r(),h=o("ul"),h.innerHTML=M,c=r(),w=o("p"),w.innerHTML=S,B=r(),C=o("ul"),C.innerHTML=me,q=r(),F=o("p"),F.innerHTML=fe},l(x){l=s(x,"P",{"data-svelte-h":!0}),p(l)!=="svelte-1ajbfxg"&&(l.innerHTML=k),u=i(x),h=s(x,"UL",{"data-svelte-h":!0}),p(h)!=="svelte-qm1t26"&&(h.innerHTML=M),c=i(x),w=s(x,"P",{"data-svelte-h":!0}),p(w)!=="svelte-1v9qsc5"&&(w.innerHTML=S),B=i(x),C=s(x,"UL",{"data-svelte-h":!0}),p(C)!=="svelte-15scerc"&&(C.innerHTML=me),q=i(x),F=s(x,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1an3odd"&&(F.innerHTML=fe)},m(x,j){d(x,l,j),d(x,u,j),d(x,h,j),d(x,c,j),d(x,w,j),d(x,B,j),d(x,C,j),d(x,q,j),d(x,F,j)},p:J,d(x){x&&(t(l),t(u),t(h),t(c),t(w),t(B),t(C),t(q),t(F))}}}function Ch($){let l,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=o("p"),l.innerHTML=k},l(u){l=s(u,"P",{"data-svelte-h":!0}),p(l)!=="svelte-fincs2"&&(l.innerHTML=k)},m(u,h){d(u,l,h)},p:J,d(u){u&&t(l)}}}function Jh($){let l,k="Examples:",u,h,M;return h=new H({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURlQ1TW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ0NS1zbWFsbCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGVDVNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIydDUtc21hbGwlMjIpJTBBJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCUyMlN0dWRpZXMlMjBoYXZlJTIwYmVlbiUyMHNob3duJTIwdGhhdCUyMG93bmluZyUyMGElMjBkb2clMjBpcyUyMGdvb2QlMjBmb3IlMjB5b3UlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyJTBBKS5pbnB1dF9pZHMlMjAlMjAlMjMlMjBCYXRjaCUyMHNpemUlMjAxJTBBZGVjb2Rlcl9pbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyU3R1ZGllcyUyMHNob3clMjB0aGF0JTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMikuaW5wdXRfaWRzJTIwJTIwJTIzJTIwQmF0Y2glMjBzaXplJTIwMSUwQSUwQSUyMyUyMHByZXByb2Nlc3MlM0ElMjBQcmVwZW5kJTIwZGVjb2Rlcl9pbnB1dF9pZHMlMjB3aXRoJTIwc3RhcnQlMjB0b2tlbiUyMHdoaWNoJTIwaXMlMjBwYWQlMjB0b2tlbiUyMGZvciUyMFQ1TW9kZWwuJTBBJTIzJTIwVGhpcyUyMGlzJTIwbm90JTIwbmVlZGVkJTIwZm9yJTIwdG9yY2gncyUyMFQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTIwYXMlMjBpdCUyMGRvZXMlMjB0aGlzJTIwaW50ZXJuYWxseSUyMHVzaW5nJTIwbGFiZWxzJTIwYXJnLiUwQWRlY29kZXJfaW5wdXRfaWRzJTIwJTNEJTIwbW9kZWwuX3NoaWZ0X3JpZ2h0KGRlY29kZXJfaW5wdXRfaWRzKSUwQSUwQSUyMyUyMGZvcndhcmQlMjBwYXNzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUyQyUyMGRlY29kZXJfaW5wdXRfaWRzJTNEZGVjb2Rlcl9pbnB1dF9pZHMpJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFT5Model

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFT5Model.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Studies have been shown that owning a dog is good for you&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>
<span class="hljs-meta">... </span>).input_ids  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = tokenizer(<span class="hljs-string">&quot;Studies show that&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>).input_ids  <span class="hljs-comment"># Batch size 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># preprocess: Prepend decoder_input_ids with start token which is pad token for T5Model.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This is not needed for torch&#x27;s T5ForConditionalGeneration as it does this internally using labels arg.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = model._shift_right(decoder_input_ids)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids, decoder_input_ids=decoder_input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){l=o("p"),l.textContent=k,u=r(),f(h.$$.fragment)},l(c){l=s(c,"P",{"data-svelte-h":!0}),p(l)!=="svelte-kvfsh7"&&(l.textContent=k),u=i(c),g(h.$$.fragment,c)},m(c,w){d(c,l,w),d(c,u,w),_(h,c,w),M=!0},p:J,i(c){M||(T(h.$$.fragment,c),M=!0)},o(c){b(h.$$.fragment,c),M=!1},d(c){c&&(t(l),t(u)),y(h,c)}}}function Uh($){let l,k="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",u,h,M="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",c,w,S=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,B,C,me=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,q,F,fe=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){l=o("p"),l.innerHTML=k,u=r(),h=o("ul"),h.innerHTML=M,c=r(),w=o("p"),w.innerHTML=S,B=r(),C=o("ul"),C.innerHTML=me,q=r(),F=o("p"),F.innerHTML=fe},l(x){l=s(x,"P",{"data-svelte-h":!0}),p(l)!=="svelte-1ajbfxg"&&(l.innerHTML=k),u=i(x),h=s(x,"UL",{"data-svelte-h":!0}),p(h)!=="svelte-qm1t26"&&(h.innerHTML=M),c=i(x),w=s(x,"P",{"data-svelte-h":!0}),p(w)!=="svelte-1v9qsc5"&&(w.innerHTML=S),B=i(x),C=s(x,"UL",{"data-svelte-h":!0}),p(C)!=="svelte-15scerc"&&(C.innerHTML=me),q=i(x),F=s(x,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1an3odd"&&(F.innerHTML=fe)},m(x,j){d(x,l,j),d(x,u,j),d(x,h,j),d(x,c,j),d(x,w,j),d(x,B,j),d(x,C,j),d(x,q,j),d(x,F,j)},p:J,d(x){x&&(t(l),t(u),t(h),t(c),t(w),t(B),t(C),t(q),t(F))}}}function qh($){let l,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=o("p"),l.innerHTML=k},l(u){l=s(u,"P",{"data-svelte-h":!0}),p(l)!=="svelte-fincs2"&&(l.innerHTML=k)},m(u,h){d(u,l,h)},p:J,d(u){u&&t(l)}}}function Ih($){let l,k="Examples:",u,h,M;return h=new H({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURlQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIydDUtc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBURlQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJ0NS1zbWFsbCUyMiklMEElMEElMjMlMjB0cmFpbmluZyUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUaGUlMjAlM0NleHRyYV9pZF8wJTNFJTIwd2Fsa3MlMjBpbiUyMCUzQ2V4dHJhX2lkXzElM0UlMjBwYXJrJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMikuaW5wdXRfaWRzJTBBbGFiZWxzJTIwJTNEJTIwdG9rZW5pemVyKCUyMiUzQ2V4dHJhX2lkXzAlM0UlMjBjdXRlJTIwZG9nJTIwJTNDZXh0cmFfaWRfMSUzRSUyMHRoZSUyMCUzQ2V4dHJhX2lkXzIlM0UlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKS5pbnB1dF9pZHMlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQSUwQSUyMyUyMGluZmVyZW5jZSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlMjJzdW1tYXJpemUlM0ElMjBzdHVkaWVzJTIwaGF2ZSUyMHNob3duJTIwdGhhdCUyMG93bmluZyUyMGElMjBkb2clMjBpcyUyMGdvb2QlMjBmb3IlMjB5b3UlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyJTBBKS5pbnB1dF9pZHMlMjAlMjAlMjMlMjBCYXRjaCUyMHNpemUlMjAxJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dHMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSUyMyUyMHN0dWRpZXMlMjBoYXZlJTIwc2hvd24lMjB0aGF0JTIwb3duaW5nJTIwYSUyMGRvZyUyMGlzJTIwZ29vZCUyMGZvciUyMHlvdQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFT5ForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFT5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># training</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;The &lt;extra_id_0&gt; walks in &lt;extra_id_1&gt; park&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(<span class="hljs-string">&quot;&lt;extra_id_0&gt; cute dog &lt;extra_id_1&gt; the &lt;extra_id_2&gt;&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;summarize: studies have shown that owning a dog is good for you&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>
<span class="hljs-meta">... </span>).input_ids  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># studies have shown that owning a dog is good for you</span>`,wrap:!1}}),{c(){l=o("p"),l.textContent=k,u=r(),f(h.$$.fragment)},l(c){l=s(c,"P",{"data-svelte-h":!0}),p(l)!=="svelte-kvfsh7"&&(l.textContent=k),u=i(c),g(h.$$.fragment,c)},m(c,w){d(c,l,w),d(c,u,w),_(h,c,w),M=!0},p:J,i(c){M||(T(h.$$.fragment,c),M=!0)},o(c){b(h.$$.fragment,c),M=!1},d(c){c&&(t(l),t(u)),y(h,c)}}}function Zh($){let l,k="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",u,h,M="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",c,w,S=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,B,C,me=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,q,F,fe=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){l=o("p"),l.innerHTML=k,u=r(),h=o("ul"),h.innerHTML=M,c=r(),w=o("p"),w.innerHTML=S,B=r(),C=o("ul"),C.innerHTML=me,q=r(),F=o("p"),F.innerHTML=fe},l(x){l=s(x,"P",{"data-svelte-h":!0}),p(l)!=="svelte-1ajbfxg"&&(l.innerHTML=k),u=i(x),h=s(x,"UL",{"data-svelte-h":!0}),p(h)!=="svelte-qm1t26"&&(h.innerHTML=M),c=i(x),w=s(x,"P",{"data-svelte-h":!0}),p(w)!=="svelte-1v9qsc5"&&(w.innerHTML=S),B=i(x),C=s(x,"UL",{"data-svelte-h":!0}),p(C)!=="svelte-15scerc"&&(C.innerHTML=me),q=i(x),F=s(x,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1an3odd"&&(F.innerHTML=fe)},m(x,j){d(x,l,j),d(x,u,j),d(x,h,j),d(x,c,j),d(x,w,j),d(x,B,j),d(x,C,j),d(x,q,j),d(x,F,j)},p:J,d(x){x&&(t(l),t(u),t(h),t(c),t(w),t(B),t(C),t(q),t(F))}}}function Gh($){let l,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=o("p"),l.innerHTML=k},l(u){l=s(u,"P",{"data-svelte-h":!0}),p(l)!=="svelte-fincs2"&&(l.innerHTML=k)},m(u,h){d(u,l,h)},p:J,d(u){u&&t(l)}}}function Wh($){let l,k="Examples:",u,h,M;return h=new H({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURlQ1RW5jb2Rlck1vZGVsJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIydDUtc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBURlQ1RW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJ0NS1zbWFsbCUyMiklMEElMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwJTIyU3R1ZGllcyUyMGhhdmUlMjBiZWVuJTIwc2hvd24lMjB0aGF0JTIwb3duaW5nJTIwYSUyMGRvZyUyMGlzJTIwZ29vZCUyMGZvciUyMHlvdSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIlMEEpLmlucHV0X2lkcyUyMCUyMCUyMyUyMEJhdGNoJTIwc2l6ZSUyMDElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFT5EncoderModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFT5EncoderModel.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Studies have been shown that owning a dog is good for you&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>
<span class="hljs-meta">... </span>).input_ids  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids)`,wrap:!1}}),{c(){l=o("p"),l.textContent=k,u=r(),f(h.$$.fragment)},l(c){l=s(c,"P",{"data-svelte-h":!0}),p(l)!=="svelte-kvfsh7"&&(l.textContent=k),u=i(c),g(h.$$.fragment,c)},m(c,w){d(c,l,w),d(c,u,w),_(h,c,w),M=!0},p:J,i(c){M||(T(h.$$.fragment,c),M=!0)},o(c){b(h.$$.fragment,c),M=!1},d(c){c&&(t(l),t(u)),y(h,c)}}}function Bh($){let l,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=o("p"),l.innerHTML=k},l(u){l=s(u,"P",{"data-svelte-h":!0}),p(l)!=="svelte-fincs2"&&(l.innerHTML=k)},m(u,h){d(u,l,h)},p:J,d(u){u&&t(l)}}}function Hh($){let l,k="Example:",u,h,M;return h=new H({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBGbGF4VDVNb2RlbCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnQ1LXNtYWxsJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheFQ1TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnQ1LXNtYWxsJTIyKSUwQSUwQWlucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlMjJTdHVkaWVzJTIwaGF2ZSUyMGJlZW4lMjBzaG93biUyMHRoYXQlMjBvd25pbmclMjBhJTIwZG9nJTIwaXMlMjBnb29kJTIwZm9yJTIweW91JTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiUwQSkuaW5wdXRfaWRzJTBBZGVjb2Rlcl9pbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyU3R1ZGllcyUyMHNob3clMjB0aGF0JTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMikuaW5wdXRfaWRzJTBBJTBBJTIzJTIwcHJlcHJvY2VzcyUzQSUyMFByZXBlbmQlMjBkZWNvZGVyX2lucHV0X2lkcyUyMHdpdGglMjBzdGFydCUyMHRva2VuJTIwd2hpY2glMjBpcyUyMHBhZCUyMHRva2VuJTIwZm9yJTIwVDVNb2RlbC4lMEElMjMlMjBUaGlzJTIwaXMlMjBub3QlMjBuZWVkZWQlMjBmb3IlMjB0b3JjaCdzJTIwVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMjBhcyUyMGl0JTIwZG9lcyUyMHRoaXMlMjBpbnRlcm5hbGx5JTIwdXNpbmclMjBsYWJlbHMlMjBhcmcuJTBBZGVjb2Rlcl9pbnB1dF9pZHMlMjAlM0QlMjBtb2RlbC5fc2hpZnRfcmlnaHQoZGVjb2Rlcl9pbnB1dF9pZHMpJTBBJTBBJTIzJTIwZm9yd2FyZCUyMHBhc3MlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzJTNEaW5wdXRfaWRzJTJDJTIwZGVjb2Rlcl9pbnB1dF9pZHMlM0RkZWNvZGVyX2lucHV0X2lkcyklMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, FlaxT5Model

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxT5Model.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Studies have been shown that owning a dog is good for you&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>
<span class="hljs-meta">... </span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = tokenizer(<span class="hljs-string">&quot;Studies show that&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># preprocess: Prepend decoder_input_ids with start token which is pad token for T5Model.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This is not needed for torch&#x27;s T5ForConditionalGeneration as it does this internally using labels arg.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = model._shift_right(decoder_input_ids)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids=input_ids, decoder_input_ids=decoder_input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){l=o("p"),l.textContent=k,u=r(),f(h.$$.fragment)},l(c){l=s(c,"P",{"data-svelte-h":!0}),p(l)!=="svelte-11lpom8"&&(l.textContent=k),u=i(c),g(h.$$.fragment,c)},m(c,w){d(c,l,w),d(c,u,w),_(h,c,w),M=!0},p:J,i(c){M||(T(h.$$.fragment,c),M=!0)},o(c){b(h.$$.fragment,c),M=!1},d(c){c&&(t(l),t(u)),y(h,c)}}}function Rh($){let l,k="Example:",u,h,M;return h=new H({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBGbGF4VDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ0NS1zbWFsbCUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhUNUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIydDUtc21hbGwlMjIpJTBBJTBBdGV4dCUyMCUzRCUyMCUyMk15JTIwZnJpZW5kcyUyMGFyZSUyMGNvb2wlMjBidXQlMjB0aGV5JTIwZWF0JTIwdG9vJTIwbWFueSUyMGNhcmJzLiUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEFlbmNvZGVyX291dHB1dHMlMjAlM0QlMjBtb2RlbC5lbmNvZGUoKippbnB1dHMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, FlaxT5ForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxT5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My friends are cool but they eat too many carbs.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_outputs = model.encode(**inputs)`,wrap:!1}}),{c(){l=o("p"),l.textContent=k,u=r(),f(h.$$.fragment)},l(c){l=s(c,"P",{"data-svelte-h":!0}),p(l)!=="svelte-11lpom8"&&(l.textContent=k),u=i(c),g(h.$$.fragment,c)},m(c,w){d(c,l,w),d(c,u,w),_(h,c,w),M=!0},p:J,i(c){M||(T(h.$$.fragment,c),M=!0)},o(c){b(h.$$.fragment,c),M=!1},d(c){c&&(t(l),t(u)),y(h,c)}}}function Nh($){let l,k="Example:",u,h,M;return h=new H({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBGbGF4VDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEFpbXBvcnQlMjBqYXgubnVtcHklMjBhcyUyMGpucCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnQ1LXNtYWxsJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheFQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJ0NS1zbWFsbCUyMiklMEElMEF0ZXh0JTIwJTNEJTIwJTIyTXklMjBmcmllbmRzJTIwYXJlJTIwY29vbCUyMGJ1dCUyMHRoZXklMjBlYXQlMjB0b28lMjBtYW55JTIwY2FyYnMuJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQWVuY29kZXJfb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmVuY29kZSgqKmlucHV0cyklMEElMEFkZWNvZGVyX3N0YXJ0X3Rva2VuX2lkJTIwJTNEJTIwbW9kZWwuY29uZmlnLmRlY29kZXJfc3RhcnRfdG9rZW5faWQlMEFkZWNvZGVyX2lucHV0X2lkcyUyMCUzRCUyMGpucC5vbmVzKChpbnB1dHMuaW5wdXRfaWRzLnNoYXBlJTVCMCU1RCUyQyUyMDEpJTJDJTIwZHR5cGUlM0QlMjJpNCUyMiklMjAqJTIwZGVjb2Rlcl9zdGFydF90b2tlbl9pZCUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5kZWNvZGUoZGVjb2Rlcl9pbnB1dF9pZHMlMkMlMjBlbmNvZGVyX291dHB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, FlaxT5ForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax.numpy <span class="hljs-keyword">as</span> jnp

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxT5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My friends are cool but they eat too many carbs.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_outputs = model.encode(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_start_token_id = model.config.decoder_start_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = jnp.ones((inputs.input_ids.shape[<span class="hljs-number">0</span>], <span class="hljs-number">1</span>), dtype=<span class="hljs-string">&quot;i4&quot;</span>) * decoder_start_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.decode(decoder_input_ids, encoder_outputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){l=o("p"),l.textContent=k,u=r(),f(h.$$.fragment)},l(c){l=s(c,"P",{"data-svelte-h":!0}),p(l)!=="svelte-11lpom8"&&(l.textContent=k),u=i(c),g(h.$$.fragment,c)},m(c,w){d(c,l,w),d(c,u,w),_(h,c,w),M=!0},p:J,i(c){M||(T(h.$$.fragment,c),M=!0)},o(c){b(h.$$.fragment,c),M=!1},d(c){c&&(t(l),t(u)),y(h,c)}}}function Vh($){let l,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=o("p"),l.innerHTML=k},l(u){l=s(u,"P",{"data-svelte-h":!0}),p(l)!=="svelte-fincs2"&&(l.innerHTML=k)},m(u,h){d(u,l,h)},p:J,d(u){u&&t(l)}}}function Xh($){let l,k="Example:",u,h,M;return h=new H({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBGbGF4VDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ0NS1zbWFsbCUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhUNUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIydDUtc21hbGwlMjIpJTBBJTBBQVJUSUNMRV9UT19TVU1NQVJJWkUlMjAlM0QlMjAlMjJzdW1tYXJpemUlM0ElMjBNeSUyMGZyaWVuZHMlMjBhcmUlMjBjb29sJTIwYnV0JTIwdGhleSUyMGVhdCUyMHRvbyUyMG1hbnklMjBjYXJicy4lMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCQVJUSUNMRV9UT19TVU1NQVJJWkUlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQSUyMyUyMEdlbmVyYXRlJTIwU3VtbWFyeSUwQXN1bW1hcnlfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEKS5zZXF1ZW5jZXMlMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKHN1bW1hcnlfaWRzJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlJTJDJTIwY2xlYW5fdXBfdG9rZW5pemF0aW9uX3NwYWNlcyUzREZhbHNlKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, FlaxT5ForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxT5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>ARTICLE_TO_SUMMARIZE = <span class="hljs-string">&quot;summarize: My friends are cool but they eat too many carbs.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([ARTICLE_TO_SUMMARIZE], return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate Summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>]).sequences
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(summary_ids[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>))`,wrap:!1}}),{c(){l=o("p"),l.textContent=k,u=r(),f(h.$$.fragment)},l(c){l=s(c,"P",{"data-svelte-h":!0}),p(l)!=="svelte-11lpom8"&&(l.textContent=k),u=i(c),g(h.$$.fragment,c)},m(c,w){d(c,l,w),d(c,u,w),_(h,c,w),M=!0},p:J,i(c){M||(T(h.$$.fragment,c),M=!0)},o(c){b(h.$$.fragment,c),M=!1},d(c){c&&(t(l),t(u)),y(h,c)}}}function Eh($){let l,k="Example:",u,h,M;return h=new H({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBGbGF4VDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ0NS1zbWFsbCUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhUNUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIydDUtc21hbGwlMjIpJTBBJTBBdGV4dCUyMCUzRCUyMCUyMk15JTIwZnJpZW5kcyUyMGFyZSUyMGNvb2wlMjBidXQlMjB0aGV5JTIwZWF0JTIwdG9vJTIwbWFueSUyMGNhcmJzLiUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEFlbmNvZGVyX291dHB1dHMlMjAlM0QlMjBtb2RlbC5lbmNvZGUoKippbnB1dHMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, FlaxT5ForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxT5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My friends are cool but they eat too many carbs.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_outputs = model.encode(**inputs)`,wrap:!1}}),{c(){l=o("p"),l.textContent=k,u=r(),f(h.$$.fragment)},l(c){l=s(c,"P",{"data-svelte-h":!0}),p(l)!=="svelte-11lpom8"&&(l.textContent=k),u=i(c),g(h.$$.fragment,c)},m(c,w){d(c,l,w),d(c,u,w),_(h,c,w),M=!0},p:J,i(c){M||(T(h.$$.fragment,c),M=!0)},o(c){b(h.$$.fragment,c),M=!1},d(c){c&&(t(l),t(u)),y(h,c)}}}function Lh($){let l,k="Example:",u,h,M;return h=new H({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBGbGF4VDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEFpbXBvcnQlMjBqYXgubnVtcHklMjBhcyUyMGpucCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnQ1LXNtYWxsJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheFQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJ0NS1zbWFsbCUyMiklMEElMEF0ZXh0JTIwJTNEJTIwJTIyc3VtbWFyaXplJTNBJTIwTXklMjBmcmllbmRzJTIwYXJlJTIwY29vbCUyMGJ1dCUyMHRoZXklMjBlYXQlMjB0b28lMjBtYW55JTIwY2FyYnMuJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQWVuY29kZXJfb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmVuY29kZSgqKmlucHV0cyklMEElMEFkZWNvZGVyX3N0YXJ0X3Rva2VuX2lkJTIwJTNEJTIwbW9kZWwuY29uZmlnLmRlY29kZXJfc3RhcnRfdG9rZW5faWQlMEFkZWNvZGVyX2lucHV0X2lkcyUyMCUzRCUyMGpucC5vbmVzKChpbnB1dHMuaW5wdXRfaWRzLnNoYXBlJTVCMCU1RCUyQyUyMDEpJTJDJTIwZHR5cGUlM0QlMjJpNCUyMiklMjAqJTIwZGVjb2Rlcl9zdGFydF90b2tlbl9pZCUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5kZWNvZGUoZGVjb2Rlcl9pbnB1dF9pZHMlMkMlMjBlbmNvZGVyX291dHB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, FlaxT5ForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax.numpy <span class="hljs-keyword">as</span> jnp

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxT5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;summarize: My friends are cool but they eat too many carbs.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_outputs = model.encode(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_start_token_id = model.config.decoder_start_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = jnp.ones((inputs.input_ids.shape[<span class="hljs-number">0</span>], <span class="hljs-number">1</span>), dtype=<span class="hljs-string">&quot;i4&quot;</span>) * decoder_start_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.decode(decoder_input_ids, encoder_outputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){l=o("p"),l.textContent=k,u=r(),f(h.$$.fragment)},l(c){l=s(c,"P",{"data-svelte-h":!0}),p(l)!=="svelte-11lpom8"&&(l.textContent=k),u=i(c),g(h.$$.fragment,c)},m(c,w){d(c,l,w),d(c,u,w),_(h,c,w),M=!0},p:J,i(c){M||(T(h.$$.fragment,c),M=!0)},o(c){b(h.$$.fragment,c),M=!1},d(c){c&&(t(l),t(u)),y(h,c)}}}function Sh($){let l,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=o("p"),l.innerHTML=k},l(u){l=s(u,"P",{"data-svelte-h":!0}),p(l)!=="svelte-fincs2"&&(l.innerHTML=k)},m(u,h){d(u,l,h)},p:J,d(u){u&&t(l)}}}function Ah($){let l,k,u,h,M,c,w,S,B,C,me="T5",q,F,fe='<a href="https://huggingface.co/models?filter=t5"><img alt="Models" src="https://img.shields.io/badge/All_model_pages-t5-blueviolet"/></a> <a href="https://huggingface.co/spaces/docs-demos/t5-base"><img alt="Spaces" src="https://img.shields.io/badge/%F0%9F%A4%97%20Hugging%20Face-Spaces-blue"/></a> <a href="https://huggingface.co/papers/1910.10683"><img alt="Paper page" src="https://img.shields.io/badge/Paper%20page-1910.10683-green"/></a>',x,j,Xe,Ba,Ot,Md,ds,Wc="Overview",yr,Yt,Bc=`The T5 model was presented in <a href="https://arxiv.org/pdf/1910.10683.pdf" rel="nofollow">Exploring the Limits of Transfer Learning with a Unified Text-to-Text Transformer</a> by <a href="https://huggingface.co/craffel" rel="nofollow">Colin Raffel</a>, Noam Shazeer, <a href="https://huggingface.co/adarob" rel="nofollow">Adam Roberts</a>, Katherine Lee, Sharan Narang,
Michael Matena, Yanqi Zhou, Wei Li, <a href="https://huggingface.co/peterjliu" rel="nofollow">Peter J. Liu</a>.`,vr,Kt,Hc="The abstract from the paper is the following:",kr,en,Rc=`<em>Transfer learning, where a model is first pre-trained on a data-rich task before being fine-tuned on a downstream
task, has emerged as a powerful technique in natural language processing (NLP). The effectiveness of transfer learning
has given rise to a diversity of approaches, methodology, and practice. In this paper, we explore the landscape of
transfer learning techniques for NLP by introducing a unified framework that converts every language problem into a
text-to-text format. Our systematic study compares pretraining objectives, architectures, unlabeled datasets, transfer
approaches, and other factors on dozens of language understanding tasks. By combining the insights from our exploration
with scale and our new “Colossal Clean Crawled Corpus”, we achieve state-of-the-art results on many benchmarks covering
summarization, question answering, text classification, and more. To facilitate future work on transfer learning for
NLP, we release our dataset, pre-trained models, and code.</em>`,Mr,tn,Nc="Tips:",wr,nn,Vc=`<li><p>T5 is an encoder-decoder model pre-trained on a multi-task mixture of unsupervised and supervised tasks and for which
each task is converted into a text-to-text format. T5 works well on a variety of tasks out-of-the-box by prepending a
different prefix to the input corresponding to each task, e.g., for translation: <em>translate English to German: …</em>,
for summarization: <em>summarize: …</em>.</p></li> <li><p>The pretraining includes both supervised and self-supervised training. Supervised training is conducted on downstream tasks provided by the GLUE and SuperGLUE benchmarks (converting them into text-to-text tasks as explained above).</p></li> <li><p>Self-supervised training uses corrupted tokens, by randomly removing 15% of the tokens and replacing them with individual sentinel tokens (if several consecutive tokens are marked for removal, the whole group is replaced with a single sentinel token). The input of the encoder is the corrupted sentence, the input of the decoder is the original sentence and the target is then the dropped out tokens delimited by their sentinel tokens.</p></li> <li><p>T5 uses relative scalar embeddings. Encoder input padding can be done on the left and on the right.</p></li> <li><p>See the <a href="#training">training</a>, <a href="#inference">inference</a> and <a href="#scripts">scripts</a> sections below for all details regarding usage.</p></li>`,xr,on,Xc="T5 comes in different sizes:",$r,sn,Ec='<li><p><a href="https://huggingface.co/t5-small" rel="nofollow">t5-small</a></p></li> <li><p><a href="https://huggingface.co/t5-base" rel="nofollow">t5-base</a></p></li> <li><p><a href="https://huggingface.co/t5-large" rel="nofollow">t5-large</a></p></li> <li><p><a href="https://huggingface.co/t5-3b" rel="nofollow">t5-3b</a></p></li> <li><p><a href="https://huggingface.co/t5-11b" rel="nofollow">t5-11b</a>.</p></li>',jr,an,Lc="Based on the original T5 model, Google has released some follow-up works:",zr,rn,Sc=`<li><p><strong>T5v1.1</strong>: T5v1.1 is an improved version of T5 with some architectural tweaks, and is pre-trained on C4 only without
mixing in the supervised tasks. Refer to the documentation of T5v1.1 which can be found <a href="t5v1.1">here</a>.</p></li> <li><p><strong>mT5</strong>: mT5 is a multilingual T5 model. It is pre-trained on the mC4 corpus, which includes 101 languages. Refer to
the documentation of mT5 which can be found <a href="mt5">here</a>.</p></li> <li><p><strong>byT5</strong>: byT5 is a T5 model pre-trained on byte sequences rather than SentencePiece subword token sequences. Refer
to the documentation of byT5 which can be found <a href="byt5">here</a>.</p></li> <li><p><strong>UL2</strong>: UL2 is a T5 like model pretrained on various denoising objectives</p></li> <li><p><strong>Flan-T5</strong>: Flan is a pretraining methods that is based on prompting. The Flan-T5 are T5 models trained on the Flan collection of
datasets which include: <code>taskmaster2</code>, <code>djaym7/wiki_dialog</code>, <code>deepmind/code_contests</code>, <code>lambada</code>, <code>gsm8k</code>, <code>aqua_rat</code>, <code>esnli</code>, <code>quasc</code> and <code>qed</code>.</p></li> <li><p><strong>FLan-UL2</strong> : the UL2 model finetuned using the “Flan” prompt tuning and dataset collection.</p></li> <li><p><strong>UMT5</strong>: UmT5 is a multilingual T5 model trained on an improved and refreshed mC4 multilingual corpus,  29 trillion characters across 107 language, using a new sampling method, UniMax. Refer to
the documentation of mT5 which can be found <a href="umt5">here</a>.</p></li>`,Fr,dn,Ac='All checkpoints can be found on the <a href="https://huggingface.co/models?search=t5" rel="nofollow">hub</a>.',Cr,ln,Pc='This model was contributed by <a href="https://huggingface.co/thomwolf" rel="nofollow">thomwolf</a>. The original code can be found <a href="https://github.com/google-research/text-to-text-transfer-transformer" rel="nofollow">here</a>.',Jr,ls,Ur,Me,Ee,Ha,cn,wd,cs,Qc="Training",qr,pn,Dc=`T5 is an encoder-decoder model and converts all NLP problems into a text-to-text format. It is trained using teacher
forcing. This means that for training, we always need an input sequence and a corresponding target sequence. The input
sequence is fed to the model using <code>input_ids</code>. The target sequence is shifted to the right, i.e., prepended by a
start-sequence token and fed to the decoder using the <code>decoder_input_ids</code>. In teacher-forcing style, the target
sequence is then appended by the EOS token and corresponds to the <code>labels</code>. The PAD token is hereby used as the
start-sequence token. T5 can be trained / fine-tuned both in a supervised and unsupervised fashion.`,Ir,un,Oc=`One can use <a href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.T5ForConditionalGeneration">T5ForConditionalGeneration</a> (or the Tensorflow/Flax variant), which includes the
language modeling head on top of the decoder.`,Zr,hn,Yc="<li>Unsupervised denoising training</li>",Gr,mn,Kc=`In this setup, spans of the input sequence are masked by so-called sentinel tokens (<em>a.k.a</em> unique mask tokens) and
the output sequence is formed as a concatenation of the same sentinel tokens and the <em>real</em> masked tokens. Each
sentinel token represents a unique mask token for this sentence and should start with <code>&lt;extra_id_0&gt;</code>,
<code>&lt;extra_id_1&gt;</code>, … up to <code>&lt;extra_id_99&gt;</code>. As a default, 100 sentinel tokens are available in
<a href="/docs/transformers/v4.34.0/en/model_doc/mt5#transformers.T5Tokenizer">T5Tokenizer</a>.`,Wr,fn,ep=`For instance, the sentence “The cute dog walks in the park” with the masks put on “cute dog” and “the” should be
processed as follows:`,Br,gn,Hr,_n,tp=`If you’re interested in pre-training T5 on a new corpus, check out the <a href="https://github.com/huggingface/transformers/tree/main/examples/flax/language-modeling" rel="nofollow">run_t5_mlm_flax.py</a> script in the Examples
directory.`,Rr,Tn,np="<li>Supervised training</li>",Nr,bn,op=`In this setup, the input sequence and output sequence are a standard sequence-to-sequence input-output mapping.
Suppose that we want to fine-tune the model for translation for example, and we have a training example: the input
sequence “The house is wonderful.” and output sequence “Das Haus ist wunderbar.”, then they should be prepared for
the model as follows:`,Vr,yn,Xr,vn,sp=`As you can see, only 2 inputs are required for the model in order to compute a loss: <code>input_ids</code> (which are the
<code>input_ids</code> of the encoded input sequence) and <code>labels</code> (which are the <code>input_ids</code> of the encoded
target sequence). The model will automatically create the <code>decoder_input_ids</code> based on the <code>labels</code>, by
shifting them one position to the right and prepending the <code>config.decoder_start_token_id</code>, which for T5 is
equal to 0 (i.e. the id of the pad token). Also note the task prefix: we prepend the input sequence with ‘translate
English to German: ’ before encoding it. This will help in improving the performance, as this task prefix was used
during T5’s pre-training.`,Er,kn,ap=`However, the example above only shows a single training example. In practice, one trains deep learning models in
batches. This entails that we must pad/truncate examples to the same length. For encoder-decoder models, one
typically defines a <code>max_source_length</code> and <code>max_target_length</code>, which determine the maximum length of the
input and output sequences respectively (otherwise they are truncated). These should be carefully set depending on
the task.`,Lr,Mn,rp=`In addition, we must make sure that padding token id’s of the <code>labels</code> are not taken into account by the loss
function. In PyTorch and Tensorflow, this can be done by replacing them with -100, which is the <code>ignore_index</code>
of the <code>CrossEntropyLoss</code>. In Flax, one can use the <code>decoder_attention_mask</code> to ignore padded tokens from
the loss (see the <a href="https://github.com/huggingface/transformers/tree/main/examples/flax/summarization" rel="nofollow">Flax summarization script</a> for details). We also pass
<code>attention_mask</code> as additional input to the model, which makes sure that padding tokens of the inputs are
ignored. The code example below illustrates all of this.`,Sr,wn,Ar,xn,ip="Additional training tips:",Pr,$n,dp=`<li>T5 models need a slightly higher learning rate than the default one set in the <code>Trainer</code> when using the AdamW
optimizer. Typically, 1e-4 and 3e-4 work well for most problems (classification, summarization, translation, question
answering, question generation). Note that T5 was pre-trained using the AdaFactor optimizer.</li>`,Qr,jn,lp=`According to <a href="https://discuss.huggingface.co/t/t5-finetuning-tips/684" rel="nofollow">this forum post</a>, task prefixes matter when
(1) doing multi-task training (2) your task is similar or related to one of the supervised tasks used in T5’s
pre-training mixture (see Appendix D of the <a href="https://arxiv.org/pdf/1910.10683.pdf" rel="nofollow">paper</a> for the task prefixes
used).`,Dr,zn,cp=`If training on TPU, it is recommended to pad all examples of the dataset to the same length or make use of
<em>pad_to_multiple_of</em> to have a small number of predefined bucket sizes to fit all examples in. Dynamically padding
batches to the longest example is not recommended on TPU as it triggers a recompilation for every batch shape that is
encountered during training thus significantly slowing down the training. only padding up to the longest example in a
batch) leads to very slow training on TPU.`,Or,ps,Yr,we,Le,Ra,Fn,xd,us,pp="Inference",Kr,Cn,up=`At inference time, it is recommended to use <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>. This
method takes care of encoding the input and feeding the encoded hidden states via cross-attention layers to the decoder
and auto-regressively generates the decoder output. Check out <a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">this blog post</a> to know all the details about generating text with Transformers.
There’s also <a href="https://huggingface.co/blog/encoder-decoder#encoder-decoder" rel="nofollow">this blog post</a> which explains how
generation works in general in encoder-decoder models.`,ei,Jn,ti,Un,hp=`Note that T5 uses the <code>pad_token_id</code> as the <code>decoder_start_token_id</code>, so when doing generation without using
<a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>, make sure you start it with the <code>pad_token_id</code>.`,ni,qn,mp="The example above only shows a single example. You can also do batched inference, like so:",oi,In,si,Zn,fp=`Because T5 has been trained with the span-mask denoising objective,
it can be used to predict the sentinel (masked-out) tokens during inference.
The predicted tokens will then be placed between the sentinel tokens.`,ai,Gn,ri,hs,ii,xe,Se,Na,Wn,$d,ms,gp="Performance",di,Bn,_p='If you’d like a faster training and inference performance, install <a href="https://github.com/NVIDIA/apex#quick-start" rel="nofollow">apex</a> and then the model will automatically use <code>apex.normalization.FusedRMSNorm</code> instead of <code>T5LayerNorm</code>. The former uses an optimized fused kernel which is several times faster than the latter.',li,$e,Ae,Va,Hn,jd,fs,Tp="Resources",ci,Rn,bp="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with T5. If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",pi,Nn,ui,Vn,yp='<li>A notebook for how to <a href="https://colab.research.google.com/github/patil-suraj/exploring-T5/blob/master/t5_fine_tuning.ipynb" rel="nofollow">finetune T5 for classification and multiple choice</a>.</li> <li>A notebook for how to <a href="https://colab.research.google.com/github/enzoampil/t5-intro/blob/master/t5_qa_training_pytorch_span_extraction.ipynb" rel="nofollow">finetune T5 for sentiment span extraction</a>. 🌎</li>',hi,Xn,mi,En,vp='<li>A notebook for how to <a href="https://colab.research.google.com/drive/1obr78FY_cBmWY5ODViCmzdY6O1KB65Vc?usp=sharing" rel="nofollow">finetune T5 for named entity recognition</a>. 🌎</li>',fi,Ln,gi,Sn,kp='<li>A notebook for <a href="https://colab.research.google.com/github/NielsRogge/Transformers-Tutorials/blob/master/T5/Fine_tune_CodeT5_for_generating_docstrings_from_Ruby_code.ipynb" rel="nofollow">Finetuning CodeT5 for generating docstrings from Ruby code</a>.</li>',_i,An,Ti,Pn,Mp='<li>A notebook to <a href="https://colab.research.google.com/github/NielsRogge/Transformers-Tutorials/blob/master/T5/Fine_tuning_Dutch_T5_base_on_CNN_Daily_Mail_for_summarization_(on_TPU_using_HuggingFace_Accelerate).ipynb" rel="nofollow">Finetune T5-base-dutch to perform Dutch abstractive summarization on a TPU</a>.</li> <li>A notebook for how to <a href="https://colab.research.google.com/github/abhimishra91/transformers-tutorials/blob/master/transformers_summarization_wandb.ipynb#scrollTo=OKRpFvYhBauC" rel="nofollow">finetune T5 for summarization in PyTorch and track experiments with WandB</a>. 🌎</li> <li>A blog post on <a href="https://huggingface.co/blog/sagemaker-distributed-training-seq2seq" rel="nofollow">Distributed Training: Train BART/T5 for Summarization using 🤗 Transformers and Amazon SageMaker</a>.</li> <li><a href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.T5ForConditionalGeneration">T5ForConditionalGeneration</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/summarization" rel="nofollow">example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/summarization.ipynb" rel="nofollow">notebook</a>.</li> <li><a href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.TFT5ForConditionalGeneration">TFT5ForConditionalGeneration</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/tensorflow/summarization" rel="nofollow">example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/summarization-tf.ipynb" rel="nofollow">notebook</a>.</li> <li><a href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.FlaxT5ForConditionalGeneration">FlaxT5ForConditionalGeneration</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/flax/summarization" rel="nofollow">example script</a>.</li> <li><a href="https://huggingface.co/course/chapter7/5?fw=pt#summarization" rel="nofollow">Summarization</a> chapter of the 🤗 Hugging Face course.</li> <li><a href="../tasks/summarization">Summarization task guide</a></li>',bi,Qn,yi,Dn,wp='<li><a href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.FlaxT5ForConditionalGeneration">FlaxT5ForConditionalGeneration</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/flax/language-modeling#t5-like-span-masked-language-modeling" rel="nofollow">example script</a> for training T5 with a span-masked language model objective. The script also shows how to train a T5 tokenizer. <a href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.FlaxT5ForConditionalGeneration">FlaxT5ForConditionalGeneration</a> is also supported by this <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/masked_language_modeling_flax.ipynb" rel="nofollow">notebook</a>.</li>',vi,On,ki,Yn,xp='<li><a href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.T5ForConditionalGeneration">T5ForConditionalGeneration</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/translation" rel="nofollow">example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/translation.ipynb" rel="nofollow">notebook</a>.</li> <li><a href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.TFT5ForConditionalGeneration">TFT5ForConditionalGeneration</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/tensorflow/translation" rel="nofollow">example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/translation-tf.ipynb" rel="nofollow">notebook</a>.</li> <li><a href="../tasks/translation">Translation task guide</a></li>',Mi,Kn,wi,eo,$p='<li>A notebook on how to <a href="https://colab.research.google.com/github/snapthat/TF-T5-text-to-text/blob/master/snapthatT5/notebooks/TF-T5-Datasets%20Training.ipynb" rel="nofollow">finetune T5 for question answering with TensorFlow 2</a>. 🌎</li> <li>A notebook on how to <a href="https://colab.research.google.com/github/patil-suraj/exploring-T5/blob/master/T5_on_TPU.ipynb#scrollTo=QLGiFCDqvuil" rel="nofollow">finetune T5 for question answering on a TPU</a>.</li>',xi,to,jp="🚀 <strong>Deploy</strong>",$i,no,zp='<li>A blog post on how to deploy <a href="https://www.philschmid.de/deploy-t5-11b" rel="nofollow">T5 11B for inference for less than $500</a>.</li>',ji,je,Pe,Xa,oo,zd,gs,Fp="T5Config",zi,ge,so,Fd,_s,Cp=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.T5Model">T5Model</a> or a <a href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.TFT5Model">TFT5Model</a>. It is used to
instantiate a T5 model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the T5
<a href="https://huggingface.co/t5-small" rel="nofollow">t5-small</a> architecture.`,Cd,Ts,Jp=`Configuration objects inherit from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Fi,ze,Qe,Ea,ao,Jd,bs,Up="T5Tokenizer",Ci,I,ro,Ud,ys,qp='Construct a T5 tokenizer. Based on <a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a>.',qd,vs,Ip=`This tokenizer inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`,Id,_e,io,Zd,ks,Zp=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. A sequence has the following format:`,Gd,Ms,Gp="<li>single sequence: <code>X &lt;/s&gt;</code></li> <li>pair of sequences: <code>A &lt;/s&gt; B &lt;/s&gt;</code></li>",Wd,De,lo,Bd,ws,Wp=`Retrieve sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> method.`,Hd,Oe,co,Rd,xs,Bp=`Create a mask from the two sequences passed to be used in a sequence-pair classification task. T5 does not make
use of token type ids, therefore a list of zeros is returned.`,Nd,$s,po,Ji,Fe,Ye,La,uo,Vd,js,Hp="T5TokenizerFast",Ui,A,ho,Xd,zs,Rp=`Construct a “fast” T5 tokenizer (backed by HuggingFace’s <em>tokenizers</em> library). Based on
<a href="https://huggingface.co/docs/tokenizers/python/latest/components.html?highlight=unigram#models" rel="nofollow">Unigram</a>.`,Ed,Fs,Np=`This tokenizer inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,Ld,Te,mo,Sd,Cs,Vp=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. A sequence has the following format:`,Ad,Js,Xp="<li>single sequence: <code>X &lt;/s&gt;</code></li> <li>pair of sequences: <code>A &lt;/s&gt; B &lt;/s&gt;</code></li>",Pd,Ke,fo,Qd,Us,Ep=`Create a mask from the two sequences passed to be used in a sequence-pair classification task. T5 does not make
use of token type ids, therefore a list of zeros is returned.`,qi,Ce,et,Sa,go,Dd,qs,Lp="T5Model",Ii,R,_o,Od,Is,Sp="The bare T5 Model transformer outputting raw hidden-states without any specific head on top.",Yd,Zs,Ap=`The T5 model was proposed in <a href="https://arxiv.org/abs/1910.10683" rel="nofollow">Exploring the Limits of Transfer Learning with a Unified Text-to-Text
Transformer</a> by Colin Raffel, Noam Shazeer, Adam Roberts, Katherine Lee, Sharan
Narang, Michael Matena, Yanqi Zhou, Wei Li, Peter J. Liu. It’s an encoder decoder transformer pre-trained in a
text-to-text denoising generative setting.`,Kd,Gs,Pp=`This model inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,el,Ws,Qp=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,tl,ee,To,nl,Bs,Dp='The <a href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.T5Model">T5Model</a> forward method, overrides the <code>__call__</code> special method.',ol,tt,sl,nt,Zi,Je,ot,Aa,bo,al,Hs,Op="T5ForConditionalGeneration",Gi,N,yo,rl,Rs,Yp="T5 Model with a <code>language modeling</code> head on top.",il,Ns,Kp=`The T5 model was proposed in <a href="https://arxiv.org/abs/1910.10683" rel="nofollow">Exploring the Limits of Transfer Learning with a Unified Text-to-Text
Transformer</a> by Colin Raffel, Noam Shazeer, Adam Roberts, Katherine Lee, Sharan
Narang, Michael Matena, Yanqi Zhou, Wei Li, Peter J. Liu. It’s an encoder decoder transformer pre-trained in a
text-to-text denoising generative setting.`,dl,Vs,eu=`This model inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ll,Xs,tu=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,cl,te,vo,pl,Es,nu='The <a href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.T5ForConditionalGeneration">T5ForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',ul,st,hl,at,Wi,Ue,rt,Pa,ko,ml,Ls,ou="T5EncoderModel",Bi,V,Mo,fl,Ss,su="The bare T5 Model transformer outputting encoder’s raw hidden-states without any specific head on top.",gl,As,au=`The T5 model was proposed in <a href="https://arxiv.org/abs/1910.10683" rel="nofollow">Exploring the Limits of Transfer Learning with a Unified Text-to-Text
Transformer</a> by Colin Raffel, Noam Shazeer, Adam Roberts, Katherine Lee, Sharan
Narang, Michael Matena, Yanqi Zhou, Wei Li, Peter J. Liu. It’s an encoder decoder transformer pre-trained in a
text-to-text denoising generative setting.`,_l,Ps,ru=`This model inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Tl,Qs,iu=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,bl,ne,wo,yl,Ds,du='The <a href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.T5EncoderModel">T5EncoderModel</a> forward method, overrides the <code>__call__</code> special method.',vl,it,kl,dt,Hi,qe,lt,Qa,xo,Ml,Os,lu="T5ForSequenceClassification",Ri,X,$o,wl,Ys,cu=`T5 model with a sequence classification/head on top (a linear layer on top of the pooled output) e.g. for GLUE
tasks.`,xl,Ks,pu=`The T5 model was proposed in <a href="https://arxiv.org/abs/1910.10683" rel="nofollow">Exploring the Limits of Transfer Learning with a Unified Text-to-Text
Transformer</a> by Colin Raffel, Noam Shazeer, Adam Roberts, Katherine Lee, Sharan
Narang, Michael Matena, Yanqi Zhou, Wei Li, Peter J. Liu. It’s an encoder decoder transformer pre-trained in a
text-to-text denoising generative setting.`,$l,ea,uu=`This model inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,jl,ta,hu=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,zl,be,jo,Fl,na,mu='The <a href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.T5ForSequenceClassification">T5ForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Cl,ct,Ni,Ie,pt,Da,zo,Jl,oa,fu="T5ForQuestionAnswering",Vi,E,Fo,Ul,sa,gu=`T5 Model with a span classification head on top for extractive question-answering tasks like SQuAD (linear layers
on top of the hidden-states output to compute <code>span start logits</code> and <code>span end logits</code>).`,ql,aa,_u=`The T5 model was proposed in <a href="https://arxiv.org/abs/1910.10683" rel="nofollow">Exploring the Limits of Transfer Learning with a Unified Text-to-Text
Transformer</a> by Colin Raffel, Noam Shazeer, Adam Roberts, Katherine Lee, Sharan
Narang, Michael Matena, Yanqi Zhou, Wei Li, Peter J. Liu. It’s an encoder decoder transformer pre-trained in a
text-to-text denoising generative setting.`,Il,ra,Tu=`This model inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Zl,ia,bu=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Gl,ye,Co,Wl,da,yu='The <a href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.T5ForQuestionAnswering">T5ForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',Bl,ut,Xi,Ze,ht,Oa,Jo,Hl,la,vu="TFT5Model",Ei,Z,Uo,Rl,ca,ku="The bare T5 Model transformer outputting raw hidden-stateswithout any specific head on top.",Nl,pa,Mu=`The T5 model was proposed in <a href="https://arxiv.org/abs/1910.10683" rel="nofollow">Exploring the Limits of Transfer Learning with a Unified Text-to-Text
Transformer</a> by Colin Raffel, Noam Shazeer, Adam Roberts, Katherine Lee, Sharan
Narang, Michael Matena, Yanqi Zhou, Wei Li, Peter J. Liu. It’s an encoder decoder transformer pre-trained in a
text-to-text denoising generative setting.`,Vl,ua,wu=`This model inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Xl,ha,xu=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">tf.keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,El,mt,Ll,oe,qo,Sl,ma,$u='The <a href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.TFT5Model">TFT5Model</a> forward method, overrides the <code>__call__</code> special method.',Al,ft,Pl,gt,Li,Ge,_t,Ya,Io,Ql,fa,ju="TFT5ForConditionalGeneration",Si,G,Zo,Dl,ga,zu="T5 Model with a <code>language modeling</code> head on top.",Ol,_a,Fu=`The T5 model was proposed in <a href="https://arxiv.org/abs/1910.10683" rel="nofollow">Exploring the Limits of Transfer Learning with a Unified Text-to-Text
Transformer</a> by Colin Raffel, Noam Shazeer, Adam Roberts, Katherine Lee, Sharan
Narang, Michael Matena, Yanqi Zhou, Wei Li, Peter J. Liu. It’s an encoder decoder transformer pre-trained in a
text-to-text denoising generative setting.`,Yl,Ta,Cu=`This model inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Kl,ba,Ju=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">tf.keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,ec,Tt,tc,se,Go,nc,ya,Uu='The <a href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.TFT5ForConditionalGeneration">TFT5ForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',oc,bt,sc,yt,Ai,We,vt,Ka,Wo,ac,va,qu="TFT5EncoderModel",Pi,W,Bo,rc,ka,Iu="The bare T5 Model transformer outputting encoder’s raw hidden-stateswithout any specific head on top.",ic,Ma,Zu=`The T5 model was proposed in <a href="https://arxiv.org/abs/1910.10683" rel="nofollow">Exploring the Limits of Transfer Learning with a Unified Text-to-Text
Transformer</a> by Colin Raffel, Noam Shazeer, Adam Roberts, Katherine Lee, Sharan
Narang, Michael Matena, Yanqi Zhou, Wei Li, Peter J. Liu. It’s an encoder decoder transformer pre-trained in a
text-to-text denoising generative setting.`,dc,wa,Gu=`This model inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,lc,xa,Wu=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">tf.keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,cc,kt,pc,ae,Ho,uc,$a,Bu='The <a href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.TFT5EncoderModel">TFT5EncoderModel</a> forward method, overrides the <code>__call__</code> special method.',hc,Mt,mc,wt,Qi,Be,xt,er,Ro,fc,ja,Hu="FlaxT5Model",Di,Y,No,gc,re,Vo,_c,za,Ru="The <code>FlaxT5PreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",Tc,$t,bc,jt,yc,zt,Xo,vc,Ft,kc,Ct,Eo,Mc,Jt,Oi,He,Ut,tr,Lo,wc,Fa,Nu="FlaxT5ForConditionalGeneration",Yi,K,So,xc,ie,Ao,$c,Ca,Vu="The <code>FlaxT5PreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",jc,qt,zc,It,Fc,Zt,Po,Cc,Gt,Jc,Wt,Qo,Uc,Bt,Ki,Re,Ht,nr,Do,qc,Ja,Xu="FlaxT5EncoderModel",ed,Ne,Oo,Ic,ve,Yo,Zc,Ua,Eu='The <a href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.FlaxT5EncoderModel">FlaxT5EncoderModel</a> forward method, overrides the <code>__call__</code> special method.',Gc,Rt,td,or,nd;return S=new U({}),Ot=new U({}),cn=new U({}),gn=new H({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1VG9rZW5pemVyJTJDJTIwVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBUNVRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIydDUtc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBUNUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIydDUtc21hbGwlMjIpJTBBJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMCUzQ2V4dHJhX2lkXzAlM0UlMjB3YWxrcyUyMGluJTIwJTNDZXh0cmFfaWRfMSUzRSUyMHBhcmslMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5pbnB1dF9pZHMlMEFsYWJlbHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyJTNDZXh0cmFfaWRfMCUzRSUyMGN1dGUlMjBkb2clMjAlM0NleHRyYV9pZF8xJTNFJTIwdGhlJTIwJTNDZXh0cmFfaWRfMiUzRSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLmlucHV0X2lkcyUwQSUwQSUyMyUyMHRoZSUyMGZvcndhcmQlMjBmdW5jdGlvbiUyMGF1dG9tYXRpY2FsbHklMjBjcmVhdGVzJTIwdGhlJTIwY29ycmVjdCUyMGRlY29kZXJfaW5wdXRfaWRzJTBBbG9zcyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUzRGlucHV0X2lkcyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcyUwQWxvc3MuaXRlbSgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5Tokenizer, T5ForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = T5Tokenizer.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = T5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(<span class="hljs-string">&quot;The &lt;extra_id_0&gt; walks in &lt;extra_id_1&gt; park&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(<span class="hljs-string">&quot;&lt;extra_id_0&gt; cute dog &lt;extra_id_1&gt; the &lt;extra_id_2&gt;&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the forward function automatically creates the correct decoder_input_ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(input_ids=input_ids, labels=labels).loss
<span class="hljs-meta">&gt;&gt;&gt; </span>loss.item()
<span class="hljs-number">3.7837</span>`,wrap:!1}}),yn=new H({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1VG9rZW5pemVyJTJDJTIwVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBUNVRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIydDUtc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBUNUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIydDUtc21hbGwlMjIpJTBBJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMnRyYW5zbGF0ZSUyMEVuZ2xpc2glMjB0byUyMEdlcm1hbiUzQSUyMFRoZSUyMGhvdXNlJTIwaXMlMjB3b25kZXJmdWwuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikuaW5wdXRfaWRzJTBBbGFiZWxzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkRhcyUyMEhhdXMlMjBpc3QlMjB3dW5kZXJiYXIuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikuaW5wdXRfaWRzJTBBJTBBJTIzJTIwdGhlJTIwZm9yd2FyZCUyMGZ1bmN0aW9uJTIwYXV0b21hdGljYWxseSUyMGNyZWF0ZXMlMjB0aGUlMjBjb3JyZWN0JTIwZGVjb2Rlcl9pbnB1dF9pZHMlMEFsb3NzJTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzJTNEaW5wdXRfaWRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKS5sb3NzJTBBbG9zcy5pdGVtKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5Tokenizer, T5ForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = T5Tokenizer.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = T5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(<span class="hljs-string">&quot;translate English to German: The house is wonderful.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(<span class="hljs-string">&quot;Das Haus ist wunderbar.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the forward function automatically creates the correct decoder_input_ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(input_ids=input_ids, labels=labels).loss
<span class="hljs-meta">&gt;&gt;&gt; </span>loss.item()
<span class="hljs-number">0.2542</span>`,wrap:!1}}),wn=new H({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5Tokenizer, T5ForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = T5Tokenizer.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = T5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the following 2 hyperparameters are task-specific</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>max_source_length = <span class="hljs-number">512</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>max_target_length = <span class="hljs-number">128</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Suppose we have the following 2 training examples:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_sequence_1 = <span class="hljs-string">&quot;Welcome to NYC&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output_sequence_1 = <span class="hljs-string">&quot;Bienvenue à NYC&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>input_sequence_2 = <span class="hljs-string">&quot;HuggingFace is a company&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output_sequence_2 = <span class="hljs-string">&quot;HuggingFace est une entreprise&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># encode the inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>task_prefix = <span class="hljs-string">&quot;translate English to French: &quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_sequences = [input_sequence_1, input_sequence_2]

<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer(
<span class="hljs-meta">... </span>    [task_prefix + sequence <span class="hljs-keyword">for</span> sequence <span class="hljs-keyword">in</span> input_sequences],
<span class="hljs-meta">... </span>    padding=<span class="hljs-string">&quot;longest&quot;</span>,
<span class="hljs-meta">... </span>    max_length=max_source_length,
<span class="hljs-meta">... </span>    truncation=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids, attention_mask = encoding.input_ids, encoding.attention_mask

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># encode the targets</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_encoding = tokenizer(
<span class="hljs-meta">... </span>    [output_sequence_1, output_sequence_2],
<span class="hljs-meta">... </span>    padding=<span class="hljs-string">&quot;longest&quot;</span>,
<span class="hljs-meta">... </span>    max_length=max_target_length,
<span class="hljs-meta">... </span>    truncation=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = target_encoding.input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># replace padding token id&#x27;s of the labels by -100 so it&#x27;s ignored by the loss</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>labels[labels == tokenizer.pad_token_id] = -<span class="hljs-number">100</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(input_ids=input_ids, attention_mask=attention_mask, labels=labels).loss
<span class="hljs-meta">&gt;&gt;&gt; </span>loss.item()
<span class="hljs-number">0.188</span>`,wrap:!1}}),Fn=new U({}),Jn=new H({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1VG9rZW5pemVyJTJDJTIwVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBUNVRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIydDUtc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBUNUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIydDUtc21hbGwlMjIpJTBBJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMnRyYW5zbGF0ZSUyMEVuZ2xpc2glMjB0byUyMEdlcm1hbiUzQSUyMFRoZSUyMGhvdXNlJTIwaXMlMjB3b25kZXJmdWwuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikuaW5wdXRfaWRzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0X2lkcyklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dHMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5Tokenizer, T5ForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = T5Tokenizer.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = T5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(<span class="hljs-string">&quot;translate English to German: The house is wonderful.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Das Haus ist wunderbar.`,wrap:!1}}),In=new H({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1VG9rZW5pemVyJTJDJTIwVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBUNVRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIydDUtc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBUNUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIydDUtc21hbGwlMjIpJTBBJTBBdGFza19wcmVmaXglMjAlM0QlMjAlMjJ0cmFuc2xhdGUlMjBFbmdsaXNoJTIwdG8lMjBHZXJtYW4lM0ElMjAlMjIlMEElMjMlMjB1c2UlMjBkaWZmZXJlbnQlMjBsZW5ndGglMjBzZW50ZW5jZXMlMjB0byUyMHRlc3QlMjBiYXRjaGluZyUwQXNlbnRlbmNlcyUyMCUzRCUyMCU1QiUyMlRoZSUyMGhvdXNlJTIwaXMlMjB3b25kZXJmdWwuJTIyJTJDJTIwJTIySSUyMGxpa2UlMjB0byUyMHdvcmslMjBpbiUyME5ZQy4lMjIlNUQlMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCdGFza19wcmVmaXglMjAlMkIlMjBzZW50ZW5jZSUyMGZvciUyMHNlbnRlbmNlJTIwaW4lMjBzZW50ZW5jZXMlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUpJTBBJTBBb3V0cHV0X3NlcXVlbmNlcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCUwQSUyMCUyMCUyMCUyMGlucHV0X2lkcyUzRGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGF0dGVudGlvbl9tYXNrJTNEaW5wdXRzJTVCJTIyYXR0ZW50aW9uX21hc2slMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUyMCUyMCUyMyUyMGRpc2FibGUlMjBzYW1wbGluZyUyMHRvJTIwdGVzdCUyMGlmJTIwYmF0Y2hpbmclMjBhZmZlY3RzJTIwb3V0cHV0JTBBKSUwQSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0X3NlcXVlbmNlcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5Tokenizer, T5ForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = T5Tokenizer.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = T5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>task_prefix = <span class="hljs-string">&quot;translate English to German: &quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># use different length sentences to test batching</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sentences = [<span class="hljs-string">&quot;The house is wonderful.&quot;</span>, <span class="hljs-string">&quot;I like to work in NYC.&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([task_prefix + sentence <span class="hljs-keyword">for</span> sentence <span class="hljs-keyword">in</span> sentences], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output_sequences = model.generate(
<span class="hljs-meta">... </span>    input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>],
<span class="hljs-meta">... </span>    attention_mask=inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>],
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">False</span>,  <span class="hljs-comment"># disable sampling to test if batching affects output</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_sequences, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Das Haus ist wunderbar.&#x27;</span>, <span class="hljs-string">&#x27;Ich arbeite gerne in NYC.&#x27;</span>]`,wrap:!1}}),Gn=new H({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1VG9rZW5pemVyJTJDJTIwVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBUNVRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIydDUtc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBUNUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIydDUtc21hbGwlMjIpJTBBJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMCUzQ2V4dHJhX2lkXzAlM0UlMjB3YWxrcyUyMGluJTIwJTNDZXh0cmFfaWRfMSUzRSUyMHBhcmslMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5pbnB1dF9pZHMlMEElMEFzZXF1ZW5jZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dF9pZHMpJTBBc2VxdWVuY2VzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShzZXF1ZW5jZV9pZHMpJTBBc2VxdWVuY2Vz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5Tokenizer, T5ForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = T5Tokenizer.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = T5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(<span class="hljs-string">&quot;The &lt;extra_id_0&gt; walks in &lt;extra_id_1&gt; park&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_ids = model.generate(input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>sequences = tokenizer.batch_decode(sequence_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>sequences
[<span class="hljs-string">&#x27;&lt;pad&gt;&lt;extra_id_0&gt; park offers&lt;extra_id_1&gt; the&lt;extra_id_2&gt; park.&lt;/s&gt;&#x27;</span>]`,wrap:!1}}),Wn=new U({}),Hn=new U({}),Nn=new is({props:{pipeline:"text-classification"}}),Xn=new is({props:{pipeline:"token-classification"}}),Ln=new is({props:{pipeline:"text-generation"}}),An=new is({props:{pipeline:"summarization"}}),Qn=new is({props:{pipeline:"fill-mask"}}),On=new is({props:{pipeline:"translation"}}),Kn=new is({props:{pipeline:"question-answering"}}),oo=new U({}),so=new z({props:{name:"class transformers.T5Config",anchor:"transformers.T5Config",parameters:[{name:"vocab_size",val:" = 32128"},{name:"d_model",val:" = 512"},{name:"d_kv",val:" = 64"},{name:"d_ff",val:" = 2048"},{name:"num_layers",val:" = 6"},{name:"num_decoder_layers",val:" = None"},{name:"num_heads",val:" = 8"},{name:"relative_attention_num_buckets",val:" = 32"},{name:"relative_attention_max_distance",val:" = 128"},{name:"dropout_rate",val:" = 0.1"},{name:"layer_norm_epsilon",val:" = 1e-06"},{name:"initializer_factor",val:" = 1.0"},{name:"feed_forward_proj",val:" = 'relu'"},{name:"is_encoder_decoder",val:" = True"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = 0"},{name:"eos_token_id",val:" = 1"},{name:"classifier_dropout",val:" = 0.0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.T5Config.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32128) &#x2014;
Vocabulary size of the T5 model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.T5Model">T5Model</a> or <a href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.TFT5Model">TFT5Model</a>.`,name:"vocab_size"},{anchor:"transformers.T5Config.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Size of the encoder layers and the pooler layer.`,name:"d_model"},{anchor:"transformers.T5Config.d_kv",description:`<strong>d_kv</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Size of the key, query, value projections per attention head. The <code>inner_dim</code> of the projection layer will
be defined as <code>num_heads * d_kv</code>.`,name:"d_kv"},{anchor:"transformers.T5Config.d_ff",description:`<strong>d_ff</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Size of the intermediate feed forward layer in each <code>T5Block</code>.`,name:"d_ff"},{anchor:"transformers.T5Config.num_layers",description:`<strong>num_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_layers"},{anchor:"transformers.T5Config.num_decoder_layers",description:`<strong>num_decoder_layers</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of hidden layers in the Transformer decoder. Will use the same value as <code>num_layers</code> if not set.`,name:"num_decoder_layers"},{anchor:"transformers.T5Config.num_heads",description:`<strong>num_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_heads"},{anchor:"transformers.T5Config.relative_attention_num_buckets",description:`<strong>relative_attention_num_buckets</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The number of buckets to use for each attention layer.`,name:"relative_attention_num_buckets"},{anchor:"transformers.T5Config.relative_attention_max_distance",description:`<strong>relative_attention_max_distance</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The maximum distance of the longer sequences for the bucket separation.`,name:"relative_attention_max_distance"},{anchor:"transformers.T5Config.dropout_rate",description:`<strong>dropout_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The ratio for all dropout layers.`,name:"dropout_rate"},{anchor:"transformers.T5Config.classifier_dropout",description:`<strong>classifier_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for classifier.`,name:"classifier_dropout"},{anchor:"transformers.T5Config.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-6) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.T5Config.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
A factor for initializing all weight matrices (should be kept to 1, used internally for initialization
testing).`,name:"initializer_factor"},{anchor:"transformers.T5Config.feed_forward_proj",description:`<strong>feed_forward_proj</strong> (<code>string</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
Type of feed forward layer to be used. Should be one of <code>&quot;relu&quot;</code> or <code>&quot;gated-gelu&quot;</code>. T5v1.1 uses the
<code>&quot;gated-gelu&quot;</code> feed forward projection. Original T5 uses <code>&quot;relu&quot;</code>.`,name:"feed_forward_proj"},{anchor:"transformers.T5Config.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models).`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/configuration_t5.py#L34"}}),ao=new U({}),ro=new z({props:{name:"class transformers.T5Tokenizer",anchor:"transformers.T5Tokenizer",parameters:[{name:"vocab_file",val:""},{name:"eos_token",val:" = '</s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"pad_token",val:" = '<pad>'"},{name:"extra_ids",val:" = 100"},{name:"additional_special_tokens",val:" = None"},{name:"sp_model_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"legacy",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.T5Tokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
<a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a> file (generally has a <em>.spm</em> extension) that
contains the vocabulary necessary to instantiate a tokenizer.`,name:"vocab_file"},{anchor:"transformers.T5Tokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.T5Tokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.T5Tokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.T5Tokenizer.extra_ids",description:`<strong>extra_ids</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
Add a number of extra ids added to the vocabulary for use as sentinels. These tokens are
accessible as &#x201C;<extra<em>id{%d}&gt;&#x201D; where &#x201D;{%d}&#x201D; is a number between 0 and extra_ids-1. These tokens can be
retrieved by calling get_sentinel_tokens method and token ids can be by calling get_sentinel_token_ids
method
additional_special_tokens (<code>List[str]</code>, <em>optional</em>):
Additional special tokens used by the tokenizer.</extra<em>`,name:"extra_ids"},{anchor:"transformers.T5Tokenizer.sp_model_kwargs",description:`<strong>sp_model_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Will be passed to the <code>SentencePieceProcessor.__init__()</code> method. The <a href="https://github.com/google/sentencepiece/tree/master/python" rel="nofollow">Python wrapper for
SentencePiece</a> can be used, among other things,
to set:</p>
<ul>
<li>
<p><code>enable_sampling</code>: Enable subword regularization.</p>
</li>
<li>
<p><code>nbest_size</code>: Sampling parameters for unigram. Invalid for BPE-Dropout.</p>
<ul>
<li><code>nbest_size = {0,1}</code>: No sampling is performed.</li>
<li><code>nbest_size &gt; 1</code>: samples from the nbest_size results.</li>
<li><code>nbest_size &lt; 0</code>: assuming that nbest_size is infinite and samples from the all hypothesis (lattice)
using forward-filtering-and-backward-sampling algorithm.</li>
</ul>
</li>
<li>
<p><code>alpha</code>: Smoothing parameter for unigram sampling, and dropout probability of merge operations for
BPE-dropout.</p>
</li>
</ul>`,name:"sp_model_kwargs"},{anchor:"transformers.T5Tokenizer.legacy",description:`<strong>legacy</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the <code>legacy</code> behaviour of the tokenizer should be used. Legacy is before the merge of #24622
and #25224 which includes fixes to properly handle tokens that appear after special tokens. A simple
example:</p>
<ul>
<li><code>legacy=True</code>:</li>
</ul>`,name:"legacy"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/tokenization_t5.py#L63"}}),io=new z({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.T5Tokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.T5Tokenizer.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.T5Tokenizer.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/tokenization_t5.py#L331",returnDescription:`
<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),lo=new z({props:{name:"get_special_tokens_mask",anchor:"transformers.T5Tokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.T5Tokenizer.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.T5Tokenizer.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"},{anchor:"transformers.T5Tokenizer.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/tokenization_t5.py#L262",returnDescription:`
<p>A list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),co=new z({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.T5Tokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.T5Tokenizer.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.T5Tokenizer.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/tokenization_t5.py#L309",returnDescription:`
<p>List of zeros.</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),po=new z({props:{name:"save_vocabulary",anchor:"transformers.T5Tokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/tokenization_t5.py#L440"}}),uo=new U({}),ho=new z({props:{name:"class transformers.T5TokenizerFast",anchor:"transformers.T5TokenizerFast",parameters:[{name:"vocab_file",val:" = None"},{name:"tokenizer_file",val:" = None"},{name:"eos_token",val:" = '</s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"pad_token",val:" = '<pad>'"},{name:"extra_ids",val:" = 100"},{name:"additional_special_tokens",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.T5TokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
<a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a> file (generally has a <em>.spm</em> extension) that
contains the vocabulary necessary to instantiate a tokenizer.`,name:"vocab_file"},{anchor:"transformers.T5TokenizerFast.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.T5TokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.T5TokenizerFast.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.T5TokenizerFast.extra_ids",description:`<strong>extra_ids</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
Add a number of extra ids added to the vocabulary for use as sentinels. These tokens are accessible as
&#x201C;<extra<em>id{%d}&gt;&#x201D; where &#x201D;{%d}&#x201D; is a number between 0 and extra_ids-1. These tokens can be retrieved by
calling get_sentinel_tokens method and token ids can be by calling get_sentinel_token_ids method</extra<em>`,name:"extra_ids"},{anchor:"transformers.T5TokenizerFast.additional_special_tokens",description:`<strong>additional_special_tokens</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Additional special tokens used by the tokenizer.`,name:"additional_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/tokenization_t5_fast.py#L66"}}),mo=new z({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.T5TokenizerFast.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.T5TokenizerFast.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.T5TokenizerFast.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/tokenization_t5_fast.py#L193",returnDescription:`
<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),fo=new z({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.T5TokenizerFast.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.T5TokenizerFast.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.T5TokenizerFast.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/tokenization_t5_fast.py#L219",returnDescription:`
<p>List of zeros.</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),go=new U({}),_o=new z({props:{name:"class transformers.T5Model",anchor:"transformers.T5Model",parameters:[{name:"config",val:": T5Config"}],parametersDescription:[{anchor:"transformers.T5Model.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.T5Config">T5Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/modeling_t5.py#L1357"}}),To=new z({props:{name:"forward",anchor:"transformers.T5Model.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"cross_attn_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.T5Model.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. T5 is a model with relative position embeddings so you
should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./t5#training">T5 Training</a>.`,name:"input_ids"},{anchor:"transformers.T5Model.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.T5Model.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>T5 uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If <code>past_key_values</code>
is used, optionally only the last <code>decoder_input_ids</code> have to be input (see <code>past_key_values</code>).</p>
<p>To know more on how to prepare <code>decoder_input_ids</code> for pretraining take a look at <a href="./t5#training">T5
Training</a>.`,name:"decoder_input_ids"},{anchor:"transformers.T5Model.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.T5Model.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.T5Model.forward.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.T5Model.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder. Mask values selected in
<code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.T5Model.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.T5Model.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.T5Model.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.T5Model.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.T5Model.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.T5Model.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.T5Model.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.T5Model.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/modeling_t5.py#L1441",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.Seq2SeqModelOutput"
>transformers.modeling_outputs.Seq2SeqModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.T5Config"
>T5Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.Seq2SeqModelOutput"
>transformers.modeling_outputs.Seq2SeqModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),tt=new O({props:{$$slots:{default:[vh]},$$scope:{ctx:$}}}),nt=new he({props:{anchor:"transformers.T5Model.forward.example",$$slots:{default:[kh]},$$scope:{ctx:$}}}),bo=new U({}),yo=new z({props:{name:"class transformers.T5ForConditionalGeneration",anchor:"transformers.T5ForConditionalGeneration",parameters:[{name:"config",val:": T5Config"}],parametersDescription:[{anchor:"transformers.T5ForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.T5Config">T5Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/modeling_t5.py#L1557"}}),vo=new z({props:{name:"forward",anchor:"transformers.T5ForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"cross_attn_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.T5ForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. T5 is a model with relative position embeddings so you
should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./t5#training">T5 Training</a>.`,name:"input_ids"},{anchor:"transformers.T5ForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.T5ForConditionalGeneration.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>T5 uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If <code>past_key_values</code>
is used, optionally only the last <code>decoder_input_ids</code> have to be input (see <code>past_key_values</code>).</p>
<p>To know more on how to prepare <code>decoder_input_ids</code> for pretraining take a look at <a href="./t5#training">T5
Training</a>.`,name:"decoder_input_ids"},{anchor:"transformers.T5ForConditionalGeneration.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.T5ForConditionalGeneration.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.T5ForConditionalGeneration.forward.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.T5ForConditionalGeneration.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder. Mask values selected in
<code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.T5ForConditionalGeneration.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.T5ForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.T5ForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.T5ForConditionalGeneration.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.T5ForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.T5ForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.T5ForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.T5ForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.T5ForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[-100, 0, ..., config.vocab_size - 1]</code>. All labels set to <code>-100</code> are ignored (masked), the loss is only computed for
labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/modeling_t5.py#L1645",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.T5Config"
>T5Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),st=new O({props:{$$slots:{default:[Mh]},$$scope:{ctx:$}}}),at=new he({props:{anchor:"transformers.T5ForConditionalGeneration.forward.example",$$slots:{default:[wh]},$$scope:{ctx:$}}}),ko=new U({}),Mo=new z({props:{name:"class transformers.T5EncoderModel",anchor:"transformers.T5EncoderModel",parameters:[{name:"config",val:": T5Config"}],parametersDescription:[{anchor:"transformers.T5EncoderModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.T5Config">T5Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/modeling_t5.py#L1867"}}),wo=new z({props:{name:"forward",anchor:"transformers.T5EncoderModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.T5EncoderModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. T5 is a model with relative position embeddings so you
should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./t5#training">T5 Training</a>.`,name:"input_ids"},{anchor:"transformers.T5EncoderModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.T5EncoderModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.T5EncoderModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.T5EncoderModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.T5EncoderModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.T5EncoderModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/modeling_t5.py#L1935",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.T5Config"
>T5Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),it=new O({props:{$$slots:{default:[xh]},$$scope:{ctx:$}}}),dt=new he({props:{anchor:"transformers.T5EncoderModel.forward.example",$$slots:{default:[$h]},$$scope:{ctx:$}}}),xo=new U({}),$o=new z({props:{name:"class transformers.T5ForSequenceClassification",anchor:"transformers.T5ForSequenceClassification",parameters:[{name:"config",val:": T5Config"}],parametersDescription:[{anchor:"transformers.T5ForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.T5Config">T5Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/modeling_t5.py#L1985"}}),jo=new z({props:{name:"forward",anchor:"transformers.T5ForSequenceClassification.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"decoder_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"cross_attn_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.T5ForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. T5 is a model with relative position embeddings so you
should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./t5#training">T5 Training</a>.`,name:"input_ids"},{anchor:"transformers.T5ForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.T5ForSequenceClassification.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>T5 uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If <code>past_key_values</code>
is used, optionally only the last <code>decoder_input_ids</code> have to be input (see <code>past_key_values</code>).</p>
<p>To know more on how to prepare <code>decoder_input_ids</code> for pretraining take a look at <a href="./t5#training">T5
Training</a>.`,name:"decoder_input_ids"},{anchor:"transformers.T5ForSequenceClassification.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.T5ForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.T5ForSequenceClassification.forward.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.T5ForSequenceClassification.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder. Mask values selected in
<code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.T5ForSequenceClassification.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.T5ForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.T5ForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.T5ForSequenceClassification.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.T5ForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.T5ForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.T5ForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.T5ForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.T5ForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/modeling_t5.py#L1999",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput"
>transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.T5Config"
>T5Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>label</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput"
>transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ct=new O({props:{$$slots:{default:[jh]},$$scope:{ctx:$}}}),zo=new U({}),Fo=new z({props:{name:"class transformers.T5ForQuestionAnswering",anchor:"transformers.T5ForQuestionAnswering",parameters:[{name:"config",val:": T5Config"}],parametersDescription:[{anchor:"transformers.T5ForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.T5Config">T5Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/modeling_t5.py#L2118"}}),Co=new z({props:{name:"forward",anchor:"transformers.T5ForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"cross_attn_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"start_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"end_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.T5ForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. T5 is a model with relative position embeddings so you
should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./t5#training">T5 Training</a>.`,name:"input_ids"},{anchor:"transformers.T5ForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.T5ForQuestionAnswering.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>T5 uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If <code>past_key_values</code>
is used, optionally only the last <code>decoder_input_ids</code> have to be input (see <code>past_key_values</code>).</p>
<p>To know more on how to prepare <code>decoder_input_ids</code> for pretraining take a look at <a href="./t5#training">T5
Training</a>.`,name:"decoder_input_ids"},{anchor:"transformers.T5ForQuestionAnswering.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.T5ForQuestionAnswering.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.T5ForQuestionAnswering.forward.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.T5ForQuestionAnswering.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder. Mask values selected in
<code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.T5ForQuestionAnswering.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.T5ForQuestionAnswering.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.T5ForQuestionAnswering.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.T5ForQuestionAnswering.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.T5ForQuestionAnswering.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.T5ForQuestionAnswering.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.T5ForQuestionAnswering.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.T5ForQuestionAnswering.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.T5ForQuestionAnswering.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<em>sequence_length</em>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.T5ForQuestionAnswering.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<em>sequence_length</em>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/modeling_t5.py#L2162",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput"
>transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.T5Config"
>T5Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.</p>
</li>
<li>
<p><strong>start_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-start scores (before SoftMax).</p>
</li>
<li>
<p><strong>end_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-end scores (before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput"
>transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ut=new O({props:{$$slots:{default:[zh]},$$scope:{ctx:$}}}),Jo=new U({}),Uo=new z({props:{name:"class transformers.TFT5Model",anchor:"transformers.TFT5Model",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFT5Model.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.T5Config">T5Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/modeling_tf_t5.py#L1093"}}),mt=new O({props:{$$slots:{default:[Fh]},$$scope:{ctx:$}}}),qo=new z({props:{name:"call",anchor:"transformers.TFT5Model.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"decoder_input_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"decoder_attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"decoder_head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"encoder_outputs",val:": np.ndarray | tf.Tensor | None = None"},{name:"past_key_values",val:": Optional[Tuple[Tuple[Union[np.ndarray, tf.Tensor]]]] = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"decoder_inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"use_cache",val:": Optional[bool] = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFT5Model.call.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. T5 is a model with relative position embeddings so you
should be able to pad the inputs on the right or the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<p>To know more on how to prepare <code>inputs</code> for pretraining take a look at <a href="./t5#training">T5 Training</a>.`,name:"input_ids"},{anchor:"transformers.TFT5Model.call.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Provide for sequence to sequence training. T5 uses the <code>pad_token_id</code> as the starting token for
<code>decoder_input_ids</code> generation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code>
have to be input (see <code>past_key_values</code>).</p>
<p>To know more on how to prepare <code>decoder_input_ids</code> for pretraining take a look at <a href="./t5#training">T5
Training</a>.`,name:"decoder_input_ids"},{anchor:"transformers.TFT5Model.call.attention_mask",description:`<strong>attention_mask</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFT5Model.call.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.TFT5Model.call.head_mask",description:`<strong>head_mask</strong> (<code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFT5Model.call.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.TFT5Model.call.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(tf.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.TFT5Model.call.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(tf.Tensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.TFT5Model.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFT5Model.call.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.TFT5Model.call.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.TFT5Model.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFT5Model.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFT5Model.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFT5Model.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/modeling_tf_t5.py#L1121",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_tf_outputs.TFSeq2SeqModelOutput"
>transformers.modeling_tf_outputs.TFSeq2SeqModelOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.T5Config"
>T5Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) of the decoder that can be
used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_tf_outputs.TFSeq2SeqModelOutput"
>transformers.modeling_tf_outputs.TFSeq2SeqModelOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),ft=new O({props:{$$slots:{default:[Ch]},$$scope:{ctx:$}}}),gt=new he({props:{anchor:"transformers.TFT5Model.call.example",$$slots:{default:[Jh]},$$scope:{ctx:$}}}),Io=new U({}),Zo=new z({props:{name:"class transformers.TFT5ForConditionalGeneration",anchor:"transformers.TFT5ForConditionalGeneration",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFT5ForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.T5Config">T5Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/modeling_tf_t5.py#L1226"}}),Tt=new O({props:{$$slots:{default:[Uh]},$$scope:{ctx:$}}}),Go=new z({props:{name:"call",anchor:"transformers.TFT5ForConditionalGeneration.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"decoder_input_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"decoder_attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"decoder_head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"encoder_outputs",val:": np.ndarray | tf.Tensor | None = None"},{name:"past_key_values",val:": Optional[Tuple[Tuple[Union[np.ndarray, tf.Tensor]]]] = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"decoder_inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"labels",val:": np.ndarray | tf.Tensor | None = None"},{name:"use_cache",val:": Optional[bool] = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFT5ForConditionalGeneration.call.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. T5 is a model with relative position embeddings so you
should be able to pad the inputs on the right or the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<p>To know more on how to prepare <code>inputs</code> for pretraining take a look at <a href="./t5#training">T5 Training</a>.`,name:"input_ids"},{anchor:"transformers.TFT5ForConditionalGeneration.call.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Provide for sequence to sequence training. T5 uses the <code>pad_token_id</code> as the starting token for
<code>decoder_input_ids</code> generation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code>
have to be input (see <code>past_key_values</code>).</p>
<p>To know more on how to prepare <code>decoder_input_ids</code> for pretraining take a look at <a href="./t5#training">T5
Training</a>.`,name:"decoder_input_ids"},{anchor:"transformers.TFT5ForConditionalGeneration.call.attention_mask",description:`<strong>attention_mask</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFT5ForConditionalGeneration.call.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.TFT5ForConditionalGeneration.call.head_mask",description:`<strong>head_mask</strong> (<code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFT5ForConditionalGeneration.call.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.TFT5ForConditionalGeneration.call.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(tf.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.TFT5ForConditionalGeneration.call.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(tf.Tensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.TFT5ForConditionalGeneration.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFT5ForConditionalGeneration.call.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.TFT5ForConditionalGeneration.call.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.TFT5ForConditionalGeneration.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFT5ForConditionalGeneration.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFT5ForConditionalGeneration.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFT5ForConditionalGeneration.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"},{anchor:"transformers.TFT5ForConditionalGeneration.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the cross entropy classification loss. Indices should be in <code>[0, ..., config.vocab_size - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/modeling_tf_t5.py#L1281",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_tf_outputs.TFSeq2SeqLMOutput"
>transformers.modeling_tf_outputs.TFSeq2SeqLMOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.T5Config"
>T5Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) — Language modeling loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) of the decoder that can be
used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_tf_outputs.TFSeq2SeqLMOutput"
>transformers.modeling_tf_outputs.TFSeq2SeqLMOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),bt=new O({props:{$$slots:{default:[qh]},$$scope:{ctx:$}}}),yt=new he({props:{anchor:"transformers.TFT5ForConditionalGeneration.call.example",$$slots:{default:[Ih]},$$scope:{ctx:$}}}),Wo=new U({}),Bo=new z({props:{name:"class transformers.TFT5EncoderModel",anchor:"transformers.TFT5EncoderModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFT5EncoderModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.T5Config">T5Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/modeling_tf_t5.py#L1479"}}),kt=new O({props:{$$slots:{default:[Zh]},$$scope:{ctx:$}}}),Ho=new z({props:{name:"call",anchor:"transformers.TFT5EncoderModel.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFT5EncoderModel.call.inputs",description:`<strong>inputs</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. T5 is a model with relative position embeddings so you
should be able to pad the inputs on the right or the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p>To know more on how to prepare <code>inputs</code> for pre-training take a look at <a href="./t5#training">T5 Training</a>.`,name:"inputs"},{anchor:"transformers.TFT5EncoderModel.call.attention_mask",description:`<strong>attention_mask</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFT5EncoderModel.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFT5EncoderModel.call.head_mask",description:`<strong>head_mask</strong> (<code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFT5EncoderModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TFT5EncoderModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFT5EncoderModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TFT5EncoderModel.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/modeling_tf_t5.py#L1498",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutput"
>transformers.modeling_tf_outputs.TFBaseModelOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.T5Config"
>T5Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutput"
>transformers.modeling_tf_outputs.TFBaseModelOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),Mt=new O({props:{$$slots:{default:[Gh]},$$scope:{ctx:$}}}),wt=new he({props:{anchor:"transformers.TFT5EncoderModel.call.example",$$slots:{default:[Wh]},$$scope:{ctx:$}}}),Ro=new U({}),No=new z({props:{name:"class transformers.FlaxT5Model",anchor:"transformers.FlaxT5Model",parameters:[{name:"config",val:": T5Config"},{name:"input_shape",val:": typing.Tuple[int] = (1, 1)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"gradient_checkpointing",val:": bool = False"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/modeling_flax_t5.py#L1367"}}),Vo=new z({props:{name:"__call__",anchor:"transformers.FlaxT5Model.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"attention_mask",val:": typing.Optional[jax.Array] = None"},{name:"decoder_input_ids",val:": Array = None"},{name:"decoder_attention_mask",val:": typing.Optional[jax.Array] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"train",val:": bool = False"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"}],parametersDescription:[{anchor:"transformers.FlaxT5Model.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. T5 is a model with relative position embeddings so you
should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./t5#training">T5 Training</a>.`,name:"input_ids"},{anchor:"transformers.FlaxT5Model.__call__.attention_mask",description:`<strong>attention_mask</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FlaxT5Model.__call__.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>T5 uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If <code>past_key_values</code>
is used, optionally only the last <code>decoder_input_ids</code> have to be input (see <code>past_key_values</code>).</p>
<p>To know more on how to prepare <code>decoder_input_ids</code> for pretraining take a look at <a href="./t5#training">T5
Training</a>.`,name:"decoder_input_ids"},{anchor:"transformers.FlaxT5Model.__call__.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.FlaxT5Model.__call__.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(jnp.ndarray)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.FlaxT5Model.__call__.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(jnp.ndarray))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/modeling_flax_t5.py#L986",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput"
>transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.T5Config"
>T5Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(jnp.ndarray))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(jnp.ndarray)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput"
>transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),$t=new O({props:{$$slots:{default:[Bh]},$$scope:{ctx:$}}}),jt=new he({props:{anchor:"transformers.FlaxT5Model.__call__.example",$$slots:{default:[Hh]},$$scope:{ctx:$}}}),Xo=new z({props:{name:"encode",anchor:"transformers.FlaxT5Model.encode",parameters:[{name:"input_ids",val:": Array"},{name:"attention_mask",val:": typing.Optional[jax.Array] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"train",val:": bool = False"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"}],parametersDescription:[{anchor:"transformers.FlaxT5Model.encode.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. T5 is a model with relative position embeddings so you
should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./t5#training">T5 Training</a>.`,name:"input_ids"},{anchor:"transformers.FlaxT5Model.encode.attention_mask",description:`<strong>attention_mask</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FlaxT5Model.encode.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FlaxT5Model.encode.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FlaxT5Model.encode.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/modeling_flax_t5.py#L1072",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_flax_outputs.FlaxBaseModelOutput"
>transformers.modeling_flax_outputs.FlaxBaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.t5.configuration_t5.T5Config'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_flax_outputs.FlaxBaseModelOutput"
>transformers.modeling_flax_outputs.FlaxBaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Ft=new he({props:{anchor:"transformers.FlaxT5Model.encode.example",$$slots:{default:[Rh]},$$scope:{ctx:$}}}),Eo=new z({props:{name:"decode",anchor:"transformers.FlaxT5Model.decode",parameters:[{name:"decoder_input_ids",val:""},{name:"encoder_outputs",val:""},{name:"encoder_attention_mask",val:": typing.Optional[jax.Array] = None"},{name:"decoder_attention_mask",val:": typing.Optional[jax.Array] = None"},{name:"past_key_values",val:": dict = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"train",val:": bool = False"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"}],parametersDescription:[{anchor:"transformers.FlaxT5Model.decode.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, target_sequence_length)</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>For training, <code>decoder_input_ids</code> should be provided.`,name:"decoder_input_ids"},{anchor:"transformers.FlaxT5Model.decode.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(jnp.ndarray)</code>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.FlaxT5Model.decode.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"encoder_attention_mask"},{anchor:"transformers.FlaxT5Model.decode.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.</p>
<p>If you want to change padding behavior, you should modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the
paper</a> for more information on the default strategy.`,name:"decoder_attention_mask"},{anchor:"transformers.FlaxT5Model.decode.past_key_values",description:`<strong>past_key_values</strong> (<code>Dict[str, np.ndarray]</code>, <em>optional</em>, returned by <code>init_cache</code> or when passing previous <code>past_key_values</code>) &#x2014;
Dictionary of pre-computed hidden-states (key and values in the attention blocks) that can be used for fast
auto-regressive decoding. Pre-computed key and value hidden-states are of shape <em>[batch_size, max_length]</em>.`,name:"past_key_values"},{anchor:"transformers.FlaxT5Model.decode.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FlaxT5Model.decode.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FlaxT5Model.decode.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/modeling_flax_t5.py#L1130",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.t5.configuration_t5.T5Config'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(jnp.ndarray))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(jnp.ndarray)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Jt=new he({props:{anchor:"transformers.FlaxT5Model.decode.example",$$slots:{default:[Nh]},$$scope:{ctx:$}}}),Lo=new U({}),So=new z({props:{name:"class transformers.FlaxT5ForConditionalGeneration",anchor:"transformers.FlaxT5ForConditionalGeneration",parameters:[{name:"config",val:": T5Config"},{name:"input_shape",val:": typing.Tuple[int] = (1, 1)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"gradient_checkpointing",val:": bool = False"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/modeling_flax_t5.py#L1605"}}),Ao=new z({props:{name:"__call__",anchor:"transformers.FlaxT5ForConditionalGeneration.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"attention_mask",val:": typing.Optional[jax.Array] = None"},{name:"decoder_input_ids",val:": Array = None"},{name:"decoder_attention_mask",val:": typing.Optional[jax.Array] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"train",val:": bool = False"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"}],parametersDescription:[{anchor:"transformers.FlaxT5ForConditionalGeneration.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. T5 is a model with relative position embeddings so you
should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./t5#training">T5 Training</a>.`,name:"input_ids"},{anchor:"transformers.FlaxT5ForConditionalGeneration.__call__.attention_mask",description:`<strong>attention_mask</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FlaxT5ForConditionalGeneration.__call__.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>T5 uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If <code>past_key_values</code>
is used, optionally only the last <code>decoder_input_ids</code> have to be input (see <code>past_key_values</code>).</p>
<p>To know more on how to prepare <code>decoder_input_ids</code> for pretraining take a look at <a href="./t5#training">T5
Training</a>.`,name:"decoder_input_ids"},{anchor:"transformers.FlaxT5ForConditionalGeneration.__call__.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.FlaxT5ForConditionalGeneration.__call__.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(jnp.ndarray)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.FlaxT5ForConditionalGeneration.__call__.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(jnp.ndarray))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/modeling_flax_t5.py#L986",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput"
>transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/t5#transformers.T5Config"
>T5Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(jnp.ndarray))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(jnp.ndarray)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput"
>transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),qt=new O({props:{$$slots:{default:[Vh]},$$scope:{ctx:$}}}),It=new he({props:{anchor:"transformers.FlaxT5ForConditionalGeneration.__call__.example",$$slots:{default:[Xh]},$$scope:{ctx:$}}}),Po=new z({props:{name:"encode",anchor:"transformers.FlaxT5ForConditionalGeneration.encode",parameters:[{name:"input_ids",val:": Array"},{name:"attention_mask",val:": typing.Optional[jax.Array] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"train",val:": bool = False"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"}],parametersDescription:[{anchor:"transformers.FlaxT5ForConditionalGeneration.encode.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. T5 is a model with relative position embeddings so you
should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./t5#training">T5 Training</a>.`,name:"input_ids"},{anchor:"transformers.FlaxT5ForConditionalGeneration.encode.attention_mask",description:`<strong>attention_mask</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FlaxT5ForConditionalGeneration.encode.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FlaxT5ForConditionalGeneration.encode.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FlaxT5ForConditionalGeneration.encode.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/modeling_flax_t5.py#L1072",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_flax_outputs.FlaxBaseModelOutput"
>transformers.modeling_flax_outputs.FlaxBaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.t5.configuration_t5.T5Config'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_flax_outputs.FlaxBaseModelOutput"
>transformers.modeling_flax_outputs.FlaxBaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Gt=new he({props:{anchor:"transformers.FlaxT5ForConditionalGeneration.encode.example",$$slots:{default:[Eh]},$$scope:{ctx:$}}}),Qo=new z({props:{name:"decode",anchor:"transformers.FlaxT5ForConditionalGeneration.decode",parameters:[{name:"decoder_input_ids",val:""},{name:"encoder_outputs",val:""},{name:"encoder_attention_mask",val:": typing.Optional[jax.Array] = None"},{name:"decoder_attention_mask",val:": typing.Optional[jax.Array] = None"},{name:"past_key_values",val:": dict = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"train",val:": bool = False"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"}],parametersDescription:[{anchor:"transformers.FlaxT5ForConditionalGeneration.decode.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, target_sequence_length)</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>For training, <code>decoder_input_ids</code> should be provided.`,name:"decoder_input_ids"},{anchor:"transformers.FlaxT5ForConditionalGeneration.decode.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(jnp.ndarray)</code>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.FlaxT5ForConditionalGeneration.decode.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"encoder_attention_mask"},{anchor:"transformers.FlaxT5ForConditionalGeneration.decode.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.</p>
<p>If you want to change padding behavior, you should modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the
paper</a> for more information on the default strategy.`,name:"decoder_attention_mask"},{anchor:"transformers.FlaxT5ForConditionalGeneration.decode.past_key_values",description:`<strong>past_key_values</strong> (<code>Dict[str, np.ndarray]</code>, <em>optional</em>, returned by <code>init_cache</code> or when passing previous <code>past_key_values</code>) &#x2014;
Dictionary of pre-computed hidden-states (key and values in the attention blocks) that can be used for fast
auto-regressive decoding. Pre-computed key and value hidden-states are of shape <em>[batch_size, max_length]</em>.`,name:"past_key_values"},{anchor:"transformers.FlaxT5ForConditionalGeneration.decode.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FlaxT5ForConditionalGeneration.decode.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FlaxT5ForConditionalGeneration.decode.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/modeling_flax_t5.py#L1608",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions"
>transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.t5.configuration_t5.T5Config'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Cross attentions weights after the attention softmax, used to compute the weighted average in the
cross-attention heads.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(jnp.ndarray))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>jnp.ndarray</code> tuples of length <code>config.n_layers</code>, with each tuple containing the cached key, value
states of the self-attention and the cross-attention layers if model is used in encoder-decoder setting.
Only relevant if <code>config.is_decoder = True</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions"
>transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Bt=new he({props:{anchor:"transformers.FlaxT5ForConditionalGeneration.decode.example",$$slots:{default:[Lh]},$$scope:{ctx:$}}}),Do=new U({}),Oo=new z({props:{name:"class transformers.FlaxT5EncoderModel",anchor:"transformers.FlaxT5EncoderModel",parameters:[{name:"config",val:": T5Config"},{name:"input_shape",val:": typing.Tuple[int] = (1, 1)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"gradient_checkpointing",val:": bool = False"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/modeling_flax_t5.py#L1454"}}),Yo=new z({props:{name:"__call__",anchor:"transformers.FlaxT5EncoderModel.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"attention_mask",val:": typing.Optional[jax.Array] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"train",val:": bool = False"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"}],parametersDescription:[{anchor:"transformers.FlaxT5EncoderModel.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. T5 is a model with relative position embeddings so you
should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./t5#training">T5 Training</a>.`,name:"input_ids"},{anchor:"transformers.FlaxT5EncoderModel.__call__.attention_mask",description:`<strong>attention_mask</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FlaxT5EncoderModel.__call__.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FlaxT5EncoderModel.__call__.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FlaxT5EncoderModel.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/t5/modeling_flax_t5.py#L1457"}}),Rt=new O({props:{$$slots:{default:[Sh]},$$scope:{ctx:$}}}),{c(){l=o("meta"),k=r(),u=o("p"),h=r(),M=o("h1"),c=o("a"),w=o("span"),f(S.$$.fragment),B=r(),C=o("span"),C.textContent=me,q=r(),F=o("div"),F.innerHTML=fe,x=r(),j=o("h2"),Xe=o("a"),Ba=o("span"),f(Ot.$$.fragment),Md=r(),ds=o("span"),ds.textContent=Wc,yr=r(),Yt=o("p"),Yt.innerHTML=Bc,vr=r(),Kt=o("p"),Kt.textContent=Hc,kr=r(),en=o("p"),en.innerHTML=Rc,Mr=r(),tn=o("p"),tn.textContent=Nc,wr=r(),nn=o("ul"),nn.innerHTML=Vc,xr=r(),on=o("p"),on.textContent=Xc,$r=r(),sn=o("ul"),sn.innerHTML=Ec,jr=r(),an=o("p"),an.textContent=Lc,zr=r(),rn=o("ul"),rn.innerHTML=Sc,Fr=r(),dn=o("p"),dn.innerHTML=Ac,Cr=r(),ln=o("p"),ln.innerHTML=Pc,Jr=r(),ls=o("a"),Ur=r(),Me=o("h2"),Ee=o("a"),Ha=o("span"),f(cn.$$.fragment),wd=r(),cs=o("span"),cs.textContent=Qc,qr=r(),pn=o("p"),pn.innerHTML=Dc,Ir=r(),un=o("p"),un.innerHTML=Oc,Zr=r(),hn=o("ul"),hn.innerHTML=Yc,Gr=r(),mn=o("p"),mn.innerHTML=Kc,Wr=r(),fn=o("p"),fn.textContent=ep,Br=r(),f(gn.$$.fragment),Hr=r(),_n=o("p"),_n.innerHTML=tp,Rr=r(),Tn=o("ul"),Tn.innerHTML=np,Nr=r(),bn=o("p"),bn.textContent=op,Vr=r(),f(yn.$$.fragment),Xr=r(),vn=o("p"),vn.innerHTML=sp,Er=r(),kn=o("p"),kn.innerHTML=ap,Lr=r(),Mn=o("p"),Mn.innerHTML=rp,Sr=r(),f(wn.$$.fragment),Ar=r(),xn=o("p"),xn.textContent=ip,Pr=r(),$n=o("ul"),$n.innerHTML=dp,Qr=r(),jn=o("p"),jn.innerHTML=lp,Dr=r(),zn=o("p"),zn.innerHTML=cp,Or=r(),ps=o("a"),Yr=r(),we=o("h2"),Le=o("a"),Ra=o("span"),f(Fn.$$.fragment),xd=r(),us=o("span"),us.textContent=pp,Kr=r(),Cn=o("p"),Cn.innerHTML=up,ei=r(),f(Jn.$$.fragment),ti=r(),Un=o("p"),Un.innerHTML=hp,ni=r(),qn=o("p"),qn.textContent=mp,oi=r(),f(In.$$.fragment),si=r(),Zn=o("p"),Zn.textContent=fp,ai=r(),f(Gn.$$.fragment),ri=r(),hs=o("a"),ii=r(),xe=o("h2"),Se=o("a"),Na=o("span"),f(Wn.$$.fragment),$d=r(),ms=o("span"),ms.textContent=gp,di=r(),Bn=o("p"),Bn.innerHTML=_p,li=r(),$e=o("h2"),Ae=o("a"),Va=o("span"),f(Hn.$$.fragment),jd=r(),fs=o("span"),fs.textContent=Tp,ci=r(),Rn=o("p"),Rn.textContent=bp,pi=r(),f(Nn.$$.fragment),ui=r(),Vn=o("ul"),Vn.innerHTML=yp,hi=r(),f(Xn.$$.fragment),mi=r(),En=o("ul"),En.innerHTML=vp,fi=r(),f(Ln.$$.fragment),gi=r(),Sn=o("ul"),Sn.innerHTML=kp,_i=r(),f(An.$$.fragment),Ti=r(),Pn=o("ul"),Pn.innerHTML=Mp,bi=r(),f(Qn.$$.fragment),yi=r(),Dn=o("ul"),Dn.innerHTML=wp,vi=r(),f(On.$$.fragment),ki=r(),Yn=o("ul"),Yn.innerHTML=xp,Mi=r(),f(Kn.$$.fragment),wi=r(),eo=o("ul"),eo.innerHTML=$p,xi=r(),to=o("p"),to.innerHTML=jp,$i=r(),no=o("ul"),no.innerHTML=zp,ji=r(),je=o("h2"),Pe=o("a"),Xa=o("span"),f(oo.$$.fragment),zd=r(),gs=o("span"),gs.textContent=Fp,zi=r(),ge=o("div"),f(so.$$.fragment),Fd=r(),_s=o("p"),_s.innerHTML=Cp,Cd=r(),Ts=o("p"),Ts.innerHTML=Jp,Fi=r(),ze=o("h2"),Qe=o("a"),Ea=o("span"),f(ao.$$.fragment),Jd=r(),bs=o("span"),bs.textContent=Up,Ci=r(),I=o("div"),f(ro.$$.fragment),Ud=r(),ys=o("p"),ys.innerHTML=qp,qd=r(),vs=o("p"),vs.innerHTML=Ip,Id=r(),_e=o("div"),f(io.$$.fragment),Zd=r(),ks=o("p"),ks.textContent=Zp,Gd=r(),Ms=o("ul"),Ms.innerHTML=Gp,Wd=r(),De=o("div"),f(lo.$$.fragment),Bd=r(),ws=o("p"),ws.innerHTML=Wp,Hd=r(),Oe=o("div"),f(co.$$.fragment),Rd=r(),xs=o("p"),xs.textContent=Bp,Nd=r(),$s=o("div"),f(po.$$.fragment),Ji=r(),Fe=o("h2"),Ye=o("a"),La=o("span"),f(uo.$$.fragment),Vd=r(),js=o("span"),js.textContent=Hp,Ui=r(),A=o("div"),f(ho.$$.fragment),Xd=r(),zs=o("p"),zs.innerHTML=Rp,Ed=r(),Fs=o("p"),Fs.innerHTML=Np,Ld=r(),Te=o("div"),f(mo.$$.fragment),Sd=r(),Cs=o("p"),Cs.textContent=Vp,Ad=r(),Js=o("ul"),Js.innerHTML=Xp,Pd=r(),Ke=o("div"),f(fo.$$.fragment),Qd=r(),Us=o("p"),Us.textContent=Ep,qi=r(),Ce=o("h2"),et=o("a"),Sa=o("span"),f(go.$$.fragment),Dd=r(),qs=o("span"),qs.textContent=Lp,Ii=r(),R=o("div"),f(_o.$$.fragment),Od=r(),Is=o("p"),Is.textContent=Sp,Yd=r(),Zs=o("p"),Zs.innerHTML=Ap,Kd=r(),Gs=o("p"),Gs.innerHTML=Pp,el=r(),Ws=o("p"),Ws.innerHTML=Qp,tl=r(),ee=o("div"),f(To.$$.fragment),nl=r(),Bs=o("p"),Bs.innerHTML=Dp,ol=r(),f(tt.$$.fragment),sl=r(),f(nt.$$.fragment),Zi=r(),Je=o("h2"),ot=o("a"),Aa=o("span"),f(bo.$$.fragment),al=r(),Hs=o("span"),Hs.textContent=Op,Gi=r(),N=o("div"),f(yo.$$.fragment),rl=r(),Rs=o("p"),Rs.innerHTML=Yp,il=r(),Ns=o("p"),Ns.innerHTML=Kp,dl=r(),Vs=o("p"),Vs.innerHTML=eu,ll=r(),Xs=o("p"),Xs.innerHTML=tu,cl=r(),te=o("div"),f(vo.$$.fragment),pl=r(),Es=o("p"),Es.innerHTML=nu,ul=r(),f(st.$$.fragment),hl=r(),f(at.$$.fragment),Wi=r(),Ue=o("h2"),rt=o("a"),Pa=o("span"),f(ko.$$.fragment),ml=r(),Ls=o("span"),Ls.textContent=ou,Bi=r(),V=o("div"),f(Mo.$$.fragment),fl=r(),Ss=o("p"),Ss.textContent=su,gl=r(),As=o("p"),As.innerHTML=au,_l=r(),Ps=o("p"),Ps.innerHTML=ru,Tl=r(),Qs=o("p"),Qs.innerHTML=iu,bl=r(),ne=o("div"),f(wo.$$.fragment),yl=r(),Ds=o("p"),Ds.innerHTML=du,vl=r(),f(it.$$.fragment),kl=r(),f(dt.$$.fragment),Hi=r(),qe=o("h2"),lt=o("a"),Qa=o("span"),f(xo.$$.fragment),Ml=r(),Os=o("span"),Os.textContent=lu,Ri=r(),X=o("div"),f($o.$$.fragment),wl=r(),Ys=o("p"),Ys.textContent=cu,xl=r(),Ks=o("p"),Ks.innerHTML=pu,$l=r(),ea=o("p"),ea.innerHTML=uu,jl=r(),ta=o("p"),ta.innerHTML=hu,zl=r(),be=o("div"),f(jo.$$.fragment),Fl=r(),na=o("p"),na.innerHTML=mu,Cl=r(),f(ct.$$.fragment),Ni=r(),Ie=o("h2"),pt=o("a"),Da=o("span"),f(zo.$$.fragment),Jl=r(),oa=o("span"),oa.textContent=fu,Vi=r(),E=o("div"),f(Fo.$$.fragment),Ul=r(),sa=o("p"),sa.innerHTML=gu,ql=r(),aa=o("p"),aa.innerHTML=_u,Il=r(),ra=o("p"),ra.innerHTML=Tu,Zl=r(),ia=o("p"),ia.innerHTML=bu,Gl=r(),ye=o("div"),f(Co.$$.fragment),Wl=r(),da=o("p"),da.innerHTML=yu,Bl=r(),f(ut.$$.fragment),Xi=r(),Ze=o("h2"),ht=o("a"),Oa=o("span"),f(Jo.$$.fragment),Hl=r(),la=o("span"),la.textContent=vu,Ei=r(),Z=o("div"),f(Uo.$$.fragment),Rl=r(),ca=o("p"),ca.textContent=ku,Nl=r(),pa=o("p"),pa.innerHTML=Mu,Vl=r(),ua=o("p"),ua.innerHTML=wu,Xl=r(),ha=o("p"),ha.innerHTML=xu,El=r(),f(mt.$$.fragment),Ll=r(),oe=o("div"),f(qo.$$.fragment),Sl=r(),ma=o("p"),ma.innerHTML=$u,Al=r(),f(ft.$$.fragment),Pl=r(),f(gt.$$.fragment),Li=r(),Ge=o("h2"),_t=o("a"),Ya=o("span"),f(Io.$$.fragment),Ql=r(),fa=o("span"),fa.textContent=ju,Si=r(),G=o("div"),f(Zo.$$.fragment),Dl=r(),ga=o("p"),ga.innerHTML=zu,Ol=r(),_a=o("p"),_a.innerHTML=Fu,Yl=r(),Ta=o("p"),Ta.innerHTML=Cu,Kl=r(),ba=o("p"),ba.innerHTML=Ju,ec=r(),f(Tt.$$.fragment),tc=r(),se=o("div"),f(Go.$$.fragment),nc=r(),ya=o("p"),ya.innerHTML=Uu,oc=r(),f(bt.$$.fragment),sc=r(),f(yt.$$.fragment),Ai=r(),We=o("h2"),vt=o("a"),Ka=o("span"),f(Wo.$$.fragment),ac=r(),va=o("span"),va.textContent=qu,Pi=r(),W=o("div"),f(Bo.$$.fragment),rc=r(),ka=o("p"),ka.textContent=Iu,ic=r(),Ma=o("p"),Ma.innerHTML=Zu,dc=r(),wa=o("p"),wa.innerHTML=Gu,lc=r(),xa=o("p"),xa.innerHTML=Wu,cc=r(),f(kt.$$.fragment),pc=r(),ae=o("div"),f(Ho.$$.fragment),uc=r(),$a=o("p"),$a.innerHTML=Bu,hc=r(),f(Mt.$$.fragment),mc=r(),f(wt.$$.fragment),Qi=r(),Be=o("h2"),xt=o("a"),er=o("span"),f(Ro.$$.fragment),fc=r(),ja=o("span"),ja.textContent=Hu,Di=r(),Y=o("div"),f(No.$$.fragment),gc=r(),re=o("div"),f(Vo.$$.fragment),_c=r(),za=o("p"),za.innerHTML=Ru,Tc=r(),f($t.$$.fragment),bc=r(),f(jt.$$.fragment),yc=r(),zt=o("div"),f(Xo.$$.fragment),vc=r(),f(Ft.$$.fragment),kc=r(),Ct=o("div"),f(Eo.$$.fragment),Mc=r(),f(Jt.$$.fragment),Oi=r(),He=o("h2"),Ut=o("a"),tr=o("span"),f(Lo.$$.fragment),wc=r(),Fa=o("span"),Fa.textContent=Nu,Yi=r(),K=o("div"),f(So.$$.fragment),xc=r(),ie=o("div"),f(Ao.$$.fragment),$c=r(),Ca=o("p"),Ca.innerHTML=Vu,jc=r(),f(qt.$$.fragment),zc=r(),f(It.$$.fragment),Fc=r(),Zt=o("div"),f(Po.$$.fragment),Cc=r(),f(Gt.$$.fragment),Jc=r(),Wt=o("div"),f(Qo.$$.fragment),Uc=r(),f(Bt.$$.fragment),Ki=r(),Re=o("h2"),Ht=o("a"),nr=o("span"),f(Do.$$.fragment),qc=r(),Ja=o("span"),Ja.textContent=Xu,ed=r(),Ne=o("div"),f(Oo.$$.fragment),Ic=r(),ve=o("div"),f(Yo.$$.fragment),Zc=r(),Ua=o("p"),Ua.innerHTML=Eu,Gc=r(),f(Rt.$$.fragment),td=r(),or=o("p"),this.h()},l(e){const a=yh("svelte-1phssyn",document.head);l=s(a,"META",{name:!0,content:!0}),a.forEach(t),k=i(e),u=s(e,"P",{}),v(u).forEach(t),h=i(e),M=s(e,"H1",{class:!0});var Ko=v(M);c=s(Ko,"A",{id:!0,class:!0,href:!0});var sr=v(c);w=s(sr,"SPAN",{});var ar=v(w);g(S.$$.fragment,ar),ar.forEach(t),sr.forEach(t),B=i(Ko),C=s(Ko,"SPAN",{"data-svelte-h":!0}),p(C)!=="svelte-1cet0"&&(C.textContent=me),Ko.forEach(t),q=i(e),F=s(e,"DIV",{class:!0,"data-svelte-h":!0}),p(F)!=="svelte-1xazft8"&&(F.innerHTML=fe),x=i(e),j=s(e,"H2",{class:!0});var es=v(j);Xe=s(es,"A",{id:!0,class:!0,href:!0});var rr=v(Xe);Ba=s(rr,"SPAN",{});var ir=v(Ba);g(Ot.$$.fragment,ir),ir.forEach(t),rr.forEach(t),Md=i(es),ds=s(es,"SPAN",{"data-svelte-h":!0}),p(ds)!=="svelte-1jsw1pg"&&(ds.textContent=Wc),es.forEach(t),yr=i(e),Yt=s(e,"P",{"data-svelte-h":!0}),p(Yt)!=="svelte-bjrdaa"&&(Yt.innerHTML=Bc),vr=i(e),Kt=s(e,"P",{"data-svelte-h":!0}),p(Kt)!=="svelte-vfdo9a"&&(Kt.textContent=Hc),kr=i(e),en=s(e,"P",{"data-svelte-h":!0}),p(en)!=="svelte-nquw4g"&&(en.innerHTML=Rc),Mr=i(e),tn=s(e,"P",{"data-svelte-h":!0}),p(tn)!=="svelte-axv494"&&(tn.textContent=Nc),wr=i(e),nn=s(e,"UL",{"data-svelte-h":!0}),p(nn)!=="svelte-wiyenp"&&(nn.innerHTML=Vc),xr=i(e),on=s(e,"P",{"data-svelte-h":!0}),p(on)!=="svelte-14r6d38"&&(on.textContent=Xc),$r=i(e),sn=s(e,"UL",{"data-svelte-h":!0}),p(sn)!=="svelte-d635uz"&&(sn.innerHTML=Ec),jr=i(e),an=s(e,"P",{"data-svelte-h":!0}),p(an)!=="svelte-1rxnqmp"&&(an.textContent=Lc),zr=i(e),rn=s(e,"UL",{"data-svelte-h":!0}),p(rn)!=="svelte-bdi512"&&(rn.innerHTML=Sc),Fr=i(e),dn=s(e,"P",{"data-svelte-h":!0}),p(dn)!=="svelte-1rpnkj8"&&(dn.innerHTML=Ac),Cr=i(e),ln=s(e,"P",{"data-svelte-h":!0}),p(ln)!=="svelte-iid9rh"&&(ln.innerHTML=Pc),Jr=i(e),ls=s(e,"A",{id:!0}),v(ls).forEach(t),Ur=i(e),Me=s(e,"H2",{class:!0});var ts=v(Me);Ee=s(ts,"A",{id:!0,class:!0,href:!0});var dr=v(Ee);Ha=s(dr,"SPAN",{});var lr=v(Ha);g(cn.$$.fragment,lr),lr.forEach(t),dr.forEach(t),wd=i(ts),cs=s(ts,"SPAN",{"data-svelte-h":!0}),p(cs)!=="svelte-1q1s287"&&(cs.textContent=Qc),ts.forEach(t),qr=i(e),pn=s(e,"P",{"data-svelte-h":!0}),p(pn)!=="svelte-1mcyrt7"&&(pn.innerHTML=Dc),Ir=i(e),un=s(e,"P",{"data-svelte-h":!0}),p(un)!=="svelte-b69qyq"&&(un.innerHTML=Oc),Zr=i(e),hn=s(e,"UL",{"data-svelte-h":!0}),p(hn)!=="svelte-1r0ku0c"&&(hn.innerHTML=Yc),Gr=i(e),mn=s(e,"P",{"data-svelte-h":!0}),p(mn)!=="svelte-u7cih6"&&(mn.innerHTML=Kc),Wr=i(e),fn=s(e,"P",{"data-svelte-h":!0}),p(fn)!=="svelte-3jfjj8"&&(fn.textContent=ep),Br=i(e),g(gn.$$.fragment,e),Hr=i(e),_n=s(e,"P",{"data-svelte-h":!0}),p(_n)!=="svelte-7vo35o"&&(_n.innerHTML=tp),Rr=i(e),Tn=s(e,"UL",{"data-svelte-h":!0}),p(Tn)!=="svelte-o4kvwt"&&(Tn.innerHTML=np),Nr=i(e),bn=s(e,"P",{"data-svelte-h":!0}),p(bn)!=="svelte-y0j04t"&&(bn.textContent=op),Vr=i(e),g(yn.$$.fragment,e),Xr=i(e),vn=s(e,"P",{"data-svelte-h":!0}),p(vn)!=="svelte-1hbtvtu"&&(vn.innerHTML=sp),Er=i(e),kn=s(e,"P",{"data-svelte-h":!0}),p(kn)!=="svelte-9qtpt3"&&(kn.innerHTML=ap),Lr=i(e),Mn=s(e,"P",{"data-svelte-h":!0}),p(Mn)!=="svelte-1iwna4s"&&(Mn.innerHTML=rp),Sr=i(e),g(wn.$$.fragment,e),Ar=i(e),xn=s(e,"P",{"data-svelte-h":!0}),p(xn)!=="svelte-1sumld1"&&(xn.textContent=ip),Pr=i(e),$n=s(e,"UL",{"data-svelte-h":!0}),p($n)!=="svelte-1yho768"&&($n.innerHTML=dp),Qr=i(e),jn=s(e,"P",{"data-svelte-h":!0}),p(jn)!=="svelte-q085d3"&&(jn.innerHTML=lp),Dr=i(e),zn=s(e,"P",{"data-svelte-h":!0}),p(zn)!=="svelte-1ydonn7"&&(zn.innerHTML=cp),Or=i(e),ps=s(e,"A",{id:!0}),v(ps).forEach(t),Yr=i(e),we=s(e,"H2",{class:!0});var ns=v(we);Le=s(ns,"A",{id:!0,class:!0,href:!0});var cr=v(Le);Ra=s(cr,"SPAN",{});var pr=v(Ra);g(Fn.$$.fragment,pr),pr.forEach(t),cr.forEach(t),xd=i(ns),us=s(ns,"SPAN",{"data-svelte-h":!0}),p(us)!=="svelte-199uz7g"&&(us.textContent=pp),ns.forEach(t),Kr=i(e),Cn=s(e,"P",{"data-svelte-h":!0}),p(Cn)!=="svelte-xj5hgj"&&(Cn.innerHTML=up),ei=i(e),g(Jn.$$.fragment,e),ti=i(e),Un=s(e,"P",{"data-svelte-h":!0}),p(Un)!=="svelte-xm0wsq"&&(Un.innerHTML=hp),ni=i(e),qn=s(e,"P",{"data-svelte-h":!0}),p(qn)!=="svelte-1pyapz5"&&(qn.textContent=mp),oi=i(e),g(In.$$.fragment,e),si=i(e),Zn=s(e,"P",{"data-svelte-h":!0}),p(Zn)!=="svelte-11xwy2d"&&(Zn.textContent=fp),ai=i(e),g(Gn.$$.fragment,e),ri=i(e),hs=s(e,"A",{id:!0}),v(hs).forEach(t),ii=i(e),xe=s(e,"H2",{class:!0});var os=v(xe);Se=s(os,"A",{id:!0,class:!0,href:!0});var ur=v(Se);Na=s(ur,"SPAN",{});var hr=v(Na);g(Wn.$$.fragment,hr),hr.forEach(t),ur.forEach(t),$d=i(os),ms=s(os,"SPAN",{"data-svelte-h":!0}),p(ms)!=="svelte-5d00vd"&&(ms.textContent=gp),os.forEach(t),di=i(e),Bn=s(e,"P",{"data-svelte-h":!0}),p(Bn)!=="svelte-15ua0xw"&&(Bn.innerHTML=_p),li=i(e),$e=s(e,"H2",{class:!0});var ss=v($e);Ae=s(ss,"A",{id:!0,class:!0,href:!0});var mr=v(Ae);Va=s(mr,"SPAN",{});var fr=v(Va);g(Hn.$$.fragment,fr),fr.forEach(t),mr.forEach(t),jd=i(ss),fs=s(ss,"SPAN",{"data-svelte-h":!0}),p(fs)!=="svelte-w4zzv6"&&(fs.textContent=Tp),ss.forEach(t),ci=i(e),Rn=s(e,"P",{"data-svelte-h":!0}),p(Rn)!=="svelte-pncau2"&&(Rn.textContent=bp),pi=i(e),g(Nn.$$.fragment,e),ui=i(e),Vn=s(e,"UL",{"data-svelte-h":!0}),p(Vn)!=="svelte-1jp8pm9"&&(Vn.innerHTML=yp),hi=i(e),g(Xn.$$.fragment,e),mi=i(e),En=s(e,"UL",{"data-svelte-h":!0}),p(En)!=="svelte-gl9m62"&&(En.innerHTML=vp),fi=i(e),g(Ln.$$.fragment,e),gi=i(e),Sn=s(e,"UL",{"data-svelte-h":!0}),p(Sn)!=="svelte-1rhxjua"&&(Sn.innerHTML=kp),_i=i(e),g(An.$$.fragment,e),Ti=i(e),Pn=s(e,"UL",{"data-svelte-h":!0}),p(Pn)!=="svelte-tm2vty"&&(Pn.innerHTML=Mp),bi=i(e),g(Qn.$$.fragment,e),yi=i(e),Dn=s(e,"UL",{"data-svelte-h":!0}),p(Dn)!=="svelte-u16gfp"&&(Dn.innerHTML=wp),vi=i(e),g(On.$$.fragment,e),ki=i(e),Yn=s(e,"UL",{"data-svelte-h":!0}),p(Yn)!=="svelte-4w3me4"&&(Yn.innerHTML=xp),Mi=i(e),g(Kn.$$.fragment,e),wi=i(e),eo=s(e,"UL",{"data-svelte-h":!0}),p(eo)!=="svelte-w8a5q6"&&(eo.innerHTML=$p),xi=i(e),to=s(e,"P",{"data-svelte-h":!0}),p(to)!=="svelte-1ov63r3"&&(to.innerHTML=jp),$i=i(e),no=s(e,"UL",{"data-svelte-h":!0}),p(no)!=="svelte-10l9pbe"&&(no.innerHTML=zp),ji=i(e),je=s(e,"H2",{class:!0});var as=v(je);Pe=s(as,"A",{id:!0,class:!0,href:!0});var gr=v(Pe);Xa=s(gr,"SPAN",{});var _r=v(Xa);g(oo.$$.fragment,_r),_r.forEach(t),gr.forEach(t),zd=i(as),gs=s(as,"SPAN",{"data-svelte-h":!0}),p(gs)!=="svelte-1sb3vxe"&&(gs.textContent=Fp),as.forEach(t),zi=i(e),ge=s(e,"DIV",{class:!0});var Ve=v(ge);g(so.$$.fragment,Ve),Fd=i(Ve),_s=s(Ve,"P",{"data-svelte-h":!0}),p(_s)!=="svelte-zu2a9c"&&(_s.innerHTML=Cp),Cd=i(Ve),Ts=s(Ve,"P",{"data-svelte-h":!0}),p(Ts)!=="svelte-10kqkkl"&&(Ts.innerHTML=Jp),Ve.forEach(t),Fi=i(e),ze=s(e,"H2",{class:!0});var rs=v(ze);Qe=s(rs,"A",{id:!0,class:!0,href:!0});var Tr=v(Qe);Ea=s(Tr,"SPAN",{});var br=v(Ea);g(ao.$$.fragment,br),br.forEach(t),Tr.forEach(t),Jd=i(rs),bs=s(rs,"SPAN",{"data-svelte-h":!0}),p(bs)!=="svelte-11kytpf"&&(bs.textContent=Up),rs.forEach(t),Ci=i(e),I=s(e,"DIV",{class:!0});var L=v(I);g(ro.$$.fragment,L),Ud=i(L),ys=s(L,"P",{"data-svelte-h":!0}),p(ys)!=="svelte-pdnetr"&&(ys.innerHTML=qp),qd=i(L),vs=s(L,"P",{"data-svelte-h":!0}),p(vs)!=="svelte-1b0fouy"&&(vs.innerHTML=Ip),Id=i(L),_e=s(L,"DIV",{class:!0});var qa=v(_e);g(io.$$.fragment,qa),Zd=i(qa),ks=s(qa,"P",{"data-svelte-h":!0}),p(ks)!=="svelte-1wjq39d"&&(ks.textContent=Zp),Gd=i(qa),Ms=s(qa,"UL",{"data-svelte-h":!0}),p(Ms)!=="svelte-8gh3n2"&&(Ms.innerHTML=Gp),qa.forEach(t),Wd=i(L),De=s(L,"DIV",{class:!0});var od=v(De);g(lo.$$.fragment,od),Bd=i(od),ws=s(od,"P",{"data-svelte-h":!0}),p(ws)!=="svelte-1f4f5kp"&&(ws.innerHTML=Wp),od.forEach(t),Hd=i(L),Oe=s(L,"DIV",{class:!0});var sd=v(Oe);g(co.$$.fragment,sd),Rd=i(sd),xs=s(sd,"P",{"data-svelte-h":!0}),p(xs)!=="svelte-fl5ab0"&&(xs.textContent=Bp),sd.forEach(t),Nd=i(L),$s=s(L,"DIV",{class:!0});var Lu=v($s);g(po.$$.fragment,Lu),Lu.forEach(t),L.forEach(t),Ji=i(e),Fe=s(e,"H2",{class:!0});var ad=v(Fe);Ye=s(ad,"A",{id:!0,class:!0,href:!0});var Su=v(Ye);La=s(Su,"SPAN",{});var Au=v(La);g(uo.$$.fragment,Au),Au.forEach(t),Su.forEach(t),Vd=i(ad),js=s(ad,"SPAN",{"data-svelte-h":!0}),p(js)!=="svelte-bd65nl"&&(js.textContent=Hp),ad.forEach(t),Ui=i(e),A=s(e,"DIV",{class:!0});var ke=v(A);g(ho.$$.fragment,ke),Xd=i(ke),zs=s(ke,"P",{"data-svelte-h":!0}),p(zs)!=="svelte-gc3mz8"&&(zs.innerHTML=Rp),Ed=i(ke),Fs=s(ke,"P",{"data-svelte-h":!0}),p(Fs)!=="svelte-ttxvs6"&&(Fs.innerHTML=Np),Ld=i(ke),Te=s(ke,"DIV",{class:!0});var Ia=v(Te);g(mo.$$.fragment,Ia),Sd=i(Ia),Cs=s(Ia,"P",{"data-svelte-h":!0}),p(Cs)!=="svelte-1wjq39d"&&(Cs.textContent=Vp),Ad=i(Ia),Js=s(Ia,"UL",{"data-svelte-h":!0}),p(Js)!=="svelte-8gh3n2"&&(Js.innerHTML=Xp),Ia.forEach(t),Pd=i(ke),Ke=s(ke,"DIV",{class:!0});var rd=v(Ke);g(fo.$$.fragment,rd),Qd=i(rd),Us=s(rd,"P",{"data-svelte-h":!0}),p(Us)!=="svelte-fl5ab0"&&(Us.textContent=Ep),rd.forEach(t),ke.forEach(t),qi=i(e),Ce=s(e,"H2",{class:!0});var id=v(Ce);et=s(id,"A",{id:!0,class:!0,href:!0});var Pu=v(et);Sa=s(Pu,"SPAN",{});var Qu=v(Sa);g(go.$$.fragment,Qu),Qu.forEach(t),Pu.forEach(t),Dd=i(id),qs=s(id,"SPAN",{"data-svelte-h":!0}),p(qs)!=="svelte-1if2jnn"&&(qs.textContent=Lp),id.forEach(t),Ii=i(e),R=s(e,"DIV",{class:!0});var de=v(R);g(_o.$$.fragment,de),Od=i(de),Is=s(de,"P",{"data-svelte-h":!0}),p(Is)!=="svelte-s4dp18"&&(Is.textContent=Sp),Yd=i(de),Zs=s(de,"P",{"data-svelte-h":!0}),p(Zs)!=="svelte-x400g0"&&(Zs.innerHTML=Ap),Kd=i(de),Gs=s(de,"P",{"data-svelte-h":!0}),p(Gs)!=="svelte-hmtw9k"&&(Gs.innerHTML=Pp),el=i(de),Ws=s(de,"P",{"data-svelte-h":!0}),p(Ws)!=="svelte-hswkmf"&&(Ws.innerHTML=Qp),tl=i(de),ee=s(de,"DIV",{class:!0});var Nt=v(ee);g(To.$$.fragment,Nt),nl=i(Nt),Bs=s(Nt,"P",{"data-svelte-h":!0}),p(Bs)!=="svelte-ndvewa"&&(Bs.innerHTML=Dp),ol=i(Nt),g(tt.$$.fragment,Nt),sl=i(Nt),g(nt.$$.fragment,Nt),Nt.forEach(t),de.forEach(t),Zi=i(e),Je=s(e,"H2",{class:!0});var dd=v(Je);ot=s(dd,"A",{id:!0,class:!0,href:!0});var Du=v(ot);Aa=s(Du,"SPAN",{});var Ou=v(Aa);g(bo.$$.fragment,Ou),Ou.forEach(t),Du.forEach(t),al=i(dd),Hs=s(dd,"SPAN",{"data-svelte-h":!0}),p(Hs)!=="svelte-1hxbsxh"&&(Hs.textContent=Op),dd.forEach(t),Gi=i(e),N=s(e,"DIV",{class:!0});var le=v(N);g(yo.$$.fragment,le),rl=i(le),Rs=s(le,"P",{"data-svelte-h":!0}),p(Rs)!=="svelte-6hhvcz"&&(Rs.innerHTML=Yp),il=i(le),Ns=s(le,"P",{"data-svelte-h":!0}),p(Ns)!=="svelte-x400g0"&&(Ns.innerHTML=Kp),dl=i(le),Vs=s(le,"P",{"data-svelte-h":!0}),p(Vs)!=="svelte-hmtw9k"&&(Vs.innerHTML=eu),ll=i(le),Xs=s(le,"P",{"data-svelte-h":!0}),p(Xs)!=="svelte-hswkmf"&&(Xs.innerHTML=tu),cl=i(le),te=s(le,"DIV",{class:!0});var Vt=v(te);g(vo.$$.fragment,Vt),pl=i(Vt),Es=s(Vt,"P",{"data-svelte-h":!0}),p(Es)!=="svelte-1lp44va"&&(Es.innerHTML=nu),ul=i(Vt),g(st.$$.fragment,Vt),hl=i(Vt),g(at.$$.fragment,Vt),Vt.forEach(t),le.forEach(t),Wi=i(e),Ue=s(e,"H2",{class:!0});var ld=v(Ue);rt=s(ld,"A",{id:!0,class:!0,href:!0});var Yu=v(rt);Pa=s(Yu,"SPAN",{});var Ku=v(Pa);g(ko.$$.fragment,Ku),Ku.forEach(t),Yu.forEach(t),ml=i(ld),Ls=s(ld,"SPAN",{"data-svelte-h":!0}),p(Ls)!=="svelte-12cu3ez"&&(Ls.textContent=ou),ld.forEach(t),Bi=i(e),V=s(e,"DIV",{class:!0});var ce=v(V);g(Mo.$$.fragment,ce),fl=i(ce),Ss=s(ce,"P",{"data-svelte-h":!0}),p(Ss)!=="svelte-d9ghfc"&&(Ss.textContent=su),gl=i(ce),As=s(ce,"P",{"data-svelte-h":!0}),p(As)!=="svelte-x400g0"&&(As.innerHTML=au),_l=i(ce),Ps=s(ce,"P",{"data-svelte-h":!0}),p(Ps)!=="svelte-hmtw9k"&&(Ps.innerHTML=ru),Tl=i(ce),Qs=s(ce,"P",{"data-svelte-h":!0}),p(Qs)!=="svelte-hswkmf"&&(Qs.innerHTML=iu),bl=i(ce),ne=s(ce,"DIV",{class:!0});var Xt=v(ne);g(wo.$$.fragment,Xt),yl=i(Xt),Ds=s(Xt,"P",{"data-svelte-h":!0}),p(Ds)!=="svelte-1lmqola"&&(Ds.innerHTML=du),vl=i(Xt),g(it.$$.fragment,Xt),kl=i(Xt),g(dt.$$.fragment,Xt),Xt.forEach(t),ce.forEach(t),Hi=i(e),qe=s(e,"H2",{class:!0});var cd=v(qe);lt=s(cd,"A",{id:!0,class:!0,href:!0});var eh=v(lt);Qa=s(eh,"SPAN",{});var th=v(Qa);g(xo.$$.fragment,th),th.forEach(t),eh.forEach(t),Ml=i(cd),Os=s(cd,"SPAN",{"data-svelte-h":!0}),p(Os)!=="svelte-1nqwnzw"&&(Os.textContent=lu),cd.forEach(t),Ri=i(e),X=s(e,"DIV",{class:!0});var pe=v(X);g($o.$$.fragment,pe),wl=i(pe),Ys=s(pe,"P",{"data-svelte-h":!0}),p(Ys)!=="svelte-14cghox"&&(Ys.textContent=cu),xl=i(pe),Ks=s(pe,"P",{"data-svelte-h":!0}),p(Ks)!=="svelte-x400g0"&&(Ks.innerHTML=pu),$l=i(pe),ea=s(pe,"P",{"data-svelte-h":!0}),p(ea)!=="svelte-hmtw9k"&&(ea.innerHTML=uu),jl=i(pe),ta=s(pe,"P",{"data-svelte-h":!0}),p(ta)!=="svelte-hswkmf"&&(ta.innerHTML=hu),zl=i(pe),be=s(pe,"DIV",{class:!0});var Za=v(be);g(jo.$$.fragment,Za),Fl=i(Za),na=s(Za,"P",{"data-svelte-h":!0}),p(na)!=="svelte-vldyni"&&(na.innerHTML=mu),Cl=i(Za),g(ct.$$.fragment,Za),Za.forEach(t),pe.forEach(t),Ni=i(e),Ie=s(e,"H2",{class:!0});var pd=v(Ie);pt=s(pd,"A",{id:!0,class:!0,href:!0});var nh=v(pt);Da=s(nh,"SPAN",{});var oh=v(Da);g(zo.$$.fragment,oh),oh.forEach(t),nh.forEach(t),Jl=i(pd),oa=s(pd,"SPAN",{"data-svelte-h":!0}),p(oa)!=="svelte-19g7rs1"&&(oa.textContent=fu),pd.forEach(t),Vi=i(e),E=s(e,"DIV",{class:!0});var ue=v(E);g(Fo.$$.fragment,ue),Ul=i(ue),sa=s(ue,"P",{"data-svelte-h":!0}),p(sa)!=="svelte-khvqt1"&&(sa.innerHTML=gu),ql=i(ue),aa=s(ue,"P",{"data-svelte-h":!0}),p(aa)!=="svelte-x400g0"&&(aa.innerHTML=_u),Il=i(ue),ra=s(ue,"P",{"data-svelte-h":!0}),p(ra)!=="svelte-hmtw9k"&&(ra.innerHTML=Tu),Zl=i(ue),ia=s(ue,"P",{"data-svelte-h":!0}),p(ia)!=="svelte-hswkmf"&&(ia.innerHTML=bu),Gl=i(ue),ye=s(ue,"DIV",{class:!0});var Ga=v(ye);g(Co.$$.fragment,Ga),Wl=i(Ga),da=s(Ga,"P",{"data-svelte-h":!0}),p(da)!=="svelte-1lifhme"&&(da.innerHTML=yu),Bl=i(Ga),g(ut.$$.fragment,Ga),Ga.forEach(t),ue.forEach(t),Xi=i(e),Ze=s(e,"H2",{class:!0});var ud=v(Ze);ht=s(ud,"A",{id:!0,class:!0,href:!0});var sh=v(ht);Oa=s(sh,"SPAN",{});var ah=v(Oa);g(Jo.$$.fragment,ah),ah.forEach(t),sh.forEach(t),Hl=i(ud),la=s(ud,"SPAN",{"data-svelte-h":!0}),p(la)!=="svelte-dkxirx"&&(la.textContent=vu),ud.forEach(t),Ei=i(e),Z=s(e,"DIV",{class:!0});var P=v(Z);g(Uo.$$.fragment,P),Rl=i(P),ca=s(P,"P",{"data-svelte-h":!0}),p(ca)!=="svelte-2jd6xc"&&(ca.textContent=ku),Nl=i(P),pa=s(P,"P",{"data-svelte-h":!0}),p(pa)!=="svelte-x400g0"&&(pa.innerHTML=Mu),Vl=i(P),ua=s(P,"P",{"data-svelte-h":!0}),p(ua)!=="svelte-1i0vt4o"&&(ua.innerHTML=wu),Xl=i(P),ha=s(P,"P",{"data-svelte-h":!0}),p(ha)!=="svelte-1ivrf8m"&&(ha.innerHTML=xu),El=i(P),g(mt.$$.fragment,P),Ll=i(P),oe=s(P,"DIV",{class:!0});var Et=v(oe);g(qo.$$.fragment,Et),Sl=i(Et),ma=s(Et,"P",{"data-svelte-h":!0}),p(ma)!=="svelte-4tga86"&&(ma.innerHTML=$u),Al=i(Et),g(ft.$$.fragment,Et),Pl=i(Et),g(gt.$$.fragment,Et),Et.forEach(t),P.forEach(t),Li=i(e),Ge=s(e,"H2",{class:!0});var hd=v(Ge);_t=s(hd,"A",{id:!0,class:!0,href:!0});var rh=v(_t);Ya=s(rh,"SPAN",{});var ih=v(Ya);g(Io.$$.fragment,ih),ih.forEach(t),rh.forEach(t),Ql=i(hd),fa=s(hd,"SPAN",{"data-svelte-h":!0}),p(fa)!=="svelte-12wkmi3"&&(fa.textContent=ju),hd.forEach(t),Si=i(e),G=s(e,"DIV",{class:!0});var Q=v(G);g(Zo.$$.fragment,Q),Dl=i(Q),ga=s(Q,"P",{"data-svelte-h":!0}),p(ga)!=="svelte-6hhvcz"&&(ga.innerHTML=zu),Ol=i(Q),_a=s(Q,"P",{"data-svelte-h":!0}),p(_a)!=="svelte-x400g0"&&(_a.innerHTML=Fu),Yl=i(Q),Ta=s(Q,"P",{"data-svelte-h":!0}),p(Ta)!=="svelte-1i0vt4o"&&(Ta.innerHTML=Cu),Kl=i(Q),ba=s(Q,"P",{"data-svelte-h":!0}),p(ba)!=="svelte-1ivrf8m"&&(ba.innerHTML=Ju),ec=i(Q),g(Tt.$$.fragment,Q),tc=i(Q),se=s(Q,"DIV",{class:!0});var Lt=v(se);g(Go.$$.fragment,Lt),nc=i(Lt),ya=s(Lt,"P",{"data-svelte-h":!0}),p(ya)!=="svelte-3fifoa"&&(ya.innerHTML=Uu),oc=i(Lt),g(bt.$$.fragment,Lt),sc=i(Lt),g(yt.$$.fragment,Lt),Lt.forEach(t),Q.forEach(t),Ai=i(e),We=s(e,"H2",{class:!0});var md=v(We);vt=s(md,"A",{id:!0,class:!0,href:!0});var dh=v(vt);Ka=s(dh,"SPAN",{});var lh=v(Ka);g(Wo.$$.fragment,lh),lh.forEach(t),dh.forEach(t),ac=i(md),va=s(md,"SPAN",{"data-svelte-h":!0}),p(va)!=="svelte-tfgsnp"&&(va.textContent=qu),md.forEach(t),Pi=i(e),W=s(e,"DIV",{class:!0});var D=v(W);g(Bo.$$.fragment,D),rc=i(D),ka=s(D,"P",{"data-svelte-h":!0}),p(ka)!=="svelte-hvu8fo"&&(ka.textContent=Iu),ic=i(D),Ma=s(D,"P",{"data-svelte-h":!0}),p(Ma)!=="svelte-x400g0"&&(Ma.innerHTML=Zu),dc=i(D),wa=s(D,"P",{"data-svelte-h":!0}),p(wa)!=="svelte-1i0vt4o"&&(wa.innerHTML=Gu),lc=i(D),xa=s(D,"P",{"data-svelte-h":!0}),p(xa)!=="svelte-1ivrf8m"&&(xa.innerHTML=Wu),cc=i(D),g(kt.$$.fragment,D),pc=i(D),ae=s(D,"DIV",{class:!0});var St=v(ae);g(Ho.$$.fragment,St),uc=i(St),$a=s(St,"P",{"data-svelte-h":!0}),p($a)!=="svelte-umqwni"&&($a.innerHTML=Bu),hc=i(St),g(Mt.$$.fragment,St),mc=i(St),g(wt.$$.fragment,St),St.forEach(t),D.forEach(t),Qi=i(e),Be=s(e,"H2",{class:!0});var fd=v(Be);xt=s(fd,"A",{id:!0,class:!0,href:!0});var ch=v(xt);er=s(ch,"SPAN",{});var ph=v(er);g(Ro.$$.fragment,ph),ph.forEach(t),ch.forEach(t),fc=i(fd),ja=s(fd,"SPAN",{"data-svelte-h":!0}),p(ja)!=="svelte-iqjfiq"&&(ja.textContent=Hu),fd.forEach(t),Di=i(e),Y=s(e,"DIV",{class:!0});var At=v(Y);g(No.$$.fragment,At),gc=i(At),re=s(At,"DIV",{class:!0});var Pt=v(re);g(Vo.$$.fragment,Pt),_c=i(Pt),za=s(Pt,"P",{"data-svelte-h":!0}),p(za)!=="svelte-w4u0pe"&&(za.innerHTML=Ru),Tc=i(Pt),g($t.$$.fragment,Pt),bc=i(Pt),g(jt.$$.fragment,Pt),Pt.forEach(t),yc=i(At),zt=s(At,"DIV",{class:!0});var gd=v(zt);g(Xo.$$.fragment,gd),vc=i(gd),g(Ft.$$.fragment,gd),gd.forEach(t),kc=i(At),Ct=s(At,"DIV",{class:!0});var _d=v(Ct);g(Eo.$$.fragment,_d),Mc=i(_d),g(Jt.$$.fragment,_d),_d.forEach(t),At.forEach(t),Oi=i(e),He=s(e,"H2",{class:!0});var Td=v(He);Ut=s(Td,"A",{id:!0,class:!0,href:!0});var uh=v(Ut);tr=s(uh,"SPAN",{});var hh=v(tr);g(Lo.$$.fragment,hh),hh.forEach(t),uh.forEach(t),wc=i(Td),Fa=s(Td,"SPAN",{"data-svelte-h":!0}),p(Fa)!=="svelte-1aujpg8"&&(Fa.textContent=Nu),Td.forEach(t),Yi=i(e),K=s(e,"DIV",{class:!0});var Qt=v(K);g(So.$$.fragment,Qt),xc=i(Qt),ie=s(Qt,"DIV",{class:!0});var Dt=v(ie);g(Ao.$$.fragment,Dt),$c=i(Dt),Ca=s(Dt,"P",{"data-svelte-h":!0}),p(Ca)!=="svelte-w4u0pe"&&(Ca.innerHTML=Vu),jc=i(Dt),g(qt.$$.fragment,Dt),zc=i(Dt),g(It.$$.fragment,Dt),Dt.forEach(t),Fc=i(Qt),Zt=s(Qt,"DIV",{class:!0});var bd=v(Zt);g(Po.$$.fragment,bd),Cc=i(bd),g(Gt.$$.fragment,bd),bd.forEach(t),Jc=i(Qt),Wt=s(Qt,"DIV",{class:!0});var yd=v(Wt);g(Qo.$$.fragment,yd),Uc=i(yd),g(Bt.$$.fragment,yd),yd.forEach(t),Qt.forEach(t),Ki=i(e),Re=s(e,"H2",{class:!0});var vd=v(Re);Ht=s(vd,"A",{id:!0,class:!0,href:!0});var mh=v(Ht);nr=s(mh,"SPAN",{});var fh=v(nr);g(Do.$$.fragment,fh),fh.forEach(t),mh.forEach(t),qc=i(vd),Ja=s(vd,"SPAN",{"data-svelte-h":!0}),p(Ja)!=="svelte-ttmxwa"&&(Ja.textContent=Xu),vd.forEach(t),ed=i(e),Ne=s(e,"DIV",{class:!0});var kd=v(Ne);g(Oo.$$.fragment,kd),Ic=i(kd),ve=s(kd,"DIV",{class:!0});var Wa=v(ve);g(Yo.$$.fragment,Wa),Zc=i(Wa),Ua=s(Wa,"P",{"data-svelte-h":!0}),p(Ua)!=="svelte-1wekn6c"&&(Ua.innerHTML=Eu),Gc=i(Wa),g(Rt.$$.fragment,Wa),Wa.forEach(t),kd.forEach(t),td=i(e),or=s(e,"P",{}),v(or).forEach(t),this.h()},h(){m(l,"name","hf:doc:metadata"),m(l,"content",JSON.stringify(Ph)),m(c,"id","t5"),m(c,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(c,"href","#t5"),m(M,"class","relative group"),m(F,"class","flex flex-wrap space-x-1"),m(Xe,"id","overview"),m(Xe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(Xe,"href","#overview"),m(j,"class","relative group"),m(ls,"id","training"),m(Ee,"id","training"),m(Ee,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(Ee,"href","#training"),m(Me,"class","relative group"),m(ps,"id","inference"),m(Le,"id","inference"),m(Le,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(Le,"href","#inference"),m(we,"class","relative group"),m(hs,"id","scripts"),m(Se,"id","performance"),m(Se,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(Se,"href","#performance"),m(xe,"class","relative group"),m(Ae,"id","resources"),m(Ae,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(Ae,"href","#resources"),m($e,"class","relative group"),m(Pe,"id","transformers.T5Config"),m(Pe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(Pe,"href","#transformers.T5Config"),m(je,"class","relative group"),m(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(Qe,"id","transformers.T5Tokenizer"),m(Qe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(Qe,"href","#transformers.T5Tokenizer"),m(ze,"class","relative group"),m(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m($s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(Ye,"id","transformers.T5TokenizerFast"),m(Ye,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(Ye,"href","#transformers.T5TokenizerFast"),m(Fe,"class","relative group"),m(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(et,"id","transformers.T5Model"),m(et,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(et,"href","#transformers.T5Model"),m(Ce,"class","relative group"),m(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(ot,"id","transformers.T5ForConditionalGeneration"),m(ot,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(ot,"href","#transformers.T5ForConditionalGeneration"),m(Je,"class","relative group"),m(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(rt,"id","transformers.T5EncoderModel"),m(rt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(rt,"href","#transformers.T5EncoderModel"),m(Ue,"class","relative group"),m(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(lt,"id","transformers.T5ForSequenceClassification"),m(lt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(lt,"href","#transformers.T5ForSequenceClassification"),m(qe,"class","relative group"),m(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(pt,"id","transformers.T5ForQuestionAnswering"),m(pt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(pt,"href","#transformers.T5ForQuestionAnswering"),m(Ie,"class","relative group"),m(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(ht,"id","transformers.TFT5Model"),m(ht,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(ht,"href","#transformers.TFT5Model"),m(Ze,"class","relative group"),m(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(_t,"id","transformers.TFT5ForConditionalGeneration"),m(_t,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(_t,"href","#transformers.TFT5ForConditionalGeneration"),m(Ge,"class","relative group"),m(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(vt,"id","transformers.TFT5EncoderModel"),m(vt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(vt,"href","#transformers.TFT5EncoderModel"),m(We,"class","relative group"),m(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(xt,"id","transformers.FlaxT5Model"),m(xt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(xt,"href","#transformers.FlaxT5Model"),m(Be,"class","relative group"),m(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(Ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(Ut,"id","transformers.FlaxT5ForConditionalGeneration"),m(Ut,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(Ut,"href","#transformers.FlaxT5ForConditionalGeneration"),m(He,"class","relative group"),m(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(Zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(Wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(Ht,"id","transformers.FlaxT5EncoderModel"),m(Ht,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(Ht,"href","#transformers.FlaxT5EncoderModel"),m(Re,"class","relative group"),m(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){n(document.head,l),d(e,k,a),d(e,u,a),d(e,h,a),d(e,M,a),n(M,c),n(c,w),_(S,w,null),n(M,B),n(M,C),d(e,q,a),d(e,F,a),d(e,x,a),d(e,j,a),n(j,Xe),n(Xe,Ba),_(Ot,Ba,null),n(j,Md),n(j,ds),d(e,yr,a),d(e,Yt,a),d(e,vr,a),d(e,Kt,a),d(e,kr,a),d(e,en,a),d(e,Mr,a),d(e,tn,a),d(e,wr,a),d(e,nn,a),d(e,xr,a),d(e,on,a),d(e,$r,a),d(e,sn,a),d(e,jr,a),d(e,an,a),d(e,zr,a),d(e,rn,a),d(e,Fr,a),d(e,dn,a),d(e,Cr,a),d(e,ln,a),d(e,Jr,a),d(e,ls,a),d(e,Ur,a),d(e,Me,a),n(Me,Ee),n(Ee,Ha),_(cn,Ha,null),n(Me,wd),n(Me,cs),d(e,qr,a),d(e,pn,a),d(e,Ir,a),d(e,un,a),d(e,Zr,a),d(e,hn,a),d(e,Gr,a),d(e,mn,a),d(e,Wr,a),d(e,fn,a),d(e,Br,a),_(gn,e,a),d(e,Hr,a),d(e,_n,a),d(e,Rr,a),d(e,Tn,a),d(e,Nr,a),d(e,bn,a),d(e,Vr,a),_(yn,e,a),d(e,Xr,a),d(e,vn,a),d(e,Er,a),d(e,kn,a),d(e,Lr,a),d(e,Mn,a),d(e,Sr,a),_(wn,e,a),d(e,Ar,a),d(e,xn,a),d(e,Pr,a),d(e,$n,a),d(e,Qr,a),d(e,jn,a),d(e,Dr,a),d(e,zn,a),d(e,Or,a),d(e,ps,a),d(e,Yr,a),d(e,we,a),n(we,Le),n(Le,Ra),_(Fn,Ra,null),n(we,xd),n(we,us),d(e,Kr,a),d(e,Cn,a),d(e,ei,a),_(Jn,e,a),d(e,ti,a),d(e,Un,a),d(e,ni,a),d(e,qn,a),d(e,oi,a),_(In,e,a),d(e,si,a),d(e,Zn,a),d(e,ai,a),_(Gn,e,a),d(e,ri,a),d(e,hs,a),d(e,ii,a),d(e,xe,a),n(xe,Se),n(Se,Na),_(Wn,Na,null),n(xe,$d),n(xe,ms),d(e,di,a),d(e,Bn,a),d(e,li,a),d(e,$e,a),n($e,Ae),n(Ae,Va),_(Hn,Va,null),n($e,jd),n($e,fs),d(e,ci,a),d(e,Rn,a),d(e,pi,a),_(Nn,e,a),d(e,ui,a),d(e,Vn,a),d(e,hi,a),_(Xn,e,a),d(e,mi,a),d(e,En,a),d(e,fi,a),_(Ln,e,a),d(e,gi,a),d(e,Sn,a),d(e,_i,a),_(An,e,a),d(e,Ti,a),d(e,Pn,a),d(e,bi,a),_(Qn,e,a),d(e,yi,a),d(e,Dn,a),d(e,vi,a),_(On,e,a),d(e,ki,a),d(e,Yn,a),d(e,Mi,a),_(Kn,e,a),d(e,wi,a),d(e,eo,a),d(e,xi,a),d(e,to,a),d(e,$i,a),d(e,no,a),d(e,ji,a),d(e,je,a),n(je,Pe),n(Pe,Xa),_(oo,Xa,null),n(je,zd),n(je,gs),d(e,zi,a),d(e,ge,a),_(so,ge,null),n(ge,Fd),n(ge,_s),n(ge,Cd),n(ge,Ts),d(e,Fi,a),d(e,ze,a),n(ze,Qe),n(Qe,Ea),_(ao,Ea,null),n(ze,Jd),n(ze,bs),d(e,Ci,a),d(e,I,a),_(ro,I,null),n(I,Ud),n(I,ys),n(I,qd),n(I,vs),n(I,Id),n(I,_e),_(io,_e,null),n(_e,Zd),n(_e,ks),n(_e,Gd),n(_e,Ms),n(I,Wd),n(I,De),_(lo,De,null),n(De,Bd),n(De,ws),n(I,Hd),n(I,Oe),_(co,Oe,null),n(Oe,Rd),n(Oe,xs),n(I,Nd),n(I,$s),_(po,$s,null),d(e,Ji,a),d(e,Fe,a),n(Fe,Ye),n(Ye,La),_(uo,La,null),n(Fe,Vd),n(Fe,js),d(e,Ui,a),d(e,A,a),_(ho,A,null),n(A,Xd),n(A,zs),n(A,Ed),n(A,Fs),n(A,Ld),n(A,Te),_(mo,Te,null),n(Te,Sd),n(Te,Cs),n(Te,Ad),n(Te,Js),n(A,Pd),n(A,Ke),_(fo,Ke,null),n(Ke,Qd),n(Ke,Us),d(e,qi,a),d(e,Ce,a),n(Ce,et),n(et,Sa),_(go,Sa,null),n(Ce,Dd),n(Ce,qs),d(e,Ii,a),d(e,R,a),_(_o,R,null),n(R,Od),n(R,Is),n(R,Yd),n(R,Zs),n(R,Kd),n(R,Gs),n(R,el),n(R,Ws),n(R,tl),n(R,ee),_(To,ee,null),n(ee,nl),n(ee,Bs),n(ee,ol),_(tt,ee,null),n(ee,sl),_(nt,ee,null),d(e,Zi,a),d(e,Je,a),n(Je,ot),n(ot,Aa),_(bo,Aa,null),n(Je,al),n(Je,Hs),d(e,Gi,a),d(e,N,a),_(yo,N,null),n(N,rl),n(N,Rs),n(N,il),n(N,Ns),n(N,dl),n(N,Vs),n(N,ll),n(N,Xs),n(N,cl),n(N,te),_(vo,te,null),n(te,pl),n(te,Es),n(te,ul),_(st,te,null),n(te,hl),_(at,te,null),d(e,Wi,a),d(e,Ue,a),n(Ue,rt),n(rt,Pa),_(ko,Pa,null),n(Ue,ml),n(Ue,Ls),d(e,Bi,a),d(e,V,a),_(Mo,V,null),n(V,fl),n(V,Ss),n(V,gl),n(V,As),n(V,_l),n(V,Ps),n(V,Tl),n(V,Qs),n(V,bl),n(V,ne),_(wo,ne,null),n(ne,yl),n(ne,Ds),n(ne,vl),_(it,ne,null),n(ne,kl),_(dt,ne,null),d(e,Hi,a),d(e,qe,a),n(qe,lt),n(lt,Qa),_(xo,Qa,null),n(qe,Ml),n(qe,Os),d(e,Ri,a),d(e,X,a),_($o,X,null),n(X,wl),n(X,Ys),n(X,xl),n(X,Ks),n(X,$l),n(X,ea),n(X,jl),n(X,ta),n(X,zl),n(X,be),_(jo,be,null),n(be,Fl),n(be,na),n(be,Cl),_(ct,be,null),d(e,Ni,a),d(e,Ie,a),n(Ie,pt),n(pt,Da),_(zo,Da,null),n(Ie,Jl),n(Ie,oa),d(e,Vi,a),d(e,E,a),_(Fo,E,null),n(E,Ul),n(E,sa),n(E,ql),n(E,aa),n(E,Il),n(E,ra),n(E,Zl),n(E,ia),n(E,Gl),n(E,ye),_(Co,ye,null),n(ye,Wl),n(ye,da),n(ye,Bl),_(ut,ye,null),d(e,Xi,a),d(e,Ze,a),n(Ze,ht),n(ht,Oa),_(Jo,Oa,null),n(Ze,Hl),n(Ze,la),d(e,Ei,a),d(e,Z,a),_(Uo,Z,null),n(Z,Rl),n(Z,ca),n(Z,Nl),n(Z,pa),n(Z,Vl),n(Z,ua),n(Z,Xl),n(Z,ha),n(Z,El),_(mt,Z,null),n(Z,Ll),n(Z,oe),_(qo,oe,null),n(oe,Sl),n(oe,ma),n(oe,Al),_(ft,oe,null),n(oe,Pl),_(gt,oe,null),d(e,Li,a),d(e,Ge,a),n(Ge,_t),n(_t,Ya),_(Io,Ya,null),n(Ge,Ql),n(Ge,fa),d(e,Si,a),d(e,G,a),_(Zo,G,null),n(G,Dl),n(G,ga),n(G,Ol),n(G,_a),n(G,Yl),n(G,Ta),n(G,Kl),n(G,ba),n(G,ec),_(Tt,G,null),n(G,tc),n(G,se),_(Go,se,null),n(se,nc),n(se,ya),n(se,oc),_(bt,se,null),n(se,sc),_(yt,se,null),d(e,Ai,a),d(e,We,a),n(We,vt),n(vt,Ka),_(Wo,Ka,null),n(We,ac),n(We,va),d(e,Pi,a),d(e,W,a),_(Bo,W,null),n(W,rc),n(W,ka),n(W,ic),n(W,Ma),n(W,dc),n(W,wa),n(W,lc),n(W,xa),n(W,cc),_(kt,W,null),n(W,pc),n(W,ae),_(Ho,ae,null),n(ae,uc),n(ae,$a),n(ae,hc),_(Mt,ae,null),n(ae,mc),_(wt,ae,null),d(e,Qi,a),d(e,Be,a),n(Be,xt),n(xt,er),_(Ro,er,null),n(Be,fc),n(Be,ja),d(e,Di,a),d(e,Y,a),_(No,Y,null),n(Y,gc),n(Y,re),_(Vo,re,null),n(re,_c),n(re,za),n(re,Tc),_($t,re,null),n(re,bc),_(jt,re,null),n(Y,yc),n(Y,zt),_(Xo,zt,null),n(zt,vc),_(Ft,zt,null),n(Y,kc),n(Y,Ct),_(Eo,Ct,null),n(Ct,Mc),_(Jt,Ct,null),d(e,Oi,a),d(e,He,a),n(He,Ut),n(Ut,tr),_(Lo,tr,null),n(He,wc),n(He,Fa),d(e,Yi,a),d(e,K,a),_(So,K,null),n(K,xc),n(K,ie),_(Ao,ie,null),n(ie,$c),n(ie,Ca),n(ie,jc),_(qt,ie,null),n(ie,zc),_(It,ie,null),n(K,Fc),n(K,Zt),_(Po,Zt,null),n(Zt,Cc),_(Gt,Zt,null),n(K,Jc),n(K,Wt),_(Qo,Wt,null),n(Wt,Uc),_(Bt,Wt,null),d(e,Ki,a),d(e,Re,a),n(Re,Ht),n(Ht,nr),_(Do,nr,null),n(Re,qc),n(Re,Ja),d(e,ed,a),d(e,Ne,a),_(Oo,Ne,null),n(Ne,Ic),n(Ne,ve),_(Yo,ve,null),n(ve,Zc),n(ve,Ua),n(ve,Gc),_(Rt,ve,null),d(e,td,a),d(e,or,a),nd=!0},p(e,[a]){const Ko={};a&2&&(Ko.$$scope={dirty:a,ctx:e}),tt.$set(Ko);const sr={};a&2&&(sr.$$scope={dirty:a,ctx:e}),nt.$set(sr);const ar={};a&2&&(ar.$$scope={dirty:a,ctx:e}),st.$set(ar);const es={};a&2&&(es.$$scope={dirty:a,ctx:e}),at.$set(es);const rr={};a&2&&(rr.$$scope={dirty:a,ctx:e}),it.$set(rr);const ir={};a&2&&(ir.$$scope={dirty:a,ctx:e}),dt.$set(ir);const ts={};a&2&&(ts.$$scope={dirty:a,ctx:e}),ct.$set(ts);const dr={};a&2&&(dr.$$scope={dirty:a,ctx:e}),ut.$set(dr);const lr={};a&2&&(lr.$$scope={dirty:a,ctx:e}),mt.$set(lr);const ns={};a&2&&(ns.$$scope={dirty:a,ctx:e}),ft.$set(ns);const cr={};a&2&&(cr.$$scope={dirty:a,ctx:e}),gt.$set(cr);const pr={};a&2&&(pr.$$scope={dirty:a,ctx:e}),Tt.$set(pr);const os={};a&2&&(os.$$scope={dirty:a,ctx:e}),bt.$set(os);const ur={};a&2&&(ur.$$scope={dirty:a,ctx:e}),yt.$set(ur);const hr={};a&2&&(hr.$$scope={dirty:a,ctx:e}),kt.$set(hr);const ss={};a&2&&(ss.$$scope={dirty:a,ctx:e}),Mt.$set(ss);const mr={};a&2&&(mr.$$scope={dirty:a,ctx:e}),wt.$set(mr);const fr={};a&2&&(fr.$$scope={dirty:a,ctx:e}),$t.$set(fr);const as={};a&2&&(as.$$scope={dirty:a,ctx:e}),jt.$set(as);const gr={};a&2&&(gr.$$scope={dirty:a,ctx:e}),Ft.$set(gr);const _r={};a&2&&(_r.$$scope={dirty:a,ctx:e}),Jt.$set(_r);const Ve={};a&2&&(Ve.$$scope={dirty:a,ctx:e}),qt.$set(Ve);const rs={};a&2&&(rs.$$scope={dirty:a,ctx:e}),It.$set(rs);const Tr={};a&2&&(Tr.$$scope={dirty:a,ctx:e}),Gt.$set(Tr);const br={};a&2&&(br.$$scope={dirty:a,ctx:e}),Bt.$set(br);const L={};a&2&&(L.$$scope={dirty:a,ctx:e}),Rt.$set(L)},i(e){nd||(T(S.$$.fragment,e),T(Ot.$$.fragment,e),T(cn.$$.fragment,e),T(gn.$$.fragment,e),T(yn.$$.fragment,e),T(wn.$$.fragment,e),T(Fn.$$.fragment,e),T(Jn.$$.fragment,e),T(In.$$.fragment,e),T(Gn.$$.fragment,e),T(Wn.$$.fragment,e),T(Hn.$$.fragment,e),T(Nn.$$.fragment,e),T(Xn.$$.fragment,e),T(Ln.$$.fragment,e),T(An.$$.fragment,e),T(Qn.$$.fragment,e),T(On.$$.fragment,e),T(Kn.$$.fragment,e),T(oo.$$.fragment,e),T(so.$$.fragment,e),T(ao.$$.fragment,e),T(ro.$$.fragment,e),T(io.$$.fragment,e),T(lo.$$.fragment,e),T(co.$$.fragment,e),T(po.$$.fragment,e),T(uo.$$.fragment,e),T(ho.$$.fragment,e),T(mo.$$.fragment,e),T(fo.$$.fragment,e),T(go.$$.fragment,e),T(_o.$$.fragment,e),T(To.$$.fragment,e),T(tt.$$.fragment,e),T(nt.$$.fragment,e),T(bo.$$.fragment,e),T(yo.$$.fragment,e),T(vo.$$.fragment,e),T(st.$$.fragment,e),T(at.$$.fragment,e),T(ko.$$.fragment,e),T(Mo.$$.fragment,e),T(wo.$$.fragment,e),T(it.$$.fragment,e),T(dt.$$.fragment,e),T(xo.$$.fragment,e),T($o.$$.fragment,e),T(jo.$$.fragment,e),T(ct.$$.fragment,e),T(zo.$$.fragment,e),T(Fo.$$.fragment,e),T(Co.$$.fragment,e),T(ut.$$.fragment,e),T(Jo.$$.fragment,e),T(Uo.$$.fragment,e),T(mt.$$.fragment,e),T(qo.$$.fragment,e),T(ft.$$.fragment,e),T(gt.$$.fragment,e),T(Io.$$.fragment,e),T(Zo.$$.fragment,e),T(Tt.$$.fragment,e),T(Go.$$.fragment,e),T(bt.$$.fragment,e),T(yt.$$.fragment,e),T(Wo.$$.fragment,e),T(Bo.$$.fragment,e),T(kt.$$.fragment,e),T(Ho.$$.fragment,e),T(Mt.$$.fragment,e),T(wt.$$.fragment,e),T(Ro.$$.fragment,e),T(No.$$.fragment,e),T(Vo.$$.fragment,e),T($t.$$.fragment,e),T(jt.$$.fragment,e),T(Xo.$$.fragment,e),T(Ft.$$.fragment,e),T(Eo.$$.fragment,e),T(Jt.$$.fragment,e),T(Lo.$$.fragment,e),T(So.$$.fragment,e),T(Ao.$$.fragment,e),T(qt.$$.fragment,e),T(It.$$.fragment,e),T(Po.$$.fragment,e),T(Gt.$$.fragment,e),T(Qo.$$.fragment,e),T(Bt.$$.fragment,e),T(Do.$$.fragment,e),T(Oo.$$.fragment,e),T(Yo.$$.fragment,e),T(Rt.$$.fragment,e),nd=!0)},o(e){b(S.$$.fragment,e),b(Ot.$$.fragment,e),b(cn.$$.fragment,e),b(gn.$$.fragment,e),b(yn.$$.fragment,e),b(wn.$$.fragment,e),b(Fn.$$.fragment,e),b(Jn.$$.fragment,e),b(In.$$.fragment,e),b(Gn.$$.fragment,e),b(Wn.$$.fragment,e),b(Hn.$$.fragment,e),b(Nn.$$.fragment,e),b(Xn.$$.fragment,e),b(Ln.$$.fragment,e),b(An.$$.fragment,e),b(Qn.$$.fragment,e),b(On.$$.fragment,e),b(Kn.$$.fragment,e),b(oo.$$.fragment,e),b(so.$$.fragment,e),b(ao.$$.fragment,e),b(ro.$$.fragment,e),b(io.$$.fragment,e),b(lo.$$.fragment,e),b(co.$$.fragment,e),b(po.$$.fragment,e),b(uo.$$.fragment,e),b(ho.$$.fragment,e),b(mo.$$.fragment,e),b(fo.$$.fragment,e),b(go.$$.fragment,e),b(_o.$$.fragment,e),b(To.$$.fragment,e),b(tt.$$.fragment,e),b(nt.$$.fragment,e),b(bo.$$.fragment,e),b(yo.$$.fragment,e),b(vo.$$.fragment,e),b(st.$$.fragment,e),b(at.$$.fragment,e),b(ko.$$.fragment,e),b(Mo.$$.fragment,e),b(wo.$$.fragment,e),b(it.$$.fragment,e),b(dt.$$.fragment,e),b(xo.$$.fragment,e),b($o.$$.fragment,e),b(jo.$$.fragment,e),b(ct.$$.fragment,e),b(zo.$$.fragment,e),b(Fo.$$.fragment,e),b(Co.$$.fragment,e),b(ut.$$.fragment,e),b(Jo.$$.fragment,e),b(Uo.$$.fragment,e),b(mt.$$.fragment,e),b(qo.$$.fragment,e),b(ft.$$.fragment,e),b(gt.$$.fragment,e),b(Io.$$.fragment,e),b(Zo.$$.fragment,e),b(Tt.$$.fragment,e),b(Go.$$.fragment,e),b(bt.$$.fragment,e),b(yt.$$.fragment,e),b(Wo.$$.fragment,e),b(Bo.$$.fragment,e),b(kt.$$.fragment,e),b(Ho.$$.fragment,e),b(Mt.$$.fragment,e),b(wt.$$.fragment,e),b(Ro.$$.fragment,e),b(No.$$.fragment,e),b(Vo.$$.fragment,e),b($t.$$.fragment,e),b(jt.$$.fragment,e),b(Xo.$$.fragment,e),b(Ft.$$.fragment,e),b(Eo.$$.fragment,e),b(Jt.$$.fragment,e),b(Lo.$$.fragment,e),b(So.$$.fragment,e),b(Ao.$$.fragment,e),b(qt.$$.fragment,e),b(It.$$.fragment,e),b(Po.$$.fragment,e),b(Gt.$$.fragment,e),b(Qo.$$.fragment,e),b(Bt.$$.fragment,e),b(Do.$$.fragment,e),b(Oo.$$.fragment,e),b(Yo.$$.fragment,e),b(Rt.$$.fragment,e),nd=!1},d(e){e&&(t(k),t(u),t(h),t(M),t(q),t(F),t(x),t(j),t(yr),t(Yt),t(vr),t(Kt),t(kr),t(en),t(Mr),t(tn),t(wr),t(nn),t(xr),t(on),t($r),t(sn),t(jr),t(an),t(zr),t(rn),t(Fr),t(dn),t(Cr),t(ln),t(Jr),t(ls),t(Ur),t(Me),t(qr),t(pn),t(Ir),t(un),t(Zr),t(hn),t(Gr),t(mn),t(Wr),t(fn),t(Br),t(Hr),t(_n),t(Rr),t(Tn),t(Nr),t(bn),t(Vr),t(Xr),t(vn),t(Er),t(kn),t(Lr),t(Mn),t(Sr),t(Ar),t(xn),t(Pr),t($n),t(Qr),t(jn),t(Dr),t(zn),t(Or),t(ps),t(Yr),t(we),t(Kr),t(Cn),t(ei),t(ti),t(Un),t(ni),t(qn),t(oi),t(si),t(Zn),t(ai),t(ri),t(hs),t(ii),t(xe),t(di),t(Bn),t(li),t($e),t(ci),t(Rn),t(pi),t(ui),t(Vn),t(hi),t(mi),t(En),t(fi),t(gi),t(Sn),t(_i),t(Ti),t(Pn),t(bi),t(yi),t(Dn),t(vi),t(ki),t(Yn),t(Mi),t(wi),t(eo),t(xi),t(to),t($i),t(no),t(ji),t(je),t(zi),t(ge),t(Fi),t(ze),t(Ci),t(I),t(Ji),t(Fe),t(Ui),t(A),t(qi),t(Ce),t(Ii),t(R),t(Zi),t(Je),t(Gi),t(N),t(Wi),t(Ue),t(Bi),t(V),t(Hi),t(qe),t(Ri),t(X),t(Ni),t(Ie),t(Vi),t(E),t(Xi),t(Ze),t(Ei),t(Z),t(Li),t(Ge),t(Si),t(G),t(Ai),t(We),t(Pi),t(W),t(Qi),t(Be),t(Di),t(Y),t(Oi),t(He),t(Yi),t(K),t(Ki),t(Re),t(ed),t(Ne),t(td),t(or)),t(l),y(S),y(Ot),y(cn),y(gn,e),y(yn,e),y(wn,e),y(Fn),y(Jn,e),y(In,e),y(Gn,e),y(Wn),y(Hn),y(Nn,e),y(Xn,e),y(Ln,e),y(An,e),y(Qn,e),y(On,e),y(Kn,e),y(oo),y(so),y(ao),y(ro),y(io),y(lo),y(co),y(po),y(uo),y(ho),y(mo),y(fo),y(go),y(_o),y(To),y(tt),y(nt),y(bo),y(yo),y(vo),y(st),y(at),y(ko),y(Mo),y(wo),y(it),y(dt),y(xo),y($o),y(jo),y(ct),y(zo),y(Fo),y(Co),y(ut),y(Jo),y(Uo),y(mt),y(qo),y(ft),y(gt),y(Io),y(Zo),y(Tt),y(Go),y(bt),y(yt),y(Wo),y(Bo),y(kt),y(Ho),y(Mt),y(wt),y(Ro),y(No),y(Vo),y($t),y(jt),y(Xo),y(Ft),y(Eo),y(Jt),y(Lo),y(So),y(Ao),y(qt),y(It),y(Po),y(Gt),y(Qo),y(Bt),y(Do),y(Oo),y(Yo),y(Rt)}}}const Ph={local:"t5",sections:[{local:"overview",title:"Overview"},{local:"training",title:"Training"},{local:"inference",title:"Inference"},{local:"performance",title:"Performance"},{local:"resources",title:"Resources"},{local:"transformers.T5Config",title:"T5Config"},{local:"transformers.T5Tokenizer",title:"T5Tokenizer"},{local:"transformers.T5TokenizerFast",title:"T5TokenizerFast"},{local:"transformers.T5Model",title:"T5Model"},{local:"transformers.T5ForConditionalGeneration",title:"T5ForConditionalGeneration"},{local:"transformers.T5EncoderModel",title:"T5EncoderModel"},{local:"transformers.T5ForSequenceClassification",title:"T5ForSequenceClassification"},{local:"transformers.T5ForQuestionAnswering",title:"T5ForQuestionAnswering"},{local:"transformers.TFT5Model",title:"TFT5Model"},{local:"transformers.TFT5ForConditionalGeneration",title:"TFT5ForConditionalGeneration"},{local:"transformers.TFT5EncoderModel",title:"TFT5EncoderModel"},{local:"transformers.FlaxT5Model",title:"FlaxT5Model"},{local:"transformers.FlaxT5ForConditionalGeneration",title:"FlaxT5ForConditionalGeneration"},{local:"transformers.FlaxT5EncoderModel",title:"FlaxT5EncoderModel"}],title:"T5"};function Qh($){return _h(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sm extends Th{constructor(l){super(),bh(this,l,Qh,Ah,gh,{})}}export{sm as component};
