import{s as Ts,o as Ms,n as Z}from"../chunks/scheduler.9bc65507.js";import{S as Us,i as Cs,g as s,s as i,u as g,A as ks,h as r,f as o,c as l,j as f,v as _,y as m,k as u,o as t,a as p,w as v,d as b,t as y,x as w}from"../chunks/index.78c82d43.js";import{T as ro}from"../chunks/Tip.87d55b76.js";import{D as J}from"../chunks/Docstring.4e7352e2.js";import{C as vt}from"../chunks/CodeBlock.73e038be.js";import{I as L}from"../chunks/IconCopyLink.bedaa44d.js";import{E as _t}from"../chunks/ExampleCodeBlock.872b014d.js";function js(U){let n,T="Example:",d,h,S;return h=new vt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFVuaVNwZWVjaFNhdE1vZGVsJTJDJTIwVW5pU3BlZWNoU2F0Q29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFVuaVNwZWVjaFNhdCUyMG1pY3Jvc29mdCUyRnVuaXNwZWVjaC1zYXQtYmFzZS0xMDBoLWxpYnJpLWZ0JTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFVuaVNwZWVjaFNhdENvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMG1pY3Jvc29mdCUyRnVuaXNwZWVjaC1zYXQtYmFzZS0xMDBoLWxpYnJpLWZ0JTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBVbmlTcGVlY2hTYXRNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> UniSpeechSatModel, UniSpeechSatConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a UniSpeechSat microsoft/unispeech-sat-base-100h-libri-ft style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = UniSpeechSatConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the microsoft/unispeech-sat-base-100h-libri-ft style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = UniSpeechSatModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){n=s("p"),n.textContent=T,d=i(),g(h.$$.fragment)},l(a){n=r(a,"P",{"data-svelte-h":!0}),m(n)!=="svelte-11lpom8"&&(n.textContent=T),d=l(a),_(h.$$.fragment,a)},m(a,M){p(a,n,M),p(a,d,M),v(h,a,M),S=!0},p:Z,i(a){S||(b(h.$$.fragment,a),S=!0)},o(a){y(h.$$.fragment,a),S=!1},d(a){a&&(o(n),o(d)),w(h,a)}}}function Fs(U){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=s("p"),n.innerHTML=T},l(d){n=r(d,"P",{"data-svelte-h":!0}),m(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(d,h){p(d,n,h)},p:Z,d(d){d&&o(n)}}}function $s(U){let n,T="Example:",d,h,S;return h=new vt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBVbmlTcGVlY2hTYXRNb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnVuaXNwZWVjaC1zYXQtYmFzZS0xMDBoLWxpYnJpLWZ0JTIyKSUwQW1vZGVsJTIwJTNEJTIwVW5pU3BlZWNoU2F0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnVuaXNwZWVjaC1zYXQtYmFzZS0xMDBoLWxpYnJpLWZ0JTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFsaXN0KGxhc3RfaGlkZGVuX3N0YXRlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, UniSpeechSatModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/unispeech-sat-base-100h-libri-ft&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = UniSpeechSatModel.from_pretrained(<span class="hljs-string">&quot;microsoft/unispeech-sat-base-100h-libri-ft&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">292</span>, <span class="hljs-number">768</span>]`,wrap:!1}}),{c(){n=s("p"),n.textContent=T,d=i(),g(h.$$.fragment)},l(a){n=r(a,"P",{"data-svelte-h":!0}),m(n)!=="svelte-11lpom8"&&(n.textContent=T),d=l(a),_(h.$$.fragment,a)},m(a,M){p(a,n,M),p(a,d,M),v(h,a,M),S=!0},p:Z,i(a){S||(b(h.$$.fragment,a),S=!0)},o(a){y(h.$$.fragment,a),S=!1},d(a){a&&(o(n),o(d)),w(h,a)}}}function xs(U){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=s("p"),n.innerHTML=T},l(d){n=r(d,"P",{"data-svelte-h":!0}),m(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(d,h){p(d,n,h)},p:Z,d(d){d&&o(n)}}}function Js(U){let n,T="Example:",d,h,S;return h=new vt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBVbmlTcGVlY2hTYXRGb3JDVEMlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kZW1vJTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc29ydCglMjJpZCUyMiklMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwZGF0YXNldC5mZWF0dXJlcyU1QiUyMmF1ZGlvJTIyJTVELnNhbXBsaW5nX3JhdGUlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZ1bmlzcGVlY2gtc2F0LWJhc2UtMTAwaC1saWJyaS1mdCUyMiklMEFtb2RlbCUyMCUzRCUyMFVuaVNwZWVjaFNhdEZvckNUQy5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGdW5pc3BlZWNoLXNhdC1iYXNlLTEwMGgtbGlicmktZnQlMjIpJTBBJTBBJTIzJTIwYXVkaW8lMjBmaWxlJTIwaXMlMjBkZWNvZGVkJTIwb24lMjB0aGUlMjBmbHklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsaW5nX3JhdGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBcHJlZGljdGVkX2lkcyUyMCUzRCUyMHRvcmNoLmFyZ21heChsb2dpdHMlMkMlMjBkaW0lM0QtMSklMEElMEElMjMlMjB0cmFuc2NyaWJlJTIwc3BlZWNoJTBBdHJhbnNjcmlwdGlvbiUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUocHJlZGljdGVkX2lkcyklMEF0cmFuc2NyaXB0aW9uJTVCMCU1RCUwQSUwQWlucHV0cyU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEZGF0YXNldCU1QjAlNUQlNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikuaW5wdXRfaWRzJTBBJTBBJTIzJTIwY29tcHV0ZSUyMGxvc3MlMEFsb3NzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvc3MlMEFyb3VuZChsb3NzLml0ZW0oKSUyQyUyMDIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, UniSpeechSatForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/unispeech-sat-base-100h-libri-ft&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = UniSpeechSatForCTC.from_pretrained(<span class="hljs-string">&quot;microsoft/unispeech-sat-base-100h-libri-ft&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># transcribe speech</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(predicted_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;MISTER QUILDER IS THE APOSTLE OF THE MIDDLE CLASSES AND WE ARE GLAD TO WELCOME HIS GOSPEL&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs[<span class="hljs-string">&quot;labels&quot;</span>] = processor(text=dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;text&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compute loss</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
<span class="hljs-number">39.88</span>`,wrap:!1}}),{c(){n=s("p"),n.textContent=T,d=i(),g(h.$$.fragment)},l(a){n=r(a,"P",{"data-svelte-h":!0}),m(n)!=="svelte-11lpom8"&&(n.textContent=T),d=l(a),_(h.$$.fragment,a)},m(a,M){p(a,n,M),p(a,d,M),v(h,a,M),S=!0},p:Z,i(a){S||(b(h.$$.fragment,a),S=!0)},o(a){y(h.$$.fragment,a),S=!1},d(a){a&&(o(n),o(d)),w(h,a)}}}function Ws(U){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=s("p"),n.innerHTML=T},l(d){n=r(d,"P",{"data-svelte-h":!0}),m(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(d,h){p(d,n,h)},p:Z,d(d){d&&o(n)}}}function Zs(U){let n,T="Example:",d,h,S;return h=new vt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTJDJTIwVW5pU3BlZWNoU2F0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnVuaXNwZWVjaC1zYXQtYmFzZS0xMDBoLWxpYnJpLWZ0JTIyKSUwQW1vZGVsJTIwJTNEJTIwVW5pU3BlZWNoU2F0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGdW5pc3BlZWNoLXNhdC1iYXNlLTEwMGgtbGlicmktZnQlMjIpJTBBJTBBJTIzJTIwYXVkaW8lMjBmaWxlJTIwaXMlMjBkZWNvZGVkJTIwb24lMjB0aGUlMjBmbHklMEFpbnB1dHMlMjAlM0QlMjBmZWF0dXJlX2V4dHJhY3RvcihkYXRhc2V0JTVCMCU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEc2FtcGxpbmdfcmF0ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfY2xhc3NfaWRzJTIwJTNEJTIwdG9yY2guYXJnbWF4KGxvZ2l0cyUyQyUyMGRpbSUzRC0xKS5pdGVtKCklMEFwcmVkaWN0ZWRfbGFiZWwlMjAlM0QlMjBtb2RlbC5jb25maWcuaWQybGFiZWwlNUJwcmVkaWN0ZWRfY2xhc3NfaWRzJTVEJTBBJTBBJTIzJTIwY29tcHV0ZSUyMGxvc3MlMjAtJTIwdGFyZ2V0X2xhYmVsJTIwaXMlMjBlLmcuJTIwJTIyZG93biUyMiUwQXRhcmdldF9sYWJlbCUyMCUzRCUyMG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QjAlNUQlMEFpbnB1dHMlNUIlMjJsYWJlbHMlMjIlNUQlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCbW9kZWwuY29uZmlnLmxhYmVsMmlkJTVCdGFyZ2V0X2xhYmVsJTVEJTVEKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, UniSpeechSatForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;microsoft/unispeech-sat-base-100h-libri-ft&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = UniSpeechSatForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/unispeech-sat-base-100h-libri-ft&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = model.config.id2label[predicted_class_ids]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compute loss - target_label is e.g. &quot;down&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_label = model.config.id2label[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs[<span class="hljs-string">&quot;labels&quot;</span>] = torch.tensor([model.config.label2id[target_label]])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs).loss`,wrap:!1}}),{c(){n=s("p"),n.textContent=T,d=i(),g(h.$$.fragment)},l(a){n=r(a,"P",{"data-svelte-h":!0}),m(n)!=="svelte-11lpom8"&&(n.textContent=T),d=l(a),_(h.$$.fragment,a)},m(a,M){p(a,n,M),p(a,d,M),v(h,a,M),S=!0},p:Z,i(a){S||(b(h.$$.fragment,a),S=!0)},o(a){y(h.$$.fragment,a),S=!1},d(a){a&&(o(n),o(d)),w(h,a)}}}function Vs(U){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=s("p"),n.innerHTML=T},l(d){n=r(d,"P",{"data-svelte-h":!0}),m(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(d,h){p(d,n,h)},p:Z,d(d){d&&o(n)}}}function Ns(U){let n,T="Example:",d,h,S;return h=new vt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTJDJTIwVW5pU3BlZWNoU2F0Rm9yQXVkaW9GcmFtZUNsYXNzaWZpY2F0aW9uJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwdG9yY2glMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZGVtbyUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNvcnQoJTIyaWQlMjIpJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGRhdGFzZXQuZmVhdHVyZXMlNUIlMjJhdWRpbyUyMiU1RC5zYW1wbGluZ19yYXRlJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBBdXRvRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGdW5pc3BlZWNoLXNhdC1iYXNlLXBsdXMtc2QlMjIpJTBBbW9kZWwlMjAlM0QlMjBVbmlTcGVlY2hTYXRGb3JBdWRpb0ZyYW1lQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnVuaXNwZWVjaC1zYXQtYmFzZS1wbHVzLXNkJTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlKSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJvYmFiaWxpdGllcyUyMCUzRCUyMHRvcmNoLnNpZ21vaWQobG9naXRzJTVCMCU1RCklMEElMjMlMjBsYWJlbHMlMjBpcyUyMGElMjBvbmUtaG90JTIwYXJyYXklMjBvZiUyMHNoYXBlJTIwKG51bV9mcmFtZXMlMkMlMjBudW1fc3BlYWtlcnMpJTBBbGFiZWxzJTIwJTNEJTIwKHByb2JhYmlsaXRpZXMlMjAlM0UlMjAwLjUpLmxvbmcoKSUwQWxhYmVscyU1QjAlNUQudG9saXN0KCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, UniSpeechSatForAudioFrameClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;microsoft/unispeech-sat-base-plus-sd&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = UniSpeechSatForAudioFrameClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/unispeech-sat-base-plus-sd&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, sampling_rate=sampling_rate)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.sigmoid(logits[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># labels is a one-hot array of shape (num_frames, num_speakers)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = (probabilities &gt; <span class="hljs-number">0.5</span>).long()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels[<span class="hljs-number">0</span>].tolist()
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=s("p"),n.textContent=T,d=i(),g(h.$$.fragment)},l(a){n=r(a,"P",{"data-svelte-h":!0}),m(n)!=="svelte-11lpom8"&&(n.textContent=T),d=l(a),_(h.$$.fragment,a)},m(a,M){p(a,n,M),p(a,d,M),v(h,a,M),S=!0},p:Z,i(a){S||(b(h.$$.fragment,a),S=!0)},o(a){y(h.$$.fragment,a),S=!1},d(a){a&&(o(n),o(d)),w(h,a)}}}function Xs(U){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=s("p"),n.innerHTML=T},l(d){n=r(d,"P",{"data-svelte-h":!0}),m(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(d,h){p(d,n,h)},p:Z,d(d){d&&o(n)}}}function zs(U){let n,T="Example:",d,h,S;return h=new vt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, UniSpeechSatForXVector
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;microsoft/unispeech-sat-base-plus-sv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = UniSpeechSatForXVector.from_pretrained(<span class="hljs-string">&quot;microsoft/unispeech-sat-base-plus-sv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(
<span class="hljs-meta">... </span>    [d[<span class="hljs-string">&quot;array&quot;</span>] <span class="hljs-keyword">for</span> d <span class="hljs-keyword">in</span> dataset[:<span class="hljs-number">2</span>][<span class="hljs-string">&quot;audio&quot;</span>]], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    embeddings = model(**inputs).embeddings

<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = torch.nn.functional.normalize(embeddings, dim=-<span class="hljs-number">1</span>).cpu()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the resulting embeddings can be used for cosine similarity-based retrieval</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cosine_sim = torch.nn.CosineSimilarity(dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>similarity = cosine_sim(embeddings[<span class="hljs-number">0</span>], embeddings[<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>threshold = <span class="hljs-number">0.7</span>  <span class="hljs-comment"># the optimal threshold is dataset-dependent</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> similarity &lt; threshold:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Speakers are not the same!&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(similarity.item(), <span class="hljs-number">2</span>)
<span class="hljs-number">0.97</span>`,wrap:!1}}),{c(){n=s("p"),n.textContent=T,d=i(),g(h.$$.fragment)},l(a){n=r(a,"P",{"data-svelte-h":!0}),m(n)!=="svelte-11lpom8"&&(n.textContent=T),d=l(a),_(h.$$.fragment,a)},m(a,M){p(a,n,M),p(a,d,M),v(h,a,M),S=!0},p:Z,i(a){S||(b(h.$$.fragment,a),S=!0)},o(a){y(h.$$.fragment,a),S=!1},d(a){a&&(o(n),o(d)),w(h,a)}}}function Gs(U){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=s("p"),n.innerHTML=T},l(d){n=r(d,"P",{"data-svelte-h":!0}),m(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(d,h){p(d,n,h)},p:Z,d(d){d&&o(n)}}}function Is(U){let n,T="Example:",d,h,S;return h=new vt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMkMlMjBVbmlTcGVlY2hTYXRGb3JQcmVUcmFpbmluZyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMubW9kZWxzLnVuaXNwZWVjaF9zYXQubW9kZWxpbmdfdW5pc3BlZWNoX3NhdCUyMGltcG9ydCUyMF9jb21wdXRlX21hc2tfaW5kaWNlcyUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnVuaXNwZWVjaC1zYXQtYmFzZSUyMiklMEFtb2RlbCUyMCUzRCUyMFVuaVNwZWVjaFNhdEZvclByZVRyYWluaW5nLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZ1bmlzcGVlY2gtc2F0LWJhc2UlMjIpJTBBJTIzJTIwVE9ETyUzQSUyMEFkZCUyMGZ1bGwlMjBwcmV0cmFpbmluZyUyMGV4YW1wbGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, UniSpeechSatForPreTraining
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.models.unispeech_sat.modeling_unispeech_sat <span class="hljs-keyword">import</span> _compute_mask_indices

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;microsoft/unispeech-sat-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = UniSpeechSatForPreTraining.from_pretrained(<span class="hljs-string">&quot;microsoft/unispeech-sat-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Add full pretraining example</span>`,wrap:!1}}),{c(){n=s("p"),n.textContent=T,d=i(),g(h.$$.fragment)},l(a){n=r(a,"P",{"data-svelte-h":!0}),m(n)!=="svelte-11lpom8"&&(n.textContent=T),d=l(a),_(h.$$.fragment,a)},m(a,M){p(a,n,M),p(a,d,M),v(h,a,M),S=!0},p:Z,i(a){S||(b(h.$$.fragment,a),S=!0)},o(a){y(h.$$.fragment,a),S=!1},d(a){a&&(o(n),o(d)),w(h,a)}}}function qs(U){let n,T,d,h,S,a,M,Ve,cn,bt,fa="UniSpeech-SAT",ko,P,re,io,Ne,dn,yt,ga="Overview",jo,Xe,_a=`The UniSpeech-SAT model was proposed in <a href="https://arxiv.org/abs/2110.05752" rel="nofollow">UniSpeech-SAT: Universal Speech Representation Learning with Speaker Aware
Pre-Training</a> by Sanyuan Chen, Yu Wu, Chengyi Wang, Zhengyang Chen, Zhuo Chen,
Shujie Liu, Jian Wu, Yao Qian, Furu Wei, Jinyu Li, Xiangzhan Yu .`,Fo,ze,va="The abstract from the paper is the following:",$o,Ge,ba=`<em>Self-supervised learning (SSL) is a long-standing goal for speech processing, since it utilizes large-scale unlabeled
data and avoids extensive human labeling. Recent years witness great successes in applying self-supervised learning in
speech recognition, while limited exploration was attempted in applying SSL for modeling speaker characteristics. In
this paper, we aim to improve the existing SSL framework for speaker representation learning. Two methods are
introduced for enhancing the unsupervised speaker information extraction. First, we apply the multi-task learning to
the current SSL framework, where we integrate the utterance-wise contrastive loss with the SSL objective function.
Second, for better speaker discrimination, we propose an utterance mixing strategy for data augmentation, where
additional overlapped utterances are created unsupervisely and incorporate during training. We integrate the proposed
methods into the HuBERT framework. Experiment results on SUPERB benchmark show that the proposed system achieves
state-of-the-art performance in universal representation learning, especially for speaker identification oriented
tasks. An ablation study is performed verifying the efficacy of each proposed method. Finally, we scale up training
dataset to 94 thousand hours public audio data and achieve further performance improvement in all SUPERB tasks.</em>`,xo,Ie,ya="Tips:",Jo,qe,wa=`<li>UniSpeechSat is a speech model that accepts a float array corresponding to the raw waveform of the speech signal.
Please use <a href="/docs/transformers/v4.34.0/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> for the feature extraction.</li> <li>UniSpeechSat model can be fine-tuned using connectionist temporal classification (CTC) so the model output has to be
decoded using <a href="/docs/transformers/v4.34.0/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer">Wav2Vec2CTCTokenizer</a>.</li> <li>UniSpeechSat performs especially well on speaker verification, speaker identification, and speaker diarization tasks.</li>`,Wo,Be,Sa=`This model was contributed by <a href="https://huggingface.co/patrickvonplaten" rel="nofollow">patrickvonplaten</a>. The Authors’ code can be
found <a href="https://github.com/microsoft/UniSpeech/tree/main/UniSpeech-SAT" rel="nofollow">here</a>.`,Zo,Q,ie,lo,Re,pn,wt,Ta="Documentation resources",Vo,Ye,Ma='<li><a href="../tasks/audio_classification">Audio classification task guide</a></li> <li><a href="../tasks/asr">Automatic speech recognition task guide</a></li>',No,D,le,co,Le,hn,St,Ua="UniSpeechSatConfig",Xo,W,Ae,mn,Tt,Ca=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.34.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatModel">UniSpeechSatModel</a>. It is used to instantiate an
UniSpeechSat model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the UniSpeechSat
<a href="https://huggingface.co/microsoft/unispeech-sat-base-100h-libri-ft" rel="nofollow">microsoft/unispeech-sat-base-100h-libri-ft</a>
architecture.`,un,Mt,ka=`Configuration objects inherit from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,fn,ce,zo,O,de,po,Ee,gn,Ut,ja="UniSpeechSat specific outputs",Go,K,He,_n,Ct,Fa="Output type of <code>UniSpeechSatForPreTrainingOutput</code>, with potential hidden states and attentions.",Io,ee,pe,ho,Pe,vn,kt,$a="UniSpeechSatModel",qo,F,Qe,bn,jt,xa=`The bare UniSpeechSat Model transformer outputting raw hidden-states without any specific head on top.
UniSpeechSat was proposed in <a href="https://arxiv.org/abs/2006.11477" rel="nofollow">wav2vec 2.0: A Framework for Self-Supervised Learning of Speech
Representations</a> by Alexei Baevski, Henry Zhou, Abdelrahman Mohamed, Michael
Auli.`,yn,Ft,Ja=`This model inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving etc.).`,wn,$t,Wa=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Sn,V,De,Tn,xt,Za='The <a href="/docs/transformers/v4.34.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatModel">UniSpeechSatModel</a> forward method, overrides the <code>__call__</code> special method.',Mn,he,Un,me,Bo,te,ue,mo,Oe,Cn,Jt,Va="UniSpeechSatForCTC",Ro,$,Ke,kn,Wt,Na=`UniSpeechSat Model with a <code>language modeling</code> head on top for Connectionist Temporal Classification (CTC).
UniSpeechSat was proposed in <a href="https://arxiv.org/abs/2006.11477" rel="nofollow">wav2vec 2.0: A Framework for Self-Supervised Learning of Speech
Representations</a> by Alexei Baevski, Henry Zhou, Abdelrahman Mohamed, Michael
Auli.`,jn,Zt,Xa=`This model inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving etc.).`,Fn,Vt,za=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,$n,N,et,xn,Nt,Ga='The <a href="/docs/transformers/v4.34.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatForCTC">UniSpeechSatForCTC</a> forward method, overrides the <code>__call__</code> special method.',Jn,fe,Wn,ge,Yo,oe,_e,uo,tt,Zn,Xt,Ia="UniSpeechSatForSequenceClassification",Lo,C,ot,Vn,zt,qa=`UniSpeechSat Model with a sequence classification head on top (a linear layer over the pooled output) for tasks
like SUPERB Keyword Spotting.`,Nn,Gt,Ba=`UniSpeechSat was proposed in <a href="https://arxiv.org/abs/2006.11477" rel="nofollow">wav2vec 2.0: A Framework for Self-Supervised Learning of Speech
Representations</a> by Alexei Baevski, Henry Zhou, Abdelrahman Mohamed, Michael
Auli.`,Xn,It,Ra=`This model inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving etc.).`,zn,qt,Ya=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Gn,X,nt,In,Bt,La='The <a href="/docs/transformers/v4.34.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatForSequenceClassification">UniSpeechSatForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',qn,ve,Bn,be,Ao,ne,ye,fo,at,Rn,Rt,Aa="UniSpeechSatForAudioFrameClassification",Eo,k,st,Yn,Yt,Ea="UniSpeech-SAT Model with a frame classification head on top for tasks like Speaker Diarization.",Ln,Lt,Ha=`UniSpeechSat was proposed in <a href="https://arxiv.org/abs/2006.11477" rel="nofollow">wav2vec 2.0: A Framework for Self-Supervised Learning of Speech
Representations</a> by Alexei Baevski, Henry Zhou, Abdelrahman Mohamed, Michael
Auli.`,An,At,Pa=`This model inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving etc.).`,En,Et,Qa=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Hn,z,rt,Pn,Ht,Da='The <a href="/docs/transformers/v4.34.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatForAudioFrameClassification">UniSpeechSatForAudioFrameClassification</a> forward method, overrides the <code>__call__</code> special method.',Qn,we,Dn,Se,Ho,ae,Te,go,it,On,Pt,Oa="UniSpeechSatForXVector",Po,j,lt,Kn,Qt,Ka="UniSpeech-SAT Model with an XVector feature extraction head on top for tasks like Speaker Verification.",ea,Dt,es=`UniSpeechSat was proposed in <a href="https://arxiv.org/abs/2006.11477" rel="nofollow">wav2vec 2.0: A Framework for Self-Supervised Learning of Speech
Representations</a> by Alexei Baevski, Henry Zhou, Abdelrahman Mohamed, Michael
Auli.`,ta,Ot,ts=`This model inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving etc.).`,oa,Kt,os=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,na,G,ct,aa,eo,ns='The <a href="/docs/transformers/v4.34.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatForXVector">UniSpeechSatForXVector</a> forward method, overrides the <code>__call__</code> special method.',sa,Me,ra,Ue,Qo,se,Ce,_o,dt,ia,to,as="UniSpeechSatForPreTraining",Do,x,pt,la,oo,ss=`UniSpeechSat Model with a quantizer and <code>VQ</code> head on top.
UniSpeechSat was proposed in <a href="https://arxiv.org/abs/2006.11477" rel="nofollow">wav2vec 2.0: A Framework for Self-Supervised Learning of Speech
Representations</a> by Alexei Baevski, Henry Zhou, Abdelrahman Mohamed, Michael
Auli.`,ca,no,rs=`This model inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving etc.).`,da,ao,is=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,pa,I,ht,ha,so,ls='The <a href="/docs/transformers/v4.34.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatForPreTraining">UniSpeechSatForPreTraining</a> forward method, overrides the <code>__call__</code> special method.',ma,ke,ua,je,Oo,vo,Ko;return Ve=new L({}),Ne=new L({}),Re=new L({}),Le=new L({}),Ae=new J({props:{name:"class transformers.UniSpeechSatConfig",anchor:"transformers.UniSpeechSatConfig",parameters:[{name:"vocab_size",val:" = 32"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout",val:" = 0.1"},{name:"activation_dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.1"},{name:"feat_proj_dropout",val:" = 0.0"},{name:"feat_quantizer_dropout",val:" = 0.0"},{name:"final_dropout",val:" = 0.1"},{name:"layerdrop",val:" = 0.1"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"feat_extract_norm",val:" = 'group'"},{name:"feat_extract_activation",val:" = 'gelu'"},{name:"conv_dim",val:" = (512, 512, 512, 512, 512, 512, 512)"},{name:"conv_stride",val:" = (5, 2, 2, 2, 2, 2, 2)"},{name:"conv_kernel",val:" = (10, 3, 3, 3, 3, 2, 2)"},{name:"conv_bias",val:" = False"},{name:"num_conv_pos_embeddings",val:" = 128"},{name:"num_conv_pos_embedding_groups",val:" = 16"},{name:"do_stable_layer_norm",val:" = False"},{name:"apply_spec_augment",val:" = True"},{name:"mask_time_prob",val:" = 0.05"},{name:"mask_time_length",val:" = 10"},{name:"mask_time_min_masks",val:" = 2"},{name:"mask_feature_prob",val:" = 0.0"},{name:"mask_feature_length",val:" = 10"},{name:"mask_feature_min_masks",val:" = 0"},{name:"num_codevectors_per_group",val:" = 320"},{name:"num_codevector_groups",val:" = 2"},{name:"contrastive_logits_temperature",val:" = 0.1"},{name:"num_negatives",val:" = 100"},{name:"codevector_dim",val:" = 256"},{name:"proj_codevector_dim",val:" = 256"},{name:"diversity_loss_weight",val:" = 0.1"},{name:"ctc_loss_reduction",val:" = 'mean'"},{name:"ctc_zero_infinity",val:" = False"},{name:"use_weighted_layer_sum",val:" = False"},{name:"classifier_proj_size",val:" = 256"},{name:"tdnn_dim",val:" = (512, 512, 512, 512, 1500)"},{name:"tdnn_kernel",val:" = (5, 3, 3, 1, 1)"},{name:"tdnn_dilation",val:" = (1, 2, 3, 1, 1)"},{name:"xvector_output_dim",val:" = 512"},{name:"pad_token_id",val:" = 0"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"num_clusters",val:" = 504"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.UniSpeechSatConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Vocabulary size of the UniSpeechSat model. Defines the number of different tokens that can be represented
by the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/v4.34.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatModel">UniSpeechSatModel</a>. Vocabulary size of the model. Defines the
different tokens that can be represented by the <em>inputs_ids</em> passed to the forward method of
<a href="/docs/transformers/v4.34.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatModel">UniSpeechSatModel</a>.`,name:"vocab_size"},{anchor:"transformers.UniSpeechSatConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.UniSpeechSatConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.UniSpeechSatConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.UniSpeechSatConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.UniSpeechSatConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.UniSpeechSatConfig.hidden_dropout",description:`<strong>hidden_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout"},{anchor:"transformers.UniSpeechSatConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.UniSpeechSatConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.UniSpeechSatConfig.final_dropout",description:`<strong>final_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for the final projection layer of <a href="/docs/transformers/v4.34.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatForCTC">UniSpeechSatForCTC</a>.`,name:"final_dropout"},{anchor:"transformers.UniSpeechSatConfig.layerdrop",description:`<strong>layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The LayerDrop probability. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>) for more
details.`,name:"layerdrop"},{anchor:"transformers.UniSpeechSatConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.UniSpeechSatConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.UniSpeechSatConfig.feat_extract_norm",description:`<strong>feat_extract_norm</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;group&quot;</code>) &#x2014;
The norm to be applied to 1D convolutional layers in feature encoder. One of <code>&quot;group&quot;</code> for group
normalization of only the first 1D convolutional layer or <code>&quot;layer&quot;</code> for layer normalization of all 1D
convolutional layers.`,name:"feat_extract_norm"},{anchor:"transformers.UniSpeechSatConfig.feat_proj_dropout",description:`<strong>feat_proj_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for output of the feature encoder.`,name:"feat_proj_dropout"},{anchor:"transformers.UniSpeechSatConfig.feat_extract_activation",description:"<strong>feat_extract_activation</strong> (<code>str, </code>optional<code>, defaults to </code>&#x201C;gelu&#x201D;<code>) -- The non-linear activation function (function or string) in the 1D convolutional layers of the feature extractor. If string, </code>&#x201C;gelu&#x201D;<code>, </code>&#x201C;relu&#x201D;<code>, </code>&#x201C;selu&#x201D;<code>and</code>&#x201C;gelu_new&#x201D;` are supported.",name:"feat_extract_activation"},{anchor:"transformers.UniSpeechSatConfig.feat_quantizer_dropout",description:`<strong>feat_quantizer_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probabilitiy for quantized feature encoder states.`,name:"feat_quantizer_dropout"},{anchor:"transformers.UniSpeechSatConfig.conv_dim",description:`<strong>conv_dim</strong> (<code>Tuple[int]</code> or <code>List[int]</code>, <em>optional</em>, defaults to <code>(512, 512, 512, 512, 512, 512, 512)</code>) &#x2014;
A tuple of integers defining the number of input and output channels of each 1D convolutional layer in the
feature encoder. The length of <em>conv_dim</em> defines the number of 1D convolutional layers.`,name:"conv_dim"},{anchor:"transformers.UniSpeechSatConfig.conv_stride",description:`<strong>conv_stride</strong> (<code>Tuple[int]</code> or <code>List[int]</code>, <em>optional</em>, defaults to <code>(5, 2, 2, 2, 2, 2, 2)</code>) &#x2014;
A tuple of integers defining the stride of each 1D convolutional layer in the feature encoder. The length
of <em>conv_stride</em> defines the number of convolutional layers and has to match the length of <em>conv_dim</em>.`,name:"conv_stride"},{anchor:"transformers.UniSpeechSatConfig.conv_kernel",description:`<strong>conv_kernel</strong> (<code>Tuple[int]</code> or <code>List[int]</code>, <em>optional</em>, defaults to <code>(10, 3, 3, 3, 3, 3, 3)</code>) &#x2014;
A tuple of integers defining the kernel size of each 1D convolutional layer in the feature encoder. The
length of <em>conv_kernel</em> defines the number of convolutional layers and has to match the length of
<em>conv_dim</em>.`,name:"conv_kernel"},{anchor:"transformers.UniSpeechSatConfig.conv_bias",description:`<strong>conv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the 1D convolutional layers have a bias.`,name:"conv_bias"},{anchor:"transformers.UniSpeechSatConfig.num_conv_pos_embeddings",description:`<strong>num_conv_pos_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Number of convolutional positional embeddings. Defines the kernel size of 1D convolutional positional
embeddings layer.`,name:"num_conv_pos_embeddings"},{anchor:"transformers.UniSpeechSatConfig.num_conv_pos_embedding_groups",description:`<strong>num_conv_pos_embedding_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of groups of 1D convolutional positional embeddings layer.`,name:"num_conv_pos_embedding_groups"},{anchor:"transformers.UniSpeechSatConfig.do_stable_layer_norm",description:`<strong>do_stable_layer_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to apply <em>stable</em> layer norm architecture of the Transformer encoder. <code>do_stable_layer_norm is True</code> corresponds to applying layer norm before the attention layer, whereas <code>do_stable_layer_norm is False</code> corresponds to applying layer norm after the attention layer.`,name:"do_stable_layer_norm"},{anchor:"transformers.UniSpeechSatConfig.apply_spec_augment",description:`<strong>apply_spec_augment</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to apply <em>SpecAugment</em> data augmentation to the outputs of the feature encoder. For reference see
<a href="https://arxiv.org/abs/1904.08779" rel="nofollow">SpecAugment: A Simple Data Augmentation Method for Automatic Speech
Recognition</a>.`,name:"apply_spec_augment"},{anchor:"transformers.UniSpeechSatConfig.mask_time_prob",description:`<strong>mask_time_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.05) &#x2014;
Percentage (between 0 and 1) of all feature vectors along the time axis which will be masked. The masking
procecure generates &#x201D;mask_time_prob<em>len(time_axis)/mask_time_length&#x201D; independent masks over the axis. If
reasoning from the propability of each feature vector to be chosen as the start of the vector span to be
masked, </em>mask_time_prob<em> should be \`prob_vector_start</em>mask_time_length<code>. Note that overlap may decrease the actual percentage of masked vectors. This is only relevant if </code>apply_spec_augment is True\`.`,name:"mask_time_prob"},{anchor:"transformers.UniSpeechSatConfig.mask_time_length",description:`<strong>mask_time_length</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
Length of vector span along the time axis.`,name:"mask_time_length"},{anchor:"transformers.UniSpeechSatConfig.mask_time_min_masks",description:`<strong>mask_time_min_masks</strong> (<code>int</code>, <em>optional</em>, defaults to 2), &#x2014;
The minimum number of masks of length <code>mask_feature_length</code> generated along the time axis, each time step,
irrespectively of <code>mask_feature_prob</code>. Only relevant if &#x201D;mask_time_prob*len(time_axis)/mask_time_length &lt;
mask_time_min_masks&#x201D;`,name:"mask_time_min_masks"},{anchor:"transformers.UniSpeechSatConfig.mask_feature_prob",description:`<strong>mask_feature_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Percentage (between 0 and 1) of all feature vectors along the feature axis which will be masked. The
masking procecure generates &#x201D;mask_feature_prob<em>len(feature_axis)/mask_time_length&#x201D; independent masks over
the axis. If reasoning from the propability of each feature vector to be chosen as the start of the vector
span to be masked, </em>mask_feature_prob<em> should be \`prob_vector_start</em>mask_feature_length<code>. Note that overlap may decrease the actual percentage of masked vectors. This is only relevant if </code>apply_spec_augment is
True\`.`,name:"mask_feature_prob"},{anchor:"transformers.UniSpeechSatConfig.mask_feature_length",description:`<strong>mask_feature_length</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
Length of vector span along the feature axis.`,name:"mask_feature_length"},{anchor:"transformers.UniSpeechSatConfig.mask_feature_min_masks",description:`<strong>mask_feature_min_masks</strong> (<code>int</code>, <em>optional</em>, defaults to 0), &#x2014;
The minimum number of masks of length <code>mask_feature_length</code> generated along the feature axis, each time
step, irrespectively of <code>mask_feature_prob</code>. Only relevant if
&#x201D;mask_feature_prob*len(feature_axis)/mask_feature_length &lt; mask_feature_min_masks&#x201D;`,name:"mask_feature_min_masks"},{anchor:"transformers.UniSpeechSatConfig.num_codevectors_per_group",description:`<strong>num_codevectors_per_group</strong> (<code>int</code>, <em>optional</em>, defaults to 320) &#x2014;
Number of entries in each quantization codebook (group).`,name:"num_codevectors_per_group"},{anchor:"transformers.UniSpeechSatConfig.num_codevector_groups",description:`<strong>num_codevector_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Number of codevector groups for product codevector quantization.`,name:"num_codevector_groups"},{anchor:"transformers.UniSpeechSatConfig.contrastive_logits_temperature",description:`<strong>contrastive_logits_temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The temperature <em>kappa</em> in the contrastive loss.`,name:"contrastive_logits_temperature"},{anchor:"transformers.UniSpeechSatConfig.feat_quantizer_dropout",description:`<strong>feat_quantizer_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probabilitiy for the output of the feature encoder that&#x2019;s used by the quantizer.`,name:"feat_quantizer_dropout"},{anchor:"transformers.UniSpeechSatConfig.num_negatives",description:`<strong>num_negatives</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
Number of negative samples for the contrastive loss.`,name:"num_negatives"},{anchor:"transformers.UniSpeechSatConfig.codevector_dim",description:`<strong>codevector_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of the quantized feature vectors.`,name:"codevector_dim"},{anchor:"transformers.UniSpeechSatConfig.proj_codevector_dim",description:`<strong>proj_codevector_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of the final projection of both the quantized and the transformer features.`,name:"proj_codevector_dim"},{anchor:"transformers.UniSpeechSatConfig.diversity_loss_weight",description:`<strong>diversity_loss_weight</strong> (<code>int</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The weight of the codebook diversity loss component.`,name:"diversity_loss_weight"},{anchor:"transformers.UniSpeechSatConfig.ctc_loss_reduction",description:`<strong>ctc_loss_reduction</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;mean&quot;</code>) &#x2014;
Specifies the reduction to apply to the output of <code>torch.nn.CTCLoss</code>. Only relevant when training an
instance of <a href="/docs/transformers/v4.34.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatForCTC">UniSpeechSatForCTC</a>.`,name:"ctc_loss_reduction"},{anchor:"transformers.UniSpeechSatConfig.ctc_zero_infinity",description:`<strong>ctc_zero_infinity</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to zero infinite losses and the associated gradients of <code>torch.nn.CTCLoss</code>. Infinite losses mainly
occur when the inputs are too short to be aligned to the targets. Only relevant when training an instance
of <a href="/docs/transformers/v4.34.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatForCTC">UniSpeechSatForCTC</a>.`,name:"ctc_zero_infinity"},{anchor:"transformers.UniSpeechSatConfig.use_weighted_layer_sum",description:`<strong>use_weighted_layer_sum</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a weighted average of layer outputs with learned weights. Only relevant when using an
instance of <a href="/docs/transformers/v4.34.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatForSequenceClassification">UniSpeechSatForSequenceClassification</a>.`,name:"use_weighted_layer_sum"},{anchor:"transformers.UniSpeechSatConfig.classifier_proj_size",description:`<strong>classifier_proj_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of the projection before token mean-pooling for classification.`,name:"classifier_proj_size"},{anchor:"transformers.UniSpeechSatConfig.tdnn_dim",description:`<strong>tdnn_dim</strong> (<code>Tuple[int]</code> or <code>List[int]</code>, <em>optional</em>, defaults to <code>(512, 512, 512, 512, 1500)</code>) &#x2014;
A tuple of integers defining the number of output channels of each 1D convolutional layer in the <em>TDNN</em>
module of the <em>XVector</em> model. The length of <em>tdnn_dim</em> defines the number of <em>TDNN</em> layers.`,name:"tdnn_dim"},{anchor:"transformers.UniSpeechSatConfig.tdnn_kernel",description:`<strong>tdnn_kernel</strong> (<code>Tuple[int]</code> or <code>List[int]</code>, <em>optional</em>, defaults to <code>(5, 3, 3, 1, 1)</code>) &#x2014;
A tuple of integers defining the kernel size of each 1D convolutional layer in the <em>TDNN</em> module of the
<em>XVector</em> model. The length of <em>tdnn_kernel</em> has to match the length of <em>tdnn_dim</em>.`,name:"tdnn_kernel"},{anchor:"transformers.UniSpeechSatConfig.tdnn_dilation",description:`<strong>tdnn_dilation</strong> (<code>Tuple[int]</code> or <code>List[int]</code>, <em>optional</em>, defaults to <code>(1, 2, 3, 1, 1)</code>) &#x2014;
A tuple of integers defining the dilation factor of each 1D convolutional layer in <em>TDNN</em> module of the
<em>XVector</em> model. The length of <em>tdnn_dilation</em> has to match the length of <em>tdnn_dim</em>.`,name:"tdnn_dilation"},{anchor:"transformers.UniSpeechSatConfig.xvector_output_dim",description:`<strong>xvector_output_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimensionality of the <em>XVector</em> embedding vectors.`,name:"xvector_output_dim"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/unispeech_sat/configuration_unispeech_sat.py#L34"}}),ce=new _t({props:{anchor:"transformers.UniSpeechSatConfig.example",$$slots:{default:[js]},$$scope:{ctx:U}}}),Ee=new L({}),He=new J({props:{name:"class transformers.models.unispeech_sat.modeling_unispeech_sat.UniSpeechSatForPreTrainingOutput",anchor:"transformers.models.unispeech_sat.modeling_unispeech_sat.UniSpeechSatForPreTrainingOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"projected_states",val:": FloatTensor = None"},{name:"projected_quantized_states",val:": FloatTensor = None"},{name:"codevector_perplexity",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.unispeech_sat.modeling_unispeech_sat.UniSpeechSatForPreTrainingOutput.loss",description:`<strong>loss</strong> (<em>optional</em>, returned when model is in train mode, <code>torch.FloatTensor</code> of shape <code>(1,)</code>) &#x2014;
Total loss as the sum of the contrastive loss (L_m) and the diversity loss (L_d) as stated in the <a href="https://arxiv.org/pdf/2006.11477.pdf" rel="nofollow">official
paper</a> . (classification) loss.`,name:"loss"},{anchor:"transformers.models.unispeech_sat.modeling_unispeech_sat.UniSpeechSatForPreTrainingOutput.projected_states",description:`<strong>projected_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.proj_codevector_dim)</code>) &#x2014;
Hidden-states of the model projected to <em>config.proj_codevector_dim</em> that can be used to predict the masked
projected quantized states.`,name:"projected_states"},{anchor:"transformers.models.unispeech_sat.modeling_unispeech_sat.UniSpeechSatForPreTrainingOutput.projected_quantized_states",description:`<strong>projected_quantized_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.proj_codevector_dim)</code>) &#x2014;
Quantized extracted feature vectors projected to <em>config.proj_codevector_dim</em> representing the positive
target vectors for contrastive loss.`,name:"projected_quantized_states"},{anchor:"transformers.models.unispeech_sat.modeling_unispeech_sat.UniSpeechSatForPreTrainingOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.unispeech_sat.modeling_unispeech_sat.UniSpeechSatForPreTrainingOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/unispeech_sat/modeling_unispeech_sat.py#L80"}}),Pe=new L({}),Qe=new J({props:{name:"class transformers.UniSpeechSatModel",anchor:"transformers.UniSpeechSatModel",parameters:[{name:"config",val:": UniSpeechSatConfig"}],parametersDescription:[{anchor:"transformers.UniSpeechSatModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatConfig">UniSpeechSatConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/unispeech_sat/modeling_unispeech_sat.py#L1123"}}),De=new J({props:{name:"forward",anchor:"transformers.UniSpeechSatModel.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.Tensor]"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"mask_time_indices",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.UniSpeechSatModel.forward.input_values",description:`<strong>input_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>torch.FloatTensor</code>. See <a href="/docs/transformers/v4.34.0/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor.__call__">Wav2Vec2Processor.<strong>call</strong>()</a> for details.`,name:"input_values"},{anchor:"transformers.UniSpeechSatModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing convolution and attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p><code>attention_mask</code> should only be passed if the corresponding processor has <code>config.return_attention_mask == True</code>. For all models whose processor has <code>config.return_attention_mask == False</code>, such as
<a href="https://huggingface.co/microsoft/unispeech-sat-base-100h-libri-ft" rel="nofollow">microsoft/unispeech-sat-base-100h-libri-ft</a>,
<code>attention_mask</code> should <strong>not</strong> be passed to avoid degraded performance when doing batched inference. For
such models <code>input_values</code> should simply be padded with 0 and passed without <code>attention_mask</code>. Be aware
that these models also yield slightly different results depending on whether <code>input_values</code> is padded or
not.</p>

					</div>`,name:"attention_mask"},{anchor:"transformers.UniSpeechSatModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.UniSpeechSatModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.UniSpeechSatModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/unispeech_sat/modeling_unispeech_sat.py#L1187",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/model_doc/wav2vec2#transformers.modeling_outputs.Wav2Vec2BaseModelOutput"
>transformers.modeling_outputs.Wav2Vec2BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatConfig"
>UniSpeechSatConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>extract_features</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, conv_dim[-1])</code>) — Sequence of extracted feature vectors of the last convolutional layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/model_doc/wav2vec2#transformers.modeling_outputs.Wav2Vec2BaseModelOutput"
>transformers.modeling_outputs.Wav2Vec2BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),he=new ro({props:{$$slots:{default:[Fs]},$$scope:{ctx:U}}}),me=new _t({props:{anchor:"transformers.UniSpeechSatModel.forward.example",$$slots:{default:[$s]},$$scope:{ctx:U}}}),Oe=new L({}),Ke=new J({props:{name:"class transformers.UniSpeechSatForCTC",anchor:"transformers.UniSpeechSatForCTC",parameters:[{name:"config",val:""},{name:"target_lang",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"transformers.UniSpeechSatForCTC.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatConfig">UniSpeechSatConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/unispeech_sat/modeling_unispeech_sat.py#L1386"}}),et=new J({props:{name:"forward",anchor:"transformers.UniSpeechSatForCTC.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.Tensor]"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.UniSpeechSatForCTC.forward.input_values",description:`<strong>input_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>torch.FloatTensor</code>. See <a href="/docs/transformers/v4.34.0/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor.__call__">Wav2Vec2Processor.<strong>call</strong>()</a> for details.`,name:"input_values"},{anchor:"transformers.UniSpeechSatForCTC.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing convolution and attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p><code>attention_mask</code> should only be passed if the corresponding processor has <code>config.return_attention_mask == True</code>. For all models whose processor has <code>config.return_attention_mask == False</code>, such as
<a href="https://huggingface.co/microsoft/unispeech-sat-base-100h-libri-ft" rel="nofollow">microsoft/unispeech-sat-base-100h-libri-ft</a>,
<code>attention_mask</code> should <strong>not</strong> be passed to avoid degraded performance when doing batched inference. For
such models <code>input_values</code> should simply be padded with 0 and passed without <code>attention_mask</code>. Be aware
that these models also yield slightly different results depending on whether <code>input_values</code> is padded or
not.</p>

					</div>`,name:"attention_mask"},{anchor:"transformers.UniSpeechSatForCTC.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.UniSpeechSatForCTC.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.UniSpeechSatForCTC.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.UniSpeechSatForCTC.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_length)</code>, <em>optional</em>) &#x2014;
Labels for connectionist temporal classification. Note that <code>target_length</code> has to be smaller or equal to
the sequence length of the output logits. Indices are selected in <code>[-100, 0, ..., config.vocab_size - 1]</code>.
All labels set to <code>-100</code> are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/unispeech_sat/modeling_unispeech_sat.py#L1458",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.CausalLMOutput"
>transformers.modeling_outputs.CausalLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatConfig"
>UniSpeechSatConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.CausalLMOutput"
>transformers.modeling_outputs.CausalLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),fe=new ro({props:{$$slots:{default:[xs]},$$scope:{ctx:U}}}),ge=new _t({props:{anchor:"transformers.UniSpeechSatForCTC.forward.example",$$slots:{default:[Js]},$$scope:{ctx:U}}}),tt=new L({}),ot=new J({props:{name:"class transformers.UniSpeechSatForSequenceClassification",anchor:"transformers.UniSpeechSatForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.UniSpeechSatForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatConfig">UniSpeechSatConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/unispeech_sat/modeling_unispeech_sat.py#L1545"}}),nt=new J({props:{name:"forward",anchor:"transformers.UniSpeechSatForSequenceClassification.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.Tensor]"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.UniSpeechSatForSequenceClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>torch.FloatTensor</code>. See <a href="/docs/transformers/v4.34.0/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor.__call__">Wav2Vec2Processor.<strong>call</strong>()</a> for details.`,name:"input_values"},{anchor:"transformers.UniSpeechSatForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing convolution and attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p><code>attention_mask</code> should only be passed if the corresponding processor has <code>config.return_attention_mask == True</code>. For all models whose processor has <code>config.return_attention_mask == False</code>, such as
<a href="https://huggingface.co/microsoft/unispeech-sat-base-100h-libri-ft" rel="nofollow">microsoft/unispeech-sat-base-100h-libri-ft</a>,
<code>attention_mask</code> should <strong>not</strong> be passed to avoid degraded performance when doing batched inference. For
such models <code>input_values</code> should simply be padded with 0 and passed without <code>attention_mask</code>. Be aware
that these models also yield slightly different results depending on whether <code>input_values</code> is padded or
not.</p>

					</div>`,name:"attention_mask"},{anchor:"transformers.UniSpeechSatForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.UniSpeechSatForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.UniSpeechSatForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.UniSpeechSatForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/unispeech_sat/modeling_unispeech_sat.py#L1593",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatConfig"
>UniSpeechSatConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ve=new ro({props:{$$slots:{default:[Ws]},$$scope:{ctx:U}}}),be=new _t({props:{anchor:"transformers.UniSpeechSatForSequenceClassification.forward.example",$$slots:{default:[Zs]},$$scope:{ctx:U}}}),at=new L({}),st=new J({props:{name:"class transformers.UniSpeechSatForAudioFrameClassification",anchor:"transformers.UniSpeechSatForAudioFrameClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.UniSpeechSatForAudioFrameClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatConfig">UniSpeechSatConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/unispeech_sat/modeling_unispeech_sat.py#L1670"}}),rt=new J({props:{name:"forward",anchor:"transformers.UniSpeechSatForAudioFrameClassification.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.Tensor]"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.UniSpeechSatForAudioFrameClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>torch.FloatTensor</code>. See <a href="/docs/transformers/v4.34.0/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor.__call__">Wav2Vec2Processor.<strong>call</strong>()</a> for details.`,name:"input_values"},{anchor:"transformers.UniSpeechSatForAudioFrameClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing convolution and attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p><code>attention_mask</code> should only be passed if the corresponding processor has <code>config.return_attention_mask == True</code>. For all models whose processor has <code>config.return_attention_mask == False</code>, such as
<a href="https://huggingface.co/microsoft/unispeech-sat-base-100h-libri-ft" rel="nofollow">microsoft/unispeech-sat-base-100h-libri-ft</a>,
<code>attention_mask</code> should <strong>not</strong> be passed to avoid degraded performance when doing batched inference. For
such models <code>input_values</code> should simply be padded with 0 and passed without <code>attention_mask</code>. Be aware
that these models also yield slightly different results depending on whether <code>input_values</code> is padded or
not.</p>

					</div>`,name:"attention_mask"},{anchor:"transformers.UniSpeechSatForAudioFrameClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.UniSpeechSatForAudioFrameClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.UniSpeechSatForAudioFrameClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.UniSpeechSatForAudioFrameClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/unispeech_sat/modeling_unispeech_sat.py#L1714",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatConfig"
>UniSpeechSatConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),we=new ro({props:{$$slots:{default:[Vs]},$$scope:{ctx:U}}}),Se=new _t({props:{anchor:"transformers.UniSpeechSatForAudioFrameClassification.forward.example",$$slots:{default:[Ns]},$$scope:{ctx:U}}}),it=new L({}),lt=new J({props:{name:"class transformers.UniSpeechSatForXVector",anchor:"transformers.UniSpeechSatForXVector",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.UniSpeechSatForXVector.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatConfig">UniSpeechSatConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/unispeech_sat/modeling_unispeech_sat.py#L1834"}}),ct=new J({props:{name:"forward",anchor:"transformers.UniSpeechSatForXVector.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.Tensor]"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.UniSpeechSatForXVector.forward.input_values",description:`<strong>input_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>torch.FloatTensor</code>. See <a href="/docs/transformers/v4.34.0/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor.__call__">Wav2Vec2Processor.<strong>call</strong>()</a> for details.`,name:"input_values"},{anchor:"transformers.UniSpeechSatForXVector.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing convolution and attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p><code>attention_mask</code> should only be passed if the corresponding processor has <code>config.return_attention_mask == True</code>. For all models whose processor has <code>config.return_attention_mask == False</code>, such as
<a href="https://huggingface.co/microsoft/unispeech-sat-base-100h-libri-ft" rel="nofollow">microsoft/unispeech-sat-base-100h-libri-ft</a>,
<code>attention_mask</code> should <strong>not</strong> be passed to avoid degraded performance when doing batched inference. For
such models <code>input_values</code> should simply be padded with 0 and passed without <code>attention_mask</code>. Be aware
that these models also yield slightly different results depending on whether <code>input_values</code> is padded or
not.</p>

					</div>`,name:"attention_mask"},{anchor:"transformers.UniSpeechSatForXVector.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.UniSpeechSatForXVector.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.UniSpeechSatForXVector.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.UniSpeechSatForXVector.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/unispeech_sat/modeling_unispeech_sat.py#L1896",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.XVectorOutput"
>transformers.modeling_outputs.XVectorOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatConfig"
>UniSpeechSatConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.xvector_output_dim)</code>) — Classification hidden states before AMSoftmax.</p>
</li>
<li>
<p><strong>embeddings</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.xvector_output_dim)</code>) — Utterance embeddings used for vector similarity-based retrieval.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.XVectorOutput"
>transformers.modeling_outputs.XVectorOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Me=new ro({props:{$$slots:{default:[Xs]},$$scope:{ctx:U}}}),Ue=new _t({props:{anchor:"transformers.UniSpeechSatForXVector.forward.example",$$slots:{default:[zs]},$$scope:{ctx:U}}}),dt=new L({}),pt=new J({props:{name:"class transformers.UniSpeechSatForPreTraining",anchor:"transformers.UniSpeechSatForPreTraining",parameters:[{name:"config",val:": UniSpeechSatConfig"}],parametersDescription:[{anchor:"transformers.UniSpeechSatForPreTraining.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatConfig">UniSpeechSatConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/unispeech_sat/modeling_unispeech_sat.py#L1244"}}),ht=new J({props:{name:"forward",anchor:"transformers.UniSpeechSatForPreTraining.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.Tensor]"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.UniSpeechSatForPreTraining.forward.input_values",description:`<strong>input_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>torch.FloatTensor</code>. See <a href="/docs/transformers/v4.34.0/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor.__call__">Wav2Vec2Processor.<strong>call</strong>()</a> for details.`,name:"input_values"},{anchor:"transformers.UniSpeechSatForPreTraining.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing convolution and attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p><code>attention_mask</code> should only be passed if the corresponding processor has <code>config.return_attention_mask == True</code>. For all models whose processor has <code>config.return_attention_mask == False</code>, such as
<a href="https://huggingface.co/microsoft/unispeech-sat-base-100h-libri-ft" rel="nofollow">microsoft/unispeech-sat-base-100h-libri-ft</a>,
<code>attention_mask</code> should <strong>not</strong> be passed to avoid degraded performance when doing batched inference. For
such models <code>input_values</code> should simply be padded with 0 and passed without <code>attention_mask</code>. Be aware
that these models also yield slightly different results depending on whether <code>input_values</code> is padded or
not.</p>

					</div>`,name:"attention_mask"},{anchor:"transformers.UniSpeechSatForPreTraining.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.UniSpeechSatForPreTraining.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.UniSpeechSatForPreTraining.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/unispeech_sat/modeling_unispeech_sat.py#L1312",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/model_doc/unispeech-sat#transformers.models.unispeech_sat.modeling_unispeech_sat.UniSpeechSatForPreTrainingOutput"
>transformers.models.unispeech_sat.modeling_unispeech_sat.UniSpeechSatForPreTrainingOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatConfig"
>UniSpeechSatConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<em>optional</em>, returned when model is in train mode, <code>torch.FloatTensor</code> of shape <code>(1,)</code>) — Total loss as the sum of the contrastive loss (L_m) and the diversity loss (L_d) as stated in the <a
  href="https://arxiv.org/pdf/2006.11477.pdf"
  rel="nofollow"
>official
paper</a> . (classification) loss.</p>
</li>
<li>
<p><strong>projected_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.proj_codevector_dim)</code>) — Hidden-states of the model projected to <em>config.proj_codevector_dim</em> that can be used to predict the masked
projected quantized states.</p>
</li>
<li>
<p><strong>projected_quantized_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.proj_codevector_dim)</code>) — Quantized extracted feature vectors projected to <em>config.proj_codevector_dim</em> representing the positive
target vectors for contrastive loss.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/model_doc/unispeech-sat#transformers.models.unispeech_sat.modeling_unispeech_sat.UniSpeechSatForPreTrainingOutput"
>transformers.models.unispeech_sat.modeling_unispeech_sat.UniSpeechSatForPreTrainingOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ke=new ro({props:{$$slots:{default:[Gs]},$$scope:{ctx:U}}}),je=new _t({props:{anchor:"transformers.UniSpeechSatForPreTraining.forward.example",$$slots:{default:[Is]},$$scope:{ctx:U}}}),{c(){n=s("meta"),T=i(),d=s("p"),h=i(),S=s("h1"),a=s("a"),M=s("span"),g(Ve.$$.fragment),cn=i(),bt=s("span"),bt.textContent=fa,ko=i(),P=s("h2"),re=s("a"),io=s("span"),g(Ne.$$.fragment),dn=i(),yt=s("span"),yt.textContent=ga,jo=i(),Xe=s("p"),Xe.innerHTML=_a,Fo=i(),ze=s("p"),ze.textContent=va,$o=i(),Ge=s("p"),Ge.innerHTML=ba,xo=i(),Ie=s("p"),Ie.textContent=ya,Jo=i(),qe=s("ul"),qe.innerHTML=wa,Wo=i(),Be=s("p"),Be.innerHTML=Sa,Zo=i(),Q=s("h2"),ie=s("a"),lo=s("span"),g(Re.$$.fragment),pn=i(),wt=s("span"),wt.textContent=Ta,Vo=i(),Ye=s("ul"),Ye.innerHTML=Ma,No=i(),D=s("h2"),le=s("a"),co=s("span"),g(Le.$$.fragment),hn=i(),St=s("span"),St.textContent=Ua,Xo=i(),W=s("div"),g(Ae.$$.fragment),mn=i(),Tt=s("p"),Tt.innerHTML=Ca,un=i(),Mt=s("p"),Mt.innerHTML=ka,fn=i(),g(ce.$$.fragment),zo=i(),O=s("h2"),de=s("a"),po=s("span"),g(Ee.$$.fragment),gn=i(),Ut=s("span"),Ut.textContent=ja,Go=i(),K=s("div"),g(He.$$.fragment),_n=i(),Ct=s("p"),Ct.innerHTML=Fa,Io=i(),ee=s("h2"),pe=s("a"),ho=s("span"),g(Pe.$$.fragment),vn=i(),kt=s("span"),kt.textContent=$a,qo=i(),F=s("div"),g(Qe.$$.fragment),bn=i(),jt=s("p"),jt.innerHTML=xa,yn=i(),Ft=s("p"),Ft.innerHTML=Ja,wn=i(),$t=s("p"),$t.innerHTML=Wa,Sn=i(),V=s("div"),g(De.$$.fragment),Tn=i(),xt=s("p"),xt.innerHTML=Za,Mn=i(),g(he.$$.fragment),Un=i(),g(me.$$.fragment),Bo=i(),te=s("h2"),ue=s("a"),mo=s("span"),g(Oe.$$.fragment),Cn=i(),Jt=s("span"),Jt.textContent=Va,Ro=i(),$=s("div"),g(Ke.$$.fragment),kn=i(),Wt=s("p"),Wt.innerHTML=Na,jn=i(),Zt=s("p"),Zt.innerHTML=Xa,Fn=i(),Vt=s("p"),Vt.innerHTML=za,$n=i(),N=s("div"),g(et.$$.fragment),xn=i(),Nt=s("p"),Nt.innerHTML=Ga,Jn=i(),g(fe.$$.fragment),Wn=i(),g(ge.$$.fragment),Yo=i(),oe=s("h2"),_e=s("a"),uo=s("span"),g(tt.$$.fragment),Zn=i(),Xt=s("span"),Xt.textContent=Ia,Lo=i(),C=s("div"),g(ot.$$.fragment),Vn=i(),zt=s("p"),zt.textContent=qa,Nn=i(),Gt=s("p"),Gt.innerHTML=Ba,Xn=i(),It=s("p"),It.innerHTML=Ra,zn=i(),qt=s("p"),qt.innerHTML=Ya,Gn=i(),X=s("div"),g(nt.$$.fragment),In=i(),Bt=s("p"),Bt.innerHTML=La,qn=i(),g(ve.$$.fragment),Bn=i(),g(be.$$.fragment),Ao=i(),ne=s("h2"),ye=s("a"),fo=s("span"),g(at.$$.fragment),Rn=i(),Rt=s("span"),Rt.textContent=Aa,Eo=i(),k=s("div"),g(st.$$.fragment),Yn=i(),Yt=s("p"),Yt.textContent=Ea,Ln=i(),Lt=s("p"),Lt.innerHTML=Ha,An=i(),At=s("p"),At.innerHTML=Pa,En=i(),Et=s("p"),Et.innerHTML=Qa,Hn=i(),z=s("div"),g(rt.$$.fragment),Pn=i(),Ht=s("p"),Ht.innerHTML=Da,Qn=i(),g(we.$$.fragment),Dn=i(),g(Se.$$.fragment),Ho=i(),ae=s("h2"),Te=s("a"),go=s("span"),g(it.$$.fragment),On=i(),Pt=s("span"),Pt.textContent=Oa,Po=i(),j=s("div"),g(lt.$$.fragment),Kn=i(),Qt=s("p"),Qt.textContent=Ka,ea=i(),Dt=s("p"),Dt.innerHTML=es,ta=i(),Ot=s("p"),Ot.innerHTML=ts,oa=i(),Kt=s("p"),Kt.innerHTML=os,na=i(),G=s("div"),g(ct.$$.fragment),aa=i(),eo=s("p"),eo.innerHTML=ns,sa=i(),g(Me.$$.fragment),ra=i(),g(Ue.$$.fragment),Qo=i(),se=s("h2"),Ce=s("a"),_o=s("span"),g(dt.$$.fragment),ia=i(),to=s("span"),to.textContent=as,Do=i(),x=s("div"),g(pt.$$.fragment),la=i(),oo=s("p"),oo.innerHTML=ss,ca=i(),no=s("p"),no.innerHTML=rs,da=i(),ao=s("p"),ao.innerHTML=is,pa=i(),I=s("div"),g(ht.$$.fragment),ha=i(),so=s("p"),so.innerHTML=ls,ma=i(),g(ke.$$.fragment),ua=i(),g(je.$$.fragment),Oo=i(),vo=s("p"),this.h()},l(e){const c=ks("svelte-1phssyn",document.head);n=r(c,"META",{name:!0,content:!0}),c.forEach(o),T=l(e),d=r(e,"P",{}),f(d).forEach(o),h=l(e),S=r(e,"H1",{class:!0});var mt=f(S);a=r(mt,"A",{id:!0,class:!0,href:!0});var bo=f(a);M=r(bo,"SPAN",{});var yo=f(M);_(Ve.$$.fragment,yo),yo.forEach(o),bo.forEach(o),cn=l(mt),bt=r(mt,"SPAN",{"data-svelte-h":!0}),m(bt)!=="svelte-tf1j4a"&&(bt.textContent=fa),mt.forEach(o),ko=l(e),P=r(e,"H2",{class:!0});var ut=f(P);re=r(ut,"A",{id:!0,class:!0,href:!0});var wo=f(re);io=r(wo,"SPAN",{});var So=f(io);_(Ne.$$.fragment,So),So.forEach(o),wo.forEach(o),dn=l(ut),yt=r(ut,"SPAN",{"data-svelte-h":!0}),m(yt)!=="svelte-1jsw1pg"&&(yt.textContent=ga),ut.forEach(o),jo=l(e),Xe=r(e,"P",{"data-svelte-h":!0}),m(Xe)!=="svelte-1316kp6"&&(Xe.innerHTML=_a),Fo=l(e),ze=r(e,"P",{"data-svelte-h":!0}),m(ze)!=="svelte-vfdo9a"&&(ze.textContent=va),$o=l(e),Ge=r(e,"P",{"data-svelte-h":!0}),m(Ge)!=="svelte-11dzg5f"&&(Ge.innerHTML=ba),xo=l(e),Ie=r(e,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-axv494"&&(Ie.textContent=ya),Jo=l(e),qe=r(e,"UL",{"data-svelte-h":!0}),m(qe)!=="svelte-1sqsi8j"&&(qe.innerHTML=wa),Wo=l(e),Be=r(e,"P",{"data-svelte-h":!0}),m(Be)!=="svelte-1vgslzy"&&(Be.innerHTML=Sa),Zo=l(e),Q=r(e,"H2",{class:!0});var ft=f(Q);ie=r(ft,"A",{id:!0,class:!0,href:!0});var To=f(ie);lo=r(To,"SPAN",{});var Mo=f(lo);_(Re.$$.fragment,Mo),Mo.forEach(o),To.forEach(o),pn=l(ft),wt=r(ft,"SPAN",{"data-svelte-h":!0}),m(wt)!=="svelte-n3f0j0"&&(wt.textContent=Ta),ft.forEach(o),Vo=l(e),Ye=r(e,"UL",{"data-svelte-h":!0}),m(Ye)!=="svelte-11qmliz"&&(Ye.innerHTML=Ma),No=l(e),D=r(e,"H2",{class:!0});var gt=f(D);le=r(gt,"A",{id:!0,class:!0,href:!0});var Uo=f(le);co=r(Uo,"SPAN",{});var Co=f(co);_(Le.$$.fragment,Co),Co.forEach(o),Uo.forEach(o),hn=l(gt),St=r(gt,"SPAN",{"data-svelte-h":!0}),m(St)!=="svelte-utnr33"&&(St.textContent=Ua),gt.forEach(o),Xo=l(e),W=r(e,"DIV",{class:!0});var Y=f(W);_(Ae.$$.fragment,Y),mn=l(Y),Tt=r(Y,"P",{"data-svelte-h":!0}),m(Tt)!=="svelte-1g4bgfo"&&(Tt.innerHTML=Ca),un=l(Y),Mt=r(Y,"P",{"data-svelte-h":!0}),m(Mt)!=="svelte-10kqkkl"&&(Mt.innerHTML=ka),fn=l(Y),_(ce.$$.fragment,Y),Y.forEach(o),zo=l(e),O=r(e,"H2",{class:!0});var en=f(O);de=r(en,"A",{id:!0,class:!0,href:!0});var cs=f(de);po=r(cs,"SPAN",{});var ds=f(po);_(Ee.$$.fragment,ds),ds.forEach(o),cs.forEach(o),gn=l(en),Ut=r(en,"SPAN",{"data-svelte-h":!0}),m(Ut)!=="svelte-9nc27h"&&(Ut.textContent=ja),en.forEach(o),Go=l(e),K=r(e,"DIV",{class:!0});var tn=f(K);_(He.$$.fragment,tn),_n=l(tn),Ct=r(tn,"P",{"data-svelte-h":!0}),m(Ct)!=="svelte-1udj2li"&&(Ct.innerHTML=Fa),tn.forEach(o),Io=l(e),ee=r(e,"H2",{class:!0});var on=f(ee);pe=r(on,"A",{id:!0,class:!0,href:!0});var ps=f(pe);ho=r(ps,"SPAN",{});var hs=f(ho);_(Pe.$$.fragment,hs),hs.forEach(o),ps.forEach(o),vn=l(on),kt=r(on,"SPAN",{"data-svelte-h":!0}),m(kt)!=="svelte-1afmnta"&&(kt.textContent=$a),on.forEach(o),qo=l(e),F=r(e,"DIV",{class:!0});var A=f(F);_(Qe.$$.fragment,A),bn=l(A),jt=r(A,"P",{"data-svelte-h":!0}),m(jt)!=="svelte-sgxxah"&&(jt.innerHTML=xa),yn=l(A),Ft=r(A,"P",{"data-svelte-h":!0}),m(Ft)!=="svelte-1e6yl4y"&&(Ft.innerHTML=Ja),wn=l(A),$t=r(A,"P",{"data-svelte-h":!0}),m($t)!=="svelte-68lg8f"&&($t.innerHTML=Wa),Sn=l(A),V=r(A,"DIV",{class:!0});var Fe=f(V);_(De.$$.fragment,Fe),Tn=l(Fe),xt=r(Fe,"P",{"data-svelte-h":!0}),m(xt)!=="svelte-1v0zhy6"&&(xt.innerHTML=Za),Mn=l(Fe),_(he.$$.fragment,Fe),Un=l(Fe),_(me.$$.fragment,Fe),Fe.forEach(o),A.forEach(o),Bo=l(e),te=r(e,"H2",{class:!0});var nn=f(te);ue=r(nn,"A",{id:!0,class:!0,href:!0});var ms=f(ue);mo=r(ms,"SPAN",{});var us=f(mo);_(Oe.$$.fragment,us),us.forEach(o),ms.forEach(o),Cn=l(nn),Jt=r(nn,"SPAN",{"data-svelte-h":!0}),m(Jt)!=="svelte-t653de"&&(Jt.textContent=Va),nn.forEach(o),Ro=l(e),$=r(e,"DIV",{class:!0});var E=f($);_(Ke.$$.fragment,E),kn=l(E),Wt=r(E,"P",{"data-svelte-h":!0}),m(Wt)!=="svelte-l1kchy"&&(Wt.innerHTML=Na),jn=l(E),Zt=r(E,"P",{"data-svelte-h":!0}),m(Zt)!=="svelte-1e6yl4y"&&(Zt.innerHTML=Xa),Fn=l(E),Vt=r(E,"P",{"data-svelte-h":!0}),m(Vt)!=="svelte-68lg8f"&&(Vt.innerHTML=za),$n=l(E),N=r(E,"DIV",{class:!0});var $e=f(N);_(et.$$.fragment,$e),xn=l($e),Nt=r($e,"P",{"data-svelte-h":!0}),m(Nt)!=="svelte-1redb6g"&&(Nt.innerHTML=Ga),Jn=l($e),_(fe.$$.fragment,$e),Wn=l($e),_(ge.$$.fragment,$e),$e.forEach(o),E.forEach(o),Yo=l(e),oe=r(e,"H2",{class:!0});var an=f(oe);_e=r(an,"A",{id:!0,class:!0,href:!0});var fs=f(_e);uo=r(fs,"SPAN",{});var gs=f(uo);_(tt.$$.fragment,gs),gs.forEach(o),fs.forEach(o),Zn=l(an),Xt=r(an,"SPAN",{"data-svelte-h":!0}),m(Xt)!=="svelte-w4qthl"&&(Xt.textContent=Ia),an.forEach(o),Lo=l(e),C=r(e,"DIV",{class:!0});var q=f(C);_(ot.$$.fragment,q),Vn=l(q),zt=r(q,"P",{"data-svelte-h":!0}),m(zt)!=="svelte-u9su9i"&&(zt.textContent=qa),Nn=l(q),Gt=r(q,"P",{"data-svelte-h":!0}),m(Gt)!=="svelte-1g4oek0"&&(Gt.innerHTML=Ba),Xn=l(q),It=r(q,"P",{"data-svelte-h":!0}),m(It)!=="svelte-1e6yl4y"&&(It.innerHTML=Ra),zn=l(q),qt=r(q,"P",{"data-svelte-h":!0}),m(qt)!=="svelte-68lg8f"&&(qt.innerHTML=Ya),Gn=l(q),X=r(q,"DIV",{class:!0});var xe=f(X);_(nt.$$.fragment,xe),In=l(xe),Bt=r(xe,"P",{"data-svelte-h":!0}),m(Bt)!=="svelte-1wqk8bm"&&(Bt.innerHTML=La),qn=l(xe),_(ve.$$.fragment,xe),Bn=l(xe),_(be.$$.fragment,xe),xe.forEach(o),q.forEach(o),Ao=l(e),ne=r(e,"H2",{class:!0});var sn=f(ne);ye=r(sn,"A",{id:!0,class:!0,href:!0});var _s=f(ye);fo=r(_s,"SPAN",{});var vs=f(fo);_(at.$$.fragment,vs),vs.forEach(o),_s.forEach(o),Rn=l(sn),Rt=r(sn,"SPAN",{"data-svelte-h":!0}),m(Rt)!=="svelte-3ob5yf"&&(Rt.textContent=Aa),sn.forEach(o),Eo=l(e),k=r(e,"DIV",{class:!0});var B=f(k);_(st.$$.fragment,B),Yn=l(B),Yt=r(B,"P",{"data-svelte-h":!0}),m(Yt)!=="svelte-6truyz"&&(Yt.textContent=Ea),Ln=l(B),Lt=r(B,"P",{"data-svelte-h":!0}),m(Lt)!=="svelte-1g4oek0"&&(Lt.innerHTML=Ha),An=l(B),At=r(B,"P",{"data-svelte-h":!0}),m(At)!=="svelte-1e6yl4y"&&(At.innerHTML=Pa),En=l(B),Et=r(B,"P",{"data-svelte-h":!0}),m(Et)!=="svelte-68lg8f"&&(Et.innerHTML=Qa),Hn=l(B),z=r(B,"DIV",{class:!0});var Je=f(z);_(rt.$$.fragment,Je),Pn=l(Je),Ht=r(Je,"P",{"data-svelte-h":!0}),m(Ht)!=="svelte-7j9rj2"&&(Ht.innerHTML=Da),Qn=l(Je),_(we.$$.fragment,Je),Dn=l(Je),_(Se.$$.fragment,Je),Je.forEach(o),B.forEach(o),Ho=l(e),ae=r(e,"H2",{class:!0});var rn=f(ae);Te=r(rn,"A",{id:!0,class:!0,href:!0});var bs=f(Te);go=r(bs,"SPAN",{});var ys=f(go);_(it.$$.fragment,ys),ys.forEach(o),bs.forEach(o),On=l(rn),Pt=r(rn,"SPAN",{"data-svelte-h":!0}),m(Pt)!=="svelte-4f8w73"&&(Pt.textContent=Oa),rn.forEach(o),Po=l(e),j=r(e,"DIV",{class:!0});var R=f(j);_(lt.$$.fragment,R),Kn=l(R),Qt=r(R,"P",{"data-svelte-h":!0}),m(Qt)!=="svelte-e1970j"&&(Qt.textContent=Ka),ea=l(R),Dt=r(R,"P",{"data-svelte-h":!0}),m(Dt)!=="svelte-1g4oek0"&&(Dt.innerHTML=es),ta=l(R),Ot=r(R,"P",{"data-svelte-h":!0}),m(Ot)!=="svelte-1e6yl4y"&&(Ot.innerHTML=ts),oa=l(R),Kt=r(R,"P",{"data-svelte-h":!0}),m(Kt)!=="svelte-68lg8f"&&(Kt.innerHTML=os),na=l(R),G=r(R,"DIV",{class:!0});var We=f(G);_(ct.$$.fragment,We),aa=l(We),eo=r(We,"P",{"data-svelte-h":!0}),m(eo)!=="svelte-sv331u"&&(eo.innerHTML=ns),sa=l(We),_(Me.$$.fragment,We),ra=l(We),_(Ue.$$.fragment,We),We.forEach(o),R.forEach(o),Qo=l(e),se=r(e,"H2",{class:!0});var ln=f(se);Ce=r(ln,"A",{id:!0,class:!0,href:!0});var ws=f(Ce);_o=r(ws,"SPAN",{});var Ss=f(_o);_(dt.$$.fragment,Ss),Ss.forEach(o),ws.forEach(o),ia=l(ln),to=r(ln,"SPAN",{"data-svelte-h":!0}),m(to)!=="svelte-poph43"&&(to.textContent=as),ln.forEach(o),Do=l(e),x=r(e,"DIV",{class:!0});var H=f(x);_(pt.$$.fragment,H),la=l(H),oo=r(H,"P",{"data-svelte-h":!0}),m(oo)!=="svelte-k6trrs"&&(oo.innerHTML=ss),ca=l(H),no=r(H,"P",{"data-svelte-h":!0}),m(no)!=="svelte-1e6yl4y"&&(no.innerHTML=rs),da=l(H),ao=r(H,"P",{"data-svelte-h":!0}),m(ao)!=="svelte-68lg8f"&&(ao.innerHTML=is),pa=l(H),I=r(H,"DIV",{class:!0});var Ze=f(I);_(ht.$$.fragment,Ze),ha=l(Ze),so=r(Ze,"P",{"data-svelte-h":!0}),m(so)!=="svelte-vp28yu"&&(so.innerHTML=ls),ma=l(Ze),_(ke.$$.fragment,Ze),ua=l(Ze),_(je.$$.fragment,Ze),Ze.forEach(o),H.forEach(o),Oo=l(e),vo=r(e,"P",{}),f(vo).forEach(o),this.h()},h(){u(n,"name","hf:doc:metadata"),u(n,"content",JSON.stringify(Bs)),u(a,"id","unispeechsat"),u(a,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(a,"href","#unispeechsat"),u(S,"class","relative group"),u(re,"id","overview"),u(re,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(re,"href","#overview"),u(P,"class","relative group"),u(ie,"id","documentation-resources"),u(ie,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(ie,"href","#documentation-resources"),u(Q,"class","relative group"),u(le,"id","transformers.UniSpeechSatConfig"),u(le,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(le,"href","#transformers.UniSpeechSatConfig"),u(D,"class","relative group"),u(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(de,"id","transformers.models.unispeech_sat.modeling_unispeech_sat.UniSpeechSatForPreTrainingOutput"),u(de,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(de,"href","#transformers.models.unispeech_sat.modeling_unispeech_sat.UniSpeechSatForPreTrainingOutput"),u(O,"class","relative group"),u(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(pe,"id","transformers.UniSpeechSatModel"),u(pe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(pe,"href","#transformers.UniSpeechSatModel"),u(ee,"class","relative group"),u(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(ue,"id","transformers.UniSpeechSatForCTC"),u(ue,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(ue,"href","#transformers.UniSpeechSatForCTC"),u(te,"class","relative group"),u(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(_e,"id","transformers.UniSpeechSatForSequenceClassification"),u(_e,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(_e,"href","#transformers.UniSpeechSatForSequenceClassification"),u(oe,"class","relative group"),u(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(ye,"id","transformers.UniSpeechSatForAudioFrameClassification"),u(ye,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(ye,"href","#transformers.UniSpeechSatForAudioFrameClassification"),u(ne,"class","relative group"),u(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(Te,"id","transformers.UniSpeechSatForXVector"),u(Te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(Te,"href","#transformers.UniSpeechSatForXVector"),u(ae,"class","relative group"),u(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(Ce,"id","transformers.UniSpeechSatForPreTraining"),u(Ce,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(Ce,"href","#transformers.UniSpeechSatForPreTraining"),u(se,"class","relative group"),u(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){t(document.head,n),p(e,T,c),p(e,d,c),p(e,h,c),p(e,S,c),t(S,a),t(a,M),v(Ve,M,null),t(S,cn),t(S,bt),p(e,ko,c),p(e,P,c),t(P,re),t(re,io),v(Ne,io,null),t(P,dn),t(P,yt),p(e,jo,c),p(e,Xe,c),p(e,Fo,c),p(e,ze,c),p(e,$o,c),p(e,Ge,c),p(e,xo,c),p(e,Ie,c),p(e,Jo,c),p(e,qe,c),p(e,Wo,c),p(e,Be,c),p(e,Zo,c),p(e,Q,c),t(Q,ie),t(ie,lo),v(Re,lo,null),t(Q,pn),t(Q,wt),p(e,Vo,c),p(e,Ye,c),p(e,No,c),p(e,D,c),t(D,le),t(le,co),v(Le,co,null),t(D,hn),t(D,St),p(e,Xo,c),p(e,W,c),v(Ae,W,null),t(W,mn),t(W,Tt),t(W,un),t(W,Mt),t(W,fn),v(ce,W,null),p(e,zo,c),p(e,O,c),t(O,de),t(de,po),v(Ee,po,null),t(O,gn),t(O,Ut),p(e,Go,c),p(e,K,c),v(He,K,null),t(K,_n),t(K,Ct),p(e,Io,c),p(e,ee,c),t(ee,pe),t(pe,ho),v(Pe,ho,null),t(ee,vn),t(ee,kt),p(e,qo,c),p(e,F,c),v(Qe,F,null),t(F,bn),t(F,jt),t(F,yn),t(F,Ft),t(F,wn),t(F,$t),t(F,Sn),t(F,V),v(De,V,null),t(V,Tn),t(V,xt),t(V,Mn),v(he,V,null),t(V,Un),v(me,V,null),p(e,Bo,c),p(e,te,c),t(te,ue),t(ue,mo),v(Oe,mo,null),t(te,Cn),t(te,Jt),p(e,Ro,c),p(e,$,c),v(Ke,$,null),t($,kn),t($,Wt),t($,jn),t($,Zt),t($,Fn),t($,Vt),t($,$n),t($,N),v(et,N,null),t(N,xn),t(N,Nt),t(N,Jn),v(fe,N,null),t(N,Wn),v(ge,N,null),p(e,Yo,c),p(e,oe,c),t(oe,_e),t(_e,uo),v(tt,uo,null),t(oe,Zn),t(oe,Xt),p(e,Lo,c),p(e,C,c),v(ot,C,null),t(C,Vn),t(C,zt),t(C,Nn),t(C,Gt),t(C,Xn),t(C,It),t(C,zn),t(C,qt),t(C,Gn),t(C,X),v(nt,X,null),t(X,In),t(X,Bt),t(X,qn),v(ve,X,null),t(X,Bn),v(be,X,null),p(e,Ao,c),p(e,ne,c),t(ne,ye),t(ye,fo),v(at,fo,null),t(ne,Rn),t(ne,Rt),p(e,Eo,c),p(e,k,c),v(st,k,null),t(k,Yn),t(k,Yt),t(k,Ln),t(k,Lt),t(k,An),t(k,At),t(k,En),t(k,Et),t(k,Hn),t(k,z),v(rt,z,null),t(z,Pn),t(z,Ht),t(z,Qn),v(we,z,null),t(z,Dn),v(Se,z,null),p(e,Ho,c),p(e,ae,c),t(ae,Te),t(Te,go),v(it,go,null),t(ae,On),t(ae,Pt),p(e,Po,c),p(e,j,c),v(lt,j,null),t(j,Kn),t(j,Qt),t(j,ea),t(j,Dt),t(j,ta),t(j,Ot),t(j,oa),t(j,Kt),t(j,na),t(j,G),v(ct,G,null),t(G,aa),t(G,eo),t(G,sa),v(Me,G,null),t(G,ra),v(Ue,G,null),p(e,Qo,c),p(e,se,c),t(se,Ce),t(Ce,_o),v(dt,_o,null),t(se,ia),t(se,to),p(e,Do,c),p(e,x,c),v(pt,x,null),t(x,la),t(x,oo),t(x,ca),t(x,no),t(x,da),t(x,ao),t(x,pa),t(x,I),v(ht,I,null),t(I,ha),t(I,so),t(I,ma),v(ke,I,null),t(I,ua),v(je,I,null),p(e,Oo,c),p(e,vo,c),Ko=!0},p(e,[c]){const mt={};c&2&&(mt.$$scope={dirty:c,ctx:e}),ce.$set(mt);const bo={};c&2&&(bo.$$scope={dirty:c,ctx:e}),he.$set(bo);const yo={};c&2&&(yo.$$scope={dirty:c,ctx:e}),me.$set(yo);const ut={};c&2&&(ut.$$scope={dirty:c,ctx:e}),fe.$set(ut);const wo={};c&2&&(wo.$$scope={dirty:c,ctx:e}),ge.$set(wo);const So={};c&2&&(So.$$scope={dirty:c,ctx:e}),ve.$set(So);const ft={};c&2&&(ft.$$scope={dirty:c,ctx:e}),be.$set(ft);const To={};c&2&&(To.$$scope={dirty:c,ctx:e}),we.$set(To);const Mo={};c&2&&(Mo.$$scope={dirty:c,ctx:e}),Se.$set(Mo);const gt={};c&2&&(gt.$$scope={dirty:c,ctx:e}),Me.$set(gt);const Uo={};c&2&&(Uo.$$scope={dirty:c,ctx:e}),Ue.$set(Uo);const Co={};c&2&&(Co.$$scope={dirty:c,ctx:e}),ke.$set(Co);const Y={};c&2&&(Y.$$scope={dirty:c,ctx:e}),je.$set(Y)},i(e){Ko||(b(Ve.$$.fragment,e),b(Ne.$$.fragment,e),b(Re.$$.fragment,e),b(Le.$$.fragment,e),b(Ae.$$.fragment,e),b(ce.$$.fragment,e),b(Ee.$$.fragment,e),b(He.$$.fragment,e),b(Pe.$$.fragment,e),b(Qe.$$.fragment,e),b(De.$$.fragment,e),b(he.$$.fragment,e),b(me.$$.fragment,e),b(Oe.$$.fragment,e),b(Ke.$$.fragment,e),b(et.$$.fragment,e),b(fe.$$.fragment,e),b(ge.$$.fragment,e),b(tt.$$.fragment,e),b(ot.$$.fragment,e),b(nt.$$.fragment,e),b(ve.$$.fragment,e),b(be.$$.fragment,e),b(at.$$.fragment,e),b(st.$$.fragment,e),b(rt.$$.fragment,e),b(we.$$.fragment,e),b(Se.$$.fragment,e),b(it.$$.fragment,e),b(lt.$$.fragment,e),b(ct.$$.fragment,e),b(Me.$$.fragment,e),b(Ue.$$.fragment,e),b(dt.$$.fragment,e),b(pt.$$.fragment,e),b(ht.$$.fragment,e),b(ke.$$.fragment,e),b(je.$$.fragment,e),Ko=!0)},o(e){y(Ve.$$.fragment,e),y(Ne.$$.fragment,e),y(Re.$$.fragment,e),y(Le.$$.fragment,e),y(Ae.$$.fragment,e),y(ce.$$.fragment,e),y(Ee.$$.fragment,e),y(He.$$.fragment,e),y(Pe.$$.fragment,e),y(Qe.$$.fragment,e),y(De.$$.fragment,e),y(he.$$.fragment,e),y(me.$$.fragment,e),y(Oe.$$.fragment,e),y(Ke.$$.fragment,e),y(et.$$.fragment,e),y(fe.$$.fragment,e),y(ge.$$.fragment,e),y(tt.$$.fragment,e),y(ot.$$.fragment,e),y(nt.$$.fragment,e),y(ve.$$.fragment,e),y(be.$$.fragment,e),y(at.$$.fragment,e),y(st.$$.fragment,e),y(rt.$$.fragment,e),y(we.$$.fragment,e),y(Se.$$.fragment,e),y(it.$$.fragment,e),y(lt.$$.fragment,e),y(ct.$$.fragment,e),y(Me.$$.fragment,e),y(Ue.$$.fragment,e),y(dt.$$.fragment,e),y(pt.$$.fragment,e),y(ht.$$.fragment,e),y(ke.$$.fragment,e),y(je.$$.fragment,e),Ko=!1},d(e){e&&(o(T),o(d),o(h),o(S),o(ko),o(P),o(jo),o(Xe),o(Fo),o(ze),o($o),o(Ge),o(xo),o(Ie),o(Jo),o(qe),o(Wo),o(Be),o(Zo),o(Q),o(Vo),o(Ye),o(No),o(D),o(Xo),o(W),o(zo),o(O),o(Go),o(K),o(Io),o(ee),o(qo),o(F),o(Bo),o(te),o(Ro),o($),o(Yo),o(oe),o(Lo),o(C),o(Ao),o(ne),o(Eo),o(k),o(Ho),o(ae),o(Po),o(j),o(Qo),o(se),o(Do),o(x),o(Oo),o(vo)),o(n),w(Ve),w(Ne),w(Re),w(Le),w(Ae),w(ce),w(Ee),w(He),w(Pe),w(Qe),w(De),w(he),w(me),w(Oe),w(Ke),w(et),w(fe),w(ge),w(tt),w(ot),w(nt),w(ve),w(be),w(at),w(st),w(rt),w(we),w(Se),w(it),w(lt),w(ct),w(Me),w(Ue),w(dt),w(pt),w(ht),w(ke),w(je)}}}const Bs={local:"unispeechsat",sections:[{local:"overview",title:"Overview"},{local:"documentation-resources",title:"Documentation resources"},{local:"transformers.UniSpeechSatConfig",title:"UniSpeechSatConfig"},{local:"transformers.models.unispeech_sat.modeling_unispeech_sat.UniSpeechSatForPreTrainingOutput",title:"UniSpeechSat specific outputs"},{local:"transformers.UniSpeechSatModel",title:"UniSpeechSatModel"},{local:"transformers.UniSpeechSatForCTC",title:"UniSpeechSatForCTC"},{local:"transformers.UniSpeechSatForSequenceClassification",title:"UniSpeechSatForSequenceClassification"},{local:"transformers.UniSpeechSatForAudioFrameClassification",title:"UniSpeechSatForAudioFrameClassification"},{local:"transformers.UniSpeechSatForXVector",title:"UniSpeechSatForXVector"},{local:"transformers.UniSpeechSatForPreTraining",title:"UniSpeechSatForPreTraining"}],title:"UniSpeech-SAT"};function Rs(U){return Ms(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ds extends Us{constructor(n){super(),Cs(this,n,Rs,qs,Ts,{})}}export{Ds as component};
