import{s as pp,f as mp,o as up,n as hp}from"../chunks/scheduler.9bc65507.js";import{S as cp,i as fp,g as i,s as o,u as h,A as yp,h as a,f as n,c as s,j as w,v as p,y as r,k as d,o as y,a as l,w as m,d as u,t as c,x as f}from"../chunks/index.78c82d43.js";import{T as dp}from"../chunks/Tip.87d55b76.js";import{I as b}from"../chunks/IconCopyLink.bedaa44d.js";import{C as M}from"../chunks/CodeBlock.73e038be.js";function wp(Jl){let T,v='If you’re interested in implementing a TensorFlow model, take a look at the <a href="add_tensorflow_model">How to convert a 🤗 Transformers model to TensorFlow</a> guide!';return{c(){T=i("p"),T.innerHTML=v},l(g){T=a(g,"P",{"data-svelte-h":!0}),r(T)!=="svelte-dn397l"&&(T.innerHTML=v)},m(g,H){l(g,T,H)},p:hp,d(g){g&&n(T)}}}function Mp(Jl){let T,v="In case you are using Windows, you should replace <code>RUN_SLOW=1</code> with <code>SET RUN_SLOW=1</code>";return{c(){T=i("p"),T.innerHTML=v},l(g){T=a(g,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1w9gxqz"&&(T.innerHTML=v)},m(g,H){l(g,T,H)},p:hp,d(g){g&&n(T)}}}function Tp(Jl){let T,v,g,H,J,N,Zl,te,Ba,jl,Ya="How to add a model to 🤗 Transformers?",Fl,ne,Fa='The 🤗 Transformers library is often able to offer new models thanks to community contributors. But this can be a challenging project and requires an in-depth knowledge of the 🤗 Transformers library and the model to implement. At Hugging Face, we’re trying to empower more of the community to actively add models and we’ve put together this guide to walk you through the process of adding a PyTorch model (make sure you have <a href="https://pytorch.org/get-started/locally/" rel="nofollow">PyTorch installed</a>).',Xl,Z,ql,le,Xa="Along the way, you’ll:",Ol,oe,qa="<li>get insights into open-source best practices</li> <li>understand the design principles behind one of the most popular deep learning libraries</li> <li>learn how to efficiently test large models</li> <li>learn how to integrate Python utilities like <code>black</code>, <code>ruff</code>, and <code>make fix-copies</code> to ensure clean and readable code</li>",Kl,se,Oa="A Hugging Face team member will be available to help you along the way so you’ll never be alone. 🤗 ❤️",eo,ie,Ka='To get started, open a <a href="https://github.com/huggingface/transformers/issues/new?assignees=&amp;labels=New+model&amp;template=new-model-addition.yml" rel="nofollow">New model addition</a> issue for the model you want to see in 🤗 Transformers. If you’re not especially picky about contributing a specific model, you can filter by the <a href="https://github.com/huggingface/transformers/labels/New%20model" rel="nofollow">New model label</a> to see if there are any unclaimed model requests and work on it.',to,ae,er="Once you’ve opened a new model request, the first step is to get familiar with 🤗 Transformers if you aren’t already!",no,j,B,Bl,re,Wa,Cl,tr="General overview of 🤗 Transformers",lo,de,nr=`First, you should get a general overview of 🤗 Transformers. 🤗 Transformers is a very opinionated library, so there is a
chance that you don’t agree with some of the library’s philosophies or design choices. From our experience, however, we
found that the fundamental design choices and philosophies of the library are crucial to efficiently scale 🤗
Transformers while keeping maintenance costs at a reasonable level.`,oo,he,lr='A good first starting point to better understand the library is to read the <a href="philosophy">documentation of our philosophy</a>. As a result of our way of working, there are some choices that we try to apply to all models:',so,pe,or=`<li>Composition is generally favored over-abstraction</li> <li>Duplicating code is not always bad if it strongly improves the readability or accessibility of a model</li> <li>Model files are as self-contained as possible so that when you read the code of a specific model, you ideally only
have to look into the respective <code>modeling_....py</code> file.</li>`,io,me,sr=`In our opinion, the library’s code is not just a means to provide a product, <em>e.g.</em> the ability to use BERT for
inference, but also as the very product that we want to improve. Hence, when adding a model, the user is not only the
person who will use your model, but also everybody who will read, try to understand, and possibly tweak your code.`,ao,ue,ir="With this in mind, let’s go a bit deeper into the general library design.",ro,C,W,Wl,ce,Pa,kl,ar="Overview of models",ho,fe,rr=`To successfully add a model, it is important to understand the interaction between your model and its config,
<a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>, and <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>. For exemplary purposes, we will
call the model to be added to 🤗 Transformers <code>BrandNewBert</code>.`,po,ye,dr="Let’s take a look:",mo,_l,hr,uo,we,pr=`As you can see, we do make use of inheritance in 🤗 Transformers, but we keep the level of abstraction to an absolute
minimum. There are never more than two levels of abstraction for any model in the library. <code>BrandNewBertModel</code>
inherits from <code>BrandNewBertPreTrainedModel</code> which in turn inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> and
that’s it. As a general rule, we want to make sure that a new model only depends on
<a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. The important functionalities that are automatically provided to every new
model are <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> and
<a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, which are used for serialization and deserialization. All of the
other important functionalities, such as <code>BrandNewBertModel.forward</code> should be completely defined in the new
<code>modeling_brand_new_bert.py</code> script. Next, we want to make sure that a model with a specific head layer, such as
<code>BrandNewBertForMaskedLM</code> does not inherit from <code>BrandNewBertModel</code>, but rather uses <code>BrandNewBertModel</code>
as a component that can be called in its forward pass to keep the level of abstraction low. Every new model requires a
configuration class, called <code>BrandNewBertConfig</code>. This configuration is always stored as an attribute in
<a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>, and thus can be accessed via the <code>config</code> attribute for all classes
inheriting from <code>BrandNewBertPreTrainedModel</code>:`,co,Me,fo,Te,mr=`Similar to the model, the configuration inherits basic serialization and deserialization functionalities from
<a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>. Note that the configuration and the model are always serialized into two
different formats - the model to a <em>pytorch_model.bin</em> file and the configuration to a <em>config.json</em> file. Calling
<a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> will automatically call
<a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig.save_pretrained">save_pretrained()</a>, so that both model and configuration are saved.`,yo,k,P,Pl,ge,Ea,Ul,ur="Code style",wo,be,cr=`When coding your new model, keep in mind that Transformers is an opinionated library and we have a few quirks of our
own regarding how code should be written :-)`,Mo,ve,fr=`<li>The forward pass of your model should be fully written in the modeling file while being fully independent of other
models in the library. If you want to reuse a block from another model, copy the code and paste it with a
<code># Copied from</code> comment on top (see <a href="https://github.com/huggingface/transformers/blob/v4.17.0/src/transformers/models/roberta/modeling_roberta.py#L160" rel="nofollow">here</a>
for a good example and <a href="pr_checks#check-copies">there</a> for more documentation on Copied from).</li> <li>The code should be fully understandable, even by a non-native English speaker. This means you should pick
descriptive variable names and avoid abbreviations. As an example, <code>activation</code> is preferred to <code>act</code>.
One-letter variable names are strongly discouraged unless it’s an index in a for loop.</li> <li>More generally we prefer longer explicit code to short magical one.</li> <li>Avoid subclassing <code>nn.Sequential</code> in PyTorch but subclass <code>nn.Module</code> and write the forward pass, so that anyone
using your code can quickly debug it by adding print statements or breaking points.</li> <li>Your function signature should be type-annotated. For the rest, good variable names are way more readable and
understandable than type annotations.</li>`,To,_,E,El,Je,Ra,xl,yr="Overview of tokenizers",go,je,wr="Not quite ready yet :-( This section will be added soon!",bo,U,R,Rl,Ce,za,Il,Mr="Step-by-step recipe to add a model to 🤗 Transformers",vo,ke,Tr=`Everyone has different preferences of how to port a model so it can be very helpful for you to take a look at summaries
of how other contributors ported models to Hugging Face. Here is a list of community blog posts on how to port a model:`,Jo,_e,gr='<li><a href="https://medium.com/huggingface/from-tensorflow-to-pytorch-265f40ef2a28" rel="nofollow">Porting GPT2 Model</a> by <a href="https://huggingface.co/thomwolf" rel="nofollow">Thomas</a></li> <li><a href="https://huggingface.co/blog/porting-fsmt" rel="nofollow">Porting WMT19 MT Model</a> by <a href="https://huggingface.co/stas" rel="nofollow">Stas</a></li>',jo,Ue,br="From experience, we can tell you that the most important things to keep in mind when adding a model are:",Co,xe,vr=`<li>Don’t reinvent the wheel! Most parts of the code you will add for the new 🤗 Transformers model already exist
somewhere in 🤗 Transformers. Take some time to find similar, already existing models and tokenizers you can copy
from. <a href="https://www.gnu.org/software/grep/" rel="nofollow">grep</a> and <a href="https://github.com/BurntSushi/ripgrep" rel="nofollow">rg</a> are your
friends. Note that it might very well happen that your model’s tokenizer is based on one model implementation, and
your model’s modeling code on another one. <em>E.g.</em> FSMT’s modeling code is based on BART, while FSMT’s tokenizer code
is based on XLM.</li> <li>It’s more of an engineering challenge than a scientific challenge. You should spend more time creating an
efficient debugging environment rather than trying to understand all theoretical aspects of the model in the paper.</li> <li>Ask for help, when you’re stuck! Models are the core component of 🤗 Transformers so we at Hugging Face are more
than happy to help you at every step to add your model. Don’t hesitate to ask if you notice you are not making
progress.</li>`,ko,Ie,Jr="In the following, we try to give you a general recipe that we found most useful when porting a model to 🤗 Transformers.",_o,$e,jr=`The following list is a summary of everything that has to be done to add a model and can be used by you as a To-Do
List:`,Uo,Ae,Cr=`☐ (Optional) Understood the model’s theoretical aspects<br/>
☐ Prepared 🤗 Transformers dev environment<br/>
☐ Set up debugging environment of the original repository<br/>
☐ Created script that successfully runs the <code>forward()</code> pass using the original repository and checkpoint<br/>
☐ Successfully added the model skeleton to 🤗 Transformers<br/>
☐ Successfully converted original checkpoint to 🤗 Transformers checkpoint<br/>
☐ Successfully ran <code>forward()</code> pass in 🤗 Transformers that gives identical output to original checkpoint<br/>
☐ Finished model tests in 🤗 Transformers<br/>
☐ Successfully added tokenizer in 🤗 Transformers<br/>
☐ Run end-to-end integration tests<br/>
☐ Finished docs<br/>
☐ Uploaded model weights to the Hub<br/>
☐ Submitted the pull request<br/>
☐ (Optional) Added a demo notebook`,xo,Le,kr=`To begin with, we usually recommend starting by getting a good theoretical understanding of <code>BrandNewBert</code>. However,
if you prefer to understand the theoretical aspects of the model <em>on-the-job</em>, then it is totally fine to directly dive
into the <code>BrandNewBert</code>’s code-base. This option might suit you better if your engineering skills are better than
your theoretical skill, if you have trouble understanding <code>BrandNewBert</code>’s paper, or if you just enjoy programming
much more than reading scientific papers.`,Io,x,z,zl,He,Ga,$l,_r="1. (Optional) Theoretical aspects of BrandNewBert",$o,Ne,Ur=`You should take some time to read <em>BrandNewBert’s</em> paper, if such descriptive work exists. There might be large
sections of the paper that are difficult to understand. If this is the case, this is fine - don’t worry! The goal is
not to get a deep theoretical understanding of the paper, but to extract the necessary information required to
effectively re-implement the model in 🤗 Transformers. That being said, you don’t have to spend too much time on the
theoretical aspects, but rather focus on the practical ones, namely:`,Ao,Ze,xr=`<li>What type of model is <em>brand_new_bert</em>? BERT-like encoder-only model? GPT2-like decoder-only model? BART-like
encoder-decoder model? Look at the <a href="model_summary">model_summary</a> if you’re not familiar with the differences between those.</li> <li>What are the applications of <em>brand_new_bert</em>? Text classification? Text generation? Seq2Seq tasks, <em>e.g.,</em>
summarization?</li> <li>What is the novel feature of the model that makes it different from BERT/GPT-2/BART?</li> <li>Which of the already existing <a href="https://huggingface.co/transformers/#contents" rel="nofollow">🤗 Transformers models</a> is most
similar to <em>brand_new_bert</em>?</li> <li>What type of tokenizer is used? A sentencepiece tokenizer? Word piece tokenizer? Is it the same tokenizer as used
for BERT or BART?</li>`,Lo,Be,Ir=`After you feel like you have gotten a good overview of the architecture of the model, you might want to write to the
Hugging Face team with any questions you might have. This might include questions regarding the model’s architecture,
its attention layer, etc. We will be more than happy to help you.`,Ho,I,G,Gl,We,Qa,Al,$r="2. Next prepare your environment",No,Pe,Ar=`<li><p>Fork the <a href="https://github.com/huggingface/transformers" rel="nofollow">repository</a> by clicking on the ‘Fork’ button on the
repository’s page. This creates a copy of the code under your GitHub user account.</p></li> <li><p>Clone your <code>transformers</code> fork to your local disk, and add the base repository as a remote:</p></li>`,Zo,Ee,Bo,Q,Lr="<li>Set up a development environment, for instance by running the following command:</li>",Wo,Re,Po,ze,Hr=`Depending on your OS, and since the number of optional dependencies of Transformers is growing, you might get a
failure with this command. If that’s the case make sure to install the Deep Learning framework you are working with
(PyTorch, TensorFlow and/or Flax) then do:`,Eo,Ge,Ro,Qe,Nr="which should be enough for most use cases. You can then return to the parent directory",zo,Ve,Go,V,Zr=`<li>We recommend adding the PyTorch version of <em>brand_new_bert</em> to Transformers. To install PyTorch, please follow the
instructions on <a href="https://pytorch.org/get-started/locally/" rel="nofollow">https://pytorch.org/get-started/locally/</a>.</li>`,Qo,De,Br="<strong>Note:</strong> You don’t need to have CUDA installed. Making the new model work on CPU is sufficient.",Vo,D,Wr="<li>To port <em>brand_new_bert</em>, you will also need access to its original repository:</li>",Do,Se,So,Ye,Pr="Now you have set up a development environment to port <em>brand_new_bert</em> to 🤗 Transformers.",Yo,$,S,Ql,Fe,Va,Ll,Er="3.-4. Run a pretrained checkpoint using the original repository",Fo,Xe,Rr=`At first, you will work on the original <em>brand_new_bert</em> repository. Often, the original implementation is very
“researchy”. Meaning that documentation might be lacking and the code can be difficult to understand. But this should
be exactly your motivation to reimplement <em>brand_new_bert</em>. At Hugging Face, one of our main goals is to <em>make people
stand on the shoulders of giants</em> which translates here very well into taking a working model and rewriting it to make
it as <strong>accessible, user-friendly, and beautiful</strong> as possible. This is the number-one motivation to re-implement
models into 🤗 Transformers - trying to make complex new NLP technology accessible to <strong>everybody</strong>.`,Xo,qe,zr="You should start thereby by diving into the original repository.",qo,Oe,Gr=`Successfully running the official pretrained model in the original repository is often <strong>the most difficult</strong> step.
From our experience, it is very important to spend some time getting familiar with the original code-base. You need to
figure out the following:`,Oo,Ke,Qr=`<li>Where to find the pretrained weights?</li> <li>How to load the pretrained weights into the corresponding model?</li> <li>How to run the tokenizer independently from the model?</li> <li>Trace one forward pass so that you know which classes and functions are required for a simple forward pass. Usually,
you only have to reimplement those functions.</li> <li>Be able to locate the important components of the model: Where is the model’s class? Are there model sub-classes,
<em>e.g.</em> EncoderModel, DecoderModel? Where is the self-attention layer? Are there multiple different attention layers,
<em>e.g.</em> <em>self-attention</em>, <em>cross-attention</em>…?</li> <li>How can you debug the model in the original environment of the repo? Do you have to add <em>print</em> statements, can you
work with an interactive debugger like <em>ipdb</em>, or should you use an efficient IDE to debug the model, like PyCharm?</li>`,Ko,et,Vr=`It is very important that before you start the porting process, you can <strong>efficiently</strong> debug code in the original
repository! Also, remember that you are working with an open-source library, so do not hesitate to open an issue, or
even a pull request in the original repository. The maintainers of this repository are most likely very happy about
someone looking into their code!`,es,tt,Dr=`At this point, it is really up to you which debugging environment and strategy you prefer to use to debug the original
model. We strongly advise against setting up a costly GPU environment, but simply work on a CPU both when starting to
dive into the original repository and also when starting to write the 🤗 Transformers implementation of the model. Only
at the very end, when the model has already been successfully ported to 🤗 Transformers, one should verify that the
model also works as expected on GPU.`,ts,nt,Sr="In general, there are two possible debugging environments for running the original model",ns,lt,Yr='<li><a href="https://jupyter.org/" rel="nofollow">Jupyter notebooks</a> / <a href="https://colab.research.google.com/notebooks/intro.ipynb" rel="nofollow">google colab</a></li> <li>Local python scripts.</li>',ls,ot,Fr=`Jupyter notebooks have the advantage that they allow for cell-by-cell execution which can be helpful to better split
logical components from one another and to have faster debugging cycles as intermediate results can be stored. Also,
notebooks are often easier to share with other contributors, which might be very helpful if you want to ask the Hugging
Face team for help. If you are familiar with Jupyter notebooks, we strongly recommend you work with them.`,os,st,Xr=`The obvious disadvantage of Jupyter notebooks is that if you are not used to working with them you will have to spend
some time adjusting to the new programming environment and you might not be able to use your known debugging tools
anymore, like <code>ipdb</code>.`,ss,it,qr=`For each code-base, a good first step is always to load a <strong>small</strong> pretrained checkpoint and to be able to reproduce a
single forward pass using a dummy integer vector of input IDs as an input. Such a script could look like this (in
pseudocode):`,is,at,as,rt,Or="Next, regarding the debugging strategy, there are generally a few from which to choose from:",rs,dt,Kr=`<li>Decompose the original model into many small testable components and run a forward pass on each of those for
verification</li> <li>Decompose the original model only into the original <em>tokenizer</em> and the original <em>model</em>, run a forward pass on
those, and use intermediate print statements or breakpoints for verification</li>`,ds,ht,ed=`Again, it is up to you which strategy to choose. Often, one or the other is advantageous depending on the original code
base.`,hs,pt,td=`If the original code-base allows you to decompose the model into smaller sub-components, <em>e.g.</em> if the original
code-base can easily be run in eager mode, it is usually worth the effort to do so. There are some important advantages
to taking the more difficult road in the beginning:`,ps,mt,nd=`<li>at a later stage when comparing the original model to the Hugging Face implementation, you can verify automatically
for each component individually that the corresponding component of the 🤗 Transformers implementation matches instead
of relying on visual comparison via print statements</li> <li>it can give you some rope to decompose the big problem of porting a model into smaller problems of just porting
individual components and thus structure your work better</li> <li>separating the model into logical meaningful components will help you to get a better overview of the model’s design
and thus to better understand the model</li> <li>at a later stage those component-by-component tests help you to ensure that no regression occurs as you continue
changing your code</li>`,ms,ut,ld=`<a href="https://gist.github.com/LysandreJik/db4c948f6b4483960de5cbac598ad4ed" rel="nofollow">Lysandre’s</a> integration checks for ELECTRA
gives a nice example of how this can be done.`,us,ct,od=`However, if the original code-base is very complex or only allows intermediate components to be run in a compiled mode,
it might be too time-consuming or even impossible to separate the model into smaller testable sub-components. A good
example is <a href="https://github.com/tensorflow/mesh/tree/master/mesh_tensorflow" rel="nofollow">T5’s MeshTensorFlow</a> library which is
very complex and does not offer a simple way to decompose the model into its sub-components. For such libraries, one
often relies on verifying print statements.`,cs,ft,sd=`No matter which strategy you choose, the recommended procedure is often the same that you should start to debug the
starting layers first and the ending layers last.`,fs,yt,id=`It is recommended that you retrieve the output, either by print statements or sub-component functions, of the following
layers in the following order:`,ys,wt,ad="<li>Retrieve the input IDs passed to the model</li> <li>Retrieve the word embeddings</li> <li>Retrieve the input of the first Transformer layer</li> <li>Retrieve the output of the first Transformer layer</li> <li>Retrieve the output of the following n - 1 Transformer layers</li> <li>Retrieve the output of the whole BrandNewBert Model</li>",ws,Mt,rd="Input IDs should thereby consists of an array of integers, <em>e.g.</em> <code>input_ids = [0, 4, 4, 3, 2, 4, 1, 7, 19]</code>",Ms,Tt,dd="The outputs of the following layers often consist of multi-dimensional float arrays and can look like this:",Ts,gt,gs,bt,hd=`We expect that every model added to 🤗 Transformers passes a couple of integration tests, meaning that the original
model and the reimplemented version in 🤗 Transformers have to give the exact same output up to a precision of 0.001!
Since it is normal that the exact same model written in different libraries can give a slightly different output
depending on the library framework, we accept an error tolerance of 1e-3 (0.001). It is not enough if the model gives
nearly the same output, they have to be almost identical. Therefore, you will certainly compare the intermediate
outputs of the 🤗 Transformers version multiple times against the intermediate outputs of the original implementation of
<em>brand_new_bert</em> in which case an <strong>efficient</strong> debugging environment of the original repository is absolutely
important. Here is some advice to make your debugging environment as efficient as possible.`,bs,vt,pd=`<li>Find the best way of debugging intermediate results. Is the original repository written in PyTorch? Then you should
probably take the time to write a longer script that decomposes the original model into smaller sub-components to
retrieve intermediate values. Is the original repository written in Tensorflow 1? Then you might have to rely on
TensorFlow print operations like <a href="https://www.tensorflow.org/api_docs/python/tf/print" rel="nofollow">tf.print</a> to output
intermediate values. Is the original repository written in Jax? Then make sure that the model is <strong>not jitted</strong> when
running the forward pass, <em>e.g.</em> check-out <a href="https://github.com/google/jax/issues/196" rel="nofollow">this link</a>.</li> <li>Use the smallest pretrained checkpoint you can find. The smaller the checkpoint, the faster your debug cycle
becomes. It is not efficient if your pretrained model is so big that your forward pass takes more than 10 seconds.
In case only very large checkpoints are available, it might make more sense to create a dummy model in the new
environment with randomly initialized weights and save those weights for comparison with the 🤗 Transformers version
of your model</li> <li>Make sure you are using the easiest way of calling a forward pass in the original repository. Ideally, you want to
find the function in the original repository that <strong>only</strong> calls a single forward pass, <em>i.e.</em> that is often called
<code>predict</code>, <code>evaluate</code>, <code>forward</code> or <code>__call__</code>. You don’t want to debug a function that calls <code>forward</code>
multiple times, <em>e.g.</em> to generate text, like <code>autoregressive_sample</code>, <code>generate</code>.</li> <li>Try to separate the tokenization from the model’s <em>forward</em> pass. If the original repository shows examples where
you have to input a string, then try to find out where in the forward call the string input is changed to input ids
and start from this point. This might mean that you have to possibly write a small script yourself or change the
original code so that you can directly input the ids instead of an input string.</li> <li>Make sure that the model in your debugging setup is <strong>not</strong> in training mode, which often causes the model to yield
random outputs due to multiple dropout layers in the model. Make sure that the forward pass in your debugging
environment is <strong>deterministic</strong> so that the dropout layers are not used. Or use <em>transformers.utils.set_seed</em>
if the old and new implementations are in the same framework.</li>`,vs,Jt,md="The following section gives you more specific details/tips on how you can do this for <em>brand_new_bert</em>.",Js,A,Y,Vl,jt,Da,Hl,ud="5.-14. Port BrandNewBert to 🤗 Transformers",js,Ct,cd="Next, you can finally start adding new code to 🤗 Transformers. Go into the clone of your 🤗 Transformers’ fork:",Cs,kt,ks,_t,fd=`In the special case that you are adding a model whose architecture exactly matches the model architecture of an
existing model you only have to add a conversion script as described in <a href="#write-a-conversion-script">this section</a>.
In this case, you can just re-use the whole model architecture of the already existing model.`,_s,Ut,yd="Otherwise, let’s start generating a new model. You have two choices here:",Us,xt,wd="<li><code>transformers-cli add-new-model-like</code> to add a new model like an existing one</li> <li><code>transformers-cli add-new-model</code> to add a new model from our template (will look like BERT or Bart depending on the type of model you select)</li>",xs,It,Md='In both cases, you will be prompted with a questionnaire to fill in the basic information of your model. The second command requires to install <code>cookiecutter</code>, you can find more information on it <a href="https://github.com/huggingface/transformers/tree/main/templates/adding_a_new_model" rel="nofollow">here</a>.',Is,$t,Td="<strong>Open a Pull Request on the main huggingface/transformers repo</strong>",$s,At,gd=`Before starting to adapt the automatically generated code, now is the time to open a “Work in progress (WIP)” pull
request, <em>e.g.</em> “[WIP] Add <em>brand_new_bert</em>”, in 🤗 Transformers so that you and the Hugging Face team can work
side-by-side on integrating the model into 🤗 Transformers.`,As,Lt,bd="You should do the following:",Ls,Ht,vd="<li>Create a branch with a descriptive name from your main branch</li>",Hs,Nt,Ns,F,Jd="<li>Commit the automatically generated code:</li>",Zs,Zt,Bs,X,jd="<li>Fetch and rebase to current main</li>",Ws,Bt,Ps,q,Cd="<li>Push the changes to your account using:</li>",Es,Wt,Rs,O,kd=`<li><p>Once you are satisfied, go to the webpage of your fork on GitHub. Click on “Pull request”. Make sure to add the
GitHub handle of some members of the Hugging Face team as reviewers, so that the Hugging Face team gets notified for
future changes.</p></li> <li><p>Change the PR into a draft by clicking on “Convert to draft” on the right of the GitHub pull request web page.</p></li>`,zs,Pt,_d=`In the following, whenever you have made some progress, don’t forget to commit your work and push it to your account so
that it shows in the pull request. Additionally, you should make sure to update your work with the current main from
time to time by doing:`,Gs,Et,Qs,Rt,Ud=`In general, all questions you might have regarding the model or your implementation should be asked in your PR and
discussed/solved in the PR. This way, the Hugging Face team will always be notified when you are committing new code or
if you have a question. It is often very helpful to point the Hugging Face team to your added code so that the Hugging
Face team can efficiently understand your problem or question.`,Vs,zt,xd=`To do so, you can go to the “Files changed” tab where you see all of your changes, go to a line regarding which you
want to ask a question, and click on the “+” symbol to add a comment. Whenever a question or problem has been solved,
you can click on the “Resolve” button of the created comment.`,Ds,Gt,Id=`In the same way, the Hugging Face team will open comments when reviewing your code. We recommend asking most questions
on GitHub on your PR. For some very general questions that are not very useful for the public, feel free to ping the
Hugging Face team by Slack or email.`,Ss,Qt,$d="<strong>5. Adapt the generated models code for brand_new_bert</strong>",Ys,Vt,Ad=`At first, we will focus only on the model itself and not care about the tokenizer. All the relevant code should be
found in the generated files <code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code> and
<code>src/transformers/models/brand_new_bert/configuration_brand_new_bert.py</code>.`,Fs,Dt,Ld=`Now you can finally start coding :). The generated code in
<code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code> will either have the same architecture as BERT if
it’s an encoder-only model or BART if it’s an encoder-decoder model. At this point, you should remind yourself what
you’ve learned in the beginning about the theoretical aspects of the model: <em>How is the model different from BERT or
BART?</em>”. Implement those changes which often means changing the <em>self-attention</em> layer, the order of the normalization
layer, etc… Again, it is often useful to look at the similar architecture of already existing models in Transformers to
get a better feeling of how your model should be implemented.`,Xs,St,Hd=`<strong>Note</strong> that at this point, you don’t have to be very sure that your code is fully correct or clean. Rather, it is
advised to add a first <em>unclean</em>, copy-pasted version of the original code to
<code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code> until you feel like all the necessary code is
added. From our experience, it is much more efficient to quickly add a first version of the required code and
improve/correct the code iteratively with the conversion script as described in the next section. The only thing that
has to work at this point is that you can instantiate the 🤗 Transformers implementation of <em>brand_new_bert</em>, <em>i.e.</em> the
following command should work:`,qs,Yt,Os,Ft,Nd=`The above command will create a model according to the default parameters as defined in <code>BrandNewBertConfig()</code> with
random weights, thus making sure that the <code>init()</code> methods of all components works.`,Ks,Xt,Zd=`Note that all random initialization should happen in the <code>_init_weights</code> method of your <code>BrandnewBertPreTrainedModel</code>
class. It should initialize all leaf modules depending on the variables of the config. Here is an example with the
BERT <code>_init_weights</code> method:`,ei,qt,ti,Ot,Bd=`You can have some more custom schemes if you need a special initialization for some modules. For instance, in
<code>Wav2Vec2ForPreTraining</code>, the last two linear layers need to have the initialization of the regular PyTorch <code>nn.Linear</code>
but all the other ones should use an initialization as above. This is coded like this:`,ni,Kt,li,en,Wd=`The <code>_is_hf_initialized</code> flag is internally used to make sure we only initialize a submodule once. By setting it to
<code>True</code> for <code>module.project_q</code> and <code>module.project_hid</code>, we make sure the custom initialization we did is not overridden later on,
the <code>_init_weights</code> function won’t be applied to them.`,oi,tn,Pd="<strong>6. Write a conversion script</strong>",si,nn,Ed=`Next, you should write a conversion script that lets you convert the checkpoint you used to debug <em>brand_new_bert</em> in
the original repository to a checkpoint compatible with your just created 🤗 Transformers implementation of
<em>brand_new_bert</em>. It is not advised to write the conversion script from scratch, but rather to look through already
existing conversion scripts in 🤗 Transformers for one that has been used to convert a similar model that was written in
the same framework as <em>brand_new_bert</em>. Usually, it is enough to copy an already existing conversion script and
slightly adapt it for your use case. Don’t hesitate to ask the Hugging Face team to point you to a similar already
existing conversion script for your model.`,ii,ln,Rd='<li>If you are porting a model from TensorFlow to PyTorch, a good starting point might be BERT’s conversion script <a href="https://github.com/huggingface/transformers/blob/7acfa95afb8194f8f9c1f4d2c6028224dbed35a2/src/transformers/models/bert/modeling_bert.py#L91" rel="nofollow">here</a></li> <li>If you are porting a model from PyTorch to PyTorch, a good starting point might be BART’s conversion script <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/bart/convert_bart_original_pytorch_checkpoint_to_pytorch.py" rel="nofollow">here</a></li>',ai,on,zd=`In the following, we’ll quickly explain how PyTorch models store layer weights and define layer names. In PyTorch, the
name of a layer is defined by the name of the class attribute you give the layer. Let’s define a dummy model in
PyTorch, called <code>SimpleModel</code> as follows:`,ri,sn,di,an,Gd=`Now we can create an instance of this model definition which will fill all weights: <code>dense</code>, <code>intermediate</code>,
<code>layer_norm</code> with random weights. We can print the model to see its architecture`,hi,rn,pi,dn,Qd="This will print out the following:",mi,hn,ui,pn,Vd=`We can see that the layer names are defined by the name of the class attribute in PyTorch. You can print out the weight
values of a specific layer:`,ci,mn,fi,un,Dd="to see that the weights were randomly initialized",yi,cn,wi,fn,Sd=`In the conversion script, you should fill those randomly initialized weights with the exact weights of the
corresponding layer in the checkpoint. <em>E.g.</em>`,Mi,yn,Ti,wn,Yd=`While doing so, you must verify that each randomly initialized weight of your PyTorch model and its corresponding
pretrained checkpoint weight exactly match in both <strong>shape and name</strong>. To do so, it is <strong>necessary</strong> to add assert
statements for the shape and print out the names of the checkpoints weights. E.g. you should add statements like:`,gi,Mn,bi,Tn,Fd="Besides, you should also print out the names of both weights to make sure they match, <em>e.g.</em>",vi,gn,Ji,bn,Xd=`If either the shape or the name doesn’t match, you probably assigned the wrong checkpoint weight to a randomly
initialized layer of the 🤗 Transformers implementation.`,ji,vn,qd=`An incorrect shape is most likely due to an incorrect setting of the config parameters in <code>BrandNewBertConfig()</code> that
do not exactly match those that were used for the checkpoint you want to convert. However, it could also be that
PyTorch’s implementation of a layer requires the weight to be transposed beforehand.`,Ci,Jn,Od=`Finally, you should also check that <strong>all</strong> required weights are initialized and print out all checkpoint weights that
were not used for initialization to make sure the model is correctly converted. It is completely normal, that the
conversion trials fail with either a wrong shape statement or a wrong name assignment. This is most likely because either
you used incorrect parameters in <code>BrandNewBertConfig()</code>, have a wrong architecture in the 🤗 Transformers
implementation, you have a bug in the <code>init()</code> functions of one of the components of the 🤗 Transformers
implementation or you need to transpose one of the checkpoint weights.`,ki,jn,Kd=`This step should be iterated with the previous step until all weights of the checkpoint are correctly loaded in the
Transformers model. Having correctly loaded the checkpoint into the 🤗 Transformers implementation, you can then save
the model under a folder of your choice <code>/path/to/converted/checkpoint/folder</code> that should then contain both a
<code>pytorch_model.bin</code> file and a <code>config.json</code> file:`,_i,Cn,Ui,kn,eh="<strong>7. Implement the forward pass</strong>",xi,_n,th=`Having managed to correctly load the pretrained weights into the 🤗 Transformers implementation, you should now make
sure that the forward pass is correctly implemented. In <a href="#34-run-a-pretrained-checkpoint-using-the-original-repository">Get familiar with the original repository</a>, you have already created a script that runs a forward
pass of the model using the original repository. Now you should write an analogous script using the 🤗 Transformers
implementation instead of the original one. It should look as follows:`,Ii,Un,$i,xn,nh=`It is very likely that the 🤗 Transformers implementation and the original model implementation don’t give the exact
same output the very first time or that the forward pass throws an error. Don’t be disappointed - it’s expected! First,
you should make sure that the forward pass doesn’t throw any errors. It often happens that the wrong dimensions are
used leading to a <em>Dimensionality mismatch</em> error or that the wrong data type object is used, <em>e.g.</em> <code>torch.long</code>
instead of <code>torch.float32</code>. Don’t hesitate to ask the Hugging Face team for help, if you don’t manage to solve
certain errors.`,Ai,In,lh=`The final part to make sure the 🤗 Transformers implementation works correctly is to ensure that the outputs are
equivalent to a precision of <code>1e-3</code>. First, you should ensure that the output shapes are identical, <em>i.e.</em> <code>outputs.shape</code> should yield the same value for the script of the 🤗 Transformers implementation and the original
implementation. Next, you should make sure that the output values are identical as well. This one of the most difficult
parts of adding a new model. Common mistakes why the outputs are not identical are:`,Li,$n,oh=`<li>Some layers were not added, <em>i.e.</em> an <em>activation</em> layer was not added, or the residual connection was forgotten</li> <li>The word embedding matrix was not tied</li> <li>The wrong positional embeddings are used because the original implementation uses on offset</li> <li>Dropout is applied during the forward pass. To fix this make sure <em>model.training is False</em> and that no dropout
layer is falsely activated during the forward pass, <em>i.e.</em> pass <em>self.training</em> to <a href="https://pytorch.org/docs/stable/nn.functional.html?highlight=dropout#torch.nn.functional.dropout" rel="nofollow">PyTorch’s functional dropout</a></li>`,Hi,An,sh=`The best way to fix the problem is usually to look at the forward pass of the original implementation and the 🤗
Transformers implementation side-by-side and check if there are any differences. Ideally, you should debug/print out
intermediate outputs of both implementations of the forward pass to find the exact position in the network where the 🤗
Transformers implementation shows a different output than the original implementation. First, make sure that the
hard-coded <code>input_ids</code> in both scripts are identical. Next, verify that the outputs of the first transformation of
the <code>input_ids</code> (usually the word embeddings) are identical. And then work your way up to the very last layer of the
network. At some point, you will notice a difference between the two implementations, which should point you to the bug
in the 🤗 Transformers implementation. From our experience, a simple and efficient way is to add many print statements
in both the original implementation and 🤗 Transformers implementation, at the same positions in the network
respectively, and to successively remove print statements showing the same values for intermediate presentations.`,Ni,Ln,ih=`When you’re confident that both implementations yield the same output, verify the outputs with
<code>torch.allclose(original_output, output, atol=1e-3)</code>, you’re done with the most difficult part! Congratulations - the
work left to be done should be a cakewalk 😊.`,Zi,Hn,ah="<strong>8. Adding all necessary model tests</strong>",Bi,Nn,rh=`At this point, you have successfully added a new model. However, it is very much possible that the model does not yet
fully comply with the required design. To make sure, the implementation is fully compatible with 🤗 Transformers, all
common tests should pass. The Cookiecutter should have automatically added a test file for your model, probably under
the same <code>tests/models/brand_new_bert/test_modeling_brand_new_bert.py</code>. Run this test file to verify that all common
tests pass:`,Wi,Zn,Pi,Bn,dh="Having fixed all common tests, it is now crucial to ensure that all the nice work you have done is well tested, so that",Ei,Wn,hh="<li>a) The community can easily understand your work by looking at specific tests of <em>brand_new_bert</em></li> <li>b) Future changes to your model will not break any important feature of the model.</li>",Ri,Pn,ph=`At first, integration tests should be added. Those integration tests essentially do the same as the debugging scripts
you used earlier to implement the model to 🤗 Transformers. A template of those model tests has already added by the
Cookiecutter, called <code>BrandNewBertModelIntegrationTests</code> and only has to be filled out by you. To ensure that those
tests are passing, run`,zi,En,Gi,K,Qi,Rn,mh=`Second, all features that are special to <em>brand_new_bert</em> should be tested additionally in a separate test under
<code>BrandNewBertModelTester</code>/\`<code>BrandNewBertModelTest</code>. This part is often forgotten but is extremely useful in two
ways:`,Vi,zn,uh=`<li>It helps to transfer the knowledge you have acquired during the model addition to the community by showing how the
special features of <em>brand_new_bert</em> should work.</li> <li>Future contributors can quickly test changes to the model by running those special tests.</li>`,Di,Gn,ch="<strong>9. Implement the tokenizer</strong>",Si,Qn,fh=`Next, we should add the tokenizer of <em>brand_new_bert</em>. Usually, the tokenizer is equivalent to or very similar to an
already existing tokenizer of 🤗 Transformers.`,Yi,Vn,yh=`It is very important to find/extract the original tokenizer file and to manage to load this file into the 🤗
Transformers’ implementation of the tokenizer.`,Fi,Dn,wh="To ensure that the tokenizer works correctly, it is recommended to first create a script in the original repository\nthat inputs a string and returns the `input_ids“. It could look similar to this (in pseudo-code):",Xi,Sn,qi,Yn,Mh=`You might have to take a deeper look again into the original repository to find the correct tokenizer function or you
might even have to do changes to your clone of the original repository to only output the <code>input_ids</code>. Having written
a functional tokenization script that uses the original repository, an analogous script for 🤗 Transformers should be
created. It should look similar to this:`,Oi,Fn,Ki,Xn,Th="When both <code>input_ids</code> yield the same values, as a final step a tokenizer test file should also be added.",ea,qn,gh=`Analogous to the modeling test files of <em>brand_new_bert</em>, the tokenization test files of <em>brand_new_bert</em> should
contain a couple of hard-coded integration tests.`,ta,On,bh="<strong>10. Run End-to-end integration tests</strong>",na,Kn,vh=`Having added the tokenizer, you should also add a couple of end-to-end integration tests using both the model and the
tokenizer to <code>tests/models/brand_new_bert/test_modeling_brand_new_bert.py</code> in 🤗 Transformers.
Such a test should show on a meaningful
text-to-text sample that the 🤗 Transformers implementation works as expected. A meaningful text-to-text sample can
include <em>e.g.</em> a source-to-target-translation pair, an article-to-summary pair, a question-to-answer pair, etc… If none
of the ported checkpoints has been fine-tuned on a downstream task it is enough to simply rely on the model tests. In a
final step to ensure that the model is fully functional, it is advised that you also run all tests on GPU. It can
happen that you forgot to add some <code>.to(self.device)</code> statements to internal tensors of the model, which in such a
test would show in an error. In case you have no access to a GPU, the Hugging Face team can take care of running those
tests for you.`,la,el,Jh="<strong>11. Add Docstring</strong>",oa,tl,jh=`Now, all the necessary functionality for <em>brand_new_bert</em> is added - you’re almost done! The only thing left to add is
a nice docstring and a doc page. The Cookiecutter should have added a template file called
<code>docs/source/model_doc/brand_new_bert.md</code> that you should fill out. Users of your model will usually first look at
this page before using your model. Hence, the documentation must be understandable and concise. It is very useful for
the community to add some <em>Tips</em> to show how the model should be used. Don’t hesitate to ping the Hugging Face team
regarding the docstrings.`,sa,nl,Ch=`Next, make sure that the docstring added to <code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code> is
correct and included all necessary inputs and outputs. We have a detailed guide about writing documentation and our docstring format <a href="writing-documentation">here</a>. It is always to good to remind oneself that documentation should
be treated at least as carefully as the code in 🤗 Transformers since the documentation is usually the first contact
point of the community with the model.`,ia,ll,kh="<strong>Code refactor</strong>",aa,ol,_h=`Great, now you have added all the necessary code for <em>brand_new_bert</em>. At this point, you should correct some potential
incorrect code style by running:`,ra,sl,da,il,Uh="and verify that your coding style passes the quality check:",ha,al,pa,rl,xh=`There are a couple of other very strict design tests in 🤗 Transformers that might still be failing, which shows up in
the tests of your pull request. This is often because of some missing information in the docstring or some incorrect
naming. The Hugging Face team will surely help you if you’re stuck here.`,ma,dl,Ih=`Lastly, it is always a good idea to refactor one’s code after having ensured that the code works correctly. With all
tests passing, now it’s a good time to go over the added code again and do some refactoring.`,ua,hl,$h="You have now finished the coding part, congratulation! 🎉 You are Awesome! 😎",ca,pl,Ah="<strong>12. Upload the models to the model hub</strong>",fa,ml,Lh=`In this final part, you should convert and upload all checkpoints to the model hub and add a model card for each
uploaded model checkpoint. You can get familiar with the hub functionalities by reading our <a href="model_sharing">Model sharing and uploading Page</a>. You should work alongside the Hugging Face team here to decide on a fitting name for each
checkpoint and to get the required access rights to be able to upload the model under the author’s organization of
<em>brand_new_bert</em>. The <code>push_to_hub</code> method, present in all models in <code>transformers</code>, is a quick and efficient way to push your checkpoint to the hub. A little snippet is pasted below:`,ya,ul,wa,cl,Hh=`It is worth spending some time to create fitting model cards for each checkpoint. The model cards should highlight the
specific characteristics of this particular checkpoint, <em>e.g.</em> On which dataset was the checkpoint
pretrained/fine-tuned on? On what down-stream task should the model be used? And also include some code on how to
correctly use the model.`,Ma,fl,Nh="<strong>13. (Optional) Add notebook</strong>",Ta,yl,Zh=`It is very helpful to add a notebook that showcases in-detail how <em>brand_new_bert</em> can be used for inference and/or
fine-tuned on a downstream task. This is not mandatory to merge your PR, but very useful for the community.`,ga,wl,Bh="<strong>14. Submit your finished PR</strong>",ba,Ml,Wh=`You’re done programming now and can move to the last step, which is getting your PR merged into main. Usually, the
Hugging Face team should have helped you already at this point, but it is worth taking some time to give your finished
PR a nice description and eventually add comments to your code, if you want to point out certain design choices to your
reviewer.`,va,L,ee,Dl,Tl,Sa,Nl,Ph="Share your work!!",Ja,gl,Eh=`Now, it’s time to get some credit from the community for your work! Having completed a model addition is a major
contribution to Transformers and the whole NLP community. Your code and the ported pre-trained models will certainly be
used by hundreds and possibly even thousands of developers and researchers. You should be proud of your work and share
your achievements with the community.`,ja,bl,Rh="<strong>You have made another model that is super easy to access for everyone in the community! 🤯</strong>",Ca,Sl,ka;return te=new b({}),Z=new dp({props:{$$slots:{default:[wp]},$$scope:{ctx:Jl}}}),re=new b({}),ce=new b({}),Me=new M({props:{code:"bW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyYnJhbmR5JTJGYnJhbmRfbmV3X2JlcnQlMjIpJTBBbW9kZWwuY29uZmlnJTIwJTIwJTIzJTIwbW9kZWwlMjBoYXMlMjBhY2Nlc3MlMjB0byUyMGl0cyUyMGNvbmZpZw==",highlighted:`model = BrandNewBertModel.from_pretrained(<span class="hljs-string">&quot;brandy/brand_new_bert&quot;</span>)
model.config  <span class="hljs-comment"># model has access to its config</span>`,wrap:!1}}),ge=new b({}),Je=new b({}),Ce=new b({}),He=new b({}),We=new b({}),Ee=new M({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkYlNUJ5b3VyJTIwR2l0aHViJTIwaGFuZGxlJTVEJTJGdHJhbnNmb3JtZXJzLmdpdCUwQWNkJTIwdHJhbnNmb3JtZXJzJTBBZ2l0JTIwcmVtb3RlJTIwYWRkJTIwdXBzdHJlYW0lMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRnRyYW5zZm9ybWVycy5naXQ=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/[your Github handle]/transformers.git
<span class="hljs-built_in">cd</span> transformers
git remote add upstream https://github.com/huggingface/transformers.git`,wrap:!1}}),Re=new M({props:{code:"cHl0aG9uJTIwLW0lMjB2ZW52JTIwLmVudiUwQXNvdXJjZSUyMC5lbnYlMkZiaW4lMkZhY3RpdmF0ZSUwQXBpcCUyMGluc3RhbGwlMjAtZSUyMCUyMi4lNUJkZXYlNUQlMjI=",highlighted:`python -m venv .<span class="hljs-built_in">env</span>
<span class="hljs-built_in">source</span> .<span class="hljs-built_in">env</span>/bin/activate
pip install -e <span class="hljs-string">&quot;.[dev]&quot;</span>`,wrap:!1}}),Ge=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1lJTIwJTIyLiU1QnF1YWxpdHklNUQlMjI=",highlighted:'pip install -e <span class="hljs-string">&quot;.[quality]&quot;</span>',wrap:!1}}),Ve=new M({props:{code:"Y2QlMjAuLg==",highlighted:'<span class="hljs-built_in">cd</span> ..',wrap:!1}}),Se=new M({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZvcmdfdGhhdF9jcmVhdGVkX2JyYW5kX25ld19iZXJ0X29yZyUyRmJyYW5kX25ld19iZXJ0LmdpdCUwQWNkJTIwYnJhbmRfbmV3X2JlcnQlMEFwaXAlMjBpbnN0YWxsJTIwLWUlMjAu",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/org_that_created_brand_new_bert_org/brand_new_bert.git
<span class="hljs-built_in">cd</span> brand_new_bert
pip install -e .`,wrap:!1}}),Fe=new b({}),at=new M({props:{code:"bW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbC5sb2FkX3ByZXRyYWluZWRfY2hlY2twb2ludCglMjIlMkZwYXRoJTJGdG8lMkZjaGVja3BvaW50JTJGJTIyKSUwQWlucHV0X2lkcyUyMCUzRCUyMCU1QjAlMkMlMjA0JTJDJTIwNSUyQyUyMDIlMkMlMjAzJTJDJTIwNyUyQyUyMDklNUQlMjAlMjAlMjMlMjB2ZWN0b3IlMjBvZiUyMGlucHV0JTIwaWRzJTBBb3JpZ2luYWxfb3V0cHV0JTIwJTNEJTIwbW9kZWwucHJlZGljdChpbnB1dF9pZHMp",highlighted:`model = BrandNewBertModel.load_pretrained_checkpoint(<span class="hljs-string">&quot;/path/to/checkpoint/&quot;</span>)
input_ids = [<span class="hljs-number">0</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">7</span>, <span class="hljs-number">9</span>]  <span class="hljs-comment"># vector of input ids</span>
original_output = model.predict(input_ids)`,wrap:!1}}),gt=new M({props:{code:"JTVCJTVCJTBBJTIwJTVCLTAuMTQ2NSUyQyUyMC0wLjY1MDElMkMlMjAlMjAwLjE5OTMlMkMlMjAlMjAuLi4lMkMlMjAlMjAwLjE0NTElMkMlMjAlMjAwLjM0MzAlMkMlMjAlMjAwLjYwMjQlNUQlMkMlMEElMjAlNUItMC40NDE3JTJDJTIwLTAuNTkyMCUyQyUyMCUyMDAuMzQ1MCUyQyUyMCUyMC4uLiUyQyUyMC0wLjMwNjIlMkMlMjAlMjAwLjYxODIlMkMlMjAlMjAwLjcxMzIlNUQlMkMlMEElMjAlNUItMC41MDA5JTJDJTIwLTAuNzEyMiUyQyUyMCUyMDAuNDU0OCUyQyUyMCUyMC4uLiUyQyUyMC0wLjM2NjIlMkMlMjAlMjAwLjYwOTElMkMlMjAlMjAwLjc2NDglNUQlMkMlMEElMjAuLi4lMkMlMEElMjAlNUItMC41NjEzJTJDJTIwLTAuNjMzMiUyQyUyMCUyMDAuNDMyNCUyQyUyMCUyMC4uLiUyQyUyMC0wLjM3OTIlMkMlMjAlMjAwLjczNzIlMkMlMjAlMjAwLjkyODglNUQlMkMlMEElMjAlNUItMC41NDE2JTJDJTIwLTAuNjM0NSUyQyUyMCUyMDAuNDE4MCUyQyUyMCUyMC4uLiUyQyUyMC0wLjM1NjQlMkMlMjAlMjAwLjY5OTIlMkMlMjAlMjAwLjkxOTElNUQlMkMlMEElMjAlNUItMC41MzM0JTJDJTIwLTAuNjQwMyUyQyUyMCUyMDAuNDI3MSUyQyUyMCUyMC4uLiUyQyUyMC0wLjMzMzklMkMlMjAlMjAwLjY1MzMlMkMlMjAlMjAwLjg2OTQlNUQlNUQlNUQlMkM=",highlighted:`<span class="hljs-comment">[<span class="hljs-comment">[
 <span class="hljs-comment">[-0.1465, -0.6501,  0.1993,  ...,  0.1451,  0.3430,  0.6024]</span>,
 <span class="hljs-comment">[-0.4417, -0.5920,  0.3450,  ..., -0.3062,  0.6182,  0.7132]</span>,
 <span class="hljs-comment">[-0.5009, -0.7122,  0.4548,  ..., -0.3662,  0.6091,  0.7648]</span>,
 ...,
 <span class="hljs-comment">[-0.5613, -0.6332,  0.4324,  ..., -0.3792,  0.7372,  0.9288]</span>,
 <span class="hljs-comment">[-0.5416, -0.6345,  0.4180,  ..., -0.3564,  0.6992,  0.9191]</span>,
 <span class="hljs-comment">[-0.5334, -0.6403,  0.4271,  ..., -0.3339,  0.6533,  0.8694]</span>]</span>]</span>,`,wrap:!1}}),jt=new b({}),kt=new M({props:{code:"Y2QlMjB0cmFuc2Zvcm1lcnM=",highlighted:'<span class="hljs-built_in">cd</span> transformers',wrap:!1}}),Nt=new M({props:{code:"Z2l0JTIwY2hlY2tvdXQlMjAtYiUyMGFkZF9icmFuZF9uZXdfYmVydA==",highlighted:"git checkout -b add_brand_new_bert",wrap:!1}}),Zt=new M({props:{code:"Z2l0JTIwYWRkJTIwLiUwQWdpdCUyMGNvbW1pdA==",highlighted:`git add .
git commit`,wrap:!1}}),Bt=new M({props:{code:"Z2l0JTIwZmV0Y2glMjB1cHN0cmVhbSUwQWdpdCUyMHJlYmFzZSUyMHVwc3RyZWFtJTJGbWFpbg==",highlighted:`git fetch upstream
git rebase upstream/main`,wrap:!1}}),Wt=new M({props:{code:"Z2l0JTIwcHVzaCUyMC11JTIwb3JpZ2luJTIwYS1kZXNjcmlwdGl2ZS1uYW1lLWZvci1teS1jaGFuZ2Vz",highlighted:"git push -u origin a-descriptive-name-for-my-changes",wrap:!1}}),Et=new M({props:{code:"Z2l0JTIwZmV0Y2glMjB1cHN0cmVhbSUwQWdpdCUyMG1lcmdlJTIwdXBzdHJlYW0lMkZtYWlu",highlighted:`git fetch upstream
git merge upstream/main`,wrap:!1}}),Yt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJyYW5kTmV3QmVydE1vZGVsJTJDJTIwQnJhbmROZXdCZXJ0Q29uZmlnJTBBJTBBbW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbChCcmFuZE5ld0JlcnRDb25maWcoKSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BrandNewBertModel, BrandNewBertConfig

model = BrandNewBertModel(BrandNewBertConfig())`,wrap:!1}}),qt=new M({props:{code:"ZGVmJTIwX2luaXRfd2VpZ2h0cyhzZWxmJTJDJTIwbW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkluaXRpYWxpemUlMjB0aGUlMjB3ZWlnaHRzJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwaWYlMjBpc2luc3RhbmNlKG1vZHVsZSUyQyUyMG5uLkxpbmVhciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUud2VpZ2h0LmRhdGEubm9ybWFsXyhtZWFuJTNEMC4wJTJDJTIwc3RkJTNEc2VsZi5jb25maWcuaW5pdGlhbGl6ZXJfcmFuZ2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBtb2R1bGUuYmlhcyUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZHVsZS5iaWFzLmRhdGEuemVyb18oKSUwQSUyMCUyMCUyMCUyMGVsaWYlMjBpc2luc3RhbmNlKG1vZHVsZSUyQyUyMG5uLkVtYmVkZGluZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUud2VpZ2h0LmRhdGEubm9ybWFsXyhtZWFuJTNEMC4wJTJDJTIwc3RkJTNEc2VsZi5jb25maWcuaW5pdGlhbGl6ZXJfcmFuZ2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBtb2R1bGUucGFkZGluZ19pZHglMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUud2VpZ2h0LmRhdGElNUJtb2R1bGUucGFkZGluZ19pZHglNUQuemVyb18oKSUwQSUyMCUyMCUyMCUyMGVsaWYlMjBpc2luc3RhbmNlKG1vZHVsZSUyQyUyMG5uLkxheWVyTm9ybSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUuYmlhcy5kYXRhLnplcm9fKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUud2VpZ2h0LmRhdGEuZmlsbF8oMS4wKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">_init_weights</span>(<span class="hljs-params">self, module</span>):
    <span class="hljs-string">&quot;&quot;&quot;Initialize the weights&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(module, nn.Linear):
        module.weight.data.normal_(mean=<span class="hljs-number">0.0</span>, std=self.config.initializer_range)
        <span class="hljs-keyword">if</span> module.bias <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            module.bias.data.zero_()
    <span class="hljs-keyword">elif</span> <span class="hljs-built_in">isinstance</span>(module, nn.Embedding):
        module.weight.data.normal_(mean=<span class="hljs-number">0.0</span>, std=self.config.initializer_range)
        <span class="hljs-keyword">if</span> module.padding_idx <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            module.weight.data[module.padding_idx].zero_()
    <span class="hljs-keyword">elif</span> <span class="hljs-built_in">isinstance</span>(module, nn.LayerNorm):
        module.bias.data.zero_()
        module.weight.data.fill_(<span class="hljs-number">1.0</span>)`,wrap:!1}}),Kt=new M({props:{code:"ZGVmJTIwX2luaXRfd2VpZ2h0cyhzZWxmJTJDJTIwbW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkluaXRpYWxpemUlMjB0aGUlMjB3ZWlnaHRzJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwaWYlMjBpc2luc3RuYWNlKG1vZHVsZSUyQyUyMFdhdjJWZWMyRm9yUHJlVHJhaW5pbmcpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kdWxlLnByb2plY3RfaGlkLnJlc2V0X3BhcmFtZXRlcnMoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZHVsZS5wcm9qZWN0X3EucmVzZXRfcGFyYW1ldGVycygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kdWxlLnByb2plY3RfaGlkLl9pc19oZl9pbml0aWFsaXplZCUyMCUzRCUyMFRydWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUucHJvamVjdF9xLl9pc19oZl9pbml0aWFsaXplZCUyMCUzRCUyMFRydWUlMEElMjAlMjAlMjAlMjBlbGlmJTIwaXNpbnN0YW5jZShtb2R1bGUlMkMlMjBubi5MaW5lYXIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kdWxlLndlaWdodC5kYXRhLm5vcm1hbF8obWVhbiUzRDAuMCUyQyUyMHN0ZCUzRHNlbGYuY29uZmlnLmluaXRpYWxpemVyX3JhbmdlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbW9kdWxlLmJpYXMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUuYmlhcy5kYXRhLnplcm9fKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">_init_weights</span>(<span class="hljs-params">self, module</span>):
    <span class="hljs-string">&quot;&quot;&quot;Initialize the weights&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> isinstnace(module, Wav2Vec2ForPreTraining):
        module.project_hid.reset_parameters()
        module.project_q.reset_parameters()
        module.project_hid._is_hf_initialized = <span class="hljs-literal">True</span>
        module.project_q._is_hf_initialized = <span class="hljs-literal">True</span>
    <span class="hljs-keyword">elif</span> <span class="hljs-built_in">isinstance</span>(module, nn.Linear):
        module.weight.data.normal_(mean=<span class="hljs-number">0.0</span>, std=self.config.initializer_range)
        <span class="hljs-keyword">if</span> module.bias <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            module.bias.data.zero_()`,wrap:!1}}),sn=new M({props:{code:"ZnJvbSUyMHRvcmNoJTIwaW1wb3J0JTIwbm4lMEElMEElMEFjbGFzcyUyMFNpbXBsZU1vZGVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuZGVuc2UlMjAlM0QlMjBubi5MaW5lYXIoMTAlMkMlMjAxMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmludGVybWVkaWF0ZSUyMCUzRCUyMG5uLkxpbmVhcigxMCUyQyUyMDEwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubGF5ZXJfbm9ybSUyMCUzRCUyMG5uLkxheWVyTm9ybSgxMCk=",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn


<span class="hljs-keyword">class</span> <span class="hljs-title class_">SimpleModel</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.dense = nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.intermediate = nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.layer_norm = nn.LayerNorm(<span class="hljs-number">10</span>)`,wrap:!1}}),rn=new M({props:{code:"bW9kZWwlMjAlM0QlMjBTaW1wbGVNb2RlbCgpJTBBJTBBcHJpbnQobW9kZWwp",highlighted:`model = SimpleModel()

<span class="hljs-built_in">print</span>(model)`,wrap:!1}}),hn=new M({props:{code:"U2ltcGxlTW9kZWwoJTBBJTIwJTIwKGRlbnNlKSUzQSUyMExpbmVhcihpbl9mZWF0dXJlcyUzRDEwJTJDJTIwb3V0X2ZlYXR1cmVzJTNEMTAlMkMlMjBiaWFzJTNEVHJ1ZSklMEElMjAlMjAoaW50ZXJtZWRpYXRlKSUzQSUyMExpbmVhcihpbl9mZWF0dXJlcyUzRDEwJTJDJTIwb3V0X2ZlYXR1cmVzJTNEMTAlMkMlMjBiaWFzJTNEVHJ1ZSklMEElMjAlMjAobGF5ZXJfbm9ybSklM0ElMjBMYXllck5vcm0oKDEwJTJDKSUyQyUyMGVwcyUzRDFlLTA1JTJDJTIwZWxlbWVudHdpc2VfYWZmaW5lJTNEVHJ1ZSklMEEp",highlighted:`SimpleModel(
  (dense): Linear(<span class="hljs-attribute">in_features</span>=10, <span class="hljs-attribute">out_features</span>=10, <span class="hljs-attribute">bias</span>=<span class="hljs-literal">True</span>)
  (intermediate): Linear(<span class="hljs-attribute">in_features</span>=10, <span class="hljs-attribute">out_features</span>=10, <span class="hljs-attribute">bias</span>=<span class="hljs-literal">True</span>)
  (layer_norm): LayerNorm((10,), <span class="hljs-attribute">eps</span>=1e-05, <span class="hljs-attribute">elementwise_affine</span>=<span class="hljs-literal">True</span>)
)`,wrap:!1}}),mn=new M({props:{code:"cHJpbnQobW9kZWwuZGVuc2Uud2VpZ2h0LmRhdGEp",highlighted:'<span class="hljs-built_in">print</span>(model.dense.weight.data)',wrap:!1}}),cn=new M({props:{code:"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",highlighted:`tensor([[<span class="hljs-string">-0</span>.0818,  0.2207, <span class="hljs-string">-0</span>.0749, <span class="hljs-string">-0</span>.0030,  0.0045, <span class="hljs-string">-0</span>.1569, <span class="hljs-string">-0</span>.1598,  0.0212,
         <span class="hljs-string">-0</span>.2077,  0.2157],
        [ 0.1044,  0.0201,  0.0990,  0.2482,  0.3116,  0.2509,  0.2866, <span class="hljs-string">-0</span>.2190,
          0.2166, <span class="hljs-string">-0</span>.0212],
        [<span class="hljs-string">-0</span>.2000,  0.1107, <span class="hljs-string">-0</span>.1999, <span class="hljs-string">-0</span>.3119,  0.1559,  0.0993,  0.1776, <span class="hljs-string">-0</span>.1950,
         <span class="hljs-string">-0</span>.1023, <span class="hljs-string">-0</span>.0447],
        [<span class="hljs-string">-0</span>.0888, <span class="hljs-string">-0</span>.1092,  0.2281,  0.0336,  0.1817, <span class="hljs-string">-0</span>.0115,  0.2096,  0.1415,
         <span class="hljs-string">-0</span>.1876, <span class="hljs-string">-0</span>.2467],
        [ 0.2208, <span class="hljs-string">-0</span>.2352, <span class="hljs-string">-0</span>.1426, <span class="hljs-string">-0</span>.2636, <span class="hljs-string">-0</span>.2889, <span class="hljs-string">-0</span>.2061, <span class="hljs-string">-0</span>.2849, <span class="hljs-string">-0</span>.0465,
          0.2577,  0.0402],
        [ 0.1502,  0.2465,  0.2566,  0.0693,  0.2352, <span class="hljs-string">-0</span>.0530,  0.1859, <span class="hljs-string">-0</span>.0604,
          0.2132,  0.1680],
        [ 0.1733, <span class="hljs-string">-0</span>.2407, <span class="hljs-string">-0</span>.1721,  0.1484,  0.0358, <span class="hljs-string">-0</span>.0633, <span class="hljs-string">-0</span>.0721, <span class="hljs-string">-0</span>.0090,
          0.2707, <span class="hljs-string">-0</span>.2509],
        [<span class="hljs-string">-0</span>.1173,  0.1561,  0.2945,  0.0595, <span class="hljs-string">-0</span>.1996,  0.2988, <span class="hljs-string">-0</span>.0802,  0.0407,
          0.1829, <span class="hljs-string">-0</span>.1568],
        [<span class="hljs-string">-0</span>.1164, <span class="hljs-string">-0</span>.2228, <span class="hljs-string">-0</span>.0403,  0.0428,  0.1339,  0.0047,  0.1967,  0.2923,
          0.0333, <span class="hljs-string">-0</span>.0536],
        [<span class="hljs-string">-0</span>.1492, <span class="hljs-string">-0</span>.1616,  0.1057,  0.1950, <span class="hljs-string">-0</span>.2807, <span class="hljs-string">-0</span>.2710, <span class="hljs-string">-0</span>.1586,  0.0739,
          0.2220,  0.2358]]).`,wrap:!1}}),yn=new M({props:{code:"JTIzJTIwcmV0cmlldmUlMjBtYXRjaGluZyUyMGxheWVyJTIwd2VpZ2h0cyUyQyUyMGUuZy4lMjBieSUwQSUyMyUyMHJlY3Vyc2l2ZSUyMGFsZ29yaXRobSUwQWxheWVyX25hbWUlMjAlM0QlMjAlMjJkZW5zZSUyMiUwQXByZXRyYWluZWRfd2VpZ2h0JTIwJTNEJTIwYXJyYXlfb2ZfZGVuc2VfbGF5ZXIlMEElMEFtb2RlbF9wb2ludGVyJTIwJTNEJTIwZ2V0YXR0cihtb2RlbCUyQyUyMCUyMmRlbnNlJTIyKSUwQSUwQW1vZGVsX3BvaW50ZXIud2VpZ2h0LmRhdGElMjAlM0QlMjB0b3JjaC5mcm9tX251bXB5KHByZXRyYWluZWRfd2VpZ2h0KQ==",highlighted:`<span class="hljs-comment"># retrieve matching layer weights, e.g. by</span>
<span class="hljs-comment"># recursive algorithm</span>
layer_name = <span class="hljs-string">&quot;dense&quot;</span>
pretrained_weight = array_of_dense_layer

model_pointer = <span class="hljs-built_in">getattr</span>(model, <span class="hljs-string">&quot;dense&quot;</span>)

model_pointer.weight.data = torch.from_numpy(pretrained_weight)`,wrap:!1}}),Mn=new M({props:{code:"YXNzZXJ0JTIwKCUwQSUyMCUyMCUyMCUyMG1vZGVsX3BvaW50ZXIud2VpZ2h0LnNoYXBlJTIwJTNEJTNEJTIwcHJldHJhaW5lZF93ZWlnaHQuc2hhcGUlMEEpJTJDJTIwZiUyMlBvaW50ZXIlMjBzaGFwZSUyMG9mJTIwcmFuZG9tJTIwd2VpZ2h0JTIwJTdCbW9kZWxfcG9pbnRlci5zaGFwZSU3RCUyMGFuZCUyMGFycmF5JTIwc2hhcGUlMjBvZiUyMGNoZWNrcG9pbnQlMjB3ZWlnaHQlMjAlN0JwcmV0cmFpbmVkX3dlaWdodC5zaGFwZSU3RCUyMG1pc21hdGNoZWQlMjI=",highlighted:`<span class="hljs-keyword">assert</span> (
    model_pointer.weight.shape == pretrained_weight.shape
), <span class="hljs-string">f&quot;Pointer shape of random weight <span class="hljs-subst">{model_pointer.shape}</span> and array shape of checkpoint weight <span class="hljs-subst">{pretrained_weight.shape}</span> mismatched&quot;</span>`,wrap:!1}}),gn=new M({props:{code:"bG9nZ2VyLmluZm8oZiUyMkluaXRpYWxpemUlMjBQeVRvcmNoJTIwd2VpZ2h0JTIwJTdCbGF5ZXJfbmFtZSU3RCUyMGZyb20lMjAlN0JwcmV0cmFpbmVkX3dlaWdodC5uYW1lJTdEJTIyKQ==",highlighted:'logger.info(<span class="hljs-string">f&quot;Initialize PyTorch weight <span class="hljs-subst">{layer_name}</span> from <span class="hljs-subst">{pretrained_weight.name}</span>&quot;</span>)',wrap:!1}}),Cn=new M({props:{code:"bW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMiUyRnBhdGglMkZ0byUyRmNvbnZlcnRlZCUyRmNoZWNrcG9pbnQlMkZmb2xkZXIlMjIp",highlighted:'model.save_pretrained(<span class="hljs-string">&quot;/path/to/converted/checkpoint/folder&quot;</span>)',wrap:!1}}),Un=new M({props:{code:"bW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyJTJGcGF0aCUyRnRvJTJGY29udmVydGVkJTJGY2hlY2twb2ludCUyRmZvbGRlciUyMiklMEFpbnB1dF9pZHMlMjAlM0QlMjAlNUIwJTJDJTIwNCUyQyUyMDQlMkMlMjAzJTJDJTIwMiUyQyUyMDQlMkMlMjAxJTJDJTIwNyUyQyUyMDE5JTVEJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzKS5sYXN0X2hpZGRlbl9zdGF0ZXM=",highlighted:`model = BrandNewBertModel.from_pretrained(<span class="hljs-string">&quot;/path/to/converted/checkpoint/folder&quot;</span>)
input_ids = [<span class="hljs-number">0</span>, <span class="hljs-number">4</span>, <span class="hljs-number">4</span>, <span class="hljs-number">3</span>, <span class="hljs-number">2</span>, <span class="hljs-number">4</span>, <span class="hljs-number">1</span>, <span class="hljs-number">7</span>, <span class="hljs-number">19</span>]
output = model(input_ids).last_hidden_states`,wrap:!1}}),Zn=new M({props:{code:"cHl0ZXN0JTIwdGVzdHMlMkZtb2RlbHMlMkZicmFuZF9uZXdfYmVydCUyRnRlc3RfbW9kZWxpbmdfYnJhbmRfbmV3X2JlcnQucHk=",highlighted:"pytest tests/models/brand_new_bert/test_modeling_brand_new_bert.py",wrap:!1}}),En=new M({props:{code:"UlVOX1NMT1clM0QxJTIwcHl0ZXN0JTIwLXN2JTIwdGVzdHMlMkZtb2RlbHMlMkZicmFuZF9uZXdfYmVydCUyRnRlc3RfbW9kZWxpbmdfYnJhbmRfbmV3X2JlcnQucHklM0ElM0FCcmFuZE5ld0JlcnRNb2RlbEludGVncmF0aW9uVGVzdHM=",highlighted:"RUN_SLOW=1 pytest -sv tests/models/brand_new_bert/test_modeling_brand_new_bert.py::BrandNewBertModelIntegrationTests",wrap:!1}}),K=new dp({props:{$$slots:{default:[Mp]},$$scope:{ctx:Jl}}}),Sn=new M({props:{code:"aW5wdXRfc3RyJTIwJTNEJTIwJTIyVGhpcyUyMGlzJTIwYSUyMGxvbmclMjBleGFtcGxlJTIwaW5wdXQlMjBzdHJpbmclMjBjb250YWluaW5nJTIwc3BlY2lhbCUyMGNoYXJhY3RlcnMlMjAuJTI0JTNGLSUyQyUyMG51bWJlcnMlMjAyODcyJTIwMjM0JTIwMTIlMjBhbmQlMjB3b3Jkcy4lMjIlMEFtb2RlbCUyMCUzRCUyMEJyYW5kTmV3QmVydE1vZGVsLmxvYWRfcHJldHJhaW5lZF9jaGVja3BvaW50KCUyMiUyRnBhdGglMkZ0byUyRmNoZWNrcG9pbnQlMkYlMjIpJTBBaW5wdXRfaWRzJTIwJTNEJTIwbW9kZWwudG9rZW5pemUoaW5wdXRfc3RyKQ==",highlighted:`input_str = <span class="hljs-string">&quot;This is a long example input string containing special characters .$?-, numbers 2872 234 12 and words.&quot;</span>
model = BrandNewBertModel.load_pretrained_checkpoint(<span class="hljs-string">&quot;/path/to/checkpoint/&quot;</span>)
input_ids = model.tokenize(input_str)`,wrap:!1}}),Fn=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJyYW5kTmV3QmVydFRva2VuaXplciUwQSUwQWlucHV0X3N0ciUyMCUzRCUyMCUyMlRoaXMlMjBpcyUyMGElMjBsb25nJTIwZXhhbXBsZSUyMGlucHV0JTIwc3RyaW5nJTIwY29udGFpbmluZyUyMHNwZWNpYWwlMjBjaGFyYWN0ZXJzJTIwLiUyNCUzRi0lMkMlMjBudW1iZXJzJTIwMjg3MiUyMDIzNCUyMDEyJTIwYW5kJTIwd29yZHMuJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQnJhbmROZXdCZXJ0VG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjIlMkZwYXRoJTJGdG8lMkZ0b2tlbml6ZXIlMkZmb2xkZXIlMkYlMjIpJTBBJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKGlucHV0X3N0cikuaW5wdXRfaWRz",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BrandNewBertTokenizer

input_str = <span class="hljs-string">&quot;This is a long example input string containing special characters .$?-, numbers 2872 234 12 and words.&quot;</span>

tokenizer = BrandNewBertTokenizer.from_pretrained(<span class="hljs-string">&quot;/path/to/tokenizer/folder/&quot;</span>)

input_ids = tokenizer(input_str).input_ids`,wrap:!1}}),sl=new M({props:{code:"bWFrZSUyMHN0eWxl",highlighted:"make style",wrap:!1}}),al=new M({props:{code:"bWFrZSUyMHF1YWxpdHk=",highlighted:"make quality",wrap:!1}}),ul=new M({props:{code:"YnJhbmRfbmV3X2JlcnQucHVzaF90b19odWIoJTIyYnJhbmRfbmV3X2JlcnQlMjIpJTBBJTIzJTIwVW5jb21tZW50JTIwdGhlJTIwZm9sbG93aW5nJTIwbGluZSUyMHRvJTIwcHVzaCUyMHRvJTIwYW4lMjBvcmdhbml6YXRpb24uJTBBJTIzJTIwYnJhbmRfbmV3X2JlcnQucHVzaF90b19odWIoJTIyJTNDb3JnYW5pemF0aW9uJTNFJTJGYnJhbmRfbmV3X2JlcnQlMjIp",highlighted:`brand_new_bert.push_to_hub(<span class="hljs-string">&quot;brand_new_bert&quot;</span>)
<span class="hljs-comment"># Uncomment the following line to push to an organization.</span>
<span class="hljs-comment"># brand_new_bert.push_to_hub(&quot;&lt;organization&gt;/brand_new_bert&quot;)</span>`,wrap:!1}}),Tl=new b({}),{c(){T=i("meta"),v=o(),g=i("p"),H=o(),J=i("h1"),N=i("a"),Zl=i("span"),h(te.$$.fragment),Ba=o(),jl=i("span"),jl.textContent=Ya,Fl=o(),ne=i("p"),ne.innerHTML=Fa,Xl=o(),h(Z.$$.fragment),ql=o(),le=i("p"),le.textContent=Xa,Ol=o(),oe=i("ul"),oe.innerHTML=qa,Kl=o(),se=i("p"),se.textContent=Oa,eo=o(),ie=i("p"),ie.innerHTML=Ka,to=o(),ae=i("p"),ae.textContent=er,no=o(),j=i("h2"),B=i("a"),Bl=i("span"),h(re.$$.fragment),Wa=o(),Cl=i("span"),Cl.textContent=tr,lo=o(),de=i("p"),de.textContent=nr,oo=o(),he=i("p"),he.innerHTML=lr,so=o(),pe=i("ul"),pe.innerHTML=or,io=o(),me=i("p"),me.innerHTML=sr,ao=o(),ue=i("p"),ue.textContent=ir,ro=o(),C=i("h3"),W=i("a"),Wl=i("span"),h(ce.$$.fragment),Pa=o(),kl=i("span"),kl.textContent=ar,ho=o(),fe=i("p"),fe.innerHTML=rr,po=o(),ye=i("p"),ye.textContent=dr,mo=o(),_l=i("img"),uo=o(),we=i("p"),we.innerHTML=pr,co=o(),h(Me.$$.fragment),fo=o(),Te=i("p"),Te.innerHTML=mr,yo=o(),k=i("h3"),P=i("a"),Pl=i("span"),h(ge.$$.fragment),Ea=o(),Ul=i("span"),Ul.textContent=ur,wo=o(),be=i("p"),be.textContent=cr,Mo=o(),ve=i("ol"),ve.innerHTML=fr,To=o(),_=i("h3"),E=i("a"),El=i("span"),h(Je.$$.fragment),Ra=o(),xl=i("span"),xl.textContent=yr,go=o(),je=i("p"),je.textContent=wr,bo=o(),U=i("h2"),R=i("a"),Rl=i("span"),h(Ce.$$.fragment),za=o(),Il=i("span"),Il.textContent=Mr,vo=o(),ke=i("p"),ke.textContent=Tr,Jo=o(),_e=i("ol"),_e.innerHTML=gr,jo=o(),Ue=i("p"),Ue.textContent=br,Co=o(),xe=i("ul"),xe.innerHTML=vr,ko=o(),Ie=i("p"),Ie.textContent=Jr,_o=o(),$e=i("p"),$e.textContent=jr,Uo=o(),Ae=i("p"),Ae.innerHTML=Cr,xo=o(),Le=i("p"),Le.innerHTML=kr,Io=o(),x=i("h3"),z=i("a"),zl=i("span"),h(He.$$.fragment),Ga=o(),$l=i("span"),$l.textContent=_r,$o=o(),Ne=i("p"),Ne.innerHTML=Ur,Ao=o(),Ze=i("ul"),Ze.innerHTML=xr,Lo=o(),Be=i("p"),Be.textContent=Ir,Ho=o(),I=i("h3"),G=i("a"),Gl=i("span"),h(We.$$.fragment),Qa=o(),Al=i("span"),Al.textContent=$r,No=o(),Pe=i("ol"),Pe.innerHTML=Ar,Zo=o(),h(Ee.$$.fragment),Bo=o(),Q=i("ol"),Q.innerHTML=Lr,Wo=o(),h(Re.$$.fragment),Po=o(),ze=i("p"),ze.textContent=Hr,Eo=o(),h(Ge.$$.fragment),Ro=o(),Qe=i("p"),Qe.textContent=Nr,zo=o(),h(Ve.$$.fragment),Go=o(),V=i("ol"),V.innerHTML=Zr,Qo=o(),De=i("p"),De.innerHTML=Br,Vo=o(),D=i("ol"),D.innerHTML=Wr,Do=o(),h(Se.$$.fragment),So=o(),Ye=i("p"),Ye.innerHTML=Pr,Yo=o(),$=i("h3"),S=i("a"),Ql=i("span"),h(Fe.$$.fragment),Va=o(),Ll=i("span"),Ll.textContent=Er,Fo=o(),Xe=i("p"),Xe.innerHTML=Rr,Xo=o(),qe=i("p"),qe.textContent=zr,qo=o(),Oe=i("p"),Oe.innerHTML=Gr,Oo=o(),Ke=i("ul"),Ke.innerHTML=Qr,Ko=o(),et=i("p"),et.innerHTML=Vr,es=o(),tt=i("p"),tt.textContent=Dr,ts=o(),nt=i("p"),nt.textContent=Sr,ns=o(),lt=i("ul"),lt.innerHTML=Yr,ls=o(),ot=i("p"),ot.textContent=Fr,os=o(),st=i("p"),st.innerHTML=Xr,ss=o(),it=i("p"),it.innerHTML=qr,is=o(),h(at.$$.fragment),as=o(),rt=i("p"),rt.textContent=Or,rs=o(),dt=i("ul"),dt.innerHTML=Kr,ds=o(),ht=i("p"),ht.textContent=ed,hs=o(),pt=i("p"),pt.innerHTML=td,ps=o(),mt=i("ul"),mt.innerHTML=nd,ms=o(),ut=i("p"),ut.innerHTML=ld,us=o(),ct=i("p"),ct.innerHTML=od,cs=o(),ft=i("p"),ft.textContent=sd,fs=o(),yt=i("p"),yt.textContent=id,ys=o(),wt=i("ol"),wt.innerHTML=ad,ws=o(),Mt=i("p"),Mt.innerHTML=rd,Ms=o(),Tt=i("p"),Tt.textContent=dd,Ts=o(),h(gt.$$.fragment),gs=o(),bt=i("p"),bt.innerHTML=hd,bs=o(),vt=i("ul"),vt.innerHTML=pd,vs=o(),Jt=i("p"),Jt.innerHTML=md,Js=o(),A=i("h3"),Y=i("a"),Vl=i("span"),h(jt.$$.fragment),Da=o(),Hl=i("span"),Hl.textContent=ud,js=o(),Ct=i("p"),Ct.textContent=cd,Cs=o(),h(kt.$$.fragment),ks=o(),_t=i("p"),_t.innerHTML=fd,_s=o(),Ut=i("p"),Ut.textContent=yd,Us=o(),xt=i("ul"),xt.innerHTML=wd,xs=o(),It=i("p"),It.innerHTML=Md,Is=o(),$t=i("p"),$t.innerHTML=Td,$s=o(),At=i("p"),At.innerHTML=gd,As=o(),Lt=i("p"),Lt.textContent=bd,Ls=o(),Ht=i("ol"),Ht.innerHTML=vd,Hs=o(),h(Nt.$$.fragment),Ns=o(),F=i("ol"),F.innerHTML=Jd,Zs=o(),h(Zt.$$.fragment),Bs=o(),X=i("ol"),X.innerHTML=jd,Ws=o(),h(Bt.$$.fragment),Ps=o(),q=i("ol"),q.innerHTML=Cd,Es=o(),h(Wt.$$.fragment),Rs=o(),O=i("ol"),O.innerHTML=kd,zs=o(),Pt=i("p"),Pt.textContent=_d,Gs=o(),h(Et.$$.fragment),Qs=o(),Rt=i("p"),Rt.textContent=Ud,Vs=o(),zt=i("p"),zt.textContent=xd,Ds=o(),Gt=i("p"),Gt.textContent=Id,Ss=o(),Qt=i("p"),Qt.innerHTML=$d,Ys=o(),Vt=i("p"),Vt.innerHTML=Ad,Fs=o(),Dt=i("p"),Dt.innerHTML=Ld,Xs=o(),St=i("p"),St.innerHTML=Hd,qs=o(),h(Yt.$$.fragment),Os=o(),Ft=i("p"),Ft.innerHTML=Nd,Ks=o(),Xt=i("p"),Xt.innerHTML=Zd,ei=o(),h(qt.$$.fragment),ti=o(),Ot=i("p"),Ot.innerHTML=Bd,ni=o(),h(Kt.$$.fragment),li=o(),en=i("p"),en.innerHTML=Wd,oi=o(),tn=i("p"),tn.innerHTML=Pd,si=o(),nn=i("p"),nn.innerHTML=Ed,ii=o(),ln=i("ul"),ln.innerHTML=Rd,ai=o(),on=i("p"),on.innerHTML=zd,ri=o(),h(sn.$$.fragment),di=o(),an=i("p"),an.innerHTML=Gd,hi=o(),h(rn.$$.fragment),pi=o(),dn=i("p"),dn.textContent=Qd,mi=o(),h(hn.$$.fragment),ui=o(),pn=i("p"),pn.textContent=Vd,ci=o(),h(mn.$$.fragment),fi=o(),un=i("p"),un.textContent=Dd,yi=o(),h(cn.$$.fragment),wi=o(),fn=i("p"),fn.innerHTML=Sd,Mi=o(),h(yn.$$.fragment),Ti=o(),wn=i("p"),wn.innerHTML=Yd,gi=o(),h(Mn.$$.fragment),bi=o(),Tn=i("p"),Tn.innerHTML=Fd,vi=o(),h(gn.$$.fragment),Ji=o(),bn=i("p"),bn.textContent=Xd,ji=o(),vn=i("p"),vn.innerHTML=qd,Ci=o(),Jn=i("p"),Jn.innerHTML=Od,ki=o(),jn=i("p"),jn.innerHTML=Kd,_i=o(),h(Cn.$$.fragment),Ui=o(),kn=i("p"),kn.innerHTML=eh,xi=o(),_n=i("p"),_n.innerHTML=th,Ii=o(),h(Un.$$.fragment),$i=o(),xn=i("p"),xn.innerHTML=nh,Ai=o(),In=i("p"),In.innerHTML=lh,Li=o(),$n=i("ul"),$n.innerHTML=oh,Hi=o(),An=i("p"),An.innerHTML=sh,Ni=o(),Ln=i("p"),Ln.innerHTML=ih,Zi=o(),Hn=i("p"),Hn.innerHTML=ah,Bi=o(),Nn=i("p"),Nn.innerHTML=rh,Wi=o(),h(Zn.$$.fragment),Pi=o(),Bn=i("p"),Bn.textContent=dh,Ei=o(),Wn=i("ul"),Wn.innerHTML=hh,Ri=o(),Pn=i("p"),Pn.innerHTML=ph,zi=o(),h(En.$$.fragment),Gi=o(),h(K.$$.fragment),Qi=o(),Rn=i("p"),Rn.innerHTML=mh,Vi=o(),zn=i("ul"),zn.innerHTML=uh,Di=o(),Gn=i("p"),Gn.innerHTML=ch,Si=o(),Qn=i("p"),Qn.innerHTML=fh,Yi=o(),Vn=i("p"),Vn.textContent=yh,Fi=o(),Dn=i("p"),Dn.textContent=wh,Xi=o(),h(Sn.$$.fragment),qi=o(),Yn=i("p"),Yn.innerHTML=Mh,Oi=o(),h(Fn.$$.fragment),Ki=o(),Xn=i("p"),Xn.innerHTML=Th,ea=o(),qn=i("p"),qn.innerHTML=gh,ta=o(),On=i("p"),On.innerHTML=bh,na=o(),Kn=i("p"),Kn.innerHTML=vh,la=o(),el=i("p"),el.innerHTML=Jh,oa=o(),tl=i("p"),tl.innerHTML=jh,sa=o(),nl=i("p"),nl.innerHTML=Ch,ia=o(),ll=i("p"),ll.innerHTML=kh,aa=o(),ol=i("p"),ol.innerHTML=_h,ra=o(),h(sl.$$.fragment),da=o(),il=i("p"),il.textContent=Uh,ha=o(),h(al.$$.fragment),pa=o(),rl=i("p"),rl.textContent=xh,ma=o(),dl=i("p"),dl.textContent=Ih,ua=o(),hl=i("p"),hl.textContent=$h,ca=o(),pl=i("p"),pl.innerHTML=Ah,fa=o(),ml=i("p"),ml.innerHTML=Lh,ya=o(),h(ul.$$.fragment),wa=o(),cl=i("p"),cl.innerHTML=Hh,Ma=o(),fl=i("p"),fl.innerHTML=Nh,Ta=o(),yl=i("p"),yl.innerHTML=Zh,ga=o(),wl=i("p"),wl.innerHTML=Bh,ba=o(),Ml=i("p"),Ml.textContent=Wh,va=o(),L=i("h3"),ee=i("a"),Dl=i("span"),h(Tl.$$.fragment),Sa=o(),Nl=i("span"),Nl.textContent=Ph,Ja=o(),gl=i("p"),gl.textContent=Eh,ja=o(),bl=i("p"),bl.innerHTML=Rh,Ca=o(),Sl=i("p"),this.h()},l(e){const t=yp("svelte-1phssyn",document.head);T=a(t,"META",{name:!0,content:!0}),t.forEach(n),v=s(e),g=a(e,"P",{}),w(g).forEach(n),H=s(e),J=a(e,"H1",{class:!0});var vl=w(J);N=a(vl,"A",{id:!0,class:!0,href:!0});var Yl=w(N);Zl=a(Yl,"SPAN",{});var zh=w(Zl);p(te.$$.fragment,zh),zh.forEach(n),Yl.forEach(n),Ba=s(vl),jl=a(vl,"SPAN",{"data-svelte-h":!0}),r(jl)!=="svelte-20y6qg"&&(jl.textContent=Ya),vl.forEach(n),Fl=s(e),ne=a(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-wxtsp1"&&(ne.innerHTML=Fa),Xl=s(e),p(Z.$$.fragment,e),ql=s(e),le=a(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1k9yxd1"&&(le.textContent=Xa),Ol=s(e),oe=a(e,"UL",{"data-svelte-h":!0}),r(oe)!=="svelte-167a1ja"&&(oe.innerHTML=qa),Kl=s(e),se=a(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1wxv5qq"&&(se.textContent=Oa),eo=s(e),ie=a(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-77fy0j"&&(ie.innerHTML=Ka),to=s(e),ae=a(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-ug8854"&&(ae.textContent=er),no=s(e),j=a(e,"H2",{class:!0});var _a=w(j);B=a(_a,"A",{id:!0,class:!0,href:!0});var Gh=w(B);Bl=a(Gh,"SPAN",{});var Qh=w(Bl);p(re.$$.fragment,Qh),Qh.forEach(n),Gh.forEach(n),Wa=s(_a),Cl=a(_a,"SPAN",{"data-svelte-h":!0}),r(Cl)!=="svelte-p1jm02"&&(Cl.textContent=tr),_a.forEach(n),lo=s(e),de=a(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-rkgkw1"&&(de.textContent=nr),oo=s(e),he=a(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-hekrk0"&&(he.innerHTML=lr),so=s(e),pe=a(e,"UL",{"data-svelte-h":!0}),r(pe)!=="svelte-9txdfw"&&(pe.innerHTML=or),io=s(e),me=a(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-77738k"&&(me.innerHTML=sr),ao=s(e),ue=a(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1z0o4ph"&&(ue.textContent=ir),ro=s(e),C=a(e,"H3",{class:!0});var Ua=w(C);W=a(Ua,"A",{id:!0,class:!0,href:!0});var Vh=w(W);Wl=a(Vh,"SPAN",{});var Dh=w(Wl);p(ce.$$.fragment,Dh),Dh.forEach(n),Vh.forEach(n),Pa=s(Ua),kl=a(Ua,"SPAN",{"data-svelte-h":!0}),r(kl)!=="svelte-jqf38j"&&(kl.textContent=ar),Ua.forEach(n),ho=s(e),fe=a(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1ihdk17"&&(fe.innerHTML=rr),po=s(e),ye=a(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1bv64m8"&&(ye.textContent=dr),mo=s(e),_l=a(e,"IMG",{src:!0}),uo=s(e),we=a(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1sb9saj"&&(we.innerHTML=pr),co=s(e),p(Me.$$.fragment,e),fo=s(e),Te=a(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1o8fha1"&&(Te.innerHTML=mr),yo=s(e),k=a(e,"H3",{class:!0});var xa=w(k);P=a(xa,"A",{id:!0,class:!0,href:!0});var Sh=w(P);Pl=a(Sh,"SPAN",{});var Yh=w(Pl);p(ge.$$.fragment,Yh),Yh.forEach(n),Sh.forEach(n),Ea=s(xa),Ul=a(xa,"SPAN",{"data-svelte-h":!0}),r(Ul)!=="svelte-vzygxd"&&(Ul.textContent=ur),xa.forEach(n),wo=s(e),be=a(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-105bqi8"&&(be.textContent=cr),Mo=s(e),ve=a(e,"OL",{"data-svelte-h":!0}),r(ve)!=="svelte-3selcg"&&(ve.innerHTML=fr),To=s(e),_=a(e,"H3",{class:!0});var Ia=w(_);E=a(Ia,"A",{id:!0,class:!0,href:!0});var Fh=w(E);El=a(Fh,"SPAN",{});var Xh=w(El);p(Je.$$.fragment,Xh),Xh.forEach(n),Fh.forEach(n),Ra=s(Ia),xl=a(Ia,"SPAN",{"data-svelte-h":!0}),r(xl)!=="svelte-1rq83x7"&&(xl.textContent=yr),Ia.forEach(n),go=s(e),je=a(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-10n9flr"&&(je.textContent=wr),bo=s(e),U=a(e,"H2",{class:!0});var $a=w(U);R=a($a,"A",{id:!0,class:!0,href:!0});var qh=w(R);Rl=a(qh,"SPAN",{});var Oh=w(Rl);p(Ce.$$.fragment,Oh),Oh.forEach(n),qh.forEach(n),za=s($a),Il=a($a,"SPAN",{"data-svelte-h":!0}),r(Il)!=="svelte-1i9kr9a"&&(Il.textContent=Mr),$a.forEach(n),vo=s(e),ke=a(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-u747sz"&&(ke.textContent=Tr),Jo=s(e),_e=a(e,"OL",{"data-svelte-h":!0}),r(_e)!=="svelte-b7gw6m"&&(_e.innerHTML=gr),jo=s(e),Ue=a(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-lru7u6"&&(Ue.textContent=br),Co=s(e),xe=a(e,"UL",{"data-svelte-h":!0}),r(xe)!=="svelte-otnau5"&&(xe.innerHTML=vr),ko=s(e),Ie=a(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-sv8a89"&&(Ie.textContent=Jr),_o=s(e),$e=a(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1ydy9mz"&&($e.textContent=jr),Uo=s(e),Ae=a(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-w74yfn"&&(Ae.innerHTML=Cr),xo=s(e),Le=a(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1pmt80l"&&(Le.innerHTML=kr),Io=s(e),x=a(e,"H3",{class:!0});var Aa=w(x);z=a(Aa,"A",{id:!0,class:!0,href:!0});var Kh=w(z);zl=a(Kh,"SPAN",{});var ep=w(zl);p(He.$$.fragment,ep),ep.forEach(n),Kh.forEach(n),Ga=s(Aa),$l=a(Aa,"SPAN",{"data-svelte-h":!0}),r($l)!=="svelte-30clyv"&&($l.textContent=_r),Aa.forEach(n),$o=s(e),Ne=a(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-10phlbf"&&(Ne.innerHTML=Ur),Ao=s(e),Ze=a(e,"UL",{"data-svelte-h":!0}),r(Ze)!=="svelte-1b4oxlm"&&(Ze.innerHTML=xr),Lo=s(e),Be=a(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-g50mc6"&&(Be.textContent=Ir),Ho=s(e),I=a(e,"H3",{class:!0});var La=w(I);G=a(La,"A",{id:!0,class:!0,href:!0});var tp=w(G);Gl=a(tp,"SPAN",{});var np=w(Gl);p(We.$$.fragment,np),np.forEach(n),tp.forEach(n),Qa=s(La),Al=a(La,"SPAN",{"data-svelte-h":!0}),r(Al)!=="svelte-5cqrut"&&(Al.textContent=$r),La.forEach(n),No=s(e),Pe=a(e,"OL",{"data-svelte-h":!0}),r(Pe)!=="svelte-klt7ii"&&(Pe.innerHTML=Ar),Zo=s(e),p(Ee.$$.fragment,e),Bo=s(e),Q=a(e,"OL",{start:!0,"data-svelte-h":!0}),r(Q)!=="svelte-9h285g"&&(Q.innerHTML=Lr),Wo=s(e),p(Re.$$.fragment,e),Po=s(e),ze=a(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-4wf1r3"&&(ze.textContent=Hr),Eo=s(e),p(Ge.$$.fragment,e),Ro=s(e),Qe=a(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-182t6ba"&&(Qe.textContent=Nr),zo=s(e),p(Ve.$$.fragment,e),Go=s(e),V=a(e,"OL",{start:!0,"data-svelte-h":!0}),r(V)!=="svelte-fi4dxm"&&(V.innerHTML=Zr),Qo=s(e),De=a(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-6bybv3"&&(De.innerHTML=Br),Vo=s(e),D=a(e,"OL",{start:!0,"data-svelte-h":!0}),r(D)!=="svelte-17p20v0"&&(D.innerHTML=Wr),Do=s(e),p(Se.$$.fragment,e),So=s(e),Ye=a(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-63px9k"&&(Ye.innerHTML=Pr),Yo=s(e),$=a(e,"H3",{class:!0});var Ha=w($);S=a(Ha,"A",{id:!0,class:!0,href:!0});var lp=w(S);Ql=a(lp,"SPAN",{});var op=w(Ql);p(Fe.$$.fragment,op),op.forEach(n),lp.forEach(n),Va=s(Ha),Ll=a(Ha,"SPAN",{"data-svelte-h":!0}),r(Ll)!=="svelte-1a7cqyb"&&(Ll.textContent=Er),Ha.forEach(n),Fo=s(e),Xe=a(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-hj6dkp"&&(Xe.innerHTML=Rr),Xo=s(e),qe=a(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-1wodnvr"&&(qe.textContent=zr),qo=s(e),Oe=a(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-172lkai"&&(Oe.innerHTML=Gr),Oo=s(e),Ke=a(e,"UL",{"data-svelte-h":!0}),r(Ke)!=="svelte-10bloo4"&&(Ke.innerHTML=Qr),Ko=s(e),et=a(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1jxuc4f"&&(et.innerHTML=Vr),es=s(e),tt=a(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-197bmdq"&&(tt.textContent=Dr),ts=s(e),nt=a(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-9v9j15"&&(nt.textContent=Sr),ns=s(e),lt=a(e,"UL",{"data-svelte-h":!0}),r(lt)!=="svelte-1k92mpt"&&(lt.innerHTML=Yr),ls=s(e),ot=a(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-xdlpes"&&(ot.textContent=Fr),os=s(e),st=a(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-1u4zdsg"&&(st.innerHTML=Xr),ss=s(e),it=a(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-1g4uiwx"&&(it.innerHTML=qr),is=s(e),p(at.$$.fragment,e),as=s(e),rt=a(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-17f6vr7"&&(rt.textContent=Or),rs=s(e),dt=a(e,"UL",{"data-svelte-h":!0}),r(dt)!=="svelte-1w5zp67"&&(dt.innerHTML=Kr),ds=s(e),ht=a(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-69ds49"&&(ht.textContent=ed),hs=s(e),pt=a(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-17olrqh"&&(pt.innerHTML=td),ps=s(e),mt=a(e,"UL",{"data-svelte-h":!0}),r(mt)!=="svelte-uaiiy7"&&(mt.innerHTML=nd),ms=s(e),ut=a(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-pv6v4"&&(ut.innerHTML=ld),us=s(e),ct=a(e,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-1ex3w25"&&(ct.innerHTML=od),cs=s(e),ft=a(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-1480vjb"&&(ft.textContent=sd),fs=s(e),yt=a(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-1sttzvl"&&(yt.textContent=id),ys=s(e),wt=a(e,"OL",{"data-svelte-h":!0}),r(wt)!=="svelte-1u0bkk8"&&(wt.innerHTML=ad),ws=s(e),Mt=a(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-xvgy42"&&(Mt.innerHTML=rd),Ms=s(e),Tt=a(e,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-a9oe4g"&&(Tt.textContent=dd),Ts=s(e),p(gt.$$.fragment,e),gs=s(e),bt=a(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-1d7jpm"&&(bt.innerHTML=hd),bs=s(e),vt=a(e,"UL",{"data-svelte-h":!0}),r(vt)!=="svelte-1bsafyj"&&(vt.innerHTML=pd),vs=s(e),Jt=a(e,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-1fog5tn"&&(Jt.innerHTML=md),Js=s(e),A=a(e,"H3",{class:!0});var Na=w(A);Y=a(Na,"A",{id:!0,class:!0,href:!0});var sp=w(Y);Vl=a(sp,"SPAN",{});var ip=w(Vl);p(jt.$$.fragment,ip),ip.forEach(n),sp.forEach(n),Da=s(Na),Hl=a(Na,"SPAN",{"data-svelte-h":!0}),r(Hl)!=="svelte-atmjij"&&(Hl.textContent=ud),Na.forEach(n),js=s(e),Ct=a(e,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-hwuqxz"&&(Ct.textContent=cd),Cs=s(e),p(kt.$$.fragment,e),ks=s(e),_t=a(e,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-1492az0"&&(_t.innerHTML=fd),_s=s(e),Ut=a(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-1xw3dz2"&&(Ut.textContent=yd),Us=s(e),xt=a(e,"UL",{"data-svelte-h":!0}),r(xt)!=="svelte-1k5sxi0"&&(xt.innerHTML=wd),xs=s(e),It=a(e,"P",{"data-svelte-h":!0}),r(It)!=="svelte-1a60q7m"&&(It.innerHTML=Md),Is=s(e),$t=a(e,"P",{"data-svelte-h":!0}),r($t)!=="svelte-1e0s43k"&&($t.innerHTML=Td),$s=s(e),At=a(e,"P",{"data-svelte-h":!0}),r(At)!=="svelte-1aoj71c"&&(At.innerHTML=gd),As=s(e),Lt=a(e,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-3h83p"&&(Lt.textContent=bd),Ls=s(e),Ht=a(e,"OL",{"data-svelte-h":!0}),r(Ht)!=="svelte-14ngdyo"&&(Ht.innerHTML=vd),Hs=s(e),p(Nt.$$.fragment,e),Ns=s(e),F=a(e,"OL",{start:!0,"data-svelte-h":!0}),r(F)!=="svelte-ebgta7"&&(F.innerHTML=Jd),Zs=s(e),p(Zt.$$.fragment,e),Bs=s(e),X=a(e,"OL",{start:!0,"data-svelte-h":!0}),r(X)!=="svelte-1xlslu7"&&(X.innerHTML=jd),Ws=s(e),p(Bt.$$.fragment,e),Ps=s(e),q=a(e,"OL",{start:!0,"data-svelte-h":!0}),r(q)!=="svelte-1wwc89z"&&(q.innerHTML=Cd),Es=s(e),p(Wt.$$.fragment,e),Rs=s(e),O=a(e,"OL",{start:!0,"data-svelte-h":!0}),r(O)!=="svelte-1k28gwf"&&(O.innerHTML=kd),zs=s(e),Pt=a(e,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-fby7tz"&&(Pt.textContent=_d),Gs=s(e),p(Et.$$.fragment,e),Qs=s(e),Rt=a(e,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-707ott"&&(Rt.textContent=Ud),Vs=s(e),zt=a(e,"P",{"data-svelte-h":!0}),r(zt)!=="svelte-10vuoyb"&&(zt.textContent=xd),Ds=s(e),Gt=a(e,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-1rsqt8e"&&(Gt.textContent=Id),Ss=s(e),Qt=a(e,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-e56uo0"&&(Qt.innerHTML=$d),Ys=s(e),Vt=a(e,"P",{"data-svelte-h":!0}),r(Vt)!=="svelte-1pev0u3"&&(Vt.innerHTML=Ad),Fs=s(e),Dt=a(e,"P",{"data-svelte-h":!0}),r(Dt)!=="svelte-o2c99d"&&(Dt.innerHTML=Ld),Xs=s(e),St=a(e,"P",{"data-svelte-h":!0}),r(St)!=="svelte-cf404e"&&(St.innerHTML=Hd),qs=s(e),p(Yt.$$.fragment,e),Os=s(e),Ft=a(e,"P",{"data-svelte-h":!0}),r(Ft)!=="svelte-1dloo7i"&&(Ft.innerHTML=Nd),Ks=s(e),Xt=a(e,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-nsqyfa"&&(Xt.innerHTML=Zd),ei=s(e),p(qt.$$.fragment,e),ti=s(e),Ot=a(e,"P",{"data-svelte-h":!0}),r(Ot)!=="svelte-sj6wf0"&&(Ot.innerHTML=Bd),ni=s(e),p(Kt.$$.fragment,e),li=s(e),en=a(e,"P",{"data-svelte-h":!0}),r(en)!=="svelte-1pfm0sb"&&(en.innerHTML=Wd),oi=s(e),tn=a(e,"P",{"data-svelte-h":!0}),r(tn)!=="svelte-f68cwo"&&(tn.innerHTML=Pd),si=s(e),nn=a(e,"P",{"data-svelte-h":!0}),r(nn)!=="svelte-vdut7s"&&(nn.innerHTML=Ed),ii=s(e),ln=a(e,"UL",{"data-svelte-h":!0}),r(ln)!=="svelte-16vb6hw"&&(ln.innerHTML=Rd),ai=s(e),on=a(e,"P",{"data-svelte-h":!0}),r(on)!=="svelte-14nqqv0"&&(on.innerHTML=zd),ri=s(e),p(sn.$$.fragment,e),di=s(e),an=a(e,"P",{"data-svelte-h":!0}),r(an)!=="svelte-p81vjw"&&(an.innerHTML=Gd),hi=s(e),p(rn.$$.fragment,e),pi=s(e),dn=a(e,"P",{"data-svelte-h":!0}),r(dn)!=="svelte-ilov09"&&(dn.textContent=Qd),mi=s(e),p(hn.$$.fragment,e),ui=s(e),pn=a(e,"P",{"data-svelte-h":!0}),r(pn)!=="svelte-13dugi2"&&(pn.textContent=Vd),ci=s(e),p(mn.$$.fragment,e),fi=s(e),un=a(e,"P",{"data-svelte-h":!0}),r(un)!=="svelte-1lx6n8g"&&(un.textContent=Dd),yi=s(e),p(cn.$$.fragment,e),wi=s(e),fn=a(e,"P",{"data-svelte-h":!0}),r(fn)!=="svelte-1t5qty0"&&(fn.innerHTML=Sd),Mi=s(e),p(yn.$$.fragment,e),Ti=s(e),wn=a(e,"P",{"data-svelte-h":!0}),r(wn)!=="svelte-1b67ucv"&&(wn.innerHTML=Yd),gi=s(e),p(Mn.$$.fragment,e),bi=s(e),Tn=a(e,"P",{"data-svelte-h":!0}),r(Tn)!=="svelte-10rxzj1"&&(Tn.innerHTML=Fd),vi=s(e),p(gn.$$.fragment,e),Ji=s(e),bn=a(e,"P",{"data-svelte-h":!0}),r(bn)!=="svelte-tq4e7m"&&(bn.textContent=Xd),ji=s(e),vn=a(e,"P",{"data-svelte-h":!0}),r(vn)!=="svelte-nguxo0"&&(vn.innerHTML=qd),Ci=s(e),Jn=a(e,"P",{"data-svelte-h":!0}),r(Jn)!=="svelte-5g2dr4"&&(Jn.innerHTML=Od),ki=s(e),jn=a(e,"P",{"data-svelte-h":!0}),r(jn)!=="svelte-jkulr9"&&(jn.innerHTML=Kd),_i=s(e),p(Cn.$$.fragment,e),Ui=s(e),kn=a(e,"P",{"data-svelte-h":!0}),r(kn)!=="svelte-8ivqw6"&&(kn.innerHTML=eh),xi=s(e),_n=a(e,"P",{"data-svelte-h":!0}),r(_n)!=="svelte-1voodxv"&&(_n.innerHTML=th),Ii=s(e),p(Un.$$.fragment,e),$i=s(e),xn=a(e,"P",{"data-svelte-h":!0}),r(xn)!=="svelte-txar7q"&&(xn.innerHTML=nh),Ai=s(e),In=a(e,"P",{"data-svelte-h":!0}),r(In)!=="svelte-10rs2ro"&&(In.innerHTML=lh),Li=s(e),$n=a(e,"UL",{"data-svelte-h":!0}),r($n)!=="svelte-1r46n3h"&&($n.innerHTML=oh),Hi=s(e),An=a(e,"P",{"data-svelte-h":!0}),r(An)!=="svelte-1i2mpdn"&&(An.innerHTML=sh),Ni=s(e),Ln=a(e,"P",{"data-svelte-h":!0}),r(Ln)!=="svelte-16p1dlw"&&(Ln.innerHTML=ih),Zi=s(e),Hn=a(e,"P",{"data-svelte-h":!0}),r(Hn)!=="svelte-1q8o052"&&(Hn.innerHTML=ah),Bi=s(e),Nn=a(e,"P",{"data-svelte-h":!0}),r(Nn)!=="svelte-13ruakv"&&(Nn.innerHTML=rh),Wi=s(e),p(Zn.$$.fragment,e),Pi=s(e),Bn=a(e,"P",{"data-svelte-h":!0}),r(Bn)!=="svelte-1z4cf"&&(Bn.textContent=dh),Ei=s(e),Wn=a(e,"UL",{"data-svelte-h":!0}),r(Wn)!=="svelte-1msq586"&&(Wn.innerHTML=hh),Ri=s(e),Pn=a(e,"P",{"data-svelte-h":!0}),r(Pn)!=="svelte-2t6h0z"&&(Pn.innerHTML=ph),zi=s(e),p(En.$$.fragment,e),Gi=s(e),p(K.$$.fragment,e),Qi=s(e),Rn=a(e,"P",{"data-svelte-h":!0}),r(Rn)!=="svelte-1wqbt18"&&(Rn.innerHTML=mh),Vi=s(e),zn=a(e,"UL",{"data-svelte-h":!0}),r(zn)!=="svelte-1192mxo"&&(zn.innerHTML=uh),Di=s(e),Gn=a(e,"P",{"data-svelte-h":!0}),r(Gn)!=="svelte-1l7w7z9"&&(Gn.innerHTML=ch),Si=s(e),Qn=a(e,"P",{"data-svelte-h":!0}),r(Qn)!=="svelte-17g0btz"&&(Qn.innerHTML=fh),Yi=s(e),Vn=a(e,"P",{"data-svelte-h":!0}),r(Vn)!=="svelte-w3jgow"&&(Vn.textContent=yh),Fi=s(e),Dn=a(e,"P",{"data-svelte-h":!0}),r(Dn)!=="svelte-1g2gl02"&&(Dn.textContent=wh),Xi=s(e),p(Sn.$$.fragment,e),qi=s(e),Yn=a(e,"P",{"data-svelte-h":!0}),r(Yn)!=="svelte-12b6z3d"&&(Yn.innerHTML=Mh),Oi=s(e),p(Fn.$$.fragment,e),Ki=s(e),Xn=a(e,"P",{"data-svelte-h":!0}),r(Xn)!=="svelte-12o38jn"&&(Xn.innerHTML=Th),ea=s(e),qn=a(e,"P",{"data-svelte-h":!0}),r(qn)!=="svelte-m9dhdl"&&(qn.innerHTML=gh),ta=s(e),On=a(e,"P",{"data-svelte-h":!0}),r(On)!=="svelte-1r4x1hz"&&(On.innerHTML=bh),na=s(e),Kn=a(e,"P",{"data-svelte-h":!0}),r(Kn)!=="svelte-1a2qjdi"&&(Kn.innerHTML=vh),la=s(e),el=a(e,"P",{"data-svelte-h":!0}),r(el)!=="svelte-lu4l51"&&(el.innerHTML=Jh),oa=s(e),tl=a(e,"P",{"data-svelte-h":!0}),r(tl)!=="svelte-ngbmem"&&(tl.innerHTML=jh),sa=s(e),nl=a(e,"P",{"data-svelte-h":!0}),r(nl)!=="svelte-y9aahr"&&(nl.innerHTML=Ch),ia=s(e),ll=a(e,"P",{"data-svelte-h":!0}),r(ll)!=="svelte-1h13ics"&&(ll.innerHTML=kh),aa=s(e),ol=a(e,"P",{"data-svelte-h":!0}),r(ol)!=="svelte-1o0dhcg"&&(ol.innerHTML=_h),ra=s(e),p(sl.$$.fragment,e),da=s(e),il=a(e,"P",{"data-svelte-h":!0}),r(il)!=="svelte-1hnvgw6"&&(il.textContent=Uh),ha=s(e),p(al.$$.fragment,e),pa=s(e),rl=a(e,"P",{"data-svelte-h":!0}),r(rl)!=="svelte-158gt2o"&&(rl.textContent=xh),ma=s(e),dl=a(e,"P",{"data-svelte-h":!0}),r(dl)!=="svelte-z20wkr"&&(dl.textContent=Ih),ua=s(e),hl=a(e,"P",{"data-svelte-h":!0}),r(hl)!=="svelte-1uwhc8b"&&(hl.textContent=$h),ca=s(e),pl=a(e,"P",{"data-svelte-h":!0}),r(pl)!=="svelte-cmu0wm"&&(pl.innerHTML=Ah),fa=s(e),ml=a(e,"P",{"data-svelte-h":!0}),r(ml)!=="svelte-11c1nk5"&&(ml.innerHTML=Lh),ya=s(e),p(ul.$$.fragment,e),wa=s(e),cl=a(e,"P",{"data-svelte-h":!0}),r(cl)!=="svelte-hwxs76"&&(cl.innerHTML=Hh),Ma=s(e),fl=a(e,"P",{"data-svelte-h":!0}),r(fl)!=="svelte-1gie4tq"&&(fl.innerHTML=Nh),Ta=s(e),yl=a(e,"P",{"data-svelte-h":!0}),r(yl)!=="svelte-1so49zx"&&(yl.innerHTML=Zh),ga=s(e),wl=a(e,"P",{"data-svelte-h":!0}),r(wl)!=="svelte-144ouhf"&&(wl.innerHTML=Bh),ba=s(e),Ml=a(e,"P",{"data-svelte-h":!0}),r(Ml)!=="svelte-jag54x"&&(Ml.textContent=Wh),va=s(e),L=a(e,"H3",{class:!0});var Za=w(L);ee=a(Za,"A",{id:!0,class:!0,href:!0});var ap=w(ee);Dl=a(ap,"SPAN",{});var rp=w(Dl);p(Tl.$$.fragment,rp),rp.forEach(n),ap.forEach(n),Sa=s(Za),Nl=a(Za,"SPAN",{"data-svelte-h":!0}),r(Nl)!=="svelte-1tpgk6m"&&(Nl.textContent=Ph),Za.forEach(n),Ja=s(e),gl=a(e,"P",{"data-svelte-h":!0}),r(gl)!=="svelte-d34izn"&&(gl.textContent=Eh),ja=s(e),bl=a(e,"P",{"data-svelte-h":!0}),r(bl)!=="svelte-1f9gbqf"&&(bl.innerHTML=Rh),Ca=s(e),Sl=a(e,"P",{}),w(Sl).forEach(n),this.h()},h(){d(T,"name","hf:doc:metadata"),d(T,"content",JSON.stringify(gp)),d(N,"id","how-to-add-a-model-to-transformers"),d(N,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(N,"href","#how-to-add-a-model-to-transformers"),d(J,"class","relative group"),d(B,"id","general-overview-of-transformers"),d(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(B,"href","#general-overview-of-transformers"),d(j,"class","relative group"),d(W,"id","overview-of-models"),d(W,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(W,"href","#overview-of-models"),d(C,"class","relative group"),mp(_l.src,hr="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers_overview.png")||d(_l,"src",hr),d(P,"id","code-style"),d(P,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(P,"href","#code-style"),d(k,"class","relative group"),d(E,"id","overview-of-tokenizers"),d(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(E,"href","#overview-of-tokenizers"),d(_,"class","relative group"),d(R,"id","stepbystep-recipe-to-add-a-model-to-transformers"),d(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(R,"href","#stepbystep-recipe-to-add-a-model-to-transformers"),d(U,"class","relative group"),d(z,"id","1-optional-theoretical-aspects-of-brandnewbert"),d(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(z,"href","#1-optional-theoretical-aspects-of-brandnewbert"),d(x,"class","relative group"),d(G,"id","2-next-prepare-your-environment"),d(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(G,"href","#2-next-prepare-your-environment"),d(I,"class","relative group"),d(Q,"start","3"),d(V,"start","4"),d(D,"start","5"),d(S,"id","34-run-a-pretrained-checkpoint-using-the-original-repository"),d(S,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(S,"href","#34-run-a-pretrained-checkpoint-using-the-original-repository"),d($,"class","relative group"),d(Y,"id","514-port-brandnewbert-to-transformers"),d(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Y,"href","#514-port-brandnewbert-to-transformers"),d(A,"class","relative group"),d(F,"start","2"),d(X,"start","3"),d(q,"start","4"),d(O,"start","5"),d(ee,"id","share-your-work"),d(ee,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(ee,"href","#share-your-work"),d(L,"class","relative group")},m(e,t){y(document.head,T),l(e,v,t),l(e,g,t),l(e,H,t),l(e,J,t),y(J,N),y(N,Zl),m(te,Zl,null),y(J,Ba),y(J,jl),l(e,Fl,t),l(e,ne,t),l(e,Xl,t),m(Z,e,t),l(e,ql,t),l(e,le,t),l(e,Ol,t),l(e,oe,t),l(e,Kl,t),l(e,se,t),l(e,eo,t),l(e,ie,t),l(e,to,t),l(e,ae,t),l(e,no,t),l(e,j,t),y(j,B),y(B,Bl),m(re,Bl,null),y(j,Wa),y(j,Cl),l(e,lo,t),l(e,de,t),l(e,oo,t),l(e,he,t),l(e,so,t),l(e,pe,t),l(e,io,t),l(e,me,t),l(e,ao,t),l(e,ue,t),l(e,ro,t),l(e,C,t),y(C,W),y(W,Wl),m(ce,Wl,null),y(C,Pa),y(C,kl),l(e,ho,t),l(e,fe,t),l(e,po,t),l(e,ye,t),l(e,mo,t),l(e,_l,t),l(e,uo,t),l(e,we,t),l(e,co,t),m(Me,e,t),l(e,fo,t),l(e,Te,t),l(e,yo,t),l(e,k,t),y(k,P),y(P,Pl),m(ge,Pl,null),y(k,Ea),y(k,Ul),l(e,wo,t),l(e,be,t),l(e,Mo,t),l(e,ve,t),l(e,To,t),l(e,_,t),y(_,E),y(E,El),m(Je,El,null),y(_,Ra),y(_,xl),l(e,go,t),l(e,je,t),l(e,bo,t),l(e,U,t),y(U,R),y(R,Rl),m(Ce,Rl,null),y(U,za),y(U,Il),l(e,vo,t),l(e,ke,t),l(e,Jo,t),l(e,_e,t),l(e,jo,t),l(e,Ue,t),l(e,Co,t),l(e,xe,t),l(e,ko,t),l(e,Ie,t),l(e,_o,t),l(e,$e,t),l(e,Uo,t),l(e,Ae,t),l(e,xo,t),l(e,Le,t),l(e,Io,t),l(e,x,t),y(x,z),y(z,zl),m(He,zl,null),y(x,Ga),y(x,$l),l(e,$o,t),l(e,Ne,t),l(e,Ao,t),l(e,Ze,t),l(e,Lo,t),l(e,Be,t),l(e,Ho,t),l(e,I,t),y(I,G),y(G,Gl),m(We,Gl,null),y(I,Qa),y(I,Al),l(e,No,t),l(e,Pe,t),l(e,Zo,t),m(Ee,e,t),l(e,Bo,t),l(e,Q,t),l(e,Wo,t),m(Re,e,t),l(e,Po,t),l(e,ze,t),l(e,Eo,t),m(Ge,e,t),l(e,Ro,t),l(e,Qe,t),l(e,zo,t),m(Ve,e,t),l(e,Go,t),l(e,V,t),l(e,Qo,t),l(e,De,t),l(e,Vo,t),l(e,D,t),l(e,Do,t),m(Se,e,t),l(e,So,t),l(e,Ye,t),l(e,Yo,t),l(e,$,t),y($,S),y(S,Ql),m(Fe,Ql,null),y($,Va),y($,Ll),l(e,Fo,t),l(e,Xe,t),l(e,Xo,t),l(e,qe,t),l(e,qo,t),l(e,Oe,t),l(e,Oo,t),l(e,Ke,t),l(e,Ko,t),l(e,et,t),l(e,es,t),l(e,tt,t),l(e,ts,t),l(e,nt,t),l(e,ns,t),l(e,lt,t),l(e,ls,t),l(e,ot,t),l(e,os,t),l(e,st,t),l(e,ss,t),l(e,it,t),l(e,is,t),m(at,e,t),l(e,as,t),l(e,rt,t),l(e,rs,t),l(e,dt,t),l(e,ds,t),l(e,ht,t),l(e,hs,t),l(e,pt,t),l(e,ps,t),l(e,mt,t),l(e,ms,t),l(e,ut,t),l(e,us,t),l(e,ct,t),l(e,cs,t),l(e,ft,t),l(e,fs,t),l(e,yt,t),l(e,ys,t),l(e,wt,t),l(e,ws,t),l(e,Mt,t),l(e,Ms,t),l(e,Tt,t),l(e,Ts,t),m(gt,e,t),l(e,gs,t),l(e,bt,t),l(e,bs,t),l(e,vt,t),l(e,vs,t),l(e,Jt,t),l(e,Js,t),l(e,A,t),y(A,Y),y(Y,Vl),m(jt,Vl,null),y(A,Da),y(A,Hl),l(e,js,t),l(e,Ct,t),l(e,Cs,t),m(kt,e,t),l(e,ks,t),l(e,_t,t),l(e,_s,t),l(e,Ut,t),l(e,Us,t),l(e,xt,t),l(e,xs,t),l(e,It,t),l(e,Is,t),l(e,$t,t),l(e,$s,t),l(e,At,t),l(e,As,t),l(e,Lt,t),l(e,Ls,t),l(e,Ht,t),l(e,Hs,t),m(Nt,e,t),l(e,Ns,t),l(e,F,t),l(e,Zs,t),m(Zt,e,t),l(e,Bs,t),l(e,X,t),l(e,Ws,t),m(Bt,e,t),l(e,Ps,t),l(e,q,t),l(e,Es,t),m(Wt,e,t),l(e,Rs,t),l(e,O,t),l(e,zs,t),l(e,Pt,t),l(e,Gs,t),m(Et,e,t),l(e,Qs,t),l(e,Rt,t),l(e,Vs,t),l(e,zt,t),l(e,Ds,t),l(e,Gt,t),l(e,Ss,t),l(e,Qt,t),l(e,Ys,t),l(e,Vt,t),l(e,Fs,t),l(e,Dt,t),l(e,Xs,t),l(e,St,t),l(e,qs,t),m(Yt,e,t),l(e,Os,t),l(e,Ft,t),l(e,Ks,t),l(e,Xt,t),l(e,ei,t),m(qt,e,t),l(e,ti,t),l(e,Ot,t),l(e,ni,t),m(Kt,e,t),l(e,li,t),l(e,en,t),l(e,oi,t),l(e,tn,t),l(e,si,t),l(e,nn,t),l(e,ii,t),l(e,ln,t),l(e,ai,t),l(e,on,t),l(e,ri,t),m(sn,e,t),l(e,di,t),l(e,an,t),l(e,hi,t),m(rn,e,t),l(e,pi,t),l(e,dn,t),l(e,mi,t),m(hn,e,t),l(e,ui,t),l(e,pn,t),l(e,ci,t),m(mn,e,t),l(e,fi,t),l(e,un,t),l(e,yi,t),m(cn,e,t),l(e,wi,t),l(e,fn,t),l(e,Mi,t),m(yn,e,t),l(e,Ti,t),l(e,wn,t),l(e,gi,t),m(Mn,e,t),l(e,bi,t),l(e,Tn,t),l(e,vi,t),m(gn,e,t),l(e,Ji,t),l(e,bn,t),l(e,ji,t),l(e,vn,t),l(e,Ci,t),l(e,Jn,t),l(e,ki,t),l(e,jn,t),l(e,_i,t),m(Cn,e,t),l(e,Ui,t),l(e,kn,t),l(e,xi,t),l(e,_n,t),l(e,Ii,t),m(Un,e,t),l(e,$i,t),l(e,xn,t),l(e,Ai,t),l(e,In,t),l(e,Li,t),l(e,$n,t),l(e,Hi,t),l(e,An,t),l(e,Ni,t),l(e,Ln,t),l(e,Zi,t),l(e,Hn,t),l(e,Bi,t),l(e,Nn,t),l(e,Wi,t),m(Zn,e,t),l(e,Pi,t),l(e,Bn,t),l(e,Ei,t),l(e,Wn,t),l(e,Ri,t),l(e,Pn,t),l(e,zi,t),m(En,e,t),l(e,Gi,t),m(K,e,t),l(e,Qi,t),l(e,Rn,t),l(e,Vi,t),l(e,zn,t),l(e,Di,t),l(e,Gn,t),l(e,Si,t),l(e,Qn,t),l(e,Yi,t),l(e,Vn,t),l(e,Fi,t),l(e,Dn,t),l(e,Xi,t),m(Sn,e,t),l(e,qi,t),l(e,Yn,t),l(e,Oi,t),m(Fn,e,t),l(e,Ki,t),l(e,Xn,t),l(e,ea,t),l(e,qn,t),l(e,ta,t),l(e,On,t),l(e,na,t),l(e,Kn,t),l(e,la,t),l(e,el,t),l(e,oa,t),l(e,tl,t),l(e,sa,t),l(e,nl,t),l(e,ia,t),l(e,ll,t),l(e,aa,t),l(e,ol,t),l(e,ra,t),m(sl,e,t),l(e,da,t),l(e,il,t),l(e,ha,t),m(al,e,t),l(e,pa,t),l(e,rl,t),l(e,ma,t),l(e,dl,t),l(e,ua,t),l(e,hl,t),l(e,ca,t),l(e,pl,t),l(e,fa,t),l(e,ml,t),l(e,ya,t),m(ul,e,t),l(e,wa,t),l(e,cl,t),l(e,Ma,t),l(e,fl,t),l(e,Ta,t),l(e,yl,t),l(e,ga,t),l(e,wl,t),l(e,ba,t),l(e,Ml,t),l(e,va,t),l(e,L,t),y(L,ee),y(ee,Dl),m(Tl,Dl,null),y(L,Sa),y(L,Nl),l(e,Ja,t),l(e,gl,t),l(e,ja,t),l(e,bl,t),l(e,Ca,t),l(e,Sl,t),ka=!0},p(e,[t]){const vl={};t&2&&(vl.$$scope={dirty:t,ctx:e}),Z.$set(vl);const Yl={};t&2&&(Yl.$$scope={dirty:t,ctx:e}),K.$set(Yl)},i(e){ka||(u(te.$$.fragment,e),u(Z.$$.fragment,e),u(re.$$.fragment,e),u(ce.$$.fragment,e),u(Me.$$.fragment,e),u(ge.$$.fragment,e),u(Je.$$.fragment,e),u(Ce.$$.fragment,e),u(He.$$.fragment,e),u(We.$$.fragment,e),u(Ee.$$.fragment,e),u(Re.$$.fragment,e),u(Ge.$$.fragment,e),u(Ve.$$.fragment,e),u(Se.$$.fragment,e),u(Fe.$$.fragment,e),u(at.$$.fragment,e),u(gt.$$.fragment,e),u(jt.$$.fragment,e),u(kt.$$.fragment,e),u(Nt.$$.fragment,e),u(Zt.$$.fragment,e),u(Bt.$$.fragment,e),u(Wt.$$.fragment,e),u(Et.$$.fragment,e),u(Yt.$$.fragment,e),u(qt.$$.fragment,e),u(Kt.$$.fragment,e),u(sn.$$.fragment,e),u(rn.$$.fragment,e),u(hn.$$.fragment,e),u(mn.$$.fragment,e),u(cn.$$.fragment,e),u(yn.$$.fragment,e),u(Mn.$$.fragment,e),u(gn.$$.fragment,e),u(Cn.$$.fragment,e),u(Un.$$.fragment,e),u(Zn.$$.fragment,e),u(En.$$.fragment,e),u(K.$$.fragment,e),u(Sn.$$.fragment,e),u(Fn.$$.fragment,e),u(sl.$$.fragment,e),u(al.$$.fragment,e),u(ul.$$.fragment,e),u(Tl.$$.fragment,e),ka=!0)},o(e){c(te.$$.fragment,e),c(Z.$$.fragment,e),c(re.$$.fragment,e),c(ce.$$.fragment,e),c(Me.$$.fragment,e),c(ge.$$.fragment,e),c(Je.$$.fragment,e),c(Ce.$$.fragment,e),c(He.$$.fragment,e),c(We.$$.fragment,e),c(Ee.$$.fragment,e),c(Re.$$.fragment,e),c(Ge.$$.fragment,e),c(Ve.$$.fragment,e),c(Se.$$.fragment,e),c(Fe.$$.fragment,e),c(at.$$.fragment,e),c(gt.$$.fragment,e),c(jt.$$.fragment,e),c(kt.$$.fragment,e),c(Nt.$$.fragment,e),c(Zt.$$.fragment,e),c(Bt.$$.fragment,e),c(Wt.$$.fragment,e),c(Et.$$.fragment,e),c(Yt.$$.fragment,e),c(qt.$$.fragment,e),c(Kt.$$.fragment,e),c(sn.$$.fragment,e),c(rn.$$.fragment,e),c(hn.$$.fragment,e),c(mn.$$.fragment,e),c(cn.$$.fragment,e),c(yn.$$.fragment,e),c(Mn.$$.fragment,e),c(gn.$$.fragment,e),c(Cn.$$.fragment,e),c(Un.$$.fragment,e),c(Zn.$$.fragment,e),c(En.$$.fragment,e),c(K.$$.fragment,e),c(Sn.$$.fragment,e),c(Fn.$$.fragment,e),c(sl.$$.fragment,e),c(al.$$.fragment,e),c(ul.$$.fragment,e),c(Tl.$$.fragment,e),ka=!1},d(e){e&&(n(v),n(g),n(H),n(J),n(Fl),n(ne),n(Xl),n(ql),n(le),n(Ol),n(oe),n(Kl),n(se),n(eo),n(ie),n(to),n(ae),n(no),n(j),n(lo),n(de),n(oo),n(he),n(so),n(pe),n(io),n(me),n(ao),n(ue),n(ro),n(C),n(ho),n(fe),n(po),n(ye),n(mo),n(_l),n(uo),n(we),n(co),n(fo),n(Te),n(yo),n(k),n(wo),n(be),n(Mo),n(ve),n(To),n(_),n(go),n(je),n(bo),n(U),n(vo),n(ke),n(Jo),n(_e),n(jo),n(Ue),n(Co),n(xe),n(ko),n(Ie),n(_o),n($e),n(Uo),n(Ae),n(xo),n(Le),n(Io),n(x),n($o),n(Ne),n(Ao),n(Ze),n(Lo),n(Be),n(Ho),n(I),n(No),n(Pe),n(Zo),n(Bo),n(Q),n(Wo),n(Po),n(ze),n(Eo),n(Ro),n(Qe),n(zo),n(Go),n(V),n(Qo),n(De),n(Vo),n(D),n(Do),n(So),n(Ye),n(Yo),n($),n(Fo),n(Xe),n(Xo),n(qe),n(qo),n(Oe),n(Oo),n(Ke),n(Ko),n(et),n(es),n(tt),n(ts),n(nt),n(ns),n(lt),n(ls),n(ot),n(os),n(st),n(ss),n(it),n(is),n(as),n(rt),n(rs),n(dt),n(ds),n(ht),n(hs),n(pt),n(ps),n(mt),n(ms),n(ut),n(us),n(ct),n(cs),n(ft),n(fs),n(yt),n(ys),n(wt),n(ws),n(Mt),n(Ms),n(Tt),n(Ts),n(gs),n(bt),n(bs),n(vt),n(vs),n(Jt),n(Js),n(A),n(js),n(Ct),n(Cs),n(ks),n(_t),n(_s),n(Ut),n(Us),n(xt),n(xs),n(It),n(Is),n($t),n($s),n(At),n(As),n(Lt),n(Ls),n(Ht),n(Hs),n(Ns),n(F),n(Zs),n(Bs),n(X),n(Ws),n(Ps),n(q),n(Es),n(Rs),n(O),n(zs),n(Pt),n(Gs),n(Qs),n(Rt),n(Vs),n(zt),n(Ds),n(Gt),n(Ss),n(Qt),n(Ys),n(Vt),n(Fs),n(Dt),n(Xs),n(St),n(qs),n(Os),n(Ft),n(Ks),n(Xt),n(ei),n(ti),n(Ot),n(ni),n(li),n(en),n(oi),n(tn),n(si),n(nn),n(ii),n(ln),n(ai),n(on),n(ri),n(di),n(an),n(hi),n(pi),n(dn),n(mi),n(ui),n(pn),n(ci),n(fi),n(un),n(yi),n(wi),n(fn),n(Mi),n(Ti),n(wn),n(gi),n(bi),n(Tn),n(vi),n(Ji),n(bn),n(ji),n(vn),n(Ci),n(Jn),n(ki),n(jn),n(_i),n(Ui),n(kn),n(xi),n(_n),n(Ii),n($i),n(xn),n(Ai),n(In),n(Li),n($n),n(Hi),n(An),n(Ni),n(Ln),n(Zi),n(Hn),n(Bi),n(Nn),n(Wi),n(Pi),n(Bn),n(Ei),n(Wn),n(Ri),n(Pn),n(zi),n(Gi),n(Qi),n(Rn),n(Vi),n(zn),n(Di),n(Gn),n(Si),n(Qn),n(Yi),n(Vn),n(Fi),n(Dn),n(Xi),n(qi),n(Yn),n(Oi),n(Ki),n(Xn),n(ea),n(qn),n(ta),n(On),n(na),n(Kn),n(la),n(el),n(oa),n(tl),n(sa),n(nl),n(ia),n(ll),n(aa),n(ol),n(ra),n(da),n(il),n(ha),n(pa),n(rl),n(ma),n(dl),n(ua),n(hl),n(ca),n(pl),n(fa),n(ml),n(ya),n(wa),n(cl),n(Ma),n(fl),n(Ta),n(yl),n(ga),n(wl),n(ba),n(Ml),n(va),n(L),n(Ja),n(gl),n(ja),n(bl),n(Ca),n(Sl)),n(T),f(te),f(Z,e),f(re),f(ce),f(Me,e),f(ge),f(Je),f(Ce),f(He),f(We),f(Ee,e),f(Re,e),f(Ge,e),f(Ve,e),f(Se,e),f(Fe),f(at,e),f(gt,e),f(jt),f(kt,e),f(Nt,e),f(Zt,e),f(Bt,e),f(Wt,e),f(Et,e),f(Yt,e),f(qt,e),f(Kt,e),f(sn,e),f(rn,e),f(hn,e),f(mn,e),f(cn,e),f(yn,e),f(Mn,e),f(gn,e),f(Cn,e),f(Un,e),f(Zn,e),f(En,e),f(K,e),f(Sn,e),f(Fn,e),f(sl,e),f(al,e),f(ul,e),f(Tl)}}}const gp={local:"how-to-add-a-model-to-transformers",sections:[{local:"general-overview-of-transformers",sections:[{local:"overview-of-models",title:"Overview of models"},{local:"code-style",title:"Code style"},{local:"overview-of-tokenizers",title:"Overview of tokenizers"}],title:"General overview of 🤗 Transformers"},{local:"stepbystep-recipe-to-add-a-model-to-transformers",sections:[{local:"1-optional-theoretical-aspects-of-brandnewbert",title:"1. (Optional) Theoretical aspects of BrandNewBert"},{local:"2-next-prepare-your-environment",title:"2. Next prepare your environment"},{local:"34-run-a-pretrained-checkpoint-using-the-original-repository",title:"3.-4. Run a pretrained checkpoint using the original repository"},{local:"514-port-brandnewbert-to-transformers",title:"5.-14. Port BrandNewBert to 🤗 Transformers"},{local:"share-your-work",title:"Share your work!!"}],title:"Step-by-step recipe to add a model to 🤗 Transformers"}],title:"How to add a model to 🤗 Transformers?"};function bp(Jl){return up(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _p extends cp{constructor(T){super(),fp(this,T,bp,Tp,pp,{})}}export{_p as component};
