import{s as Qi,n as Ki,o as tl}from"../chunks/scheduler.9bc65507.js";import{S as el,i as nl,g as r,s as d,u as h,m as ia,A as rl,h as a,f as e,c,j as s,v as m,y as g,n as la,k as l,o,a as i,w as p,d as f,t as v,x as u}from"../chunks/index.78c82d43.js";import{I as b}from"../chunks/IconCopyLink.bedaa44d.js";import{C as Ur}from"../chunks/CodeBlock.73e038be.js";function al(oa){let y,on,Ue,dn,w,L,ze,ht,zr,pe,da="Optimize inference using torch.compile()",cn,mt,ca='This guide aims to provide a benchmark on the inference speed-ups introduced with <a href="https://pytorch.org/tutorials/intermediate/torch_compile_tutorial.html" rel="nofollow"><code>torch.compile()</code></a> for <a href="https://huggingface.co/models?pipeline_tag=image-classification&amp;library=transformers&amp;sort=trending" rel="nofollow">computer vision models in 🤗 Transformers</a>.',sn,M,W,Be,pt,Br,fe,sa="Benefits of torch.compile",gn,ft,ga=`Compiling a model takes time, so it’s useful if you are compiling the model only once instead of every time you infer.
To compile any computer vision model of your choice, call <code>torch.compile()</code> on the model as shown below:`,hn,vt,mn,ut,ha='<code>compile()</code> comes with multiple modes for compiling, which essentially differ in compilation time and inference overhead. <code>max-autotune</code> takes longer than <code>reduce-overhead</code> but results in faster inference. Default mode is fastest for compilation but is not as efficient compared to <code>reduce-overhead</code> for inference time. In this guide, we used the default mode. You can learn more about it <a href="https://pytorch.org/get-started/pytorch-2.0/#user-experience" rel="nofollow">here</a>.',pn,bt,ma="We benchmarked <code>torch.compile</code> with different computer vision models, tasks, types of hardware, and batch sizes on <code>torch</code> version 2.0.1.",fn,T,P,Ze,yt,Zr,ve,pa="Benchmarking code",vn,wt,fa="Below you can find the benchmarking code for each task. We warm up the GPU before inference and take the mean time of 300 inferences, using the same image each time.",un,C,O,He,Mt,Hr,ue,va="Image Classification with ViT",bn,Tt,yn,k,V,De,Ct,Dr,be,ua="Object Detection with DETR",wn,kt,Mn,$,X,Le,$t,Lr,ye,ba="Image Segmentation with Segformer",Tn,_t,Cn,Et,ya="Below you can find the list of the models we benchmarked.",kn,jt,wa="<strong>Image Classification</strong>",$n,It,Ma='<li><a href="https://huggingface.co/google/vit-base-patch16-224" rel="nofollow">google/vit-base-patch16-224</a></li> <li><a href="https://huggingface.co/microsoft/beit-base-patch16-224-pt22k-ft22k" rel="nofollow">microsoft/beit-base-patch16-224-pt22k-ft22k</a></li> <li><a href="https://huggingface.co/facebook/convnext-large-224" rel="nofollow">facebook/convnext-large-224</a></li> <li><a href="https://huggingface.co/" rel="nofollow">microsoft/resnet-50</a></li>',_n,xt,Ta="<strong>Image Segmentation</strong>",En,St,Ca='<li><a href="https://huggingface.co/nvidia/segformer-b0-finetuned-ade-512-512" rel="nofollow">nvidia/segformer-b0-finetuned-ade-512-512</a></li> <li><a href="https://huggingface.co/facebook/mask2former-swin-tiny-coco-panoptic" rel="nofollow">facebook/mask2former-swin-tiny-coco-panoptic</a></li> <li><a href="https://huggingface.co/facebook/maskformer-swin-base-ade" rel="nofollow">facebook/maskformer-swin-base-ade</a></li> <li><a href="https://huggingface.co/google/deeplabv3_mobilenet_v2_1.0_513" rel="nofollow">google/deeplabv3_mobilenet_v2_1.0_513</a></li>',jn,Nt,ka="<strong>Object Detection</strong>",In,Rt,$a='<li><a href="https://huggingface.co/google/owlvit-base-patch32" rel="nofollow">google/owlvit-base-patch32</a></li> <li><a href="https://huggingface.co/facebook/detr-resnet-101" rel="nofollow">facebook/detr-resnet-101</a></li> <li><a href="https://huggingface.co/microsoft/conditional-detr-resnet-50" rel="nofollow">microsoft/conditional-detr-resnet-50</a></li>',xn,At,_a="Below you can find visualization of inference durations with and without <code>torch.compile()</code> and percentage improvements for each model in different hardware and batch sizes.",Sn,G,Ea='<div><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/a100_batch_comp.png"/></div> <div><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/v100_batch_comp.png"/></div> <div><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/t4_batch_comp.png"/></div>',Nn,q,ja='<div><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/A100_1_duration.png"/></div> <div><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/A100_1_percentage.png"/></div>',Rn,Jt,Ia='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/v100_1_duration.png" alt="Duration Comparison on V100 with Batch Size of 1"/>',An,Ut,xa='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/T4_4_percentage.png" alt="Percentage Improvement on T4 with Batch Size of 4"/>',Jn,zt,Sa="Below you can find inference durations in milliseconds for each model with and without <code>compile()</code>. Note that OwlViT results in OOM in larger batch sizes.",Un,_,F,We,Bt,Wr,we,Na="A100 (batch size: 1)",zn,Zt,Ra='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">9.325</td> <td align="center">7.584</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">11.759</td> <td align="center">10.500</td></tr> <tr><td align="center">Object Detection/OwlViT</td> <td align="center">24.978</td> <td align="center">18.420</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">11.282</td> <td align="center">8.448</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">34.619</td> <td align="center">19.040</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">10.410</td> <td align="center">10.208</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">6.531</td> <td align="center">4.124</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">60.188</td> <td align="center">49.117</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">75.764</td> <td align="center">59.487</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">8.583</td> <td align="center">3.974</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">36.276</td> <td align="center">18.197</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">31.219</td> <td align="center">17.993</td></tr></tbody>',Bn,E,Y,Pe,Ht,Pr,Me,Aa="A100 (batch size: 4)",Zn,Dt,Ja='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">14.832</td> <td align="center">14.499</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">18.838</td> <td align="center">16.476</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">13.205</td> <td align="center">13.048</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">48.657</td> <td align="center">32.418</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">22.940</td> <td align="center">21.631</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">6.657</td> <td align="center">4.268</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">74.277</td> <td align="center">61.781</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">180.700</td> <td align="center">159.116</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">14.174</td> <td align="center">8.515</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">68.101</td> <td align="center">44.998</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">56.470</td> <td align="center">35.552</td></tr></tbody>',Hn,j,Q,Oe,Lt,Or,Te,Ua="A100 (batch size: 16)",Dn,Wt,za='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">40.944</td> <td align="center">40.010</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">37.005</td> <td align="center">31.144</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">41.854</td> <td align="center">41.048</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">164.382</td> <td align="center">161.902</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">82.258</td> <td align="center">75.561</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">7.018</td> <td align="center">5.024</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">178.945</td> <td align="center">154.814</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">638.570</td> <td align="center">579.826</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">51.693</td> <td align="center">30.310</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">232.887</td> <td align="center">155.021</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">180.491</td> <td align="center">124.032</td></tr></tbody>',Ln,I,K,Ve,Pt,Vr,Ce,Ba="V100 (batch size: 1)",Wn,Ot,Za='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">10.495</td> <td align="center">6.00</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">13.321</td> <td align="center">5.862</td></tr> <tr><td align="center">Object Detection/OwlViT</td> <td align="center">25.769</td> <td align="center">22.395</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">11.347</td> <td align="center">7.234</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">33.951</td> <td align="center">19.388</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">11.623</td> <td align="center">10.412</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">6.484</td> <td align="center">3.820</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">64.640</td> <td align="center">49.873</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">95.532</td> <td align="center">72.207</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">9.217</td> <td align="center">4.753</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">52.818</td> <td align="center">28.367</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">39.512</td> <td align="center">20.816</td></tr></tbody>',Pn,x,tt,Xe,Vt,Xr,ke,Ha="V100 (batch size: 4)",On,Xt,Da='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">15.181</td> <td align="center">14.501</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">16.787</td> <td align="center">16.188</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">15.171</td> <td align="center">14.753</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">88.529</td> <td align="center">64.195</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">29.574</td> <td align="center">27.085</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">6.109</td> <td align="center">4.731</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">90.402</td> <td align="center">76.926</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">234.261</td> <td align="center">205.456</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">24.623</td> <td align="center">14.816</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">134.672</td> <td align="center">101.304</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">97.464</td> <td align="center">69.739</td></tr></tbody>',Vn,S,et,Ge,Gt,Gr,$e,La="V100 (batch size: 16)",Xn,qt,Wa='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">52.209</td> <td align="center">51.633</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">61.013</td> <td align="center">55.499</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">53.938</td> <td align="center">53.581</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">OOM</td> <td align="center">OOM</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">109.682</td> <td align="center">100.771</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">14.857</td> <td align="center">12.089</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">249.605</td> <td align="center">222.801</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">831.142</td> <td align="center">743.645</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">93.129</td> <td align="center">55.365</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">482.425</td> <td align="center">361.843</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">344.661</td> <td align="center">255.298</td></tr></tbody>',Gn,N,nt,qe,Ft,qr,_e,Pa="T4 (batch size: 1)",qn,Yt,Oa='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">16.520</td> <td align="center">15.786</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">16.116</td> <td align="center">14.205</td></tr> <tr><td align="center">Object Detection/OwlViT</td> <td align="center">53.634</td> <td align="center">51.105</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">16.464</td> <td align="center">15.710</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">73.100</td> <td align="center">53.99</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">32.932</td> <td align="center">30.845</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">6.031</td> <td align="center">4.321</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">79.192</td> <td align="center">66.815</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">200.026</td> <td align="center">188.268</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">18.908</td> <td align="center">11.997</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">106.622</td> <td align="center">82.566</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">77.594</td> <td align="center">56.984</td></tr></tbody>',Fn,R,rt,Fe,Qt,Fr,Ee,Va="T4 (batch size: 4)",Yn,Kt,Xa='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">43.653</td> <td align="center">43.626</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">45.327</td> <td align="center">42.445</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">52.007</td> <td align="center">51.354</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">277.850</td> <td align="center">268.003</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">119.259</td> <td align="center">105.580</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">13.039</td> <td align="center">11.388</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">201.540</td> <td align="center">184.670</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">764.052</td> <td align="center">711.280</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">74.289</td> <td align="center">48.677</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">421.859</td> <td align="center">357.614</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">289.002</td> <td align="center">226.945</td></tr></tbody>',Qn,A,at,Ye,te,Yr,je,Ga="T4 (batch size: 16)",Kn,ee,qa='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">163.914</td> <td align="center">160.907</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">192.412</td> <td align="center">163.620</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">188.978</td> <td align="center">187.976</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">OOM</td> <td align="center">OOM</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">422.886</td> <td align="center">388.078</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">44.114</td> <td align="center">37.604</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">756.337</td> <td align="center">695.291</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">2842.940</td> <td align="center">2656.88</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">299.003</td> <td align="center">201.942</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">1619.505</td> <td align="center">1262.758</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">1137.513</td> <td align="center">897.390</td></tr></tbody>',tr,J,it,Qe,ne,Qr,Ie,Fa="PyTorch Nightly",er,U,lt,Ke,re,Kr,xe,Ya="A100",nr,ae,Qa='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>Batch Size</strong></th> <th align="center"><strong>torch 2.0 - no compile</strong></th> <th align="center"><strong>torch 2.0 -<br/> compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/BeiT</td> <td align="center">Unbatched</td> <td align="center">12.462</td> <td align="center">6.954</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">4</td> <td align="center">14.109</td> <td align="center">12.851</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">16</td> <td align="center">42.179</td> <td align="center">42.147</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">Unbatched</td> <td align="center">30.484</td> <td align="center">15.221</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">4</td> <td align="center">46.816</td> <td align="center">30.942</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">16</td> <td align="center">163.749</td> <td align="center">163.706</td></tr></tbody>',rr,z,ot,tn,ie,ta,Se,Ka="T4",ar,le,ti='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>Batch Size</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/BeiT</td> <td align="center">Unbatched</td> <td align="center">14.408</td> <td align="center">14.052</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">4</td> <td align="center">47.381</td> <td align="center">46.604</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">16</td> <td align="center">42.179</td> <td align="center">42.147</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">Unbatched</td> <td align="center">68.382</td> <td align="center">53.481</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">4</td> <td align="center">269.615</td> <td align="center">204.785</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">16</td> <td align="center">OOM</td> <td align="center">OOM</td></tr></tbody>',ir,B,dt,en,oe,ea,Ne,ei="V100",lr,de,ni='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>Batch Size</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/BeiT</td> <td align="center">Unbatched</td> <td align="center">13.477</td> <td align="center">7.926</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">4</td> <td align="center">15.103</td> <td align="center">14.378</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">16</td> <td align="center">52.517</td> <td align="center">51.691</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">Unbatched</td> <td align="center">28.706</td> <td align="center">19.077</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">4</td> <td align="center">88.402</td> <td align="center">62.949</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">16</td> <td align="center">OOM</td> <td align="center">OOM</td></tr></tbody>',or,Z,ct,nn,ce,na,Re,ri="Reduce Overhead",dr,H,st,rn,se,ra,Ae,ai="A100",cr,ge,ii='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>Batch Size</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">Unbatched</td> <td align="center">11.758</td> <td align="center">7.335</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">4</td> <td align="center">23.171</td> <td align="center">21.490</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">Unbatched</td> <td align="center">7.435</td> <td align="center">3.801</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">4</td> <td align="center">7.261</td> <td align="center">2.187</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">Unbatched</td> <td align="center">32.823</td> <td align="center">11.627</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">4</td> <td align="center">50.622</td> <td align="center">33.831</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">Unbatched</td> <td align="center">9.869</td> <td align="center">4.244</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">4</td> <td align="center">14.385</td> <td align="center">7.946</td></tr></tbody>',sr,D,gt,an,he,aa,Je,li="T4",gr,me,oi='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>Batch Size</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">Unbatched</td> <td align="center">32.137</td> <td align="center">31.84</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">4</td> <td align="center">120.944</td> <td align="center">110.209</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">Unbatched</td> <td align="center">9.761</td> <td align="center">7.698</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">4</td> <td align="center">15.215</td> <td align="center">13.871</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">Unbatched</td> <td align="center">72.150</td> <td align="center">57.660</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">4</td> <td align="center">301.494</td> <td align="center">247.543</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">Unbatched</td> <td align="center">22.266</td> <td align="center">19.339</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">4</td> <td align="center">78.311</td> <td align="center">50.983</td></tr></tbody>',hr,ln,mr;return ht=new b({}),pt=new b({}),vt=new Ur({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKE1PREVMX0lEKS50byglMjJjdWRhJTIyKSUwQSUyQiUyMG1vZGVsJTIwJTNEJTIwdG9yY2guY29tcGlsZShtb2RlbCk=",highlighted:`from transformers import AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(MODEL_ID).to(&quot;cuda&quot;)
<span class="hljs-addition">+ model = torch.compile(model)</span>`,wrap:!1}}),yt=new b({}),Mt=new b({}),Tt=new Ur({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvSW1hZ2VQcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBdXJsJTIwJTNEJTIwJ2h0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGcnJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKS50byglMjJjdWRhJTIyKSUwQW1vZGVsJTIwJTNEJTIwdG9yY2guY29tcGlsZShtb2RlbCklMEElMEFwcm9jZXNzZWRfaW5wdXQlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCdwdCcpLnRvKGRldmljZSUzRCUyMmN1ZGElMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMF8lMjAlM0QlMjBtb2RlbCgqKnByb2Nlc3NlZF9pbnB1dCklMEE=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForImageClassification

url = <span class="hljs-string">&#x27;http://images.cocodataset.org/val2017/000000039769.jpg&#x27;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)
model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
model = torch.<span class="hljs-built_in">compile</span>(model)

processed_input = processor(image, return_tensors=<span class="hljs-string">&#x27;pt&#x27;</span>).to(device=<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">with</span> torch.no_grad():
    _ = model(**processed_input)
`,wrap:!1}}),Ct=new b({}),kt=new Ur({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZkZXRyLXJlc25ldC01MCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZkZXRyLXJlc25ldC01MCUyMikudG8oJTIyY3VkYSUyMiklMEFtb2RlbCUyMCUzRCUyMHRvcmNoLmNvbXBpbGUobW9kZWwpJTBBJTBBdGV4dHMlMjAlM0QlMjAlNUIlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBjYXQlMjIlMkMlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBkb2clMjIlNUQlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRHRleHRzJTJDJTIwaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBfJTIwJTNEJTIwbW9kZWwoKippbnB1dHMp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForObjectDetection

processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/detr-resnet-50&quot;</span>)
model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;facebook/detr-resnet-50&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
model = torch.<span class="hljs-built_in">compile</span>(model)

texts = [<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>]
inputs = processor(text=texts, images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">with</span> torch.no_grad():
    _ = model(**inputs)`,wrap:!1}}),$t=new b({}),_t=new Ur({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlZ2Zvcm1lckltYWdlUHJvY2Vzc29yJTJDJTIwU2VnZm9ybWVyRm9yU2VtYW50aWNTZWdtZW50YXRpb24lMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBTZWdmb3JtZXJJbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybnZpZGlhJTJGc2VnZm9ybWVyLWIwLWZpbmV0dW5lZC1hZGUtNTEyLTUxMiUyMiklMEFtb2RlbCUyMCUzRCUyMFNlZ2Zvcm1lckZvclNlbWFudGljU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJudmlkaWElMkZzZWdmb3JtZXItYjAtZmluZXR1bmVkLWFkZS01MTItNTEyJTIyKS50byglMjJjdWRhJTIyKSUwQW1vZGVsJTIwJTNEJTIwdG9yY2guY29tcGlsZShtb2RlbCklMEFzZWdfaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwXyUyMCUzRCUyMG1vZGVsKCoqc2VnX2lucHV0cyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SegformerImageProcessor, SegformerForSemanticSegmentation

processor = SegformerImageProcessor.from_pretrained(<span class="hljs-string">&quot;nvidia/segformer-b0-finetuned-ade-512-512&quot;</span>)
model = SegformerForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;nvidia/segformer-b0-finetuned-ade-512-512&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
model = torch.<span class="hljs-built_in">compile</span>(model)
seg_inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">with</span> torch.no_grad():
    _ = model(**seg_inputs)`,wrap:!1}}),Bt=new b({}),Ht=new b({}),Lt=new b({}),Pt=new b({}),Vt=new b({}),Gt=new b({}),Ft=new b({}),Qt=new b({}),te=new b({}),ne=new b({}),re=new b({}),ie=new b({}),oe=new b({}),ce=new b({}),se=new b({}),he=new b({}),{c(){y=r("meta"),on=d(),Ue=r("p"),dn=d(),w=r("h1"),L=r("a"),ze=r("span"),h(ht.$$.fragment),zr=d(),pe=r("span"),pe.textContent=da,cn=d(),mt=r("p"),mt.innerHTML=ca,sn=d(),M=r("h2"),W=r("a"),Be=r("span"),h(pt.$$.fragment),Br=d(),fe=r("span"),fe.textContent=sa,gn=ia("\n\n\n   \nDepending on the model and the GPU, `torch.compile()` yields up to 30% speed-up during inference. To use `torch.compile()`, simply install any version of `torch` above 2.0.\n"),ft=r("p"),ft.innerHTML=ga,hn=d(),h(vt.$$.fragment),mn=d(),ut=r("p"),ut.innerHTML=ha,pn=d(),bt=r("p"),bt.innerHTML=ma,fn=d(),T=r("h2"),P=r("a"),Ze=r("span"),h(yt.$$.fragment),Zr=d(),ve=r("span"),ve.textContent=pa,vn=d(),wt=r("p"),wt.textContent=fa,un=d(),C=r("h3"),O=r("a"),He=r("span"),h(Mt.$$.fragment),Hr=d(),ue=r("span"),ue.textContent=va,bn=d(),h(Tt.$$.fragment),yn=d(),k=r("h4"),V=r("a"),De=r("span"),h(Ct.$$.fragment),Dr=d(),be=r("span"),be.textContent=ua,wn=d(),h(kt.$$.fragment),Mn=d(),$=r("h4"),X=r("a"),Le=r("span"),h($t.$$.fragment),Lr=d(),ye=r("span"),ye.textContent=ba,Tn=d(),h(_t.$$.fragment),Cn=d(),Et=r("p"),Et.textContent=ya,kn=d(),jt=r("p"),jt.innerHTML=wa,$n=d(),It=r("ul"),It.innerHTML=Ma,_n=d(),xt=r("p"),xt.innerHTML=Ta,En=d(),St=r("ul"),St.innerHTML=Ca,jn=d(),Nt=r("p"),Nt.innerHTML=ka,In=d(),Rt=r("ul"),Rt.innerHTML=$a,xn=d(),At=r("p"),At.innerHTML=_a,Sn=d(),G=r("div"),G.innerHTML=Ea,Nn=d(),q=r("div"),q.innerHTML=ja,Rn=d(),Jt=r("p"),Jt.innerHTML=Ia,An=d(),Ut=r("p"),Ut.innerHTML=xa,Jn=d(),zt=r("p"),zt.innerHTML=Sa,Un=d(),_=r("h3"),F=r("a"),We=r("span"),h(Bt.$$.fragment),Wr=d(),we=r("span"),we.textContent=Na,zn=d(),Zt=r("table"),Zt.innerHTML=Ra,Bn=d(),E=r("h3"),Y=r("a"),Pe=r("span"),h(Ht.$$.fragment),Pr=d(),Me=r("span"),Me.textContent=Aa,Zn=d(),Dt=r("table"),Dt.innerHTML=Ja,Hn=d(),j=r("h3"),Q=r("a"),Oe=r("span"),h(Lt.$$.fragment),Or=d(),Te=r("span"),Te.textContent=Ua,Dn=d(),Wt=r("table"),Wt.innerHTML=za,Ln=d(),I=r("h3"),K=r("a"),Ve=r("span"),h(Pt.$$.fragment),Vr=d(),Ce=r("span"),Ce.textContent=Ba,Wn=d(),Ot=r("table"),Ot.innerHTML=Za,Pn=d(),x=r("h3"),tt=r("a"),Xe=r("span"),h(Vt.$$.fragment),Xr=d(),ke=r("span"),ke.textContent=Ha,On=d(),Xt=r("table"),Xt.innerHTML=Da,Vn=d(),S=r("h3"),et=r("a"),Ge=r("span"),h(Gt.$$.fragment),Gr=d(),$e=r("span"),$e.textContent=La,Xn=d(),qt=r("table"),qt.innerHTML=Wa,Gn=d(),N=r("h3"),nt=r("a"),qe=r("span"),h(Ft.$$.fragment),qr=d(),_e=r("span"),_e.textContent=Pa,qn=d(),Yt=r("table"),Yt.innerHTML=Oa,Fn=d(),R=r("h3"),rt=r("a"),Fe=r("span"),h(Qt.$$.fragment),Fr=d(),Ee=r("span"),Ee.textContent=Va,Yn=d(),Kt=r("table"),Kt.innerHTML=Xa,Qn=d(),A=r("h3"),at=r("a"),Ye=r("span"),h(te.$$.fragment),Yr=d(),je=r("span"),je.textContent=Ga,Kn=d(),ee=r("table"),ee.innerHTML=qa,tr=d(),J=r("h2"),it=r("a"),Qe=r("span"),h(ne.$$.fragment),Qr=d(),Ie=r("span"),Ie.textContent=Fa,er=ia(`


We also benchmarked on PyTorch nightly (2.1.0dev, find the wheel [here](https://download.pytorch.org/whl/nightly/cu118)) and observed improvement in latency both for uncompiled and compiled models.
`),U=r("h3"),lt=r("a"),Ke=r("span"),h(re.$$.fragment),Kr=d(),xe=r("span"),xe.textContent=Ya,nr=d(),ae=r("table"),ae.innerHTML=Qa,rr=d(),z=r("h3"),ot=r("a"),tn=r("span"),h(ie.$$.fragment),ta=d(),Se=r("span"),Se.textContent=Ka,ar=d(),le=r("table"),le.innerHTML=ti,ir=d(),B=r("h3"),dt=r("a"),en=r("span"),h(oe.$$.fragment),ea=d(),Ne=r("span"),Ne.textContent=ei,lr=d(),de=r("table"),de.innerHTML=ni,or=d(),Z=r("h2"),ct=r("a"),nn=r("span"),h(ce.$$.fragment),na=d(),Re=r("span"),Re.textContent=ri,dr=ia(`


We benchmarked \`reduce-overhead\` compilation mode for A100 and T4 in Nightly.
`),H=r("h3"),st=r("a"),rn=r("span"),h(se.$$.fragment),ra=d(),Ae=r("span"),Ae.textContent=ai,cr=d(),ge=r("table"),ge.innerHTML=ii,sr=d(),D=r("h3"),gt=r("a"),an=r("span"),h(he.$$.fragment),aa=d(),Je=r("span"),Je.textContent=li,gr=d(),me=r("table"),me.innerHTML=oi,hr=d(),ln=r("p"),this.h()},l(t){const n=rl("svelte-1phssyn",document.head);y=a(n,"META",{name:!0,content:!0}),n.forEach(e),on=c(t),Ue=a(t,"P",{}),s(Ue).forEach(e),dn=c(t),w=a(t,"H1",{class:!0});var pr=s(w);L=a(pr,"A",{id:!0,class:!0,href:!0});var di=s(L);ze=a(di,"SPAN",{});var ci=s(ze);m(ht.$$.fragment,ci),ci.forEach(e),di.forEach(e),zr=c(pr),pe=a(pr,"SPAN",{"data-svelte-h":!0}),g(pe)!=="svelte-mpj2ov"&&(pe.textContent=da),pr.forEach(e),cn=c(t),mt=a(t,"P",{"data-svelte-h":!0}),g(mt)!=="svelte-a1xmpp"&&(mt.innerHTML=ca),sn=c(t),M=a(t,"H2",{class:!0});var fr=s(M);W=a(fr,"A",{id:!0,class:!0,href:!0});var si=s(W);Be=a(si,"SPAN",{});var gi=s(Be);m(pt.$$.fragment,gi),gi.forEach(e),si.forEach(e),Br=c(fr),fe=a(fr,"SPAN",{"data-svelte-h":!0}),g(fe)!=="svelte-yjplhr"&&(fe.textContent=sa),fr.forEach(e),gn=la(t,"\n\n\n   \nDepending on the model and the GPU, `torch.compile()` yields up to 30% speed-up during inference. To use `torch.compile()`, simply install any version of `torch` above 2.0.\n"),ft=a(t,"P",{"data-svelte-h":!0}),g(ft)!=="svelte-1b66kne"&&(ft.innerHTML=ga),hn=c(t),m(vt.$$.fragment,t),mn=c(t),ut=a(t,"P",{"data-svelte-h":!0}),g(ut)!=="svelte-13c27qn"&&(ut.innerHTML=ha),pn=c(t),bt=a(t,"P",{"data-svelte-h":!0}),g(bt)!=="svelte-116qe4s"&&(bt.innerHTML=ma),fn=c(t),T=a(t,"H2",{class:!0});var vr=s(T);P=a(vr,"A",{id:!0,class:!0,href:!0});var hi=s(P);Ze=a(hi,"SPAN",{});var mi=s(Ze);m(yt.$$.fragment,mi),mi.forEach(e),hi.forEach(e),Zr=c(vr),ve=a(vr,"SPAN",{"data-svelte-h":!0}),g(ve)!=="svelte-1o38izn"&&(ve.textContent=pa),vr.forEach(e),vn=c(t),wt=a(t,"P",{"data-svelte-h":!0}),g(wt)!=="svelte-2dld2n"&&(wt.textContent=fa),un=c(t),C=a(t,"H3",{class:!0});var ur=s(C);O=a(ur,"A",{id:!0,class:!0,href:!0});var pi=s(O);He=a(pi,"SPAN",{});var fi=s(He);m(Mt.$$.fragment,fi),fi.forEach(e),pi.forEach(e),Hr=c(ur),ue=a(ur,"SPAN",{"data-svelte-h":!0}),g(ue)!=="svelte-72z2l5"&&(ue.textContent=va),ur.forEach(e),bn=c(t),m(Tt.$$.fragment,t),yn=c(t),k=a(t,"H4",{class:!0});var br=s(k);V=a(br,"A",{id:!0,class:!0,href:!0});var vi=s(V);De=a(vi,"SPAN",{});var ui=s(De);m(Ct.$$.fragment,ui),ui.forEach(e),vi.forEach(e),Dr=c(br),be=a(br,"SPAN",{"data-svelte-h":!0}),g(be)!=="svelte-hjw90q"&&(be.textContent=ua),br.forEach(e),wn=c(t),m(kt.$$.fragment,t),Mn=c(t),$=a(t,"H4",{class:!0});var yr=s($);X=a(yr,"A",{id:!0,class:!0,href:!0});var bi=s(X);Le=a(bi,"SPAN",{});var yi=s(Le);m($t.$$.fragment,yi),yi.forEach(e),bi.forEach(e),Lr=c(yr),ye=a(yr,"SPAN",{"data-svelte-h":!0}),g(ye)!=="svelte-1h4umik"&&(ye.textContent=ba),yr.forEach(e),Tn=c(t),m(_t.$$.fragment,t),Cn=c(t),Et=a(t,"P",{"data-svelte-h":!0}),g(Et)!=="svelte-fbvml8"&&(Et.textContent=ya),kn=c(t),jt=a(t,"P",{"data-svelte-h":!0}),g(jt)!=="svelte-1pzh5ag"&&(jt.innerHTML=wa),$n=c(t),It=a(t,"UL",{"data-svelte-h":!0}),g(It)!=="svelte-i1xpay"&&(It.innerHTML=Ma),_n=c(t),xt=a(t,"P",{"data-svelte-h":!0}),g(xt)!=="svelte-vq25eq"&&(xt.innerHTML=Ta),En=c(t),St=a(t,"UL",{"data-svelte-h":!0}),g(St)!=="svelte-1vcuz7e"&&(St.innerHTML=Ca),jn=c(t),Nt=a(t,"P",{"data-svelte-h":!0}),g(Nt)!=="svelte-1e8jpwt"&&(Nt.innerHTML=ka),In=c(t),Rt=a(t,"UL",{"data-svelte-h":!0}),g(Rt)!=="svelte-yhf9tm"&&(Rt.innerHTML=$a),xn=c(t),At=a(t,"P",{"data-svelte-h":!0}),g(At)!=="svelte-7yg5eu"&&(At.innerHTML=_a),Sn=c(t),G=a(t,"DIV",{class:!0,"data-svelte-h":!0}),g(G)!=="svelte-1jw9wmi"&&(G.innerHTML=Ea),Nn=c(t),q=a(t,"DIV",{class:!0,"data-svelte-h":!0}),g(q)!=="svelte-nlzsqo"&&(q.innerHTML=ja),Rn=c(t),Jt=a(t,"P",{"data-svelte-h":!0}),g(Jt)!=="svelte-gdeipd"&&(Jt.innerHTML=Ia),An=c(t),Ut=a(t,"P",{"data-svelte-h":!0}),g(Ut)!=="svelte-1cusdpa"&&(Ut.innerHTML=xa),Jn=c(t),zt=a(t,"P",{"data-svelte-h":!0}),g(zt)!=="svelte-16crmf3"&&(zt.innerHTML=Sa),Un=c(t),_=a(t,"H3",{class:!0});var wr=s(_);F=a(wr,"A",{id:!0,class:!0,href:!0});var wi=s(F);We=a(wi,"SPAN",{});var Mi=s(We);m(Bt.$$.fragment,Mi),Mi.forEach(e),wi.forEach(e),Wr=c(wr),we=a(wr,"SPAN",{"data-svelte-h":!0}),g(we)!=="svelte-xluwjc"&&(we.textContent=Na),wr.forEach(e),zn=c(t),Zt=a(t,"TABLE",{"data-svelte-h":!0}),g(Zt)!=="svelte-6uvhqg"&&(Zt.innerHTML=Ra),Bn=c(t),E=a(t,"H3",{class:!0});var Mr=s(E);Y=a(Mr,"A",{id:!0,class:!0,href:!0});var Ti=s(Y);Pe=a(Ti,"SPAN",{});var Ci=s(Pe);m(Ht.$$.fragment,Ci),Ci.forEach(e),Ti.forEach(e),Pr=c(Mr),Me=a(Mr,"SPAN",{"data-svelte-h":!0}),g(Me)!=="svelte-vpkidz"&&(Me.textContent=Aa),Mr.forEach(e),Zn=c(t),Dt=a(t,"TABLE",{"data-svelte-h":!0}),g(Dt)!=="svelte-f4zjoc"&&(Dt.innerHTML=Ja),Hn=c(t),j=a(t,"H3",{class:!0});var Tr=s(j);Q=a(Tr,"A",{id:!0,class:!0,href:!0});var ki=s(Q);Oe=a(ki,"SPAN",{});var $i=s(Oe);m(Lt.$$.fragment,$i),$i.forEach(e),ki.forEach(e),Or=c(Tr),Te=a(Tr,"SPAN",{"data-svelte-h":!0}),g(Te)!=="svelte-1q5bayy"&&(Te.textContent=Ua),Tr.forEach(e),Dn=c(t),Wt=a(t,"TABLE",{"data-svelte-h":!0}),g(Wt)!=="svelte-9ju0ii"&&(Wt.innerHTML=za),Ln=c(t),I=a(t,"H3",{class:!0});var Cr=s(I);K=a(Cr,"A",{id:!0,class:!0,href:!0});var _i=s(K);Ve=a(_i,"SPAN",{});var Ei=s(Ve);m(Pt.$$.fragment,Ei),Ei.forEach(e),_i.forEach(e),Vr=c(Cr),Ce=a(Cr,"SPAN",{"data-svelte-h":!0}),g(Ce)!=="svelte-u2vuyx"&&(Ce.textContent=Ba),Cr.forEach(e),Wn=c(t),Ot=a(t,"TABLE",{"data-svelte-h":!0}),g(Ot)!=="svelte-18ncoxq"&&(Ot.innerHTML=Za),Pn=c(t),x=a(t,"H3",{class:!0});var kr=s(x);tt=a(kr,"A",{id:!0,class:!0,href:!0});var ji=s(tt);Xe=a(ji,"SPAN",{});var Ii=s(Xe);m(Vt.$$.fragment,Ii),Ii.forEach(e),ji.forEach(e),Xr=c(kr),ke=a(kr,"SPAN",{"data-svelte-h":!0}),g(ke)!=="svelte-1ns34tm"&&(ke.textContent=Ha),kr.forEach(e),On=c(t),Xt=a(t,"TABLE",{"data-svelte-h":!0}),g(Xt)!=="svelte-15udyd3"&&(Xt.innerHTML=Da),Vn=c(t),S=a(t,"H3",{class:!0});var $r=s(S);et=a($r,"A",{id:!0,class:!0,href:!0});var xi=s(et);Ge=a(xi,"SPAN",{});var Si=s(Ge);m(Gt.$$.fragment,Si),Si.forEach(e),xi.forEach(e),Gr=c($r),$e=a($r,"SPAN",{"data-svelte-h":!0}),g($e)!=="svelte-xy91vb"&&($e.textContent=La),$r.forEach(e),Xn=c(t),qt=a(t,"TABLE",{"data-svelte-h":!0}),g(qt)!=="svelte-rw07j7"&&(qt.innerHTML=Wa),Gn=c(t),N=a(t,"H3",{class:!0});var _r=s(N);nt=a(_r,"A",{id:!0,class:!0,href:!0});var Ni=s(nt);qe=a(Ni,"SPAN",{});var Ri=s(qe);m(Ft.$$.fragment,Ri),Ri.forEach(e),Ni.forEach(e),qr=c(_r),_e=a(_r,"SPAN",{"data-svelte-h":!0}),g(_e)!=="svelte-1782kgu"&&(_e.textContent=Pa),_r.forEach(e),qn=c(t),Yt=a(t,"TABLE",{"data-svelte-h":!0}),g(Yt)!=="svelte-37x5jw"&&(Yt.innerHTML=Oa),Fn=c(t),R=a(t,"H3",{class:!0});var Er=s(R);rt=a(Er,"A",{id:!0,class:!0,href:!0});var Ai=s(rt);Fe=a(Ai,"SPAN",{});var Ji=s(Fe);m(Qt.$$.fragment,Ji),Ji.forEach(e),Ai.forEach(e),Fr=c(Er),Ee=a(Er,"SPAN",{"data-svelte-h":!0}),g(Ee)!=="svelte-fpbdvl"&&(Ee.textContent=Va),Er.forEach(e),Yn=c(t),Kt=a(t,"TABLE",{"data-svelte-h":!0}),g(Kt)!=="svelte-1mc5027"&&(Kt.innerHTML=Xa),Qn=c(t),A=a(t,"H3",{class:!0});var jr=s(A);at=a(jr,"A",{id:!0,class:!0,href:!0});var Ui=s(at);Ye=a(Ui,"SPAN",{});var zi=s(Ye);m(te.$$.fragment,zi),zi.forEach(e),Ui.forEach(e),Yr=c(jr),je=a(jr,"SPAN",{"data-svelte-h":!0}),g(je)!=="svelte-1gago4w"&&(je.textContent=Ga),jr.forEach(e),Kn=c(t),ee=a(t,"TABLE",{"data-svelte-h":!0}),g(ee)!=="svelte-10eiin7"&&(ee.innerHTML=qa),tr=c(t),J=a(t,"H2",{class:!0});var Ir=s(J);it=a(Ir,"A",{id:!0,class:!0,href:!0});var Bi=s(it);Qe=a(Bi,"SPAN",{});var Zi=s(Qe);m(ne.$$.fragment,Zi),Zi.forEach(e),Bi.forEach(e),Qr=c(Ir),Ie=a(Ir,"SPAN",{"data-svelte-h":!0}),g(Ie)!=="svelte-f31dyp"&&(Ie.textContent=Fa),Ir.forEach(e),er=la(t,`


We also benchmarked on PyTorch nightly (2.1.0dev, find the wheel [here](https://download.pytorch.org/whl/nightly/cu118)) and observed improvement in latency both for uncompiled and compiled models.
`),U=a(t,"H3",{class:!0});var xr=s(U);lt=a(xr,"A",{id:!0,class:!0,href:!0});var Hi=s(lt);Ke=a(Hi,"SPAN",{});var Di=s(Ke);m(re.$$.fragment,Di),Di.forEach(e),Hi.forEach(e),Kr=c(xr),xe=a(xr,"SPAN",{"data-svelte-h":!0}),g(xe)!=="svelte-1ro5nrz"&&(xe.textContent=Ya),xr.forEach(e),nr=c(t),ae=a(t,"TABLE",{"data-svelte-h":!0}),g(ae)!=="svelte-1cg5nyy"&&(ae.innerHTML=Qa),rr=c(t),z=a(t,"H3",{class:!0});var Sr=s(z);ot=a(Sr,"A",{id:!0,class:!0,href:!0});var Li=s(ot);tn=a(Li,"SPAN",{});var Wi=s(tn);m(ie.$$.fragment,Wi),Wi.forEach(e),Li.forEach(e),ta=c(Sr),Se=a(Sr,"SPAN",{"data-svelte-h":!0}),g(Se)!=="svelte-6jcko9"&&(Se.textContent=Ka),Sr.forEach(e),ar=c(t),le=a(t,"TABLE",{"data-svelte-h":!0}),g(le)!=="svelte-1nlzppe"&&(le.innerHTML=ti),ir=c(t),B=a(t,"H3",{class:!0});var Nr=s(B);dt=a(Nr,"A",{id:!0,class:!0,href:!0});var Pi=s(dt);en=a(Pi,"SPAN",{});var Oi=s(en);m(oe.$$.fragment,Oi),Oi.forEach(e),Pi.forEach(e),ea=c(Nr),Ne=a(Nr,"SPAN",{"data-svelte-h":!0}),g(Ne)!=="svelte-kpkwqa"&&(Ne.textContent=ei),Nr.forEach(e),lr=c(t),de=a(t,"TABLE",{"data-svelte-h":!0}),g(de)!=="svelte-ok1p6e"&&(de.innerHTML=ni),or=c(t),Z=a(t,"H2",{class:!0});var Rr=s(Z);ct=a(Rr,"A",{id:!0,class:!0,href:!0});var Vi=s(ct);nn=a(Vi,"SPAN",{});var Xi=s(nn);m(ce.$$.fragment,Xi),Xi.forEach(e),Vi.forEach(e),na=c(Rr),Re=a(Rr,"SPAN",{"data-svelte-h":!0}),g(Re)!=="svelte-w9cqdp"&&(Re.textContent=ri),Rr.forEach(e),dr=la(t,`


We benchmarked \`reduce-overhead\` compilation mode for A100 and T4 in Nightly.
`),H=a(t,"H3",{class:!0});var Ar=s(H);st=a(Ar,"A",{id:!0,class:!0,href:!0});var Gi=s(st);rn=a(Gi,"SPAN",{});var qi=s(rn);m(se.$$.fragment,qi),qi.forEach(e),Gi.forEach(e),ra=c(Ar),Ae=a(Ar,"SPAN",{"data-svelte-h":!0}),g(Ae)!=="svelte-1ro5nrz"&&(Ae.textContent=ai),Ar.forEach(e),cr=c(t),ge=a(t,"TABLE",{"data-svelte-h":!0}),g(ge)!=="svelte-13rnx0"&&(ge.innerHTML=ii),sr=c(t),D=a(t,"H3",{class:!0});var Jr=s(D);gt=a(Jr,"A",{id:!0,class:!0,href:!0});var Fi=s(gt);an=a(Fi,"SPAN",{});var Yi=s(an);m(he.$$.fragment,Yi),Yi.forEach(e),Fi.forEach(e),aa=c(Jr),Je=a(Jr,"SPAN",{"data-svelte-h":!0}),g(Je)!=="svelte-6jcko9"&&(Je.textContent=li),Jr.forEach(e),gr=c(t),me=a(t,"TABLE",{"data-svelte-h":!0}),g(me)!=="svelte-oh2zql"&&(me.innerHTML=oi),hr=c(t),ln=a(t,"P",{}),s(ln).forEach(e),this.h()},h(){l(y,"name","hf:doc:metadata"),l(y,"content",JSON.stringify(il)),l(L,"id","optimize-inference-using-torchcompile"),l(L,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(L,"href","#optimize-inference-using-torchcompile"),l(w,"class","relative group"),l(W,"id","benefits-of-torchcompile"),l(W,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(W,"href","#benefits-of-torchcompile"),l(M,"class","relative group"),l(P,"id","benchmarking-code"),l(P,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(P,"href","#benchmarking-code"),l(T,"class","relative group"),l(O,"id","image-classification-with-vit"),l(O,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(O,"href","#image-classification-with-vit"),l(C,"class","relative group"),l(V,"id","object-detection-with-detr"),l(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(V,"href","#object-detection-with-detr"),l(k,"class","relative group"),l(X,"id","image-segmentation-with-segformer"),l(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(X,"href","#image-segmentation-with-segformer"),l($,"class","relative group"),l(G,"class","flex"),l(q,"class","flex"),l(F,"id","a100-batch-size-1"),l(F,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(F,"href","#a100-batch-size-1"),l(_,"class","relative group"),l(Y,"id","a100-batch-size-4"),l(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(Y,"href","#a100-batch-size-4"),l(E,"class","relative group"),l(Q,"id","a100-batch-size-16"),l(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(Q,"href","#a100-batch-size-16"),l(j,"class","relative group"),l(K,"id","v100-batch-size-1"),l(K,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(K,"href","#v100-batch-size-1"),l(I,"class","relative group"),l(tt,"id","v100-batch-size-4"),l(tt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(tt,"href","#v100-batch-size-4"),l(x,"class","relative group"),l(et,"id","v100-batch-size-16"),l(et,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(et,"href","#v100-batch-size-16"),l(S,"class","relative group"),l(nt,"id","t4-batch-size-1"),l(nt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(nt,"href","#t4-batch-size-1"),l(N,"class","relative group"),l(rt,"id","t4-batch-size-4"),l(rt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(rt,"href","#t4-batch-size-4"),l(R,"class","relative group"),l(at,"id","t4-batch-size-16"),l(at,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(at,"href","#t4-batch-size-16"),l(A,"class","relative group"),l(it,"id","pytorch-nightly"),l(it,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(it,"href","#pytorch-nightly"),l(J,"class","relative group"),l(lt,"id","a100"),l(lt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(lt,"href","#a100"),l(U,"class","relative group"),l(ot,"id","t4"),l(ot,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(ot,"href","#t4"),l(z,"class","relative group"),l(dt,"id","v100"),l(dt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(dt,"href","#v100"),l(B,"class","relative group"),l(ct,"id","reduce-overhead"),l(ct,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(ct,"href","#reduce-overhead"),l(Z,"class","relative group"),l(st,"id","a100"),l(st,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(st,"href","#a100"),l(H,"class","relative group"),l(gt,"id","t4"),l(gt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(gt,"href","#t4"),l(D,"class","relative group")},m(t,n){o(document.head,y),i(t,on,n),i(t,Ue,n),i(t,dn,n),i(t,w,n),o(w,L),o(L,ze),p(ht,ze,null),o(w,zr),o(w,pe),i(t,cn,n),i(t,mt,n),i(t,sn,n),i(t,M,n),o(M,W),o(W,Be),p(pt,Be,null),o(M,Br),o(M,fe),i(t,gn,n),i(t,ft,n),i(t,hn,n),p(vt,t,n),i(t,mn,n),i(t,ut,n),i(t,pn,n),i(t,bt,n),i(t,fn,n),i(t,T,n),o(T,P),o(P,Ze),p(yt,Ze,null),o(T,Zr),o(T,ve),i(t,vn,n),i(t,wt,n),i(t,un,n),i(t,C,n),o(C,O),o(O,He),p(Mt,He,null),o(C,Hr),o(C,ue),i(t,bn,n),p(Tt,t,n),i(t,yn,n),i(t,k,n),o(k,V),o(V,De),p(Ct,De,null),o(k,Dr),o(k,be),i(t,wn,n),p(kt,t,n),i(t,Mn,n),i(t,$,n),o($,X),o(X,Le),p($t,Le,null),o($,Lr),o($,ye),i(t,Tn,n),p(_t,t,n),i(t,Cn,n),i(t,Et,n),i(t,kn,n),i(t,jt,n),i(t,$n,n),i(t,It,n),i(t,_n,n),i(t,xt,n),i(t,En,n),i(t,St,n),i(t,jn,n),i(t,Nt,n),i(t,In,n),i(t,Rt,n),i(t,xn,n),i(t,At,n),i(t,Sn,n),i(t,G,n),i(t,Nn,n),i(t,q,n),i(t,Rn,n),i(t,Jt,n),i(t,An,n),i(t,Ut,n),i(t,Jn,n),i(t,zt,n),i(t,Un,n),i(t,_,n),o(_,F),o(F,We),p(Bt,We,null),o(_,Wr),o(_,we),i(t,zn,n),i(t,Zt,n),i(t,Bn,n),i(t,E,n),o(E,Y),o(Y,Pe),p(Ht,Pe,null),o(E,Pr),o(E,Me),i(t,Zn,n),i(t,Dt,n),i(t,Hn,n),i(t,j,n),o(j,Q),o(Q,Oe),p(Lt,Oe,null),o(j,Or),o(j,Te),i(t,Dn,n),i(t,Wt,n),i(t,Ln,n),i(t,I,n),o(I,K),o(K,Ve),p(Pt,Ve,null),o(I,Vr),o(I,Ce),i(t,Wn,n),i(t,Ot,n),i(t,Pn,n),i(t,x,n),o(x,tt),o(tt,Xe),p(Vt,Xe,null),o(x,Xr),o(x,ke),i(t,On,n),i(t,Xt,n),i(t,Vn,n),i(t,S,n),o(S,et),o(et,Ge),p(Gt,Ge,null),o(S,Gr),o(S,$e),i(t,Xn,n),i(t,qt,n),i(t,Gn,n),i(t,N,n),o(N,nt),o(nt,qe),p(Ft,qe,null),o(N,qr),o(N,_e),i(t,qn,n),i(t,Yt,n),i(t,Fn,n),i(t,R,n),o(R,rt),o(rt,Fe),p(Qt,Fe,null),o(R,Fr),o(R,Ee),i(t,Yn,n),i(t,Kt,n),i(t,Qn,n),i(t,A,n),o(A,at),o(at,Ye),p(te,Ye,null),o(A,Yr),o(A,je),i(t,Kn,n),i(t,ee,n),i(t,tr,n),i(t,J,n),o(J,it),o(it,Qe),p(ne,Qe,null),o(J,Qr),o(J,Ie),i(t,er,n),i(t,U,n),o(U,lt),o(lt,Ke),p(re,Ke,null),o(U,Kr),o(U,xe),i(t,nr,n),i(t,ae,n),i(t,rr,n),i(t,z,n),o(z,ot),o(ot,tn),p(ie,tn,null),o(z,ta),o(z,Se),i(t,ar,n),i(t,le,n),i(t,ir,n),i(t,B,n),o(B,dt),o(dt,en),p(oe,en,null),o(B,ea),o(B,Ne),i(t,lr,n),i(t,de,n),i(t,or,n),i(t,Z,n),o(Z,ct),o(ct,nn),p(ce,nn,null),o(Z,na),o(Z,Re),i(t,dr,n),i(t,H,n),o(H,st),o(st,rn),p(se,rn,null),o(H,ra),o(H,Ae),i(t,cr,n),i(t,ge,n),i(t,sr,n),i(t,D,n),o(D,gt),o(gt,an),p(he,an,null),o(D,aa),o(D,Je),i(t,gr,n),i(t,me,n),i(t,hr,n),i(t,ln,n),mr=!0},p:Ki,i(t){mr||(f(ht.$$.fragment,t),f(pt.$$.fragment,t),f(vt.$$.fragment,t),f(yt.$$.fragment,t),f(Mt.$$.fragment,t),f(Tt.$$.fragment,t),f(Ct.$$.fragment,t),f(kt.$$.fragment,t),f($t.$$.fragment,t),f(_t.$$.fragment,t),f(Bt.$$.fragment,t),f(Ht.$$.fragment,t),f(Lt.$$.fragment,t),f(Pt.$$.fragment,t),f(Vt.$$.fragment,t),f(Gt.$$.fragment,t),f(Ft.$$.fragment,t),f(Qt.$$.fragment,t),f(te.$$.fragment,t),f(ne.$$.fragment,t),f(re.$$.fragment,t),f(ie.$$.fragment,t),f(oe.$$.fragment,t),f(ce.$$.fragment,t),f(se.$$.fragment,t),f(he.$$.fragment,t),mr=!0)},o(t){v(ht.$$.fragment,t),v(pt.$$.fragment,t),v(vt.$$.fragment,t),v(yt.$$.fragment,t),v(Mt.$$.fragment,t),v(Tt.$$.fragment,t),v(Ct.$$.fragment,t),v(kt.$$.fragment,t),v($t.$$.fragment,t),v(_t.$$.fragment,t),v(Bt.$$.fragment,t),v(Ht.$$.fragment,t),v(Lt.$$.fragment,t),v(Pt.$$.fragment,t),v(Vt.$$.fragment,t),v(Gt.$$.fragment,t),v(Ft.$$.fragment,t),v(Qt.$$.fragment,t),v(te.$$.fragment,t),v(ne.$$.fragment,t),v(re.$$.fragment,t),v(ie.$$.fragment,t),v(oe.$$.fragment,t),v(ce.$$.fragment,t),v(se.$$.fragment,t),v(he.$$.fragment,t),mr=!1},d(t){t&&(e(on),e(Ue),e(dn),e(w),e(cn),e(mt),e(sn),e(M),e(gn),e(ft),e(hn),e(mn),e(ut),e(pn),e(bt),e(fn),e(T),e(vn),e(wt),e(un),e(C),e(bn),e(yn),e(k),e(wn),e(Mn),e($),e(Tn),e(Cn),e(Et),e(kn),e(jt),e($n),e(It),e(_n),e(xt),e(En),e(St),e(jn),e(Nt),e(In),e(Rt),e(xn),e(At),e(Sn),e(G),e(Nn),e(q),e(Rn),e(Jt),e(An),e(Ut),e(Jn),e(zt),e(Un),e(_),e(zn),e(Zt),e(Bn),e(E),e(Zn),e(Dt),e(Hn),e(j),e(Dn),e(Wt),e(Ln),e(I),e(Wn),e(Ot),e(Pn),e(x),e(On),e(Xt),e(Vn),e(S),e(Xn),e(qt),e(Gn),e(N),e(qn),e(Yt),e(Fn),e(R),e(Yn),e(Kt),e(Qn),e(A),e(Kn),e(ee),e(tr),e(J),e(er),e(U),e(nr),e(ae),e(rr),e(z),e(ar),e(le),e(ir),e(B),e(lr),e(de),e(or),e(Z),e(dr),e(H),e(cr),e(ge),e(sr),e(D),e(gr),e(me),e(hr),e(ln)),e(y),u(ht),u(pt),u(vt,t),u(yt),u(Mt),u(Tt,t),u(Ct),u(kt,t),u($t),u(_t,t),u(Bt),u(Ht),u(Lt),u(Pt),u(Vt),u(Gt),u(Ft),u(Qt),u(te),u(ne),u(re),u(ie),u(oe),u(ce),u(se),u(he)}}}const il={local:"optimize-inference-using-torchcompile",sections:[{local:"benefits-of-torchcompile",title:"Benefits of torch.compile"},{local:"benchmarking-code",sections:[{local:"image-classification-with-vit",sections:[{local:"object-detection-with-detr",title:"Object Detection with DETR"},{local:"image-segmentation-with-segformer",title:"Image Segmentation with Segformer"}],title:"Image Classification with ViT"},{local:"a100-batch-size-1",title:"A100 (batch size: 1)"},{local:"a100-batch-size-4",title:"A100 (batch size: 4)"},{local:"a100-batch-size-16",title:"A100 (batch size: 16)"},{local:"v100-batch-size-1",title:"V100 (batch size: 1)"},{local:"v100-batch-size-4",title:"V100 (batch size: 4)"},{local:"v100-batch-size-16",title:"V100 (batch size: 16)"},{local:"t4-batch-size-1",title:"T4 (batch size: 1)"},{local:"t4-batch-size-4",title:"T4 (batch size: 4)"},{local:"t4-batch-size-16",title:"T4 (batch size: 16)"}],title:"Benchmarking code "},{local:"pytorch-nightly",sections:[{local:"a100",title:"A100"},{local:"t4",title:"T4"},{local:"v100",title:"V100"}],title:"PyTorch Nightly"},{local:"reduce-overhead",sections:[{local:"a100",title:"A100"},{local:"t4",title:"T4"}],title:"Reduce Overhead"}],title:"Optimize inference using torch.compile()"};function ll(oa){return tl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gl extends el{constructor(y){super(),nl(this,y,ll,al,Qi,{})}}export{gl as component};
