import{s as hu,o as uu,n as du}from"../chunks/scheduler.9bc65507.js";import{S as fu,i as cu,g as n,s as a,u as d,A as mu,h as i,f as t,c as o,j as u,v as f,y as r,k as p,o as h,a as s,w as c,d as m,t as v,x as w}from"../chunks/index.78c82d43.js";import{T as vu}from"../chunks/Tip.87d55b76.js";import{I as x}from"../chunks/IconCopyLink.bedaa44d.js";import{C as Es}from"../chunks/CodeBlock.73e038be.js";function wu(Is){let g,X='Note: Most of the strategies introduced in the <a href="perf_train_gpu_one">single GPU section</a> (such as mixed precision training or gradient accumulation) are generic and apply to training models in general so make sure to have a look at it before diving into the following sections such as multi-GPU or CPU training.';return{c(){g=n("p"),g.innerHTML=X},l(P){g=i(P,"P",{"data-svelte-h":!0}),r(g)!=="svelte-ltsvmw"&&(g.innerHTML=X)},m(P,hs){s(P,g,hs)},p:du,d(P){P&&t(g)}}}function gu(Is){let g,X,P,hs,y,G,Ts,F,vo,us,Uo="Efficient Training on Multiple GPUs",As,O,ko="When training on a single GPU is too slow or the model weights don’t fit in a single GPUs memory we use a multi-GPU setup. Switching from a single GPU to multiple requires some form of parallelism as the work needs to be distributed. There are several techniques to achieve parallism such as data, tensor, or pipeline parallism. However, there is no one solution to fit them all and which settings works best depends on the hardware you are running on. While the main concepts most likely will apply to any other framework, this article is focused on PyTorch-based implementations.",zs,S,Bs,q,Do="We will first discuss in depth various 1D parallelism techniques and their pros and cons and then look at how they can be combined into 2D and 3D parallelism to enable an even faster training and to support even bigger models. Various other powerful alternative approaches will be presented.",Qs,M,N,Cs,Y,wo,ds,Jo="Concepts",Zs,K,Ho="The following is the brief description of the main concepts that will be described later in depth in this document.",Rs,ee,Go="<li><strong>DataParallel (DP)</strong> - the same setup is replicated multiple times, and each being fed a slice of the data. The processing is done in parallel and all setups are synchronized at the end of each training step.</li> <li><strong>TensorParallel (TP)</strong> - each tensor is split up into multiple chunks, so instead of having the whole tensor reside on a single gpu, each shard of the tensor resides on its designated gpu. During processing each shard gets processed separately and in parallel on different GPUs and the results are synced at the end of the step. This is what one may call horizontal parallelism, as the splitting happens on horizontal level.</li> <li><strong>PipelineParallel (PP)</strong> - the model is split up vertically (layer-level) across multiple GPUs, so that only one or several layers of the model are places on a single gpu. Each gpu processes in parallel different stages of the pipeline and working on a small chunk of the batch.</li> <li><strong>Zero Redundancy Optimizer (ZeRO)</strong> - Also performs sharding of the tensors somewhat similar to TP, except the whole tensor gets reconstructed in time for a forward or backward computation, therefore the model doesn’t need to be modified. It also supports various offloading techniques to compensate for limited GPU memory.</li> <li><strong>Sharded DDP</strong> - is another name for the foundational ZeRO concept as used by various other implementations of ZeRO.</li>",Vs,te,So="Before diving deeper into the specifics of each concept we first have a look at the rough decision process when training large models on a large infrastructure.",Ws,b,$,_s,le,go,fs,No="Scalability Strategy",Xs,se,$o="<strong>⇨ Single Node / Multi-GPU</strong>",Fs,ne,Eo="<li><p>Model fits onto a single GPU:</p> <ol><li>DDP - Distributed DP</li> <li>ZeRO - may or may not be faster depending on the situation and configuration used</li></ol></li> <li><p>Model doesn’t fit onto a single GPU:</p> <ol><li><p>PP</p></li> <li><p>ZeRO</p></li> <li><p>TP</p> <p>With very fast intra-node connectivity of NVLINK or NVSwitch all three should be mostly on par, without these PP will be faster than TP or ZeRO. The degree of TP may also make a difference. Best to experiment to find the winner on your particular setup.</p> <p>TP is almost always used within a single node. That is TP size &lt;= gpus per node.</p></li></ol></li> <li><p>Largest Layer not fitting into a single GPU:</p> <ol><li>If not using ZeRO - must use TP, as PP alone won’t be able to fit.</li> <li>With ZeRO see the same entry for “Single GPU” above</li></ol></li>",Os,ie,Io="<strong>⇨ Multi-Node / Multi-GPU</strong>",qs,ae,Ao="<li><p>When you have fast inter-node connectivity:</p> <ol><li>ZeRO - as it requires close to no modifications to the model</li> <li>PP+TP+DP - less communications, but requires massive changes to the model</li></ol></li> <li><p>when you have slow inter-node connectivity and still low on GPU memory:</p> <ol><li>DP+PP+TP+ZeRO-1</li></ol></li>",Ys,T,E,js,oe,xo,cs,zo="Data Parallelism",Ks,re,Bo='Most users with just 2 GPUs already enjoy the increased training speed up thanks to <code>DataParallel</code> (DP) and <code>DistributedDataParallel</code> (DDP) that are almost trivial to use. This is a built-in feature of Pytorch. Note that in general it is advised to use DDP as it is better maintained and works for all models while DP might fail for some models. <a href="https://pytorch.org/docs/master/generated/torch.nn.DataParallel.html" rel="nofollow">PyTorch documentation</a> itself recommends the use of DDP.',en,C,I,Ls,pe,Po,ms,Qo="DP vs DDP",tn,he,Zo="<code>DistributedDataParallel</code> (DDP) is typically faster than <code>DataParallel</code> (DP), but it is not always the case:",ln,ue,Ro="<li>while DP is python threads-based, DDP is multiprocess-based - and as such it has no python threads limitations, such as GIL</li> <li>on the other hand a slow inter-connectivity between the GPU cards could lead to an actual slower outcome with DDP</li>",sn,de,Vo="Here are the main differences in the inter-GPU communication overhead between the two modes:",nn,fe,Wo='<a href="https://pytorch.org/docs/master/notes/ddp.html" rel="nofollow">DDP</a>:',an,ce,Xo="<li>At the start time the main process replicates the model once from gpu 0 to the rest of gpus</li> <li>Then for each batch:<ol><li>each gpu consumes each own mini-batch of data directly</li> <li>during <code>backward</code>, once the local gradients are ready, they are then averaged across all processes</li></ol></li>",on,me,Fo='<a href="https://pytorch.org/docs/master/generated/torch.nn.DataParallel.html" rel="nofollow">DP</a>:',rn,ve,Oo="For each batch:",pn,we,qo="<li>gpu 0 reads the batch of data and then sends a mini-batch to each gpu</li> <li>replicates the up-to-date model from gpu 0 to each gpu</li> <li>runs <code>forward</code> and sends output from each gpu to gpu 0, computes loss</li> <li>scatters loss from gpu 0 to all gpus, runs <code>backward</code></li> <li>sends gradients from each gpu to gpu 0 and averages those</li>",hn,ge,Yo="The only communication DDP performs per batch is sending gradients, whereas DP does 5 different data exchanges per batch.",un,xe,Ko='DP copies data within the process via python threads, whereas DDP copies data via <a href="https://pytorch.org/docs/master/distributed.html" rel="nofollow">torch.distributed</a>.',dn,Pe,er="Under DP gpu 0 performs a lot more work than the rest of the gpus, thus resulting in under-utilization of gpus.",fn,ye,tr="You can use DDP across multiple machines, but this is not the case with DP.",cn,Me,lr="There are other differences between DP and DDP but they aren’t relevant to this discussion.",mn,be,sr='If you want to go really deep into understanding these 2 modes, this <a href="https://www.telesens.co/2019/04/04/distributed-data-parallel-training-using-pytorch-on-aws/" rel="nofollow">article</a> is highly recommended, as it has great diagrams, includes multiple benchmarks and profiler outputs on various hardware, explains all the nuances that you may need to know.',vn,Te,nr="Let’s look at an actual benchmark:",wn,Ce,ir='<thead><tr><th align="left">Type</th> <th>NVlink</th> <th align="right">Time</th></tr></thead> <tbody><tr><td align="left">2:DP</td> <td>Y</td> <td align="right">110s</td></tr> <tr><td align="left">2:DDP</td> <td>Y</td> <td align="right">101s</td></tr> <tr><td align="left">2:DDP</td> <td>N</td> <td align="right">131s</td></tr></tbody>',gn,_e,ar="Analysis:",xn,je,or="Here DP is ~10% slower than DDP w/ NVlink, but ~15% faster than DDP w/o NVlink",Pn,Le,rr="The real difference will depend on how much data each GPU needs to sync with the others - the more there is to sync, the more a slow link will slow down the total runtime.",yn,Ue,pr="Here is the full benchmark code and outputs:",Mn,ke,hr="<code>NCCL_P2P_DISABLE=1</code> was used to disable the NVLink feature on the corresponding benchmark.",bn,De,Tn,Je,ur=`Hardware: 2x TITAN RTX 24GB each + NVlink with 2 NVLinks (<code>NV2</code> in <code>nvidia-smi topo -m</code>)
Software: <code>pytorch-1.8-to-be</code> + <code>cuda-11.0</code> / <code>transformers==4.3.0.dev0</code>`,Cn,_,A,Us,He,yo,vs,dr="ZeRO Data Parallelism",_n,Ge,fr='ZeRO-powered data parallelism (ZeRO-DP) is described on the following diagram from this <a href="https://www.microsoft.com/en-us/research/blog/zero-deepspeed-new-system-optimizations-enable-training-models-with-over-100-billion-parameters/" rel="nofollow">blog post</a> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-zero.png" alt="DeepSpeed-Image-1"/>',jn,Se,cr="It can be difficult to wrap one’s head around it, but in reality the concept is quite simple. This is just the usual <code>DataParallel</code> (DP), except, instead of replicating the full model params, gradients and optimizer states, each GPU stores only a slice of it.  And then at run-time when the full layer params are needed just for the given layer, all GPUs synchronize to give each other parts that they miss - this is it.",Ln,Ne,mr="Consider this simple model with 3 layers, where each layer has 3 params:",Un,$e,kn,Ee,vr="Layer La has weights a0, a1 and a2.",Dn,Ie,wr="If we have 3 GPUs, the Sharded DDP (= Zero-DP) splits the model onto 3 GPUs like so:",Jn,Ae,Hn,ze,gr="In a way this is the same horizontal slicing, as tensor parallelism, if you imagine the typical DNN diagram. Vertical slicing is where one puts whole layer-groups on different GPUs. But it’s just the starting point.",Gn,Be,xr="Now each of these GPUs will get the usual mini-batch as it works in DP:",Sn,Qe,Nn,Ze,Pr="The inputs are unmodified - they think they are going to be processed by the normal model.",$n,Re,yr="First, the inputs hit the layer La.",En,Ve,Mr="Let’s focus just on GPU0: x0 needs a0, a1, a2 params to do its forward path, but GPU0 has only a0 - it gets sent a1 from GPU1 and a2 from GPU2, bringing all pieces of the model together.",In,We,br="In parallel, GPU1 gets mini-batch x1 and it only has a1, but needs a0 and a2 params, so it gets those from GPU0 and GPU2.",An,Xe,Tr="Same happens to GPU2 that gets input x2. It gets a0 and a1 from GPU0 and GPU1, and with its a2 it reconstructs the full tensor.",zn,Fe,Cr="All 3 GPUs get the full tensors reconstructed and a forward happens.",Bn,Oe,_r="As soon as the calculation is done, the data that is no longer needed gets dropped - it’s only used during the calculation. The reconstruction is done efficiently via a pre-fetch.",Qn,qe,jr="And the whole process is repeated for layer Lb, then Lc forward-wise, and then backward Lc -> Lb -> La.",Zn,Ye,Lr="To me this sounds like an efficient group backpacking weight distribution strategy:",Rn,Ke,Ur="<li>person A carries the tent</li> <li>person B carries the stove</li> <li>person C carries the axe</li>",Vn,et,kr="Now each night they all share what they have with others and get from others what they don’t have, and in the morning they pack up their allocated type of gear and continue on their way. This is Sharded DDP / Zero DP.",Wn,tt,Dr="Compare this strategy to the simple one where each person has to carry their own tent, stove and axe, which would be far more inefficient. This is DataParallel (DP and DDP) in Pytorch.",Xn,lt,Jr="While reading the literature on this topic you may encounter the following synonyms: Sharded, Partitioned.",Fn,st,Hr="If you pay close attention the way ZeRO partitions the model’s weights - it looks very similar to tensor parallelism which will be discussed later. This is because it partitions/shards each layer’s weights, unlike vertical model parallelism which is discussed next.",On,nt,Gr="Implementations:",qn,it,Sr='<li><a href="https://www.deepspeed.ai/features/#the-zero-redundancy-optimizer" rel="nofollow">DeepSpeed</a> ZeRO-DP stages 1+2+3</li> <li><a href="main_classes/trainer#trainer-integrations"><code>transformers</code> integration</a></li>',Yn,j,z,ks,at,Mo,ws,Nr="Naive Model Parallelism (Vertical) and Pipeline Parallelism",Kn,ot,$r="Naive Model Parallelism (MP) is where one spreads groups of model layers across multiple GPUs. The mechanism is relatively simple - switch the desired layers <code>.to()</code> the desired devices and now whenever the data goes in and out those layers switch the data to the same device as the layer and leave the rest unmodified.",ei,rt,Er="We refer to it as Vertical MP, because if you remember how most models are drawn, we slice the layers vertically. For example, if the following diagram shows an 8-layer model:",ti,pt,li,ht,Ir="we just sliced it in 2 vertically, placing layers 0-3 onto GPU0 and 4-7 to GPU1.",si,ut,Ar="Now while data travels from layer 0 to 1, 1 to 2 and 2 to 3 this is just the normal model. But when data needs to pass from layer 3 to layer 4 it needs to travel from GPU0 to GPU1 which introduces a communication overhead. If the participating GPUs are on the same compute node (e.g. same physical machine) this copying is pretty fast, but if the GPUs are located on different compute nodes (e.g. multiple machines) the communication overhead could be significantly larger.",ni,dt,zr="Then layers 4 to 5 to 6 to 7 are as a normal model would have and when the 7th layer completes we often need to send the data back to layer 0 where the labels are (or alternatively send the labels to the last layer). Now the loss can be computed and the optimizer can do its work.",ii,ft,Br="Problems:",ai,ct,Qr="<li>the main deficiency and why this one is called “naive” MP, is that all but one GPU is idle at any given moment. So if 4 GPUs are used, it’s almost identical to quadrupling the amount of memory of a single GPU, and ignoring the rest of the hardware. Plus there is the overhead of copying the data between devices. So 4x 6GB cards will be able to accommodate the same size as 1x 24GB card using naive MP, except the latter will complete the training faster, since it doesn’t have the data copying overhead. But, say, if you have 40GB cards and need to fit a 45GB model you can with 4x 40GB cards (but barely because of the gradient and optimizer states)</li> <li>shared embeddings may need to get copied back and forth between GPUs.</li>",oi,mt,Zr="Pipeline Parallelism (PP) is almost identical to a naive MP, but it solves the GPU idling problem, by chunking the incoming batch into micro-batches and artificially creating a pipeline, which allows different GPUs to concurrently participate in the computation process.",ri,vt,Rr='The following illustration from the <a href="https://ai.googleblog.com/2019/03/introducing-gpipe-open-source-library.html" rel="nofollow">GPipe paper</a> shows the naive MP on the top, and PP on the bottom:',pi,wt,Vr='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-gpipe-bubble.png" alt="mp-pp"/>',hi,gt,Wr="It’s easy to see from the bottom diagram how PP has less dead zones, where GPUs are idle. The idle parts are referred to as the “bubble”.",ui,xt,Xr="Both parts of the diagram show a parallelism that is of degree 4. That is 4 GPUs are participating in the pipeline. So there is the forward path of 4 pipe stages F0, F1, F2 and F3 and then the return reverse order backward path of B3, B2, B1 and B0.",di,Pt,Fr="PP introduces a new hyper-parameter to tune and it’s <code>chunks</code> which defines how many chunks of data are sent in a sequence through the same pipe stage. For example, in the bottom diagram you can see that <code>chunks=4</code>. GPU0 performs the same forward path on chunk 0, 1, 2 and 3 (F0,0, F0,1, F0,2, F0,3) and then it waits for other GPUs to do their work and only when their work is starting to be complete, GPU0 starts to work again doing the backward path for chunks 3, 2, 1 and 0 (B0,3, B0,2, B0,1, B0,0).",fi,yt,Or="Note that conceptually this is the same concept as gradient accumulation steps (GAS). Pytorch uses <code>chunks</code>, whereas DeepSpeed refers to the same hyper-parameter as GAS.",ci,Mt,qr="Because of the chunks, PP introduces the concept of micro-batches (MBS). DP splits the global data batch size into mini-batches, so if you have a DP degree of 4, a global batch size of 1024 gets split up into 4 mini-batches of 256 each (1024/4). And if the number of <code>chunks</code> (or GAS) is 32 we end up with a micro-batch size of 8 (256/32). Each Pipeline stage works with a single micro-batch at a time.",mi,bt,Yr="To calculate the global batch size of the DP + PP setup we then do: <code>mbs*chunks*dp_degree</code> (<code>8*32*4=1024</code>).",vi,Tt,Kr="Let’s go back to the diagram.",wi,Ct,ep="With <code>chunks=1</code> you end up with the naive MP, which is very inefficient. With a very large <code>chunks</code> value you end up with tiny micro-batch sizes which could be not every efficient either. So one has to experiment to find the value that leads to the highest efficient utilization of the gpus.",gi,_t,tp="While the diagram shows that there is a bubble of “dead” time that can’t be parallelized because the last <code>forward</code> stage has to wait for <code>backward</code> to complete the pipeline, the purpose of finding the best value for <code>chunks</code> is to enable a high concurrent GPU utilization across all participating GPUs which translates to minimizing the size of the bubble.",xi,jt,lp="There are 2 groups of solutions - the traditional Pipeline API and the more modern solutions that make things much easier for the end user.",Pi,Lt,sp="Traditional Pipeline API solutions:",yi,Ut,np="<li>PyTorch</li> <li>DeepSpeed</li> <li>Megatron-LM</li>",Mi,kt,ip="Modern solutions:",bi,Dt,ap="<li>Varuna</li> <li>Sagemaker</li>",Ti,Jt,op="Problems with traditional Pipeline API solutions:",Ci,Ht,rp='<li>have to modify the model quite heavily, because Pipeline requires one to rewrite the normal flow of modules into a <code>nn.Sequential</code> sequence of the same, which may require changes to the design of the model.</li> <li>currently the Pipeline API is very restricted. If you had a bunch of python variables being passed in the very first stage of the Pipeline, you will have to find a way around it. Currently, the pipeline interface requires either a single Tensor or a tuple of Tensors as the only input and output. These tensors must have a batch size as the very first dimension, since pipeline is going to chunk the mini batch into micro-batches. Possible improvements are being discussed here <a href="https://github.com/pytorch/pytorch/pull/50693" rel="nofollow">https://github.com/pytorch/pytorch/pull/50693</a></li> <li>conditional control flow at the level of pipe stages is not possible - e.g., Encoder-Decoder models like T5 require special workarounds to handle a conditional encoder stage.</li> <li>have to arrange each layer so that the output of one model becomes an input to the other model.</li>',_i,Gt,pp="We are yet to experiment with Varuna and SageMaker but their papers report that they have overcome the list of problems mentioned above and that they require much smaller changes to the user’s model.",ji,St,hp="Implementations:",Li,Nt,up='<li><a href="https://pytorch.org/docs/stable/pipeline.html" rel="nofollow">Pytorch</a> (initial support in pytorch-1.8, and progressively getting improved in 1.9 and more so in 1.10). Some <a href="https://github.com/pytorch/pytorch/blob/master/benchmarks/distributed/pipeline/pipe.py" rel="nofollow">examples</a></li> <li><a href="https://www.deepspeed.ai/tutorials/pipeline/" rel="nofollow">DeepSpeed</a></li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a> has an internal implementation - no API.</li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a> - this is a proprietary solution that can only be used on AWS.</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a> - this is implemented based on the Hugging Face Transformers.</li>',Ui,$t,dp="🤗 Transformers status: as of this writing none of the models supports full-PP. GPT2 and T5 models have naive MP support. The main obstacle is being unable to convert the models to <code>nn.Sequential</code> and have all the inputs to be Tensors. This is because currently the models include many features that make the conversion very complicated, and will need to be removed to accomplish that.",ki,Et,fp="Other approaches:",Di,It,cp='DeepSpeed, Varuna and SageMaker use the concept of an <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-parallel-core-features.html" rel="nofollow">Interleaved Pipeline</a> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-sagemaker-interleaved-pipeline.png" alt="interleaved-pipeline-execution"/>',Ji,At,mp="Here the bubble (idle time) is further minimized by prioritizing backward passes.",Hi,zt,vp="Varuna further tries to improve the schedule by using simulations to discover the most efficient scheduling.",Gi,Bt,wp="OSLO has pipeline parallelism implementation based on the Transformers without <code>nn.Sequential</code> converting.",Si,L,B,Ds,Qt,bo,gs,gp="Tensor Parallelism",Ni,Zt,xp="In Tensor Parallelism each GPU processes only a slice of a tensor and only aggregates the full tensor for operations that require the whole thing.",$i,Rt,Pp='In this section we use concepts and diagrams from the <a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a> paper: <a href="https://arxiv.org/abs/2104.04473" rel="nofollow">Efficient Large-Scale Language Model Training on GPU Clusters</a>.',Ei,Vt,yp="The main building block of any transformer is a fully connected <code>nn.Linear</code> followed by a nonlinear activation <code>GeLU</code>.",Ii,Wt,Mp="Following the Megatron’s paper notation, we can write the dot-product part of it as <code>Y = GeLU(XA)</code>, where <code>X</code> and <code>Y</code> are the input and output vectors, and <code>A</code> is the weight matrix.",Ai,Xt,bp=`If we look at the computation in matrix form, it’s easy to see how the matrix multiplication can be split between multiple GPUs:
<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_gemm.png" alt="Parallel GEMM"/>`,zi,Ft,Tp=`If we split the weight matrix <code>A</code> column-wise across <code>N</code> GPUs and perform matrix multiplications <code>XA_1</code> through <code>XA_n</code> in parallel, then we will end up with <code>N</code> output vectors <code>Y_1, Y_2, ..., Y_n</code> which can be fed into <code>GeLU</code> independently:
<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-independent-gelu.png" alt="independent GeLU"/>`,Bi,Ot,Cp=`Using this principle, we can update an MLP of arbitrary depth, without the need for any synchronization between GPUs until the very end, where we need to reconstruct the output vector from shards. The Megatron-LM paper authors provide a helpful illustration for that:
<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_shard_processing.png" alt="parallel shard processing"/>`,Qi,qt,_p=`Parallelizing the multi-headed attention layers is even simpler, since they are already inherently parallel, due to having multiple independent heads!
<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_self_attention.png" alt="parallel self-attention"/>`,Zi,Yt,jp="Special considerations: TP requires very fast network, and therefore it’s not advisable to do TP across more than one node. Practically, if a node has 4 GPUs, the highest TP degree is therefore 4. If you need a TP degree of 8, you need to use nodes that have at least 8 GPUs.",Ri,Kt,Lp=`This section is based on the original much more <a href="https://github.com/huggingface/transformers/issues/10321#issuecomment-783543530" rel="nofollow">detailed TP overview</a>.
by <a href="https://github.com/anton-l" rel="nofollow">@anton-l</a>.`,Vi,el,Up="SageMaker combines TP with DP for a more efficient processing.",Wi,tl,kp="Alternative names:",Xi,ll,Dp='<li>DeepSpeed calls it <a href="https://www.deepspeed.ai/features/#model-parallelism" rel="nofollow">tensor slicing</a></li>',Fi,sl,Jp="Implementations:",Oi,nl,Hp='<li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a> has an internal implementation, as it’s very model-specific</li> <li><a href="https://github.com/tunib-ai/parallelformers" rel="nofollow">parallelformers</a> (only inference at the moment)</li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a> - this is a proprietary solution that can only be used on AWS.</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a> has the tensor parallelism implementation based on the Transformers.</li>',qi,il,Gp="🤗 Transformers status:",Yi,al,Sp='<li>core: not yet implemented in the core</li> <li>but if you want inference <a href="https://github.com/tunib-ai/parallelformers" rel="nofollow">parallelformers</a> provides this support for most of our models. So until this is implemented in the core you can use theirs. And hopefully training mode will be supported too.</li> <li>Deepspeed-Inference also supports our BERT, GPT-2, and GPT-Neo models in their super-fast CUDA-kernel-based inference mode, see more <a href="https://www.deepspeed.ai/tutorials/inference-tutorial/" rel="nofollow">here</a></li>',Ki,U,Q,Js,ol,To,xs,Np="DP+PP",ea,rl,$p='The following diagram from the DeepSpeed <a href="https://www.deepspeed.ai/tutorials/pipeline/" rel="nofollow">pipeline tutorial</a> demonstrates how one combines DP with PP.',ta,pl,Ep='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-zero-dp-pp.png" alt="dp-pp-2d"/>',la,hl,Ip="Here it’s important to see how DP rank 0 doesn’t see GPU2 and DP rank 1 doesn’t see GPU3. To DP there is just GPUs 0 and 1 where it feeds data as if there were just 2 GPUs. GPU0 “secretly” offloads some of its load to GPU2 using PP. And GPU1 does the same by enlisting GPU3 to its aid.",sa,ul,Ap="Since each dimension requires at least 2 GPUs, here you’d need at least 4 GPUs.",na,dl,zp="Implementations:",ia,fl,Bp='<li><a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a></li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a></li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a></li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',aa,cl,Qp="🤗 Transformers status: not yet implemented",oa,k,Z,Hs,ml,Co,Ps,Zp="DP+PP+TP",ra,vl,Rp="To get an even more efficient training a 3D parallelism is used where PP is combined with TP and DP. This can be seen in the following diagram.",pa,wl,Vp='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-deepspeed-3d.png" alt="dp-pp-tp-3d"/>',ha,gl,Wp='This diagram is from a blog post <a href="https://www.microsoft.com/en-us/research/blog/deepspeed-extreme-scale-model-training-for-everyone/" rel="nofollow">3D parallelism: Scaling to trillion-parameter models</a>, which is a good read as well.',ua,xl,Xp="Since each dimension requires at least 2 GPUs, here you’d need at least 8 GPUs.",da,Pl,Fp="Implementations:",fa,yl,Op='<li><a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a> - DeepSpeed also includes an even more efficient DP, which they call ZeRO-DP.</li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a></li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a></li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',ca,Ml,qp="🤗 Transformers status: not yet implemented, since we have no PP and TP.",ma,D,R,Gs,bl,_o,ys,Yp="ZeRO DP+PP+TP",va,Tl,Kp='One of the main features of DeepSpeed is ZeRO, which is a super-scalable extension of DP. It has already been discussed in <a href="#zero-data-parallelism">ZeRO Data Parallelism</a>. Normally it’s a standalone feature that doesn’t require PP or TP. But it can be combined with PP and TP.',wa,Cl,eh="When ZeRO-DP is combined with PP (and optionally TP) it typically enables only ZeRO stage 1 (optimizer sharding).",ga,_l,th="While it’s theoretically possible to use ZeRO stage 2 (gradient sharding) with Pipeline Parallelism, it will have bad performance impacts. There would need to be an additional reduce-scatter collective for every micro-batch to aggregate the gradients before sharding, which adds a potentially significant communication overhead. By nature of Pipeline Parallelism, small micro-batches are used and instead the focus is on trying to balance arithmetic intensity (micro-batch size) with minimizing the Pipeline bubble (number of micro-batches). Therefore those communication costs are going to hurt.",xa,jl,lh="In addition, There are already fewer layers than normal due to PP and so the memory savings won’t be huge. PP already reduces gradient size by <code>1/PP</code>, and so gradient sharding savings on top of that are less significant than pure DP.",Pa,Ll,sh="ZeRO stage 3 is not a good choice either for the same reason - more inter-node communications required.",ya,Ul,nh="And since we have ZeRO, the other benefit is ZeRO-Offload. Since this is stage 1 optimizer states can be offloaded to CPU.",Ma,kl,ih="Implementations:",ba,Dl,ah='<li><a href="https://github.com/microsoft/Megatron-DeepSpeed" rel="nofollow">Megatron-DeepSpeed</a> and <a href="https://github.com/bigscience-workshop/Megatron-DeepSpeed" rel="nofollow">Megatron-Deepspeed from BigScience</a>, which is the fork of the former repo.</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',Ta,Jl,oh="Important papers:",Ca,Hl,rh='<li><a href="https://arxiv.org/abs/2201.11990" rel="nofollow">Using DeepSpeed and Megatron to Train Megatron-Turing NLG 530B, A Large-Scale Generative Language Model</a></li>',_a,Gl,ph="🤗 Transformers status: not yet implemented, since we have no PP and TP.",ja,J,V,Ss,Sl,jo,Ms,hh="FlexFlow",La,Nl,uh='<a href="https://github.com/flexflow/FlexFlow" rel="nofollow">FlexFlow</a> also solves the parallelization problem in a slightly different approach.',Ua,$l,dh='Paper: <a href="https://arxiv.org/abs/1807.05358" rel="nofollow">“Beyond Data and Model Parallelism for Deep Neural Networks” by Zhihao Jia, Matei Zaharia, Alex Aiken</a>',ka,El,fh="It performs a sort of 4D Parallelism over Sample-Operator-Attribute-Parameter.",Da,Il,ch="<li>Sample = Data Parallelism (sample-wise parallel)</li> <li>Operator = Parallelize a single operation into several sub-operations</li> <li>Attribute = Data Parallelism (length-wise parallel)</li> <li>Parameter = Model Parallelism (regardless of dimension - horizontal or vertical)</li>",Ja,Al,mh="Examples:",Ha,zl,vh="<li>Sample</li>",Ga,Bl,wh="Let’s take 10 batches of sequence length 512. If we parallelize them by sample dimension into 2 devices, we get 10 x 512 which becomes be 5 x 2 x 512.",Sa,Ql,gh="<li>Operator</li>",Na,Zl,xh="If we perform layer normalization, we compute std first and mean second, and then we can normalize data. Operator parallelism allows computing std and mean in parallel. So if we parallelize them by operator dimension into 2 devices (cuda:0, cuda:1), first we copy input data into both devices, and cuda:0 computes std, cuda:1 computes mean at the same time.",$a,Rl,Ph="<li>Attribute</li>",Ea,Vl,yh="We have 10 batches of 512 length. If we parallelize them by attribute dimension into 2 devices, 10 x 512 will be 10 x 2 x 256.",Ia,Wl,Mh="<li>Parameter</li>",Aa,Xl,bh="It is similar with tensor model parallelism or naive layer-wise model parallelism.",za,Fl,Th='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-flexflow.jpeg" alt="flex-flow-soap"/>',Ba,Ol,Ch="The significance of this framework is that it takes resources like (1) GPU/TPU/CPU vs. (2) RAM/DRAM vs. (3) fast-intra-connect/slow-inter-connect and it automatically optimizes all these  algorithmically deciding which parallelisation to use where.",Qa,ql,_h="One very important aspect is that FlexFlow is designed for optimizing DNN parallelizations for models with static and fixed workloads, since models with dynamic behavior may prefer different parallelization strategies across iterations.",Za,Yl,jh="So the promise is very attractive - it runs a 30min simulation on the cluster of choice and it comes up with the best strategy to utilise this specific environment. If you add/remove/replace any parts it’ll run and re-optimize the plan for that. And then you can train. A different setup will have its own custom optimization.",Ra,Kl,Lh='🤗 Transformers status: not yet integrated. We already have our models FX-trace-able via <a href="https://github.com/huggingface/transformers/blob/master/src/transformers/utils/fx.py" rel="nofollow">transformers.utils.fx</a>, which is a prerequisite for FlexFlow, so someone needs to figure out what needs to be done to make FlexFlow work with our models.',Va,H,W,Ns,es,Lo,bs,Uh="Which Strategy To Use When",Wa,ts,kh="Here is a very rough outline at which parallelism strategy to use when. The first on each list is typically faster.",Xa,ls,Dh="<strong>⇨ Single GPU</strong>",Fa,ss,Jh="<li><p>Model fits onto a single GPU:</p> <ol><li>Normal use</li></ol></li> <li><p>Model doesn’t fit onto a single GPU:</p> <ol><li>ZeRO + Offload CPU and optionally NVMe</li> <li>as above plus Memory Centric Tiling (see below for details) if the largest layer can’t fit into a single GPU</li></ol></li> <li><p>Largest Layer not fitting into a single GPU:</p></li>",Oa,ns,Hh='<li>ZeRO - Enable <a href="https://deepspeed.readthedocs.io/en/latest/zero3.html#memory-centric-tiling" rel="nofollow">Memory Centric Tiling</a> (MCT). It allows you to run arbitrarily large layers by automatically splitting them and executing them sequentially. MCT reduces the number of parameters that are live on a GPU, but it does not affect the activation memory. As this need is very rare as of this writing a manual override of <code>torch.nn.Linear</code> needs to be done by the user.</li>',qa,is,Gh="<strong>⇨ Single Node / Multi-GPU</strong>",Ya,as,Sh="<li><p>Model fits onto a single GPU:</p> <ol><li>DDP - Distributed DP</li> <li>ZeRO - may or may not be faster depending on the situation and configuration used</li></ol></li> <li><p>Model doesn’t fit onto a single GPU:</p> <ol><li><p>PP</p></li> <li><p>ZeRO</p></li> <li><p>TP</p> <p>With very fast intra-node connectivity of NVLINK or NVSwitch all three should be mostly on par, without these PP will be faster than TP or ZeRO. The degree of TP may also make a difference. Best to experiment to find the winner on your particular setup.</p> <p>TP is almost always used within a single node. That is TP size &lt;= gpus per node.</p></li></ol></li> <li><p>Largest Layer not fitting into a single GPU:</p> <ol><li>If not using ZeRO - must use TP, as PP alone won’t be able to fit.</li> <li>With ZeRO see the same entry for “Single GPU” above</li></ol></li>",Ka,os,Nh="<strong>⇨ Multi-Node / Multi-GPU</strong>",eo,rs,$h="<li><p>When you have fast inter-node connectivity:</p> <ol><li>ZeRO - as it requires close to no modifications to the model</li> <li>PP+TP+DP - less communications, but requires massive changes to the model</li></ol></li> <li><p>when you have slow inter-node connectivity and still low on GPU memory:</p> <ol><li>DP+PP+TP+ZeRO-1</li></ol></li>",to,$s,lo;return F=new x({}),S=new vu({props:{$$slots:{default:[wu]},$$scope:{ctx:Is}}}),Y=new x({}),le=new x({}),oe=new x({}),pe=new x({}),De=new Es({props:{code:"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",highlighted:`
<span class="hljs-comment"># DP</span>
<span class="hljs-string">rm</span> -<span class="hljs-string">r</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span>; <span class="hljs-string">CUDA_VISIBLE_DEVICES</span>=<span class="hljs-string">0</span>,<span class="hljs-string">1</span> \\
<span class="hljs-string">python</span> <span class="hljs-string">examples</span>/<span class="hljs-string">pytorch</span>/<span class="hljs-string">language-modeling</span>/<span class="hljs-string">run_clm</span>.<span class="hljs-string">py</span> \\
<span class="hljs-built_in">--model_name_or_path</span> <span class="hljs-string">gpt2</span> <span class="hljs-built_in">--dataset_name</span> <span class="hljs-string">wikitext</span> <span class="hljs-built_in">--dataset_config_name</span> <span class="hljs-string">wikitext-2-raw-v1</span> \\
<span class="hljs-built_in">--do_train</span> <span class="hljs-built_in">--output_dir</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span> <span class="hljs-built_in">--per_device_train_batch_size</span> <span class="hljs-string">4</span> <span class="hljs-built_in">--max_steps</span> <span class="hljs-string">200</span>

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-string">110</span>.<span class="hljs-string">5948</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-string">1</span>.<span class="hljs-string">808</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-string">0</span>.<span class="hljs-string">69</span>}

<span class="hljs-comment"># DDP w/ NVlink</span>
<span class="hljs-string">rm</span> -<span class="hljs-string">r</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span>; <span class="hljs-string">CUDA_VISIBLE_DEVICES</span>=<span class="hljs-string">0</span>,<span class="hljs-string">1</span> \\
<span class="hljs-string">python</span> -<span class="hljs-string">m</span> <span class="hljs-string">torch</span>.<span class="hljs-string">distributed</span>.<span class="hljs-string">launch</span> <span class="hljs-built_in">--nproc_per_node</span> <span class="hljs-string">2</span> <span class="hljs-string">examples</span>/<span class="hljs-string">pytorch</span>/<span class="hljs-string">language-modeling</span>/<span class="hljs-string">run_clm</span>.<span class="hljs-string">py</span> \\
<span class="hljs-built_in">--model_name_or_path</span> <span class="hljs-string">gpt2</span> <span class="hljs-built_in">--dataset_name</span> <span class="hljs-string">wikitext</span> <span class="hljs-built_in">--dataset_config_name</span> <span class="hljs-string">wikitext-2-raw-v1</span> \\
<span class="hljs-built_in">--do_train</span> <span class="hljs-built_in">--output_dir</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span> <span class="hljs-built_in">--per_device_train_batch_size</span> <span class="hljs-string">4</span> <span class="hljs-built_in">--max_steps</span> <span class="hljs-string">200</span>

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-string">101</span>.<span class="hljs-string">9003</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-string">1</span>.<span class="hljs-string">963</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-string">0</span>.<span class="hljs-string">69</span>}

<span class="hljs-comment"># DDP w/o NVlink</span>
<span class="hljs-string">rm</span> -<span class="hljs-string">r</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span>; <span class="hljs-string">NCCL_P2P_DISABLE</span>=<span class="hljs-string">1</span> <span class="hljs-string">CUDA_VISIBLE_DEVICES</span>=<span class="hljs-string">0</span>,<span class="hljs-string">1</span> \\
<span class="hljs-string">python</span> -<span class="hljs-string">m</span> <span class="hljs-string">torch</span>.<span class="hljs-string">distributed</span>.<span class="hljs-string">launch</span> <span class="hljs-built_in">--nproc_per_node</span> <span class="hljs-string">2</span> <span class="hljs-string">examples</span>/<span class="hljs-string">pytorch</span>/<span class="hljs-string">language-modeling</span>/<span class="hljs-string">run_clm</span>.<span class="hljs-string">py</span> \\
<span class="hljs-built_in">--model_name_or_path</span> <span class="hljs-string">gpt2</span> <span class="hljs-built_in">--dataset_name</span> <span class="hljs-string">wikitext</span> <span class="hljs-built_in">--dataset_config_name</span> <span class="hljs-string">wikitext-2-raw-v1</span> \\
<span class="hljs-built_in">--do_train</span> <span class="hljs-built_in">--output_dir</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span> <span class="hljs-built_in">--per_device_train_batch_size</span> <span class="hljs-string">4</span> <span class="hljs-built_in">--max_steps</span> <span class="hljs-string">200</span>

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-string">131</span>.<span class="hljs-string">4367</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-string">1</span>.<span class="hljs-string">522</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-string">0</span>.<span class="hljs-string">69</span>}`,wrap:!1}}),He=new x({}),$e=new Es({props:{code:"TGElMjAlN0MlMjBMYiUyMCU3QyUyMExjJTBBLS0tJTdDLS0tLSU3Qy0tLSUwQWEwJTIwJTdDJTIwYjAlMjAlN0MlMjBjMCUwQWExJTIwJTdDJTIwYjElMjAlN0MlMjBjMSUwQWEyJTIwJTdDJTIwYjIlMjAlN0MlMjBjMg==",highlighted:`La |<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a0 </span>|<span class="hljs-string"> b0 </span>|<span class="hljs-string"> c0
a1 </span>|<span class="hljs-string"> b1 </span>|<span class="hljs-string"> c1
a2 </span>|<span class="hljs-string"> b2 </span>|<span class="hljs-string"> c2</span>`,wrap:!1}}),Ae=new Es({props:{code:"R1BVMCUzQSUwQUxhJTIwJTdDJTIwTGIlMjAlN0MlMjBMYyUwQS0tLSU3Qy0tLS0lN0MtLS0lMEFhMCUyMCU3QyUyMGIwJTIwJTdDJTIwYzAlMEElMEFHUFUxJTNBJTBBTGElMjAlN0MlMjBMYiUyMCU3QyUyMExjJTBBLS0tJTdDLS0tLSU3Qy0tLSUwQWExJTIwJTdDJTIwYjElMjAlN0MlMjBjMSUwQSUwQUdQVTIlM0ElMEFMYSUyMCU3QyUyMExiJTIwJTdDJTIwTGMlMEEtLS0lN0MtLS0tJTdDLS0tJTBBYTIlMjAlN0MlMjBiMiUyMCU3QyUyMGMy",highlighted:`GPU0:
La |<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a0 </span>|<span class="hljs-string"> b0 </span>|<span class="hljs-string"> c0

GPU1:
La </span>|<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a1 </span>|<span class="hljs-string"> b1 </span>|<span class="hljs-string"> c1

GPU2:
La </span>|<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a2 </span>|<span class="hljs-string"> b2 </span>|<span class="hljs-string"> c2</span>`,wrap:!1}}),Qe=new Es({props:{code:"eDAlMjAlM0QlM0UlMjBHUFUwJTBBeDElMjAlM0QlM0UlMjBHUFUxJTBBeDIlMjAlM0QlM0UlMjBHUFUy",highlighted:`<span class="hljs-attribute">x0</span> <span class="hljs-operator">=</span>&gt; GPU0
<span class="hljs-attribute">x1</span> <span class="hljs-operator">=</span>&gt; GPU1
<span class="hljs-attribute">x2</span> <span class="hljs-operator">=</span>&gt; GPU2`,wrap:!1}}),at=new x({}),pt=new Es({props:{code:"JTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTIwJTIwJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTBBJTdDJTIwJTIwMCUyMCU3QyUyMDElMjAlN0MlMjAyJTIwJTdDJTIwMyUyMCUyMCU3QyUyMCUyMCU3QyUyMCUyMDQlMjAlN0MlMjA1JTIwJTdDJTIwNiUyMCU3QyUyMDclMjAlMjAlN0MlMEElM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlMjAlMjAlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBncHUwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ3B1MQ==",highlighted:`===================  ===================
|<span class="hljs-string">  0 </span>|<span class="hljs-string"> 1 </span>|<span class="hljs-string"> 2 </span>|<span class="hljs-string"> 3  </span>|<span class="hljs-string">  </span>|<span class="hljs-string">  4 </span>|<span class="hljs-string"> 5 </span>|<span class="hljs-string"> 6 </span>|<span class="hljs-string"> 7  </span>|
===================  ===================
        gpu0                 gpu1`,wrap:!1}}),Qt=new x({}),ol=new x({}),ml=new x({}),bl=new x({}),Sl=new x({}),es=new x({}),{c(){g=n("meta"),X=a(),P=n("p"),hs=a(),y=n("h1"),G=n("a"),Ts=n("span"),d(F.$$.fragment),vo=a(),us=n("span"),us.textContent=Uo,As=a(),O=n("p"),O.textContent=ko,zs=a(),d(S.$$.fragment),Bs=a(),q=n("p"),q.textContent=Do,Qs=a(),M=n("h2"),N=n("a"),Cs=n("span"),d(Y.$$.fragment),wo=a(),ds=n("span"),ds.textContent=Jo,Zs=a(),K=n("p"),K.textContent=Ho,Rs=a(),ee=n("ol"),ee.innerHTML=Go,Vs=a(),te=n("p"),te.textContent=So,Ws=a(),b=n("h2"),$=n("a"),_s=n("span"),d(le.$$.fragment),go=a(),fs=n("span"),fs.textContent=No,Xs=a(),se=n("p"),se.innerHTML=$o,Fs=a(),ne=n("ul"),ne.innerHTML=Eo,Os=a(),ie=n("p"),ie.innerHTML=Io,qs=a(),ae=n("ul"),ae.innerHTML=Ao,Ys=a(),T=n("h2"),E=n("a"),js=n("span"),d(oe.$$.fragment),xo=a(),cs=n("span"),cs.textContent=zo,Ks=a(),re=n("p"),re.innerHTML=Bo,en=a(),C=n("h3"),I=n("a"),Ls=n("span"),d(pe.$$.fragment),Po=a(),ms=n("span"),ms.textContent=Qo,tn=a(),he=n("p"),he.innerHTML=Zo,ln=a(),ue=n("ul"),ue.innerHTML=Ro,sn=a(),de=n("p"),de.textContent=Vo,nn=a(),fe=n("p"),fe.innerHTML=Wo,an=a(),ce=n("ul"),ce.innerHTML=Xo,on=a(),me=n("p"),me.innerHTML=Fo,rn=a(),ve=n("p"),ve.textContent=Oo,pn=a(),we=n("ol"),we.innerHTML=qo,hn=a(),ge=n("p"),ge.textContent=Yo,un=a(),xe=n("p"),xe.innerHTML=Ko,dn=a(),Pe=n("p"),Pe.textContent=er,fn=a(),ye=n("p"),ye.textContent=tr,cn=a(),Me=n("p"),Me.textContent=lr,mn=a(),be=n("p"),be.innerHTML=sr,vn=a(),Te=n("p"),Te.textContent=nr,wn=a(),Ce=n("table"),Ce.innerHTML=ir,gn=a(),_e=n("p"),_e.textContent=ar,xn=a(),je=n("p"),je.textContent=or,Pn=a(),Le=n("p"),Le.textContent=rr,yn=a(),Ue=n("p"),Ue.textContent=pr,Mn=a(),ke=n("p"),ke.innerHTML=hr,bn=a(),d(De.$$.fragment),Tn=a(),Je=n("p"),Je.innerHTML=ur,Cn=a(),_=n("h2"),A=n("a"),Us=n("span"),d(He.$$.fragment),yo=a(),vs=n("span"),vs.textContent=dr,_n=a(),Ge=n("p"),Ge.innerHTML=fr,jn=a(),Se=n("p"),Se.innerHTML=cr,Ln=a(),Ne=n("p"),Ne.textContent=mr,Un=a(),d($e.$$.fragment),kn=a(),Ee=n("p"),Ee.textContent=vr,Dn=a(),Ie=n("p"),Ie.textContent=wr,Jn=a(),d(Ae.$$.fragment),Hn=a(),ze=n("p"),ze.textContent=gr,Gn=a(),Be=n("p"),Be.textContent=xr,Sn=a(),d(Qe.$$.fragment),Nn=a(),Ze=n("p"),Ze.textContent=Pr,$n=a(),Re=n("p"),Re.textContent=yr,En=a(),Ve=n("p"),Ve.textContent=Mr,In=a(),We=n("p"),We.textContent=br,An=a(),Xe=n("p"),Xe.textContent=Tr,zn=a(),Fe=n("p"),Fe.textContent=Cr,Bn=a(),Oe=n("p"),Oe.textContent=_r,Qn=a(),qe=n("p"),qe.textContent=jr,Zn=a(),Ye=n("p"),Ye.textContent=Lr,Rn=a(),Ke=n("ol"),Ke.innerHTML=Ur,Vn=a(),et=n("p"),et.textContent=kr,Wn=a(),tt=n("p"),tt.textContent=Dr,Xn=a(),lt=n("p"),lt.textContent=Jr,Fn=a(),st=n("p"),st.textContent=Hr,On=a(),nt=n("p"),nt.textContent=Gr,qn=a(),it=n("ul"),it.innerHTML=Sr,Yn=a(),j=n("h2"),z=n("a"),ks=n("span"),d(at.$$.fragment),Mo=a(),ws=n("span"),ws.textContent=Nr,Kn=a(),ot=n("p"),ot.innerHTML=$r,ei=a(),rt=n("p"),rt.textContent=Er,ti=a(),d(pt.$$.fragment),li=a(),ht=n("p"),ht.textContent=Ir,si=a(),ut=n("p"),ut.textContent=Ar,ni=a(),dt=n("p"),dt.textContent=zr,ii=a(),ft=n("p"),ft.textContent=Br,ai=a(),ct=n("ul"),ct.innerHTML=Qr,oi=a(),mt=n("p"),mt.textContent=Zr,ri=a(),vt=n("p"),vt.innerHTML=Rr,pi=a(),wt=n("p"),wt.innerHTML=Vr,hi=a(),gt=n("p"),gt.textContent=Wr,ui=a(),xt=n("p"),xt.textContent=Xr,di=a(),Pt=n("p"),Pt.innerHTML=Fr,fi=a(),yt=n("p"),yt.innerHTML=Or,ci=a(),Mt=n("p"),Mt.innerHTML=qr,mi=a(),bt=n("p"),bt.innerHTML=Yr,vi=a(),Tt=n("p"),Tt.textContent=Kr,wi=a(),Ct=n("p"),Ct.innerHTML=ep,gi=a(),_t=n("p"),_t.innerHTML=tp,xi=a(),jt=n("p"),jt.textContent=lp,Pi=a(),Lt=n("p"),Lt.textContent=sp,yi=a(),Ut=n("ul"),Ut.innerHTML=np,Mi=a(),kt=n("p"),kt.textContent=ip,bi=a(),Dt=n("ul"),Dt.innerHTML=ap,Ti=a(),Jt=n("p"),Jt.textContent=op,Ci=a(),Ht=n("ul"),Ht.innerHTML=rp,_i=a(),Gt=n("p"),Gt.textContent=pp,ji=a(),St=n("p"),St.textContent=hp,Li=a(),Nt=n("ul"),Nt.innerHTML=up,Ui=a(),$t=n("p"),$t.innerHTML=dp,ki=a(),Et=n("p"),Et.textContent=fp,Di=a(),It=n("p"),It.innerHTML=cp,Ji=a(),At=n("p"),At.textContent=mp,Hi=a(),zt=n("p"),zt.textContent=vp,Gi=a(),Bt=n("p"),Bt.innerHTML=wp,Si=a(),L=n("h2"),B=n("a"),Ds=n("span"),d(Qt.$$.fragment),bo=a(),gs=n("span"),gs.textContent=gp,Ni=a(),Zt=n("p"),Zt.textContent=xp,$i=a(),Rt=n("p"),Rt.innerHTML=Pp,Ei=a(),Vt=n("p"),Vt.innerHTML=yp,Ii=a(),Wt=n("p"),Wt.innerHTML=Mp,Ai=a(),Xt=n("p"),Xt.innerHTML=bp,zi=a(),Ft=n("p"),Ft.innerHTML=Tp,Bi=a(),Ot=n("p"),Ot.innerHTML=Cp,Qi=a(),qt=n("p"),qt.innerHTML=_p,Zi=a(),Yt=n("p"),Yt.textContent=jp,Ri=a(),Kt=n("p"),Kt.innerHTML=Lp,Vi=a(),el=n("p"),el.textContent=Up,Wi=a(),tl=n("p"),tl.textContent=kp,Xi=a(),ll=n("ul"),ll.innerHTML=Dp,Fi=a(),sl=n("p"),sl.textContent=Jp,Oi=a(),nl=n("ul"),nl.innerHTML=Hp,qi=a(),il=n("p"),il.textContent=Gp,Yi=a(),al=n("ul"),al.innerHTML=Sp,Ki=a(),U=n("h2"),Q=n("a"),Js=n("span"),d(ol.$$.fragment),To=a(),xs=n("span"),xs.textContent=Np,ea=a(),rl=n("p"),rl.innerHTML=$p,ta=a(),pl=n("p"),pl.innerHTML=Ep,la=a(),hl=n("p"),hl.textContent=Ip,sa=a(),ul=n("p"),ul.textContent=Ap,na=a(),dl=n("p"),dl.textContent=zp,ia=a(),fl=n("ul"),fl.innerHTML=Bp,aa=a(),cl=n("p"),cl.textContent=Qp,oa=a(),k=n("h2"),Z=n("a"),Hs=n("span"),d(ml.$$.fragment),Co=a(),Ps=n("span"),Ps.textContent=Zp,ra=a(),vl=n("p"),vl.textContent=Rp,pa=a(),wl=n("p"),wl.innerHTML=Vp,ha=a(),gl=n("p"),gl.innerHTML=Wp,ua=a(),xl=n("p"),xl.textContent=Xp,da=a(),Pl=n("p"),Pl.textContent=Fp,fa=a(),yl=n("ul"),yl.innerHTML=Op,ca=a(),Ml=n("p"),Ml.textContent=qp,ma=a(),D=n("h2"),R=n("a"),Gs=n("span"),d(bl.$$.fragment),_o=a(),ys=n("span"),ys.textContent=Yp,va=a(),Tl=n("p"),Tl.innerHTML=Kp,wa=a(),Cl=n("p"),Cl.textContent=eh,ga=a(),_l=n("p"),_l.textContent=th,xa=a(),jl=n("p"),jl.innerHTML=lh,Pa=a(),Ll=n("p"),Ll.textContent=sh,ya=a(),Ul=n("p"),Ul.textContent=nh,Ma=a(),kl=n("p"),kl.textContent=ih,ba=a(),Dl=n("ul"),Dl.innerHTML=ah,Ta=a(),Jl=n("p"),Jl.textContent=oh,Ca=a(),Hl=n("ul"),Hl.innerHTML=rh,_a=a(),Gl=n("p"),Gl.textContent=ph,ja=a(),J=n("h2"),V=n("a"),Ss=n("span"),d(Sl.$$.fragment),jo=a(),Ms=n("span"),Ms.textContent=hh,La=a(),Nl=n("p"),Nl.innerHTML=uh,Ua=a(),$l=n("p"),$l.innerHTML=dh,ka=a(),El=n("p"),El.textContent=fh,Da=a(),Il=n("ol"),Il.innerHTML=ch,Ja=a(),Al=n("p"),Al.textContent=mh,Ha=a(),zl=n("ul"),zl.innerHTML=vh,Ga=a(),Bl=n("p"),Bl.textContent=wh,Sa=a(),Ql=n("ul"),Ql.innerHTML=gh,Na=a(),Zl=n("p"),Zl.textContent=xh,$a=a(),Rl=n("ul"),Rl.innerHTML=Ph,Ea=a(),Vl=n("p"),Vl.textContent=yh,Ia=a(),Wl=n("ul"),Wl.innerHTML=Mh,Aa=a(),Xl=n("p"),Xl.textContent=bh,za=a(),Fl=n("p"),Fl.innerHTML=Th,Ba=a(),Ol=n("p"),Ol.textContent=Ch,Qa=a(),ql=n("p"),ql.textContent=_h,Za=a(),Yl=n("p"),Yl.textContent=jh,Ra=a(),Kl=n("p"),Kl.innerHTML=Lh,Va=a(),H=n("h2"),W=n("a"),Ns=n("span"),d(es.$$.fragment),Lo=a(),bs=n("span"),bs.textContent=Uh,Wa=a(),ts=n("p"),ts.textContent=kh,Xa=a(),ls=n("p"),ls.innerHTML=Dh,Fa=a(),ss=n("ul"),ss.innerHTML=Jh,Oa=a(),ns=n("ol"),ns.innerHTML=Hh,qa=a(),is=n("p"),is.innerHTML=Gh,Ya=a(),as=n("ul"),as.innerHTML=Sh,Ka=a(),os=n("p"),os.innerHTML=Nh,eo=a(),rs=n("ul"),rs.innerHTML=$h,to=a(),$s=n("p"),this.h()},l(e){const l=mu("svelte-1phssyn",document.head);g=i(l,"META",{name:!0,content:!0}),l.forEach(t),X=o(e),P=i(e,"P",{}),u(P).forEach(t),hs=o(e),y=i(e,"H1",{class:!0});var ps=u(y);G=i(ps,"A",{id:!0,class:!0,href:!0});var Eh=u(G);Ts=i(Eh,"SPAN",{});var Ih=u(Ts);f(F.$$.fragment,Ih),Ih.forEach(t),Eh.forEach(t),vo=o(ps),us=i(ps,"SPAN",{"data-svelte-h":!0}),r(us)!=="svelte-tyiod8"&&(us.textContent=Uo),ps.forEach(t),As=o(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1rziuzo"&&(O.textContent=ko),zs=o(e),f(S.$$.fragment,e),Bs=o(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-h5m4s0"&&(q.textContent=Do),Qs=o(e),M=i(e,"H2",{class:!0});var so=u(M);N=i(so,"A",{id:!0,class:!0,href:!0});var Ah=u(N);Cs=i(Ah,"SPAN",{});var zh=u(Cs);f(Y.$$.fragment,zh),zh.forEach(t),Ah.forEach(t),wo=o(so),ds=i(so,"SPAN",{"data-svelte-h":!0}),r(ds)!=="svelte-1ca2n0m"&&(ds.textContent=Jo),so.forEach(t),Zs=o(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-pynyh2"&&(K.textContent=Ho),Rs=o(e),ee=i(e,"OL",{"data-svelte-h":!0}),r(ee)!=="svelte-xyghb4"&&(ee.innerHTML=Go),Vs=o(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-bxn59e"&&(te.textContent=So),Ws=o(e),b=i(e,"H2",{class:!0});var no=u(b);$=i(no,"A",{id:!0,class:!0,href:!0});var Bh=u($);_s=i(Bh,"SPAN",{});var Qh=u(_s);f(le.$$.fragment,Qh),Qh.forEach(t),Bh.forEach(t),go=o(no),fs=i(no,"SPAN",{"data-svelte-h":!0}),r(fs)!=="svelte-14benph"&&(fs.textContent=No),no.forEach(t),Xs=o(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-f88duy"&&(se.innerHTML=$o),Fs=o(e),ne=i(e,"UL",{"data-svelte-h":!0}),r(ne)!=="svelte-1yree73"&&(ne.innerHTML=Eo),Os=o(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-kdfi74"&&(ie.innerHTML=Io),qs=o(e),ae=i(e,"UL",{"data-svelte-h":!0}),r(ae)!=="svelte-mgpo8"&&(ae.innerHTML=Ao),Ys=o(e),T=i(e,"H2",{class:!0});var io=u(T);E=i(io,"A",{id:!0,class:!0,href:!0});var Zh=u(E);js=i(Zh,"SPAN",{});var Rh=u(js);f(oe.$$.fragment,Rh),Rh.forEach(t),Zh.forEach(t),xo=o(io),cs=i(io,"SPAN",{"data-svelte-h":!0}),r(cs)!=="svelte-j21lf3"&&(cs.textContent=zo),io.forEach(t),Ks=o(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1fxgfhi"&&(re.innerHTML=Bo),en=o(e),C=i(e,"H3",{class:!0});var ao=u(C);I=i(ao,"A",{id:!0,class:!0,href:!0});var Vh=u(I);Ls=i(Vh,"SPAN",{});var Wh=u(Ls);f(pe.$$.fragment,Wh),Wh.forEach(t),Vh.forEach(t),Po=o(ao),ms=i(ao,"SPAN",{"data-svelte-h":!0}),r(ms)!=="svelte-1l0meho"&&(ms.textContent=Qo),ao.forEach(t),tn=o(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1dfmjsp"&&(he.innerHTML=Zo),ln=o(e),ue=i(e,"UL",{"data-svelte-h":!0}),r(ue)!=="svelte-123r2xc"&&(ue.innerHTML=Ro),sn=o(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1ssfu1g"&&(de.textContent=Vo),nn=o(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1v8b0bi"&&(fe.innerHTML=Wo),an=o(e),ce=i(e,"UL",{"data-svelte-h":!0}),r(ce)!=="svelte-11u6e1m"&&(ce.innerHTML=Xo),on=o(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-2za96j"&&(me.innerHTML=Fo),rn=o(e),ve=i(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1e3g0sm"&&(ve.textContent=Oo),pn=o(e),we=i(e,"OL",{"data-svelte-h":!0}),r(we)!=="svelte-2irogx"&&(we.innerHTML=qo),hn=o(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1lupox0"&&(ge.textContent=Yo),un=o(e),xe=i(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-11l39rn"&&(xe.innerHTML=Ko),dn=o(e),Pe=i(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1mr4sva"&&(Pe.textContent=er),fn=o(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1pi6jp8"&&(ye.textContent=tr),cn=o(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1ivvdh1"&&(Me.textContent=lr),mn=o(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1rep9ix"&&(be.innerHTML=sr),vn=o(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-yxf37j"&&(Te.textContent=nr),wn=o(e),Ce=i(e,"TABLE",{"data-svelte-h":!0}),r(Ce)!=="svelte-1glyygb"&&(Ce.innerHTML=ir),gn=o(e),_e=i(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-gug91c"&&(_e.textContent=ar),xn=o(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-lz5d0e"&&(je.textContent=or),Pn=o(e),Le=i(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-kfwgwv"&&(Le.textContent=rr),yn=o(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-16jny0z"&&(Ue.textContent=pr),Mn=o(e),ke=i(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-hs453n"&&(ke.innerHTML=hr),bn=o(e),f(De.$$.fragment,e),Tn=o(e),Je=i(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-pittpg"&&(Je.innerHTML=ur),Cn=o(e),_=i(e,"H2",{class:!0});var oo=u(_);A=i(oo,"A",{id:!0,class:!0,href:!0});var Xh=u(A);Us=i(Xh,"SPAN",{});var Fh=u(Us);f(He.$$.fragment,Fh),Fh.forEach(t),Xh.forEach(t),yo=o(oo),vs=i(oo,"SPAN",{"data-svelte-h":!0}),r(vs)!=="svelte-hqyxfb"&&(vs.textContent=dr),oo.forEach(t),_n=o(e),Ge=i(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-srae2u"&&(Ge.innerHTML=fr),jn=o(e),Se=i(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-8nwpg0"&&(Se.innerHTML=cr),Ln=o(e),Ne=i(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-13leqhj"&&(Ne.textContent=mr),Un=o(e),f($e.$$.fragment,e),kn=o(e),Ee=i(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-19zx7iu"&&(Ee.textContent=vr),Dn=o(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-vbsuek"&&(Ie.textContent=wr),Jn=o(e),f(Ae.$$.fragment,e),Hn=o(e),ze=i(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-z5lhr7"&&(ze.textContent=gr),Gn=o(e),Be=i(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-k74por"&&(Be.textContent=xr),Sn=o(e),f(Qe.$$.fragment,e),Nn=o(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1bnbo9h"&&(Ze.textContent=Pr),$n=o(e),Re=i(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-2160r6"&&(Re.textContent=yr),En=o(e),Ve=i(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-137i420"&&(Ve.textContent=Mr),In=o(e),We=i(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-fuckbw"&&(We.textContent=br),An=o(e),Xe=i(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-8k7f2v"&&(Xe.textContent=Tr),zn=o(e),Fe=i(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-ka27ai"&&(Fe.textContent=Cr),Bn=o(e),Oe=i(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-sr3f0f"&&(Oe.textContent=_r),Qn=o(e),qe=i(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-13q1vu5"&&(qe.textContent=jr),Zn=o(e),Ye=i(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-j8ab4e"&&(Ye.textContent=Lr),Rn=o(e),Ke=i(e,"OL",{"data-svelte-h":!0}),r(Ke)!=="svelte-6pzgco"&&(Ke.innerHTML=Ur),Vn=o(e),et=i(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1dtp0my"&&(et.textContent=kr),Wn=o(e),tt=i(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-of8cks"&&(tt.textContent=Dr),Xn=o(e),lt=i(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-1qo8w9o"&&(lt.textContent=Jr),Fn=o(e),st=i(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-1r4i3oj"&&(st.textContent=Hr),On=o(e),nt=i(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1b2mzqh"&&(nt.textContent=Gr),qn=o(e),it=i(e,"UL",{"data-svelte-h":!0}),r(it)!=="svelte-1duka0r"&&(it.innerHTML=Sr),Yn=o(e),j=i(e,"H2",{class:!0});var ro=u(j);z=i(ro,"A",{id:!0,class:!0,href:!0});var Oh=u(z);ks=i(Oh,"SPAN",{});var qh=u(ks);f(at.$$.fragment,qh),qh.forEach(t),Oh.forEach(t),Mo=o(ro),ws=i(ro,"SPAN",{"data-svelte-h":!0}),r(ws)!=="svelte-1ubkrz5"&&(ws.textContent=Nr),ro.forEach(t),Kn=o(e),ot=i(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-1pxnuea"&&(ot.innerHTML=$r),ei=o(e),rt=i(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-wezc9q"&&(rt.textContent=Er),ti=o(e),f(pt.$$.fragment,e),li=o(e),ht=i(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-qijq4u"&&(ht.textContent=Ir),si=o(e),ut=i(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-4g6pcw"&&(ut.textContent=Ar),ni=o(e),dt=i(e,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-1xu2x6q"&&(dt.textContent=zr),ii=o(e),ft=i(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-1n10xu2"&&(ft.textContent=Br),ai=o(e),ct=i(e,"UL",{"data-svelte-h":!0}),r(ct)!=="svelte-988mfp"&&(ct.innerHTML=Qr),oi=o(e),mt=i(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-1fevjqr"&&(mt.textContent=Zr),ri=o(e),vt=i(e,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-b4pgks"&&(vt.innerHTML=Rr),pi=o(e),wt=i(e,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-1q7hzge"&&(wt.innerHTML=Vr),hi=o(e),gt=i(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-1g83j3f"&&(gt.textContent=Wr),ui=o(e),xt=i(e,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-1vo2jyy"&&(xt.textContent=Xr),di=o(e),Pt=i(e,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-1hgi2en"&&(Pt.innerHTML=Fr),fi=o(e),yt=i(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-1736ap5"&&(yt.innerHTML=Or),ci=o(e),Mt=i(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-1adhphn"&&(Mt.innerHTML=qr),mi=o(e),bt=i(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-muana1"&&(bt.innerHTML=Yr),vi=o(e),Tt=i(e,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-m941ob"&&(Tt.textContent=Kr),wi=o(e),Ct=i(e,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-4yeq43"&&(Ct.innerHTML=ep),gi=o(e),_t=i(e,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-1u0vuag"&&(_t.innerHTML=tp),xi=o(e),jt=i(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-14w2s8c"&&(jt.textContent=lp),Pi=o(e),Lt=i(e,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-j65mcd"&&(Lt.textContent=sp),yi=o(e),Ut=i(e,"UL",{"data-svelte-h":!0}),r(Ut)!=="svelte-1m54oo0"&&(Ut.innerHTML=np),Mi=o(e),kt=i(e,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-oykhtz"&&(kt.textContent=ip),bi=o(e),Dt=i(e,"UL",{"data-svelte-h":!0}),r(Dt)!=="svelte-n2xihd"&&(Dt.innerHTML=ap),Ti=o(e),Jt=i(e,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-1wdbk4x"&&(Jt.textContent=op),Ci=o(e),Ht=i(e,"UL",{"data-svelte-h":!0}),r(Ht)!=="svelte-q8rblb"&&(Ht.innerHTML=rp),_i=o(e),Gt=i(e,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-w4skeu"&&(Gt.textContent=pp),ji=o(e),St=i(e,"P",{"data-svelte-h":!0}),r(St)!=="svelte-1b2mzqh"&&(St.textContent=hp),Li=o(e),Nt=i(e,"UL",{"data-svelte-h":!0}),r(Nt)!=="svelte-yzvtut"&&(Nt.innerHTML=up),Ui=o(e),$t=i(e,"P",{"data-svelte-h":!0}),r($t)!=="svelte-wo41ed"&&($t.innerHTML=dp),ki=o(e),Et=i(e,"P",{"data-svelte-h":!0}),r(Et)!=="svelte-1djad0c"&&(Et.textContent=fp),Di=o(e),It=i(e,"P",{"data-svelte-h":!0}),r(It)!=="svelte-1rlh20n"&&(It.innerHTML=cp),Ji=o(e),At=i(e,"P",{"data-svelte-h":!0}),r(At)!=="svelte-eeo3o2"&&(At.textContent=mp),Hi=o(e),zt=i(e,"P",{"data-svelte-h":!0}),r(zt)!=="svelte-tt8ebp"&&(zt.textContent=vp),Gi=o(e),Bt=i(e,"P",{"data-svelte-h":!0}),r(Bt)!=="svelte-1ddaj59"&&(Bt.innerHTML=wp),Si=o(e),L=i(e,"H2",{class:!0});var po=u(L);B=i(po,"A",{id:!0,class:!0,href:!0});var Yh=u(B);Ds=i(Yh,"SPAN",{});var Kh=u(Ds);f(Qt.$$.fragment,Kh),Kh.forEach(t),Yh.forEach(t),bo=o(po),gs=i(po,"SPAN",{"data-svelte-h":!0}),r(gs)!=="svelte-5podt8"&&(gs.textContent=gp),po.forEach(t),Ni=o(e),Zt=i(e,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-rq0mtj"&&(Zt.textContent=xp),$i=o(e),Rt=i(e,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-kmqtuy"&&(Rt.innerHTML=Pp),Ei=o(e),Vt=i(e,"P",{"data-svelte-h":!0}),r(Vt)!=="svelte-kx5fsx"&&(Vt.innerHTML=yp),Ii=o(e),Wt=i(e,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-inc4wa"&&(Wt.innerHTML=Mp),Ai=o(e),Xt=i(e,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-hnmqxg"&&(Xt.innerHTML=bp),zi=o(e),Ft=i(e,"P",{"data-svelte-h":!0}),r(Ft)!=="svelte-121l99q"&&(Ft.innerHTML=Tp),Bi=o(e),Ot=i(e,"P",{"data-svelte-h":!0}),r(Ot)!=="svelte-wx20wp"&&(Ot.innerHTML=Cp),Qi=o(e),qt=i(e,"P",{"data-svelte-h":!0}),r(qt)!=="svelte-p22xej"&&(qt.innerHTML=_p),Zi=o(e),Yt=i(e,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-16v636l"&&(Yt.textContent=jp),Ri=o(e),Kt=i(e,"P",{"data-svelte-h":!0}),r(Kt)!=="svelte-hmoxa9"&&(Kt.innerHTML=Lp),Vi=o(e),el=i(e,"P",{"data-svelte-h":!0}),r(el)!=="svelte-xqarbt"&&(el.textContent=Up),Wi=o(e),tl=i(e,"P",{"data-svelte-h":!0}),r(tl)!=="svelte-1ma7lah"&&(tl.textContent=kp),Xi=o(e),ll=i(e,"UL",{"data-svelte-h":!0}),r(ll)!=="svelte-1udq7jy"&&(ll.innerHTML=Dp),Fi=o(e),sl=i(e,"P",{"data-svelte-h":!0}),r(sl)!=="svelte-1b2mzqh"&&(sl.textContent=Jp),Oi=o(e),nl=i(e,"UL",{"data-svelte-h":!0}),r(nl)!=="svelte-sudg8s"&&(nl.innerHTML=Hp),qi=o(e),il=i(e,"P",{"data-svelte-h":!0}),r(il)!=="svelte-1g6ovc1"&&(il.textContent=Gp),Yi=o(e),al=i(e,"UL",{"data-svelte-h":!0}),r(al)!=="svelte-13k8bts"&&(al.innerHTML=Sp),Ki=o(e),U=i(e,"H2",{class:!0});var ho=u(U);Q=i(ho,"A",{id:!0,class:!0,href:!0});var eu=u(Q);Js=i(eu,"SPAN",{});var tu=u(Js);f(ol.$$.fragment,tu),tu.forEach(t),eu.forEach(t),To=o(ho),xs=i(ho,"SPAN",{"data-svelte-h":!0}),r(xs)!=="svelte-e1rqse"&&(xs.textContent=Np),ho.forEach(t),ea=o(e),rl=i(e,"P",{"data-svelte-h":!0}),r(rl)!=="svelte-iiww3g"&&(rl.innerHTML=$p),ta=o(e),pl=i(e,"P",{"data-svelte-h":!0}),r(pl)!=="svelte-qmcl9c"&&(pl.innerHTML=Ep),la=o(e),hl=i(e,"P",{"data-svelte-h":!0}),r(hl)!=="svelte-oj250q"&&(hl.textContent=Ip),sa=o(e),ul=i(e,"P",{"data-svelte-h":!0}),r(ul)!=="svelte-4rkar7"&&(ul.textContent=Ap),na=o(e),dl=i(e,"P",{"data-svelte-h":!0}),r(dl)!=="svelte-1b2mzqh"&&(dl.textContent=zp),ia=o(e),fl=i(e,"UL",{"data-svelte-h":!0}),r(fl)!=="svelte-1ry6c7"&&(fl.innerHTML=Bp),aa=o(e),cl=i(e,"P",{"data-svelte-h":!0}),r(cl)!=="svelte-9dc2gy"&&(cl.textContent=Qp),oa=o(e),k=i(e,"H2",{class:!0});var uo=u(k);Z=i(uo,"A",{id:!0,class:!0,href:!0});var lu=u(Z);Hs=i(lu,"SPAN",{});var su=u(Hs);f(ml.$$.fragment,su),su.forEach(t),lu.forEach(t),Co=o(uo),Ps=i(uo,"SPAN",{"data-svelte-h":!0}),r(Ps)!=="svelte-1bbbduz"&&(Ps.textContent=Zp),uo.forEach(t),ra=o(e),vl=i(e,"P",{"data-svelte-h":!0}),r(vl)!=="svelte-fz9fyw"&&(vl.textContent=Rp),pa=o(e),wl=i(e,"P",{"data-svelte-h":!0}),r(wl)!=="svelte-18rdwc7"&&(wl.innerHTML=Vp),ha=o(e),gl=i(e,"P",{"data-svelte-h":!0}),r(gl)!=="svelte-18bvwlv"&&(gl.innerHTML=Wp),ua=o(e),xl=i(e,"P",{"data-svelte-h":!0}),r(xl)!=="svelte-1hp29wn"&&(xl.textContent=Xp),da=o(e),Pl=i(e,"P",{"data-svelte-h":!0}),r(Pl)!=="svelte-1b2mzqh"&&(Pl.textContent=Fp),fa=o(e),yl=i(e,"UL",{"data-svelte-h":!0}),r(yl)!=="svelte-3ic0jq"&&(yl.innerHTML=Op),ca=o(e),Ml=i(e,"P",{"data-svelte-h":!0}),r(Ml)!=="svelte-r6xwz8"&&(Ml.textContent=qp),ma=o(e),D=i(e,"H2",{class:!0});var fo=u(D);R=i(fo,"A",{id:!0,class:!0,href:!0});var nu=u(R);Gs=i(nu,"SPAN",{});var iu=u(Gs);f(bl.$$.fragment,iu),iu.forEach(t),nu.forEach(t),_o=o(fo),ys=i(fo,"SPAN",{"data-svelte-h":!0}),r(ys)!=="svelte-19byuaz"&&(ys.textContent=Yp),fo.forEach(t),va=o(e),Tl=i(e,"P",{"data-svelte-h":!0}),r(Tl)!=="svelte-ohkord"&&(Tl.innerHTML=Kp),wa=o(e),Cl=i(e,"P",{"data-svelte-h":!0}),r(Cl)!=="svelte-172u2n6"&&(Cl.textContent=eh),ga=o(e),_l=i(e,"P",{"data-svelte-h":!0}),r(_l)!=="svelte-16eyfr0"&&(_l.textContent=th),xa=o(e),jl=i(e,"P",{"data-svelte-h":!0}),r(jl)!=="svelte-rdhflp"&&(jl.innerHTML=lh),Pa=o(e),Ll=i(e,"P",{"data-svelte-h":!0}),r(Ll)!=="svelte-q3kikv"&&(Ll.textContent=sh),ya=o(e),Ul=i(e,"P",{"data-svelte-h":!0}),r(Ul)!=="svelte-s2rtor"&&(Ul.textContent=nh),Ma=o(e),kl=i(e,"P",{"data-svelte-h":!0}),r(kl)!=="svelte-1b2mzqh"&&(kl.textContent=ih),ba=o(e),Dl=i(e,"UL",{"data-svelte-h":!0}),r(Dl)!=="svelte-o5zp0z"&&(Dl.innerHTML=ah),Ta=o(e),Jl=i(e,"P",{"data-svelte-h":!0}),r(Jl)!=="svelte-1grbiex"&&(Jl.textContent=oh),Ca=o(e),Hl=i(e,"UL",{"data-svelte-h":!0}),r(Hl)!=="svelte-1oyel1u"&&(Hl.innerHTML=rh),_a=o(e),Gl=i(e,"P",{"data-svelte-h":!0}),r(Gl)!=="svelte-r6xwz8"&&(Gl.textContent=ph),ja=o(e),J=i(e,"H2",{class:!0});var co=u(J);V=i(co,"A",{id:!0,class:!0,href:!0});var au=u(V);Ss=i(au,"SPAN",{});var ou=u(Ss);f(Sl.$$.fragment,ou),ou.forEach(t),au.forEach(t),jo=o(co),Ms=i(co,"SPAN",{"data-svelte-h":!0}),r(Ms)!=="svelte-1bqh76s"&&(Ms.textContent=hh),co.forEach(t),La=o(e),Nl=i(e,"P",{"data-svelte-h":!0}),r(Nl)!=="svelte-121cfuq"&&(Nl.innerHTML=uh),Ua=o(e),$l=i(e,"P",{"data-svelte-h":!0}),r($l)!=="svelte-dou7hg"&&($l.innerHTML=dh),ka=o(e),El=i(e,"P",{"data-svelte-h":!0}),r(El)!=="svelte-oa098n"&&(El.textContent=fh),Da=o(e),Il=i(e,"OL",{"data-svelte-h":!0}),r(Il)!=="svelte-6cxs64"&&(Il.innerHTML=ch),Ja=o(e),Al=i(e,"P",{"data-svelte-h":!0}),r(Al)!=="svelte-kvfsh7"&&(Al.textContent=mh),Ha=o(e),zl=i(e,"UL",{"data-svelte-h":!0}),r(zl)!=="svelte-1734ihx"&&(zl.innerHTML=vh),Ga=o(e),Bl=i(e,"P",{"data-svelte-h":!0}),r(Bl)!=="svelte-jsce61"&&(Bl.textContent=wh),Sa=o(e),Ql=i(e,"UL",{"data-svelte-h":!0}),r(Ql)!=="svelte-ilmkvr"&&(Ql.innerHTML=gh),Na=o(e),Zl=i(e,"P",{"data-svelte-h":!0}),r(Zl)!=="svelte-1mjyx54"&&(Zl.textContent=xh),$a=o(e),Rl=i(e,"UL",{"data-svelte-h":!0}),r(Rl)!=="svelte-dyjda9"&&(Rl.innerHTML=Ph),Ea=o(e),Vl=i(e,"P",{"data-svelte-h":!0}),r(Vl)!=="svelte-1qwl5bi"&&(Vl.textContent=yh),Ia=o(e),Wl=i(e,"UL",{"data-svelte-h":!0}),r(Wl)!=="svelte-bzftse"&&(Wl.innerHTML=Mh),Aa=o(e),Xl=i(e,"P",{"data-svelte-h":!0}),r(Xl)!=="svelte-pn1yl1"&&(Xl.textContent=bh),za=o(e),Fl=i(e,"P",{"data-svelte-h":!0}),r(Fl)!=="svelte-k8js9g"&&(Fl.innerHTML=Th),Ba=o(e),Ol=i(e,"P",{"data-svelte-h":!0}),r(Ol)!=="svelte-6pmm5n"&&(Ol.textContent=Ch),Qa=o(e),ql=i(e,"P",{"data-svelte-h":!0}),r(ql)!=="svelte-pg911u"&&(ql.textContent=_h),Za=o(e),Yl=i(e,"P",{"data-svelte-h":!0}),r(Yl)!=="svelte-1kiqb4z"&&(Yl.textContent=jh),Ra=o(e),Kl=i(e,"P",{"data-svelte-h":!0}),r(Kl)!=="svelte-1dy3y3g"&&(Kl.innerHTML=Lh),Va=o(e),H=i(e,"H2",{class:!0});var mo=u(H);W=i(mo,"A",{id:!0,class:!0,href:!0});var ru=u(W);Ns=i(ru,"SPAN",{});var pu=u(Ns);f(es.$$.fragment,pu),pu.forEach(t),ru.forEach(t),Lo=o(mo),bs=i(mo,"SPAN",{"data-svelte-h":!0}),r(bs)!=="svelte-aiv881"&&(bs.textContent=Uh),mo.forEach(t),Wa=o(e),ts=i(e,"P",{"data-svelte-h":!0}),r(ts)!=="svelte-1ysb6gs"&&(ts.textContent=kh),Xa=o(e),ls=i(e,"P",{"data-svelte-h":!0}),r(ls)!=="svelte-1ll70nj"&&(ls.innerHTML=Dh),Fa=o(e),ss=i(e,"UL",{"data-svelte-h":!0}),r(ss)!=="svelte-1tk5izf"&&(ss.innerHTML=Jh),Oa=o(e),ns=i(e,"OL",{"data-svelte-h":!0}),r(ns)!=="svelte-im98lt"&&(ns.innerHTML=Hh),qa=o(e),is=i(e,"P",{"data-svelte-h":!0}),r(is)!=="svelte-f88duy"&&(is.innerHTML=Gh),Ya=o(e),as=i(e,"UL",{"data-svelte-h":!0}),r(as)!=="svelte-1yree73"&&(as.innerHTML=Sh),Ka=o(e),os=i(e,"P",{"data-svelte-h":!0}),r(os)!=="svelte-kdfi74"&&(os.innerHTML=Nh),eo=o(e),rs=i(e,"UL",{"data-svelte-h":!0}),r(rs)!=="svelte-mgpo8"&&(rs.innerHTML=$h),to=o(e),$s=i(e,"P",{}),u($s).forEach(t),this.h()},h(){p(g,"name","hf:doc:metadata"),p(g,"content",JSON.stringify(xu)),p(G,"id","efficient-training-on-multiple-gpus"),p(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(G,"href","#efficient-training-on-multiple-gpus"),p(y,"class","relative group"),p(N,"id","concepts"),p(N,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(N,"href","#concepts"),p(M,"class","relative group"),p($,"id","scalability-strategy"),p($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p($,"href","#scalability-strategy"),p(b,"class","relative group"),p(E,"id","data-parallelism"),p(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(E,"href","#data-parallelism"),p(T,"class","relative group"),p(I,"id","dp-vs-ddp"),p(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(I,"href","#dp-vs-ddp"),p(C,"class","relative group"),p(A,"id","zero-data-parallelism"),p(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(A,"href","#zero-data-parallelism"),p(_,"class","relative group"),p(z,"id","naive-model-parallelism-vertical-and-pipeline-parallelism"),p(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(z,"href","#naive-model-parallelism-vertical-and-pipeline-parallelism"),p(j,"class","relative group"),p(B,"id","tensor-parallelism"),p(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(B,"href","#tensor-parallelism"),p(L,"class","relative group"),p(Q,"id","dppp"),p(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Q,"href","#dppp"),p(U,"class","relative group"),p(Z,"id","dppptp"),p(Z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Z,"href","#dppptp"),p(k,"class","relative group"),p(R,"id","zero-dppptp"),p(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(R,"href","#zero-dppptp"),p(D,"class","relative group"),p(V,"id","flexflow"),p(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(V,"href","#flexflow"),p(J,"class","relative group"),p(W,"id","which-strategy-to-use-when"),p(W,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(W,"href","#which-strategy-to-use-when"),p(H,"class","relative group")},m(e,l){h(document.head,g),s(e,X,l),s(e,P,l),s(e,hs,l),s(e,y,l),h(y,G),h(G,Ts),c(F,Ts,null),h(y,vo),h(y,us),s(e,As,l),s(e,O,l),s(e,zs,l),c(S,e,l),s(e,Bs,l),s(e,q,l),s(e,Qs,l),s(e,M,l),h(M,N),h(N,Cs),c(Y,Cs,null),h(M,wo),h(M,ds),s(e,Zs,l),s(e,K,l),s(e,Rs,l),s(e,ee,l),s(e,Vs,l),s(e,te,l),s(e,Ws,l),s(e,b,l),h(b,$),h($,_s),c(le,_s,null),h(b,go),h(b,fs),s(e,Xs,l),s(e,se,l),s(e,Fs,l),s(e,ne,l),s(e,Os,l),s(e,ie,l),s(e,qs,l),s(e,ae,l),s(e,Ys,l),s(e,T,l),h(T,E),h(E,js),c(oe,js,null),h(T,xo),h(T,cs),s(e,Ks,l),s(e,re,l),s(e,en,l),s(e,C,l),h(C,I),h(I,Ls),c(pe,Ls,null),h(C,Po),h(C,ms),s(e,tn,l),s(e,he,l),s(e,ln,l),s(e,ue,l),s(e,sn,l),s(e,de,l),s(e,nn,l),s(e,fe,l),s(e,an,l),s(e,ce,l),s(e,on,l),s(e,me,l),s(e,rn,l),s(e,ve,l),s(e,pn,l),s(e,we,l),s(e,hn,l),s(e,ge,l),s(e,un,l),s(e,xe,l),s(e,dn,l),s(e,Pe,l),s(e,fn,l),s(e,ye,l),s(e,cn,l),s(e,Me,l),s(e,mn,l),s(e,be,l),s(e,vn,l),s(e,Te,l),s(e,wn,l),s(e,Ce,l),s(e,gn,l),s(e,_e,l),s(e,xn,l),s(e,je,l),s(e,Pn,l),s(e,Le,l),s(e,yn,l),s(e,Ue,l),s(e,Mn,l),s(e,ke,l),s(e,bn,l),c(De,e,l),s(e,Tn,l),s(e,Je,l),s(e,Cn,l),s(e,_,l),h(_,A),h(A,Us),c(He,Us,null),h(_,yo),h(_,vs),s(e,_n,l),s(e,Ge,l),s(e,jn,l),s(e,Se,l),s(e,Ln,l),s(e,Ne,l),s(e,Un,l),c($e,e,l),s(e,kn,l),s(e,Ee,l),s(e,Dn,l),s(e,Ie,l),s(e,Jn,l),c(Ae,e,l),s(e,Hn,l),s(e,ze,l),s(e,Gn,l),s(e,Be,l),s(e,Sn,l),c(Qe,e,l),s(e,Nn,l),s(e,Ze,l),s(e,$n,l),s(e,Re,l),s(e,En,l),s(e,Ve,l),s(e,In,l),s(e,We,l),s(e,An,l),s(e,Xe,l),s(e,zn,l),s(e,Fe,l),s(e,Bn,l),s(e,Oe,l),s(e,Qn,l),s(e,qe,l),s(e,Zn,l),s(e,Ye,l),s(e,Rn,l),s(e,Ke,l),s(e,Vn,l),s(e,et,l),s(e,Wn,l),s(e,tt,l),s(e,Xn,l),s(e,lt,l),s(e,Fn,l),s(e,st,l),s(e,On,l),s(e,nt,l),s(e,qn,l),s(e,it,l),s(e,Yn,l),s(e,j,l),h(j,z),h(z,ks),c(at,ks,null),h(j,Mo),h(j,ws),s(e,Kn,l),s(e,ot,l),s(e,ei,l),s(e,rt,l),s(e,ti,l),c(pt,e,l),s(e,li,l),s(e,ht,l),s(e,si,l),s(e,ut,l),s(e,ni,l),s(e,dt,l),s(e,ii,l),s(e,ft,l),s(e,ai,l),s(e,ct,l),s(e,oi,l),s(e,mt,l),s(e,ri,l),s(e,vt,l),s(e,pi,l),s(e,wt,l),s(e,hi,l),s(e,gt,l),s(e,ui,l),s(e,xt,l),s(e,di,l),s(e,Pt,l),s(e,fi,l),s(e,yt,l),s(e,ci,l),s(e,Mt,l),s(e,mi,l),s(e,bt,l),s(e,vi,l),s(e,Tt,l),s(e,wi,l),s(e,Ct,l),s(e,gi,l),s(e,_t,l),s(e,xi,l),s(e,jt,l),s(e,Pi,l),s(e,Lt,l),s(e,yi,l),s(e,Ut,l),s(e,Mi,l),s(e,kt,l),s(e,bi,l),s(e,Dt,l),s(e,Ti,l),s(e,Jt,l),s(e,Ci,l),s(e,Ht,l),s(e,_i,l),s(e,Gt,l),s(e,ji,l),s(e,St,l),s(e,Li,l),s(e,Nt,l),s(e,Ui,l),s(e,$t,l),s(e,ki,l),s(e,Et,l),s(e,Di,l),s(e,It,l),s(e,Ji,l),s(e,At,l),s(e,Hi,l),s(e,zt,l),s(e,Gi,l),s(e,Bt,l),s(e,Si,l),s(e,L,l),h(L,B),h(B,Ds),c(Qt,Ds,null),h(L,bo),h(L,gs),s(e,Ni,l),s(e,Zt,l),s(e,$i,l),s(e,Rt,l),s(e,Ei,l),s(e,Vt,l),s(e,Ii,l),s(e,Wt,l),s(e,Ai,l),s(e,Xt,l),s(e,zi,l),s(e,Ft,l),s(e,Bi,l),s(e,Ot,l),s(e,Qi,l),s(e,qt,l),s(e,Zi,l),s(e,Yt,l),s(e,Ri,l),s(e,Kt,l),s(e,Vi,l),s(e,el,l),s(e,Wi,l),s(e,tl,l),s(e,Xi,l),s(e,ll,l),s(e,Fi,l),s(e,sl,l),s(e,Oi,l),s(e,nl,l),s(e,qi,l),s(e,il,l),s(e,Yi,l),s(e,al,l),s(e,Ki,l),s(e,U,l),h(U,Q),h(Q,Js),c(ol,Js,null),h(U,To),h(U,xs),s(e,ea,l),s(e,rl,l),s(e,ta,l),s(e,pl,l),s(e,la,l),s(e,hl,l),s(e,sa,l),s(e,ul,l),s(e,na,l),s(e,dl,l),s(e,ia,l),s(e,fl,l),s(e,aa,l),s(e,cl,l),s(e,oa,l),s(e,k,l),h(k,Z),h(Z,Hs),c(ml,Hs,null),h(k,Co),h(k,Ps),s(e,ra,l),s(e,vl,l),s(e,pa,l),s(e,wl,l),s(e,ha,l),s(e,gl,l),s(e,ua,l),s(e,xl,l),s(e,da,l),s(e,Pl,l),s(e,fa,l),s(e,yl,l),s(e,ca,l),s(e,Ml,l),s(e,ma,l),s(e,D,l),h(D,R),h(R,Gs),c(bl,Gs,null),h(D,_o),h(D,ys),s(e,va,l),s(e,Tl,l),s(e,wa,l),s(e,Cl,l),s(e,ga,l),s(e,_l,l),s(e,xa,l),s(e,jl,l),s(e,Pa,l),s(e,Ll,l),s(e,ya,l),s(e,Ul,l),s(e,Ma,l),s(e,kl,l),s(e,ba,l),s(e,Dl,l),s(e,Ta,l),s(e,Jl,l),s(e,Ca,l),s(e,Hl,l),s(e,_a,l),s(e,Gl,l),s(e,ja,l),s(e,J,l),h(J,V),h(V,Ss),c(Sl,Ss,null),h(J,jo),h(J,Ms),s(e,La,l),s(e,Nl,l),s(e,Ua,l),s(e,$l,l),s(e,ka,l),s(e,El,l),s(e,Da,l),s(e,Il,l),s(e,Ja,l),s(e,Al,l),s(e,Ha,l),s(e,zl,l),s(e,Ga,l),s(e,Bl,l),s(e,Sa,l),s(e,Ql,l),s(e,Na,l),s(e,Zl,l),s(e,$a,l),s(e,Rl,l),s(e,Ea,l),s(e,Vl,l),s(e,Ia,l),s(e,Wl,l),s(e,Aa,l),s(e,Xl,l),s(e,za,l),s(e,Fl,l),s(e,Ba,l),s(e,Ol,l),s(e,Qa,l),s(e,ql,l),s(e,Za,l),s(e,Yl,l),s(e,Ra,l),s(e,Kl,l),s(e,Va,l),s(e,H,l),h(H,W),h(W,Ns),c(es,Ns,null),h(H,Lo),h(H,bs),s(e,Wa,l),s(e,ts,l),s(e,Xa,l),s(e,ls,l),s(e,Fa,l),s(e,ss,l),s(e,Oa,l),s(e,ns,l),s(e,qa,l),s(e,is,l),s(e,Ya,l),s(e,as,l),s(e,Ka,l),s(e,os,l),s(e,eo,l),s(e,rs,l),s(e,to,l),s(e,$s,l),lo=!0},p(e,[l]){const ps={};l&2&&(ps.$$scope={dirty:l,ctx:e}),S.$set(ps)},i(e){lo||(m(F.$$.fragment,e),m(S.$$.fragment,e),m(Y.$$.fragment,e),m(le.$$.fragment,e),m(oe.$$.fragment,e),m(pe.$$.fragment,e),m(De.$$.fragment,e),m(He.$$.fragment,e),m($e.$$.fragment,e),m(Ae.$$.fragment,e),m(Qe.$$.fragment,e),m(at.$$.fragment,e),m(pt.$$.fragment,e),m(Qt.$$.fragment,e),m(ol.$$.fragment,e),m(ml.$$.fragment,e),m(bl.$$.fragment,e),m(Sl.$$.fragment,e),m(es.$$.fragment,e),lo=!0)},o(e){v(F.$$.fragment,e),v(S.$$.fragment,e),v(Y.$$.fragment,e),v(le.$$.fragment,e),v(oe.$$.fragment,e),v(pe.$$.fragment,e),v(De.$$.fragment,e),v(He.$$.fragment,e),v($e.$$.fragment,e),v(Ae.$$.fragment,e),v(Qe.$$.fragment,e),v(at.$$.fragment,e),v(pt.$$.fragment,e),v(Qt.$$.fragment,e),v(ol.$$.fragment,e),v(ml.$$.fragment,e),v(bl.$$.fragment,e),v(Sl.$$.fragment,e),v(es.$$.fragment,e),lo=!1},d(e){e&&(t(X),t(P),t(hs),t(y),t(As),t(O),t(zs),t(Bs),t(q),t(Qs),t(M),t(Zs),t(K),t(Rs),t(ee),t(Vs),t(te),t(Ws),t(b),t(Xs),t(se),t(Fs),t(ne),t(Os),t(ie),t(qs),t(ae),t(Ys),t(T),t(Ks),t(re),t(en),t(C),t(tn),t(he),t(ln),t(ue),t(sn),t(de),t(nn),t(fe),t(an),t(ce),t(on),t(me),t(rn),t(ve),t(pn),t(we),t(hn),t(ge),t(un),t(xe),t(dn),t(Pe),t(fn),t(ye),t(cn),t(Me),t(mn),t(be),t(vn),t(Te),t(wn),t(Ce),t(gn),t(_e),t(xn),t(je),t(Pn),t(Le),t(yn),t(Ue),t(Mn),t(ke),t(bn),t(Tn),t(Je),t(Cn),t(_),t(_n),t(Ge),t(jn),t(Se),t(Ln),t(Ne),t(Un),t(kn),t(Ee),t(Dn),t(Ie),t(Jn),t(Hn),t(ze),t(Gn),t(Be),t(Sn),t(Nn),t(Ze),t($n),t(Re),t(En),t(Ve),t(In),t(We),t(An),t(Xe),t(zn),t(Fe),t(Bn),t(Oe),t(Qn),t(qe),t(Zn),t(Ye),t(Rn),t(Ke),t(Vn),t(et),t(Wn),t(tt),t(Xn),t(lt),t(Fn),t(st),t(On),t(nt),t(qn),t(it),t(Yn),t(j),t(Kn),t(ot),t(ei),t(rt),t(ti),t(li),t(ht),t(si),t(ut),t(ni),t(dt),t(ii),t(ft),t(ai),t(ct),t(oi),t(mt),t(ri),t(vt),t(pi),t(wt),t(hi),t(gt),t(ui),t(xt),t(di),t(Pt),t(fi),t(yt),t(ci),t(Mt),t(mi),t(bt),t(vi),t(Tt),t(wi),t(Ct),t(gi),t(_t),t(xi),t(jt),t(Pi),t(Lt),t(yi),t(Ut),t(Mi),t(kt),t(bi),t(Dt),t(Ti),t(Jt),t(Ci),t(Ht),t(_i),t(Gt),t(ji),t(St),t(Li),t(Nt),t(Ui),t($t),t(ki),t(Et),t(Di),t(It),t(Ji),t(At),t(Hi),t(zt),t(Gi),t(Bt),t(Si),t(L),t(Ni),t(Zt),t($i),t(Rt),t(Ei),t(Vt),t(Ii),t(Wt),t(Ai),t(Xt),t(zi),t(Ft),t(Bi),t(Ot),t(Qi),t(qt),t(Zi),t(Yt),t(Ri),t(Kt),t(Vi),t(el),t(Wi),t(tl),t(Xi),t(ll),t(Fi),t(sl),t(Oi),t(nl),t(qi),t(il),t(Yi),t(al),t(Ki),t(U),t(ea),t(rl),t(ta),t(pl),t(la),t(hl),t(sa),t(ul),t(na),t(dl),t(ia),t(fl),t(aa),t(cl),t(oa),t(k),t(ra),t(vl),t(pa),t(wl),t(ha),t(gl),t(ua),t(xl),t(da),t(Pl),t(fa),t(yl),t(ca),t(Ml),t(ma),t(D),t(va),t(Tl),t(wa),t(Cl),t(ga),t(_l),t(xa),t(jl),t(Pa),t(Ll),t(ya),t(Ul),t(Ma),t(kl),t(ba),t(Dl),t(Ta),t(Jl),t(Ca),t(Hl),t(_a),t(Gl),t(ja),t(J),t(La),t(Nl),t(Ua),t($l),t(ka),t(El),t(Da),t(Il),t(Ja),t(Al),t(Ha),t(zl),t(Ga),t(Bl),t(Sa),t(Ql),t(Na),t(Zl),t($a),t(Rl),t(Ea),t(Vl),t(Ia),t(Wl),t(Aa),t(Xl),t(za),t(Fl),t(Ba),t(Ol),t(Qa),t(ql),t(Za),t(Yl),t(Ra),t(Kl),t(Va),t(H),t(Wa),t(ts),t(Xa),t(ls),t(Fa),t(ss),t(Oa),t(ns),t(qa),t(is),t(Ya),t(as),t(Ka),t(os),t(eo),t(rs),t(to),t($s)),t(g),w(F),w(S,e),w(Y),w(le),w(oe),w(pe),w(De,e),w(He),w($e,e),w(Ae,e),w(Qe,e),w(at),w(pt,e),w(Qt),w(ol),w(ml),w(bl),w(Sl),w(es)}}}const xu={local:"efficient-training-on-multiple-gpus",sections:[{local:"concepts",title:"Concepts"},{local:"scalability-strategy",title:"Scalability Strategy"},{local:"data-parallelism",sections:[{local:"dp-vs-ddp",title:"DP vs DDP"}],title:"Data Parallelism"},{local:"zero-data-parallelism",title:"ZeRO Data Parallelism"},{local:"naive-model-parallelism-vertical-and-pipeline-parallelism",title:"Naive Model Parallelism (Vertical) and Pipeline Parallelism"},{local:"tensor-parallelism",title:"Tensor Parallelism"},{local:"dppp",title:"DP+PP"},{local:"dppptp",title:"DP+PP+TP"},{local:"zero-dppptp",title:"ZeRO DP+PP+TP"},{local:"flexflow",title:"FlexFlow"},{local:"which-strategy-to-use-when",title:"Which Strategy To Use When"}],title:"Efficient Training on Multiple GPUs"};function Pu(Is){return uu(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _u extends fu{constructor(g){super(),cu(this,g,Pu,gu,hu,{})}}export{_u as component};
