import{s as Vp,o as Dp,n as Wa}from"../chunks/scheduler.9bc65507.js";import{S as Qp,i as Kp,g as i,s as r,u as f,A as Op,h as l,f as t,c as s,j as c,v as u,y as o,k as p,o as h,a,w as m,d as g,t as v,x as y}from"../chunks/index.78c82d43.js";import{T as La}from"../chunks/Tip.87d55b76.js";import{I as M}from"../chunks/IconCopyLink.bedaa44d.js";import{C as x}from"../chunks/CodeBlock.73e038be.js";function eh(C){let d,_='If you have access to a machine with multiple GPUs, these approaches are still valid, plus you can leverage additional methods outlined in the <a href="perf_train_gpu_many">multi-GPU section</a>.';return{c(){d=i("p"),d.innerHTML=_},l(w){d=l(w,"P",{"data-svelte-h":!0}),o(d)!=="svelte-198lgun"&&(d.innerHTML=_)},m(w,b){a(w,d,b)},p:Wa,d(w){w&&t(d)}}}function th(C){let d,_=`Note: when using mixed precision with a small model and a large batch size, there will be some memory savings but with a
large model and a small batch size, the memory use will be larger.`;return{c(){d=i("p"),d.textContent=_},l(w){d=l(w,"P",{"data-svelte-h":!0}),o(d)!=="svelte-e8wqm0"&&(d.textContent=_)},m(w,b){a(w,d,b)},p:Wa,d(w){w&&t(d)}}}function nh(C){let d,_="While gradient checkpointing may improve memory efficiency, it slows training by approximately 20%.";return{c(){d=i("p"),d.textContent=_},l(w){d=l(w,"P",{"data-svelte-h":!0}),o(d)!=="svelte-1rw5pua"&&(d.textContent=_)},m(w,b){a(w,d,b)},p:Wa,d(w){w&&t(d)}}}function ah(C){let d,_="tf32 can’t be accessed directly via <code>tensor.to(dtype=torch.tf32)</code> because it is an internal CUDA data type. You need <code>torch&gt;=1.7</code> to use tf32 data types.";return{c(){d=i("p"),d.innerHTML=_},l(w){d=l(w,"P",{"data-svelte-h":!0}),o(d)!=="svelte-lagf4l"&&(d.innerHTML=_)},m(w,b){a(w,d,b)},p:Wa,d(w){w&&t(d)}}}function ih(C){let d,_="The PyTorch-native <code>scaled_dot_product_attention</code> operator can only dispatch to Flash Attention if no <code>attention_mask</code> is provided.",w,b,$="By default, in training mode, the BetterTransformer integration <strong>drops the mask support and can only be used for training that does not require a padding mask for batched training</strong>. This is the case, for example, during masked language modeling or causal language modeling. BetterTransformer is not suited for fine-tuning models on tasks that require a padding mask.";return{c(){d=i("p"),d.innerHTML=_,w=r(),b=i("p"),b.innerHTML=$},l(T){d=l(T,"P",{"data-svelte-h":!0}),o(d)!=="svelte-3mpetc"&&(d.innerHTML=_),w=s(T),b=l(T,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1sd6oaz"&&(b.innerHTML=$)},m(T,k){a(T,d,k),a(T,w,k),a(T,b,k)},p:Wa,d(T){T&&(t(d),t(w),t(b))}}}function lh(C){let d,_,w,b,$,T,k,ve,jr,Nn,Or="Methods and tools for efficient training on a single GPU",Ga,ye,es=`This guide demonstrates practical techniques that you can use to increase the efficiency of your model’s training by
optimizing memory utilization, speeding up the training, or both. If you’d like to understand how GPU is utilized during
training, please refer to the <a href="model_memory_anatomy">Model training anatomy</a> conceptual guide first. This guide
focuses on practical techniques.`,Ya,S,Ia,we,ts="When training large models, there are two aspects that should be considered at the same time:",Ra,be,ns="<li>Data throughput/training time</li> <li>Model performance</li>",Ea,Me,as=`Maximizing the throughput (samples/second) leads to lower training cost. This is generally achieved by utilizing the GPU
as much as possible and thus filling GPU memory to its limit. If the desired batch size exceeds the limits of the GPU memory,
the memory optimization techniques, such as gradient accumulation, can help.`,Za,_e,is=`However, if the preferred batch size fits into memory, there’s no reason to apply memory-optimizing techniques because they can
slow down the training. Just because one can use a large batch size, does not necessarily mean they should. As part of
hyperparameter tuning, you should determine which batch size yields the best results and then optimize resources accordingly.`,Fa,Te,ls="The methods and tools covered in this guide can be classified based on the effect they have on the training process:",Ba,xe,rs='<thead><tr><th align="left">Method/tool</th> <th align="left">Improves training speed</th> <th align="left">Optimizes memory utilization</th></tr></thead> <tbody><tr><td align="left"><a href="#batch-size-choice">Batch size choice</a></td> <td align="left">Yes</td> <td align="left">Yes</td></tr> <tr><td align="left"><a href="#gradient-accumulation">Gradient accumulation</a></td> <td align="left">No</td> <td align="left">Yes</td></tr> <tr><td align="left"><a href="#gradient-checkpointing">Gradient checkpointing</a></td> <td align="left">No</td> <td align="left">Yes</td></tr> <tr><td align="left"><a href="#mixed-precision-training">Mixed precision training</a></td> <td align="left">Yes</td> <td align="left">(No)</td></tr> <tr><td align="left"><a href="#optimizer-choice">Optimizer choice</a></td> <td align="left">Yes</td> <td align="left">Yes</td></tr> <tr><td align="left"><a href="#data-preloading">Data preloading</a></td> <td align="left">Yes</td> <td align="left">No</td></tr> <tr><td align="left"><a href="#deepspeed-zero">DeepSpeed Zero</a></td> <td align="left">No</td> <td align="left">Yes</td></tr> <tr><td align="left"><a href="#using-torchcompile">torch.compile</a></td> <td align="left">Yes</td> <td align="left">No</td></tr></tbody>',Xa,q,Na,Ce,ss=`You can combine the above methods to get a cumulative effect. These techniques are available to you whether you are
training your model with <a href="/docs/transformers/v4.34.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> or writing a pure PyTorch loop, in which case you can <a href="#using-accelerate">configure these optimizations
with 🤗 Accelerate</a>.`,Sa,$e,os="If these methods do not result in sufficient gains, you can explore the following options:",qa,ke,ps='<li><a href="#efficient-software-prebuilds">Look into building your own custom Docker container with efficient softare prebuilds</a></li> <li><a href="#mixture-of-experts">Consider a model that uses Mixture of Experts (MoE)</a></li> <li><a href="#using-pytorch-native-attention">Convert your model to BetterTransformer to leverage PyTorch native attention</a></li>',Va,Ae,hs=`Finally, if all of the above is still not enough, even after switching to a server-grade GPU like A100, consider moving
to a multi-GPU setup. All these approaches are still valid in a multi-GPU setup, plus you can leverage additional parallelism
techniques outlined in the <a href="perf_train_gpu_many">multi-GPU section</a>.`,Da,A,V,da,Je,Pr,Sn,cs="Batch size choice",Qa,Ue,ds=`To achieve optimal performance, start by identifying the appropriate batch size. It is recommended to use batch sizes and
input/output neuron counts that are of size 2^N. Often it’s a multiple of 8, but it can be
higher depending on the hardware being used and the model’s dtype.`,Ka,He,fs=`For reference, check out NVIDIA’s recommendation for <a href="https://docs.nvidia.com/deeplearning/performance/dl-performance-fully-connected/index.html#input-features" rel="nofollow">input/output neuron counts</a> and
<a href="https://docs.nvidia.com/deeplearning/performance/dl-performance-fully-connected/index.html#batch-size" rel="nofollow">batch size</a> for
fully connected layers (which are involved in GEMMs (General Matrix Multiplications)).`,Oa,ze,us=`<a href="https://docs.nvidia.com/deeplearning/performance/dl-performance-matrix-multiplication/index.html#requirements-tc" rel="nofollow">Tensor Core Requirements</a>
define the multiplier based on the dtype and the hardware. For instance, for fp16 data type a multiple of 8 is recommended, unless
it’s an A100 GPU, in which case use multiples of 64.`,ei,je,ms=`For parameters that are small, consider also <a href="https://docs.nvidia.com/deeplearning/performance/dl-performance-matrix-multiplication/index.html#dim-quantization" rel="nofollow">Dimension Quantization Effects</a>.
This is where tiling happens and the right multiplier can have a significant speedup.`,ti,J,D,fa,Pe,Lr,qn,gs="Gradient Accumulation",ni,Le,vs=`The <strong>gradient accumulation</strong> method aims to calculate gradients in smaller increments instead of computing them for the
entire batch at once. This approach involves iteratively calculating gradients in smaller batches by performing forward
and backward passes through the model and accumulating the gradients during the process. Once a sufficient number of
gradients have been accumulated, the model’s optimization step is executed. By employing gradient accumulation, it
becomes possible to increase the <strong>effective batch size</strong> beyond the limitations imposed by the GPU’s memory capacity.
However, it is important to note that the additional forward and backward passes introduced by gradient accumulation can
slow down the training process.`,ai,We,ys='You can enable gradient accumulation by adding the <code>gradient_accumulation_steps</code> argument to  <a href="/docs/transformers/v4.34.0/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>:',ii,Ge,li,Ye,ws="In the above example, your effective batch size becomes 4.",ri,Ie,bs=`Alternatively, use 🤗 Accelerate to gain full control over the training loop. Find the 🤗 Accelerate example
<a href="#using-accelerate">further down in this guide</a>.`,si,Re,Ms=`While it is advised to max out GPU usage as much as possible, a high number of gradient accumulation steps can
result in a more pronounced training slowdown. Consider the following example. Let’s say, the <code>per_device_train_batch_size=4</code>
without gradient accumulation hits the GPU’s limit. If you would like to train with batches of size 64, do not set the
<code>per_device_train_batch_size</code> to 1 and <code>gradient_accumulation_steps</code> to 64. Instead, keep <code>per_device_train_batch_size=4</code>
and set <code>gradient_accumulation_steps=16</code>. This results in the same effective batch size while making better use of
the available GPU resources.`,oi,Ee,_s=`For additional information, please refer to batch size and gradient accumulation benchmarks for <a href="https://github.com/huggingface/transformers/issues/14608#issuecomment-1004392537" rel="nofollow">RTX-3090</a>
and <a href="https://github.com/huggingface/transformers/issues/15026#issuecomment-1005033957" rel="nofollow">A100</a>.`,pi,U,Q,ua,Ze,Wr,Vn,Ts="Gradient Checkpointing",hi,Fe,xs=`Some large models may still face memory issues even when the batch size is set to 1 and gradient accumulation is used.
This is because there are other components that also require memory storage.`,ci,Be,Cs=`Saving all activations from the forward pass in order to compute the gradients during the backward pass can result in
significant memory overhead. The alternative approach of discarding the activations and recalculating them when needed
during the backward pass, would introduce a considerable computational overhead and slow down the training process.`,di,Xe,$s=`<strong>Gradient checkpointing</strong> offers a compromise between these two approaches and saves strategically selected activations
throughout the computational graph so only a fraction of the activations need to be re-computed for the gradients. For
an in-depth explanation of gradient checkpointing, refer to <a href="https://medium.com/tensorflow/fitting-larger-networks-into-memory-583e3c758ff9" rel="nofollow">this great article</a>.`,fi,Ne,ks='To enable gradient checkpointing in the <a href="/docs/transformers/v4.34.0/en/main_classes/trainer#transformers.Trainer">Trainer</a>, pass the corresponding a flag to <a href="/docs/transformers/v4.34.0/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>:',ui,Se,mi,qe,As='Alternatively, use 🤗 Accelerate - find the 🤗 Accelerate example <a href="#using-accelerate">further in this guide</a>.',gi,K,vi,H,O,ma,Ve,Gr,Dn,Js="Mixed precision training",yi,De,Us=`<strong>Mixed precision training</strong> is a technique that aims to optimize the computational efficiency of training models by
utilizing lower-precision numerical formats for certain variables. Traditionally, most models use 32-bit floating point
precision (fp32 or float32) to represent and process variables. However, not all variables require this high precision
level to achieve accurate results. By reducing the precision of certain variables to lower numerical formats like 16-bit
floating point (fp16 or float16), we can speed up the computations. Because in this approach some computations are performed
in half-precision, while some are still in full precision, the approach is called mixed precision training.`,wi,Qe,Hs=`Most commonly mixed precision training is achieved by using fp16 (float16) data types, however, some GPU architectures
(such as the Ampere architecture) offer bf16 and tf32 (CUDA internal data type) data types. Check
out the <a href="https://developer.nvidia.com/blog/accelerating-ai-training-with-tf32-tensor-cores/" rel="nofollow">NVIDIA Blog</a> to learn more about
the differences between these data types.`,bi,z,ee,ga,Ke,Yr,Qn,zs="fp16",Mi,Oe,js=`The main advantage of mixed precision training comes from saving the activations in half precision (fp16).
Although the gradients are also computed in half precision they are converted back to full precision for the optimization
step so no memory is saved here.
While mixed precision training results in faster computations, it can also lead to more GPU memory being utilized, especially for small batch sizes.
This is because the model is now present on the GPU in both 16-bit and 32-bit precision (1.5x the original model on the GPU).`,_i,et,Ps="To enable mixed precision training, set the <code>fp16</code> flag to <code>True</code>:",Ti,tt,xi,nt,Ls='If you prefer to use 🤗 Accelerate, find the 🤗 Accelerate example <a href="#using-accelerate">further in this guide</a>.',Ci,j,te,va,at,Ir,Kn,Ws="BF16",$i,it,Gs=`If you have access to an Ampere or newer hardware you can use bf16 for mixed precision training and evaluation. While
bf16 has a worse precision than fp16, it has a much bigger dynamic range. In fp16 the biggest number you can have
is <code>65535</code> and any number above that will result in an overflow. A bf16 number can be as large as <code>3.39e+38</code> (!) which
is about the same as fp32 - because both have 8-bits used for the numerical range.`,ki,lt,Ys="You can enable BF16 in the 🤗 Trainer with:",Ai,rt,Ji,P,ne,ya,st,Rr,On,Is="TF32",Ui,ot,Rs=`The Ampere hardware uses a magical data type called tf32. It has the same numerical range as fp32 (8-bits), but instead
of 23 bits precision it has only 10 bits (same as fp16) and uses only 19 bits in total. It’s “magical” in the sense that
you can use the normal fp32 training and/or inference code and by enabling tf32 support you can get up to 3x throughput
improvement. All you need to do is to add the following to your code:`,Hi,pt,zi,ht,Es="CUDA will automatically switch to using tf32 instead of fp32 where possible, assuming that the used GPU is from the Ampere series.",ji,ct,Zs=`According to <a href="https://developer.nvidia.com/blog/accelerating-ai-training-with-tf32-tensor-cores/" rel="nofollow">NVIDIA research</a>, the
majority of machine learning training workloads show the same perplexity and convergence with tf32 training as with fp32.
If you’re already using fp16 or bf16 mixed precision it may help with the throughput as well.`,Pi,dt,Fs="You can enable this mode in the 🤗 Trainer:",Li,ft,Wi,ae,Gi,ut,Bs=`For additional information on tf32 vs other precisions, please refer to the following benchmarks:
<a href="https://github.com/huggingface/transformers/issues/14608#issuecomment-1004390803" rel="nofollow">RTX-3090</a> and
<a href="https://github.com/huggingface/transformers/issues/15026#issuecomment-1004543189" rel="nofollow">A100</a>.`,Yi,L,ie,wa,mt,Er,ea,Xs="Flash Attention 2",Ii,gt,Ns='You can speedup the training throughput by using Flash Attention 2 integration in transformers. Check out the appropriate section in the <a href="./perf_infer_gpu_one#Flash-Attention-2">single GPU section</a> to learn more about how to load a model with Flash Attention 2 modules.',Ri,W,le,ba,vt,Zr,ta,Ss="Optimizer choice",Ei,yt,qs=`The most common optimizer used to train transformer models is Adam or AdamW (Adam with weight decay). Adam achieves
good convergence by storing the rolling average of the previous gradients; however, it adds an additional memory
footprint of the order of the number of model parameters. To remedy this, you can use an alternative optimizer.
For example if you have <a href="https://github.com/NVIDIA/apex" rel="nofollow">NVIDIA/apex</a> installed, <code>adamw_apex_fused</code> will give you the
fastest training experience among all supported AdamW optimizers.`,Zi,wt,Vs=`<a href="/docs/transformers/v4.34.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> integrates a variety of optimizers that can be used out of box: <code>adamw_hf</code>, <code>adamw_torch</code>, <code>adamw_torch_fused</code>,
<code>adamw_apex_fused</code>, <code>adamw_anyprecision</code>, <code>adafactor</code>, or <code>adamw_bnb_8bit</code>. More optimizers can be plugged in via a third-party implementation.`,Fi,bt,Ds="Let’s take a closer look at two alternatives to AdamW optimizer:",Bi,Mt,Qs='<li><code>adafactor</code> which is available in <a href="/docs/transformers/v4.34.0/en/main_classes/trainer#transformers.Trainer">Trainer</a></li> <li><code>adamw_bnb_8bit</code> is also available in Trainer, but a third-party integration is provided below for demonstration.</li>',Xi,_t,Ks="For comparison, for a 3B-parameter model, like “t5-3b”:",Ni,Tt,Os="<li>A standard AdamW optimizer will need 24GB of GPU memory because it uses 8 bytes for each parameter (8*3 =&gt; 24GB)</li> <li>Adafactor optimizer will need more than 12GB. It uses slightly more than 4 bytes for each parameter, so 4*3 and then some extra.</li> <li>8bit BNB quantized optimizer will use only (2*3) 6GB if all optimizer states are quantized.</li>",Si,G,re,Ma,xt,Fr,na,eo="Adafactor",qi,Ct,to=`Adafactor doesn’t store rolling averages for each element in weight matrices. Instead, it keeps aggregated information
(sums of rolling averages row- and column-wise), significantly reducing its footprint. However, compared to Adam,
Adafactor may have slower convergence in certain cases.`,Vi,$t,no='You can switch to Adafactor by setting <code>optim=&quot;adafactor&quot;</code> in <a href="/docs/transformers/v4.34.0/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>:',Di,kt,Qi,At,ao=`Combined with other approaches (gradient accumulation, gradient checkpointing, and mixed precision training)
you can notice up to 3x improvement while maintaining the throughput! However, as mentioned before, the convergence of
Adafactor can be worse than Adam.`,Ki,Y,se,_a,Jt,Br,aa,io="8-bit Adam",Oi,Ut,lo=`Instead of aggregating optimizer states like Adafactor, 8-bit Adam keeps the full state and quantizes it. Quantization
means that it stores the state with lower precision and dequantizes it only for the optimization. This is similar to the
idea behind mixed precision training.`,el,Ht,ro='To use <code>adamw_bnb_8bit</code>, you simply need to set <code>optim=&quot;adamw_bnb_8bit&quot;</code> in <a href="/docs/transformers/v4.34.0/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>:',tl,zt,nl,jt,so="However, we can also use a third-party implementation of the 8-bit optimizer for demonstration purposes to see how that can be integrated.",al,Pt,oo=`First, follow the installation guide in the GitHub <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">repo</a> to install the <code>bitsandbytes</code> library
that implements the 8-bit Adam optimizer.`,il,Lt,po="Next you need to initialize the optimizer. This involves two steps:",ll,Wt,ho="<li>First, group the model’s parameters into two groups - one where weight decay should be applied, and the other one where it should not. Usually, biases and layer norm parameters are not weight decayed.</li> <li>Then do some argument housekeeping to use the same parameters as the previously used AdamW optimizer.</li>",rl,Gt,sl,Yt,co="Finally, pass the custom optimizer as an argument to the <code>Trainer</code>:",ol,It,pl,Rt,fo=`Combined with other approaches (gradient accumulation, gradient checkpointing, and mixed precision training),
you can expect to get about a 3x memory improvement and even slightly higher throughput as using Adafactor.`,hl,I,oe,Ta,Et,Xr,ia,uo="multi_tensor",cl,Zt,mo=`pytorch-nightly introduced <code>torch.optim._multi_tensor</code> which should significantly speed up the optimizers for situations
with lots of small feature tensors. It should eventually become the default, but if you want to experiment with it sooner, take a look at this GitHub <a href="https://github.com/huggingface/transformers/issues/9965" rel="nofollow">issue</a>.`,dl,R,pe,xa,Ft,Nr,la,go="Data preloading",fl,Bt,vo=`One of the important requirements to reach great training speed is the ability to feed the GPU at the maximum speed it
can handle. By default, everything happens in the main process, and it might not be able to read the data from disk fast
enough, and thus create a bottleneck, leading to GPU under-utilization. Configure the following arguments to reduce the bottleneck:`,ul,Xt,yo="<li><code>DataLoader(pin_memory=True, ...)</code> - ensures the data gets preloaded into the pinned memory on CPU and typically leads to much faster transfers from CPU to GPU memory.</li> <li><code>DataLoader(num_workers=4, ...)</code> - spawn several workers to preload data faster. During training, watch the GPU utilization stats; if it’s far from 100%, experiment with increasing the number of workers. Of course, the problem could be elsewhere, so many workers won’t necessarily lead to better performance.</li>",ml,Nt,wo='When using <a href="/docs/transformers/v4.34.0/en/main_classes/trainer#transformers.Trainer">Trainer</a>, the corresponding <a href="/docs/transformers/v4.34.0/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> are: <code>dataloader_pin_memory</code> (<code>True</code> by default), and <code>dataloader_num_workers</code> (defaults to <code>0</code>).',gl,E,he,Ca,St,Sr,ra,bo="DeepSpeed ZeRO",vl,qt,Mo=`DeepSpeed is an open-source deep learning optimization library that is integrated with 🤗 Transformers and 🤗 Accelerate.
It provides a wide range of features and optimizations designed to improve the efficiency and scalability of large-scale
deep learning training.`,yl,Vt,_o=`If your model fits onto a single GPU and you have enough space to fit a small batch size, you don’t need to use DeepSpeed
as it’ll only slow things down. However, if the model doesn’t fit onto a single GPU or you can’t fit a small batch, you can
leverage DeepSpeed ZeRO + CPU Offload, or NVMe Offload for much larger models. In this case, you need to separately
<a href="main_classes/deepspeed#installation">install the library</a>, then follow one of the guides to create a configuration file
and launch DeepSpeed:`,wl,Dt,To=`<li>For an in-depth guide on DeepSpeed integration with <a href="/docs/transformers/v4.34.0/en/main_classes/trainer#transformers.Trainer">Trainer</a>, review <a href="main_classes/deepspeed">the corresponding documentation</a>, specifically the
<a href="main_classes/deepspeed#deployment-with-one-gpu">section for a single GPU</a>. Some adjustments are required to use DeepSpeed in a notebook; please take a look at the <a href="main_classes/deepspeed#deployment-in-notebooks">corresponding guide</a>.</li> <li>If you prefer to use 🤗 Accelerate, refer to <a href="https://huggingface.co/docs/accelerate/en/usage_guides/deepspeed" rel="nofollow">🤗 Accelerate DeepSpeed guide</a>.</li>`,bl,Z,ce,$a,Qt,qr,sa,xo="Using torch.compile",Ml,Kt,Co=`PyTorch 2.0 introduced a new compile function that doesn’t require any modification to existing PyTorch code but can
optimize your code by adding a single line of code: <code>model = torch.compile(model)</code>.`,_l,Ot,$o='If using <a href="/docs/transformers/v4.34.0/en/main_classes/trainer#transformers.Trainer">Trainer</a>, you only need <code>to</code> pass the <code>torch_compile</code> option in the <a href="/docs/transformers/v4.34.0/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>:',Tl,en,xl,tn,ko=`<code>torch.compile</code> uses Python’s frame evaluation API to automatically create a graph from existing PyTorch programs. After
capturing the graph, different backends can be deployed to lower the graph to an optimized engine.
You can find more details and benchmarks in <a href="https://pytorch.org/get-started/pytorch-2.0/" rel="nofollow">PyTorch documentation</a>.`,Cl,nn,Ao="<code>torch.compile</code> has a growing list of backends, which can be found in by calling <code>torchdynamo.list_backends()</code>, each of which with its optional dependencies.",$l,an,Jo='Choose which backend to use by specifying it via <code>torch_compile_backend</code> in the <a href="/docs/transformers/v4.34.0/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>.  Some of the most commonly used backends are:',kl,ln,Uo="<strong>Debugging backends</strong>:",Al,rn,Ho="<li><code>dynamo.optimize(&quot;eager&quot;)</code> - Uses PyTorch to run the extracted GraphModule. This is quite useful in debugging TorchDynamo issues.</li> <li><code>dynamo.optimize(&quot;aot_eager&quot;)</code> - Uses AotAutograd with no compiler, i.e, just using PyTorch eager for the AotAutograd’s extracted forward and backward graphs. This is useful for debugging, and unlikely to give speedups.</li>",Jl,sn,zo="<strong>Training &amp; inference backends</strong>:",Ul,on,jo='<li><code>dynamo.optimize(&quot;inductor&quot;)</code> - Uses TorchInductor backend with AotAutograd and cudagraphs by leveraging codegened Triton kernels  <a href="https://dev-discuss.pytorch.org/t/torchinductor-a-pytorch-native-compiler-with-define-by-run-ir-and-symbolic-shapes/747" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;nvfuser&quot;)</code> -  nvFuser with TorchScript. <a href="https://dev-discuss.pytorch.org/t/tracing-with-primitives-update-1-nvfuser-and-its-primitives/593" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;aot_nvfuser&quot;)</code> -  nvFuser with AotAutograd. <a href="https://dev-discuss.pytorch.org/t/tracing-with-primitives-update-1-nvfuser-and-its-primitives/593" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;aot_cudagraphs&quot;)</code> - cudagraphs with AotAutograd. <a href="https://github.com/pytorch/torchdynamo/pull/757" rel="nofollow">Read more</a></li>',Hl,pn,Po="<strong>Inference-only backend</strong>s:",zl,hn,Lo='<li><code>dynamo.optimize(&quot;ofi&quot;)</code> -  Uses Torchscript optimize_for_inference.  <a href="https://pytorch.org/docs/stable/generated/torch.jit.optimize_for_inference.html" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;fx2trt&quot;)</code> -  Uses Nvidia TensorRT for inference optimizations.  <a href="https://github.com/pytorch/TensorRT/blob/master/docsrc/tutorials/getting_started_with_fx_path.rst" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;onnxrt&quot;)</code> -  Uses ONNXRT for inference on CPU/GPU.  <a href="https://onnxruntime.ai/" rel="nofollow">Read more</a></li> <li><code>dynamo.optimize(&quot;ipex&quot;)</code> -  Uses IPEX for inference on CPU.  <a href="https://github.com/intel/intel-extension-for-pytorch" rel="nofollow">Read more</a></li>',jl,cn,Wo='For an example of using <code>torch.compile</code> with 🤗 Transformers, check out this <a href="https://www.philschmid.de/getting-started-pytorch-2-0-transformers" rel="nofollow">blog post on fine-tuning a BERT model for Text Classification using the newest PyTorch 2.0 features</a>',Pl,F,de,ka,dn,Vr,oa,Go="Using 🤗 Accelerate",Ll,fn,Yo=`With <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">🤗 Accelerate</a> you can use the above methods while gaining full
control over the training loop and can essentially write the loop in pure PyTorch with some minor modifications.`,Wl,un,Io='Suppose you have combined the methods in the <a href="/docs/transformers/v4.34.0/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> like so:',Gl,mn,Yl,gn,Ro="The full example training loop with 🤗 Accelerate is only a handful of lines of code long:",Il,vn,Rl,yn,Eo=`First we wrap the dataset in a <a href="https://pytorch.org/docs/stable/data.html#torch.utils.data.DataLoader" rel="nofollow"><code>DataLoader</code></a>.
Then we can enable gradient checkpointing by calling the model’s <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.gradient_checkpointing_enable">gradient_checkpointing_enable()</a> method.
When we initialize the <a href="https://huggingface.co/docs/accelerate/package_reference/accelerator#accelerate.Accelerator" rel="nofollow"><code>Accelerator</code></a>
we can specify if we want to use mixed precision training and it will take care of it for us in the <code>prepare</code> call.
During the <a href="https://huggingface.co/docs/accelerate/package_reference/accelerator#accelerate.Accelerator.prepare" rel="nofollow"><code>prepare</code></a>
call the dataloader will also be distributed across workers should we use multiple GPUs. We use the same <a href="#8-bit-adam">8-bit optimizer</a> from the earlier example.`,El,wn,Zo=`Finally, we can add the main training loop. Note that the <code>backward</code> call is handled by 🤗 Accelerate. We can also see
how gradient accumulation works: we normalize the loss, so we get the average at the end of accumulation and once we have
enough steps we run the optimization.`,Zl,bn,Fo=`Implementing these optimization techniques with 🤗 Accelerate only takes a handful of lines of code and comes with the
benefit of more flexibility in the training loop. For a full documentation of all features have a look at the
<a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate documentation</a>.`,Fl,B,fe,Aa,Mn,Dr,pa,Bo="Efficient Software Prebuilds",Bl,_n,Xo=`PyTorch’s <a href="https://pytorch.org/get-started/locally/#start-locally" rel="nofollow">pip and conda builds</a> come prebuilt with the cuda toolkit
which is enough to run PyTorch, but it is insufficient if you need to build cuda extensions.`,Xl,Tn,No=`At times, additional efforts may be required to pre-build some components. For instance, if you’re using libraries like <code>apex</code> that
don’t come pre-compiled. In other situations figuring out how to install the right cuda toolkit system-wide can be complicated.
To address these scenarios PyTorch and NVIDIA released a new version of NGC docker container which already comes with
everything prebuilt. You just need to install your programs on it, and it will run out of the box.`,Nl,xn,So=`This approach is also useful if you want to tweak the pytorch source and/or make a new customized build.
To find the docker image version you want start <a href="https://docs.nvidia.com/deeplearning/frameworks/pytorch-release-notes/" rel="nofollow">with PyTorch release notes</a>,
choose one of the latest monthly releases. Go into the release’s notes for the desired release, check that the environment’s
components are matching your needs (including NVIDIA Driver requirements!) and then at the very top of that document go
to the corresponding NGC page. If for some reason you get lost, here is <a href="https://ngc.nvidia.com/catalog/containers/nvidia:pytorch" rel="nofollow">the index of all PyTorch NGC images</a>.`,Sl,Cn,qo="Next follow the instructions to download and deploy the docker image.",ql,X,ue,Ja,$n,Qr,ha,Vo="Mixture of Experts",Vl,kn,Do=`Some recent papers reported a 4-5x training speedup and a faster inference by integrating
Mixture of Experts (MoE) into the Transformer models.`,Dl,An,Qo=`Since it has been discovered that more parameters lead to better performance, this technique allows to increase the
number of parameters by an order of magnitude without increasing training costs.`,Ql,Jn,Ko=`In this approach every other FFN layer is replaced with a MoE Layer which consists of many experts, with a gated function
that trains each expert in a balanced way depending on the input token’s position in a sequence.`,Kl,Un,Oo='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/perf-moe-transformer.png" alt="MoE Transformer 2x block"/>',Ol,Hn,ep='(source: <a href="https://ai.googleblog.com/2021/12/more-efficient-in-context-learning-with.html" rel="nofollow">GLAM</a>)',er,zn,tp="You can find exhaustive details and comparison tables in the papers listed at the end of this section.",tr,jn,np=`The main drawback of this approach is that it requires staggering amounts of GPU memory - almost an order of magnitude
larger than its dense equivalent. Various distillation and approaches are proposed to how to overcome the much higher memory requirements.`,nr,Pn,ap=`There is direct trade-off though, you can use just a few experts with a 2-3x smaller base model instead of dozens or
hundreds experts leading to a 5x smaller model and thus increase the training speed moderately while increasing the
memory requirements moderately as well.`,ar,Ln,ip="Most related papers and implementations are built around Tensorflow/TPUs:",ir,Wn,lp='<li><a href="https://arxiv.org/abs/2006.16668" rel="nofollow">GShard: Scaling Giant Models with Conditional Computation and Automatic Sharding</a></li> <li><a href="https://arxiv.org/abs/2101.03961" rel="nofollow">Switch Transformers: Scaling to Trillion Parameter Models with Simple and Efficient Sparsity</a></li> <li><a href="https://ai.googleblog.com/2021/12/more-efficient-in-context-learning-with.html" rel="nofollow">GLaM: Generalist Language Model (GLaM)</a></li>',lr,Gn,rp='And for Pytorch DeepSpeed has built one as well: <a href="https://arxiv.org/abs/2201.05596" rel="nofollow">DeepSpeed-MoE: Advancing Mixture-of-Experts Inference and Training to Power Next-Generation AI Scale</a>, <a href="https://www.deepspeed.ai/tutorials/mixture-of-experts/" rel="nofollow">Mixture of Experts</a> - blog posts:  <a href="https://www.microsoft.com/en-us/research/blog/deepspeed-powers-8x-larger-moe-model-training-with-high-performance/" rel="nofollow">1</a>, <a href="https://www.microsoft.com/en-us/research/publication/scalable-and-efficient-moe-training-for-multitask-multilingual-models/" rel="nofollow">2</a> and specific deployment with large transformer-based natural language generation models: <a href="https://www.deepspeed.ai/news/2021/12/09/deepspeed-moe-nlg.html" rel="nofollow">blog post</a>, <a href="Thttps://github.com/microsoft/Megatron-DeepSpeed/tree/moe-training">Megatron-Deepspeed branch</a>.',rr,N,me,Ua,Yn,Kr,ca,sp="Using PyTorch native attention and Flash Attention",sr,In,op=`PyTorch 2.0 released a native <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>torch.nn.functional.scaled_dot_product_attention</code></a> (SDPA),
that allows using fused GPU kernels such as <a href="https://arxiv.org/abs/2112.05682" rel="nofollow">memory-efficient attention</a> and <a href="https://arxiv.org/abs/2205.14135" rel="nofollow">flash attention</a>.`,or,Rn,pp=`After installing the <a href="https://github.com/huggingface/optimum" rel="nofollow"><code>optimum</code></a> package, the relevant internal modules can be
replaced to use PyTorch’s native attention with:`,pr,En,hr,Zn,hp="Once converted, train the model as usual.",cr,ge,dr,Fn,cp='Check out this <a href="https://pytorch.org/blog/out-of-the-box-acceleration/" rel="nofollow">blogpost</a> to learn more about acceleration and memory-savings with SDPA.',fr,Ha,ur;return ve=new M({}),S=new La({props:{$$slots:{default:[eh]},$$scope:{ctx:C}}}),q=new La({props:{$$slots:{default:[th]},$$scope:{ctx:C}}}),Je=new M({}),Pe=new M({}),Ge=new x({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMkMlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTJDJTIwKipkZWZhdWx0X2FyZ3Mp",highlighted:'training_args = TrainingArguments(per_device_train_batch_size=<span class="hljs-number">1</span>, gradient_accumulation_steps=<span class="hljs-number">4</span>, **default_args)',wrap:!1}}),Ze=new M({}),Se=new x({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMkMlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTJDJTIwZ3JhZGllbnRfY2hlY2twb2ludGluZyUzRFRydWUlMkMlMjAqKmRlZmF1bHRfYXJncyUwQSk=",highlighted:`training_args = TrainingArguments(
    per_device_train_batch_size=<span class="hljs-number">1</span>, gradient_accumulation_steps=<span class="hljs-number">4</span>, gradient_checkpointing=<span class="hljs-literal">True</span>, **default_args
)`,wrap:!1}}),K=new La({props:{$$slots:{default:[nh]},$$scope:{ctx:C}}}),Ve=new M({}),Ke=new M({}),tt=new x({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMjBmcDE2JTNEVHJ1ZSUyQyUyMCoqZGVmYXVsdF9hcmdzKQ==",highlighted:'training_args = TrainingArguments(per_device_train_batch_size=<span class="hljs-number">4</span>, fp16=<span class="hljs-literal">True</span>, **default_args)',wrap:!1}}),at=new M({}),rt=new x({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKGJmMTYlM0RUcnVlJTJDJTIwKipkZWZhdWx0X2FyZ3Mp",highlighted:'training_args = TrainingArguments(bf16=<span class="hljs-literal">True</span>, **default_args)',wrap:!1}}),st=new M({}),pt=new x({props:{code:"aW1wb3J0JTIwdG9yY2glMEF0b3JjaC5iYWNrZW5kcy5jdWRhLm1hdG11bC5hbGxvd190ZjMyJTIwJTNEJTIwVHJ1ZSUwQXRvcmNoLmJhY2tlbmRzLmN1ZG5uLmFsbG93X3RmMzIlMjAlM0QlMjBUcnVl",highlighted:`import torch
torch<span class="hljs-selector-class">.backends</span><span class="hljs-selector-class">.cuda</span><span class="hljs-selector-class">.matmul</span><span class="hljs-selector-class">.allow_tf32</span> = True
torch<span class="hljs-selector-class">.backends</span><span class="hljs-selector-class">.cudnn</span><span class="hljs-selector-class">.allow_tf32</span> = True`,wrap:!1}}),ft=new x({props:{code:"VHJhaW5pbmdBcmd1bWVudHModGYzMiUzRFRydWUlMkMlMjAqKmRlZmF1bHRfYXJncyk=",highlighted:'TrainingArguments(tf32=<span class="hljs-literal">True</span>, **default_args)',wrap:!1}}),ae=new La({props:{$$slots:{default:[ah]},$$scope:{ctx:C}}}),mt=new M({}),vt=new M({}),xt=new M({}),kt=new x({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMjBvcHRpbSUzRCUyMmFkYWZhY3RvciUyMiUyQyUyMCoqZGVmYXVsdF9hcmdzKQ==",highlighted:'training_args = TrainingArguments(per_device_train_batch_size=<span class="hljs-number">4</span>, optim=<span class="hljs-string">&quot;adafactor&quot;</span>, **default_args)',wrap:!1}}),Jt=new M({}),zt=new x({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMjBvcHRpbSUzRCUyMmFkYW13X2JuYl84Yml0JTIyJTJDJTIwKipkZWZhdWx0X2FyZ3Mp",highlighted:'training_args = TrainingArguments(per_device_train_batch_size=<span class="hljs-number">4</span>, optim=<span class="hljs-string">&quot;adamw_bnb_8bit&quot;</span>, **default_args)',wrap:!1}}),Gt=new x({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> bitsandbytes <span class="hljs-keyword">as</span> bnb
<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn
<span class="hljs-keyword">from</span> transformers.trainer_pt_utils <span class="hljs-keyword">import</span> get_parameter_names

training_args = TrainingArguments(per_device_train_batch_size=<span class="hljs-number">4</span>, **default_args)

decay_parameters = get_parameter_names(model, [nn.LayerNorm])
decay_parameters = [name <span class="hljs-keyword">for</span> name <span class="hljs-keyword">in</span> decay_parameters <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;bias&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> name]
optimizer_grouped_parameters = [
    {
        <span class="hljs-string">&quot;params&quot;</span>: [p <span class="hljs-keyword">for</span> n, p <span class="hljs-keyword">in</span> model.named_parameters() <span class="hljs-keyword">if</span> n <span class="hljs-keyword">in</span> decay_parameters],
        <span class="hljs-string">&quot;weight_decay&quot;</span>: training_args.weight_decay,
    },
    {
        <span class="hljs-string">&quot;params&quot;</span>: [p <span class="hljs-keyword">for</span> n, p <span class="hljs-keyword">in</span> model.named_parameters() <span class="hljs-keyword">if</span> n <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> decay_parameters],
        <span class="hljs-string">&quot;weight_decay&quot;</span>: <span class="hljs-number">0.0</span>,
    },
]

optimizer_kwargs = {
    <span class="hljs-string">&quot;betas&quot;</span>: (training_args.adam_beta1, training_args.adam_beta2),
    <span class="hljs-string">&quot;eps&quot;</span>: training_args.adam_epsilon,
}
optimizer_kwargs[<span class="hljs-string">&quot;lr&quot;</span>] = training_args.learning_rate
adam_bnb_optim = bnb.optim.Adam8bit(
    optimizer_grouped_parameters,
    betas=(training_args.adam_beta1, training_args.adam_beta2),
    eps=training_args.adam_epsilon,
    lr=training_args.learning_rate,
)`,wrap:!1}}),It=new x({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIobW9kZWwlM0Rtb2RlbCUyQyUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTIwdHJhaW5fZGF0YXNldCUzRGRzJTJDJTIwb3B0aW1pemVycyUzRChhZGFtX2JuYl9vcHRpbSUyQyUyME5vbmUpKQ==",highlighted:'trainer = Trainer(model=model, args=training_args, train_dataset=ds, optimizers=(adam_bnb_optim, <span class="hljs-literal">None</span>))',wrap:!1}}),Et=new M({}),Ft=new M({}),St=new M({}),Qt=new M({}),en=new x({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKHRvcmNoX2NvbXBpbGUlM0RUcnVlJTJDJTIwKipkZWZhdWx0X2FyZ3Mp",highlighted:'training_args = TrainingArguments(torch_compile=<span class="hljs-literal">True</span>, **default_args)',wrap:!1}}),dn=new M({}),mn=new x({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfY2hlY2twb2ludGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCoqZGVmYXVsdF9hcmdzJTJDJTBBKQ==",highlighted:`training_args = TrainingArguments(
    per_device_train_batch_size=<span class="hljs-number">1</span>,
    gradient_accumulation_steps=<span class="hljs-number">4</span>,
    gradient_checkpointing=<span class="hljs-literal">True</span>,
    fp16=<span class="hljs-literal">True</span>,
    **default_args,
)`,wrap:!1}}),vn=new x({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjB0b3JjaC51dGlscy5kYXRhLmRhdGFsb2FkZXIlMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBJTBBZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoZHMlMkMlMjBiYXRjaF9zaXplJTNEdHJhaW5pbmdfYXJncy5wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUpJTBBJTBBaWYlMjB0cmFpbmluZ19hcmdzLmdyYWRpZW50X2NoZWNrcG9pbnRpbmclM0ElMEElMjAlMjAlMjAlMjBtb2RlbC5ncmFkaWVudF9jaGVja3BvaW50aW5nX2VuYWJsZSgpJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihmcDE2JTNEdHJhaW5pbmdfYXJncy5mcDE2KSUwQW1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwZGF0YWxvYWRlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUobW9kZWwlMkMlMjBhZGFtX2JuYl9vcHRpbSUyQyUyMGRhdGFsb2FkZXIpJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMHN0ZXAlMkMlMjBiYXRjaCUyMGluJTIwZW51bWVyYXRlKGRhdGFsb2FkZXIlMkMlMjBzdGFydCUzRDEpJTNBJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpLmxvc3MlMEElMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zcyUyMCUyRiUyMHRyYWluaW5nX2FyZ3MuZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMjAlMjAlMjAlMjBpZiUyMHN0ZXAlMjAlMjUlMjB0cmFpbmluZ19hcmdzLmdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnplcm9fZ3JhZCgp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> torch.utils.data.dataloader <span class="hljs-keyword">import</span> DataLoader

dataloader = DataLoader(ds, batch_size=training_args.per_device_train_batch_size)

<span class="hljs-keyword">if</span> training_args.gradient_checkpointing:
    model.gradient_checkpointing_enable()

accelerator = Accelerator(fp16=training_args.fp16)
model, optimizer, dataloader = accelerator.prepare(model, adam_bnb_optim, dataloader)

model.train()
<span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(dataloader, start=<span class="hljs-number">1</span>):
    loss = model(**batch).loss
    loss = loss / training_args.gradient_accumulation_steps
    accelerator.backward(loss)
    <span class="hljs-keyword">if</span> step % training_args.gradient_accumulation_steps == <span class="hljs-number">0</span>:
        optimizer.step()
        optimizer.zero_grad()`,wrap:!1}}),Mn=new M({}),$n=new M({}),Yn=new M({}),En=new x({props:{code:"bW9kZWwlMjAlM0QlMjBtb2RlbC50b19iZXR0ZXJ0cmFuc2Zvcm1lcigp",highlighted:"model = model.to_bettertransformer()",wrap:!1}}),ge=new La({props:{warning:!0,$$slots:{default:[ih]},$$scope:{ctx:C}}}),{c(){d=i("meta"),_=r(),w=i("p"),b=r(),$=i("h1"),T=i("a"),k=i("span"),f(ve.$$.fragment),jr=r(),Nn=i("span"),Nn.textContent=Or,Ga=r(),ye=i("p"),ye.innerHTML=es,Ya=r(),f(S.$$.fragment),Ia=r(),we=i("p"),we.textContent=ts,Ra=r(),be=i("ul"),be.innerHTML=ns,Ea=r(),Me=i("p"),Me.textContent=as,Za=r(),_e=i("p"),_e.textContent=is,Fa=r(),Te=i("p"),Te.textContent=ls,Ba=r(),xe=i("table"),xe.innerHTML=rs,Xa=r(),f(q.$$.fragment),Na=r(),Ce=i("p"),Ce.innerHTML=ss,Sa=r(),$e=i("p"),$e.textContent=os,qa=r(),ke=i("ul"),ke.innerHTML=ps,Va=r(),Ae=i("p"),Ae.innerHTML=hs,Da=r(),A=i("h2"),V=i("a"),da=i("span"),f(Je.$$.fragment),Pr=r(),Sn=i("span"),Sn.textContent=cs,Qa=r(),Ue=i("p"),Ue.textContent=ds,Ka=r(),He=i("p"),He.innerHTML=fs,Oa=r(),ze=i("p"),ze.innerHTML=us,ei=r(),je=i("p"),je.innerHTML=ms,ti=r(),J=i("h2"),D=i("a"),fa=i("span"),f(Pe.$$.fragment),Lr=r(),qn=i("span"),qn.textContent=gs,ni=r(),Le=i("p"),Le.innerHTML=vs,ai=r(),We=i("p"),We.innerHTML=ys,ii=r(),f(Ge.$$.fragment),li=r(),Ye=i("p"),Ye.textContent=ws,ri=r(),Ie=i("p"),Ie.innerHTML=bs,si=r(),Re=i("p"),Re.innerHTML=Ms,oi=r(),Ee=i("p"),Ee.innerHTML=_s,pi=r(),U=i("h2"),Q=i("a"),ua=i("span"),f(Ze.$$.fragment),Wr=r(),Vn=i("span"),Vn.textContent=Ts,hi=r(),Fe=i("p"),Fe.textContent=xs,ci=r(),Be=i("p"),Be.textContent=Cs,di=r(),Xe=i("p"),Xe.innerHTML=$s,fi=r(),Ne=i("p"),Ne.innerHTML=ks,ui=r(),f(Se.$$.fragment),mi=r(),qe=i("p"),qe.innerHTML=As,gi=r(),f(K.$$.fragment),vi=r(),H=i("h2"),O=i("a"),ma=i("span"),f(Ve.$$.fragment),Gr=r(),Dn=i("span"),Dn.textContent=Js,yi=r(),De=i("p"),De.innerHTML=Us,wi=r(),Qe=i("p"),Qe.innerHTML=Hs,bi=r(),z=i("h3"),ee=i("a"),ga=i("span"),f(Ke.$$.fragment),Yr=r(),Qn=i("span"),Qn.textContent=zs,Mi=r(),Oe=i("p"),Oe.textContent=js,_i=r(),et=i("p"),et.innerHTML=Ps,Ti=r(),f(tt.$$.fragment),xi=r(),nt=i("p"),nt.innerHTML=Ls,Ci=r(),j=i("h3"),te=i("a"),va=i("span"),f(at.$$.fragment),Ir=r(),Kn=i("span"),Kn.textContent=Ws,$i=r(),it=i("p"),it.innerHTML=Gs,ki=r(),lt=i("p"),lt.textContent=Ys,Ai=r(),f(rt.$$.fragment),Ji=r(),P=i("h3"),ne=i("a"),ya=i("span"),f(st.$$.fragment),Rr=r(),On=i("span"),On.textContent=Is,Ui=r(),ot=i("p"),ot.textContent=Rs,Hi=r(),f(pt.$$.fragment),zi=r(),ht=i("p"),ht.textContent=Es,ji=r(),ct=i("p"),ct.innerHTML=Zs,Pi=r(),dt=i("p"),dt.textContent=Fs,Li=r(),f(ft.$$.fragment),Wi=r(),f(ae.$$.fragment),Gi=r(),ut=i("p"),ut.innerHTML=Bs,Yi=r(),L=i("h2"),ie=i("a"),wa=i("span"),f(mt.$$.fragment),Er=r(),ea=i("span"),ea.textContent=Xs,Ii=r(),gt=i("p"),gt.innerHTML=Ns,Ri=r(),W=i("h2"),le=i("a"),ba=i("span"),f(vt.$$.fragment),Zr=r(),ta=i("span"),ta.textContent=Ss,Ei=r(),yt=i("p"),yt.innerHTML=qs,Zi=r(),wt=i("p"),wt.innerHTML=Vs,Fi=r(),bt=i("p"),bt.textContent=Ds,Bi=r(),Mt=i("ol"),Mt.innerHTML=Qs,Xi=r(),_t=i("p"),_t.textContent=Ks,Ni=r(),Tt=i("ul"),Tt.innerHTML=Os,Si=r(),G=i("h3"),re=i("a"),Ma=i("span"),f(xt.$$.fragment),Fr=r(),na=i("span"),na.textContent=eo,qi=r(),Ct=i("p"),Ct.textContent=to,Vi=r(),$t=i("p"),$t.innerHTML=no,Di=r(),f(kt.$$.fragment),Qi=r(),At=i("p"),At.textContent=ao,Ki=r(),Y=i("h3"),se=i("a"),_a=i("span"),f(Jt.$$.fragment),Br=r(),aa=i("span"),aa.textContent=io,Oi=r(),Ut=i("p"),Ut.textContent=lo,el=r(),Ht=i("p"),Ht.innerHTML=ro,tl=r(),f(zt.$$.fragment),nl=r(),jt=i("p"),jt.textContent=so,al=r(),Pt=i("p"),Pt.innerHTML=oo,il=r(),Lt=i("p"),Lt.textContent=po,ll=r(),Wt=i("ul"),Wt.innerHTML=ho,rl=r(),f(Gt.$$.fragment),sl=r(),Yt=i("p"),Yt.innerHTML=co,ol=r(),f(It.$$.fragment),pl=r(),Rt=i("p"),Rt.textContent=fo,hl=r(),I=i("h3"),oe=i("a"),Ta=i("span"),f(Et.$$.fragment),Xr=r(),ia=i("span"),ia.textContent=uo,cl=r(),Zt=i("p"),Zt.innerHTML=mo,dl=r(),R=i("h2"),pe=i("a"),xa=i("span"),f(Ft.$$.fragment),Nr=r(),la=i("span"),la.textContent=go,fl=r(),Bt=i("p"),Bt.textContent=vo,ul=r(),Xt=i("ul"),Xt.innerHTML=yo,ml=r(),Nt=i("p"),Nt.innerHTML=wo,gl=r(),E=i("h2"),he=i("a"),Ca=i("span"),f(St.$$.fragment),Sr=r(),ra=i("span"),ra.textContent=bo,vl=r(),qt=i("p"),qt.textContent=Mo,yl=r(),Vt=i("p"),Vt.innerHTML=_o,wl=r(),Dt=i("ul"),Dt.innerHTML=To,bl=r(),Z=i("h2"),ce=i("a"),$a=i("span"),f(Qt.$$.fragment),qr=r(),sa=i("span"),sa.textContent=xo,Ml=r(),Kt=i("p"),Kt.innerHTML=Co,_l=r(),Ot=i("p"),Ot.innerHTML=$o,Tl=r(),f(en.$$.fragment),xl=r(),tn=i("p"),tn.innerHTML=ko,Cl=r(),nn=i("p"),nn.innerHTML=Ao,$l=r(),an=i("p"),an.innerHTML=Jo,kl=r(),ln=i("p"),ln.innerHTML=Uo,Al=r(),rn=i("ul"),rn.innerHTML=Ho,Jl=r(),sn=i("p"),sn.innerHTML=zo,Ul=r(),on=i("ul"),on.innerHTML=jo,Hl=r(),pn=i("p"),pn.innerHTML=Po,zl=r(),hn=i("ul"),hn.innerHTML=Lo,jl=r(),cn=i("p"),cn.innerHTML=Wo,Pl=r(),F=i("h2"),de=i("a"),ka=i("span"),f(dn.$$.fragment),Vr=r(),oa=i("span"),oa.textContent=Go,Ll=r(),fn=i("p"),fn.innerHTML=Yo,Wl=r(),un=i("p"),un.innerHTML=Io,Gl=r(),f(mn.$$.fragment),Yl=r(),gn=i("p"),gn.textContent=Ro,Il=r(),f(vn.$$.fragment),Rl=r(),yn=i("p"),yn.innerHTML=Eo,El=r(),wn=i("p"),wn.innerHTML=Zo,Zl=r(),bn=i("p"),bn.innerHTML=Fo,Fl=r(),B=i("h2"),fe=i("a"),Aa=i("span"),f(Mn.$$.fragment),Dr=r(),pa=i("span"),pa.textContent=Bo,Bl=r(),_n=i("p"),_n.innerHTML=Xo,Xl=r(),Tn=i("p"),Tn.innerHTML=No,Nl=r(),xn=i("p"),xn.innerHTML=So,Sl=r(),Cn=i("p"),Cn.textContent=qo,ql=r(),X=i("h2"),ue=i("a"),Ja=i("span"),f($n.$$.fragment),Qr=r(),ha=i("span"),ha.textContent=Vo,Vl=r(),kn=i("p"),kn.textContent=Do,Dl=r(),An=i("p"),An.textContent=Qo,Ql=r(),Jn=i("p"),Jn.textContent=Ko,Kl=r(),Un=i("p"),Un.innerHTML=Oo,Ol=r(),Hn=i("p"),Hn.innerHTML=ep,er=r(),zn=i("p"),zn.textContent=tp,tr=r(),jn=i("p"),jn.textContent=np,nr=r(),Pn=i("p"),Pn.textContent=ap,ar=r(),Ln=i("p"),Ln.textContent=ip,ir=r(),Wn=i("ul"),Wn.innerHTML=lp,lr=r(),Gn=i("p"),Gn.innerHTML=rp,rr=r(),N=i("h2"),me=i("a"),Ua=i("span"),f(Yn.$$.fragment),Kr=r(),ca=i("span"),ca.textContent=sp,sr=r(),In=i("p"),In.innerHTML=op,or=r(),Rn=i("p"),Rn.innerHTML=pp,pr=r(),f(En.$$.fragment),hr=r(),Zn=i("p"),Zn.textContent=hp,cr=r(),f(ge.$$.fragment),dr=r(),Fn=i("p"),Fn.innerHTML=cp,fr=r(),Ha=i("p"),this.h()},l(e){const n=Op("svelte-1phssyn",document.head);d=l(n,"META",{name:!0,content:!0}),n.forEach(t),_=s(e),w=l(e,"P",{}),c(w).forEach(t),b=s(e),$=l(e,"H1",{class:!0});var Bn=c($);T=l(Bn,"A",{id:!0,class:!0,href:!0});var za=c(T);k=l(za,"SPAN",{});var ja=c(k);u(ve.$$.fragment,ja),ja.forEach(t),za.forEach(t),jr=s(Bn),Nn=l(Bn,"SPAN",{"data-svelte-h":!0}),o(Nn)!=="svelte-izxbuz"&&(Nn.textContent=Or),Bn.forEach(t),Ga=s(e),ye=l(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-tqdu0u"&&(ye.innerHTML=es),Ya=s(e),u(S.$$.fragment,e),Ia=s(e),we=l(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-4s75i8"&&(we.textContent=ts),Ra=s(e),be=l(e,"UL",{"data-svelte-h":!0}),o(be)!=="svelte-djgcn1"&&(be.innerHTML=ns),Ea=s(e),Me=l(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-uf18r4"&&(Me.textContent=as),Za=s(e),_e=l(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-b3xmwb"&&(_e.textContent=is),Fa=s(e),Te=l(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-1qbc4zp"&&(Te.textContent=ls),Ba=s(e),xe=l(e,"TABLE",{"data-svelte-h":!0}),o(xe)!=="svelte-15stut3"&&(xe.innerHTML=rs),Xa=s(e),u(q.$$.fragment,e),Na=s(e),Ce=l(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-1q6ffx2"&&(Ce.innerHTML=ss),Sa=s(e),$e=l(e,"P",{"data-svelte-h":!0}),o($e)!=="svelte-1thjxg4"&&($e.textContent=os),qa=s(e),ke=l(e,"UL",{"data-svelte-h":!0}),o(ke)!=="svelte-18kwup6"&&(ke.innerHTML=ps),Va=s(e),Ae=l(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-1uvbmrd"&&(Ae.innerHTML=hs),Da=s(e),A=l(e,"H2",{class:!0});var Xn=c(A);V=l(Xn,"A",{id:!0,class:!0,href:!0});var Pa=c(V);da=l(Pa,"SPAN",{});var dp=c(da);u(Je.$$.fragment,dp),dp.forEach(t),Pa.forEach(t),Pr=s(Xn),Sn=l(Xn,"SPAN",{"data-svelte-h":!0}),o(Sn)!=="svelte-124zq07"&&(Sn.textContent=cs),Xn.forEach(t),Qa=s(e),Ue=l(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-1f9wkzb"&&(Ue.textContent=ds),Ka=s(e),He=l(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-h1ek0g"&&(He.innerHTML=fs),Oa=s(e),ze=l(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-sfn5k1"&&(ze.innerHTML=us),ei=s(e),je=l(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-wvp8kx"&&(je.innerHTML=ms),ti=s(e),J=l(e,"H2",{class:!0});var mr=c(J);D=l(mr,"A",{id:!0,class:!0,href:!0});var fp=c(D);fa=l(fp,"SPAN",{});var up=c(fa);u(Pe.$$.fragment,up),up.forEach(t),fp.forEach(t),Lr=s(mr),qn=l(mr,"SPAN",{"data-svelte-h":!0}),o(qn)!=="svelte-1hbfta0"&&(qn.textContent=gs),mr.forEach(t),ni=s(e),Le=l(e,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-1l7rfkq"&&(Le.innerHTML=vs),ai=s(e),We=l(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-11b7h47"&&(We.innerHTML=ys),ii=s(e),u(Ge.$$.fragment,e),li=s(e),Ye=l(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-18ky75y"&&(Ye.textContent=ws),ri=s(e),Ie=l(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-khctnv"&&(Ie.innerHTML=bs),si=s(e),Re=l(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-1bitspm"&&(Re.innerHTML=Ms),oi=s(e),Ee=l(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-nbfonf"&&(Ee.innerHTML=_s),pi=s(e),U=l(e,"H2",{class:!0});var gr=c(U);Q=l(gr,"A",{id:!0,class:!0,href:!0});var mp=c(Q);ua=l(mp,"SPAN",{});var gp=c(ua);u(Ze.$$.fragment,gp),gp.forEach(t),mp.forEach(t),Wr=s(gr),Vn=l(gr,"SPAN",{"data-svelte-h":!0}),o(Vn)!=="svelte-1p42uqz"&&(Vn.textContent=Ts),gr.forEach(t),hi=s(e),Fe=l(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-n1qbw"&&(Fe.textContent=xs),ci=s(e),Be=l(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-1419dmv"&&(Be.textContent=Cs),di=s(e),Xe=l(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-nfo3gu"&&(Xe.innerHTML=$s),fi=s(e),Ne=l(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-17hn093"&&(Ne.innerHTML=ks),ui=s(e),u(Se.$$.fragment,e),mi=s(e),qe=l(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-1wwrmcl"&&(qe.innerHTML=As),gi=s(e),u(K.$$.fragment,e),vi=s(e),H=l(e,"H2",{class:!0});var vr=c(H);O=l(vr,"A",{id:!0,class:!0,href:!0});var vp=c(O);ma=l(vp,"SPAN",{});var yp=c(ma);u(Ve.$$.fragment,yp),yp.forEach(t),vp.forEach(t),Gr=s(vr),Dn=l(vr,"SPAN",{"data-svelte-h":!0}),o(Dn)!=="svelte-h7a0sg"&&(Dn.textContent=Js),vr.forEach(t),yi=s(e),De=l(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-7pqnv0"&&(De.innerHTML=Us),wi=s(e),Qe=l(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-1ttanpy"&&(Qe.innerHTML=Hs),bi=s(e),z=l(e,"H3",{class:!0});var yr=c(z);ee=l(yr,"A",{id:!0,class:!0,href:!0});var wp=c(ee);ga=l(wp,"SPAN",{});var bp=c(ga);u(Ke.$$.fragment,bp),bp.forEach(t),wp.forEach(t),Yr=s(yr),Qn=l(yr,"SPAN",{"data-svelte-h":!0}),o(Qn)!=="svelte-1pscsni"&&(Qn.textContent=zs),yr.forEach(t),Mi=s(e),Oe=l(e,"P",{"data-svelte-h":!0}),o(Oe)!=="svelte-h2t8go"&&(Oe.textContent=js),_i=s(e),et=l(e,"P",{"data-svelte-h":!0}),o(et)!=="svelte-wwg09w"&&(et.innerHTML=Ps),Ti=s(e),u(tt.$$.fragment,e),xi=s(e),nt=l(e,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-11fsu6r"&&(nt.innerHTML=Ls),Ci=s(e),j=l(e,"H3",{class:!0});var wr=c(j);te=l(wr,"A",{id:!0,class:!0,href:!0});var Mp=c(te);va=l(Mp,"SPAN",{});var _p=c(va);u(at.$$.fragment,_p),_p.forEach(t),Mp.forEach(t),Ir=s(wr),Kn=l(wr,"SPAN",{"data-svelte-h":!0}),o(Kn)!=="svelte-13por1k"&&(Kn.textContent=Ws),wr.forEach(t),$i=s(e),it=l(e,"P",{"data-svelte-h":!0}),o(it)!=="svelte-1p48z2n"&&(it.innerHTML=Gs),ki=s(e),lt=l(e,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-vq639r"&&(lt.textContent=Ys),Ai=s(e),u(rt.$$.fragment,e),Ji=s(e),P=l(e,"H3",{class:!0});var br=c(P);ne=l(br,"A",{id:!0,class:!0,href:!0});var Tp=c(ne);ya=l(Tp,"SPAN",{});var xp=c(ya);u(st.$$.fragment,xp),xp.forEach(t),Tp.forEach(t),Rr=s(br),On=l(br,"SPAN",{"data-svelte-h":!0}),o(On)!=="svelte-whoyjk"&&(On.textContent=Is),br.forEach(t),Ui=s(e),ot=l(e,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-7szee7"&&(ot.textContent=Rs),Hi=s(e),u(pt.$$.fragment,e),zi=s(e),ht=l(e,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-1kvnj8w"&&(ht.textContent=Es),ji=s(e),ct=l(e,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-alc3bu"&&(ct.innerHTML=Zs),Pi=s(e),dt=l(e,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-d0keh1"&&(dt.textContent=Fs),Li=s(e),u(ft.$$.fragment,e),Wi=s(e),u(ae.$$.fragment,e),Gi=s(e),ut=l(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-dzrbtx"&&(ut.innerHTML=Bs),Yi=s(e),L=l(e,"H2",{class:!0});var Mr=c(L);ie=l(Mr,"A",{id:!0,class:!0,href:!0});var Cp=c(ie);wa=l(Cp,"SPAN",{});var $p=c(wa);u(mt.$$.fragment,$p),$p.forEach(t),Cp.forEach(t),Er=s(Mr),ea=l(Mr,"SPAN",{"data-svelte-h":!0}),o(ea)!=="svelte-10q8yp"&&(ea.textContent=Xs),Mr.forEach(t),Ii=s(e),gt=l(e,"P",{"data-svelte-h":!0}),o(gt)!=="svelte-4gzx8m"&&(gt.innerHTML=Ns),Ri=s(e),W=l(e,"H2",{class:!0});var _r=c(W);le=l(_r,"A",{id:!0,class:!0,href:!0});var kp=c(le);ba=l(kp,"SPAN",{});var Ap=c(ba);u(vt.$$.fragment,Ap),Ap.forEach(t),kp.forEach(t),Zr=s(_r),ta=l(_r,"SPAN",{"data-svelte-h":!0}),o(ta)!=="svelte-166mczz"&&(ta.textContent=Ss),_r.forEach(t),Ei=s(e),yt=l(e,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-xkv29v"&&(yt.innerHTML=qs),Zi=s(e),wt=l(e,"P",{"data-svelte-h":!0}),o(wt)!=="svelte-cvzqz8"&&(wt.innerHTML=Vs),Fi=s(e),bt=l(e,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-1qfw41"&&(bt.textContent=Ds),Bi=s(e),Mt=l(e,"OL",{"data-svelte-h":!0}),o(Mt)!=="svelte-qu93m3"&&(Mt.innerHTML=Qs),Xi=s(e),_t=l(e,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-2mb823"&&(_t.textContent=Ks),Ni=s(e),Tt=l(e,"UL",{"data-svelte-h":!0}),o(Tt)!=="svelte-ajuctj"&&(Tt.innerHTML=Os),Si=s(e),G=l(e,"H3",{class:!0});var Tr=c(G);re=l(Tr,"A",{id:!0,class:!0,href:!0});var Jp=c(re);Ma=l(Jp,"SPAN",{});var Up=c(Ma);u(xt.$$.fragment,Up),Up.forEach(t),Jp.forEach(t),Fr=s(Tr),na=l(Tr,"SPAN",{"data-svelte-h":!0}),o(na)!=="svelte-cj5f8s"&&(na.textContent=eo),Tr.forEach(t),qi=s(e),Ct=l(e,"P",{"data-svelte-h":!0}),o(Ct)!=="svelte-19jpav8"&&(Ct.textContent=to),Vi=s(e),$t=l(e,"P",{"data-svelte-h":!0}),o($t)!=="svelte-izqwnz"&&($t.innerHTML=no),Di=s(e),u(kt.$$.fragment,e),Qi=s(e),At=l(e,"P",{"data-svelte-h":!0}),o(At)!=="svelte-1850zf2"&&(At.textContent=ao),Ki=s(e),Y=l(e,"H3",{class:!0});var xr=c(Y);se=l(xr,"A",{id:!0,class:!0,href:!0});var Hp=c(se);_a=l(Hp,"SPAN",{});var zp=c(_a);u(Jt.$$.fragment,zp),zp.forEach(t),Hp.forEach(t),Br=s(xr),aa=l(xr,"SPAN",{"data-svelte-h":!0}),o(aa)!=="svelte-6mb76"&&(aa.textContent=io),xr.forEach(t),Oi=s(e),Ut=l(e,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-1ld1y8t"&&(Ut.textContent=lo),el=s(e),Ht=l(e,"P",{"data-svelte-h":!0}),o(Ht)!=="svelte-ghnlmv"&&(Ht.innerHTML=ro),tl=s(e),u(zt.$$.fragment,e),nl=s(e),jt=l(e,"P",{"data-svelte-h":!0}),o(jt)!=="svelte-czmcu6"&&(jt.textContent=so),al=s(e),Pt=l(e,"P",{"data-svelte-h":!0}),o(Pt)!=="svelte-1av8920"&&(Pt.innerHTML=oo),il=s(e),Lt=l(e,"P",{"data-svelte-h":!0}),o(Lt)!=="svelte-19nyc4u"&&(Lt.textContent=po),ll=s(e),Wt=l(e,"UL",{"data-svelte-h":!0}),o(Wt)!=="svelte-8z8ok2"&&(Wt.innerHTML=ho),rl=s(e),u(Gt.$$.fragment,e),sl=s(e),Yt=l(e,"P",{"data-svelte-h":!0}),o(Yt)!=="svelte-n8bkwf"&&(Yt.innerHTML=co),ol=s(e),u(It.$$.fragment,e),pl=s(e),Rt=l(e,"P",{"data-svelte-h":!0}),o(Rt)!=="svelte-1egi1g7"&&(Rt.textContent=fo),hl=s(e),I=l(e,"H3",{class:!0});var Cr=c(I);oe=l(Cr,"A",{id:!0,class:!0,href:!0});var jp=c(oe);Ta=l(jp,"SPAN",{});var Pp=c(Ta);u(Et.$$.fragment,Pp),Pp.forEach(t),jp.forEach(t),Xr=s(Cr),ia=l(Cr,"SPAN",{"data-svelte-h":!0}),o(ia)!=="svelte-frs5m8"&&(ia.textContent=uo),Cr.forEach(t),cl=s(e),Zt=l(e,"P",{"data-svelte-h":!0}),o(Zt)!=="svelte-1cvgqaq"&&(Zt.innerHTML=mo),dl=s(e),R=l(e,"H2",{class:!0});var $r=c(R);pe=l($r,"A",{id:!0,class:!0,href:!0});var Lp=c(pe);xa=l(Lp,"SPAN",{});var Wp=c(xa);u(Ft.$$.fragment,Wp),Wp.forEach(t),Lp.forEach(t),Nr=s($r),la=l($r,"SPAN",{"data-svelte-h":!0}),o(la)!=="svelte-mumppk"&&(la.textContent=go),$r.forEach(t),fl=s(e),Bt=l(e,"P",{"data-svelte-h":!0}),o(Bt)!=="svelte-16tninz"&&(Bt.textContent=vo),ul=s(e),Xt=l(e,"UL",{"data-svelte-h":!0}),o(Xt)!=="svelte-1i85v8g"&&(Xt.innerHTML=yo),ml=s(e),Nt=l(e,"P",{"data-svelte-h":!0}),o(Nt)!=="svelte-1bn1lmd"&&(Nt.innerHTML=wo),gl=s(e),E=l(e,"H2",{class:!0});var kr=c(E);he=l(kr,"A",{id:!0,class:!0,href:!0});var Gp=c(he);Ca=l(Gp,"SPAN",{});var Yp=c(Ca);u(St.$$.fragment,Yp),Yp.forEach(t),Gp.forEach(t),Sr=s(kr),ra=l(kr,"SPAN",{"data-svelte-h":!0}),o(ra)!=="svelte-19d84u2"&&(ra.textContent=bo),kr.forEach(t),vl=s(e),qt=l(e,"P",{"data-svelte-h":!0}),o(qt)!=="svelte-1onp6io"&&(qt.textContent=Mo),yl=s(e),Vt=l(e,"P",{"data-svelte-h":!0}),o(Vt)!=="svelte-18hg7g"&&(Vt.innerHTML=_o),wl=s(e),Dt=l(e,"UL",{"data-svelte-h":!0}),o(Dt)!=="svelte-1sekruc"&&(Dt.innerHTML=To),bl=s(e),Z=l(e,"H2",{class:!0});var Ar=c(Z);ce=l(Ar,"A",{id:!0,class:!0,href:!0});var Ip=c(ce);$a=l(Ip,"SPAN",{});var Rp=c($a);u(Qt.$$.fragment,Rp),Rp.forEach(t),Ip.forEach(t),qr=s(Ar),sa=l(Ar,"SPAN",{"data-svelte-h":!0}),o(sa)!=="svelte-1mhqvvq"&&(sa.textContent=xo),Ar.forEach(t),Ml=s(e),Kt=l(e,"P",{"data-svelte-h":!0}),o(Kt)!=="svelte-5qw0v5"&&(Kt.innerHTML=Co),_l=s(e),Ot=l(e,"P",{"data-svelte-h":!0}),o(Ot)!=="svelte-173y9g"&&(Ot.innerHTML=$o),Tl=s(e),u(en.$$.fragment,e),xl=s(e),tn=l(e,"P",{"data-svelte-h":!0}),o(tn)!=="svelte-1y4s25e"&&(tn.innerHTML=ko),Cl=s(e),nn=l(e,"P",{"data-svelte-h":!0}),o(nn)!=="svelte-jluuok"&&(nn.innerHTML=Ao),$l=s(e),an=l(e,"P",{"data-svelte-h":!0}),o(an)!=="svelte-1buffru"&&(an.innerHTML=Jo),kl=s(e),ln=l(e,"P",{"data-svelte-h":!0}),o(ln)!=="svelte-v82kng"&&(ln.innerHTML=Uo),Al=s(e),rn=l(e,"UL",{"data-svelte-h":!0}),o(rn)!=="svelte-1dbgjs7"&&(rn.innerHTML=Ho),Jl=s(e),sn=l(e,"P",{"data-svelte-h":!0}),o(sn)!=="svelte-m2qf5f"&&(sn.innerHTML=zo),Ul=s(e),on=l(e,"UL",{"data-svelte-h":!0}),o(on)!=="svelte-x9b2wm"&&(on.innerHTML=jo),Hl=s(e),pn=l(e,"P",{"data-svelte-h":!0}),o(pn)!=="svelte-78l3h4"&&(pn.innerHTML=Po),zl=s(e),hn=l(e,"UL",{"data-svelte-h":!0}),o(hn)!=="svelte-1y0itbi"&&(hn.innerHTML=Lo),jl=s(e),cn=l(e,"P",{"data-svelte-h":!0}),o(cn)!=="svelte-1prqm7s"&&(cn.innerHTML=Wo),Pl=s(e),F=l(e,"H2",{class:!0});var Jr=c(F);de=l(Jr,"A",{id:!0,class:!0,href:!0});var Ep=c(de);ka=l(Ep,"SPAN",{});var Zp=c(ka);u(dn.$$.fragment,Zp),Zp.forEach(t),Ep.forEach(t),Vr=s(Jr),oa=l(Jr,"SPAN",{"data-svelte-h":!0}),o(oa)!=="svelte-97dpbf"&&(oa.textContent=Go),Jr.forEach(t),Ll=s(e),fn=l(e,"P",{"data-svelte-h":!0}),o(fn)!=="svelte-d91a9c"&&(fn.innerHTML=Yo),Wl=s(e),un=l(e,"P",{"data-svelte-h":!0}),o(un)!=="svelte-36acz5"&&(un.innerHTML=Io),Gl=s(e),u(mn.$$.fragment,e),Yl=s(e),gn=l(e,"P",{"data-svelte-h":!0}),o(gn)!=="svelte-eja69v"&&(gn.textContent=Ro),Il=s(e),u(vn.$$.fragment,e),Rl=s(e),yn=l(e,"P",{"data-svelte-h":!0}),o(yn)!=="svelte-1uxzlgd"&&(yn.innerHTML=Eo),El=s(e),wn=l(e,"P",{"data-svelte-h":!0}),o(wn)!=="svelte-i5733s"&&(wn.innerHTML=Zo),Zl=s(e),bn=l(e,"P",{"data-svelte-h":!0}),o(bn)!=="svelte-1caz98g"&&(bn.innerHTML=Fo),Fl=s(e),B=l(e,"H2",{class:!0});var Ur=c(B);fe=l(Ur,"A",{id:!0,class:!0,href:!0});var Fp=c(fe);Aa=l(Fp,"SPAN",{});var Bp=c(Aa);u(Mn.$$.fragment,Bp),Bp.forEach(t),Fp.forEach(t),Dr=s(Ur),pa=l(Ur,"SPAN",{"data-svelte-h":!0}),o(pa)!=="svelte-1noxph5"&&(pa.textContent=Bo),Ur.forEach(t),Bl=s(e),_n=l(e,"P",{"data-svelte-h":!0}),o(_n)!=="svelte-nmhpgl"&&(_n.innerHTML=Xo),Xl=s(e),Tn=l(e,"P",{"data-svelte-h":!0}),o(Tn)!=="svelte-kxuhyz"&&(Tn.innerHTML=No),Nl=s(e),xn=l(e,"P",{"data-svelte-h":!0}),o(xn)!=="svelte-qkuwkx"&&(xn.innerHTML=So),Sl=s(e),Cn=l(e,"P",{"data-svelte-h":!0}),o(Cn)!=="svelte-16g8p4x"&&(Cn.textContent=qo),ql=s(e),X=l(e,"H2",{class:!0});var Hr=c(X);ue=l(Hr,"A",{id:!0,class:!0,href:!0});var Xp=c(ue);Ja=l(Xp,"SPAN",{});var Np=c(Ja);u($n.$$.fragment,Np),Np.forEach(t),Xp.forEach(t),Qr=s(Hr),ha=l(Hr,"SPAN",{"data-svelte-h":!0}),o(ha)!=="svelte-ei820d"&&(ha.textContent=Vo),Hr.forEach(t),Vl=s(e),kn=l(e,"P",{"data-svelte-h":!0}),o(kn)!=="svelte-1aawf57"&&(kn.textContent=Do),Dl=s(e),An=l(e,"P",{"data-svelte-h":!0}),o(An)!=="svelte-ln9ugc"&&(An.textContent=Qo),Ql=s(e),Jn=l(e,"P",{"data-svelte-h":!0}),o(Jn)!=="svelte-1ett6yb"&&(Jn.textContent=Ko),Kl=s(e),Un=l(e,"P",{"data-svelte-h":!0}),o(Un)!=="svelte-tdgts9"&&(Un.innerHTML=Oo),Ol=s(e),Hn=l(e,"P",{"data-svelte-h":!0}),o(Hn)!=="svelte-z2dori"&&(Hn.innerHTML=ep),er=s(e),zn=l(e,"P",{"data-svelte-h":!0}),o(zn)!=="svelte-1gc8znk"&&(zn.textContent=tp),tr=s(e),jn=l(e,"P",{"data-svelte-h":!0}),o(jn)!=="svelte-13sa7m0"&&(jn.textContent=np),nr=s(e),Pn=l(e,"P",{"data-svelte-h":!0}),o(Pn)!=="svelte-dxh8d5"&&(Pn.textContent=ap),ar=s(e),Ln=l(e,"P",{"data-svelte-h":!0}),o(Ln)!=="svelte-1jfhyzg"&&(Ln.textContent=ip),ir=s(e),Wn=l(e,"UL",{"data-svelte-h":!0}),o(Wn)!=="svelte-1fjc55v"&&(Wn.innerHTML=lp),lr=s(e),Gn=l(e,"P",{"data-svelte-h":!0}),o(Gn)!=="svelte-o7v7js"&&(Gn.innerHTML=rp),rr=s(e),N=l(e,"H2",{class:!0});var zr=c(N);me=l(zr,"A",{id:!0,class:!0,href:!0});var Sp=c(me);Ua=l(Sp,"SPAN",{});var qp=c(Ua);u(Yn.$$.fragment,qp),qp.forEach(t),Sp.forEach(t),Kr=s(zr),ca=l(zr,"SPAN",{"data-svelte-h":!0}),o(ca)!=="svelte-14vlou"&&(ca.textContent=sp),zr.forEach(t),sr=s(e),In=l(e,"P",{"data-svelte-h":!0}),o(In)!=="svelte-10jsqxr"&&(In.innerHTML=op),or=s(e),Rn=l(e,"P",{"data-svelte-h":!0}),o(Rn)!=="svelte-mg6n76"&&(Rn.innerHTML=pp),pr=s(e),u(En.$$.fragment,e),hr=s(e),Zn=l(e,"P",{"data-svelte-h":!0}),o(Zn)!=="svelte-wfi44p"&&(Zn.textContent=hp),cr=s(e),u(ge.$$.fragment,e),dr=s(e),Fn=l(e,"P",{"data-svelte-h":!0}),o(Fn)!=="svelte-1r3sioy"&&(Fn.innerHTML=cp),fr=s(e),Ha=l(e,"P",{}),c(Ha).forEach(t),this.h()},h(){p(d,"name","hf:doc:metadata"),p(d,"content",JSON.stringify(rh)),p(T,"id","methods-and-tools-for-efficient-training-on-a-single-gpu"),p(T,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(T,"href","#methods-and-tools-for-efficient-training-on-a-single-gpu"),p($,"class","relative group"),p(V,"id","batch-size-choice"),p(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(V,"href","#batch-size-choice"),p(A,"class","relative group"),p(D,"id","gradient-accumulation"),p(D,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(D,"href","#gradient-accumulation"),p(J,"class","relative group"),p(Q,"id","gradient-checkpointing"),p(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Q,"href","#gradient-checkpointing"),p(U,"class","relative group"),p(O,"id","mixed-precision-training"),p(O,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(O,"href","#mixed-precision-training"),p(H,"class","relative group"),p(ee,"id","fp16"),p(ee,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ee,"href","#fp16"),p(z,"class","relative group"),p(te,"id","bf16"),p(te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(te,"href","#bf16"),p(j,"class","relative group"),p(ne,"id","tf32"),p(ne,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ne,"href","#tf32"),p(P,"class","relative group"),p(ie,"id","flash-attention-2"),p(ie,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ie,"href","#flash-attention-2"),p(L,"class","relative group"),p(le,"id","optimizer-choice"),p(le,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(le,"href","#optimizer-choice"),p(W,"class","relative group"),p(re,"id","adafactor"),p(re,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(re,"href","#adafactor"),p(G,"class","relative group"),p(se,"id","8bit-adam"),p(se,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(se,"href","#8bit-adam"),p(Y,"class","relative group"),p(oe,"id","multitensor"),p(oe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(oe,"href","#multitensor"),p(I,"class","relative group"),p(pe,"id","data-preloading"),p(pe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(pe,"href","#data-preloading"),p(R,"class","relative group"),p(he,"id","deepspeed-zero"),p(he,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(he,"href","#deepspeed-zero"),p(E,"class","relative group"),p(ce,"id","using-torchcompile"),p(ce,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ce,"href","#using-torchcompile"),p(Z,"class","relative group"),p(de,"id","using-accelerate"),p(de,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(de,"href","#using-accelerate"),p(F,"class","relative group"),p(fe,"id","efficient-software-prebuilds"),p(fe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(fe,"href","#efficient-software-prebuilds"),p(B,"class","relative group"),p(ue,"id","mixture-of-experts"),p(ue,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ue,"href","#mixture-of-experts"),p(X,"class","relative group"),p(me,"id","using-pytorch-native-attention-and-flash-attention"),p(me,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(me,"href","#using-pytorch-native-attention-and-flash-attention"),p(N,"class","relative group")},m(e,n){h(document.head,d),a(e,_,n),a(e,w,n),a(e,b,n),a(e,$,n),h($,T),h(T,k),m(ve,k,null),h($,jr),h($,Nn),a(e,Ga,n),a(e,ye,n),a(e,Ya,n),m(S,e,n),a(e,Ia,n),a(e,we,n),a(e,Ra,n),a(e,be,n),a(e,Ea,n),a(e,Me,n),a(e,Za,n),a(e,_e,n),a(e,Fa,n),a(e,Te,n),a(e,Ba,n),a(e,xe,n),a(e,Xa,n),m(q,e,n),a(e,Na,n),a(e,Ce,n),a(e,Sa,n),a(e,$e,n),a(e,qa,n),a(e,ke,n),a(e,Va,n),a(e,Ae,n),a(e,Da,n),a(e,A,n),h(A,V),h(V,da),m(Je,da,null),h(A,Pr),h(A,Sn),a(e,Qa,n),a(e,Ue,n),a(e,Ka,n),a(e,He,n),a(e,Oa,n),a(e,ze,n),a(e,ei,n),a(e,je,n),a(e,ti,n),a(e,J,n),h(J,D),h(D,fa),m(Pe,fa,null),h(J,Lr),h(J,qn),a(e,ni,n),a(e,Le,n),a(e,ai,n),a(e,We,n),a(e,ii,n),m(Ge,e,n),a(e,li,n),a(e,Ye,n),a(e,ri,n),a(e,Ie,n),a(e,si,n),a(e,Re,n),a(e,oi,n),a(e,Ee,n),a(e,pi,n),a(e,U,n),h(U,Q),h(Q,ua),m(Ze,ua,null),h(U,Wr),h(U,Vn),a(e,hi,n),a(e,Fe,n),a(e,ci,n),a(e,Be,n),a(e,di,n),a(e,Xe,n),a(e,fi,n),a(e,Ne,n),a(e,ui,n),m(Se,e,n),a(e,mi,n),a(e,qe,n),a(e,gi,n),m(K,e,n),a(e,vi,n),a(e,H,n),h(H,O),h(O,ma),m(Ve,ma,null),h(H,Gr),h(H,Dn),a(e,yi,n),a(e,De,n),a(e,wi,n),a(e,Qe,n),a(e,bi,n),a(e,z,n),h(z,ee),h(ee,ga),m(Ke,ga,null),h(z,Yr),h(z,Qn),a(e,Mi,n),a(e,Oe,n),a(e,_i,n),a(e,et,n),a(e,Ti,n),m(tt,e,n),a(e,xi,n),a(e,nt,n),a(e,Ci,n),a(e,j,n),h(j,te),h(te,va),m(at,va,null),h(j,Ir),h(j,Kn),a(e,$i,n),a(e,it,n),a(e,ki,n),a(e,lt,n),a(e,Ai,n),m(rt,e,n),a(e,Ji,n),a(e,P,n),h(P,ne),h(ne,ya),m(st,ya,null),h(P,Rr),h(P,On),a(e,Ui,n),a(e,ot,n),a(e,Hi,n),m(pt,e,n),a(e,zi,n),a(e,ht,n),a(e,ji,n),a(e,ct,n),a(e,Pi,n),a(e,dt,n),a(e,Li,n),m(ft,e,n),a(e,Wi,n),m(ae,e,n),a(e,Gi,n),a(e,ut,n),a(e,Yi,n),a(e,L,n),h(L,ie),h(ie,wa),m(mt,wa,null),h(L,Er),h(L,ea),a(e,Ii,n),a(e,gt,n),a(e,Ri,n),a(e,W,n),h(W,le),h(le,ba),m(vt,ba,null),h(W,Zr),h(W,ta),a(e,Ei,n),a(e,yt,n),a(e,Zi,n),a(e,wt,n),a(e,Fi,n),a(e,bt,n),a(e,Bi,n),a(e,Mt,n),a(e,Xi,n),a(e,_t,n),a(e,Ni,n),a(e,Tt,n),a(e,Si,n),a(e,G,n),h(G,re),h(re,Ma),m(xt,Ma,null),h(G,Fr),h(G,na),a(e,qi,n),a(e,Ct,n),a(e,Vi,n),a(e,$t,n),a(e,Di,n),m(kt,e,n),a(e,Qi,n),a(e,At,n),a(e,Ki,n),a(e,Y,n),h(Y,se),h(se,_a),m(Jt,_a,null),h(Y,Br),h(Y,aa),a(e,Oi,n),a(e,Ut,n),a(e,el,n),a(e,Ht,n),a(e,tl,n),m(zt,e,n),a(e,nl,n),a(e,jt,n),a(e,al,n),a(e,Pt,n),a(e,il,n),a(e,Lt,n),a(e,ll,n),a(e,Wt,n),a(e,rl,n),m(Gt,e,n),a(e,sl,n),a(e,Yt,n),a(e,ol,n),m(It,e,n),a(e,pl,n),a(e,Rt,n),a(e,hl,n),a(e,I,n),h(I,oe),h(oe,Ta),m(Et,Ta,null),h(I,Xr),h(I,ia),a(e,cl,n),a(e,Zt,n),a(e,dl,n),a(e,R,n),h(R,pe),h(pe,xa),m(Ft,xa,null),h(R,Nr),h(R,la),a(e,fl,n),a(e,Bt,n),a(e,ul,n),a(e,Xt,n),a(e,ml,n),a(e,Nt,n),a(e,gl,n),a(e,E,n),h(E,he),h(he,Ca),m(St,Ca,null),h(E,Sr),h(E,ra),a(e,vl,n),a(e,qt,n),a(e,yl,n),a(e,Vt,n),a(e,wl,n),a(e,Dt,n),a(e,bl,n),a(e,Z,n),h(Z,ce),h(ce,$a),m(Qt,$a,null),h(Z,qr),h(Z,sa),a(e,Ml,n),a(e,Kt,n),a(e,_l,n),a(e,Ot,n),a(e,Tl,n),m(en,e,n),a(e,xl,n),a(e,tn,n),a(e,Cl,n),a(e,nn,n),a(e,$l,n),a(e,an,n),a(e,kl,n),a(e,ln,n),a(e,Al,n),a(e,rn,n),a(e,Jl,n),a(e,sn,n),a(e,Ul,n),a(e,on,n),a(e,Hl,n),a(e,pn,n),a(e,zl,n),a(e,hn,n),a(e,jl,n),a(e,cn,n),a(e,Pl,n),a(e,F,n),h(F,de),h(de,ka),m(dn,ka,null),h(F,Vr),h(F,oa),a(e,Ll,n),a(e,fn,n),a(e,Wl,n),a(e,un,n),a(e,Gl,n),m(mn,e,n),a(e,Yl,n),a(e,gn,n),a(e,Il,n),m(vn,e,n),a(e,Rl,n),a(e,yn,n),a(e,El,n),a(e,wn,n),a(e,Zl,n),a(e,bn,n),a(e,Fl,n),a(e,B,n),h(B,fe),h(fe,Aa),m(Mn,Aa,null),h(B,Dr),h(B,pa),a(e,Bl,n),a(e,_n,n),a(e,Xl,n),a(e,Tn,n),a(e,Nl,n),a(e,xn,n),a(e,Sl,n),a(e,Cn,n),a(e,ql,n),a(e,X,n),h(X,ue),h(ue,Ja),m($n,Ja,null),h(X,Qr),h(X,ha),a(e,Vl,n),a(e,kn,n),a(e,Dl,n),a(e,An,n),a(e,Ql,n),a(e,Jn,n),a(e,Kl,n),a(e,Un,n),a(e,Ol,n),a(e,Hn,n),a(e,er,n),a(e,zn,n),a(e,tr,n),a(e,jn,n),a(e,nr,n),a(e,Pn,n),a(e,ar,n),a(e,Ln,n),a(e,ir,n),a(e,Wn,n),a(e,lr,n),a(e,Gn,n),a(e,rr,n),a(e,N,n),h(N,me),h(me,Ua),m(Yn,Ua,null),h(N,Kr),h(N,ca),a(e,sr,n),a(e,In,n),a(e,or,n),a(e,Rn,n),a(e,pr,n),m(En,e,n),a(e,hr,n),a(e,Zn,n),a(e,cr,n),m(ge,e,n),a(e,dr,n),a(e,Fn,n),a(e,fr,n),a(e,Ha,n),ur=!0},p(e,[n]){const Bn={};n&2&&(Bn.$$scope={dirty:n,ctx:e}),S.$set(Bn);const za={};n&2&&(za.$$scope={dirty:n,ctx:e}),q.$set(za);const ja={};n&2&&(ja.$$scope={dirty:n,ctx:e}),K.$set(ja);const Xn={};n&2&&(Xn.$$scope={dirty:n,ctx:e}),ae.$set(Xn);const Pa={};n&2&&(Pa.$$scope={dirty:n,ctx:e}),ge.$set(Pa)},i(e){ur||(g(ve.$$.fragment,e),g(S.$$.fragment,e),g(q.$$.fragment,e),g(Je.$$.fragment,e),g(Pe.$$.fragment,e),g(Ge.$$.fragment,e),g(Ze.$$.fragment,e),g(Se.$$.fragment,e),g(K.$$.fragment,e),g(Ve.$$.fragment,e),g(Ke.$$.fragment,e),g(tt.$$.fragment,e),g(at.$$.fragment,e),g(rt.$$.fragment,e),g(st.$$.fragment,e),g(pt.$$.fragment,e),g(ft.$$.fragment,e),g(ae.$$.fragment,e),g(mt.$$.fragment,e),g(vt.$$.fragment,e),g(xt.$$.fragment,e),g(kt.$$.fragment,e),g(Jt.$$.fragment,e),g(zt.$$.fragment,e),g(Gt.$$.fragment,e),g(It.$$.fragment,e),g(Et.$$.fragment,e),g(Ft.$$.fragment,e),g(St.$$.fragment,e),g(Qt.$$.fragment,e),g(en.$$.fragment,e),g(dn.$$.fragment,e),g(mn.$$.fragment,e),g(vn.$$.fragment,e),g(Mn.$$.fragment,e),g($n.$$.fragment,e),g(Yn.$$.fragment,e),g(En.$$.fragment,e),g(ge.$$.fragment,e),ur=!0)},o(e){v(ve.$$.fragment,e),v(S.$$.fragment,e),v(q.$$.fragment,e),v(Je.$$.fragment,e),v(Pe.$$.fragment,e),v(Ge.$$.fragment,e),v(Ze.$$.fragment,e),v(Se.$$.fragment,e),v(K.$$.fragment,e),v(Ve.$$.fragment,e),v(Ke.$$.fragment,e),v(tt.$$.fragment,e),v(at.$$.fragment,e),v(rt.$$.fragment,e),v(st.$$.fragment,e),v(pt.$$.fragment,e),v(ft.$$.fragment,e),v(ae.$$.fragment,e),v(mt.$$.fragment,e),v(vt.$$.fragment,e),v(xt.$$.fragment,e),v(kt.$$.fragment,e),v(Jt.$$.fragment,e),v(zt.$$.fragment,e),v(Gt.$$.fragment,e),v(It.$$.fragment,e),v(Et.$$.fragment,e),v(Ft.$$.fragment,e),v(St.$$.fragment,e),v(Qt.$$.fragment,e),v(en.$$.fragment,e),v(dn.$$.fragment,e),v(mn.$$.fragment,e),v(vn.$$.fragment,e),v(Mn.$$.fragment,e),v($n.$$.fragment,e),v(Yn.$$.fragment,e),v(En.$$.fragment,e),v(ge.$$.fragment,e),ur=!1},d(e){e&&(t(_),t(w),t(b),t($),t(Ga),t(ye),t(Ya),t(Ia),t(we),t(Ra),t(be),t(Ea),t(Me),t(Za),t(_e),t(Fa),t(Te),t(Ba),t(xe),t(Xa),t(Na),t(Ce),t(Sa),t($e),t(qa),t(ke),t(Va),t(Ae),t(Da),t(A),t(Qa),t(Ue),t(Ka),t(He),t(Oa),t(ze),t(ei),t(je),t(ti),t(J),t(ni),t(Le),t(ai),t(We),t(ii),t(li),t(Ye),t(ri),t(Ie),t(si),t(Re),t(oi),t(Ee),t(pi),t(U),t(hi),t(Fe),t(ci),t(Be),t(di),t(Xe),t(fi),t(Ne),t(ui),t(mi),t(qe),t(gi),t(vi),t(H),t(yi),t(De),t(wi),t(Qe),t(bi),t(z),t(Mi),t(Oe),t(_i),t(et),t(Ti),t(xi),t(nt),t(Ci),t(j),t($i),t(it),t(ki),t(lt),t(Ai),t(Ji),t(P),t(Ui),t(ot),t(Hi),t(zi),t(ht),t(ji),t(ct),t(Pi),t(dt),t(Li),t(Wi),t(Gi),t(ut),t(Yi),t(L),t(Ii),t(gt),t(Ri),t(W),t(Ei),t(yt),t(Zi),t(wt),t(Fi),t(bt),t(Bi),t(Mt),t(Xi),t(_t),t(Ni),t(Tt),t(Si),t(G),t(qi),t(Ct),t(Vi),t($t),t(Di),t(Qi),t(At),t(Ki),t(Y),t(Oi),t(Ut),t(el),t(Ht),t(tl),t(nl),t(jt),t(al),t(Pt),t(il),t(Lt),t(ll),t(Wt),t(rl),t(sl),t(Yt),t(ol),t(pl),t(Rt),t(hl),t(I),t(cl),t(Zt),t(dl),t(R),t(fl),t(Bt),t(ul),t(Xt),t(ml),t(Nt),t(gl),t(E),t(vl),t(qt),t(yl),t(Vt),t(wl),t(Dt),t(bl),t(Z),t(Ml),t(Kt),t(_l),t(Ot),t(Tl),t(xl),t(tn),t(Cl),t(nn),t($l),t(an),t(kl),t(ln),t(Al),t(rn),t(Jl),t(sn),t(Ul),t(on),t(Hl),t(pn),t(zl),t(hn),t(jl),t(cn),t(Pl),t(F),t(Ll),t(fn),t(Wl),t(un),t(Gl),t(Yl),t(gn),t(Il),t(Rl),t(yn),t(El),t(wn),t(Zl),t(bn),t(Fl),t(B),t(Bl),t(_n),t(Xl),t(Tn),t(Nl),t(xn),t(Sl),t(Cn),t(ql),t(X),t(Vl),t(kn),t(Dl),t(An),t(Ql),t(Jn),t(Kl),t(Un),t(Ol),t(Hn),t(er),t(zn),t(tr),t(jn),t(nr),t(Pn),t(ar),t(Ln),t(ir),t(Wn),t(lr),t(Gn),t(rr),t(N),t(sr),t(In),t(or),t(Rn),t(pr),t(hr),t(Zn),t(cr),t(dr),t(Fn),t(fr),t(Ha)),t(d),y(ve),y(S,e),y(q,e),y(Je),y(Pe),y(Ge,e),y(Ze),y(Se,e),y(K,e),y(Ve),y(Ke),y(tt,e),y(at),y(rt,e),y(st),y(pt,e),y(ft,e),y(ae,e),y(mt),y(vt),y(xt),y(kt,e),y(Jt),y(zt,e),y(Gt,e),y(It,e),y(Et),y(Ft),y(St),y(Qt),y(en,e),y(dn),y(mn,e),y(vn,e),y(Mn),y($n),y(Yn),y(En,e),y(ge,e)}}}const rh={local:"methods-and-tools-for-efficient-training-on-a-single-gpu",sections:[{local:"batch-size-choice",title:"Batch size choice"},{local:"gradient-accumulation",title:"Gradient Accumulation"},{local:"gradient-checkpointing",title:"Gradient Checkpointing"},{local:"mixed-precision-training",sections:[{local:"fp16",title:"fp16"},{local:"bf16",title:"BF16"},{local:"tf32",title:"TF32"}],title:"Mixed precision training"},{local:"flash-attention-2",title:"Flash Attention 2"},{local:"optimizer-choice",sections:[{local:"adafactor",title:"Adafactor"},{local:"8bit-adam",title:"8-bit Adam"},{local:"multitensor",title:"multi_tensor"}],title:"Optimizer choice"},{local:"data-preloading",title:"Data preloading"},{local:"deepspeed-zero",title:"DeepSpeed ZeRO"},{local:"using-torchcompile",title:"Using torch.compile"},{local:"using-accelerate",title:"Using 🤗 Accelerate"},{local:"efficient-software-prebuilds",title:"Efficient Software Prebuilds"},{local:"mixture-of-experts",title:"Mixture of Experts"},{local:"using-pytorch-native-attention-and-flash-attention",title:"Using PyTorch native attention and Flash Attention"}],title:"Methods and tools for efficient training on a single GPU"};function sh(C){return Dp(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fh extends Qp{constructor(d){super(),Kp(this,d,sh,lh,Vp,{})}}export{fh as component};
